import{s as Eo,f as Yo,o as Qo,n as Ne}from"../chunks/scheduler.25b97de1.js";import{S as Oo,i as Ao,g as m,s as a,r as h,A as Do,h as d,f as o,c as n,j as $,u as g,x as M,k as v,y as i,a as l,v as f,d as u,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as qo}from"../chunks/Tip.baa67368.js";import{D as I}from"../chunks/Docstring.ffac8efa.js";import{C as nt}from"../chunks/CodeBlock.e6cd0d95.js";import{E as at}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as P,E as Ko}from"../chunks/EditOnGithub.91d95064.js";function es(j){let r,y="Examples:",p,c,k;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2syRm9ybWVyQ29uZmlnJTJDJTIwTWFzazJGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXNrMkZvcm1lciUyMGZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrMkZvcm1lckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mask2FormerConfig, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mask2Former facebook/mask2former-swin-small-coco-instance configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mask2FormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/mask2former-swin-small-coco-instance style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=m("p"),r.textContent=y,p=a(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-kvfsh7"&&(r.textContent=y),p=n(t),g(c.$$.fragment,t)},m(t,w){l(t,r,w),l(t,p,w),f(c,t,w),k=!0},p:Ne,i(t){k||(u(c.$$.fragment,t),k=!0)},o(t){_(c.$$.fragment,t),k=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ts(j){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=m("p"),r.innerHTML=y},l(p){r=d(p,"P",{"data-svelte-h":!0}),M(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(p,c){l(p,r,c)},p:Ne,d(p){p&&o(r)}}}function os(j){let r,y="Examples:",p,c,k;return c=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBNYXNrMkZvcm1lck1vZGVsJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBpbWFnZSUyMHByZXByb2Nlc3NvciUyMGFuZCUyME1hc2syRm9ybWVyTW9kZWwlMjB0cmFpbmVkJTIwb24lMjBDT0NPJTIwaW5zdGFuY2UlMjBzZWdtZW50YXRpb24lMjBkYXRhc2V0JTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMG1vZGVsJTIwb3V0cHV0cyUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQXByaW50KG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image preprocessor and Mask2FormerModel trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model outputs last hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.transformer_decoder_last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=y,p=a(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-kvfsh7"&&(r.textContent=y),p=n(t),g(c.$$.fragment,t)},m(t,w){l(t,r,w),l(t,p,w),f(c,t,w),k=!0},p:Ne,i(t){k||(u(c.$$.fragment,t),k=!0)},o(t){_(c.$$.fragment,t),k=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ss(j){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=m("p"),r.innerHTML=y},l(p){r=d(p,"P",{"data-svelte-h":!0}),M(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(p,c){l(p,r,c)},p:Ne,d(p){p&&o(r)}}}function as(j){let r,y="Instance segmentation example:",p,c,k;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMENPQ08lMjBpbnN0YW5jZSUyMHNlZ21lbnRhdGlvbiUyMGRhdGFzZXQlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMGluc3RhbmNlJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9pbnN0YW5jZV9tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEJTBBKSU1QjAlNUQlMEFwcmludChwcmVkX2luc3RhbmNlX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get instance segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_instance_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_instance_map.shape)
torch.Size([<span class="hljs-number">480</span>, <span class="hljs-number">640</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=y,p=a(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-1xhxiwz"&&(r.textContent=y),p=n(t),g(c.$$.fragment,t)},m(t,w){l(t,r,w),l(t,p,w),f(c,t,w),k=!0},p:Ne,i(t){k||(u(c.$$.fragment,t),k=!0)},o(t){_(c.$$.fragment,t),k=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ns(j){let r,y="Semantic segmentation example:",p,c,k;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMEFERTIwayUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwZGF0YXNldCUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLXNtYWxsLWFkZS1zZW1hbnRpYyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtYWRlLXNlbWFudGljJTIyKSUwQSUwQXVybCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfYWRlMjBrJTJGcmVzb2x2ZSUyRm1haW4lMkZBREVfdmFsXzAwMDAwMDAxLmpwZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9zZW1hbnRpY19tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEJTBBKSU1QjAlNUQlMEFwcmludChwcmVkX3NlbWFudGljX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on ADE20k semantic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get semantic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_semantic_map.shape)
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">683</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=y,p=a(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-ec2k7m"&&(r.textContent=y),p=n(t),g(c.$$.fragment,t)},m(t,w){l(t,r,w),l(t,p,w),f(c,t,w),k=!0},p:Ne,i(t){k||(u(c.$$.fragment,t),k=!0)},o(t){_(c.$$.fragment,t),k=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function rs(j){let r,y="Panoptic segmentation example:",p,c,k;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMENpdHlTY2FwZXMlMjBwYW5vcHRpYyUyMHNlZ21lbnRhdGlvbiUyMGRhdGFzZXQlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jaXR5c2NhcGVzLXBhbm9wdGljJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jaXR5c2NhcGVzLXBhbm9wdGljJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLW1lZGlhLmh1Z2dpbmdmYWNlLmNvJTJGSW5mZXJlbmNlLUFQSSUyRlNhbXBsZS1yZXN1bHRzLW9uLXRoZS1DaXR5c2NhcGVzLWRhdGFzZXQtVGhlLWFib3ZlLWltYWdlcy1zaG93LWhvdy1vdXItbWV0aG9kLWNhbi1oYW5kbGUucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyME1vZGVsJTIwcHJlZGljdHMlMjBjbGFzc19xdWVyaWVzX2xvZ2l0cyUyMG9mJTIwc2hhcGUlMjAlNjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9xdWVyaWVzKSU2MCUwQSUyMyUyMGFuZCUyMG1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklNjAlMEFjbGFzc19xdWVyaWVzX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMuY2xhc3NfcXVlcmllc19sb2dpdHMlMEFtYXNrc19xdWVyaWVzX2xvZ2l0cyUyMCUzRCUyMG91dHB1dHMubWFza3NfcXVlcmllc19sb2dpdHMlMEElMEElMjMlMjBQZXJmb3JtJTIwcG9zdC1wcm9jZXNzaW5nJTIwdG8lMjBnZXQlMjBwYW5vcHRpYyUyMHNlZ21lbnRhdGlvbiUyMG1hcCUwQXByZWRfcGFub3B0aWNfbWFwJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19wYW5vcHRpY19zZWdtZW50YXRpb24oJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCUwQSklNUIwJTVEJTVCJTIyc2VnbWVudGF0aW9uJTIyJTVEJTBBcHJpbnQocHJlZF9wYW5vcHRpY19tYXAuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on CityScapes panoptic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://cdn-media.huggingface.co/Inference-API/Sample-results-on-the-Cityscapes-dataset-The-above-images-show-how-our-method-can-handle.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get panoptic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_panoptic_map = image_processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_panoptic_map.shape)
torch.Size([<span class="hljs-number">338</span>, <span class="hljs-number">676</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=y,p=a(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-1hqqxa2"&&(r.textContent=y),p=n(t),g(c.$$.fragment,t)},m(t,w){l(t,r,w),l(t,p,w),f(c,t,w),k=!0},p:Ne,i(t){k||(u(c.$$.fragment,t),k=!0)},o(t){_(c.$$.fragment,t),k=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function is(j){let r,y,p,c,k,t,w,rt,oe,uo='The Mask2Former model was proposed in <a href="https://arxiv.org/abs/2112.01527" rel="nofollow">Masked-attention Mask Transformer for Universal Image Segmentation</a> by Bowen Cheng, Ishan Misra, Alexander G. Schwing, Alexander Kirillov, Rohit Girdhar. Mask2Former is a unified framework for panoptic, instance and semantic segmentation and features significant performance and efficiency improvements over <a href="maskformer">MaskFormer</a>.',it,se,_o="The abstract from the paper is the following:",lt,ae,bo=`<em>Image segmentation groups pixels with different semantics, e.g., category or instance membership. Each choice
of semantics defines a task. While only the semantics of each task differ, current research focuses on designing specialized architectures for each task. We present Masked-attention Mask Transformer (Mask2Former), a new architecture capable of addressing any image segmentation task (panoptic, instance or semantic). Its key components include masked attention, which extracts localized features by constraining cross-attention within predicted mask regions. In addition to reducing the research effort by at least three times, it outperforms the best specialized architectures by a significant margin on four popular datasets. Most notably, Mask2Former sets a new state-of-the-art for panoptic segmentation (57.8 PQ on COCO), instance segmentation (50.1 AP on COCO) and semantic segmentation (57.7 mIoU on ADE20K).</em>`,mt,L,Mo,dt,ne,ko='Mask2Former architecture. Taken from the <a href="https://arxiv.org/abs/2112.01527">original paper.</a>',ct,re,wo='This model was contributed by <a href="https://huggingface.co/shivi" rel="nofollow">Shivalika Singh</a> and <a href="https://huggingface.co/adirik" rel="nofollow">Alara Dirik</a>. The original code can be found <a href="https://github.com/facebookresearch/Mask2Former" rel="nofollow">here</a>.',pt,ie,ht,le,yo='<li>Mask2Former uses the same preprocessing and postprocessing steps as <a href="maskformer">MaskFormer</a>. Use <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> or <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>',gt,me,ft,de,Fo="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Mask2Former.",ut,ce,vo='<li>Demo notebooks regarding inference + fine-tuning Mask2Former on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Mask2Former" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <code>Mask2Former</code> with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/instance-segmentation" rel="nofollow">here</a>.</li>',_t,pe,To=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,bt,he,Mt,x,ge,Nt,Ze,xo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. It is used to instantiate a
Mask2Former model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Mask2Former
<a href="https://huggingface.co/facebook/mask2former-swin-small-coco-instance" rel="nofollow">facebook/mask2former-swin-small-coco-instance</a>
architecture.`,Zt,Xe,jo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xt,Ve,Uo='Currently, Mask2Former only supports the <a href="swin">Swin Transformer</a> as backbone.',Vt,H,Bt,q,fe,St,Be,$o='Instantiate a <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (or a derived class) from a pre-trained backbone model configuration.',kt,ue,wt,B,_e,Gt,Se,Jo='Class for outputs of <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. This class returns all the needed hidden states to compute the logits.',yt,C,be,Rt,Ge,zo="Class for outputs of <code>Mask2FormerForUniversalSegmentationOutput</code>.",Pt,Re,Io=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to compute final segmentation maps. Please, see
[\`~Mask2FormerImageProcessor] for details regarding usage.`,Ft,Me,vt,N,ke,Lt,Pe,Wo=`The bare Mask2Former Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ht,W,we,qt,Le,Co='The <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> forward method, overrides the <code>__call__</code> special method.',Et,E,Yt,Y,Tt,ye,xt,Z,Fe,Qt,He,No=`The Mask2Former Model with heads on top for instance/semantic/panoptic segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ot,T,ve,At,qe,Zo='The <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Dt,Q,Kt,Ee,Xo="Examples:",eo,O,to,A,oo,D,jt,Te,Ut,F,xe,so,Ye,Vo=`Constructs a Mask2Former image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,ao,Qe,Bo=`This image processor inherits from <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,no,Oe,je,ro,V,Ue,io,Ae,So="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",lo,De,Go=`Mask2Former addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,mo,K,$e,co,Ke,Ro=`Converts the output of <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,po,ee,Je,ho,et,Po=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into instance segmentation predictions.
Only supports PyTorch.`,go,te,ze,fo,tt,Lo=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,$t,Ie,Jt,st,zt;return k=new P({props:{title:"Mask2Former",local:"mask2former",headingTag:"h1"}}),w=new P({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new P({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new P({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new P({props:{title:"Mask2FormerConfig",local:"transformers.Mask2FormerConfig",headingTag:"h2"}}),ge=new I({props:{name:"class transformers.Mask2FormerConfig",anchor:"transformers.Mask2FormerConfig",parameters:[{name:"backbone_config",val:": Optional = None"},{name:"feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"activation_function",val:": str = 'relu'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.0"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_projection",val:": bool = False"},{name:"common_stride",val:": int = 4"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 100"},{name:"no_object_weight",val:": float = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"feature_strides",val:": List = [4, 8, 16, 32]"},{name:"output_auxiliary_logits",val:": bool = None"},{name:"backbone",val:": Optional = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>SwinConfig()</code>) &#x2014;
The configuration of the backbone model. If unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.Mask2FormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.Mask2FormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.Mask2FormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.Mask2FormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.Mask2FormerConfig.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The features (channels) of the resulting feature maps.`,name:"feature_size"},{anchor:"transformers.Mask2FormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.Mask2FormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of feedforward network for deformable detr encoder used as part of pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in the deformable detr encoder used as part of pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.Mask2FormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.Mask2FormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer.`,name:"num_attention_heads"},{anchor:"transformers.Mask2FormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder.`,name:"dropout"},{anchor:"transformers.Mask2FormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Feature dimension in feedforward network for transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.Mask2FormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pre-LayerNorm or not for transformer decoder.`,name:"pre_norm"},{anchor:"transformers.Mask2FormerConfig.enforce_input_projection",description:`<strong>enforce_input_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an input projection 1x1 convolution even if the input channels and hidden dim are identical
in the Transformer decoder.`,name:"enforce_input_projection"},{anchor:"transformers.Mask2FormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Parameter used for determining number of FPN levels used as part of pixel decoder.`,name:"common_stride"},{anchor:"transformers.Mask2FormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Category id to be ignored during training.`,name:"ignore_value"},{anchor:"transformers.Mask2FormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of queries for the decoder.`,name:"num_queries"},{anchor:"transformers.Mask2FormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.Mask2FormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The weight for the cross entropy loss.`,name:"class_weight"},{anchor:"transformers.Mask2FormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.Mask2FormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.Mask2FormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points used for sampling during loss calculation.`,name:"train_num_points"},{anchor:"transformers.Mask2FormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Oversampling parameter used for calculating no. of sampled points`,name:"oversample_ratio"},{anchor:"transformers.Mask2FormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.Mask2FormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.Mask2FormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.Mask2FormerConfig.use_auxiliary_loss",description:"<strong>use_auxiliary_loss</strong> (<code>boolean``, *optional*, defaults to </code>True<code>) -- If </code>True<code> </code>Mask2FormerForUniversalSegmentationOutput` will contain the auxiliary losses computed using\nthe logits from each decoder&#x2019;s stage.",name:"use_auxiliary_loss"},{anchor:"transformers.Mask2FormerConfig.feature_strides",description:`<strong>feature_strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
Feature strides corresponding to features generated from backbone network.`,name:"feature_strides"},{anchor:"transformers.Mask2FormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/configuration_mask2former.py#L28"}}),H=new at({props:{anchor:"transformers.Mask2FormerConfig.example",$$slots:{default:[es]},$$scope:{ctx:j}}}),fe=new I({props:{name:"from_backbone_config",anchor:"transformers.Mask2FormerConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/configuration_mask2former.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a></p>
`}}),ue=new P({props:{title:"MaskFormer specific outputs",local:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",headingTag:"h2"}}),_e=new I({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": FloatTensor = None"},{name:"pixel_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"transformer_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_intermediate_states",val:": Tuple = None"},{name:"masks_queries_logits",val:": Tuple = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_intermediate_states",description:`<strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"transformer_decoder_intermediate_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from each layer in the transformer decoder.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L146"}}),be=new I({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_logits",val:": Optional = None"},{name:"encoder_last_hidden_state",val:": FloatTensor = None"},{name:"pixel_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"transformer_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"pixel_decoder_hidden_states",val:": Optional = None"},{name:"transformer_decoder_hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.auxiliary_logits",description:`<strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L192"}}),Me=new P({props:{title:"Mask2FormerModel",local:"transformers.Mask2FormerModel",headingTag:"h2"}}),ke=new I({props:{name:"class transformers.Mask2FormerModel",anchor:"transformers.Mask2FormerModel",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2206"}}),we=new I({props:{name:"forward",anchor:"transformers.Mask2FormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2220",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from each layer in the transformer decoder.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new qo({props:{$$slots:{default:[ts]},$$scope:{ctx:j}}}),Y=new at({props:{anchor:"transformers.Mask2FormerModel.forward.example",$$slots:{default:[os]},$$scope:{ctx:j}}}),ye=new P({props:{title:"Mask2FormerForUniversalSegmentation",local:"transformers.Mask2FormerForUniversalSegmentation",headingTag:"h2"}}),Fe=new I({props:{name:"class transformers.Mask2FormerForUniversalSegmentation",anchor:"transformers.Mask2FormerForUniversalSegmentation",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2310"}}),ve=new I({props:{name:"forward",anchor:"transformers.Mask2FormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": Optional = None"},{name:"class_labels",val:": Optional = None"},{name:"pixel_mask",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"output_auxiliary_logits",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new qo({props:{$$slots:{default:[ss]},$$scope:{ctx:j}}}),O=new at({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example",$$slots:{default:[as]},$$scope:{ctx:j}}}),A=new at({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-2",$$slots:{default:[ns]},$$scope:{ctx:j}}}),D=new at({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-3",$$slots:{default:[rs]},$$scope:{ctx:j}}}),Te=new P({props:{title:"Mask2FormerImageProcessor",local:"transformers.Mask2FormerImageProcessor",headingTag:"h2"}}),xe=new I({props:{name:"class transformers.Mask2FormerImageProcessor",anchor:"transformers.Mask2FormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"num_labels",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.Mask2FormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.Mask2FormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.Mask2FormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.Mask2FormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.Mask2FormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Mask2FormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.Mask2FormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.Mask2FormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.Mask2FormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.Mask2FormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.Mask2FormerImageProcessor.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of labels in the segmentation map.`,name:"num_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L352"}}),je=new I({props:{name:"preprocess",anchor:"transformers.Mask2FormerImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Optional = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"size_divisor",val:": Optional = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L678"}}),Ue=new I({props:{name:"encode_inputs",anchor:"transformers.Mask2FormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": List"},{name:"segmentation_maps",val:": Union = None"},{name:"instance_id_to_semantic_id",val:": Union = None"},{name:"ignore_index",val:": Optional = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": Union = None"},{name:"input_data_format",val:": Union = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),$e=new I({props:{name:"post_process_semantic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Je=new I({props:{name:"post_process_instance_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": Optional = None"},{name:"return_coco_annotation",val:": Optional = False"},{name:"return_binary_maps",val:": Optional = False"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L1025",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ze=new I({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": Optional = None"},{name:"target_sizes",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>Mask2FormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L1144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ie=new Ko({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mask2former.md"}}),{c(){r=m("meta"),y=a(),p=m("p"),c=a(),h(k.$$.fragment),t=a(),h(w.$$.fragment),rt=a(),oe=m("p"),oe.innerHTML=uo,it=a(),se=m("p"),se.textContent=_o,lt=a(),ae=m("p"),ae.innerHTML=bo,mt=a(),L=m("img"),dt=a(),ne=m("small"),ne.innerHTML=ko,ct=a(),re=m("p"),re.innerHTML=wo,pt=a(),h(ie.$$.fragment),ht=a(),le=m("ul"),le.innerHTML=yo,gt=a(),h(me.$$.fragment),ft=a(),de=m("p"),de.textContent=Fo,ut=a(),ce=m("ul"),ce.innerHTML=vo,_t=a(),pe=m("p"),pe.textContent=To,bt=a(),h(he.$$.fragment),Mt=a(),x=m("div"),h(ge.$$.fragment),Nt=a(),Ze=m("p"),Ze.innerHTML=xo,Zt=a(),Xe=m("p"),Xe.innerHTML=jo,Xt=a(),Ve=m("p"),Ve.innerHTML=Uo,Vt=a(),h(H.$$.fragment),Bt=a(),q=m("div"),h(fe.$$.fragment),St=a(),Be=m("p"),Be.innerHTML=$o,kt=a(),h(ue.$$.fragment),wt=a(),B=m("div"),h(_e.$$.fragment),Gt=a(),Se=m("p"),Se.innerHTML=Jo,yt=a(),C=m("div"),h(be.$$.fragment),Rt=a(),Ge=m("p"),Ge.innerHTML=zo,Pt=a(),Re=m("p"),Re.innerHTML=Io,Ft=a(),h(Me.$$.fragment),vt=a(),N=m("div"),h(ke.$$.fragment),Lt=a(),Pe=m("p"),Pe.innerHTML=Wo,Ht=a(),W=m("div"),h(we.$$.fragment),qt=a(),Le=m("p"),Le.innerHTML=Co,Et=a(),h(E.$$.fragment),Yt=a(),h(Y.$$.fragment),Tt=a(),h(ye.$$.fragment),xt=a(),Z=m("div"),h(Fe.$$.fragment),Qt=a(),He=m("p"),He.innerHTML=No,Ot=a(),T=m("div"),h(ve.$$.fragment),At=a(),qe=m("p"),qe.innerHTML=Zo,Dt=a(),h(Q.$$.fragment),Kt=a(),Ee=m("p"),Ee.textContent=Xo,eo=a(),h(O.$$.fragment),to=a(),h(A.$$.fragment),oo=a(),h(D.$$.fragment),jt=a(),h(Te.$$.fragment),Ut=a(),F=m("div"),h(xe.$$.fragment),so=a(),Ye=m("p"),Ye.textContent=Vo,ao=a(),Qe=m("p"),Qe.innerHTML=Bo,no=a(),Oe=m("div"),h(je.$$.fragment),ro=a(),V=m("div"),h(Ue.$$.fragment),io=a(),Ae=m("p"),Ae.innerHTML=So,lo=a(),De=m("p"),De.innerHTML=Go,mo=a(),K=m("div"),h($e.$$.fragment),co=a(),Ke=m("p"),Ke.innerHTML=Ro,po=a(),ee=m("div"),h(Je.$$.fragment),ho=a(),et=m("p"),et.innerHTML=Po,go=a(),te=m("div"),h(ze.$$.fragment),fo=a(),tt=m("p"),tt.innerHTML=Lo,$t=a(),h(Ie.$$.fragment),Jt=a(),st=m("p"),this.h()},l(e){const s=Do("svelte-u9bgzb",document.head);r=d(s,"META",{name:!0,content:!0}),s.forEach(o),y=n(e),p=d(e,"P",{}),$(p).forEach(o),c=n(e),g(k.$$.fragment,e),t=n(e),g(w.$$.fragment,e),rt=n(e),oe=d(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-vv3e67"&&(oe.innerHTML=uo),it=n(e),se=d(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-vfdo9a"&&(se.textContent=_o),lt=n(e),ae=d(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-12dpxkq"&&(ae.innerHTML=bo),mt=n(e),L=d(e,"IMG",{src:!0,alt:!0,width:!0}),dt=n(e),ne=d(e,"SMALL",{"data-svelte-h":!0}),M(ne)!=="svelte-1qlm9ke"&&(ne.innerHTML=ko),ct=n(e),re=d(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-12ct8xd"&&(re.innerHTML=wo),pt=n(e),g(ie.$$.fragment,e),ht=n(e),le=d(e,"UL",{"data-svelte-h":!0}),M(le)!=="svelte-192jmvq"&&(le.innerHTML=yo),gt=n(e),g(me.$$.fragment,e),ft=n(e),de=d(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-m0sdby"&&(de.textContent=Fo),ut=n(e),ce=d(e,"UL",{"data-svelte-h":!0}),M(ce)!=="svelte-jric7z"&&(ce.innerHTML=vo),_t=n(e),pe=d(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1rggs50"&&(pe.textContent=To),bt=n(e),g(he.$$.fragment,e),Mt=n(e),x=d(e,"DIV",{class:!0});var J=$(x);g(ge.$$.fragment,J),Nt=n(J),Ze=d(J,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-ib30qi"&&(Ze.innerHTML=xo),Zt=n(J),Xe=d(J,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-o55m63"&&(Xe.innerHTML=jo),Xt=n(J),Ve=d(J,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-938vl7"&&(Ve.innerHTML=Uo),Vt=n(J),g(H.$$.fragment,J),Bt=n(J),q=d(J,"DIV",{class:!0});var We=$(q);g(fe.$$.fragment,We),St=n(We),Be=d(We,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-iwqgdj"&&(Be.innerHTML=$o),We.forEach(o),J.forEach(o),kt=n(e),g(ue.$$.fragment,e),wt=n(e),B=d(e,"DIV",{class:!0});var Ce=$(B);g(_e.$$.fragment,Ce),Gt=n(Ce),Se=d(Ce,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-11ltned"&&(Se.innerHTML=Jo),Ce.forEach(o),yt=n(e),C=d(e,"DIV",{class:!0});var S=$(C);g(be.$$.fragment,S),Rt=n(S),Ge=d(S,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1cgna0v"&&(Ge.innerHTML=zo),Pt=n(S),Re=d(S,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-1ufbz4t"&&(Re.innerHTML=Io),S.forEach(o),Ft=n(e),g(Me.$$.fragment,e),vt=n(e),N=d(e,"DIV",{class:!0});var G=$(N);g(ke.$$.fragment,G),Lt=n(G),Pe=d(G,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-14icbh2"&&(Pe.innerHTML=Wo),Ht=n(G),W=d(G,"DIV",{class:!0});var X=$(W);g(we.$$.fragment,X),qt=n(X),Le=d(X,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-1bj7biw"&&(Le.innerHTML=Co),Et=n(X),g(E.$$.fragment,X),Yt=n(X),g(Y.$$.fragment,X),X.forEach(o),G.forEach(o),Tt=n(e),g(ye.$$.fragment,e),xt=n(e),Z=d(e,"DIV",{class:!0});var R=$(Z);g(Fe.$$.fragment,R),Qt=n(R),He=d(R,"P",{"data-svelte-h":!0}),M(He)!=="svelte-dh9ww1"&&(He.innerHTML=No),Ot=n(R),T=d(R,"DIV",{class:!0});var z=$(T);g(ve.$$.fragment,z),At=n(z),qe=d(z,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1y2q3l0"&&(qe.innerHTML=Zo),Dt=n(z),g(Q.$$.fragment,z),Kt=n(z),Ee=d(z,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-kvfsh7"&&(Ee.textContent=Xo),eo=n(z),g(O.$$.fragment,z),to=n(z),g(A.$$.fragment,z),oo=n(z),g(D.$$.fragment,z),z.forEach(o),R.forEach(o),jt=n(e),g(Te.$$.fragment,e),Ut=n(e),F=d(e,"DIV",{class:!0});var U=$(F);g(xe.$$.fragment,U),so=n(U),Ye=d(U,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-1te0494"&&(Ye.textContent=Vo),ao=n(U),Qe=d(U,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1o6r6pd"&&(Qe.innerHTML=Bo),no=n(U),Oe=d(U,"DIV",{class:!0});var Ho=$(Oe);g(je.$$.fragment,Ho),Ho.forEach(o),ro=n(U),V=d(U,"DIV",{class:!0});var ot=$(V);g(Ue.$$.fragment,ot),io=n(ot),Ae=d(ot,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-1tetyua"&&(Ae.innerHTML=So),lo=n(ot),De=d(ot,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1gqhxe4"&&(De.innerHTML=Go),ot.forEach(o),mo=n(U),K=d(U,"DIV",{class:!0});var It=$(K);g($e.$$.fragment,It),co=n(It),Ke=d(It,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-h41nf"&&(Ke.innerHTML=Ro),It.forEach(o),po=n(U),ee=d(U,"DIV",{class:!0});var Wt=$(ee);g(Je.$$.fragment,Wt),ho=n(Wt),et=d(Wt,"P",{"data-svelte-h":!0}),M(et)!=="svelte-31bvgi"&&(et.innerHTML=Po),Wt.forEach(o),go=n(U),te=d(U,"DIV",{class:!0});var Ct=$(te);g(ze.$$.fragment,Ct),fo=n(Ct),tt=d(Ct,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-ay0y3u"&&(tt.innerHTML=Lo),Ct.forEach(o),U.forEach(o),$t=n(e),g(Ie.$$.fragment,e),Jt=n(e),st=d(e,"P",{}),$(st).forEach(o),this.h()},h(){v(r,"name","hf:doc:metadata"),v(r,"content",ls),Yo(L.src,Mo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/mask2former_architecture.jpg")||v(L,"src",Mo),v(L,"alt","drawing"),v(L,"width","600"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){i(document.head,r),l(e,y,s),l(e,p,s),l(e,c,s),f(k,e,s),l(e,t,s),f(w,e,s),l(e,rt,s),l(e,oe,s),l(e,it,s),l(e,se,s),l(e,lt,s),l(e,ae,s),l(e,mt,s),l(e,L,s),l(e,dt,s),l(e,ne,s),l(e,ct,s),l(e,re,s),l(e,pt,s),f(ie,e,s),l(e,ht,s),l(e,le,s),l(e,gt,s),f(me,e,s),l(e,ft,s),l(e,de,s),l(e,ut,s),l(e,ce,s),l(e,_t,s),l(e,pe,s),l(e,bt,s),f(he,e,s),l(e,Mt,s),l(e,x,s),f(ge,x,null),i(x,Nt),i(x,Ze),i(x,Zt),i(x,Xe),i(x,Xt),i(x,Ve),i(x,Vt),f(H,x,null),i(x,Bt),i(x,q),f(fe,q,null),i(q,St),i(q,Be),l(e,kt,s),f(ue,e,s),l(e,wt,s),l(e,B,s),f(_e,B,null),i(B,Gt),i(B,Se),l(e,yt,s),l(e,C,s),f(be,C,null),i(C,Rt),i(C,Ge),i(C,Pt),i(C,Re),l(e,Ft,s),f(Me,e,s),l(e,vt,s),l(e,N,s),f(ke,N,null),i(N,Lt),i(N,Pe),i(N,Ht),i(N,W),f(we,W,null),i(W,qt),i(W,Le),i(W,Et),f(E,W,null),i(W,Yt),f(Y,W,null),l(e,Tt,s),f(ye,e,s),l(e,xt,s),l(e,Z,s),f(Fe,Z,null),i(Z,Qt),i(Z,He),i(Z,Ot),i(Z,T),f(ve,T,null),i(T,At),i(T,qe),i(T,Dt),f(Q,T,null),i(T,Kt),i(T,Ee),i(T,eo),f(O,T,null),i(T,to),f(A,T,null),i(T,oo),f(D,T,null),l(e,jt,s),f(Te,e,s),l(e,Ut,s),l(e,F,s),f(xe,F,null),i(F,so),i(F,Ye),i(F,ao),i(F,Qe),i(F,no),i(F,Oe),f(je,Oe,null),i(F,ro),i(F,V),f(Ue,V,null),i(V,io),i(V,Ae),i(V,lo),i(V,De),i(F,mo),i(F,K),f($e,K,null),i(K,co),i(K,Ke),i(F,po),i(F,ee),f(Je,ee,null),i(ee,ho),i(ee,et),i(F,go),i(F,te),f(ze,te,null),i(te,fo),i(te,tt),l(e,$t,s),f(Ie,e,s),l(e,Jt,s),l(e,st,s),zt=!0},p(e,[s]){const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),H.$set(J);const We={};s&2&&(We.$$scope={dirty:s,ctx:e}),E.$set(We);const Ce={};s&2&&(Ce.$$scope={dirty:s,ctx:e}),Y.$set(Ce);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),Q.$set(S);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),O.$set(G);const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),A.$set(X);const R={};s&2&&(R.$$scope={dirty:s,ctx:e}),D.$set(R)},i(e){zt||(u(k.$$.fragment,e),u(w.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(H.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(ke.$$.fragment,e),u(we.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(ye.$$.fragment,e),u(Fe.$$.fragment,e),u(ve.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u($e.$$.fragment,e),u(Je.$$.fragment,e),u(ze.$$.fragment,e),u(Ie.$$.fragment,e),zt=!0)},o(e){_(k.$$.fragment,e),_(w.$$.fragment,e),_(ie.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(H.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(ke.$$.fragment,e),_(we.$$.fragment,e),_(E.$$.fragment,e),_(Y.$$.fragment,e),_(ye.$$.fragment,e),_(Fe.$$.fragment,e),_(ve.$$.fragment,e),_(Q.$$.fragment,e),_(O.$$.fragment,e),_(A.$$.fragment,e),_(D.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_(je.$$.fragment,e),_(Ue.$$.fragment,e),_($e.$$.fragment,e),_(Je.$$.fragment,e),_(ze.$$.fragment,e),_(Ie.$$.fragment,e),zt=!1},d(e){e&&(o(y),o(p),o(c),o(t),o(rt),o(oe),o(it),o(se),o(lt),o(ae),o(mt),o(L),o(dt),o(ne),o(ct),o(re),o(pt),o(ht),o(le),o(gt),o(ft),o(de),o(ut),o(ce),o(_t),o(pe),o(bt),o(Mt),o(x),o(kt),o(wt),o(B),o(yt),o(C),o(Ft),o(vt),o(N),o(Tt),o(xt),o(Z),o(jt),o(Ut),o(F),o($t),o(Jt),o(st)),o(r),b(k,e),b(w,e),b(ie,e),b(me,e),b(he,e),b(ge),b(H),b(fe),b(ue,e),b(_e),b(be),b(Me,e),b(ke),b(we),b(E),b(Y),b(ye,e),b(Fe),b(ve),b(Q),b(O),b(A),b(D),b(Te,e),b(xe),b(je),b(Ue),b($e),b(Je),b(ze),b(Ie,e)}}}const ls='{"title":"Mask2Former","local":"mask2former","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Mask2FormerConfig","local":"transformers.Mask2FormerConfig","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput","sections":[],"depth":2},{"title":"Mask2FormerModel","local":"transformers.Mask2FormerModel","sections":[],"depth":2},{"title":"Mask2FormerForUniversalSegmentation","local":"transformers.Mask2FormerForUniversalSegmentation","sections":[],"depth":2},{"title":"Mask2FormerImageProcessor","local":"transformers.Mask2FormerImageProcessor","sections":[],"depth":2}],"depth":1}';function ms(j){return Qo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends Oo{constructor(r){super(),Ao(this,r,ms,is,Eo,{})}}export{_s as component};
