import{s as pt,o as gt,n as Ee}from"../chunks/scheduler.9991993c.js";import{S as ut,i as ht,g as l,s,r as f,A as ft,h as c,f as o,c as a,j as G,u as M,x as p,k,y as t,a as m,v as b,d as _,t as y,w as T}from"../chunks/index.7fc9a5e7.js";import{T as mt}from"../chunks/Tip.9de92fc6.js";import{D as I}from"../chunks/Docstring.ef7d0149.js";import{C as Hn}from"../chunks/CodeBlock.e11cba92.js";import{E as Rn}from"../chunks/ExampleCodeBlock.0db1a011.js";import{H as Ne,E as Mt}from"../chunks/EditOnGithub.84ab7f0e.js";function bt(B){let r,j="Examples:",g,d,u;return d=new Hn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQSUyMyUyMEUuZy4lMjBjb25maWclMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiklMEElMEElMjMlMjBZb3UlMjBjYW4lMjBhbHNvJTIwc3BlY2lmeSUyMGNvbmZpZ3VyYXRpb24lMjBuYW1lcyUyMHRvJTIweW91ciUyMGdlbmVyYXRpb24lMjBjb25maWd1cmF0aW9uJTIwZmlsZSUwQWdlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyJTJDJTIwY29uZmlnX2ZpbGVfbmFtZSUzRCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjAlMjJteV9jb25maWd1cmF0aW9uLmpzb24lMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UnZCUyMGxpa2UlMjB0byUyMHRyeSUyMGElMjBtaW5vciUyMHZhcmlhdGlvbiUyMHRvJTIwYW4lMjBleGlzdGluZyUyMGNvbmZpZ3VyYXRpb24lMkMlMjB5b3UlMjBjYW4lMjBhbHNvJTIwcGFzcyUyMGdlbmVyYXRpb24lMEElMjMlMjBhcmd1bWVudHMlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoKSU2MC4lMjBCZSUyMG1pbmRmdWwlMjB0aGF0JTIwdHlwb3MlMjBhbmQlMjB1bnVzZWQlMjBhcmd1bWVudHMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTBBZ2VuZXJhdGlvbl9jb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjB0b3BfayUzRDElMkMlMjBmb28lM0RGYWxzZSUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBZ2VuZXJhdGlvbl9jb25maWcudG9wX2slMEElMEF1bnVzZWRfa3dhcmdz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){r=l("p"),r.textContent=j,g=s(),f(d.$$.fragment)},l(n){r=c(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kvfsh7"&&(r.textContent=j),g=a(n),M(d.$$.fragment,n)},m(n,h){m(n,r,h),m(n,g,h),b(d,n,h),u=!0},p:Ee,i(n){u||(_(d.$$.fragment,n),u=!0)},o(n){y(d.$$.fragment,n),u=!1},d(n){n&&(o(r),o(g)),T(d,n)}}}function _t(B){let r,j=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,d,u=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){r=l("p"),r.innerHTML=j,g=s(),d=l("p"),d.innerHTML=u},l(n){r=c(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1c5u34l"&&(r.innerHTML=j),g=a(n),d=c(n,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fvlq1g"&&(d.innerHTML=u)},m(n,h){m(n,r,h),m(n,g,h),m(n,d,h)},p:Ee,d(n){n&&(o(r),o(g),o(d))}}}function yt(B){let r,j="Examples:",g,d,u;return d=new Hn({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | log probability | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 1: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip 2: the output length does NOT include the input length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){r=l("p"),r.textContent=j,g=s(),f(d.$$.fragment)},l(n){r=c(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kvfsh7"&&(r.textContent=j),g=a(n),M(d.$$.fragment,n)},m(n,h){m(n,r,h),m(n,g,h),b(d,n,h),u=!0},p:Ee,i(n){u||(_(d.$$.fragment,n),u=!0)},o(n){y(d.$$.fragment,n),u=!1},d(n){n&&(o(r),o(g)),T(d,n)}}}function Tt(B){let r,j=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate, e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,g,d,u=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){r=l("p"),r.innerHTML=j,g=s(),d=l("p"),d.innerHTML=u},l(n){r=c(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1pahvb2"&&(r.innerHTML=j),g=a(n),d=c(n,"P",{"data-svelte-h":!0}),p(d)!=="svelte-fvlq1g"&&(d.innerHTML=u)},m(n,h){m(n,r,h),m(n,g,h),m(n,d,h)},p:Ee,d(n){n&&(o(r),o(g),o(d))}}}function jt(B){let r,j="Examples:",g,d,u;return d=new Hn({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){r=l("p"),r.textContent=j,g=s(),f(d.$$.fragment)},l(n){r=c(n,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kvfsh7"&&(r.textContent=j),g=a(n),M(d.$$.fragment,n)},m(n,h){m(n,r,h),m(n,g,h),b(d,n,h),u=!0},p:Ee,i(n){u||(_(d.$$.fragment,n),u=!0)},o(n){y(d.$$.fragment,n),u=!1},d(n){n&&(o(r),o(g)),T(d,n)}}}function wt(B){let r,j,g,d,u,n,h,Fn="每个框架都在它们各自的 <code>GenerationMixin</code> 类中实现了文本生成的 <code>generate</code> 方法：",Ye,q,Nn='<li>PyTorch <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 在 <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationMixin">GenerationMixin</a> 中实现。</li> <li>TensorFlow <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a> 在 <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.TFGenerationMixin">TFGenerationMixin</a> 中实现。</li> <li>Flax/JAX <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a> 在 <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.FlaxGenerationMixin">FlaxGenerationMixin</a> 中实现。</li>',Se,A,En='无论您选择哪个框架，都可以使用 <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> 类实例对 generate 方法进行参数化。有关生成方法的控制参数的完整列表，请参阅此类。',Le,O,Yn='要了解如何检查模型的生成配置、默认值是什么、如何临时更改参数以及如何创建和保存自定义生成配置，请参阅 <a href="../generation_strategies">文本生成策略指南</a>。该指南还解释了如何使用相关功能，如token流。',De,P,Qe,Z,K,on,C,ee,rn,Me,Sn='Instantiate a <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a generation configuration file.',ln,F,cn,N,ne,dn,be,Ln=`Instantiates a <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a <a href="/docs/transformers/main/zh/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This function is useful to convert legacy
<a href="/docs/transformers/main/zh/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> objects, which may contain generation parameters, into a stand-alone <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.`,mn,E,te,pn,_e,Dn=`Save a generation configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">from_pretrained()</a> class method.`,qe,se,Ae,w,ae,gn,ye,Qn='A class containing all functions for auto-regressive text generation, to be used as a mixin in <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',un,Te,qn='The class exposes <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, which can be used for:',hn,je,An="<li><em>greedy decoding</em> if <code>num_beams=1</code> and <code>do_sample=False</code></li> <li><em>contrastive search</em> if <code>penalty_alpha&gt;0</code> and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> if <code>num_beams=1</code> and <code>do_sample=True</code></li> <li><em>beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> if <code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> if <code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> if <code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> if <code>assistant_model</code> or <code>prompt_lookup_num_tokens</code> is passed to <code>.generate()</code></li>",fn,we,On='To learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.',Mn,V,oe,bn,Je,Pn="Generates sequences of token ids for models with a language modeling head.",_n,Y,yn,W,re,Tn,ve,Kn=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,jn,S,Oe,ie,Pe,J,le,wn,xe,et='A class containing all of the functions supporting generation, to be used as a mixin in <a href="/docs/transformers/main/zh/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>.',Jn,Ue,nt='The class exposes <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>, which can be used for:',vn,Ge,tt=`<li><em>greedy decoding</em> by calling <code>greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <code>contrastive_search()</code> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <code>sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>beam_search()</code> if <code>num_beams&gt;1</code></li>`,xn,ke,st=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Un,X,ce,Gn,Ze,at="Generates sequences of token ids for models with a language modeling head.",kn,L,Zn,R,de,Bn,Be,ot=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,zn,D,Ke,me,en,v,pe,In,ze,rt=`A class containing all functions for auto-regressive text generation, to be used as a mixin in
<a href="/docs/transformers/main/zh/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>.`,$n,Ie,it='The class exposes <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>, which can be used for:',Cn,$e,lt=`<li><em>greedy decoding</em> by calling <code>_greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>multinomial sampling</em> by calling <code>_sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>_beam_search()</code> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li>`,Vn,Ce,ct=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Wn,Q,ge,Xn,Ve,dt="Generates sequences of token ids for models with a language modeling head.",nn,ue,tn,Fe,sn;return u=new Ne({props:{title:"Generation",local:"generation",headingTag:"h1"}}),P=new Ne({props:{title:"GenerationConfig",local:"transformers.GenerationConfig",headingTag:"h2"}}),K=new I({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L94"}}),ee=new I({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible.
Will be removed in v5 of Transformers.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass <code>revision=&quot;refs/pr/&lt;pr_number&gt;&quot;</code>.</p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L879",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),F=new Rn({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[bt]},$$scope:{ctx:B}}}),ne=new I({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L1219",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The configuration object instantiated from those parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),te=new I({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"config_file_name",val:": Union = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/configuration_utils.py#L801"}}),se=new Ne({props:{title:"GenerationMixin",local:"transformers.GenerationMixin",headingTag:"h2"}}),ae=new I({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L332"}}),oe=new I({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"stopping_criteria",val:": Optional = None"},{name:"prefix_allowed_tokens_fn",val:": Optional = None"},{name:"synced_gpus",val:": Optional = None"},{name:"assistant_model",val:": Optional = None"},{name:"streamer",val:": Optional = None"},{name:"negative_prompt_ids",val:": Optional = None"},{name:"negative_prompt_attention_mask",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1860",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),Y=new mt({props:{warning:!0,$$slots:{default:[_t]},$$scope:{ctx:B}}}),re=new I({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),S=new Rn({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[yt]},$$scope:{ctx:B}}}),ie=new Ne({props:{title:"TFGenerationMixin",local:"transformers.TFGenerationMixin",headingTag:"h2"}}),le=new I({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L444"}}),ce=new I({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": Optional = None"},{name:"generation_config",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L645",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/zh/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),L=new mt({props:{warning:!0,$$slots:{default:[Tt]},$$scope:{ctx:B}}}),de=new I({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": Tuple"},{name:"beam_indices",val:": Optional = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L477",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code></p>
`}}),D=new Rn({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[jt]},$$scope:{ctx:B}}}),me=new Ne({props:{title:"FlaxGenerationMixin",local:"transformers.FlaxGenerationMixin",headingTag:"h2"}}),pe=new I({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L130"}}),ge=new I({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": Optional = None"},{name:"prng_key",val:": Optional = None"},{name:"trace",val:": bool = True"},{name:"params",val:": Optional = None"},{name:"logits_processor",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/zh/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L268",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/zh/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),ue=new Mt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/main_classes/text_generation.md"}}),{c(){r=l("meta"),j=s(),g=l("p"),d=s(),f(u.$$.fragment),n=s(),h=l("p"),h.innerHTML=Fn,Ye=s(),q=l("ul"),q.innerHTML=Nn,Se=s(),A=l("p"),A.innerHTML=En,Le=s(),O=l("p"),O.innerHTML=Yn,De=s(),f(P.$$.fragment),Qe=s(),Z=l("div"),f(K.$$.fragment),on=s(),C=l("div"),f(ee.$$.fragment),rn=s(),Me=l("p"),Me.innerHTML=Sn,ln=s(),f(F.$$.fragment),cn=s(),N=l("div"),f(ne.$$.fragment),dn=s(),be=l("p"),be.innerHTML=Ln,mn=s(),E=l("div"),f(te.$$.fragment),pn=s(),_e=l("p"),_e.innerHTML=Dn,qe=s(),f(se.$$.fragment),Ae=s(),w=l("div"),f(ae.$$.fragment),gn=s(),ye=l("p"),ye.innerHTML=Qn,un=s(),Te=l("p"),Te.innerHTML=qn,hn=s(),je=l("ul"),je.innerHTML=An,fn=s(),we=l("p"),we.innerHTML=On,Mn=s(),V=l("div"),f(oe.$$.fragment),bn=s(),Je=l("p"),Je.textContent=Pn,_n=s(),f(Y.$$.fragment),yn=s(),W=l("div"),f(re.$$.fragment),Tn=s(),ve=l("p"),ve.textContent=Kn,jn=s(),f(S.$$.fragment),Oe=s(),f(ie.$$.fragment),Pe=s(),J=l("div"),f(le.$$.fragment),wn=s(),xe=l("p"),xe.innerHTML=et,Jn=s(),Ue=l("p"),Ue.innerHTML=nt,vn=s(),Ge=l("ul"),Ge.innerHTML=tt,xn=s(),ke=l("p"),ke.innerHTML=st,Un=s(),X=l("div"),f(ce.$$.fragment),Gn=s(),Ze=l("p"),Ze.textContent=at,kn=s(),f(L.$$.fragment),Zn=s(),R=l("div"),f(de.$$.fragment),Bn=s(),Be=l("p"),Be.textContent=ot,zn=s(),f(D.$$.fragment),Ke=s(),f(me.$$.fragment),en=s(),v=l("div"),f(pe.$$.fragment),In=s(),ze=l("p"),ze.innerHTML=rt,$n=s(),Ie=l("p"),Ie.innerHTML=it,Cn=s(),$e=l("ul"),$e.innerHTML=lt,Vn=s(),Ce=l("p"),Ce.innerHTML=ct,Wn=s(),Q=l("div"),f(ge.$$.fragment),Xn=s(),Ve=l("p"),Ve.textContent=dt,nn=s(),f(ue.$$.fragment),tn=s(),Fe=l("p"),this.h()},l(e){const i=ft("svelte-u9bgzb",document.head);r=c(i,"META",{name:!0,content:!0}),i.forEach(o),j=a(e),g=c(e,"P",{}),G(g).forEach(o),d=a(e),M(u.$$.fragment,e),n=a(e),h=c(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1k28bt"&&(h.innerHTML=Fn),Ye=a(e),q=c(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-xzoscc"&&(q.innerHTML=Nn),Se=a(e),A=c(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-18lmnzt"&&(A.innerHTML=En),Le=a(e),O=c(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-179ahbs"&&(O.innerHTML=Yn),De=a(e),M(P.$$.fragment,e),Qe=a(e),Z=c(e,"DIV",{class:!0});var $=G(Z);M(K.$$.fragment,$),on=a($),C=c($,"DIV",{class:!0});var H=G(C);M(ee.$$.fragment,H),rn=a(H),Me=c(H,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1twplvm"&&(Me.innerHTML=Sn),ln=a(H),M(F.$$.fragment,H),H.forEach(o),cn=a($),N=c($,"DIV",{class:!0});var he=G(N);M(ne.$$.fragment,he),dn=a(he),be=c(he,"P",{"data-svelte-h":!0}),p(be)!=="svelte-i38qcb"&&(be.innerHTML=Ln),he.forEach(o),mn=a($),E=c($,"DIV",{class:!0});var fe=G(E);M(te.$$.fragment,fe),pn=a(fe),_e=c(fe,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-4i2w4l"&&(_e.innerHTML=Dn),fe.forEach(o),$.forEach(o),qe=a(e),M(se.$$.fragment,e),Ae=a(e),w=c(e,"DIV",{class:!0});var x=G(w);M(ae.$$.fragment,x),gn=a(x),ye=c(x,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-5ssewn"&&(ye.innerHTML=Qn),un=a(x),Te=c(x,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1uyhp82"&&(Te.innerHTML=qn),hn=a(x),je=c(x,"UL",{"data-svelte-h":!0}),p(je)!=="svelte-1655ho"&&(je.innerHTML=An),fn=a(x),we=c(x,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1gtazd5"&&(we.innerHTML=On),Mn=a(x),V=c(x,"DIV",{class:!0});var We=G(V);M(oe.$$.fragment,We),bn=a(We),Je=c(We,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-s5ko3x"&&(Je.textContent=Pn),_n=a(We),M(Y.$$.fragment,We),We.forEach(o),yn=a(x),W=c(x,"DIV",{class:!0});var Xe=G(W);M(re.$$.fragment,Xe),Tn=a(Xe),ve=c(Xe,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1om47tb"&&(ve.textContent=Kn),jn=a(Xe),M(S.$$.fragment,Xe),Xe.forEach(o),x.forEach(o),Oe=a(e),M(ie.$$.fragment,e),Pe=a(e),J=c(e,"DIV",{class:!0});var U=G(J);M(le.$$.fragment,U),wn=a(U),xe=c(U,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1bj8ta5"&&(xe.innerHTML=et),Jn=a(U),Ue=c(U,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-x1z540"&&(Ue.innerHTML=nt),vn=a(U),Ge=c(U,"UL",{"data-svelte-h":!0}),p(Ge)!=="svelte-fx738d"&&(Ge.innerHTML=tt),xn=a(U),ke=c(U,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-13kczdy"&&(ke.innerHTML=st),Un=a(U),X=c(U,"DIV",{class:!0});var Re=G(X);M(ce.$$.fragment,Re),Gn=a(Re),Ze=c(Re,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-s5ko3x"&&(Ze.textContent=at),kn=a(Re),M(L.$$.fragment,Re),Re.forEach(o),Zn=a(U),R=c(U,"DIV",{class:!0});var He=G(R);M(de.$$.fragment,He),Bn=a(He),Be=c(He,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1om47tb"&&(Be.textContent=ot),zn=a(He),M(D.$$.fragment,He),He.forEach(o),U.forEach(o),Ke=a(e),M(me.$$.fragment,e),en=a(e),v=c(e,"DIV",{class:!0});var z=G(v);M(pe.$$.fragment,z),In=a(z),ze=c(z,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-h0a2hx"&&(ze.innerHTML=rt),$n=a(z),Ie=c(z,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-vu95if"&&(Ie.innerHTML=it),Cn=a(z),$e=c(z,"UL",{"data-svelte-h":!0}),p($e)!=="svelte-ffjx8e"&&($e.innerHTML=lt),Vn=a(z),Ce=c(z,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-13kczdy"&&(Ce.innerHTML=ct),Wn=a(z),Q=c(z,"DIV",{class:!0});var an=G(Q);M(ge.$$.fragment,an),Xn=a(an),Ve=c(an,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-s5ko3x"&&(Ve.textContent=dt),an.forEach(o),z.forEach(o),nn=a(e),M(ue.$$.fragment,e),tn=a(e),Fe=c(e,"P",{}),G(Fe).forEach(o),this.h()},h(){k(r,"name","hf:doc:metadata"),k(r,"content",Jt),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,r),m(e,j,i),m(e,g,i),m(e,d,i),b(u,e,i),m(e,n,i),m(e,h,i),m(e,Ye,i),m(e,q,i),m(e,Se,i),m(e,A,i),m(e,Le,i),m(e,O,i),m(e,De,i),b(P,e,i),m(e,Qe,i),m(e,Z,i),b(K,Z,null),t(Z,on),t(Z,C),b(ee,C,null),t(C,rn),t(C,Me),t(C,ln),b(F,C,null),t(Z,cn),t(Z,N),b(ne,N,null),t(N,dn),t(N,be),t(Z,mn),t(Z,E),b(te,E,null),t(E,pn),t(E,_e),m(e,qe,i),b(se,e,i),m(e,Ae,i),m(e,w,i),b(ae,w,null),t(w,gn),t(w,ye),t(w,un),t(w,Te),t(w,hn),t(w,je),t(w,fn),t(w,we),t(w,Mn),t(w,V),b(oe,V,null),t(V,bn),t(V,Je),t(V,_n),b(Y,V,null),t(w,yn),t(w,W),b(re,W,null),t(W,Tn),t(W,ve),t(W,jn),b(S,W,null),m(e,Oe,i),b(ie,e,i),m(e,Pe,i),m(e,J,i),b(le,J,null),t(J,wn),t(J,xe),t(J,Jn),t(J,Ue),t(J,vn),t(J,Ge),t(J,xn),t(J,ke),t(J,Un),t(J,X),b(ce,X,null),t(X,Gn),t(X,Ze),t(X,kn),b(L,X,null),t(J,Zn),t(J,R),b(de,R,null),t(R,Bn),t(R,Be),t(R,zn),b(D,R,null),m(e,Ke,i),b(me,e,i),m(e,en,i),m(e,v,i),b(pe,v,null),t(v,In),t(v,ze),t(v,$n),t(v,Ie),t(v,Cn),t(v,$e),t(v,Vn),t(v,Ce),t(v,Wn),t(v,Q),b(ge,Q,null),t(Q,Xn),t(Q,Ve),m(e,nn,i),b(ue,e,i),m(e,tn,i),m(e,Fe,i),sn=!0},p(e,[i]){const $={};i&2&&($.$$scope={dirty:i,ctx:e}),F.$set($);const H={};i&2&&(H.$$scope={dirty:i,ctx:e}),Y.$set(H);const he={};i&2&&(he.$$scope={dirty:i,ctx:e}),S.$set(he);const fe={};i&2&&(fe.$$scope={dirty:i,ctx:e}),L.$set(fe);const x={};i&2&&(x.$$scope={dirty:i,ctx:e}),D.$set(x)},i(e){sn||(_(u.$$.fragment,e),_(P.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(F.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(oe.$$.fragment,e),_(Y.$$.fragment,e),_(re.$$.fragment,e),_(S.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(L.$$.fragment,e),_(de.$$.fragment,e),_(D.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),sn=!0)},o(e){y(u.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(F.$$.fragment,e),y(ne.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(oe.$$.fragment,e),y(Y.$$.fragment,e),y(re.$$.fragment,e),y(S.$$.fragment,e),y(ie.$$.fragment,e),y(le.$$.fragment,e),y(ce.$$.fragment,e),y(L.$$.fragment,e),y(de.$$.fragment,e),y(D.$$.fragment,e),y(me.$$.fragment,e),y(pe.$$.fragment,e),y(ge.$$.fragment,e),y(ue.$$.fragment,e),sn=!1},d(e){e&&(o(j),o(g),o(d),o(n),o(h),o(Ye),o(q),o(Se),o(A),o(Le),o(O),o(De),o(Qe),o(Z),o(qe),o(Ae),o(w),o(Oe),o(Pe),o(J),o(Ke),o(en),o(v),o(nn),o(tn),o(Fe)),o(r),T(u,e),T(P,e),T(K),T(ee),T(F),T(ne),T(te),T(se,e),T(ae),T(oe),T(Y),T(re),T(S),T(ie,e),T(le),T(ce),T(L),T(de),T(D),T(me,e),T(pe),T(ge),T(ue,e)}}}const Jt='{"title":"Generation","local":"generation","sections":[{"title":"GenerationConfig","local":"transformers.GenerationConfig","sections":[],"depth":2},{"title":"GenerationMixin","local":"transformers.GenerationMixin","sections":[],"depth":2},{"title":"TFGenerationMixin","local":"transformers.TFGenerationMixin","sections":[],"depth":2},{"title":"FlaxGenerationMixin","local":"transformers.FlaxGenerationMixin","sections":[],"depth":2}],"depth":1}';function vt(B){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends ut{constructor(r){super(),ht(this,r,vt,wt,pt,{})}}export{It as component};
