import{s as Ct,n as It,o as xt}from"../chunks/scheduler.85c25b89.js";import{S as kt,i as Wt,g as p,s as l,r as m,A as At,h as i,f as e,c as n,j as $t,u as o,x as r,k as Zt,y as Bt,a,v as c,d as g,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as X}from"../chunks/CodeBlock.94efc595.js";import{H as Y}from"../chunks/Heading.3c6e5b17.js";function Et(ht){let j,_,R,V,d,H,y,Mt="Extending  “shallow” skip connections, <strong>Dense Layer Aggregation (DLA)</strong> incorporates more depth and sharing. The authors introduce two structures for deep layer aggregation (DLA): iterative deep aggregation (IDA) and hierarchical deep aggregation (HDA). These structures are expressed through an architectural framework, independent of the choice of backbone, for compatibility with current and future networks.",S,u,jt="IDA focuses on fusing resolutions and scales while HDA focuses on merging features from all modules and channels. IDA follows the base hierarchy to refine resolution and aggregate scale stage-bystage. HDA assembles its own hierarchy of tree-structured connections that cross and merge stages to aggregate different levels of representation.",z,J,F,w,dt="To load a pretrained model:",D,f,L,T,yt="To load and preprocess the image:",q,b,P,U,ut="To get the model predictions:",K,$,O,Z,Jt="To get the top-5 predictions class names:",tt,C,st,I,wt="Replace the model name with the variant you want to use, e.g. <code>dla102</code>. You can find the IDs in the model summaries at the top of this page.",et,x,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,k,lt,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,A,pt,B,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,E,mt,v,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,G,rt,N,ct,Q,gt;return d=new Y({props:{title:"Deep Layer Aggregation",local:"deep-layer-aggregation",headingTag:"h1"}}),J=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RsYTEwMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),A=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGxhMTAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),N=new X({props:{code:"JTQwbWlzYyU3Qnl1MjAxOWRlZXAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkRlZXAlMjBMYXllciUyMEFnZ3JlZ2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRmlzaGVyJTIwWXUlMjBhbmQlMjBEZXF1YW4lMjBXYW5nJTIwYW5kJTIwRXZhbiUyMFNoZWxoYW1lciUyMGFuZCUyMFRyZXZvciUyMERhcnJlbGwlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDY0ODQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{yu2019deep,
      title={Deep Layer Aggregation}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Fisher Yu and Dequan Wang and Evan Shelhamer and Trevor Darrell}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1707.06484}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){j=p("meta"),_=l(),R=p("p"),V=l(),m(d.$$.fragment),H=l(),y=p("p"),y.innerHTML=Mt,S=l(),u=p("p"),u.textContent=jt,z=l(),m(J.$$.fragment),F=l(),w=p("p"),w.textContent=dt,D=l(),m(f.$$.fragment),L=l(),T=p("p"),T.textContent=yt,q=l(),m(b.$$.fragment),P=l(),U=p("p"),U.textContent=ut,K=l(),m($.$$.fragment),O=l(),Z=p("p"),Z.textContent=Jt,tt=l(),m(C.$$.fragment),st=l(),I=p("p"),I.innerHTML=wt,et=l(),x=p("p"),x.innerHTML=ft,at=l(),m(k.$$.fragment),lt=l(),W=p("p"),W.textContent=Tt,nt=l(),m(A.$$.fragment),pt=l(),B=p("p"),B.innerHTML=bt,it=l(),m(E.$$.fragment),mt=l(),v=p("p"),v.innerHTML=Ut,ot=l(),m(G.$$.fragment),rt=l(),m(N.$$.fragment),ct=l(),Q=p("p"),this.h()},l(t){const s=At("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(e),_=n(t),R=i(t,"P",{}),$t(R).forEach(e),V=n(t),o(d.$$.fragment,t),H=n(t),y=i(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-ztimnn"&&(y.innerHTML=Mt),S=n(t),u=i(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-148crxx"&&(u.textContent=jt),z=n(t),o(J.$$.fragment,t),F=n(t),w=i(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-18ywhxh"&&(w.textContent=dt),D=n(t),o(f.$$.fragment,t),L=n(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1c2ipa8"&&(T.textContent=yt),q=n(t),o(b.$$.fragment,t),P=n(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=ut),K=n(t),o($.$$.fragment,t),O=n(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-19cnvx1"&&(Z.textContent=Jt),tt=n(t),o(C.$$.fragment,t),st=n(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-16eylps"&&(I.innerHTML=wt),et=n(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1wmi3ea"&&(x.innerHTML=ft),at=n(t),o(k.$$.fragment,t),lt=n(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),nt=n(t),o(A.$$.fragment,t),pt=n(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1kguc51"&&(B.innerHTML=bt),it=n(t),o(E.$$.fragment,t),mt=n(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1n0coha"&&(v.innerHTML=Ut),ot=n(t),o(G.$$.fragment,t),rt=n(t),o(N.$$.fragment,t),ct=n(t),Q=i(t,"P",{}),$t(Q).forEach(e),this.h()},h(){Zt(j,"name","hf:doc:metadata"),Zt(j,"content",vt)},m(t,s){Bt(document.head,j),a(t,_,s),a(t,R,s),a(t,V,s),c(d,t,s),a(t,H,s),a(t,y,s),a(t,S,s),a(t,u,s),a(t,z,s),c(J,t,s),a(t,F,s),a(t,w,s),a(t,D,s),c(f,t,s),a(t,L,s),a(t,T,s),a(t,q,s),c(b,t,s),a(t,P,s),a(t,U,s),a(t,K,s),c($,t,s),a(t,O,s),a(t,Z,s),a(t,tt,s),c(C,t,s),a(t,st,s),a(t,I,s),a(t,et,s),a(t,x,s),a(t,at,s),c(k,t,s),a(t,lt,s),a(t,W,s),a(t,nt,s),c(A,t,s),a(t,pt,s),a(t,B,s),a(t,it,s),c(E,t,s),a(t,mt,s),a(t,v,s),a(t,ot,s),c(G,t,s),a(t,rt,s),c(N,t,s),a(t,ct,s),a(t,Q,s),gt=!0},p:It,i(t){gt||(g(d.$$.fragment,t),g(J.$$.fragment,t),g(f.$$.fragment,t),g(b.$$.fragment,t),g($.$$.fragment,t),g(C.$$.fragment,t),g(k.$$.fragment,t),g(A.$$.fragment,t),g(E.$$.fragment,t),g(G.$$.fragment,t),g(N.$$.fragment,t),gt=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(k.$$.fragment,t),h(A.$$.fragment,t),h(E.$$.fragment,t),h(G.$$.fragment,t),h(N.$$.fragment,t),gt=!1},d(t){t&&(e(_),e(R),e(V),e(H),e(y),e(S),e(u),e(z),e(F),e(w),e(D),e(L),e(T),e(q),e(P),e(U),e(K),e(O),e(Z),e(tt),e(st),e(I),e(et),e(x),e(at),e(lt),e(W),e(nt),e(pt),e(B),e(it),e(mt),e(v),e(ot),e(rt),e(ct),e(Q)),e(j),M(d,t),M(J,t),M(f,t),M(b,t),M($,t),M(C,t),M(k,t),M(A,t),M(E,t),M(G,t),M(N,t)}}}const vt='{"title":"Deep Layer Aggregation","local":"deep-layer-aggregation","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Gt(ht){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends kt{constructor(j){super(),Wt(this,j,Gt,Et,Ct,{})}}export{Yt as component};
