import{s as _s,n as Bs,o as Gs}from"../chunks/scheduler.85c25b89.js";import{S as Ns,i as Qs,g as m,s as l,r as i,m as Rs,H as Es,A as Vs,h as p,f as t,c as n,j as ys,u as o,x as r,n as Ys,E as Xs,k as vs,y as js,a as e,v as c,d as h,t as g,w as d}from"../chunks/index.c9bcf812.js";import{C as E}from"../chunks/CodeBlock.94efc595.js";import{H as X}from"../chunks/Heading.3c6e5b17.js";function zs(Js){let M,z,V,H,y,S,w,R,us="RegNetX",ws,A,Zs='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>j</mi><mo>=</mo><mi>w</mi><mi mathvariant="normal">_</mi><mn>0</mn><mo>+</mo><mi>w</mi><mi mathvariant="normal">_</mi><mi>a</mi><mo>⋅</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> u\\_{j} = w\\_{0} + w\\_{a}\\cdot{j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9695em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9544em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord">0</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7545em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord"><span class="mord mathnormal">a</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">⋅</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span></span></span>',F,j,Ts="For <strong>RegNetX</strong> we have additional restrictions: we set $b = 1$ (the bottleneck ratio), $12 \\leq d \\leq 28$, and $w_{m} \\geq 2$ (the width multiplier).",L,J,D,u,fs="To load a pretrained model:",q,T,P,f,bs="To load and preprocess the image:",K,b,O,U,Us="To get the model predictions:",ss,$,as,I,$s="To get the top-5 predictions class names:",ts,x,es,C,Is="Replace the model name with the variant you want to use, e.g. <code>regnetx_002</code>. You can find the IDs in the model summaries at the top of this page.",ls,k,xs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ns,W,ms,v,Cs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,Z,is,_,ks=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,os,B,rs,G,Ws='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',cs,N,hs,Q,gs,Y,ds;return y=new X({props:{title:"RegNetX",local:"regnetx",headingTag:"h1"}}),J=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new E({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlZ25ldHhfMDAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnetx_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new E({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new E({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),Z=new E({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVnbmV0eF8wMDInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;regnetx_002&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new E({props:{code:"JTQwbWlzYyU3QnJhZG9zYXZvdmljMjAyMGRlc2lnbmluZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRGVzaWduaW5nJTIwTmV0d29yayUyMERlc2lnbiUyMFNwYWNlcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QklsaWphJTIwUmFkb3Nhdm92aWMlMjBhbmQlMjBSYWolMjBQcmF0ZWVrJTIwS29zYXJhanUlMjBhbmQlMjBSb3NzJTIwR2lyc2hpY2slMjBhbmQlMjBLYWltaW5nJTIwSGUlMjBhbmQlMjBQaW90ciUyMERvbGwlQzMlQTFyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjc4JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{radosavovic2020designing,
      title={Designing Network Design Spaces}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Ilija Radosavovic and Raj Prateek Kosaraju and Ross Girshick and Kaiming He and Piotr Dollár}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2003.13678}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){M=m("meta"),z=l(),V=m("p"),H=l(),i(y.$$.fragment),S=l(),w=m("p"),R=m("strong"),R.textContent=us,ws=Rs(` is a convolutional network design space with simple, regular models with parameters: depth $d$, initial width $w_{0} > 0$, and slope $w_{a} > 0$, and generates a different block width $u_{j}$ for each block $j < d$. The key restriction for the RegNet types of model is that there is a linear parameterisation of block widths (the design space only contains models with this linear structure):
`),A=new Es(!1),F=l(),j=m("p"),j.innerHTML=Ts,L=l(),i(J.$$.fragment),D=l(),u=m("p"),u.textContent=fs,q=l(),i(T.$$.fragment),P=l(),f=m("p"),f.textContent=bs,K=l(),i(b.$$.fragment),O=l(),U=m("p"),U.textContent=Us,ss=l(),i($.$$.fragment),as=l(),I=m("p"),I.textContent=$s,ts=l(),i(x.$$.fragment),es=l(),C=m("p"),C.innerHTML=Is,ls=l(),k=m("p"),k.innerHTML=xs,ns=l(),i(W.$$.fragment),ms=l(),v=m("p"),v.textContent=Cs,ps=l(),i(Z.$$.fragment),is=l(),_=m("p"),_.innerHTML=ks,os=l(),i(B.$$.fragment),rs=l(),G=m("p"),G.innerHTML=Ws,cs=l(),i(N.$$.fragment),hs=l(),i(Q.$$.fragment),gs=l(),Y=m("p"),this.h()},l(s){const a=Vs("svelte-u9bgzb",document.head);M=p(a,"META",{name:!0,content:!0}),a.forEach(t),z=n(s),V=p(s,"P",{}),ys(V).forEach(t),H=n(s),o(y.$$.fragment,s),S=n(s),w=p(s,"P",{});var Ms=ys(w);R=p(Ms,"STRONG",{"data-svelte-h":!0}),r(R)!=="svelte-150637r"&&(R.textContent=us),ws=Ys(Ms,` is a convolutional network design space with simple, regular models with parameters: depth $d$, initial width $w_{0} > 0$, and slope $w_{a} > 0$, and generates a different block width $u_{j}$ for each block $j < d$. The key restriction for the RegNet types of model is that there is a linear parameterisation of block widths (the design space only contains models with this linear structure):
`),A=Xs(Ms,!1),Ms.forEach(t),F=n(s),j=p(s,"P",{"data-svelte-h":!0}),r(j)!=="svelte-mi3jox"&&(j.innerHTML=Ts),L=n(s),o(J.$$.fragment,s),D=n(s),u=p(s,"P",{"data-svelte-h":!0}),r(u)!=="svelte-18ywhxh"&&(u.textContent=fs),q=n(s),o(T.$$.fragment,s),P=n(s),f=p(s,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1c2ipa8"&&(f.textContent=bs),K=n(s),o(b.$$.fragment,s),O=n(s),U=p(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=Us),ss=n(s),o($.$$.fragment,s),as=n(s),I=p(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-19cnvx1"&&(I.textContent=$s),ts=n(s),o(x.$$.fragment,s),es=n(s),C=p(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-o836lw"&&(C.innerHTML=Is),ls=n(s),k=p(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1wmi3ea"&&(k.innerHTML=xs),ns=n(s),o(W.$$.fragment,s),ms=n(s),v=p(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-9sr7nh"&&(v.textContent=Cs),ps=n(s),o(Z.$$.fragment,s),is=n(s),_=p(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1kguc51"&&(_.innerHTML=ks),os=n(s),o(B.$$.fragment,s),rs=n(s),G=p(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1n0coha"&&(G.innerHTML=Ws),cs=n(s),o(N.$$.fragment,s),hs=n(s),o(Q.$$.fragment,s),gs=n(s),Y=p(s,"P",{}),ys(Y).forEach(t),this.h()},h(){vs(M,"name","hf:doc:metadata"),vs(M,"content",Hs),A.a=null},m(s,a){js(document.head,M),e(s,z,a),e(s,V,a),e(s,H,a),c(y,s,a),e(s,S,a),e(s,w,a),js(w,R),js(w,ws),A.m(Zs,w),e(s,F,a),e(s,j,a),e(s,L,a),c(J,s,a),e(s,D,a),e(s,u,a),e(s,q,a),c(T,s,a),e(s,P,a),e(s,f,a),e(s,K,a),c(b,s,a),e(s,O,a),e(s,U,a),e(s,ss,a),c($,s,a),e(s,as,a),e(s,I,a),e(s,ts,a),c(x,s,a),e(s,es,a),e(s,C,a),e(s,ls,a),e(s,k,a),e(s,ns,a),c(W,s,a),e(s,ms,a),e(s,v,a),e(s,ps,a),c(Z,s,a),e(s,is,a),e(s,_,a),e(s,os,a),c(B,s,a),e(s,rs,a),e(s,G,a),e(s,cs,a),c(N,s,a),e(s,hs,a),c(Q,s,a),e(s,gs,a),e(s,Y,a),ds=!0},p:Bs,i(s){ds||(h(y.$$.fragment,s),h(J.$$.fragment,s),h(T.$$.fragment,s),h(b.$$.fragment,s),h($.$$.fragment,s),h(x.$$.fragment,s),h(W.$$.fragment,s),h(Z.$$.fragment,s),h(B.$$.fragment,s),h(N.$$.fragment,s),h(Q.$$.fragment,s),ds=!0)},o(s){g(y.$$.fragment,s),g(J.$$.fragment,s),g(T.$$.fragment,s),g(b.$$.fragment,s),g($.$$.fragment,s),g(x.$$.fragment,s),g(W.$$.fragment,s),g(Z.$$.fragment,s),g(B.$$.fragment,s),g(N.$$.fragment,s),g(Q.$$.fragment,s),ds=!1},d(s){s&&(t(z),t(V),t(H),t(S),t(w),t(F),t(j),t(L),t(D),t(u),t(q),t(P),t(f),t(K),t(O),t(U),t(ss),t(as),t(I),t(ts),t(es),t(C),t(ls),t(k),t(ns),t(ms),t(v),t(ps),t(is),t(_),t(os),t(rs),t(G),t(cs),t(hs),t(gs),t(Y)),t(M),d(y,s),d(J,s),d(T,s),d(b,s),d($,s),d(x,s),d(W,s),d(Z,s),d(B,s),d(N,s),d(Q,s)}}}const Hs='{"title":"RegNetX","local":"regnetx","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ss(Js){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qs extends Ns{constructor(M){super(),Qs(this,M,Ss,zs,_s,{})}}export{qs as component};
