import{s as zt,f as Ut,o as $t,n as Ve}from"../chunks/scheduler.25b97de1.js";import{S as Jt,i as Nt,g as l,s as n,r as h,A as qt,h as c,f as t,c as s,j as z,u,x as g,k as M,y as d,a as r,v as f,d as _,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as It}from"../chunks/Tip.baa67368.js";import{D as R}from"../chunks/Docstring.ffac8efa.js";import{C as Go}from"../chunks/CodeBlock.e6cd0d95.js";import{E as et}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Z,E as Rt}from"../chunks/EditOnGithub.91d95064.js";function Zt(k){let a,T="Examples:",m,p,w;return p=new Go({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdyb3VuZGluZ0Rpbm9Db25maWclMkMlMjBHcm91bmRpbmdEaW5vTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR3JvdW5kaW5nJTIwRElOTyUyMElERUEtUmVzZWFyY2glMkZncm91bmRpbmctZGluby10aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEdyb3VuZGluZ0Rpbm9Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwSURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdyb3VuZGluZ0Rpbm9Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GroundingDinoConfig, GroundingDinoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Grounding DINO IDEA-Research/grounding-dino-tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GroundingDinoConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the IDEA-Research/grounding-dino-tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GroundingDinoModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=l("p"),a.textContent=T,m=n(),h(p.$$.fragment)},l(i){a=c(i,"P",{"data-svelte-h":!0}),g(a)!=="svelte-kvfsh7"&&(a.textContent=T),m=s(i),u(p.$$.fragment,i)},m(i,v){r(i,a,v),r(i,m,v),f(p,i,v),w=!0},p:Ve,i(i){w||(_(p.$$.fragment,i),w=!0)},o(i){b(p.$$.fragment,i),w=!1},d(i){i&&(t(a),t(m)),y(p,i)}}}function Ft(k){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=T},l(m){a=c(m,"P",{"data-svelte-h":!0}),g(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(m,p){r(m,a,p)},p:Ve,d(m){m&&t(a)}}}function Et(k){let a,T="Examples:",m,p,w;return p=new Go({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEF0ZXh0JTIwJTNEJTIwJTIyYSUyMGNhdC4lMjIlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJREVBLVJlc2VhcmNoJTJGZ3JvdW5kaW5nLWRpbm8tdGlueSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;a cat.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">900</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=T,m=n(),h(p.$$.fragment)},l(i){a=c(i,"P",{"data-svelte-h":!0}),g(a)!=="svelte-kvfsh7"&&(a.textContent=T),m=s(i),u(p.$$.fragment,i)},m(i,v){r(i,a,v),r(i,m,v),f(p,i,v),w=!0},p:Ve,i(i){w||(_(p.$$.fragment,i),w=!0)},o(i){b(p.$$.fragment,i),w=!1},d(i){i&&(t(a),t(m)),y(p,i)}}}function Pt(k){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=T},l(m){a=c(m,"P",{"data-svelte-h":!0}),g(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(m,p){r(m,a,p)},p:Ve,d(m){m&&t(a)}}}function Wt(k){let a,T="Examples:",m,p,w;return p=new Go({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(image_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Check for cats and remote controls</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a remote control&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    threshold=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    text_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Retrieve the first image result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(x, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.479</span> at location [<span class="hljs-number">344.7</span>, <span class="hljs-number">23.11</span>, <span class="hljs-number">637.18</span>, <span class="hljs-number">374.28</span>]
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.438</span> at location [<span class="hljs-number">12.27</span>, <span class="hljs-number">51.91</span>, <span class="hljs-number">316.86</span>, <span class="hljs-number">472.44</span>]
Detected a remote control <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.478</span> at location [<span class="hljs-number">38.57</span>, <span class="hljs-number">70.0</span>, <span class="hljs-number">176.78</span>, <span class="hljs-number">118.18</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=T,m=n(),h(p.$$.fragment)},l(i){a=c(i,"P",{"data-svelte-h":!0}),g(a)!=="svelte-kvfsh7"&&(a.textContent=T),m=s(i),u(p.$$.fragment,i)},m(i,v){r(i,a,v),r(i,m,v),f(p,i,v),w=!0},p:Ve,i(i){w||(_(p.$$.fragment,i),w=!0)},o(i){b(p.$$.fragment,i),w=!1},d(i){i&&(t(a),t(m)),y(p,i)}}}function Lt(k){let a,T,m,p,w,i,v,Qe,Y,ot='The Grounding DINO model was proposed in <a href="https://arxiv.org/abs/2303.05499" rel="nofollow">Grounding DINO: Marrying DINO with Grounded Pre-Training for Open-Set Object Detection</a> by Shilong Liu, Zhaoyang Zeng, Tianhe Ren, Feng Li, Hao Zhang, Jie Yang, Chunyuan Li, Jianwei Yang, Hang Su, Jun Zhu, Lei Zhang. Grounding DINO extends a closed-set object detection model with a text encoder, enabling open-set object detection. The model achieves remarkable results, such as 52.5 AP on COCO zero-shot.',Xe,K,tt="The abstract from the paper is the following:",Ye,ee,nt="<em>In this paper, we present an open-set object detector, called Grounding DINO, by marrying Transformer-based detector DINO with grounded pre-training, which can detect arbitrary objects with human inputs such as category names or referring expressions. The key solution of open-set object detection is introducing language to a closed-set detector for open-set concept generalization. To effectively fuse language and vision modalities, we conceptually divide a closed-set detector into three phases and propose a tight fusion solution, which includes a feature enhancer, a language-guided query selection, and a cross-modality decoder for cross-modality fusion. While previous works mainly evaluate open-set object detection on novel categories, we propose to also perform evaluations on referring expression comprehension for objects specified with attributes. Grounding DINO performs remarkably well on all three settings, including benchmarks on COCO, LVIS, ODinW, and RefCOCO/+/g. Grounding DINO achieves a 52.5 AP on the COCO detection zero-shot transfer benchmark, i.e., without any training data from COCO. It sets a new record on the ODinW zero-shot benchmark with a mean 26.1 AP.</em>",Ke,F,st,eo,oe,rt='Grounding DINO overview. Taken from the <a href="https://arxiv.org/abs/2303.05499">original paper</a>.',oo,te,at=`This model was contributed by <a href="https://huggingface.co/EduardoPacheco" rel="nofollow">EduardoPacheco</a> and <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/IDEA-Research/GroundingDINO" rel="nofollow">here</a>.`,to,ne,no,se,it='<li>One can use <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> to prepare image-text pairs for the model.</li> <li>To separate classes in the text use a period e.g. “a cat. a dog.”</li> <li>When using multiple classes (e.g. <code>&quot;a cat. a dog.&quot;</code>), use <code>post_process_grounded_object_detection</code> from <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> to post process outputs. Since, the labels returned from <code>post_process_object_detection</code> represent the indices from the model dimension where prob &gt; threshold.</li>',so,re,dt="Here’s how to use the model for zero-shot object detection:",ro,ae,ao,ie,io,de,lt='One can combine Grounding DINO with the <a href="sam">Segment Anything</a> model for text-based mask generation as introduced in <a href="https://arxiv.org/abs/2401.14159" rel="nofollow">Grounded SAM: Assembling Open-World Models for Diverse Visual Tasks</a>. You can refer to this <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Grounding%20DINO/GroundingDINO_with_Segment_Anything.ipynb" rel="nofollow">demo notebook</a> 🌍 for details.',lo,E,ct,co,le,mt='Grounded SAM overview. Taken from the <a href="https://github.com/IDEA-Research/Grounded-Segment-Anything">original repository</a>.',mo,ce,po,me,pt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Grounding DINO. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",go,pe,gt='<li>Demo notebooks regarding inference with Grounding DINO as well as combining it with <a href="sam">SAM</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Grounding%20DINO" rel="nofollow">here</a>. 🌎</li>',ho,ge,uo,D,he,Co,ze,ht="Constructs a Grounding DINO image processor.",ko,P,ue,Uo,$e,ut="Preprocess an image or a batch of images so that it can be used by the model.",Io,W,fe,zo,Je,ft=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,fo,_e,_o,G,be,$o,Ne,_t=`Constructs a Grounding DINO processor which wraps a Deformable DETR image processor and a BERT tokenizer into a
single processor.`,Jo,qe,bt=`<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoImageProcessor">GroundingDinoImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See the docstring of <code>__call__()</code> and <code>decode()</code>
for more information.`,No,L,ye,qo,Re,yt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format and get the associated text label.`,bo,we,yo,C,Te,Ro,Ze,wt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a>. It is used to instantiate a
Grounding DINO model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Grounding DINO
<a href="https://huggingface.co/IDEA-Research/grounding-dino-tiny" rel="nofollow">IDEA-Research/grounding-dino-tiny</a> architecture.`,Zo,Fe,Tt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fo,B,wo,ve,To,x,Me,Eo,Ee,vt=`The bare Grounding DINO Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,Po,Pe,Mt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wo,We,xt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Lo,U,xe,Bo,Le,jt='The <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a> forward method, overrides the <code>__call__</code> special method.',So,S,Ho,H,vo,je,Mo,j,De,Oo,Be,Dt=`Grounding DINO Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on top,
for tasks such as COCO detection.`,Ao,Se,Gt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vo,He,Ct=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qo,I,Ge,Xo,Oe,kt='The <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Yo,O,Ko,A,xo,Ce,jo,Ae,Do;return w=new Z({props:{title:"Grounding DINO",local:"grounding-dino",headingTag:"h1"}}),v=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new Z({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ae=new Go({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(image_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Check for cats and remote controls</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a remote control&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    inputs.input_ids,
<span class="hljs-meta">... </span>    box_threshold=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    text_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Retrieve the first image result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, labels <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;labels&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(x, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{labels}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.468</span> at location [<span class="hljs-number">344.78</span>, <span class="hljs-number">22.9</span>, <span class="hljs-number">637.3</span>, <span class="hljs-number">373.62</span>]
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.426</span> at location [<span class="hljs-number">11.74</span>, <span class="hljs-number">51.55</span>, <span class="hljs-number">316.51</span>, <span class="hljs-number">473.22</span>]`,wrap:!1}}),ie=new Z({props:{title:"Grounded SAM",local:"grounded-sam",headingTag:"h2"}}),ce=new Z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ge=new Z({props:{title:"GroundingDinoImageProcessor",local:"transformers.GroundingDinoImageProcessor",headingTag:"h2"}}),he=new R({props:{name:"class transformers.GroundingDinoImageProcessor",anchor:"transformers.GroundingDinoImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.grounding_dino.image_processing_grounding_dino.AnnotationFormat] = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method. Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code>
parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L841"}}),ue=new R({props:{name:"preprocess",anchor:"transformers.GroundingDinoImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.grounding_dino.image_processing_grounding_dino.AnnotationFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L1301"}}),fe=new R({props:{name:"post_process_object_detection",anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:": GroundingDinoObjectDetectionOutput"},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>GroundingDinoObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.GroundingDinoImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L1566",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“labels”: Indexes of the classes predicted by the model on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),_e=new Z({props:{title:"GroundingDinoProcessor",local:"transformers.GroundingDinoProcessor",headingTag:"h2"}}),be=new R({props:{name:"class transformers.GroundingDinoProcessor",anchor:"transformers.GroundingDinoProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoProcessor.image_processor",description:`<strong>image_processor</strong> (<code>GroundingDinoImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoImageProcessor">GroundingDinoImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.GroundingDinoProcessor.tokenizer",description:"<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;\nAn instance of [&#x2018;PreTrainedTokenizer`]. The tokenizer is a required input.",name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/processing_grounding_dino.py#L129"}}),ye=new R({props:{name:"post_process_grounded_object_detection",anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:": GroundingDinoObjectDetectionOutput"},{name:"input_ids",val:": typing.Optional[transformers.utils.generic.TensorType] = None"},{name:"threshold",val:": float = 0.25"},{name:"text_threshold",val:": float = 0.25"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"},{name:"text_labels",val:": typing.Optional[typing.List[typing.List[str]]] = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>GroundingDinoObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The token ids of the input text. If not provided will be taken from the model output.`,name:"input_ids"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Threshold to keep object detection predictions based on confidence score.`,name:"threshold"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.text_threshold",description:`<strong>text_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Score threshold to keep text detection predictions.`,name:"text_threshold"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.text_labels",description:`<strong>text_labels</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
List of candidate labels to be detected on each image. At the moment it&#x2019;s <em>NOT used</em>, but required
to be in signature for the zero-shot object detection pipeline. Text labels are instead extracted
from the <code>input_ids</code> tensor provided in <code>outputs</code>.`,name:"text_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/processing_grounding_dino.py#L242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the</p>
<ul>
<li><strong>scores</strong>: tensor of confidence scores for detected objects</li>
<li><strong>boxes</strong>: tensor of bounding boxes in [x0, y0, x1, y1] format</li>
<li><strong>labels</strong>: list of text labels for each detected object (will be replaced with integer ids in v4.51.0)</li>
<li><strong>text_labels</strong>: list of text labels for detected objects</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),we=new Z({props:{title:"GroundingDinoConfig",local:"transformers.GroundingDinoConfig",headingTag:"h2"}}),Te=new R({props:{name:"class transformers.GroundingDinoConfig",anchor:"transformers.GroundingDinoConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"text_config",val:" = None"},{name:"num_queries",val:" = 900"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"num_feature_levels",val:" = 4"},{name:"encoder_n_points",val:" = 4"},{name:"decoder_n_points",val:" = 4"},{name:"two_stage",val:" = True"},{name:"class_cost",val:" = 1.0"},{name:"bbox_cost",val:" = 5.0"},{name:"giou_cost",val:" = 2.0"},{name:"bbox_loss_coefficient",val:" = 5.0"},{name:"giou_loss_coefficient",val:" = 2.0"},{name:"focal_alpha",val:" = 0.25"},{name:"disable_custom_kernels",val:" = False"},{name:"max_text_len",val:" = 256"},{name:"text_enhancer_dropout",val:" = 0.0"},{name:"fusion_droppath",val:" = 0.1"},{name:"fusion_dropout",val:" = 0.0"},{name:"embedding_init_target",val:" = True"},{name:"query_dim",val:" = 4"},{name:"decoder_bbox_embed_share",val:" = True"},{name:"two_stage_bbox_embed_share",val:" = False"},{name:"positional_embedding_temperature",val:" = 20"},{name:"init_std",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>ResNetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.GroundingDinoConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.GroundingDinoConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.GroundingDinoConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.GroundingDinoConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.GroundingDinoConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>BertConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.GroundingDinoConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 900) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a> can detect in a single image.`,name:"num_queries"},{anchor:"transformers.GroundingDinoConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.GroundingDinoConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.GroundingDinoConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.GroundingDinoConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.GroundingDinoConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.GroundingDinoConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.GroundingDinoConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.GroundingDinoConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.GroundingDinoConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.GroundingDinoConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.GroundingDinoConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.GroundingDinoConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.GroundingDinoConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.GroundingDinoConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.GroundingDinoConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of input feature levels.`,name:"num_feature_levels"},{anchor:"transformers.GroundingDinoConfig.encoder_n_points",description:`<strong>encoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the encoder.`,name:"encoder_n_points"},{anchor:"transformers.GroundingDinoConfig.decoder_n_points",description:`<strong>decoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the decoder.`,name:"decoder_n_points"},{anchor:"transformers.GroundingDinoConfig.two_stage",description:`<strong>two_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply a two-stage deformable DETR, where the region proposals are also generated by a variant of
Grounding DINO, which are further fed into the decoder for iterative bounding box refinement.`,name:"two_stage"},{anchor:"transformers.GroundingDinoConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.GroundingDinoConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.GroundingDinoConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.GroundingDinoConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.GroundingDinoConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.GroundingDinoConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.GroundingDinoConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Disable the use of custom CUDA and CPU kernels. This option is necessary for the ONNX export, as custom
kernels are not supported by PyTorch ONNX export.`,name:"disable_custom_kernels"},{anchor:"transformers.GroundingDinoConfig.max_text_len",description:`<strong>max_text_len</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum length of the text input.`,name:"max_text_len"},{anchor:"transformers.GroundingDinoConfig.text_enhancer_dropout",description:`<strong>text_enhancer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the text enhancer.`,name:"text_enhancer_dropout"},{anchor:"transformers.GroundingDinoConfig.fusion_droppath",description:`<strong>fusion_droppath</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The droppath ratio for the fusion module.`,name:"fusion_droppath"},{anchor:"transformers.GroundingDinoConfig.fusion_dropout",description:`<strong>fusion_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the fusion module.`,name:"fusion_dropout"},{anchor:"transformers.GroundingDinoConfig.embedding_init_target",description:`<strong>embedding_init_target</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to initialize the target with Embedding weights.`,name:"embedding_init_target"},{anchor:"transformers.GroundingDinoConfig.query_dim",description:`<strong>query_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The dimension of the query vector.`,name:"query_dim"},{anchor:"transformers.GroundingDinoConfig.decoder_bbox_embed_share",description:`<strong>decoder_bbox_embed_share</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to share the bbox regression head for all decoder layers.`,name:"decoder_bbox_embed_share"},{anchor:"transformers.GroundingDinoConfig.two_stage_bbox_embed_share",description:`<strong>two_stage_bbox_embed_share</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to share the bbox embedding between the two-stage bbox generator and the region proposal
generation.`,name:"two_stage_bbox_embed_share"},{anchor:"transformers.GroundingDinoConfig.positional_embedding_temperature",description:`<strong>positional_embedding_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 20) &#x2014;
The temperature for Sine Positional Embedding that is used together with vision backbone.`,name:"positional_embedding_temperature"},{anchor:"transformers.GroundingDinoConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.GroundingDinoConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/configuration_grounding_dino.py#L26"}}),B=new et({props:{anchor:"transformers.GroundingDinoConfig.example",$$slots:{default:[Zt]},$$scope:{ctx:k}}}),ve=new Z({props:{title:"GroundingDinoModel",local:"transformers.GroundingDinoModel",headingTag:"h2"}}),Me=new R({props:{name:"class transformers.GroundingDinoModel",anchor:"transformers.GroundingDinoModel",parameters:[{name:"config",val:": GroundingDinoConfig"}],parametersDescription:[{anchor:"transformers.GroundingDinoModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig">GroundingDinoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2062"}}),xe=new R({props:{name:"forward",anchor:"transformers.GroundingDinoModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"input_ids",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:" = None"},{name:"output_attentions",val:" = None"},{name:"output_hidden_states",val:" = None"},{name:"return_dict",val:" = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">GroundingDinoImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.GroundingDinoModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">BertTokenizer.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.GroundingDinoModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: 0 corresponds to a <code>sentence A</code> token, 1 corresponds to a <code>sentence B</code> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GroundingDinoModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for tokens that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GroundingDinoModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.GroundingDinoModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state_vision</code>, <em>optional</em>: <code>last_hidden_state_text</code>, <em>optional</em>:
<code>vision_hidden_states</code>, <em>optional</em>: <code>text_hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state_vision</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence
of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the
decoder.`,name:"encoder_outputs"},{anchor:"transformers.GroundingDinoModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GroundingDinoModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GroundingDinoModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2217",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig"
>GroundingDinoConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_last_hidden_state_vision</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_last_hidden_state_text</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_vision_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the vision embeddings + one for the output of each
layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the vision encoder at the
output of each layer plus the initial embedding outputs.</li>
<li><strong>encoder_text_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the text embeddings + one for the output of each layer)
of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the text encoder at the output of
each layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the text-vision attention, vision-text attention, text-enhancer (self-attention) and
multi-scale deformable attention heads. attention softmax, used to compute the weighted average in the
bi-attention heads.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.num_queries</code> scoring bounding boxes are picked as
region proposals in the first stage. Output of bounding box binary classification (i.e. foreground and
background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new It({props:{$$slots:{default:[Ft]},$$scope:{ctx:k}}}),H=new et({props:{anchor:"transformers.GroundingDinoModel.forward.example",$$slots:{default:[Et]},$$scope:{ctx:k}}}),je=new Z({props:{title:"GroundingDinoForObjectDetection",local:"transformers.GroundingDinoForObjectDetection",headingTag:"h2"}}),De=new R({props:{name:"class transformers.GroundingDinoForObjectDetection",anchor:"transformers.GroundingDinoForObjectDetection",parameters:[{name:"config",val:": GroundingDinoConfig"}],parametersDescription:[{anchor:"transformers.GroundingDinoForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig">GroundingDinoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2479"}}),Ge=new R({props:{name:"forward",anchor:"transformers.GroundingDinoForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"input_ids",val:": LongTensor"},{name:"token_type_ids",val:": LongTensor = None"},{name:"attention_mask",val:": LongTensor = None"},{name:"pixel_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Union[transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoEncoderOutput, typing.Tuple, NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.List[typing.Dict[str, typing.Union[torch.LongTensor, torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">GroundingDinoImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">BertTokenizer.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: 0 corresponds to a <code>sentence A</code> token, 1 corresponds to a <code>sentence B</code> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for tokens that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state_vision</code>, <em>optional</em>: <code>last_hidden_state_text</code>, <em>optional</em>:
<code>vision_hidden_states</code>, <em>optional</em>: <code>text_hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state_vision</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence
of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the
decoder.`,name:"encoder_outputs"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2525",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig"
>GroundingDinoConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor.post_process_grounded_object_detection"
>post_process_grounded_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>List[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_last_hidden_state_vision</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_last_hidden_state_text</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_vision_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the vision embeddings + one for the output of each
layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the vision encoder at the
output of each layer plus the initial embedding outputs.</li>
<li><strong>encoder_text_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the text embeddings + one for the output of each layer)
of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the text encoder at the output of
each layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the text-vision attention, vision-text attention, text-enhancer (self-attention) and
multi-scale deformable attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.num_queries</code> scoring bounding boxes are picked as
region proposals in the first stage. Output of bounding box binary classification (i.e. foreground and
background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
<li><strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) — Encoded candidate labels sequence. Used in processor to post process object detection result.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new It({props:{$$slots:{default:[Pt]},$$scope:{ctx:k}}}),A=new et({props:{anchor:"transformers.GroundingDinoForObjectDetection.forward.example",$$slots:{default:[Wt]},$$scope:{ctx:k}}}),Ce=new Rt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/grounding-dino.md"}}),{c(){a=l("meta"),T=n(),m=l("p"),p=n(),h(w.$$.fragment),i=n(),h(v.$$.fragment),Qe=n(),Y=l("p"),Y.innerHTML=ot,Xe=n(),K=l("p"),K.textContent=tt,Ye=n(),ee=l("p"),ee.innerHTML=nt,Ke=n(),F=l("img"),eo=n(),oe=l("small"),oe.innerHTML=rt,oo=n(),te=l("p"),te.innerHTML=at,to=n(),h(ne.$$.fragment),no=n(),se=l("ul"),se.innerHTML=it,so=n(),re=l("p"),re.textContent=dt,ro=n(),h(ae.$$.fragment),ao=n(),h(ie.$$.fragment),io=n(),de=l("p"),de.innerHTML=lt,lo=n(),E=l("img"),co=n(),le=l("small"),le.innerHTML=mt,mo=n(),h(ce.$$.fragment),po=n(),me=l("p"),me.textContent=pt,go=n(),pe=l("ul"),pe.innerHTML=gt,ho=n(),h(ge.$$.fragment),uo=n(),D=l("div"),h(he.$$.fragment),Co=n(),ze=l("p"),ze.textContent=ht,ko=n(),P=l("div"),h(ue.$$.fragment),Uo=n(),$e=l("p"),$e.textContent=ut,Io=n(),W=l("div"),h(fe.$$.fragment),zo=n(),Je=l("p"),Je.innerHTML=ft,fo=n(),h(_e.$$.fragment),_o=n(),G=l("div"),h(be.$$.fragment),$o=n(),Ne=l("p"),Ne.textContent=_t,Jo=n(),qe=l("p"),qe.innerHTML=bt,No=n(),L=l("div"),h(ye.$$.fragment),qo=n(),Re=l("p"),Re.innerHTML=yt,bo=n(),h(we.$$.fragment),yo=n(),C=l("div"),h(Te.$$.fragment),Ro=n(),Ze=l("p"),Ze.innerHTML=wt,Zo=n(),Fe=l("p"),Fe.innerHTML=Tt,Fo=n(),h(B.$$.fragment),wo=n(),h(ve.$$.fragment),To=n(),x=l("div"),h(Me.$$.fragment),Eo=n(),Ee=l("p"),Ee.textContent=vt,Po=n(),Pe=l("p"),Pe.innerHTML=Mt,Wo=n(),We=l("p"),We.innerHTML=xt,Lo=n(),U=l("div"),h(xe.$$.fragment),Bo=n(),Le=l("p"),Le.innerHTML=jt,So=n(),h(S.$$.fragment),Ho=n(),h(H.$$.fragment),vo=n(),h(je.$$.fragment),Mo=n(),j=l("div"),h(De.$$.fragment),Oo=n(),Be=l("p"),Be.textContent=Dt,Ao=n(),Se=l("p"),Se.innerHTML=Gt,Vo=n(),He=l("p"),He.innerHTML=Ct,Qo=n(),I=l("div"),h(Ge.$$.fragment),Xo=n(),Oe=l("p"),Oe.innerHTML=kt,Yo=n(),h(O.$$.fragment),Ko=n(),h(A.$$.fragment),xo=n(),h(Ce.$$.fragment),jo=n(),Ae=l("p"),this.h()},l(e){const o=qt("svelte-u9bgzb",document.head);a=c(o,"META",{name:!0,content:!0}),o.forEach(t),T=s(e),m=c(e,"P",{}),z(m).forEach(t),p=s(e),u(w.$$.fragment,e),i=s(e),u(v.$$.fragment,e),Qe=s(e),Y=c(e,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1usvly6"&&(Y.innerHTML=ot),Xe=s(e),K=c(e,"P",{"data-svelte-h":!0}),g(K)!=="svelte-vfdo9a"&&(K.textContent=tt),Ye=s(e),ee=c(e,"P",{"data-svelte-h":!0}),g(ee)!=="svelte-14ayby0"&&(ee.innerHTML=nt),Ke=s(e),F=c(e,"IMG",{src:!0,alt:!0,width:!0}),eo=s(e),oe=c(e,"SMALL",{"data-svelte-h":!0}),g(oe)!=="svelte-1o9330u"&&(oe.innerHTML=rt),oo=s(e),te=c(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-1p2elqj"&&(te.innerHTML=at),to=s(e),u(ne.$$.fragment,e),no=s(e),se=c(e,"UL",{"data-svelte-h":!0}),g(se)!=="svelte-1omd7fu"&&(se.innerHTML=it),so=s(e),re=c(e,"P",{"data-svelte-h":!0}),g(re)!=="svelte-ffyfwo"&&(re.textContent=dt),ro=s(e),u(ae.$$.fragment,e),ao=s(e),u(ie.$$.fragment,e),io=s(e),de=c(e,"P",{"data-svelte-h":!0}),g(de)!=="svelte-1ewje5n"&&(de.innerHTML=lt),lo=s(e),E=c(e,"IMG",{src:!0,alt:!0,width:!0}),co=s(e),le=c(e,"SMALL",{"data-svelte-h":!0}),g(le)!=="svelte-16zie7b"&&(le.innerHTML=mt),mo=s(e),u(ce.$$.fragment,e),po=s(e),me=c(e,"P",{"data-svelte-h":!0}),g(me)!=="svelte-h29b2y"&&(me.textContent=pt),go=s(e),pe=c(e,"UL",{"data-svelte-h":!0}),g(pe)!=="svelte-1afawla"&&(pe.innerHTML=gt),ho=s(e),u(ge.$$.fragment,e),uo=s(e),D=c(e,"DIV",{class:!0});var $=z(D);u(he.$$.fragment,$),Co=s($),ze=c($,"P",{"data-svelte-h":!0}),g(ze)!=="svelte-1k24st3"&&(ze.textContent=ht),ko=s($),P=c($,"DIV",{class:!0});var ke=z(P);u(ue.$$.fragment,ke),Uo=s(ke),$e=c(ke,"P",{"data-svelte-h":!0}),g($e)!=="svelte-jgz2ra"&&($e.textContent=ut),ke.forEach(t),Io=s($),W=c($,"DIV",{class:!0});var Ue=z(W);u(fe.$$.fragment,Ue),zo=s(Ue),Je=c(Ue,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-ca0muk"&&(Je.innerHTML=ft),Ue.forEach(t),$.forEach(t),fo=s(e),u(_e.$$.fragment,e),_o=s(e),G=c(e,"DIV",{class:!0});var J=z(G);u(be.$$.fragment,J),$o=s(J),Ne=c(J,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-6v5vrh"&&(Ne.textContent=_t),Jo=s(J),qe=c(J,"P",{"data-svelte-h":!0}),g(qe)!=="svelte-1svcr55"&&(qe.innerHTML=bt),No=s(J),L=c(J,"DIV",{class:!0});var Ie=z(L);u(ye.$$.fragment,Ie),qo=s(Ie),Re=c(Ie,"P",{"data-svelte-h":!0}),g(Re)!=="svelte-kxzevl"&&(Re.innerHTML=yt),Ie.forEach(t),J.forEach(t),bo=s(e),u(we.$$.fragment,e),yo=s(e),C=c(e,"DIV",{class:!0});var V=z(C);u(Te.$$.fragment,V),Ro=s(V),Ze=c(V,"P",{"data-svelte-h":!0}),g(Ze)!=="svelte-14zgym3"&&(Ze.innerHTML=wt),Zo=s(V),Fe=c(V,"P",{"data-svelte-h":!0}),g(Fe)!=="svelte-o55m63"&&(Fe.innerHTML=Tt),Fo=s(V),u(B.$$.fragment,V),V.forEach(t),wo=s(e),u(ve.$$.fragment,e),To=s(e),x=c(e,"DIV",{class:!0});var N=z(x);u(Me.$$.fragment,N),Eo=s(N),Ee=c(N,"P",{"data-svelte-h":!0}),g(Ee)!=="svelte-7hyzcp"&&(Ee.textContent=vt),Po=s(N),Pe=c(N,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-6pahdo"&&(Pe.innerHTML=Mt),Wo=s(N),We=c(N,"P",{"data-svelte-h":!0}),g(We)!=="svelte-hswkmf"&&(We.innerHTML=xt),Lo=s(N),U=c(N,"DIV",{class:!0});var Q=z(U);u(xe.$$.fragment,Q),Bo=s(Q),Le=c(Q,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-1rg4rqf"&&(Le.innerHTML=jt),So=s(Q),u(S.$$.fragment,Q),Ho=s(Q),u(H.$$.fragment,Q),Q.forEach(t),N.forEach(t),vo=s(e),u(je.$$.fragment,e),Mo=s(e),j=c(e,"DIV",{class:!0});var q=z(j);u(De.$$.fragment,q),Oo=s(q),Be=c(q,"P",{"data-svelte-h":!0}),g(Be)!=="svelte-hgz8xq"&&(Be.textContent=Dt),Ao=s(q),Se=c(q,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-6pahdo"&&(Se.innerHTML=Gt),Vo=s(q),He=c(q,"P",{"data-svelte-h":!0}),g(He)!=="svelte-hswkmf"&&(He.innerHTML=Ct),Qo=s(q),I=c(q,"DIV",{class:!0});var X=z(I);u(Ge.$$.fragment,X),Xo=s(X),Oe=c(X,"P",{"data-svelte-h":!0}),g(Oe)!=="svelte-z24s13"&&(Oe.innerHTML=kt),Yo=s(X),u(O.$$.fragment,X),Ko=s(X),u(A.$$.fragment,X),X.forEach(t),q.forEach(t),xo=s(e),u(Ce.$$.fragment,e),jo=s(e),Ae=c(e,"P",{}),z(Ae).forEach(t),this.h()},h(){M(a,"name","hf:doc:metadata"),M(a,"content",Bt),Ut(F.src,st="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/grouding_dino_architecture.png")||M(F,"src",st),M(F,"alt","drawing"),M(F,"width","600"),Ut(E.src,ct="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/grounded_sam.png")||M(E,"src",ct),M(E,"alt","drawing"),M(E,"width","900"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){d(document.head,a),r(e,T,o),r(e,m,o),r(e,p,o),f(w,e,o),r(e,i,o),f(v,e,o),r(e,Qe,o),r(e,Y,o),r(e,Xe,o),r(e,K,o),r(e,Ye,o),r(e,ee,o),r(e,Ke,o),r(e,F,o),r(e,eo,o),r(e,oe,o),r(e,oo,o),r(e,te,o),r(e,to,o),f(ne,e,o),r(e,no,o),r(e,se,o),r(e,so,o),r(e,re,o),r(e,ro,o),f(ae,e,o),r(e,ao,o),f(ie,e,o),r(e,io,o),r(e,de,o),r(e,lo,o),r(e,E,o),r(e,co,o),r(e,le,o),r(e,mo,o),f(ce,e,o),r(e,po,o),r(e,me,o),r(e,go,o),r(e,pe,o),r(e,ho,o),f(ge,e,o),r(e,uo,o),r(e,D,o),f(he,D,null),d(D,Co),d(D,ze),d(D,ko),d(D,P),f(ue,P,null),d(P,Uo),d(P,$e),d(D,Io),d(D,W),f(fe,W,null),d(W,zo),d(W,Je),r(e,fo,o),f(_e,e,o),r(e,_o,o),r(e,G,o),f(be,G,null),d(G,$o),d(G,Ne),d(G,Jo),d(G,qe),d(G,No),d(G,L),f(ye,L,null),d(L,qo),d(L,Re),r(e,bo,o),f(we,e,o),r(e,yo,o),r(e,C,o),f(Te,C,null),d(C,Ro),d(C,Ze),d(C,Zo),d(C,Fe),d(C,Fo),f(B,C,null),r(e,wo,o),f(ve,e,o),r(e,To,o),r(e,x,o),f(Me,x,null),d(x,Eo),d(x,Ee),d(x,Po),d(x,Pe),d(x,Wo),d(x,We),d(x,Lo),d(x,U),f(xe,U,null),d(U,Bo),d(U,Le),d(U,So),f(S,U,null),d(U,Ho),f(H,U,null),r(e,vo,o),f(je,e,o),r(e,Mo,o),r(e,j,o),f(De,j,null),d(j,Oo),d(j,Be),d(j,Ao),d(j,Se),d(j,Vo),d(j,He),d(j,Qo),d(j,I),f(Ge,I,null),d(I,Xo),d(I,Oe),d(I,Yo),f(O,I,null),d(I,Ko),f(A,I,null),r(e,xo,o),f(Ce,e,o),r(e,jo,o),r(e,Ae,o),Do=!0},p(e,[o]){const $={};o&2&&($.$$scope={dirty:o,ctx:e}),B.$set($);const ke={};o&2&&(ke.$$scope={dirty:o,ctx:e}),S.$set(ke);const Ue={};o&2&&(Ue.$$scope={dirty:o,ctx:e}),H.$set(Ue);const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),O.$set(J);const Ie={};o&2&&(Ie.$$scope={dirty:o,ctx:e}),A.$set(Ie)},i(e){Do||(_(w.$$.fragment,e),_(v.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(Te.$$.fragment,e),_(B.$$.fragment,e),_(ve.$$.fragment,e),_(Me.$$.fragment,e),_(xe.$$.fragment,e),_(S.$$.fragment,e),_(H.$$.fragment,e),_(je.$$.fragment,e),_(De.$$.fragment,e),_(Ge.$$.fragment,e),_(O.$$.fragment,e),_(A.$$.fragment,e),_(Ce.$$.fragment,e),Do=!0)},o(e){b(w.$$.fragment,e),b(v.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(ie.$$.fragment,e),b(ce.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(we.$$.fragment,e),b(Te.$$.fragment,e),b(B.$$.fragment,e),b(ve.$$.fragment,e),b(Me.$$.fragment,e),b(xe.$$.fragment,e),b(S.$$.fragment,e),b(H.$$.fragment,e),b(je.$$.fragment,e),b(De.$$.fragment,e),b(Ge.$$.fragment,e),b(O.$$.fragment,e),b(A.$$.fragment,e),b(Ce.$$.fragment,e),Do=!1},d(e){e&&(t(T),t(m),t(p),t(i),t(Qe),t(Y),t(Xe),t(K),t(Ye),t(ee),t(Ke),t(F),t(eo),t(oe),t(oo),t(te),t(to),t(no),t(se),t(so),t(re),t(ro),t(ao),t(io),t(de),t(lo),t(E),t(co),t(le),t(mo),t(po),t(me),t(go),t(pe),t(ho),t(uo),t(D),t(fo),t(_o),t(G),t(bo),t(yo),t(C),t(wo),t(To),t(x),t(vo),t(Mo),t(j),t(xo),t(jo),t(Ae)),t(a),y(w,e),y(v,e),y(ne,e),y(ae,e),y(ie,e),y(ce,e),y(ge,e),y(he),y(ue),y(fe),y(_e,e),y(be),y(ye),y(we,e),y(Te),y(B),y(ve,e),y(Me),y(xe),y(S),y(H),y(je,e),y(De),y(Ge),y(O),y(A),y(Ce,e)}}}const Bt='{"title":"Grounding DINO","local":"grounding-dino","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Grounded SAM","local":"grounded-sam","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GroundingDinoImageProcessor","local":"transformers.GroundingDinoImageProcessor","sections":[],"depth":2},{"title":"GroundingDinoProcessor","local":"transformers.GroundingDinoProcessor","sections":[],"depth":2},{"title":"GroundingDinoConfig","local":"transformers.GroundingDinoConfig","sections":[],"depth":2},{"title":"GroundingDinoModel","local":"transformers.GroundingDinoModel","sections":[],"depth":2},{"title":"GroundingDinoForObjectDetection","local":"transformers.GroundingDinoForObjectDetection","sections":[],"depth":2}],"depth":1}';function St(k){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Jt{constructor(a){super(),Nt(this,a,St,Lt,zt,{})}}export{Kt as component};
