import{s as aa,o as ra,n as Dt}from"../chunks/scheduler.25b97de1.js";import{S as la,i as ia,g as r,s,r as m,A as da,h as l,f as n,c as a,j as $,u as p,x as d,k as x,y as i,a as o,v as u,d as g,t as h,w as f}from"../chunks/index.d9030fc9.js";import{T as Ko}from"../chunks/Tip.baa67368.js";import{D as R}from"../chunks/Docstring.ffac8efa.js";import{C}from"../chunks/CodeBlock.e6cd0d95.js";import{E as es}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as J,E as ca}from"../chunks/EditOnGithub.91d95064.js";function ma(U){let c,_="Example:",y,b,T;return b=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IlMEElMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMiklMEElMEElMjMlMjBnZXQlMjB0aGUlMjB1bmNvbmRpdGlvbmFsJTIwKG9yJTIwJ251bGwnKSUyMGlucHV0cyUyMGZvciUyMHRoZSUyMG1vZGVsJTBBcHJvY2Vzc29yJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQXVuY29uZGl0aW9uYWxfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fc2FtcGxlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdW5jb25kaXRpb25hbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration, MusicgenMelodyProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get the unconditional (or &#x27;null&#x27;) inputs for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = MusicgenMelodyProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = processor.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_samples = model.generate(**unconditional_inputs, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=r("p"),c.textContent=_,y=s(),m(b.$$.fragment)},l(M){c=l(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=_),y=a(M),p(b.$$.fragment,M)},m(M,v){o(M,c,v),o(M,y,v),u(b,M,v),T=!0},p:Dt,i(M){T||(g(b.$$.fragment,M),T=!0)},o(M){h(b.$$.fragment,M),T=!1},d(M){M&&(n(c),n(y)),f(b,M)}}}function pa(U){let c,_="Example:",y,b,T;return b=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenMelodyConfig,
<span class="hljs-meta">... </span>    MusicgenMelodyDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenMelodyForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenMelodyDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenMelodyConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenMelodyForConditionalGeneration (with random weights) from the facebook/musicgen-melody style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_melody_config = MusicgenMelodyConfig.from_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen_melody-model&quot;</span>, config=musicgen_melody_config)`,wrap:!1}}),{c(){c=r("p"),c.textContent=_,y=s(),m(b.$$.fragment)},l(M){c=l(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=_),y=a(M),p(b.$$.fragment,M)},m(M,v){o(M,c,v),o(M,y,v),u(b,M,v),T=!0},p:Dt,i(M){T||(g(b.$$.fragment,M),T=!0)},o(M){h(b.$$.fragment,M),T=!1},d(M){M&&(n(c),n(y)),f(b,M)}}}function ua(U){let c,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=_},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=_)},m(y,b){o(y,c,b)},p:Dt,d(y){y&&n(c)}}}function ga(U){let c,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=_},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=_)},m(y,b){o(y,c,b)},p:Dt,d(y){y&&n(c)}}}function ha(U){let c,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=_},l(y){c=l(y,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=_)},m(y,b){o(y,c,b)},p:Dt,d(y){y&&n(c)}}}function fa(U){let c,_="Examples:",y,b,T;return b=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjI4MHMlMjBwb3AlMjB0cmFjayUyMHdpdGglMjBiYXNzeSUyMGRydW1zJTIwYW5kJTIwc3ludGglMjIlMkMlMjAlMjI5MHMlMjByb2NrJTIwc29uZyUyMHdpdGglMjBsb3VkJTIwZ3VpdGFycyUyMGFuZCUyMGhlYXZ5JTIwZHJ1bXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBJTBBcGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcucGFkX3Rva2VuX2lkJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwdG9yY2gub25lcygoaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjAlNUQlMjAqJTIwbW9kZWwuZGVjb2Rlci5udW1fY29kZWJvb2tzJTJDJTIwMSklMkMlMjBkdHlwZSUzRHRvcmNoLmxvbmcpJTBBJTIwJTIwJTIwJTIwKiUyMHBhZF90b2tlbl9pZCUwQSklMEElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZSUyMCUyMCUyMyUyMChic3olMjAqJTIwbnVtX2NvZGVib29rcyUyQyUyMGVuY29kZXJfbGVuJTIwJTJCJTIwdGd0X2xlbiUyQyUyMHZvY2FiX3NpemUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, encoder_len + tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">249</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){c=r("p"),c.textContent=_,y=s(),m(b.$$.fragment)},l(M){c=l(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=_),y=a(M),p(b.$$.fragment,M)},m(M,v){o(M,c,v),o(M,y,v),u(b,M,v),T=!0},p:Dt,i(M){T||(g(b.$$.fragment,M),T=!0)},o(M){h(b.$$.fragment,M),T=!1},d(M){M&&(n(c),n(y)),f(b,M)}}}function Ma(U){let c,_,y,b,T,M,v,Ot,ne,ts='The MusicGen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.',Kt,oe,ns="MusicGen Melody is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>, conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec, to recover the audio waveform.",en,se,os="Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g. hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.",tn,ae,ss="The abstract from the paper is the following:",nn,re,as="<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark. Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>",on,le,rs='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">ylacombe</a>. The original code can be found <a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the <a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen" rel="nofollow">Hugging Face Hub</a>.',sn,ie,an,de,ls="There are two key differences with MusicGen:",rn,ce,is='<li>The audio prompt is used here as a conditional signal for the generated audio sample, whereas it’s used for audio continuation in <a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>.</li> <li>Conditional text and audio signals are concatenated to the decoder’s hidden states instead of being used as a cross-attention signal, as in MusicGen.</li>',ln,me,dn,pe,ds="MusicGen Melody is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default, and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenMelodyForConditionalGeneration.generate()</code>, or by overriding the model’s generation config (see below).",cn,ue,cs="Transformers supports both mono (1-channel) and stereo (2-channel) variants of MusicGen Melody. The mono channel versions generate a single set of codebooks. The stereo versions generate 2 sets of codebooks, 1 for each channel (left/right), and each set of codebooks is decoded independently through the audio compression model. The audio streams for each channel are combined to give the final stereo output.",mn,ge,pn,he,ms='The model can generate an audio sample conditioned on a text and an audio prompt through use of the <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor">MusicgenMelodyProcessor</a> to pre-process the inputs.',un,fe,ps="In the following examples, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command below:",gn,Me,hn,ye,us="The audio file we are about to use is loaded as follows:",fn,be,Mn,_e,gs='The audio prompt should ideally be free of the low-frequency signals usually produced by instruments such as drums and bass. The <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> model can be used to separate vocals and other signals from the drums and bass components.',yn,Te,hs='If you wish to use Demucs, you first need to follow the installation steps <a href="https://github.com/adefossez/demucs/tree/main?tab=readme-ov-file#for-musicians" rel="nofollow">here</a> before using the following snippet:',bn,ve,_n,we,fs="You can then use the following snippet to generate music:",Tn,ke,vn,je,Ms="You can also pass the audio signal directly without using Demucs, although the quality of the generation will probably be degraded:",wn,Je,kn,Ce,ys="The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen to the generated audio samples, you can either play them in an ipynb notebook:",jn,Ze,Jn,Ue,bs="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>soundfile</code>:",Cn,$e,Zn,xe,Un,Ge,_s='The same <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor">MusicgenMelodyProcessor</a> can be used to pre-process a text-only prompt.',$n,We,xn,Fe,Ts="The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits (which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or ‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results, use <code>guidance_scale=3</code> (default).",Gn,Ve,vs="You can also generate in batch:",Wn,ze,Fn,Ne,Vn,Ie,ws='The inputs for unconditional (or ‘null’) generation can be obtained through the method <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyProcessor.get_unconditional_inputs">MusicgenMelodyProcessor.get_unconditional_inputs()</a>:',zn,Re,Nn,Be,In,Xe,ks="The default parameters that control the generation process, such as sampling, guidance scale and number of generated tokens, can be found in the model’s generation config, and updated as desired:",Rn,He,Bn,Ee,js="Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting <code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the generation config.",Xn,qe,Hn,Ye,Js="The MusicGen model can be de-composed into three distinct stages:",En,Le,Cs="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5.</li> <li>MusicGen Melody decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio decoder: used to recover the audio waveform from the audio tokens predicted by the decoder.</li>",qn,Qe,Zs='Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a>, or as a composite model that includes the text encoder and audio encoder, corresponding to the class <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:',Yn,Se,Ln,Pe,Us='Since the text encoder and audio encoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can be combined with the frozen text encoder and audio encoder to recover the composite <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a> model.',Qn,De,Sn,Ae,$s='<li>After downloading the original checkpoints from <a href="https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md#importing--exporting-models" rel="nofollow">here</a>, you can convert them using the <strong>conversion script</strong> available at <code>src/transformers/models/musicgen_melody/convert_musicgen_melody_transformers.py</code> with the following command:</li>',Pn,Oe,Dn,Ke,xs="Tips:",An,et,Gs="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenMelodyForConditionalGeneration.generate()</code></li>",On,tt,Kn,B,nt,fo,vt,Ws=`This is the configuration class to store the configuration of an <code>MusicgenMelodyDecoder</code>. It is used to instantiate a
Musicgen Melody decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Musicgen Melody
<a href="https://huggingface.co/facebook/musicgen-melody" rel="nofollow">facebook/musicgen-melody</a> architecture.`,Mo,wt,Fs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,eo,ot,to,G,st,yo,kt,Vs=`Constructs a MusicGen Melody processor which wraps a Wav2Vec2 feature extractor - for raw audio waveform processing - and a T5 tokenizer into a single processor
class.`,bo,jt,zs=`<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a> and <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>. See
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,_o,E,at,To,Jt,Ns=`Helper function to get null inputs for unconditional generation, enabling the model to be used without the
feature extractor or tokenizer.`,vo,S,no,rt,oo,W,lt,wo,Ct,Is="Constructs a MusicgenMelody feature extractor.",ko,Zt,Rs=`This feature extractor inherits from <a href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods.`,jo,Ut,Bs=`This class extracts chroma features from audio processed by <a href="https://github.com/adefossez/demucs/tree/main" rel="nofollow">Demucs</a> or
directly from raw audio waveform.`,so,it,ao,Z,dt,Jo,$t,Xs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyModel">MusicgenMelodyModel</a>. It is used to instantiate a
Musicgen Melody model according to the specified arguments, defining the text encoder, audio encoder and Musicgen Melody decoder
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the Musicgen Melody
<a href="https://huggingface.co/facebook/musicgen-melody" rel="nofollow">facebook/musicgen-melody</a> architecture.`,Co,xt,Hs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Zo,P,Uo,D,ct,$o,Gt,Es=`Instantiate a <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,ro,mt,lo,w,pt,xo,Wt,qs="The bare MusicgenMelody decoder model outputting raw hidden-states without any specific head on top.",Go,Ft,Ys=`The Musicgen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is a
decoder-only transformer trained on the task of conditional music generation.`,Wo,Vt,Ls=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fo,zt,Qs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vo,q,ut,zo,Nt,Ss='The <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyModel">MusicgenMelodyModel</a> forward method, overrides the <code>__call__</code> special method.',No,A,io,gt,co,k,ht,Io,It,Ps="The Musicgen Melody decoder model with a language modelling head on top.",Ro,Rt,Ds=`The Musicgen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is a
decoder-only transformer trained on the task of conditional music generation.`,Bo,Bt,As=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xo,Xt,Os=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ho,Y,ft,Eo,Ht,Ks='The <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForCausalLM">MusicgenMelodyForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',qo,O,mo,Mt,po,j,yt,Yo,Et,ea="The composite Musicgen Melody model with a text and audio conditional models, a MusicgenMelody decoder and an audio encoder, for music generation tasks with one or both of text and audio prompts.",Lo,qt,ta=`The Musicgen Melody model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is a
decoder-only transformer trained on the task of conditional music generation.`,Qo,Yt,na=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,So,Lt,oa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Po,V,bt,Do,Qt,sa='The <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyForConditionalGeneration">MusicgenMelodyForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Ao,K,Oo,ee,uo,_t,go,At,ho;return T=new J({props:{title:"MusicGen Melody",local:"musicgen-melody",headingTag:"h1"}}),v=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new J({props:{title:"Difference with MusicGen",local:"difference-with-musicgen",headingTag:"h2"}}),me=new J({props:{title:"Generation",local:"generation",headingTag:"h2"}}),ge=new J({props:{title:"Audio Conditional Generation",local:"audio-conditional-generation",headingTag:"h4"}}),Me=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip <span class="hljs-keyword">install</span> --upgrade pip
pip <span class="hljs-keyword">install</span> datasets[audio]`,wrap:!1}}),be=new C({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYW5jaGl0LWdhbmRoaSUyRmd0emFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGRhdGFzZXQpKSU1QiUyMmF1ZGlvJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]`,wrap:!1}}),ve=new C({props:{code:"ZnJvbSUyMGRlbXVjcyUyMGltcG9ydCUyMHByZXRyYWluZWQlMEFmcm9tJTIwZGVtdWNzLmFwcGx5JTIwaW1wb3J0JTIwYXBwbHlfbW9kZWwlMEFmcm9tJTIwZGVtdWNzLmF1ZGlvJTIwaW1wb3J0JTIwY29udmVydF9hdWRpbyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBJTBBd2F2JTIwJTNEJTIwdG9yY2gudGVuc29yKHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEKS50byh0b3JjaC5mbG9hdDMyKSUwQSUwQWRlbXVjcyUyMCUzRCUyMHByZXRyYWluZWQuZ2V0X21vZGVsKCdodGRlbXVjcycpJTBBJTBBd2F2JTIwJTNEJTIwY29udmVydF9hdWRpbyh3YXYlNUJOb25lJTVEJTJDJTIwc2FtcGxlJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMGRlbXVjcy5zYW1wbGVyYXRlJTJDJTIwZGVtdWNzLmF1ZGlvX2NoYW5uZWxzKSUwQXdhdiUyMCUzRCUyMGFwcGx5X21vZGVsKGRlbXVjcyUyQyUyMHdhdiU1Qk5vbmUlNUQp",highlighted:`<span class="hljs-keyword">from</span> demucs <span class="hljs-keyword">import</span> pretrained
<span class="hljs-keyword">from</span> demucs.apply <span class="hljs-keyword">import</span> apply_model
<span class="hljs-keyword">from</span> demucs.audio <span class="hljs-keyword">import</span> convert_audio
<span class="hljs-keyword">import</span> torch


wav = torch.tensor(sample[<span class="hljs-string">&quot;array&quot;</span>]).to(torch.float32)

demucs = pretrained.get_model(<span class="hljs-string">&#x27;htdemucs&#x27;</span>)

wav = convert_audio(wav[<span class="hljs-literal">None</span>], sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>], demucs.samplerate, demucs.audio_channels)
wav = apply_model(demucs, wav[<span class="hljs-literal">None</span>])`,wrap:!1}}),ke=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHdhdiUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RkZW11Y3Muc2FtcGxlcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjI4MHMlMjBibHVlcyUyMHRyYWNrJTIwd2l0aCUyMGdyb292eSUyMHNheG9waG9uZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=wav,
<span class="hljs-meta">... </span>    sampling_rate=demucs.samplerate,
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Je=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ze=new C({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),$e=new C({props:{code:"aW1wb3J0JTIwc291bmRmaWxlJTIwYXMlMjBzZiUwQSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBtb2RlbC5jb25maWcuYXVkaW9fZW5jb2Rlci5zYW1wbGluZ19yYXRlJTBBc2Yud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMGF1ZGlvX3ZhbHVlcyU1QjAlNUQuVC5udW1weSgpJTJDJTIwc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>sf.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, audio_values[<span class="hljs-number">0</span>].T.numpy(), sampling_rate)`,wrap:!1}}),xe=new J({props:{title:"Text-only Conditional Generation",local:"text-only-conditional-generation",headingTag:"h3"}}),We=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),ze=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKSUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMHF1YXJ0ZXIlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzElMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjA0JTVEJTBBJTBBJTIzJTIwdGFrZSUyMHRoZSUyMGZpcnN0JTIwaGFsZiUyMG9mJTIwdGhlJTIwYXVkaW8lMjBzYW1wbGUlMEFzYW1wbGVfMiUyMCUzRCUyMHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTVCJTNBJTIwbGVuKHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEKSUyMCUyRiUyRiUyMDIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwYXVkaW8lM0QlNUJzYW1wbGVfMSUyQyUyMHNhbXBsZV8yJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlMkMlMjAlMjI5MHMlMjByb2NrJTIwc29uZyUyMHdpdGglMjBsb3VkJTIwZ3VpdGFycyUyMGFuZCUyMGhlYXZ5JTIwZHJ1bXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenMelodyForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ne=new J({props:{title:"Unconditional Generation",local:"unconditional-generation",headingTag:"h3"}}),Re=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTXVzaWNnZW5NZWxvZHlQcm9jZXNzb3IlMEElMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyME11c2ljZ2VuTWVsb2R5UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMikuZ2V0X3VuY29uZGl0aW9uYWxfaW5wdXRzKG51bV9zYW1wbGVzJTNEMSklMEElMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKnVuY29uZGl0aW9uYWxfaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration, MusicgenMelodyProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = MusicgenMelodyProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Be=new J({props:{title:"Generation Configuration",local:"generation-configuration",headingTag:"h3"}}),He=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbk1lbG9keUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIpJTBBJTBBJTIzJTIwaW5zcGVjdCUyMHRoZSUyMGRlZmF1bHQlMjBnZW5lcmF0aW9uJTIwY29uZmlnJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWclMEElMEElMjMlMjBpbmNyZWFzZSUyMHRoZSUyMGd1aWRhbmNlJTIwc2NhbGUlMjB0byUyMDQuMCUwQW1vZGVsLmdlbmVyYXRpb25fY29uZmlnLmd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwNC4wJTBBJTBBJTIzJTIwZGVjcmVhc2UlMjB0aGUlMjBtYXglMjBsZW5ndGglMjB0byUyMDI1NiUyMHRva2VucyUwQW1vZGVsLmdlbmVyYXRpb25fY29uZmlnLm1heF9sZW5ndGglMjAlM0QlMjAyNTY=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),qe=new J({props:{title:"Model Structure",local:"model-structure",headingTag:"h2"}}),Se=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbk1lbG9keUZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5NZWxvZHlGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyKS5kZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tbWVsb2R5JTIyJTJDJTIwKipkZWNvZGVyX2NvbmZpZy50b19kaWN0KCkpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuTWVsb2R5Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLW1lbG9keSUyMikuZGVjb2Rlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenMelodyForCausalLM, MusicgenMelodyForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenMelodyForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>, **decoder_config.to_dict())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenMelodyForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span>).decoder`,wrap:!1}}),De=new J({props:{title:"Checkpoint Conversion",local:"checkpoint-conversion",headingTag:"h2"}}),Oe=new C({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbXVzaWNnZW5fbWVsb2R5JTJGY29udmVydF9tdXNpY2dlbl9tZWxvZHlfdHJhbnNmb3JtZXJzLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50JTNEJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1tZWxvZHklMjIlMjAtLXB5dG9yY2hfZHVtcF9mb2xkZXIlMjAlMkZvdXRwdXQlMkZwYXRoJTIw",highlighted:`python src/transformers/models/musicgen_melody/convert_musicgen_melody_transformers.py \\
    --checkpoint=<span class="hljs-string">&quot;facebook/musicgen-melody&quot;</span> --pytorch_dump_folder /output/path `,wrap:!1}}),tt=new J({props:{title:"MusicgenMelodyDecoderConfig",local:"transformers.MusicgenMelodyDecoderConfig",headingTag:"h2"}}),nt=new R({props:{name:"class transformers.MusicgenMelodyDecoderConfig",anchor:"transformers.MusicgenMelodyDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"audio_channels",val:" = 1"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenMelodyDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenMelodyDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenMelodyDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenMelodyDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenMelodyDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenMelodyDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenMelodyDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenMelodyDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenMelodyDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenMelodyDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenMelodyDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenMelodyDecoderConfig.audio_channels",description:`<strong>audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of audio channels used by the model (either mono or stereo). Stereo models generate a separate
audio stream for the left/right output channels. Mono models generate a single audio stream output.`,name:"audio_channels"},{anchor:"transformers.MusicgenMelodyDecoderConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014; The id of the <em>beginning-of-sequence</em> token.",name:"bos_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.eos_token_id",description:"<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>end-of-sequence</em> token.",name:"eos_token_id"},{anchor:"transformers.MusicgenMelodyDecoderConfig.tie_word_embeddings",description:"<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to tie word embeddings with the text encoder.",name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L25"}}),ot=new J({props:{title:"MusicgenMelodyProcessor",local:"transformers.MusicgenMelodyProcessor",headingTag:"h2"}}),st=new R({props:{name:"class transformers.MusicgenMelodyProcessor",anchor:"transformers.MusicgenMelodyProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MusicgenMelodyFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenMelodyProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/processing_musicgen_melody.py#L27"}}),at=new R({props:{name:"get_unconditional_inputs",anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs",parameters:[{name:"num_samples",val:" = 1"},{name:"return_tensors",val:" = 'pt'"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs.num_samples",description:`<strong>num_samples</strong> (int, <em>optional</em>) &#x2014;
Number of audio samples to unconditionally generate.`,name:"num_samples"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/processing_musicgen_melody.py#L151"}}),S=new es({props:{anchor:"transformers.MusicgenMelodyProcessor.get_unconditional_inputs.example",$$slots:{default:[ma]},$$scope:{ctx:U}}}),rt=new J({props:{title:"MusicgenMelodyFeatureExtractor",local:"transformers.MusicgenMelodyFeatureExtractor",headingTag:"h2"}}),lt=new R({props:{name:"class transformers.MusicgenMelodyFeatureExtractor",anchor:"transformers.MusicgenMelodyFeatureExtractor",parameters:[{name:"feature_size",val:" = 12"},{name:"sampling_rate",val:" = 32000"},{name:"hop_length",val:" = 4096"},{name:"chunk_length",val:" = 30"},{name:"n_fft",val:" = 16384"},{name:"num_chroma",val:" = 12"},{name:"padding_value",val:" = 0.0"},{name:"return_attention_mask",val:" = False"},{name:"stem_indices",val:" = [3, 2]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyFeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The feature dimension of the extracted features.`,name:"feature_size"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.hop_length",description:`<strong>hop_length</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Length of the overlaping windows for the STFT used to obtain the Mel Frequency coefficients.`,name:"hop_length"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.chunk_length",description:`<strong>chunk_length</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
The maximum number of chunks of <code>sampling_rate</code> samples used to trim and pad longer or shorter audio
sequences.`,name:"chunk_length"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.n_fft",description:`<strong>n_fft</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Size of the Fourier transform.`,name:"n_fft"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.num_chroma",description:`<strong>num_chroma</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of chroma bins to use.`,name:"num_chroma"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Padding value used to pad the audio.`,name:"padding_value"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return the attention mask. Can be overwritten when calling the feature extractor.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>For Whisper models, <code>attention_mask</code> should always be passed for batched inference, to avoid subtle
bugs.</p>

					</div>`,name:"return_attention_mask"},{anchor:"transformers.MusicgenMelodyFeatureExtractor.stem_indices",description:`<strong>stem_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2]</code>) &#x2014;
Stem channels to extract if demucs outputs are passed.`,name:"stem_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/feature_extraction_musicgen_melody.py#L39"}}),it=new J({props:{title:"MusicgenMelodyConfig",local:"transformers.MusicgenMelodyConfig",headingTag:"h2"}}),dt=new R({props:{name:"class transformers.MusicgenMelodyConfig",anchor:"transformers.MusicgenMelodyConfig",parameters:[{name:"num_chroma",val:" = 12"},{name:"chroma_length",val:" = 235"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyConfig.num_chroma",description:"<strong>num_chroma</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014; Number of chroma bins to use.",name:"num_chroma"},{anchor:"transformers.MusicgenMelodyConfig.chroma_length",description:`<strong>chroma_length</strong> (<code>int</code>, <em>optional</em>, defaults to 235) &#x2014;
Maximum chroma duration if audio is used to condition the model. Corresponds to the maximum duration used during training.`,name:"chroma_length"},{anchor:"transformers.MusicgenMelodyConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L137"}}),P=new es({props:{anchor:"transformers.MusicgenMelodyConfig.example",$$slots:{default:[pa]},$$scope:{ctx:U}}}),ct=new R({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenMelodyConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenMelodyDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/configuration_musicgen_melody.py#L232",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a></p>
`}}),mt=new J({props:{title:"MusicgenMelodyModel",local:"transformers.MusicgenMelodyModel",headingTag:"h2"}}),pt=new R({props:{name:"class transformers.MusicgenMelodyModel",anchor:"transformers.MusicgenMelodyModel",parameters:[{name:"config",val:": MusicgenMelodyDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1049"}}),ut=new R({props:{name:"forward",anchor:"transformers.MusicgenMelodyModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states representing the concatenation of the text encoder output and the processed audio encoder output.
Used as a conditional signal and will thus be concatenated to the projeted <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on conditional hidden states. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenMelodyModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)\`.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1070"}}),A=new Ko({props:{$$slots:{default:[ua]},$$scope:{ctx:U}}}),gt=new J({props:{title:"MusicgenMelodyForCausalLM",local:"transformers.MusicgenMelodyForCausalLM",headingTag:"h2"}}),ht=new R({props:{name:"class transformers.MusicgenMelodyForCausalLM",anchor:"transformers.MusicgenMelodyForCausalLM",parameters:[{name:"config",val:": MusicgenMelodyDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1119"}}),ft=new R({props:{name:"forward",anchor:"transformers.MusicgenMelodyForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states representing the concatenation of the text encoder output and the processed audio encoder output.
Used as a conditional signal and will thus be concatenated to the projeted <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on conditional hidden states. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)\`.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MusicgenMelodyForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of conditional hidden-states representing the concatenation of the projeted text encoder output and the projeted audio encoder output.
Used as a conditional signal.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Ko({props:{$$slots:{default:[ga]},$$scope:{ctx:U}}}),Mt=new J({props:{title:"MusicgenMelodyForConditionalGeneration",local:"transformers.MusicgenMelodyForConditionalGeneration",headingTag:"h2"}}),yt=new R({props:{name:"class transformers.MusicgenMelodyForConditionalGeneration",anchor:"transformers.MusicgenMelodyForConditionalGeneration",parameters:[{name:"config",val:": MusicgenMelodyConfig = None"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"audio_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyForCausalLM] = None"}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig">MusicgenMelodyConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.text_encoder",description:"<strong>text_encoder</strong> (<code>Optional[PreTrainedModel]</code>, <em>optional</em>) &#x2014; Text encoder.",name:"text_encoder"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.audio_encoder",description:"<strong>audio_encoder</strong> (<code>Optional[PreTrainedModel]</code>, <em>optional</em>) &#x2014; Audio code decoder.",name:"audio_encoder"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.decoder",description:"<strong>decoder</strong> (<code>Optional[MusicgenMelodyForCausalLM]</code>, <em>optional</em>) &#x2014; MusicGen Melody decoder used to generate audio codes.",name:"decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1584"}}),bt=new R({props:{name:"forward",anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"past_key_values",val:": typing.Tuple[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_sequence_length, num_chroma)</code>) &#x2014;
Input audio features.
This should be returned by the <a href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyFeatureExtractor">MusicgenMelodyFeatureExtractor</a> class that you can also
retrieve from <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a>. See <code>MusicgenMelodyFeatureExtractor.__call__()</code> for details.`,name:"input_features"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length + sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of conditional hidden-states representing the concatenation of the projeted text encoder output and the projeted audio encoder output.
Used as a conditional signal and will thus be concatenated to the projeted <code>decoder_input_ids</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen_melody/modeling_musicgen_melody.py#L1905",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen_melody#transformers.MusicgenMelodyConfig"
>MusicgenMelodyConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of conditional hidden-states representing the concatenation of the projeted text encoder output and the projeted audio encoder output.
Used as a conditional signal.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.musicgen_melody.modeling_musicgen_melody.MusicgenMelodyOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new Ko({props:{$$slots:{default:[ha]},$$scope:{ctx:U}}}),ee=new es({props:{anchor:"transformers.MusicgenMelodyForConditionalGeneration.forward.example",$$slots:{default:[fa]},$$scope:{ctx:U}}}),_t=new ca({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/musicgen_melody.md"}}),{c(){c=r("meta"),_=s(),y=r("p"),b=s(),m(T.$$.fragment),M=s(),m(v.$$.fragment),Ot=s(),ne=r("p"),ne.innerHTML=ts,Kt=s(),oe=r("p"),oe.innerHTML=ns,en=s(),se=r("p"),se.textContent=os,tn=s(),ae=r("p"),ae.textContent=ss,nn=s(),re=r("p"),re.innerHTML=as,on=s(),le=r("p"),le.innerHTML=rs,sn=s(),m(ie.$$.fragment),an=s(),de=r("p"),de.textContent=ls,rn=s(),ce=r("ol"),ce.innerHTML=is,ln=s(),m(me.$$.fragment),dn=s(),pe=r("p"),pe.innerHTML=ds,cn=s(),ue=r("p"),ue.textContent=cs,mn=s(),m(ge.$$.fragment),pn=s(),he=r("p"),he.innerHTML=ms,un=s(),fe=r("p"),fe.textContent=ps,gn=s(),m(Me.$$.fragment),hn=s(),ye=r("p"),ye.textContent=us,fn=s(),m(be.$$.fragment),Mn=s(),_e=r("p"),_e.innerHTML=gs,yn=s(),Te=r("p"),Te.innerHTML=hs,bn=s(),m(ve.$$.fragment),_n=s(),we=r("p"),we.textContent=fs,Tn=s(),m(ke.$$.fragment),vn=s(),je=r("p"),je.textContent=Ms,wn=s(),m(Je.$$.fragment),kn=s(),Ce=r("p"),Ce.innerHTML=ys,jn=s(),m(Ze.$$.fragment),Jn=s(),Ue=r("p"),Ue.innerHTML=bs,Cn=s(),m($e.$$.fragment),Zn=s(),m(xe.$$.fragment),Un=s(),Ge=r("p"),Ge.innerHTML=_s,$n=s(),m(We.$$.fragment),xn=s(),Fe=r("p"),Fe.innerHTML=Ts,Gn=s(),Ve=r("p"),Ve.textContent=vs,Wn=s(),m(ze.$$.fragment),Fn=s(),m(Ne.$$.fragment),Vn=s(),Ie=r("p"),Ie.innerHTML=ws,zn=s(),m(Re.$$.fragment),Nn=s(),m(Be.$$.fragment),In=s(),Xe=r("p"),Xe.textContent=ks,Rn=s(),m(He.$$.fragment),Bn=s(),Ee=r("p"),Ee.innerHTML=js,Xn=s(),m(qe.$$.fragment),Hn=s(),Ye=r("p"),Ye.textContent=Js,En=s(),Le=r("ol"),Le.innerHTML=Cs,qn=s(),Qe=r("p"),Qe.innerHTML=Zs,Yn=s(),m(Se.$$.fragment),Ln=s(),Pe=r("p"),Pe.innerHTML=Us,Qn=s(),m(De.$$.fragment),Sn=s(),Ae=r("ul"),Ae.innerHTML=$s,Pn=s(),m(Oe.$$.fragment),Dn=s(),Ke=r("p"),Ke.textContent=xs,An=s(),et=r("ul"),et.innerHTML=Gs,On=s(),m(tt.$$.fragment),Kn=s(),B=r("div"),m(nt.$$.fragment),fo=s(),vt=r("p"),vt.innerHTML=Ws,Mo=s(),wt=r("p"),wt.innerHTML=Fs,eo=s(),m(ot.$$.fragment),to=s(),G=r("div"),m(st.$$.fragment),yo=s(),kt=r("p"),kt.textContent=Vs,bo=s(),jt=r("p"),jt.innerHTML=zs,_o=s(),E=r("div"),m(at.$$.fragment),To=s(),Jt=r("p"),Jt.textContent=Ns,vo=s(),m(S.$$.fragment),no=s(),m(rt.$$.fragment),oo=s(),W=r("div"),m(lt.$$.fragment),wo=s(),Ct=r("p"),Ct.textContent=Is,ko=s(),Zt=r("p"),Zt.innerHTML=Rs,jo=s(),Ut=r("p"),Ut.innerHTML=Bs,so=s(),m(it.$$.fragment),ao=s(),Z=r("div"),m(dt.$$.fragment),Jo=s(),$t=r("p"),$t.innerHTML=Xs,Co=s(),xt=r("p"),xt.innerHTML=Hs,Zo=s(),m(P.$$.fragment),Uo=s(),D=r("div"),m(ct.$$.fragment),$o=s(),Gt=r("p"),Gt.innerHTML=Es,ro=s(),m(mt.$$.fragment),lo=s(),w=r("div"),m(pt.$$.fragment),xo=s(),Wt=r("p"),Wt.textContent=qs,Go=s(),Ft=r("p"),Ft.innerHTML=Ys,Wo=s(),Vt=r("p"),Vt.innerHTML=Ls,Fo=s(),zt=r("p"),zt.innerHTML=Qs,Vo=s(),q=r("div"),m(ut.$$.fragment),zo=s(),Nt=r("p"),Nt.innerHTML=Ss,No=s(),m(A.$$.fragment),io=s(),m(gt.$$.fragment),co=s(),k=r("div"),m(ht.$$.fragment),Io=s(),It=r("p"),It.textContent=Ps,Ro=s(),Rt=r("p"),Rt.innerHTML=Ds,Bo=s(),Bt=r("p"),Bt.innerHTML=As,Xo=s(),Xt=r("p"),Xt.innerHTML=Os,Ho=s(),Y=r("div"),m(ft.$$.fragment),Eo=s(),Ht=r("p"),Ht.innerHTML=Ks,qo=s(),m(O.$$.fragment),mo=s(),m(Mt.$$.fragment),po=s(),j=r("div"),m(yt.$$.fragment),Yo=s(),Et=r("p"),Et.textContent=ea,Lo=s(),qt=r("p"),qt.innerHTML=ta,Qo=s(),Yt=r("p"),Yt.innerHTML=na,So=s(),Lt=r("p"),Lt.innerHTML=oa,Po=s(),V=r("div"),m(bt.$$.fragment),Do=s(),Qt=r("p"),Qt.innerHTML=sa,Ao=s(),m(K.$$.fragment),Oo=s(),m(ee.$$.fragment),uo=s(),m(_t.$$.fragment),go=s(),At=r("p"),this.h()},l(e){const t=da("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(n),_=a(e),y=l(e,"P",{}),$(y).forEach(n),b=a(e),p(T.$$.fragment,e),M=a(e),p(v.$$.fragment,e),Ot=a(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-78c2gt"&&(ne.innerHTML=ts),Kt=a(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-12yjb0l"&&(oe.innerHTML=ns),en=a(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-fd8as4"&&(se.textContent=os),tn=a(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-vfdo9a"&&(ae.textContent=ss),nn=a(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1ivrrzt"&&(re.innerHTML=as),on=a(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1hq1neg"&&(le.innerHTML=rs),sn=a(e),p(ie.$$.fragment,e),an=a(e),de=l(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1uncox0"&&(de.textContent=ls),rn=a(e),ce=l(e,"OL",{"data-svelte-h":!0}),d(ce)!=="svelte-18htd4w"&&(ce.innerHTML=is),ln=a(e),p(me.$$.fragment,e),dn=a(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1ftnanv"&&(pe.innerHTML=ds),cn=a(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1csutn1"&&(ue.textContent=cs),mn=a(e),p(ge.$$.fragment,e),pn=a(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-10ek10q"&&(he.innerHTML=ms),un=a(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-13qa4g8"&&(fe.textContent=ps),gn=a(e),p(Me.$$.fragment,e),hn=a(e),ye=l(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-z5hgod"&&(ye.textContent=us),fn=a(e),p(be.$$.fragment,e),Mn=a(e),_e=l(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1qlcazm"&&(_e.innerHTML=gs),yn=a(e),Te=l(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-3ul8a2"&&(Te.innerHTML=hs),bn=a(e),p(ve.$$.fragment,e),_n=a(e),we=l(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-j9yyu1"&&(we.textContent=fs),Tn=a(e),p(ke.$$.fragment,e),vn=a(e),je=l(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1ogs8cb"&&(je.textContent=Ms),wn=a(e),p(Je.$$.fragment,e),kn=a(e),Ce=l(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1i3bavh"&&(Ce.innerHTML=ys),jn=a(e),p(Ze.$$.fragment,e),Jn=a(e),Ue=l(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1so91jo"&&(Ue.innerHTML=bs),Cn=a(e),p($e.$$.fragment,e),Zn=a(e),p(xe.$$.fragment,e),Un=a(e),Ge=l(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-re3xvv"&&(Ge.innerHTML=_s),$n=a(e),p(We.$$.fragment,e),xn=a(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1hk6jop"&&(Fe.innerHTML=Ts),Gn=a(e),Ve=l(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-nxh1r8"&&(Ve.textContent=vs),Wn=a(e),p(ze.$$.fragment,e),Fn=a(e),p(Ne.$$.fragment,e),Vn=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-mlnl2q"&&(Ie.innerHTML=ws),zn=a(e),p(Re.$$.fragment,e),Nn=a(e),p(Be.$$.fragment,e),In=a(e),Xe=l(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1osihnc"&&(Xe.textContent=ks),Rn=a(e),p(He.$$.fragment,e),Bn=a(e),Ee=l(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-j9qxmb"&&(Ee.innerHTML=js),Xn=a(e),p(qe.$$.fragment,e),Hn=a(e),Ye=l(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-52mell"&&(Ye.textContent=Js),En=a(e),Le=l(e,"OL",{"data-svelte-h":!0}),d(Le)!=="svelte-1cudh7l"&&(Le.innerHTML=Cs),qn=a(e),Qe=l(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1rq1sbs"&&(Qe.innerHTML=Zs),Yn=a(e),p(Se.$$.fragment,e),Ln=a(e),Pe=l(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-hyjder"&&(Pe.innerHTML=Us),Qn=a(e),p(De.$$.fragment,e),Sn=a(e),Ae=l(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-111jn6u"&&(Ae.innerHTML=$s),Pn=a(e),p(Oe.$$.fragment,e),Dn=a(e),Ke=l(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-axv494"&&(Ke.textContent=xs),An=a(e),et=l(e,"UL",{"data-svelte-h":!0}),d(et)!=="svelte-43b5cf"&&(et.innerHTML=Gs),On=a(e),p(tt.$$.fragment,e),Kn=a(e),B=l(e,"DIV",{class:!0});var L=$(B);p(nt.$$.fragment,L),fo=a(L),vt=l(L,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1is1y2l"&&(vt.innerHTML=Ws),Mo=a(L),wt=l(L,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-o55m63"&&(wt.innerHTML=Fs),L.forEach(n),eo=a(e),p(ot.$$.fragment,e),to=a(e),G=l(e,"DIV",{class:!0});var X=$(G);p(st.$$.fragment,X),yo=a(X),kt=l(X,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1eghntb"&&(kt.textContent=Vs),bo=a(X),jt=l(X,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-5ej9zd"&&(jt.innerHTML=zs),_o=a(X),E=l(X,"DIV",{class:!0});var Q=$(E);p(at.$$.fragment,Q),To=a(Q),Jt=l(Q,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-99wdq5"&&(Jt.textContent=Ns),vo=a(Q),p(S.$$.fragment,Q),Q.forEach(n),X.forEach(n),no=a(e),p(rt.$$.fragment,e),oo=a(e),W=l(e,"DIV",{class:!0});var H=$(W);p(lt.$$.fragment,H),wo=a(H),Ct=l(H,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-avkweo"&&(Ct.textContent=Is),ko=a(H),Zt=l(H,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-3gz575"&&(Zt.innerHTML=Rs),jo=a(H),Ut=l(H,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-ffxp6h"&&(Ut.innerHTML=Bs),H.forEach(n),so=a(e),p(it.$$.fragment,e),ao=a(e),Z=l(e,"DIV",{class:!0});var F=$(Z);p(dt.$$.fragment,F),Jo=a(F),$t=l(F,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1szg2e3"&&($t.innerHTML=Xs),Co=a(F),xt=l(F,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-o55m63"&&(xt.innerHTML=Hs),Zo=a(F),p(P.$$.fragment,F),Uo=a(F),D=l(F,"DIV",{class:!0});var Tt=$(D);p(ct.$$.fragment,Tt),$o=a(Tt),Gt=l(Tt,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-fqk2bf"&&(Gt.innerHTML=Es),Tt.forEach(n),F.forEach(n),ro=a(e),p(mt.$$.fragment,e),lo=a(e),w=l(e,"DIV",{class:!0});var z=$(w);p(pt.$$.fragment,z),xo=a(z),Wt=l(z,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-wdu1ev"&&(Wt.textContent=qs),Go=a(z),Ft=l(z,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-1ju8fyw"&&(Ft.innerHTML=Ys),Wo=a(z),Vt=l(z,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-6pahdo"&&(Vt.innerHTML=Ls),Fo=a(z),zt=l(z,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-hswkmf"&&(zt.innerHTML=Qs),Vo=a(z),q=l(z,"DIV",{class:!0});var St=$(q);p(ut.$$.fragment,St),zo=a(St),Nt=l(St,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-b9g5ur"&&(Nt.innerHTML=Ss),No=a(St),p(A.$$.fragment,St),St.forEach(n),z.forEach(n),io=a(e),p(gt.$$.fragment,e),co=a(e),k=l(e,"DIV",{class:!0});var N=$(k);p(ht.$$.fragment,N),Io=a(N),It=l(N,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1m1my0b"&&(It.textContent=Ps),Ro=a(N),Rt=l(N,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-1ju8fyw"&&(Rt.innerHTML=Ds),Bo=a(N),Bt=l(N,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-6pahdo"&&(Bt.innerHTML=As),Xo=a(N),Xt=l(N,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-hswkmf"&&(Xt.innerHTML=Os),Ho=a(N),Y=l(N,"DIV",{class:!0});var Pt=$(Y);p(ft.$$.fragment,Pt),Eo=a(Pt),Ht=l(Pt,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-383y17"&&(Ht.innerHTML=Ks),qo=a(Pt),p(O.$$.fragment,Pt),Pt.forEach(n),N.forEach(n),mo=a(e),p(Mt.$$.fragment,e),po=a(e),j=l(e,"DIV",{class:!0});var I=$(j);p(yt.$$.fragment,I),Yo=a(I),Et=l(I,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1c6yw0h"&&(Et.textContent=ea),Lo=a(I),qt=l(I,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-1ju8fyw"&&(qt.innerHTML=ta),Qo=a(I),Yt=l(I,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-6pahdo"&&(Yt.innerHTML=na),So=a(I),Lt=l(I,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-hswkmf"&&(Lt.innerHTML=oa),Po=a(I),V=l(I,"DIV",{class:!0});var te=$(V);p(bt.$$.fragment,te),Do=a(te),Qt=l(te,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1b6bgmb"&&(Qt.innerHTML=sa),Ao=a(te),p(K.$$.fragment,te),Oo=a(te),p(ee.$$.fragment,te),te.forEach(n),I.forEach(n),uo=a(e),p(_t.$$.fragment,e),go=a(e),At=l(e,"P",{}),$(At).forEach(n),this.h()},h(){x(c,"name","hf:doc:metadata"),x(c,"content",ya),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,c),o(e,_,t),o(e,y,t),o(e,b,t),u(T,e,t),o(e,M,t),u(v,e,t),o(e,Ot,t),o(e,ne,t),o(e,Kt,t),o(e,oe,t),o(e,en,t),o(e,se,t),o(e,tn,t),o(e,ae,t),o(e,nn,t),o(e,re,t),o(e,on,t),o(e,le,t),o(e,sn,t),u(ie,e,t),o(e,an,t),o(e,de,t),o(e,rn,t),o(e,ce,t),o(e,ln,t),u(me,e,t),o(e,dn,t),o(e,pe,t),o(e,cn,t),o(e,ue,t),o(e,mn,t),u(ge,e,t),o(e,pn,t),o(e,he,t),o(e,un,t),o(e,fe,t),o(e,gn,t),u(Me,e,t),o(e,hn,t),o(e,ye,t),o(e,fn,t),u(be,e,t),o(e,Mn,t),o(e,_e,t),o(e,yn,t),o(e,Te,t),o(e,bn,t),u(ve,e,t),o(e,_n,t),o(e,we,t),o(e,Tn,t),u(ke,e,t),o(e,vn,t),o(e,je,t),o(e,wn,t),u(Je,e,t),o(e,kn,t),o(e,Ce,t),o(e,jn,t),u(Ze,e,t),o(e,Jn,t),o(e,Ue,t),o(e,Cn,t),u($e,e,t),o(e,Zn,t),u(xe,e,t),o(e,Un,t),o(e,Ge,t),o(e,$n,t),u(We,e,t),o(e,xn,t),o(e,Fe,t),o(e,Gn,t),o(e,Ve,t),o(e,Wn,t),u(ze,e,t),o(e,Fn,t),u(Ne,e,t),o(e,Vn,t),o(e,Ie,t),o(e,zn,t),u(Re,e,t),o(e,Nn,t),u(Be,e,t),o(e,In,t),o(e,Xe,t),o(e,Rn,t),u(He,e,t),o(e,Bn,t),o(e,Ee,t),o(e,Xn,t),u(qe,e,t),o(e,Hn,t),o(e,Ye,t),o(e,En,t),o(e,Le,t),o(e,qn,t),o(e,Qe,t),o(e,Yn,t),u(Se,e,t),o(e,Ln,t),o(e,Pe,t),o(e,Qn,t),u(De,e,t),o(e,Sn,t),o(e,Ae,t),o(e,Pn,t),u(Oe,e,t),o(e,Dn,t),o(e,Ke,t),o(e,An,t),o(e,et,t),o(e,On,t),u(tt,e,t),o(e,Kn,t),o(e,B,t),u(nt,B,null),i(B,fo),i(B,vt),i(B,Mo),i(B,wt),o(e,eo,t),u(ot,e,t),o(e,to,t),o(e,G,t),u(st,G,null),i(G,yo),i(G,kt),i(G,bo),i(G,jt),i(G,_o),i(G,E),u(at,E,null),i(E,To),i(E,Jt),i(E,vo),u(S,E,null),o(e,no,t),u(rt,e,t),o(e,oo,t),o(e,W,t),u(lt,W,null),i(W,wo),i(W,Ct),i(W,ko),i(W,Zt),i(W,jo),i(W,Ut),o(e,so,t),u(it,e,t),o(e,ao,t),o(e,Z,t),u(dt,Z,null),i(Z,Jo),i(Z,$t),i(Z,Co),i(Z,xt),i(Z,Zo),u(P,Z,null),i(Z,Uo),i(Z,D),u(ct,D,null),i(D,$o),i(D,Gt),o(e,ro,t),u(mt,e,t),o(e,lo,t),o(e,w,t),u(pt,w,null),i(w,xo),i(w,Wt),i(w,Go),i(w,Ft),i(w,Wo),i(w,Vt),i(w,Fo),i(w,zt),i(w,Vo),i(w,q),u(ut,q,null),i(q,zo),i(q,Nt),i(q,No),u(A,q,null),o(e,io,t),u(gt,e,t),o(e,co,t),o(e,k,t),u(ht,k,null),i(k,Io),i(k,It),i(k,Ro),i(k,Rt),i(k,Bo),i(k,Bt),i(k,Xo),i(k,Xt),i(k,Ho),i(k,Y),u(ft,Y,null),i(Y,Eo),i(Y,Ht),i(Y,qo),u(O,Y,null),o(e,mo,t),u(Mt,e,t),o(e,po,t),o(e,j,t),u(yt,j,null),i(j,Yo),i(j,Et),i(j,Lo),i(j,qt),i(j,Qo),i(j,Yt),i(j,So),i(j,Lt),i(j,Po),i(j,V),u(bt,V,null),i(V,Do),i(V,Qt),i(V,Ao),u(K,V,null),i(V,Oo),u(ee,V,null),o(e,uo,t),u(_t,e,t),o(e,go,t),o(e,At,t),ho=!0},p(e,[t]){const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),S.$set(L);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),P.$set(X);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),A.$set(Q);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),O.$set(H);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),K.$set(F);const Tt={};t&2&&(Tt.$$scope={dirty:t,ctx:e}),ee.$set(Tt)},i(e){ho||(g(T.$$.fragment,e),g(v.$$.fragment,e),g(ie.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(Me.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(ke.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g(ze.$$.fragment,e),g(Ne.$$.fragment,e),g(Re.$$.fragment,e),g(Be.$$.fragment,e),g(He.$$.fragment,e),g(qe.$$.fragment,e),g(Se.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(S.$$.fragment,e),g(rt.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(P.$$.fragment,e),g(ct.$$.fragment,e),g(mt.$$.fragment,e),g(pt.$$.fragment,e),g(ut.$$.fragment,e),g(A.$$.fragment,e),g(gt.$$.fragment,e),g(ht.$$.fragment,e),g(ft.$$.fragment,e),g(O.$$.fragment,e),g(Mt.$$.fragment,e),g(yt.$$.fragment,e),g(bt.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(_t.$$.fragment,e),ho=!0)},o(e){h(T.$$.fragment,e),h(v.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h($e.$$.fragment,e),h(xe.$$.fragment,e),h(We.$$.fragment,e),h(ze.$$.fragment,e),h(Ne.$$.fragment,e),h(Re.$$.fragment,e),h(Be.$$.fragment,e),h(He.$$.fragment,e),h(qe.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(S.$$.fragment,e),h(rt.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(P.$$.fragment,e),h(ct.$$.fragment,e),h(mt.$$.fragment,e),h(pt.$$.fragment,e),h(ut.$$.fragment,e),h(A.$$.fragment,e),h(gt.$$.fragment,e),h(ht.$$.fragment,e),h(ft.$$.fragment,e),h(O.$$.fragment,e),h(Mt.$$.fragment,e),h(yt.$$.fragment,e),h(bt.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(_t.$$.fragment,e),ho=!1},d(e){e&&(n(_),n(y),n(b),n(M),n(Ot),n(ne),n(Kt),n(oe),n(en),n(se),n(tn),n(ae),n(nn),n(re),n(on),n(le),n(sn),n(an),n(de),n(rn),n(ce),n(ln),n(dn),n(pe),n(cn),n(ue),n(mn),n(pn),n(he),n(un),n(fe),n(gn),n(hn),n(ye),n(fn),n(Mn),n(_e),n(yn),n(Te),n(bn),n(_n),n(we),n(Tn),n(vn),n(je),n(wn),n(kn),n(Ce),n(jn),n(Jn),n(Ue),n(Cn),n(Zn),n(Un),n(Ge),n($n),n(xn),n(Fe),n(Gn),n(Ve),n(Wn),n(Fn),n(Vn),n(Ie),n(zn),n(Nn),n(In),n(Xe),n(Rn),n(Bn),n(Ee),n(Xn),n(Hn),n(Ye),n(En),n(Le),n(qn),n(Qe),n(Yn),n(Ln),n(Pe),n(Qn),n(Sn),n(Ae),n(Pn),n(Dn),n(Ke),n(An),n(et),n(On),n(Kn),n(B),n(eo),n(to),n(G),n(no),n(oo),n(W),n(so),n(ao),n(Z),n(ro),n(lo),n(w),n(io),n(co),n(k),n(mo),n(po),n(j),n(uo),n(go),n(At)),n(c),f(T,e),f(v,e),f(ie,e),f(me,e),f(ge,e),f(Me,e),f(be,e),f(ve,e),f(ke,e),f(Je,e),f(Ze,e),f($e,e),f(xe,e),f(We,e),f(ze,e),f(Ne,e),f(Re,e),f(Be,e),f(He,e),f(qe,e),f(Se,e),f(De,e),f(Oe,e),f(tt,e),f(nt),f(ot,e),f(st),f(at),f(S),f(rt,e),f(lt),f(it,e),f(dt),f(P),f(ct),f(mt,e),f(pt),f(ut),f(A),f(gt,e),f(ht),f(ft),f(O),f(Mt,e),f(yt),f(bt),f(K),f(ee),f(_t,e)}}}const ya='{"title":"MusicGen Melody","local":"musicgen-melody","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Difference with MusicGen","local":"difference-with-musicgen","sections":[],"depth":2},{"title":"Generation","local":"generation","sections":[{"title":"Audio Conditional Generation","local":"audio-conditional-generation","sections":[],"depth":4},{"title":"Text-only Conditional Generation","local":"text-only-conditional-generation","sections":[],"depth":3},{"title":"Unconditional Generation","local":"unconditional-generation","sections":[],"depth":3},{"title":"Generation Configuration","local":"generation-configuration","sections":[],"depth":3}],"depth":2},{"title":"Model Structure","local":"model-structure","sections":[],"depth":2},{"title":"Checkpoint Conversion","local":"checkpoint-conversion","sections":[],"depth":2},{"title":"MusicgenMelodyDecoderConfig","local":"transformers.MusicgenMelodyDecoderConfig","sections":[],"depth":2},{"title":"MusicgenMelodyProcessor","local":"transformers.MusicgenMelodyProcessor","sections":[],"depth":2},{"title":"MusicgenMelodyFeatureExtractor","local":"transformers.MusicgenMelodyFeatureExtractor","sections":[],"depth":2},{"title":"MusicgenMelodyConfig","local":"transformers.MusicgenMelodyConfig","sections":[],"depth":2},{"title":"MusicgenMelodyModel","local":"transformers.MusicgenMelodyModel","sections":[],"depth":2},{"title":"MusicgenMelodyForCausalLM","local":"transformers.MusicgenMelodyForCausalLM","sections":[],"depth":2},{"title":"MusicgenMelodyForConditionalGeneration","local":"transformers.MusicgenMelodyForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function ba(U){return ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends la{constructor(c){super(),ia(this,c,ba,Ma,aa,{})}}export{Ca as component};
