import{s as is,f as ls,o as ds,n as Ke}from"../chunks/scheduler.9bc65507.js";import{S as cs,i as ms,g as n,s as r,u,A as ps,h as s,f as t,c as i,j as h,v as _,y as g,k as m,o,a as c,w as v,d as T,t as b,x as y}from"../chunks/index.78c82d43.js";import{T as pn}from"../chunks/Tip.87d55b76.js";import{D}from"../chunks/Docstring.f3d04bd2.js";import{C as $o}from"../chunks/CodeBlock.48618ec2.js";import{I as V}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Po}from"../chunks/ExampleCodeBlock.872b014d.js";function hs(M){let d,P="Example:",p,f,w;return f=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERQVE1vZGVsJTJDJTIwRFBUQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMERQVCUyMGRwdC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEUFRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBkcHQtbGFyZ2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMERQVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTModel, DPTConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DPT dpt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the dpt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){d=n("p"),d.textContent=P,p=r(),u(f.$$.fragment)},l(l){d=s(l,"P",{"data-svelte-h":!0}),g(d)!=="svelte-11lpom8"&&(d.textContent=P),p=i(l),_(f.$$.fragment,l)},m(l,$){c(l,d,$),c(l,p,$),v(f,l,$),w=!0},p:Ke,i(l){w||(T(f.$$.fragment,l),w=!0)},o(l){b(f.$$.fragment,l),w=!1},d(l){l&&(t(d),t(p)),y(f,l)}}}function fs(M){let d,P=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=n("p"),d.innerHTML=P},l(p){d=s(p,"P",{"data-svelte-h":!0}),g(d)!=="svelte-fincs2"&&(d.innerHTML=P)},m(p,f){c(p,d,f)},p:Ke,d(p){p&&t(d)}}}function gs(M){let d,P="Example:",p,f,w;return f=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMERQVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTModel.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">577</span>, <span class="hljs-number">1024</span>]`}}),{c(){d=n("p"),d.textContent=P,p=r(),u(f.$$.fragment)},l(l){d=s(l,"P",{"data-svelte-h":!0}),g(d)!=="svelte-11lpom8"&&(d.textContent=P),p=i(l),_(f.$$.fragment,l)},m(l,$){c(l,d,$),c(l,p,$),v(f,l,$),w=!0},p:Ke,i(l){w||(T(f.$$.fragment,l),w=!0)},o(l){b(f.$$.fragment,l),w=!1},d(l){l&&(t(d),t(p)),y(f,l)}}}function us(M){let d,P=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=n("p"),d.innerHTML=P},l(p){d=s(p,"P",{"data-svelte-h":!0}),g(d)!=="svelte-fincs2"&&(d.innerHTML=P)},m(p,f){c(p,d,f)},p:Ke,d(p){p&&t(d)}}}function _s(M){let d,P="Examples:",p,f,w;return f=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVEZvckRlcHRoRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMERQVEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZkcHQtbGFyZ2UlMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`}}),{c(){d=n("p"),d.textContent=P,p=r(),u(f.$$.fragment)},l(l){d=s(l,"P",{"data-svelte-h":!0}),g(d)!=="svelte-kvfsh7"&&(d.textContent=P),p=i(l),_(f.$$.fragment,l)},m(l,$){c(l,d,$),c(l,p,$),v(f,l,$),w=!0},p:Ke,i(l){w||(T(f.$$.fragment,l),w=!0)},o(l){b(f.$$.fragment,l),w=!1},d(l){l&&(t(d),t(p)),y(f,l)}}}function vs(M){let d,P=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=n("p"),d.innerHTML=P},l(p){d=s(p,"P",{"data-svelte-h":!0}),g(d)!=="svelte-fincs2"&&(d.innerHTML=P)},m(p,f){c(p,d,f)},p:Ke,d(p){p&&t(d)}}}function Ts(M){let d,P="Examples:",p,f,w;return f=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERQVEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJbnRlbCUyRmRwdC1sYXJnZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBEUFRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySW50ZWwlMkZkcHQtbGFyZ2UtYWRlJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DPTForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DPTForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-large-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){d=n("p"),d.textContent=P,p=r(),u(f.$$.fragment)},l(l){d=s(l,"P",{"data-svelte-h":!0}),g(d)!=="svelte-kvfsh7"&&(d.textContent=P),p=i(l),_(f.$$.fragment,l)},m(l,$){c(l,d,$),c(l,p,$),v(f,l,$),w=!0},p:Ke,i(l){w||(T(f.$$.fragment,l),w=!0)},o(l){b(f.$$.fragment,l),w=!1},d(l){l&&(t(d),t(p)),y(f,l)}}}function bs(M){let d,P,p,f,w,l,$,Te,Mo,et,hn="DPT",Nt,S,A,Dt,be,xo,tt,fn="Overview",Zt,ye,gn=`The DPT model was proposed in <a href="https://arxiv.org/abs/2103.13413" rel="nofollow">Vision Transformers for Dense Prediction</a> by René Ranftl, Alexey Bochkovskiy, Vladlen Koltun.
DPT is a model that leverages the <a href="vit">Vision Transformer (ViT)</a> as backbone for dense prediction tasks like semantic segmentation and depth estimation.`,Bt,we,un="The abstract from the paper is the following:",Lt,Pe,_n="<em>We introduce dense vision transformers, an architecture that leverages vision transformers in place of convolutional networks as a backbone for dense prediction tasks. We assemble tokens from various stages of the vision transformer into image-like representations at various resolutions and progressively combine them into full-resolution predictions using a convolutional decoder. The transformer backbone processes representations at a constant and relatively high resolution and has a global receptive field at every stage. These properties allow the dense vision transformer to provide finer-grained and more globally coherent predictions when compared to fully-convolutional networks. Our experiments show that this architecture yields substantial improvements on dense prediction tasks, especially when a large amount of training data is available. For monocular depth estimation, we observe an improvement of up to 28% in relative performance when compared to a state-of-the-art fully-convolutional network. When applied to semantic segmentation, dense vision transformers set a new state of the art on ADE20K with 49.02% mIoU. We further show that the architecture can be fine-tuned on smaller datasets such as NYUv2, KITTI, and Pascal Context where it also sets the new state of the art.</em>",Ht,G,vn,Vt,$e,Tn='DPT architecture. Taken from the <a href="https://arxiv.org/abs/2103.13413" target="_blank">original paper</a>.',At,Me,bn='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/isl-org/DPT" rel="nofollow">here</a>.',Gt,R,q,Ct,xe,Do,ot,yn="Resources",qt,De,wn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DPT.",Xt,Ce,Pn='<li><p>Demo notebooks for <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/DPT" rel="nofollow">here</a>.</p></li> <li><p><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></p></li> <li><p><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></p></li>',Yt,ke,$n="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Qt,W,X,kt,ze,Co,nt,Mn="DPTConfig",Ot,x,je,ko,st,xn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTModel">DPTModel</a>. It is used to instantiate an DPT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DPT
<a href="https://huggingface.co/Intel/dpt-large" rel="nofollow">Intel/dpt-large</a> architecture.`,zo,at,Dn=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jo,Y,Io,Q,Ie,Jo,rt,Cn=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,Kt,N,O,zt,Je,Eo,it,kn="DPTFeatureExtractor",eo,E,Ee,Fo,K,Fe,Uo,lt,zn="Preprocess an image or a batch of images.",So,ee,Ue,Ro,dt,jn='Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',to,Z,te,jt,Se,Wo,ct,In="DPTImageProcessor",oo,C,Re,No,mt,Jn="Constructs a DPT image processor.",Zo,oe,We,Bo,pt,En="Preprocess an image or batch of images.",Lo,ne,Ne,Ho,ht,Fn='Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',no,B,se,It,Ze,Vo,ft,Un="DPTModel",so,F,Be,Ao,gt,Sn=`The bare DPT Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Go,j,Le,qo,ut,Rn='The <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTModel">DPTModel</a> forward method, overrides the <code>__call__</code> special method.',Xo,ae,Yo,re,ao,L,ie,Jt,He,Qo,_t,Wn="DPTForDepthEstimation",ro,k,Ve,Oo,vt,Nn="DPT Model with a depth estimation head on top (consisting of 3 convolutional layers) e.g. for KITTI, NYUv2.",Ko,Tt,Zn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,en,I,Ae,tn,bt,Bn='The <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForDepthEstimation">DPTForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',on,le,nn,de,io,H,ce,Et,Ge,sn,yt,Ln="DPTForSemanticSegmentation",lo,z,qe,an,wt,Hn="DPT Model with a semantic segmentation head on top e.g. for ADE20k, CityScapes.",rn,Pt,Vn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ln,J,Xe,dn,$t,An='The <a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',cn,me,mn,pe,co,Ft,mo;return Te=new V({}),be=new V({}),xe=new V({}),ze=new V({}),je=new D({props:{name:"class transformers.DPTConfig",anchor:"transformers.DPTConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 384"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"is_hybrid",val:" = False"},{name:"qkv_bias",val:" = True"},{name:"backbone_out_indices",val:" = [2, 5, 8, 11]"},{name:"readout_type",val:" = 'project'"},{name:"reassemble_factors",val:" = [4, 2, 1, 0.5]"},{name:"neck_hidden_sizes",val:" = [96, 192, 384, 768]"},{name:"fusion_hidden_size",val:" = 256"},{name:"head_in_index",val:" = -1"},{name:"use_batch_norm_in_fusion_residual",val:" = False"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"semantic_classifier_dropout",val:" = 0.1"},{name:"backbone_featmap_shape",val:" = [1, 1024, 24, 24]"},{name:"neck_ignore_stages",val:" = [0, 1]"},{name:"backbone_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.DPTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.DPTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.DPTConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.DPTConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.DPTConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.DPTConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.DPTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DPTConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.DPTConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.DPTConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.DPTConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DPTConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.DPTConfig.backbone_out_indices",description:`<strong>backbone_out_indices</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
Indices of the intermediate hidden states to use from backbone.`,name:"backbone_out_indices"},{anchor:"transformers.DPTConfig.readout_type",description:`<strong>readout_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;project&quot;</code>) &#x2014;
The readout type to use when processing the readout token (CLS token) of the intermediate hidden states of
the ViT backbone. Can be one of [<code>&quot;ignore&quot;</code>, <code>&quot;add&quot;</code>, <code>&quot;project&quot;</code>].</p>
<ul>
<li>&#x201C;ignore&#x201D; simply ignores the CLS token.</li>
<li>&#x201C;add&#x201D; passes the information from the CLS token to all other tokens by adding the representations.</li>
<li>&#x201C;project&#x201D; passes information to the other tokens by concatenating the readout to all other tokens before
projecting the
representation to the original feature dimension D using a linear layer followed by a GELU non-linearity.</li>
</ul>`,name:"readout_type"},{anchor:"transformers.DPTConfig.is_hybrid",description:`<strong>is_hybrid</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a hybrid backbone. Useful in the context of loading DPT-Hybrid models.`,name:"is_hybrid"},{anchor:"transformers.DPTConfig.reassemble_factors",description:`<strong>reassemble_factors</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 1, 0.5]</code>) &#x2014;
The up/downsampling factors of the reassemble layers.`,name:"reassemble_factors"},{anchor:"transformers.DPTConfig.neck_hidden_sizes",description:`<strong>neck_hidden_sizes</strong> (<code>List[str]</code>, <em>optional</em>, defaults to [96, 192, 384, 768]) &#x2014;
The hidden sizes to project to for the feature maps of the backbone.`,name:"neck_hidden_sizes"},{anchor:"transformers.DPTConfig.fusion_hidden_size",description:`<strong>fusion_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of channels before fusion.`,name:"fusion_hidden_size"},{anchor:"transformers.DPTConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the heads.`,name:"head_in_index"},{anchor:"transformers.DPTConfig.use_batch_norm_in_fusion_residual",description:`<strong>use_batch_norm_in_fusion_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch normalization in the pre-activate residual units of the fusion blocks.`,name:"use_batch_norm_in_fusion_residual"},{anchor:"transformers.DPTConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.DPTConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.DPTConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"},{anchor:"transformers.DPTConfig.semantic_classifier_dropout",description:`<strong>semantic_classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the semantic classification head.`,name:"semantic_classifier_dropout"},{anchor:"transformers.DPTConfig.backbone_featmap_shape",description:`<strong>backbone_featmap_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1024, 24, 24]</code>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The shape of the feature maps of the backbone.`,name:"backbone_featmap_shape"},{anchor:"transformers.DPTConfig.neck_ignore_stages",description:`<strong>neck_ignore_stages</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[0, 1]</code>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The stages of the readout layers to ignore.`,name:"neck_ignore_stages"},{anchor:"transformers.DPTConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Union[Dict[str, Any], PretrainedConfig]</code>, <em>optional</em>) &#x2014;
Used only for the <code>hybrid</code> embedding type. The configuration of the backbone in a dictionary.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/configuration_dpt.py#L32"}}),Y=new Po({props:{anchor:"transformers.DPTConfig.example",$$slots:{default:[hs]},$$scope:{ctx:M}}}),Ie=new D({props:{name:"to_dict",anchor:"transformers.DPTConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/configuration_dpt.py#L220"}}),Je=new V({}),Ee=new D({props:{name:"class transformers.DPTFeatureExtractor",anchor:"transformers.DPTFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/feature_extraction_dpt.py#L26"}}),Fe=new D({props:{name:"__call__",anchor:"transformers.DPTFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/image_processing_utils.py#L544"}}),Ue=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DPTFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/image_processing_dpt.py#L346",returnDescription:`
<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p>semantic_segmentation</p>
`}}),Se=new V({}),Re=new D({props:{name:"class transformers.DPTImageProcessor",anchor:"transformers.DPTImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"keep_aspect_ratio",val:": bool = False"},{name:"ensure_multiple_of",val:": int = 1"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions. Can be overidden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.DPTImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 384}</code>):
Size of the image after resizing. Can be overidden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.DPTImageProcessor.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the image is resized to the largest possible size such that the aspect ratio is preserved. Can
be overidden by <code>keep_aspect_ratio</code> in <code>preprocess</code>.`,name:"keep_aspect_ratio"},{anchor:"transformers.DPTImageProcessor.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
If <code>do_resize</code> is <code>True</code>, the image is resized to a size that is a multiple of this value. Can be overidden
by <code>ensure_multiple_of</code> in <code>preprocess</code>.`,name:"ensure_multiple_of"},{anchor:"transformers.DPTImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overidden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.DPTImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overidden by <code>do_rescale</code> in
<code>preprocess</code>.`,name:"do_rescale"},{anchor:"transformers.DPTImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overidden by <code>rescale_factor</code> in <code>preprocess</code>.`,name:"rescale_factor"},{anchor:"transformers.DPTImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DPTImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DPTImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/image_processing_dpt.py#L94"}}),We=new D({props:{name:"preprocess",anchor:"transformers.DPTImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": int = None"},{name:"keep_aspect_ratio",val:": bool = None"},{name:"ensure_multiple_of",val:": int = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DPTImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DPTImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after reszing. If <code>keep_aspect_ratio</code> is <code>True</code>, the image is resized to the largest
possible size such that the aspect ratio is preserved. If <code>ensure_multiple_of</code> is set, the image is
resized to a size that is a multiple of this value.`,name:"size"},{anchor:"transformers.DPTImageProcessor.preprocess.keep_aspect_ratio",description:`<strong>keep_aspect_ratio</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.keep_aspect_ratio</code>) &#x2014;
Whether to keep the aspect ratio of the image. If False, the image will be resized to (size, size). If
True, the image will be resized to keep the aspect ratio and the size will be the maximum possible.`,name:"keep_aspect_ratio"},{anchor:"transformers.DPTImageProcessor.preprocess.ensure_multiple_of",description:`<strong>ensure_multiple_of</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.ensure_multiple_of</code>) &#x2014;
Ensure that the image size is a multiple of this value.`,name:"ensure_multiple_of"},{anchor:"transformers.DPTImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.DPTImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DPTImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DPTImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DPTImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.DPTImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.DPTImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DPTImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DPTImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/image_processing_dpt.py#L211"}}),Ne=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTForSemanticSegmentation">DPTForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.DPTImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/image_processing_dpt.py#L346",returnDescription:`
<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p>semantic_segmentation</p>
`}}),Ze=new V({}),Be=new D({props:{name:"class transformers.DPTModel",anchor:"transformers.DPTModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.DPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/modeling_dpt.py#L864"}}),Le=new D({props:{name:"forward",anchor:"transformers.DPTModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/modeling_dpt.py#L896",returnDescription:`
<p>A <code>transformers.models.dpt.modeling_dpt.BaseModelOutputWithPoolingAndIntermediateActivations</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>intermediate_activations</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Intermediate activations that can be used to compute hidden states of the model at various layers.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.models.dpt.modeling_dpt.BaseModelOutputWithPoolingAndIntermediateActivations</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new pn({props:{$$slots:{default:[fs]},$$scope:{ctx:M}}}),re=new Po({props:{anchor:"transformers.DPTModel.forward.example",$$slots:{default:[gs]},$$scope:{ctx:M}}}),He=new V({}),Ve=new D({props:{name:"class transformers.DPTForDepthEstimation",anchor:"transformers.DPTForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DPTForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/modeling_dpt.py#L1052"}}),Ae=new D({props:{name:"forward",anchor:"transformers.DPTForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DPTForDepthEstimation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DPTForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/modeling_dpt.py#L1067",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new pn({props:{$$slots:{default:[us]},$$scope:{ctx:M}}}),de=new Po({props:{anchor:"transformers.DPTForDepthEstimation.forward.example",$$slots:{default:[_s]},$$scope:{ctx:M}}}),Ge=new V({}),qe=new D({props:{name:"class transformers.DPTForSemanticSegmentation",anchor:"transformers.DPTForSemanticSegmentation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.DPTForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/vit#transformers.ViTConfig">ViTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/modeling_dpt.py#L1220"}}),Xe=new D({props:{name:"forward",anchor:"transformers.DPTForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DPTForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">DPTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DPTForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DPTForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DPTForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DPTForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DPTForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/dpt/modeling_dpt.py#L1236",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/dpt#transformers.DPTConfig"
>DPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new pn({props:{$$slots:{default:[vs]},$$scope:{ctx:M}}}),pe=new Po({props:{anchor:"transformers.DPTForSemanticSegmentation.forward.example",$$slots:{default:[Ts]},$$scope:{ctx:M}}}),{c(){d=n("meta"),P=r(),p=n("p"),f=r(),w=n("h1"),l=n("a"),$=n("span"),u(Te.$$.fragment),Mo=r(),et=n("span"),et.textContent=hn,Nt=r(),S=n("h2"),A=n("a"),Dt=n("span"),u(be.$$.fragment),xo=r(),tt=n("span"),tt.textContent=fn,Zt=r(),ye=n("p"),ye.innerHTML=gn,Bt=r(),we=n("p"),we.textContent=un,Lt=r(),Pe=n("p"),Pe.innerHTML=_n,Ht=r(),G=n("img"),Vt=r(),$e=n("small"),$e.innerHTML=Tn,At=r(),Me=n("p"),Me.innerHTML=bn,Gt=r(),R=n("h2"),q=n("a"),Ct=n("span"),u(xe.$$.fragment),Do=r(),ot=n("span"),ot.textContent=yn,qt=r(),De=n("p"),De.textContent=wn,Xt=r(),Ce=n("ul"),Ce.innerHTML=Pn,Yt=r(),ke=n("p"),ke.textContent=$n,Qt=r(),W=n("h2"),X=n("a"),kt=n("span"),u(ze.$$.fragment),Co=r(),nt=n("span"),nt.textContent=Mn,Ot=r(),x=n("div"),u(je.$$.fragment),ko=r(),st=n("p"),st.innerHTML=xn,zo=r(),at=n("p"),at.innerHTML=Dn,jo=r(),u(Y.$$.fragment),Io=r(),Q=n("div"),u(Ie.$$.fragment),Jo=r(),rt=n("p"),rt.innerHTML=Cn,Kt=r(),N=n("h2"),O=n("a"),zt=n("span"),u(Je.$$.fragment),Eo=r(),it=n("span"),it.textContent=kn,eo=r(),E=n("div"),u(Ee.$$.fragment),Fo=r(),K=n("div"),u(Fe.$$.fragment),Uo=r(),lt=n("p"),lt.textContent=zn,So=r(),ee=n("div"),u(Ue.$$.fragment),Ro=r(),dt=n("p"),dt.innerHTML=jn,to=r(),Z=n("h2"),te=n("a"),jt=n("span"),u(Se.$$.fragment),Wo=r(),ct=n("span"),ct.textContent=In,oo=r(),C=n("div"),u(Re.$$.fragment),No=r(),mt=n("p"),mt.textContent=Jn,Zo=r(),oe=n("div"),u(We.$$.fragment),Bo=r(),pt=n("p"),pt.textContent=En,Lo=r(),ne=n("div"),u(Ne.$$.fragment),Ho=r(),ht=n("p"),ht.innerHTML=Fn,no=r(),B=n("h2"),se=n("a"),It=n("span"),u(Ze.$$.fragment),Vo=r(),ft=n("span"),ft.textContent=Un,so=r(),F=n("div"),u(Be.$$.fragment),Ao=r(),gt=n("p"),gt.innerHTML=Sn,Go=r(),j=n("div"),u(Le.$$.fragment),qo=r(),ut=n("p"),ut.innerHTML=Rn,Xo=r(),u(ae.$$.fragment),Yo=r(),u(re.$$.fragment),ao=r(),L=n("h2"),ie=n("a"),Jt=n("span"),u(He.$$.fragment),Qo=r(),_t=n("span"),_t.textContent=Wn,ro=r(),k=n("div"),u(Ve.$$.fragment),Oo=r(),vt=n("p"),vt.textContent=Nn,Ko=r(),Tt=n("p"),Tt.innerHTML=Zn,en=r(),I=n("div"),u(Ae.$$.fragment),tn=r(),bt=n("p"),bt.innerHTML=Bn,on=r(),u(le.$$.fragment),nn=r(),u(de.$$.fragment),io=r(),H=n("h2"),ce=n("a"),Et=n("span"),u(Ge.$$.fragment),sn=r(),yt=n("span"),yt.textContent=Ln,lo=r(),z=n("div"),u(qe.$$.fragment),an=r(),wt=n("p"),wt.textContent=Hn,rn=r(),Pt=n("p"),Pt.innerHTML=Vn,ln=r(),J=n("div"),u(Xe.$$.fragment),dn=r(),$t=n("p"),$t.innerHTML=An,cn=r(),u(me.$$.fragment),mn=r(),u(pe.$$.fragment),co=r(),Ft=n("p"),this.h()},l(e){const a=ps("svelte-1phssyn",document.head);d=s(a,"META",{name:!0,content:!0}),a.forEach(t),P=i(e),p=s(e,"P",{}),h(p).forEach(t),f=i(e),w=s(e,"H1",{class:!0});var Ye=h(w);l=s(Ye,"A",{id:!0,class:!0,href:!0});var Ut=h(l);$=s(Ut,"SPAN",{});var St=h($);_(Te.$$.fragment,St),St.forEach(t),Ut.forEach(t),Mo=i(Ye),et=s(Ye,"SPAN",{"data-svelte-h":!0}),g(et)!=="svelte-1pwttnf"&&(et.textContent=hn),Ye.forEach(t),Nt=i(e),S=s(e,"H2",{class:!0});var Qe=h(S);A=s(Qe,"A",{id:!0,class:!0,href:!0});var Rt=h(A);Dt=s(Rt,"SPAN",{});var Wt=h(Dt);_(be.$$.fragment,Wt),Wt.forEach(t),Rt.forEach(t),xo=i(Qe),tt=s(Qe,"SPAN",{"data-svelte-h":!0}),g(tt)!=="svelte-1jsw1pg"&&(tt.textContent=fn),Qe.forEach(t),Zt=i(e),ye=s(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-19gxegr"&&(ye.innerHTML=gn),Bt=i(e),we=s(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-vfdo9a"&&(we.textContent=un),Lt=i(e),Pe=s(e,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-17tgro5"&&(Pe.innerHTML=_n),Ht=i(e),G=s(e,"IMG",{src:!0,alt:!0,width:!0}),Vt=i(e),$e=s(e,"SMALL",{"data-svelte-h":!0}),g($e)!=="svelte-6ly4vl"&&($e.innerHTML=Tn),At=i(e),Me=s(e,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-d1d7zy"&&(Me.innerHTML=bn),Gt=i(e),R=s(e,"H2",{class:!0});var Oe=h(R);q=s(Oe,"A",{id:!0,class:!0,href:!0});var Gn=h(q);Ct=s(Gn,"SPAN",{});var qn=h(Ct);_(xe.$$.fragment,qn),qn.forEach(t),Gn.forEach(t),Do=i(Oe),ot=s(Oe,"SPAN",{"data-svelte-h":!0}),g(ot)!=="svelte-w4zzv6"&&(ot.textContent=yn),Oe.forEach(t),qt=i(e),De=s(e,"P",{"data-svelte-h":!0}),g(De)!=="svelte-1b0rfkj"&&(De.textContent=wn),Xt=i(e),Ce=s(e,"UL",{"data-svelte-h":!0}),g(Ce)!=="svelte-e9iq6f"&&(Ce.innerHTML=Pn),Yt=i(e),ke=s(e,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-1xesile"&&(ke.textContent=$n),Qt=i(e),W=s(e,"H2",{class:!0});var po=h(W);X=s(po,"A",{id:!0,class:!0,href:!0});var Xn=h(X);kt=s(Xn,"SPAN",{});var Yn=h(kt);_(ze.$$.fragment,Yn),Yn.forEach(t),Xn.forEach(t),Co=i(po),nt=s(po,"SPAN",{"data-svelte-h":!0}),g(nt)!=="svelte-1a1zpdp"&&(nt.textContent=Mn),po.forEach(t),Ot=i(e),x=s(e,"DIV",{class:!0});var U=h(x);_(je.$$.fragment,U),ko=i(U),st=s(U,"P",{"data-svelte-h":!0}),g(st)!=="svelte-1ymqql1"&&(st.innerHTML=xn),zo=i(U),at=s(U,"P",{"data-svelte-h":!0}),g(at)!=="svelte-cfh5wl"&&(at.innerHTML=Dn),jo=i(U),_(Y.$$.fragment,U),Io=i(U),Q=s(U,"DIV",{class:!0});var ho=h(Q);_(Ie.$$.fragment,ho),Jo=i(ho),rt=s(ho,"P",{"data-svelte-h":!0}),g(rt)!=="svelte-1fulur6"&&(rt.innerHTML=Cn),ho.forEach(t),U.forEach(t),Kt=i(e),N=s(e,"H2",{class:!0});var fo=h(N);O=s(fo,"A",{id:!0,class:!0,href:!0});var Qn=h(O);zt=s(Qn,"SPAN",{});var On=h(zt);_(Je.$$.fragment,On),On.forEach(t),Qn.forEach(t),Eo=i(fo),it=s(fo,"SPAN",{"data-svelte-h":!0}),g(it)!=="svelte-m1hzz5"&&(it.textContent=kn),fo.forEach(t),eo=i(e),E=s(e,"DIV",{class:!0});var Mt=h(E);_(Ee.$$.fragment,Mt),Fo=i(Mt),K=s(Mt,"DIV",{class:!0});var go=h(K);_(Fe.$$.fragment,go),Uo=i(go),lt=s(go,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-khengj"&&(lt.textContent=zn),go.forEach(t),So=i(Mt),ee=s(Mt,"DIV",{class:!0});var uo=h(ee);_(Ue.$$.fragment,uo),Ro=i(uo),dt=s(uo,"P",{"data-svelte-h":!0}),g(dt)!=="svelte-tzwde"&&(dt.innerHTML=jn),uo.forEach(t),Mt.forEach(t),to=i(e),Z=s(e,"H2",{class:!0});var _o=h(Z);te=s(_o,"A",{id:!0,class:!0,href:!0});var Kn=h(te);jt=s(Kn,"SPAN",{});var es=h(jt);_(Se.$$.fragment,es),es.forEach(t),Kn.forEach(t),Wo=i(_o),ct=s(_o,"SPAN",{"data-svelte-h":!0}),g(ct)!=="svelte-pj0sp8"&&(ct.textContent=In),_o.forEach(t),oo=i(e),C=s(e,"DIV",{class:!0});var he=h(C);_(Re.$$.fragment,he),No=i(he),mt=s(he,"P",{"data-svelte-h":!0}),g(mt)!=="svelte-oc8yhy"&&(mt.textContent=Jn),Zo=i(he),oe=s(he,"DIV",{class:!0});var vo=h(oe);_(We.$$.fragment,vo),Bo=i(vo),pt=s(vo,"P",{"data-svelte-h":!0}),g(pt)!=="svelte-1x3yxsa"&&(pt.textContent=En),vo.forEach(t),Lo=i(he),ne=s(he,"DIV",{class:!0});var To=h(ne);_(Ne.$$.fragment,To),Ho=i(To),ht=s(To,"P",{"data-svelte-h":!0}),g(ht)!=="svelte-tzwde"&&(ht.innerHTML=Fn),To.forEach(t),he.forEach(t),no=i(e),B=s(e,"H2",{class:!0});var bo=h(B);se=s(bo,"A",{id:!0,class:!0,href:!0});var ts=h(se);It=s(ts,"SPAN",{});var os=h(It);_(Ze.$$.fragment,os),os.forEach(t),ts.forEach(t),Vo=i(bo),ft=s(bo,"SPAN",{"data-svelte-h":!0}),g(ft)!=="svelte-1w327hy"&&(ft.textContent=Un),bo.forEach(t),so=i(e),F=s(e,"DIV",{class:!0});var xt=h(F);_(Be.$$.fragment,xt),Ao=i(xt),gt=s(xt,"P",{"data-svelte-h":!0}),g(gt)!=="svelte-s1wkj9"&&(gt.innerHTML=Sn),Go=i(xt),j=s(xt,"DIV",{class:!0});var fe=h(j);_(Le.$$.fragment,fe),qo=i(fe),ut=s(fe,"P",{"data-svelte-h":!0}),g(ut)!=="svelte-1641lzf"&&(ut.innerHTML=Rn),Xo=i(fe),_(ae.$$.fragment,fe),Yo=i(fe),_(re.$$.fragment,fe),fe.forEach(t),xt.forEach(t),ao=i(e),L=s(e,"H2",{class:!0});var yo=h(L);ie=s(yo,"A",{id:!0,class:!0,href:!0});var ns=h(ie);Jt=s(ns,"SPAN",{});var ss=h(Jt);_(He.$$.fragment,ss),ss.forEach(t),ns.forEach(t),Qo=i(yo),_t=s(yo,"SPAN",{"data-svelte-h":!0}),g(_t)!=="svelte-1v2wwhs"&&(_t.textContent=Wn),yo.forEach(t),ro=i(e),k=s(e,"DIV",{class:!0});var ge=h(k);_(Ve.$$.fragment,ge),Oo=i(ge),vt=s(ge,"P",{"data-svelte-h":!0}),g(vt)!=="svelte-1w35xhv"&&(vt.textContent=Nn),Ko=i(ge),Tt=s(ge,"P",{"data-svelte-h":!0}),g(Tt)!=="svelte-1gjh92c"&&(Tt.innerHTML=Zn),en=i(ge),I=s(ge,"DIV",{class:!0});var ue=h(I);_(Ae.$$.fragment,ue),tn=i(ue),bt=s(ue,"P",{"data-svelte-h":!0}),g(bt)!=="svelte-1xvs6zx"&&(bt.innerHTML=Bn),on=i(ue),_(le.$$.fragment,ue),nn=i(ue),_(de.$$.fragment,ue),ue.forEach(t),ge.forEach(t),io=i(e),H=s(e,"H2",{class:!0});var wo=h(H);ce=s(wo,"A",{id:!0,class:!0,href:!0});var as=h(ce);Et=s(as,"SPAN",{});var rs=h(Et);_(Ge.$$.fragment,rs),rs.forEach(t),as.forEach(t),sn=i(wo),yt=s(wo,"SPAN",{"data-svelte-h":!0}),g(yt)!=="svelte-14vnhs6"&&(yt.textContent=Ln),wo.forEach(t),lo=i(e),z=s(e,"DIV",{class:!0});var _e=h(z);_(qe.$$.fragment,_e),an=i(_e),wt=s(_e,"P",{"data-svelte-h":!0}),g(wt)!=="svelte-a7kv1k"&&(wt.textContent=Hn),rn=i(_e),Pt=s(_e,"P",{"data-svelte-h":!0}),g(Pt)!=="svelte-1gjh92c"&&(Pt.innerHTML=Vn),ln=i(_e),J=s(_e,"DIV",{class:!0});var ve=h(J);_(Xe.$$.fragment,ve),dn=i(ve),$t=s(ve,"P",{"data-svelte-h":!0}),g($t)!=="svelte-1srd97r"&&($t.innerHTML=An),cn=i(ve),_(me.$$.fragment,ve),mn=i(ve),_(pe.$$.fragment,ve),ve.forEach(t),_e.forEach(t),co=i(e),Ft=s(e,"P",{}),h(Ft).forEach(t),this.h()},h(){m(d,"name","hf:doc:metadata"),m(d,"content",JSON.stringify(ys)),m(l,"id","dpt"),m(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(l,"href","#dpt"),m(w,"class","relative group"),m(A,"id","overview"),m(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(A,"href","#overview"),m(S,"class","relative group"),ls(G.src,vn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/dpt_architecture.jpg")||m(G,"src",vn),m(G,"alt","drawing"),m(G,"width","600"),m(q,"id","resources"),m(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(q,"href","#resources"),m(R,"class","relative group"),m(X,"id","transformers.DPTConfig"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#transformers.DPTConfig"),m(W,"class","relative group"),m(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(O,"id","transformers.DPTFeatureExtractor"),m(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(O,"href","#transformers.DPTFeatureExtractor"),m(N,"class","relative group"),m(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(te,"id","transformers.DPTImageProcessor"),m(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(te,"href","#transformers.DPTImageProcessor"),m(Z,"class","relative group"),m(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(se,"id","transformers.DPTModel"),m(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(se,"href","#transformers.DPTModel"),m(B,"class","relative group"),m(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ie,"id","transformers.DPTForDepthEstimation"),m(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ie,"href","#transformers.DPTForDepthEstimation"),m(L,"class","relative group"),m(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ce,"id","transformers.DPTForSemanticSegmentation"),m(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ce,"href","#transformers.DPTForSemanticSegmentation"),m(H,"class","relative group"),m(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){o(document.head,d),c(e,P,a),c(e,p,a),c(e,f,a),c(e,w,a),o(w,l),o(l,$),v(Te,$,null),o(w,Mo),o(w,et),c(e,Nt,a),c(e,S,a),o(S,A),o(A,Dt),v(be,Dt,null),o(S,xo),o(S,tt),c(e,Zt,a),c(e,ye,a),c(e,Bt,a),c(e,we,a),c(e,Lt,a),c(e,Pe,a),c(e,Ht,a),c(e,G,a),c(e,Vt,a),c(e,$e,a),c(e,At,a),c(e,Me,a),c(e,Gt,a),c(e,R,a),o(R,q),o(q,Ct),v(xe,Ct,null),o(R,Do),o(R,ot),c(e,qt,a),c(e,De,a),c(e,Xt,a),c(e,Ce,a),c(e,Yt,a),c(e,ke,a),c(e,Qt,a),c(e,W,a),o(W,X),o(X,kt),v(ze,kt,null),o(W,Co),o(W,nt),c(e,Ot,a),c(e,x,a),v(je,x,null),o(x,ko),o(x,st),o(x,zo),o(x,at),o(x,jo),v(Y,x,null),o(x,Io),o(x,Q),v(Ie,Q,null),o(Q,Jo),o(Q,rt),c(e,Kt,a),c(e,N,a),o(N,O),o(O,zt),v(Je,zt,null),o(N,Eo),o(N,it),c(e,eo,a),c(e,E,a),v(Ee,E,null),o(E,Fo),o(E,K),v(Fe,K,null),o(K,Uo),o(K,lt),o(E,So),o(E,ee),v(Ue,ee,null),o(ee,Ro),o(ee,dt),c(e,to,a),c(e,Z,a),o(Z,te),o(te,jt),v(Se,jt,null),o(Z,Wo),o(Z,ct),c(e,oo,a),c(e,C,a),v(Re,C,null),o(C,No),o(C,mt),o(C,Zo),o(C,oe),v(We,oe,null),o(oe,Bo),o(oe,pt),o(C,Lo),o(C,ne),v(Ne,ne,null),o(ne,Ho),o(ne,ht),c(e,no,a),c(e,B,a),o(B,se),o(se,It),v(Ze,It,null),o(B,Vo),o(B,ft),c(e,so,a),c(e,F,a),v(Be,F,null),o(F,Ao),o(F,gt),o(F,Go),o(F,j),v(Le,j,null),o(j,qo),o(j,ut),o(j,Xo),v(ae,j,null),o(j,Yo),v(re,j,null),c(e,ao,a),c(e,L,a),o(L,ie),o(ie,Jt),v(He,Jt,null),o(L,Qo),o(L,_t),c(e,ro,a),c(e,k,a),v(Ve,k,null),o(k,Oo),o(k,vt),o(k,Ko),o(k,Tt),o(k,en),o(k,I),v(Ae,I,null),o(I,tn),o(I,bt),o(I,on),v(le,I,null),o(I,nn),v(de,I,null),c(e,io,a),c(e,H,a),o(H,ce),o(ce,Et),v(Ge,Et,null),o(H,sn),o(H,yt),c(e,lo,a),c(e,z,a),v(qe,z,null),o(z,an),o(z,wt),o(z,rn),o(z,Pt),o(z,ln),o(z,J),v(Xe,J,null),o(J,dn),o(J,$t),o(J,cn),v(me,J,null),o(J,mn),v(pe,J,null),c(e,co,a),c(e,Ft,a),mo=!0},p(e,[a]){const Ye={};a&2&&(Ye.$$scope={dirty:a,ctx:e}),Y.$set(Ye);const Ut={};a&2&&(Ut.$$scope={dirty:a,ctx:e}),ae.$set(Ut);const St={};a&2&&(St.$$scope={dirty:a,ctx:e}),re.$set(St);const Qe={};a&2&&(Qe.$$scope={dirty:a,ctx:e}),le.$set(Qe);const Rt={};a&2&&(Rt.$$scope={dirty:a,ctx:e}),de.$set(Rt);const Wt={};a&2&&(Wt.$$scope={dirty:a,ctx:e}),me.$set(Wt);const Oe={};a&2&&(Oe.$$scope={dirty:a,ctx:e}),pe.$set(Oe)},i(e){mo||(T(Te.$$.fragment,e),T(be.$$.fragment,e),T(xe.$$.fragment,e),T(ze.$$.fragment,e),T(je.$$.fragment,e),T(Y.$$.fragment,e),T(Ie.$$.fragment,e),T(Je.$$.fragment,e),T(Ee.$$.fragment,e),T(Fe.$$.fragment,e),T(Ue.$$.fragment,e),T(Se.$$.fragment,e),T(Re.$$.fragment,e),T(We.$$.fragment,e),T(Ne.$$.fragment,e),T(Ze.$$.fragment,e),T(Be.$$.fragment,e),T(Le.$$.fragment,e),T(ae.$$.fragment,e),T(re.$$.fragment,e),T(He.$$.fragment,e),T(Ve.$$.fragment,e),T(Ae.$$.fragment,e),T(le.$$.fragment,e),T(de.$$.fragment,e),T(Ge.$$.fragment,e),T(qe.$$.fragment,e),T(Xe.$$.fragment,e),T(me.$$.fragment,e),T(pe.$$.fragment,e),mo=!0)},o(e){b(Te.$$.fragment,e),b(be.$$.fragment,e),b(xe.$$.fragment,e),b(ze.$$.fragment,e),b(je.$$.fragment,e),b(Y.$$.fragment,e),b(Ie.$$.fragment,e),b(Je.$$.fragment,e),b(Ee.$$.fragment,e),b(Fe.$$.fragment,e),b(Ue.$$.fragment,e),b(Se.$$.fragment,e),b(Re.$$.fragment,e),b(We.$$.fragment,e),b(Ne.$$.fragment,e),b(Ze.$$.fragment,e),b(Be.$$.fragment,e),b(Le.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(He.$$.fragment,e),b(Ve.$$.fragment,e),b(Ae.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(Ge.$$.fragment,e),b(qe.$$.fragment,e),b(Xe.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),mo=!1},d(e){e&&(t(P),t(p),t(f),t(w),t(Nt),t(S),t(Zt),t(ye),t(Bt),t(we),t(Lt),t(Pe),t(Ht),t(G),t(Vt),t($e),t(At),t(Me),t(Gt),t(R),t(qt),t(De),t(Xt),t(Ce),t(Yt),t(ke),t(Qt),t(W),t(Ot),t(x),t(Kt),t(N),t(eo),t(E),t(to),t(Z),t(oo),t(C),t(no),t(B),t(so),t(F),t(ao),t(L),t(ro),t(k),t(io),t(H),t(lo),t(z),t(co),t(Ft)),t(d),y(Te),y(be),y(xe),y(ze),y(je),y(Y),y(Ie),y(Je),y(Ee),y(Fe),y(Ue),y(Se),y(Re),y(We),y(Ne),y(Ze),y(Be),y(Le),y(ae),y(re),y(He),y(Ve),y(Ae),y(le),y(de),y(Ge),y(qe),y(Xe),y(me),y(pe)}}}const ys={local:"dpt",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.DPTConfig",title:"DPTConfig"},{local:"transformers.DPTFeatureExtractor",title:"DPTFeatureExtractor"},{local:"transformers.DPTImageProcessor",title:"DPTImageProcessor"},{local:"transformers.DPTModel",title:"DPTModel"},{local:"transformers.DPTForDepthEstimation",title:"DPTForDepthEstimation"},{local:"transformers.DPTForSemanticSegmentation",title:"DPTForSemanticSegmentation"}],title:"DPT"};function ws(M){return ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends cs{constructor(d){super(),ms(this,d,ws,bs,is,{})}}export{zs as component};
