import{s as cn,f as pn,o as mn,n as tt}from"../chunks/scheduler.9bc65507.js";import{S as hn,i as un,g as o,s as i,u as g,A as fn,h as n,f as t,c as d,j as h,v as _,y as f,k as p,o as r,a,w as v,d as b,t as y,x as w}from"../chunks/index.78c82d43.js";import{T as wo}from"../chunks/Tip.87d55b76.js";import{D as Z}from"../chunks/Docstring.f3d04bd2.js";import{C as $o}from"../chunks/CodeBlock.48618ec2.js";import{I as ae}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Mo}from"../chunks/ExampleCodeBlock.872b014d.js";function gn(P){let l,$=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){l=o("p"),l.innerHTML=$},l(m){l=n(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-j665pk"&&(l.innerHTML=$)},m(m,u){a(m,l,u)},p:tt,d(m){m&&t(l)}}}function _n(P){let l,$="Example:",m,u,M;return u=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdMUE5Nb2RlbCUyQyUyMEdMUE5Db25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR0xQTiUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR0xQTkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GLPNModel, GLPNConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GLPN vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GLPNConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){l=o("p"),l.textContent=$,m=i(),g(u.$$.fragment)},l(c){l=n(c,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=$),m=d(c),_(u.$$.fragment,c)},m(c,T){a(c,l,T),a(c,m,T),v(u,c,T),M=!0},p:tt,i(c){M||(b(u.$$.fragment,c),M=!0)},o(c){y(u.$$.fragment,c),M=!1},d(c){c&&(t(l),t(m)),w(u,c)}}}function vn(P){let l,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=$},l(m){l=n(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-fincs2"&&(l.innerHTML=$)},m(m,u){a(m,l,u)},p:tt,d(m){m&&t(l)}}}function bn(P){let l,$="Example:",m,u,M;return u=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">15</span>, <span class="hljs-number">20</span>]`}}),{c(){l=o("p"),l.textContent=$,m=i(),g(u.$$.fragment)},l(c){l=n(c,"P",{"data-svelte-h":!0}),f(l)!=="svelte-11lpom8"&&(l.textContent=$),m=d(c),_(u.$$.fragment,c)},m(c,T){a(c,l,T),a(c,m,T),v(u,c,T),M=!0},p:tt,i(c){M||(b(u.$$.fragment,c),M=!0)},o(c){y(u.$$.fragment,c),M=!1},d(c){c&&(t(l),t(m)),w(u,c)}}}function yn(P){let l,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=$},l(m){l=n(m,"P",{"data-svelte-h":!0}),f(l)!=="svelte-fincs2"&&(l.innerHTML=$)},m(m,u){a(m,l,u)},p:tt,d(m){m&&t(l)}}}function wn(P){let l,$="Examples:",m,u,M;return u=new $o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`}}),{c(){l=o("p"),l.textContent=$,m=i(),g(u.$$.fragment)},l(c){l=n(c,"P",{"data-svelte-h":!0}),f(l)!=="svelte-kvfsh7"&&(l.textContent=$),m=d(c),_(u.$$.fragment,c)},m(c,T){a(c,l,T),a(c,m,T),v(u,c,T),M=!0},p:tt,i(c){M||(b(u.$$.fragment,c),M=!0)},o(c){y(u.$$.fragment,c),M=!1},d(c){c&&(t(l),t(m)),w(u,c)}}}function Mn(P){let l,$,m,u,M,c,T,le,Vt,ke,To="GLPN",ut,W,ft,E,B,ot,ie,qt,Je,Po="Overview",gt,de,No=`The GLPN model was proposed in <a href="https://arxiv.org/abs/2201.07436" rel="nofollow">Global-Local Path Networks for Monocular Depth Estimation with Vertical CutDepth</a>  by Doyeon Kim, Woonghyun Ga, Pyungwhan Ahn, Donggyu Joo, Sehwan Chun, Junmo Kim.
GLPN combines <a href="segformer">SegFormer</a>’s hierarchical mix-Transformer with a lightweight decoder for monocular depth estimation. The proposed decoder shows better performance than the previously proposed decoders, with considerably
less computational complexity.`,_t,ce,xo="The abstract from the paper is the following:",vt,pe,Go="<em>Depth estimation from a single image is an important task that can be applied to various fields in computer vision, and has grown rapidly with the development of convolutional neural networks. In this paper, we propose a novel structure and training strategy for monocular depth estimation to further improve the prediction accuracy of the network. We deploy a hierarchical transformer encoder to capture and convey the global context, and design a lightweight yet powerful decoder to generate an estimated depth map while considering local connectivity. By constructing connected paths between multi-scale local features and the global decoding stream with our proposed selective feature fusion module, the network can integrate both representations and recover fine details. In addition, the proposed decoder shows better performance than the previously proposed decoders, with considerably less computational complexity. Furthermore, we improve the depth-specific augmentation method by utilizing an important observation in depth estimation to enhance the model. Our network achieves state-of-the-art performance over the challenging depth dataset NYU Depth V2. Extensive experiments have been conducted to validate and show the effectiveness of the proposed approach. Finally, our model shows better generalisation ability and robustness than other comparative models.</em>",bt,me,Lo="Tips:",yt,he,Co='<li>One can use <a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNImageProcessor">GLPNImageProcessor</a> to prepare images for the model.</li>',wt,S,jo,Mt,ue,Eo='Summary of the approach. Taken from the <a href="https://arxiv.org/abs/2201.07436" target="_blank">original paper</a>.',$t,fe,Io='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/vinvino02/GLPDepth" rel="nofollow">here</a>.',Tt,I,H,nt,ge,Qt,ze,Uo="Resources",Pt,_e,ko="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with GLPN.",Nt,ve,Jo='<li>Demo notebooks for <a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/GLPN" rel="nofollow">here</a>.</li> <li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li>',xt,U,A,st,be,Yt,Fe,zo="GLPNConfig",Gt,N,ye,Ot,Re,Fo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a>. It is used to instantiate an GLPN
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the GLPN
<a href="https://huggingface.co/vinvino02/glpn-kitti" rel="nofollow">vinvino02/glpn-kitti</a> architecture.`,Kt,Ze,Ro=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,eo,D,Lt,k,X,rt,we,to,We,Zo="GLPNFeatureExtractor",Ct,J,Me,oo,V,$e,no,Be,Wo="Preprocess an image or a batch of images.",jt,z,q,at,Te,so,Se,Bo="GLPNImageProcessor",Et,L,Pe,ro,He,So="Constructs a GLPN image processor.",ao,Q,Ne,lo,Ae,Ho="Preprocess the given images.",It,F,Y,lt,xe,io,De,Ao="GLPNModel",Ut,C,Ge,co,Xe,Do=`The bare GLPN encoder (Mix-Transformer) outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,po,x,Le,mo,Ve,Xo='The <a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> forward method, overrides the <code>__call__</code> special method.',ho,O,uo,K,kt,R,ee,it,Ce,fo,qe,Vo="GLPNForDepthEstimation",Jt,j,je,go,Qe,qo=`GLPN Model transformer with a lightweight depth estimation head on top e.g. for KITTI, NYUv2.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,_o,G,Ee,vo,Ye,Qo='The <a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',bo,te,yo,oe,zt,dt,Ft;return le=new ae({}),W=new wo({props:{$$slots:{default:[gn]},$$scope:{ctx:P}}}),ie=new ae({}),ge=new ae({}),be=new ae({}),ye=new Z({props:{name:"class transformers.GLPNConfig",anchor:"transformers.GLPNConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"num_encoder_blocks",val:" = 4"},{name:"depths",val:" = [2, 2, 2, 2]"},{name:"sr_ratios",val:" = [8, 4, 2, 1]"},{name:"hidden_sizes",val:" = [32, 64, 160, 256]"},{name:"patch_sizes",val:" = [7, 3, 3, 3]"},{name:"strides",val:" = [4, 2, 2, 2]"},{name:"num_attention_heads",val:" = [1, 2, 5, 8]"},{name:"mlp_ratios",val:" = [4, 4, 4, 4]"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"drop_path_rate",val:" = 0.1"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"decoder_hidden_size",val:" = 64"},{name:"max_depth",val:" = 10"},{name:"head_in_index",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.GLPNConfig.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of encoder blocks (i.e. stages in the Mix Transformer encoder).`,name:"num_encoder_blocks"},{anchor:"transformers.GLPNConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2, 2]</code>) &#x2014;
The number of layers in each encoder block.`,name:"depths"},{anchor:"transformers.GLPNConfig.sr_ratios",description:`<strong>sr_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 4, 2, 1]</code>) &#x2014;
Sequence reduction ratios in each encoder block.`,name:"sr_ratios"},{anchor:"transformers.GLPNConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 160, 256]</code>) &#x2014;
Dimension of each of the encoder blocks.`,name:"hidden_sizes"},{anchor:"transformers.GLPNConfig.patch_sizes",description:`<strong>patch_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[7, 3, 3, 3]</code>) &#x2014;
Patch size before each encoder block.`,name:"patch_sizes"},{anchor:"transformers.GLPNConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 2, 2]</code>) &#x2014;
Stride before each encoder block.`,name:"strides"},{anchor:"transformers.GLPNConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 4, 8]</code>) &#x2014;
Number of attention heads for each attention layer in each block of the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GLPNConfig.mlp_ratios",description:`<strong>mlp_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 4, 4, 4]</code>) &#x2014;
Ratio of the size of the hidden layer compared to the size of the input layer of the Mix FFNs in the
encoder blocks.`,name:"mlp_ratios"},{anchor:"transformers.GLPNConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.GLPNConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.GLPNConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.GLPNConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GLPNConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for stochastic depth, used in the blocks of the Transformer encoder.`,name:"drop_path_rate"},{anchor:"transformers.GLPNConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GLPNConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The dimension of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.GLPNConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The maximum depth of the decoder.`,name:"max_depth"},{anchor:"transformers.GLPNConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the head.`,name:"head_in_index"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/configuration_glpn.py#L29"}}),D=new Mo({props:{anchor:"transformers.GLPNConfig.example",$$slots:{default:[_n]},$$scope:{ctx:P}}}),we=new ae({}),Me=new Z({props:{name:"class transformers.GLPNFeatureExtractor",anchor:"transformers.GLPNFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/feature_extraction_glpn.py#L26"}}),$e=new Z({props:{name:"__call__",anchor:"transformers.GLPNFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/image_processing_utils.py#L544"}}),Te=new ae({}),Pe=new Z({props:{name:"class transformers.GLPNImageProcessor",anchor:"transformers.GLPNImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:" = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions, rounding them down to the closest multiple of
<code>size_divisor</code>. Can be overridden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the closest
multiple of <code>size_divisor</code>. Can be overridden by <code>size_divisor</code> in <code>preprocess</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.). Can be
overridden by <code>do_rescale</code> in <code>preprocess</code>.`,name:"do_rescale"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/image_processing_glpn.py#L40"}}),Ne=new Z({props:{name:"preprocess",anchor:"transformers.GLPNImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), transformers.utils.generic.TensorType, typing.List[ForwardRef('PIL.Image.Image')], typing.List[transformers.utils.generic.TensorType]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>TensorType</code> or <code>List[np.ndarray]</code> or <code>List[TensorType]</code>) &#x2014;
Images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the input such that the (height, width) dimensions are a multiple of <code>size_divisor</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.preprocess.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisor</code>) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the
closest multiple of <code>size_divisor</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PIL.Image</code> resampling filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.GLPNImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GLPNImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GLPNImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/image_processing_glpn.py#L124"}}),xe=new ae({}),Ge=new Z({props:{name:"class transformers.GLPNModel",anchor:"transformers.GLPNModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/modeling_glpn.py#L483"}}),Le=new Z({props:{name:"forward",anchor:"transformers.GLPNModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/modeling_glpn.py#L503",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new wo({props:{$$slots:{default:[vn]},$$scope:{ctx:P}}}),K=new Mo({props:{anchor:"transformers.GLPNModel.forward.example",$$slots:{default:[bn]},$$scope:{ctx:P}}}),Ce=new ae({}),je=new Z({props:{name:"class transformers.GLPNForDepthEstimation",anchor:"transformers.GLPNForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/modeling_glpn.py#L684"}}),Ee=new Z({props:{name:"forward",anchor:"transformers.GLPNForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.33.3/en/model_doc/mobilevit#transformers.MobileViTFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GLPNForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/glpn/modeling_glpn.py#L695",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new wo({props:{$$slots:{default:[yn]},$$scope:{ctx:P}}}),oe=new Mo({props:{anchor:"transformers.GLPNForDepthEstimation.forward.example",$$slots:{default:[wn]},$$scope:{ctx:P}}}),{c(){l=o("meta"),$=i(),m=o("p"),u=i(),M=o("h1"),c=o("a"),T=o("span"),g(le.$$.fragment),Vt=i(),ke=o("span"),ke.textContent=To,ut=i(),g(W.$$.fragment),ft=i(),E=o("h2"),B=o("a"),ot=o("span"),g(ie.$$.fragment),qt=i(),Je=o("span"),Je.textContent=Po,gt=i(),de=o("p"),de.innerHTML=No,_t=i(),ce=o("p"),ce.textContent=xo,vt=i(),pe=o("p"),pe.innerHTML=Go,bt=i(),me=o("p"),me.textContent=Lo,yt=i(),he=o("ul"),he.innerHTML=Co,wt=i(),S=o("img"),Mt=i(),ue=o("small"),ue.innerHTML=Eo,$t=i(),fe=o("p"),fe.innerHTML=Io,Tt=i(),I=o("h2"),H=o("a"),nt=o("span"),g(ge.$$.fragment),Qt=i(),ze=o("span"),ze.textContent=Uo,Pt=i(),_e=o("p"),_e.textContent=ko,Nt=i(),ve=o("ul"),ve.innerHTML=Jo,xt=i(),U=o("h2"),A=o("a"),st=o("span"),g(be.$$.fragment),Yt=i(),Fe=o("span"),Fe.textContent=zo,Gt=i(),N=o("div"),g(ye.$$.fragment),Ot=i(),Re=o("p"),Re.innerHTML=Fo,Kt=i(),Ze=o("p"),Ze.innerHTML=Ro,eo=i(),g(D.$$.fragment),Lt=i(),k=o("h2"),X=o("a"),rt=o("span"),g(we.$$.fragment),to=i(),We=o("span"),We.textContent=Zo,Ct=i(),J=o("div"),g(Me.$$.fragment),oo=i(),V=o("div"),g($e.$$.fragment),no=i(),Be=o("p"),Be.textContent=Wo,jt=i(),z=o("h2"),q=o("a"),at=o("span"),g(Te.$$.fragment),so=i(),Se=o("span"),Se.textContent=Bo,Et=i(),L=o("div"),g(Pe.$$.fragment),ro=i(),He=o("p"),He.textContent=So,ao=i(),Q=o("div"),g(Ne.$$.fragment),lo=i(),Ae=o("p"),Ae.textContent=Ho,It=i(),F=o("h2"),Y=o("a"),lt=o("span"),g(xe.$$.fragment),io=i(),De=o("span"),De.textContent=Ao,Ut=i(),C=o("div"),g(Ge.$$.fragment),co=i(),Xe=o("p"),Xe.innerHTML=Do,po=i(),x=o("div"),g(Le.$$.fragment),mo=i(),Ve=o("p"),Ve.innerHTML=Xo,ho=i(),g(O.$$.fragment),uo=i(),g(K.$$.fragment),kt=i(),R=o("h2"),ee=o("a"),it=o("span"),g(Ce.$$.fragment),fo=i(),qe=o("span"),qe.textContent=Vo,Jt=i(),j=o("div"),g(je.$$.fragment),go=i(),Qe=o("p"),Qe.innerHTML=qo,_o=i(),G=o("div"),g(Ee.$$.fragment),vo=i(),Ye=o("p"),Ye.innerHTML=Qo,bo=i(),g(te.$$.fragment),yo=i(),g(oe.$$.fragment),zt=i(),dt=o("p"),this.h()},l(e){const s=fn("svelte-1phssyn",document.head);l=n(s,"META",{name:!0,content:!0}),s.forEach(t),$=d(e),m=n(e,"P",{}),h(m).forEach(t),u=d(e),M=n(e,"H1",{class:!0});var Ie=h(M);c=n(Ie,"A",{id:!0,class:!0,href:!0});var ct=h(c);T=n(ct,"SPAN",{});var pt=h(T);_(le.$$.fragment,pt),pt.forEach(t),ct.forEach(t),Vt=d(Ie),ke=n(Ie,"SPAN",{"data-svelte-h":!0}),f(ke)!=="svelte-lgdb5u"&&(ke.textContent=To),Ie.forEach(t),ut=d(e),_(W.$$.fragment,e),ft=d(e),E=n(e,"H2",{class:!0});var Ue=h(E);B=n(Ue,"A",{id:!0,class:!0,href:!0});var mt=h(B);ot=n(mt,"SPAN",{});var ht=h(ot);_(ie.$$.fragment,ht),ht.forEach(t),mt.forEach(t),qt=d(Ue),Je=n(Ue,"SPAN",{"data-svelte-h":!0}),f(Je)!=="svelte-1jsw1pg"&&(Je.textContent=Po),Ue.forEach(t),gt=d(e),de=n(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1rdmycr"&&(de.innerHTML=No),_t=d(e),ce=n(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-vfdo9a"&&(ce.textContent=xo),vt=d(e),pe=n(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-l8ay4x"&&(pe.innerHTML=Go),bt=d(e),me=n(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-axv494"&&(me.textContent=Lo),yt=d(e),he=n(e,"UL",{"data-svelte-h":!0}),f(he)!=="svelte-1zgfif"&&(he.innerHTML=Co),wt=d(e),S=n(e,"IMG",{src:!0,alt:!0,width:!0}),Mt=d(e),ue=n(e,"SMALL",{"data-svelte-h":!0}),f(ue)!=="svelte-bacs7t"&&(ue.innerHTML=Eo),$t=d(e),fe=n(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1grdklu"&&(fe.innerHTML=Io),Tt=d(e),I=n(e,"H2",{class:!0});var Rt=h(I);H=n(Rt,"A",{id:!0,class:!0,href:!0});var Yo=h(H);nt=n(Yo,"SPAN",{});var Oo=h(nt);_(ge.$$.fragment,Oo),Oo.forEach(t),Yo.forEach(t),Qt=d(Rt),ze=n(Rt,"SPAN",{"data-svelte-h":!0}),f(ze)!=="svelte-w4zzv6"&&(ze.textContent=Uo),Rt.forEach(t),Pt=d(e),_e=n(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-fq64ti"&&(_e.textContent=ko),Nt=d(e),ve=n(e,"UL",{"data-svelte-h":!0}),f(ve)!=="svelte-cs78w2"&&(ve.innerHTML=Jo),xt=d(e),U=n(e,"H2",{class:!0});var Zt=h(U);A=n(Zt,"A",{id:!0,class:!0,href:!0});var Ko=h(A);st=n(Ko,"SPAN",{});var en=h(st);_(be.$$.fragment,en),en.forEach(t),Ko.forEach(t),Yt=d(Zt),Fe=n(Zt,"SPAN",{"data-svelte-h":!0}),f(Fe)!=="svelte-hu2uz4"&&(Fe.textContent=zo),Zt.forEach(t),Gt=d(e),N=n(e,"DIV",{class:!0});var ne=h(N);_(ye.$$.fragment,ne),Ot=d(ne),Re=n(ne,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-19os4ca"&&(Re.innerHTML=Fo),Kt=d(ne),Ze=n(ne,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-cfh5wl"&&(Ze.innerHTML=Ro),eo=d(ne),_(D.$$.fragment,ne),ne.forEach(t),Lt=d(e),k=n(e,"H2",{class:!0});var Wt=h(k);X=n(Wt,"A",{id:!0,class:!0,href:!0});var tn=h(X);rt=n(tn,"SPAN",{});var on=h(rt);_(we.$$.fragment,on),on.forEach(t),tn.forEach(t),to=d(Wt),We=n(Wt,"SPAN",{"data-svelte-h":!0}),f(We)!=="svelte-2966t0"&&(We.textContent=Zo),Wt.forEach(t),Ct=d(e),J=n(e,"DIV",{class:!0});var Bt=h(J);_(Me.$$.fragment,Bt),oo=d(Bt),V=n(Bt,"DIV",{class:!0});var St=h(V);_($e.$$.fragment,St),no=d(St),Be=n(St,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-khengj"&&(Be.textContent=Wo),St.forEach(t),Bt.forEach(t),jt=d(e),z=n(e,"H2",{class:!0});var Ht=h(z);q=n(Ht,"A",{id:!0,class:!0,href:!0});var nn=h(q);at=n(nn,"SPAN",{});var sn=h(at);_(Te.$$.fragment,sn),sn.forEach(t),nn.forEach(t),so=d(Ht),Se=n(Ht,"SPAN",{"data-svelte-h":!0}),f(Se)!=="svelte-1lyodnv"&&(Se.textContent=Bo),Ht.forEach(t),Et=d(e),L=n(e,"DIV",{class:!0});var Oe=h(L);_(Pe.$$.fragment,Oe),ro=d(Oe),He=n(Oe,"P",{"data-svelte-h":!0}),f(He)!=="svelte-1e6g6g5"&&(He.textContent=So),ao=d(Oe),Q=n(Oe,"DIV",{class:!0});var At=h(Q);_(Ne.$$.fragment,At),lo=d(At),Ae=n(At,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-tvrlms"&&(Ae.textContent=Ho),At.forEach(t),Oe.forEach(t),It=d(e),F=n(e,"H2",{class:!0});var Dt=h(F);Y=n(Dt,"A",{id:!0,class:!0,href:!0});var rn=h(Y);lt=n(rn,"SPAN",{});var an=h(lt);_(xe.$$.fragment,an),an.forEach(t),rn.forEach(t),io=d(Dt),De=n(Dt,"SPAN",{"data-svelte-h":!0}),f(De)!=="svelte-tsr49"&&(De.textContent=Ao),Dt.forEach(t),Ut=d(e),C=n(e,"DIV",{class:!0});var Ke=h(C);_(Ge.$$.fragment,Ke),co=d(Ke),Xe=n(Ke,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-dvd88g"&&(Xe.innerHTML=Do),po=d(Ke),x=n(Ke,"DIV",{class:!0});var se=h(x);_(Le.$$.fragment,se),mo=d(se),Ve=n(se,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-13yo5lg"&&(Ve.innerHTML=Xo),ho=d(se),_(O.$$.fragment,se),uo=d(se),_(K.$$.fragment,se),se.forEach(t),Ke.forEach(t),kt=d(e),R=n(e,"H2",{class:!0});var Xt=h(R);ee=n(Xt,"A",{id:!0,class:!0,href:!0});var ln=h(ee);it=n(ln,"SPAN",{});var dn=h(it);_(Ce.$$.fragment,dn),dn.forEach(t),ln.forEach(t),fo=d(Xt),qe=n(Xt,"SPAN",{"data-svelte-h":!0}),f(qe)!=="svelte-1cmw9m7"&&(qe.textContent=Vo),Xt.forEach(t),Jt=d(e),j=n(e,"DIV",{class:!0});var et=h(j);_(je.$$.fragment,et),go=d(et),Qe=n(et,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-1ec4khr"&&(Qe.innerHTML=qo),_o=d(et),G=n(et,"DIV",{class:!0});var re=h(G);_(Ee.$$.fragment,re),vo=d(re),Ye=n(re,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1mam7ug"&&(Ye.innerHTML=Qo),bo=d(re),_(te.$$.fragment,re),yo=d(re),_(oe.$$.fragment,re),re.forEach(t),et.forEach(t),zt=d(e),dt=n(e,"P",{}),h(dt).forEach(t),this.h()},h(){p(l,"name","hf:doc:metadata"),p(l,"content",JSON.stringify($n)),p(c,"id","glpn"),p(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(c,"href","#glpn"),p(M,"class","relative group"),p(B,"id","overview"),p(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(B,"href","#overview"),p(E,"class","relative group"),pn(S.src,jo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/glpn_architecture.jpg")||p(S,"src",jo),p(S,"alt","drawing"),p(S,"width","600"),p(H,"id","resources"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#resources"),p(I,"class","relative group"),p(A,"id","transformers.GLPNConfig"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#transformers.GLPNConfig"),p(U,"class","relative group"),p(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(X,"id","transformers.GLPNFeatureExtractor"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#transformers.GLPNFeatureExtractor"),p(k,"class","relative group"),p(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(q,"id","transformers.GLPNImageProcessor"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#transformers.GLPNImageProcessor"),p(z,"class","relative group"),p(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Y,"id","transformers.GLPNModel"),p(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Y,"href","#transformers.GLPNModel"),p(F,"class","relative group"),p(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ee,"id","transformers.GLPNForDepthEstimation"),p(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ee,"href","#transformers.GLPNForDepthEstimation"),p(R,"class","relative group"),p(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){r(document.head,l),a(e,$,s),a(e,m,s),a(e,u,s),a(e,M,s),r(M,c),r(c,T),v(le,T,null),r(M,Vt),r(M,ke),a(e,ut,s),v(W,e,s),a(e,ft,s),a(e,E,s),r(E,B),r(B,ot),v(ie,ot,null),r(E,qt),r(E,Je),a(e,gt,s),a(e,de,s),a(e,_t,s),a(e,ce,s),a(e,vt,s),a(e,pe,s),a(e,bt,s),a(e,me,s),a(e,yt,s),a(e,he,s),a(e,wt,s),a(e,S,s),a(e,Mt,s),a(e,ue,s),a(e,$t,s),a(e,fe,s),a(e,Tt,s),a(e,I,s),r(I,H),r(H,nt),v(ge,nt,null),r(I,Qt),r(I,ze),a(e,Pt,s),a(e,_e,s),a(e,Nt,s),a(e,ve,s),a(e,xt,s),a(e,U,s),r(U,A),r(A,st),v(be,st,null),r(U,Yt),r(U,Fe),a(e,Gt,s),a(e,N,s),v(ye,N,null),r(N,Ot),r(N,Re),r(N,Kt),r(N,Ze),r(N,eo),v(D,N,null),a(e,Lt,s),a(e,k,s),r(k,X),r(X,rt),v(we,rt,null),r(k,to),r(k,We),a(e,Ct,s),a(e,J,s),v(Me,J,null),r(J,oo),r(J,V),v($e,V,null),r(V,no),r(V,Be),a(e,jt,s),a(e,z,s),r(z,q),r(q,at),v(Te,at,null),r(z,so),r(z,Se),a(e,Et,s),a(e,L,s),v(Pe,L,null),r(L,ro),r(L,He),r(L,ao),r(L,Q),v(Ne,Q,null),r(Q,lo),r(Q,Ae),a(e,It,s),a(e,F,s),r(F,Y),r(Y,lt),v(xe,lt,null),r(F,io),r(F,De),a(e,Ut,s),a(e,C,s),v(Ge,C,null),r(C,co),r(C,Xe),r(C,po),r(C,x),v(Le,x,null),r(x,mo),r(x,Ve),r(x,ho),v(O,x,null),r(x,uo),v(K,x,null),a(e,kt,s),a(e,R,s),r(R,ee),r(ee,it),v(Ce,it,null),r(R,fo),r(R,qe),a(e,Jt,s),a(e,j,s),v(je,j,null),r(j,go),r(j,Qe),r(j,_o),r(j,G),v(Ee,G,null),r(G,vo),r(G,Ye),r(G,bo),v(te,G,null),r(G,yo),v(oe,G,null),a(e,zt,s),a(e,dt,s),Ft=!0},p(e,[s]){const Ie={};s&2&&(Ie.$$scope={dirty:s,ctx:e}),W.$set(Ie);const ct={};s&2&&(ct.$$scope={dirty:s,ctx:e}),D.$set(ct);const pt={};s&2&&(pt.$$scope={dirty:s,ctx:e}),O.$set(pt);const Ue={};s&2&&(Ue.$$scope={dirty:s,ctx:e}),K.$set(Ue);const mt={};s&2&&(mt.$$scope={dirty:s,ctx:e}),te.$set(mt);const ht={};s&2&&(ht.$$scope={dirty:s,ctx:e}),oe.$set(ht)},i(e){Ft||(b(le.$$.fragment,e),b(W.$$.fragment,e),b(ie.$$.fragment,e),b(ge.$$.fragment,e),b(be.$$.fragment,e),b(ye.$$.fragment,e),b(D.$$.fragment,e),b(we.$$.fragment,e),b(Me.$$.fragment,e),b($e.$$.fragment,e),b(Te.$$.fragment,e),b(Pe.$$.fragment,e),b(Ne.$$.fragment,e),b(xe.$$.fragment,e),b(Ge.$$.fragment,e),b(Le.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(Ce.$$.fragment,e),b(je.$$.fragment,e),b(Ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),Ft=!0)},o(e){y(le.$$.fragment,e),y(W.$$.fragment,e),y(ie.$$.fragment,e),y(ge.$$.fragment,e),y(be.$$.fragment,e),y(ye.$$.fragment,e),y(D.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y($e.$$.fragment,e),y(Te.$$.fragment,e),y(Pe.$$.fragment,e),y(Ne.$$.fragment,e),y(xe.$$.fragment,e),y(Ge.$$.fragment,e),y(Le.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y(Ee.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),Ft=!1},d(e){e&&(t($),t(m),t(u),t(M),t(ut),t(ft),t(E),t(gt),t(de),t(_t),t(ce),t(vt),t(pe),t(bt),t(me),t(yt),t(he),t(wt),t(S),t(Mt),t(ue),t($t),t(fe),t(Tt),t(I),t(Pt),t(_e),t(Nt),t(ve),t(xt),t(U),t(Gt),t(N),t(Lt),t(k),t(Ct),t(J),t(jt),t(z),t(Et),t(L),t(It),t(F),t(Ut),t(C),t(kt),t(R),t(Jt),t(j),t(zt),t(dt)),t(l),w(le),w(W,e),w(ie),w(ge),w(be),w(ye),w(D),w(we),w(Me),w($e),w(Te),w(Pe),w(Ne),w(xe),w(Ge),w(Le),w(O),w(K),w(Ce),w(je),w(Ee),w(te),w(oe)}}}const $n={local:"glpn",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.GLPNConfig",title:"GLPNConfig"},{local:"transformers.GLPNFeatureExtractor",title:"GLPNFeatureExtractor"},{local:"transformers.GLPNImageProcessor",title:"GLPNImageProcessor"},{local:"transformers.GLPNModel",title:"GLPNModel"},{local:"transformers.GLPNForDepthEstimation",title:"GLPNForDepthEstimation"}],title:"GLPN"};function Tn(P){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class En extends hn{constructor(l){super(),un(this,l,Tn,Mn,cn,{})}}export{En as component};
