import{s as Xn,n as Fn,o as Ln}from"../chunks/scheduler.889ebb13.js";import{S as Pn,i as Kn,g as e,s as p,u,A as Dn,h as n,f as t,c as i,j as o,v as j,y as h,k as c,o as r,a,w as m,d as y,t as M,x as g}from"../chunks/index.8980e686.js";import{I as J}from"../chunks/IconCopyLink.357761cd.js";import{C as x}from"../chunks/CodeBlock.25fc3430.js";function On(pe){let d,ll,qt,al,f,G,Vt,ss,Ea,dt,ie="🤗 Transformers로 할 수 있는 것",el,ts,re=`🤗 Transformers는 자연어처리(NLP), 컴퓨터 비전, 오디오 및 음성 처리 작업에 대한 사전훈련된 최첨단 모델 라이브러리입니다.
이 라이브러리는 트랜스포머 모델뿐만 아니라 컴퓨터 비전 작업을 위한 현대적인 합성곱 신경망과 같은 트랜스포머가 아닌 모델도 포함하고 있습니다.`,nl,ls,ce=`스마트폰, 앱, 텔레비전과 같은 오늘날 가장 인기 있는 소비자 제품을 살펴보면, 딥러닝 기술이 그 뒤에 사용되고 있을 확률이 높습니다.
스마트폰으로 촬영한 사진에서 배경 객체를 제거하고 싶다면 어떻게 할까요? 이는 파놉틱 세그멘테이션 작업의 예입니다(아직 이게 무엇인지 모른다면, 다음 섹션에서 설명하겠습니다!).`,pl,as,he="이 페이지는 다양한 음성 및 오디오, 컴퓨터 비전, NLP 작업을 🤗 Transformers 라이브러리를 활용하여 다루는 간단한 예제를 3줄의 코드로 제공합니다.",il,U,q,Rt,es,Qa,ft,oe="오디오",rl,ns,ue=`음성 및 오디오 처리 작업은 다른 모달리티와 약간 다릅니다. 이는 주로 오디오가 연속적인 신호로 입력되기 때문입니다.
텍스트와 달리 원본 오디오 파형(waveform)은 문장이 단어로 나눠지는 것처럼 깔끔하게 이산적인 묶음으로 나눌 수 없습니다.
이를 극복하기 위해 원본 오디오 신호는 일정한 간격으로 샘플링됩니다. 해당 간격 내에서 더 많은 샘플을 취할 경우 샘플링률이 높아지며, 오디오는 원본 오디오 소스에 더 가까워집니다.`,cl,ps,je=`과거의 접근 방식은 오디오에서 유용한 특징을 추출하기 위해 오디오를 전처리하는 것이었습니다.
하지만 현재는 원본 오디오 파형을 특성 인코더에 직접 넣어서 오디오 표현(representation)을 추출하는 것이 더 일반적입니다.
이렇게 하면 전처리 단계가 단순해지고 모델이 가장 중요한 특징을 학습할 수 있습니다.`,hl,w,V,Et,is,za,Ut,me="오디오 분류",ol,rs,ye="오디오 분류는 오디오 데이터에 미리 정의된 클래스 집합의 레이블을 지정하는 작업입니다. 이는 많은 구체적인 응용 프로그램을 포함한 넓은 범주입니다.",ul,cs,Me="일부 예시는 다음과 같습니다:",jl,hs,ge="<li>음향 장면 분류: 오디오에 장면 레이블(“사무실”, “해변”, “경기장”)을 지정합니다.</li> <li>음향 이벤트 감지: 오디오에 소리 이벤트 레이블(“차 경적”, “고래 울음소리”, “유리 파손”)을 지정합니다.</li> <li>태깅: 여러 가지 소리(새 지저귐, 회의에서의 화자 식별)가 포함된 오디오에 레이블을 지정합니다.</li> <li>음악 분류: 음악에 장르 레이블(“메탈”, “힙합”, “컨트리”)을 지정합니다.</li>",ml,os,yl,b,R,Qt,us,Aa,wt,Je="자동 음성 인식",Ml,js,xe=`자동 음성 인식(ASR)은 음성을 텍스트로 변환하는 작업입니다.
음성은 인간의 자연스러운 의사소통 형태이기 때문에 ASR은 가장 일반적인 오디오 작업 중 하나입니다.
오늘날 ASR 시스템은 스피커, 전화 및 자동차와 같은 “스마트” 기술 제품에 내장되어 있습니다.
우리는 가상 비서에게 음악 재생, 알림 설정 및 날씨 정보를 요청할 수 있습니다.`,gl,ms,de="하지만 트랜스포머 아키텍처가 해결하는 데 도움을 준 핵심 도전 과제 중 하나는 양이 데이터 양이 적은 언어(low-resource language)에 대한 것입니다. 대량의 음성 데이터로 사전 훈련한 후 데이터 양이 적은 언어에서 레이블이 지정된 음성 데이터 1시간만으로 모델을 미세 조정하면 이전의 100배 많은 레이블이 지정된 데이터로 훈련된 ASR 시스템보다 훨씬 더 높은 품질의 결과를 얻을 수 있습니다.",Jl,ys,xl,v,E,zt,Ms,Sa,bt,fe="컴퓨터 비전",dl,gs,Ue='컴퓨터 비전 작업 중 가장 초기의 성공적인 작업 중 하나는 <a href="glossary#convolution">합성곱 신경망(CNN)</a>을 사용하여 우편번호 숫자 이미지를 인식하는 것이었습니다. 이미지는 픽셀로 구성되어 있으며 각 픽셀은 숫자 값으로 표현됩니다. 이로써 이미지를 픽셀 값의 행렬로 나타내는 것이 쉬워집니다. 특정한 픽셀 값의 조합은 이미지의 색상을 의미합니다.',fl,Js,we="컴퓨터 비전 작업은 일반적으로 다음 두 가지 방법으로 접근 가능합니다:",Ul,xs,be="<li><p>합성곱을 사용하여 이미지의 낮은 수준 특징에서 높은 수준의 추상적인 요소까지 계층적으로 학습합니다.</p></li> <li><p>이미지를 패치로 나누고 트랜스포머를 사용하여 점진적으로 각 이미지 패치가 서로 어떠한 방식으로 연관되어 이미지를 형성하는지 학습합니다. <code>CNN</code>에서 선호하는 상향식 접근법과는 달리, 이 방식은 흐릿한 이미지로 초안을 그리고 점진적으로 선명한 이미지로 만들어가는 것과 유사합니다.</p></li>",wl,T,Q,At,ds,Ya,vt,ve="이미지 분류",bl,fs,Te="이미지 분류는 한 개의 전체 이미지에 미리 정의된 클래스 집합의 레이블을 지정하는 작업입니다.",vl,Us,Ce="대부분의 분류 작업과 마찬가지로, 이미지 분류에는 다양한 실용적인 용도가 있으며, 일부 예시는 다음과 같습니다:",Tl,ws,Ie="<li>의료: 질병을 감지하거나 환자 건강을 모니터링하기 위해 의료 이미지에 레이블을 지정합니다.</li> <li>환경: 위성 이미지를 분류하여 산림 벌채를 감시하고 야생 지역 관리를 위한 정보를 제공하거나 산불을 감지합니다.</li> <li>농업: 작물 이미지를 분류하여 식물 건강을 확인하거나 위성 이미지를 분류하여 토지 이용 관찰에 사용합니다.</li> <li>생태학: 동물이나 식물 종 이미지를 분류하여 야생 동물 개체군을 조사하거나 멸종 위기에 처한 종을 추적합니다.</li>",Cl,bs,Il,C,z,St,vs,Xa,Tt,Ze="객체 탐지",Zl,Ts,ke="이미지 분류와 달리 객체 탐지는 이미지 내에서 여러 객체를 식별하고 바운딩 박스로 정의된 객체의 위치를 파악합니다.",kl,Cs,Be="객체 탐지의 몇 가지 응용 예시는 다음과 같습니다:",Bl,Is,$e="<li>자율 주행 차량: 다른 차량, 보행자 및 신호등과 같은 일상적인 교통 객체를 감지합니다.</li> <li>원격 감지: 재난 모니터링, 도시 계획 및 기상 예측 등을 수행합니다.</li> <li>결함 탐지: 건물의 균열이나 구조적 손상, 제조 결함 등을 탐지합니다.</li>",$l,Zs,Wl,I,A,Yt,ks,Fa,Ct,We="이미지 분할",_l,Bs,_e="이미지 분할은 픽셀 차원의 작업으로, 이미지 내의 모든 픽셀을 클래스에 할당합니다. 이는 객체 탐지와 다릅니다. 객체 탐지는 바운딩 박스를 사용하여 이미지 내의 객체를 레이블링하고 예측하는 반면, 분할은 더 세분화된 작업입니다. 분할은 픽셀 수준에서 객체를 감지할 수 있습니다.",Hl,$s,He="이미지 분할에는 여러 유형이 있습니다:",Nl,Ws,Ne="<li>인스턴스 분할: 개체의 클래스를 레이블링하는 것 외에도, 개체의 각 구분된 인스턴스에도 레이블을 지정합니다 (“개-1”, “개-2” 등).</li> <li>파놉틱 분할: 의미적 분할과 인스턴스 분할의 조합입니다. 각 픽셀을 의미적 클래스로 레이블링하는 <strong>동시에</strong> 개체의 각각 구분된 인스턴스로도 레이블을 지정합니다.</li>",Gl,_s,Ge="분할 작업은 자율 주행 차량에서 유용하며, 주변 환경의 픽셀 수준 지도를 생성하여 보행자와 다른 차량 주변에서 안전하게 탐색할 수 있습니다. 또한 의료 영상에서도 유용합니다. 분할 작업이 픽셀 수준에서 객체를 감지할 수 있기 때문에 비정상적인 세포나 장기의 특징을 식별하는 데 도움이 될 수 있습니다. 이미지 분할은 의류 가상 시착이나 카메라를 통해 실제 세계에 가상 개체를 덧씌워 증강 현실 경험을 만드는 등 전자 상거래 분야에서도 사용될 수 있습니다.",ql,Hs,Vl,Z,S,Xt,Ns,La,It,qe="깊이 추정",Rl,Gs,Ve="깊이 추정은 카메라로부터 이미지 내부의 각 픽셀의 거리를 예측합니다. 이 컴퓨터 비전 작업은 특히 장면 이해와 재구성에 중요합니다. 예를 들어, 자율 주행 차량은 보행자, 교통 표지판 및 다른 차량과 같은 객체와의 거리를 이해하여 장애물과 충돌을 피해야 합니다. 깊이 정보는 또한 2D 이미지에서 3D 표현을 구성하는 데 도움이 되며 생물학적 구조나 건물의 고품질 3D 표현을 생성하는 데 사용될 수 있습니다.",El,qs,Re="깊이 추정에는 두 가지 접근 방식이 있습니다:",Ql,Vs,Ee="<li>스테레오: 약간 다른 각도에서 촬영된 동일한 이미지 두 장을 비교하여 깊이를 추정합니다.</li> <li>단안: 단일 이미지에서 깊이를 추정합니다.</li>",zl,Rs,Al,k,Y,Ft,Es,Pa,Zt,Qe="자연어처리",Sl,Qs,ze="텍스트는 인간이 의사 소통하는 자연스러운 방식 중 하나이기 때문에 자연어처리 역시 가장 일반적인 작업 유형 중 하나입니다. 모델이 인식하는 형식으로 텍스트를 변환하려면 토큰화해야 합니다. 이는 텍스트 시퀀스를 개별 단어 또는 하위 단어(토큰)로 분할한 다음 이러한 토큰을 숫자로 변환하는 것을 의미합니다. 결과적으로 텍스트 시퀀스를 숫자 시퀀스로 표현할 수 있으며, 숫자 시퀀스를 다양한 자연어처리 작업을 해결하기 위한 모델에 입력할 수 있습니다!",Yl,B,X,Lt,zs,Ka,kt,Ae="텍스트 분류",Xl,As,Se="다른 모달리티에서의 분류 작업과 마찬가지로 텍스트 분류는 미리 정의된 클래스 집합에서 텍스트 시퀀스(문장 수준, 단락 또는 문서 등)에 레이블을 지정합니다. 텍스트 분류에는 다양한 실용적인 응용 사례가 있으며, 일부 예시는 다음과 같습니다:",Fl,Ss,Ye="<li>감성 분석: 텍스트를 <code>긍정</code> 또는 <code>부정</code>과 같은 어떤 극성에 따라 레이블링하여 정치, 금융, 마케팅과 같은 분야에서 의사 결정에 정보를 제공하고 지원할 수 있습니다.</li> <li>콘텐츠 분류: 텍스트를 주제에 따라 레이블링(날씨, 스포츠, 금융 등)하여 뉴스 및 소셜 미디어 피드에서 정보를 구성하고 필터링하는 데 도움이 될 수 있습니다.</li>",Ll,Ys,Pl,$,F,Pt,Xs,Da,Bt,Xe="토큰 분류",Kl,Fs,Fe='모든 자연어처리 작업에서는 텍스트가 개별 단어나 하위 단어로 분리되어 전처리됩니다. 분리된 단어를 <a href="/glossary#token">토큰</a>이라고 합니다. 토큰 분류는 각 토큰에 미리 정의된 클래스 집합의 레이블을 할당합니다.',Dl,Ls,Le="토큰 분류의 두 가지 일반적인 유형은 다음과 같습니다:",Ol,Ps,Pe="<li>개체명 인식 (NER): 토큰을 조직, 인물, 위치 또는 날짜와 같은 개체 범주에 따라 레이블링합니다. NER은 특히 유전체학적인 환경에서 유전자, 단백질 및 약물 이름에 레이블을 지정하는 데 널리 사용됩니다.</li> <li>품사 태깅 (POS): 명사, 동사, 형용사와 같은 품사에 따라 토큰에 레이블을 할당합니다. POS는 번역 시스템이 동일한 단어가 문법적으로 어떻게 다른지 이해하는 데 도움이 됩니다 (명사로 사용되는 “bank(은행)“과 동사로 사용되는 “bank(예금을 예치하다)“과 같은 경우).</li>",sa,Ks,ta,W,L,Kt,Ds,Oa,$t,Ke="질의응답",la,Os,De="질의응답은 또 하나의 토큰 차원의 작업으로, 문맥이 있을 때(개방형 도메인)와 문맥이 없을 때(폐쇄형 도메인) 질문에 대한 답변을 반환합니다. 이 작업은 가상 비서에게 식당이 영업 중인지와 같은 질문을 할 때마다 발생할 수 있습니다. 고객 지원 또는 기술 지원을 제공하거나 검색 엔진이 요청한 정보를 검색하는 데 도움을 줄 수 있습니다.",aa,st,Oe="질문 답변에는 일반적으로 두 가지 유형이 있습니다:",ea,tt,sn="<li>추출형: 질문과 문맥이 주어졌을 때, 모델이 주어진 문맥의 일부에서 가져온 텍스트의 범위를 답변으로 합니다.</li> <li>생성형: 질문과 문맥이 주어졌을 때, 주어진 문맥을 통해 답변을 생성합니다. 이 접근 방식은 <code>QuestionAnsweringPipeline</code> 대신 <code>Text2TextGenerationPipeline</code>을 통해 처리됩니다.</li>",na,lt,pa,_,P,Dt,at,se,Wt,tn="요약",ia,et,ln="요약은 원본 문서의 의미를 최대한 보존하면서 긴 문서를 짧은 문서로 만드는 작업입니다. 요약은 <code>sequence-to-sequence</code> 작업입니다. 입력보다 짧은 텍스트 시퀀스를 출력합니다. 요약 작업은 독자가 장문 문서들의 주요 포인트를 빠르게 이해하는 데 도움을 줄 수 있습니다. 입법안, 법률 및 금융 문서, 특허 및 과학 논문은 요약 작업이 독자의 시간을 절약하고 독서 보조 도구로 사용될 수 있는 몇 가지 예시입니다.",ra,nt,an="질문 답변과 마찬가지로 요약에는 두 가지 유형이 있습니다:",ca,pt,en="<li>추출형: 원본 텍스트에서 가장 중요한 문장을 식별하고 추출합니다.</li> <li>생성형: 원본 텍스트에서 목표 요약을 생성합니다. 입력 문서에 없는 새로운 단어를 포함할 수도 있습니다. <code>SummarizationPipeline</code>은 생성형 접근 방식을 사용합니다.</li>",ha,it,oa,H,K,Ot,rt,te,_t,nn="번역",ua,ct,pn="번역은 한 언어로 된 텍스트 시퀀스를 다른 언어로 변환하는 작업입니다. 이는 서로 다른 배경을 가진 사람들이 서로 소통하는 데 도움을 주는 중요한 역할을 합니다. 더 넓은 대중에게 콘텐츠를 번역하여 전달하거나, 새로운 언어를 배우는 데 도움이 되는 학습 도구가 될 수도 있습니다. 요약과 마찬가지로, 번역은 <code>sequence-to-sequence</code> 작업입니다. 즉, 모델은 입력 시퀀스를 받아서 출력이 되는 목표 시퀀스를 반환합니다.",ja,ht,rn="초기의 번역 모델은 대부분 단일 언어로 이루어져 있었지만, 최근에는 많은 언어 쌍 간에 번역을 수행할 수 있는 다중 언어 모델에 대한 관심이 높아지고 있습니다.",ma,ot,ya,N,D,sl,ut,le,Ht,cn="언어 모델링",Ma,jt,hn="언어 모델링은 텍스트 시퀀스에서 단어를 예측하는 작업입니다. 사전 훈련된 언어 모델은 많은 다른 하위 작업에 따라 미세 조정될 수 있기 때문에 매우 인기 있는 자연어처리 작업이 되었습니다. 최근에는 제로 샷(zero-shot) 또는 퓨 샷(few-shot) 학습이 가능한 대규모 언어 모델(Large Language Models, LLM)에 대한 많은 관심이 발생하고 있습니다. 이는 모델이 명시적으로 훈련되지 않은 작업도 해결할 수 있다는 것을 의미합니다! 언어 모델은 유창하고 설득력 있는 텍스트를 생성하는 데 사용될 수 있지만, 텍스트가 항상 정확하지는 않을 수 있으므로 주의가 필요합니다.",ga,mt,on="언어 모델링에는 두 가지 유형이 있습니다:",Ja,O,yt,Nt,un="인과적 언어 모델링: 이 모델의 목적은 시퀀스에서 다음 토큰을 예측하는 것이며, 미래 토큰이 마스킹 됩니다.",ae,Mt,ee,gt,Gt,jn="마스킹된 언어 모델링: 이 모델의 목적은 시퀀스 내의 마스킹된 토큰을 예측하는 것이며, 시퀀스 내의 모든 토큰에 대한 접근이 제공됩니다.",ne,Jt,xa,xt,mn='이 페이지를 통해 각 모달리티의 다양한 작업 유형과 각 작업의 실용적 중요성에 대해 추가적인 배경 정보를 얻으셨기를 바랍니다. 다음 <a href="tasks_explained">섹션</a>에서는 🤗 Transformer가 이러한 작업을 해결하는 <strong>방법</strong>에 대해 알아보실 수 있습니다.',da,tl,fa;return ss=new J({}),es=new J({}),is=new J({}),os=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`}}),us=new J({}),ys=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`}}),Ms=new J({}),ds=new J({}),bs=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`}}),vs=new J({}),Zs=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`}}),ks=new J({}),Hs=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`}}),Ns=new J({}),Rs=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`}}),Es=new J({}),zs=new J({}),Ys=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`}}),Xs=new J({}),Ks=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`}}),Ds=new J({}),lt=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`}}),at=new J({}),it=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`}}),rt=new J({}),ot=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`}}),ut=new J({}),Mt=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`}}),Jt=new x({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`}}),{c(){d=e("meta"),ll=p(),qt=e("p"),al=p(),f=e("h1"),G=e("a"),Vt=e("span"),u(ss.$$.fragment),Ea=p(),dt=e("span"),dt.textContent=ie,el=p(),ts=e("p"),ts.textContent=re,nl=p(),ls=e("p"),ls.textContent=ce,pl=p(),as=e("p"),as.textContent=he,il=p(),U=e("h2"),q=e("a"),Rt=e("span"),u(es.$$.fragment),Qa=p(),ft=e("span"),ft.textContent=oe,rl=p(),ns=e("p"),ns.textContent=ue,cl=p(),ps=e("p"),ps.textContent=je,hl=p(),w=e("h3"),V=e("a"),Et=e("span"),u(is.$$.fragment),za=p(),Ut=e("span"),Ut.textContent=me,ol=p(),rs=e("p"),rs.textContent=ye,ul=p(),cs=e("p"),cs.textContent=Me,jl=p(),hs=e("ul"),hs.innerHTML=ge,ml=p(),u(os.$$.fragment),yl=p(),b=e("h3"),R=e("a"),Qt=e("span"),u(us.$$.fragment),Aa=p(),wt=e("span"),wt.textContent=Je,Ml=p(),js=e("p"),js.textContent=xe,gl=p(),ms=e("p"),ms.textContent=de,Jl=p(),u(ys.$$.fragment),xl=p(),v=e("h2"),E=e("a"),zt=e("span"),u(Ms.$$.fragment),Sa=p(),bt=e("span"),bt.textContent=fe,dl=p(),gs=e("p"),gs.innerHTML=Ue,fl=p(),Js=e("p"),Js.textContent=we,Ul=p(),xs=e("ol"),xs.innerHTML=be,wl=p(),T=e("h3"),Q=e("a"),At=e("span"),u(ds.$$.fragment),Ya=p(),vt=e("span"),vt.textContent=ve,bl=p(),fs=e("p"),fs.textContent=Te,vl=p(),Us=e("p"),Us.textContent=Ce,Tl=p(),ws=e("ul"),ws.innerHTML=Ie,Cl=p(),u(bs.$$.fragment),Il=p(),C=e("h3"),z=e("a"),St=e("span"),u(vs.$$.fragment),Xa=p(),Tt=e("span"),Tt.textContent=Ze,Zl=p(),Ts=e("p"),Ts.textContent=ke,kl=p(),Cs=e("p"),Cs.textContent=Be,Bl=p(),Is=e("ul"),Is.innerHTML=$e,$l=p(),u(Zs.$$.fragment),Wl=p(),I=e("h3"),A=e("a"),Yt=e("span"),u(ks.$$.fragment),Fa=p(),Ct=e("span"),Ct.textContent=We,_l=p(),Bs=e("p"),Bs.textContent=_e,Hl=p(),$s=e("p"),$s.textContent=He,Nl=p(),Ws=e("ul"),Ws.innerHTML=Ne,Gl=p(),_s=e("p"),_s.textContent=Ge,ql=p(),u(Hs.$$.fragment),Vl=p(),Z=e("h3"),S=e("a"),Xt=e("span"),u(Ns.$$.fragment),La=p(),It=e("span"),It.textContent=qe,Rl=p(),Gs=e("p"),Gs.textContent=Ve,El=p(),qs=e("p"),qs.textContent=Re,Ql=p(),Vs=e("ul"),Vs.innerHTML=Ee,zl=p(),u(Rs.$$.fragment),Al=p(),k=e("h2"),Y=e("a"),Ft=e("span"),u(Es.$$.fragment),Pa=p(),Zt=e("span"),Zt.textContent=Qe,Sl=p(),Qs=e("p"),Qs.textContent=ze,Yl=p(),B=e("h3"),X=e("a"),Lt=e("span"),u(zs.$$.fragment),Ka=p(),kt=e("span"),kt.textContent=Ae,Xl=p(),As=e("p"),As.textContent=Se,Fl=p(),Ss=e("ul"),Ss.innerHTML=Ye,Ll=p(),u(Ys.$$.fragment),Pl=p(),$=e("h3"),F=e("a"),Pt=e("span"),u(Xs.$$.fragment),Da=p(),Bt=e("span"),Bt.textContent=Xe,Kl=p(),Fs=e("p"),Fs.innerHTML=Fe,Dl=p(),Ls=e("p"),Ls.textContent=Le,Ol=p(),Ps=e("ul"),Ps.innerHTML=Pe,sa=p(),u(Ks.$$.fragment),ta=p(),W=e("h3"),L=e("a"),Kt=e("span"),u(Ds.$$.fragment),Oa=p(),$t=e("span"),$t.textContent=Ke,la=p(),Os=e("p"),Os.textContent=De,aa=p(),st=e("p"),st.textContent=Oe,ea=p(),tt=e("ul"),tt.innerHTML=sn,na=p(),u(lt.$$.fragment),pa=p(),_=e("h3"),P=e("a"),Dt=e("span"),u(at.$$.fragment),se=p(),Wt=e("span"),Wt.textContent=tn,ia=p(),et=e("p"),et.innerHTML=ln,ra=p(),nt=e("p"),nt.textContent=an,ca=p(),pt=e("ul"),pt.innerHTML=en,ha=p(),u(it.$$.fragment),oa=p(),H=e("h3"),K=e("a"),Ot=e("span"),u(rt.$$.fragment),te=p(),_t=e("span"),_t.textContent=nn,ua=p(),ct=e("p"),ct.innerHTML=pn,ja=p(),ht=e("p"),ht.textContent=rn,ma=p(),u(ot.$$.fragment),ya=p(),N=e("h3"),D=e("a"),sl=e("span"),u(ut.$$.fragment),le=p(),Ht=e("span"),Ht.textContent=cn,Ma=p(),jt=e("p"),jt.textContent=hn,ga=p(),mt=e("p"),mt.textContent=on,Ja=p(),O=e("ul"),yt=e("li"),Nt=e("p"),Nt.textContent=un,ae=p(),u(Mt.$$.fragment),ee=p(),gt=e("li"),Gt=e("p"),Gt.textContent=jn,ne=p(),u(Jt.$$.fragment),xa=p(),xt=e("p"),xt.innerHTML=mn,da=p(),tl=e("p"),this.h()},l(s){const l=Dn("svelte-1phssyn",document.head);d=n(l,"META",{name:!0,content:!0}),l.forEach(t),ll=i(s),qt=n(s,"P",{}),o(qt).forEach(t),al=i(s),f=n(s,"H1",{class:!0});var Ua=o(f);G=n(Ua,"A",{id:!0,class:!0,href:!0});var yn=o(G);Vt=n(yn,"SPAN",{});var Mn=o(Vt);j(ss.$$.fragment,Mn),Mn.forEach(t),yn.forEach(t),Ea=i(Ua),dt=n(Ua,"SPAN",{"data-svelte-h":!0}),h(dt)!=="svelte-lps4tb"&&(dt.textContent=ie),Ua.forEach(t),el=i(s),ts=n(s,"P",{"data-svelte-h":!0}),h(ts)!=="svelte-10idx7x"&&(ts.textContent=re),nl=i(s),ls=n(s,"P",{"data-svelte-h":!0}),h(ls)!=="svelte-rz0m0r"&&(ls.textContent=ce),pl=i(s),as=n(s,"P",{"data-svelte-h":!0}),h(as)!=="svelte-d62f10"&&(as.textContent=he),il=i(s),U=n(s,"H2",{class:!0});var wa=o(U);q=n(wa,"A",{id:!0,class:!0,href:!0});var gn=o(q);Rt=n(gn,"SPAN",{});var Jn=o(Rt);j(es.$$.fragment,Jn),Jn.forEach(t),gn.forEach(t),Qa=i(wa),ft=n(wa,"SPAN",{"data-svelte-h":!0}),h(ft)!=="svelte-10ppf2f"&&(ft.textContent=oe),wa.forEach(t),rl=i(s),ns=n(s,"P",{"data-svelte-h":!0}),h(ns)!=="svelte-13r673m"&&(ns.textContent=ue),cl=i(s),ps=n(s,"P",{"data-svelte-h":!0}),h(ps)!=="svelte-qps12j"&&(ps.textContent=je),hl=i(s),w=n(s,"H3",{class:!0});var ba=o(w);V=n(ba,"A",{id:!0,class:!0,href:!0});var xn=o(V);Et=n(xn,"SPAN",{});var dn=o(Et);j(is.$$.fragment,dn),dn.forEach(t),xn.forEach(t),za=i(ba),Ut=n(ba,"SPAN",{"data-svelte-h":!0}),h(Ut)!=="svelte-vjgcqp"&&(Ut.textContent=me),ba.forEach(t),ol=i(s),rs=n(s,"P",{"data-svelte-h":!0}),h(rs)!=="svelte-18pih3a"&&(rs.textContent=ye),ul=i(s),cs=n(s,"P",{"data-svelte-h":!0}),h(cs)!=="svelte-9ctq6o"&&(cs.textContent=Me),jl=i(s),hs=n(s,"UL",{"data-svelte-h":!0}),h(hs)!=="svelte-5dixf0"&&(hs.innerHTML=ge),ml=i(s),j(os.$$.fragment,s),yl=i(s),b=n(s,"H3",{class:!0});var va=o(b);R=n(va,"A",{id:!0,class:!0,href:!0});var fn=o(R);Qt=n(fn,"SPAN",{});var Un=o(Qt);j(us.$$.fragment,Un),Un.forEach(t),fn.forEach(t),Aa=i(va),wt=n(va,"SPAN",{"data-svelte-h":!0}),h(wt)!=="svelte-krl0ci"&&(wt.textContent=Je),va.forEach(t),Ml=i(s),js=n(s,"P",{"data-svelte-h":!0}),h(js)!=="svelte-cdyfh4"&&(js.textContent=xe),gl=i(s),ms=n(s,"P",{"data-svelte-h":!0}),h(ms)!=="svelte-190cybw"&&(ms.textContent=de),Jl=i(s),j(ys.$$.fragment,s),xl=i(s),v=n(s,"H2",{class:!0});var Ta=o(v);E=n(Ta,"A",{id:!0,class:!0,href:!0});var wn=o(E);zt=n(wn,"SPAN",{});var bn=o(zt);j(Ms.$$.fragment,bn),bn.forEach(t),wn.forEach(t),Sa=i(Ta),bt=n(Ta,"SPAN",{"data-svelte-h":!0}),h(bt)!=="svelte-11r341x"&&(bt.textContent=fe),Ta.forEach(t),dl=i(s),gs=n(s,"P",{"data-svelte-h":!0}),h(gs)!=="svelte-lp1ekz"&&(gs.innerHTML=Ue),fl=i(s),Js=n(s,"P",{"data-svelte-h":!0}),h(Js)!=="svelte-uo6axu"&&(Js.textContent=we),Ul=i(s),xs=n(s,"OL",{"data-svelte-h":!0}),h(xs)!=="svelte-imx589"&&(xs.innerHTML=be),wl=i(s),T=n(s,"H3",{class:!0});var Ca=o(T);Q=n(Ca,"A",{id:!0,class:!0,href:!0});var vn=o(Q);At=n(vn,"SPAN",{});var Tn=o(At);j(ds.$$.fragment,Tn),Tn.forEach(t),vn.forEach(t),Ya=i(Ca),vt=n(Ca,"SPAN",{"data-svelte-h":!0}),h(vt)!=="svelte-mmw9bt"&&(vt.textContent=ve),Ca.forEach(t),bl=i(s),fs=n(s,"P",{"data-svelte-h":!0}),h(fs)!=="svelte-1o1g4f9"&&(fs.textContent=Te),vl=i(s),Us=n(s,"P",{"data-svelte-h":!0}),h(Us)!=="svelte-14qqsoc"&&(Us.textContent=Ce),Tl=i(s),ws=n(s,"UL",{"data-svelte-h":!0}),h(ws)!=="svelte-1ong27"&&(ws.innerHTML=Ie),Cl=i(s),j(bs.$$.fragment,s),Il=i(s),C=n(s,"H3",{class:!0});var Ia=o(C);z=n(Ia,"A",{id:!0,class:!0,href:!0});var Cn=o(z);St=n(Cn,"SPAN",{});var In=o(St);j(vs.$$.fragment,In),In.forEach(t),Cn.forEach(t),Xa=i(Ia),Tt=n(Ia,"SPAN",{"data-svelte-h":!0}),h(Tt)!=="svelte-6w6qco"&&(Tt.textContent=Ze),Ia.forEach(t),Zl=i(s),Ts=n(s,"P",{"data-svelte-h":!0}),h(Ts)!=="svelte-10dx22t"&&(Ts.textContent=ke),kl=i(s),Cs=n(s,"P",{"data-svelte-h":!0}),h(Cs)!=="svelte-1bbfjj6"&&(Cs.textContent=Be),Bl=i(s),Is=n(s,"UL",{"data-svelte-h":!0}),h(Is)!=="svelte-doxpjs"&&(Is.innerHTML=$e),$l=i(s),j(Zs.$$.fragment,s),Wl=i(s),I=n(s,"H3",{class:!0});var Za=o(I);A=n(Za,"A",{id:!0,class:!0,href:!0});var Zn=o(A);Yt=n(Zn,"SPAN",{});var kn=o(Yt);j(ks.$$.fragment,kn),kn.forEach(t),Zn.forEach(t),Fa=i(Za),Ct=n(Za,"SPAN",{"data-svelte-h":!0}),h(Ct)!=="svelte-1ar8vc1"&&(Ct.textContent=We),Za.forEach(t),_l=i(s),Bs=n(s,"P",{"data-svelte-h":!0}),h(Bs)!=="svelte-uvfxg5"&&(Bs.textContent=_e),Hl=i(s),$s=n(s,"P",{"data-svelte-h":!0}),h($s)!=="svelte-1hwst5e"&&($s.textContent=He),Nl=i(s),Ws=n(s,"UL",{"data-svelte-h":!0}),h(Ws)!=="svelte-bh6x2l"&&(Ws.innerHTML=Ne),Gl=i(s),_s=n(s,"P",{"data-svelte-h":!0}),h(_s)!=="svelte-1spkl8f"&&(_s.textContent=Ge),ql=i(s),j(Hs.$$.fragment,s),Vl=i(s),Z=n(s,"H3",{class:!0});var ka=o(Z);S=n(ka,"A",{id:!0,class:!0,href:!0});var Bn=o(S);Xt=n(Bn,"SPAN",{});var $n=o(Xt);j(Ns.$$.fragment,$n),$n.forEach(t),Bn.forEach(t),La=i(ka),It=n(ka,"SPAN",{"data-svelte-h":!0}),h(It)!=="svelte-ty81ry"&&(It.textContent=qe),ka.forEach(t),Rl=i(s),Gs=n(s,"P",{"data-svelte-h":!0}),h(Gs)!=="svelte-1exjil8"&&(Gs.textContent=Ve),El=i(s),qs=n(s,"P",{"data-svelte-h":!0}),h(qs)!=="svelte-skr9n9"&&(qs.textContent=Re),Ql=i(s),Vs=n(s,"UL",{"data-svelte-h":!0}),h(Vs)!=="svelte-urw9j1"&&(Vs.innerHTML=Ee),zl=i(s),j(Rs.$$.fragment,s),Al=i(s),k=n(s,"H2",{class:!0});var Ba=o(k);Y=n(Ba,"A",{id:!0,class:!0,href:!0});var Wn=o(Y);Ft=n(Wn,"SPAN",{});var _n=o(Ft);j(Es.$$.fragment,_n),_n.forEach(t),Wn.forEach(t),Pa=i(Ba),Zt=n(Ba,"SPAN",{"data-svelte-h":!0}),h(Zt)!=="svelte-44gc8r"&&(Zt.textContent=Qe),Ba.forEach(t),Sl=i(s),Qs=n(s,"P",{"data-svelte-h":!0}),h(Qs)!=="svelte-juznik"&&(Qs.textContent=ze),Yl=i(s),B=n(s,"H3",{class:!0});var $a=o(B);X=n($a,"A",{id:!0,class:!0,href:!0});var Hn=o(X);Lt=n(Hn,"SPAN",{});var Nn=o(Lt);j(zs.$$.fragment,Nn),Nn.forEach(t),Hn.forEach(t),Ka=i($a),kt=n($a,"SPAN",{"data-svelte-h":!0}),h(kt)!=="svelte-3qubuy"&&(kt.textContent=Ae),$a.forEach(t),Xl=i(s),As=n(s,"P",{"data-svelte-h":!0}),h(As)!=="svelte-1i4o3md"&&(As.textContent=Se),Fl=i(s),Ss=n(s,"UL",{"data-svelte-h":!0}),h(Ss)!=="svelte-5w2u0i"&&(Ss.innerHTML=Ye),Ll=i(s),j(Ys.$$.fragment,s),Pl=i(s),$=n(s,"H3",{class:!0});var Wa=o($);F=n(Wa,"A",{id:!0,class:!0,href:!0});var Gn=o(F);Pt=n(Gn,"SPAN",{});var qn=o(Pt);j(Xs.$$.fragment,qn),qn.forEach(t),Gn.forEach(t),Da=i(Wa),Bt=n(Wa,"SPAN",{"data-svelte-h":!0}),h(Bt)!=="svelte-m2p5mn"&&(Bt.textContent=Xe),Wa.forEach(t),Kl=i(s),Fs=n(s,"P",{"data-svelte-h":!0}),h(Fs)!=="svelte-1hgqh5j"&&(Fs.innerHTML=Fe),Dl=i(s),Ls=n(s,"P",{"data-svelte-h":!0}),h(Ls)!=="svelte-16tsf9c"&&(Ls.textContent=Le),Ol=i(s),Ps=n(s,"UL",{"data-svelte-h":!0}),h(Ps)!=="svelte-1wq0vai"&&(Ps.innerHTML=Pe),sa=i(s),j(Ks.$$.fragment,s),ta=i(s),W=n(s,"H3",{class:!0});var _a=o(W);L=n(_a,"A",{id:!0,class:!0,href:!0});var Vn=o(L);Kt=n(Vn,"SPAN",{});var Rn=o(Kt);j(Ds.$$.fragment,Rn),Rn.forEach(t),Vn.forEach(t),Oa=i(_a),$t=n(_a,"SPAN",{"data-svelte-h":!0}),h($t)!=="svelte-1akgq2r"&&($t.textContent=Ke),_a.forEach(t),la=i(s),Os=n(s,"P",{"data-svelte-h":!0}),h(Os)!=="svelte-1bb9mft"&&(Os.textContent=De),aa=i(s),st=n(s,"P",{"data-svelte-h":!0}),h(st)!=="svelte-17o3plg"&&(st.textContent=Oe),ea=i(s),tt=n(s,"UL",{"data-svelte-h":!0}),h(tt)!=="svelte-1ayvag1"&&(tt.innerHTML=sn),na=i(s),j(lt.$$.fragment,s),pa=i(s),_=n(s,"H3",{class:!0});var Ha=o(_);P=n(Ha,"A",{id:!0,class:!0,href:!0});var En=o(P);Dt=n(En,"SPAN",{});var Qn=o(Dt);j(at.$$.fragment,Qn),Qn.forEach(t),En.forEach(t),se=i(Ha),Wt=n(Ha,"SPAN",{"data-svelte-h":!0}),h(Wt)!=="svelte-9k3gek"&&(Wt.textContent=tn),Ha.forEach(t),ia=i(s),et=n(s,"P",{"data-svelte-h":!0}),h(et)!=="svelte-11gr80y"&&(et.innerHTML=ln),ra=i(s),nt=n(s,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-fmz0j8"&&(nt.textContent=an),ca=i(s),pt=n(s,"UL",{"data-svelte-h":!0}),h(pt)!=="svelte-mxtzg1"&&(pt.innerHTML=en),ha=i(s),j(it.$$.fragment,s),oa=i(s),H=n(s,"H3",{class:!0});var Na=o(H);K=n(Na,"A",{id:!0,class:!0,href:!0});var zn=o(K);Ot=n(zn,"SPAN",{});var An=o(Ot);j(rt.$$.fragment,An),An.forEach(t),zn.forEach(t),te=i(Na),_t=n(Na,"SPAN",{"data-svelte-h":!0}),h(_t)!=="svelte-19kkq20"&&(_t.textContent=nn),Na.forEach(t),ua=i(s),ct=n(s,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-173rkq6"&&(ct.innerHTML=pn),ja=i(s),ht=n(s,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-4yqe8s"&&(ht.textContent=rn),ma=i(s),j(ot.$$.fragment,s),ya=i(s),N=n(s,"H3",{class:!0});var Ga=o(N);D=n(Ga,"A",{id:!0,class:!0,href:!0});var Sn=o(D);sl=n(Sn,"SPAN",{});var Yn=o(sl);j(ut.$$.fragment,Yn),Yn.forEach(t),Sn.forEach(t),le=i(Ga),Ht=n(Ga,"SPAN",{"data-svelte-h":!0}),h(Ht)!=="svelte-1qh5vsg"&&(Ht.textContent=cn),Ga.forEach(t),Ma=i(s),jt=n(s,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-1i9u0s6"&&(jt.textContent=hn),ga=i(s),mt=n(s,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-1pvuplr"&&(mt.textContent=on),Ja=i(s),O=n(s,"UL",{});var qa=o(O);yt=n(qa,"LI",{});var Va=o(yt);Nt=n(Va,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-bmp22e"&&(Nt.textContent=un),ae=i(Va),j(Mt.$$.fragment,Va),Va.forEach(t),ee=i(qa),gt=n(qa,"LI",{});var Ra=o(gt);Gt=n(Ra,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-axjjse"&&(Gt.textContent=jn),ne=i(Ra),j(Jt.$$.fragment,Ra),Ra.forEach(t),qa.forEach(t),xa=i(s),xt=n(s,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-sjudlh"&&(xt.innerHTML=mn),da=i(s),tl=n(s,"P",{}),o(tl).forEach(t),this.h()},h(){c(d,"name","hf:doc:metadata"),c(d,"content",JSON.stringify(sp)),c(G,"id","what__transformers_can_do"),c(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(G,"href","#what__transformers_can_do"),c(f,"class","relative group"),c(q,"id","audio"),c(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(q,"href","#audio"),c(U,"class","relative group"),c(V,"id","audio_classification"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#audio_classification"),c(w,"class","relative group"),c(R,"id","automatic_speech_recognition"),c(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(R,"href","#automatic_speech_recognition"),c(b,"class","relative group"),c(E,"id","computer_vision"),c(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(E,"href","#computer_vision"),c(v,"class","relative group"),c(Q,"id","image_classification"),c(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Q,"href","#image_classification"),c(T,"class","relative group"),c(z,"id","object_detection"),c(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(z,"href","#object_detection"),c(C,"class","relative group"),c(A,"id","image_segmentation"),c(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(A,"href","#image_segmentation"),c(I,"class","relative group"),c(S,"id","depth_estimation"),c(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(S,"href","#depth_estimation"),c(Z,"class","relative group"),c(Y,"id","natural_language_processing"),c(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Y,"href","#natural_language_processing"),c(k,"class","relative group"),c(X,"id","text_classification"),c(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(X,"href","#text_classification"),c(B,"class","relative group"),c(F,"id","token_classification"),c(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(F,"href","#token_classification"),c($,"class","relative group"),c(L,"id","question_answering"),c(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(L,"href","#question_answering"),c(W,"class","relative group"),c(P,"id","summarization"),c(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(P,"href","#summarization"),c(_,"class","relative group"),c(K,"id","translation"),c(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(K,"href","#translation"),c(H,"class","relative group"),c(D,"id","language_modeling"),c(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(D,"href","#language_modeling"),c(N,"class","relative group")},m(s,l){r(document.head,d),a(s,ll,l),a(s,qt,l),a(s,al,l),a(s,f,l),r(f,G),r(G,Vt),m(ss,Vt,null),r(f,Ea),r(f,dt),a(s,el,l),a(s,ts,l),a(s,nl,l),a(s,ls,l),a(s,pl,l),a(s,as,l),a(s,il,l),a(s,U,l),r(U,q),r(q,Rt),m(es,Rt,null),r(U,Qa),r(U,ft),a(s,rl,l),a(s,ns,l),a(s,cl,l),a(s,ps,l),a(s,hl,l),a(s,w,l),r(w,V),r(V,Et),m(is,Et,null),r(w,za),r(w,Ut),a(s,ol,l),a(s,rs,l),a(s,ul,l),a(s,cs,l),a(s,jl,l),a(s,hs,l),a(s,ml,l),m(os,s,l),a(s,yl,l),a(s,b,l),r(b,R),r(R,Qt),m(us,Qt,null),r(b,Aa),r(b,wt),a(s,Ml,l),a(s,js,l),a(s,gl,l),a(s,ms,l),a(s,Jl,l),m(ys,s,l),a(s,xl,l),a(s,v,l),r(v,E),r(E,zt),m(Ms,zt,null),r(v,Sa),r(v,bt),a(s,dl,l),a(s,gs,l),a(s,fl,l),a(s,Js,l),a(s,Ul,l),a(s,xs,l),a(s,wl,l),a(s,T,l),r(T,Q),r(Q,At),m(ds,At,null),r(T,Ya),r(T,vt),a(s,bl,l),a(s,fs,l),a(s,vl,l),a(s,Us,l),a(s,Tl,l),a(s,ws,l),a(s,Cl,l),m(bs,s,l),a(s,Il,l),a(s,C,l),r(C,z),r(z,St),m(vs,St,null),r(C,Xa),r(C,Tt),a(s,Zl,l),a(s,Ts,l),a(s,kl,l),a(s,Cs,l),a(s,Bl,l),a(s,Is,l),a(s,$l,l),m(Zs,s,l),a(s,Wl,l),a(s,I,l),r(I,A),r(A,Yt),m(ks,Yt,null),r(I,Fa),r(I,Ct),a(s,_l,l),a(s,Bs,l),a(s,Hl,l),a(s,$s,l),a(s,Nl,l),a(s,Ws,l),a(s,Gl,l),a(s,_s,l),a(s,ql,l),m(Hs,s,l),a(s,Vl,l),a(s,Z,l),r(Z,S),r(S,Xt),m(Ns,Xt,null),r(Z,La),r(Z,It),a(s,Rl,l),a(s,Gs,l),a(s,El,l),a(s,qs,l),a(s,Ql,l),a(s,Vs,l),a(s,zl,l),m(Rs,s,l),a(s,Al,l),a(s,k,l),r(k,Y),r(Y,Ft),m(Es,Ft,null),r(k,Pa),r(k,Zt),a(s,Sl,l),a(s,Qs,l),a(s,Yl,l),a(s,B,l),r(B,X),r(X,Lt),m(zs,Lt,null),r(B,Ka),r(B,kt),a(s,Xl,l),a(s,As,l),a(s,Fl,l),a(s,Ss,l),a(s,Ll,l),m(Ys,s,l),a(s,Pl,l),a(s,$,l),r($,F),r(F,Pt),m(Xs,Pt,null),r($,Da),r($,Bt),a(s,Kl,l),a(s,Fs,l),a(s,Dl,l),a(s,Ls,l),a(s,Ol,l),a(s,Ps,l),a(s,sa,l),m(Ks,s,l),a(s,ta,l),a(s,W,l),r(W,L),r(L,Kt),m(Ds,Kt,null),r(W,Oa),r(W,$t),a(s,la,l),a(s,Os,l),a(s,aa,l),a(s,st,l),a(s,ea,l),a(s,tt,l),a(s,na,l),m(lt,s,l),a(s,pa,l),a(s,_,l),r(_,P),r(P,Dt),m(at,Dt,null),r(_,se),r(_,Wt),a(s,ia,l),a(s,et,l),a(s,ra,l),a(s,nt,l),a(s,ca,l),a(s,pt,l),a(s,ha,l),m(it,s,l),a(s,oa,l),a(s,H,l),r(H,K),r(K,Ot),m(rt,Ot,null),r(H,te),r(H,_t),a(s,ua,l),a(s,ct,l),a(s,ja,l),a(s,ht,l),a(s,ma,l),m(ot,s,l),a(s,ya,l),a(s,N,l),r(N,D),r(D,sl),m(ut,sl,null),r(N,le),r(N,Ht),a(s,Ma,l),a(s,jt,l),a(s,ga,l),a(s,mt,l),a(s,Ja,l),a(s,O,l),r(O,yt),r(yt,Nt),r(yt,ae),m(Mt,yt,null),r(O,ee),r(O,gt),r(gt,Gt),r(gt,ne),m(Jt,gt,null),a(s,xa,l),a(s,xt,l),a(s,da,l),a(s,tl,l),fa=!0},p:Fn,i(s){fa||(y(ss.$$.fragment,s),y(es.$$.fragment,s),y(is.$$.fragment,s),y(os.$$.fragment,s),y(us.$$.fragment,s),y(ys.$$.fragment,s),y(Ms.$$.fragment,s),y(ds.$$.fragment,s),y(bs.$$.fragment,s),y(vs.$$.fragment,s),y(Zs.$$.fragment,s),y(ks.$$.fragment,s),y(Hs.$$.fragment,s),y(Ns.$$.fragment,s),y(Rs.$$.fragment,s),y(Es.$$.fragment,s),y(zs.$$.fragment,s),y(Ys.$$.fragment,s),y(Xs.$$.fragment,s),y(Ks.$$.fragment,s),y(Ds.$$.fragment,s),y(lt.$$.fragment,s),y(at.$$.fragment,s),y(it.$$.fragment,s),y(rt.$$.fragment,s),y(ot.$$.fragment,s),y(ut.$$.fragment,s),y(Mt.$$.fragment,s),y(Jt.$$.fragment,s),fa=!0)},o(s){M(ss.$$.fragment,s),M(es.$$.fragment,s),M(is.$$.fragment,s),M(os.$$.fragment,s),M(us.$$.fragment,s),M(ys.$$.fragment,s),M(Ms.$$.fragment,s),M(ds.$$.fragment,s),M(bs.$$.fragment,s),M(vs.$$.fragment,s),M(Zs.$$.fragment,s),M(ks.$$.fragment,s),M(Hs.$$.fragment,s),M(Ns.$$.fragment,s),M(Rs.$$.fragment,s),M(Es.$$.fragment,s),M(zs.$$.fragment,s),M(Ys.$$.fragment,s),M(Xs.$$.fragment,s),M(Ks.$$.fragment,s),M(Ds.$$.fragment,s),M(lt.$$.fragment,s),M(at.$$.fragment,s),M(it.$$.fragment,s),M(rt.$$.fragment,s),M(ot.$$.fragment,s),M(ut.$$.fragment,s),M(Mt.$$.fragment,s),M(Jt.$$.fragment,s),fa=!1},d(s){s&&(t(ll),t(qt),t(al),t(f),t(el),t(ts),t(nl),t(ls),t(pl),t(as),t(il),t(U),t(rl),t(ns),t(cl),t(ps),t(hl),t(w),t(ol),t(rs),t(ul),t(cs),t(jl),t(hs),t(ml),t(yl),t(b),t(Ml),t(js),t(gl),t(ms),t(Jl),t(xl),t(v),t(dl),t(gs),t(fl),t(Js),t(Ul),t(xs),t(wl),t(T),t(bl),t(fs),t(vl),t(Us),t(Tl),t(ws),t(Cl),t(Il),t(C),t(Zl),t(Ts),t(kl),t(Cs),t(Bl),t(Is),t($l),t(Wl),t(I),t(_l),t(Bs),t(Hl),t($s),t(Nl),t(Ws),t(Gl),t(_s),t(ql),t(Vl),t(Z),t(Rl),t(Gs),t(El),t(qs),t(Ql),t(Vs),t(zl),t(Al),t(k),t(Sl),t(Qs),t(Yl),t(B),t(Xl),t(As),t(Fl),t(Ss),t(Ll),t(Pl),t($),t(Kl),t(Fs),t(Dl),t(Ls),t(Ol),t(Ps),t(sa),t(ta),t(W),t(la),t(Os),t(aa),t(st),t(ea),t(tt),t(na),t(pa),t(_),t(ia),t(et),t(ra),t(nt),t(ca),t(pt),t(ha),t(oa),t(H),t(ua),t(ct),t(ja),t(ht),t(ma),t(ya),t(N),t(Ma),t(jt),t(ga),t(mt),t(Ja),t(O),t(xa),t(xt),t(da),t(tl)),t(d),g(ss),g(es),g(is),g(os,s),g(us),g(ys,s),g(Ms),g(ds),g(bs,s),g(vs),g(Zs,s),g(ks),g(Hs,s),g(Ns),g(Rs,s),g(Es),g(zs),g(Ys,s),g(Xs),g(Ks,s),g(Ds),g(lt,s),g(at),g(it,s),g(rt),g(ot,s),g(ut),g(Mt),g(Jt)}}}const sp={local:"what__transformers_can_do",sections:[{local:"audio",sections:[{local:"audio_classification",title:"오디오 분류"},{local:"automatic_speech_recognition",title:"자동 음성 인식"}],title:"오디오"},{local:"computer_vision",sections:[{local:"image_classification",title:"이미지 분류"},{local:"object_detection",title:"객체 탐지"},{local:"image_segmentation",title:"이미지 분할"},{local:"depth_estimation",title:"깊이 추정"}],title:"컴퓨터 비전"},{local:"natural_language_processing",sections:[{local:"text_classification",title:"텍스트 분류"},{local:"token_classification",title:"토큰 분류"},{local:"question_answering",title:"질의응답"},{local:"summarization",title:"요약"},{local:"translation",title:"번역"},{local:"language_modeling",title:"언어 모델링"}],title:"자연어처리"}],title:"🤗 Transformers로 할 수 있는 것"};function tp(pe){return Ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pp extends Pn{constructor(d){super(),Kn(this,d,tp,On,Xn,{})}}export{pp as component};
