import{s as le,n as ae,o as se}from"../chunks/scheduler.182ea377.js";import{S as ie,i as oe,g as i,s as a,r as _,A as pe,h as o,f as n,c as s,j as ee,u as j,x as T,k as te,y as re,a as l,v as J,d as $,t as v,w as C}from"../chunks/index.abf12888.js";import{C as L}from"../chunks/CodeBlock.57fe6e13.js";import{H as ne}from"../chunks/Heading.16916d63.js";function de(E){let p,k,Z,W,r,G,d,P="Many diffusion systems share the same components, allowing you to adapt a pretrained model for one task to an entirely different task.",V,m,Y='This guide will show you how to adapt a pretrained text-to-image model for inpainting by initializing and modifying the architecture of a pretrained <a href="/docs/diffusers/v0.27.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.',B,f,N,u,F='A <a href="/docs/diffusers/v0.27.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> by default accepts 4 channels in the <a href="https://huggingface.co/docs/diffusers/v0.16.0/en/api/models#diffusers.UNet2DConditionModel.in_channels" rel="nofollow">input sample</a>. For example, load a pretrained text-to-image model like <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> and take a look at the number of <code>in_channels</code>:',X,c,x,h,q='Inpainting requires 9 channels in the input sample. You can check this value in a pretrained inpainting model like <a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow"><code>runwayml/stable-diffusion-inpainting</code></a>:',Q,M,I,y,A="To adapt your text-to-image model for inpainting, you’ll need to change the number of <code>in_channels</code> from 4 to 9.",R,b,K='Initialize a <a href="/docs/diffusers/v0.27.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> with the pretrained text-to-image model weights, and change <code>in_channels</code> to 9. Changing the number of <code>in_channels</code> means you need to set <code>ignore_mismatched_sizes=True</code> and <code>low_cpu_mem_usage=False</code> to avoid a size mismatch error because the shape is different now.',S,w,H,g,O="The pretrained weights of the other components from the text-to-image model are initialized from their checkpoints, but the input channel weights (<code>conv_in.weight</code>) of the <code>unet</code> are randomly initialized. It is important to finetune the model for inpainting because otherwise the model returns noise.",z,U,D;return r=new ne({props:{title:"Adapt a model to a new task",local:"adapt-a-model-to-a-new-task",headingTag:"h1"}}),f=new ne({props:{title:"Configure UNet2DConditionModel parameters",local:"configure-unet2dconditionmodel-parameters",headingTag:"h2"}}),c=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGVsaW5lLnVuZXQuY29uZmlnJTVCJTIyaW5fY2hhbm5lbHMlMjIlNUQlMEE0",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipeline.unet.config[<span class="hljs-string">&quot;in_channels&quot;</span>]
<span class="hljs-number">4</span>`,wrap:!1}}),M=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGVsaW5lLnVuZXQuY29uZmlnJTVCJTIyaW5fY2hhbm5lbHMlMjIlNUQlMEE5",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipeline.unet.config[<span class="hljs-string">&quot;in_channels&quot;</span>]
<span class="hljs-number">9</span>`,wrap:!1}}),w=new L({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5fY2hhbm5lbHMlM0Q5JTJDJTBBJTIwJTIwJTIwJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
unet = UNet2DConditionModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;unet&quot;</span>,
    in_channels=<span class="hljs-number">9</span>,
    low_cpu_mem_usage=<span class="hljs-literal">False</span>,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){p=i("meta"),k=a(),Z=i("p"),W=a(),_(r.$$.fragment),G=a(),d=i("p"),d.textContent=P,V=a(),m=i("p"),m.innerHTML=Y,B=a(),_(f.$$.fragment),N=a(),u=i("p"),u.innerHTML=F,X=a(),_(c.$$.fragment),x=a(),h=i("p"),h.innerHTML=q,Q=a(),_(M.$$.fragment),I=a(),y=i("p"),y.innerHTML=A,R=a(),b=i("p"),b.innerHTML=K,S=a(),_(w.$$.fragment),H=a(),g=i("p"),g.innerHTML=O,z=a(),U=i("p"),this.h()},l(e){const t=pe("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(n),k=s(e),Z=o(e,"P",{}),ee(Z).forEach(n),W=s(e),j(r.$$.fragment,e),G=s(e),d=o(e,"P",{"data-svelte-h":!0}),T(d)!=="svelte-3om45r"&&(d.textContent=P),V=s(e),m=o(e,"P",{"data-svelte-h":!0}),T(m)!=="svelte-l4rlv"&&(m.innerHTML=Y),B=s(e),j(f.$$.fragment,e),N=s(e),u=o(e,"P",{"data-svelte-h":!0}),T(u)!=="svelte-1e4lyf8"&&(u.innerHTML=F),X=s(e),j(c.$$.fragment,e),x=s(e),h=o(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-ph2jy1"&&(h.innerHTML=q),Q=s(e),j(M.$$.fragment,e),I=s(e),y=o(e,"P",{"data-svelte-h":!0}),T(y)!=="svelte-15mkgo9"&&(y.innerHTML=A),R=s(e),b=o(e,"P",{"data-svelte-h":!0}),T(b)!=="svelte-13bwr0t"&&(b.innerHTML=K),S=s(e),j(w.$$.fragment,e),H=s(e),g=o(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-6j6lxu"&&(g.innerHTML=O),z=s(e),U=o(e,"P",{}),ee(U).forEach(n),this.h()},h(){te(p,"name","hf:doc:metadata"),te(p,"content",me)},m(e,t){re(document.head,p),l(e,k,t),l(e,Z,t),l(e,W,t),J(r,e,t),l(e,G,t),l(e,d,t),l(e,V,t),l(e,m,t),l(e,B,t),J(f,e,t),l(e,N,t),l(e,u,t),l(e,X,t),J(c,e,t),l(e,x,t),l(e,h,t),l(e,Q,t),J(M,e,t),l(e,I,t),l(e,y,t),l(e,R,t),l(e,b,t),l(e,S,t),J(w,e,t),l(e,H,t),l(e,g,t),l(e,z,t),l(e,U,t),D=!0},p:ae,i(e){D||($(r.$$.fragment,e),$(f.$$.fragment,e),$(c.$$.fragment,e),$(M.$$.fragment,e),$(w.$$.fragment,e),D=!0)},o(e){v(r.$$.fragment,e),v(f.$$.fragment,e),v(c.$$.fragment,e),v(M.$$.fragment,e),v(w.$$.fragment,e),D=!1},d(e){e&&(n(k),n(Z),n(W),n(G),n(d),n(V),n(m),n(B),n(N),n(u),n(X),n(x),n(h),n(Q),n(I),n(y),n(R),n(b),n(S),n(H),n(g),n(z),n(U)),n(p),C(r,e),C(f,e),C(c,e),C(M,e),C(w,e)}}}const me='{"title":"Adapt a model to a new task","local":"adapt-a-model-to-a-new-task","sections":[{"title":"Configure UNet2DConditionModel parameters","local":"configure-unet2dconditionmodel-parameters","sections":[],"depth":2}],"depth":1}';function fe(E){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends ie{constructor(p){super(),oe(this,p,fe,de,le,{})}}export{ye as component};
