import{s as It,f as Ut,n as ft,o as gt}from"../chunks/scheduler.65852ee5.js";import{S as At,i as Ct,g as i,s as a,r as o,A as bt,h as M,f as t,c as n,j as Fe,u as p,x as d,k as h,y as $t,a as s,v as r,d as c,t as u,w as j}from"../chunks/index.65a1b999.js";import{D as Bt,C as y}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as J,E as Zt}from"../chunks/index.37c62cb6.js";function qt(xe){let m,Zl,$l,ql,U,Gl,I,El,f,Xe='<em>Authored by: <a href="https://huggingface.co/davidberenstein1957" rel="nofollow">David Berenstein</a> and <a href="https://huggingface.co/sdiazlor" rel="nofollow">Sara Han Díaz</a></em>',kl,g,He='<li><strong>Libraries</strong>: <a href="https://github.com/argilla-io/argilla" rel="nofollow">argilla</a>, <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">hf-inference-endpoints</a></li> <li><strong>Components</strong>: <a href="https://distilabel.argilla.io/dev/components-gallery/steps/loaddatafromdicts/" rel="nofollow">LoadDataFromDicts</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/tasks/ultrafeedback/" rel="nofollow">UltraFeedback</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/groupcolumns/" rel="nofollow">KeepColumns</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/steps/textgenerationtoargilla/" rel="nofollow">PreferenceToArgilla</a>, <a href="https://distilabel.argilla.io/latest/components-gallery/llms/inferenceendpointsllm/" rel="nofollow">InferenceEndpointsLLM</a>, <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/global_step/" rel="nofollow">GlobalStep</a></li>',Vl,A,Se='In this tutorial, we’ll use distilabel to clean a dataset using the LLMs as judges by providing AI feedback on the quality of the data. <a href="https://github.com/argilla-io/distilabel" rel="nofollow">distilabel</a> is a synthetic data and AI feedback framework for engineers who need fast, reliable and scalable pipelines based on verified research papers. Check the documentation <a href="https://distilabel.argilla.io/latest/" rel="nofollow">here</a>.',Wl,C,Ye='To evaluate the responses, we will use the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">serverless HF Inference API</a> integrated with distilabel. This is free but rate-limited, allowing you to test and evaluate over 150,000 public models, or your own private models, via simple HTTP requests, with fast inference hosted on Hugging Face shared infrastructure. If you need more compute power, you can deploy your own inference endpoint with <a href="https://huggingface.co/docs/inference-endpoints/guides/create_endpoint" rel="nofollow">Hugging Face Inference Endpoints</a>.',vl,b,ze='Finally, to further curate the data, we will use <a href="https://github.com/argilla-io/argilla" rel="nofollow">Argilla</a>, which allows us to provide human feedback on the data quality. Argilla is a collaboration tool for AI engineers and domain experts who need to build high-quality datasets for their projects. Check the documentation <a href="https://docs.argilla.io/latest/" rel="nofollow">here</a>.',_l,$,Ql,B,Nl,Z,Le="To complete this tutorial, you need to install the distilabel SDK and a few third-party libraries via pip.",Rl,q,Fl,G,xl,E,De="Let’s make the required imports:",Xl,k,Hl,V,Pe="You’ll need an <code>HF_TOKEN</code> to use the HF Inference Endpoints. Login to use it directly within this notebook.",Sl,W,Yl,v,zl,_,Ke='You can skip this step or replace it with any other data evaluation tool, but the quality of your model will suffer from a lack of data quality, so we do recommend looking at your data. If you already deployed Argilla, you can skip this step. Otherwise, you can quickly deploy Argilla following <a href="https://docs.argilla.io/latest/getting_started/quickstart/" rel="nofollow">this guide</a>.',Ll,Q,Oe="Along with that, you will need to install Argilla as a distilabel extra.",Dl,N,Pl,R,Kl,F,lt='In this case, we will clean a preference dataset, so we will use the <a href="https://huggingface.co/datasets/Intel/orca_dpo_pairs" rel="nofollow"><code>Intel/orca_dpo_pairs</code></a> dataset from the Hugging Face Hub.',Ol,w,et,le,x,ee,X,tt="Next, we will shuffle the <code>chosen</code> and <code>rejected</code> columns to avoid any bias in the dataset.",te,H,se,S,ae,Y,ne,z,st='A step is a block in a distilabel pipeline used to manipulate, generate, or evaluate data, among other tasks. A set of predefined steps is provided, but you can also create your <a href="https://distilabel.argilla.io/latest/sections/how_to_guides/basic/step/#defining-custom-steps" rel="nofollow">own custom steps</a>. Instead of preprocessing the data as in the previous section, it is possible to use a custom step to shuffle the columns. This step should be in a separate module to be imported and used in the pipeline. In this case, the pipeline would start by loading the <code>orca_dpo_pairs</code> dataset using the <code>LoadDataFromHub</code> step and then applying the <code>ShuffleStep</code>.',ie,L,Me,D,oe,P,pe,K,at="To clean an existing preference dataset, we will need to define a <code>Pipeline</code> with all the necessary steps. However, a similar workflow can be used to clean an SFT dataset. Below, we will go over each step in detail.",re,O,ce,ll,nt="We will use the dataset we just shuffled as source data.",ue,el,it="<li>Component: <code>LoadDataFromDicts</code></li> <li>Input columns: <code>system</code>, <code>question</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code> and <code>order</code>, the same keys as in the loaded list of dictionaries.</li> <li>Output columns: <code>system</code>, <code>instruction</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code> and <code>order</code>. We will use <code>output_mappings</code> to rename the columns.</li>",je,tl,de,sl,ye,al,Mt='To evaluate the quality of the responses, we will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-70B-Instruct</code></a>, applying the <code>UltraFeedback</code> task that judges the responses according to different dimensions (helpfulness, honesty, instruction-following, truthfulness). For an SFT dataset, you can use <a href="../papers/prometheus.md"><code>PrometheusEval</code></a> instead.',Je,nl,ot="<li>Component: <code>UltraFeedback</code> task with LLMs using <code>InferenceEndpointsLLM</code></li> <li>Input columns: <code>instruction</code>, <code>generations</code></li> <li>Output columns: <code>ratings</code>, <code>rationales</code>, <code>distilabel_metadata</code>, <code>model_name</code></li>",we,il,pt='For your use case and to improve the results, you can use any <a href="https://distilabel.argilla.io/latest/components-gallery/llms/" rel="nofollow">other LLM of your choice</a>.',Te,Ml,he,ol,me,pl,rt="We will get rid of the unneeded columns.",Ue,rl,ct="<li>Component: <code>KeepColumns</code></li> <li>Input columns: <code>system</code>, <code>instruction</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code>, <code>ratings</code>, <code>rationales</code>, <code>distilabel_metadata</code> and <code>model_name</code></li> <li>Output columns: <code>instruction</code>, <code>chosen</code>, <code>rejected</code>, <code>generations</code> and <code>order</code></li>",Ie,cl,fe,ul,ge,jl,ut="You can use Argilla to further curate your data.",Ae,dl,jt="<li>Component: <code>PreferenceToArgilla</code> step</li> <li>Input columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li> <li>Output columns: <code>instruction</code>, <code>generations</code>, <code>generation_models</code>, <code>ratings</code></li>",Ce,yl,be,Jl,$e,wl,dt="Below, you can see the full pipeline definition:",Be,Tl,Ze,hl,yt="Let’s now run the pipeline and clean our preference dataset.",qe,ml,Ge,Ul,Jt='Let’s check it! If you have loaded the data to Argilla, you can <a href="https://docs.argilla.io/latest/how_to_guides/annotate/" rel="nofollow">start annotating in the Argilla UI</a>.',Ee,Il,wt='You can push the dataset to the Hub for sharing with the community and <a href="https://huggingface.co/docs/hub/datasets-viewer-embed" rel="nofollow">embed it to explore the data</a>.',ke,fl,Ve,T,Tt,We,gl,ve,Al,ht="In this tutorial, we showcased the detailed steps to build a pipeline for cleaning a preference dataset using distilabel. However, you can customize this pipeline for your own use cases, such as cleaning an SFT dataset or adding custom steps.",_e,Cl,mt="We used a preference dataset as our starting point and shuffled the data to avoid any bias. Next, we evaluated the responses using a model through the serverless Hugging Face Inference API, following the UltraFeedback standards. Finally, we kept the needed columns and used Argilla for further curation.",Qe,bl,Ne,Bl,Re;return U=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/clean_dataset_judges_distilabel.ipynb"}]}}),I=new J({props:{title:"Clean an Existing Preference Dataset with LLMs as Judges",local:"clean-an-existing-preference-dataset-with-llms-as-judges",headingTag:"h1"}}),$=new J({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),B=new J({props:{title:"Install the dependencies",local:"install-the-dependencies",headingTag:"h3"}}),q=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCaGYtaW5mZXJlbmNlLWVuZHBvaW50cyU1RCUyMg==",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[hf-inference-endpoints]&quot;</span>',wrap:!1}}),G=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnN+JTNENC4wJTIyJTIwJTIydG9yY2h+JTNEMi4wJTIy",highlighted:'!pip install <span class="hljs-string">&quot;transformers~=4.0&quot;</span> <span class="hljs-string">&quot;torch~=2.0&quot;</span>',wrap:!1}}),k=new y({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMEluZmVyZW5jZUVuZHBvaW50c0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnBpcGVsaW5lJTIwaW1wb3J0JTIwUGlwZWxpbmUlMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBLZWVwQ29sdW1ucyUyQyUwQSUyMCUyMCUyMCUyMExvYWREYXRhRnJvbURpY3RzJTJDJTBBJTIwJTIwJTIwJTIwUHJlZmVyZW5jZVRvQXJnaWxsYSUyQyUwQSklMEFmcm9tJTIwZGlzdGlsYWJlbC5zdGVwcy50YXNrcyUyMGltcG9ydCUyMFVsdHJhRmVlZGJhY2s=",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> InferenceEndpointsLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> (
    KeepColumns,
    LoadDataFromDicts,
    PreferenceToArgilla,
)
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> UltraFeedback`,wrap:!1}}),W=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbG9naW4lMEElMEFsb2dpbih0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMiklMkMlMjBhZGRfdG9fZ2l0X2NyZWRlbnRpYWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>), add_to_git_credential=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new J({props:{title:"(optional) Deploy Argilla",local:"optional-deploy-argilla",headingTag:"h3"}}),N=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJkaXN0aWxhYmVsJTVCYXJnaWxsYSUyQyUyMGhmLWluZmVyZW5jZS1lbmRwb2ludHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;distilabel[argilla, hf-inference-endpoints]&quot;</span>',wrap:!1}}),R=new J({props:{title:"The dataset",local:"the-dataset",headingTag:"h2"}}),x=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJJbnRlbCUyRm9yY2FfZHBvX3BhaXJzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTIwJTVEJTIyKQ==",highlighted:'dataset = load_dataset(<span class="hljs-string">&quot;Intel/orca_dpo_pairs&quot;</span>, split=<span class="hljs-string">&quot;train[:20]&quot;</span>)',wrap:!1}}),H=new y({props:{code:"ZGVmJTIwc2h1ZmZsZV9hbmRfdHJhY2soY2hvc2VuJTJDJTIwcmVqZWN0ZWQpJTNBJTBBJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMCU1QmNob3NlbiUyQyUyMHJlamVjdGVkJTVEJTBBJTIwJTIwJTIwJTIwcmFuZG9tLnNodWZmbGUocGFpciklMEElMjAlMjAlMjAlMjBvcmRlciUyMCUzRCUyMCU1QiUyMmNob3NlbiUyMiUyMGlmJTIweCUyMCUzRCUzRCUyMGNob3NlbiUyMGVsc2UlMjAlMjJyZWplY3RlZCUyMiUyMGZvciUyMHglMjBpbiUyMHBhaXIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJnZW5lcmF0aW9ucyUyMiUzQSUyMHBhaXIlMkMlMjAlMjJvcmRlciUyMiUzQSUyMG9yZGVyJTdEJTBBJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjBzaHVmZmxlX2FuZF90cmFjayh4JTVCJTIyY2hvc2VuJTIyJTVEJTJDJTIweCU1QiUyMnJlamVjdGVkJTIyJTVEKSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">shuffle_and_track</span>(<span class="hljs-params">chosen, rejected</span>):
    pair = [chosen, rejected]
    random.shuffle(pair)
    order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order}


dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: shuffle_and_track(x[<span class="hljs-string">&quot;chosen&quot;</span>], x[<span class="hljs-string">&quot;rejected&quot;</span>]))`,wrap:!1}}),S=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9fbGlzdCgp",highlighted:"dataset = dataset.to_list()",wrap:!1}}),Y=new J({props:{title:"(optional) Create a custom step",local:"optional-create-a-custom-step",headingTag:"h3"}}),L=new y({props:{code:"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",highlighted:`<span class="hljs-comment"># &quot;shuffle_step.py&quot;</span>
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TYPE_CHECKING, <span class="hljs-type">List</span>
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> GlobalStep, StepInput

<span class="hljs-keyword">if</span> TYPE_CHECKING:
    <span class="hljs-keyword">from</span> distilabel.steps.typing <span class="hljs-keyword">import</span> StepOutput

<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ShuffleStep</span>(<span class="hljs-title class_ inherited__">GlobalStep</span>):
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>]

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">outputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;instruction&quot;</span>, <span class="hljs-string">&quot;generations&quot;</span>, <span class="hljs-string">&quot;order&quot;</span>]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">self, inputs: StepInput</span>) -&gt; <span class="hljs-string">&quot;StepOutput&quot;</span>:
        outputs = []

        <span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span> <span class="hljs-keyword">in</span> inputs:
            chosen = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;chosen&quot;</span>]
            rejected = <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;rejected&quot;</span>]
            pair = [chosen, rejected]
            random.shuffle(pair)
            order = [<span class="hljs-string">&quot;chosen&quot;</span> <span class="hljs-keyword">if</span> x == chosen <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;rejected&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> pair]

            outputs.append({<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;instruction&quot;</span>], <span class="hljs-string">&quot;generations&quot;</span>: pair, <span class="hljs-string">&quot;order&quot;</span>: order})

        <span class="hljs-keyword">yield</span> outputs`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMHNodWZmbGVfc3RlcCUyMGltcG9ydCUyMFNodWZmbGVTdGVw",highlighted:'<span class="hljs-keyword">from</span> shuffle_step <span class="hljs-keyword">import</span> ShuffleStep',wrap:!1}}),P=new J({props:{title:"Define the pipeline",local:"define-the-pipeline",headingTag:"h2"}}),O=new J({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h3"}}),tl=new y({props:{code:"bG9hZF9kYXRhc2V0JTIwJTNEJTIwTG9hZERhdGFGcm9tRGljdHMoJTBBJTIwJTIwJTIwJTIwZGF0YSUzRGRhdGFzZXQlNUIlM0ExJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X21hcHBpbmdzJTNEJTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjJpbnN0cnVjdGlvbiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFsb2FkX2RhdGFzZXQubG9hZCgpJTBBbmV4dChsb2FkX2RhdGFzZXQucHJvY2VzcygpKQ==",highlighted:`load_dataset = LoadDataFromDicts(
    data=dataset[:<span class="hljs-number">1</span>],
    output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>},
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
load_dataset.load()
<span class="hljs-built_in">next</span>(load_dataset.process())`,wrap:!1}}),sl=new J({props:{title:"Evaluate the responses",local:"evaluate-the-responses",headingTag:"h3"}}),Ml=new y({props:{code:"ZXZhbHVhdGVfcmVzcG9uc2VzJTIwJTNEJTIwVWx0cmFGZWVkYmFjayglMEElMjAlMjAlMjAlMjBhc3BlY3QlM0QlMjJvdmVyYWxsLXJhdGluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzREluZmVyZW5jZUVuZHBvaW50c0xMTSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXJfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9rd2FyZ3MlM0QlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDUxMiUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC43JTdEJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEUGlwZWxpbmUobmFtZSUzRCUyMnNob3djYXNlLXBpcGVsaW5lJTIyKSUyQyUwQSklMEFldmFsdWF0ZV9yZXNwb25zZXMubG9hZCgpJTBBbmV4dCglMEElMjAlMjAlMjAlMjBldmFsdWF0ZV9yZXNwb25zZXMucHJvY2VzcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMldoYXQncyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMFNwYWluJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhdGlvbnMlMjIlM0ElMjAlNUIlMjJNYWRyaWQlMjIlMkMlMjAlMjJCYXJjZWxvbmElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`evaluate_responses = UltraFeedback(
    aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
    llm=InferenceEndpointsLLM(
        model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
        generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
    ),
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
evaluate_responses.load()
<span class="hljs-built_in">next</span>(
    evaluate_responses.process(
        [
            {
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
            }
        ]
    )
)`,wrap:!1}}),ol=new J({props:{title:"Keep only the required columns",local:"keep-only-the-required-columns",headingTag:"h3"}}),cl=new y({props:{code:"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",highlighted:`keep_columns = KeepColumns(
    columns=[
        <span class="hljs-string">&quot;instruction&quot;</span>,
        <span class="hljs-string">&quot;generations&quot;</span>,
        <span class="hljs-string">&quot;order&quot;</span>,
        <span class="hljs-string">&quot;ratings&quot;</span>,
        <span class="hljs-string">&quot;rationales&quot;</span>,
        <span class="hljs-string">&quot;model_name&quot;</span>,
    ],
    pipeline=Pipeline(name=<span class="hljs-string">&quot;showcase-pipeline&quot;</span>),
)
keep_columns.load()
<span class="hljs-built_in">next</span>(
    keep_columns.process(
        [
            {
                <span class="hljs-string">&quot;system&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
                <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the capital of Spain?&quot;</span>,
                <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;Madrid&quot;</span>,
                <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;Barcelona&quot;</span>,
                <span class="hljs-string">&quot;generations&quot;</span>: [<span class="hljs-string">&quot;Madrid&quot;</span>, <span class="hljs-string">&quot;Barcelona&quot;</span>],
                <span class="hljs-string">&quot;order&quot;</span>: [<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>],
                <span class="hljs-string">&quot;ratings&quot;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">1</span>],
                <span class="hljs-string">&quot;rationales&quot;</span>: [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
                <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            }
        ]
    )
)`,wrap:!1}}),ul=new J({props:{title:"(Optional) Further data curation",local:"optional-further-data-curation",headingTag:"h3"}}),yl=new y({props:{code:"dG9fYXJnaWxsYSUyMCUzRCUyMFByZWZlcmVuY2VUb0FyZ2lsbGEoJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyY2xlYW5lZC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF93b3Jrc3BhY2UlM0QlMjJhcmdpbGxhJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGJTVCeW91ci1vd25lci1uYW1lJTVELSU1QnlvdXItc3BhY2UtbmFtZSU1RC5oZi5zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjIlNUJ5b3VyLWFwaS1rZXklNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fZ2VuZXJhdGlvbnMlM0QyJTJDJTBBKQ==",highlighted:`to_argilla = PreferenceToArgilla(
    dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
    dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
    api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
    api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
    num_generations=<span class="hljs-number">2</span>,
)`,wrap:!1}}),Jl=new J({props:{title:"Run the pipeline",local:"run-the-pipeline",headingTag:"h2"}}),Tl=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">with</span> Pipeline(name=<span class="hljs-string">&quot;clean-dataset&quot;</span>) <span class="hljs-keyword">as</span> pipeline:

    load_dataset = LoadDataFromDicts(data=dataset, output_mappings={<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>})

    evaluate_responses = UltraFeedback(
        aspect=<span class="hljs-string">&quot;overall-rating&quot;</span>,
        llm=InferenceEndpointsLLM(
            model_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            tokenizer_id=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-70B-Instruct&quot;</span>,
            generation_kwargs={<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>},
        ),
    )

    keep_columns = KeepColumns(
        columns=[
            <span class="hljs-string">&quot;instruction&quot;</span>,
            <span class="hljs-string">&quot;generations&quot;</span>,
            <span class="hljs-string">&quot;order&quot;</span>,
            <span class="hljs-string">&quot;ratings&quot;</span>,
            <span class="hljs-string">&quot;rationales&quot;</span>,
            <span class="hljs-string">&quot;model_name&quot;</span>,
        ]
    )

    to_argilla = PreferenceToArgilla(
        dataset_name=<span class="hljs-string">&quot;cleaned-dataset&quot;</span>,
        dataset_workspace=<span class="hljs-string">&quot;argilla&quot;</span>,
        api_url=<span class="hljs-string">&quot;https://[your-owner-name]-[your-space-name].hf.space&quot;</span>,
        api_key=<span class="hljs-string">&quot;[your-api-key]&quot;</span>,
        num_generations=<span class="hljs-number">2</span>,
    )

    load_dataset.connect(evaluate_responses)
    evaluate_responses.connect(keep_columns)
    keep_columns.connect(to_argilla)`,wrap:!1}}),ml=new y({props:{code:"ZGlzdGlzZXQlMjAlM0QlMjBwaXBlbGluZS5ydW4oKQ==",highlighted:"distiset = pipeline.run()",wrap:!1}}),fl=new y({props:{code:"ZGlzdGlzZXQucHVzaF90b19odWIoJTIyJTVCeW91ci1vd25lci1uYW1lJTVEJTJGZXhhbXBsZS1jbGVhbmVkLXByZWZlcmVuY2UtZGF0YXNldCUyMik=",highlighted:'distiset.push_to_hub(<span class="hljs-string">&quot;[your-owner-name]/example-cleaned-preference-dataset&quot;</span>)',wrap:!1}}),gl=new J({props:{title:"Conclusions",local:"conclusions",headingTag:"h2"}}),bl=new Zt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/clean_dataset_judges_distilabel.md"}}),{c(){m=i("meta"),Zl=a(),$l=i("p"),ql=a(),o(U.$$.fragment),Gl=a(),o(I.$$.fragment),El=a(),f=i("p"),f.innerHTML=Xe,kl=a(),g=i("ul"),g.innerHTML=He,Vl=a(),A=i("p"),A.innerHTML=Se,Wl=a(),C=i("p"),C.innerHTML=Ye,vl=a(),b=i("p"),b.innerHTML=ze,_l=a(),o($.$$.fragment),Ql=a(),o(B.$$.fragment),Nl=a(),Z=i("p"),Z.textContent=Le,Rl=a(),o(q.$$.fragment),Fl=a(),o(G.$$.fragment),xl=a(),E=i("p"),E.textContent=De,Xl=a(),o(k.$$.fragment),Hl=a(),V=i("p"),V.innerHTML=Pe,Sl=a(),o(W.$$.fragment),Yl=a(),o(v.$$.fragment),zl=a(),_=i("p"),_.innerHTML=Ke,Ll=a(),Q=i("p"),Q.textContent=Oe,Dl=a(),o(N.$$.fragment),Pl=a(),o(R.$$.fragment),Kl=a(),F=i("p"),F.innerHTML=lt,Ol=a(),w=i("iframe"),le=a(),o(x.$$.fragment),ee=a(),X=i("p"),X.innerHTML=tt,te=a(),o(H.$$.fragment),se=a(),o(S.$$.fragment),ae=a(),o(Y.$$.fragment),ne=a(),z=i("p"),z.innerHTML=st,ie=a(),o(L.$$.fragment),Me=a(),o(D.$$.fragment),oe=a(),o(P.$$.fragment),pe=a(),K=i("p"),K.innerHTML=at,re=a(),o(O.$$.fragment),ce=a(),ll=i("p"),ll.textContent=nt,ue=a(),el=i("ul"),el.innerHTML=it,je=a(),o(tl.$$.fragment),de=a(),o(sl.$$.fragment),ye=a(),al=i("p"),al.innerHTML=Mt,Je=a(),nl=i("ul"),nl.innerHTML=ot,we=a(),il=i("p"),il.innerHTML=pt,Te=a(),o(Ml.$$.fragment),he=a(),o(ol.$$.fragment),me=a(),pl=i("p"),pl.textContent=rt,Ue=a(),rl=i("ul"),rl.innerHTML=ct,Ie=a(),o(cl.$$.fragment),fe=a(),o(ul.$$.fragment),ge=a(),jl=i("p"),jl.textContent=ut,Ae=a(),dl=i("ul"),dl.innerHTML=jt,Ce=a(),o(yl.$$.fragment),be=a(),o(Jl.$$.fragment),$e=a(),wl=i("p"),wl.textContent=dt,Be=a(),o(Tl.$$.fragment),Ze=a(),hl=i("p"),hl.textContent=yt,qe=a(),o(ml.$$.fragment),Ge=a(),Ul=i("p"),Ul.innerHTML=Jt,Ee=a(),Il=i("p"),Il.innerHTML=wt,ke=a(),o(fl.$$.fragment),Ve=a(),T=i("iframe"),We=a(),o(gl.$$.fragment),ve=a(),Al=i("p"),Al.textContent=ht,_e=a(),Cl=i("p"),Cl.textContent=mt,Qe=a(),o(bl.$$.fragment),Ne=a(),Bl=i("p"),this.h()},l(l){const e=bt("svelte-u9bgzb",document.head);m=M(e,"META",{name:!0,content:!0}),e.forEach(t),Zl=n(l),$l=M(l,"P",{}),Fe($l).forEach(t),ql=n(l),p(U.$$.fragment,l),Gl=n(l),p(I.$$.fragment,l),El=n(l),f=M(l,"P",{"data-svelte-h":!0}),d(f)!=="svelte-gisfdz"&&(f.innerHTML=Xe),kl=n(l),g=M(l,"UL",{"data-svelte-h":!0}),d(g)!=="svelte-mbqi7c"&&(g.innerHTML=He),Vl=n(l),A=M(l,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1upfgij"&&(A.innerHTML=Se),Wl=n(l),C=M(l,"P",{"data-svelte-h":!0}),d(C)!=="svelte-13wpfbf"&&(C.innerHTML=Ye),vl=n(l),b=M(l,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1tx7tfk"&&(b.innerHTML=ze),_l=n(l),p($.$$.fragment,l),Ql=n(l),p(B.$$.fragment,l),Nl=n(l),Z=M(l,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-3bna4r"&&(Z.textContent=Le),Rl=n(l),p(q.$$.fragment,l),Fl=n(l),p(G.$$.fragment,l),xl=n(l),E=M(l,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1efpmun"&&(E.textContent=De),Xl=n(l),p(k.$$.fragment,l),Hl=n(l),V=M(l,"P",{"data-svelte-h":!0}),d(V)!=="svelte-a7dt3m"&&(V.innerHTML=Pe),Sl=n(l),p(W.$$.fragment,l),Yl=n(l),p(v.$$.fragment,l),zl=n(l),_=M(l,"P",{"data-svelte-h":!0}),d(_)!=="svelte-104zazh"&&(_.innerHTML=Ke),Ll=n(l),Q=M(l,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-nd7qbb"&&(Q.textContent=Oe),Dl=n(l),p(N.$$.fragment,l),Pl=n(l),p(R.$$.fragment,l),Kl=n(l),F=M(l,"P",{"data-svelte-h":!0}),d(F)!=="svelte-n55nu"&&(F.innerHTML=lt),Ol=n(l),w=M(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Fe(w).forEach(t),le=n(l),p(x.$$.fragment,l),ee=n(l),X=M(l,"P",{"data-svelte-h":!0}),d(X)!=="svelte-tyuym6"&&(X.innerHTML=tt),te=n(l),p(H.$$.fragment,l),se=n(l),p(S.$$.fragment,l),ae=n(l),p(Y.$$.fragment,l),ne=n(l),z=M(l,"P",{"data-svelte-h":!0}),d(z)!=="svelte-82wvvi"&&(z.innerHTML=st),ie=n(l),p(L.$$.fragment,l),Me=n(l),p(D.$$.fragment,l),oe=n(l),p(P.$$.fragment,l),pe=n(l),K=M(l,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1torx5s"&&(K.innerHTML=at),re=n(l),p(O.$$.fragment,l),ce=n(l),ll=M(l,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1tymi5a"&&(ll.textContent=nt),ue=n(l),el=M(l,"UL",{"data-svelte-h":!0}),d(el)!=="svelte-62eraq"&&(el.innerHTML=it),je=n(l),p(tl.$$.fragment,l),de=n(l),p(sl.$$.fragment,l),ye=n(l),al=M(l,"P",{"data-svelte-h":!0}),d(al)!=="svelte-z2q9he"&&(al.innerHTML=Mt),Je=n(l),nl=M(l,"UL",{"data-svelte-h":!0}),d(nl)!=="svelte-1lich0g"&&(nl.innerHTML=ot),we=n(l),il=M(l,"P",{"data-svelte-h":!0}),d(il)!=="svelte-wb9t0n"&&(il.innerHTML=pt),Te=n(l),p(Ml.$$.fragment,l),he=n(l),p(ol.$$.fragment,l),me=n(l),pl=M(l,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-yp3cey"&&(pl.textContent=rt),Ue=n(l),rl=M(l,"UL",{"data-svelte-h":!0}),d(rl)!=="svelte-hoflav"&&(rl.innerHTML=ct),Ie=n(l),p(cl.$$.fragment,l),fe=n(l),p(ul.$$.fragment,l),ge=n(l),jl=M(l,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-1x55czc"&&(jl.textContent=ut),Ae=n(l),dl=M(l,"UL",{"data-svelte-h":!0}),d(dl)!=="svelte-sera5w"&&(dl.innerHTML=jt),Ce=n(l),p(yl.$$.fragment,l),be=n(l),p(Jl.$$.fragment,l),$e=n(l),wl=M(l,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-z5tzhe"&&(wl.textContent=dt),Be=n(l),p(Tl.$$.fragment,l),Ze=n(l),hl=M(l,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-io3h18"&&(hl.textContent=yt),qe=n(l),p(ml.$$.fragment,l),Ge=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-1gqov0s"&&(Ul.innerHTML=Jt),Ee=n(l),Il=M(l,"P",{"data-svelte-h":!0}),d(Il)!=="svelte-1cen2j5"&&(Il.innerHTML=wt),ke=n(l),p(fl.$$.fragment,l),Ve=n(l),T=M(l,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Fe(T).forEach(t),We=n(l),p(gl.$$.fragment,l),ve=n(l),Al=M(l,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-ct6t5z"&&(Al.textContent=ht),_e=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),d(Cl)!=="svelte-u277as"&&(Cl.textContent=mt),Qe=n(l),p(bl.$$.fragment,l),Ne=n(l),Bl=M(l,"P",{}),Fe(Bl).forEach(t),this.h()},h(){h(m,"name","hf:doc:metadata"),h(m,"content",Gt),Ut(w.src,et="https://huggingface.co/datasets/Intel/orca_dpo_pairs/embed/viewer/default/train")||h(w,"src",et),h(w,"frameborder","0"),h(w,"width","100%"),h(w,"height","560px"),Ut(T.src,Tt="https://huggingface.co/datasets/distilabel-internal-testing/example-cleaned-preference-dataset/embed/viewer/default/train")||h(T,"src",Tt),h(T,"frameborder","0"),h(T,"width","100%"),h(T,"height","560px")},m(l,e){$t(document.head,m),s(l,Zl,e),s(l,$l,e),s(l,ql,e),r(U,l,e),s(l,Gl,e),r(I,l,e),s(l,El,e),s(l,f,e),s(l,kl,e),s(l,g,e),s(l,Vl,e),s(l,A,e),s(l,Wl,e),s(l,C,e),s(l,vl,e),s(l,b,e),s(l,_l,e),r($,l,e),s(l,Ql,e),r(B,l,e),s(l,Nl,e),s(l,Z,e),s(l,Rl,e),r(q,l,e),s(l,Fl,e),r(G,l,e),s(l,xl,e),s(l,E,e),s(l,Xl,e),r(k,l,e),s(l,Hl,e),s(l,V,e),s(l,Sl,e),r(W,l,e),s(l,Yl,e),r(v,l,e),s(l,zl,e),s(l,_,e),s(l,Ll,e),s(l,Q,e),s(l,Dl,e),r(N,l,e),s(l,Pl,e),r(R,l,e),s(l,Kl,e),s(l,F,e),s(l,Ol,e),s(l,w,e),s(l,le,e),r(x,l,e),s(l,ee,e),s(l,X,e),s(l,te,e),r(H,l,e),s(l,se,e),r(S,l,e),s(l,ae,e),r(Y,l,e),s(l,ne,e),s(l,z,e),s(l,ie,e),r(L,l,e),s(l,Me,e),r(D,l,e),s(l,oe,e),r(P,l,e),s(l,pe,e),s(l,K,e),s(l,re,e),r(O,l,e),s(l,ce,e),s(l,ll,e),s(l,ue,e),s(l,el,e),s(l,je,e),r(tl,l,e),s(l,de,e),r(sl,l,e),s(l,ye,e),s(l,al,e),s(l,Je,e),s(l,nl,e),s(l,we,e),s(l,il,e),s(l,Te,e),r(Ml,l,e),s(l,he,e),r(ol,l,e),s(l,me,e),s(l,pl,e),s(l,Ue,e),s(l,rl,e),s(l,Ie,e),r(cl,l,e),s(l,fe,e),r(ul,l,e),s(l,ge,e),s(l,jl,e),s(l,Ae,e),s(l,dl,e),s(l,Ce,e),r(yl,l,e),s(l,be,e),r(Jl,l,e),s(l,$e,e),s(l,wl,e),s(l,Be,e),r(Tl,l,e),s(l,Ze,e),s(l,hl,e),s(l,qe,e),r(ml,l,e),s(l,Ge,e),s(l,Ul,e),s(l,Ee,e),s(l,Il,e),s(l,ke,e),r(fl,l,e),s(l,Ve,e),s(l,T,e),s(l,We,e),r(gl,l,e),s(l,ve,e),s(l,Al,e),s(l,_e,e),s(l,Cl,e),s(l,Qe,e),r(bl,l,e),s(l,Ne,e),s(l,Bl,e),Re=!0},p:ft,i(l){Re||(c(U.$$.fragment,l),c(I.$$.fragment,l),c($.$$.fragment,l),c(B.$$.fragment,l),c(q.$$.fragment,l),c(G.$$.fragment,l),c(k.$$.fragment,l),c(W.$$.fragment,l),c(v.$$.fragment,l),c(N.$$.fragment,l),c(R.$$.fragment,l),c(x.$$.fragment,l),c(H.$$.fragment,l),c(S.$$.fragment,l),c(Y.$$.fragment,l),c(L.$$.fragment,l),c(D.$$.fragment,l),c(P.$$.fragment,l),c(O.$$.fragment,l),c(tl.$$.fragment,l),c(sl.$$.fragment,l),c(Ml.$$.fragment,l),c(ol.$$.fragment,l),c(cl.$$.fragment,l),c(ul.$$.fragment,l),c(yl.$$.fragment,l),c(Jl.$$.fragment,l),c(Tl.$$.fragment,l),c(ml.$$.fragment,l),c(fl.$$.fragment,l),c(gl.$$.fragment,l),c(bl.$$.fragment,l),Re=!0)},o(l){u(U.$$.fragment,l),u(I.$$.fragment,l),u($.$$.fragment,l),u(B.$$.fragment,l),u(q.$$.fragment,l),u(G.$$.fragment,l),u(k.$$.fragment,l),u(W.$$.fragment,l),u(v.$$.fragment,l),u(N.$$.fragment,l),u(R.$$.fragment,l),u(x.$$.fragment,l),u(H.$$.fragment,l),u(S.$$.fragment,l),u(Y.$$.fragment,l),u(L.$$.fragment,l),u(D.$$.fragment,l),u(P.$$.fragment,l),u(O.$$.fragment,l),u(tl.$$.fragment,l),u(sl.$$.fragment,l),u(Ml.$$.fragment,l),u(ol.$$.fragment,l),u(cl.$$.fragment,l),u(ul.$$.fragment,l),u(yl.$$.fragment,l),u(Jl.$$.fragment,l),u(Tl.$$.fragment,l),u(ml.$$.fragment,l),u(fl.$$.fragment,l),u(gl.$$.fragment,l),u(bl.$$.fragment,l),Re=!1},d(l){l&&(t(Zl),t($l),t(ql),t(Gl),t(El),t(f),t(kl),t(g),t(Vl),t(A),t(Wl),t(C),t(vl),t(b),t(_l),t(Ql),t(Nl),t(Z),t(Rl),t(Fl),t(xl),t(E),t(Xl),t(Hl),t(V),t(Sl),t(Yl),t(zl),t(_),t(Ll),t(Q),t(Dl),t(Pl),t(Kl),t(F),t(Ol),t(w),t(le),t(ee),t(X),t(te),t(se),t(ae),t(ne),t(z),t(ie),t(Me),t(oe),t(pe),t(K),t(re),t(ce),t(ll),t(ue),t(el),t(je),t(de),t(ye),t(al),t(Je),t(nl),t(we),t(il),t(Te),t(he),t(me),t(pl),t(Ue),t(rl),t(Ie),t(fe),t(ge),t(jl),t(Ae),t(dl),t(Ce),t(be),t($e),t(wl),t(Be),t(Ze),t(hl),t(qe),t(Ge),t(Ul),t(Ee),t(Il),t(ke),t(Ve),t(T),t(We),t(ve),t(Al),t(_e),t(Cl),t(Qe),t(Ne),t(Bl)),t(m),j(U,l),j(I,l),j($,l),j(B,l),j(q,l),j(G,l),j(k,l),j(W,l),j(v,l),j(N,l),j(R,l),j(x,l),j(H,l),j(S,l),j(Y,l),j(L,l),j(D,l),j(P,l),j(O,l),j(tl,l),j(sl,l),j(Ml,l),j(ol,l),j(cl,l),j(ul,l),j(yl,l),j(Jl,l),j(Tl,l),j(ml,l),j(fl,l),j(gl,l),j(bl,l)}}}const Gt='{"title":"Clean an Existing Preference Dataset with LLMs as Judges","local":"clean-an-existing-preference-dataset-with-llms-as-judges","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install the dependencies","local":"install-the-dependencies","sections":[],"depth":3},{"title":"(optional) Deploy Argilla","local":"optional-deploy-argilla","sections":[],"depth":3}],"depth":2},{"title":"The dataset","local":"the-dataset","sections":[{"title":"(optional) Create a custom step","local":"optional-create-a-custom-step","sections":[],"depth":3}],"depth":2},{"title":"Define the pipeline","local":"define-the-pipeline","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":3},{"title":"Evaluate the responses","local":"evaluate-the-responses","sections":[],"depth":3},{"title":"Keep only the required columns","local":"keep-only-the-required-columns","sections":[],"depth":3},{"title":"(Optional) Further data curation","local":"optional-further-data-curation","sections":[],"depth":3}],"depth":2},{"title":"Run the pipeline","local":"run-the-pipeline","sections":[],"depth":2},{"title":"Conclusions","local":"conclusions","sections":[],"depth":2}],"depth":1}';function Et(xe){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends At{constructor(m){super(),Ct(this,m,Et,qt,It,{})}}export{_t as component};
