import{s as xe,f as de,n as ze,o as ve}from"../chunks/scheduler.39a43cde.js";import{S as Ve,i as Ge,g as i,s,r as n,A as Ie,h as a,f as l,c as o,j as he,u as p,x as w,k as kl,y as ke,a as e,v as U,d as K,t as f,w as r}from"../chunks/index.23ec2204.js";import{D as Qe,C as j}from"../chunks/DocNotebookDropdown.7c3158f8.js";import{H as m,E as Xe}from"../chunks/index.724daca9.js";function Ze(Ql){let M,tt,_A,lt,c,et,F,st,y,Xl='<em>作者: <a href="https://github.com/emre570" rel="nofollow">Emre Albayrak</a></em>',ot,g,Zl="本指南概述了在自定义生物医学数据集上微调视觉 transformer（ViT）模型的过程。它包括加载数据集和准备数据集的步骤，为不同的数据拆分设置图像转换，配置和初始化 ViT 模型，以及定义具有评估和可视化工具的训练过程。",it,R,at,C,ql="自定义数据集是手工制作的，包含 780 张图片，分为 3 类（良性，恶性，正常）。",nt,J,Wl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/102d6c23e6cc24db857fbc60186461ded6cdfb75/datasetinfo.png" alt="attachment:datasetinfo.png"/>',pt,B,Ut,u,Nl='我们所要微调的模型是 Google 的 <a href="https://huggingface.co/google/vit-large-patch16-224" rel="nofollow"><code>&quot;vit-large-patch16-224&quot;</code></a> 模型，该模型可以在 Hugging Face 的模型库中找到。这个模型是在 ImageNet-21k 数据集上进行预训练的，该数据集包含 1400 万张图片和 21,843 个类别。之后，它在 ImageNet 2012 数据集上进行了微调，该数据集有 100 万张图片和 1000 个类别，图像分辨率统一为 224x224。Google 还提供了其他几种 ViT（Vision Transformer）模型，它们具有不同的图像尺寸和分割块大小。',Kt,b,Dl="现在，让我们开始吧。",ft,T,rt,H,Sl="首先，让我们安装库。",wt,P,jt,d,Yl="(可选) 我们会把我们的模型推送到 hugging face hub 上，所以我们必须登录。",mt,h,Mt,x,ct,z,Ol='数据集库会自动从数据集中拉取图片和类别。若需更详细的信息，你可以访问这个<a href="https://huggingface.co/docs/datasets/image_load" rel="nofollow"><code>链接</code></a>。',Ft,v,yt,V,Ll="我们已获得数据集。但我们没有验证集。为了创建验证集，我们将根据测试集的大小计算验证集作为训练集的一部分的大小。然后我们将训练数据集拆分为新的训练和验证子集。",gt,G,Rt,I,El="我们已获得分离的训练集。现在让我们将其与测试集合并。",Ct,k,Jt,Q,$l="完美！我们的数据集已经准备好了。现在我们将子集分配给不同的变量。我们将在后面使用它们以便于引用。",Bt,X,ut,Z,_l="我们可以看到这张图片是一个与标签关联的PIL.Image对象。",bt,q,Tt,W,Ae="我们还可以查看训练集的特征。",Ht,N,Pt,D,te="让我们从数据集中显示每个类的一个图像。",dt,S,ht,EA,le,xt,Y,zt,O,ee="数据集已经准备好了。但我们还没有为微调做好准备。我们将按照以下步骤进行：",vt,L,se="<li><p><strong>标签映射：</strong> 我们将标签 ID 与其对应的名字之间进行转换，这对于模型训练和评估非常有用。</p></li> <li><p><strong>图像处理：</strong> 然后，我们使用 ViTImageProcessor 来标准化输入图像的大小，并应用特定于预训练模型的归一化。同时，我们还将为训练、验证和测试定义不同的转换，以使用 torchvision 提高模型的泛化能力。</p></li> <li><p><strong>转换函数：</strong> 实现函数以将转换应用于数据集，将图像转换为 ViT 模型所需格式和尺寸。</p></li> <li><p><strong>数据加载：</strong> 设置一个自定义的整理函数以正确地批量处理图像和标签，并创建一个 DataLoader 以在模型训练期间高效地加载数据和批量处理。</p></li> <li><p><strong>批量准备：</strong> 检索并显示样本批量中数据的形状，以验证处理是否正确并为模型输入做好准备。</p></li>",Vt,E,Gt,$,It,_,kt,AA,Qt,tA,Xt,lA,Zt,eA,qt,sA,Wt,oA,Nt,iA,Dt,aA,St,nA,oe="看起来我们将像素值转换成了张量。",Yt,pA,Ot,UA,Lt,KA,Et,fA,$t,rA,ie=`pixel_values torch.Size([4, 3, 224, 224])
labels torch.Size([4])
`,_t,wA,ae="完美！现在我们为微调过程做好了准备。",Al,jA,tl,mA,ne="现在我们将配置和微调模型。我们首先使用特定的标签映射和预训练设置初始化模型，调整大小不匹配的问题。训练参数被设置用来定义模型的学习过程，包括保存策略、批量大小和训练轮次，结果将通过 Weights & Biases 进行记录。Hugging Face Trainer 然后将实例化以管理训练和评估，利用自定义数据整理器和模型的内置处理器。最后，在训练之后，模型的性能将在测试数据集上进行评估，并打印指标以评估其准确性。",ll,MA,pe="首先，我们调用我们的模型。",el,cA,sl,FA,Ue="这里有一个微妙的细节。<code>ignore_mismatched_sizes</code> 参数。",ol,yA,Ke=`当你在一个新数据集上微调预训练模型时，有时你的图像的输入大小或模型架构的特定细节（比如分类层中的标签数量）可能与模型最初训练时的大小不完全匹配。这可能会由于各种原因而发生，例如当你在完全不同类型的图像数据（如医学图像或专业相机图像）上使用在一种类型的图像数据（如ImageNet中的自然图像）上训练的模型时。
将 <code>ignore_mismatched_sizes</code> 设置为 <code>True</code> 允许模型调整其层以适应大小差异，而不会抛出错误。`,il,gA,fe="例如，这个模型训练的类数是1000，即 <code>torch.Size([1000])</code>，它期望一个具有 <code>torch.Size([1000])</code> 类的输入。我们的数据集有3类，即 <code>torch.Size([3])</code> 类。如果我们直接给它，它会抛出错误，因为类别数量不匹配。",al,RA,re="然后，为这个模型定义来自谷歌的训练参数。",nl,CA,we="(可选) 注意，由于我们将 <code>report_to</code> 参数设置为 <code>wandb</code>，指标将被保存在 Weights &amp; Biases 中。W&amp;B 将要求你提供一个 API 密钥，因此你应该创建一个账户和一个API密钥。如果你不希望这样做，你可以删除 <code>report_to</code> 参数。",pl,JA,Ul,BA,je="我们现在可以使用 <code>Trainer</code> 开始微调过程。",Kl,uA,fl,bA,me="<thead><tr><th>Epoch</th> <th>训练损失</th> <th>验证损失</th> <th>准确率</th></tr></thead> <tbody><tr><td>40</td> <td>0.174700</td> <td>0.596288</td> <td>0.903846</td></tr></tbody>",rl,TA,Me="微调过程已完成。接下来，我们继续使用测试集评估模型。",wl,HA,jl,PA,ce=`&#123;'test_loss': 0.40843912959098816, 'test_runtime': 4.9934, 'test_samples_per_second': 31.242, 'test_steps_per_second': 7.81}
`,ml,dA,Fe="<code>{&#39;test_loss&#39;: 0.3219967782497406, &#39;test_accuracy&#39;: 0.9102564102564102, &#39;test_runtime&#39;: 4.0543, &#39;test_samples_per_second&#39;: 38.478, &#39;test_steps_per_second&#39;: 9.619}</code>",Ml,hA,cl,xA,ye="我们可以使用 <code>push_to_hub</code> 将我们的模型推送到 Hugging Face Hub。",Fl,zA,yl,vA,ge="太棒了！让我们可视化结果。",gl,VA,Rl,GA,Re="我们已经完成了微调。让我们看看我们的模型是如何预测类别的，使用 scikit-learn 的混淆矩阵显示，并展示召回率。",Cl,IA,Jl,kA,Ce="混淆矩阵是一种特定的表格布局，它允许可视化算法的性能，通常是监督学习模型，在一组已知真实值的测试数据上。它特别有用，因为可以检查分类模型的性能，因为它显示了真实标签与预测标签的频率。",Bl,QA,Je="让我们绘制我们模型的混淆矩阵。",ul,XA,bl,$A,Be,Tl,ZA,Hl,qA,ue="召回率是分类任务中使用的性能指标，用于衡量模型正确识别数据集中所有相关实例的能力。具体来说，召回率评估了模型正确预测为阳性的实际阳性比例。",Pl,WA,be="让我们使用 scikit-learn 打印召回率。",dl,NA,hl,DA,Te=`Recall for benign: 0.90
Recall for malignant: 0.86
Recall for normal: 0.78
`,xl,SA,He="<code>良性召回率为0.90， 恶性召回率为0.86， 正常召回率为0.78</code>",zl,YA,vl,OA,Pe="在这个指南中，我们介绍了如何使用医学数据集训练一个 ViT 模型。它涵盖了关键的步骤，如数据集准备、图像预处理、模型配置、训练、评估和结果可视化。通过利用 Hugging Face 的 Transformers 库、scikit-learn 和 PyTorch Torchvision，它促进了高效的模型训练和评估，提供了关于模型性能及其准确分类生物医学图像能力的宝贵见解。",Vl,LA,Gl,At,Il;return c=new Qe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/fine_tuning_vit_custom_dataset.ipynb"}]}}),F=new m({props:{title:"用自定义生物医学数据集微调视觉 Transformer 模型",local:"用自定义生物医学数据集微调视觉-transformer-模型",headingTag:"h1"}}),R=new m({props:{title:"数据集信息",local:"数据集信息",headingTag:"h2"}}),B=new m({props:{title:"模型信息",local:"模型信息",headingTag:"h2"}}),T=new m({props:{title:"开始",local:"开始",headingTag:"h2"}}),P=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjB0b3JjaCUyMHNjaWtpdC1sZWFybiUyMG1hdHBsb3RsaWIlMjB3YW5kYg==",highlighted:"!pip install datasets transformers accelerate torch scikit-learn matplotlib wandb",wrap:!1}}),h=new j({props:{code:"JTIzJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTIzJTIwbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-comment"># from huggingface_hub import notebook_login</span>
<span class="hljs-comment"># notebook_login()</span>`,wrap:!1}}),x=new m({props:{title:"数据集准备",local:"数据集准备",headingTag:"h2"}}),v=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJlbXJlNTcwJTJGYnJlYXN0Y2FuY2VyLXVsdHJhc291bmQtaW1hZ2VzJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;emre570/breastcancer-ultrasound-images&quot;</span>)
dataset`,wrap:!1}}),G=new j({props:{code:"JTIzJTIwR2V0JTIwdGhlJTIwbnVtYmVycyUyMG9mJTIwZWFjaCUyMHNldCUwQXRlc3RfbnVtJTIwJTNEJTIwbGVuKGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEKSUwQXRyYWluX251bSUyMCUzRCUyMGxlbihkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBdmFsX3NpemUlMjAlM0QlMjB0ZXN0X251bSUyMCUyRiUyMHRyYWluX251bSUwQSUwQXRyYWluX3ZhbF9zcGxpdCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RC50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRHZhbF9zaXplKSUwQXRyYWluX3ZhbF9zcGxpdA==",highlighted:`<span class="hljs-comment"># Get the numbers of each set</span>
test_num = <span class="hljs-built_in">len</span>(dataset[<span class="hljs-string">&quot;test&quot;</span>])
train_num = <span class="hljs-built_in">len</span>(dataset[<span class="hljs-string">&quot;train&quot;</span>])

val_size = test_num / train_num

train_val_split = dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=val_size)
train_val_split`,wrap:!1}}),k=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldERpY3QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldERpY3QoJTBBJTIwJTIwJTIwJTIwJTdCJTIydHJhaW4lMjIlM0ElMjB0cmFpbl92YWxfc3BsaXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMCUyMnZhbGlkYXRpb24lMjIlM0ElMjB0cmFpbl92YWxfc3BsaXQlNUIlMjJ0ZXN0JTIyJTVEJTJDJTIwJTIydGVzdCUyMiUzQSUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTdEJTBBKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> DatasetDict

dataset = DatasetDict(
    {<span class="hljs-string">&quot;train&quot;</span>: train_val_split[<span class="hljs-string">&quot;train&quot;</span>], <span class="hljs-string">&quot;validation&quot;</span>: train_val_split[<span class="hljs-string">&quot;test&quot;</span>], <span class="hljs-string">&quot;test&quot;</span>: dataset[<span class="hljs-string">&quot;test&quot;</span>]}
)
dataset`,wrap:!1}}),X=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMEF2YWxfZHMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQXRlc3RfZHMlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RA==",highlighted:`train_ds = dataset[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = dataset[<span class="hljs-string">&quot;validation&quot;</span>]
test_ds = dataset[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),q=new j({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:'train_ds[<span class="hljs-number">0</span>]',wrap:!1}}),N=new j({props:{code:"dHJhaW5fZHMuZmVhdHVyZXM=",highlighted:"train_ds.features",wrap:!1}}),S=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBhJTIwc2V0JTIwdG8lMjBrZWVwJTIwdHJhY2slMjBvZiUyMHNob3duJTIwbGFiZWxzJTBBc2hvd25fbGFiZWxzJTIwJTNEJTIwc2V0KCklMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwZmlndXJlJTIwZm9yJTIwcGxvdHRpbmclMEFwbHQuZmlndXJlKGZpZ3NpemUlM0QoMTAlMkMlMjAxMCkpJTBBJTBBJTIzJTIwTG9vcCUyMHRocm91Z2glMjB0aGUlMjBkYXRhc2V0JTIwYW5kJTIwcGxvdCUyMHRoZSUyMGZpcnN0JTIwaW1hZ2UlMjBvZiUyMGVhY2glMjBsYWJlbCUwQWZvciUyMGklMkMlMjBzYW1wbGUlMjBpbiUyMGVudW1lcmF0ZSh0cmFpbl9kcyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHRyYWluX2RzLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlNUJzYW1wbGUlNUIlMjJsYWJlbCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbGFiZWwlMjBub3QlMjBpbiUyMHNob3duX2xhYmVscyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsdC5zdWJwbG90KDElMkMlMjBsZW4odHJhaW5fZHMuZmVhdHVyZXMlNUIlMjJsYWJlbCUyMiU1RC5uYW1lcyklMkMlMjBsZW4oc2hvd25fbGFiZWxzKSUyMCUyQiUyMDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0Lmltc2hvdyhzYW1wbGUlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbHQudGl0bGUobGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LmF4aXMoJTIyb2ZmJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNob3duX2xhYmVscy5hZGQobGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc2hvd25fbGFiZWxzKSUyMCUzRCUzRCUyMGxlbih0cmFpbl9kcy5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize a set to keep track of shown labels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>shown_labels = <span class="hljs-built_in">set</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the figure for plotting</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loop through the dataset and plot the first image of each label</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, sample <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_ds):
<span class="hljs-meta">... </span>    label = train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names[sample[<span class="hljs-string">&quot;label&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> label <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> shown_labels:
<span class="hljs-meta">... </span>        plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names), <span class="hljs-built_in">len</span>(shown_labels) + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>        plt.imshow(sample[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        plt.title(label)
<span class="hljs-meta">... </span>        plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>        shown_labels.add(label)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(shown_labels) == <span class="hljs-built_in">len</span>(train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names):
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),Y=new m({props:{title:"数据处理",local:"数据处理",headingTag:"h2"}}),E=new m({props:{title:"标签映射",local:"标签映射",headingTag:"h3"}}),$=new j({props:{code:"aWQybGFiZWwlMjAlM0QlMjAlN0JpZCUzQSUyMGxhYmVsJTIwZm9yJTIwaWQlMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHRyYWluX2RzLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMpJTdEJTBBbGFiZWwyaWQlMjAlM0QlMjAlN0JsYWJlbCUzQSUyMGlkJTIwZm9yJTIwaWQlMkMlMjBsYWJlbCUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQWlkMmxhYmVsJTJDJTIwaWQybGFiZWwlNUJ0cmFpbl9kcyU1QjAlNUQlNUIlMjJsYWJlbCUyMiU1RCU1RA==",highlighted:`id2label = {<span class="hljs-built_in">id</span>: label <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names)}
label2id = {label: <span class="hljs-built_in">id</span> <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, label <span class="hljs-keyword">in</span> id2label.items()}
id2label, id2label[train_ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]]`,wrap:!1}}),_=new m({props:{title:"图像处理",local:"图像处理",headingTag:"h3"}}),AA=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEltYWdlUHJvY2Vzc29yJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMmdvb2dsZSUyRnZpdC1sYXJnZS1wYXRjaDE2LTIyNCUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFZpVEltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTImageProcessor

model_name = <span class="hljs-string">&quot;google/vit-large-patch16-224&quot;</span>
processor = ViTImageProcessor.from_pretrained(model_name)`,wrap:!1}}),tA=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEElMjAlMjAlMjAlMjBSZXNpemUlMkMlMEEpJTBBJTBBaW1hZ2VfbWVhbiUyQyUyMGltYWdlX3N0ZCUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9tZWFuJTJDJTIwcHJvY2Vzc29yLmltYWdlX3N0ZCUwQXNpemUlMjAlM0QlMjBwcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUwQSUwQW5vcm1hbGl6ZSUyMCUzRCUyME5vcm1hbGl6ZShtZWFuJTNEaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3N0ZCklMEElMEF0cmFpbl90cmFuc2Zvcm1zJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21SZXNpemVkQ3JvcChzaXplKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJhbmRvbUhvcml6b250YWxGbGlwKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb1RlbnNvcigpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXZhbF90cmFuc2Zvcm1zJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSZXNpemUoc2l6ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKHNpemUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vcm1hbGl6ZSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEF0ZXN0X3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShzaXplKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENlbnRlckNyb3Aoc2l6ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb1RlbnNvcigpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    ToTensor,
    Resize,
)

image_mean, image_std = processor.image_mean, processor.image_std
size = processor.size[<span class="hljs-string">&quot;height&quot;</span>]

normalize = Normalize(mean=image_mean, std=image_std)

train_transforms = Compose(
    [
        RandomResizedCrop(size),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)
val_transforms = Compose(
    [
        Resize(size),
        CenterCrop(size),
        ToTensor(),
        normalize,
    ]
)
test_transforms = Compose(
    [
        Resize(size),
        CenterCrop(size),
        ToTensor(),
        normalize,
    ]
)`,wrap:!1}}),lA=new m({props:{title:"创建转换函数",local:"创建转换函数",headingTag:"h3"}}),eA=new j({props:{code:"ZGVmJTIwYXBwbHlfdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnRyYWluX3RyYW5zZm9ybXMoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXMlMEElMEElMEFkZWYlMjBhcHBseV92YWxfdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGVzJTBBJTBBJTBBZGVmJTIwYXBwbHlfdGVzdF90cmFuc2Zvcm1zKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwJTVCdmFsX3RyYW5zZm9ybXMoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_train_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> examples


<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_val_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> examples


<span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_test_transforms</span>(<span class="hljs-params">examples</span>):
    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),sA=new m({props:{title:"将转换函数应用于每个集合",local:"将转换函数应用于每个集合",headingTag:"h3"}}),oA=new j({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybShhcHBseV90cmFpbl90cmFuc2Zvcm1zKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKGFwcGx5X3ZhbF90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybShhcHBseV90ZXN0X3RyYW5zZm9ybXMp",highlighted:`train_ds.set_transform(apply_train_transforms)
val_ds.set_transform(apply_val_transforms)
test_ds.set_transform(apply_test_transforms)`,wrap:!1}}),iA=new j({props:{code:"dHJhaW5fZHMuZmVhdHVyZXM=",highlighted:"train_ds.features",wrap:!1}}),aA=new j({props:{code:"dHJhaW5fZHMlNUIwJTVE",highlighted:'train_ds[<span class="hljs-number">0</span>]',wrap:!1}}),pA=new m({props:{title:"数据加载",local:"数据加载",headingTag:"h3"}}),UA=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEElMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdEJTBBJTBBJTBBdHJhaW5fZGwlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwY29sbGF0ZV9mbiUzRGNvbGxhdGVfZm4lMkMlMjBiYXRjaF9zaXplJTNENCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader


<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}


train_dl = DataLoader(train_ds, collate_fn=collate_fn, batch_size=<span class="hljs-number">4</span>)`,wrap:!1}}),KA=new m({props:{title:"批量准备",local:"批量准备",headingTag:"h3"}}),fA=new j({props:{code:"YmF0Y2glMjAlM0QlMjBuZXh0KGl0ZXIodHJhaW5fZGwpKSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKHYlMkMlMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoayUyQyUyMHYuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>batch = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dl))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(v, torch.Tensor):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(k, v.shape)`,wrap:!1}}),jA=new m({props:{title:"微调模型",local:"微调模型",headingTag:"h2"}}),cA=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViTForImageClassification

model = ViTForImageClassification.from_pretrained(
    model_name, id2label=id2label, label2id=label2id, ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)`,wrap:!1}}),JA=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQXRyYWluX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyb3V0cHV0LW1vZGVscyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTIyd2FuZGIlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMmUtNSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMC4wMSUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0QlMjJsb2dzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVtb3ZlX3VudXNlZF9jb2x1bW5zJTNERmFsc2UlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

train_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;output-models&quot;</span>,
    save_total_limit=<span class="hljs-number">2</span>,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    per_device_train_batch_size=<span class="hljs-number">10</span>,
    per_device_eval_batch_size=<span class="hljs-number">4</span>,
    num_train_epochs=<span class="hljs-number">40</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    logging_dir=<span class="hljs-string">&quot;logs&quot;</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),uA=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGNvbGxhdGVfZm4lMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IlMkMlMEEpJTBBdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    model,
    train_args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    data_collator=collate_fn,
    tokenizer=processor,
)
trainer.train()`,wrap:!1}}),HA=new j({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIucHJlZGljdCh0ZXN0X2RzKSUwQXByaW50KG91dHB1dHMubWV0cmljcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = trainer.predict(test_ds)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.metrics)`,wrap:!1}}),hA=new m({props:{title:"(可选) 将模型推送到 Hub",local:"可选-将模型推送到-hub",headingTag:"h3"}}),zA=new j({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIyeW91cl9tb2RlbF9uYW1lJTIyKQ==",highlighted:'model.push_to_hub(<span class="hljs-string">&quot;your_model_name&quot;</span>)',wrap:!1}}),VA=new m({props:{title:"结果",local:"结果",headingTag:"h2"}}),IA=new m({props:{title:"什么是混淆矩阵？",local:"什么是混淆矩阵",headingTag:"h3"}}),XA=new j({props:{code:"ZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMGNvbmZ1c2lvbl9tYXRyaXglMkMlMjBDb25mdXNpb25NYXRyaXhEaXNwbGF5JTBBJTBBeV90cnVlJTIwJTNEJTIwb3V0cHV0cy5sYWJlbF9pZHMlMEF5X3ByZWQlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25zLmFyZ21heCgxKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRyYWluX2RzLmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEFjbSUyMCUzRCUyMGNvbmZ1c2lvbl9tYXRyaXgoeV90cnVlJTJDJTIweV9wcmVkKSUwQWRpc3AlMjAlM0QlMjBDb25mdXNpb25NYXRyaXhEaXNwbGF5KGNvbmZ1c2lvbl9tYXRyaXglM0RjbSUyQyUyMGRpc3BsYXlfbGFiZWxzJTNEbGFiZWxzKSUwQWRpc3AucGxvdCh4dGlja3Nfcm90YXRpb24lM0Q0NSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> confusion_matrix, ConfusionMatrixDisplay

<span class="hljs-meta">&gt;&gt;&gt; </span>y_true = outputs.label_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>y_pred = outputs.predictions.argmax(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = train_ds.features[<span class="hljs-string">&quot;label&quot;</span>].names
<span class="hljs-meta">&gt;&gt;&gt; </span>cm = confusion_matrix(y_true, y_pred)
<span class="hljs-meta">&gt;&gt;&gt; </span>disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>disp.plot(xticks_rotation=<span class="hljs-number">45</span>)`,wrap:!1}}),ZA=new m({props:{title:"什么是召回率？",local:"什么是召回率",headingTag:"h3"}}),NA=new j({props:{code:"ZnJvbSUyMHNrbGVhcm4ubWV0cmljcyUyMGltcG9ydCUyMHJlY2FsbF9zY29yZSUwQSUwQSUyMyUyMENhbGN1bGF0ZSUyMHRoZSUyMHJlY2FsbCUyMHNjb3JlcyUwQSUyMyUyMCdOb25lJyUyMGNhbGN1bGF0ZXMlMjByZWNhbGwlMjBmb3IlMjBlYWNoJTIwY2xhc3MlMjBzZXBhcmF0ZWx5JTBBcmVjYWxsJTIwJTNEJTIwcmVjYWxsX3Njb3JlKHlfdHJ1ZSUyQyUyMHlfcHJlZCUyQyUyMGF2ZXJhZ2UlM0ROb25lKSUwQSUwQSUyMyUyMFByaW50JTIwdGhlJTIwcmVjYWxsJTIwZm9yJTIwZWFjaCUyMGNsYXNzJTBBZm9yJTIwbGFiZWwlMkMlMjBzY29yZSUyMGluJTIwemlwKGxhYmVscyUyQyUyMHJlY2FsbCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUmVjYWxsJTIwZm9yJTIwJTdCbGFiZWwlN0QlM0ElMjAlN0JzY29yZSUzQS4yZiU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sklearn.metrics <span class="hljs-keyword">import</span> recall_score

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Calculate the recall scores</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># &#x27;None&#x27; calculates recall for each class separately</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>recall = recall_score(y_true, y_pred, average=<span class="hljs-literal">None</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print the recall for each class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, recall):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Recall for <span class="hljs-subst">{label}</span>: <span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),YA=new m({props:{title:"结论",local:"结论",headingTag:"h2"}}),LA=new Xe({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/fine_tuning_vit_custom_dataset.md"}}),{c(){M=i("meta"),tt=s(),_A=i("p"),lt=s(),n(c.$$.fragment),et=s(),n(F.$$.fragment),st=s(),y=i("p"),y.innerHTML=Xl,ot=s(),g=i("p"),g.textContent=Zl,it=s(),n(R.$$.fragment),at=s(),C=i("p"),C.textContent=ql,nt=s(),J=i("p"),J.innerHTML=Wl,pt=s(),n(B.$$.fragment),Ut=s(),u=i("p"),u.innerHTML=Nl,Kt=s(),b=i("p"),b.textContent=Dl,ft=s(),n(T.$$.fragment),rt=s(),H=i("p"),H.textContent=Sl,wt=s(),n(P.$$.fragment),jt=s(),d=i("p"),d.textContent=Yl,mt=s(),n(h.$$.fragment),Mt=s(),n(x.$$.fragment),ct=s(),z=i("p"),z.innerHTML=Ol,Ft=s(),n(v.$$.fragment),yt=s(),V=i("p"),V.textContent=Ll,gt=s(),n(G.$$.fragment),Rt=s(),I=i("p"),I.textContent=El,Ct=s(),n(k.$$.fragment),Jt=s(),Q=i("p"),Q.textContent=$l,Bt=s(),n(X.$$.fragment),ut=s(),Z=i("p"),Z.textContent=_l,bt=s(),n(q.$$.fragment),Tt=s(),W=i("p"),W.textContent=Ae,Ht=s(),n(N.$$.fragment),Pt=s(),D=i("p"),D.textContent=te,dt=s(),n(S.$$.fragment),ht=s(),EA=i("img"),xt=s(),n(Y.$$.fragment),zt=s(),O=i("p"),O.textContent=ee,vt=s(),L=i("ul"),L.innerHTML=se,Vt=s(),n(E.$$.fragment),Gt=s(),n($.$$.fragment),It=s(),n(_.$$.fragment),kt=s(),n(AA.$$.fragment),Qt=s(),n(tA.$$.fragment),Xt=s(),n(lA.$$.fragment),Zt=s(),n(eA.$$.fragment),qt=s(),n(sA.$$.fragment),Wt=s(),n(oA.$$.fragment),Nt=s(),n(iA.$$.fragment),Dt=s(),n(aA.$$.fragment),St=s(),nA=i("p"),nA.textContent=oe,Yt=s(),n(pA.$$.fragment),Ot=s(),n(UA.$$.fragment),Lt=s(),n(KA.$$.fragment),Et=s(),n(fA.$$.fragment),$t=s(),rA=i("pre"),rA.textContent=ie,_t=s(),wA=i("p"),wA.textContent=ae,Al=s(),n(jA.$$.fragment),tl=s(),mA=i("p"),mA.textContent=ne,ll=s(),MA=i("p"),MA.textContent=pe,el=s(),n(cA.$$.fragment),sl=s(),FA=i("p"),FA.innerHTML=Ue,ol=s(),yA=i("p"),yA.innerHTML=Ke,il=s(),gA=i("p"),gA.innerHTML=fe,al=s(),RA=i("p"),RA.textContent=re,nl=s(),CA=i("p"),CA.innerHTML=we,pl=s(),n(JA.$$.fragment),Ul=s(),BA=i("p"),BA.innerHTML=je,Kl=s(),n(uA.$$.fragment),fl=s(),bA=i("table"),bA.innerHTML=me,rl=s(),TA=i("p"),TA.textContent=Me,wl=s(),n(HA.$$.fragment),jl=s(),PA=i("pre"),PA.textContent=ce,ml=s(),dA=i("p"),dA.innerHTML=Fe,Ml=s(),n(hA.$$.fragment),cl=s(),xA=i("p"),xA.innerHTML=ye,Fl=s(),n(zA.$$.fragment),yl=s(),vA=i("p"),vA.textContent=ge,gl=s(),n(VA.$$.fragment),Rl=s(),GA=i("p"),GA.textContent=Re,Cl=s(),n(IA.$$.fragment),Jl=s(),kA=i("p"),kA.textContent=Ce,Bl=s(),QA=i("p"),QA.textContent=Je,ul=s(),n(XA.$$.fragment),bl=s(),$A=i("img"),Tl=s(),n(ZA.$$.fragment),Hl=s(),qA=i("p"),qA.textContent=ue,Pl=s(),WA=i("p"),WA.textContent=be,dl=s(),n(NA.$$.fragment),hl=s(),DA=i("pre"),DA.textContent=Te,xl=s(),SA=i("p"),SA.innerHTML=He,zl=s(),n(YA.$$.fragment),vl=s(),OA=i("p"),OA.textContent=Pe,Vl=s(),n(LA.$$.fragment),Gl=s(),At=i("p"),this.h()},l(A){const t=Ie("svelte-u9bgzb",document.head);M=a(t,"META",{name:!0,content:!0}),t.forEach(l),tt=o(A),_A=a(A,"P",{}),he(_A).forEach(l),lt=o(A),p(c.$$.fragment,A),et=o(A),p(F.$$.fragment,A),st=o(A),y=a(A,"P",{"data-svelte-h":!0}),w(y)!=="svelte-j90vf8"&&(y.innerHTML=Xl),ot=o(A),g=a(A,"P",{"data-svelte-h":!0}),w(g)!=="svelte-14tbdkx"&&(g.textContent=Zl),it=o(A),p(R.$$.fragment,A),at=o(A),C=a(A,"P",{"data-svelte-h":!0}),w(C)!=="svelte-1n5d465"&&(C.textContent=ql),nt=o(A),J=a(A,"P",{"data-svelte-h":!0}),w(J)!=="svelte-6ujxmm"&&(J.innerHTML=Wl),pt=o(A),p(B.$$.fragment,A),Ut=o(A),u=a(A,"P",{"data-svelte-h":!0}),w(u)!=="svelte-1tv904c"&&(u.innerHTML=Nl),Kt=o(A),b=a(A,"P",{"data-svelte-h":!0}),w(b)!=="svelte-11pjy6u"&&(b.textContent=Dl),ft=o(A),p(T.$$.fragment,A),rt=o(A),H=a(A,"P",{"data-svelte-h":!0}),w(H)!=="svelte-1ypvx35"&&(H.textContent=Sl),wt=o(A),p(P.$$.fragment,A),jt=o(A),d=a(A,"P",{"data-svelte-h":!0}),w(d)!=="svelte-11b1r7"&&(d.textContent=Yl),mt=o(A),p(h.$$.fragment,A),Mt=o(A),p(x.$$.fragment,A),ct=o(A),z=a(A,"P",{"data-svelte-h":!0}),w(z)!=="svelte-15lbyn4"&&(z.innerHTML=Ol),Ft=o(A),p(v.$$.fragment,A),yt=o(A),V=a(A,"P",{"data-svelte-h":!0}),w(V)!=="svelte-2b6neo"&&(V.textContent=Ll),gt=o(A),p(G.$$.fragment,A),Rt=o(A),I=a(A,"P",{"data-svelte-h":!0}),w(I)!=="svelte-1e7eh4y"&&(I.textContent=El),Ct=o(A),p(k.$$.fragment,A),Jt=o(A),Q=a(A,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-txiyhq"&&(Q.textContent=$l),Bt=o(A),p(X.$$.fragment,A),ut=o(A),Z=a(A,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-9l16x1"&&(Z.textContent=_l),bt=o(A),p(q.$$.fragment,A),Tt=o(A),W=a(A,"P",{"data-svelte-h":!0}),w(W)!=="svelte-njl03p"&&(W.textContent=Ae),Ht=o(A),p(N.$$.fragment,A),Pt=o(A),D=a(A,"P",{"data-svelte-h":!0}),w(D)!=="svelte-10656ze"&&(D.textContent=te),dt=o(A),p(S.$$.fragment,A),ht=o(A),EA=a(A,"IMG",{src:!0}),xt=o(A),p(Y.$$.fragment,A),zt=o(A),O=a(A,"P",{"data-svelte-h":!0}),w(O)!=="svelte-qatcao"&&(O.textContent=ee),vt=o(A),L=a(A,"UL",{"data-svelte-h":!0}),w(L)!=="svelte-1wkjt79"&&(L.innerHTML=se),Vt=o(A),p(E.$$.fragment,A),Gt=o(A),p($.$$.fragment,A),It=o(A),p(_.$$.fragment,A),kt=o(A),p(AA.$$.fragment,A),Qt=o(A),p(tA.$$.fragment,A),Xt=o(A),p(lA.$$.fragment,A),Zt=o(A),p(eA.$$.fragment,A),qt=o(A),p(sA.$$.fragment,A),Wt=o(A),p(oA.$$.fragment,A),Nt=o(A),p(iA.$$.fragment,A),Dt=o(A),p(aA.$$.fragment,A),St=o(A),nA=a(A,"P",{"data-svelte-h":!0}),w(nA)!=="svelte-11cv390"&&(nA.textContent=oe),Yt=o(A),p(pA.$$.fragment,A),Ot=o(A),p(UA.$$.fragment,A),Lt=o(A),p(KA.$$.fragment,A),Et=o(A),p(fA.$$.fragment,A),$t=o(A),rA=a(A,"PRE",{"data-svelte-h":!0}),w(rA)!=="svelte-1er930r"&&(rA.textContent=ie),_t=o(A),wA=a(A,"P",{"data-svelte-h":!0}),w(wA)!=="svelte-iwpd39"&&(wA.textContent=ae),Al=o(A),p(jA.$$.fragment,A),tl=o(A),mA=a(A,"P",{"data-svelte-h":!0}),w(mA)!=="svelte-ozps7d"&&(mA.textContent=ne),ll=o(A),MA=a(A,"P",{"data-svelte-h":!0}),w(MA)!=="svelte-1lbhpkv"&&(MA.textContent=pe),el=o(A),p(cA.$$.fragment,A),sl=o(A),FA=a(A,"P",{"data-svelte-h":!0}),w(FA)!=="svelte-1s6b0tj"&&(FA.innerHTML=Ue),ol=o(A),yA=a(A,"P",{"data-svelte-h":!0}),w(yA)!=="svelte-ci5mtz"&&(yA.innerHTML=Ke),il=o(A),gA=a(A,"P",{"data-svelte-h":!0}),w(gA)!=="svelte-q6x316"&&(gA.innerHTML=fe),al=o(A),RA=a(A,"P",{"data-svelte-h":!0}),w(RA)!=="svelte-w1bllo"&&(RA.textContent=re),nl=o(A),CA=a(A,"P",{"data-svelte-h":!0}),w(CA)!=="svelte-tfszn2"&&(CA.innerHTML=we),pl=o(A),p(JA.$$.fragment,A),Ul=o(A),BA=a(A,"P",{"data-svelte-h":!0}),w(BA)!=="svelte-1u7hquk"&&(BA.innerHTML=je),Kl=o(A),p(uA.$$.fragment,A),fl=o(A),bA=a(A,"TABLE",{"data-svelte-h":!0}),w(bA)!=="svelte-1b0seea"&&(bA.innerHTML=me),rl=o(A),TA=a(A,"P",{"data-svelte-h":!0}),w(TA)!=="svelte-1hjy49q"&&(TA.textContent=Me),wl=o(A),p(HA.$$.fragment,A),jl=o(A),PA=a(A,"PRE",{"data-svelte-h":!0}),w(PA)!=="svelte-8qkmqm"&&(PA.textContent=ce),ml=o(A),dA=a(A,"P",{"data-svelte-h":!0}),w(dA)!=="svelte-189m2kt"&&(dA.innerHTML=Fe),Ml=o(A),p(hA.$$.fragment,A),cl=o(A),xA=a(A,"P",{"data-svelte-h":!0}),w(xA)!=="svelte-9omi8w"&&(xA.innerHTML=ye),Fl=o(A),p(zA.$$.fragment,A),yl=o(A),vA=a(A,"P",{"data-svelte-h":!0}),w(vA)!=="svelte-11qvr39"&&(vA.textContent=ge),gl=o(A),p(VA.$$.fragment,A),Rl=o(A),GA=a(A,"P",{"data-svelte-h":!0}),w(GA)!=="svelte-1ouccfv"&&(GA.textContent=Re),Cl=o(A),p(IA.$$.fragment,A),Jl=o(A),kA=a(A,"P",{"data-svelte-h":!0}),w(kA)!=="svelte-1sx8pg2"&&(kA.textContent=Ce),Bl=o(A),QA=a(A,"P",{"data-svelte-h":!0}),w(QA)!=="svelte-1be9m2i"&&(QA.textContent=Je),ul=o(A),p(XA.$$.fragment,A),bl=o(A),$A=a(A,"IMG",{src:!0}),Tl=o(A),p(ZA.$$.fragment,A),Hl=o(A),qA=a(A,"P",{"data-svelte-h":!0}),w(qA)!=="svelte-1k9t745"&&(qA.textContent=ue),Pl=o(A),WA=a(A,"P",{"data-svelte-h":!0}),w(WA)!=="svelte-1qqgxed"&&(WA.textContent=be),dl=o(A),p(NA.$$.fragment,A),hl=o(A),DA=a(A,"PRE",{"data-svelte-h":!0}),w(DA)!=="svelte-w7wxtb"&&(DA.textContent=Te),xl=o(A),SA=a(A,"P",{"data-svelte-h":!0}),w(SA)!=="svelte-uc2cs0"&&(SA.innerHTML=He),zl=o(A),p(YA.$$.fragment,A),vl=o(A),OA=a(A,"P",{"data-svelte-h":!0}),w(OA)!=="svelte-1y0b0en"&&(OA.textContent=Pe),Vl=o(A),p(LA.$$.fragment,A),Gl=o(A),At=a(A,"P",{}),he(At).forEach(l),this.h()},h(){kl(M,"name","hf:doc:metadata"),kl(M,"content",qe),de(EA.src,le="data:image/jpeg;base64,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")||kl(EA,"src",le),de($A.src,Be="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAHeAi8DASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiigAooooAKKKKACiiigAooooAKKKKACiiuY8ftIvhUrFPPAZL6yiZ4JWifa9zErAMpBGQSOD3qZyUIuT6DSu7HT0V59/wjNp/z/wCuf+Dq7/8AjtH/AAjNp/z/AOuf+Dq7/wDjteB/rLhP5Zfcv8zo+qz8j0GivPv+EZtP+f8A1z/wdXf/AMdo/wCEZtP+f/XP/B1d/wDx2j/WXCfyy+5f5h9Vn5HoNFeff8Izaf8AP/rn/g6u/wD47R/wjNp/z/65/wCDq7/+O0f6y4T+WX3L/MPqs/I9Borz7/hGbT/n/wBc/wDB1d//AB2j/hGbT/n/ANc/8HV3/wDHaP8AWXCfyy+5f5h9Vn5HoNFeff8ACM2n/P8A65/4Orv/AOO0f8Izaf8AP/rn/g6u/wD47R/rLhP5Zfcv8w+qz8j0GivPv+EZtP8An/1z/wAHV3/8do/4Rm0/5/8AXP8AwdXf/wAdo/1lwn8svuX+YfVZ+R6DRXn3/CM2n/P/AK5/4Orv/wCO0f8ACM2n/P8A65/4Orv/AOO0f6y4T+WX3L/MPqs/I9Borz7/AIRm0/5/9c/8HV3/APHa8Z1vVtZs9e1G1g1/W1hhupY0X+1JzhQxAGS/oK9PK8fSzKcoUU04q+v/AAGyJ0JR3Pqeivkn+39e/wChi1v/AMGc/wD8XR/b+vf9DFrf/gzn/wDi69r6lU7ojkZ9bUV8k/2/r3/Qxa3/AODOf/4uj+39e/6GLW//AAZz/wDxdH1Kp3QcjPraivkn+39e/wChi1v/AMGc/wD8XR/b+vf9DFrf/gzn/wDi6PqVTug5GfW1FfJP9v69/wBDFrf/AIM5/wD4uj+39e/6GLW//BnP/wDF0fUqndByM+tqK+Sf7f17/oYtb/8ABnP/APF0f2/r3/Qxa3/4M5//AIuj6lU7oORn1tRXyT/b+vf9DFrf/gzn/wDi6P7f17/oYtb/APBnP/8AF0fUqndByM+tqK+Sf7f17/oYtb/8Gc//AMXR/b+vf9DFrf8A4M5//i6PqVTug5GfW1FfIN54j8QxRBk8R62Dux/yEp//AIqqX/CV+Jf+hl1v/wAGM3/xVS8HNdUaRw8pK6PsuivjT/hK/Ev/AEMut/8Agxm/+Ko/4SvxL/0Mut/+DGb/AOKo+qT7or6rPuj7Lor40/4SvxL/ANDLrf8A4MZv/iqP+Er8S/8AQy63/wCDGb/4qj6pPug+qz7o+y6K+NP+Er8S/wDQy63/AODGb/4qj/hK/Ev/AEMut/8Agxm/+Ko+qT7oPqs+6PsuivjT/hK/Ev8A0Mut/wDgxm/+Ko/4SvxL/wBDLrf/AIMZv/iqPqk+6D6rPuj7Lor40/4SvxL/ANDLrf8A4MZv/iqP+Er8S/8AQy63/wCDGb/4qj6pPug+qz7o+y6K+NP+Er8S/wDQy63/AODGb/4qj/hK/Ev/AEMut/8Agxm/+Ko+qT7oPqs+6PsuivjT/hK/Ev8A0Mut/wDgxm/+Kpk3izxMsLkeJdbyFJ/5CM3/AMVSeFmle6E8NNK59nUU1P8AVr9BTq5jnCikc4RiPSvKfDOkR6l4V0i+u9T1yS5uLOKWV/7Zul3MyAk4EmBye1cGPzClgoqVVN37f8OjSnTc3ZHq9Fee/wDCN2n/AD/65/4Orv8A+OVb8HxPZeLNasEu76a2SytJlS6vJbja7PcBiDIxIyEXp6Vz4LOsPi6vsqaafnb/ADKnRlBXZ29FFFeuYhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVy/xA/wCRXj/7CVh/6VxV1Fcv8QP+RXj/AOwlYf8ApXFWVf8AhS9H+Q47oKKKK/Kj1wooooAKKKKACiiigAooooAKKKKACiiigAr528Sf8jTq/wD1+zf+hmvomvnbxJ/yNOr/APX7N/6Ga+14K/j1fRfmYV9kZdFFFfohzBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAFTUP9Qv+9/Q1nVo6h/qF/3v6Gs6oluddH4QooopGoUUUUAFFFFABRRRQAUUUUAFFFFABUc//HvJ/un+VSVHP/x7yf7p/lUy+Fky+Fn3Gn+rX6CnU1P9Wv0FOrxjyRr/AOrb6GvN/Brf8UPoP/YPg/8ARa16Q/8Aq2+hrzLwc3/FE6F/2D4P/Ra18xxP/Bp+v6G9B2bOg3VD4YOfHeu/9g2x/wDRlzS7qZ4VOfHWu/8AYOsv/RlzXkcOr/bV6M0rSvE7eiiivvjkCiiigAooooAKKKKACiiigAooooAKKKKACiiigArl/iB/yK8f/YSsP/SuKuorl/iB/wAivH/2ErD/ANK4qyr/AMKXo/yHHdBRRRX5UeuFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFfO3iT/kadX/6/Zv/AEM19E187eJP+Rp1f/r9m/8AQzX2vBX8er6L8zCvsjLooor9EOYKKKKACiiigAooooAKKKKACiiigAooooAqah/qF/3v6Gs6tHUP9Qv+9/Q1nVEtzro/CFFFFI1CiiigAooooAKKKKACiiigAooooAKjn/495P8AdP8AKpKjn/495P8AdP8AKpl8LJl8LPuNP9Wv0FOpqf6tfoKdXjHkjX/1bfQ15d4Pb/iitC/7B8H/AKLFeov/AKtvoa8p8IN/xReh/wDXhB/6AK+b4kV6UPX9Coysb+6jwkc+Odd/7B1l/wCjLmot3vVLRNf0fRPG+sHVtVsrDztPs/L+1TrFvxJcZxuIzjI/OvLyCNsYvRg5XR6XRVC//tC6sY30a8sopGIYS3EDTxshHYK6deOc/hXF2Xi/xFPEbf8A4ldxdXeryabp9wlvJHEViRmmlZTIxYAo6gBhkjrzX3BJ6HRWD4c1i9v59U07VEgXUNNnWKR7cERyqyK6OoJJXIbBBJwQea3qACiiigAooooAKKKKACiiigAooooAKKKKACuX+IH/ACK8f/YSsP8A0rirqK5f4gf8ivH/ANhKw/8ASuKsq/8ACl6P8hx3QUUUV+VHrhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXzt4k/5GnV/wDr9m/9DNfRNfO3iT/kadX/AOv2b/0M19rwV/Hq+i/Mwr7Iy6KKK/RDmCiiigAooooAKKKKACiiigAooooAKKKKAKmof6hf97+hrOrR1D/UL/vf0NZ1RLc66PwhRRRSNQooooAKKKKACiiigAooooAKKKKACo5/+PeT/dP8qkqOf/j3k/3T/Kpl8LJl8LPuNP8AVr9BTqan+rX6CnV4x5I1/wDVt9DXkvhFv+KN0T/rwg/9AFetP/q2+hryHwk3/FHaJ/14w/8AoArwc+jenD1M6krI3d1TeDgG8ba7kA/8S+y6j/ppc1V3VZ8FnPjXXv8AsH2X/oy5rzsmhbFJ+TJpyuzs9US+fSbtNMaFb5oWW3aYkIshHylsAnAOO1c5N4QmsdC8PW+jSwi+0N1khNxkJOTGySByASNwdjkA4Pauuor682MHw5o97Yz6pqOqPbtqGpTrLIlsSY4lVFREUkAtgLkkgZJPFb1FFABRRRQAUUUUAFFFFAHO+OtWudC8HX2pWk3kzQGI+YED4BlUNwQc8E9qhHjrT4jdJf2Wo6fcQxJKlvcwjzLhXcIvlhWbJLlV2nBBYZAzVvxlot14h8KXul2M0UNzP5eySXO1Ssitk4B7LXNa14H1fxZPNd62+mRTQ26Q2cMO+aJyJklYyhguVYxqu0ZwCeTQBtTeOrKzsNTudQ07UbKXTrYXUtrPGnmPESQGTa5VhkEfe4744pw8YWs/2+3ktNT0+aGxe9jM0KBpYRwXjGSMg4+VwDyMisKXwLc3HhvW7CDQ/DekXN9aG3jewLHcSc/O3lqQvA4ANbmueHLzU9dkvoZIFibRbrTwHYhvMlaMqeB935Dnv04NAB/wmNtDHp8EFnqmpXE9jHeOIIULxwsOHkGVGSQflXJJBwOKiT4gadPZ6LPaWGpXTazHLJaQxRJvIjxuDZYBeuQSccckVhX5l8D3djdf2ro8E02kwWNxFfSugLQZw8W1SXPzsNnBPHIqx4L8N6hFpfgu9uAsX9n2Nws8UoKyZm2FflxwRtOQSMUAdhoms22vacLy2SaMCR4pIpl2yRSIxVkYZPIIPQmuV8eeItEl05NJj1iwfUhqdiptFuEMoIuoiRszngAnpXQ+G9IuNHi1JLh4mN1qNxdp5ZJwkj5AOQOfX+dUPiAo/wCEZjOBn+0rDnH/AE9xVlX/AIUvR/kOO6Fooor8qPXCiiigAooooAoarBLJB5yarcafHCrPI0KRtkYzzvRumD0xXJpq+rw6Posl9qVxEt+0sjzR2ySTqvWJRGqHPy8sQhwfSus1rTTrGlTWHnmFJ9qysFySmRuUcjGRkZ7ZqDUdHmuL20vrC7S0ubWN4l3w+ZGyNtyCuR3VcEEV6WFrUYwUalt30WmjtrZ7t+drLQBvhi/uNS0RLm5lWVjJIqyABS6ByFLKPutgDI7HsOlbFZ+j6X/ZVpJG05nmmmeeaUqF3OxycAdB7VoVyYlwlWk6e19ACiiisACiiigAr528Sf8AI06v/wBfs3/oZr6Jr528Sf8AI06v/wBfs3/oZr7Xgr+PV9F+ZhX2Rl0UUV+iHMFFFFABRRRQBuaDp8d3aX0wsTqF1D5flWgZvmUk7mwpDHGBwD/FUfiTS00u/hVIzEs9uk/kltxiJyCufYg+9UbGazhdjeWss6kfKIp/LIP12mnanqDaldCUxrFGiLFFEpJEaKMAZPJ+vck1wqnWWLc7vk/DZaLXvrsvUq6sU6KKK7iQooooAKKKKAKmof6hf97+hrOrR1D/AFC/739DWdUS3Ouj8IUUUUjUKKKKACrukWP9qazY2G7Z9pnSHd/d3MBn9apVNaXUtjewXcDbZoJFkQ+jKcj9RUVFJwahvbT1A6C9ttKv9K1SewsPsb6dKm1hKz+dGzFfm3Hhs7TxgcniuZrd1DXraexuraw037H9tlWW5YzGTdtyQqjA2rkk45PTnisKufCRqRi+e610u7u1l1u+t+oBRRRXWAUUUUAFRz/8e8n+6f5VJUc//HvJ/un+VTL4WTL4Wfcaf6tfoKdTU/1a/QU6vGPJGv8A6tvoa8d8KN/xR+i/9eMP/oAr2J/9W30NeMeFW/4pHRv+vGH/ANAFePnEbwj6nNiXZI3d1XfBBz4017/rwsv/AEO5rM3Vo+BTnxlr3/XhZf8AodzXFlcLYi/kzHDyvM9Booor6U7wooooAKKKKACiiigAooooAKKKKACiiigAooooAK5f4gf8ivH/ANhKw/8ASuKuorl/iB/yK8f/AGErD/0rirKv/Cl6P8hx3QUUUV+VHrhRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXzt4k/wCRp1f/AK/Zv/QzX0TXzt4k/wCRp1f/AK/Zv/QzX2vBX8er6L8zCvsjLooor9EOYKKKKACiiigAooooAKKKKACiiigAooooAqah/qF/3v6Gs6tHUP8AUL/vf0NZ1RLc66PwhRRRSNQooooAKKKKACiiigAooooAKKKKACo5/wDj3k/3T/KpKjn/AOPeT/dP8qmXwsmXws+40/1a/QU6mp/q1+gp1eMeSNf/AFbfQ14p4Wb/AIpLR/8Aryh/9AFe1v8A6tvoa8Q8Lt/xSej/APXlD/6AK83Mo3hE4cc7RRt7q0/ARz4x1/8A68bL/wBDuaxt1TeFNf0fRPF+tHVtVsrDzrG08v7VOse/D3GcbiM4yPzrlwELVrnPg5Xqnq1Fc54t8VQ+HNDt72NoHe8njt7Z5GPl7nBIYlckgKGOBycADrWZH4xuYvC15f8A2mx1K+S5itIYYbaW02yysqIsiSFnXlwc8ZHQV7h6x21Fc5o2r6qPENzoWtize5S1S7hns0ZEdCxVlKszEFSBzk5DDpXR0AFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFcv8QP+RXj/wCwlYf+lcVdRXL/ABA/5FeP/sJWH/pXFWVf+FL0f5Djugooor8qPXCiiigAooooAKKKKACiiigAooooAKKKKACvnbxJ/wAjTq//AF+zf+hmvomvnbxJ/wAjTq//AF+zf+hmvteCv49X0X5mFfZGXRRRX6IcwUUUUAFFFFABRRRQAUUUUAFFFFABRRRQBU1D/UL/AL39DWdWjqH+oX/e/oazqiW510fhCiiikahRRRQAUUUUAFFFFABRRRQAUUUUAFRz/wDHvJ/un+VSVHP/AMe8n+6f5VMvhZMvhZ9xp/q1+gp1NT/Vr9BTq8Y8ka/+rb6GvC/DLf8AFK6R/wBecP8A6AK90f8A1bfQ14P4ab/iltJ/684v/QBXHjFeKPNzJ2hE2d1bPw+Abxdr+QD/AKDZdf8AfuKwd1bvw6OfFuv/APXlZf8AodxWGFjaocuAlesdX4q0KbXLGyNo8KXun3sV9beeCY2dM/K2OQCGYZHTOecViz+D9U1S21m7vrizttVvpbWWBbctJFA1swePJIUtls5OBwcDpXcUV6Z7hzmjaRqp8Q3Ou62bNLl7VLSGCzdnREDFmYsyqSWJHGBgKOtdHRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAVy/xA/5FeP/ALCVh/6VxV1Fcv8AED/kV4/+wlYf+lcVZV/4UvR/kOO6Ciiivyo9cKKKKACiiigAooooAKKKKACiiigAooooAK+dvEn/ACNOr/8AX7N/6Ga+ia+dvEn/ACNOr/8AX7N/6Ga+14K/j1fRfmYV9kZdFFFfohzBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAFTUP9Qv8Avf0NZ1aOof6hf97+hrOqJbnXR+EKKKKRqFFFFABRRRQAUUUUAFFFFABRRRQAVHP/AMe8n+6f5VJUc/8Ax7yf7p/lUy+Fky+Fn3Gn+rX6CnU1P9Wv0FOrxjyRr/6tvoa8C8Nt/wAUvpX/AF5xf+gCvfX/ANW30NfP3hxv+KZ0r/r0i/8AQBWFdXSPKzV2hH1NjdXQfDc58V+IP+vKy/8AQ7iua3V0fw0OfFXiD/rzs/8A0O4rOjG0jjy13r/JnptFFFdZ9CFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXG/FK8/s7wHcXvl+Z9nu7ObZnG7bcxHGe3Suyrg/jL/yS7VP+utt/wClEdHKp+7LZjW55/8A8Lm/6gH/AJOf/YUf8Lm/6gH/AJOf/YV5XRR/qzlX/Pr/AMml/mehzyPVP+Fzf9QD/wAnP/sKP+Fzf9QD/wAnP/sK8roo/wBWcq/59f8Ak0v8w55Hqn/C5v8AqAf+Tn/2FH/C5v8AqAf+Tn/2FeV0Uf6s5V/z6/8AJpf5hzyPVP8Ahc3/AFAP/Jz/AOwo/wCFzf8AUA/8nP8A7CvK6KP9Wcq/59f+TS/zDnkeqf8AC5v+oB/5Of8A2FH/AAub/qAf+Tn/ANhXldFH+rOVf8+v/Jpf5hzyPVP+Fzf9QD/yc/8AsKP+Fzf9QD/yc/8AsK8roo/1Zyr/AJ9f+TS/zDnkeqf8Lm/6gH/k5/8AYUf8Lm/6gH/k5/8AYV5XRR/qzlX/AD6/8ml/mHPI9U/4XN/1AP8Ayc/+wrlLuy/te9n1LzPK+2SNceXjds3ndjPGcZ64rlq7Sx/48Lb/AK5L/IV04bK8JgG5YaHK3vq3+bZ5Wa4mrShFwdtTO/sL/p5/8c/+vR/YX/Tz/wCOf/XrYors9pLueJ/aOJ/m/Bf5GP8A2F/08/8Ajn/16P7C/wCnn/xz/wCvWxRR7SXcP7RxP834L/Ix/wCwv+nn/wAc/wDr0f2F/wBPP/jn/wBetiij2ku4f2jif5vwX+Rj/wBhf9PP/jn/ANej+wv+nn/xz/69bFFHtJdw/tHE/wA34L/Ix/7C/wCnn/xz/wCvR/YX/Tz/AOOf/XrYoo9pLuH9o4n+b8F/kY/9hf8ATz/45/8AXo/sL/p5/wDHP/r1sUUe0l3D+0cT/N+C/wAjH/sL/p5/8c/+vR/YX/Tz/wCOf/XrYoo9pLuH9o4n+b8F/kcprmmfZLJJPO35kC4247H3rA2+9df4o/5Bkf8A12H/AKC1clWkW2rs+lyutOrh1Kbu7sbt96NvvTqKo9G43b70bfenUUBcbt96NvvTqKAuN2+9G33p1FAXG7fejb706igLjdvvRt96dRQFxu33qO4XFtLz/Cf5VNUVx/x7S/7h/lSl8LJk9GfcCf6tfoKdTU/1a/QU6vFPKGv/AKtvoa+evDzf8U1pf/XpF/6CK+hX/wBW30NfO3h9v+Kb0z/r1i/9BFRNXPIzd+5H1NbdXTfDE58U+IP+vOz/APQ7iuU3VseBNctdH8T62bqK+k820tNv2WxmuMYefOfLVtvXvjPPpUwjZnDlb/2j5M9iorm/F1xrP9h20ugfbBPJcw+Z9mijMwhJ+fCzDaDj+93rAj8RX1xDYaLY6tqA1S71NrW5m1K1hW4s1WEzMAiKIySqjacMPnzk4xWp9Keh0VznhjUL+S+1rR9Suftc+mXCIl0Y1RpY5I1ddwUAbhkg4ABwDiujoAKKKKACiiigAooooAKKKKACiiigAooooAK4P4y/8ku1T/rrbf8ApRHXeVwfxl/5Jdqn/XW2/wDSiOqj8SGtz5rooor2zuCiiigAooooAKKKKACiiigAooooAKKKKACu0sf+PC2/65L/ACFcXXaWP/Hhbf8AXJf5Csqux4udfw4+pPRRRWJ88FFFFABRRRQAUUUUAFFFFABRRRQAUUUUAYnij/kGR/8AXYf+gtXJV1vij/kGR/8AXYf+gtXJVtT2Prcm/wB1XqwooorQ9UKKKKACiiigAooooAKKKKACiiigAqK4/wCPaX/cP8qlqK4/49pf9w/yqZfCxS2Z9wJ/q1+gp1NT/Vr9BTq8U8oa/wDq2+hr5x0A/wDFO6Z/16xf+givo5/9W30NfN2gn/intN/69Y//AEEU0rnjZz/Dj6mrmus+FnPibxD/ANeln/6HcVx+a6/4VHPiXxD/ANeln/6HcUNWOHKv94+TPRdUt9RuLZF0u/hsp1cMXmtvPVlwflK7lPcHII6Vzh8DTMHv21hjrzXq3q3/ANnARWWPyggiz9zyyVI3ZOc5zXY0Uj6cxtA0N9I+3XF1efbdQv5/PubgR+WpIUIqquTtUKoAGSepzzWzRRQAVyOs6z4o0kz3M0Xha205ZCsc97qksOVydu791gMR2BP4111cP8SNDvtV037RZWsF2Y7K7tvImlWPa0yBVlUt8u5SMckcO2D2IBv6FeazcyXUesR6TG8WzYun3bzEZBJ3hkXbxtI65ya2a5fwrb6hPfahrd/ax2f2yKCCK2WdZSEi3/OzLlckyHgE8KOa6igAooooAKKKKACiiigAooooAK4P4y/8ku1T/rrbf+lEdd5XB/GX/kl2qf8AXW2/9KI6qPxIa3PmuiiivbO4KKKKACiiigAooooAKKKKACiiigAooooAK7Sx/wCPC2/65L/IVxddpY/8eFt/1yX+QrKrseLnX8OPqT0UUVifPBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAGJ4o/5Bkf8A12H/AKC1clXW+KP+QZH/ANdh/wCgtXJVtT2Prcm/3VerCiiitD1QooooAKKKKACiiigAooooAKKKKACorj/j2l/3D/KpaiuP+PaX/cP8qmXwsUtmfcCf6tfoKdTU/wBWv0FOrxTyhr/6tvoa+a9CP/FP6b/17R/+givpR/8AVt9DXzRoR/4p/Tv+vaP/ANBFXBXZ4+cfw4+pp5rsfhRz4k8Q/wDXpZ/+hXFcXmuz+E/PiPxD/wBetn/6FcVU1ocOVf7x8merUUUVkfTBRRRQAV514quZtV8Qaet14L1nU9NsZJ1lgeKFoZmOAkqqZMPja2AwHD54IxXotcd47sta1KKOz0u4v7dGsruTfZSGNjcKi+QrOOQpJc9RkgA0AR+BrVoNV1yWHw9d6Dp0pgMFnKiIhYB98iqjEKT8oIHHyqckk47WuE+Hqt9s1d4JNclsHS3Mbau85dJcP5kaiXnC/LyByWIycDHd0AFFFFABRWfd6vb2Wr6dpsiSma/MgiZQNq7F3Hdznp0wDVq1me4tklkt5bZ2HMUpXcv12kj8iaAJqKKKACiioL28g06wuL26k8u3t4mmlfBO1FBJOByeAelAE9cH8Zf+SXap/wBdbb/0ojruYZo7iCOeJt0cih0bGMgjIrhvjL/yS7VP+utt/wClEdVH4kNbnzXRRRXtncFFFFABRRRQAUUVranoY0tWWbU7J7hVRjbx+aX+YAjkoF6EHrWcqsYyUXu/6/UDJooorQAooooAKKKKACu0sf8Ajwtv+uS/yFcXXaWP/Hhbf9cl/kKyq7Hi51/Dj6k9FFFYnzwUUUUAFFFKq7mC5AycZPQUgEoq9Jpcgh82CeG6XesZ8ktlWPQYIHXB6Uy6sfsi/NdW8kgba0cbElT7nGD+BNZRxFOTsnr/AF93zLdKaV2ipRRRWxAUUUUAFFFFAGJ4o/5Bkf8A12H/AKC1clXW+KP+QZH/ANdh/wCgtXJVtT2Prcm/3VerCiiitD1QooooAKKKVF3uq5AycZJwBSASitLVtGk0lLR2ura5juozJHJbszLgMVPUDuprNqadSNSPNF6AFFFFWAUUUUAFRXH/AB7S/wC4f5VLUVx/x7S/7h/lUy+Filsz7gT/AFa/QU6mp/q1+gp1eKeUNf8A1bfQ18zaGf8AiQad/wBe0f8A6CK+mX/1bfQ18x6If+JDp/8A17R/+gitqO7PIzde5H1NLNdr8Jf+Ri8Q/wDXrZ/+hXFcPmul+HOuWmj+IdcN1FfSeba2m37JYzXGMNPnPlq23r3xnn0q6q904ssX+0fJntVFUdR1a10zSH1K48wQqoKoEO92bAVAp53EkADrk4rgh4m8TWi67b3lxB/aDX1ja2ieWpjszc7RjIwX2bup6lewOK5j6Q9Lorl9EvNTsvFV74f1LUG1FVs4r23uZIkjkAZ2RkYIApwVBBAHU5ziuooAK5u68J3FzdzTr4q8QQCR2cRRTxBEyc7VBjJwOg5NdJXAfFLVLzTdIDRajc6bafZLuQ3NudpNwqAwRl8fKGO70yVAzzggHVaNo0mkef5msalqPm7cfbpEby8Z+7tVeuec56CmeLP+RN1z/sH3H/otqzvC+tf25rGrXFndm70hYrdIZlOYzMA/mhG7gDy844yTXU0AeV2fhfSI9Z8G24tQYdQ0uY36FiReFEhKmUfx4LEjNY5ubLyINDv4dJjsrW81KO1utYheeNFS5KLDGoZcuFxjnIAAAr2yigDyrwndXF5F8O5bqR5JQNQjLOCGwgZQDuJPAUDkk1Q0r+zP7G8G/wDCTeV/wj/2O6/4+P8AUfavMXZ5nbOzzNue+cc17JWfqumy6lFGkOqX2nshJ8y0KZYehDqwx+GaAPKNNs7LUND0S1CzNYyeMrkKsjMGaPZcYDZ+bkDBB5PINaN5JbaBZeLdLhsLVtJi1W0jSC4DfZrVZYoWZ2VekYYliowMnsCa9H0bR7XQtMjsLPzDGrM7PK+95HZizOzdyWJJ+tX6APDVlVvCfjvT7a5tH0+P7G8B06F4bcFzhjErM2B8o5BwSCRXQ+INAsrPUvEGj6bYIIL3wzNM9sq7hLOjkI5B6vk/e6k4r1GigDm/Av8AYH/CL2//AAjwsFgwv2gWQUATbF3bwvR8bc556Vyfxh0u8TwNqt62u6g9uZrc/YWSDyRmeMYyI9/HX736cV6hXB/GX/kl2qf9dbb/ANKI6qPxIa3PmuiiivbO4KKKKACiiigArr5rm5TR9Qj1rVrS9iaELaRJcLMwkDLhlxkoAAc5x6YrkKK56+HVZxv0d9tej0fTYaYUUUV0CCiiigAooooAK7Sx/wCPC2/65L/IVxddpY/8eFt/1yX+QrKrseLnX8OPqT0UUVifPBRRRQAU6NPMkVNyruIGWOAPrTaKTA6W2u0sIIPtklqTDcxPGtqVJYD7xbZweOmec/jUOpTlrG5W5u4LgtMptREwbYvOen3RjHB/KsCivPjl8VU9pfW99vnp28+92dTxUnHktp/W/fyCiiivROUKKKKACiiigDE8Uf8AIMj/AOuw/wDQWrkq63xR/wAgyP8A67D/ANBauSransfW5N/uq9WFFFFaHqhRRRQAUqjcwAxyccnFJRSA6jxBYGLw7ooF5p8r2kEkcyQXsUjBmmdhgKxJ4YdK5eiiscPSlShyyd9W+27v+oBRRRW4BRRRQAVFcf8AHtL/ALh/lUtRXH/HtL/uH+VTL4WKWzPuBP8AVr9BTqan+rX6CnV4p5Q1/wDVt9DXzDoh/wCJFp//AF7R/wDoIr6ef/Vt9DXy/op/4kWn/wDXvH/6CK3obs8rNVeEfU0c13Hwi/5GHxF/162f/oU9cJmu6+EP/IweIv8Ar1s//Qp60rL3Tky1Wr/I9P1HTLDWLNrPUrOC7tmILRToHUkHI4NciPhbokM+rzWUUFjJemBrZ7W2VGs2iKsCp7guisRgZx+NdzRXIfQGFougXVlql3q2qait/qNxFHBvjt/JjjiQsQqruY8lmJJJzx0xW7RRQAVz/ih3UWwTxRb6GG35E0cTef06eZ6e396ugrh/El+114gthbeHp9dg0+SW1vrdYYSI2eOGRGBkI5wwGBwctn7oyATeCtRu7nVdasZtfh1u3tBAYbi3hjRE3B8p8nBYbQTz0K9MmuyrF8O3v2iGaFfDl5osURBVLhIVWTOc7RG7dMc5x1HWtqgAooooAKKKKACiiigAooooAK4P4y/8ku1T/rrbf+lEdd5XB/GX/kl2qf8AXW2/9KI6qPxIa3PmuiiivbO4KKKKACiiigAooooAKKKKACiiigAooooAK7Sx/wCPC2/65L/IVxddpY/8eFt/1yX+QrKrseLnX8OPqT0UUVifPBRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAGJ4o/5Bkf8A12H/AKC1clXW+KP+QZH/ANdh/wCgtXJVtT2Prcm/3VerCiiitD1QooooAKKKKACiiigAooooAKKKKACorj/j2l/3D/KpaiuP+PaX/cP8qmXwsUtmfcCf6tfoKdTU/wBWv0FOrxTyhr/6tvoa+XdFP/EjsP8Ar3j/APQRX1E/+rb6GvlvRj/xJLD/AK94/wD0EV0Yfdnm5krwiaGa7v4P/wDIweIv+vaz/wDQp64LNd58Hv8AkP8AiL/r2s//AEKeta/wHJl6/ffI9coooriPdCiiigArjF8GNfeI/EF/d3ur2aXN3G9uLLUZIUkQW8KFiqN13Kw554HbFdnRQBlaNoMOief5V9qd1523P269kuNuM/d3k7evOOuB6Vq0UUAFFFFABRRRQAUUUUAFFFFABXB/GX/kl2qf9dbb/wBKI67yuD+Mv/JLtU/6623/AKUR1UfiQ1ufNdFFFe2dwUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAV2lj/x4W3/XJf5CuLrtLH/jwtv+uS/yFZVdjxc6/hx9SeiiisT54KKKKACiiigAooooAKKKKACiiigAooooAxPFH/IMj/67D/0Fq5Kut8Uf8gyP/rsP/QWrkq2p7H1uTf7qvVhRRRWh6oUUUUAFFFFABRRRQAUUUUAFFFFABUVx/wAe0v8AuH+VS1Fcf8e0v+4f5VMvhYpbM+4E/wBWv0FOpqf6tfoKdXinlDX/ANW30NfLOjn/AIklh/17x/8AoIr6mf8A1bfQ18r6Of8AiS2P/Xun/oIrpw27PPzBXii/mu/+DvOveIv+vaz/APQp689zXX/DHU7rT9d137Lot9qe+2td32V4V8vDTYz5kidc9s9D0rbEfAc2CX709vorM1e2+36M29NRUhRKYbK48mZiBnYHVgM9vvAe9edWOo6ldXsPh1r7VLKG61kwtFczk3ttAtqZdhlyT87JkMGbCkjdnpwHsnrFFcv4TluLfVfEGiS3U91Bp1zH9nluJDJIEkiV9jMeWwScE5OCK6igAooooAKKKKACiiigAooooAKKKKACiiigArg/jL/yS7VP+utt/wClEdd5XB/GX/kl2qf9dbb/ANKI6qPxIa3Pmuik3D1FG4eor2zuFopNw9RRuHqKAFopNw9RRuHqKAFopNw9RRuHqKAFopNw9RRuHqKAFopNw9RRuHqKAFopNw9RRuHqKAFrtLH/AI8Lb/rkv8hXFbh6iuts760Wyt1a6gDCNQQZBkcVlV2PHziEpQjZX1L9FV/t9n/z9wf9/B/jR9vs/wDn7g/7+D/GsbM+f9lU/lf3Fiiq/wBvs/8An7g/7+D/ABo+32f/AD9wf9/B/jRZh7Kp/K/uLFFV/t9n/wA/cH/fwf40fb7P/n7g/wC/g/xosw9lU/lf3Fiiq/2+z/5+4P8Av4P8aPt9n/z9wf8Afwf40WYeyqfyv7ixRVf7fZ/8/cH/AH8H+NH2+z/5+4P+/g/xosw9lU/lf3Fiiq/2+z/5+4P+/g/xo+32f/P3B/38H+NFmHsqn8r+4sUVX+32f/P3B/38H+NH2+z/AOfuD/v4P8aLMPZVP5X9xmeKP+QZH/12H/oLVyVdV4glju7COO2kSZxKGKxtuIGDzgVzf2S5/wCfeX/vg1vDY+qyl8mGSlo7shoqb7Jc/wDPvL/3waPslz/z7y/98GrPT549yGipvslz/wA+8v8A3waPslz/AM+8v/fBoDnj3IaKm+yXP/PvL/3waPslz/z7y/8AfBoDnj3IaKm+yXP/AD7y/wDfBo+yXP8Az7y/98GgOePchoqb7Jc/8+8v/fBo+yXP/PvL/wB8GgOePchoqb7Jc/8APvL/AN8Gj7Jc/wDPvL/3waA549yGorj/AI9pf9w/yq39kuf+feX/AL4NRXVrcLaTM0EoAQkkoeOKmXwsmU42ep9tJ/q1+gp1NT/Vr9BTq8U80a/+rb6GvlXSP+QLY/8AXBP/AEEV9VP/AKtvoa+U9IP/ABJrL/rgn/oIrqwvxM4sarxRezXoXwa/5DviL/r2s/8A0KevO816H8Gf+Q74i/697P8A9CnrbE/wznwitUPUtU0+TUbZYotRvLB1cOJrRkDdCMHerKRz0I7CsU+BdOa2lEl5qD38lyl2dSaVftCyou1WB27QApK7du3BPHNdPRXnnqmZomh2+hwTrFNcXE9zMZ7i5uWDSTOQBliABwFAAAAAHStOiigAooooAKKKKACiiigAooooAKKKKACiiigArgvjN/ySzVf+ult/6UR13tcF8Zv+SWar/wBdLb/0ojqo/Ehx3PmWiiivaPSCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA0NH/4+3/65n+YrbrE0f/j7f/rmf5itug8bG/xQooooOQKKKKACiiigAooooAKKKKACiiigAqpqn/IJvP8Arg/8jVuqmqf8gm8/64P/ACNKfwscdz61T/Vr9BTqan+rX6CnV4h6A1/9W30NfKGkn/iT2X/XBP8A0EV9Xv8A6tvoa+TtKP8AxJ7L/rgn/oIrrwnxM5cUrxRezXovwX/5DniP/r3s/wD0KevOM16N8Fv+Q34j/wCvez/9CnrfFfwzHDK0z2GiiivNPQCiiigAooooAKKKKACiiigAooooAKKKKACiiigArgvjN/ySzVf+ult/6UR13tcF8Zv+SWar/wBdLb/0ojqo/Ehx3PmWiiivaPSCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA0NH/4+3/65n+YrbrE0f/j7f/rmf5itug8bG/xQooooOQKKKKACiiigAooooAKKKKACiiigAqpqn/IJvP8Arg/8jVuqmqf8gm8/64P/ACNKfwscdz61T/Vr9BTqan+rX6CnV4h6A1/9W30NfJmlH/iUWf8A1wT/ANBFfWb/AOrb6GvknSz/AMSmz/64p/IV2YP4mYV1dIvZr0j4Kc614j/697T/ANCnrzTNdz8KJ9Zh1nXv7IsLG6zBa+b9qvHg2/NNjG2N89/TGB1zxviv4ZlRVpnulFY+v22kXOhmXxLFb/YrcCeZZWJiUgEc9Nw5OARzxxnFcLLaXNh4JugsU+maVq2tWqQ2m4q1pZySRRuP+me/5jtH3fMxwc15h2HqVFcZoVja6F8QNR0jSoVt9OfTYLp7aPiOOUySJuA6KWVRnHXbmuzoAKKKKACiiigAooooAKKKKACiiigAooooAK4L4zf8ks1X/rpbf+lEdd7XBfGb/klmq/8AXS2/9KI6qPxIcdz5looor2j0gooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKANDR/+Pt/+uZ/mK26xNH/4+3/65n+YrboPGxv8UKKKKDkCiiigAooooAKKKKACiiigAooooAKqap/yCbz/AK4P/I1bqpqn/IJvP+uD/wAjSn8LHHc+tU/1a/QU6mp/q1+gp1eIegNf/Vt9DXyPph/4lVn/ANcU/kK+uH/1bfQ18iaYf+JVaf8AXFP5Cu3BfEzOorovZr0v4I86z4j/AOuFp/6FPXmGa9O+CH/IY8R/9cLT/wBCnrfF/wAMimrM9S1zw/pviOzitdUhkliimWdBHPJCVkXO1tyMDxn164PYVHF4Z0qLS7rTXiuLmzuuJY7y7lud30MjMR+BHPPWteivLNzM0jQNM0JZ/wCz4GRpyGlklmeWR8DAy7ksQB0GcDtWnRRQAUUUUAFFFFABRRRQAUVz+v8AiG70rVtK0yx0sX1zqPnbN1x5Sx+WobLHaeOeoGfY5rLtvHN3qEsOn2GiCTWt9wtzay3YSKAQuEZjKEOQSy7cLznnGKAO0orjG8dzTRaOllorzXuoXNxZvbSXAj+zzQht4ZsEFQVPI7cgE8VBeePNTsm1oyeHEeHQxE1/Il90DQpK/lgoN5XceDtyADnJwADuqK5vTfE13da3/Zl7pP2N5rNr20IuA5kjVlUhxgbHG9OAWHPXiqeieOo9T8RpolwmnLcSxPJGbHUku8bCNyyAKpRsHI6g4PPFAHYVwXxm/wCSWar/ANdLb/0ojrY+H11cXvgHRrm6nlnnktwXllcszHJ5JPJrlPjFql4/gTVrJtC1BLcTW4+3M8HknE0ZzgSb+en3f05qo/Ehx3PniiiivaPSCiiigAooooAKKK7C01CTU/DOpwzajcX1wlrv+y3CYjgCuuXjbJyQO2F6nr0PPiKzopNK6bS9L/J/jYDj6KKK6ACiiigAooooAKKKKACiiigAooooAKKKKACitrw/qr2MxifWLzTrZiGY20e/ceOGG4cY+v0qPxPEYfE2ooYI4P37MI4jlVB5GOB2I7D6CudV37d0mul7/d5efRvzsBk0UUV0AFFFFABRRRQBoaP/AMfb/wDXM/zFbdYmj/8AH2//AFzP8xW3QeNjf4oUUUUHIFFFFABRRXQaDeXkKLLNcMmk2x/fRkDbLnny8fxMffoOe1YYmrKlTc4q/le33aPV9EXCKk7M5+it3w9dzLJe2yOUgktLhmjHQnymxWFThVcqkoNWtb8b/wCXmJxSSYUUUVsSFFFFABVTVP8AkE3n/XB/5GrdVNU/5BN5/wBcH/kaU/hY47n1qn+rX6CnU1P9Wv0FOrxD0Br/AOrb6GvkHTT/AMSu0/64p/IV9fP/AKtvoa+PtOP/ABLLX/rkv8hXbgviYmrl3NeofA7nV/En/XC0/wDQp68s3V6j8DDnVvEn/XC0/wDQp66MX/CElY9ooooryigooooAKKKKACiiigAooooAyr7RvtviHSdV+0bP7PWdfK2Z8zzFUdc8Y2+hzWEvge6s9Um1bS9ZW21GS5uZC8lp5kZimKsY2TeCcFAQwI78V2VFAHLWHgxLCfRZhfvLLYXFzdTu8Yzcyzht7cHC8uTjB4AHvTr7wh9ttPFkH27Z/wAJAu3d5Ofs/wC4WH+9833d3brj3rp6KAOe1Dwqmo6lHcyXbpGNKuNNZEXDESmMlw2eCNnTB6+1Z2keCLyw1bR7261iGdNKgkt4YILAQKysoXJw5+b5Rk9PQDnPZUUAZXhrRv8AhHvDlhpH2j7R9kiEfm7Nm73xk4/OuX+M3/JLNV/66W3/AKUR13tcF8Zv+SWar/10tv8A0ojqo/Ehx3PmWiiivaPSCiiigAooooAK1LnxDqd1bSW8k8axy4EnlQRxmTnPzFVBbn1rLoqJ0oTacknbbyAKKKKsAooooAKKKKACiiigAooooAKKKKACiiigDQsdavdOhMVs0IQtvHmW8chDccgspI6DpVO4uJrq4kuLiRpZpGLO7nJYnuTUdFRGlCMnNJXfUAoooqwCiiigAooooA0NH/4+3/65n+YrbrE0f/j7f/rmf5itug8bG/xQooooOQKKKKACtGHW76CzitFaBoIiSiyW0cmCTk8spNZ1FRUpU6iSqRTt3VxqTjsy9Zaveaf5htmiUyZ3FoI24IwR8ynAx2HFVJpXnmeV9u5zk7VCj8AOBTKKI0qcZOcYpN9bag5NqzYUUUVYgooooAKqap/yCbz/AK4P/I1bqpqn/IJvP+uD/wAjSn8LHHc+tU/1a/QU6mp/q1+gp1eIegNf/Vt9DXx3p5/4l1r/ANcl/lX2I/8Aq2+hr43sD/xLrb/rkv8AKu3BfEyoq5c3V6r8CjnVfEn/AFxtP5z15PmvRfg7PrMWqa//AGRYWN3mG1837XePBt5mxjbG+e/pjA6546MZ/CHJWR75RVa4tI9R057W/hVo5k2zRhiQfUZ4JH5V5lCi6f8ADbVLKzza2jeJJbJzCSnlW73/AJbAEdBsJHtmvKIPVqK4zRbC00H4hXmk6TCttp8ulxXUltFxGkvmsgYL0BZRzjrsrs6ACiiigAooooAKKKKACiiigAooooAKKKKACuC+M3/JLNV/66W3/pRHXe1wXxm/5JZqv/XS2/8ASiOqj8SHHc+ZaKKK9o9IKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigDQ0f8A4+3/AOuZ/mK26xNH/wCPt/8Armf5itug8bG/xQooooOQKKKKACiiigAooooAKKKKACiiigAqpqn/ACCbz/rg/wDI1bqpqn/IJvP+uD/yNKfwscdz61T/AFa/QU6mp/q1+gp1eIegNf8A1bfQ18aWLf6Bb/8AXNf5V9lv/q2+hr4vsj/oNv8A9c1/lXbgviZrSV2XN1etfAU51PxJ/wBcbT+c1eQbq9d+ARzqXiX/AK5Wn85q6MX/AAyqitE9ou7WO9tJbabzPKlUo3lyNG2D6MpBB9wQaw7HwN4e062vLaG0me3vVZbiG4vJp0fccsdsjsAxPO4c5710VFeUYGZo/h7TNC886fbsjzkGWWWZ5ZHwMKC7ksQOcDOBnitOiigAooooAKKKKACiiigAooooAKKKKACiiigArgvjN/ySzVf+ult/6UR13tcF8Zv+SWar/wBdLb/0ojqo/Ehx3PmWiiivaPSCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooA0NH/4+3/65n+YrbrE0f/j7f/rmf5itug8bG/xQooooOQKKKKACiiigAooooAKKKKACiiigAqpqn/IJvP8Arg/8jVuqmqf8gm8/64P/ACNKfwscdz61T/Vr9BTqan+rX6CnV4h6A1/9W30NfFdm3+hQf9c1/lX2o/8Aq2+hr4mtW/0SH/cH8q7cF8TN6Cu2W91ewfAA51DxL/1ytP5zV41ur2P9n05v/Ev/AFztP5zVvi/4ZrWVoHuVFFFeWcYUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFcF8Zv8Aklmq/wDXS2/9KI672uf8beGm8XeFLvREuxaNcNG3nGPzNuyRX+7kZztx1pxdmmNbnyRRXsv/AAz5df8AQ1Q/+C0//HaP+GfLr/oaof8AwWn/AOO16X1umdnt4HjVFey/8M+XX/Q1Q/8AgtP/AMdo/wCGfLr/AKGqH/wWn/47R9bph7eB41RXsv8Awz5df9DVD/4LT/8AHaP+GfLr/oaof/Baf/jtH1umHt4HjVFey/8ADPl1/wBDVD/4LT/8drNh+CN1N4jvdI/4SSEfZrWC583+zz83mNKu3Hm8Y8rrnnd7cn1umHt4HllFey/8M+XX/Q1Q/wDgtP8A8do/4Z8uv+hqh/8ABaf/AI7R9bph7eB41RXsv/DPl1/0NUP/AILT/wDHaP8Ahny6/wChqh/8Fp/+O0fW6Ye3geNUV7L/AMM+XX/Q1Q/+C0//AB2j/hny6/6GqH/wWn/47R9bph7eB41RXsv/AAz5df8AQ1Q/+C0//HaP+GfLr/oaof8AwWn/AOO0fW6Ye3geNUV7L/wz5df9DVD/AOC0/wDx2j/hny6/6GqH/wAFp/8AjtH1umHt4HjVFey/8M+XX/Q1Q/8AgtP/AMdo/wCGfLr/AKGqH/wWn/47R9bph7eB41RXsv8Awz5df9DVD/4LT/8AHaP+GfLr/oaof/Baf/jtH1umHt4HjVFep638EbrRrCK6/wCEkhm33Vvbbf7PK482ZIt2fNPTfnHfGOK0v+GfLr/oaof/AAWn/wCO0fW6Ye3geNUV7L/wz5df9DVD/wCC0/8Ax2j/AIZ8uv8Aoaof/Baf/jtH1umHt4HjVFey/wDDPl1/0NUP/gtP/wAdo/4Z8uv+hqh/8Fp/+O0fW6Ye3geNUV7L/wAM+XX/AENUP/gtP/x2j/hny6/6GqH/AMFp/wDjtH1umHt4HlWj/wDH2/8A1zP8xW3Xf23wFvbWQuniqAkjHzaaf/j1Wv8AhSep/wDQ0Wv/AILG/wDj1H1umediYupU5onm1Fek/wDCk9T/AOhotf8AwWN/8eo/4Unqf/Q0Wv8A4LG/+PUfW6Zz+xmebUV6T/wpPU/+hotf/BY3/wAeo/4Unqf/AENFr/4LG/8Aj1H1umHsZnm1Fek/8KT1P/oaLX/wWN/8eo/4Unqf/Q0Wv/gsb/49R9bph7GZ5tRXcab8KdS1G/1e1/4SK1j/ALOultt39nMfMzDHLux5vH+sxjnpnvWj/wAKT1P/AKGi1/8ABY3/AMeo+t0w9jM82or0n/hSep/9DRa/+Cxv/j1H/Ck9T/6Gi1/8Fjf/AB6j63TD2MzzaivSf+FJ6n/0NFr/AOCxv/j1H/Ck9T/6Gi1/8Fjf/HqPrdMPYzPNqqap/wAgm8/64P8AyNeqf8KT1P8A6Gi1/wDBY3/x6o7j4G6jcW0sLeKLbbIhU40xs4Ix/wA9qUsVTaaGqMrnsqf6tfoKdSKNqgE5wMUteadY1/8AVt9DXxDbN/o0X+4P5V9vkZUj1FeEr+zpOihV8Vx7QMDOnHP/AKNrow9WNNtyN6E4wb5jxrdXtH7PJze+Jf8Arnafzmpv/DO1z/0NcX/gtP8A8drp/Bvwx13wPJfPpfiXT5WvBGJPtOlu2Nm7GNs4/vn9K1r14ThZF1qsJRsj013SONndgqKCWZjgADuarafqunatC02m39rexK21ntplkUH0JUnmud+IYceA7kTsGjEtt9sZVwph86PzTjJwuzdnnpmo7D7L/wALRuv7N8nyP7Gj+1eRjbv80+VnHGdu/HfGO2K4jlOxooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACmiNBK0gRRIwClsckDOBn8T+Zp1FABRXO+J/EbaRcadpln5P8Aampy+XbfaQ4hGOWJYDkgdFyCcim6H4juLjUpNE1y2js9ZiXeFiYmK4j/AOekRPJHqDyO9AHSUUUUAFFFFABRRRQAUUUUAFFFFABRRRQA140lULIiuoIYBhnkHIP4EA06iigAoqpqWoWemWbT319BZQ52iaZ1RQT05bjNcT4W8RajY6lcWvjDVIhNNEr2MylFtZoVHLq4/wCWhJywJx0wMckA9BoqG1uoL6zhu7aVZbeeNZIpF6MrDII+oNTUAFFFFABRRRQAUUUUAFFFFABRRRQA1Y0RnZEVWc7nIGNxwBk+vAA/CnUVwmrapFda8b/wtrMN5q1mhjudK+0ZW5iDHIUZwJAc8j6HtgA7uis3QtdsvEOmre2TkrkrJG4w8TjqrDqCPStKgAooooAKKKKACiiigAooooAKKKKAGuiSRtHIqsjAhlYZBB7Gq2n6Vp2kwtDptha2UTNuZLaFY1J9SFA5q3RQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABXL+IvEk9n4Z1OeyRYtWtoDN9lfEskUZcr5hRScjaC2PbFS+M/EMnh7SYpIlZHuZkt1u2jDw2pYgeZJ8w+UZ/PrxXL6jYa2detre8lU6vhm0rW7aArHNgFmguEGQowCQehHoeoBnaylvoywx6jqk2ueG9ZZro3O8GWxkGD58bL0Qbhz2z3Br03SrKe0061ivbsX13ChQ3ZiCFwT6ZOOgzzziuel+H+mTWoSG1s9Na6AGpfYoADcL95o1Y8ohYDOBkgduo7AAAADoKACiiigAooooAKKKKACiiigAooooAKKKKACqWq6tZ6LYPe3shSJSFAVSzOxOFVVHLMTwAKk1C+g0zTri+umdbe3jMkjIjOQoGScKCTXCSeKr6fTLTWdXsLBdBu/3trfW7tI1gxyI3lBA4wR8y/dOQeDmgCrqutQ6zrcWs2Ykv7fR90eo6HdQBZoQykGVVIzkAkH2rodF8K6cUeSMxXfh+7Vbm1sLq33CCRuSy7vugg/dx3P45PhLwTc22o6fqWpW9rbS6dbmKKSyuXY3jucvNKcDIPB2ndySc9K9DoAKKKKACiiigAooooAKKKKACiiigAoorivEWrX/iBta8OeGZoUvrS1zPNIxADscCLoCNyhvnB+UgcHnABZ1zxYLSa8tk0i8vtPt41F9d2sikwhweiA7mwvJx0HTNcfP4dm1rUYo9LtbhLZGtzour2sq/Z7O1VVZioDDLswIIIOcjkAVr+F9PtmuIdS8JRRaWySLa61o04KquOCcDO2RR0I4cY9jXd6fptlpVsbewto7eEyNIUjGBuYksce5JoAfa2cNor+XGgklYPNIqBTK+ANzYHJwBU9FFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQBDdXUFjaTXd1KsVvChkkkY4CqBkk1z2ueNtF0y3eMaiq3D23nRyLE8kcYYHYzsoIQEg8tjoa6YgMpVgCCMEHvXBS6FqHg/VJ5fD+lrqek6o6Rz2Dy7fsrdAykg/u+eV/h7cdADk/DN/aTyvcSzT3V9PGLE6JJctLNeSt/rJp1yVVPvMuMKF5zyAPWNC0aPQdMXT4Li4mt42byRO4YxITxGDjO1egzk4qt4U0NtA8N2GnztFJcQRbHkjXA6k7VzztGcD2A4FbdABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABVCfVre2nAnZI7b7punlQR+YW2iPrndnPanarq1notg97eyFIlIUBVLM7E4VVUcsxPAArzSefS521WbSbeS60wv/AMTrQ5ozHNbsefPjQ8qe5x/+oAuX1zrWpXus6vbaz9kv/D1xME0xl2xSQBVYGTud6qSHHAzjsa1PAcFneWt5eaez2+mXJKXGiTxcWlz1kC5PyqQQdmMc5HBxTdJ8H2uqWKy6vDY6tHGinS725hJmMJAYLKCBuxxwevtXS6Boo0WzlR7l7q6uZmuLq4dQvmSNgEhRwoAAAHoB160AatFFFABRRRQAUUUUAFFFFABRRRQAUUVQ1uxudS0W7s7O+exuJoysdwihih+h6jsf6UAc34j8TRzXmmadpeuW9tFc3bW93eQFJWt2CkqnOQpZgBlh7dSKy7PStTuvFN5F/aMQ13SfJKamIgBd20mT5U8a4BYbTyMdiMdq9p4Vs9cs49NewttL13SkjguU+zhre5h6ZI4DowBx3BzXoGk6JpuhWrW2l2UNrEzb2WNcbmxjJPUnAA59KALqxRo7uqKrOQWYDliBjn14p1FFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABVPVNVstGsXvb+cQwKQu7BJLE4AAGSSSegq5XPeKfD9xrCWd5YXTQalp0vn2wZz5Uh7pIvQg+vUdu4IBysviLVtV0uTxFbiy1LRoriUC3htnFzZBSVWYbjlmH3mXaDg8dOZPBPhGU3Ol63eQW1v9ks9kEllcOxvTJ8zTS8DIbIO07uSTnpXQ6HpKTaiviMW11pV3cxsl7YkjZLIDgOw55GDhhjIIzmumoAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAorgfH8Ftc+JfCsV3orazCXus2apG5Y+UMHEjKvHXk1maba+JdHn0XRYbptHg1K/vpVt8R3D2tuEDJGCdygg5PBIG7vjFAHqNNlljhieWV1jjRSzu5wFA5JJ7CvMrjXvF91eatFpCapcvpc32SERwWhhuJERSTOXdXG4t/AFABBGas67f63q9v4u8rUhp1vpNp5f2Mwo4mZrcSuZGIyB8+0bSPuk89KAO+iv7OeVIobuCSR4hOqJICWjPAcAdVPr0qxXma+KL/QdKDxATQWXhGK+SAqMGUZGSeuMAZGaseMtM1eH4ZeIZL7xJPel9NdmC28KICBkhMLnaRkcknB4IPNAHolFcBrmo65pF3o+g2d7q1/NeRz3El3DBaG4CR7AEUOEixl8k4J46c5DYtX8U3C6No1482lXl7eXCG8kihaZoIk3qdgLxh2yAeo+ViByMAHeQ3VvcPMkE8UrwP5cqo4YxtgHa2OhwQcHsRRFdW8008MU8UksDBZkRwWjJAYBh2JBB57EGuQ+H63CXfixLu5W5nTWmVplQLvxbwgEgcA4xnHGc9OlUH1JdL1TxxN9puLeWTU7OGFraFZZWd7aABUVvlJOcc8DOT0oA765ureytnuLqeKCCMZeWVwqqPcngVLXkOs67ql34L8caXqf2oyafbwSxPfxwpNtkycOISU4KZBGDg8iug1DXdZ8J31yt7qH9sRto11qKIYEjMUkGzKjYB+7bfxnJG3qaAO+JABJOAOpNRW1zBeW0dzazRzwSqHjliYMrqehBHBFcHoGpeLJ760a8t9Sm0+6t3a5ku4rSOOFtm5TF5TlipPGG3HkHPFbfw7/wCSb+G/+wdB/wCgCgDpqKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAKtxptpdX9nfTRbrmz3+Q+4jZvG1uAcHI9aLjTbS6v7O+mi3XNnv8h9xGzeNrcA4OR61aooAw9Q8I6Jqd9Je3FrILiUBZmguZYRMAMDeEYB8Dj5geKTVPB2g6zdPc31iZJJIhDLtmkjWVBnAdVYB8ZONwOO1btFAGZD4f0qCVZEs13LZrYAMzMDAOiEE4I9zzVWz8H6HY2tzaw2khtriE28kEtzLLH5Z6oquxCj2XFbtFAGE/g/RZdOhsZYLiSKCQyQu97M0sTEYOyUvvUY4wGAp0vhHRZtLj06S1kaCKbz42NzL5qSf3xLu3hsEjO7ocVt0UAZujaBpnh+G4i0u1+zpcS+fKN7Nvk2qpYlieSFGfU89STUV34Y0e+TUFubMONQljmuD5jgtIiqqMCDlCAi4K46Z61r0UAc9H4H8Ox2mo2wsC0epIkd55lxI7ThCSu5ixJPzHnOT36CrOmeFtF0iaeazssSTxiJzLK8uIx/Au8nan+yMD2rYooAw9O8I6LpNws1lbTRlFKxxm6leOMEYIRGYqgx/dArT07T7XSdNttPsYvKtbaNYoY9xbaoGAMkkn8as0UAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAH//Z")||kl($A,"src",Be)},m(A,t){ke(document.head,M),e(A,tt,t),e(A,_A,t),e(A,lt,t),U(c,A,t),e(A,et,t),U(F,A,t),e(A,st,t),e(A,y,t),e(A,ot,t),e(A,g,t),e(A,it,t),U(R,A,t),e(A,at,t),e(A,C,t),e(A,nt,t),e(A,J,t),e(A,pt,t),U(B,A,t),e(A,Ut,t),e(A,u,t),e(A,Kt,t),e(A,b,t),e(A,ft,t),U(T,A,t),e(A,rt,t),e(A,H,t),e(A,wt,t),U(P,A,t),e(A,jt,t),e(A,d,t),e(A,mt,t),U(h,A,t),e(A,Mt,t),U(x,A,t),e(A,ct,t),e(A,z,t),e(A,Ft,t),U(v,A,t),e(A,yt,t),e(A,V,t),e(A,gt,t),U(G,A,t),e(A,Rt,t),e(A,I,t),e(A,Ct,t),U(k,A,t),e(A,Jt,t),e(A,Q,t),e(A,Bt,t),U(X,A,t),e(A,ut,t),e(A,Z,t),e(A,bt,t),U(q,A,t),e(A,Tt,t),e(A,W,t),e(A,Ht,t),U(N,A,t),e(A,Pt,t),e(A,D,t),e(A,dt,t),U(S,A,t),e(A,ht,t),e(A,EA,t),e(A,xt,t),U(Y,A,t),e(A,zt,t),e(A,O,t),e(A,vt,t),e(A,L,t),e(A,Vt,t),U(E,A,t),e(A,Gt,t),U($,A,t),e(A,It,t),U(_,A,t),e(A,kt,t),U(AA,A,t),e(A,Qt,t),U(tA,A,t),e(A,Xt,t),U(lA,A,t),e(A,Zt,t),U(eA,A,t),e(A,qt,t),U(sA,A,t),e(A,Wt,t),U(oA,A,t),e(A,Nt,t),U(iA,A,t),e(A,Dt,t),U(aA,A,t),e(A,St,t),e(A,nA,t),e(A,Yt,t),U(pA,A,t),e(A,Ot,t),U(UA,A,t),e(A,Lt,t),U(KA,A,t),e(A,Et,t),U(fA,A,t),e(A,$t,t),e(A,rA,t),e(A,_t,t),e(A,wA,t),e(A,Al,t),U(jA,A,t),e(A,tl,t),e(A,mA,t),e(A,ll,t),e(A,MA,t),e(A,el,t),U(cA,A,t),e(A,sl,t),e(A,FA,t),e(A,ol,t),e(A,yA,t),e(A,il,t),e(A,gA,t),e(A,al,t),e(A,RA,t),e(A,nl,t),e(A,CA,t),e(A,pl,t),U(JA,A,t),e(A,Ul,t),e(A,BA,t),e(A,Kl,t),U(uA,A,t),e(A,fl,t),e(A,bA,t),e(A,rl,t),e(A,TA,t),e(A,wl,t),U(HA,A,t),e(A,jl,t),e(A,PA,t),e(A,ml,t),e(A,dA,t),e(A,Ml,t),U(hA,A,t),e(A,cl,t),e(A,xA,t),e(A,Fl,t),U(zA,A,t),e(A,yl,t),e(A,vA,t),e(A,gl,t),U(VA,A,t),e(A,Rl,t),e(A,GA,t),e(A,Cl,t),U(IA,A,t),e(A,Jl,t),e(A,kA,t),e(A,Bl,t),e(A,QA,t),e(A,ul,t),U(XA,A,t),e(A,bl,t),e(A,$A,t),e(A,Tl,t),U(ZA,A,t),e(A,Hl,t),e(A,qA,t),e(A,Pl,t),e(A,WA,t),e(A,dl,t),U(NA,A,t),e(A,hl,t),e(A,DA,t),e(A,xl,t),e(A,SA,t),e(A,zl,t),U(YA,A,t),e(A,vl,t),e(A,OA,t),e(A,Vl,t),U(LA,A,t),e(A,Gl,t),e(A,At,t),Il=!0},p:ze,i(A){Il||(K(c.$$.fragment,A),K(F.$$.fragment,A),K(R.$$.fragment,A),K(B.$$.fragment,A),K(T.$$.fragment,A),K(P.$$.fragment,A),K(h.$$.fragment,A),K(x.$$.fragment,A),K(v.$$.fragment,A),K(G.$$.fragment,A),K(k.$$.fragment,A),K(X.$$.fragment,A),K(q.$$.fragment,A),K(N.$$.fragment,A),K(S.$$.fragment,A),K(Y.$$.fragment,A),K(E.$$.fragment,A),K($.$$.fragment,A),K(_.$$.fragment,A),K(AA.$$.fragment,A),K(tA.$$.fragment,A),K(lA.$$.fragment,A),K(eA.$$.fragment,A),K(sA.$$.fragment,A),K(oA.$$.fragment,A),K(iA.$$.fragment,A),K(aA.$$.fragment,A),K(pA.$$.fragment,A),K(UA.$$.fragment,A),K(KA.$$.fragment,A),K(fA.$$.fragment,A),K(jA.$$.fragment,A),K(cA.$$.fragment,A),K(JA.$$.fragment,A),K(uA.$$.fragment,A),K(HA.$$.fragment,A),K(hA.$$.fragment,A),K(zA.$$.fragment,A),K(VA.$$.fragment,A),K(IA.$$.fragment,A),K(XA.$$.fragment,A),K(ZA.$$.fragment,A),K(NA.$$.fragment,A),K(YA.$$.fragment,A),K(LA.$$.fragment,A),Il=!0)},o(A){f(c.$$.fragment,A),f(F.$$.fragment,A),f(R.$$.fragment,A),f(B.$$.fragment,A),f(T.$$.fragment,A),f(P.$$.fragment,A),f(h.$$.fragment,A),f(x.$$.fragment,A),f(v.$$.fragment,A),f(G.$$.fragment,A),f(k.$$.fragment,A),f(X.$$.fragment,A),f(q.$$.fragment,A),f(N.$$.fragment,A),f(S.$$.fragment,A),f(Y.$$.fragment,A),f(E.$$.fragment,A),f($.$$.fragment,A),f(_.$$.fragment,A),f(AA.$$.fragment,A),f(tA.$$.fragment,A),f(lA.$$.fragment,A),f(eA.$$.fragment,A),f(sA.$$.fragment,A),f(oA.$$.fragment,A),f(iA.$$.fragment,A),f(aA.$$.fragment,A),f(pA.$$.fragment,A),f(UA.$$.fragment,A),f(KA.$$.fragment,A),f(fA.$$.fragment,A),f(jA.$$.fragment,A),f(cA.$$.fragment,A),f(JA.$$.fragment,A),f(uA.$$.fragment,A),f(HA.$$.fragment,A),f(hA.$$.fragment,A),f(zA.$$.fragment,A),f(VA.$$.fragment,A),f(IA.$$.fragment,A),f(XA.$$.fragment,A),f(ZA.$$.fragment,A),f(NA.$$.fragment,A),f(YA.$$.fragment,A),f(LA.$$.fragment,A),Il=!1},d(A){A&&(l(tt),l(_A),l(lt),l(et),l(st),l(y),l(ot),l(g),l(it),l(at),l(C),l(nt),l(J),l(pt),l(Ut),l(u),l(Kt),l(b),l(ft),l(rt),l(H),l(wt),l(jt),l(d),l(mt),l(Mt),l(ct),l(z),l(Ft),l(yt),l(V),l(gt),l(Rt),l(I),l(Ct),l(Jt),l(Q),l(Bt),l(ut),l(Z),l(bt),l(Tt),l(W),l(Ht),l(Pt),l(D),l(dt),l(ht),l(EA),l(xt),l(zt),l(O),l(vt),l(L),l(Vt),l(Gt),l(It),l(kt),l(Qt),l(Xt),l(Zt),l(qt),l(Wt),l(Nt),l(Dt),l(St),l(nA),l(Yt),l(Ot),l(Lt),l(Et),l($t),l(rA),l(_t),l(wA),l(Al),l(tl),l(mA),l(ll),l(MA),l(el),l(sl),l(FA),l(ol),l(yA),l(il),l(gA),l(al),l(RA),l(nl),l(CA),l(pl),l(Ul),l(BA),l(Kl),l(fl),l(bA),l(rl),l(TA),l(wl),l(jl),l(PA),l(ml),l(dA),l(Ml),l(cl),l(xA),l(Fl),l(yl),l(vA),l(gl),l(Rl),l(GA),l(Cl),l(Jl),l(kA),l(Bl),l(QA),l(ul),l(bl),l($A),l(Tl),l(Hl),l(qA),l(Pl),l(WA),l(dl),l(hl),l(DA),l(xl),l(SA),l(zl),l(vl),l(OA),l(Vl),l(Gl),l(At)),l(M),r(c,A),r(F,A),r(R,A),r(B,A),r(T,A),r(P,A),r(h,A),r(x,A),r(v,A),r(G,A),r(k,A),r(X,A),r(q,A),r(N,A),r(S,A),r(Y,A),r(E,A),r($,A),r(_,A),r(AA,A),r(tA,A),r(lA,A),r(eA,A),r(sA,A),r(oA,A),r(iA,A),r(aA,A),r(pA,A),r(UA,A),r(KA,A),r(fA,A),r(jA,A),r(cA,A),r(JA,A),r(uA,A),r(HA,A),r(hA,A),r(zA,A),r(VA,A),r(IA,A),r(XA,A),r(ZA,A),r(NA,A),r(YA,A),r(LA,A)}}}const qe='{"title":"用自定义生物医学数据集微调视觉 Transformer 模型","local":"用自定义生物医学数据集微调视觉-transformer-模型","sections":[{"title":"数据集信息","local":"数据集信息","sections":[],"depth":2},{"title":"模型信息","local":"模型信息","sections":[],"depth":2},{"title":"开始","local":"开始","sections":[],"depth":2},{"title":"数据集准备","local":"数据集准备","sections":[],"depth":2},{"title":"数据处理","local":"数据处理","sections":[{"title":"标签映射","local":"标签映射","sections":[],"depth":3},{"title":"图像处理","local":"图像处理","sections":[],"depth":3},{"title":"创建转换函数","local":"创建转换函数","sections":[],"depth":3},{"title":"将转换函数应用于每个集合","local":"将转换函数应用于每个集合","sections":[],"depth":3},{"title":"数据加载","local":"数据加载","sections":[],"depth":3},{"title":"批量准备","local":"批量准备","sections":[],"depth":3}],"depth":2},{"title":"微调模型","local":"微调模型","sections":[{"title":"(可选) 将模型推送到 Hub","local":"可选-将模型推送到-hub","sections":[],"depth":3}],"depth":2},{"title":"结果","local":"结果","sections":[{"title":"什么是混淆矩阵？","local":"什么是混淆矩阵","sections":[],"depth":3},{"title":"什么是召回率？","local":"什么是召回率","sections":[],"depth":3}],"depth":2},{"title":"结论","local":"结论","sections":[],"depth":2}],"depth":1}';function We(Ql){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ve{constructor(M){super(),Ge(this,M,We,Ze,xe,{})}}export{Oe as component};
