import{s as En,n as Nn,o as Fn}from"../chunks/scheduler.182ea377.js";import{S as Qn,i as xn,g as r,s as a,r as c,A as Yn,h as s,f as n,c as i,j as nn,u as o,x as d,k as Hn,y,a as l,v as p,d as g,t as m,w as h}from"../chunks/index.abf12888.js";import{C as J}from"../chunks/CodeBlock.57fe6e13.js";import{H as M}from"../chunks/Heading.16916d63.js";function Ln(ln){let f,Ct,Vt,zt,T,Ht,w,an='🤗 Diffusers supports the latest optimizations from <a href="https://pytorch.org/get-started/pytorch-2.0/" rel="nofollow">PyTorch 2.0</a> which include:',Et,U,rn='<li>A memory-efficient attention implementation, scaled dot product attention, without requiring any extra dependencies such as xFormers.</li> <li><a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile</code></a>, a just-in-time (JIT) compiler to provide an extra performance boost when individual models are compiled.</li>',Nt,j,sn="Both of these optimizations require PyTorch 2.0 or later and 🤗 Diffusers > 0.13.0.",Ft,Z,Qt,B,xt,W,dn='<a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> (SDPA) is an optimized and memory-efficient attention (similar to xFormers) that automatically enables several other optimizations depending on the model inputs and GPU type. SDPA is enabled by default if you’re using PyTorch 2.0 and the latest version of 🤗 Diffusers, so you don’t need to add anything to your code.',Yt,X,cn='However, if you want to explicitly enable it, you can set a <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to use <a href="/docs/diffusers/v0.26.1/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor2_0">AttnProcessor2_0</a>:',Lt,$,Dt,G,on='SDPA should be as fast and memory efficient as <code>xFormers</code>; check the <a href="#benchmark">benchmark</a> for more details.',At,R,pn='In some cases - such as making the pipeline more deterministic or converting it to other formats - it may be helpful to use the vanilla attention processor, <a href="/docs/diffusers/v0.26.1/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor">AttnProcessor</a>. To revert to <a href="/docs/diffusers/v0.26.1/en/api/attnprocessor#diffusers.models.attention_processor.AttnProcessor">AttnProcessor</a>, call the <a href="/docs/diffusers/v0.26.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel.set_default_attn_processor">set_default_attn_processor()</a> function on the pipeline:',qt,v,Pt,S,Kt,_,gn="The <code>torch.compile</code> function can often provide an additional speed-up to your PyTorch code. In 🤗 Diffusers, it is usually best to wrap the UNet with <code>torch.compile</code> because it does most of the heavy lifting in the pipeline.",Ot,I,te,V,mn="Depending on GPU type, <code>torch.compile</code> can provide an <em>additional speed-up</em> of <strong>5-300x</strong> on top of SDPA! If you’re using more recent GPU architectures such as Ampere (A100, 3090), Ada (4090), and Hopper (H100), <code>torch.compile</code> is able to squeeze even more performance out of these GPUs.",ee,k,hn="Compilation requires some time to complete, so it is best suited for situations where you prepare your pipeline once and then perform the same type of inference operations multiple times. For example, calling the compiled pipeline on a different image size triggers compilation again which can be expensive.",ne,C,Mn='For more information and different options about <code>torch.compile</code>, refer to the <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch_compile</code></a> tutorial.',le,z,ae,H,bn='We conducted a comprehensive benchmark with PyTorch 2.0’s efficient attention implementation and <code>torch.compile</code> across different GPUs and batch sizes for five of our most used pipelines. The code is benchmarked on 🤗 Diffusers v0.17.0.dev0 to optimize <code>torch.compile</code> usage (see <a href="https://github.com/huggingface/diffusers/pull/3313" rel="nofollow">here</a> for more details).',ie,E,un="Expand the dropdown below to find the code used to benchmark each pipeline:",re,b,N,Le,F,De,Q,Ae,x,qe,Y,Pe,L,Ke,D,Oe,A,tn,q,en,P,se,K,yn='The graph below highlights the relative speed-ups for the <a href="/docs/diffusers/v0.26.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> across five GPU families with PyTorch 2.0 and <code>torch.compile</code> enabled. The benchmarks for the following graphs are measured in <em>number of iterations/second</em>.',de,O,fn='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/pt2_benchmarks/t2i_speedup.png" alt="t2i_speedup"/>',ce,tt,Jn=`To give you an even better idea of how this speed-up holds for the other pipelines, consider the following
graph for an A100 with PyTorch 2.0 and <code>torch.compile</code>:`,oe,et,Tn='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/pt2_benchmarks/a100_numbers.png" alt="a100_numbers"/>',pe,nt,wn="In the following tables, we report our findings in terms of the <em>number of iterations/second</em>.",ge,lt,me,at,Un='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">21.66</td> <td align="center">23.13</td> <td align="center">44.03</td> <td align="center">49.74</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">21.81</td> <td align="center">22.40</td> <td align="center">43.92</td> <td align="center">46.32</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">22.24</td> <td align="center">23.23</td> <td align="center">43.76</td> <td align="center">49.25</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">15.02</td> <td align="center">15.82</td> <td align="center">32.13</td> <td align="center">36.08</td></tr> <tr><td align="center">IF</td> <td align="center">20.21 / <br/>13.84 / <br/>24.00</td> <td align="center">20.12 / <br/>13.70 / <br/>24.03</td> <td align="center">❌</td> <td align="center">97.34 / <br/>27.23 / <br/>111.66</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">8.64</td> <td align="center">9.9</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',he,it,Me,rt,jn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">11.6</td> <td align="center">13.12</td> <td align="center">14.62</td> <td align="center">17.27</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">11.47</td> <td align="center">13.06</td> <td align="center">14.66</td> <td align="center">17.25</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">11.67</td> <td align="center">13.31</td> <td align="center">14.88</td> <td align="center">17.48</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">8.28</td> <td align="center">9.38</td> <td align="center">10.51</td> <td align="center">12.41</td></tr> <tr><td align="center">IF</td> <td align="center">25.02</td> <td align="center">18.04</td> <td align="center">❌</td> <td align="center">48.47</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">2.44</td> <td align="center">2.74</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',be,st,ue,dt,Zn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">3.04</td> <td align="center">3.6</td> <td align="center">3.83</td> <td align="center">4.68</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">2.98</td> <td align="center">3.58</td> <td align="center">3.83</td> <td align="center">4.67</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">3.04</td> <td align="center">3.66</td> <td align="center">3.9</td> <td align="center">4.76</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">2.15</td> <td align="center">2.58</td> <td align="center">2.74</td> <td align="center">3.35</td></tr> <tr><td align="center">IF</td> <td align="center">8.78</td> <td align="center">9.82</td> <td align="center">❌</td> <td align="center">16.77</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.64</td> <td align="center">0.72</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',ye,ct,fe,ot,Bn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">18.99</td> <td align="center">19.14</td> <td align="center">20.95</td> <td align="center">22.17</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">18.56</td> <td align="center">19.18</td> <td align="center">20.95</td> <td align="center">22.11</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">19.14</td> <td align="center">19.06</td> <td align="center">21.08</td> <td align="center">22.20</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">13.48</td> <td align="center">13.93</td> <td align="center">15.18</td> <td align="center">15.88</td></tr> <tr><td align="center">IF</td> <td align="center">20.01 / <br/>9.08 / <br/>23.34</td> <td align="center">19.79 / <br/>8.98 / <br/>24.10</td> <td align="center">❌</td> <td align="center">55.75 / <br/>11.57 / <br/>57.67</td></tr></tbody>',Je,pt,Te,gt,Wn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">5.96</td> <td align="center">5.89</td> <td align="center">6.83</td> <td align="center">6.86</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">5.90</td> <td align="center">5.91</td> <td align="center">6.81</td> <td align="center">6.82</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">5.99</td> <td align="center">6.03</td> <td align="center">6.93</td> <td align="center">6.95</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.26</td> <td align="center">4.29</td> <td align="center">4.92</td> <td align="center">4.93</td></tr> <tr><td align="center">IF</td> <td align="center">15.41</td> <td align="center">14.76</td> <td align="center">❌</td> <td align="center">22.95</td></tr></tbody>',we,mt,Ue,ht,Xn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.66</td> <td align="center">1.66</td> <td align="center">1.92</td> <td align="center">1.90</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.65</td> <td align="center">1.65</td> <td align="center">1.91</td> <td align="center">1.89</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.69</td> <td align="center">1.69</td> <td align="center">1.95</td> <td align="center">1.93</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.19</td> <td align="center">1.19</td> <td align="center">OOM after warmup</td> <td align="center">1.36</td></tr> <tr><td align="center">IF</td> <td align="center">5.43</td> <td align="center">5.29</td> <td align="center">❌</td> <td align="center">7.06</td></tr></tbody>',je,Mt,Ze,bt,$n='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">6.9</td> <td align="center">6.95</td> <td align="center">7.3</td> <td align="center">7.56</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">6.84</td> <td align="center">6.99</td> <td align="center">7.04</td> <td align="center">7.55</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">6.91</td> <td align="center">6.7</td> <td align="center">7.01</td> <td align="center">7.37</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.89</td> <td align="center">4.86</td> <td align="center">5.35</td> <td align="center">5.48</td></tr> <tr><td align="center">IF</td> <td align="center">17.42 / <br/>2.47 / <br/>18.52</td> <td align="center">16.96 / <br/>2.45 / <br/>18.69</td> <td align="center">❌</td> <td align="center">24.63 / <br/>2.47 / <br/>23.39</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">1.15</td> <td align="center">1.16</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Be,ut,We,yt,Gn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.79</td> <td align="center">1.79</td> <td align="center">2.03</td> <td align="center">1.99</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.77</td> <td align="center">1.77</td> <td align="center">2.05</td> <td align="center">2.04</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.81</td> <td align="center">1.82</td> <td align="center">2.09</td> <td align="center">2.09</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.34</td> <td align="center">1.27</td> <td align="center">1.47</td> <td align="center">1.46</td></tr> <tr><td align="center">IF</td> <td align="center">5.79</td> <td align="center">5.61</td> <td align="center">❌</td> <td align="center">7.39</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.288</td> <td align="center">0.289</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Xe,ft,$e,Jt,Rn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">2.34s</td> <td align="center">2.30s</td> <td align="center">OOM after 2nd iteration</td> <td align="center">1.99s</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">2.35s</td> <td align="center">2.31s</td> <td align="center">OOM after warmup</td> <td align="center">2.00s</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">2.30s</td> <td align="center">2.26s</td> <td align="center">OOM after 2nd iteration</td> <td align="center">1.95s</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">OOM after 2nd iteration</td> <td align="center">OOM after 2nd iteration</td> <td align="center">OOM after warmup</td> <td align="center">OOM after warmup</td></tr> <tr><td align="center">IF *</td> <td align="center">1.44</td> <td align="center">1.44</td> <td align="center">❌</td> <td align="center">1.94</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">OOM</td> <td align="center">OOM</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Ge,Tt,Re,wt,vn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">22.56</td> <td align="center">22.84</td> <td align="center">23.84</td> <td align="center">25.69</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">22.25</td> <td align="center">22.61</td> <td align="center">24.1</td> <td align="center">25.83</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">22.22</td> <td align="center">22.54</td> <td align="center">24.26</td> <td align="center">26.02</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">16.03</td> <td align="center">16.33</td> <td align="center">17.38</td> <td align="center">18.56</td></tr> <tr><td align="center">IF</td> <td align="center">27.08 / <br/>9.07 / <br/>31.23</td> <td align="center">26.75 / <br/>8.92 / <br/>31.47</td> <td align="center">❌</td> <td align="center">68.08 / <br/>11.16 / <br/>65.29</td></tr></tbody>',ve,Ut,Se,jt,Sn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">6.46</td> <td align="center">6.35</td> <td align="center">7.29</td> <td align="center">7.3</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">6.33</td> <td align="center">6.27</td> <td align="center">7.31</td> <td align="center">7.26</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">6.47</td> <td align="center">6.4</td> <td align="center">7.44</td> <td align="center">7.39</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">4.59</td> <td align="center">4.54</td> <td align="center">5.27</td> <td align="center">5.26</td></tr> <tr><td align="center">IF</td> <td align="center">16.81</td> <td align="center">16.62</td> <td align="center">❌</td> <td align="center">21.57</td></tr></tbody>',_e,Zt,Ie,Bt,_n='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">1.7</td> <td align="center">1.69</td> <td align="center">1.93</td> <td align="center">1.91</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">1.68</td> <td align="center">1.67</td> <td align="center">1.93</td> <td align="center">1.9</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">1.72</td> <td align="center">1.71</td> <td align="center">1.97</td> <td align="center">1.94</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">1.23</td> <td align="center">1.22</td> <td align="center">1.4</td> <td align="center">1.38</td></tr> <tr><td align="center">IF</td> <td align="center">5.01</td> <td align="center">5.00</td> <td align="center">❌</td> <td align="center">6.33</td></tr></tbody>',Ve,Wt,ke,Xt,In='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">40.5</td> <td align="center">41.89</td> <td align="center">44.65</td> <td align="center">49.81</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">40.39</td> <td align="center">41.95</td> <td align="center">44.46</td> <td align="center">49.8</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">40.51</td> <td align="center">41.88</td> <td align="center">44.58</td> <td align="center">49.72</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">29.27</td> <td align="center">30.29</td> <td align="center">32.26</td> <td align="center">36.03</td></tr> <tr><td align="center">IF</td> <td align="center">69.71 / <br/>18.78 / <br/>85.49</td> <td align="center">69.13 / <br/>18.80 / <br/>85.56</td> <td align="center">❌</td> <td align="center">124.60 / <br/>26.37 / <br/>138.79</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">6.8</td> <td align="center">8.18</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Ce,$t,ze,Gt,Vn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">12.62</td> <td align="center">12.84</td> <td align="center">15.32</td> <td align="center">15.59</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">12.61</td> <td align="center">12,.79</td> <td align="center">15.35</td> <td align="center">15.66</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">12.65</td> <td align="center">12.81</td> <td align="center">15.3</td> <td align="center">15.58</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">9.1</td> <td align="center">9.25</td> <td align="center">11.03</td> <td align="center">11.22</td></tr> <tr><td align="center">IF</td> <td align="center">31.88</td> <td align="center">31.14</td> <td align="center">❌</td> <td align="center">43.92</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">2.19</td> <td align="center">2.35</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',He,Rt,Ee,vt,kn='<thead><tr><th align="center"><strong>Pipeline</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch nightly - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th> <th align="center"><strong>torch nightly - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">SD - txt2img</td> <td align="center">3.17</td> <td align="center">3.2</td> <td align="center">3.84</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - img2img</td> <td align="center">3.16</td> <td align="center">3.2</td> <td align="center">3.84</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - inpaint</td> <td align="center">3.17</td> <td align="center">3.2</td> <td align="center">3.85</td> <td align="center">3.85</td></tr> <tr><td align="center">SD - controlnet</td> <td align="center">2.23</td> <td align="center">2.3</td> <td align="center">2.7</td> <td align="center">2.75</td></tr> <tr><td align="center">IF</td> <td align="center">9.26</td> <td align="center">9.2</td> <td align="center">❌</td> <td align="center">13.31</td></tr> <tr><td align="center">SDXL - txt2img</td> <td align="center">0.52</td> <td align="center">0.53</td> <td align="center">-</td> <td align="center">-</td></tr></tbody>',Ne,St,Fe,_t,Cn='<li>Follow this <a href="https://github.com/huggingface/diffusers/pull/3313" rel="nofollow">PR</a> for more details on the environment used for conducting the benchmarks.</li> <li>For the DeepFloyd IF pipeline where batch sizes &gt; 1, we only used a batch size of &gt; 1 in the first IF pipeline for text-to-image generation and NOT for upscaling. That means the two upscaling pipelines received a batch size of 1.</li>',Qe,It,zn='<em>Thanks to <a href="https://github.com/Chillee" rel="nofollow">Horace He</a> from the PyTorch team for their support in improving our support of <code>torch.compile()</code> in Diffusers.</em>',xe,kt,Ye;return T=new M({props:{title:"PyTorch 2.0",local:"pytorch-20",headingTag:"h1"}}),Z=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHRvcmNoJTIwZGlmZnVzZXJz",highlighted:"pip install --upgrade torch diffusers",wrap:!1}}),B=new M({props:{title:"Scaled dot product attention",local:"scaled-dot-product-attention",headingTag:"h2"}}),$=new J({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMkIlMjBmcm9tJTIwZGlmZnVzZXJzLm1vZGVscy5hdHRlbnRpb25fcHJvY2Vzc29yJTIwaW1wb3J0JTIwQXR0blByb2Nlc3NvcjJfMCUwQSUwQSUyMCUyMHBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMHBpcGUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQXR0blByb2Nlc3NvcjJfMCgpKSUwQSUwQSUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEElMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`  import torch
  from diffusers import DiffusionPipeline
<span class="hljs-addition">+ from diffusers.models.attention_processor import AttnProcessor2_0</span>

  pipe = DiffusionPipeline.from_pretrained(&quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True).to(&quot;cuda&quot;)
<span class="hljs-addition">+ pipe.unet.set_attn_processor(AttnProcessor2_0())</span>

  prompt = &quot;a photo of an astronaut riding a horse on mars&quot;
  image = pipe(prompt).images[0]`,wrap:!1}}),v=new J({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEElMkIlMjBwaXBlLnVuZXQuc2V0X2RlZmF1bHRfYXR0bl9wcm9jZXNzb3IoKSUwQSUwQSUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEElMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`  import torch
  from diffusers import DiffusionPipeline

  pipe = DiffusionPipeline.from_pretrained(&quot;runwayml/stable-diffusion-v1-5&quot;, torch_dtype=torch.float16, use_safetensors=True).to(&quot;cuda&quot;)
<span class="hljs-addition">+ pipe.unet.set_default_attn_processor()</span>

  prompt = &quot;a photo of an astronaut riding a horse on mars&quot;
  image = pipe(prompt).images[0]`,wrap:!1}}),S=new M({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),I=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRHN0ZXBzJTJDJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEYmF0Y2hfc2l6ZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
images = pipe(prompt, num_inference_steps=steps, num_images_per_prompt=batch_size).images[<span class="hljs-number">0</span>]`,wrap:!1}}),z=new M({props:{title:"Benchmark",local:"benchmark",headingTag:"h2"}}),N=new M({props:{title:"Stable Diffusion text-to-image",local:"stable-diffusion-text-to-image",headingTag:"h3"}}),F=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwYXRoJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEElMEFydW5fY29tcGlsZSUyMCUzRCUyMFRydWUlMjAlMjAlMjMlMjBTZXQlMjBUcnVlJTIwJTJGJTIwRmFsc2UlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = DiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    images = pipe(prompt=prompt).images`,wrap:!1}}),Q=new M({props:{title:"Stable Diffusion image-to-image",local:"stable-diffusion-image-to-image",headingTag:"h3"}}),x=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBJTBBcnVuX2NvbXBpbGUlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwU2V0JTIwVHJ1ZSUyMCUyRiUyMEZhbHNlJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBJTBBaWYlMjBydW5fY29tcGlsZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMlJ1biUyMHRvcmNoJTIwY29tcGlsZSUyMiklMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmdoaWJsaSUyMHN0eWxlJTJDJTIwYSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMjB3aXRoJTIwY2FzdGxlcyUyMiUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = StableDiffusionImg2ImgPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Y=new M({props:{title:"Stable Diffusion inpainting",local:"stable-diffusion-inpainting",headingTag:"h3"}}),L=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQSUwQXJ1bl9jb21waWxlJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMFNldCUyMFRydWUlMjAlMkYlMjBGYWxzZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQSUwQWlmJTIwcnVuX2NvbXBpbGUlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJSdW4lMjB0b3JjaCUyMGNvbXBpbGUlMjIpJTBBJTIwJTIwJTIwJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJnaGlibGklMjBzdHlsZSUyQyUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTIwd2l0aCUyMGNhc3RsZXMlMjIlMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = load_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = load_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe = StableDiffusionInpaintPipeline.from_pretrained(path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new M({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),A=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

init_image = load_image(url)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    path, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.unet.to(memory_format=torch.channels_last)
pipe.controlnet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Run torch compile&quot;</span>)
    pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe.controlnet = torch.<span class="hljs-built_in">compile</span>(pipe.controlnet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with castles&quot;</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new M({props:{title:"DeepFloyd IF text-to-image + upscaling",local:"deepfloyd-if-text-to-image--upscaling",headingTag:"h3"}}),P=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

run_compile = <span class="hljs-literal">True</span>  <span class="hljs-comment"># Set True / False</span>

pipe_1 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;DeepFloyd/IF-I-M-v1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, text_encoder=<span class="hljs-literal">None</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_1.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_2 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;DeepFloyd/IF-II-M-v1.0&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, text_encoder=<span class="hljs-literal">None</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_2.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe_3 = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-x4-upscaler&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe_3.to(<span class="hljs-string">&quot;cuda&quot;</span>)


pipe_1.unet.to(memory_format=torch.channels_last)
pipe_2.unet.to(memory_format=torch.channels_last)
pipe_3.unet.to(memory_format=torch.channels_last)

<span class="hljs-keyword">if</span> run_compile:
    pipe_1.unet = torch.<span class="hljs-built_in">compile</span>(pipe_1.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe_2.unet = torch.<span class="hljs-built_in">compile</span>(pipe_2.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    pipe_3.unet = torch.<span class="hljs-built_in">compile</span>(pipe_3.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;the blue hulk&quot;</span>

prompt_embeds = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4096</span>), dtype=torch.float16)
neg_prompt_embeds = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4096</span>), dtype=torch.float16)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    image_1 = pipe_1(prompt_embeds=prompt_embeds, negative_prompt_embeds=neg_prompt_embeds, output_type=<span class="hljs-string">&quot;pt&quot;</span>).images
    image_2 = pipe_2(image=image_1, prompt_embeds=prompt_embeds, negative_prompt_embeds=neg_prompt_embeds, output_type=<span class="hljs-string">&quot;pt&quot;</span>).images
    image_3 = pipe_3(prompt=prompt, image=image_1, noise_level=<span class="hljs-number">100</span>).images`,wrap:!1}}),lt=new M({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),it=new M({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),st=new M({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),ct=new M({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),pt=new M({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),mt=new M({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),Mt=new M({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),ut=new M({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),ft=new M({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),Tt=new M({props:{title:"RTX 3090 (batch size: 1)",local:"rtx-3090-batch-size-1",headingTag:"h3"}}),Ut=new M({props:{title:"RTX 3090 (batch size: 4)",local:"rtx-3090-batch-size-4",headingTag:"h3"}}),Zt=new M({props:{title:"RTX 3090 (batch size: 16)",local:"rtx-3090-batch-size-16",headingTag:"h3"}}),Wt=new M({props:{title:"RTX 4090 (batch size: 1)",local:"rtx-4090-batch-size-1",headingTag:"h3"}}),$t=new M({props:{title:"RTX 4090 (batch size: 4)",local:"rtx-4090-batch-size-4",headingTag:"h3"}}),Rt=new M({props:{title:"RTX 4090 (batch size: 16)",local:"rtx-4090-batch-size-16",headingTag:"h3"}}),St=new M({props:{title:"Notes",local:"notes",headingTag:"h2"}}),{c(){f=r("meta"),Ct=a(),Vt=r("p"),zt=a(),c(T.$$.fragment),Ht=a(),w=r("p"),w.innerHTML=an,Et=a(),U=r("ol"),U.innerHTML=rn,Nt=a(),j=r("p"),j.textContent=sn,Ft=a(),c(Z.$$.fragment),Qt=a(),c(B.$$.fragment),xt=a(),W=r("p"),W.innerHTML=dn,Yt=a(),X=r("p"),X.innerHTML=cn,Lt=a(),c($.$$.fragment),Dt=a(),G=r("p"),G.innerHTML=on,At=a(),R=r("p"),R.innerHTML=pn,qt=a(),c(v.$$.fragment),Pt=a(),c(S.$$.fragment),Kt=a(),_=r("p"),_.innerHTML=gn,Ot=a(),c(I.$$.fragment),te=a(),V=r("p"),V.innerHTML=mn,ee=a(),k=r("p"),k.textContent=hn,ne=a(),C=r("p"),C.innerHTML=Mn,le=a(),c(z.$$.fragment),ae=a(),H=r("p"),H.innerHTML=bn,ie=a(),E=r("p"),E.textContent=un,re=a(),b=r("details"),c(N.$$.fragment),Le=a(),c(F.$$.fragment),De=a(),c(Q.$$.fragment),Ae=a(),c(x.$$.fragment),qe=a(),c(Y.$$.fragment),Pe=a(),c(L.$$.fragment),Ke=a(),c(D.$$.fragment),Oe=a(),c(A.$$.fragment),tn=a(),c(q.$$.fragment),en=a(),c(P.$$.fragment),se=a(),K=r("p"),K.innerHTML=yn,de=a(),O=r("p"),O.innerHTML=fn,ce=a(),tt=r("p"),tt.innerHTML=Jn,oe=a(),et=r("p"),et.innerHTML=Tn,pe=a(),nt=r("p"),nt.innerHTML=wn,ge=a(),c(lt.$$.fragment),me=a(),at=r("table"),at.innerHTML=Un,he=a(),c(it.$$.fragment),Me=a(),rt=r("table"),rt.innerHTML=jn,be=a(),c(st.$$.fragment),ue=a(),dt=r("table"),dt.innerHTML=Zn,ye=a(),c(ct.$$.fragment),fe=a(),ot=r("table"),ot.innerHTML=Bn,Je=a(),c(pt.$$.fragment),Te=a(),gt=r("table"),gt.innerHTML=Wn,we=a(),c(mt.$$.fragment),Ue=a(),ht=r("table"),ht.innerHTML=Xn,je=a(),c(Mt.$$.fragment),Ze=a(),bt=r("table"),bt.innerHTML=$n,Be=a(),c(ut.$$.fragment),We=a(),yt=r("table"),yt.innerHTML=Gn,Xe=a(),c(ft.$$.fragment),$e=a(),Jt=r("table"),Jt.innerHTML=Rn,Ge=a(),c(Tt.$$.fragment),Re=a(),wt=r("table"),wt.innerHTML=vn,ve=a(),c(Ut.$$.fragment),Se=a(),jt=r("table"),jt.innerHTML=Sn,_e=a(),c(Zt.$$.fragment),Ie=a(),Bt=r("table"),Bt.innerHTML=_n,Ve=a(),c(Wt.$$.fragment),ke=a(),Xt=r("table"),Xt.innerHTML=In,Ce=a(),c($t.$$.fragment),ze=a(),Gt=r("table"),Gt.innerHTML=Vn,He=a(),c(Rt.$$.fragment),Ee=a(),vt=r("table"),vt.innerHTML=kn,Ne=a(),c(St.$$.fragment),Fe=a(),_t=r("ul"),_t.innerHTML=Cn,Qe=a(),It=r("p"),It.innerHTML=zn,xe=a(),kt=r("p"),this.h()},l(t){const e=Yn("svelte-u9bgzb",document.head);f=s(e,"META",{name:!0,content:!0}),e.forEach(n),Ct=i(t),Vt=s(t,"P",{}),nn(Vt).forEach(n),zt=i(t),o(T.$$.fragment,t),Ht=i(t),w=s(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-15wmwhw"&&(w.innerHTML=an),Et=i(t),U=s(t,"OL",{"data-svelte-h":!0}),d(U)!=="svelte-19p82dc"&&(U.innerHTML=rn),Nt=i(t),j=s(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1u908i1"&&(j.textContent=sn),Ft=i(t),o(Z.$$.fragment,t),Qt=i(t),o(B.$$.fragment,t),xt=i(t),W=s(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1bb69gh"&&(W.innerHTML=dn),Yt=i(t),X=s(t,"P",{"data-svelte-h":!0}),d(X)!=="svelte-bz85s3"&&(X.innerHTML=cn),Lt=i(t),o($.$$.fragment,t),Dt=i(t),G=s(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-psbnvm"&&(G.innerHTML=on),At=i(t),R=s(t,"P",{"data-svelte-h":!0}),d(R)!=="svelte-oigu1u"&&(R.innerHTML=pn),qt=i(t),o(v.$$.fragment,t),Pt=i(t),o(S.$$.fragment,t),Kt=i(t),_=s(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1vjh5md"&&(_.innerHTML=gn),Ot=i(t),o(I.$$.fragment,t),te=i(t),V=s(t,"P",{"data-svelte-h":!0}),d(V)!=="svelte-mm2mnz"&&(V.innerHTML=mn),ee=i(t),k=s(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-19iy5vt"&&(k.textContent=hn),ne=i(t),C=s(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-yz7oqo"&&(C.innerHTML=Mn),le=i(t),o(z.$$.fragment,t),ae=i(t),H=s(t,"P",{"data-svelte-h":!0}),d(H)!=="svelte-km3nc0"&&(H.innerHTML=bn),ie=i(t),E=s(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-pe5bn7"&&(E.textContent=un),re=i(t),b=s(t,"DETAILS",{});var u=nn(b);o(N.$$.fragment,u),Le=i(u),o(F.$$.fragment,u),De=i(u),o(Q.$$.fragment,u),Ae=i(u),o(x.$$.fragment,u),qe=i(u),o(Y.$$.fragment,u),Pe=i(u),o(L.$$.fragment,u),Ke=i(u),o(D.$$.fragment,u),Oe=i(u),o(A.$$.fragment,u),tn=i(u),o(q.$$.fragment,u),en=i(u),o(P.$$.fragment,u),u.forEach(n),se=i(t),K=s(t,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1nx4h47"&&(K.innerHTML=yn),de=i(t),O=s(t,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1sjwyaz"&&(O.innerHTML=fn),ce=i(t),tt=s(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1zzsz7"&&(tt.innerHTML=Jn),oe=i(t),et=s(t,"P",{"data-svelte-h":!0}),d(et)!=="svelte-19p9vzv"&&(et.innerHTML=Tn),pe=i(t),nt=s(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-18iwyus"&&(nt.innerHTML=wn),ge=i(t),o(lt.$$.fragment,t),me=i(t),at=s(t,"TABLE",{"data-svelte-h":!0}),d(at)!=="svelte-14f48w"&&(at.innerHTML=Un),he=i(t),o(it.$$.fragment,t),Me=i(t),rt=s(t,"TABLE",{"data-svelte-h":!0}),d(rt)!=="svelte-19bbd89"&&(rt.innerHTML=jn),be=i(t),o(st.$$.fragment,t),ue=i(t),dt=s(t,"TABLE",{"data-svelte-h":!0}),d(dt)!=="svelte-cd9a2o"&&(dt.innerHTML=Zn),ye=i(t),o(ct.$$.fragment,t),fe=i(t),ot=s(t,"TABLE",{"data-svelte-h":!0}),d(ot)!=="svelte-9j8rj7"&&(ot.innerHTML=Bn),Je=i(t),o(pt.$$.fragment,t),Te=i(t),gt=s(t,"TABLE",{"data-svelte-h":!0}),d(gt)!=="svelte-1xs3uwi"&&(gt.innerHTML=Wn),we=i(t),o(mt.$$.fragment,t),Ue=i(t),ht=s(t,"TABLE",{"data-svelte-h":!0}),d(ht)!=="svelte-1elkjwp"&&(ht.innerHTML=Xn),je=i(t),o(Mt.$$.fragment,t),Ze=i(t),bt=s(t,"TABLE",{"data-svelte-h":!0}),d(bt)!=="svelte-sqqgka"&&(bt.innerHTML=$n),Be=i(t),o(ut.$$.fragment,t),We=i(t),yt=s(t,"TABLE",{"data-svelte-h":!0}),d(yt)!=="svelte-15f755w"&&(yt.innerHTML=Gn),Xe=i(t),o(ft.$$.fragment,t),$e=i(t),Jt=s(t,"TABLE",{"data-svelte-h":!0}),d(Jt)!=="svelte-uuno4d"&&(Jt.innerHTML=Rn),Ge=i(t),o(Tt.$$.fragment,t),Re=i(t),wt=s(t,"TABLE",{"data-svelte-h":!0}),d(wt)!=="svelte-1hbo08l"&&(wt.innerHTML=vn),ve=i(t),o(Ut.$$.fragment,t),Se=i(t),jt=s(t,"TABLE",{"data-svelte-h":!0}),d(jt)!=="svelte-abi9u4"&&(jt.innerHTML=Sn),_e=i(t),o(Zt.$$.fragment,t),Ie=i(t),Bt=s(t,"TABLE",{"data-svelte-h":!0}),d(Bt)!=="svelte-11m8i0f"&&(Bt.innerHTML=_n),Ve=i(t),o(Wt.$$.fragment,t),ke=i(t),Xt=s(t,"TABLE",{"data-svelte-h":!0}),d(Xt)!=="svelte-1i4s3fg"&&(Xt.innerHTML=In),Ce=i(t),o($t.$$.fragment,t),ze=i(t),Gt=s(t,"TABLE",{"data-svelte-h":!0}),d(Gt)!=="svelte-13cqeai"&&(Gt.innerHTML=Vn),He=i(t),o(Rt.$$.fragment,t),Ee=i(t),vt=s(t,"TABLE",{"data-svelte-h":!0}),d(vt)!=="svelte-16al08t"&&(vt.innerHTML=kn),Ne=i(t),o(St.$$.fragment,t),Fe=i(t),_t=s(t,"UL",{"data-svelte-h":!0}),d(_t)!=="svelte-1xg6qk7"&&(_t.innerHTML=Cn),Qe=i(t),It=s(t,"P",{"data-svelte-h":!0}),d(It)!=="svelte-7zliwv"&&(It.innerHTML=zn),xe=i(t),kt=s(t,"P",{}),nn(kt).forEach(n),this.h()},h(){Hn(f,"name","hf:doc:metadata"),Hn(f,"content",Dn)},m(t,e){y(document.head,f),l(t,Ct,e),l(t,Vt,e),l(t,zt,e),p(T,t,e),l(t,Ht,e),l(t,w,e),l(t,Et,e),l(t,U,e),l(t,Nt,e),l(t,j,e),l(t,Ft,e),p(Z,t,e),l(t,Qt,e),p(B,t,e),l(t,xt,e),l(t,W,e),l(t,Yt,e),l(t,X,e),l(t,Lt,e),p($,t,e),l(t,Dt,e),l(t,G,e),l(t,At,e),l(t,R,e),l(t,qt,e),p(v,t,e),l(t,Pt,e),p(S,t,e),l(t,Kt,e),l(t,_,e),l(t,Ot,e),p(I,t,e),l(t,te,e),l(t,V,e),l(t,ee,e),l(t,k,e),l(t,ne,e),l(t,C,e),l(t,le,e),p(z,t,e),l(t,ae,e),l(t,H,e),l(t,ie,e),l(t,E,e),l(t,re,e),l(t,b,e),p(N,b,null),y(b,Le),p(F,b,null),y(b,De),p(Q,b,null),y(b,Ae),p(x,b,null),y(b,qe),p(Y,b,null),y(b,Pe),p(L,b,null),y(b,Ke),p(D,b,null),y(b,Oe),p(A,b,null),y(b,tn),p(q,b,null),y(b,en),p(P,b,null),l(t,se,e),l(t,K,e),l(t,de,e),l(t,O,e),l(t,ce,e),l(t,tt,e),l(t,oe,e),l(t,et,e),l(t,pe,e),l(t,nt,e),l(t,ge,e),p(lt,t,e),l(t,me,e),l(t,at,e),l(t,he,e),p(it,t,e),l(t,Me,e),l(t,rt,e),l(t,be,e),p(st,t,e),l(t,ue,e),l(t,dt,e),l(t,ye,e),p(ct,t,e),l(t,fe,e),l(t,ot,e),l(t,Je,e),p(pt,t,e),l(t,Te,e),l(t,gt,e),l(t,we,e),p(mt,t,e),l(t,Ue,e),l(t,ht,e),l(t,je,e),p(Mt,t,e),l(t,Ze,e),l(t,bt,e),l(t,Be,e),p(ut,t,e),l(t,We,e),l(t,yt,e),l(t,Xe,e),p(ft,t,e),l(t,$e,e),l(t,Jt,e),l(t,Ge,e),p(Tt,t,e),l(t,Re,e),l(t,wt,e),l(t,ve,e),p(Ut,t,e),l(t,Se,e),l(t,jt,e),l(t,_e,e),p(Zt,t,e),l(t,Ie,e),l(t,Bt,e),l(t,Ve,e),p(Wt,t,e),l(t,ke,e),l(t,Xt,e),l(t,Ce,e),p($t,t,e),l(t,ze,e),l(t,Gt,e),l(t,He,e),p(Rt,t,e),l(t,Ee,e),l(t,vt,e),l(t,Ne,e),p(St,t,e),l(t,Fe,e),l(t,_t,e),l(t,Qe,e),l(t,It,e),l(t,xe,e),l(t,kt,e),Ye=!0},p:Nn,i(t){Ye||(g(T.$$.fragment,t),g(Z.$$.fragment,t),g(B.$$.fragment,t),g($.$$.fragment,t),g(v.$$.fragment,t),g(S.$$.fragment,t),g(I.$$.fragment,t),g(z.$$.fragment,t),g(N.$$.fragment,t),g(F.$$.fragment,t),g(Q.$$.fragment,t),g(x.$$.fragment,t),g(Y.$$.fragment,t),g(L.$$.fragment,t),g(D.$$.fragment,t),g(A.$$.fragment,t),g(q.$$.fragment,t),g(P.$$.fragment,t),g(lt.$$.fragment,t),g(it.$$.fragment,t),g(st.$$.fragment,t),g(ct.$$.fragment,t),g(pt.$$.fragment,t),g(mt.$$.fragment,t),g(Mt.$$.fragment,t),g(ut.$$.fragment,t),g(ft.$$.fragment,t),g(Tt.$$.fragment,t),g(Ut.$$.fragment,t),g(Zt.$$.fragment,t),g(Wt.$$.fragment,t),g($t.$$.fragment,t),g(Rt.$$.fragment,t),g(St.$$.fragment,t),Ye=!0)},o(t){m(T.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m($.$$.fragment,t),m(v.$$.fragment,t),m(S.$$.fragment,t),m(I.$$.fragment,t),m(z.$$.fragment,t),m(N.$$.fragment,t),m(F.$$.fragment,t),m(Q.$$.fragment,t),m(x.$$.fragment,t),m(Y.$$.fragment,t),m(L.$$.fragment,t),m(D.$$.fragment,t),m(A.$$.fragment,t),m(q.$$.fragment,t),m(P.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(st.$$.fragment,t),m(ct.$$.fragment,t),m(pt.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(Tt.$$.fragment,t),m(Ut.$$.fragment,t),m(Zt.$$.fragment,t),m(Wt.$$.fragment,t),m($t.$$.fragment,t),m(Rt.$$.fragment,t),m(St.$$.fragment,t),Ye=!1},d(t){t&&(n(Ct),n(Vt),n(zt),n(Ht),n(w),n(Et),n(U),n(Nt),n(j),n(Ft),n(Qt),n(xt),n(W),n(Yt),n(X),n(Lt),n(Dt),n(G),n(At),n(R),n(qt),n(Pt),n(Kt),n(_),n(Ot),n(te),n(V),n(ee),n(k),n(ne),n(C),n(le),n(ae),n(H),n(ie),n(E),n(re),n(b),n(se),n(K),n(de),n(O),n(ce),n(tt),n(oe),n(et),n(pe),n(nt),n(ge),n(me),n(at),n(he),n(Me),n(rt),n(be),n(ue),n(dt),n(ye),n(fe),n(ot),n(Je),n(Te),n(gt),n(we),n(Ue),n(ht),n(je),n(Ze),n(bt),n(Be),n(We),n(yt),n(Xe),n($e),n(Jt),n(Ge),n(Re),n(wt),n(ve),n(Se),n(jt),n(_e),n(Ie),n(Bt),n(Ve),n(ke),n(Xt),n(Ce),n(ze),n(Gt),n(He),n(Ee),n(vt),n(Ne),n(Fe),n(_t),n(Qe),n(It),n(xe),n(kt)),n(f),h(T,t),h(Z,t),h(B,t),h($,t),h(v,t),h(S,t),h(I,t),h(z,t),h(N),h(F),h(Q),h(x),h(Y),h(L),h(D),h(A),h(q),h(P),h(lt,t),h(it,t),h(st,t),h(ct,t),h(pt,t),h(mt,t),h(Mt,t),h(ut,t),h(ft,t),h(Tt,t),h(Ut,t),h(Zt,t),h(Wt,t),h($t,t),h(Rt,t),h(St,t)}}}const Dn='{"title":"PyTorch 2.0","local":"pytorch-20","sections":[{"title":"Scaled dot product attention","local":"scaled-dot-product-attention","sections":[],"depth":2},{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Benchmark","local":"benchmark","sections":[{"title":"Stable Diffusion text-to-image","local":"stable-diffusion-text-to-image","sections":[],"depth":3},{"title":"Stable Diffusion image-to-image","local":"stable-diffusion-image-to-image","sections":[],"depth":3},{"title":"Stable Diffusion inpainting","local":"stable-diffusion-inpainting","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"DeepFloyd IF text-to-image + upscaling","local":"deepfloyd-if-text-to-image--upscaling","sections":[],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 1)","local":"rtx-3090-batch-size-1","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 4)","local":"rtx-3090-batch-size-4","sections":[],"depth":3},{"title":"RTX 3090 (batch size: 16)","local":"rtx-3090-batch-size-16","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 1)","local":"rtx-4090-batch-size-1","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 4)","local":"rtx-4090-batch-size-4","sections":[],"depth":3},{"title":"RTX 4090 (batch size: 16)","local":"rtx-4090-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"Notes","local":"notes","sections":[],"depth":2}],"depth":1}';function An(ln){return Fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Qn{constructor(f){super(),xn(this,f,An,Ln,En,{})}}export{tl as component};
