import{s as Ee,o as ke,n as Ge}from"../chunks/scheduler.182ea377.js";import{S as Ie,i as He,g as r,s as n,r as d,A as Ce,h as p,f as s,c as a,j as Ze,u,x as o,k as ve,y as Xe,a as l,v as f,d as m,t as h,w as M}from"../chunks/index.abf12888.js";import{T as Pe}from"../chunks/Tip.230e2334.js";import{C as B}from"../chunks/CodeBlock.57fe6e13.js";import{H as fe}from"../chunks/Heading.16916d63.js";function Re(Q){let i,w='To learn more, take a look at the <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed Inference with 🤗 Accelerate</a> guide.';return{c(){i=r("p"),i.innerHTML=w},l(c){i=p(c,"P",{"data-svelte-h":!0}),o(i)!=="svelte-c8rg1s"&&(i.innerHTML=w)},m(c,A){l(c,i,A)},p:Ge,d(c){c&&s(i)}}}function We(Q){let i,w,c,A,j,Y,b,me='On distributed setups, you can run inference across multiple GPUs with 🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> or <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a>, which is useful for generating with multiple prompts in parallel.',x,J,he="This guide will show you how to use 🤗 Accelerate and PyTorch Distributed for distributed inference.",L,T,S,g,Me='🤗 <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> is a library designed to make it easy to train or run inference across distributed setups. It simplifies the process of setting up the distributed environment, allowing you to focus on your PyTorch code.',V,_,ye='To begin, create a Python file and initialize an <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> to create a distributed environment; your setup is automatically detected so you don’t need to explicitly define the <code>rank</code> or <code>world_size</code>. Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>distributed_state.device</code> to assign a GPU to each process.',q,U,we='Now use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',D,$,F,Z,je="Use the <code>--num_processes</code> argument to specify the number of GPUs to use, and call <code>accelerate launch</code> to run the script:",K,v,O,y,ee,E,te,k,be='PyTorch supports <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a> which enables data parallelism.',se,G,Je='To start, create a Python file and import <code>torch.distributed</code> and <code>torch.multiprocessing</code> to set up the distributed process group and to spawn the processes for inference on each GPU. You should also initialize a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',le,I,ne,H,Te='You’ll want to create a function to run inference; <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow"><code>init_process_group</code></a> handles creating a distributed environment with the type of backend to use, the <code>rank</code> of the current process, and the <code>world_size</code> or the number of processes participating. If you’re running inference in parallel over 2 GPUs, then the <code>world_size</code> is 2.',ae,C,ge='Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process, where each process handles a different prompt:',ie,X,re,P,_e='To run the distributed inference, call <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow"><code>mp.spawn</code></a> to run the <code>run_inference</code> function on the number of GPUs defined in <code>world_size</code>:',pe,R,oe,W,Ue="Once you’ve completed the inference script, use the <code>--nproc_per_node</code> argument to specify the number of GPUs to use and call <code>torchrun</code> to run the script:",ce,z,de,N,ue;return j=new fe({props:{title:"Distributed inference with multiple GPUs",local:"distributed-inference-with-multiple-gpus",headingTag:"h1"}}),T=new fe({props:{title:"🤗 Accelerate",local:"-accelerate",headingTag:"h2"}}),$=new B({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBZGlzdHJpYnV0ZWRfc3RhdGUlMjAlM0QlMjBQYXJ0aWFsU3RhdGUoKSUwQXBpcGVsaW5lLnRvKGRpc3RyaWJ1dGVkX3N0YXRlLmRldmljZSklMEElMEF3aXRoJTIwZGlzdHJpYnV0ZWRfc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyYSUyMGRvZyUyMiUyQyUyMCUyMmElMjBjYXQlMjIlNUQpJTIwYXMlMjBwcm9tcHQlM0ElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXN1bHQuc2F2ZShmJTIycmVzdWx0XyU3QmRpc3RyaWJ1dGVkX3N0YXRlLnByb2Nlc3NfaW5kZXglN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)

<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),v=new B({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),y=new Pe({props:{$$slots:{default:[Re]},$$scope:{ctx:Q}}}),E=new fe({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),I=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzZCUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

sd = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),X=new B({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBzZC50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    sd.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),R=new B({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),z=new B({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),{c(){i=r("meta"),w=n(),c=r("p"),A=n(),d(j.$$.fragment),Y=n(),b=r("p"),b.innerHTML=me,x=n(),J=r("p"),J.textContent=he,L=n(),d(T.$$.fragment),S=n(),g=r("p"),g.innerHTML=Me,V=n(),_=r("p"),_.innerHTML=ye,q=n(),U=r("p"),U.innerHTML=we,D=n(),d($.$$.fragment),F=n(),Z=r("p"),Z.innerHTML=je,K=n(),d(v.$$.fragment),O=n(),d(y.$$.fragment),ee=n(),d(E.$$.fragment),te=n(),k=r("p"),k.innerHTML=be,se=n(),G=r("p"),G.innerHTML=Je,le=n(),d(I.$$.fragment),ne=n(),H=r("p"),H.innerHTML=Te,ae=n(),C=r("p"),C.innerHTML=ge,ie=n(),d(X.$$.fragment),re=n(),P=r("p"),P.innerHTML=_e,pe=n(),d(R.$$.fragment),oe=n(),W=r("p"),W.innerHTML=Ue,ce=n(),d(z.$$.fragment),de=n(),N=r("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(s),w=a(e),c=p(e,"P",{}),Ze(c).forEach(s),A=a(e),u(j.$$.fragment,e),Y=a(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-a7bv7i"&&(b.innerHTML=me),x=a(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1qu3csy"&&(J.textContent=he),L=a(e),u(T.$$.fragment,e),S=a(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-13uq1g2"&&(g.innerHTML=Me),V=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-qwrp8g"&&(_.innerHTML=ye),q=a(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1iuwz8b"&&(U.innerHTML=we),D=a(e),u($.$$.fragment,e),F=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1ohh8as"&&(Z.innerHTML=je),K=a(e),u(v.$$.fragment,e),O=a(e),u(y.$$.fragment,e),ee=a(e),u(E.$$.fragment,e),te=a(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-jtiddl"&&(k.innerHTML=be),se=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-q18o27"&&(G.innerHTML=Je),le=a(e),u(I.$$.fragment,e),ne=a(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-qkdvuf"&&(H.innerHTML=Te),ae=a(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1rcgdqq"&&(C.innerHTML=ge),ie=a(e),u(X.$$.fragment,e),re=a(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1ecd3vq"&&(P.innerHTML=_e),pe=a(e),u(R.$$.fragment,e),oe=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-ykaora"&&(W.innerHTML=Ue),ce=a(e),u(z.$$.fragment,e),de=a(e),N=p(e,"P",{}),Ze(N).forEach(s),this.h()},h(){ve(i,"name","hf:doc:metadata"),ve(i,"content",ze)},m(e,t){Xe(document.head,i),l(e,w,t),l(e,c,t),l(e,A,t),f(j,e,t),l(e,Y,t),l(e,b,t),l(e,x,t),l(e,J,t),l(e,L,t),f(T,e,t),l(e,S,t),l(e,g,t),l(e,V,t),l(e,_,t),l(e,q,t),l(e,U,t),l(e,D,t),f($,e,t),l(e,F,t),l(e,Z,t),l(e,K,t),f(v,e,t),l(e,O,t),f(y,e,t),l(e,ee,t),f(E,e,t),l(e,te,t),l(e,k,t),l(e,se,t),l(e,G,t),l(e,le,t),f(I,e,t),l(e,ne,t),l(e,H,t),l(e,ae,t),l(e,C,t),l(e,ie,t),f(X,e,t),l(e,re,t),l(e,P,t),l(e,pe,t),f(R,e,t),l(e,oe,t),l(e,W,t),l(e,ce,t),f(z,e,t),l(e,de,t),l(e,N,t),ue=!0},p(e,[t]){const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),y.$set($e)},i(e){ue||(m(j.$$.fragment,e),m(T.$$.fragment,e),m($.$$.fragment,e),m(v.$$.fragment,e),m(y.$$.fragment,e),m(E.$$.fragment,e),m(I.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(z.$$.fragment,e),ue=!0)},o(e){h(j.$$.fragment,e),h(T.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(y.$$.fragment,e),h(E.$$.fragment,e),h(I.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(z.$$.fragment,e),ue=!1},d(e){e&&(s(w),s(c),s(A),s(Y),s(b),s(x),s(J),s(L),s(S),s(g),s(V),s(_),s(q),s(U),s(D),s(F),s(Z),s(K),s(O),s(ee),s(te),s(k),s(se),s(G),s(le),s(ne),s(H),s(ae),s(C),s(ie),s(re),s(P),s(pe),s(oe),s(W),s(ce),s(de),s(N)),s(i),M(j,e),M(T,e),M($,e),M(v,e),M(y,e),M(E,e),M(I,e),M(X,e),M(R,e),M(z,e)}}}const ze='{"title":"Distributed inference with multiple GPUs","local":"distributed-inference-with-multiple-gpus","sections":[{"title":"🤗 Accelerate","local":"-accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2}],"depth":1}';function Ae(Q){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends Ie{constructor(i){super(),He(this,i,Ae,We,Ee,{})}}export{Le as component};
