import{s as fe,n as be,o as Je}from"../chunks/scheduler.182ea377.js";import{S as he,i as ge,g as i,s as a,r as M,A as we,h as p,f as s,c as n,j as de,u as m,x as o,k as ye,y as je,a as t,v as r,d as c,t as u,w as d}from"../chunks/index.abf12888.js";import{C as b}from"../chunks/CodeBlock.57fe6e13.js";import{D as Te}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as y}from"../chunks/Heading.16916d63.js";function Ue(ql){let f,nl,tl,il,J,pl,h,ol,g,Al='<p><strong>For more information about community pipelines, please have a look at <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">this issue</a>.</strong></p>',Ml,w,Dl=`<strong>Community</strong> examples consist of both inference and training examples that have been added by the community.
Please have a look at the following table to get an overview of all community examples. Click on the <strong>Code Example</strong> to get a copy-and-paste ready code example that you can try out.
If a community doesn’t work as expected, please open an issue and ping the author on it.`,ml,j,Ll='<thead><tr><th align="left">Example</th> <th align="left">Description</th> <th align="left">Code Example</th> <th align="left">Colab</th> <th align="right">Author</th></tr></thead> <tbody><tr><td align="left">CLIP Guided Stable Diffusion</td> <td align="left">Doing CLIP guidance for text to image generation with Stable Diffusion</td> <td align="left"><a href="#clip-guided-stable-diffusion">CLIP Guided Stable Diffusion</a></td> <td align="left"><a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/CLIP_Guided_Stable_diffusion_with_diffusers.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a></td> <td align="right"><a href="https://github.com/patil-suraj/" rel="nofollow">Suraj Patil</a></td></tr> <tr><td align="left">One Step U-Net (Dummy)</td> <td align="left">Example showcasing of how to use Community Pipelines (see <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">https://github.com/huggingface/diffusers/issues/841</a>)</td> <td align="left"><a href="#one-step-unet">One Step U-Net</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/patrickvonplaten/" rel="nofollow">Patrick von Platen</a></td></tr> <tr><td align="left">Stable Diffusion Interpolation</td> <td align="left">Interpolate the latent space of Stable Diffusion between different prompts/seeds</td> <td align="left"><a href="#stable-diffusion-interpolation">Stable Diffusion Interpolation</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/nateraw/" rel="nofollow">Nate Raw</a></td></tr> <tr><td align="left">Stable Diffusion Mega</td> <td align="left"><strong>One</strong> Stable Diffusion Pipeline with all functionalities of <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py" rel="nofollow">Text2Image</a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py" rel="nofollow">Image2Image</a> and <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_inpaint.py" rel="nofollow">Inpainting</a></td> <td align="left"><a href="#stable-diffusion-mega">Stable Diffusion Mega</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/patrickvonplaten/" rel="nofollow">Patrick von Platen</a></td></tr> <tr><td align="left">Long Prompt Weighting Stable Diffusion</td> <td align="left"><strong>One</strong> Stable Diffusion Pipeline without tokens length limit, and support parsing weighting in prompt.</td> <td align="left"><a href="#long-prompt-weighting-stable-diffusion">Long Prompt Weighting Stable Diffusion</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/SkyTNT" rel="nofollow">SkyTNT</a></td></tr> <tr><td align="left">Speech to Image</td> <td align="left">Using automatic-speech-recognition to transcribe text and Stable Diffusion to generate images</td> <td align="left"><a href="#speech-to-image">Speech to Image</a></td> <td align="left">-</td> <td align="right"><a href="https://github.com/MikailINTech" rel="nofollow">Mikail Duzenli</a></td></tr></tbody>',rl,T,Pl="To load a custom pipeline you just need to pass the <code>custom_pipeline</code> argument to <code>DiffusionPipeline</code>, as one of the files in <code>diffusers/examples/community</code>. Feel free to send a PR with your own pipelines, we will merge them quickly.",cl,U,ul,Z,dl,W,yl,B,Kl=`CLIP guided stable diffusion can help to generate more realistic images
by guiding stable diffusion at every denoising step with an additional CLIP model.`,fl,G,Ol="The following code requires roughly 12GB of GPU RAM.",bl,I,Jl,k,le=`The <code>images</code> list contains a list of PIL images that can be saved locally or displayed directly in a google colab.
Generated images tend to be of higher qualtiy than natively using stable diffusion. E.g. the above script generates the following images:`,hl,C,ee='<img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/clip_guidance/merged_clip_guidance.jpg" alt="clip_guidance"/>.',gl,_,wl,X,se="The dummy “one-step-unet” can be run as follows:",jl,V,Tl,v,te='<strong>Note</strong>: This community pipeline is not useful as a feature, but rather just serves as an example of how community pipelines can be added (see <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">https://github.com/huggingface/diffusers/issues/841</a>).',Ul,R,Zl,E,ae="The following code can be run on a GPU of at least 8GB VRAM and should take approximately 5 minutes.",Wl,Q,Bl,x,ne="The output of the <code>walk(...)</code> function returns a list of images saved under the folder as defined in <code>output_dir</code>. You can use these images to create videos of stable diffusion.",Gl,Y,ie='<p><strong>Please have a look at <a href="https://github.com/nateraw/stable-diffusion-videos" rel="nofollow">https://github.com/nateraw/stable-diffusion-videos</a> for more in-detail information on how to create videos using stable diffusion as well as more feature-complete functionality.</strong></p>',Il,S,kl,N,pe="The Stable Diffusion Mega Pipeline lets you use the main use cases of the stable diffusion pipeline in a single class.",Cl,z,_l,F,oe="As shown above this one pipeline can run all both “text-to-image”, “image-to-image”, and “inpainting” in one pipeline.",Xl,$,Vl,H,Me=`The Pipeline lets you input prompt without 77 token length limit. And you can increase words weighting by using ”()” or decrease words weighting by using ”[]”
The Pipeline also lets you use the main use cases of the stable diffusion pipeline in a single class.`,vl,q,Rl,A,El,D,Ql,L,xl,P,me="if you see <code>Token indices sequence length is longer than the specified maximum sequence length for this model ( *** &gt; 77 ) . Running this sequence through the model will result in indexing errors</code>. Do not worry, it is normal.",Yl,K,Sl,O,re="The following code can generate an image from an audio sample using pre-trained OpenAI whisper-small and Stable Diffusion.",Nl,ll,zl,el,ce="This example produces the following image:",Fl,sl,ue='<img src="https://user-images.githubusercontent.com/45072645/196901736-77d9c6fc-63ee-4072-90b0-dc8b903d63e3.png" alt="image"/>',$l,al,Hl;return J=new y({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h1"}}),h=new Te({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_examples.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_examples.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_examples.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_examples.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_examples.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_examples.ipynb"}]}}),U=new b({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyZmlsZW5hbWVfaW5fdGhlX2NvbW11bml0eV9mb2xkZXIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;filename_in_the_community_folder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Z=new y({props:{title:"Example usages",local:"example-usages",headingTag:"h2"}}),W=new y({props:{title:"CLIP Guided Stable Diffusion",local:"clip-guided-stable-diffusion",headingTag:"h3"}}),I=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel
<span class="hljs-keyword">import</span> torch


feature_extractor = CLIPImageProcessor.from_pretrained(<span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>)
clip_model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>, torch_dtype=torch.float16)


guided_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
guided_pipeline.enable_attention_slicing()
guided_pipeline = guided_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;fantasy book cover, full moon, fantasy forest landscape, golden vector elements, fantasy magic, dark light night, intricate, elegant, sharp focus, illustration, highly detailed, digital painting, concept art, matte, art by WLOP and Artgerm and Albert Bierstadt, masterpiece&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = []
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
    image = guided_pipeline(
        prompt,
        num_inference_steps=<span class="hljs-number">50</span>,
        guidance_scale=<span class="hljs-number">7.5</span>,
        clip_guidance_scale=<span class="hljs-number">100</span>,
        num_cutouts=<span class="hljs-number">4</span>,
        use_cutouts=<span class="hljs-literal">False</span>,
        generator=generator,
    ).images[<span class="hljs-number">0</span>]
    images.append(image)

<span class="hljs-comment"># save images locally</span>
<span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
    img.save(<span class="hljs-string">f&quot;./clip_guided_sd/image_<span class="hljs-subst">{i}</span>.png&quot;</span>)`,wrap:!1}}),_=new y({props:{title:"One Step Unet",local:"one-step-unet",headingTag:"h3"}}),V=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJvbmVfc3RlcF91bmV0JTIyKSUwQXBpcGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;one_step_unet&quot;</span>)
pipe()`,wrap:!1}}),R=new y({props:{title:"Stable Diffusion Interpolation",local:"stable-diffusion-interpolation",headingTag:"h3"}}),Q=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMjAlMjAlMjMlMjBWZXJ5JTIwaW1wb3J0YW50JTIwZm9yJTIwdmlkZW9zLi4ubG90cyUyMG9mJTIwZmFsc2UlMjBwb3NpdGl2ZXMlMjB3aGlsZSUyMGludGVycG9sYXRpbmclMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJpbnRlcnBvbGF0ZV9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLmVuYWJsZV9hdHRlbnRpb25fc2xpY2luZygpJTBBJTBBZnJhbWVfZmlsZXBhdGhzJTIwJTNEJTIwcGlwZS53YWxrKCUwQSUyMCUyMCUyMCUyMHByb21wdHMlM0QlNUIlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiUyQyUyMCUyMmElMjBob3JzZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNlZWRzJTNEJTVCNDIlMkMlMjAxMzM3JTJDJTIwMTIzNCU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbnRlcnBvbGF0aW9uX3N0ZXBzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyLiUyRmRyZWFtcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDguNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># Very important for videos...lots of false positives while interpolating</span>
    custom_pipeline=<span class="hljs-string">&quot;interpolate_stable_diffusion&quot;</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.enable_attention_slicing()

frame_filepaths = pipe.walk(
    prompts=[<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a horse&quot;</span>],
    seeds=[<span class="hljs-number">42</span>, <span class="hljs-number">1337</span>, <span class="hljs-number">1234</span>],
    num_interpolation_steps=<span class="hljs-number">16</span>,
    output_dir=<span class="hljs-string">&quot;./dreams&quot;</span>,
    batch_size=<span class="hljs-number">4</span>,
    height=<span class="hljs-number">512</span>,
    width=<span class="hljs-number">512</span>,
    guidance_scale=<span class="hljs-number">8.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
)`,wrap:!1}}),S=new y({props:{title:"Stable Diffusion Mega",local:"stable-diffusion-mega",headingTag:"h3"}}),z=new b({props:{code:"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",highlighted:`<span class="hljs-comment">#!/usr/bin/env python3</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;stable_diffusion_mega&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.enable_attention_slicing()


<span class="hljs-comment">### Text-to-Image</span>

images = pipe.text2img(<span class="hljs-string">&quot;An astronaut riding a horse&quot;</span>).images

<span class="hljs-comment">### Image-to-Image</span>

init_image = download_image(
    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
)

prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

images = pipe.img2img(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images

<span class="hljs-comment">### Inpainting</span>

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;a cat sitting on a bench&quot;</span>
images = pipe.inpaint(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.75</span>).images`,wrap:!1}}),$=new y({props:{title:"Long Prompt Weighting Stable Diffusion",local:"long-prompt-weighting-stable-diffusion",headingTag:"h3"}}),q=new y({props:{title:"pytorch",local:"pytorch",headingTag:"h4"}}),A=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmhha3VyZWklMkZ3YWlmdS1kaWZmdXNpb24lMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJscHdfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJiZXN0X3F1YWxpdHklMjAoMWdpcmwlM0ExLjMpJTIwYm93JTIwYnJpZGUlMjBicm93bl9oYWlyJTIwY2xvc2VkX21vdXRoJTIwZnJpbGxlZF9ib3clMjBmcmlsbGVkX2hhaXJfdHViZXMlMjBmcmlsbHMlMjAoZnVsbF9ib2R5JTNBMS4zKSUyMGZveF9lYXIlMjBoYWlyX2JvdyUyMGhhaXJfdHViZXMlMjBoYXBweSUyMGhvb2QlMjBqYXBhbmVzZV9jbG90aGVzJTIwa2ltb25vJTIwbG9uZ19zbGVldmVzJTIwcmVkX2JvdyUyMHNtaWxlJTIwc29sbyUyMHRhYmklMjB1Y2hpa2FrZSUyMHdoaXRlX2tpbW9ubyUyMHdpZGVfc2xlZXZlcyUyMGNoZXJyeV9ibG9zc29tcyUyMiUwQW5lZ19wcm9tcHQlMjAlM0QlMjAlMjJsb3dyZXMlMkMlMjBiYWRfYW5hdG9teSUyQyUyMGVycm9yX2JvZHklMkMlMjBlcnJvcl9oYWlyJTJDJTIwZXJyb3JfYXJtJTJDJTIwZXJyb3JfaGFuZHMlMkMlMjBiYWRfaGFuZHMlMkMlMjBlcnJvcl9maW5nZXJzJTJDJTIwYmFkX2ZpbmdlcnMlMkMlMjBtaXNzaW5nX2ZpbmdlcnMlMkMlMjBlcnJvcl9sZWdzJTJDJTIwYmFkX2xlZ3MlMkMlMjBtdWx0aXBsZV9sZWdzJTJDJTIwbWlzc2luZ19sZWdzJTJDJTIwZXJyb3JfbGlnaHRpbmclMkMlMjBlcnJvcl9zaGFkb3clMkMlMjBlcnJvcl9yZWZsZWN0aW9uJTJDJTIwdGV4dCUyQyUyMGVycm9yJTJDJTIwZXh0cmFfZGlnaXQlMkMlMjBmZXdlcl9kaWdpdHMlMkMlMjBjcm9wcGVkJTJDJTIwd29yc3RfcXVhbGl0eSUyQyUyMGxvd19xdWFsaXR5JTJDJTIwbm9ybWFsX3F1YWxpdHklMkMlMjBqcGVnX2FydGlmYWN0cyUyQyUyMHNpZ25hdHVyZSUyQyUyMHdhdGVybWFyayUyQyUyMHVzZXJuYW1lJTJDJTIwYmx1cnJ5JTIyJTBBJTBBcGlwZS50ZXh0MmltZyhwcm9tcHQlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdfcHJvbXB0JTJDJTIwd2lkdGglM0Q1MTIlMkMlMjBoZWlnaHQlM0Q1MTIlMkMlMjBtYXhfZW1iZWRkaW5nc19tdWx0aXBsZXMlM0QzKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;hakurei/waifu-diffusion&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;best_quality (1girl:1.3) bow bride brown_hair closed_mouth frilled_bow frilled_hair_tubes frills (full_body:1.3) fox_ear hair_bow hair_tubes happy hood japanese_clothes kimono long_sleeves red_bow smile solo tabi uchikake white_kimono wide_sleeves cherry_blossoms&quot;</span>
neg_prompt = <span class="hljs-string">&quot;lowres, bad_anatomy, error_body, error_hair, error_arm, error_hands, bad_hands, error_fingers, bad_fingers, missing_fingers, error_legs, bad_legs, multiple_legs, missing_legs, error_lighting, error_shadow, error_reflection, text, error, extra_digit, fewer_digits, cropped, worst_quality, low_quality, normal_quality, jpeg_artifacts, signature, watermark, username, blurry&quot;</span>

pipe.text2img(prompt, negative_prompt=neg_prompt, width=<span class="hljs-number">512</span>, height=<span class="hljs-number">512</span>, max_embeddings_multiples=<span class="hljs-number">3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new y({props:{title:"onnxruntime",local:"onnxruntime",headingTag:"h4"}}),L=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJscHdfc3RhYmxlX2RpZmZ1c2lvbl9vbm54JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmV2aXNpb24lM0QlMjJvbm54JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJDVURBRXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMkMlMjBiZXN0JTIwcXVhbGl0eSUyMiUwQW5lZ19wcm9tcHQlMjAlM0QlMjAlMjJsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwZXJyb3IlMjBib2R5JTJDJTIwZXJyb3IlMjBoYWlyJTJDJTIwZXJyb3IlMjBhcm0lMkMlMjBlcnJvciUyMGhhbmRzJTJDJTIwYmFkJTIwaGFuZHMlMkMlMjBlcnJvciUyMGZpbmdlcnMlMkMlMjBiYWQlMjBmaW5nZXJzJTJDJTIwbWlzc2luZyUyMGZpbmdlcnMlMkMlMjBlcnJvciUyMGxlZ3MlMkMlMjBiYWQlMjBsZWdzJTJDJTIwbXVsdGlwbGUlMjBsZWdzJTJDJTIwbWlzc2luZyUyMGxlZ3MlMkMlMjBlcnJvciUyMGxpZ2h0aW5nJTJDJTIwZXJyb3IlMjBzaGFkb3clMkMlMjBlcnJvciUyMHJlZmxlY3Rpb24lMkMlMjB0ZXh0JTJDJTIwZXJyb3IlMkMlMjBleHRyYSUyMGRpZ2l0JTJDJTIwZmV3ZXIlMjBkaWdpdHMlMkMlMjBjcm9wcGVkJTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyQyUyMG5vcm1hbCUyMHF1YWxpdHklMkMlMjBqcGVnJTIwYXJ0aWZhY3RzJTJDJTIwc2lnbmF0dXJlJTJDJTIwd2F0ZXJtYXJrJTJDJTIwdXNlcm5hbWUlMkMlMjBibHVycnklMjIlMEElMEFwaXBlLnRleHQyaW1nKHByb21wdCUyQyUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ19wcm9tcHQlMkMlMjB3aWR0aCUzRDUxMiUyQyUyMGhlaWdodCUzRDUxMiUyQyUyMG1heF9lbWJlZGRpbmdzX211bHRpcGxlcyUzRDMpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion_onnx&quot;</span>,
    revision=<span class="hljs-string">&quot;onnx&quot;</span>,
    provider=<span class="hljs-string">&quot;CUDAExecutionProvider&quot;</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars, best quality&quot;</span>
neg_prompt = <span class="hljs-string">&quot;lowres, bad anatomy, error body, error hair, error arm, error hands, bad hands, error fingers, bad fingers, missing fingers, error legs, bad legs, multiple legs, missing legs, error lighting, error shadow, error reflection, text, error, extra digit, fewer digits, cropped, worst quality, low quality, normal quality, jpeg artifacts, signature, watermark, username, blurry&quot;</span>

pipe.text2img(prompt, negative_prompt=neg_prompt, width=<span class="hljs-number">512</span>, height=<span class="hljs-number">512</span>, max_embeddings_multiples=<span class="hljs-number">3</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),K=new y({props:{title:"Speech to Image",local:"speech-to-image",headingTag:"h3"}}),ll=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwV2hpc3BlclByb2Nlc3NvciUyQyUwQSklMEElMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEElMEFhdWRpb19zYW1wbGUlMjAlM0QlMjBkcyU1QjMlNUQlMEElMEF0ZXh0JTIwJTNEJTIwYXVkaW9fc2FtcGxlJTVCJTIydGV4dCUyMiU1RC5sb3dlcigpJTBBc3BlZWNoX2RhdGElMjAlM0QlMjBhdWRpb19zYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwV2hpc3BlclByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEElMEFkaWZmdXNlcl9waXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyc3BlZWNoX3RvX2ltYWdlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWVjaF9tb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwc3BlZWNoX3Byb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBZGlmZnVzZXJfcGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFkaWZmdXNlcl9waXBlbGluZSUyMCUzRCUyMGRpZmZ1c2VyX3BpcGVsaW5lLnRvKGRldmljZSklMEElMEFvdXRwdXQlMjAlM0QlMjBkaWZmdXNlcl9waXBlbGluZShzcGVlY2hfZGF0YSklMEFwbHQuaW1zaG93KG91dHB1dC5pbWFnZXMlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    WhisperForConditionalGeneration,
    WhisperProcessor,
)


device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)

audio_sample = ds[<span class="hljs-number">3</span>]

text = audio_sample[<span class="hljs-string">&quot;text&quot;</span>].lower()
speech_data = audio_sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>).to(device)
processor = WhisperProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

diffuser_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;speech_to_image_diffusion&quot;</span>,
    speech_model=model,
    speech_processor=processor,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

diffuser_pipeline.enable_attention_slicing()
diffuser_pipeline = diffuser_pipeline.to(device)

output = diffuser_pipeline(speech_data)
plt.imshow(output.images[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){f=i("meta"),nl=a(),tl=i("p"),il=a(),M(J.$$.fragment),pl=a(),M(h.$$.fragment),ol=a(),g=i("blockquote"),g.innerHTML=Al,Ml=a(),w=i("p"),w.innerHTML=Dl,ml=a(),j=i("table"),j.innerHTML=Ll,rl=a(),T=i("p"),T.innerHTML=Pl,cl=a(),M(U.$$.fragment),ul=a(),M(Z.$$.fragment),dl=a(),M(W.$$.fragment),yl=a(),B=i("p"),B.textContent=Kl,fl=a(),G=i("p"),G.textContent=Ol,bl=a(),M(I.$$.fragment),Jl=a(),k=i("p"),k.innerHTML=le,hl=a(),C=i("p"),C.innerHTML=ee,gl=a(),M(_.$$.fragment),wl=a(),X=i("p"),X.textContent=se,jl=a(),M(V.$$.fragment),Tl=a(),v=i("p"),v.innerHTML=te,Ul=a(),M(R.$$.fragment),Zl=a(),E=i("p"),E.textContent=ae,Wl=a(),M(Q.$$.fragment),Bl=a(),x=i("p"),x.innerHTML=ne,Gl=a(),Y=i("blockquote"),Y.innerHTML=ie,Il=a(),M(S.$$.fragment),kl=a(),N=i("p"),N.textContent=pe,Cl=a(),M(z.$$.fragment),_l=a(),F=i("p"),F.textContent=oe,Xl=a(),M($.$$.fragment),Vl=a(),H=i("p"),H.textContent=Me,vl=a(),M(q.$$.fragment),Rl=a(),M(A.$$.fragment),El=a(),M(D.$$.fragment),Ql=a(),M(L.$$.fragment),xl=a(),P=i("p"),P.innerHTML=me,Yl=a(),M(K.$$.fragment),Sl=a(),O=i("p"),O.textContent=re,Nl=a(),M(ll.$$.fragment),zl=a(),el=i("p"),el.textContent=ce,Fl=a(),sl=i("p"),sl.innerHTML=ue,$l=a(),al=i("p"),this.h()},l(l){const e=we("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(s),nl=n(l),tl=p(l,"P",{}),de(tl).forEach(s),il=n(l),m(J.$$.fragment,l),pl=n(l),m(h.$$.fragment,l),ol=n(l),g=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(g)!=="svelte-1625cc9"&&(g.innerHTML=Al),Ml=n(l),w=p(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-s6c6cu"&&(w.innerHTML=Dl),ml=n(l),j=p(l,"TABLE",{"data-svelte-h":!0}),o(j)!=="svelte-drxtou"&&(j.innerHTML=Ll),rl=n(l),T=p(l,"P",{"data-svelte-h":!0}),o(T)!=="svelte-zz3olk"&&(T.innerHTML=Pl),cl=n(l),m(U.$$.fragment,l),ul=n(l),m(Z.$$.fragment,l),dl=n(l),m(W.$$.fragment,l),yl=n(l),B=p(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1auoru7"&&(B.textContent=Kl),fl=n(l),G=p(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-13ji4fm"&&(G.textContent=Ol),bl=n(l),m(I.$$.fragment,l),Jl=n(l),k=p(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-k0w204"&&(k.innerHTML=le),hl=n(l),C=p(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-rgrio8"&&(C.innerHTML=ee),gl=n(l),m(_.$$.fragment,l),wl=n(l),X=p(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1woju3k"&&(X.textContent=se),jl=n(l),m(V.$$.fragment,l),Tl=n(l),v=p(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-akro5r"&&(v.innerHTML=te),Ul=n(l),m(R.$$.fragment,l),Zl=n(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-bgpjoj"&&(E.textContent=ae),Wl=n(l),m(Q.$$.fragment,l),Bl=n(l),x=p(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1na1qtx"&&(x.innerHTML=ne),Gl=n(l),Y=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Y)!=="svelte-1mkc989"&&(Y.innerHTML=ie),Il=n(l),m(S.$$.fragment,l),kl=n(l),N=p(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-53qzlx"&&(N.textContent=pe),Cl=n(l),m(z.$$.fragment,l),_l=n(l),F=p(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1oozv83"&&(F.textContent=oe),Xl=n(l),m($.$$.fragment,l),Vl=n(l),H=p(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-yjvgbi"&&(H.textContent=Me),vl=n(l),m(q.$$.fragment,l),Rl=n(l),m(A.$$.fragment,l),El=n(l),m(D.$$.fragment,l),Ql=n(l),m(L.$$.fragment,l),xl=n(l),P=p(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-lrjnmf"&&(P.innerHTML=me),Yl=n(l),m(K.$$.fragment,l),Sl=n(l),O=p(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1lzt21l"&&(O.textContent=re),Nl=n(l),m(ll.$$.fragment,l),zl=n(l),el=p(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-12u9q20"&&(el.textContent=ce),Fl=n(l),sl=p(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-pca3uz"&&(sl.innerHTML=ue),$l=n(l),al=p(l,"P",{}),de(al).forEach(s),this.h()},h(){ye(f,"name","hf:doc:metadata"),ye(f,"content",Ze)},m(l,e){je(document.head,f),t(l,nl,e),t(l,tl,e),t(l,il,e),r(J,l,e),t(l,pl,e),r(h,l,e),t(l,ol,e),t(l,g,e),t(l,Ml,e),t(l,w,e),t(l,ml,e),t(l,j,e),t(l,rl,e),t(l,T,e),t(l,cl,e),r(U,l,e),t(l,ul,e),r(Z,l,e),t(l,dl,e),r(W,l,e),t(l,yl,e),t(l,B,e),t(l,fl,e),t(l,G,e),t(l,bl,e),r(I,l,e),t(l,Jl,e),t(l,k,e),t(l,hl,e),t(l,C,e),t(l,gl,e),r(_,l,e),t(l,wl,e),t(l,X,e),t(l,jl,e),r(V,l,e),t(l,Tl,e),t(l,v,e),t(l,Ul,e),r(R,l,e),t(l,Zl,e),t(l,E,e),t(l,Wl,e),r(Q,l,e),t(l,Bl,e),t(l,x,e),t(l,Gl,e),t(l,Y,e),t(l,Il,e),r(S,l,e),t(l,kl,e),t(l,N,e),t(l,Cl,e),r(z,l,e),t(l,_l,e),t(l,F,e),t(l,Xl,e),r($,l,e),t(l,Vl,e),t(l,H,e),t(l,vl,e),r(q,l,e),t(l,Rl,e),r(A,l,e),t(l,El,e),r(D,l,e),t(l,Ql,e),r(L,l,e),t(l,xl,e),t(l,P,e),t(l,Yl,e),r(K,l,e),t(l,Sl,e),t(l,O,e),t(l,Nl,e),r(ll,l,e),t(l,zl,e),t(l,el,e),t(l,Fl,e),t(l,sl,e),t(l,$l,e),t(l,al,e),Hl=!0},p:be,i(l){Hl||(c(J.$$.fragment,l),c(h.$$.fragment,l),c(U.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(I.$$.fragment,l),c(_.$$.fragment,l),c(V.$$.fragment,l),c(R.$$.fragment,l),c(Q.$$.fragment,l),c(S.$$.fragment,l),c(z.$$.fragment,l),c($.$$.fragment,l),c(q.$$.fragment,l),c(A.$$.fragment,l),c(D.$$.fragment,l),c(L.$$.fragment,l),c(K.$$.fragment,l),c(ll.$$.fragment,l),Hl=!0)},o(l){u(J.$$.fragment,l),u(h.$$.fragment,l),u(U.$$.fragment,l),u(Z.$$.fragment,l),u(W.$$.fragment,l),u(I.$$.fragment,l),u(_.$$.fragment,l),u(V.$$.fragment,l),u(R.$$.fragment,l),u(Q.$$.fragment,l),u(S.$$.fragment,l),u(z.$$.fragment,l),u($.$$.fragment,l),u(q.$$.fragment,l),u(A.$$.fragment,l),u(D.$$.fragment,l),u(L.$$.fragment,l),u(K.$$.fragment,l),u(ll.$$.fragment,l),Hl=!1},d(l){l&&(s(nl),s(tl),s(il),s(pl),s(ol),s(g),s(Ml),s(w),s(ml),s(j),s(rl),s(T),s(cl),s(ul),s(dl),s(yl),s(B),s(fl),s(G),s(bl),s(Jl),s(k),s(hl),s(C),s(gl),s(wl),s(X),s(jl),s(Tl),s(v),s(Ul),s(Zl),s(E),s(Wl),s(Bl),s(x),s(Gl),s(Y),s(Il),s(kl),s(N),s(Cl),s(_l),s(F),s(Xl),s(Vl),s(H),s(vl),s(Rl),s(El),s(Ql),s(xl),s(P),s(Yl),s(Sl),s(O),s(Nl),s(zl),s(el),s(Fl),s(sl),s($l),s(al)),s(f),d(J,l),d(h,l),d(U,l),d(Z,l),d(W,l),d(I,l),d(_,l),d(V,l),d(R,l),d(Q,l),d(S,l),d(z,l),d($,l),d(q,l),d(A,l),d(D,l),d(L,l),d(K,l),d(ll,l)}}}const Ze='{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Example usages","local":"example-usages","sections":[{"title":"CLIP Guided Stable Diffusion","local":"clip-guided-stable-diffusion","sections":[],"depth":3},{"title":"One Step Unet","local":"one-step-unet","sections":[],"depth":3},{"title":"Stable Diffusion Interpolation","local":"stable-diffusion-interpolation","sections":[],"depth":3},{"title":"Stable Diffusion Mega","local":"stable-diffusion-mega","sections":[],"depth":3},{"title":"Long Prompt Weighting Stable Diffusion","local":"long-prompt-weighting-stable-diffusion","sections":[{"title":"pytorch","local":"pytorch","sections":[],"depth":4},{"title":"onnxruntime","local":"onnxruntime","sections":[],"depth":4}],"depth":3},{"title":"Speech to Image","local":"speech-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function We(ql){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends he{constructor(f){super(),ge(this,f,We,Ue,fe,{})}}export{_e as component};
