import{s as Ot,o as Kt,n as O}from"../chunks/scheduler.182ea377.js";import{S as en,i as tn,g as l,s,r as y,A as nn,h as d,f as p,c as a,j as J,u as v,x as h,k,y as o,a as _,v as w,d as x,t as D,w as $}from"../chunks/index.abf12888.js";import{T as St}from"../chunks/Tip.230e2334.js";import{D as L}from"../chunks/Docstring.93f6f462.js";import{C as Le}from"../chunks/CodeBlock.57fe6e13.js";import{E as Ze}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Jt}from"../chunks/Heading.16916d63.js";function on(I){let n,b='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',r,i,m='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=l("p"),n.innerHTML=b,r=s(),i=l("p"),i.innerHTML=m},l(t){n=d(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1ue9xpl"&&(n.innerHTML=b),r=a(t),i=d(t,"P",{"data-svelte-h":!0}),h(i)!=="svelte-z4pn9c"&&(i.innerHTML=m)},m(t,u){_(t,n,u),_(t,r,u),_(t,i,u)},p:O,d(t){t&&(p(n),p(r),p(i))}}}function sn(I){let n,b="Examples:",r,i,m;return i=new Le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25EZXB0aDJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItZGVwdGglMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQXByb21wdCUyMCUzRCUyMCUyMnR3byUyMHRpZ2VycyUyMiUwQW5fcHJvcG10JTIwJTNEJTIwJTIyYmFkJTJDJTIwZGVmb3JtZWQlMkMlMjB1Z2x5JTJDJTIwYmFkJTIwYW5vdG9teSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuX3Byb3BtdCUyQyUyMHN0cmVuZ3RoJTNEMC43KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDepth2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionDepth2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-depth&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;two tigers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_propmt = <span class="hljs-string">&quot;bad, deformed, ugly, bad anotomy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=init_image, negative_prompt=n_propmt, strength=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=b,r=s(),y(i.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=a(t),v(i.$$.fragment,t)},m(t,u){_(t,n,u),_(t,r,u),w(i,t,u),m=!0},p:O,i(t){m||(x(i.$$.fragment,t),m=!0)},o(t){D(i.$$.fragment,t),m=!1},d(t){t&&(p(n),p(r)),$(i,t)}}}function an(I){let n,b=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=l("p"),n.innerHTML=b},l(r){n=d(r,"P",{"data-svelte-h":!0}),h(n)!=="svelte-ackzsn"&&(n.innerHTML=b)},m(r,i){_(r,n,i)},p:O,d(r){r&&p(n)}}}function rn(I){let n,b="Examples:",r,i,m;return i=new Le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=l("p"),n.textContent=b,r=s(),y(i.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=a(t),v(i.$$.fragment,t)},m(t,u){_(t,n,u),_(t,r,u),w(i,t,u),m=!0},p:O,i(t){m||(x(i.$$.fragment,t),m=!0)},o(t){D(i.$$.fragment,t),m=!1},d(t){t&&(p(n),p(r)),$(i,t)}}}function ln(I){let n,b=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=l("p"),n.textContent=b},l(r){n=d(r,"P",{"data-svelte-h":!0}),h(n)!=="svelte-17p1lpg"&&(n.textContent=b)},m(r,i){_(r,n,i)},p:O,d(r){r&&p(n)}}}function dn(I){let n,b="Examples:",r,i,m;return i=new Le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=b,r=s(),y(i.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-kvfsh7"&&(n.textContent=b),r=a(t),v(i.$$.fragment,t)},m(t,u){_(t,n,u),_(t,r,u),w(i,t,u),m=!0},p:O,i(t){m||(x(i.$$.fragment,t),m=!0)},o(t){D(i.$$.fragment,t),m=!1},d(t){t&&(p(n),p(r)),$(i,t)}}}function pn(I){let n,b="To load a textual inversion embedding vector in 🤗 Diffusers format:",r,i,m;return i=new Le({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=b,r=s(),y(i.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1y13ww6"&&(n.textContent=b),r=a(t),v(i.$$.fragment,t)},m(t,u){_(t,n,u),_(t,r,u),w(i,t,u),m=!0},p:O,i(t){m||(x(i.$$.fragment,t),m=!0)},o(t){D(i.$$.fragment,t),m=!1},d(t){t&&(p(n),p(r)),$(i,t)}}}function cn(I){let n,b="locally:",r,i,m;return i=new Le({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=l("p"),n.textContent=b,r=s(),y(i.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-4c75kq"&&(n.textContent=b),r=a(t),v(i.$$.fragment,t)},m(t,u){_(t,n,u),_(t,r,u),w(i,t,u),m=!0},p:O,i(t){m||(x(i.$$.fragment,t),m=!0)},o(t){D(i.$$.fragment,t),m=!1},d(t){t&&(p(n),p(r)),$(i,t)}}}function mn(I){let n,b,r,i,m,t,u,kt='The Stable Diffusion model can also infer depth based on an image using <a href="https://github.com/isl-org/MiDaS" rel="nofollow">MiDas</a>. This allows you to pass a text prompt and an initial image to condition the generation of new images as well as a <code>depth_map</code> to preserve the image structure.',We,F,Ne,K,Ge,f,ee,Ye,ue,Ut="Pipeline for text-guided depth-based image-to-image generation using Stable Diffusion.",Ve,ge,Ct=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,qe,he,jt="The pipeline also inherits the following loading methods:",Ae,_e,Zt='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',Qe,W,te,Oe,be,Lt="The call function to the pipeline for generation.",Ke,R,et,U,ne,tt,ye,Wt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,nt,E,ot,B,it,X,oe,st,ve,Nt=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,at,C,ie,rt,we,Gt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,lt,H,dt,z,pt,Y,se,ct,xe,Ft='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',mt,T,ae,ft,De,Rt=`Load textual inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,ut,$e,Et="Example:",gt,V,ht,Ie,Bt=`To load a textual inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,_t,q,bt,M,re,yt,Te,Xt=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,vt,Me,Ht="All kwargs are forwarded to <code>self.lora_state_dict</code>.",wt,Pe,zt='See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',xt,Se,Yt=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Dt,Je,Vt=`See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,$t,A,le,It,ke,qt="Save the LoRA parameters corresponding to the UNet and text encoder.",Tt,Q,de,Mt,Ue,At="Encodes the prompt into text encoder hidden states.",Fe,pe,Re,N,ce,Pt,Ce,Qt="Output class for Stable Diffusion pipelines.",Ee,je,Be;return m=new Jt({props:{title:"Depth-to-image",local:"depth-to-image",headingTag:"h1"}}),F=new St({props:{$$slots:{default:[on]},$$scope:{ctx:I}}}),K=new Jt({props:{title:"StableDiffusionDepth2ImgPipeline",local:"diffusers.StableDiffusionDepth2ImgPipeline",headingTag:"h2"}}),ee=new L({props:{name:"class diffusers.StableDiffusionDepth2ImgPipeline",anchor:"diffusers.StableDiffusionDepth2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"depth_estimator",val:": DPTForDepthEstimation"},{name:"feature_extractor",val:": DPTFeatureExtractor"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_depth2img.py#L63"}}),te=new L({props:{name:"__call__",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.FloatTensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.FloatTensor]] = None"},{name:"depth_map",val:": typing.Optional[torch.FloatTensor] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": typing.Optional[int] = 50"},{name:"guidance_scale",val:": typing.Optional[float] = 7.5"},{name:"negative_prompt",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": typing.Optional[float] = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be used as the starting point. Can accept image
latents as <code>image</code> only if <code>depth_map</code> is not <code>None</code>.`,name:"image"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.depth_map",description:`<strong>depth_map</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Depth prediction to be used as additional conditioning for the image generation process. If not
defined, it automatically predicts the depth with <code>self.depth_estimator</code>.`,name:"depth_map"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_depth2img.py#L548",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),R=new Ze({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.__call__.example",$$slots:{default:[sn]},$$scope:{ctx:I}}}),ne=new L({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1925"}}),E=new St({props:{warning:!0,$$slots:{default:[an]},$$scope:{ctx:I}}}),B=new Ze({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[rn]},$$scope:{ctx:I}}}),oe=new L({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1965"}}),ie=new L({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),H=new St({props:{warning:!0,$$slots:{default:[ln]},$$scope:{ctx:I}}}),z=new Ze({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[dn]},$$scope:{ctx:I}}}),se=new L({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1899"}}),ae=new L({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L984"}}),V=new Ze({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.example",$$slots:{default:[pn]},$$scope:{ctx:I}}}),q=new Ze({props:{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[cn]},$$scope:{ctx:I}}}),re=new L({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1173"}}),le=new L({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders.py#L1964"}}),de=new L({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionDepth2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_depth2img.py#L169"}}),pe=new Jt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ce=new L({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),{c(){n=l("meta"),b=s(),r=l("p"),i=s(),y(m.$$.fragment),t=s(),u=l("p"),u.innerHTML=kt,We=s(),y(F.$$.fragment),Ne=s(),y(K.$$.fragment),Ge=s(),f=l("div"),y(ee.$$.fragment),Ye=s(),ue=l("p"),ue.textContent=Ut,Ve=s(),ge=l("p"),ge.innerHTML=Ct,qe=s(),he=l("p"),he.textContent=jt,Ae=s(),_e=l("ul"),_e.innerHTML=Zt,Qe=s(),W=l("div"),y(te.$$.fragment),Oe=s(),be=l("p"),be.textContent=Lt,Ke=s(),y(R.$$.fragment),et=s(),U=l("div"),y(ne.$$.fragment),tt=s(),ye=l("p"),ye.textContent=Wt,nt=s(),y(E.$$.fragment),ot=s(),y(B.$$.fragment),it=s(),X=l("div"),y(oe.$$.fragment),st=s(),ve=l("p"),ve.innerHTML=Nt,at=s(),C=l("div"),y(ie.$$.fragment),rt=s(),we=l("p"),we.innerHTML=Gt,lt=s(),y(H.$$.fragment),dt=s(),y(z.$$.fragment),pt=s(),Y=l("div"),y(se.$$.fragment),ct=s(),xe=l("p"),xe.innerHTML=Ft,mt=s(),T=l("div"),y(ae.$$.fragment),ft=s(),De=l("p"),De.innerHTML=Rt,ut=s(),$e=l("p"),$e.textContent=Et,gt=s(),y(V.$$.fragment),ht=s(),Ie=l("p"),Ie.innerHTML=Bt,_t=s(),y(q.$$.fragment),bt=s(),M=l("div"),y(re.$$.fragment),yt=s(),Te=l("p"),Te.innerHTML=Xt,vt=s(),Me=l("p"),Me.innerHTML=Ht,wt=s(),Pe=l("p"),Pe.innerHTML=zt,xt=s(),Se=l("p"),Se.innerHTML=Yt,Dt=s(),Je=l("p"),Je.innerHTML=Vt,$t=s(),A=l("div"),y(le.$$.fragment),It=s(),ke=l("p"),ke.textContent=qt,Tt=s(),Q=l("div"),y(de.$$.fragment),Mt=s(),Ue=l("p"),Ue.textContent=At,Fe=s(),y(pe.$$.fragment),Re=s(),N=l("div"),y(ce.$$.fragment),Pt=s(),Ce=l("p"),Ce.textContent=Qt,Ee=s(),je=l("p"),this.h()},l(e){const c=nn("svelte-u9bgzb",document.head);n=d(c,"META",{name:!0,content:!0}),c.forEach(p),b=a(e),r=d(e,"P",{}),J(r).forEach(p),i=a(e),v(m.$$.fragment,e),t=a(e),u=d(e,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1j9qpq3"&&(u.innerHTML=kt),We=a(e),v(F.$$.fragment,e),Ne=a(e),v(K.$$.fragment,e),Ge=a(e),f=d(e,"DIV",{class:!0});var g=J(f);v(ee.$$.fragment,g),Ye=a(g),ue=d(g,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1fmvafp"&&(ue.textContent=Ut),Ve=a(g),ge=d(g,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-496sm0"&&(ge.innerHTML=Ct),qe=a(g),he=d(g,"P",{"data-svelte-h":!0}),h(he)!=="svelte-14s6m4u"&&(he.textContent=jt),Ae=a(g),_e=d(g,"UL",{"data-svelte-h":!0}),h(_e)!=="svelte-omhkhg"&&(_e.innerHTML=Zt),Qe=a(g),W=d(g,"DIV",{class:!0});var G=J(W);v(te.$$.fragment,G),Oe=a(G),be=d(G,"P",{"data-svelte-h":!0}),h(be)!=="svelte-50j04k"&&(be.textContent=Lt),Ke=a(G),v(R.$$.fragment,G),G.forEach(p),et=a(g),U=d(g,"DIV",{class:!0});var j=J(U);v(ne.$$.fragment,j),tt=a(j),ye=d(j,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-10jaql7"&&(ye.textContent=Wt),nt=a(j),v(E.$$.fragment,j),ot=a(j),v(B.$$.fragment,j),j.forEach(p),it=a(g),X=d(g,"DIV",{class:!0});var me=J(X);v(oe.$$.fragment,me),st=a(me),ve=d(me,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1lh0nh5"&&(ve.innerHTML=Nt),me.forEach(p),at=a(g),C=d(g,"DIV",{class:!0});var Z=J(C);v(ie.$$.fragment,Z),rt=a(Z),we=d(Z,"P",{"data-svelte-h":!0}),h(we)!=="svelte-e03q3e"&&(we.innerHTML=Gt),lt=a(Z),v(H.$$.fragment,Z),dt=a(Z),v(z.$$.fragment,Z),Z.forEach(p),pt=a(g),Y=d(g,"DIV",{class:!0});var fe=J(Y);v(se.$$.fragment,fe),ct=a(fe),xe=d(fe,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-1vfte1e"&&(xe.innerHTML=Ft),fe.forEach(p),mt=a(g),T=d(g,"DIV",{class:!0});var P=J(T);v(ae.$$.fragment,P),ft=a(P),De=d(P,"P",{"data-svelte-h":!0}),h(De)!=="svelte-617c7s"&&(De.innerHTML=Rt),ut=a(P),$e=d(P,"P",{"data-svelte-h":!0}),h($e)!=="svelte-11lpom8"&&($e.textContent=Et),gt=a(P),v(V.$$.fragment,P),ht=a(P),Ie=d(P,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-2gddoh"&&(Ie.innerHTML=Bt),_t=a(P),v(q.$$.fragment,P),P.forEach(p),bt=a(g),M=d(g,"DIV",{class:!0});var S=J(M);v(re.$$.fragment,S),yt=a(S),Te=d(S,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-vs7s0z"&&(Te.innerHTML=Xt),vt=a(S),Me=d(S,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-15b960v"&&(Me.innerHTML=Ht),wt=a(S),Pe=d(S,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-qj05o3"&&(Pe.innerHTML=zt),xt=a(S),Se=d(S,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-ot29jq"&&(Se.innerHTML=Yt),Dt=a(S),Je=d(S,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-1ah097o"&&(Je.innerHTML=Vt),S.forEach(p),$t=a(g),A=d(g,"DIV",{class:!0});var Xe=J(A);v(le.$$.fragment,Xe),It=a(Xe),ke=d(Xe,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-1ufq5ot"&&(ke.textContent=qt),Xe.forEach(p),Tt=a(g),Q=d(g,"DIV",{class:!0});var He=J(Q);v(de.$$.fragment,He),Mt=a(He),Ue=d(He,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-16q0ax1"&&(Ue.textContent=At),He.forEach(p),g.forEach(p),Fe=a(e),v(pe.$$.fragment,e),Re=a(e),N=d(e,"DIV",{class:!0});var ze=J(N);v(ce.$$.fragment,ze),Pt=a(ze),Ce=d(ze,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1qpjiuf"&&(Ce.textContent=Qt),ze.forEach(p),Ee=a(e),je=d(e,"P",{}),J(je).forEach(p),this.h()},h(){k(n,"name","hf:doc:metadata"),k(n,"content",fn),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){o(document.head,n),_(e,b,c),_(e,r,c),_(e,i,c),w(m,e,c),_(e,t,c),_(e,u,c),_(e,We,c),w(F,e,c),_(e,Ne,c),w(K,e,c),_(e,Ge,c),_(e,f,c),w(ee,f,null),o(f,Ye),o(f,ue),o(f,Ve),o(f,ge),o(f,qe),o(f,he),o(f,Ae),o(f,_e),o(f,Qe),o(f,W),w(te,W,null),o(W,Oe),o(W,be),o(W,Ke),w(R,W,null),o(f,et),o(f,U),w(ne,U,null),o(U,tt),o(U,ye),o(U,nt),w(E,U,null),o(U,ot),w(B,U,null),o(f,it),o(f,X),w(oe,X,null),o(X,st),o(X,ve),o(f,at),o(f,C),w(ie,C,null),o(C,rt),o(C,we),o(C,lt),w(H,C,null),o(C,dt),w(z,C,null),o(f,pt),o(f,Y),w(se,Y,null),o(Y,ct),o(Y,xe),o(f,mt),o(f,T),w(ae,T,null),o(T,ft),o(T,De),o(T,ut),o(T,$e),o(T,gt),w(V,T,null),o(T,ht),o(T,Ie),o(T,_t),w(q,T,null),o(f,bt),o(f,M),w(re,M,null),o(M,yt),o(M,Te),o(M,vt),o(M,Me),o(M,wt),o(M,Pe),o(M,xt),o(M,Se),o(M,Dt),o(M,Je),o(f,$t),o(f,A),w(le,A,null),o(A,It),o(A,ke),o(f,Tt),o(f,Q),w(de,Q,null),o(Q,Mt),o(Q,Ue),_(e,Fe,c),w(pe,e,c),_(e,Re,c),_(e,N,c),w(ce,N,null),o(N,Pt),o(N,Ce),_(e,Ee,c),_(e,je,c),Be=!0},p(e,[c]){const g={};c&2&&(g.$$scope={dirty:c,ctx:e}),F.$set(g);const G={};c&2&&(G.$$scope={dirty:c,ctx:e}),R.$set(G);const j={};c&2&&(j.$$scope={dirty:c,ctx:e}),E.$set(j);const me={};c&2&&(me.$$scope={dirty:c,ctx:e}),B.$set(me);const Z={};c&2&&(Z.$$scope={dirty:c,ctx:e}),H.$set(Z);const fe={};c&2&&(fe.$$scope={dirty:c,ctx:e}),z.$set(fe);const P={};c&2&&(P.$$scope={dirty:c,ctx:e}),V.$set(P);const S={};c&2&&(S.$$scope={dirty:c,ctx:e}),q.$set(S)},i(e){Be||(x(m.$$.fragment,e),x(F.$$.fragment,e),x(K.$$.fragment,e),x(ee.$$.fragment,e),x(te.$$.fragment,e),x(R.$$.fragment,e),x(ne.$$.fragment,e),x(E.$$.fragment,e),x(B.$$.fragment,e),x(oe.$$.fragment,e),x(ie.$$.fragment,e),x(H.$$.fragment,e),x(z.$$.fragment,e),x(se.$$.fragment,e),x(ae.$$.fragment,e),x(V.$$.fragment,e),x(q.$$.fragment,e),x(re.$$.fragment,e),x(le.$$.fragment,e),x(de.$$.fragment,e),x(pe.$$.fragment,e),x(ce.$$.fragment,e),Be=!0)},o(e){D(m.$$.fragment,e),D(F.$$.fragment,e),D(K.$$.fragment,e),D(ee.$$.fragment,e),D(te.$$.fragment,e),D(R.$$.fragment,e),D(ne.$$.fragment,e),D(E.$$.fragment,e),D(B.$$.fragment,e),D(oe.$$.fragment,e),D(ie.$$.fragment,e),D(H.$$.fragment,e),D(z.$$.fragment,e),D(se.$$.fragment,e),D(ae.$$.fragment,e),D(V.$$.fragment,e),D(q.$$.fragment,e),D(re.$$.fragment,e),D(le.$$.fragment,e),D(de.$$.fragment,e),D(pe.$$.fragment,e),D(ce.$$.fragment,e),Be=!1},d(e){e&&(p(b),p(r),p(i),p(t),p(u),p(We),p(Ne),p(Ge),p(f),p(Fe),p(Re),p(N),p(Ee),p(je)),p(n),$(m,e),$(F,e),$(K,e),$(ee),$(te),$(R),$(ne),$(E),$(B),$(oe),$(ie),$(H),$(z),$(se),$(ae),$(V),$(q),$(re),$(le),$(de),$(pe,e),$(ce)}}}const fn='{"title":"Depth-to-image","local":"depth-to-image","sections":[{"title":"StableDiffusionDepth2ImgPipeline","local":"diffusers.StableDiffusionDepth2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function un(I){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xn extends en{constructor(n){super(),tn(this,n,un,mn,Ot,{})}}export{xn as component};
