import{s as Fe,o as Qe,n as Ce}from"../chunks/scheduler.182ea377.js";import{S as ze,i as Le,g as c,s as n,r as m,A as qe,h as o,f as t,c as i,j as He,u,x as r,k as q,y as De,a as l,v as d,d as y,t as f,w as h}from"../chunks/index.abf12888.js";import{T as _e}from"../chunks/Tip.230e2334.js";import{C as z}from"../chunks/CodeBlock.57fe6e13.js";import{H as ge}from"../chunks/Heading.16916d63.js";function Pe(j){let a,M='🤗 Diffusers currently only supports <code>callback_on_step_end</code>, but feel free to open a <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">feature request</a> if you have a cool use-case and require a callback function with a different execution point!';return{c(){a=c("p"),a.innerHTML=M},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-1g9pkv"&&(a.innerHTML=M)},m(p,b){l(p,a,b)},p:Ce,d(p){p&&t(a)}}}function Ke(j){let a,M='The interruption callback is supported for text-to-image, image-to-image, and inpainting for the <a href="../api/pipelines/stable_diffusion/overview">StableDiffusionPipeline</a> and <a href="../api/pipelines/stable_diffusion/stable_diffusion_xl">StableDiffusionXLPipeline</a>.';return{c(){a=c("p"),a.innerHTML=M},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-q9hytq"&&(a.innerHTML=M)},m(p,b){l(p,a,b)},p:Ce,d(p){p&&t(a)}}}function Oe(j){let a,M='This tip was contributed by <a href="https://github.com/asomoza" rel="nofollow">asomoza</a>.';return{c(){a=c("p"),a.innerHTML=M},l(p){a=o(p,"P",{"data-svelte-h":!0}),r(a)!=="svelte-13sfhtz"&&(a.innerHTML=M)},m(p,b){l(p,a,b)},p:Ce,d(p){p&&t(a)}}}function es(j){let a,M,p,b,C,D,Z,Ze="The denoising loop of a pipeline can be modified with custom defined functions using the <code>callback_on_step_end</code> parameter. The callback function is executed at the end of each step, and modifies the pipeline attributes and variables for the next step. This is really useful for <em>dynamically</em> adjusting certain pipeline attributes or modifying tensor variables. This versatility allows for interesting use-cases such as changing the prompt embeddings at each timestep, assigning different weights to the prompt embeddings, and editing the guidance scale. With callbacks, you can implement new features without modifying the underlying code!",P,w,K,I,Ie="This guide will demonstrate how callbacks work by a few features you can implement with them.",O,k,ee,A,ke="Dynamic classifier-free guidance (CFG) is a feature that allows you to disable CFG after a certain number of inference steps which can help you save compute with minimal cost to performance. The callback function for this should have the following arguments:",se,$,Ae="<li><code>pipeline</code> (or the pipeline instance) provides access to important properties such as <code>num_timesteps</code> and <code>guidance_scale</code>. You can modify these properties by updating the underlying attributes. For this example, you’ll disable CFG by setting <code>pipeline._guidance_scale=0.0</code>.</li> <li><code>step_index</code> and <code>timestep</code> tell you where you are in the denoising loop. Use <code>step_index</code> to turn off CFG after reaching 40% of <code>num_timesteps</code>.</li> <li><code>callback_kwargs</code> is a dict that contains tensor variables you can modify during the denoising loop. It only includes variables specified in the <code>callback_on_step_end_tensor_inputs</code> argument, which is passed to the pipeline’s <code>__call__</code> method. Different pipelines may use different sets of variables, so please check a pipeline’s <code>_callback_tensor_inputs</code> attribute for the list of variables you can modify. Some common variables include <code>latents</code> and <code>prompt_embeds</code>. For this function, change the batch size of <code>prompt_embeds</code> after setting <code>guidance_scale=0.0</code> in order for it to work properly.</li>",te,v,$e="Your callback function should look something like this:",le,B,ae,G,ve="Now, you can pass the callback function to the <code>callback_on_step_end</code> parameter and the <code>prompt_embeds</code> to <code>callback_on_step_end_tensor_inputs</code>.",ne,W,ie,x,pe,J,ce,Y,Be="Stopping the diffusion process early is useful when building UIs that work with Diffusers because it allows users to stop the generation process if they’re unhappy with the intermediate results. You can incorporate this into your pipeline with a callback.",oe,R,Ge="This callback function should take the following arguments: <code>pipeline</code>, <code>i</code>, <code>t</code>, and <code>callback_kwargs</code> (this must be returned). Set the pipeline’s <code>_interrupt</code> attribute to <code>True</code> to stop the diffusion process after a certain number of steps. You are also free to implement your own custom stopping logic inside the callback.",re,X,We="In this example, the diffusion process is stopped after 10 steps even though <code>num_inference_steps</code> is set to 50.",Me,E,me,S,ue,U,de,N,xe="Display an image after each generation step by accessing and converting the latents after each step into an image. The latent space is compressed to 128x128, so the images are also 128x128 which is useful for a quick preview.",ye,V,Ye='<li>Use the function below to convert the SDXL latents (4 channels) to RGB tensors (3 channels) as explained in the <a href="https://huggingface.co/blog/TimothyAlexisVass/explaining-the-sdxl-latent-space" rel="nofollow">Explaining the SDXL latent space</a> blog post.</li>',fe,H,he,T,Re="<li>Create a function to decode and save the latents into an image.</li>",be,F,je,g,Xe="<li>Pass the <code>decode_tensors</code> function to the <code>callback_on_step_end</code> parameter to decode the tensors after each step. You also need to specify what you want to modify in the <code>callback_on_step_end_tensor_inputs</code> parameter, which in this case are the latents.</li>",we,Q,Je,_,Ee='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 0</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_19.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 19</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_29.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 29</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_39.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 39</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/tips_step_49.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">step 49</figcaption></div>',Ue,L,Te;return C=new ge({props:{title:"Pipeline callbacks",local:"pipeline-callbacks",headingTag:"h1"}}),w=new _e({props:{warning:!1,$$slots:{default:[Pe]},$$scope:{ctx:j}}}),k=new ge({props:{title:"Dynamic classifier-free guidance",local:"dynamic-classifier-free-guidance",headingTag:"h2"}}),B=new z({props:{code:"ZGVmJTIwY2FsbGJhY2tfZHluYW1pY19jZmcocGlwZSUyQyUyMHN0ZXBfaW5kZXglMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBhZGp1c3QlMjB0aGUlMjBiYXRjaF9zaXplJTIwb2YlMjBwcm9tcHRfZW1iZWRzJTIwYWNjb3JkaW5nJTIwdG8lMjBndWlkYW5jZV9zY2FsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3RlcF9pbmRleCUyMCUzRCUzRCUyMGludChwaXBlbGluZS5udW1fdGltZXN0ZXBzJTIwKiUyMDAuNCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIycHJvbXB0X2VtYmVkcyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlMjAlM0QlMjBwcm9tcHRfZW1iZWRzLmNodW5rKDIpJTVCLTElNUQlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB1cGRhdGUlMjBndWlkYW5jZV9zY2FsZSUyMGFuZCUyMHByb21wdF9lbWJlZHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5fZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjAwLjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYWxsYmFja19rd2FyZ3MlNUIlMjJwcm9tcHRfZW1iZWRzJTIyJTVEJTIwJTNEJTIwcHJvbXB0X2VtYmVkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">callback_dynamic_cfg</span>(<span class="hljs-params">pipe, step_index, timestep, callback_kwargs</span>):
        <span class="hljs-comment"># adjust the batch_size of prompt_embeds according to guidance_scale</span>
        <span class="hljs-keyword">if</span> step_index == <span class="hljs-built_in">int</span>(pipeline.num_timesteps * <span class="hljs-number">0.4</span>):
                prompt_embeds = callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>]
                prompt_embeds = prompt_embeds.chunk(<span class="hljs-number">2</span>)[-<span class="hljs-number">1</span>]

                <span class="hljs-comment"># update guidance_scale and prompt_embeds</span>
                pipeline._guidance_scale = <span class="hljs-number">0.0</span>
                callback_kwargs[<span class="hljs-string">&quot;prompt_embeds&quot;</span>] = prompt_embeds
        <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),W=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgxKSUwQW91dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEY2FsbGJhY2tfZHluYW1pY19jZmclMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja19vbl9zdGVwX2VuZF90ZW5zb3JfaW5wdXRzJTNEJTVCJ3Byb21wdF9lbWJlZHMnJTVEJTBBKSUwQSUwQW91dC5pbWFnZXMlNUIwJTVELnNhdmUoJTIyb3V0X2N1c3RvbV9jZmcucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>)
out = pipeline(
    prompt,
    generator=generator,
    callback_on_step_end=callback_dynamic_cfg,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&#x27;prompt_embeds&#x27;</span>]
)

out.images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;out_custom_cfg.png&quot;</span>)`,wrap:!1}}),x=new ge({props:{title:"Interrupt the diffusion process",local:"interrupt-the-diffusion-process",headingTag:"h2"}}),J=new _e({props:{warning:!1,$$slots:{default:[Ke]},$$scope:{ctx:j}}}),E=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNTAlMEElMEFkZWYlMjBpbnRlcnJ1cHRfY2FsbGJhY2socGlwZWxpbmUlMkMlMjBpJTJDJTIwdCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBzdG9wX2lkeCUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwc3RvcF9pZHglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZS5faW50ZXJydXB0JTIwJTNEJTIwVHJ1ZSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhbGxiYWNrX2t3YXJncyUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0RudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwY2FsbGJhY2tfb25fc3RlcF9lbmQlM0RpbnRlcnJ1cHRfY2FsbGJhY2slMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
pipeline.enable_model_cpu_offload()
num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">interrupt_callback</span>(<span class="hljs-params">pipeline, i, t, callback_kwargs</span>):
    stop_idx = <span class="hljs-number">10</span>
    <span class="hljs-keyword">if</span> i == stop_idx:
        pipeline._interrupt = <span class="hljs-literal">True</span>

    <span class="hljs-keyword">return</span> callback_kwargs

pipeline(
    <span class="hljs-string">&quot;A photo of a cat&quot;</span>,
    num_inference_steps=num_inference_steps,
    callback_on_step_end=interrupt_callback,
)`,wrap:!1}}),S=new ge({props:{title:"Display image after each generation step",local:"display-image-after-each-generation-step",headingTag:"h2"}}),U=new _e({props:{warning:!1,$$slots:{default:[Oe]},$$scope:{ctx:j}}}),H=new z({props:{code:"ZGVmJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyklM0ElMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMC02MCUyQyUyMDI1JTJDJTIwLTcwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCg2MCUyQyUyMCUyMC01JTJDJTIwMTUlMkMlMjAtNTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKDYwJTJDJTIwJTIwMTAlMkMlMjAtNSUyQyUyMC0zNSklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwd2VpZ2h0c190ZW5zb3IlMjAlM0QlMjB0b3JjaC50KHRvcmNoLnRlbnNvcih3ZWlnaHRzJTJDJTIwZHR5cGUlM0RsYXRlbnRzLmR0eXBlKS50byhsYXRlbnRzLmRldmljZSkpJTBBJTIwJTIwJTIwJTIwYmlhc2VzX3RlbnNvciUyMCUzRCUyMHRvcmNoLnRlbnNvcigoMTUwJTJDJTIwMTQwJTJDJTIwMTMwKSUyQyUyMGR0eXBlJTNEbGF0ZW50cy5kdHlwZSkudG8obGF0ZW50cy5kZXZpY2UpJTBBJTIwJTIwJTIwJTIwcmdiX3RlbnNvciUyMCUzRCUyMHRvcmNoLmVpbnN1bSglMjIuLi5seHklMkNsciUyMC0lM0UlMjAuLi5yeHklMjIlMkMlMjBsYXRlbnRzJTJDJTIwd2VpZ2h0c190ZW5zb3IpJTIwJTJCJTIwYmlhc2VzX3RlbnNvci51bnNxdWVlemUoLTEpLnVuc3F1ZWV6ZSgtMSklMEElMjAlMjAlMjAlMjBpbWFnZV9hcnJheSUyMCUzRCUyMHJnYl90ZW5zb3IuY2xhbXAoMCUyQyUyMDI1NSklNUIwJTVELmJ5dGUoKS5jcHUoKS5udW1weSgpJTBBJTIwJTIwJTIwJTIwaW1hZ2VfYXJyYXklMjAlM0QlMjBpbWFnZV9hcnJheS50cmFuc3Bvc2UoMSUyQyUyMDIlMkMlMjAwKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMEltYWdlLmZyb21hcnJheShpbWFnZV9hcnJheSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">latents_to_rgb</span>(<span class="hljs-params">latents</span>):
    weights = (
        (<span class="hljs-number">60</span>, -<span class="hljs-number">60</span>, <span class="hljs-number">25</span>, -<span class="hljs-number">70</span>),
        (<span class="hljs-number">60</span>,  -<span class="hljs-number">5</span>, <span class="hljs-number">15</span>, -<span class="hljs-number">50</span>),
        (<span class="hljs-number">60</span>,  <span class="hljs-number">10</span>, -<span class="hljs-number">5</span>, -<span class="hljs-number">35</span>)
    )

    weights_tensor = torch.t(torch.tensor(weights, dtype=latents.dtype).to(latents.device))
    biases_tensor = torch.tensor((<span class="hljs-number">150</span>, <span class="hljs-number">140</span>, <span class="hljs-number">130</span>), dtype=latents.dtype).to(latents.device)
    rgb_tensor = torch.einsum(<span class="hljs-string">&quot;...lxy,lr -&gt; ...rxy&quot;</span>, latents, weights_tensor) + biases_tensor.unsqueeze(-<span class="hljs-number">1</span>).unsqueeze(-<span class="hljs-number">1</span>)
    image_array = rgb_tensor.clamp(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>)[<span class="hljs-number">0</span>].byte().cpu().numpy()
    image_array = image_array.transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>)

    <span class="hljs-keyword">return</span> Image.fromarray(image_array)`,wrap:!1}}),F=new z({props:{code:"ZGVmJTIwZGVjb2RlX3RlbnNvcnMocGlwZSUyQyUyMHN0ZXAlMkMlMjB0aW1lc3RlcCUyQyUyMGNhbGxiYWNrX2t3YXJncyklM0ElMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwY2FsbGJhY2tfa3dhcmdzJTVCJTIybGF0ZW50cyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbGF0ZW50c190b19yZ2IobGF0ZW50cyklMEElMjAlMjAlMjAlMjBpbWFnZS5zYXZlKGYlMjIlN0JzdGVwJTdELnBuZyUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBjYWxsYmFja19rd2FyZ3M=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_tensors</span>(<span class="hljs-params">pipe, step, timestep, callback_kwargs</span>):
    latents = callback_kwargs[<span class="hljs-string">&quot;latents&quot;</span>]
    
    image = latents_to_rgb(latents)
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{step}</span>.png&quot;</span>)

    <span class="hljs-keyword">return</span> callback_kwargs`,wrap:!1}}),Q=new z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMGNyb2lzc2FudCUyMHNoYXBlZCUyMGxpa2UlMjBhJTIwY3V0ZSUyMGJlYXIuJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyRGVmb3JtZWQlMkMlMjB1Z2x5JTJDJTIwYmFkJTIwYW5hdG9teSUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbGxiYWNrX29uX3N0ZXBfZW5kJTNEZGVjb2RlX3RlbnNvcnMlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja19vbl9zdGVwX2VuZF90ZW5zb3JfaW5wdXRzJTNEJTVCJTIybGF0ZW50cyUyMiU1RCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A croissant shaped like a cute bear.&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;Deformed, ugly, bad anatomy&quot;</span>,
    callback_on_step_end=decode_tensors,
    callback_on_step_end_tensor_inputs=[<span class="hljs-string">&quot;latents&quot;</span>],
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=c("meta"),M=n(),p=c("p"),b=n(),m(C.$$.fragment),D=n(),Z=c("p"),Z.innerHTML=Ze,P=n(),m(w.$$.fragment),K=n(),I=c("p"),I.textContent=Ie,O=n(),m(k.$$.fragment),ee=n(),A=c("p"),A.textContent=ke,se=n(),$=c("ul"),$.innerHTML=Ae,te=n(),v=c("p"),v.textContent=$e,le=n(),m(B.$$.fragment),ae=n(),G=c("p"),G.innerHTML=ve,ne=n(),m(W.$$.fragment),ie=n(),m(x.$$.fragment),pe=n(),m(J.$$.fragment),ce=n(),Y=c("p"),Y.textContent=Be,oe=n(),R=c("p"),R.innerHTML=Ge,re=n(),X=c("p"),X.innerHTML=We,Me=n(),m(E.$$.fragment),me=n(),m(S.$$.fragment),ue=n(),m(U.$$.fragment),de=n(),N=c("p"),N.textContent=xe,ye=n(),V=c("ol"),V.innerHTML=Ye,fe=n(),m(H.$$.fragment),he=n(),T=c("ol"),T.innerHTML=Re,be=n(),m(F.$$.fragment),je=n(),g=c("ol"),g.innerHTML=Xe,we=n(),m(Q.$$.fragment),Je=n(),_=c("div"),_.innerHTML=Ee,Ue=n(),L=c("p"),this.h()},l(e){const s=qe("svelte-u9bgzb",document.head);a=o(s,"META",{name:!0,content:!0}),s.forEach(t),M=i(e),p=o(e,"P",{}),He(p).forEach(t),b=i(e),u(C.$$.fragment,e),D=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1v9uh80"&&(Z.innerHTML=Ze),P=i(e),u(w.$$.fragment,e),K=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ct42i6"&&(I.textContent=Ie),O=i(e),u(k.$$.fragment,e),ee=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1f6wgfp"&&(A.textContent=ke),se=i(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-dtd0ri"&&($.innerHTML=Ae),te=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1s2b9st"&&(v.textContent=$e),le=i(e),u(B.$$.fragment,e),ae=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-y3yxaw"&&(G.innerHTML=ve),ne=i(e),u(W.$$.fragment,e),ie=i(e),u(x.$$.fragment,e),pe=i(e),u(J.$$.fragment,e),ce=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1nej5ag"&&(Y.textContent=Be),oe=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-zdg2uc"&&(R.innerHTML=Ge),re=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-s21qgj"&&(X.innerHTML=We),Me=i(e),u(E.$$.fragment,e),me=i(e),u(S.$$.fragment,e),ue=i(e),u(U.$$.fragment,e),de=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ofpl9u"&&(N.textContent=xe),ye=i(e),V=o(e,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-19fyqau"&&(V.innerHTML=Ye),fe=i(e),u(H.$$.fragment,e),he=i(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-ebwxn0"&&(T.innerHTML=Re),be=i(e),u(F.$$.fragment,e),je=i(e),g=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-1r24q0u"&&(g.innerHTML=Xe),we=i(e),u(Q.$$.fragment,e),Je=i(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-o2x0os"&&(_.innerHTML=Ee),Ue=i(e),L=o(e,"P",{}),He(L).forEach(t),this.h()},h(){q(a,"name","hf:doc:metadata"),q(a,"content",ss),q(T,"start","2"),q(g,"start","3"),q(_,"class","flex gap-4 justify-center")},m(e,s){De(document.head,a),l(e,M,s),l(e,p,s),l(e,b,s),d(C,e,s),l(e,D,s),l(e,Z,s),l(e,P,s),d(w,e,s),l(e,K,s),l(e,I,s),l(e,O,s),d(k,e,s),l(e,ee,s),l(e,A,s),l(e,se,s),l(e,$,s),l(e,te,s),l(e,v,s),l(e,le,s),d(B,e,s),l(e,ae,s),l(e,G,s),l(e,ne,s),d(W,e,s),l(e,ie,s),d(x,e,s),l(e,pe,s),d(J,e,s),l(e,ce,s),l(e,Y,s),l(e,oe,s),l(e,R,s),l(e,re,s),l(e,X,s),l(e,Me,s),d(E,e,s),l(e,me,s),d(S,e,s),l(e,ue,s),d(U,e,s),l(e,de,s),l(e,N,s),l(e,ye,s),l(e,V,s),l(e,fe,s),d(H,e,s),l(e,he,s),l(e,T,s),l(e,be,s),d(F,e,s),l(e,je,s),l(e,g,s),l(e,we,s),d(Q,e,s),l(e,Je,s),l(e,_,s),l(e,Ue,s),l(e,L,s),Te=!0},p(e,[s]){const Se={};s&2&&(Se.$$scope={dirty:s,ctx:e}),w.$set(Se);const Ne={};s&2&&(Ne.$$scope={dirty:s,ctx:e}),J.$set(Ne);const Ve={};s&2&&(Ve.$$scope={dirty:s,ctx:e}),U.$set(Ve)},i(e){Te||(y(C.$$.fragment,e),y(w.$$.fragment,e),y(k.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(x.$$.fragment,e),y(J.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(U.$$.fragment,e),y(H.$$.fragment,e),y(F.$$.fragment,e),y(Q.$$.fragment,e),Te=!0)},o(e){f(C.$$.fragment,e),f(w.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(W.$$.fragment,e),f(x.$$.fragment,e),f(J.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(U.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(Q.$$.fragment,e),Te=!1},d(e){e&&(t(M),t(p),t(b),t(D),t(Z),t(P),t(K),t(I),t(O),t(ee),t(A),t(se),t($),t(te),t(v),t(le),t(ae),t(G),t(ne),t(ie),t(pe),t(ce),t(Y),t(oe),t(R),t(re),t(X),t(Me),t(me),t(ue),t(de),t(N),t(ye),t(V),t(fe),t(he),t(T),t(be),t(je),t(g),t(we),t(Je),t(_),t(Ue),t(L)),t(a),h(C,e),h(w,e),h(k,e),h(B,e),h(W,e),h(x,e),h(J,e),h(E,e),h(S,e),h(U,e),h(H,e),h(F,e),h(Q,e)}}}const ss='{"title":"Pipeline callbacks","local":"pipeline-callbacks","sections":[{"title":"Dynamic classifier-free guidance","local":"dynamic-classifier-free-guidance","sections":[],"depth":2},{"title":"Interrupt the diffusion process","local":"interrupt-the-diffusion-process","sections":[],"depth":2},{"title":"Display image after each generation step","local":"display-image-after-each-generation-step","sections":[],"depth":2}],"depth":1}';function ts(j){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends ze{constructor(a){super(),Le(this,a,ts,es,Fe,{})}}export{cs as component};
