import{s as It,o as Bt,n as ye}from"../chunks/scheduler.182ea377.js";import{S as kt,i as xt,g as c,s as n,r as d,A as Rt,h as f,f as l,c as o,j as Gt,u as y,x as u,k as fe,y as Xt,a as i,v as M,d as h,t as b,w}from"../chunks/index.abf12888.js";import{T as st}from"../chunks/Tip.230e2334.js";import{C as Z}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ht}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as de}from"../chunks/Heading.16916d63.js";import{H as Et,a as Ct}from"../chunks/HfOption.fc88c804.js";function Nt(U){let s,T="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){s=c("p"),s.textContent=T},l(p){s=f(p,"P",{"data-svelte-h":!0}),u(s)!=="svelte-154jbq5"&&(s.textContent=T)},m(p,m){i(p,s,m)},p:ye,d(p){p&&l(s)}}}function Qt(U){let s,T="For example, to load from the <code>main</code> branch:",p,m,r;return m=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIybWFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;main&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=T,p=n(),d(m.$$.fragment)},l(a){s=f(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1kgdpxr"&&(s.innerHTML=T),p=o(a),y(m.$$.fragment,a)},m(a,J){i(a,s,J),i(a,p,J),M(m,a,J),r=!0},p:ye,i(a){r||(h(m.$$.fragment,a),r=!0)},o(a){b(m.$$.fragment,a),r=!1},d(a){a&&(l(s),l(p)),w(m,a)}}}function Ft(U){let s,T="For example, to load from a previous version of Diffusers like <code>v0.25.0</code>:",p,m,r;return m=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIydjAuMjUuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;v0.25.0&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=T,p=n(),d(m.$$.fragment)},l(a){s=f(a,"P",{"data-svelte-h":!0}),u(s)!=="svelte-15bkibl"&&(s.innerHTML=T),p=o(a),y(m.$$.fragment,a)},m(a,J){i(a,s,J),i(a,p,J),M(m,a,J),r=!0},p:ye,i(a){r||(h(m.$$.fragment,a),r=!0)},o(a){b(m.$$.fragment,a),r=!1},d(a){a&&(l(s),l(p)),w(m,a)}}}function zt(U){let s,T,p,m;return s=new Ct({props:{id:"version",option:"main",$$slots:{default:[Qt]},$$scope:{ctx:U}}}),p=new Ct({props:{id:"version",option:"older version",$$slots:{default:[Ft]},$$scope:{ctx:U}}}),{c(){d(s.$$.fragment),T=n(),d(p.$$.fragment)},l(r){y(s.$$.fragment,r),T=o(r),y(p.$$.fragment,r)},m(r,a){M(s,r,a),i(r,T,a),M(p,r,a),m=!0},p(r,a){const J={};a&2&&(J.$$scope={dirty:a,ctx:r}),s.$set(J);const C={};a&2&&(C.$$scope={dirty:a,ctx:r}),p.$set(C)},i(r){m||(h(s.$$.fragment,r),h(p.$$.fragment,r),m=!0)},o(r){b(s.$$.fragment,r),b(p.$$.fragment,r),m=!1},d(r){r&&l(T),w(s,r),w(p,r)}}}function St(U){let s,T='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){s=c("p"),s.innerHTML=T},l(p){s=f(p,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ptu9pr"&&(s.innerHTML=T)},m(p,m){i(p,s,m)},p:ye,d(p){p&&l(s)}}}function Lt(U){let s,T="When using <code>trust_remote_code=True</code>, it is also strongly encouraged to pass a commit hash as a <code>revision</code> to make sure the author of the models did not update the code with some malicious new lines (unless you fully trust the authors of the models).";return{c(){s=c("p"),s.innerHTML=T},l(p){s=f(p,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1thgilw"&&(s.innerHTML=T)},m(p,m){i(p,s,m)},p:ye,d(p){p&&l(s)}}}function Yt(U){let s,T,p,m,r,a,J,C,I,Me,B,nt='Community pipelines are any <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',he,k,ot='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',be,x,at='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',we,$,Te,R,Je,X,pt='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',Ue,H,Ze,E,$e,N,rt="Community pipelines can also be loaded from a local file if you pass a file path instead. The path to the passed directory must contain a <code>pipeline.py</code> file that contains the pipeline class in order to successfully load it.",_e,Q,ge,F,je,z,mt="By default, community pipelines are loaded from the latest stable version of Diffusers. To load a community pipeline from another version, use the <code>custom_revision</code> parameter.",Ve,_,ve,S,ct='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',We,L,Ge,Y,ft="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",Ce,q,ut="This section shows how users should use community components to build a community pipeline.",Ie,P,dt='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example. So, let’s start loading the components:',Be,D,yt="<li>Import and load the text encoder from Transformers:</li>",ke,A,xe,g,Mt="<li>Load a scheduler:</li>",Re,O,Xe,j,ht="<li>Load an image processor:</li>",He,K,Ee,V,Ne,v,bt='<li>Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in the <code>showone_unet_3d_condition.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">script</a> for your convenience. You’ll notice the <code>UNet3DConditionModel</code> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in the <code>showone_unet_3d_condition.py</code> script.</li>',Qe,ee,wt="Once this is done, you can initialize the UNet:",Fe,te,ze,W,Tt='<li>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in the <code>pipeline_t2v_base_pixel.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">script</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in the <code>pipeline_t2v_base_pixel.py</code> script.</li>',Se,le,Jt="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",Le,ie,Ye,se,Ut="Push the pipeline to the Hub to share with the community!",qe,ne,Pe,oe,Zt="After the pipeline is successfully pushed, you need a couple of changes:",De,ae,$t='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow"><code>model_index.json</code></a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <code>unet</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline base <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li>',Ae,pe,_t="To run inference, simply add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",Oe,re,Ke,me,gt='As an additional reference example, you can refer to the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a>, that makes use of the <code>trust_remote_code</code> feature:',et,ce,tt,G,lt,ue,it;return r=new de({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),J=new Ht({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),I=new de({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),$=new st({props:{warning:!0,$$slots:{default:[Nt]},$$scope:{ctx:U}}}),R=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),H=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),E=new de({props:{title:"Load from a local file",local:"load-from-a-local-file",headingTag:"h3"}}),Q=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjIuJTJGcGF0aCUyRnRvJTJGcGlwZWxpbmVfZGlyZWN0b3J5JTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9tb2RlbCUzRGNsaXBfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSk=",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;./path/to/pipeline_directory/&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),F=new de({props:{title:"Load from a specific version",local:"load-from-a-specific-version",headingTag:"h3"}}),_=new Et({props:{id:"version",options:["main","older version"],$$slots:{default:[zt]},$$scope:{ctx:U}}}),L=new de({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),A=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),O=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),K=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),V=new st({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:U}}}),te=new Z({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),ie=new Z({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),ne=new Z({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),re=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),ce=new Z({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBpZiUyMHVzaW5nJTIwdG9yY2glMjAlM0MlMjAyLjAlMEElMjMlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiVFNiU5RiVCNCVFNyU4QSVBQyVFMyU4MCU4MSVFMyU4MiVBQiVFMyU4MyVBOSVFMyU4MyU5NSVFMyU4MyVBQiVFMyU4MiVBMiVFMyU4MyVCQyVFMyU4MyU4OCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># if using torch &lt; 2.0</span>
<span class="hljs-comment"># pipeline.enable_xformers_memory_efficient_attention()</span>

prompt = <span class="hljs-string">&quot;柴犬、カラフルアート&quot;</span>

image = pipeline(prompt=prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),G=new st({props:{warning:!1,$$slots:{default:[Lt]},$$scope:{ctx:U}}}),{c(){s=c("meta"),T=n(),p=c("p"),m=n(),d(r.$$.fragment),a=n(),d(J.$$.fragment),C=n(),d(I.$$.fragment),Me=n(),B=c("p"),B.innerHTML=nt,he=n(),k=c("p"),k.innerHTML=ot,be=n(),x=c("p"),x.innerHTML=at,we=n(),d($.$$.fragment),Te=n(),d(R.$$.fragment),Je=n(),X=c("p"),X.innerHTML=pt,Ue=n(),d(H.$$.fragment),Ze=n(),d(E.$$.fragment),$e=n(),N=c("p"),N.innerHTML=rt,_e=n(),d(Q.$$.fragment),ge=n(),d(F.$$.fragment),je=n(),z=c("p"),z.innerHTML=mt,Ve=n(),d(_.$$.fragment),ve=n(),S=c("p"),S.innerHTML=ct,We=n(),d(L.$$.fragment),Ge=n(),Y=c("p"),Y.textContent=ft,Ce=n(),q=c("p"),q.textContent=ut,Ie=n(),P=c("p"),P.innerHTML=dt,Be=n(),D=c("ol"),D.innerHTML=yt,ke=n(),d(A.$$.fragment),xe=n(),g=c("ol"),g.innerHTML=Mt,Re=n(),d(O.$$.fragment),Xe=n(),j=c("ol"),j.innerHTML=ht,He=n(),d(K.$$.fragment),Ee=n(),d(V.$$.fragment),Ne=n(),v=c("ol"),v.innerHTML=bt,Qe=n(),ee=c("p"),ee.textContent=wt,Fe=n(),d(te.$$.fragment),ze=n(),W=c("ol"),W.innerHTML=Tt,Se=n(),le=c("p"),le.innerHTML=Jt,Le=n(),d(ie.$$.fragment),Ye=n(),se=c("p"),se.textContent=Ut,qe=n(),d(ne.$$.fragment),Pe=n(),oe=c("p"),oe.textContent=Zt,De=n(),ae=c("ol"),ae.innerHTML=$t,Ae=n(),pe=c("p"),pe.innerHTML=_t,Oe=n(),d(re.$$.fragment),Ke=n(),me=c("p"),me.innerHTML=gt,et=n(),d(ce.$$.fragment),tt=n(),d(G.$$.fragment),lt=n(),ue=c("p"),this.h()},l(e){const t=Rt("svelte-u9bgzb",document.head);s=f(t,"META",{name:!0,content:!0}),t.forEach(l),T=o(e),p=f(e,"P",{}),Gt(p).forEach(l),m=o(e),y(r.$$.fragment,e),a=o(e),y(J.$$.fragment,e),C=o(e),y(I.$$.fragment,e),Me=o(e),B=f(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1yn8qeb"&&(B.innerHTML=nt),he=o(e),k=f(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-10en0rk"&&(k.innerHTML=ot),be=o(e),x=f(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1mmnk2f"&&(x.innerHTML=at),we=o(e),y($.$$.fragment,e),Te=o(e),y(R.$$.fragment,e),Je=o(e),X=f(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1yyre8w"&&(X.innerHTML=pt),Ue=o(e),y(H.$$.fragment,e),Ze=o(e),y(E.$$.fragment,e),$e=o(e),N=f(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1e8nso6"&&(N.innerHTML=rt),_e=o(e),y(Q.$$.fragment,e),ge=o(e),y(F.$$.fragment,e),je=o(e),z=f(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-17rlizh"&&(z.innerHTML=mt),Ve=o(e),y(_.$$.fragment,e),ve=o(e),S=f(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1ho2g1z"&&(S.innerHTML=ct),We=o(e),y(L.$$.fragment,e),Ge=o(e),Y=f(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1vh7uou"&&(Y.textContent=ft),Ce=o(e),q=f(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-phpvnj"&&(q.textContent=ut),Ie=o(e),P=f(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-7sknw0"&&(P.innerHTML=dt),Be=o(e),D=f(e,"OL",{"data-svelte-h":!0}),u(D)!=="svelte-8ccbl9"&&(D.innerHTML=yt),ke=o(e),y(A.$$.fragment,e),xe=o(e),g=f(e,"OL",{start:!0,"data-svelte-h":!0}),u(g)!=="svelte-1rtkhjg"&&(g.innerHTML=Mt),Re=o(e),y(O.$$.fragment,e),Xe=o(e),j=f(e,"OL",{start:!0,"data-svelte-h":!0}),u(j)!=="svelte-o9t4x9"&&(j.innerHTML=ht),He=o(e),y(K.$$.fragment,e),Ee=o(e),y(V.$$.fragment,e),Ne=o(e),v=f(e,"OL",{start:!0,"data-svelte-h":!0}),u(v)!=="svelte-2m7lmo"&&(v.innerHTML=bt),Qe=o(e),ee=f(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-4yol19"&&(ee.textContent=wt),Fe=o(e),y(te.$$.fragment,e),ze=o(e),W=f(e,"OL",{start:!0,"data-svelte-h":!0}),u(W)!=="svelte-1m9qhhm"&&(W.innerHTML=Tt),Se=o(e),le=f(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1jpprmd"&&(le.innerHTML=Jt),Le=o(e),y(ie.$$.fragment,e),Ye=o(e),se=f(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-14lz5yb"&&(se.textContent=Ut),qe=o(e),y(ne.$$.fragment,e),Pe=o(e),oe=f(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-azdq2p"&&(oe.textContent=Zt),De=o(e),ae=f(e,"OL",{"data-svelte-h":!0}),u(ae)!=="svelte-7wsjmh"&&(ae.innerHTML=$t),Ae=o(e),pe=f(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-xpz58c"&&(pe.innerHTML=_t),Oe=o(e),y(re.$$.fragment,e),Ke=o(e),me=f(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1cmjoh5"&&(me.innerHTML=gt),et=o(e),y(ce.$$.fragment,e),tt=o(e),y(G.$$.fragment,e),lt=o(e),ue=f(e,"P",{}),Gt(ue).forEach(l),this.h()},h(){fe(s,"name","hf:doc:metadata"),fe(s,"content",qt),fe(g,"start","2"),fe(j,"start","3"),fe(v,"start","4"),fe(W,"start","5")},m(e,t){Xt(document.head,s),i(e,T,t),i(e,p,t),i(e,m,t),M(r,e,t),i(e,a,t),M(J,e,t),i(e,C,t),M(I,e,t),i(e,Me,t),i(e,B,t),i(e,he,t),i(e,k,t),i(e,be,t),i(e,x,t),i(e,we,t),M($,e,t),i(e,Te,t),M(R,e,t),i(e,Je,t),i(e,X,t),i(e,Ue,t),M(H,e,t),i(e,Ze,t),M(E,e,t),i(e,$e,t),i(e,N,t),i(e,_e,t),M(Q,e,t),i(e,ge,t),M(F,e,t),i(e,je,t),i(e,z,t),i(e,Ve,t),M(_,e,t),i(e,ve,t),i(e,S,t),i(e,We,t),M(L,e,t),i(e,Ge,t),i(e,Y,t),i(e,Ce,t),i(e,q,t),i(e,Ie,t),i(e,P,t),i(e,Be,t),i(e,D,t),i(e,ke,t),M(A,e,t),i(e,xe,t),i(e,g,t),i(e,Re,t),M(O,e,t),i(e,Xe,t),i(e,j,t),i(e,He,t),M(K,e,t),i(e,Ee,t),M(V,e,t),i(e,Ne,t),i(e,v,t),i(e,Qe,t),i(e,ee,t),i(e,Fe,t),M(te,e,t),i(e,ze,t),i(e,W,t),i(e,Se,t),i(e,le,t),i(e,Le,t),M(ie,e,t),i(e,Ye,t),i(e,se,t),i(e,qe,t),M(ne,e,t),i(e,Pe,t),i(e,oe,t),i(e,De,t),i(e,ae,t),i(e,Ae,t),i(e,pe,t),i(e,Oe,t),M(re,e,t),i(e,Ke,t),i(e,me,t),i(e,et,t),M(ce,e,t),i(e,tt,t),M(G,e,t),i(e,lt,t),i(e,ue,t),it=!0},p(e,[t]){const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),$.$set(jt);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),_.$set(Vt);const vt={};t&2&&(vt.$$scope={dirty:t,ctx:e}),V.$set(vt);const Wt={};t&2&&(Wt.$$scope={dirty:t,ctx:e}),G.$set(Wt)},i(e){it||(h(r.$$.fragment,e),h(J.$$.fragment,e),h(I.$$.fragment,e),h($.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(F.$$.fragment,e),h(_.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(V.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(G.$$.fragment,e),it=!0)},o(e){b(r.$$.fragment,e),b(J.$$.fragment,e),b(I.$$.fragment,e),b($.$$.fragment,e),b(R.$$.fragment,e),b(H.$$.fragment,e),b(E.$$.fragment,e),b(Q.$$.fragment,e),b(F.$$.fragment,e),b(_.$$.fragment,e),b(L.$$.fragment,e),b(A.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(V.$$.fragment,e),b(te.$$.fragment,e),b(ie.$$.fragment,e),b(ne.$$.fragment,e),b(re.$$.fragment,e),b(ce.$$.fragment,e),b(G.$$.fragment,e),it=!1},d(e){e&&(l(T),l(p),l(m),l(a),l(C),l(Me),l(B),l(he),l(k),l(be),l(x),l(we),l(Te),l(Je),l(X),l(Ue),l(Ze),l($e),l(N),l(_e),l(ge),l(je),l(z),l(Ve),l(ve),l(S),l(We),l(Ge),l(Y),l(Ce),l(q),l(Ie),l(P),l(Be),l(D),l(ke),l(xe),l(g),l(Re),l(Xe),l(j),l(He),l(Ee),l(Ne),l(v),l(Qe),l(ee),l(Fe),l(ze),l(W),l(Se),l(le),l(Le),l(Ye),l(se),l(qe),l(Pe),l(oe),l(De),l(ae),l(Ae),l(pe),l(Oe),l(Ke),l(me),l(et),l(tt),l(lt),l(ue)),l(s),w(r,e),w(J,e),w(I,e),w($,e),w(R,e),w(H,e),w(E,e),w(Q,e),w(F,e),w(_,e),w(L,e),w(A,e),w(O,e),w(K,e),w(V,e),w(te,e),w(ie,e),w(ne,e),w(re,e),w(ce,e),w(G,e)}}}const qt='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Load from a local file","local":"load-from-a-local-file","sections":[],"depth":3},{"title":"Load from a specific version","local":"load-from-a-specific-version","sections":[],"depth":3}],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function Pt(U){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends kt{constructor(s){super(),xt(this,s,Pt,Yt,It,{})}}export{il as component};
