import{s as Jc,n as kc,o as Dc}from"../chunks/scheduler.b108d059.js";import{S as qc,i as Ic,g as i,s as n,r as a,A as Kc,h as r,f as l,c as o,j as h,u as m,x as d,k as u,y as Bc,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as em}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function Nc(tm){let $,dn,on,un,y,an,b,mn,v,lm="Helper module for <code>Tensor</code> processing.",pn,M,sm=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,cn,x,nm='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.permute"><code>.permute(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li> <li><a href="#module_utils/tensor.quantize_embeddings"><code>.quantize_embeddings(tensor, precision)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor..args%5B1%5D"><code>~args[1]</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',fn,Tn,hn,C,_n,H,$n,L,om='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',yn,w,im='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+permute"><code>.permute(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',bn,vn,Mn,A,xn,g,Cn,z,rm="Create a new Tensor or copy an existing Tensor.",Hn,P,dm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Ln,wn,An,U,gn,R,zn,E,um="Dimensions of the tensor.",Pn,j,am='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Un,Rn,En,J,jn,k,Jn,D,mm="Type of the tensor.",kn,q,pm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Dn,qn,In,I,Kn,K,Bn,B,cm="The data stored in the tensor.",Nn,N,fm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Vn,Qn,Sn,V,Wn,Q,Yn,S,Tm="The number of elements in the tensor.",Fn,W,hm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',On,Gn,Zn,Y,Xn,F,eo,O,_m=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,to,G,$m='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',lo,so,no,Z,oo,X,io,ee,ym="Index into a Tensor object.",ro,te,bm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',uo,le,vm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",ao,mo,po,se,co,ne,fo,oe,Mm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',To,ie,xm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",ho,_o,$o,re,yo,de,bo,ue,Cm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',vo,ae,Hm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",Mo,xo,Co,me,Ho,pe,Lo,ce,Lm=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,wo,fe,wm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Ao,Te,Am="<li><code>Error</code> If the tensor has more than one element.</li>",go,zo,Po,he,Uo,_e,Ro,$e,gm="Convert tensor data to a n-dimensional JS list",Eo,ye,zm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',jo,Jo,ko,be,Do,ve,qo,Me,Pm="Return a new Tensor with the sigmoid function applied to each element.",Io,xe,Um='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Ko,Bo,No,Ce,Vo,He,Qo,Le,Rm="Applies the sigmoid function to the tensor in place.",So,we,Em='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Wo,Yo,Fo,Ae,Oo,ge,Go,ze,jm="Return a new Tensor with every element multiplied by a constant.",Zo,Pe,Jm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Xo,Ue,km="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",ei,ti,li,Re,si,Ee,ni,je,Dm="Multiply the tensor by a constant in place.",oi,Je,qm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ii,ke,Im="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",ri,di,ui,De,ai,qe,mi,Ie,Km="Return a new Tensor with every element added by a constant.",pi,Ke,Bm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',ci,Be,Nm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",fi,Ti,hi,Ne,_i,Ve,$i,Qe,Vm="Add the tensor by a constant in place.",yi,Se,Qm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',bi,We,Sm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",vi,Mi,xi,Ye,Ci,Fe,Hi,Oe,Wm="Return a permuted version of this Tensor, according to the provided dimensions.",Li,Ge,Ym='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',wi,Ze,Fm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to permute.</p></td></tr></tbody>",Ai,gi,zi,Xe,Pi,et,Ui,tt,Om="Returns the sum of each row of the input tensor in the given dimension dim.",Ri,lt,Gm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Ei,st,Zm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",ji,Ji,ki,nt,Di,ot,qi,it,Xm="Returns the matrix norm or vector norm of a given tensor.",Ii,rt,ep='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Ki,dt,tp=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Bi,Ni,Vi,ut,Qi,at,Si,mt,lp="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Wi,pt,sp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Yi,ct,np="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Fi,Oi,Gi,ft,Zi,Tt,Xi,ht,op="Performs <code>L_p</code> normalization of inputs over specified dimension.",er,_t,ip='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',tr,$t,rp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",lr,sr,nr,yt,or,bt,ir,vt,dp=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,rr,Mt,up='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',dr,ur,ar,xt,mr,Ct,pr,Ht,ap="Returns a tensor with all specified dimensions of input of size 1 removed.",cr,Lt,mp=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,fr,wt,pp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',Tr,At,cp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",hr,_r,$r,gt,yr,zt,br,Pt,fp='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',vr,Ut,Tp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mr,xr,Cr,Rt,Hr,Et,Lr,jt,hp="Returns a new tensor with a dimension of size one inserted at the specified position.",wr,Jt,_p="NOTE: The returned tensor shares the same underlying data with this tensor.",Ar,kt,$p='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',gr,Dt,yp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",zr,Pr,Ur,qt,Rr,It,Er,Kt,bp='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',jr,Bt,vp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Jr,kr,Dr,Nt,qr,Vt,Ir,Qt,Mp='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Kr,St,xp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Br,Nr,Vr,Wt,Qr,Yt,Sr,Ft,Cp=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Wr,Ot,Hp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Yr,Gt,Lp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Fr,Or,Gr,Zt,Zr,Xt,Xr,el,wp="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",ed,tl,Ap='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',td,ll,gp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",ld,sd,nd,sl,od,nl,id,ol,zp='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',rd,il,Pp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',dd,ud,ad,rl,md,dl,pd,ul,Up="Clamps all elements in input into the range [ min, max ]",cd,al,Rp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',fd,ml,Ep="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",Td,hd,_d,pl,$d,cl,yd,fl,jp='In-place version of @see <a href="Tensor.round">Tensor.round</a>',bd,Tl,Jp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',vd,Md,xd,hl,Cd,_l,Hd,$l,kp="Rounds elements of input to the nearest integer.",Ld,yl,Dp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',wd,Ad,gd,bl,zd,vl,Pd,Ml,qp="Performs Tensor dtype conversion.",Ud,xl,Ip='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Rd,Cl,Kp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code>DataType</code></td><td><p>The desired data type.</p></td></tr></tbody>",Ed,jd,Jd,Hl,kd,Ll,Dd,wl,Bp="Permutes a tensor according to the provided axes.",qd,Al,Np='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The permuted tensor.',Id,gl,Vp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to permute.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to permute the tensor along.</p></td></tr></tbody>",Kd,Bd,Nd,zl,Vd,Pl,Qd,Ul,Qp="Interpolates an Tensor to the given size.",Sd,Rl,Sp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Wd,El,Wp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Yd,Fd,Od,jl,Gd,Jl,Zd,kl,Yp="Perform mean pooling of the last hidden state followed by a normalization step.",Xd,Dl,Fp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',eu,ql,Op="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",tu,lu,su,Il,nu,Kl,ou,Bl,Gp="Apply Layer Normalization for last certain number of dimensions.",iu,Nl,Zp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',ru,Vl,Xp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",du,uu,au,Ql,mu,Sl,pu,Wl,ec="Concatenates an array of tensors along a specified dimension.",cu,Yl,tc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',fu,Fl,lc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",Tu,hu,_u,Ol,$u,Gl,yu,Zl,sc="Stack an array of tensors along a specified dimension.",bu,Xl,nc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',vu,es,oc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",Mu,xu,Cu,ts,Hu,ls,Lu,ss,ic="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",wu,ns,rc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',Au,os,dc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",gu,zu,Pu,is,Uu,rs,Ru,ds,uc="Returns the mean value of each row of the input tensor in the given dimension dim.",Eu,us,ac='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',ju,as,mc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Ju,ku,Du,ms,qu,ps,Iu,cs,pc=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Ku,fs,cc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Bu,Ts,fc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",Nu,Vu,Qu,hs,Su,_s,Wu,$s,Tc="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Yu,ys,hc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Fu,bs,_c="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Ou,Gu,Zu,vs,Xu,Ms,ea,xs,$c="Returns a tensor filled with the scalar value 1, with the same size as input.",ta,Cs,yc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',la,Hs,bc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",sa,na,oa,Ls,ia,ws,ra,As,vc="Quantizes the embeddings tensor to binary or unsigned binary precision.",da,gs,Mc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The quantized tensor.',ua,zs,xc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The tensor to quantize.</p></td> </tr><tr><td>precision</td><td><code>&#39;binary&#39;</code> | <code>&#39;ubinary&#39;</code></td><td><p>The precision to use for quantization.</p></td></tr></tbody>",aa,ma,pa,Ps,ca,Us,fa,Rs,Cc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Ta,ha,_a,Es,$a,js,ya,Js,Hc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',ba,va,Ma,ks,xa,Ds,Ca,qs,Lc="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Ha,Is,wc='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',La,Ks,Ac="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",wa,Bs,gc="<strong>Example</strong>",Aa,Ns,ga,za,Pa,Vs,Ua,Qs,Ra,Ss,zc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',Ea,ja,Ja,Ws,ka,Ys,Da,Fs,Pc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',qa,Ia,Ka,Os,Ba,Gs,Na,Zs,Uc="This creates a nested array of a given type and depth (see examples).",Va,Xs,Rc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',Qa,en,Sa,tn,Ec="<strong>Example</strong>",Wa,ln,Ya,sn,jc="<strong>Example</strong>",Fa,nn,Oa,Ga,Za,rn,Xa;return b=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),R=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),k=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),F=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),X=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),ne=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),de=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),_e=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),ve=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ee=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),qe=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.permute(...dims) ⇒ <code> Tensor </code>",local:"tensorpermutedims--code-tensor-code",headingTag:"h3"}}),et=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),ot=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),at=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),bt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),zt=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),Et=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),It=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Yt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),Xt=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),nl=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),dl=new _({props:{title:"tensor.clamp(min, max) ⇒",local:"tensorclampmin-max-",headingTag:"h3"}}),cl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),_l=new _({props:{title:"tensor.round() ⇒",local:"tensorround-",headingTag:"h3"}}),vl=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensorpermutetensor-axes--code-tensor-code",headingTag:"h2"}}),Pl=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Jl=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Kl=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),Sl=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Gl=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),ls=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),ps=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),_s=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),Ms=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>",local:"utilstensorquantizeembeddingstensor-precision--code-tensor-code",headingTag:"h2"}}),Us=new _({props:{title:"utils/tensor~args[0] : <code> DataType </code>",local:"utilstensorargs0--code-datatype-code",headingTag:"h2"}}),js=new _({props:{title:"utils/tensor~args[1] : <code> * </code>",local:"utilstensorargs1--code--code",headingTag:"h2"}}),Ds=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Ns=new em({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),Qs=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Ys=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Gs=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),en=new em({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),ln=new em({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),nn=new em({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=i("meta"),dn=n(),on=i("p"),un=n(),y=i("a"),an=n(),a(b.$$.fragment),mn=n(),v=i("p"),v.innerHTML=lm,pn=n(),M=i("p"),M.textContent=sm,cn=n(),x=i("ul"),x.innerHTML=nm,fn=n(),Tn=i("hr"),hn=n(),C=i("a"),_n=n(),a(H.$$.fragment),$n=n(),L=i("p"),L.innerHTML=om,yn=n(),w=i("ul"),w.innerHTML=im,bn=n(),vn=i("hr"),Mn=n(),A=i("a"),xn=n(),a(g.$$.fragment),Cn=n(),z=i("p"),z.textContent=rm,Hn=n(),P=i("table"),P.innerHTML=dm,Ln=n(),wn=i("hr"),An=n(),U=i("a"),gn=n(),a(R.$$.fragment),zn=n(),E=i("p"),E.textContent=um,Pn=n(),j=i("p"),j.innerHTML=am,Un=n(),Rn=i("hr"),En=n(),J=i("a"),jn=n(),a(k.$$.fragment),Jn=n(),D=i("p"),D.textContent=mm,kn=n(),q=i("p"),q.innerHTML=pm,Dn=n(),qn=i("hr"),In=n(),I=i("a"),Kn=n(),a(K.$$.fragment),Bn=n(),B=i("p"),B.textContent=cm,Nn=n(),N=i("p"),N.innerHTML=fm,Vn=n(),Qn=i("hr"),Sn=n(),V=i("a"),Wn=n(),a(Q.$$.fragment),Yn=n(),S=i("p"),S.textContent=Tm,Fn=n(),W=i("p"),W.innerHTML=hm,On=n(),Gn=i("hr"),Zn=n(),Y=i("a"),Xn=n(),a(F.$$.fragment),eo=n(),O=i("p"),O.textContent=_m,to=n(),G=i("p"),G.innerHTML=$m,lo=n(),so=i("hr"),no=n(),Z=i("a"),oo=n(),a(X.$$.fragment),io=n(),ee=i("p"),ee.textContent=ym,ro=n(),te=i("p"),te.innerHTML=bm,uo=n(),le=i("table"),le.innerHTML=vm,ao=n(),mo=i("hr"),po=n(),se=i("a"),co=n(),a(ne.$$.fragment),fo=n(),oe=i("p"),oe.innerHTML=Mm,To=n(),ie=i("table"),ie.innerHTML=xm,ho=n(),_o=i("hr"),$o=n(),re=i("a"),yo=n(),a(de.$$.fragment),bo=n(),ue=i("p"),ue.innerHTML=Cm,vo=n(),ae=i("table"),ae.innerHTML=Hm,Mo=n(),xo=i("hr"),Co=n(),me=i("a"),Ho=n(),a(pe.$$.fragment),Lo=n(),ce=i("p"),ce.innerHTML=Lm,wo=n(),fe=i("p"),fe.innerHTML=wm,Ao=n(),Te=i("ul"),Te.innerHTML=Am,go=n(),zo=i("hr"),Po=n(),he=i("a"),Uo=n(),a(_e.$$.fragment),Ro=n(),$e=i("p"),$e.textContent=gm,Eo=n(),ye=i("p"),ye.innerHTML=zm,jo=n(),Jo=i("hr"),ko=n(),be=i("a"),Do=n(),a(ve.$$.fragment),qo=n(),Me=i("p"),Me.textContent=Pm,Io=n(),xe=i("p"),xe.innerHTML=Um,Ko=n(),Bo=i("hr"),No=n(),Ce=i("a"),Vo=n(),a(He.$$.fragment),Qo=n(),Le=i("p"),Le.textContent=Rm,So=n(),we=i("p"),we.innerHTML=Em,Wo=n(),Yo=i("hr"),Fo=n(),Ae=i("a"),Oo=n(),a(ge.$$.fragment),Go=n(),ze=i("p"),ze.textContent=jm,Zo=n(),Pe=i("p"),Pe.innerHTML=Jm,Xo=n(),Ue=i("table"),Ue.innerHTML=km,ei=n(),ti=i("hr"),li=n(),Re=i("a"),si=n(),a(Ee.$$.fragment),ni=n(),je=i("p"),je.textContent=Dm,oi=n(),Je=i("p"),Je.innerHTML=qm,ii=n(),ke=i("table"),ke.innerHTML=Im,ri=n(),di=i("hr"),ui=n(),De=i("a"),ai=n(),a(qe.$$.fragment),mi=n(),Ie=i("p"),Ie.textContent=Km,pi=n(),Ke=i("p"),Ke.innerHTML=Bm,ci=n(),Be=i("table"),Be.innerHTML=Nm,fi=n(),Ti=i("hr"),hi=n(),Ne=i("a"),_i=n(),a(Ve.$$.fragment),$i=n(),Qe=i("p"),Qe.textContent=Vm,yi=n(),Se=i("p"),Se.innerHTML=Qm,bi=n(),We=i("table"),We.innerHTML=Sm,vi=n(),Mi=i("hr"),xi=n(),Ye=i("a"),Ci=n(),a(Fe.$$.fragment),Hi=n(),Oe=i("p"),Oe.textContent=Wm,Li=n(),Ge=i("p"),Ge.innerHTML=Ym,wi=n(),Ze=i("table"),Ze.innerHTML=Fm,Ai=n(),gi=i("hr"),zi=n(),Xe=i("a"),Pi=n(),a(et.$$.fragment),Ui=n(),tt=i("p"),tt.textContent=Om,Ri=n(),lt=i("p"),lt.innerHTML=Gm,Ei=n(),st=i("table"),st.innerHTML=Zm,ji=n(),Ji=i("hr"),ki=n(),nt=i("a"),Di=n(),a(ot.$$.fragment),qi=n(),it=i("p"),it.textContent=Xm,Ii=n(),rt=i("p"),rt.innerHTML=ep,Ki=n(),dt=i("table"),dt.innerHTML=tp,Bi=n(),Ni=i("hr"),Vi=n(),ut=i("a"),Qi=n(),a(at.$$.fragment),Si=n(),mt=i("p"),mt.innerHTML=lp,Wi=n(),pt=i("p"),pt.innerHTML=sp,Yi=n(),ct=i("table"),ct.innerHTML=np,Fi=n(),Oi=i("hr"),Gi=n(),ft=i("a"),Zi=n(),a(Tt.$$.fragment),Xi=n(),ht=i("p"),ht.innerHTML=op,er=n(),_t=i("p"),_t.innerHTML=ip,tr=n(),$t=i("table"),$t.innerHTML=rp,lr=n(),sr=i("hr"),nr=n(),yt=i("a"),or=n(),a(bt.$$.fragment),ir=n(),vt=i("p"),vt.textContent=dp,rr=n(),Mt=i("p"),Mt.innerHTML=up,dr=n(),ur=i("hr"),ar=n(),xt=i("a"),mr=n(),a(Ct.$$.fragment),pr=n(),Ht=i("p"),Ht.textContent=ap,cr=n(),Lt=i("p"),Lt.innerHTML=mp,fr=n(),wt=i("p"),wt.innerHTML=pp,Tr=n(),At=i("table"),At.innerHTML=cp,hr=n(),_r=i("hr"),$r=n(),gt=i("a"),yr=n(),a(zt.$$.fragment),br=n(),Pt=i("p"),Pt.innerHTML=fp,vr=n(),Ut=i("p"),Ut.innerHTML=Tp,Mr=n(),xr=i("hr"),Cr=n(),Rt=i("a"),Hr=n(),a(Et.$$.fragment),Lr=n(),jt=i("p"),jt.textContent=hp,wr=n(),Jt=i("p"),Jt.textContent=_p,Ar=n(),kt=i("p"),kt.innerHTML=$p,gr=n(),Dt=i("table"),Dt.innerHTML=yp,zr=n(),Pr=i("hr"),Ur=n(),qt=i("a"),Rr=n(),a(It.$$.fragment),Er=n(),Kt=i("p"),Kt.innerHTML=bp,jr=n(),Bt=i("p"),Bt.innerHTML=vp,Jr=n(),kr=i("hr"),Dr=n(),Nt=i("a"),qr=n(),a(Vt.$$.fragment),Ir=n(),Qt=i("p"),Qt.innerHTML=Mp,Kr=n(),St=i("p"),St.innerHTML=xp,Br=n(),Nr=i("hr"),Vr=n(),Wt=i("a"),Qr=n(),a(Yt.$$.fragment),Sr=n(),Ft=i("p"),Ft.innerHTML=Cp,Wr=n(),Ot=i("p"),Ot.innerHTML=Hp,Yr=n(),Gt=i("table"),Gt.innerHTML=Lp,Fr=n(),Or=i("hr"),Gr=n(),Zt=i("a"),Zr=n(),a(Xt.$$.fragment),Xr=n(),el=i("p"),el.innerHTML=wp,ed=n(),tl=i("p"),tl.innerHTML=Ap,td=n(),ll=i("table"),ll.innerHTML=gp,ld=n(),sd=i("hr"),nd=n(),sl=i("a"),od=n(),a(nl.$$.fragment),id=n(),ol=i("p"),ol.innerHTML=zp,rd=n(),il=i("p"),il.innerHTML=Pp,dd=n(),ud=i("hr"),ad=n(),rl=i("a"),md=n(),a(dl.$$.fragment),pd=n(),ul=i("p"),ul.textContent=Up,cd=n(),al=i("p"),al.innerHTML=Rp,fd=n(),ml=i("table"),ml.innerHTML=Ep,Td=n(),hd=i("hr"),_d=n(),pl=i("a"),$d=n(),a(cl.$$.fragment),yd=n(),fl=i("p"),fl.innerHTML=jp,bd=n(),Tl=i("p"),Tl.innerHTML=Jp,vd=n(),Md=i("hr"),xd=n(),hl=i("a"),Cd=n(),a(_l.$$.fragment),Hd=n(),$l=i("p"),$l.textContent=kp,Ld=n(),yl=i("p"),yl.innerHTML=Dp,wd=n(),Ad=i("hr"),gd=n(),bl=i("a"),zd=n(),a(vl.$$.fragment),Pd=n(),Ml=i("p"),Ml.textContent=qp,Ud=n(),xl=i("p"),xl.innerHTML=Ip,Rd=n(),Cl=i("table"),Cl.innerHTML=Kp,Ed=n(),jd=i("hr"),Jd=n(),Hl=i("a"),kd=n(),a(Ll.$$.fragment),Dd=n(),wl=i("p"),wl.textContent=Bp,qd=n(),Al=i("p"),Al.innerHTML=Np,Id=n(),gl=i("table"),gl.innerHTML=Vp,Kd=n(),Bd=i("hr"),Nd=n(),zl=i("a"),Vd=n(),a(Pl.$$.fragment),Qd=n(),Ul=i("p"),Ul.textContent=Qp,Sd=n(),Rl=i("p"),Rl.innerHTML=Sp,Wd=n(),El=i("table"),El.innerHTML=Wp,Yd=n(),Fd=i("hr"),Od=n(),jl=i("a"),Gd=n(),a(Jl.$$.fragment),Zd=n(),kl=i("p"),kl.textContent=Yp,Xd=n(),Dl=i("p"),Dl.innerHTML=Fp,eu=n(),ql=i("table"),ql.innerHTML=Op,tu=n(),lu=i("hr"),su=n(),Il=i("a"),nu=n(),a(Kl.$$.fragment),ou=n(),Bl=i("p"),Bl.textContent=Gp,iu=n(),Nl=i("p"),Nl.innerHTML=Zp,ru=n(),Vl=i("table"),Vl.innerHTML=Xp,du=n(),uu=i("hr"),au=n(),Ql=i("a"),mu=n(),a(Sl.$$.fragment),pu=n(),Wl=i("p"),Wl.textContent=ec,cu=n(),Yl=i("p"),Yl.innerHTML=tc,fu=n(),Fl=i("table"),Fl.innerHTML=lc,Tu=n(),hu=i("hr"),_u=n(),Ol=i("a"),$u=n(),a(Gl.$$.fragment),yu=n(),Zl=i("p"),Zl.textContent=sc,bu=n(),Xl=i("p"),Xl.innerHTML=nc,vu=n(),es=i("table"),es.innerHTML=oc,Mu=n(),xu=i("hr"),Cu=n(),ts=i("a"),Hu=n(),a(ls.$$.fragment),Lu=n(),ss=i("p"),ss.innerHTML=ic,wu=n(),ns=i("p"),ns.innerHTML=rc,Au=n(),os=i("table"),os.innerHTML=dc,gu=n(),zu=i("hr"),Pu=n(),is=i("a"),Uu=n(),a(rs.$$.fragment),Ru=n(),ds=i("p"),ds.textContent=uc,Eu=n(),us=i("p"),us.innerHTML=ac,ju=n(),as=i("table"),as.innerHTML=mc,Ju=n(),ku=i("hr"),Du=n(),ms=i("a"),qu=n(),a(ps.$$.fragment),Iu=n(),cs=i("p"),cs.textContent=pc,Ku=n(),fs=i("p"),fs.innerHTML=cc,Bu=n(),Ts=i("table"),Ts.innerHTML=fc,Nu=n(),Vu=i("hr"),Qu=n(),hs=i("a"),Su=n(),a(_s.$$.fragment),Wu=n(),$s=i("p"),$s.textContent=Tc,Yu=n(),ys=i("p"),ys.innerHTML=hc,Fu=n(),bs=i("table"),bs.innerHTML=_c,Ou=n(),Gu=i("hr"),Zu=n(),vs=i("a"),Xu=n(),a(Ms.$$.fragment),ea=n(),xs=i("p"),xs.textContent=$c,ta=n(),Cs=i("p"),Cs.innerHTML=yc,la=n(),Hs=i("table"),Hs.innerHTML=bc,sa=n(),na=i("hr"),oa=n(),Ls=i("a"),ia=n(),a(ws.$$.fragment),ra=n(),As=i("p"),As.textContent=vc,da=n(),gs=i("p"),gs.innerHTML=Mc,ua=n(),zs=i("table"),zs.innerHTML=xc,aa=n(),ma=i("hr"),pa=n(),Ps=i("a"),ca=n(),a(Us.$$.fragment),fa=n(),Rs=i("p"),Rs.innerHTML=Cc,Ta=n(),ha=i("hr"),_a=n(),Es=i("a"),$a=n(),a(js.$$.fragment),ya=n(),Js=i("p"),Js.innerHTML=Hc,ba=n(),va=i("hr"),Ma=n(),ks=i("a"),xa=n(),a(Ds.$$.fragment),Ca=n(),qs=i("p"),qs.textContent=Lc,Ha=n(),Is=i("p"),Is.innerHTML=wc,La=n(),Ks=i("table"),Ks.innerHTML=Ac,wa=n(),Bs=i("p"),Bs.innerHTML=gc,Aa=n(),a(Ns.$$.fragment),ga=n(),za=i("hr"),Pa=n(),Vs=i("a"),Ua=n(),a(Qs.$$.fragment),Ra=n(),Ss=i("p"),Ss.innerHTML=zc,Ea=n(),ja=i("hr"),Ja=n(),Ws=i("a"),ka=n(),a(Ys.$$.fragment),Da=n(),Fs=i("p"),Fs.innerHTML=Pc,qa=n(),Ia=i("hr"),Ka=n(),Os=i("a"),Ba=n(),a(Gs.$$.fragment),Na=n(),Zs=i("p"),Zs.textContent=Uc,Va=n(),Xs=i("p"),Xs.innerHTML=Rc,Qa=n(),a(en.$$.fragment),Sa=n(),tn=i("p"),tn.innerHTML=Ec,Wa=n(),a(ln.$$.fragment),Ya=n(),sn=i("p"),sn.innerHTML=jc,Fa=n(),a(nn.$$.fragment),Oa=n(),Ga=i("hr"),Za=n(),rn=i("p"),this.h()},l(e){const t=Kc("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),dn=o(e),on=r(e,"P",{}),h(on).forEach(l),un=o(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(l),an=o(e),m(b.$$.fragment,e),mn=o(e),v=r(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-uw4y1m"&&(v.innerHTML=lm),pn=o(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=sm),cn=o(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-1bjk6s8"&&(x.innerHTML=nm),fn=o(e),Tn=r(e,"HR",{}),hn=o(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),_n=o(e),m(H.$$.fragment,e),$n=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=om),yn=o(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-kawule"&&(w.innerHTML=im),bn=o(e),vn=r(e,"HR",{}),Mn=o(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),xn=o(e),m(g.$$.fragment,e),Cn=o(e),z=r(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-55wecd"&&(z.textContent=rm),Hn=o(e),P=r(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=dm),Ln=o(e),wn=r(e,"HR",{}),An=o(e),U=r(e,"A",{id:!0,class:!0}),h(U).forEach(l),gn=o(e),m(R.$$.fragment,e),zn=o(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1gc2rt4"&&(E.textContent=um),Pn=o(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-10qzguj"&&(j.innerHTML=am),Un=o(e),Rn=r(e,"HR",{}),En=o(e),J=r(e,"A",{id:!0,class:!0}),h(J).forEach(l),jn=o(e),m(k.$$.fragment,e),Jn=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=mm),kn=o(e),q=r(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-10qzguj"&&(q.innerHTML=pm),Dn=o(e),qn=r(e,"HR",{}),In=o(e),I=r(e,"A",{id:!0,class:!0}),h(I).forEach(l),Kn=o(e),m(K.$$.fragment,e),Bn=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1eqabt7"&&(B.textContent=cm),Nn=o(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-10qzguj"&&(N.innerHTML=fm),Vn=o(e),Qn=r(e,"HR",{}),Sn=o(e),V=r(e,"A",{id:!0,class:!0}),h(V).forEach(l),Wn=o(e),m(Q.$$.fragment,e),Yn=o(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=Tm),Fn=o(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-10qzguj"&&(W.innerHTML=hm),On=o(e),Gn=r(e,"HR",{}),Zn=o(e),Y=r(e,"A",{id:!0,class:!0}),h(Y).forEach(l),Xn=o(e),m(F.$$.fragment,e),eo=o(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1adn56z"&&(O.textContent=_m),to=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1gxgvk6"&&(G.innerHTML=$m),lo=o(e),so=r(e,"HR",{}),no=o(e),Z=r(e,"A",{id:!0,class:!0}),h(Z).forEach(l),oo=o(e),m(X.$$.fragment,e),io=o(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1u97xg1"&&(ee.textContent=ym),ro=o(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1afa2dz"&&(te.innerHTML=bm),uo=o(e),le=r(e,"TABLE",{"data-svelte-h":!0}),d(le)!=="svelte-1kq04ga"&&(le.innerHTML=vm),ao=o(e),mo=r(e,"HR",{}),po=o(e),se=r(e,"A",{id:!0,class:!0}),h(se).forEach(l),co=o(e),m(ne.$$.fragment,e),fo=o(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1cg22af"&&(oe.innerHTML=Mm),To=o(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-1hful42"&&(ie.innerHTML=xm),ho=o(e),_o=r(e,"HR",{}),$o=o(e),re=r(e,"A",{id:!0,class:!0}),h(re).forEach(l),yo=o(e),m(de.$$.fragment,e),bo=o(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1mr58c3"&&(ue.innerHTML=Cm),vo=o(e),ae=r(e,"TABLE",{"data-svelte-h":!0}),d(ae)!=="svelte-153ftfy"&&(ae.innerHTML=Hm),Mo=o(e),xo=r(e,"HR",{}),Co=o(e),me=r(e,"A",{id:!0,class:!0}),h(me).forEach(l),Ho=o(e),m(pe.$$.fragment,e),Lo=o(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-13nzfs3"&&(ce.innerHTML=Lm),wo=o(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-11rv1mu"&&(fe.innerHTML=wm),Ao=o(e),Te=r(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-5t2sg3"&&(Te.innerHTML=Am),go=o(e),zo=r(e,"HR",{}),Po=o(e),he=r(e,"A",{id:!0,class:!0}),h(he).forEach(l),Uo=o(e),m(_e.$$.fragment,e),Ro=o(e),$e=r(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-87xdyr"&&($e.textContent=gm),Eo=o(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1mr58c3"&&(ye.innerHTML=zm),jo=o(e),Jo=r(e,"HR",{}),ko=o(e),be=r(e,"A",{id:!0,class:!0}),h(be).forEach(l),Do=o(e),m(ve.$$.fragment,e),qo=o(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-2wti2w"&&(Me.textContent=Pm),Io=o(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-kpq7mo"&&(xe.innerHTML=Um),Ko=o(e),Bo=r(e,"HR",{}),No=o(e),Ce=r(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Vo=o(e),m(He.$$.fragment,e),Qo=o(e),Le=r(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1edu6c8"&&(Le.textContent=Rm),So=o(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1hc4oxa"&&(we.innerHTML=Em),Wo=o(e),Yo=r(e,"HR",{}),Fo=o(e),Ae=r(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Oo=o(e),m(ge.$$.fragment,e),Go=o(e),ze=r(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-xg80lg"&&(ze.textContent=jm),Zo=o(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1aygav2"&&(Pe.innerHTML=Jm),Xo=o(e),Ue=r(e,"TABLE",{"data-svelte-h":!0}),d(Ue)!=="svelte-1tbtmqd"&&(Ue.innerHTML=km),ei=o(e),ti=r(e,"HR",{}),li=o(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),si=o(e),m(Ee.$$.fragment,e),ni=o(e),je=r(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1i12x1s"&&(je.textContent=Dm),oi=o(e),Je=r(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1hc4oxa"&&(Je.innerHTML=qm),ii=o(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-1tbtmqd"&&(ke.innerHTML=Im),ri=o(e),di=r(e,"HR",{}),ui=o(e),De=r(e,"A",{id:!0,class:!0}),h(De).forEach(l),ai=o(e),m(qe.$$.fragment,e),mi=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1hl64jn"&&(Ie.textContent=Km),pi=o(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1aygav2"&&(Ke.innerHTML=Bm),ci=o(e),Be=r(e,"TABLE",{"data-svelte-h":!0}),d(Be)!=="svelte-1p5444"&&(Be.innerHTML=Nm),fi=o(e),Ti=r(e,"HR",{}),hi=o(e),Ne=r(e,"A",{id:!0,class:!0}),h(Ne).forEach(l),_i=o(e),m(Ve.$$.fragment,e),$i=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-bbf4x3"&&(Qe.textContent=Vm),yi=o(e),Se=r(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1hc4oxa"&&(Se.innerHTML=Qm),bi=o(e),We=r(e,"TABLE",{"data-svelte-h":!0}),d(We)!=="svelte-1p5444"&&(We.innerHTML=Sm),vi=o(e),Mi=r(e,"HR",{}),xi=o(e),Ye=r(e,"A",{id:!0,class:!0}),h(Ye).forEach(l),Ci=o(e),m(Fe.$$.fragment,e),Hi=o(e),Oe=r(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1g8ouql"&&(Oe.textContent=Wm),Li=o(e),Ge=r(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1scc4l4"&&(Ge.innerHTML=Ym),wi=o(e),Ze=r(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-1p49qvp"&&(Ze.innerHTML=Fm),Ai=o(e),gi=r(e,"HR",{}),zi=o(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),Pi=o(e),m(et.$$.fragment,e),Ui=o(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-yjryb1"&&(tt.textContent=Om),Ri=o(e),lt=r(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-xtr8tc"&&(lt.innerHTML=Gm),Ei=o(e),st=r(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-6xvdso"&&(st.innerHTML=Zm),ji=o(e),Ji=r(e,"HR",{}),ki=o(e),nt=r(e,"A",{id:!0,class:!0}),h(nt).forEach(l),Di=o(e),m(ot.$$.fragment,e),qi=o(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1okfsqx"&&(it.textContent=Xm),Ii=o(e),rt=r(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t556pk"&&(rt.innerHTML=ep),Ki=o(e),dt=r(e,"TABLE",{"data-svelte-h":!0}),d(dt)!=="svelte-13m2wni"&&(dt.innerHTML=tp),Bi=o(e),Ni=r(e,"HR",{}),Vi=o(e),ut=r(e,"A",{id:!0,class:!0}),h(ut).forEach(l),Qi=o(e),m(at.$$.fragment,e),Si=o(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1htpbrk"&&(mt.innerHTML=lp),Wi=o(e),pt=r(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1t0m8l6"&&(pt.innerHTML=sp),Yi=o(e),ct=r(e,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1qi99pl"&&(ct.innerHTML=np),Fi=o(e),Oi=r(e,"HR",{}),Gi=o(e),ft=r(e,"A",{id:!0,class:!0}),h(ft).forEach(l),Zi=o(e),m(Tt.$$.fragment,e),Xi=o(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1ztgqp"&&(ht.innerHTML=op),er=o(e),_t=r(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-mvb39p"&&(_t.innerHTML=ip),tr=o(e),$t=r(e,"TABLE",{"data-svelte-h":!0}),d($t)!=="svelte-1qi99pl"&&($t.innerHTML=rp),lr=o(e),sr=r(e,"HR",{}),nr=o(e),yt=r(e,"A",{id:!0,class:!0}),h(yt).forEach(l),or=o(e),m(bt.$$.fragment,e),ir=o(e),vt=r(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1a7u185"&&(vt.textContent=dp),rr=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1eu3doh"&&(Mt.innerHTML=up),dr=o(e),ur=r(e,"HR",{}),ar=o(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),mr=o(e),m(Ct.$$.fragment,e),pr=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-qls17b"&&(Ht.textContent=ap),cr=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-5nabmy"&&(Lt.innerHTML=mp),fr=o(e),wt=r(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1skbfxl"&&(wt.innerHTML=pp),Tr=o(e),At=r(e,"TABLE",{"data-svelte-h":!0}),d(At)!=="svelte-52pnzr"&&(At.innerHTML=cp),hr=o(e),_r=r(e,"HR",{}),$r=o(e),gt=r(e,"A",{id:!0,class:!0}),h(gt).forEach(l),yr=o(e),m(zt.$$.fragment,e),br=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-19w0pic"&&(Pt.innerHTML=fp),vr=o(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1mr58c3"&&(Ut.innerHTML=Tp),Mr=o(e),xr=r(e,"HR",{}),Cr=o(e),Rt=r(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),Hr=o(e),m(Et.$$.fragment,e),Lr=o(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-18ws76n"&&(jt.textContent=hp),wr=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1tnr5gm"&&(Jt.textContent=_p),Ar=o(e),kt=r(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1aoa5jo"&&(kt.innerHTML=$p),gr=o(e),Dt=r(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-1u9lyxp"&&(Dt.innerHTML=yp),zr=o(e),Pr=r(e,"HR",{}),Ur=o(e),qt=r(e,"A",{id:!0,class:!0}),h(qt).forEach(l),Rr=o(e),m(It.$$.fragment,e),Er=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1b9ygao"&&(Kt.innerHTML=bp),jr=o(e),Bt=r(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1mr58c3"&&(Bt.innerHTML=vp),Jr=o(e),kr=r(e,"HR",{}),Dr=o(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),qr=o(e),m(Vt.$$.fragment,e),Ir=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1vkr5xo"&&(Qt.innerHTML=Mp),Kr=o(e),St=r(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1mr58c3"&&(St.innerHTML=xp),Br=o(e),Nr=r(e,"HR",{}),Vr=o(e),Wt=r(e,"A",{id:!0,class:!0}),h(Wt).forEach(l),Qr=o(e),m(Yt.$$.fragment,e),Sr=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-1gguudf"&&(Ft.innerHTML=Cp),Wr=o(e),Ot=r(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-9ffe42"&&(Ot.innerHTML=Hp),Yr=o(e),Gt=r(e,"TABLE",{"data-svelte-h":!0}),d(Gt)!=="svelte-z6whez"&&(Gt.innerHTML=Lp),Fr=o(e),Or=r(e,"HR",{}),Gr=o(e),Zt=r(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Zr=o(e),m(Xt.$$.fragment,e),Xr=o(e),el=r(e,"P",{"data-svelte-h":!0}),d(el)!=="svelte-d6gvut"&&(el.innerHTML=wp),ed=o(e),tl=r(e,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-18n9ux4"&&(tl.innerHTML=Ap),td=o(e),ll=r(e,"TABLE",{"data-svelte-h":!0}),d(ll)!=="svelte-jj58dd"&&(ll.innerHTML=gp),ld=o(e),sd=r(e,"HR",{}),nd=o(e),sl=r(e,"A",{id:!0,class:!0}),h(sl).forEach(l),od=o(e),m(nl.$$.fragment,e),id=o(e),ol=r(e,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-1adolpg"&&(ol.innerHTML=zp),rd=o(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1mr58c3"&&(il.innerHTML=Pp),dd=o(e),ud=r(e,"HR",{}),ad=o(e),rl=r(e,"A",{id:!0,class:!0}),h(rl).forEach(l),md=o(e),m(dl.$$.fragment,e),pd=o(e),ul=r(e,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-1hm8vtj"&&(ul.textContent=Up),cd=o(e),al=r(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-106ei5g"&&(al.innerHTML=Rp),fd=o(e),ml=r(e,"TABLE",{"data-svelte-h":!0}),d(ml)!=="svelte-9ff0sy"&&(ml.innerHTML=Ep),Td=o(e),hd=r(e,"HR",{}),_d=o(e),pl=r(e,"A",{id:!0,class:!0}),h(pl).forEach(l),$d=o(e),m(cl.$$.fragment,e),yd=o(e),fl=r(e,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-1e6kzks"&&(fl.innerHTML=jp),bd=o(e),Tl=r(e,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1mr58c3"&&(Tl.innerHTML=Jp),vd=o(e),Md=r(e,"HR",{}),xd=o(e),hl=r(e,"A",{id:!0,class:!0}),h(hl).forEach(l),Cd=o(e),m(_l.$$.fragment,e),Hd=o(e),$l=r(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-t5k6jp"&&($l.textContent=kp),Ld=o(e),yl=r(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-106ei5g"&&(yl.innerHTML=Dp),wd=o(e),Ad=r(e,"HR",{}),gd=o(e),bl=r(e,"A",{id:!0,class:!0}),h(bl).forEach(l),zd=o(e),m(vl.$$.fragment,e),Pd=o(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-avw2a1"&&(Ml.textContent=qp),Ud=o(e),xl=r(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-16q99cu"&&(xl.innerHTML=Ip),Rd=o(e),Cl=r(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-zy0eig"&&(Cl.innerHTML=Kp),Ed=o(e),jd=r(e,"HR",{}),Jd=o(e),Hl=r(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),kd=o(e),m(Ll.$$.fragment,e),Dd=o(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-167n5bd"&&(wl.textContent=Bp),qd=o(e),Al=r(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-1pz529g"&&(Al.innerHTML=Np),Id=o(e),gl=r(e,"TABLE",{"data-svelte-h":!0}),d(gl)!=="svelte-1oyadc3"&&(gl.innerHTML=Vp),Kd=o(e),Bd=r(e,"HR",{}),Nd=o(e),zl=r(e,"A",{id:!0,class:!0}),h(zl).forEach(l),Vd=o(e),m(Pl.$$.fragment,e),Qd=o(e),Ul=r(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-fju8tm"&&(Ul.textContent=Qp),Sd=o(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-13s6o0v"&&(Rl.innerHTML=Sp),Wd=o(e),El=r(e,"TABLE",{"data-svelte-h":!0}),d(El)!=="svelte-8i278m"&&(El.innerHTML=Wp),Yd=o(e),Fd=r(e,"HR",{}),Od=o(e),jl=r(e,"A",{id:!0,class:!0}),h(jl).forEach(l),Gd=o(e),m(Jl.$$.fragment,e),Zd=o(e),kl=r(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-11ei68w"&&(kl.textContent=Yp),Xd=o(e),Dl=r(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1p3llh"&&(Dl.innerHTML=Fp),eu=o(e),ql=r(e,"TABLE",{"data-svelte-h":!0}),d(ql)!=="svelte-1xe0vb8"&&(ql.innerHTML=Op),tu=o(e),lu=r(e,"HR",{}),su=o(e),Il=r(e,"A",{id:!0,class:!0}),h(Il).forEach(l),nu=o(e),m(Kl.$$.fragment,e),ou=o(e),Bl=r(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-7ivim4"&&(Bl.textContent=Gp),iu=o(e),Nl=r(e,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-151n4qz"&&(Nl.innerHTML=Zp),ru=o(e),Vl=r(e,"TABLE",{"data-svelte-h":!0}),d(Vl)!=="svelte-iprxta"&&(Vl.innerHTML=Xp),du=o(e),uu=r(e,"HR",{}),au=o(e),Ql=r(e,"A",{id:!0,class:!0}),h(Ql).forEach(l),mu=o(e),m(Sl.$$.fragment,e),pu=o(e),Wl=r(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-k6p1db"&&(Wl.textContent=ec),cu=o(e),Yl=r(e,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-1o30xnd"&&(Yl.innerHTML=tc),fu=o(e),Fl=r(e,"TABLE",{"data-svelte-h":!0}),d(Fl)!=="svelte-101obk2"&&(Fl.innerHTML=lc),Tu=o(e),hu=r(e,"HR",{}),_u=o(e),Ol=r(e,"A",{id:!0,class:!0}),h(Ol).forEach(l),$u=o(e),m(Gl.$$.fragment,e),yu=o(e),Zl=r(e,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-8afo9v"&&(Zl.textContent=sc),bu=o(e),Xl=r(e,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-1vvmhgz"&&(Xl.innerHTML=nc),vu=o(e),es=r(e,"TABLE",{"data-svelte-h":!0}),d(es)!=="svelte-wz2jkw"&&(es.innerHTML=oc),Mu=o(e),xu=r(e,"HR",{}),Cu=o(e),ts=r(e,"A",{id:!0,class:!0}),h(ts).forEach(l),Hu=o(e),m(ls.$$.fragment,e),Lu=o(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-11plveb"&&(ss.innerHTML=ic),wu=o(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1wu8g4g"&&(ns.innerHTML=rc),Au=o(e),os=r(e,"TABLE",{"data-svelte-h":!0}),d(os)!=="svelte-1vsvca3"&&(os.innerHTML=dc),gu=o(e),zu=r(e,"HR",{}),Pu=o(e),is=r(e,"A",{id:!0,class:!0}),h(is).forEach(l),Uu=o(e),m(rs.$$.fragment,e),Ru=o(e),ds=r(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-17f4oxi"&&(ds.textContent=uc),Eu=o(e),us=r(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1lh8r1a"&&(us.innerHTML=ac),ju=o(e),as=r(e,"TABLE",{"data-svelte-h":!0}),d(as)!=="svelte-m4z8c4"&&(as.innerHTML=mc),Ju=o(e),ku=r(e,"HR",{}),Du=o(e),ms=r(e,"A",{id:!0,class:!0}),h(ms).forEach(l),qu=o(e),m(ps.$$.fragment,e),Iu=o(e),cs=r(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-kcewlk"&&(cs.textContent=pc),Ku=o(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-17f480h"&&(fs.innerHTML=cc),Bu=o(e),Ts=r(e,"TABLE",{"data-svelte-h":!0}),d(Ts)!=="svelte-1to7jw8"&&(Ts.innerHTML=fc),Nu=o(e),Vu=r(e,"HR",{}),Qu=o(e),hs=r(e,"A",{id:!0,class:!0}),h(hs).forEach(l),Su=o(e),m(_s.$$.fragment,e),Wu=o(e),$s=r(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-1ayje0f"&&($s.textContent=Tc),Yu=o(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-17f480h"&&(ys.innerHTML=hc),Fu=o(e),bs=r(e,"TABLE",{"data-svelte-h":!0}),d(bs)!=="svelte-gyxne1"&&(bs.innerHTML=_c),Ou=o(e),Gu=r(e,"HR",{}),Zu=o(e),vs=r(e,"A",{id:!0,class:!0}),h(vs).forEach(l),Xu=o(e),m(Ms.$$.fragment,e),ea=o(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-1wvb8sq"&&(xs.textContent=$c),ta=o(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-154yhp4"&&(Cs.innerHTML=yc),la=o(e),Hs=r(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1fk5fng"&&(Hs.innerHTML=bc),sa=o(e),na=r(e,"HR",{}),oa=o(e),Ls=r(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),ia=o(e),m(ws.$$.fragment,e),ra=o(e),As=r(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-185sm1b"&&(As.textContent=vc),da=o(e),gs=r(e,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-1y8qzzr"&&(gs.innerHTML=Mc),ua=o(e),zs=r(e,"TABLE",{"data-svelte-h":!0}),d(zs)!=="svelte-1v01t7k"&&(zs.innerHTML=xc),aa=o(e),ma=r(e,"HR",{}),pa=o(e),Ps=r(e,"A",{id:!0,class:!0}),h(Ps).forEach(l),ca=o(e),m(Us.$$.fragment,e),fa=o(e),Rs=r(e,"P",{"data-svelte-h":!0}),d(Rs)!=="svelte-12loz97"&&(Rs.innerHTML=Cc),Ta=o(e),ha=r(e,"HR",{}),_a=o(e),Es=r(e,"A",{id:!0,class:!0}),h(Es).forEach(l),$a=o(e),m(js.$$.fragment,e),ya=o(e),Js=r(e,"P",{"data-svelte-h":!0}),d(Js)!=="svelte-12loz97"&&(Js.innerHTML=Hc),ba=o(e),va=r(e,"HR",{}),Ma=o(e),ks=r(e,"A",{id:!0,class:!0}),h(ks).forEach(l),xa=o(e),m(Ds.$$.fragment,e),Ca=o(e),qs=r(e,"P",{"data-svelte-h":!0}),d(qs)!=="svelte-40isdg"&&(qs.textContent=Lc),Ha=o(e),Is=r(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-tlsa2h"&&(Is.innerHTML=wc),La=o(e),Ks=r(e,"TABLE",{"data-svelte-h":!0}),d(Ks)!=="svelte-17343p6"&&(Ks.innerHTML=Ac),wa=o(e),Bs=r(e,"P",{"data-svelte-h":!0}),d(Bs)!=="svelte-1aswmub"&&(Bs.innerHTML=gc),Aa=o(e),m(Ns.$$.fragment,e),ga=o(e),za=r(e,"HR",{}),Pa=o(e),Vs=r(e,"A",{id:!0,class:!0}),h(Vs).forEach(l),Ua=o(e),m(Qs.$$.fragment,e),Ra=o(e),Ss=r(e,"P",{"data-svelte-h":!0}),d(Ss)!=="svelte-kp31r8"&&(Ss.innerHTML=zc),Ea=o(e),ja=r(e,"HR",{}),Ja=o(e),Ws=r(e,"A",{id:!0,class:!0}),h(Ws).forEach(l),ka=o(e),m(Ys.$$.fragment,e),Da=o(e),Fs=r(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1fs9no9"&&(Fs.innerHTML=Pc),qa=o(e),Ia=r(e,"HR",{}),Ka=o(e),Os=r(e,"A",{id:!0,class:!0}),h(Os).forEach(l),Ba=o(e),m(Gs.$$.fragment,e),Na=o(e),Zs=r(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-2mif9c"&&(Zs.textContent=Uc),Va=o(e),Xs=r(e,"P",{"data-svelte-h":!0}),d(Xs)!=="svelte-1jas2kw"&&(Xs.innerHTML=Rc),Qa=o(e),m(en.$$.fragment,e),Sa=o(e),tn=r(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-1aswmub"&&(tn.innerHTML=Ec),Wa=o(e),m(ln.$$.fragment,e),Ya=o(e),sn=r(e,"P",{"data-svelte-h":!0}),d(sn)!=="svelte-1aswmub"&&(sn.innerHTML=jc),Fa=o(e),m(nn.$$.fragment,e),Oa=o(e),Ga=r(e,"HR",{}),Za=o(e),rn=r(e,"P",{}),h(rn).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",Vc),u(y,"id","module_utils/tensor"),u(y,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(U,"id","module_utils/tensor.Tensor+dims"),u(U,"class","group"),u(J,"id","module_utils/tensor.Tensor+type"),u(J,"class","group"),u(I,"id","module_utils/tensor.Tensor+data"),u(I,"class","group"),u(V,"id","module_utils/tensor.Tensor+size"),u(V,"class","group"),u(Y,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(Y,"class","group"),u(Z,"id","module_utils/tensor.Tensor+_getitem"),u(Z,"class","group"),u(se,"id","module_utils/tensor.Tensor+indexOf"),u(se,"class","group"),u(re,"id","module_utils/tensor.Tensor+_subarray"),u(re,"class","group"),u(me,"id","module_utils/tensor.Tensor+item"),u(me,"class","group"),u(he,"id","module_utils/tensor.Tensor+tolist"),u(he,"class","group"),u(be,"id","module_utils/tensor.Tensor+sigmoid"),u(be,"class","group"),u(Ce,"id","module_utils/tensor.Tensor+sigmoid_"),u(Ce,"class","group"),u(Ae,"id","module_utils/tensor.Tensor+mul"),u(Ae,"class","group"),u(Re,"id","module_utils/tensor.Tensor+mul_"),u(Re,"class","group"),u(De,"id","module_utils/tensor.Tensor+add"),u(De,"class","group"),u(Ne,"id","module_utils/tensor.Tensor+add_"),u(Ne,"class","group"),u(Ye,"id","module_utils/tensor.Tensor+permute"),u(Ye,"class","group"),u(Xe,"id","module_utils/tensor.Tensor+sum"),u(Xe,"class","group"),u(nt,"id","module_utils/tensor.Tensor+norm"),u(nt,"class","group"),u(ut,"id","module_utils/tensor.Tensor+normalize_"),u(ut,"class","group"),u(ft,"id","module_utils/tensor.Tensor+normalize"),u(ft,"class","group"),u(yt,"id","module_utils/tensor.Tensor+stride"),u(yt,"class","group"),u(xt,"id","module_utils/tensor.Tensor+squeeze"),u(xt,"class","group"),u(gt,"id","module_utils/tensor.Tensor+squeeze_"),u(gt,"class","group"),u(Rt,"id","module_utils/tensor.Tensor+unsqueeze"),u(Rt,"class","group"),u(qt,"id","module_utils/tensor.Tensor+unsqueeze_"),u(qt,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+flatten_"),u(Nt,"class","group"),u(Wt,"id","module_utils/tensor.Tensor+flatten"),u(Wt,"class","group"),u(Zt,"id","module_utils/tensor.Tensor+view"),u(Zt,"class","group"),u(sl,"id","module_utils/tensor.Tensor+clamp_"),u(sl,"class","group"),u(rl,"id","module_utils/tensor.Tensor+clamp"),u(rl,"class","group"),u(pl,"id","module_utils/tensor.Tensor+round_"),u(pl,"class","group"),u(hl,"id","module_utils/tensor.Tensor+round"),u(hl,"class","group"),u(bl,"id","module_utils/tensor.Tensor+to"),u(bl,"class","group"),u(Hl,"id","module_utils/tensor.permute"),u(Hl,"class","group"),u(zl,"id","module_utils/tensor.interpolate"),u(zl,"class","group"),u(jl,"id","module_utils/tensor.mean_pooling"),u(jl,"class","group"),u(Il,"id","module_utils/tensor.layer_norm"),u(Il,"class","group"),u(Ql,"id","module_utils/tensor.cat"),u(Ql,"class","group"),u(Ol,"id","module_utils/tensor.stack"),u(Ol,"class","group"),u(ts,"id","module_utils/tensor.std_mean"),u(ts,"class","group"),u(is,"id","module_utils/tensor.mean"),u(is,"class","group"),u(ms,"id","module_utils/tensor.dynamicTimeWarping"),u(ms,"class","group"),u(hs,"id","module_utils/tensor.ones"),u(hs,"class","group"),u(vs,"id","module_utils/tensor.ones_like"),u(vs,"class","group"),u(Ls,"id","module_utils/tensor.quantize_embeddings"),u(Ls,"class","group"),u(Ps,"id","module_utils/tensor..args[0]"),u(Ps,"class","group"),u(Es,"id","module_utils/tensor..args[1]"),u(Es,"class","group"),u(ks,"id","module_utils/tensor..reshape"),u(ks,"class","group"),u(Vs,"id","module_utils/tensor..reshape..reshapedArray"),u(Vs,"class","group"),u(Ws,"id","module_utils/tensor..DataArray"),u(Ws,"class","group"),u(Os,"id","module_utils/tensor..NestArray"),u(Os,"class","group")},m(e,t){Bc(document.head,$),s(e,dn,t),s(e,on,t),s(e,un,t),s(e,y,t),s(e,an,t),p(b,e,t),s(e,mn,t),s(e,v,t),s(e,pn,t),s(e,M,t),s(e,cn,t),s(e,x,t),s(e,fn,t),s(e,Tn,t),s(e,hn,t),s(e,C,t),s(e,_n,t),p(H,e,t),s(e,$n,t),s(e,L,t),s(e,yn,t),s(e,w,t),s(e,bn,t),s(e,vn,t),s(e,Mn,t),s(e,A,t),s(e,xn,t),p(g,e,t),s(e,Cn,t),s(e,z,t),s(e,Hn,t),s(e,P,t),s(e,Ln,t),s(e,wn,t),s(e,An,t),s(e,U,t),s(e,gn,t),p(R,e,t),s(e,zn,t),s(e,E,t),s(e,Pn,t),s(e,j,t),s(e,Un,t),s(e,Rn,t),s(e,En,t),s(e,J,t),s(e,jn,t),p(k,e,t),s(e,Jn,t),s(e,D,t),s(e,kn,t),s(e,q,t),s(e,Dn,t),s(e,qn,t),s(e,In,t),s(e,I,t),s(e,Kn,t),p(K,e,t),s(e,Bn,t),s(e,B,t),s(e,Nn,t),s(e,N,t),s(e,Vn,t),s(e,Qn,t),s(e,Sn,t),s(e,V,t),s(e,Wn,t),p(Q,e,t),s(e,Yn,t),s(e,S,t),s(e,Fn,t),s(e,W,t),s(e,On,t),s(e,Gn,t),s(e,Zn,t),s(e,Y,t),s(e,Xn,t),p(F,e,t),s(e,eo,t),s(e,O,t),s(e,to,t),s(e,G,t),s(e,lo,t),s(e,so,t),s(e,no,t),s(e,Z,t),s(e,oo,t),p(X,e,t),s(e,io,t),s(e,ee,t),s(e,ro,t),s(e,te,t),s(e,uo,t),s(e,le,t),s(e,ao,t),s(e,mo,t),s(e,po,t),s(e,se,t),s(e,co,t),p(ne,e,t),s(e,fo,t),s(e,oe,t),s(e,To,t),s(e,ie,t),s(e,ho,t),s(e,_o,t),s(e,$o,t),s(e,re,t),s(e,yo,t),p(de,e,t),s(e,bo,t),s(e,ue,t),s(e,vo,t),s(e,ae,t),s(e,Mo,t),s(e,xo,t),s(e,Co,t),s(e,me,t),s(e,Ho,t),p(pe,e,t),s(e,Lo,t),s(e,ce,t),s(e,wo,t),s(e,fe,t),s(e,Ao,t),s(e,Te,t),s(e,go,t),s(e,zo,t),s(e,Po,t),s(e,he,t),s(e,Uo,t),p(_e,e,t),s(e,Ro,t),s(e,$e,t),s(e,Eo,t),s(e,ye,t),s(e,jo,t),s(e,Jo,t),s(e,ko,t),s(e,be,t),s(e,Do,t),p(ve,e,t),s(e,qo,t),s(e,Me,t),s(e,Io,t),s(e,xe,t),s(e,Ko,t),s(e,Bo,t),s(e,No,t),s(e,Ce,t),s(e,Vo,t),p(He,e,t),s(e,Qo,t),s(e,Le,t),s(e,So,t),s(e,we,t),s(e,Wo,t),s(e,Yo,t),s(e,Fo,t),s(e,Ae,t),s(e,Oo,t),p(ge,e,t),s(e,Go,t),s(e,ze,t),s(e,Zo,t),s(e,Pe,t),s(e,Xo,t),s(e,Ue,t),s(e,ei,t),s(e,ti,t),s(e,li,t),s(e,Re,t),s(e,si,t),p(Ee,e,t),s(e,ni,t),s(e,je,t),s(e,oi,t),s(e,Je,t),s(e,ii,t),s(e,ke,t),s(e,ri,t),s(e,di,t),s(e,ui,t),s(e,De,t),s(e,ai,t),p(qe,e,t),s(e,mi,t),s(e,Ie,t),s(e,pi,t),s(e,Ke,t),s(e,ci,t),s(e,Be,t),s(e,fi,t),s(e,Ti,t),s(e,hi,t),s(e,Ne,t),s(e,_i,t),p(Ve,e,t),s(e,$i,t),s(e,Qe,t),s(e,yi,t),s(e,Se,t),s(e,bi,t),s(e,We,t),s(e,vi,t),s(e,Mi,t),s(e,xi,t),s(e,Ye,t),s(e,Ci,t),p(Fe,e,t),s(e,Hi,t),s(e,Oe,t),s(e,Li,t),s(e,Ge,t),s(e,wi,t),s(e,Ze,t),s(e,Ai,t),s(e,gi,t),s(e,zi,t),s(e,Xe,t),s(e,Pi,t),p(et,e,t),s(e,Ui,t),s(e,tt,t),s(e,Ri,t),s(e,lt,t),s(e,Ei,t),s(e,st,t),s(e,ji,t),s(e,Ji,t),s(e,ki,t),s(e,nt,t),s(e,Di,t),p(ot,e,t),s(e,qi,t),s(e,it,t),s(e,Ii,t),s(e,rt,t),s(e,Ki,t),s(e,dt,t),s(e,Bi,t),s(e,Ni,t),s(e,Vi,t),s(e,ut,t),s(e,Qi,t),p(at,e,t),s(e,Si,t),s(e,mt,t),s(e,Wi,t),s(e,pt,t),s(e,Yi,t),s(e,ct,t),s(e,Fi,t),s(e,Oi,t),s(e,Gi,t),s(e,ft,t),s(e,Zi,t),p(Tt,e,t),s(e,Xi,t),s(e,ht,t),s(e,er,t),s(e,_t,t),s(e,tr,t),s(e,$t,t),s(e,lr,t),s(e,sr,t),s(e,nr,t),s(e,yt,t),s(e,or,t),p(bt,e,t),s(e,ir,t),s(e,vt,t),s(e,rr,t),s(e,Mt,t),s(e,dr,t),s(e,ur,t),s(e,ar,t),s(e,xt,t),s(e,mr,t),p(Ct,e,t),s(e,pr,t),s(e,Ht,t),s(e,cr,t),s(e,Lt,t),s(e,fr,t),s(e,wt,t),s(e,Tr,t),s(e,At,t),s(e,hr,t),s(e,_r,t),s(e,$r,t),s(e,gt,t),s(e,yr,t),p(zt,e,t),s(e,br,t),s(e,Pt,t),s(e,vr,t),s(e,Ut,t),s(e,Mr,t),s(e,xr,t),s(e,Cr,t),s(e,Rt,t),s(e,Hr,t),p(Et,e,t),s(e,Lr,t),s(e,jt,t),s(e,wr,t),s(e,Jt,t),s(e,Ar,t),s(e,kt,t),s(e,gr,t),s(e,Dt,t),s(e,zr,t),s(e,Pr,t),s(e,Ur,t),s(e,qt,t),s(e,Rr,t),p(It,e,t),s(e,Er,t),s(e,Kt,t),s(e,jr,t),s(e,Bt,t),s(e,Jr,t),s(e,kr,t),s(e,Dr,t),s(e,Nt,t),s(e,qr,t),p(Vt,e,t),s(e,Ir,t),s(e,Qt,t),s(e,Kr,t),s(e,St,t),s(e,Br,t),s(e,Nr,t),s(e,Vr,t),s(e,Wt,t),s(e,Qr,t),p(Yt,e,t),s(e,Sr,t),s(e,Ft,t),s(e,Wr,t),s(e,Ot,t),s(e,Yr,t),s(e,Gt,t),s(e,Fr,t),s(e,Or,t),s(e,Gr,t),s(e,Zt,t),s(e,Zr,t),p(Xt,e,t),s(e,Xr,t),s(e,el,t),s(e,ed,t),s(e,tl,t),s(e,td,t),s(e,ll,t),s(e,ld,t),s(e,sd,t),s(e,nd,t),s(e,sl,t),s(e,od,t),p(nl,e,t),s(e,id,t),s(e,ol,t),s(e,rd,t),s(e,il,t),s(e,dd,t),s(e,ud,t),s(e,ad,t),s(e,rl,t),s(e,md,t),p(dl,e,t),s(e,pd,t),s(e,ul,t),s(e,cd,t),s(e,al,t),s(e,fd,t),s(e,ml,t),s(e,Td,t),s(e,hd,t),s(e,_d,t),s(e,pl,t),s(e,$d,t),p(cl,e,t),s(e,yd,t),s(e,fl,t),s(e,bd,t),s(e,Tl,t),s(e,vd,t),s(e,Md,t),s(e,xd,t),s(e,hl,t),s(e,Cd,t),p(_l,e,t),s(e,Hd,t),s(e,$l,t),s(e,Ld,t),s(e,yl,t),s(e,wd,t),s(e,Ad,t),s(e,gd,t),s(e,bl,t),s(e,zd,t),p(vl,e,t),s(e,Pd,t),s(e,Ml,t),s(e,Ud,t),s(e,xl,t),s(e,Rd,t),s(e,Cl,t),s(e,Ed,t),s(e,jd,t),s(e,Jd,t),s(e,Hl,t),s(e,kd,t),p(Ll,e,t),s(e,Dd,t),s(e,wl,t),s(e,qd,t),s(e,Al,t),s(e,Id,t),s(e,gl,t),s(e,Kd,t),s(e,Bd,t),s(e,Nd,t),s(e,zl,t),s(e,Vd,t),p(Pl,e,t),s(e,Qd,t),s(e,Ul,t),s(e,Sd,t),s(e,Rl,t),s(e,Wd,t),s(e,El,t),s(e,Yd,t),s(e,Fd,t),s(e,Od,t),s(e,jl,t),s(e,Gd,t),p(Jl,e,t),s(e,Zd,t),s(e,kl,t),s(e,Xd,t),s(e,Dl,t),s(e,eu,t),s(e,ql,t),s(e,tu,t),s(e,lu,t),s(e,su,t),s(e,Il,t),s(e,nu,t),p(Kl,e,t),s(e,ou,t),s(e,Bl,t),s(e,iu,t),s(e,Nl,t),s(e,ru,t),s(e,Vl,t),s(e,du,t),s(e,uu,t),s(e,au,t),s(e,Ql,t),s(e,mu,t),p(Sl,e,t),s(e,pu,t),s(e,Wl,t),s(e,cu,t),s(e,Yl,t),s(e,fu,t),s(e,Fl,t),s(e,Tu,t),s(e,hu,t),s(e,_u,t),s(e,Ol,t),s(e,$u,t),p(Gl,e,t),s(e,yu,t),s(e,Zl,t),s(e,bu,t),s(e,Xl,t),s(e,vu,t),s(e,es,t),s(e,Mu,t),s(e,xu,t),s(e,Cu,t),s(e,ts,t),s(e,Hu,t),p(ls,e,t),s(e,Lu,t),s(e,ss,t),s(e,wu,t),s(e,ns,t),s(e,Au,t),s(e,os,t),s(e,gu,t),s(e,zu,t),s(e,Pu,t),s(e,is,t),s(e,Uu,t),p(rs,e,t),s(e,Ru,t),s(e,ds,t),s(e,Eu,t),s(e,us,t),s(e,ju,t),s(e,as,t),s(e,Ju,t),s(e,ku,t),s(e,Du,t),s(e,ms,t),s(e,qu,t),p(ps,e,t),s(e,Iu,t),s(e,cs,t),s(e,Ku,t),s(e,fs,t),s(e,Bu,t),s(e,Ts,t),s(e,Nu,t),s(e,Vu,t),s(e,Qu,t),s(e,hs,t),s(e,Su,t),p(_s,e,t),s(e,Wu,t),s(e,$s,t),s(e,Yu,t),s(e,ys,t),s(e,Fu,t),s(e,bs,t),s(e,Ou,t),s(e,Gu,t),s(e,Zu,t),s(e,vs,t),s(e,Xu,t),p(Ms,e,t),s(e,ea,t),s(e,xs,t),s(e,ta,t),s(e,Cs,t),s(e,la,t),s(e,Hs,t),s(e,sa,t),s(e,na,t),s(e,oa,t),s(e,Ls,t),s(e,ia,t),p(ws,e,t),s(e,ra,t),s(e,As,t),s(e,da,t),s(e,gs,t),s(e,ua,t),s(e,zs,t),s(e,aa,t),s(e,ma,t),s(e,pa,t),s(e,Ps,t),s(e,ca,t),p(Us,e,t),s(e,fa,t),s(e,Rs,t),s(e,Ta,t),s(e,ha,t),s(e,_a,t),s(e,Es,t),s(e,$a,t),p(js,e,t),s(e,ya,t),s(e,Js,t),s(e,ba,t),s(e,va,t),s(e,Ma,t),s(e,ks,t),s(e,xa,t),p(Ds,e,t),s(e,Ca,t),s(e,qs,t),s(e,Ha,t),s(e,Is,t),s(e,La,t),s(e,Ks,t),s(e,wa,t),s(e,Bs,t),s(e,Aa,t),p(Ns,e,t),s(e,ga,t),s(e,za,t),s(e,Pa,t),s(e,Vs,t),s(e,Ua,t),p(Qs,e,t),s(e,Ra,t),s(e,Ss,t),s(e,Ea,t),s(e,ja,t),s(e,Ja,t),s(e,Ws,t),s(e,ka,t),p(Ys,e,t),s(e,Da,t),s(e,Fs,t),s(e,qa,t),s(e,Ia,t),s(e,Ka,t),s(e,Os,t),s(e,Ba,t),p(Gs,e,t),s(e,Na,t),s(e,Zs,t),s(e,Va,t),s(e,Xs,t),s(e,Qa,t),p(en,e,t),s(e,Sa,t),s(e,tn,t),s(e,Wa,t),p(ln,e,t),s(e,Ya,t),s(e,sn,t),s(e,Fa,t),p(nn,e,t),s(e,Oa,t),s(e,Ga,t),s(e,Za,t),s(e,rn,t),Xa=!0},p:kc,i(e){Xa||(c(b.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(X.$$.fragment,e),c(ne.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(_e.$$.fragment,e),c(ve.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(Ee.$$.fragment,e),c(qe.$$.fragment,e),c(Ve.$$.fragment,e),c(Fe.$$.fragment,e),c(et.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(Tt.$$.fragment,e),c(bt.$$.fragment,e),c(Ct.$$.fragment,e),c(zt.$$.fragment,e),c(Et.$$.fragment,e),c(It.$$.fragment,e),c(Vt.$$.fragment,e),c(Yt.$$.fragment,e),c(Xt.$$.fragment,e),c(nl.$$.fragment,e),c(dl.$$.fragment,e),c(cl.$$.fragment,e),c(_l.$$.fragment,e),c(vl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(Jl.$$.fragment,e),c(Kl.$$.fragment,e),c(Sl.$$.fragment,e),c(Gl.$$.fragment,e),c(ls.$$.fragment,e),c(rs.$$.fragment,e),c(ps.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(js.$$.fragment,e),c(Ds.$$.fragment,e),c(Ns.$$.fragment,e),c(Qs.$$.fragment,e),c(Ys.$$.fragment,e),c(Gs.$$.fragment,e),c(en.$$.fragment,e),c(ln.$$.fragment,e),c(nn.$$.fragment,e),Xa=!0)},o(e){f(b.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(R.$$.fragment,e),f(k.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(F.$$.fragment,e),f(X.$$.fragment,e),f(ne.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(Ee.$$.fragment,e),f(qe.$$.fragment,e),f(Ve.$$.fragment,e),f(Fe.$$.fragment,e),f(et.$$.fragment,e),f(ot.$$.fragment,e),f(at.$$.fragment,e),f(Tt.$$.fragment,e),f(bt.$$.fragment,e),f(Ct.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),f(It.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(Xt.$$.fragment,e),f(nl.$$.fragment,e),f(dl.$$.fragment,e),f(cl.$$.fragment,e),f(_l.$$.fragment,e),f(vl.$$.fragment,e),f(Ll.$$.fragment,e),f(Pl.$$.fragment,e),f(Jl.$$.fragment,e),f(Kl.$$.fragment,e),f(Sl.$$.fragment,e),f(Gl.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(ps.$$.fragment,e),f(_s.$$.fragment,e),f(Ms.$$.fragment,e),f(ws.$$.fragment,e),f(Us.$$.fragment,e),f(js.$$.fragment,e),f(Ds.$$.fragment,e),f(Ns.$$.fragment,e),f(Qs.$$.fragment,e),f(Ys.$$.fragment,e),f(Gs.$$.fragment,e),f(en.$$.fragment,e),f(ln.$$.fragment,e),f(nn.$$.fragment,e),Xa=!1},d(e){e&&(l(dn),l(on),l(un),l(y),l(an),l(mn),l(v),l(pn),l(M),l(cn),l(x),l(fn),l(Tn),l(hn),l(C),l(_n),l($n),l(L),l(yn),l(w),l(bn),l(vn),l(Mn),l(A),l(xn),l(Cn),l(z),l(Hn),l(P),l(Ln),l(wn),l(An),l(U),l(gn),l(zn),l(E),l(Pn),l(j),l(Un),l(Rn),l(En),l(J),l(jn),l(Jn),l(D),l(kn),l(q),l(Dn),l(qn),l(In),l(I),l(Kn),l(Bn),l(B),l(Nn),l(N),l(Vn),l(Qn),l(Sn),l(V),l(Wn),l(Yn),l(S),l(Fn),l(W),l(On),l(Gn),l(Zn),l(Y),l(Xn),l(eo),l(O),l(to),l(G),l(lo),l(so),l(no),l(Z),l(oo),l(io),l(ee),l(ro),l(te),l(uo),l(le),l(ao),l(mo),l(po),l(se),l(co),l(fo),l(oe),l(To),l(ie),l(ho),l(_o),l($o),l(re),l(yo),l(bo),l(ue),l(vo),l(ae),l(Mo),l(xo),l(Co),l(me),l(Ho),l(Lo),l(ce),l(wo),l(fe),l(Ao),l(Te),l(go),l(zo),l(Po),l(he),l(Uo),l(Ro),l($e),l(Eo),l(ye),l(jo),l(Jo),l(ko),l(be),l(Do),l(qo),l(Me),l(Io),l(xe),l(Ko),l(Bo),l(No),l(Ce),l(Vo),l(Qo),l(Le),l(So),l(we),l(Wo),l(Yo),l(Fo),l(Ae),l(Oo),l(Go),l(ze),l(Zo),l(Pe),l(Xo),l(Ue),l(ei),l(ti),l(li),l(Re),l(si),l(ni),l(je),l(oi),l(Je),l(ii),l(ke),l(ri),l(di),l(ui),l(De),l(ai),l(mi),l(Ie),l(pi),l(Ke),l(ci),l(Be),l(fi),l(Ti),l(hi),l(Ne),l(_i),l($i),l(Qe),l(yi),l(Se),l(bi),l(We),l(vi),l(Mi),l(xi),l(Ye),l(Ci),l(Hi),l(Oe),l(Li),l(Ge),l(wi),l(Ze),l(Ai),l(gi),l(zi),l(Xe),l(Pi),l(Ui),l(tt),l(Ri),l(lt),l(Ei),l(st),l(ji),l(Ji),l(ki),l(nt),l(Di),l(qi),l(it),l(Ii),l(rt),l(Ki),l(dt),l(Bi),l(Ni),l(Vi),l(ut),l(Qi),l(Si),l(mt),l(Wi),l(pt),l(Yi),l(ct),l(Fi),l(Oi),l(Gi),l(ft),l(Zi),l(Xi),l(ht),l(er),l(_t),l(tr),l($t),l(lr),l(sr),l(nr),l(yt),l(or),l(ir),l(vt),l(rr),l(Mt),l(dr),l(ur),l(ar),l(xt),l(mr),l(pr),l(Ht),l(cr),l(Lt),l(fr),l(wt),l(Tr),l(At),l(hr),l(_r),l($r),l(gt),l(yr),l(br),l(Pt),l(vr),l(Ut),l(Mr),l(xr),l(Cr),l(Rt),l(Hr),l(Lr),l(jt),l(wr),l(Jt),l(Ar),l(kt),l(gr),l(Dt),l(zr),l(Pr),l(Ur),l(qt),l(Rr),l(Er),l(Kt),l(jr),l(Bt),l(Jr),l(kr),l(Dr),l(Nt),l(qr),l(Ir),l(Qt),l(Kr),l(St),l(Br),l(Nr),l(Vr),l(Wt),l(Qr),l(Sr),l(Ft),l(Wr),l(Ot),l(Yr),l(Gt),l(Fr),l(Or),l(Gr),l(Zt),l(Zr),l(Xr),l(el),l(ed),l(tl),l(td),l(ll),l(ld),l(sd),l(nd),l(sl),l(od),l(id),l(ol),l(rd),l(il),l(dd),l(ud),l(ad),l(rl),l(md),l(pd),l(ul),l(cd),l(al),l(fd),l(ml),l(Td),l(hd),l(_d),l(pl),l($d),l(yd),l(fl),l(bd),l(Tl),l(vd),l(Md),l(xd),l(hl),l(Cd),l(Hd),l($l),l(Ld),l(yl),l(wd),l(Ad),l(gd),l(bl),l(zd),l(Pd),l(Ml),l(Ud),l(xl),l(Rd),l(Cl),l(Ed),l(jd),l(Jd),l(Hl),l(kd),l(Dd),l(wl),l(qd),l(Al),l(Id),l(gl),l(Kd),l(Bd),l(Nd),l(zl),l(Vd),l(Qd),l(Ul),l(Sd),l(Rl),l(Wd),l(El),l(Yd),l(Fd),l(Od),l(jl),l(Gd),l(Zd),l(kl),l(Xd),l(Dl),l(eu),l(ql),l(tu),l(lu),l(su),l(Il),l(nu),l(ou),l(Bl),l(iu),l(Nl),l(ru),l(Vl),l(du),l(uu),l(au),l(Ql),l(mu),l(pu),l(Wl),l(cu),l(Yl),l(fu),l(Fl),l(Tu),l(hu),l(_u),l(Ol),l($u),l(yu),l(Zl),l(bu),l(Xl),l(vu),l(es),l(Mu),l(xu),l(Cu),l(ts),l(Hu),l(Lu),l(ss),l(wu),l(ns),l(Au),l(os),l(gu),l(zu),l(Pu),l(is),l(Uu),l(Ru),l(ds),l(Eu),l(us),l(ju),l(as),l(Ju),l(ku),l(Du),l(ms),l(qu),l(Iu),l(cs),l(Ku),l(fs),l(Bu),l(Ts),l(Nu),l(Vu),l(Qu),l(hs),l(Su),l(Wu),l($s),l(Yu),l(ys),l(Fu),l(bs),l(Ou),l(Gu),l(Zu),l(vs),l(Xu),l(ea),l(xs),l(ta),l(Cs),l(la),l(Hs),l(sa),l(na),l(oa),l(Ls),l(ia),l(ra),l(As),l(da),l(gs),l(ua),l(zs),l(aa),l(ma),l(pa),l(Ps),l(ca),l(fa),l(Rs),l(Ta),l(ha),l(_a),l(Es),l($a),l(ya),l(Js),l(ba),l(va),l(Ma),l(ks),l(xa),l(Ca),l(qs),l(Ha),l(Is),l(La),l(Ks),l(wa),l(Bs),l(Aa),l(ga),l(za),l(Pa),l(Vs),l(Ua),l(Ra),l(Ss),l(Ea),l(ja),l(Ja),l(Ws),l(ka),l(Da),l(Fs),l(qa),l(Ia),l(Ka),l(Os),l(Ba),l(Na),l(Zs),l(Va),l(Xs),l(Qa),l(Sa),l(tn),l(Wa),l(Ya),l(sn),l(Fa),l(Oa),l(Ga),l(Za),l(rn)),l($),T(b,e),T(H,e),T(g,e),T(R,e),T(k,e),T(K,e),T(Q,e),T(F,e),T(X,e),T(ne,e),T(de,e),T(pe,e),T(_e,e),T(ve,e),T(He,e),T(ge,e),T(Ee,e),T(qe,e),T(Ve,e),T(Fe,e),T(et,e),T(ot,e),T(at,e),T(Tt,e),T(bt,e),T(Ct,e),T(zt,e),T(Et,e),T(It,e),T(Vt,e),T(Yt,e),T(Xt,e),T(nl,e),T(dl,e),T(cl,e),T(_l,e),T(vl,e),T(Ll,e),T(Pl,e),T(Jl,e),T(Kl,e),T(Sl,e),T(Gl,e),T(ls,e),T(rs,e),T(ps,e),T(_s,e),T(Ms,e),T(ws,e),T(Us,e),T(js,e),T(Ds,e),T(Ns,e),T(Qs,e),T(Ys,e),T(Gs,e),T(en,e),T(ln,e),T(nn,e)}}}const Vc='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.permute(...dims) ⇒ <code> Tensor </code>","local":"tensorpermutedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒","local":"tensorclampmin-max-","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒","local":"tensorround-","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.permute(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensorpermutetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor.quantize_embeddings(tensor, precision) ⇒ <code> Tensor </code>","local":"utilstensorquantizeembeddingstensor-precision--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> DataType </code>","local":"utilstensorargs0--code-datatype-code","sections":[],"depth":2},{"title":"utils/tensor~args[1] : <code> * </code>","local":"utilstensorargs1--code--code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function Qc(tm){return Dc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oc extends qc{constructor($){super(),Ic(this,$,Qc,Nc,Jc,{})}}export{Oc as component};
