import{s as Pd,f as Ed,o as Gd,n as zd}from"../chunks/scheduler.9bc65507.js";import{S as Qd,i as Vd,g as s,s as o,r as d,A as Dd,h as a,f as n,c as i,j as C,u as m,x as r,k as ea,y as f,a as l,v as p,d as h,t as u,w as c}from"../chunks/index.707bf1b6.js";import{T as Rd}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as k}from"../chunks/Heading.342b1fa6.js";function Yd(el){let w,U='If you’re interested in implementing a TensorFlow model, take a look at the <a href="add_tensorflow_model">How to convert a 🤗 Transformers model to TensorFlow</a> guide!';return{c(){w=s("p"),w.innerHTML=U},l(M){w=a(M,"P",{"data-svelte-h":!0}),r(w)!=="svelte-dn397l"&&(w.innerHTML=U)},m(M,_){l(M,w,_)},p:zd,d(M){M&&n(w)}}}function Fd(el){let w,U="In case you are using Windows, you should replace <code>RUN_SLOW=1</code> with <code>SET RUN_SLOW=1</code>";return{c(){w=s("p"),w.innerHTML=U},l(M){w=a(M,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1w9gxqz"&&(w.innerHTML=U)},m(M,_){l(M,w,_)},p:zd,d(M){M&&n(w)}}}function Sd(el){let w,U,M,_,$,yl,L,ta='The 🤗 Transformers library is often able to offer new models thanks to community contributors. But this can be a challenging project and requires an in-depth knowledge of the 🤗 Transformers library and the model to implement. At Hugging Face, we’re trying to empower more of the community to actively add models and we’ve put together this guide to walk you through the process of adding a PyTorch model (make sure you have <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch installed</a>).',wl,I,Ml,A,na="Along the way, you’ll:",Tl,H,la="<li>get insights into open-source best practices</li> <li>understand the design principles behind one of the most popular deep learning libraries</li> <li>learn how to efficiently test large models</li> <li>learn how to integrate Python utilities like <code>black</code>, <code>ruff</code>, and <code>make fix-copies</code> to ensure clean and readable code</li>",gl,Z,oa="A Hugging Face team member will be available to help you along the way so you’ll never be alone. 🤗 ❤️",bl,B,ia='To get started, open a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=New+model&amp;template=new-model-addition.yml" rel="nofollow">New model addition</a> issue for the model you want to see in 🤗 Transformers. If you’re not especially picky about contributing a specific model, you can filter by the <a href="https://github.com/huggingface/transformers/labels/New%20model" rel="nofollow">New model label</a> to see if there are any unclaimed model requests and work on it.',vl,N,sa="Once you’ve opened a new model request, the first step is to get familiar with 🤗 Transformers if you aren’t already!",Jl,W,jl,R,aa=`First, you should get a general overview of 🤗 Transformers. 🤗 Transformers is a very opinionated library, so there is a
chance that you don’t agree with some of the library’s philosophies or design choices. From our experience, however, we
found that the fundamental design choices and philosophies of the library are crucial to efficiently scale 🤗
Transformers while keeping maintenance costs at a reasonable level.`,Cl,z,ra='A good first starting point to better understand the library is to read the <a href="philosophy">documentation of our philosophy</a>. As a result of our way of working, there are some choices that we try to apply to all models:',kl,P,da=`<li>Composition is generally favored over-abstraction</li> <li>Duplicating code is not always bad if it strongly improves the readability or accessibility of a model</li> <li>Model files are as self-contained as possible so that when you read the code of a specific model, you ideally only
have to look into the respective <code>modeling_....py</code> file.</li>`,Ul,E,ma=`In our opinion, the library’s code is not just a means to provide a product, <em>e.g.</em> the ability to use BERT for
inference, but also as the very product that we want to improve. Hence, when adding a model, the user is not only the
person who will use your model, but also everybody who will read, try to understand, and possibly tweak your code.`,_l,G,pa="With this in mind, let’s go a bit deeper into the general library design.",Il,Q,xl,V,ha=`To successfully add a model, it is important to understand the interaction between your model and its config,
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. For exemplary purposes, we will
call the model to be added to 🤗 Transformers <code>BrandNewBert</code>.`,$l,D,ua="Let’s take a look:",Ll,tl,ca,Al,Y,fa=`As you can see, we do make use of inheritance in 🤗 Transformers, but we keep the level of abstraction to an absolute
minimum. There are never more than two levels of abstraction for any model in the library. <code>BrandNewBertModel</code>
inherits from <code>BrandNewBertPreTrainedModel</code> which in turn inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> and
that’s it. As a general rule, we want to make sure that a new model only depends on
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. The important functionalities that are automatically provided to every new
model are <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, which are used for serialization and deserialization. All of the
other important functionalities, such as <code>BrandNewBertModel.forward</code> should be completely defined in the new
<code>modeling_brand_new_bert.py</code> script. Next, we want to make sure that a model with a specific head layer, such as
<code>BrandNewBertForMaskedLM</code> does not inherit from <code>BrandNewBertModel</code>, but rather uses <code>BrandNewBertModel</code>
as a component that can be called in its forward pass to keep the level of abstraction low. Every new model requires a
configuration class, called <code>BrandNewBertConfig</code>. This configuration is always stored as an attribute in
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and thus can be accessed via the <code>config</code> attribute for all classes
inheriting from <code>BrandNewBertPreTrainedModel</code>:`,Hl,F,Zl,S,ya=`Similar to the model, the configuration inherits basic serialization and deserialization functionalities from
<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. Note that the configuration and the model are always serialized into two
different formats - the model to a <em>pytorch_model.bin</em> file and the configuration to a <em>config.json</em> file. Calling
the model’s <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> will automatically call
the config’s <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a>, so that both model and configuration are saved.`,Bl,X,Nl,q,wa=`When coding your new model, keep in mind that Transformers is an opinionated library and we have a few quirks of our
own regarding how code should be written :-)`,Wl,O,Ma=`<li>The forward pass of your model should be fully written in the modeling file while being fully independent of other
models in the library. If you want to reuse a block from another model, copy the code and paste it with a
<code># Copied from</code> comment on top (see <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">here</a>
for a good example and <a href="pr_checks#check-copies">there</a> for more documentation on Copied from).</li> <li>The code should be fully understandable, even by a non-native English speaker. This means you should pick
descriptive variable names and avoid abbreviations. As an example, <code>activation</code> is preferred to <code>act</code>.
One-letter variable names are strongly discouraged unless it’s an index in a for loop.</li> <li>More generally we prefer longer explicit code to short magical one.</li> <li>Avoid subclassing <code>nn.Sequential</code> in PyTorch but subclass <code>nn.Module</code> and write the forward pass, so that anyone
using your code can quickly debug it by adding print statements or breaking points.</li> <li>Your function signature should be type-annotated. For the rest, good variable names are way more readable and
understandable than type annotations.</li>`,Rl,K,zl,ee,Ta="Not quite ready yet :-( This section will be added soon!",Pl,te,El,ne,ga=`Everyone has different preferences of how to port a model so it can be very helpful for you to take a look at summaries
of how other contributors ported models to Hugging Face. Here is a list of community blog posts on how to port a model:`,Gl,le,ba='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Porting GPT2 Model</a> by <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Porting WMT19 MT Model</a> by <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',Ql,oe,va="From experience, we can tell you that the most important things to keep in mind when adding a model are:",Vl,ie,Ja=`<li>Don’t reinvent the wheel! Most parts of the code you will add for the new 🤗 Transformers model already exist
somewhere in 🤗 Transformers. Take some time to find similar, already existing models and tokenizers you can copy
from. <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> and <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> are your
friends. Note that it might very well happen that your model’s tokenizer is based on one model implementation, and
your model’s modeling code on another one. <em>E.g.</em> FSMT’s modeling code is based on BART, while FSMT’s tokenizer code
is based on XLM.</li> <li>It’s more of an engineering challenge than a scientific challenge. You should spend more time creating an
efficient debugging environment rather than trying to understand all theoretical aspects of the model in the paper.</li> <li>Ask for help, when you’re stuck! Models are the core component of 🤗 Transformers so we at Hugging Face are more
than happy to help you at every step to add your model. Don’t hesitate to ask if you notice you are not making
progress.</li>`,Dl,se,ja="In the following, we try to give you a general recipe that we found most useful when porting a model to 🤗 Transformers.",Yl,ae,Ca=`The following list is a summary of everything that has to be done to add a model and can be used by you as a To-Do
List:`,Fl,re,ka=`☐ (Optional) Understood the model’s theoretical aspects<br/>
☐ Prepared 🤗 Transformers dev environment<br/>
☐ Set up debugging environment of the original repository<br/>
☐ Created script that successfully runs the <code>forward()</code> pass using the original repository and checkpoint<br/>
☐ Successfully added the model skeleton to 🤗 Transformers<br/>
☐ Successfully converted original checkpoint to 🤗 Transformers checkpoint<br/>
☐ Successfully ran <code>forward()</code> pass in 🤗 Transformers that gives identical output to original checkpoint<br/>
☐ Finished model tests in 🤗 Transformers<br/>
☐ Successfully added tokenizer in 🤗 Transformers<br/>
☐ Run end-to-end integration tests<br/>
☐ Finished docs<br/>
☐ Uploaded model weights to the Hub<br/>
☐ Submitted the pull request<br/>
☐ (Optional) Added a demo notebook`,Sl,de,Ua=`To begin with, we usually recommend starting by getting a good theoretical understanding of <code>BrandNewBert</code>. However,
if you prefer to understand the theoretical aspects of the model <em>on-the-job</em>, then it is totally fine to directly dive
into the <code>BrandNewBert</code>’s code-base. This option might suit you better if your engineering skills are better than
your theoretical skill, if you have trouble understanding <code>BrandNewBert</code>’s paper, or if you just enjoy programming
much more than reading scientific papers.`,Xl,me,ql,pe,_a=`You should take some time to read <em>BrandNewBert’s</em> paper, if such descriptive work exists. There might be large
sections of the paper that are difficult to understand. If this is the case, this is fine - don’t worry! The goal is
not to get a deep theoretical understanding of the paper, but to extract the necessary information required to
effectively re-implement the model in 🤗 Transformers. That being said, you don’t have to spend too much time on the
theoretical aspects, but rather focus on the practical ones, namely:`,Ol,he,Ia=`<li>What type of model is <em>brand_new_bert</em>? BERT-like encoder-only model? GPT2-like decoder-only model? BART-like
encoder-decoder model? Look at the <a href="model_summary">model_summary</a> if you’re not familiar with the differences between those.</li> <li>What are the applications of <em>brand_new_bert</em>? Text classification? Text generation? Seq2Seq tasks, <em>e.g.,</em>
summarization?</li> <li>What is the novel feature of the model that makes it different from BERT/GPT-2/BART?</li> <li>Which of the already existing <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> is most
similar to <em>brand_new_bert</em>?</li> <li>What type of tokenizer is used? A sentencepiece tokenizer? Word piece tokenizer? Is it the same tokenizer as used
for BERT or BART?</li>`,Kl,ue,xa=`After you feel like you have gotten a good overview of the architecture of the model, you might want to write to the
Hugging Face team with any questions you might have. This might include questions regarding the model’s architecture,
its attention layer, etc. We will be more than happy to help you.`,eo,ce,to,b,nl,$a=`<p>Fork the <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> by clicking on the ‘Fork’ button on the
repository’s page. This creates a copy of the code under your GitHub user account.</p>`,Hs,fe,ll,La="Clone your <code>transformers</code> fork to your local disk, and add the base repository as a remote:",Zs,ye,Bs,g,ol,Aa="Set up a development environment, for instance by running the following command:",Ns,we,Ws,il,Ha=`Depending on your OS, and since the number of optional dependencies of Transformers is growing, you might get a
failure with this command. If that’s the case make sure to install the Deep Learning framework you are working with
(PyTorch, TensorFlow and/or Flax) then do:`,Rs,Me,zs,sl,Za="which should be enough for most use cases. You can then return to the parent directory",Ps,Te,Es,al,Ba=`<p>We recommend adding the PyTorch version of <em>brand_new_bert</em> to Transformers. To install PyTorch, please follow the
instructions on <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</p> <p><strong>Note:</strong> You don’t need to have CUDA installed. Making the new model work on CPU is sufficient.</p>`,Gs,ge,rl,Na="To port <em>brand_new_bert</em>, you will also need access to its original repository:",Qs,be,no,ve,Wa="Now you have set up a development environment to port <em>brand_new_bert</em> to 🤗 Transformers.",lo,Je,oo,je,Ra=`At first, you will work on the original <em>brand_new_bert</em> repository. Often, the original implementation is very
“researchy”. Meaning that documentation might be lacking and the code can be difficult to understand. But this should
be exactly your motivation to reimplement <em>brand_new_bert</em>. At Hugging Face, one of our main goals is to <em>make people
stand on the shoulders of giants</em> which translates here very well into taking a working model and rewriting it to make
it as <strong>accessible, user-friendly, and beautiful</strong> as possible. This is the number-one motivation to re-implement
models into 🤗 Transformers - trying to make complex new NLP technology accessible to <strong>everybody</strong>.`,io,Ce,za="You should start thereby by diving into the original repository.",so,ke,Pa=`Successfully running the official pretrained model in the original repository is often <strong>the most difficult</strong> step.
From our experience, it is very important to spend some time getting familiar with the original code-base. You need to
figure out the following:`,ao,Ue,Ea=`<li>Where to find the pretrained weights?</li> <li>How to load the pretrained weights into the corresponding model?</li> <li>How to run the tokenizer independently from the model?</li> <li>Trace one forward pass so that you know which classes and functions are required for a simple forward pass. Usually,
you only have to reimplement those functions.</li> <li>Be able to locate the important components of the model: Where is the model’s class? Are there model sub-classes,
<em>e.g.</em> EncoderModel, DecoderModel? Where is the self-attention layer? Are there multiple different attention layers,
<em>e.g.</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>How can you debug the model in the original environment of the repo? Do you have to add <em>print</em> statements, can you
work with an interactive debugger like <em>ipdb</em>, or should you use an efficient IDE to debug the model, like PyCharm?</li>`,ro,_e,Ga=`It is very important that before you start the porting process, you can <strong>efficiently</strong> debug code in the original
repository! Also, remember that you are working with an open-source library, so do not hesitate to open an issue, or
even a pull request in the original repository. The maintainers of this repository are most likely very happy about
someone looking into their code!`,mo,Ie,Qa=`At this point, it is really up to you which debugging environment and strategy you prefer to use to debug the original
model. We strongly advise against setting up a costly GPU environment, but simply work on a CPU both when starting to
dive into the original repository and also when starting to write the 🤗 Transformers implementation of the model. Only
at the very end, when the model has already been successfully ported to 🤗 Transformers, one should verify that the
model also works as expected on GPU.`,po,xe,Va="In general, there are two possible debugging environments for running the original model",ho,$e,Da='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Local python scripts.</li>',uo,Le,Ya=`Jupyter notebooks have the advantage that they allow for cell-by-cell execution which can be helpful to better split
logical components from one another and to have faster debugging cycles as intermediate results can be stored. Also,
notebooks are often easier to share with other contributors, which might be very helpful if you want to ask the Hugging
Face team for help. If you are familiar with Jupyter notebooks, we strongly recommend you work with them.`,co,Ae,Fa=`The obvious disadvantage of Jupyter notebooks is that if you are not used to working with them you will have to spend
some time adjusting to the new programming environment and you might not be able to use your known debugging tools
anymore, like <code>ipdb</code>.`,fo,He,Sa=`For each code-base, a good first step is always to load a <strong>small</strong> pretrained checkpoint and to be able to reproduce a
single forward pass using a dummy integer vector of input IDs as an input. Such a script could look like this (in
pseudocode):`,yo,Ze,wo,Be,Xa="Next, regarding the debugging strategy, there are generally a few from which to choose from:",Mo,Ne,qa=`<li>Decompose the original model into many small testable components and run a forward pass on each of those for
verification</li> <li>Decompose the original model only into the original <em>tokenizer</em> and the original <em>model</em>, run a forward pass on
those, and use intermediate print statements or breakpoints for verification</li>`,To,We,Oa=`Again, it is up to you which strategy to choose. Often, one or the other is advantageous depending on the original code
base.`,go,Re,Ka=`If the original code-base allows you to decompose the model into smaller sub-components, <em>e.g.</em> if the original
code-base can easily be run in eager mode, it is usually worth the effort to do so. There are some important advantages
to taking the more difficult road in the beginning:`,bo,ze,er=`<li>at a later stage when comparing the original model to the Hugging Face implementation, you can verify automatically
for each component individually that the corresponding component of the 🤗 Transformers implementation matches instead
of relying on visual comparison via print statements</li> <li>it can give you some rope to decompose the big problem of porting a model into smaller problems of just porting
individual components and thus structure your work better</li> <li>separating the model into logical meaningful components will help you to get a better overview of the model’s design
and thus to better understand the model</li> <li>at a later stage those component-by-component tests help you to ensure that no regression occurs as you continue
changing your code</li>`,vo,Pe,tr=`<a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre’s</a> integration checks for ELECTRA
gives a nice example of how this can be done.`,Jo,Ee,nr=`However, if the original code-base is very complex or only allows intermediate components to be run in a compiled mode,
it might be too time-consuming or even impossible to separate the model into smaller testable sub-components. A good
example is <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">T5’s MeshTensorFlow</a> library which is
very complex and does not offer a simple way to decompose the model into its sub-components. For such libraries, one
often relies on verifying print statements.`,jo,Ge,lr=`No matter which strategy you choose, the recommended procedure is often the same that you should start to debug the
starting layers first and the ending layers last.`,Co,Qe,or=`It is recommended that you retrieve the output, either by print statements or sub-component functions, of the following
layers in the following order:`,ko,Ve,ir="<li>Retrieve the input IDs passed to the model</li> <li>Retrieve the word embeddings</li> <li>Retrieve the input of the first Transformer layer</li> <li>Retrieve the output of the first Transformer layer</li> <li>Retrieve the output of the following n - 1 Transformer layers</li> <li>Retrieve the output of the whole BrandNewBert Model</li>",Uo,De,sr="Input IDs should thereby consists of an array of integers, <em>e.g.</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",_o,Ye,ar="The outputs of the following layers often consist of multi-dimensional float arrays and can look like this:",Io,Fe,xo,Se,rr=`We expect that every model added to 🤗 Transformers passes a couple of integration tests, meaning that the original
model and the reimplemented version in 🤗 Transformers have to give the exact same output up to a precision of 0.001!
Since it is normal that the exact same model written in different libraries can give a slightly different output
depending on the library framework, we accept an error tolerance of 1e-3 (0.001). It is not enough if the model gives
nearly the same output, they have to be almost identical. Therefore, you will certainly compare the intermediate
outputs of the 🤗 Transformers version multiple times against the intermediate outputs of the original implementation of
<em>brand_new_bert</em> in which case an <strong>efficient</strong> debugging environment of the original repository is absolutely
important. Here is some advice to make your debugging environment as efficient as possible.`,$o,Xe,dr=`<li>Find the best way of debugging intermediate results. Is the original repository written in PyTorch? Then you should
probably take the time to write a longer script that decomposes the original model into smaller sub-components to
retrieve intermediate values. Is the original repository written in Tensorflow 1? Then you might have to rely on
TensorFlow print operations like <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a> to output
intermediate values. Is the original repository written in Jax? Then make sure that the model is <strong>not jitted</strong> when
running the forward pass, <em>e.g.</em> check-out <a href="https://github.com/google/jax/issues/196" rel="nofollow">this link</a>.</li> <li>Use the smallest pretrained checkpoint you can find. The smaller the checkpoint, the faster your debug cycle
becomes. It is not efficient if your pretrained model is so big that your forward pass takes more than 10 seconds.
In case only very large checkpoints are available, it might make more sense to create a dummy model in the new
environment with randomly initialized weights and save those weights for comparison with the 🤗 Transformers version
of your model</li> <li>Make sure you are using the easiest way of calling a forward pass in the original repository. Ideally, you want to
find the function in the original repository that <strong>only</strong> calls a single forward pass, <em>i.e.</em> that is often called
<code>predict</code>, <code>evaluate</code>, <code>forward</code> or <code>__call__</code>. You don’t want to debug a function that calls <code>forward</code>
multiple times, <em>e.g.</em> to generate text, like <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Try to separate the tokenization from the model’s <em>forward</em> pass. If the original repository shows examples where
you have to input a string, then try to find out where in the forward call the string input is changed to input ids
and start from this point. This might mean that you have to possibly write a small script yourself or change the
original code so that you can directly input the ids instead of an input string.</li> <li>Make sure that the model in your debugging setup is <strong>not</strong> in training mode, which often causes the model to yield
random outputs due to multiple dropout layers in the model. Make sure that the forward pass in your debugging
environment is <strong>deterministic</strong> so that the dropout layers are not used. Or use <em>transformers.utils.set_seed</em>
if the old and new implementations are in the same framework.</li>`,Lo,qe,mr="The following section gives you more specific details/tips on how you can do this for <em>brand_new_bert</em>.",Ao,Oe,Ho,Ke,pr="Next, you can finally start adding new code to 🤗 Transformers. Go into the clone of your 🤗 Transformers’ fork:",Zo,et,Bo,tt,hr=`In the special case that you are adding a model whose architecture exactly matches the model architecture of an
existing model you only have to add a conversion script as described in <a href="#write-a-conversion-script">this section</a>.
In this case, you can just re-use the whole model architecture of the already existing model.`,No,nt,ur="Otherwise, let’s start generating a new model. You have two choices here:",Wo,lt,cr="<li><code>transformers-cli add-new-model-like</code> to add a new model like an existing one</li> <li><code>transformers-cli add-new-model</code> to add a new model from our template (will look like BERT or Bart depending on the type of model you select)</li>",Ro,ot,fr='In both cases, you will be prompted with a questionnaire to fill in the basic information of your model. The second command requires to install <code>cookiecutter</code>, you can find more information on it <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model" rel="nofollow">here</a>.',zo,it,yr="<strong>Open a Pull Request on the main huggingface/transformers repo</strong>",Po,st,wr=`Before starting to adapt the automatically generated code, now is the time to open a “Work in progress (WIP)” pull
request, <em>e.g.</em> “[WIP] Add <em>brand_new_bert</em>”, in 🤗 Transformers so that you and the Hugging Face team can work
side-by-side on integrating the model into 🤗 Transformers.`,Eo,at,Mr="You should do the following:",Go,T,rt,dl,Tr="Create a branch with a descriptive name from your main branch",Vs,dt,Ds,mt,ml,gr="Commit the automatically generated code:",Ys,pt,Fs,ht,pl,br="Fetch and rebase to current main",Ss,ut,Xs,ct,hl,vr="Push the changes to your account using:",qs,ft,Os,ul,Jr=`<p>Once you are satisfied, go to the webpage of your fork on GitHub. Click on “Pull request”. Make sure to add the
GitHub handle of some members of the Hugging Face team as reviewers, so that the Hugging Face team gets notified for
future changes.</p>`,Ks,cl,jr="<p>Change the PR into a draft by clicking on “Convert to draft” on the right of the GitHub pull request web page.</p>",Qo,yt,Cr=`In the following, whenever you have made some progress, don’t forget to commit your work and push it to your account so
that it shows in the pull request. Additionally, you should make sure to update your work with the current main from
time to time by doing:`,Vo,wt,Do,Mt,kr=`In general, all questions you might have regarding the model or your implementation should be asked in your PR and
discussed/solved in the PR. This way, the Hugging Face team will always be notified when you are committing new code or
if you have a question. It is often very helpful to point the Hugging Face team to your added code so that the Hugging
Face team can efficiently understand your problem or question.`,Yo,Tt,Ur=`To do so, you can go to the “Files changed” tab where you see all of your changes, go to a line regarding which you
want to ask a question, and click on the “+” symbol to add a comment. Whenever a question or problem has been solved,
you can click on the “Resolve” button of the created comment.`,Fo,gt,_r=`In the same way, the Hugging Face team will open comments when reviewing your code. We recommend asking most questions
on GitHub on your PR. For some very general questions that are not very useful for the public, feel free to ping the
Hugging Face team by Slack or email.`,So,bt,Ir="<strong>5. Adapt the generated models code for brand_new_bert</strong>",Xo,vt,xr=`At first, we will focus only on the model itself and not care about the tokenizer. All the relevant code should be
found in the generated files <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> and
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,qo,Jt,$r=`Now you can finally start coding :). The generated code in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> will either have the same architecture as BERT if
it’s an encoder-only model or BART if it’s an encoder-decoder model. At this point, you should remind yourself what
you’ve learned in the beginning about the theoretical aspects of the model: <em>How is the model different from BERT or
BART?</em>”. Implement those changes which often means changing the <em>self-attention</em> layer, the order of the normalization
layer, etc… Again, it is often useful to look at the similar architecture of already existing models in Transformers to
get a better feeling of how your model should be implemented.`,Oo,jt,Lr=`<strong>Note</strong> that at this point, you don’t have to be very sure that your code is fully correct or clean. Rather, it is
advised to add a first <em>unclean</em>, copy-pasted version of the original code to
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> until you feel like all the necessary code is
added. From our experience, it is much more efficient to quickly add a first version of the required code and
improve/correct the code iteratively with the conversion script as described in the next section. The only thing that
has to work at this point is that you can instantiate the 🤗 Transformers implementation of <em>brand_new_bert</em>, <em>i.e.</em> the
following command should work:`,Ko,Ct,ei,kt,Ar=`The above command will create a model according to the default parameters as defined in <code>BrandNewBertConfig()</code> with
random weights, thus making sure that the <code>init()</code> methods of all components works.`,ti,Ut,Hr=`Note that all random initialization should happen in the <code>_init_weights</code> method of your <code>BrandnewBertPreTrainedModel</code>
class. It should initialize all leaf modules depending on the variables of the config. Here is an example with the
BERT <code>_init_weights</code> method:`,ni,_t,li,It,Zr=`You can have some more custom schemes if you need a special initialization for some modules. For instance, in
<code>Wav2Vec2ForPreTraining</code>, the last two linear layers need to have the initialization of the regular PyTorch <code>nn.Linear</code>
but all the other ones should use an initialization as above. This is coded like this:`,oi,xt,ii,$t,Br=`The <code>_is_hf_initialized</code> flag is internally used to make sure we only initialize a submodule once. By setting it to
<code>True</code> for <code>module.project_q</code> and <code>module.project_hid</code>, we make sure the custom initialization we did is not overridden later on,
the <code>_init_weights</code> function won’t be applied to them.`,si,Lt,Nr="<strong>6. Write a conversion script</strong>",ai,At,Wr=`Next, you should write a conversion script that lets you convert the checkpoint you used to debug <em>brand_new_bert</em> in
the original repository to a checkpoint compatible with your just created 🤗 Transformers implementation of
<em>brand_new_bert</em>. It is not advised to write the conversion script from scratch, but rather to look through already
existing conversion scripts in 🤗 Transformers for one that has been used to convert a similar model that was written in
the same framework as <em>brand_new_bert</em>. Usually, it is enough to copy an already existing conversion script and
slightly adapt it for your use case. Don’t hesitate to ask the Hugging Face team to point you to a similar already
existing conversion script for your model.`,ri,Ht,Rr='<li>If you are porting a model from TensorFlow to PyTorch, a good starting point might be BERT’s conversion script <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">here</a></li> <li>If you are porting a model from PyTorch to PyTorch, a good starting point might be BART’s conversion script <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">here</a></li>',di,Zt,zr=`In the following, we’ll quickly explain how PyTorch models store layer weights and define layer names. In PyTorch, the
name of a layer is defined by the name of the class attribute you give the layer. Let’s define a dummy model in
PyTorch, called <code>SimpleModel</code> as follows:`,mi,Bt,pi,Nt,Pr=`Now we can create an instance of this model definition which will fill all weights: <code>dense</code>, <code>intermediate</code>,
<code>layer_norm</code> with random weights. We can print the model to see its architecture`,hi,Wt,ui,Rt,Er="This will print out the following:",ci,zt,fi,Pt,Gr=`We can see that the layer names are defined by the name of the class attribute in PyTorch. You can print out the weight
values of a specific layer:`,yi,Et,wi,Gt,Qr="to see that the weights were randomly initialized",Mi,Qt,Ti,Vt,Vr=`In the conversion script, you should fill those randomly initialized weights with the exact weights of the
corresponding layer in the checkpoint. <em>E.g.</em>`,gi,Dt,bi,Yt,Dr=`While doing so, you must verify that each randomly initialized weight of your PyTorch model and its corresponding
pretrained checkpoint weight exactly match in both <strong>shape and name</strong>. To do so, it is <strong>necessary</strong> to add assert
statements for the shape and print out the names of the checkpoints weights. E.g. you should add statements like:`,vi,Ft,Ji,St,Yr="Besides, you should also print out the names of both weights to make sure they match, <em>e.g.</em>",ji,Xt,Ci,qt,Fr=`If either the shape or the name doesn’t match, you probably assigned the wrong checkpoint weight to a randomly
initialized layer of the 🤗 Transformers implementation.`,ki,Ot,Sr=`An incorrect shape is most likely due to an incorrect setting of the config parameters in <code>BrandNewBertConfig()</code> that
do not exactly match those that were used for the checkpoint you want to convert. However, it could also be that
PyTorch’s implementation of a layer requires the weight to be transposed beforehand.`,Ui,Kt,Xr=`Finally, you should also check that <strong>all</strong> required weights are initialized and print out all checkpoint weights that
were not used for initialization to make sure the model is correctly converted. It is completely normal, that the
conversion trials fail with either a wrong shape statement or a wrong name assignment. This is most likely because either
you used incorrect parameters in <code>BrandNewBertConfig()</code>, have a wrong architecture in the 🤗 Transformers
implementation, you have a bug in the <code>init()</code> functions of one of the components of the 🤗 Transformers
implementation or you need to transpose one of the checkpoint weights.`,_i,en,qr=`This step should be iterated with the previous step until all weights of the checkpoint are correctly loaded in the
Transformers model. Having correctly loaded the checkpoint into the 🤗 Transformers implementation, you can then save
the model under a folder of your choice <code>/path/to/converted/checkpoint/folder</code> that should then contain both a
<code>pytorch_model.bin</code> file and a <code>config.json</code> file:`,Ii,tn,xi,nn,Or="<strong>7. Implement the forward pass</strong>",$i,ln,Kr=`Having managed to correctly load the pretrained weights into the 🤗 Transformers implementation, you should now make
sure that the forward pass is correctly implemented. In <a href="#3-4-run-a-pretrained-checkpoint-using-the-original-repository">Get familiar with the original repository</a>, you have already created a script that runs a forward
pass of the model using the original repository. Now you should write an analogous script using the 🤗 Transformers
implementation instead of the original one. It should look as follows:`,Li,on,Ai,sn,ed=`It is very likely that the 🤗 Transformers implementation and the original model implementation don’t give the exact
same output the very first time or that the forward pass throws an error. Don’t be disappointed - it’s expected! First,
you should make sure that the forward pass doesn’t throw any errors. It often happens that the wrong dimensions are
used leading to a <em>Dimensionality mismatch</em> error or that the wrong data type object is used, <em>e.g.</em> <code>torch.long</code>
instead of <code>torch.float32</code>. Don’t hesitate to ask the Hugging Face team for help, if you don’t manage to solve
certain errors.`,Hi,an,td=`The final part to make sure the 🤗 Transformers implementation works correctly is to ensure that the outputs are
equivalent to a precision of <code>1e-3</code>. First, you should ensure that the output shapes are identical, <em>i.e.</em> <code>outputs.shape</code> should yield the same value for the script of the 🤗 Transformers implementation and the original
implementation. Next, you should make sure that the output values are identical as well. This one of the most difficult
parts of adding a new model. Common mistakes why the outputs are not identical are:`,Zi,rn,nd=`<li>Some layers were not added, <em>i.e.</em> an <em>activation</em> layer was not added, or the residual connection was forgotten</li> <li>The word embedding matrix was not tied</li> <li>The wrong positional embeddings are used because the original implementation uses on offset</li> <li>Dropout is applied during the forward pass. To fix this make sure <em>model.training is False</em> and that no dropout
layer is falsely activated during the forward pass, <em>i.e.</em> pass <em>self.training</em> to <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,Bi,dn,ld=`The best way to fix the problem is usually to look at the forward pass of the original implementation and the 🤗
Transformers implementation side-by-side and check if there are any differences. Ideally, you should debug/print out
intermediate outputs of both implementations of the forward pass to find the exact position in the network where the 🤗
Transformers implementation shows a different output than the original implementation. First, make sure that the
hard-coded <code>input_ids</code> in both scripts are identical. Next, verify that the outputs of the first transformation of
the <code>input_ids</code> (usually the word embeddings) are identical. And then work your way up to the very last layer of the
network. At some point, you will notice a difference between the two implementations, which should point you to the bug
in the 🤗 Transformers implementation. From our experience, a simple and efficient way is to add many print statements
in both the original implementation and 🤗 Transformers implementation, at the same positions in the network
respectively, and to successively remove print statements showing the same values for intermediate presentations.`,Ni,mn,od=`When you’re confident that both implementations yield the same output, verify the outputs with
<code>torch.allclose(original_output, output, atol=1e-3)</code>, you’re done with the most difficult part! Congratulations - the
work left to be done should be a cakewalk 😊.`,Wi,pn,id="<strong>8. Adding all necessary model tests</strong>",Ri,hn,sd=`At this point, you have successfully added a new model. However, it is very much possible that the model does not yet
fully comply with the required design. To make sure, the implementation is fully compatible with 🤗 Transformers, all
common tests should pass. The Cookiecutter should have automatically added a test file for your model, probably under
the same <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code>. Run this test file to verify that all common
tests pass:`,zi,un,Pi,cn,ad="Having fixed all common tests, it is now crucial to ensure that all the nice work you have done is well tested, so that",Ei,fn,rd="<li>a) The community can easily understand your work by looking at specific tests of <em>brand_new_bert</em></li> <li>b) Future changes to your model will not break any important feature of the model.</li>",Gi,yn,dd=`At first, integration tests should be added. Those integration tests essentially do the same as the debugging scripts
you used earlier to implement the model to 🤗 Transformers. A template of those model tests has already added by the
Cookiecutter, called <code>BrandNewBertModelIntegrationTests</code> and only has to be filled out by you. To ensure that those
tests are passing, run`,Qi,wn,Vi,x,Di,Mn,md=`Second, all features that are special to <em>brand_new_bert</em> should be tested additionally in a separate test under
<code>BrandNewBertModelTester</code>/<code>BrandNewBertModelTest</code>. This part is often forgotten but is extremely useful in two
ways:`,Yi,Tn,pd=`<li>It helps to transfer the knowledge you have acquired during the model addition to the community by showing how the
special features of <em>brand_new_bert</em> should work.</li> <li>Future contributors can quickly test changes to the model by running those special tests.</li>`,Fi,gn,hd="<strong>9. Implement the tokenizer</strong>",Si,bn,ud=`Next, we should add the tokenizer of <em>brand_new_bert</em>. Usually, the tokenizer is equivalent to or very similar to an
already existing tokenizer of 🤗 Transformers.`,Xi,vn,cd=`It is very important to find/extract the original tokenizer file and to manage to load this file into the 🤗
Transformers’ implementation of the tokenizer.`,qi,Jn,fd=`To ensure that the tokenizer works correctly, it is recommended to first create a script in the original repository
that inputs a string and returns the <code>input_ids</code>. It could look similar to this (in pseudo-code):`,Oi,jn,Ki,Cn,yd=`You might have to take a deeper look again into the original repository to find the correct tokenizer function or you
might even have to do changes to your clone of the original repository to only output the <code>input_ids</code>. Having written
a functional tokenization script that uses the original repository, an analogous script for 🤗 Transformers should be
created. It should look similar to this:`,es,kn,ts,Un,wd="When both <code>input_ids</code> yield the same values, as a final step a tokenizer test file should also be added.",ns,_n,Md=`Analogous to the modeling test files of <em>brand_new_bert</em>, the tokenization test files of <em>brand_new_bert</em> should
contain a couple of hard-coded integration tests.`,ls,In,Td="<strong>10. Run End-to-end integration tests</strong>",os,xn,gd=`Having added the tokenizer, you should also add a couple of end-to-end integration tests using both the model and the
tokenizer to <code>tests/models/brand_new_bert/test_modeling_brand_new_bert.py</code> in 🤗 Transformers.
Such a test should show on a meaningful
text-to-text sample that the 🤗 Transformers implementation works as expected. A meaningful text-to-text sample can
include <em>e.g.</em> a source-to-target-translation pair, an article-to-summary pair, a question-to-answer pair, etc… If none
of the ported checkpoints has been fine-tuned on a downstream task it is enough to simply rely on the model tests. In a
final step to ensure that the model is fully functional, it is advised that you also run all tests on GPU. It can
happen that you forgot to add some <code>.to(self.device)</code> statements to internal tensors of the model, which in such a
test would show in an error. In case you have no access to a GPU, the Hugging Face team can take care of running those
tests for you.`,is,$n,bd="<strong>11. Add Docstring</strong>",ss,Ln,vd=`Now, all the necessary functionality for <em>brand_new_bert</em> is added - you’re almost done! The only thing left to add is
a nice docstring and a doc page. The Cookiecutter should have added a template file called
<code>docs/source/model_doc/brand_new_bert.md</code> that you should fill out. Users of your model will usually first look at
this page before using your model. Hence, the documentation must be understandable and concise. It is very useful for
the community to add some <em>Tips</em> to show how the model should be used. Don’t hesitate to ping the Hugging Face team
regarding the docstrings.`,as,An,Jd=`Next, make sure that the docstring added to <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> is
correct and included all necessary inputs and outputs. We have a detailed guide about writing documentation and our docstring format <a href="writing-documentation">here</a>. It is always good to remind oneself that documentation should
be treated at least as carefully as the code in 🤗 Transformers since the documentation is usually the first contact
point of the community with the model.`,rs,Hn,jd="<strong>Code refactor</strong>",ds,Zn,Cd=`Great, now you have added all the necessary code for <em>brand_new_bert</em>. At this point, you should correct some potential
incorrect code style by running:`,ms,Bn,ps,Nn,kd="and verify that your coding style passes the quality check:",hs,Wn,us,Rn,Ud=`There are a couple of other very strict design tests in 🤗 Transformers that might still be failing, which shows up in
the tests of your pull request. This is often because of some missing information in the docstring or some incorrect
naming. The Hugging Face team will surely help you if you’re stuck here.`,cs,zn,_d=`Lastly, it is always a good idea to refactor one’s code after having ensured that the code works correctly. With all
tests passing, now it’s a good time to go over the added code again and do some refactoring.`,fs,Pn,Id="You have now finished the coding part, congratulation! 🎉 You are Awesome! 😎",ys,En,xd="<strong>12. Upload the models to the model hub</strong>",ws,Gn,$d=`In this final part, you should convert and upload all checkpoints to the model hub and add a model card for each
uploaded model checkpoint. You can get familiar with the hub functionalities by reading our <a href="model_sharing">Model sharing and uploading Page</a>. You should work alongside the Hugging Face team here to decide on a fitting name for each
checkpoint and to get the required access rights to be able to upload the model under the author’s organization of
<em>brand_new_bert</em>. The <code>push_to_hub</code> method, present in all models in <code>transformers</code>, is a quick and efficient way to push your checkpoint to the hub. A little snippet is pasted below:`,Ms,Qn,Ts,Vn,Ld=`It is worth spending some time to create fitting model cards for each checkpoint. The model cards should highlight the
specific characteristics of this particular checkpoint, <em>e.g.</em> On which dataset was the checkpoint
pretrained/fine-tuned on? On what down-stream task should the model be used? And also include some code on how to
correctly use the model.`,gs,Dn,Ad="<strong>13. (Optional) Add notebook</strong>",bs,Yn,Hd=`It is very helpful to add a notebook that showcases in-detail how <em>brand_new_bert</em> can be used for inference and/or
fine-tuned on a downstream task. This is not mandatory to merge your PR, but very useful for the community.`,vs,Fn,Zd="<strong>14. Submit your finished PR</strong>",Js,Sn,Bd=`You’re done programming now and can move to the last step, which is getting your PR merged into main. Usually, the
Hugging Face team should have helped you already at this point, but it is worth taking some time to give your finished
PR a nice description and eventually add comments to your code, if you want to point out certain design choices to your
reviewer.`,js,Xn,Cs,qn,Nd=`Now, it’s time to get some credit from the community for your work! Having completed a model addition is a major
contribution to Transformers and the whole NLP community. Your code and the ported pre-trained models will certainly be
used by hundreds and possibly even thousands of developers and researchers. You should be proud of your work and share
your achievements with the community.`,ks,On,Wd="<strong>You have made another model that is super easy to access for everyone in the community! 🤯</strong>",Us,fl,_s;return $=new k({props:{title:"How to add a model to 🤗 Transformers?",local:"how-to-add-a-model-to--transformers",headingTag:"h1"}}),I=new Rd({props:{$$slots:{default:[Yd]},$$scope:{ctx:el}}}),W=new k({props:{title:"General overview of 🤗 Transformers",local:"general-overview-of--transformers",headingTag:"h2"}}),Q=new k({props:{title:"Overview of models",local:"overview-of-models",headingTag:"h3"}}),F=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwbW9kZWwlMjBoYXMlMjBhY2Nlc3MlMjB0byUyMGl0cyUyMGNvbmZpZw==",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># model has access to its config</span>`,wrap:!1}}),X=new k({props:{title:"Code style",local:"code-style",headingTag:"h3"}}),K=new k({props:{title:"Overview of tokenizers",local:"overview-of-tokenizers",headingTag:"h3"}}),te=new k({props:{title:"Step-by-step recipe to add a model to 🤗 Transformers",local:"step-by-step-recipe-to-add-a-model-to--transformers",headingTag:"h2"}}),me=new k({props:{title:"1. (Optional) Theoretical aspects of BrandNewBert",local:"1-optional-theoretical-aspects-of-brandnewbert",headingTag:"h3"}}),ce=new k({props:{title:"2. Next prepare your environment",local:"2-next-prepare-your-environment",headingTag:"h3"}}),ye=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),we=new y({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),Me=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1lJTIwJTIyLiU1QnF1YWxpdHklNUQlMjI=",highlighted:'pip install -e <span class="hljs-string">&quot;.[quality]&quot;</span>',wrap:!1}}),Te=new y({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),be=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),Je=new k({props:{title:"3.-4. Run a pretrained checkpoint using the original repository",local:"3-4-run-a-pretrained-checkpoint-using-the-original-repository",headingTag:"h3"}}),Ze=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),Fe=new y({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),Oe=new k({props:{title:"5.-14. Port BrandNewBert to 🤗 Transformers",local:"5-14-port-brandnewbert-to--transformers",headingTag:"h3"}}),et=new y({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),dt=new y({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydA==",highlighted:"git checkout -b add_brand_new_bert",wrap:!1}}),pt=new y({props:{code:"Z2l0JTIwYWRkJTIwLiUwQWdpdCUyMGNvbW1pdA==",highlighted:`git add .
git commit`,wrap:!1}}),ut=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbg==",highlighted:`git fetch upstream
git rebase upstream/main`,wrap:!1}}),ft=new y({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),wt=new y({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),Ct=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),_t=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxpbmVhciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUuYmlhcyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5iaWFzLmRhdGEuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkVtYmVkZGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEubm9ybWFsXyhtZWFuJTNEMC4wJTJDJTIwc3RkJTNEc2VsZi5jb25maWcuaW5pdGlhbGl6ZXJfcmFuZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtb2R1bGUucGFkZGluZ19pZHglMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGElNUJtb2R1bGUucGFkZGluZ19pZHglNUQuemVyb18oKSUwQSUyMCUyMCUyMCUyMGVsaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMG5uLkxheWVyTm9ybSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUud2VpZ2h0LmRhdGEuZmlsbF8oMS4wKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Embedding):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.padding_idx <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.weight.data[module.padding_idx].zero_()
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.LayerNorm):
        module.bias.data.zero_()
        module.weight.data.fill_(<span class="hljs-number">1.0</span>)`,wrap:!1}}),xt=new y({props:{code:"ZGVmJTIwX2luaXRfd2VpZ2h0cyhzZWxmJTJDJTIwbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkluaXRpYWxpemUlMjB0aGUlMjB3ZWlnaHRzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKG1vZHVsZSUyQyUyMFdhdjJWZWMyRm9yUHJlVHJhaW5pbmcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLnJlc2V0X3BhcmFtZXRlcnMoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZHVsZS5wcm9qZWN0X3EucmVzZXRfcGFyYW1ldGVycygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLnByb2plY3RfaGlkLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUucHJvamVjdF9xLl9pc19oZl9pbml0aWFsaXplZCUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjBlbGlmJTIwaXNpbnN0YW5jZShtb2R1bGUlMkMlMjBubi5MaW5lYXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kdWxlLndlaWdodC5kYXRhLm5vcm1hbF8obWVhbiUzRDAuMCUyQyUyMHN0ZCUzRHNlbGYuY29uZmlnLmluaXRpYWxpemVyX3JhbmdlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbW9kdWxlLmJpYXMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2R1bGUuYmlhcy5kYXRhLnplcm9fKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, module</span>):
    <span class="hljs-string">&quot;&quot;&quot;Initialize the weights&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(module, Wav2Vec2ForPreTraining):
        module.project_hid.reset_parameters()
        module.project_q.reset_parameters()
        module.project_hid._is_hf_initialized = <span class="hljs-literal">True</span>
        module.project_q._is_hf_initialized = <span class="hljs-literal">True</span>
    <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(module, nn.Linear):
        module.weight.data.normal_(mean=<span class="hljs-number">0.0</span>, std=self.config.initializer_range)
        <span class="hljs-keyword">if</span> module.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            module.bias.data.zero_()`,wrap:!1}}),Bt=new y({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),Wt=new y({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),zt=new y({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),Et=new y({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),Qt=new y({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),Dt=new y({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Ft=new y({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),Xt=new y({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),tn=new y({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),on=new y({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),un=new y({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHk=",highlighted:"pytest tests/models/brand_new_bert/test_modeling_brand_new_bert.py",wrap:!1}}),wn=new y({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZtb2RlbHMlMkZicmFuZF9uZXdfYmVydCUyRnRlc3RfbW9kZWxpbmdfYnJhbmRfbmV3X2JlcnQucHklM0ElM0FCcmFuZE5ld0JlcnRNb2RlbEludGVncmF0aW9uVGVzdHM=",highlighted:"RUN_SLOW=1 pytest -sv tests/models/brand_new_bert/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),x=new Rd({props:{$$slots:{default:[Fd]},$$scope:{ctx:el}}}),jn=new y({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),kn=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Bn=new y({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),Wn=new y({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),Qn=new y({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyYnJhbmRfbmV3X2JlcnQlMjIpJTBBJTIzJTIwVW5jb21tZW50JTIwdGhlJTIwZm9sbG93aW5nJTIwbGluZSUyMHRvJTIwcHVzaCUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24uJTBBJTIzJTIwYnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTIyJTNDb3JnYW5pemF0aW9uJTNFJTJGYnJhbmRfbmV3X2JlcnQlMjIp",highlighted:`brand_new_bert.push_to_hub(<span class="hljs-string">&quot;brand_new_bert&quot;</span>)
<span class="hljs-comment"># Uncomment the following line to push to an organization.</span>
<span class="hljs-comment"># brand_new_bert.push_to_hub(&quot;&lt;organization&gt;/brand_new_bert&quot;)</span>`,wrap:!1}}),Xn=new k({props:{title:"Share your work!!",local:"share-your-work",headingTag:"h3"}}),{c(){w=s("meta"),U=o(),M=s("p"),_=o(),d($.$$.fragment),yl=o(),L=s("p"),L.innerHTML=ta,wl=o(),d(I.$$.fragment),Ml=o(),A=s("p"),A.textContent=na,Tl=o(),H=s("ul"),H.innerHTML=la,gl=o(),Z=s("p"),Z.textContent=oa,bl=o(),B=s("p"),B.innerHTML=ia,vl=o(),N=s("p"),N.textContent=sa,Jl=o(),d(W.$$.fragment),jl=o(),R=s("p"),R.textContent=aa,Cl=o(),z=s("p"),z.innerHTML=ra,kl=o(),P=s("ul"),P.innerHTML=da,Ul=o(),E=s("p"),E.innerHTML=ma,_l=o(),G=s("p"),G.textContent=pa,Il=o(),d(Q.$$.fragment),xl=o(),V=s("p"),V.innerHTML=ha,$l=o(),D=s("p"),D.textContent=ua,Ll=o(),tl=s("img"),Al=o(),Y=s("p"),Y.innerHTML=fa,Hl=o(),d(F.$$.fragment),Zl=o(),S=s("p"),S.innerHTML=ya,Bl=o(),d(X.$$.fragment),Nl=o(),q=s("p"),q.textContent=wa,Wl=o(),O=s("ol"),O.innerHTML=Ma,Rl=o(),d(K.$$.fragment),zl=o(),ee=s("p"),ee.textContent=Ta,Pl=o(),d(te.$$.fragment),El=o(),ne=s("p"),ne.textContent=ga,Gl=o(),le=s("ol"),le.innerHTML=ba,Ql=o(),oe=s("p"),oe.textContent=va,Vl=o(),ie=s("ul"),ie.innerHTML=Ja,Dl=o(),se=s("p"),se.textContent=ja,Yl=o(),ae=s("p"),ae.textContent=Ca,Fl=o(),re=s("p"),re.innerHTML=ka,Sl=o(),de=s("p"),de.innerHTML=Ua,Xl=o(),d(me.$$.fragment),ql=o(),pe=s("p"),pe.innerHTML=_a,Ol=o(),he=s("ul"),he.innerHTML=Ia,Kl=o(),ue=s("p"),ue.textContent=xa,eo=o(),d(ce.$$.fragment),to=o(),b=s("ol"),nl=s("li"),nl.innerHTML=$a,Hs=o(),fe=s("li"),ll=s("p"),ll.innerHTML=La,Zs=o(),d(ye.$$.fragment),Bs=o(),g=s("li"),ol=s("p"),ol.textContent=Aa,Ns=o(),d(we.$$.fragment),Ws=o(),il=s("p"),il.textContent=Ha,Rs=o(),d(Me.$$.fragment),zs=o(),sl=s("p"),sl.textContent=Za,Ps=o(),d(Te.$$.fragment),Es=o(),al=s("li"),al.innerHTML=Ba,Gs=o(),ge=s("li"),rl=s("p"),rl.innerHTML=Na,Qs=o(),d(be.$$.fragment),no=o(),ve=s("p"),ve.innerHTML=Wa,lo=o(),d(Je.$$.fragment),oo=o(),je=s("p"),je.innerHTML=Ra,io=o(),Ce=s("p"),Ce.textContent=za,so=o(),ke=s("p"),ke.innerHTML=Pa,ao=o(),Ue=s("ul"),Ue.innerHTML=Ea,ro=o(),_e=s("p"),_e.innerHTML=Ga,mo=o(),Ie=s("p"),Ie.textContent=Qa,po=o(),xe=s("p"),xe.textContent=Va,ho=o(),$e=s("ul"),$e.innerHTML=Da,uo=o(),Le=s("p"),Le.textContent=Ya,co=o(),Ae=s("p"),Ae.innerHTML=Fa,fo=o(),He=s("p"),He.innerHTML=Sa,yo=o(),d(Ze.$$.fragment),wo=o(),Be=s("p"),Be.textContent=Xa,Mo=o(),Ne=s("ul"),Ne.innerHTML=qa,To=o(),We=s("p"),We.textContent=Oa,go=o(),Re=s("p"),Re.innerHTML=Ka,bo=o(),ze=s("ul"),ze.innerHTML=er,vo=o(),Pe=s("p"),Pe.innerHTML=tr,Jo=o(),Ee=s("p"),Ee.innerHTML=nr,jo=o(),Ge=s("p"),Ge.textContent=lr,Co=o(),Qe=s("p"),Qe.textContent=or,ko=o(),Ve=s("ol"),Ve.innerHTML=ir,Uo=o(),De=s("p"),De.innerHTML=sr,_o=o(),Ye=s("p"),Ye.textContent=ar,Io=o(),d(Fe.$$.fragment),xo=o(),Se=s("p"),Se.innerHTML=rr,$o=o(),Xe=s("ul"),Xe.innerHTML=dr,Lo=o(),qe=s("p"),qe.innerHTML=mr,Ao=o(),d(Oe.$$.fragment),Ho=o(),Ke=s("p"),Ke.textContent=pr,Zo=o(),d(et.$$.fragment),Bo=o(),tt=s("p"),tt.innerHTML=hr,No=o(),nt=s("p"),nt.textContent=ur,Wo=o(),lt=s("ul"),lt.innerHTML=cr,Ro=o(),ot=s("p"),ot.innerHTML=fr,zo=o(),it=s("p"),it.innerHTML=yr,Po=o(),st=s("p"),st.innerHTML=wr,Eo=o(),at=s("p"),at.textContent=Mr,Go=o(),T=s("ol"),rt=s("li"),dl=s("p"),dl.textContent=Tr,Vs=o(),d(dt.$$.fragment),Ds=o(),mt=s("li"),ml=s("p"),ml.textContent=gr,Ys=o(),d(pt.$$.fragment),Fs=o(),ht=s("li"),pl=s("p"),pl.textContent=br,Ss=o(),d(ut.$$.fragment),Xs=o(),ct=s("li"),hl=s("p"),hl.textContent=vr,qs=o(),d(ft.$$.fragment),Os=o(),ul=s("li"),ul.innerHTML=Jr,Ks=o(),cl=s("li"),cl.innerHTML=jr,Qo=o(),yt=s("p"),yt.textContent=Cr,Vo=o(),d(wt.$$.fragment),Do=o(),Mt=s("p"),Mt.textContent=kr,Yo=o(),Tt=s("p"),Tt.textContent=Ur,Fo=o(),gt=s("p"),gt.textContent=_r,So=o(),bt=s("p"),bt.innerHTML=Ir,Xo=o(),vt=s("p"),vt.innerHTML=xr,qo=o(),Jt=s("p"),Jt.innerHTML=$r,Oo=o(),jt=s("p"),jt.innerHTML=Lr,Ko=o(),d(Ct.$$.fragment),ei=o(),kt=s("p"),kt.innerHTML=Ar,ti=o(),Ut=s("p"),Ut.innerHTML=Hr,ni=o(),d(_t.$$.fragment),li=o(),It=s("p"),It.innerHTML=Zr,oi=o(),d(xt.$$.fragment),ii=o(),$t=s("p"),$t.innerHTML=Br,si=o(),Lt=s("p"),Lt.innerHTML=Nr,ai=o(),At=s("p"),At.innerHTML=Wr,ri=o(),Ht=s("ul"),Ht.innerHTML=Rr,di=o(),Zt=s("p"),Zt.innerHTML=zr,mi=o(),d(Bt.$$.fragment),pi=o(),Nt=s("p"),Nt.innerHTML=Pr,hi=o(),d(Wt.$$.fragment),ui=o(),Rt=s("p"),Rt.textContent=Er,ci=o(),d(zt.$$.fragment),fi=o(),Pt=s("p"),Pt.textContent=Gr,yi=o(),d(Et.$$.fragment),wi=o(),Gt=s("p"),Gt.textContent=Qr,Mi=o(),d(Qt.$$.fragment),Ti=o(),Vt=s("p"),Vt.innerHTML=Vr,gi=o(),d(Dt.$$.fragment),bi=o(),Yt=s("p"),Yt.innerHTML=Dr,vi=o(),d(Ft.$$.fragment),Ji=o(),St=s("p"),St.innerHTML=Yr,ji=o(),d(Xt.$$.fragment),Ci=o(),qt=s("p"),qt.textContent=Fr,ki=o(),Ot=s("p"),Ot.innerHTML=Sr,Ui=o(),Kt=s("p"),Kt.innerHTML=Xr,_i=o(),en=s("p"),en.innerHTML=qr,Ii=o(),d(tn.$$.fragment),xi=o(),nn=s("p"),nn.innerHTML=Or,$i=o(),ln=s("p"),ln.innerHTML=Kr,Li=o(),d(on.$$.fragment),Ai=o(),sn=s("p"),sn.innerHTML=ed,Hi=o(),an=s("p"),an.innerHTML=td,Zi=o(),rn=s("ul"),rn.innerHTML=nd,Bi=o(),dn=s("p"),dn.innerHTML=ld,Ni=o(),mn=s("p"),mn.innerHTML=od,Wi=o(),pn=s("p"),pn.innerHTML=id,Ri=o(),hn=s("p"),hn.innerHTML=sd,zi=o(),d(un.$$.fragment),Pi=o(),cn=s("p"),cn.textContent=ad,Ei=o(),fn=s("ul"),fn.innerHTML=rd,Gi=o(),yn=s("p"),yn.innerHTML=dd,Qi=o(),d(wn.$$.fragment),Vi=o(),d(x.$$.fragment),Di=o(),Mn=s("p"),Mn.innerHTML=md,Yi=o(),Tn=s("ul"),Tn.innerHTML=pd,Fi=o(),gn=s("p"),gn.innerHTML=hd,Si=o(),bn=s("p"),bn.innerHTML=ud,Xi=o(),vn=s("p"),vn.textContent=cd,qi=o(),Jn=s("p"),Jn.innerHTML=fd,Oi=o(),d(jn.$$.fragment),Ki=o(),Cn=s("p"),Cn.innerHTML=yd,es=o(),d(kn.$$.fragment),ts=o(),Un=s("p"),Un.innerHTML=wd,ns=o(),_n=s("p"),_n.innerHTML=Md,ls=o(),In=s("p"),In.innerHTML=Td,os=o(),xn=s("p"),xn.innerHTML=gd,is=o(),$n=s("p"),$n.innerHTML=bd,ss=o(),Ln=s("p"),Ln.innerHTML=vd,as=o(),An=s("p"),An.innerHTML=Jd,rs=o(),Hn=s("p"),Hn.innerHTML=jd,ds=o(),Zn=s("p"),Zn.innerHTML=Cd,ms=o(),d(Bn.$$.fragment),ps=o(),Nn=s("p"),Nn.textContent=kd,hs=o(),d(Wn.$$.fragment),us=o(),Rn=s("p"),Rn.textContent=Ud,cs=o(),zn=s("p"),zn.textContent=_d,fs=o(),Pn=s("p"),Pn.textContent=Id,ys=o(),En=s("p"),En.innerHTML=xd,ws=o(),Gn=s("p"),Gn.innerHTML=$d,Ms=o(),d(Qn.$$.fragment),Ts=o(),Vn=s("p"),Vn.innerHTML=Ld,gs=o(),Dn=s("p"),Dn.innerHTML=Ad,bs=o(),Yn=s("p"),Yn.innerHTML=Hd,vs=o(),Fn=s("p"),Fn.innerHTML=Zd,Js=o(),Sn=s("p"),Sn.textContent=Bd,js=o(),d(Xn.$$.fragment),Cs=o(),qn=s("p"),qn.textContent=Nd,ks=o(),On=s("p"),On.innerHTML=Wd,Us=o(),fl=s("p"),this.h()},l(e){const t=Dd("svelte-u9bgzb",document.head);w=a(t,"META",{name:!0,content:!0}),t.forEach(n),U=i(e),M=a(e,"P",{}),C(M).forEach(n),_=i(e),m($.$$.fragment,e),yl=i(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-wxtsp1"&&(L.innerHTML=ta),wl=i(e),m(I.$$.fragment,e),Ml=i(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1k9yxd1"&&(A.textContent=na),Tl=i(e),H=a(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-167a1ja"&&(H.innerHTML=la),gl=i(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1wxv5qq"&&(Z.textContent=oa),bl=i(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-77fy0j"&&(B.innerHTML=ia),vl=i(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ug8854"&&(N.textContent=sa),Jl=i(e),m(W.$$.fragment,e),jl=i(e),R=a(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-rkgkw1"&&(R.textContent=aa),Cl=i(e),z=a(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-hekrk0"&&(z.innerHTML=ra),kl=i(e),P=a(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-9txdfw"&&(P.innerHTML=da),Ul=i(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-77738k"&&(E.innerHTML=ma),_l=i(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1z0o4ph"&&(G.textContent=pa),Il=i(e),m(Q.$$.fragment,e),xl=i(e),V=a(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-k29h5h"&&(V.innerHTML=ha),$l=i(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1bv64m8"&&(D.textContent=ua),Ll=i(e),tl=a(e,"IMG",{src:!0}),Al=i(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1j7ilc9"&&(Y.innerHTML=fa),Hl=i(e),m(F.$$.fragment,e),Zl=i(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-33bpss"&&(S.innerHTML=ya),Bl=i(e),m(X.$$.fragment,e),Nl=i(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-105bqi8"&&(q.textContent=wa),Wl=i(e),O=a(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-3selcg"&&(O.innerHTML=Ma),Rl=i(e),m(K.$$.fragment,e),zl=i(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-10n9flr"&&(ee.textContent=Ta),Pl=i(e),m(te.$$.fragment,e),El=i(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-u747sz"&&(ne.textContent=ga),Gl=i(e),le=a(e,"OL",{"data-svelte-h":!0}),r(le)!=="svelte-b7gw6m"&&(le.innerHTML=ba),Ql=i(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-lru7u6"&&(oe.textContent=va),Vl=i(e),ie=a(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-otnau5"&&(ie.innerHTML=Ja),Dl=i(e),se=a(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-sv8a89"&&(se.textContent=ja),Yl=i(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1ydy9mz"&&(ae.textContent=Ca),Fl=i(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-w74yfn"&&(re.innerHTML=ka),Sl=i(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1pmt80l"&&(de.innerHTML=Ua),Xl=i(e),m(me.$$.fragment,e),ql=i(e),pe=a(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-10phlbf"&&(pe.innerHTML=_a),Ol=i(e),he=a(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-1b4oxlm"&&(he.innerHTML=Ia),Kl=i(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-g50mc6"&&(ue.textContent=xa),eo=i(e),m(ce.$$.fragment,e),to=i(e),b=a(e,"OL",{});var v=C(b);nl=a(v,"LI",{"data-svelte-h":!0}),r(nl)!=="svelte-4g2dtl"&&(nl.innerHTML=$a),Hs=i(v),fe=a(v,"LI",{});var Kn=C(fe);ll=a(Kn,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-lgncv4"&&(ll.innerHTML=La),Zs=i(Kn),m(ye.$$.fragment,Kn),Kn.forEach(n),Bs=i(v),g=a(v,"LI",{});var J=C(g);ol=a(J,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-lbvoi5"&&(ol.textContent=Aa),Ns=i(J),m(we.$$.fragment,J),Ws=i(J),il=a(J,"P",{"data-svelte-h":!0}),r(il)!=="svelte-4wf1r3"&&(il.textContent=Ha),Rs=i(J),m(Me.$$.fragment,J),zs=i(J),sl=a(J,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-182t6ba"&&(sl.textContent=Za),Ps=i(J),m(Te.$$.fragment,J),J.forEach(n),Es=i(v),al=a(v,"LI",{"data-svelte-h":!0}),r(al)!=="svelte-1t6q97z"&&(al.innerHTML=Ba),Gs=i(v),ge=a(v,"LI",{});var Is=C(ge);rl=a(Is,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-hv4twz"&&(rl.innerHTML=Na),Qs=i(Is),m(be.$$.fragment,Is),Is.forEach(n),v.forEach(n),no=i(e),ve=a(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-63px9k"&&(ve.innerHTML=Wa),lo=i(e),m(Je.$$.fragment,e),oo=i(e),je=a(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-hj6dkp"&&(je.innerHTML=Ra),io=i(e),Ce=a(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1wodnvr"&&(Ce.textContent=za),so=i(e),ke=a(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-172lkai"&&(ke.innerHTML=Pa),ao=i(e),Ue=a(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-10bloo4"&&(Ue.innerHTML=Ea),ro=i(e),_e=a(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1jxuc4f"&&(_e.innerHTML=Ga),mo=i(e),Ie=a(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-197bmdq"&&(Ie.textContent=Qa),po=i(e),xe=a(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-9v9j15"&&(xe.textContent=Va),ho=i(e),$e=a(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-1k92mpt"&&($e.innerHTML=Da),uo=i(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-xdlpes"&&(Le.textContent=Ya),co=i(e),Ae=a(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1u4zdsg"&&(Ae.innerHTML=Fa),fo=i(e),He=a(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1g4uiwx"&&(He.innerHTML=Sa),yo=i(e),m(Ze.$$.fragment,e),wo=i(e),Be=a(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-17f6vr7"&&(Be.textContent=Xa),Mo=i(e),Ne=a(e,"UL",{"data-svelte-h":!0}),r(Ne)!=="svelte-1w5zp67"&&(Ne.innerHTML=qa),To=i(e),We=a(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-69ds49"&&(We.textContent=Oa),go=i(e),Re=a(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-17olrqh"&&(Re.innerHTML=Ka),bo=i(e),ze=a(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-uaiiy7"&&(ze.innerHTML=er),vo=i(e),Pe=a(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-pv6v4"&&(Pe.innerHTML=tr),Jo=i(e),Ee=a(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1ex3w25"&&(Ee.innerHTML=nr),jo=i(e),Ge=a(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1480vjb"&&(Ge.textContent=lr),Co=i(e),Qe=a(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1sttzvl"&&(Qe.textContent=or),ko=i(e),Ve=a(e,"OL",{"data-svelte-h":!0}),r(Ve)!=="svelte-1u0bkk8"&&(Ve.innerHTML=ir),Uo=i(e),De=a(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-xvgy42"&&(De.innerHTML=sr),_o=i(e),Ye=a(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-a9oe4g"&&(Ye.textContent=ar),Io=i(e),m(Fe.$$.fragment,e),xo=i(e),Se=a(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1d7jpm"&&(Se.innerHTML=rr),$o=i(e),Xe=a(e,"UL",{"data-svelte-h":!0}),r(Xe)!=="svelte-1bsafyj"&&(Xe.innerHTML=dr),Lo=i(e),qe=a(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1fog5tn"&&(qe.innerHTML=mr),Ao=i(e),m(Oe.$$.fragment,e),Ho=i(e),Ke=a(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-hwuqxz"&&(Ke.textContent=pr),Zo=i(e),m(et.$$.fragment,e),Bo=i(e),tt=a(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1492az0"&&(tt.innerHTML=hr),No=i(e),nt=a(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1xw3dz2"&&(nt.textContent=ur),Wo=i(e),lt=a(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-1k5sxi0"&&(lt.innerHTML=cr),Ro=i(e),ot=a(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1a60q7m"&&(ot.innerHTML=fr),zo=i(e),it=a(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1e0s43k"&&(it.innerHTML=yr),Po=i(e),st=a(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1aoj71c"&&(st.innerHTML=wr),Eo=i(e),at=a(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-3h83p"&&(at.textContent=Mr),Go=i(e),T=a(e,"OL",{});var j=C(T);rt=a(j,"LI",{});var xs=C(rt);dl=a(xs,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1hwk139"&&(dl.textContent=Tr),Vs=i(xs),m(dt.$$.fragment,xs),xs.forEach(n),Ds=i(j),mt=a(j,"LI",{});var $s=C(mt);ml=a($s,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-gmko0l"&&(ml.textContent=gr),Ys=i($s),m(pt.$$.fragment,$s),$s.forEach(n),Fs=i(j),ht=a(j,"LI",{});var Ls=C(ht);pl=a(Ls,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-h4badi"&&(pl.textContent=br),Ss=i(Ls),m(ut.$$.fragment,Ls),Ls.forEach(n),Xs=i(j),ct=a(j,"LI",{});var As=C(ct);hl=a(As,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-1adm7yl"&&(hl.textContent=vr),qs=i(As),m(ft.$$.fragment,As),As.forEach(n),Os=i(j),ul=a(j,"LI",{"data-svelte-h":!0}),r(ul)!=="svelte-v52akd"&&(ul.innerHTML=Jr),Ks=i(j),cl=a(j,"LI",{"data-svelte-h":!0}),r(cl)!=="svelte-1jfczy2"&&(cl.innerHTML=jr),j.forEach(n),Qo=i(e),yt=a(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-fby7tz"&&(yt.textContent=Cr),Vo=i(e),m(wt.$$.fragment,e),Do=i(e),Mt=a(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-707ott"&&(Mt.textContent=kr),Yo=i(e),Tt=a(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-10vuoyb"&&(Tt.textContent=Ur),Fo=i(e),gt=a(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1rsqt8e"&&(gt.textContent=_r),So=i(e),bt=a(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-e56uo0"&&(bt.innerHTML=Ir),Xo=i(e),vt=a(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1pev0u3"&&(vt.innerHTML=xr),qo=i(e),Jt=a(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-o2c99d"&&(Jt.innerHTML=$r),Oo=i(e),jt=a(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-cf404e"&&(jt.innerHTML=Lr),Ko=i(e),m(Ct.$$.fragment,e),ei=i(e),kt=a(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1dloo7i"&&(kt.innerHTML=Ar),ti=i(e),Ut=a(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-nsqyfa"&&(Ut.innerHTML=Hr),ni=i(e),m(_t.$$.fragment,e),li=i(e),It=a(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-sj6wf0"&&(It.innerHTML=Zr),oi=i(e),m(xt.$$.fragment,e),ii=i(e),$t=a(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1pfm0sb"&&($t.innerHTML=Br),si=i(e),Lt=a(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-f68cwo"&&(Lt.innerHTML=Nr),ai=i(e),At=a(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-vdut7s"&&(At.innerHTML=Wr),ri=i(e),Ht=a(e,"UL",{"data-svelte-h":!0}),r(Ht)!=="svelte-16vb6hw"&&(Ht.innerHTML=Rr),di=i(e),Zt=a(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-14nqqv0"&&(Zt.innerHTML=zr),mi=i(e),m(Bt.$$.fragment,e),pi=i(e),Nt=a(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-p81vjw"&&(Nt.innerHTML=Pr),hi=i(e),m(Wt.$$.fragment,e),ui=i(e),Rt=a(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-ilov09"&&(Rt.textContent=Er),ci=i(e),m(zt.$$.fragment,e),fi=i(e),Pt=a(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-13dugi2"&&(Pt.textContent=Gr),yi=i(e),m(Et.$$.fragment,e),wi=i(e),Gt=a(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1lx6n8g"&&(Gt.textContent=Qr),Mi=i(e),m(Qt.$$.fragment,e),Ti=i(e),Vt=a(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1t5qty0"&&(Vt.innerHTML=Vr),gi=i(e),m(Dt.$$.fragment,e),bi=i(e),Yt=a(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1b67ucv"&&(Yt.innerHTML=Dr),vi=i(e),m(Ft.$$.fragment,e),Ji=i(e),St=a(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-10rxzj1"&&(St.innerHTML=Yr),ji=i(e),m(Xt.$$.fragment,e),Ci=i(e),qt=a(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-tq4e7m"&&(qt.textContent=Fr),ki=i(e),Ot=a(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-nguxo0"&&(Ot.innerHTML=Sr),Ui=i(e),Kt=a(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-5g2dr4"&&(Kt.innerHTML=Xr),_i=i(e),en=a(e,"P",{"data-svelte-h":!0}),r(en)!=="svelte-jkulr9"&&(en.innerHTML=qr),Ii=i(e),m(tn.$$.fragment,e),xi=i(e),nn=a(e,"P",{"data-svelte-h":!0}),r(nn)!=="svelte-8ivqw6"&&(nn.innerHTML=Or),$i=i(e),ln=a(e,"P",{"data-svelte-h":!0}),r(ln)!=="svelte-1v8xetm"&&(ln.innerHTML=Kr),Li=i(e),m(on.$$.fragment,e),Ai=i(e),sn=a(e,"P",{"data-svelte-h":!0}),r(sn)!=="svelte-txar7q"&&(sn.innerHTML=ed),Hi=i(e),an=a(e,"P",{"data-svelte-h":!0}),r(an)!=="svelte-10rs2ro"&&(an.innerHTML=td),Zi=i(e),rn=a(e,"UL",{"data-svelte-h":!0}),r(rn)!=="svelte-1r46n3h"&&(rn.innerHTML=nd),Bi=i(e),dn=a(e,"P",{"data-svelte-h":!0}),r(dn)!=="svelte-1i2mpdn"&&(dn.innerHTML=ld),Ni=i(e),mn=a(e,"P",{"data-svelte-h":!0}),r(mn)!=="svelte-16p1dlw"&&(mn.innerHTML=od),Wi=i(e),pn=a(e,"P",{"data-svelte-h":!0}),r(pn)!=="svelte-1q8o052"&&(pn.innerHTML=id),Ri=i(e),hn=a(e,"P",{"data-svelte-h":!0}),r(hn)!=="svelte-13ruakv"&&(hn.innerHTML=sd),zi=i(e),m(un.$$.fragment,e),Pi=i(e),cn=a(e,"P",{"data-svelte-h":!0}),r(cn)!=="svelte-1z4cf"&&(cn.textContent=ad),Ei=i(e),fn=a(e,"UL",{"data-svelte-h":!0}),r(fn)!=="svelte-1msq586"&&(fn.innerHTML=rd),Gi=i(e),yn=a(e,"P",{"data-svelte-h":!0}),r(yn)!=="svelte-2t6h0z"&&(yn.innerHTML=dd),Qi=i(e),m(wn.$$.fragment,e),Vi=i(e),m(x.$$.fragment,e),Di=i(e),Mn=a(e,"P",{"data-svelte-h":!0}),r(Mn)!=="svelte-63hgsc"&&(Mn.innerHTML=md),Yi=i(e),Tn=a(e,"UL",{"data-svelte-h":!0}),r(Tn)!=="svelte-1192mxo"&&(Tn.innerHTML=pd),Fi=i(e),gn=a(e,"P",{"data-svelte-h":!0}),r(gn)!=="svelte-1l7w7z9"&&(gn.innerHTML=hd),Si=i(e),bn=a(e,"P",{"data-svelte-h":!0}),r(bn)!=="svelte-17g0btz"&&(bn.innerHTML=ud),Xi=i(e),vn=a(e,"P",{"data-svelte-h":!0}),r(vn)!=="svelte-w3jgow"&&(vn.textContent=cd),qi=i(e),Jn=a(e,"P",{"data-svelte-h":!0}),r(Jn)!=="svelte-3mgn5l"&&(Jn.innerHTML=fd),Oi=i(e),m(jn.$$.fragment,e),Ki=i(e),Cn=a(e,"P",{"data-svelte-h":!0}),r(Cn)!=="svelte-12b6z3d"&&(Cn.innerHTML=yd),es=i(e),m(kn.$$.fragment,e),ts=i(e),Un=a(e,"P",{"data-svelte-h":!0}),r(Un)!=="svelte-12o38jn"&&(Un.innerHTML=wd),ns=i(e),_n=a(e,"P",{"data-svelte-h":!0}),r(_n)!=="svelte-m9dhdl"&&(_n.innerHTML=Md),ls=i(e),In=a(e,"P",{"data-svelte-h":!0}),r(In)!=="svelte-1r4x1hz"&&(In.innerHTML=Td),os=i(e),xn=a(e,"P",{"data-svelte-h":!0}),r(xn)!=="svelte-1a2qjdi"&&(xn.innerHTML=gd),is=i(e),$n=a(e,"P",{"data-svelte-h":!0}),r($n)!=="svelte-lu4l51"&&($n.innerHTML=bd),ss=i(e),Ln=a(e,"P",{"data-svelte-h":!0}),r(Ln)!=="svelte-ngbmem"&&(Ln.innerHTML=vd),as=i(e),An=a(e,"P",{"data-svelte-h":!0}),r(An)!=="svelte-oj7bsa"&&(An.innerHTML=Jd),rs=i(e),Hn=a(e,"P",{"data-svelte-h":!0}),r(Hn)!=="svelte-1h13ics"&&(Hn.innerHTML=jd),ds=i(e),Zn=a(e,"P",{"data-svelte-h":!0}),r(Zn)!=="svelte-1o0dhcg"&&(Zn.innerHTML=Cd),ms=i(e),m(Bn.$$.fragment,e),ps=i(e),Nn=a(e,"P",{"data-svelte-h":!0}),r(Nn)!=="svelte-1hnvgw6"&&(Nn.textContent=kd),hs=i(e),m(Wn.$$.fragment,e),us=i(e),Rn=a(e,"P",{"data-svelte-h":!0}),r(Rn)!=="svelte-158gt2o"&&(Rn.textContent=Ud),cs=i(e),zn=a(e,"P",{"data-svelte-h":!0}),r(zn)!=="svelte-z20wkr"&&(zn.textContent=_d),fs=i(e),Pn=a(e,"P",{"data-svelte-h":!0}),r(Pn)!=="svelte-1uwhc8b"&&(Pn.textContent=Id),ys=i(e),En=a(e,"P",{"data-svelte-h":!0}),r(En)!=="svelte-cmu0wm"&&(En.innerHTML=xd),ws=i(e),Gn=a(e,"P",{"data-svelte-h":!0}),r(Gn)!=="svelte-11c1nk5"&&(Gn.innerHTML=$d),Ms=i(e),m(Qn.$$.fragment,e),Ts=i(e),Vn=a(e,"P",{"data-svelte-h":!0}),r(Vn)!=="svelte-hwxs76"&&(Vn.innerHTML=Ld),gs=i(e),Dn=a(e,"P",{"data-svelte-h":!0}),r(Dn)!=="svelte-1gie4tq"&&(Dn.innerHTML=Ad),bs=i(e),Yn=a(e,"P",{"data-svelte-h":!0}),r(Yn)!=="svelte-1so49zx"&&(Yn.innerHTML=Hd),vs=i(e),Fn=a(e,"P",{"data-svelte-h":!0}),r(Fn)!=="svelte-144ouhf"&&(Fn.innerHTML=Zd),Js=i(e),Sn=a(e,"P",{"data-svelte-h":!0}),r(Sn)!=="svelte-jag54x"&&(Sn.textContent=Bd),js=i(e),m(Xn.$$.fragment,e),Cs=i(e),qn=a(e,"P",{"data-svelte-h":!0}),r(qn)!=="svelte-d34izn"&&(qn.textContent=Nd),ks=i(e),On=a(e,"P",{"data-svelte-h":!0}),r(On)!=="svelte-1f9gbqf"&&(On.innerHTML=Wd),Us=i(e),fl=a(e,"P",{}),C(fl).forEach(n),this.h()},h(){ea(w,"name","hf:doc:metadata"),ea(w,"content",Xd),Ed(tl.src,ca="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||ea(tl,"src",ca)},m(e,t){f(document.head,w),l(e,U,t),l(e,M,t),l(e,_,t),p($,e,t),l(e,yl,t),l(e,L,t),l(e,wl,t),p(I,e,t),l(e,Ml,t),l(e,A,t),l(e,Tl,t),l(e,H,t),l(e,gl,t),l(e,Z,t),l(e,bl,t),l(e,B,t),l(e,vl,t),l(e,N,t),l(e,Jl,t),p(W,e,t),l(e,jl,t),l(e,R,t),l(e,Cl,t),l(e,z,t),l(e,kl,t),l(e,P,t),l(e,Ul,t),l(e,E,t),l(e,_l,t),l(e,G,t),l(e,Il,t),p(Q,e,t),l(e,xl,t),l(e,V,t),l(e,$l,t),l(e,D,t),l(e,Ll,t),l(e,tl,t),l(e,Al,t),l(e,Y,t),l(e,Hl,t),p(F,e,t),l(e,Zl,t),l(e,S,t),l(e,Bl,t),p(X,e,t),l(e,Nl,t),l(e,q,t),l(e,Wl,t),l(e,O,t),l(e,Rl,t),p(K,e,t),l(e,zl,t),l(e,ee,t),l(e,Pl,t),p(te,e,t),l(e,El,t),l(e,ne,t),l(e,Gl,t),l(e,le,t),l(e,Ql,t),l(e,oe,t),l(e,Vl,t),l(e,ie,t),l(e,Dl,t),l(e,se,t),l(e,Yl,t),l(e,ae,t),l(e,Fl,t),l(e,re,t),l(e,Sl,t),l(e,de,t),l(e,Xl,t),p(me,e,t),l(e,ql,t),l(e,pe,t),l(e,Ol,t),l(e,he,t),l(e,Kl,t),l(e,ue,t),l(e,eo,t),p(ce,e,t),l(e,to,t),l(e,b,t),f(b,nl),f(b,Hs),f(b,fe),f(fe,ll),f(fe,Zs),p(ye,fe,null),f(b,Bs),f(b,g),f(g,ol),f(g,Ns),p(we,g,null),f(g,Ws),f(g,il),f(g,Rs),p(Me,g,null),f(g,zs),f(g,sl),f(g,Ps),p(Te,g,null),f(b,Es),f(b,al),f(b,Gs),f(b,ge),f(ge,rl),f(ge,Qs),p(be,ge,null),l(e,no,t),l(e,ve,t),l(e,lo,t),p(Je,e,t),l(e,oo,t),l(e,je,t),l(e,io,t),l(e,Ce,t),l(e,so,t),l(e,ke,t),l(e,ao,t),l(e,Ue,t),l(e,ro,t),l(e,_e,t),l(e,mo,t),l(e,Ie,t),l(e,po,t),l(e,xe,t),l(e,ho,t),l(e,$e,t),l(e,uo,t),l(e,Le,t),l(e,co,t),l(e,Ae,t),l(e,fo,t),l(e,He,t),l(e,yo,t),p(Ze,e,t),l(e,wo,t),l(e,Be,t),l(e,Mo,t),l(e,Ne,t),l(e,To,t),l(e,We,t),l(e,go,t),l(e,Re,t),l(e,bo,t),l(e,ze,t),l(e,vo,t),l(e,Pe,t),l(e,Jo,t),l(e,Ee,t),l(e,jo,t),l(e,Ge,t),l(e,Co,t),l(e,Qe,t),l(e,ko,t),l(e,Ve,t),l(e,Uo,t),l(e,De,t),l(e,_o,t),l(e,Ye,t),l(e,Io,t),p(Fe,e,t),l(e,xo,t),l(e,Se,t),l(e,$o,t),l(e,Xe,t),l(e,Lo,t),l(e,qe,t),l(e,Ao,t),p(Oe,e,t),l(e,Ho,t),l(e,Ke,t),l(e,Zo,t),p(et,e,t),l(e,Bo,t),l(e,tt,t),l(e,No,t),l(e,nt,t),l(e,Wo,t),l(e,lt,t),l(e,Ro,t),l(e,ot,t),l(e,zo,t),l(e,it,t),l(e,Po,t),l(e,st,t),l(e,Eo,t),l(e,at,t),l(e,Go,t),l(e,T,t),f(T,rt),f(rt,dl),f(rt,Vs),p(dt,rt,null),f(T,Ds),f(T,mt),f(mt,ml),f(mt,Ys),p(pt,mt,null),f(T,Fs),f(T,ht),f(ht,pl),f(ht,Ss),p(ut,ht,null),f(T,Xs),f(T,ct),f(ct,hl),f(ct,qs),p(ft,ct,null),f(T,Os),f(T,ul),f(T,Ks),f(T,cl),l(e,Qo,t),l(e,yt,t),l(e,Vo,t),p(wt,e,t),l(e,Do,t),l(e,Mt,t),l(e,Yo,t),l(e,Tt,t),l(e,Fo,t),l(e,gt,t),l(e,So,t),l(e,bt,t),l(e,Xo,t),l(e,vt,t),l(e,qo,t),l(e,Jt,t),l(e,Oo,t),l(e,jt,t),l(e,Ko,t),p(Ct,e,t),l(e,ei,t),l(e,kt,t),l(e,ti,t),l(e,Ut,t),l(e,ni,t),p(_t,e,t),l(e,li,t),l(e,It,t),l(e,oi,t),p(xt,e,t),l(e,ii,t),l(e,$t,t),l(e,si,t),l(e,Lt,t),l(e,ai,t),l(e,At,t),l(e,ri,t),l(e,Ht,t),l(e,di,t),l(e,Zt,t),l(e,mi,t),p(Bt,e,t),l(e,pi,t),l(e,Nt,t),l(e,hi,t),p(Wt,e,t),l(e,ui,t),l(e,Rt,t),l(e,ci,t),p(zt,e,t),l(e,fi,t),l(e,Pt,t),l(e,yi,t),p(Et,e,t),l(e,wi,t),l(e,Gt,t),l(e,Mi,t),p(Qt,e,t),l(e,Ti,t),l(e,Vt,t),l(e,gi,t),p(Dt,e,t),l(e,bi,t),l(e,Yt,t),l(e,vi,t),p(Ft,e,t),l(e,Ji,t),l(e,St,t),l(e,ji,t),p(Xt,e,t),l(e,Ci,t),l(e,qt,t),l(e,ki,t),l(e,Ot,t),l(e,Ui,t),l(e,Kt,t),l(e,_i,t),l(e,en,t),l(e,Ii,t),p(tn,e,t),l(e,xi,t),l(e,nn,t),l(e,$i,t),l(e,ln,t),l(e,Li,t),p(on,e,t),l(e,Ai,t),l(e,sn,t),l(e,Hi,t),l(e,an,t),l(e,Zi,t),l(e,rn,t),l(e,Bi,t),l(e,dn,t),l(e,Ni,t),l(e,mn,t),l(e,Wi,t),l(e,pn,t),l(e,Ri,t),l(e,hn,t),l(e,zi,t),p(un,e,t),l(e,Pi,t),l(e,cn,t),l(e,Ei,t),l(e,fn,t),l(e,Gi,t),l(e,yn,t),l(e,Qi,t),p(wn,e,t),l(e,Vi,t),p(x,e,t),l(e,Di,t),l(e,Mn,t),l(e,Yi,t),l(e,Tn,t),l(e,Fi,t),l(e,gn,t),l(e,Si,t),l(e,bn,t),l(e,Xi,t),l(e,vn,t),l(e,qi,t),l(e,Jn,t),l(e,Oi,t),p(jn,e,t),l(e,Ki,t),l(e,Cn,t),l(e,es,t),p(kn,e,t),l(e,ts,t),l(e,Un,t),l(e,ns,t),l(e,_n,t),l(e,ls,t),l(e,In,t),l(e,os,t),l(e,xn,t),l(e,is,t),l(e,$n,t),l(e,ss,t),l(e,Ln,t),l(e,as,t),l(e,An,t),l(e,rs,t),l(e,Hn,t),l(e,ds,t),l(e,Zn,t),l(e,ms,t),p(Bn,e,t),l(e,ps,t),l(e,Nn,t),l(e,hs,t),p(Wn,e,t),l(e,us,t),l(e,Rn,t),l(e,cs,t),l(e,zn,t),l(e,fs,t),l(e,Pn,t),l(e,ys,t),l(e,En,t),l(e,ws,t),l(e,Gn,t),l(e,Ms,t),p(Qn,e,t),l(e,Ts,t),l(e,Vn,t),l(e,gs,t),l(e,Dn,t),l(e,bs,t),l(e,Yn,t),l(e,vs,t),l(e,Fn,t),l(e,Js,t),l(e,Sn,t),l(e,js,t),p(Xn,e,t),l(e,Cs,t),l(e,qn,t),l(e,ks,t),l(e,On,t),l(e,Us,t),l(e,fl,t),_s=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),I.$set(v);const Kn={};t&2&&(Kn.$$scope={dirty:t,ctx:e}),x.$set(Kn)},i(e){_s||(h($.$$.fragment,e),h(I.$$.fragment,e),h(W.$$.fragment,e),h(Q.$$.fragment,e),h(F.$$.fragment,e),h(X.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(Fe.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ut.$$.fragment,e),h(ft.$$.fragment,e),h(wt.$$.fragment,e),h(Ct.$$.fragment,e),h(_t.$$.fragment,e),h(xt.$$.fragment,e),h(Bt.$$.fragment,e),h(Wt.$$.fragment,e),h(zt.$$.fragment,e),h(Et.$$.fragment,e),h(Qt.$$.fragment,e),h(Dt.$$.fragment,e),h(Ft.$$.fragment,e),h(Xt.$$.fragment,e),h(tn.$$.fragment,e),h(on.$$.fragment,e),h(un.$$.fragment,e),h(wn.$$.fragment,e),h(x.$$.fragment,e),h(jn.$$.fragment,e),h(kn.$$.fragment,e),h(Bn.$$.fragment,e),h(Wn.$$.fragment,e),h(Qn.$$.fragment,e),h(Xn.$$.fragment,e),_s=!0)},o(e){u($.$$.fragment,e),u(I.$$.fragment,e),u(W.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(X.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),u(Fe.$$.fragment,e),u(Oe.$$.fragment,e),u(et.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),u(_t.$$.fragment,e),u(xt.$$.fragment,e),u(Bt.$$.fragment,e),u(Wt.$$.fragment,e),u(zt.$$.fragment,e),u(Et.$$.fragment,e),u(Qt.$$.fragment,e),u(Dt.$$.fragment,e),u(Ft.$$.fragment,e),u(Xt.$$.fragment,e),u(tn.$$.fragment,e),u(on.$$.fragment,e),u(un.$$.fragment,e),u(wn.$$.fragment,e),u(x.$$.fragment,e),u(jn.$$.fragment,e),u(kn.$$.fragment,e),u(Bn.$$.fragment,e),u(Wn.$$.fragment,e),u(Qn.$$.fragment,e),u(Xn.$$.fragment,e),_s=!1},d(e){e&&(n(U),n(M),n(_),n(yl),n(L),n(wl),n(Ml),n(A),n(Tl),n(H),n(gl),n(Z),n(bl),n(B),n(vl),n(N),n(Jl),n(jl),n(R),n(Cl),n(z),n(kl),n(P),n(Ul),n(E),n(_l),n(G),n(Il),n(xl),n(V),n($l),n(D),n(Ll),n(tl),n(Al),n(Y),n(Hl),n(Zl),n(S),n(Bl),n(Nl),n(q),n(Wl),n(O),n(Rl),n(zl),n(ee),n(Pl),n(El),n(ne),n(Gl),n(le),n(Ql),n(oe),n(Vl),n(ie),n(Dl),n(se),n(Yl),n(ae),n(Fl),n(re),n(Sl),n(de),n(Xl),n(ql),n(pe),n(Ol),n(he),n(Kl),n(ue),n(eo),n(to),n(b),n(no),n(ve),n(lo),n(oo),n(je),n(io),n(Ce),n(so),n(ke),n(ao),n(Ue),n(ro),n(_e),n(mo),n(Ie),n(po),n(xe),n(ho),n($e),n(uo),n(Le),n(co),n(Ae),n(fo),n(He),n(yo),n(wo),n(Be),n(Mo),n(Ne),n(To),n(We),n(go),n(Re),n(bo),n(ze),n(vo),n(Pe),n(Jo),n(Ee),n(jo),n(Ge),n(Co),n(Qe),n(ko),n(Ve),n(Uo),n(De),n(_o),n(Ye),n(Io),n(xo),n(Se),n($o),n(Xe),n(Lo),n(qe),n(Ao),n(Ho),n(Ke),n(Zo),n(Bo),n(tt),n(No),n(nt),n(Wo),n(lt),n(Ro),n(ot),n(zo),n(it),n(Po),n(st),n(Eo),n(at),n(Go),n(T),n(Qo),n(yt),n(Vo),n(Do),n(Mt),n(Yo),n(Tt),n(Fo),n(gt),n(So),n(bt),n(Xo),n(vt),n(qo),n(Jt),n(Oo),n(jt),n(Ko),n(ei),n(kt),n(ti),n(Ut),n(ni),n(li),n(It),n(oi),n(ii),n($t),n(si),n(Lt),n(ai),n(At),n(ri),n(Ht),n(di),n(Zt),n(mi),n(pi),n(Nt),n(hi),n(ui),n(Rt),n(ci),n(fi),n(Pt),n(yi),n(wi),n(Gt),n(Mi),n(Ti),n(Vt),n(gi),n(bi),n(Yt),n(vi),n(Ji),n(St),n(ji),n(Ci),n(qt),n(ki),n(Ot),n(Ui),n(Kt),n(_i),n(en),n(Ii),n(xi),n(nn),n($i),n(ln),n(Li),n(Ai),n(sn),n(Hi),n(an),n(Zi),n(rn),n(Bi),n(dn),n(Ni),n(mn),n(Wi),n(pn),n(Ri),n(hn),n(zi),n(Pi),n(cn),n(Ei),n(fn),n(Gi),n(yn),n(Qi),n(Vi),n(Di),n(Mn),n(Yi),n(Tn),n(Fi),n(gn),n(Si),n(bn),n(Xi),n(vn),n(qi),n(Jn),n(Oi),n(Ki),n(Cn),n(es),n(ts),n(Un),n(ns),n(_n),n(ls),n(In),n(os),n(xn),n(is),n($n),n(ss),n(Ln),n(as),n(An),n(rs),n(Hn),n(ds),n(Zn),n(ms),n(ps),n(Nn),n(hs),n(us),n(Rn),n(cs),n(zn),n(fs),n(Pn),n(ys),n(En),n(ws),n(Gn),n(Ms),n(Ts),n(Vn),n(gs),n(Dn),n(bs),n(Yn),n(vs),n(Fn),n(Js),n(Sn),n(js),n(Cs),n(qn),n(ks),n(On),n(Us),n(fl)),n(w),c($,e),c(I,e),c(W,e),c(Q,e),c(F,e),c(X,e),c(K,e),c(te,e),c(me,e),c(ce,e),c(ye),c(we),c(Me),c(Te),c(be),c(Je,e),c(Ze,e),c(Fe,e),c(Oe,e),c(et,e),c(dt),c(pt),c(ut),c(ft),c(wt,e),c(Ct,e),c(_t,e),c(xt,e),c(Bt,e),c(Wt,e),c(zt,e),c(Et,e),c(Qt,e),c(Dt,e),c(Ft,e),c(Xt,e),c(tn,e),c(on,e),c(un,e),c(wn,e),c(x,e),c(jn,e),c(kn,e),c(Bn,e),c(Wn,e),c(Qn,e),c(Xn,e)}}}const Xd='{"title":"How to add a model to 🤗 Transformers?","local":"how-to-add-a-model-to--transformers","sections":[{"title":"General overview of 🤗 Transformers","local":"general-overview-of--transformers","sections":[{"title":"Overview of models","local":"overview-of-models","sections":[],"depth":3},{"title":"Code style","local":"code-style","sections":[],"depth":3},{"title":"Overview of tokenizers","local":"overview-of-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Step-by-step recipe to add a model to 🤗 Transformers","local":"step-by-step-recipe-to-add-a-model-to--transformers","sections":[{"title":"1. (Optional) Theoretical aspects of BrandNewBert","local":"1-optional-theoretical-aspects-of-brandnewbert","sections":[],"depth":3},{"title":"2. Next prepare your environment","local":"2-next-prepare-your-environment","sections":[],"depth":3},{"title":"3.-4. Run a pretrained checkpoint using the original repository","local":"3-4-run-a-pretrained-checkpoint-using-the-original-repository","sections":[],"depth":3},{"title":"5.-14. Port BrandNewBert to 🤗 Transformers","local":"5-14-port-brandnewbert-to--transformers","sections":[],"depth":3},{"title":"Share your work!!","local":"share-your-work","sections":[],"depth":3}],"depth":2}],"depth":1}';function qd(el){return Gd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lm extends Qd{constructor(w){super(),Vd(this,w,qd,Sd,Pd,{})}}export{lm as component};
