import{s as ls,o as rs,n as E}from"../chunks/scheduler.182ea377.js";import{S as ds,i as cs,g as r,s as a,r as g,A as ps,h as d,f as l,c as o,j as J,u as h,x as u,k as j,y as n,a as m,v as _,d as b,t as w,w as y}from"../chunks/index.abf12888.js";import{T as Sn}from"../chunks/Tip.230e2334.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{C as Be}from"../chunks/CodeBlock.57fe6e13.js";import{E as We}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as ut}from"../chunks/Heading.16916d63.js";function ms(T){let s,M='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!';return{c(){s=r("p"),s.innerHTML=M},l(c){s=d(c,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1j961ct"&&(s.innerHTML=M)},m(c,i){m(c,s,i)},p:E,d(c){c&&l(s)}}}function fs(T){let s,M="Examples:",c,i,f;return i=new Be({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkX29yX3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oZGV2aWNlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNzY4JTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyQyUyMHRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionImg2ImgPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function us(T){let s,M=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){s=r("p"),s.innerHTML=M},l(c){s=d(c,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ackzsn"&&(s.innerHTML=M)},m(c,i){m(c,s,i)},p:E,d(c){c&&l(s)}}}function gs(T){let s,M="Examples:",c,i,f;return i=new Be({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function hs(T){let s,M=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){s=r("p"),s.textContent=M},l(c){s=d(c,"P",{"data-svelte-h":!0}),u(s)!=="svelte-17p1lpg"&&(s.textContent=M)},m(c,i){m(c,s,i)},p:E,d(c){c&&l(s)}}}function _s(T){let s,M="Examples:",c,i,f;return i=new Be({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function bs(T){let s,M="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,i,f;return i=new Be({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1gc783q"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function ws(T){let s,M="locally:",c,i,f;return i=new Be({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-4c75kq"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function ys(T){let s,M="Examples:",c,i,f;return i=new Be({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function vs(T){let s,M="Examples:",c,i,f;return i=new Be({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionImg2ImgPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)


<span class="hljs-meta">&gt;&gt;&gt; </span>rng = create_key(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_img = init_img.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;flax&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>rng = jax.random.split(rng, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids, processed_image = pipeline.prepare_inputs(
<span class="hljs-meta">... </span>    prompt=[prompts] * num_samples, image=[init_img] * num_samples
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>p_params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = shard(processed_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipeline(
<span class="hljs-meta">... </span>    prompt_ids=prompt_ids,
<span class="hljs-meta">... </span>    image=processed_image,
<span class="hljs-meta">... </span>    params=p_params,
<span class="hljs-meta">... </span>    prng_seed=rng,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.75</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    jit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = pipeline.numpy_to_pil(np.asarray(output.reshape((num_samples,) + output.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){s=r("p"),s.textContent=M,c=a(),g(i.$$.fragment)},l(t){s=d(t,"P",{"data-svelte-h":!0}),u(s)!=="svelte-kvfsh7"&&(s.textContent=M),c=o(t),h(i.$$.fragment,t)},m(t,x){m(t,s,x),m(t,c,x),_(i,t,x),f=!0},p:E,i(t){f||(b(i.$$.fragment,t),f=!0)},o(t){w(i.$$.fragment,t),f=!1},d(t){t&&(l(s),l(c)),y(i,t)}}}function xs(T){let s,M,c,i,f,t,x,kn="The Stable Diffusion model can also be applied to image-to-image generation by passing a text prompt and an initial image to condition the generation of new images.",gt,de,Dn='The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> uses the diffusion-denoising mechanism proposed in <a href="https://huggingface.co/papers/2108.01073" rel="nofollow">SDEdit: Guided Image Synthesis and Editing with Stochastic Differential Equations</a> by Chenlin Meng, Yutong He, Yang Song, Jiaming Song, Jiajun Wu, Jun-Yan Zhu, Stefano Ermon.',ht,ce,Pn="The abstract from the paper is:",_t,pe,Un="<em>Guided image synthesis enables everyday users to create and edit photo-realistic images with minimum effort. The key challenge is balancing faithfulness to the user input (e.g., hand-drawn colored strokes) and realism of the synthesized image. Existing GAN-based methods attempt to achieve such balance using either conditional GANs or GAN inversions, which are challenging and often require additional training data or loss functions for individual applications. To address these issues, we introduce a new image synthesis and editing method, Stochastic Differential Editing (SDEdit), based on a diffusion model generative prior, which synthesizes realistic images by iteratively denoising through a stochastic differential equation (SDE). Given an input image with user guide of any type, SDEdit first adds noise to the input, then subsequently denoises the resulting image through the SDE prior to increase its realism. SDEdit does not require task-specific training or inversions and can naturally achieve the balance between realism and faithfulness. SDEdit significantly outperforms state-of-the-art GAN-based methods by up to 98.09% on realism and 91.72% on overall satisfaction scores, according to a human perception study, on multiple tasks, including stroke-based image synthesis and editing as well as image compositing.</em>",bt,R,wt,me,yt,v,fe,Ut,Ge,Zn="Pipeline for text-guided image-to-image generation using Stable Diffusion.",Zt,Fe,Cn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ct,Ne,Wn="The pipeline also inherits the following loading methods:",Wt,Le,Bn='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Bt,F,ue,Gt,Ee,Gn="The call function to the pipeline for generation.",Ft,A,Nt,Z,ge,Lt,Xe,Fn=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Et,Y,Xt,H,Vt,Q,he,zt,Ve,Nn=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Rt,C,_e,At,ze,Ln=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Yt,q,Ht,O,Qt,K,be,qt,Re,En='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ot,S,we,Kt,Ae,Xn=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,en,Ye,Vn="Example:",tn,ee,nn,He,zn=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,sn,te,an,N,ye,on,Qe,Rn=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,ln,ne,rn,k,ve,dn,qe,An=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,cn,Oe,Yn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",pn,Ke,Hn='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',mn,et,Qn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,fn,tt,qn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,un,se,xe,gn,nt,On="Save the LoRA parameters corresponding to the UNet and text encoder.",hn,ae,Ie,_n,st,Kn="Encodes the prompt into text encoder hidden states.",bn,oe,Me,wn,at,es='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',vt,Te,xt,X,Je,yn,ot,ts="Output class for Stable Diffusion pipelines.",It,je,Mt,U,$e,vn,it,ns="Flax-based pipeline for text-guided image-to-image generation using Stable Diffusion.",xn,lt,ss=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,In,L,Se,Mn,rt,as="The call function to the pipeline for generation.",Tn,ie,Tt,ke,Jt,W,De,Jn,dt,os="Output class for Flax-based Stable Diffusion pipelines.",jn,le,Pe,$n,ct,is="“Returns a new object replacing the specified fields with new values.",jt,ft,$t;return f=new ut({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h1"}}),R=new Sn({props:{$$slots:{default:[ms]},$$scope:{ctx:T}}}),me=new ut({props:{title:"StableDiffusionImg2ImgPipeline",local:"diffusers.StableDiffusionImg2ImgPipeline",headingTag:"h2"}}),fe=new $({props:{name:"class diffusers.StableDiffusionImg2ImgPipeline",anchor:"diffusers.StableDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L157"}}),ue=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": Optional = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": Optional = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": Optional = 0.0"},{name:"generator",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L825",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new We({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[fs]},$$scope:{ctx:T}}}),ge=new $({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1588"}}),Y=new Sn({props:{warning:!0,$$slots:{default:[us]},$$scope:{ctx:T}}}),H=new We({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[gs]},$$scope:{ctx:T}}}),he=new $({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1628"}}),_e=new $({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1527"}}),q=new Sn({props:{warning:!0,$$slots:{default:[hs]},$$scope:{ctx:T}}}),O=new We({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[_s]},$$scope:{ctx:T}}}),be=new $({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1562"}}),we=new $({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),ee=new We({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.example",$$slots:{default:[bs]},$$scope:{ctx:T}}}),te=new We({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[ws]},$$scope:{ctx:T}}}),ye=new $({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L156"}}),ne=new We({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.example",$$slots:{default:[ys]},$$scope:{ctx:T}}}),ve=new $({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L80"}}),xe=new $({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L707"}}),Ie=new $({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L329"}}),Me=new $({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L770",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Te=new ut({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Je=new $({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),je=new ut({props:{title:"FlaxStableDiffusionImg2ImgPipeline",local:"diffusers.FlaxStableDiffusionImg2ImgPipeline",headingTag:"h2"}}),$e=new $({props:{name:"class diffusers.FlaxStableDiffusionImg2ImgPipeline",anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_img2img.py#L105"}}),Se=new $({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"noise",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.prompt_ids",description:`<strong>prompt_ids</strong> (<code>jnp.ndarray</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt_ids"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>jnp.ndarray</code>) &#x2014;
Array representing an image batch to be used as the starting point.`,name:"image"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.params",description:`<strong>params</strong> (<code>Dict</code> or <code>FrozenDict</code>) &#x2014;
Dictionary containing the model parameters/weights.`,name:"params"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.prng_seed",description:`<strong>prng_seed</strong> (<code>jax.Array</code> or <code>jax.Array</code>) &#x2014;
Array containing random number generator key.`,name:"prng_seed"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.noise",description:`<strong>noise</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. The array is generated by
sampling using the supplied random <code>generator</code>.`,name:"noise"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_img2img.py#L337",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ie=new We({props:{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[vs]},$$scope:{ctx:T}}}),ke=new ut({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),De=new $({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Pe=new $({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){s=r("meta"),M=a(),c=r("p"),i=a(),g(f.$$.fragment),t=a(),x=r("p"),x.textContent=kn,gt=a(),de=r("p"),de.innerHTML=Dn,ht=a(),ce=r("p"),ce.textContent=Pn,_t=a(),pe=r("p"),pe.innerHTML=Un,bt=a(),g(R.$$.fragment),wt=a(),g(me.$$.fragment),yt=a(),v=r("div"),g(fe.$$.fragment),Ut=a(),Ge=r("p"),Ge.textContent=Zn,Zt=a(),Fe=r("p"),Fe.innerHTML=Cn,Ct=a(),Ne=r("p"),Ne.textContent=Wn,Wt=a(),Le=r("ul"),Le.innerHTML=Bn,Bt=a(),F=r("div"),g(ue.$$.fragment),Gt=a(),Ee=r("p"),Ee.textContent=Gn,Ft=a(),g(A.$$.fragment),Nt=a(),Z=r("div"),g(ge.$$.fragment),Lt=a(),Xe=r("p"),Xe.textContent=Fn,Et=a(),g(Y.$$.fragment),Xt=a(),g(H.$$.fragment),Vt=a(),Q=r("div"),g(he.$$.fragment),zt=a(),Ve=r("p"),Ve.innerHTML=Nn,Rt=a(),C=r("div"),g(_e.$$.fragment),At=a(),ze=r("p"),ze.innerHTML=Ln,Yt=a(),g(q.$$.fragment),Ht=a(),g(O.$$.fragment),Qt=a(),K=r("div"),g(be.$$.fragment),qt=a(),Re=r("p"),Re.innerHTML=En,Ot=a(),S=r("div"),g(we.$$.fragment),Kt=a(),Ae=r("p"),Ae.innerHTML=Xn,en=a(),Ye=r("p"),Ye.textContent=Vn,tn=a(),g(ee.$$.fragment),nn=a(),He=r("p"),He.innerHTML=zn,sn=a(),g(te.$$.fragment),an=a(),N=r("div"),g(ye.$$.fragment),on=a(),Qe=r("p"),Qe.innerHTML=Rn,ln=a(),g(ne.$$.fragment),rn=a(),k=r("div"),g(ve.$$.fragment),dn=a(),qe=r("p"),qe.innerHTML=An,cn=a(),Oe=r("p"),Oe.innerHTML=Yn,pn=a(),Ke=r("p"),Ke.innerHTML=Hn,mn=a(),et=r("p"),et.innerHTML=Qn,fn=a(),tt=r("p"),tt.innerHTML=qn,un=a(),se=r("div"),g(xe.$$.fragment),gn=a(),nt=r("p"),nt.textContent=On,hn=a(),ae=r("div"),g(Ie.$$.fragment),_n=a(),st=r("p"),st.textContent=Kn,bn=a(),oe=r("div"),g(Me.$$.fragment),wn=a(),at=r("p"),at.innerHTML=es,vt=a(),g(Te.$$.fragment),xt=a(),X=r("div"),g(Je.$$.fragment),yn=a(),ot=r("p"),ot.textContent=ts,It=a(),g(je.$$.fragment),Mt=a(),U=r("div"),g($e.$$.fragment),vn=a(),it=r("p"),it.textContent=ns,xn=a(),lt=r("p"),lt.innerHTML=ss,In=a(),L=r("div"),g(Se.$$.fragment),Mn=a(),rt=r("p"),rt.textContent=as,Tn=a(),g(ie.$$.fragment),Tt=a(),g(ke.$$.fragment),Jt=a(),W=r("div"),g(De.$$.fragment),Jn=a(),dt=r("p"),dt.textContent=os,jn=a(),le=r("div"),g(Pe.$$.fragment),$n=a(),ct=r("p"),ct.textContent=is,jt=a(),ft=r("p"),this.h()},l(e){const p=ps("svelte-u9bgzb",document.head);s=d(p,"META",{name:!0,content:!0}),p.forEach(l),M=o(e),c=d(e,"P",{}),J(c).forEach(l),i=o(e),h(f.$$.fragment,e),t=o(e),x=d(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1wz97a4"&&(x.textContent=kn),gt=o(e),de=d(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-1ju27vr"&&(de.innerHTML=Dn),ht=o(e),ce=d(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1cwsb16"&&(ce.textContent=Pn),_t=o(e),pe=d(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1nbpwa2"&&(pe.innerHTML=Un),bt=o(e),h(R.$$.fragment,e),wt=o(e),h(me.$$.fragment,e),yt=o(e),v=d(e,"DIV",{class:!0});var I=J(v);h(fe.$$.fragment,I),Ut=o(I),Ge=d(I,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-1n95u1g"&&(Ge.textContent=Zn),Zt=o(I),Fe=d(I,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-496sm0"&&(Fe.innerHTML=Cn),Ct=o(I),Ne=d(I,"P",{"data-svelte-h":!0}),u(Ne)!=="svelte-14s6m4u"&&(Ne.textContent=Wn),Wt=o(I),Le=d(I,"UL",{"data-svelte-h":!0}),u(Le)!=="svelte-o83amg"&&(Le.innerHTML=Bn),Bt=o(I),F=d(I,"DIV",{class:!0});var V=J(F);h(ue.$$.fragment,V),Gt=o(V),Ee=d(V,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-50j04k"&&(Ee.textContent=Gn),Ft=o(V),h(A.$$.fragment,V),V.forEach(l),Nt=o(I),Z=d(I,"DIV",{class:!0});var B=J(Z);h(ge.$$.fragment,B),Lt=o(B),Xe=d(B,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-10jaql7"&&(Xe.textContent=Fn),Et=o(B),h(Y.$$.fragment,B),Xt=o(B),h(H.$$.fragment,B),B.forEach(l),Vt=o(I),Q=d(I,"DIV",{class:!0});var Ue=J(Q);h(he.$$.fragment,Ue),zt=o(Ue),Ve=d(Ue,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1lh0nh5"&&(Ve.innerHTML=Nn),Ue.forEach(l),Rt=o(I),C=d(I,"DIV",{class:!0});var G=J(C);h(_e.$$.fragment,G),At=o(G),ze=d(G,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-e03q3e"&&(ze.innerHTML=Ln),Yt=o(G),h(q.$$.fragment,G),Ht=o(G),h(O.$$.fragment,G),G.forEach(l),Qt=o(I),K=d(I,"DIV",{class:!0});var Ze=J(K);h(be.$$.fragment,Ze),qt=o(Ze),Re=d(Ze,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-1vfte1e"&&(Re.innerHTML=En),Ze.forEach(l),Ot=o(I),S=d(I,"DIV",{class:!0});var D=J(S);h(we.$$.fragment,D),Kt=o(D),Ae=d(D,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-1lv88wo"&&(Ae.innerHTML=Xn),en=o(D),Ye=d(D,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-11lpom8"&&(Ye.textContent=Vn),tn=o(D),h(ee.$$.fragment,D),nn=o(D),He=d(D,"P",{"data-svelte-h":!0}),u(He)!=="svelte-15d7mv5"&&(He.innerHTML=zn),sn=o(D),h(te.$$.fragment,D),D.forEach(l),an=o(I),N=d(I,"DIV",{class:!0});var z=J(N);h(ye.$$.fragment,z),on=o(z),Qe=d(z,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-pmqrln"&&(Qe.innerHTML=Rn),ln=o(z),h(ne.$$.fragment,z),z.forEach(l),rn=o(I),k=d(I,"DIV",{class:!0});var P=J(k);h(ve.$$.fragment,P),dn=o(P),qe=d(P,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-vs7s0z"&&(qe.innerHTML=An),cn=o(P),Oe=d(P,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-15b960v"&&(Oe.innerHTML=Yn),pn=o(P),Ke=d(P,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-12uyc98"&&(Ke.innerHTML=Hn),mn=o(P),et=d(P,"P",{"data-svelte-h":!0}),u(et)!=="svelte-1q3yzk7"&&(et.innerHTML=Qn),fn=o(P),tt=d(P,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-10xxjud"&&(tt.innerHTML=qn),P.forEach(l),un=o(I),se=d(I,"DIV",{class:!0});var Ce=J(se);h(xe.$$.fragment,Ce),gn=o(Ce),nt=d(Ce,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-1ufq5ot"&&(nt.textContent=On),Ce.forEach(l),hn=o(I),ae=d(I,"DIV",{class:!0});var St=J(ae);h(Ie.$$.fragment,St),_n=o(St),st=d(St,"P",{"data-svelte-h":!0}),u(st)!=="svelte-16q0ax1"&&(st.textContent=Kn),St.forEach(l),bn=o(I),oe=d(I,"DIV",{class:!0});var kt=J(oe);h(Me.$$.fragment,kt),wn=o(kt),at=d(kt,"P",{"data-svelte-h":!0}),u(at)!=="svelte-vo59ec"&&(at.innerHTML=es),kt.forEach(l),I.forEach(l),vt=o(e),h(Te.$$.fragment,e),xt=o(e),X=d(e,"DIV",{class:!0});var Dt=J(X);h(Je.$$.fragment,Dt),yn=o(Dt),ot=d(Dt,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-1qpjiuf"&&(ot.textContent=ts),Dt.forEach(l),It=o(e),h(je.$$.fragment,e),Mt=o(e),U=d(e,"DIV",{class:!0});var re=J(U);h($e.$$.fragment,re),vn=o(re),it=d(re,"P",{"data-svelte-h":!0}),u(it)!=="svelte-at7ys7"&&(it.textContent=ns),xn=o(re),lt=d(re,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-knddhk"&&(lt.innerHTML=ss),In=o(re),L=d(re,"DIV",{class:!0});var pt=J(L);h(Se.$$.fragment,pt),Mn=o(pt),rt=d(pt,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-50j04k"&&(rt.textContent=as),Tn=o(pt),h(ie.$$.fragment,pt),pt.forEach(l),re.forEach(l),Tt=o(e),h(ke.$$.fragment,e),Jt=o(e),W=d(e,"DIV",{class:!0});var mt=J(W);h(De.$$.fragment,mt),Jn=o(mt),dt=d(mt,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-wzv2jc"&&(dt.textContent=os),jn=o(mt),le=d(mt,"DIV",{class:!0});var Pt=J(le);h(Pe.$$.fragment,Pt),$n=o(Pt),ct=d(Pt,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-5ihtpa"&&(ct.textContent=is),Pt.forEach(l),mt.forEach(l),jt=o(e),ft=d(e,"P",{}),J(ft).forEach(l),this.h()},h(){j(s,"name","hf:doc:metadata"),j(s,"content",Is),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){n(document.head,s),m(e,M,p),m(e,c,p),m(e,i,p),_(f,e,p),m(e,t,p),m(e,x,p),m(e,gt,p),m(e,de,p),m(e,ht,p),m(e,ce,p),m(e,_t,p),m(e,pe,p),m(e,bt,p),_(R,e,p),m(e,wt,p),_(me,e,p),m(e,yt,p),m(e,v,p),_(fe,v,null),n(v,Ut),n(v,Ge),n(v,Zt),n(v,Fe),n(v,Ct),n(v,Ne),n(v,Wt),n(v,Le),n(v,Bt),n(v,F),_(ue,F,null),n(F,Gt),n(F,Ee),n(F,Ft),_(A,F,null),n(v,Nt),n(v,Z),_(ge,Z,null),n(Z,Lt),n(Z,Xe),n(Z,Et),_(Y,Z,null),n(Z,Xt),_(H,Z,null),n(v,Vt),n(v,Q),_(he,Q,null),n(Q,zt),n(Q,Ve),n(v,Rt),n(v,C),_(_e,C,null),n(C,At),n(C,ze),n(C,Yt),_(q,C,null),n(C,Ht),_(O,C,null),n(v,Qt),n(v,K),_(be,K,null),n(K,qt),n(K,Re),n(v,Ot),n(v,S),_(we,S,null),n(S,Kt),n(S,Ae),n(S,en),n(S,Ye),n(S,tn),_(ee,S,null),n(S,nn),n(S,He),n(S,sn),_(te,S,null),n(v,an),n(v,N),_(ye,N,null),n(N,on),n(N,Qe),n(N,ln),_(ne,N,null),n(v,rn),n(v,k),_(ve,k,null),n(k,dn),n(k,qe),n(k,cn),n(k,Oe),n(k,pn),n(k,Ke),n(k,mn),n(k,et),n(k,fn),n(k,tt),n(v,un),n(v,se),_(xe,se,null),n(se,gn),n(se,nt),n(v,hn),n(v,ae),_(Ie,ae,null),n(ae,_n),n(ae,st),n(v,bn),n(v,oe),_(Me,oe,null),n(oe,wn),n(oe,at),m(e,vt,p),_(Te,e,p),m(e,xt,p),m(e,X,p),_(Je,X,null),n(X,yn),n(X,ot),m(e,It,p),_(je,e,p),m(e,Mt,p),m(e,U,p),_($e,U,null),n(U,vn),n(U,it),n(U,xn),n(U,lt),n(U,In),n(U,L),_(Se,L,null),n(L,Mn),n(L,rt),n(L,Tn),_(ie,L,null),m(e,Tt,p),_(ke,e,p),m(e,Jt,p),m(e,W,p),_(De,W,null),n(W,Jn),n(W,dt),n(W,jn),n(W,le),_(Pe,le,null),n(le,$n),n(le,ct),m(e,jt,p),m(e,ft,p),$t=!0},p(e,[p]){const I={};p&2&&(I.$$scope={dirty:p,ctx:e}),R.$set(I);const V={};p&2&&(V.$$scope={dirty:p,ctx:e}),A.$set(V);const B={};p&2&&(B.$$scope={dirty:p,ctx:e}),Y.$set(B);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),H.$set(Ue);const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),q.$set(G);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),O.$set(Ze);const D={};p&2&&(D.$$scope={dirty:p,ctx:e}),ee.$set(D);const z={};p&2&&(z.$$scope={dirty:p,ctx:e}),te.$set(z);const P={};p&2&&(P.$$scope={dirty:p,ctx:e}),ne.$set(P);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),ie.$set(Ce)},i(e){$t||(b(f.$$.fragment,e),b(R.$$.fragment,e),b(me.$$.fragment,e),b(fe.$$.fragment,e),b(ue.$$.fragment,e),b(A.$$.fragment,e),b(ge.$$.fragment,e),b(Y.$$.fragment,e),b(H.$$.fragment,e),b(he.$$.fragment,e),b(_e.$$.fragment,e),b(q.$$.fragment,e),b(O.$$.fragment,e),b(be.$$.fragment,e),b(we.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(ye.$$.fragment,e),b(ne.$$.fragment,e),b(ve.$$.fragment,e),b(xe.$$.fragment,e),b(Ie.$$.fragment,e),b(Me.$$.fragment,e),b(Te.$$.fragment,e),b(Je.$$.fragment,e),b(je.$$.fragment,e),b($e.$$.fragment,e),b(Se.$$.fragment,e),b(ie.$$.fragment,e),b(ke.$$.fragment,e),b(De.$$.fragment,e),b(Pe.$$.fragment,e),$t=!0)},o(e){w(f.$$.fragment,e),w(R.$$.fragment,e),w(me.$$.fragment,e),w(fe.$$.fragment,e),w(ue.$$.fragment,e),w(A.$$.fragment,e),w(ge.$$.fragment,e),w(Y.$$.fragment,e),w(H.$$.fragment,e),w(he.$$.fragment,e),w(_e.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(be.$$.fragment,e),w(we.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ye.$$.fragment,e),w(ne.$$.fragment,e),w(ve.$$.fragment,e),w(xe.$$.fragment,e),w(Ie.$$.fragment,e),w(Me.$$.fragment,e),w(Te.$$.fragment,e),w(Je.$$.fragment,e),w(je.$$.fragment,e),w($e.$$.fragment,e),w(Se.$$.fragment,e),w(ie.$$.fragment,e),w(ke.$$.fragment,e),w(De.$$.fragment,e),w(Pe.$$.fragment,e),$t=!1},d(e){e&&(l(M),l(c),l(i),l(t),l(x),l(gt),l(de),l(ht),l(ce),l(_t),l(pe),l(bt),l(wt),l(yt),l(v),l(vt),l(xt),l(X),l(It),l(Mt),l(U),l(Tt),l(Jt),l(W),l(jt),l(ft)),l(s),y(f,e),y(R,e),y(me,e),y(fe),y(ue),y(A),y(ge),y(Y),y(H),y(he),y(_e),y(q),y(O),y(be),y(we),y(ee),y(te),y(ye),y(ne),y(ve),y(xe),y(Ie),y(Me),y(Te,e),y(Je),y(je,e),y($e),y(Se),y(ie),y(ke,e),y(De),y(Pe)}}}const Is='{"title":"Image-to-image","local":"image-to-image","sections":[{"title":"StableDiffusionImg2ImgPipeline","local":"diffusers.StableDiffusionImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionImg2ImgPipeline","local":"diffusers.FlaxStableDiffusionImg2ImgPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ms(T){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends ds{constructor(s){super(),cs(this,s,Ms,xs,ls,{})}}export{Ps as component};
