import{s as rm,n as nm,o as dm}from"../chunks/scheduler.b108d059.js";import{S as am,i as cm,g as r,s as i,r as p,A as pm,h as n,f as t,c as l,j as c,u,x as d,k as a,y as um,a as s,v as g,d as m,t as f,w as h}from"../chunks/index.008de539.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function gm(hp){let L,fi,gi,hi,b,_i,T,Li,P,_p="Classes, functions, and utilities for generation.",bi,$,Lp="<strong>Todo</strong>",Ti,w,bp="<li>Describe how to create a custom <code>GenerationConfig</code>.</li>",Pi,v,Tp='<li><a href="#module_utils/generation">utils/generation</a><ul><li><em>static</em><ul><li><a href="#module_utils/generation.LogitsProcessorList">.LogitsProcessorList</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_utils/generation.LogitsProcessorList_new"><code>new LogitsProcessorList()</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+push"><code>.push(item)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+extend"><code>.extend(items)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+_call"><code>._call(input_ids, batchedLogits)</code></a></li></ul></li> <li><a href="#module_utils/generation.LogitsProcessor">.LogitsProcessor</a> ⇐ <code>Callable</code><ul><li><em><a href="#module_utils/generation.LogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></em></li></ul></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor">.ForceTokensLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForceTokensLogitsProcessor_new"><code>new ForceTokensLogitsProcessor(forced_decoder_ids)</code></a></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor">.ForcedBOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"><code>new ForcedBOSTokenLogitsProcessor(bos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor">.ForcedEOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"><code>new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></li></ul></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor">.SuppressTokensAtBeginLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"><code>new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)</code></a></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor">.WhisperTimeStampLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"><code>new WhisperTimeStampLogitsProcessor(generate_config)</code></a></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor">.NoRepeatNGramLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"><code>new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)</code></a></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"><code>.getNgrams(prevInputIds)</code></a> ⇒ <code>Map.&lt;string, Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"><code>.getGeneratedNgrams(bannedNgrams, prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"><code>.calcBannedNgramTokens(prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor">.RepetitionPenaltyLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"><code>new RepetitionPenaltyLogitsProcessor(penalty)</code></a></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor">.MinLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinLengthLogitsProcessor_new"><code>new MinLengthLogitsProcessor(min_length, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor">.MinNewTokensLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"><code>new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.NoBadWordsLogitsProcessor">.NoBadWordsLogitsProcessor</a><ul><li><a href="#new_module_utils/generation.NoBadWordsLogitsProcessor_new"><code>new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.NoBadWordsLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.GenerationConfig">.GenerationConfig</a><ul><li><a href="#new_module_utils/generation.GenerationConfig_new"><code>new GenerationConfig([kwargs])</code></a></li></ul></li> <li><a href="#module_utils/generation.Sampler">.Sampler</a><ul><li><a href="#new_module_utils/generation.Sampler_new"><code>new Sampler(generation_config)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/generation.Sampler+_call"><code>._call(logits, index)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/generation.Sampler+sample"><code>.sample(logits, index)</code></a></li> <li><a href="#module_utils/generation.Sampler+getLogits"><code>.getLogits(logits, index)</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/generation.Sampler+randomSelect"><code>.randomSelect(probabilities)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/generation.Sampler.getSampler"><code>.getSampler(generation_config)</code></a> ⇒ <code>Sampler</code></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/generation..GreedySampler">~GreedySampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..GreedySampler+sample"><code>.sample(logits, [index])</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..MultinomialSampler">~MultinomialSampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..MultinomialSampler+sample"><code>.sample(logits, index)</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..BeamSearchSampler">~BeamSearchSampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..BeamSearchSampler+sample"><code>.sample(logits, index)</code></a> ⇒ <code>Array</code></li></ul></li></ul></li></ul></li>',$i,wi,vi,k,ki,x,xi,y,Pp=`A class representing a list of logits processors. A logits processor is a function that modifies the logits
output of a language model. This class provides methods for adding new processors and applying all processors to a
batch of logits.`,yi,C,$p='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Ci,M,wp='<li><a href="#module_utils/generation.LogitsProcessorList">.LogitsProcessorList</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_utils/generation.LogitsProcessorList_new"><code>new LogitsProcessorList()</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+push"><code>.push(item)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+extend"><code>.extend(items)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+_call"><code>._call(input_ids, batchedLogits)</code></a></li></ul></li>',Mi,Hi,Si,H,Ai,S,Ni,A,vp="Constructs a new instance of <code>LogitsProcessorList</code>.",Ei,Ri,Bi,N,Oi,E,ji,R,kp="Adds a new logits processor to the list.",Gi,B,xp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',Ii,O,yp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>LogitsProcessor</code></td><td><p>The logits processor function to add.</p></td></tr></tbody>",Fi,qi,Di,j,Wi,G,Ki,I,Cp="Adds multiple logits processors to the list.",zi,F,Mp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',Ui,q,Hp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array.&lt;LogitsProcessor&gt;</code></td><td><p>The logits processor functions to add.</p></td></tr></tbody>",Ji,Qi,Vi,D,Xi,W,Yi,K,Sp="Applies all logits processors in the list to a batch of logits, modifying them in-place.",Zi,z,Ap='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',el,U,Np=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input IDs for the language model.</p></td> </tr><tr><td>batchedLogits</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>A 2D array of logits, where each row corresponds to a single
                                               input sequence in the batch.</p></td></tr></tbody>`,tl,ol,sl,J,il,Q,ll,V,Ep="Base class for processing logits.",rl,X,Rp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',nl,dl,al,Y,cl,Z,pl,ee,Bp="Apply the processor to the input logits.",ul,te,Op='<strong>Kind</strong>: instance abstract method of <a href="#module_utils/generation.LogitsProcessor"><code>LogitsProcessor</code></a><br/> <strong>Throws</strong>:',gl,oe,jp="<li><code>Error</code> Throws an error if `_call` is not implemented in the subclass.</li>",ml,se,Gp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits to process.</p></td></tr></tbody>",fl,hl,_l,ie,Ll,le,bl,re,Ip="A logits processor that forces a specific token to be generated by the decoder.",Tl,ne,Fp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Pl,de,qp='<li><a href="#module_utils/generation.ForceTokensLogitsProcessor">.ForceTokensLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForceTokensLogitsProcessor_new"><code>new ForceTokensLogitsProcessor(forced_decoder_ids)</code></a></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li>',$l,wl,vl,ae,kl,ce,xl,pe,Dp="Constructs a new instance of <code>ForceTokensLogitsProcessor</code>.",yl,ue,Wp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>forced_decoder_ids</td><td><code>Array</code></td><td><p>The ids of tokens that should be forced.</p></td></tr></tbody>",Cl,Ml,Hl,ge,Sl,me,Al,fe,Kp="Apply the processor to the input logits.",Nl,he,zp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForceTokensLogitsProcessor"><code>ForceTokensLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The processed logits.',El,_e,Up="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits to process.</p></td></tr></tbody>",Rl,Bl,Ol,Le,jl,be,Gl,Te,Jp="A LogitsProcessor that forces a BOS token at the beginning of the generated sequence.",Il,Pe,Qp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Fl,$e,Vp='<li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor">.ForcedBOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"><code>new ForcedBOSTokenLogitsProcessor(bos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',ql,Dl,Wl,we,Kl,ve,zl,ke,Xp="Create a ForcedBOSTokenLogitsProcessor.",Ul,xe,Yp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bos_token_id</td><td><code>number</code></td><td><p>The ID of the beginning-of-sequence token to be forced.</p></td></tr></tbody>",Jl,Ql,Vl,ye,Xl,Ce,Yl,Me,Zp="Apply the BOS token forcing to the logits.",Zl,He,eu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor"><code>ForcedBOSTokenLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with BOS token forcing.',er,Se,tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",tr,or,sr,Ae,ir,Ne,lr,Ee,ou="A logits processor that forces end-of-sequence token probability to 1.",rr,Re,su='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',nr,Be,iu='<li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor">.ForcedEOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"><code>new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></li></ul></li>',dr,ar,cr,Oe,pr,je,ur,Ge,lu="Create a ForcedEOSTokenLogitsProcessor.",gr,Ie,ru="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>max_length</td><td><code>number</code></td><td><p>Max length of the sequence.</p></td> </tr><tr><td>forced_eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID of the end-of-sequence token to be forced.</p></td></tr></tbody>",mr,fr,hr,Fe,_r,qe,Lr,De,nu="Apply the processor to input_ids and logits.",br,We,du='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor"><code>ForcedEOSTokenLogitsProcessor</code></a>',Tr,Ke,au="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits tensor.</p></td></tr></tbody>",Pr,$r,wr,ze,vr,Ue,kr,Je,cu=`A LogitsProcessor that suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by
<code>begin_suppress_tokens</code> at not sampled at the begining of the generation.`,xr,Qe,pu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',yr,Ve,uu='<li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor">.SuppressTokensAtBeginLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"><code>new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)</code></a></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Cr,Mr,Hr,Xe,Sr,Ye,Ar,Ze,gu="Create a SuppressTokensAtBeginLogitsProcessor.",Nr,et,mu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>begin_suppress_tokens</td><td><code>Array.&lt;number&gt;</code></td><td><p>The IDs of the tokens to suppress.</p></td> </tr><tr><td>begin_index</td><td><code>number</code></td><td><p>The number of tokens to generate before suppressing tokens.</p></td></tr></tbody>",Er,Rr,Br,tt,Or,ot,jr,st,fu="Apply the BOS token forcing to the logits.",Gr,it,hu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor"><code>SuppressTokensAtBeginLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with BOS token forcing.',Ir,lt,_u="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Fr,qr,Dr,rt,Wr,nt,Kr,dt,Lu="A LogitsProcessor that handles adding timestamps to generated text.",zr,at,bu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Ur,ct,Tu='<li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor">.WhisperTimeStampLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"><code>new WhisperTimeStampLogitsProcessor(generate_config)</code></a></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Jr,Qr,Vr,pt,Xr,ut,Yr,gt,Pu="Constructs a new WhisperTimeStampLogitsProcessor.",Zr,mt,$u="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generate_config</td><td><code>Object</code></td><td><p>The config object passed to the <code>generate()</code> method of a transformer model.</p></td> </tr><tr><td>generate_config.eos_token_id</td><td><code>number</code></td><td><p>The ID of the end-of-sequence token.</p></td> </tr><tr><td>generate_config.no_timestamps_token_id</td><td><code>number</code></td><td><p>The ID of the token used to indicate that a token should not have a timestamp.</p></td> </tr><tr><td>[generate_config.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>An array of two-element arrays representing decoder IDs that are forced to appear in the output. The second element of each array indicates whether the token is a timestamp.</p></td> </tr><tr><td>[generate_config.max_initial_timestamp_index]</td><td><code>number</code></td><td><p>The maximum index at which an initial timestamp can appear.</p></td></tr></tbody>",en,tn,on,ft,sn,ht,ln,_t,wu="Modify the logits to handle timestamp tokens.",rn,Lt,vu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.WhisperTimeStampLogitsProcessor"><code>WhisperTimeStampLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The modified logits.',nn,bt,ku="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input sequence of tokens.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits output by the model.</p></td></tr></tbody>",dn,an,cn,Tt,pn,Pt,un,$t,xu="A logits processor that disallows ngrams of a certain size to be repeated.",gn,wt,yu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',mn,vt,Cu='<li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor">.NoRepeatNGramLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"><code>new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)</code></a></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"><code>.getNgrams(prevInputIds)</code></a> ⇒ <code>Map.&lt;string, Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"><code>.getGeneratedNgrams(bannedNgrams, prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"><code>.calcBannedNgramTokens(prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',fn,hn,_n,kt,Ln,xt,bn,yt,Mu="Create a NoRepeatNGramLogitsProcessor.",Tn,Ct,Hu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>no_repeat_ngram_size</td><td><code>number</code></td><td><p>The no-repeat-ngram size. All ngrams of this size can only occur once.</p></td></tr></tbody>",Pn,$n,wn,Mt,vn,Ht,kn,St,Su="Generate n-grams from a sequence of token ids.",xn,At,Au='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Map.&lt;string, Array&lt;number&gt;&gt;</code> - Map of generated n-grams',yn,Nt,Nu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",Cn,Mn,Hn,Et,Sn,Rt,An,Bt,Eu="Generate n-grams from a sequence of token ids.",Nn,Ot,Ru='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Map of generated n-grams',En,jt,Bu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bannedNgrams</td><td><code>Map.&lt;string, Array&lt;number&gt;&gt;</code></td><td><p>Map of banned n-grams</p></td> </tr><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",Rn,Bn,On,Gt,jn,It,Gn,Ft,Ou="Calculate banned n-gram tokens",In,qt,ju='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Map of generated n-grams',Fn,Dt,Gu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",qn,Dn,Wn,Wt,Kn,Kt,zn,zt,Iu="Apply the no-repeat-ngram processor to the logits.",Un,Ut,Fu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with no-repeat-ngram processing.',Jn,Jt,qu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Qn,Vn,Xn,Qt,Yn,Vt,Zn,Xt,Du="A logits processor that penalises repeated output tokens.",ed,Yt,Wu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',td,Zt,Ku='<li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor">.RepetitionPenaltyLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"><code>new RepetitionPenaltyLogitsProcessor(penalty)</code></a></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',od,sd,id,eo,ld,to,rd,oo,zu="Create a RepetitionPenaltyLogitsProcessor.",nd,so,Uu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>penalty</td><td><code>number</code></td><td><p>The penalty to apply for repeated tokens.</p></td></tr></tbody>",dd,ad,cd,io,pd,lo,ud,ro,Ju="Apply the repetition penalty to the logits.",gd,no,Qu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor"><code>RepetitionPenaltyLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with repetition penalty processing.',md,ao,Vu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",fd,hd,_d,co,Ld,po,bd,uo,Xu="A logits processor that enforces a minimum number of tokens.",Td,go,Yu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Pd,mo,Zu='<li><a href="#module_utils/generation.MinLengthLogitsProcessor">.MinLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinLengthLogitsProcessor_new"><code>new MinLengthLogitsProcessor(min_length, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',$d,wd,vd,fo,kd,ho,xd,_o,eg="Create a MinLengthLogitsProcessor.",yd,Lo,tg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min_length</td><td><code>number</code></td><td><p>The minimum length below which the score of <code>eos_token_id</code> is set to negative infinity.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID/IDs of the end-of-sequence token.</p></td></tr></tbody>",Cd,Md,Hd,bo,Sd,To,Ad,Po,og="Apply logit processor.",Nd,$o,sg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.MinLengthLogitsProcessor"><code>MinLengthLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',Ed,wo,ig="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Rd,Bd,Od,vo,jd,ko,Gd,xo,lg="A logits processor that enforces a minimum number of new tokens.",Id,yo,rg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Fd,Co,ng='<li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor">.MinNewTokensLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"><code>new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',qd,Dd,Wd,Mo,Kd,Ho,zd,So,dg="Create a MinNewTokensLengthLogitsProcessor.",Ud,Ao,ag="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prompt_length_to_skip</td><td><code>number</code></td><td><p>The input tokens length.</p></td> </tr><tr><td>min_new_tokens</td><td><code>number</code></td><td><p>The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to negative infinity.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID/IDs of the end-of-sequence token.</p></td></tr></tbody>",Jd,Qd,Vd,No,Xd,Eo,Yd,Ro,cg="Apply logit processor.",Zd,Bo,pg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor"><code>MinNewTokensLengthLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',ea,Oo,ug="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",ta,oa,sa,jo,ia,Go,la,Io,gg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',ra,Fo,mg='<li><a href="#module_utils/generation.NoBadWordsLogitsProcessor">.NoBadWordsLogitsProcessor</a><ul><li><a href="#new_module_utils/generation.NoBadWordsLogitsProcessor_new"><code>new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.NoBadWordsLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',na,da,aa,qo,ca,Do,pa,Wo,fg="Create a <code>NoBadWordsLogitsProcessor</code>.",ua,Ko,hg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bad_words_ids</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>List of list of token ids that are not allowed to be generated.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td></tr></tbody>",ga,ma,fa,zo,ha,Uo,_a,Jo,_g="Apply logit processor.",La,Qo,Lg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoBadWordsLogitsProcessor"><code>NoBadWordsLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',ba,Vo,bg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Ta,Pa,$a,Xo,wa,Yo,va,Zo,Tg="Class that holds a configuration for a generation task.",ka,es,Pg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',xa,ya,Ca,ts,Ma,os,Ha,ss,$g="Create a GenerationConfig object",Sa,is,wg='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>The configuration parameters. If not set, the default values are used.</p></td> </tr><tr><td>[kwargs.max_length]</td><td><code>number</code></td><td><code>20</code></td><td><p>The maximum length the generated tokens can have. Corresponds to the length of the input prompt + <code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.</p></td> </tr><tr><td>[kwargs.max_new_tokens]</td><td><code>number</code></td><td><code></code></td><td><p>The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.</p></td> </tr><tr><td>[kwargs.min_length]</td><td><code>number</code></td><td><code>0</code></td><td><p>The minimum length of the sequence to be generated. Corresponds to the length of the input prompt + <code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.</p></td> </tr><tr><td>[kwargs.min_new_tokens]</td><td><code>number</code></td><td><code></code></td><td><p>The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.</p></td> </tr><tr><td>[kwargs.early_stopping]</td><td><code>boolean</code> | <code>&quot;never&quot;</code></td><td><code>false</code></td><td><p>Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:</p> <ul><li><code>true</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates;</li> <li><code>false</code>, where an heuristic is applied and the generation stops when is it very unlikely to find better candidates;</li> <li><code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical beam search algorithm).</li></ul></td> </tr><tr><td>[kwargs.max_time]</td><td><code>number</code></td><td><code></code></td><td><p>The maximum amount of time you allow the computation to run for in seconds. Generation will still finish the current pass after allocated time has been passed.</p></td> </tr><tr><td>[kwargs.do_sample]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to use sampling; use greedy decoding otherwise.</p></td> </tr><tr><td>[kwargs.num_beams]</td><td><code>number</code></td><td><code>1</code></td><td><p>Number of beams for beam search. 1 means no beam search.</p></td> </tr><tr><td>[kwargs.num_beam_groups]</td><td><code>number</code></td><td><code>1</code></td><td><p>Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[kwargs.penalty_alpha]</td><td><code>number</code></td><td><code></code></td><td><p>The values balance the model confidence and the degeneration penalty in contrastive search decoding.</p></td> </tr><tr><td>[kwargs.use_cache]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether or not the model should use the past last key/values attentions (if applicable to the model) to speed up decoding.</p></td> </tr><tr><td>[kwargs.temperature]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The value used to modulate the next token probabilities.</p></td> </tr><tr><td>[kwargs.top_k]</td><td><code>number</code></td><td><code>50</code></td><td><p>The number of highest probability vocabulary tokens to keep for top-k-filtering.</p></td> </tr><tr><td>[kwargs.top_p]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or higher are kept for generation.</p></td> </tr><tr><td>[kwargs.typical_p]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Local typicality measures how similar the conditional probability of predicting a target token next is to the expected conditional probability of predicting a random token next, given the partial text already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[kwargs.epsilon_cutoff]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>If set to float strictly between 0 and 1, only tokens with a conditional probability greater than <code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191">Truncation Sampling as Language Model Desmoothing</a> for more details.</p></td> </tr><tr><td>[kwargs.eta_cutoff]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between 0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3, depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191">Truncation Sampling as Language Model Desmoothing</a> for more details.</p></td> </tr><tr><td>[kwargs.diversity_penalty]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>This value is subtracted from a beam&#39;s score if it generates a token same as any beam from other group at a particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.</p></td> </tr><tr><td>[kwargs.repetition_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[kwargs.encoder_repetition_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the original input. 1.0 means no penalty.</p></td> </tr><tr><td>[kwargs.length_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while <code>length_penalty</code> &lt; 0.0 encourages shorter sequences.</p></td> </tr><tr><td>[kwargs.no_repeat_ngram_size]</td><td><code>number</code></td><td><code>0</code></td><td><p>If set to int &gt; 0, all ngrams of that size can only occur once.</p></td> </tr><tr><td>[kwargs.bad_words_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>List of token ids that are not allowed to be generated. In order to get the token ids of the words that should not appear in the generated text, use <code>(await tokenizer(bad_words, {add_prefix_space: true, add_special_tokens: false})).input_ids</code>.</p></td> </tr><tr><td>[kwargs.force_words_ids]</td><td><code>Array&lt;Array&lt;number&gt;&gt;</code> | <code>Array&lt;Array&lt;Array&lt;number&gt;&gt;&gt;</code></td><td><code></code></td><td><p>List of token ids that must be generated. If given a <code>number[][]</code>, this is treated as a simple list of words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>number[][][]</code>, this triggers a <a href="https://github.com/huggingface/transformers/issues/14081">disjunctive constraint</a>, where one can allow different forms of each word.</p></td> </tr><tr><td>[kwargs.renormalize_logits]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to renormalize the logits after applying all the logits processors or warpers (including the custom ones). It&#39;s highly recommended to set this flag to <code>true</code> as the search algorithms suppose the score logits are normalized but some logit processors or warpers break the normalization.</p></td> </tr><tr><td>[kwargs.constraints]</td><td><code>Array.&lt;Object&gt;</code></td><td><code></code></td><td><p>Custom constraints that can be added to the generation to ensure that the output will contain the use of certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.</p></td> </tr><tr><td>[kwargs.forced_bos_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for multilingual models like mBART where the first generated token needs to be the target language token.</p></td> </tr><tr><td>[kwargs.forced_eos_token_id]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td> </tr><tr><td>[kwargs.remove_invalid_values]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash. Note that using <code>remove_invalid_values</code> can slow down generation.</p></td> </tr><tr><td>[kwargs.exponential_decay_length_penalty]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty starts and <code>decay_factor</code> represents the factor of exponential decay.</p></td> </tr><tr><td>[kwargs.suppress_tokens]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their log probs to <code>-inf</code> so that they are not sampled.</p></td> </tr><tr><td>[kwargs.begin_suppress_tokens]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit processor will set their log probs to <code>-inf</code> so that they are not sampled.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices that will be forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token of index 123.</p></td> </tr><tr><td>[kwargs.num_return_sequences]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of independently computed returned sequences for each element in the batch.</p></td> </tr><tr><td>[kwargs.output_attentions]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned tensors for more details.</p></td> </tr><tr><td>[kwargs.output_hidden_states]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more details.</p></td> </tr><tr><td>[kwargs.output_scores]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.</p></td> </tr><tr><td>[kwargs.return_dict_in_generate]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.</p></td> </tr><tr><td>[kwargs.pad_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the <em>padding</em> token.</p></td> </tr><tr><td>[kwargs.bos_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the <em>beginning-of-sequence</em> token.</p></td> </tr><tr><td>[kwargs.eos_token_id]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td> </tr><tr><td>[kwargs.encoder_no_repeat_ngram_size]</td><td><code>number</code></td><td><code>0</code></td><td><p>If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the <code>decoder_input_ids</code>.</p></td> </tr><tr><td>[kwargs.decoder_start_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.</p></td> </tr><tr><td>[kwargs.generation_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional generation kwargs will be forwarded to the <code>generate</code> function of the model. Kwargs that are not present in <code>generate</code>&#39;s signature will be used in the model forward pass.</p></td></tr></tbody>',Aa,Na,Ea,ls,Ra,rs,Ba,ns,vg="Sampler is a base class for all sampling methods used for text generation.",Oa,ds,kg='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',ja,as,xg='<li><a href="#module_utils/generation.Sampler">.Sampler</a><ul><li><a href="#new_module_utils/generation.Sampler_new"><code>new Sampler(generation_config)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/generation.Sampler+_call"><code>._call(logits, index)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/generation.Sampler+sample"><code>.sample(logits, index)</code></a></li> <li><a href="#module_utils/generation.Sampler+getLogits"><code>.getLogits(logits, index)</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/generation.Sampler+randomSelect"><code>.randomSelect(probabilities)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/generation.Sampler.getSampler"><code>.getSampler(generation_config)</code></a> ⇒ <code>Sampler</code></li></ul></li></ul></li>',Ga,Ia,Fa,cs,qa,ps,Da,us,yg="Creates a new Sampler object with the specified generation config.",Wa,gs,Cg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generation_config</td><td><code>GenerationConfig</code></td><td><p>The generation config.</p></td></tr></tbody>",Ka,za,Ua,ms,Ja,fs,Qa,hs,Mg="Executes the sampler, using the specified logits.",Va,_s,Hg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a>',Xa,Ls,Sg="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Ya,Za,ec,bs,tc,Ts,oc,Ps,Ag="Abstract method for sampling the logits.",sc,$s,Ng='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Throws</strong>:',ic,ws,Eg="<li><code>Error</code></li>",lc,vs,Rg="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",rc,nc,dc,ks,ac,xs,cc,ys,Bg="Returns the specified logits as an array, with temperature applied.",pc,Cs,Og='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a>',uc,Ms,jg="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",gc,mc,fc,Hs,hc,Ss,_c,As,Gg="Selects an item randomly based on the specified probabilities.",Lc,Ns,Ig='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the selected item.',bc,Es,Fg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>probabilities</td><td><code>Array</code></td><td><p>An array of probabilities to use for selection.</p></td></tr></tbody>",Tc,Pc,$c,Rs,wc,Bs,vc,Os,qg="Returns a Sampler object based on the specified options.",kc,js,Dg='<strong>Kind</strong>: static method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Returns</strong>: <code>Sampler</code> - A Sampler object.',xc,Gs,Wg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generation_config</td><td><code>GenerationConfig</code></td><td><p>An object containing options for the sampler.</p></td></tr></tbody>",yc,Cc,Mc,Is,Hc,Fs,Sc,qs,Kg="Class representing a Greedy Sampler.",Ac,Ds,zg='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',Nc,Ec,Rc,Ws,Bc,Ks,Oc,zs,Ug="Sample the maximum probability of a given logits tensor.",jc,Us,Jg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..GreedySampler"><code>GreedySampler</code></a><br/> <strong>Returns</strong>: <code>Array</code> - An array with a single tuple, containing the index of the maximum value and a meaningless score (since this is a greedy search).',Gc,Js,Qg="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td><td></td> </tr><tr><td>[index]</td><td><code>number</code></td><td><code>-1</code></td></tr></tbody>",Ic,Fc,qc,Qs,Dc,Vs,Wc,Xs,Vg="Class representing a MultinomialSampler.",Kc,Ys,Xg='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',zc,Uc,Jc,Zs,Qc,ei,Vc,ti,Yg="Sample from the logits.",Xc,oi,Zg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..MultinomialSampler"><code>MultinomialSampler</code></a>',Yc,si,em="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Zc,ep,tp,ii,op,li,sp,ri,tm="Class representing a BeamSearchSampler.",ip,ni,om='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',lp,rp,np,di,dp,ai,ap,ci,sm="Sample from the logits.",cp,pi,im='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..BeamSearchSampler"><code>BeamSearchSampler</code></a>',pp,ui,lm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",up,gp,mp,mi,fp;return T=new _({props:{title:"utils/generation",local:"utilsgeneration",headingTag:"h1"}}),x=new _({props:{title:"utils/generation.LogitsProcessorList ⇐ <code> Callable </code>",local:"utilsgenerationlogitsprocessorlist--code-callable-code",headingTag:"h2"}}),S=new _({props:{title:"new LogitsProcessorList()",local:"new-logitsprocessorlist",headingTag:"h3"}}),E=new _({props:{title:"logitsProcessorList.push(item)",local:"logitsprocessorlistpushitem",headingTag:"h3"}}),G=new _({props:{title:"logitsProcessorList.extend(items)",local:"logitsprocessorlistextenditems",headingTag:"h3"}}),W=new _({props:{title:"logitsProcessorList._call(input_ids, batchedLogits)",local:"logitsprocessorlistcallinputids-batchedlogits",headingTag:"h3"}}),Q=new _({props:{title:"utils/generation.LogitsProcessor ⇐ <code> Callable </code>",local:"utilsgenerationlogitsprocessor--code-callable-code",headingTag:"h2"}}),Z=new _({props:{title:"logitsProcessor._call(input_ids, logits)",local:"logitsprocessorcallinputids-logits",headingTag:"h3"}}),le=new _({props:{title:"utils/generation.ForceTokensLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcetokenslogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ce=new _({props:{title:"new ForceTokensLogitsProcessor(forced_decoder_ids)",local:"new-forcetokenslogitsprocessorforceddecoderids",headingTag:"h3"}}),me=new _({props:{title:"forceTokensLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>",local:"forcetokenslogitsprocessorcallinputids-logits--code-tensor-code",headingTag:"h3"}}),be=new _({props:{title:"utils/generation.ForcedBOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcedbostokenlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ve=new _({props:{title:"new ForcedBOSTokenLogitsProcessor(bos_token_id)",local:"new-forcedbostokenlogitsprocessorbostokenid",headingTag:"h3"}}),Ce=new _({props:{title:"forcedBOSTokenLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"forcedbostokenlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Ne=new _({props:{title:"utils/generation.ForcedEOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcedeostokenlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),je=new _({props:{title:"new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)",local:"new-forcedeostokenlogitsprocessormaxlength-forcedeostokenid",headingTag:"h3"}}),qe=new _({props:{title:"forcedEOSTokenLogitsProcessor._call(input_ids, logits)",local:"forcedeostokenlogitsprocessorcallinputids-logits",headingTag:"h3"}}),Ue=new _({props:{title:"utils/generation.SuppressTokensAtBeginLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationsuppresstokensatbeginlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),Ye=new _({props:{title:"new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)",local:"new-suppresstokensatbeginlogitsprocessorbeginsuppresstokens-beginindex",headingTag:"h3"}}),ot=new _({props:{title:"suppressTokensAtBeginLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"suppresstokensatbeginlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),nt=new _({props:{title:"utils/generation.WhisperTimeStampLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationwhispertimestamplogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ut=new _({props:{title:"new WhisperTimeStampLogitsProcessor(generate_config)",local:"new-whispertimestamplogitsprocessorgenerateconfig",headingTag:"h3"}}),ht=new _({props:{title:"whisperTimeStampLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>",local:"whispertimestamplogitsprocessorcallinputids-logits--code-tensor-code",headingTag:"h3"}}),Pt=new _({props:{title:"utils/generation.NoRepeatNGramLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationnorepeatngramlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),xt=new _({props:{title:"new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)",local:"new-norepeatngramlogitsprocessornorepeatngramsize",headingTag:"h3"}}),Ht=new _({props:{title:"noRepeatNGramLogitsProcessor.getNgrams(prevInputIds) ⇒ <code> Map. < string, Array < number > > </code>",local:"norepeatngramlogitsprocessorgetngramsprevinputids--code-map--string-array--number---code",headingTag:"h3"}}),Rt=new _({props:{title:"noRepeatNGramLogitsProcessor.getGeneratedNgrams(bannedNgrams, prevInputIds) ⇒ <code> Array. < number > </code>",local:"norepeatngramlogitsprocessorgetgeneratedngramsbannedngrams-previnputids--code-array--number--code",headingTag:"h3"}}),It=new _({props:{title:"noRepeatNGramLogitsProcessor.calcBannedNgramTokens(prevInputIds) ⇒ <code> Array. < number > </code>",local:"norepeatngramlogitsprocessorcalcbannedngramtokensprevinputids--code-array--number--code",headingTag:"h3"}}),Kt=new _({props:{title:"noRepeatNGramLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"norepeatngramlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Vt=new _({props:{title:"utils/generation.RepetitionPenaltyLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationrepetitionpenaltylogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),to=new _({props:{title:"new RepetitionPenaltyLogitsProcessor(penalty)",local:"new-repetitionpenaltylogitsprocessorpenalty",headingTag:"h3"}}),lo=new _({props:{title:"repetitionPenaltyLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"repetitionpenaltylogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),po=new _({props:{title:"utils/generation.MinLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationminlengthlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ho=new _({props:{title:"new MinLengthLogitsProcessor(min_length, eos_token_id)",local:"new-minlengthlogitsprocessorminlength-eostokenid",headingTag:"h3"}}),To=new _({props:{title:"minLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"minlengthlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),ko=new _({props:{title:"utils/generation.MinNewTokensLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationminnewtokenslengthlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),Ho=new _({props:{title:"new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)",local:"new-minnewtokenslengthlogitsprocessorpromptlengthtoskip-minnewtokens-eostokenid",headingTag:"h3"}}),Eo=new _({props:{title:"minNewTokensLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"minnewtokenslengthlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Go=new _({props:{title:"utils/generation.NoBadWordsLogitsProcessor",local:"utilsgenerationnobadwordslogitsprocessor",headingTag:"h2"}}),Do=new _({props:{title:"new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)",local:"new-nobadwordslogitsprocessorbadwordsids-eostokenid",headingTag:"h3"}}),Uo=new _({props:{title:"noBadWordsLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"nobadwordslogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Yo=new _({props:{title:"utils/generation.GenerationConfig",local:"utilsgenerationgenerationconfig",headingTag:"h2"}}),os=new _({props:{title:"new GenerationConfig([kwargs])",local:"new-generationconfigkwargs",headingTag:"h3"}}),rs=new _({props:{title:"utils/generation.Sampler",local:"utilsgenerationsampler",headingTag:"h2"}}),ps=new _({props:{title:"new Sampler(generation_config)",local:"new-samplergenerationconfig",headingTag:"h3"}}),fs=new _({props:{title:"sampler._call(logits, index) ⇒ <code> void </code>",local:"samplercalllogits-index--code-void-code",headingTag:"h3"}}),Ts=new _({props:{title:"sampler.sample(logits, index)",local:"samplersamplelogits-index",headingTag:"h3"}}),xs=new _({props:{title:"sampler.getLogits(logits, index) ⇒ <code> Array </code>",local:"samplergetlogitslogits-index--code-array-code",headingTag:"h3"}}),Ss=new _({props:{title:"sampler.randomSelect(probabilities) ⇒ <code> number </code>",local:"samplerrandomselectprobabilities--code-number-code",headingTag:"h3"}}),Bs=new _({props:{title:"Sampler.getSampler(generation_config) ⇒ <code> Sampler </code>",local:"samplergetsamplergenerationconfig--code-sampler-code",headingTag:"h3"}}),Fs=new _({props:{title:"utils/generation~GreedySampler ⇐ <code> Sampler </code>",local:"utilsgenerationgreedysampler--code-sampler-code",headingTag:"h2"}}),Ks=new _({props:{title:"greedySampler.sample(logits, [index]) ⇒ <code> Array </code>",local:"greedysamplersamplelogits-index--code-array-code",headingTag:"h3"}}),Vs=new _({props:{title:"utils/generation~MultinomialSampler ⇐ <code> Sampler </code>",local:"utilsgenerationmultinomialsampler--code-sampler-code",headingTag:"h2"}}),ei=new _({props:{title:"multinomialSampler.sample(logits, index) ⇒ <code> Array </code>",local:"multinomialsamplersamplelogits-index--code-array-code",headingTag:"h3"}}),li=new _({props:{title:"utils/generation~BeamSearchSampler ⇐ <code> Sampler </code>",local:"utilsgenerationbeamsearchsampler--code-sampler-code",headingTag:"h2"}}),ai=new _({props:{title:"beamSearchSampler.sample(logits, index) ⇒ <code> Array </code>",local:"beamsearchsamplersamplelogits-index--code-array-code",headingTag:"h3"}}),{c(){L=r("meta"),fi=i(),gi=r("p"),hi=i(),b=r("a"),_i=i(),p(T.$$.fragment),Li=i(),P=r("p"),P.textContent=_p,bi=i(),$=r("p"),$.innerHTML=Lp,Ti=i(),w=r("ul"),w.innerHTML=bp,Pi=i(),v=r("ul"),v.innerHTML=Tp,$i=i(),wi=r("hr"),vi=i(),k=r("a"),ki=i(),p(x.$$.fragment),xi=i(),y=r("p"),y.textContent=Pp,yi=i(),C=r("p"),C.innerHTML=$p,Ci=i(),M=r("ul"),M.innerHTML=wp,Mi=i(),Hi=r("hr"),Si=i(),H=r("a"),Ai=i(),p(S.$$.fragment),Ni=i(),A=r("p"),A.innerHTML=vp,Ei=i(),Ri=r("hr"),Bi=i(),N=r("a"),Oi=i(),p(E.$$.fragment),ji=i(),R=r("p"),R.textContent=kp,Gi=i(),B=r("p"),B.innerHTML=xp,Ii=i(),O=r("table"),O.innerHTML=yp,Fi=i(),qi=r("hr"),Di=i(),j=r("a"),Wi=i(),p(G.$$.fragment),Ki=i(),I=r("p"),I.textContent=Cp,zi=i(),F=r("p"),F.innerHTML=Mp,Ui=i(),q=r("table"),q.innerHTML=Hp,Ji=i(),Qi=r("hr"),Vi=i(),D=r("a"),Xi=i(),p(W.$$.fragment),Yi=i(),K=r("p"),K.textContent=Sp,Zi=i(),z=r("p"),z.innerHTML=Ap,el=i(),U=r("table"),U.innerHTML=Np,tl=i(),ol=r("hr"),sl=i(),J=r("a"),il=i(),p(Q.$$.fragment),ll=i(),V=r("p"),V.textContent=Ep,rl=i(),X=r("p"),X.innerHTML=Rp,nl=i(),dl=r("hr"),al=i(),Y=r("a"),cl=i(),p(Z.$$.fragment),pl=i(),ee=r("p"),ee.textContent=Bp,ul=i(),te=r("p"),te.innerHTML=Op,gl=i(),oe=r("ul"),oe.innerHTML=jp,ml=i(),se=r("table"),se.innerHTML=Gp,fl=i(),hl=r("hr"),_l=i(),ie=r("a"),Ll=i(),p(le.$$.fragment),bl=i(),re=r("p"),re.textContent=Ip,Tl=i(),ne=r("p"),ne.innerHTML=Fp,Pl=i(),de=r("ul"),de.innerHTML=qp,$l=i(),wl=r("hr"),vl=i(),ae=r("a"),kl=i(),p(ce.$$.fragment),xl=i(),pe=r("p"),pe.innerHTML=Dp,yl=i(),ue=r("table"),ue.innerHTML=Wp,Cl=i(),Ml=r("hr"),Hl=i(),ge=r("a"),Sl=i(),p(me.$$.fragment),Al=i(),fe=r("p"),fe.textContent=Kp,Nl=i(),he=r("p"),he.innerHTML=zp,El=i(),_e=r("table"),_e.innerHTML=Up,Rl=i(),Bl=r("hr"),Ol=i(),Le=r("a"),jl=i(),p(be.$$.fragment),Gl=i(),Te=r("p"),Te.textContent=Jp,Il=i(),Pe=r("p"),Pe.innerHTML=Qp,Fl=i(),$e=r("ul"),$e.innerHTML=Vp,ql=i(),Dl=r("hr"),Wl=i(),we=r("a"),Kl=i(),p(ve.$$.fragment),zl=i(),ke=r("p"),ke.textContent=Xp,Ul=i(),xe=r("table"),xe.innerHTML=Yp,Jl=i(),Ql=r("hr"),Vl=i(),ye=r("a"),Xl=i(),p(Ce.$$.fragment),Yl=i(),Me=r("p"),Me.textContent=Zp,Zl=i(),He=r("p"),He.innerHTML=eu,er=i(),Se=r("table"),Se.innerHTML=tu,tr=i(),or=r("hr"),sr=i(),Ae=r("a"),ir=i(),p(Ne.$$.fragment),lr=i(),Ee=r("p"),Ee.textContent=ou,rr=i(),Re=r("p"),Re.innerHTML=su,nr=i(),Be=r("ul"),Be.innerHTML=iu,dr=i(),ar=r("hr"),cr=i(),Oe=r("a"),pr=i(),p(je.$$.fragment),ur=i(),Ge=r("p"),Ge.textContent=lu,gr=i(),Ie=r("table"),Ie.innerHTML=ru,mr=i(),fr=r("hr"),hr=i(),Fe=r("a"),_r=i(),p(qe.$$.fragment),Lr=i(),De=r("p"),De.textContent=nu,br=i(),We=r("p"),We.innerHTML=du,Tr=i(),Ke=r("table"),Ke.innerHTML=au,Pr=i(),$r=r("hr"),wr=i(),ze=r("a"),vr=i(),p(Ue.$$.fragment),kr=i(),Je=r("p"),Je.innerHTML=cu,xr=i(),Qe=r("p"),Qe.innerHTML=pu,yr=i(),Ve=r("ul"),Ve.innerHTML=uu,Cr=i(),Mr=r("hr"),Hr=i(),Xe=r("a"),Sr=i(),p(Ye.$$.fragment),Ar=i(),Ze=r("p"),Ze.textContent=gu,Nr=i(),et=r("table"),et.innerHTML=mu,Er=i(),Rr=r("hr"),Br=i(),tt=r("a"),Or=i(),p(ot.$$.fragment),jr=i(),st=r("p"),st.textContent=fu,Gr=i(),it=r("p"),it.innerHTML=hu,Ir=i(),lt=r("table"),lt.innerHTML=_u,Fr=i(),qr=r("hr"),Dr=i(),rt=r("a"),Wr=i(),p(nt.$$.fragment),Kr=i(),dt=r("p"),dt.textContent=Lu,zr=i(),at=r("p"),at.innerHTML=bu,Ur=i(),ct=r("ul"),ct.innerHTML=Tu,Jr=i(),Qr=r("hr"),Vr=i(),pt=r("a"),Xr=i(),p(ut.$$.fragment),Yr=i(),gt=r("p"),gt.textContent=Pu,Zr=i(),mt=r("table"),mt.innerHTML=$u,en=i(),tn=r("hr"),on=i(),ft=r("a"),sn=i(),p(ht.$$.fragment),ln=i(),_t=r("p"),_t.textContent=wu,rn=i(),Lt=r("p"),Lt.innerHTML=vu,nn=i(),bt=r("table"),bt.innerHTML=ku,dn=i(),an=r("hr"),cn=i(),Tt=r("a"),pn=i(),p(Pt.$$.fragment),un=i(),$t=r("p"),$t.textContent=xu,gn=i(),wt=r("p"),wt.innerHTML=yu,mn=i(),vt=r("ul"),vt.innerHTML=Cu,fn=i(),hn=r("hr"),_n=i(),kt=r("a"),Ln=i(),p(xt.$$.fragment),bn=i(),yt=r("p"),yt.textContent=Mu,Tn=i(),Ct=r("table"),Ct.innerHTML=Hu,Pn=i(),$n=r("hr"),wn=i(),Mt=r("a"),vn=i(),p(Ht.$$.fragment),kn=i(),St=r("p"),St.textContent=Su,xn=i(),At=r("p"),At.innerHTML=Au,yn=i(),Nt=r("table"),Nt.innerHTML=Nu,Cn=i(),Mn=r("hr"),Hn=i(),Et=r("a"),Sn=i(),p(Rt.$$.fragment),An=i(),Bt=r("p"),Bt.textContent=Eu,Nn=i(),Ot=r("p"),Ot.innerHTML=Ru,En=i(),jt=r("table"),jt.innerHTML=Bu,Rn=i(),Bn=r("hr"),On=i(),Gt=r("a"),jn=i(),p(It.$$.fragment),Gn=i(),Ft=r("p"),Ft.textContent=Ou,In=i(),qt=r("p"),qt.innerHTML=ju,Fn=i(),Dt=r("table"),Dt.innerHTML=Gu,qn=i(),Dn=r("hr"),Wn=i(),Wt=r("a"),Kn=i(),p(Kt.$$.fragment),zn=i(),zt=r("p"),zt.textContent=Iu,Un=i(),Ut=r("p"),Ut.innerHTML=Fu,Jn=i(),Jt=r("table"),Jt.innerHTML=qu,Qn=i(),Vn=r("hr"),Xn=i(),Qt=r("a"),Yn=i(),p(Vt.$$.fragment),Zn=i(),Xt=r("p"),Xt.textContent=Du,ed=i(),Yt=r("p"),Yt.innerHTML=Wu,td=i(),Zt=r("ul"),Zt.innerHTML=Ku,od=i(),sd=r("hr"),id=i(),eo=r("a"),ld=i(),p(to.$$.fragment),rd=i(),oo=r("p"),oo.textContent=zu,nd=i(),so=r("table"),so.innerHTML=Uu,dd=i(),ad=r("hr"),cd=i(),io=r("a"),pd=i(),p(lo.$$.fragment),ud=i(),ro=r("p"),ro.textContent=Ju,gd=i(),no=r("p"),no.innerHTML=Qu,md=i(),ao=r("table"),ao.innerHTML=Vu,fd=i(),hd=r("hr"),_d=i(),co=r("a"),Ld=i(),p(po.$$.fragment),bd=i(),uo=r("p"),uo.textContent=Xu,Td=i(),go=r("p"),go.innerHTML=Yu,Pd=i(),mo=r("ul"),mo.innerHTML=Zu,$d=i(),wd=r("hr"),vd=i(),fo=r("a"),kd=i(),p(ho.$$.fragment),xd=i(),_o=r("p"),_o.textContent=eg,yd=i(),Lo=r("table"),Lo.innerHTML=tg,Cd=i(),Md=r("hr"),Hd=i(),bo=r("a"),Sd=i(),p(To.$$.fragment),Ad=i(),Po=r("p"),Po.textContent=og,Nd=i(),$o=r("p"),$o.innerHTML=sg,Ed=i(),wo=r("table"),wo.innerHTML=ig,Rd=i(),Bd=r("hr"),Od=i(),vo=r("a"),jd=i(),p(ko.$$.fragment),Gd=i(),xo=r("p"),xo.textContent=lg,Id=i(),yo=r("p"),yo.innerHTML=rg,Fd=i(),Co=r("ul"),Co.innerHTML=ng,qd=i(),Dd=r("hr"),Wd=i(),Mo=r("a"),Kd=i(),p(Ho.$$.fragment),zd=i(),So=r("p"),So.textContent=dg,Ud=i(),Ao=r("table"),Ao.innerHTML=ag,Jd=i(),Qd=r("hr"),Vd=i(),No=r("a"),Xd=i(),p(Eo.$$.fragment),Yd=i(),Ro=r("p"),Ro.textContent=cg,Zd=i(),Bo=r("p"),Bo.innerHTML=pg,ea=i(),Oo=r("table"),Oo.innerHTML=ug,ta=i(),oa=r("hr"),sa=i(),jo=r("a"),ia=i(),p(Go.$$.fragment),la=i(),Io=r("p"),Io.innerHTML=gg,ra=i(),Fo=r("ul"),Fo.innerHTML=mg,na=i(),da=r("hr"),aa=i(),qo=r("a"),ca=i(),p(Do.$$.fragment),pa=i(),Wo=r("p"),Wo.innerHTML=fg,ua=i(),Ko=r("table"),Ko.innerHTML=hg,ga=i(),ma=r("hr"),fa=i(),zo=r("a"),ha=i(),p(Uo.$$.fragment),_a=i(),Jo=r("p"),Jo.textContent=_g,La=i(),Qo=r("p"),Qo.innerHTML=Lg,ba=i(),Vo=r("table"),Vo.innerHTML=bg,Ta=i(),Pa=r("hr"),$a=i(),Xo=r("a"),wa=i(),p(Yo.$$.fragment),va=i(),Zo=r("p"),Zo.textContent=Tg,ka=i(),es=r("p"),es.innerHTML=Pg,xa=i(),ya=r("hr"),Ca=i(),ts=r("a"),Ma=i(),p(os.$$.fragment),Ha=i(),ss=r("p"),ss.textContent=$g,Sa=i(),is=r("table"),is.innerHTML=wg,Aa=i(),Na=r("hr"),Ea=i(),ls=r("a"),Ra=i(),p(rs.$$.fragment),Ba=i(),ns=r("p"),ns.textContent=vg,Oa=i(),ds=r("p"),ds.innerHTML=kg,ja=i(),as=r("ul"),as.innerHTML=xg,Ga=i(),Ia=r("hr"),Fa=i(),cs=r("a"),qa=i(),p(ps.$$.fragment),Da=i(),us=r("p"),us.textContent=yg,Wa=i(),gs=r("table"),gs.innerHTML=Cg,Ka=i(),za=r("hr"),Ua=i(),ms=r("a"),Ja=i(),p(fs.$$.fragment),Qa=i(),hs=r("p"),hs.textContent=Mg,Va=i(),_s=r("p"),_s.innerHTML=Hg,Xa=i(),Ls=r("table"),Ls.innerHTML=Sg,Ya=i(),Za=r("hr"),ec=i(),bs=r("a"),tc=i(),p(Ts.$$.fragment),oc=i(),Ps=r("p"),Ps.textContent=Ag,sc=i(),$s=r("p"),$s.innerHTML=Ng,ic=i(),ws=r("ul"),ws.innerHTML=Eg,lc=i(),vs=r("table"),vs.innerHTML=Rg,rc=i(),nc=r("hr"),dc=i(),ks=r("a"),ac=i(),p(xs.$$.fragment),cc=i(),ys=r("p"),ys.textContent=Bg,pc=i(),Cs=r("p"),Cs.innerHTML=Og,uc=i(),Ms=r("table"),Ms.innerHTML=jg,gc=i(),mc=r("hr"),fc=i(),Hs=r("a"),hc=i(),p(Ss.$$.fragment),_c=i(),As=r("p"),As.textContent=Gg,Lc=i(),Ns=r("p"),Ns.innerHTML=Ig,bc=i(),Es=r("table"),Es.innerHTML=Fg,Tc=i(),Pc=r("hr"),$c=i(),Rs=r("a"),wc=i(),p(Bs.$$.fragment),vc=i(),Os=r("p"),Os.textContent=qg,kc=i(),js=r("p"),js.innerHTML=Dg,xc=i(),Gs=r("table"),Gs.innerHTML=Wg,yc=i(),Cc=r("hr"),Mc=i(),Is=r("a"),Hc=i(),p(Fs.$$.fragment),Sc=i(),qs=r("p"),qs.textContent=Kg,Ac=i(),Ds=r("p"),Ds.innerHTML=zg,Nc=i(),Ec=r("hr"),Rc=i(),Ws=r("a"),Bc=i(),p(Ks.$$.fragment),Oc=i(),zs=r("p"),zs.textContent=Ug,jc=i(),Us=r("p"),Us.innerHTML=Jg,Gc=i(),Js=r("table"),Js.innerHTML=Qg,Ic=i(),Fc=r("hr"),qc=i(),Qs=r("a"),Dc=i(),p(Vs.$$.fragment),Wc=i(),Xs=r("p"),Xs.textContent=Vg,Kc=i(),Ys=r("p"),Ys.innerHTML=Xg,zc=i(),Uc=r("hr"),Jc=i(),Zs=r("a"),Qc=i(),p(ei.$$.fragment),Vc=i(),ti=r("p"),ti.textContent=Yg,Xc=i(),oi=r("p"),oi.innerHTML=Zg,Yc=i(),si=r("table"),si.innerHTML=em,Zc=i(),ep=r("hr"),tp=i(),ii=r("a"),op=i(),p(li.$$.fragment),sp=i(),ri=r("p"),ri.textContent=tm,ip=i(),ni=r("p"),ni.innerHTML=om,lp=i(),rp=r("hr"),np=i(),di=r("a"),dp=i(),p(ai.$$.fragment),ap=i(),ci=r("p"),ci.textContent=sm,cp=i(),pi=r("p"),pi.innerHTML=im,pp=i(),ui=r("table"),ui.innerHTML=lm,up=i(),gp=r("hr"),mp=i(),mi=r("p"),this.h()},l(e){const o=pm("svelte-u9bgzb",document.head);L=n(o,"META",{name:!0,content:!0}),o.forEach(t),fi=l(e),gi=n(e,"P",{}),c(gi).forEach(t),hi=l(e),b=n(e,"A",{id:!0,class:!0}),c(b).forEach(t),_i=l(e),u(T.$$.fragment,e),Li=l(e),P=n(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-sqdsz9"&&(P.textContent=_p),bi=l(e),$=n(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-1dx7r99"&&($.innerHTML=Lp),Ti=l(e),w=n(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-145ffvq"&&(w.innerHTML=bp),Pi=l(e),v=n(e,"UL",{"data-svelte-h":!0}),d(v)!=="svelte-68r033"&&(v.innerHTML=Tp),$i=l(e),wi=n(e,"HR",{}),vi=l(e),k=n(e,"A",{id:!0,class:!0}),c(k).forEach(t),ki=l(e),u(x.$$.fragment,e),xi=l(e),y=n(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-3s9f37"&&(y.textContent=Pp),yi=l(e),C=n(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-2xq34v"&&(C.innerHTML=$p),Ci=l(e),M=n(e,"UL",{"data-svelte-h":!0}),d(M)!=="svelte-a0tc84"&&(M.innerHTML=wp),Mi=l(e),Hi=n(e,"HR",{}),Si=l(e),H=n(e,"A",{id:!0,class:!0}),c(H).forEach(t),Ai=l(e),u(S.$$.fragment,e),Ni=l(e),A=n(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-7qo2qs"&&(A.innerHTML=vp),Ei=l(e),Ri=n(e,"HR",{}),Bi=l(e),N=n(e,"A",{id:!0,class:!0}),c(N).forEach(t),Oi=l(e),u(E.$$.fragment,e),ji=l(e),R=n(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-y2lyqr"&&(R.textContent=kp),Gi=l(e),B=n(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-ye1us2"&&(B.innerHTML=xp),Ii=l(e),O=n(e,"TABLE",{"data-svelte-h":!0}),d(O)!=="svelte-wth0th"&&(O.innerHTML=yp),Fi=l(e),qi=n(e,"HR",{}),Di=l(e),j=n(e,"A",{id:!0,class:!0}),c(j).forEach(t),Wi=l(e),u(G.$$.fragment,e),Ki=l(e),I=n(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19ybhdd"&&(I.textContent=Cp),zi=l(e),F=n(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-ye1us2"&&(F.innerHTML=Mp),Ui=l(e),q=n(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-qfvccr"&&(q.innerHTML=Hp),Ji=l(e),Qi=n(e,"HR",{}),Vi=l(e),D=n(e,"A",{id:!0,class:!0}),c(D).forEach(t),Xi=l(e),u(W.$$.fragment,e),Yi=l(e),K=n(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1a5adsy"&&(K.textContent=Sp),Zi=l(e),z=n(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-ye1us2"&&(z.innerHTML=Ap),el=l(e),U=n(e,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-afve8l"&&(U.innerHTML=Np),tl=l(e),ol=n(e,"HR",{}),sl=l(e),J=n(e,"A",{id:!0,class:!0}),c(J).forEach(t),il=l(e),u(Q.$$.fragment,e),ll=l(e),V=n(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1skhj6b"&&(V.textContent=Ep),rl=l(e),X=n(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-2xq34v"&&(X.innerHTML=Rp),nl=l(e),dl=n(e,"HR",{}),al=l(e),Y=n(e,"A",{id:!0,class:!0}),c(Y).forEach(t),cl=l(e),u(Z.$$.fragment,e),pl=l(e),ee=n(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-pof7bn"&&(ee.textContent=Bp),ul=l(e),te=n(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1v7ihvu"&&(te.innerHTML=Op),gl=l(e),oe=n(e,"UL",{"data-svelte-h":!0}),d(oe)!=="svelte-1881dk3"&&(oe.innerHTML=jp),ml=l(e),se=n(e,"TABLE",{"data-svelte-h":!0}),d(se)!=="svelte-znwo1g"&&(se.innerHTML=Gp),fl=l(e),hl=n(e,"HR",{}),_l=l(e),ie=n(e,"A",{id:!0,class:!0}),c(ie).forEach(t),Ll=l(e),u(le.$$.fragment,e),bl=l(e),re=n(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1d43oth"&&(re.textContent=Ip),Tl=l(e),ne=n(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-9hwh5b"&&(ne.innerHTML=Fp),Pl=l(e),de=n(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-8mww04"&&(de.innerHTML=qp),$l=l(e),wl=n(e,"HR",{}),vl=l(e),ae=n(e,"A",{id:!0,class:!0}),c(ae).forEach(t),kl=l(e),u(ce.$$.fragment,e),xl=l(e),pe=n(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1shgsb3"&&(pe.innerHTML=Dp),yl=l(e),ue=n(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-wcljf3"&&(ue.innerHTML=Wp),Cl=l(e),Ml=n(e,"HR",{}),Hl=l(e),ge=n(e,"A",{id:!0,class:!0}),c(ge).forEach(t),Sl=l(e),u(me.$$.fragment,e),Al=l(e),fe=n(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-pof7bn"&&(fe.textContent=Kp),Nl=l(e),he=n(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1fawzos"&&(he.innerHTML=zp),El=l(e),_e=n(e,"TABLE",{"data-svelte-h":!0}),d(_e)!=="svelte-znwo1g"&&(_e.innerHTML=Up),Rl=l(e),Bl=n(e,"HR",{}),Ol=l(e),Le=n(e,"A",{id:!0,class:!0}),c(Le).forEach(t),jl=l(e),u(be.$$.fragment,e),Gl=l(e),Te=n(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-o4hur7"&&(Te.textContent=Jp),Il=l(e),Pe=n(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-9hwh5b"&&(Pe.innerHTML=Qp),Fl=l(e),$e=n(e,"UL",{"data-svelte-h":!0}),d($e)!=="svelte-1p5owii"&&($e.innerHTML=Vp),ql=l(e),Dl=n(e,"HR",{}),Wl=l(e),we=n(e,"A",{id:!0,class:!0}),c(we).forEach(t),Kl=l(e),u(ve.$$.fragment,e),zl=l(e),ke=n(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1gtxb4f"&&(ke.textContent=Xp),Ul=l(e),xe=n(e,"TABLE",{"data-svelte-h":!0}),d(xe)!=="svelte-5i4wcj"&&(xe.innerHTML=Yp),Jl=l(e),Ql=n(e,"HR",{}),Vl=l(e),ye=n(e,"A",{id:!0,class:!0}),c(ye).forEach(t),Xl=l(e),u(Ce.$$.fragment,e),Yl=l(e),Me=n(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-uhajj6"&&(Me.textContent=Zp),Zl=l(e),He=n(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1ljjg3x"&&(He.innerHTML=eu),er=l(e),Se=n(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-aks9lu"&&(Se.innerHTML=tu),tr=l(e),or=n(e,"HR",{}),sr=l(e),Ae=n(e,"A",{id:!0,class:!0}),c(Ae).forEach(t),ir=l(e),u(Ne.$$.fragment,e),lr=l(e),Ee=n(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-13qkt8b"&&(Ee.textContent=ou),rr=l(e),Re=n(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-9hwh5b"&&(Re.innerHTML=su),nr=l(e),Be=n(e,"UL",{"data-svelte-h":!0}),d(Be)!=="svelte-1kyyz39"&&(Be.innerHTML=iu),dr=l(e),ar=n(e,"HR",{}),cr=l(e),Oe=n(e,"A",{id:!0,class:!0}),c(Oe).forEach(t),pr=l(e),u(je.$$.fragment,e),ur=l(e),Ge=n(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-16ugs6s"&&(Ge.textContent=lu),gr=l(e),Ie=n(e,"TABLE",{"data-svelte-h":!0}),d(Ie)!=="svelte-ahgedn"&&(Ie.innerHTML=ru),mr=l(e),fr=n(e,"HR",{}),hr=l(e),Fe=n(e,"A",{id:!0,class:!0}),c(Fe).forEach(t),_r=l(e),u(qe.$$.fragment,e),Lr=l(e),De=n(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-2wlv12"&&(De.textContent=nu),br=l(e),We=n(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-9znmwc"&&(We.innerHTML=du),Tr=l(e),Ke=n(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-je9vmv"&&(Ke.innerHTML=au),Pr=l(e),$r=n(e,"HR",{}),wr=l(e),ze=n(e,"A",{id:!0,class:!0}),c(ze).forEach(t),vr=l(e),u(Ue.$$.fragment,e),kr=l(e),Je=n(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-5s9hr2"&&(Je.innerHTML=cu),xr=l(e),Qe=n(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-9hwh5b"&&(Qe.innerHTML=pu),yr=l(e),Ve=n(e,"UL",{"data-svelte-h":!0}),d(Ve)!=="svelte-1otb2bz"&&(Ve.innerHTML=uu),Cr=l(e),Mr=n(e,"HR",{}),Hr=l(e),Xe=n(e,"A",{id:!0,class:!0}),c(Xe).forEach(t),Sr=l(e),u(Ye.$$.fragment,e),Ar=l(e),Ze=n(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-459vk0"&&(Ze.textContent=gu),Nr=l(e),et=n(e,"TABLE",{"data-svelte-h":!0}),d(et)!=="svelte-rmc35r"&&(et.innerHTML=mu),Er=l(e),Rr=n(e,"HR",{}),Br=l(e),tt=n(e,"A",{id:!0,class:!0}),c(tt).forEach(t),Or=l(e),u(ot.$$.fragment,e),jr=l(e),st=n(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-uhajj6"&&(st.textContent=fu),Gr=l(e),it=n(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-ysooxp"&&(it.innerHTML=hu),Ir=l(e),lt=n(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-aks9lu"&&(lt.innerHTML=_u),Fr=l(e),qr=n(e,"HR",{}),Dr=l(e),rt=n(e,"A",{id:!0,class:!0}),c(rt).forEach(t),Wr=l(e),u(nt.$$.fragment,e),Kr=l(e),dt=n(e,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-7cf1c8"&&(dt.textContent=Lu),zr=l(e),at=n(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-9hwh5b"&&(at.innerHTML=bu),Ur=l(e),ct=n(e,"UL",{"data-svelte-h":!0}),d(ct)!=="svelte-1df9ntq"&&(ct.innerHTML=Tu),Jr=l(e),Qr=n(e,"HR",{}),Vr=l(e),pt=n(e,"A",{id:!0,class:!0}),c(pt).forEach(t),Xr=l(e),u(ut.$$.fragment,e),Yr=l(e),gt=n(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-h97ofl"&&(gt.textContent=Pu),Zr=l(e),mt=n(e,"TABLE",{"data-svelte-h":!0}),d(mt)!=="svelte-ouguny"&&(mt.innerHTML=$u),en=l(e),tn=n(e,"HR",{}),on=l(e),ft=n(e,"A",{id:!0,class:!0}),c(ft).forEach(t),sn=l(e),u(ht.$$.fragment,e),ln=l(e),_t=n(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-t6pj9i"&&(_t.textContent=wu),rn=l(e),Lt=n(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1ba862j"&&(Lt.innerHTML=vu),nn=l(e),bt=n(e,"TABLE",{"data-svelte-h":!0}),d(bt)!=="svelte-1i9o6ca"&&(bt.innerHTML=ku),dn=l(e),an=n(e,"HR",{}),cn=l(e),Tt=n(e,"A",{id:!0,class:!0}),c(Tt).forEach(t),pn=l(e),u(Pt.$$.fragment,e),un=l(e),$t=n(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1nbhk1j"&&($t.textContent=xu),gn=l(e),wt=n(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-9hwh5b"&&(wt.innerHTML=yu),mn=l(e),vt=n(e,"UL",{"data-svelte-h":!0}),d(vt)!=="svelte-bbnk9b"&&(vt.innerHTML=Cu),fn=l(e),hn=n(e,"HR",{}),_n=l(e),kt=n(e,"A",{id:!0,class:!0}),c(kt).forEach(t),Ln=l(e),u(xt.$$.fragment,e),bn=l(e),yt=n(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-ztp378"&&(yt.textContent=Mu),Tn=l(e),Ct=n(e,"TABLE",{"data-svelte-h":!0}),d(Ct)!=="svelte-1oeknti"&&(Ct.innerHTML=Hu),Pn=l(e),$n=n(e,"HR",{}),wn=l(e),Mt=n(e,"A",{id:!0,class:!0}),c(Mt).forEach(t),vn=l(e),u(Ht.$$.fragment,e),kn=l(e),St=n(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-kezmb4"&&(St.textContent=Su),xn=l(e),At=n(e,"P",{"data-svelte-h":!0}),d(At)!=="svelte-4618wm"&&(At.innerHTML=Au),yn=l(e),Nt=n(e,"TABLE",{"data-svelte-h":!0}),d(Nt)!=="svelte-7hcqif"&&(Nt.innerHTML=Nu),Cn=l(e),Mn=n(e,"HR",{}),Hn=l(e),Et=n(e,"A",{id:!0,class:!0}),c(Et).forEach(t),Sn=l(e),u(Rt.$$.fragment,e),An=l(e),Bt=n(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-kezmb4"&&(Bt.textContent=Eu),Nn=l(e),Ot=n(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-56j6v5"&&(Ot.innerHTML=Ru),En=l(e),jt=n(e,"TABLE",{"data-svelte-h":!0}),d(jt)!=="svelte-12kqlqq"&&(jt.innerHTML=Bu),Rn=l(e),Bn=n(e,"HR",{}),On=l(e),Gt=n(e,"A",{id:!0,class:!0}),c(Gt).forEach(t),jn=l(e),u(It.$$.fragment,e),Gn=l(e),Ft=n(e,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-i6fmo8"&&(Ft.textContent=Ou),In=l(e),qt=n(e,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-56j6v5"&&(qt.innerHTML=ju),Fn=l(e),Dt=n(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-7hcqif"&&(Dt.innerHTML=Gu),qn=l(e),Dn=n(e,"HR",{}),Wn=l(e),Wt=n(e,"A",{id:!0,class:!0}),c(Wt).forEach(t),Kn=l(e),u(Kt.$$.fragment,e),zn=l(e),zt=n(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-ns64he"&&(zt.textContent=Iu),Un=l(e),Ut=n(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-eb379u"&&(Ut.innerHTML=Fu),Jn=l(e),Jt=n(e,"TABLE",{"data-svelte-h":!0}),d(Jt)!=="svelte-aks9lu"&&(Jt.innerHTML=qu),Qn=l(e),Vn=n(e,"HR",{}),Xn=l(e),Qt=n(e,"A",{id:!0,class:!0}),c(Qt).forEach(t),Yn=l(e),u(Vt.$$.fragment,e),Zn=l(e),Xt=n(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1swjk5j"&&(Xt.textContent=Du),ed=l(e),Yt=n(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-9hwh5b"&&(Yt.innerHTML=Wu),td=l(e),Zt=n(e,"UL",{"data-svelte-h":!0}),d(Zt)!=="svelte-8ptdd5"&&(Zt.innerHTML=Ku),od=l(e),sd=n(e,"HR",{}),id=l(e),eo=n(e,"A",{id:!0,class:!0}),c(eo).forEach(t),ld=l(e),u(to.$$.fragment,e),rd=l(e),oo=n(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-1miwk7z"&&(oo.textContent=zu),nd=l(e),so=n(e,"TABLE",{"data-svelte-h":!0}),d(so)!=="svelte-qogrf9"&&(so.innerHTML=Uu),dd=l(e),ad=n(e,"HR",{}),cd=l(e),io=n(e,"A",{id:!0,class:!0}),c(io).forEach(t),pd=l(e),u(lo.$$.fragment,e),ud=l(e),ro=n(e,"P",{"data-svelte-h":!0}),d(ro)!=="svelte-ttelh1"&&(ro.textContent=Ju),gd=l(e),no=n(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-1l9hzxj"&&(no.innerHTML=Qu),md=l(e),ao=n(e,"TABLE",{"data-svelte-h":!0}),d(ao)!=="svelte-aks9lu"&&(ao.innerHTML=Vu),fd=l(e),hd=n(e,"HR",{}),_d=l(e),co=n(e,"A",{id:!0,class:!0}),c(co).forEach(t),Ld=l(e),u(po.$$.fragment,e),bd=l(e),uo=n(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-9c4wc0"&&(uo.textContent=Xu),Td=l(e),go=n(e,"P",{"data-svelte-h":!0}),d(go)!=="svelte-9hwh5b"&&(go.innerHTML=Yu),Pd=l(e),mo=n(e,"UL",{"data-svelte-h":!0}),d(mo)!=="svelte-5gysvm"&&(mo.innerHTML=Zu),$d=l(e),wd=n(e,"HR",{}),vd=l(e),fo=n(e,"A",{id:!0,class:!0}),c(fo).forEach(t),kd=l(e),u(ho.$$.fragment,e),xd=l(e),_o=n(e,"P",{"data-svelte-h":!0}),d(_o)!=="svelte-1m5mw53"&&(_o.textContent=eg),yd=l(e),Lo=n(e,"TABLE",{"data-svelte-h":!0}),d(Lo)!=="svelte-1glhq7b"&&(Lo.innerHTML=tg),Cd=l(e),Md=n(e,"HR",{}),Hd=l(e),bo=n(e,"A",{id:!0,class:!0}),c(bo).forEach(t),Sd=l(e),u(To.$$.fragment,e),Ad=l(e),Po=n(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-uo9cbt"&&(Po.textContent=og),Nd=l(e),$o=n(e,"P",{"data-svelte-h":!0}),d($o)!=="svelte-r6npgs"&&($o.innerHTML=sg),Ed=l(e),wo=n(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-aks9lu"&&(wo.innerHTML=ig),Rd=l(e),Bd=n(e,"HR",{}),Od=l(e),vo=n(e,"A",{id:!0,class:!0}),c(vo).forEach(t),jd=l(e),u(ko.$$.fragment,e),Gd=l(e),xo=n(e,"P",{"data-svelte-h":!0}),d(xo)!=="svelte-ozjzty"&&(xo.textContent=lg),Id=l(e),yo=n(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-9hwh5b"&&(yo.innerHTML=rg),Fd=l(e),Co=n(e,"UL",{"data-svelte-h":!0}),d(Co)!=="svelte-1ry7094"&&(Co.innerHTML=ng),qd=l(e),Dd=n(e,"HR",{}),Wd=l(e),Mo=n(e,"A",{id:!0,class:!0}),c(Mo).forEach(t),Kd=l(e),u(Ho.$$.fragment,e),zd=l(e),So=n(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-6z34lb"&&(So.textContent=dg),Ud=l(e),Ao=n(e,"TABLE",{"data-svelte-h":!0}),d(Ao)!=="svelte-1hv5g9s"&&(Ao.innerHTML=ag),Jd=l(e),Qd=n(e,"HR",{}),Vd=l(e),No=n(e,"A",{id:!0,class:!0}),c(No).forEach(t),Xd=l(e),u(Eo.$$.fragment,e),Yd=l(e),Ro=n(e,"P",{"data-svelte-h":!0}),d(Ro)!=="svelte-uo9cbt"&&(Ro.textContent=cg),Zd=l(e),Bo=n(e,"P",{"data-svelte-h":!0}),d(Bo)!=="svelte-1o7er1i"&&(Bo.innerHTML=pg),ea=l(e),Oo=n(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-aks9lu"&&(Oo.innerHTML=ug),ta=l(e),oa=n(e,"HR",{}),sa=l(e),jo=n(e,"A",{id:!0,class:!0}),c(jo).forEach(t),ia=l(e),u(Go.$$.fragment,e),la=l(e),Io=n(e,"P",{"data-svelte-h":!0}),d(Io)!=="svelte-8k9dr4"&&(Io.innerHTML=gg),ra=l(e),Fo=n(e,"UL",{"data-svelte-h":!0}),d(Fo)!=="svelte-3itsi1"&&(Fo.innerHTML=mg),na=l(e),da=n(e,"HR",{}),aa=l(e),qo=n(e,"A",{id:!0,class:!0}),c(qo).forEach(t),ca=l(e),u(Do.$$.fragment,e),pa=l(e),Wo=n(e,"P",{"data-svelte-h":!0}),d(Wo)!=="svelte-1un5mwn"&&(Wo.innerHTML=fg),ua=l(e),Ko=n(e,"TABLE",{"data-svelte-h":!0}),d(Ko)!=="svelte-4hl4st"&&(Ko.innerHTML=hg),ga=l(e),ma=n(e,"HR",{}),fa=l(e),zo=n(e,"A",{id:!0,class:!0}),c(zo).forEach(t),ha=l(e),u(Uo.$$.fragment,e),_a=l(e),Jo=n(e,"P",{"data-svelte-h":!0}),d(Jo)!=="svelte-uo9cbt"&&(Jo.textContent=_g),La=l(e),Qo=n(e,"P",{"data-svelte-h":!0}),d(Qo)!=="svelte-1kfi162"&&(Qo.innerHTML=Lg),ba=l(e),Vo=n(e,"TABLE",{"data-svelte-h":!0}),d(Vo)!=="svelte-aks9lu"&&(Vo.innerHTML=bg),Ta=l(e),Pa=n(e,"HR",{}),$a=l(e),Xo=n(e,"A",{id:!0,class:!0}),c(Xo).forEach(t),wa=l(e),u(Yo.$$.fragment,e),va=l(e),Zo=n(e,"P",{"data-svelte-h":!0}),d(Zo)!=="svelte-setd0x"&&(Zo.textContent=Tg),ka=l(e),es=n(e,"P",{"data-svelte-h":!0}),d(es)!=="svelte-8k9dr4"&&(es.innerHTML=Pg),xa=l(e),ya=n(e,"HR",{}),Ca=l(e),ts=n(e,"A",{id:!0,class:!0}),c(ts).forEach(t),Ma=l(e),u(os.$$.fragment,e),Ha=l(e),ss=n(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-fn6kkw"&&(ss.textContent=$g),Sa=l(e),is=n(e,"TABLE",{"data-svelte-h":!0}),d(is)!=="svelte-2bvx5l"&&(is.innerHTML=wg),Aa=l(e),Na=n(e,"HR",{}),Ea=l(e),ls=n(e,"A",{id:!0,class:!0}),c(ls).forEach(t),Ra=l(e),u(rs.$$.fragment,e),Ba=l(e),ns=n(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-p0jtpm"&&(ns.textContent=vg),Oa=l(e),ds=n(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-8k9dr4"&&(ds.innerHTML=kg),ja=l(e),as=n(e,"UL",{"data-svelte-h":!0}),d(as)!=="svelte-ait4x5"&&(as.innerHTML=xg),Ga=l(e),Ia=n(e,"HR",{}),Fa=l(e),cs=n(e,"A",{id:!0,class:!0}),c(cs).forEach(t),qa=l(e),u(ps.$$.fragment,e),Da=l(e),us=n(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-cx2gtq"&&(us.textContent=yg),Wa=l(e),gs=n(e,"TABLE",{"data-svelte-h":!0}),d(gs)!=="svelte-i95exv"&&(gs.innerHTML=Cg),Ka=l(e),za=n(e,"HR",{}),Ua=l(e),ms=n(e,"A",{id:!0,class:!0}),c(ms).forEach(t),Ja=l(e),u(fs.$$.fragment,e),Qa=l(e),hs=n(e,"P",{"data-svelte-h":!0}),d(hs)!=="svelte-18hhszu"&&(hs.textContent=Mg),Va=l(e),_s=n(e,"P",{"data-svelte-h":!0}),d(_s)!=="svelte-1hkhr2u"&&(_s.innerHTML=Hg),Xa=l(e),Ls=n(e,"TABLE",{"data-svelte-h":!0}),d(Ls)!=="svelte-1ks6oyq"&&(Ls.innerHTML=Sg),Ya=l(e),Za=n(e,"HR",{}),ec=l(e),bs=n(e,"A",{id:!0,class:!0}),c(bs).forEach(t),tc=l(e),u(Ts.$$.fragment,e),oc=l(e),Ps=n(e,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-mhsbvo"&&(Ps.textContent=Ag),sc=l(e),$s=n(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-mok1bi"&&($s.innerHTML=Ng),ic=l(e),ws=n(e,"UL",{"data-svelte-h":!0}),d(ws)!=="svelte-1ijvx2"&&(ws.innerHTML=Eg),lc=l(e),vs=n(e,"TABLE",{"data-svelte-h":!0}),d(vs)!=="svelte-1ks6oyq"&&(vs.innerHTML=Rg),rc=l(e),nc=n(e,"HR",{}),dc=l(e),ks=n(e,"A",{id:!0,class:!0}),c(ks).forEach(t),ac=l(e),u(xs.$$.fragment,e),cc=l(e),ys=n(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-1tthoub"&&(ys.textContent=Bg),pc=l(e),Cs=n(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-1hkhr2u"&&(Cs.innerHTML=Og),uc=l(e),Ms=n(e,"TABLE",{"data-svelte-h":!0}),d(Ms)!=="svelte-1ks6oyq"&&(Ms.innerHTML=jg),gc=l(e),mc=n(e,"HR",{}),fc=l(e),Hs=n(e,"A",{id:!0,class:!0}),c(Hs).forEach(t),hc=l(e),u(Ss.$$.fragment,e),_c=l(e),As=n(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-yywnzb"&&(As.textContent=Gg),Lc=l(e),Ns=n(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-1o7ozs"&&(Ns.innerHTML=Ig),bc=l(e),Es=n(e,"TABLE",{"data-svelte-h":!0}),d(Es)!=="svelte-415bxe"&&(Es.innerHTML=Fg),Tc=l(e),Pc=n(e,"HR",{}),$c=l(e),Rs=n(e,"A",{id:!0,class:!0}),c(Rs).forEach(t),wc=l(e),u(Bs.$$.fragment,e),vc=l(e),Os=n(e,"P",{"data-svelte-h":!0}),d(Os)!=="svelte-wl8u0w"&&(Os.textContent=qg),kc=l(e),js=n(e,"P",{"data-svelte-h":!0}),d(js)!=="svelte-18j5rpb"&&(js.innerHTML=Dg),xc=l(e),Gs=n(e,"TABLE",{"data-svelte-h":!0}),d(Gs)!=="svelte-1vneufm"&&(Gs.innerHTML=Wg),yc=l(e),Cc=n(e,"HR",{}),Mc=l(e),Is=n(e,"A",{id:!0,class:!0}),c(Is).forEach(t),Hc=l(e),u(Fs.$$.fragment,e),Sc=l(e),qs=n(e,"P",{"data-svelte-h":!0}),d(qs)!=="svelte-1pvj197"&&(qs.textContent=Kg),Ac=l(e),Ds=n(e,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-1cm4lld"&&(Ds.innerHTML=zg),Nc=l(e),Ec=n(e,"HR",{}),Rc=l(e),Ws=n(e,"A",{id:!0,class:!0}),c(Ws).forEach(t),Bc=l(e),u(Ks.$$.fragment,e),Oc=l(e),zs=n(e,"P",{"data-svelte-h":!0}),d(zs)!=="svelte-1acvd9s"&&(zs.textContent=Ug),jc=l(e),Us=n(e,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-dut2ci"&&(Us.innerHTML=Jg),Gc=l(e),Js=n(e,"TABLE",{"data-svelte-h":!0}),d(Js)!=="svelte-tzng1p"&&(Js.innerHTML=Qg),Ic=l(e),Fc=n(e,"HR",{}),qc=l(e),Qs=n(e,"A",{id:!0,class:!0}),c(Qs).forEach(t),Dc=l(e),u(Vs.$$.fragment,e),Wc=l(e),Xs=n(e,"P",{"data-svelte-h":!0}),d(Xs)!=="svelte-2u15u0"&&(Xs.textContent=Vg),Kc=l(e),Ys=n(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1cm4lld"&&(Ys.innerHTML=Xg),zc=l(e),Uc=n(e,"HR",{}),Jc=l(e),Zs=n(e,"A",{id:!0,class:!0}),c(Zs).forEach(t),Qc=l(e),u(ei.$$.fragment,e),Vc=l(e),ti=n(e,"P",{"data-svelte-h":!0}),d(ti)!=="svelte-1uart2f"&&(ti.textContent=Yg),Xc=l(e),oi=n(e,"P",{"data-svelte-h":!0}),d(oi)!=="svelte-6rm4k"&&(oi.innerHTML=Zg),Yc=l(e),si=n(e,"TABLE",{"data-svelte-h":!0}),d(si)!=="svelte-1ks6oyq"&&(si.innerHTML=em),Zc=l(e),ep=n(e,"HR",{}),tp=l(e),ii=n(e,"A",{id:!0,class:!0}),c(ii).forEach(t),op=l(e),u(li.$$.fragment,e),sp=l(e),ri=n(e,"P",{"data-svelte-h":!0}),d(ri)!=="svelte-tcl9v8"&&(ri.textContent=tm),ip=l(e),ni=n(e,"P",{"data-svelte-h":!0}),d(ni)!=="svelte-1cm4lld"&&(ni.innerHTML=om),lp=l(e),rp=n(e,"HR",{}),np=l(e),di=n(e,"A",{id:!0,class:!0}),c(di).forEach(t),dp=l(e),u(ai.$$.fragment,e),ap=l(e),ci=n(e,"P",{"data-svelte-h":!0}),d(ci)!=="svelte-1uart2f"&&(ci.textContent=sm),cp=l(e),pi=n(e,"P",{"data-svelte-h":!0}),d(pi)!=="svelte-18emm88"&&(pi.innerHTML=im),pp=l(e),ui=n(e,"TABLE",{"data-svelte-h":!0}),d(ui)!=="svelte-1ks6oyq"&&(ui.innerHTML=lm),up=l(e),gp=n(e,"HR",{}),mp=l(e),mi=n(e,"P",{}),c(mi).forEach(t),this.h()},h(){a(L,"name","hf:doc:metadata"),a(L,"content",mm),a(b,"id","module_utils/generation"),a(b,"class","group"),a(k,"id","module_utils/generation.LogitsProcessorList"),a(k,"class","group"),a(H,"id","new_module_utils/generation.LogitsProcessorList_new"),a(H,"class","group"),a(N,"id","module_utils/generation.LogitsProcessorList+push"),a(N,"class","group"),a(j,"id","module_utils/generation.LogitsProcessorList+extend"),a(j,"class","group"),a(D,"id","module_utils/generation.LogitsProcessorList+_call"),a(D,"class","group"),a(J,"id","module_utils/generation.LogitsProcessor"),a(J,"class","group"),a(Y,"id","module_utils/generation.LogitsProcessor+_call"),a(Y,"class","group"),a(ie,"id","module_utils/generation.ForceTokensLogitsProcessor"),a(ie,"class","group"),a(ae,"id","new_module_utils/generation.ForceTokensLogitsProcessor_new"),a(ae,"class","group"),a(ge,"id","module_utils/generation.ForceTokensLogitsProcessor+_call"),a(ge,"class","group"),a(Le,"id","module_utils/generation.ForcedBOSTokenLogitsProcessor"),a(Le,"class","group"),a(we,"id","new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"),a(we,"class","group"),a(ye,"id","module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"),a(ye,"class","group"),a(Ae,"id","module_utils/generation.ForcedEOSTokenLogitsProcessor"),a(Ae,"class","group"),a(Oe,"id","new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"),a(Oe,"class","group"),a(Fe,"id","module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"),a(Fe,"class","group"),a(ze,"id","module_utils/generation.SuppressTokensAtBeginLogitsProcessor"),a(ze,"class","group"),a(Xe,"id","new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"),a(Xe,"class","group"),a(tt,"id","module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"),a(tt,"class","group"),a(rt,"id","module_utils/generation.WhisperTimeStampLogitsProcessor"),a(rt,"class","group"),a(pt,"id","new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"),a(pt,"class","group"),a(ft,"id","module_utils/generation.WhisperTimeStampLogitsProcessor+_call"),a(ft,"class","group"),a(Tt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor"),a(Tt,"class","group"),a(kt,"id","new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"),a(kt,"class","group"),a(Mt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"),a(Mt,"class","group"),a(Et,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"),a(Et,"class","group"),a(Gt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"),a(Gt,"class","group"),a(Wt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+_call"),a(Wt,"class","group"),a(Qt,"id","module_utils/generation.RepetitionPenaltyLogitsProcessor"),a(Qt,"class","group"),a(eo,"id","new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"),a(eo,"class","group"),a(io,"id","module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"),a(io,"class","group"),a(co,"id","module_utils/generation.MinLengthLogitsProcessor"),a(co,"class","group"),a(fo,"id","new_module_utils/generation.MinLengthLogitsProcessor_new"),a(fo,"class","group"),a(bo,"id","module_utils/generation.MinLengthLogitsProcessor+_call"),a(bo,"class","group"),a(vo,"id","module_utils/generation.MinNewTokensLengthLogitsProcessor"),a(vo,"class","group"),a(Mo,"id","new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"),a(Mo,"class","group"),a(No,"id","module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"),a(No,"class","group"),a(jo,"id","module_utils/generation.NoBadWordsLogitsProcessor"),a(jo,"class","group"),a(qo,"id","new_module_utils/generation.NoBadWordsLogitsProcessor_new"),a(qo,"class","group"),a(zo,"id","module_utils/generation.NoBadWordsLogitsProcessor+_call"),a(zo,"class","group"),a(Xo,"id","module_utils/generation.GenerationConfig"),a(Xo,"class","group"),a(ts,"id","new_module_utils/generation.GenerationConfig_new"),a(ts,"class","group"),a(ls,"id","module_utils/generation.Sampler"),a(ls,"class","group"),a(cs,"id","new_module_utils/generation.Sampler_new"),a(cs,"class","group"),a(ms,"id","module_utils/generation.Sampler+_call"),a(ms,"class","group"),a(bs,"id","module_utils/generation.Sampler+sample"),a(bs,"class","group"),a(ks,"id","module_utils/generation.Sampler+getLogits"),a(ks,"class","group"),a(Hs,"id","module_utils/generation.Sampler+randomSelect"),a(Hs,"class","group"),a(Rs,"id","module_utils/generation.Sampler.getSampler"),a(Rs,"class","group"),a(Is,"id","module_utils/generation..GreedySampler"),a(Is,"class","group"),a(Ws,"id","module_utils/generation..GreedySampler+sample"),a(Ws,"class","group"),a(Qs,"id","module_utils/generation..MultinomialSampler"),a(Qs,"class","group"),a(Zs,"id","module_utils/generation..MultinomialSampler+sample"),a(Zs,"class","group"),a(ii,"id","module_utils/generation..BeamSearchSampler"),a(ii,"class","group"),a(di,"id","module_utils/generation..BeamSearchSampler+sample"),a(di,"class","group")},m(e,o){um(document.head,L),s(e,fi,o),s(e,gi,o),s(e,hi,o),s(e,b,o),s(e,_i,o),g(T,e,o),s(e,Li,o),s(e,P,o),s(e,bi,o),s(e,$,o),s(e,Ti,o),s(e,w,o),s(e,Pi,o),s(e,v,o),s(e,$i,o),s(e,wi,o),s(e,vi,o),s(e,k,o),s(e,ki,o),g(x,e,o),s(e,xi,o),s(e,y,o),s(e,yi,o),s(e,C,o),s(e,Ci,o),s(e,M,o),s(e,Mi,o),s(e,Hi,o),s(e,Si,o),s(e,H,o),s(e,Ai,o),g(S,e,o),s(e,Ni,o),s(e,A,o),s(e,Ei,o),s(e,Ri,o),s(e,Bi,o),s(e,N,o),s(e,Oi,o),g(E,e,o),s(e,ji,o),s(e,R,o),s(e,Gi,o),s(e,B,o),s(e,Ii,o),s(e,O,o),s(e,Fi,o),s(e,qi,o),s(e,Di,o),s(e,j,o),s(e,Wi,o),g(G,e,o),s(e,Ki,o),s(e,I,o),s(e,zi,o),s(e,F,o),s(e,Ui,o),s(e,q,o),s(e,Ji,o),s(e,Qi,o),s(e,Vi,o),s(e,D,o),s(e,Xi,o),g(W,e,o),s(e,Yi,o),s(e,K,o),s(e,Zi,o),s(e,z,o),s(e,el,o),s(e,U,o),s(e,tl,o),s(e,ol,o),s(e,sl,o),s(e,J,o),s(e,il,o),g(Q,e,o),s(e,ll,o),s(e,V,o),s(e,rl,o),s(e,X,o),s(e,nl,o),s(e,dl,o),s(e,al,o),s(e,Y,o),s(e,cl,o),g(Z,e,o),s(e,pl,o),s(e,ee,o),s(e,ul,o),s(e,te,o),s(e,gl,o),s(e,oe,o),s(e,ml,o),s(e,se,o),s(e,fl,o),s(e,hl,o),s(e,_l,o),s(e,ie,o),s(e,Ll,o),g(le,e,o),s(e,bl,o),s(e,re,o),s(e,Tl,o),s(e,ne,o),s(e,Pl,o),s(e,de,o),s(e,$l,o),s(e,wl,o),s(e,vl,o),s(e,ae,o),s(e,kl,o),g(ce,e,o),s(e,xl,o),s(e,pe,o),s(e,yl,o),s(e,ue,o),s(e,Cl,o),s(e,Ml,o),s(e,Hl,o),s(e,ge,o),s(e,Sl,o),g(me,e,o),s(e,Al,o),s(e,fe,o),s(e,Nl,o),s(e,he,o),s(e,El,o),s(e,_e,o),s(e,Rl,o),s(e,Bl,o),s(e,Ol,o),s(e,Le,o),s(e,jl,o),g(be,e,o),s(e,Gl,o),s(e,Te,o),s(e,Il,o),s(e,Pe,o),s(e,Fl,o),s(e,$e,o),s(e,ql,o),s(e,Dl,o),s(e,Wl,o),s(e,we,o),s(e,Kl,o),g(ve,e,o),s(e,zl,o),s(e,ke,o),s(e,Ul,o),s(e,xe,o),s(e,Jl,o),s(e,Ql,o),s(e,Vl,o),s(e,ye,o),s(e,Xl,o),g(Ce,e,o),s(e,Yl,o),s(e,Me,o),s(e,Zl,o),s(e,He,o),s(e,er,o),s(e,Se,o),s(e,tr,o),s(e,or,o),s(e,sr,o),s(e,Ae,o),s(e,ir,o),g(Ne,e,o),s(e,lr,o),s(e,Ee,o),s(e,rr,o),s(e,Re,o),s(e,nr,o),s(e,Be,o),s(e,dr,o),s(e,ar,o),s(e,cr,o),s(e,Oe,o),s(e,pr,o),g(je,e,o),s(e,ur,o),s(e,Ge,o),s(e,gr,o),s(e,Ie,o),s(e,mr,o),s(e,fr,o),s(e,hr,o),s(e,Fe,o),s(e,_r,o),g(qe,e,o),s(e,Lr,o),s(e,De,o),s(e,br,o),s(e,We,o),s(e,Tr,o),s(e,Ke,o),s(e,Pr,o),s(e,$r,o),s(e,wr,o),s(e,ze,o),s(e,vr,o),g(Ue,e,o),s(e,kr,o),s(e,Je,o),s(e,xr,o),s(e,Qe,o),s(e,yr,o),s(e,Ve,o),s(e,Cr,o),s(e,Mr,o),s(e,Hr,o),s(e,Xe,o),s(e,Sr,o),g(Ye,e,o),s(e,Ar,o),s(e,Ze,o),s(e,Nr,o),s(e,et,o),s(e,Er,o),s(e,Rr,o),s(e,Br,o),s(e,tt,o),s(e,Or,o),g(ot,e,o),s(e,jr,o),s(e,st,o),s(e,Gr,o),s(e,it,o),s(e,Ir,o),s(e,lt,o),s(e,Fr,o),s(e,qr,o),s(e,Dr,o),s(e,rt,o),s(e,Wr,o),g(nt,e,o),s(e,Kr,o),s(e,dt,o),s(e,zr,o),s(e,at,o),s(e,Ur,o),s(e,ct,o),s(e,Jr,o),s(e,Qr,o),s(e,Vr,o),s(e,pt,o),s(e,Xr,o),g(ut,e,o),s(e,Yr,o),s(e,gt,o),s(e,Zr,o),s(e,mt,o),s(e,en,o),s(e,tn,o),s(e,on,o),s(e,ft,o),s(e,sn,o),g(ht,e,o),s(e,ln,o),s(e,_t,o),s(e,rn,o),s(e,Lt,o),s(e,nn,o),s(e,bt,o),s(e,dn,o),s(e,an,o),s(e,cn,o),s(e,Tt,o),s(e,pn,o),g(Pt,e,o),s(e,un,o),s(e,$t,o),s(e,gn,o),s(e,wt,o),s(e,mn,o),s(e,vt,o),s(e,fn,o),s(e,hn,o),s(e,_n,o),s(e,kt,o),s(e,Ln,o),g(xt,e,o),s(e,bn,o),s(e,yt,o),s(e,Tn,o),s(e,Ct,o),s(e,Pn,o),s(e,$n,o),s(e,wn,o),s(e,Mt,o),s(e,vn,o),g(Ht,e,o),s(e,kn,o),s(e,St,o),s(e,xn,o),s(e,At,o),s(e,yn,o),s(e,Nt,o),s(e,Cn,o),s(e,Mn,o),s(e,Hn,o),s(e,Et,o),s(e,Sn,o),g(Rt,e,o),s(e,An,o),s(e,Bt,o),s(e,Nn,o),s(e,Ot,o),s(e,En,o),s(e,jt,o),s(e,Rn,o),s(e,Bn,o),s(e,On,o),s(e,Gt,o),s(e,jn,o),g(It,e,o),s(e,Gn,o),s(e,Ft,o),s(e,In,o),s(e,qt,o),s(e,Fn,o),s(e,Dt,o),s(e,qn,o),s(e,Dn,o),s(e,Wn,o),s(e,Wt,o),s(e,Kn,o),g(Kt,e,o),s(e,zn,o),s(e,zt,o),s(e,Un,o),s(e,Ut,o),s(e,Jn,o),s(e,Jt,o),s(e,Qn,o),s(e,Vn,o),s(e,Xn,o),s(e,Qt,o),s(e,Yn,o),g(Vt,e,o),s(e,Zn,o),s(e,Xt,o),s(e,ed,o),s(e,Yt,o),s(e,td,o),s(e,Zt,o),s(e,od,o),s(e,sd,o),s(e,id,o),s(e,eo,o),s(e,ld,o),g(to,e,o),s(e,rd,o),s(e,oo,o),s(e,nd,o),s(e,so,o),s(e,dd,o),s(e,ad,o),s(e,cd,o),s(e,io,o),s(e,pd,o),g(lo,e,o),s(e,ud,o),s(e,ro,o),s(e,gd,o),s(e,no,o),s(e,md,o),s(e,ao,o),s(e,fd,o),s(e,hd,o),s(e,_d,o),s(e,co,o),s(e,Ld,o),g(po,e,o),s(e,bd,o),s(e,uo,o),s(e,Td,o),s(e,go,o),s(e,Pd,o),s(e,mo,o),s(e,$d,o),s(e,wd,o),s(e,vd,o),s(e,fo,o),s(e,kd,o),g(ho,e,o),s(e,xd,o),s(e,_o,o),s(e,yd,o),s(e,Lo,o),s(e,Cd,o),s(e,Md,o),s(e,Hd,o),s(e,bo,o),s(e,Sd,o),g(To,e,o),s(e,Ad,o),s(e,Po,o),s(e,Nd,o),s(e,$o,o),s(e,Ed,o),s(e,wo,o),s(e,Rd,o),s(e,Bd,o),s(e,Od,o),s(e,vo,o),s(e,jd,o),g(ko,e,o),s(e,Gd,o),s(e,xo,o),s(e,Id,o),s(e,yo,o),s(e,Fd,o),s(e,Co,o),s(e,qd,o),s(e,Dd,o),s(e,Wd,o),s(e,Mo,o),s(e,Kd,o),g(Ho,e,o),s(e,zd,o),s(e,So,o),s(e,Ud,o),s(e,Ao,o),s(e,Jd,o),s(e,Qd,o),s(e,Vd,o),s(e,No,o),s(e,Xd,o),g(Eo,e,o),s(e,Yd,o),s(e,Ro,o),s(e,Zd,o),s(e,Bo,o),s(e,ea,o),s(e,Oo,o),s(e,ta,o),s(e,oa,o),s(e,sa,o),s(e,jo,o),s(e,ia,o),g(Go,e,o),s(e,la,o),s(e,Io,o),s(e,ra,o),s(e,Fo,o),s(e,na,o),s(e,da,o),s(e,aa,o),s(e,qo,o),s(e,ca,o),g(Do,e,o),s(e,pa,o),s(e,Wo,o),s(e,ua,o),s(e,Ko,o),s(e,ga,o),s(e,ma,o),s(e,fa,o),s(e,zo,o),s(e,ha,o),g(Uo,e,o),s(e,_a,o),s(e,Jo,o),s(e,La,o),s(e,Qo,o),s(e,ba,o),s(e,Vo,o),s(e,Ta,o),s(e,Pa,o),s(e,$a,o),s(e,Xo,o),s(e,wa,o),g(Yo,e,o),s(e,va,o),s(e,Zo,o),s(e,ka,o),s(e,es,o),s(e,xa,o),s(e,ya,o),s(e,Ca,o),s(e,ts,o),s(e,Ma,o),g(os,e,o),s(e,Ha,o),s(e,ss,o),s(e,Sa,o),s(e,is,o),s(e,Aa,o),s(e,Na,o),s(e,Ea,o),s(e,ls,o),s(e,Ra,o),g(rs,e,o),s(e,Ba,o),s(e,ns,o),s(e,Oa,o),s(e,ds,o),s(e,ja,o),s(e,as,o),s(e,Ga,o),s(e,Ia,o),s(e,Fa,o),s(e,cs,o),s(e,qa,o),g(ps,e,o),s(e,Da,o),s(e,us,o),s(e,Wa,o),s(e,gs,o),s(e,Ka,o),s(e,za,o),s(e,Ua,o),s(e,ms,o),s(e,Ja,o),g(fs,e,o),s(e,Qa,o),s(e,hs,o),s(e,Va,o),s(e,_s,o),s(e,Xa,o),s(e,Ls,o),s(e,Ya,o),s(e,Za,o),s(e,ec,o),s(e,bs,o),s(e,tc,o),g(Ts,e,o),s(e,oc,o),s(e,Ps,o),s(e,sc,o),s(e,$s,o),s(e,ic,o),s(e,ws,o),s(e,lc,o),s(e,vs,o),s(e,rc,o),s(e,nc,o),s(e,dc,o),s(e,ks,o),s(e,ac,o),g(xs,e,o),s(e,cc,o),s(e,ys,o),s(e,pc,o),s(e,Cs,o),s(e,uc,o),s(e,Ms,o),s(e,gc,o),s(e,mc,o),s(e,fc,o),s(e,Hs,o),s(e,hc,o),g(Ss,e,o),s(e,_c,o),s(e,As,o),s(e,Lc,o),s(e,Ns,o),s(e,bc,o),s(e,Es,o),s(e,Tc,o),s(e,Pc,o),s(e,$c,o),s(e,Rs,o),s(e,wc,o),g(Bs,e,o),s(e,vc,o),s(e,Os,o),s(e,kc,o),s(e,js,o),s(e,xc,o),s(e,Gs,o),s(e,yc,o),s(e,Cc,o),s(e,Mc,o),s(e,Is,o),s(e,Hc,o),g(Fs,e,o),s(e,Sc,o),s(e,qs,o),s(e,Ac,o),s(e,Ds,o),s(e,Nc,o),s(e,Ec,o),s(e,Rc,o),s(e,Ws,o),s(e,Bc,o),g(Ks,e,o),s(e,Oc,o),s(e,zs,o),s(e,jc,o),s(e,Us,o),s(e,Gc,o),s(e,Js,o),s(e,Ic,o),s(e,Fc,o),s(e,qc,o),s(e,Qs,o),s(e,Dc,o),g(Vs,e,o),s(e,Wc,o),s(e,Xs,o),s(e,Kc,o),s(e,Ys,o),s(e,zc,o),s(e,Uc,o),s(e,Jc,o),s(e,Zs,o),s(e,Qc,o),g(ei,e,o),s(e,Vc,o),s(e,ti,o),s(e,Xc,o),s(e,oi,o),s(e,Yc,o),s(e,si,o),s(e,Zc,o),s(e,ep,o),s(e,tp,o),s(e,ii,o),s(e,op,o),g(li,e,o),s(e,sp,o),s(e,ri,o),s(e,ip,o),s(e,ni,o),s(e,lp,o),s(e,rp,o),s(e,np,o),s(e,di,o),s(e,dp,o),g(ai,e,o),s(e,ap,o),s(e,ci,o),s(e,cp,o),s(e,pi,o),s(e,pp,o),s(e,ui,o),s(e,up,o),s(e,gp,o),s(e,mp,o),s(e,mi,o),fp=!0},p:nm,i(e){fp||(m(T.$$.fragment,e),m(x.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(Q.$$.fragment,e),m(Z.$$.fragment,e),m(le.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(be.$$.fragment,e),m(ve.$$.fragment,e),m(Ce.$$.fragment,e),m(Ne.$$.fragment,e),m(je.$$.fragment,e),m(qe.$$.fragment,e),m(Ue.$$.fragment,e),m(Ye.$$.fragment,e),m(ot.$$.fragment,e),m(nt.$$.fragment,e),m(ut.$$.fragment,e),m(ht.$$.fragment,e),m(Pt.$$.fragment,e),m(xt.$$.fragment,e),m(Ht.$$.fragment,e),m(Rt.$$.fragment,e),m(It.$$.fragment,e),m(Kt.$$.fragment,e),m(Vt.$$.fragment,e),m(to.$$.fragment,e),m(lo.$$.fragment,e),m(po.$$.fragment,e),m(ho.$$.fragment,e),m(To.$$.fragment,e),m(ko.$$.fragment,e),m(Ho.$$.fragment,e),m(Eo.$$.fragment,e),m(Go.$$.fragment,e),m(Do.$$.fragment,e),m(Uo.$$.fragment,e),m(Yo.$$.fragment,e),m(os.$$.fragment,e),m(rs.$$.fragment,e),m(ps.$$.fragment,e),m(fs.$$.fragment,e),m(Ts.$$.fragment,e),m(xs.$$.fragment,e),m(Ss.$$.fragment,e),m(Bs.$$.fragment,e),m(Fs.$$.fragment,e),m(Ks.$$.fragment,e),m(Vs.$$.fragment,e),m(ei.$$.fragment,e),m(li.$$.fragment,e),m(ai.$$.fragment,e),fp=!0)},o(e){f(T.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(G.$$.fragment,e),f(W.$$.fragment,e),f(Q.$$.fragment,e),f(Z.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Ce.$$.fragment,e),f(Ne.$$.fragment,e),f(je.$$.fragment,e),f(qe.$$.fragment,e),f(Ue.$$.fragment,e),f(Ye.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(Pt.$$.fragment,e),f(xt.$$.fragment,e),f(Ht.$$.fragment,e),f(Rt.$$.fragment,e),f(It.$$.fragment,e),f(Kt.$$.fragment,e),f(Vt.$$.fragment,e),f(to.$$.fragment,e),f(lo.$$.fragment,e),f(po.$$.fragment,e),f(ho.$$.fragment,e),f(To.$$.fragment,e),f(ko.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(Go.$$.fragment,e),f(Do.$$.fragment,e),f(Uo.$$.fragment,e),f(Yo.$$.fragment,e),f(os.$$.fragment,e),f(rs.$$.fragment,e),f(ps.$$.fragment,e),f(fs.$$.fragment,e),f(Ts.$$.fragment,e),f(xs.$$.fragment,e),f(Ss.$$.fragment,e),f(Bs.$$.fragment,e),f(Fs.$$.fragment,e),f(Ks.$$.fragment,e),f(Vs.$$.fragment,e),f(ei.$$.fragment,e),f(li.$$.fragment,e),f(ai.$$.fragment,e),fp=!1},d(e){e&&(t(fi),t(gi),t(hi),t(b),t(_i),t(Li),t(P),t(bi),t($),t(Ti),t(w),t(Pi),t(v),t($i),t(wi),t(vi),t(k),t(ki),t(xi),t(y),t(yi),t(C),t(Ci),t(M),t(Mi),t(Hi),t(Si),t(H),t(Ai),t(Ni),t(A),t(Ei),t(Ri),t(Bi),t(N),t(Oi),t(ji),t(R),t(Gi),t(B),t(Ii),t(O),t(Fi),t(qi),t(Di),t(j),t(Wi),t(Ki),t(I),t(zi),t(F),t(Ui),t(q),t(Ji),t(Qi),t(Vi),t(D),t(Xi),t(Yi),t(K),t(Zi),t(z),t(el),t(U),t(tl),t(ol),t(sl),t(J),t(il),t(ll),t(V),t(rl),t(X),t(nl),t(dl),t(al),t(Y),t(cl),t(pl),t(ee),t(ul),t(te),t(gl),t(oe),t(ml),t(se),t(fl),t(hl),t(_l),t(ie),t(Ll),t(bl),t(re),t(Tl),t(ne),t(Pl),t(de),t($l),t(wl),t(vl),t(ae),t(kl),t(xl),t(pe),t(yl),t(ue),t(Cl),t(Ml),t(Hl),t(ge),t(Sl),t(Al),t(fe),t(Nl),t(he),t(El),t(_e),t(Rl),t(Bl),t(Ol),t(Le),t(jl),t(Gl),t(Te),t(Il),t(Pe),t(Fl),t($e),t(ql),t(Dl),t(Wl),t(we),t(Kl),t(zl),t(ke),t(Ul),t(xe),t(Jl),t(Ql),t(Vl),t(ye),t(Xl),t(Yl),t(Me),t(Zl),t(He),t(er),t(Se),t(tr),t(or),t(sr),t(Ae),t(ir),t(lr),t(Ee),t(rr),t(Re),t(nr),t(Be),t(dr),t(ar),t(cr),t(Oe),t(pr),t(ur),t(Ge),t(gr),t(Ie),t(mr),t(fr),t(hr),t(Fe),t(_r),t(Lr),t(De),t(br),t(We),t(Tr),t(Ke),t(Pr),t($r),t(wr),t(ze),t(vr),t(kr),t(Je),t(xr),t(Qe),t(yr),t(Ve),t(Cr),t(Mr),t(Hr),t(Xe),t(Sr),t(Ar),t(Ze),t(Nr),t(et),t(Er),t(Rr),t(Br),t(tt),t(Or),t(jr),t(st),t(Gr),t(it),t(Ir),t(lt),t(Fr),t(qr),t(Dr),t(rt),t(Wr),t(Kr),t(dt),t(zr),t(at),t(Ur),t(ct),t(Jr),t(Qr),t(Vr),t(pt),t(Xr),t(Yr),t(gt),t(Zr),t(mt),t(en),t(tn),t(on),t(ft),t(sn),t(ln),t(_t),t(rn),t(Lt),t(nn),t(bt),t(dn),t(an),t(cn),t(Tt),t(pn),t(un),t($t),t(gn),t(wt),t(mn),t(vt),t(fn),t(hn),t(_n),t(kt),t(Ln),t(bn),t(yt),t(Tn),t(Ct),t(Pn),t($n),t(wn),t(Mt),t(vn),t(kn),t(St),t(xn),t(At),t(yn),t(Nt),t(Cn),t(Mn),t(Hn),t(Et),t(Sn),t(An),t(Bt),t(Nn),t(Ot),t(En),t(jt),t(Rn),t(Bn),t(On),t(Gt),t(jn),t(Gn),t(Ft),t(In),t(qt),t(Fn),t(Dt),t(qn),t(Dn),t(Wn),t(Wt),t(Kn),t(zn),t(zt),t(Un),t(Ut),t(Jn),t(Jt),t(Qn),t(Vn),t(Xn),t(Qt),t(Yn),t(Zn),t(Xt),t(ed),t(Yt),t(td),t(Zt),t(od),t(sd),t(id),t(eo),t(ld),t(rd),t(oo),t(nd),t(so),t(dd),t(ad),t(cd),t(io),t(pd),t(ud),t(ro),t(gd),t(no),t(md),t(ao),t(fd),t(hd),t(_d),t(co),t(Ld),t(bd),t(uo),t(Td),t(go),t(Pd),t(mo),t($d),t(wd),t(vd),t(fo),t(kd),t(xd),t(_o),t(yd),t(Lo),t(Cd),t(Md),t(Hd),t(bo),t(Sd),t(Ad),t(Po),t(Nd),t($o),t(Ed),t(wo),t(Rd),t(Bd),t(Od),t(vo),t(jd),t(Gd),t(xo),t(Id),t(yo),t(Fd),t(Co),t(qd),t(Dd),t(Wd),t(Mo),t(Kd),t(zd),t(So),t(Ud),t(Ao),t(Jd),t(Qd),t(Vd),t(No),t(Xd),t(Yd),t(Ro),t(Zd),t(Bo),t(ea),t(Oo),t(ta),t(oa),t(sa),t(jo),t(ia),t(la),t(Io),t(ra),t(Fo),t(na),t(da),t(aa),t(qo),t(ca),t(pa),t(Wo),t(ua),t(Ko),t(ga),t(ma),t(fa),t(zo),t(ha),t(_a),t(Jo),t(La),t(Qo),t(ba),t(Vo),t(Ta),t(Pa),t($a),t(Xo),t(wa),t(va),t(Zo),t(ka),t(es),t(xa),t(ya),t(Ca),t(ts),t(Ma),t(Ha),t(ss),t(Sa),t(is),t(Aa),t(Na),t(Ea),t(ls),t(Ra),t(Ba),t(ns),t(Oa),t(ds),t(ja),t(as),t(Ga),t(Ia),t(Fa),t(cs),t(qa),t(Da),t(us),t(Wa),t(gs),t(Ka),t(za),t(Ua),t(ms),t(Ja),t(Qa),t(hs),t(Va),t(_s),t(Xa),t(Ls),t(Ya),t(Za),t(ec),t(bs),t(tc),t(oc),t(Ps),t(sc),t($s),t(ic),t(ws),t(lc),t(vs),t(rc),t(nc),t(dc),t(ks),t(ac),t(cc),t(ys),t(pc),t(Cs),t(uc),t(Ms),t(gc),t(mc),t(fc),t(Hs),t(hc),t(_c),t(As),t(Lc),t(Ns),t(bc),t(Es),t(Tc),t(Pc),t($c),t(Rs),t(wc),t(vc),t(Os),t(kc),t(js),t(xc),t(Gs),t(yc),t(Cc),t(Mc),t(Is),t(Hc),t(Sc),t(qs),t(Ac),t(Ds),t(Nc),t(Ec),t(Rc),t(Ws),t(Bc),t(Oc),t(zs),t(jc),t(Us),t(Gc),t(Js),t(Ic),t(Fc),t(qc),t(Qs),t(Dc),t(Wc),t(Xs),t(Kc),t(Ys),t(zc),t(Uc),t(Jc),t(Zs),t(Qc),t(Vc),t(ti),t(Xc),t(oi),t(Yc),t(si),t(Zc),t(ep),t(tp),t(ii),t(op),t(sp),t(ri),t(ip),t(ni),t(lp),t(rp),t(np),t(di),t(dp),t(ap),t(ci),t(cp),t(pi),t(pp),t(ui),t(up),t(gp),t(mp),t(mi)),t(L),h(T,e),h(x,e),h(S,e),h(E,e),h(G,e),h(W,e),h(Q,e),h(Z,e),h(le,e),h(ce,e),h(me,e),h(be,e),h(ve,e),h(Ce,e),h(Ne,e),h(je,e),h(qe,e),h(Ue,e),h(Ye,e),h(ot,e),h(nt,e),h(ut,e),h(ht,e),h(Pt,e),h(xt,e),h(Ht,e),h(Rt,e),h(It,e),h(Kt,e),h(Vt,e),h(to,e),h(lo,e),h(po,e),h(ho,e),h(To,e),h(ko,e),h(Ho,e),h(Eo,e),h(Go,e),h(Do,e),h(Uo,e),h(Yo,e),h(os,e),h(rs,e),h(ps,e),h(fs,e),h(Ts,e),h(xs,e),h(Ss,e),h(Bs,e),h(Fs,e),h(Ks,e),h(Vs,e),h(ei,e),h(li,e),h(ai,e)}}}const mm='{"title":"utils/generation","local":"utilsgeneration","sections":[{"title":"utils/generation.LogitsProcessorList ⇐ <code> Callable </code>","local":"utilsgenerationlogitsprocessorlist--code-callable-code","sections":[{"title":"new LogitsProcessorList()","local":"new-logitsprocessorlist","sections":[],"depth":3},{"title":"logitsProcessorList.push(item)","local":"logitsprocessorlistpushitem","sections":[],"depth":3},{"title":"logitsProcessorList.extend(items)","local":"logitsprocessorlistextenditems","sections":[],"depth":3},{"title":"logitsProcessorList._call(input_ids, batchedLogits)","local":"logitsprocessorlistcallinputids-batchedlogits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.LogitsProcessor ⇐ <code> Callable </code>","local":"utilsgenerationlogitsprocessor--code-callable-code","sections":[{"title":"logitsProcessor._call(input_ids, logits)","local":"logitsprocessorcallinputids-logits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForceTokensLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcetokenslogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForceTokensLogitsProcessor(forced_decoder_ids)","local":"new-forcetokenslogitsprocessorforceddecoderids","sections":[],"depth":3},{"title":"forceTokensLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>","local":"forcetokenslogitsprocessorcallinputids-logits--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForcedBOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcedbostokenlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForcedBOSTokenLogitsProcessor(bos_token_id)","local":"new-forcedbostokenlogitsprocessorbostokenid","sections":[],"depth":3},{"title":"forcedBOSTokenLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"forcedbostokenlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForcedEOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcedeostokenlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)","local":"new-forcedeostokenlogitsprocessormaxlength-forcedeostokenid","sections":[],"depth":3},{"title":"forcedEOSTokenLogitsProcessor._call(input_ids, logits)","local":"forcedeostokenlogitsprocessorcallinputids-logits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.SuppressTokensAtBeginLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationsuppresstokensatbeginlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)","local":"new-suppresstokensatbeginlogitsprocessorbeginsuppresstokens-beginindex","sections":[],"depth":3},{"title":"suppressTokensAtBeginLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"suppresstokensatbeginlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.WhisperTimeStampLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationwhispertimestamplogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new WhisperTimeStampLogitsProcessor(generate_config)","local":"new-whispertimestamplogitsprocessorgenerateconfig","sections":[],"depth":3},{"title":"whisperTimeStampLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>","local":"whispertimestamplogitsprocessorcallinputids-logits--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.NoRepeatNGramLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationnorepeatngramlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)","local":"new-norepeatngramlogitsprocessornorepeatngramsize","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.getNgrams(prevInputIds) ⇒ <code> Map. < string, Array < number > > </code>","local":"norepeatngramlogitsprocessorgetngramsprevinputids--code-map--string-array--number---code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.getGeneratedNgrams(bannedNgrams, prevInputIds) ⇒ <code> Array. < number > </code>","local":"norepeatngramlogitsprocessorgetgeneratedngramsbannedngrams-previnputids--code-array--number--code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.calcBannedNgramTokens(prevInputIds) ⇒ <code> Array. < number > </code>","local":"norepeatngramlogitsprocessorcalcbannedngramtokensprevinputids--code-array--number--code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"norepeatngramlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.RepetitionPenaltyLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationrepetitionpenaltylogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new RepetitionPenaltyLogitsProcessor(penalty)","local":"new-repetitionpenaltylogitsprocessorpenalty","sections":[],"depth":3},{"title":"repetitionPenaltyLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"repetitionpenaltylogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.MinLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationminlengthlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new MinLengthLogitsProcessor(min_length, eos_token_id)","local":"new-minlengthlogitsprocessorminlength-eostokenid","sections":[],"depth":3},{"title":"minLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"minlengthlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.MinNewTokensLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationminnewtokenslengthlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)","local":"new-minnewtokenslengthlogitsprocessorpromptlengthtoskip-minnewtokens-eostokenid","sections":[],"depth":3},{"title":"minNewTokensLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"minnewtokenslengthlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.NoBadWordsLogitsProcessor","local":"utilsgenerationnobadwordslogitsprocessor","sections":[{"title":"new NoBadWordsLogitsProcessor(bad_words_ids, eos_token_id)","local":"new-nobadwordslogitsprocessorbadwordsids-eostokenid","sections":[],"depth":3},{"title":"noBadWordsLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"nobadwordslogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.GenerationConfig","local":"utilsgenerationgenerationconfig","sections":[{"title":"new GenerationConfig([kwargs])","local":"new-generationconfigkwargs","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.Sampler","local":"utilsgenerationsampler","sections":[{"title":"new Sampler(generation_config)","local":"new-samplergenerationconfig","sections":[],"depth":3},{"title":"sampler._call(logits, index) ⇒ <code> void </code>","local":"samplercalllogits-index--code-void-code","sections":[],"depth":3},{"title":"sampler.sample(logits, index)","local":"samplersamplelogits-index","sections":[],"depth":3},{"title":"sampler.getLogits(logits, index) ⇒ <code> Array </code>","local":"samplergetlogitslogits-index--code-array-code","sections":[],"depth":3},{"title":"sampler.randomSelect(probabilities) ⇒ <code> number </code>","local":"samplerrandomselectprobabilities--code-number-code","sections":[],"depth":3},{"title":"Sampler.getSampler(generation_config) ⇒ <code> Sampler </code>","local":"samplergetsamplergenerationconfig--code-sampler-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~GreedySampler ⇐ <code> Sampler </code>","local":"utilsgenerationgreedysampler--code-sampler-code","sections":[{"title":"greedySampler.sample(logits, [index]) ⇒ <code> Array </code>","local":"greedysamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~MultinomialSampler ⇐ <code> Sampler </code>","local":"utilsgenerationmultinomialsampler--code-sampler-code","sections":[{"title":"multinomialSampler.sample(logits, index) ⇒ <code> Array </code>","local":"multinomialsamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~BeamSearchSampler ⇐ <code> Sampler </code>","local":"utilsgenerationbeamsearchsampler--code-sampler-code","sections":[{"title":"beamSearchSampler.sample(logits, index) ⇒ <code> Array </code>","local":"beamsearchsamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function fm(hp){return dm(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bm extends am{constructor(L){super(),cm(this,L,fm,gm,rm,{})}}export{bm as component};
