import{s as el,o as tl,n as ll}from"../chunks/scheduler.182ea377.js";import{S as sl,i as al,g as i,s as a,p as r,A as nl,h as p,f as l,c as n,j as U,q as m,m as o,k as y,v as b,a as s,r as c,d,t as u,u as M}from"../chunks/index.008d68e4.js";import{T as il}from"../chunks/Tip.4f096367.js";import{I as ht}from"../chunks/IconCopyLink.96bbb92b.js";import{C as w}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as pl}from"../chunks/DocNotebookDropdown.bb388256.js";function ol(je){let J,v='Check out the <a href="https://huggingface.co/docs/transformers/main/en/generation_strategies" rel="nofollow">generation strategy</a> guide if you’re interested in learning more about strategies for generating different quality text.';return{c(){J=i("p"),J.innerHTML=v},l(f){J=p(f,"P",{"data-svelte-h":!0}),o(J)!=="svelte-vxki65"&&(J.innerHTML=v)},m(f,h){s(f,J,h)},p:ll,d(f){f&&l(J)}}}function rl(je){let J,v,f,h,Te,G,ft,we,Tt="DiffEdit",Ze,X,Ie,B,gt="Image editing typically requires providing a mask of the area to be edited. DiffEdit automatically generates the mask for you based on a text query, making it easier overall to create a mask without image editing software. The DiffEdit algorithm works in three steps:",_e,C,Ut="<li>the diffusion model denoises an image conditioned on some query text and reference text which produces different noise estimates for different areas of the image; the difference is used to infer a mask to identify which area of the image needs to be changed to match the query text</li> <li>the input image is encoded into latent space with DDIM</li> <li>the latents are decoded with the diffusion model conditioned on the text query, using the mask as a guide such that pixels outside the mask remain the same as in the input image</li>",We,V,jt="This guide will show you how to use DiffEdit to edit images without manually creating a mask.",ve,R,Zt="Before you begin, make sure you have the following libraries installed:",Ge,k,Xe,E,It='The <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> requires an image mask and a set of partially inverted latents. The image mask is generated from the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function, and includes two parameters, <code>source_prompt</code> and <code>target_prompt</code>. These parameters determine what to edit in the image. For example, if you want to change a bowl of <em>fruits</em> to a bowl of <em>pears</em>, then:',Be,Y,Ce,H,_t='The partially inverted latents are generated from the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function, and it is generally a good idea to include a <code>prompt</code> or <em>caption</em> describing the image to help guide the inverse latent sampling process. The caption can often be your <code>source_prompt</code>, but feel free to experiment with other text descriptions!',Ve,x,Wt="Let’s load the pipeline, scheduler, inverse scheduler, and enable some optimizations to reduce memory usage:",Re,N,ke,$,vt="Load the image to edit:",Ee,F,Ye,S,Gt='Use the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> function to generate the image mask. You’ll need to pass it the <code>source_prompt</code> and <code>target_prompt</code> to specify what to edit in the image:',He,Q,xe,z,Xt="Next, create the inverted latents and pass it a caption describing the image:",Ne,A,$e,D,Bt="Finally, pass the image mask and inverted latents to the pipeline. The <code>target_prompt</code> becomes the <code>prompt</code> now, and the <code>source_prompt</code> is used as the <code>negative_prompt</code>:",Fe,q,Se,j,Ct='<div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/blob/main/assets/target.png?raw=true"/> <figcaption class="mt-2 text-center text-sm text-gray-500">edited image</figcaption></div>',Qe,T,Z,ge,L,wt,be,Vt="Generate source and target embeddings",ze,P,Rt='The source and target embeddings can be automatically generated with the <a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">Flan-T5</a> model instead of creating them manually.',Ae,K,kt="Load the Flan-T5 model and tokenizer from the 🤗 Transformers library:",De,O,qe,ee,Et="Provide some initial text to prompt the model to generate the source and target prompts.",Le,te,Pe,le,Yt="Next, create a utility function to generate the prompts:",Ke,se,Oe,I,et,ae,Ht='Load the text encoder model used by the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline">StableDiffusionDiffEditPipeline</a> to encode the text. You’ll use the text encoder to compute the text embeddings:',tt,ne,lt,ie,xt='Finally, pass the embeddings to the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.generate_mask">generate_mask()</a> and <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> functions, and pipeline to generate the image:',st,pe,at,g,_,Ue,oe,bt,he,Nt="Generate a caption for inversion",nt,re,$t='While you can use the <code>source_prompt</code> as a caption to help generate the partially inverted latents, you can also use the <a href="https://huggingface.co/docs/transformers/model_doc/blip" rel="nofollow">BLIP</a> model to automatically generate a caption.',it,me,Ft="Load the BLIP model and processor from the 🤗 Transformers library:",pt,ce,ot,de,St="Create a utility function to generate a caption from the input image:",rt,ue,mt,Me,Qt="Load an input image and generate a caption for it using the <code>generate_caption</code> function:",ct,Je,dt,W,zt='<figure><img class="rounded-xl" src="https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png"/> <figcaption class="text-center">generated caption: &quot;a photograph of a bowl of fruit on a table&quot;</figcaption></figure>',ut,ye,At='Now you can drop the caption into the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/diffedit#diffusers.StableDiffusionDiffEditPipeline.invert">invert()</a> function to generate the partially inverted latents!',Mt;return G=new ht({}),X=new pl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/diffedit.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/diffedit.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/diffedit.ipynb"}]}}),k=new w({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`}}),Y=new w({props:{code:"c291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJvd2wlMjBvZiUyMHBlYXJzJTIy",highlighted:`source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a bowl of pears&quot;</span>`}}),N=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMERESU1JbnZlcnNlU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uRGlmZkVkaXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmludmVyc2Vfc2NoZWR1bGVyJTIwJTNEJTIwRERJTUludmVyc2VTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGVsaW5lLmVuYWJsZV92YWVfc2xpY2luZygp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDIMInverseScheduler, StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()`}}),F=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFyYXdfaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
raw_image`}}),Q=new w({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBc291cmNlX3Byb21wdCUyMCUzRCUyMCUyMmElMjBib3dsJTIwb2YlMjBmcnVpdHMlMjIlMEF0YXJnZXRfcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJhc2tldCUyMG9mJTIwcGVhcnMlMjIlMEFtYXNrX2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUuZ2VuZXJhdGVfbWFzayglMEElMjAlMjAlMjAlMjBpbWFnZSUzRHJhd19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHNvdXJjZV9wcm9tcHQlM0Rzb3VyY2VfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3Byb21wdCUzRHRhcmdldF9wcm9tcHQlMkMlMEEpJTBBSW1hZ2UuZnJvbWFycmF5KChtYXNrX2ltYWdlLnNxdWVlemUoKSoyNTUpLmFzdHlwZSglMjJ1aW50OCUyMiklMkMlMjAlMjJMJTIyKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

source_prompt = <span class="hljs-string">&quot;a bowl of fruits&quot;</span>
target_prompt = <span class="hljs-string">&quot;a basket of pears&quot;</span>
mask_image = pipeline.generate_mask(
    image=raw_image,
    source_prompt=source_prompt,
    target_prompt=target_prompt,
)
Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))`}}),A=new w({props:{code:"aW52X2xhdGVudHMlMjAlM0QlMjBwaXBlbGluZS5pbnZlcnQocHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUyMGltYWdlJTNEcmF3X2ltYWdlKS5sYXRlbnRz",highlighted:"inv_latents = pipeline.invert(prompt=source_prompt, image=raw_image).latents"}}),q=new w({props:{code:"b3V0cHV0X2ltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEdGFyZ2V0X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbGF0ZW50cyUzRGludl9sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEc291cmNlX3Byb21wdCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoKG1hc2tfaW1hZ2Uuc3F1ZWV6ZSgpKjI1NSkuYXN0eXBlKCUyMnVpbnQ4JTIyKSUyQyUyMCUyMkwlMjIpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCcmF3X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dF9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output_image = pipeline(
    prompt=target_prompt,
    mask_image=mask_image,
    image_latents=inv_latents,
    negative_prompt=source_prompt,
).images[<span class="hljs-number">0</span>]
mask_image = Image.fromarray((mask_image.squeeze()*<span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>), <span class="hljs-string">&quot;L&quot;</span>).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
make_image_grid([raw_image, mask_image, output_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),L=new ht({}),O=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMFQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LWxhcmdlJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, T5ForConditionalGeneration

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>)
model = T5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-large&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.float16)`}}),te=new w({props:{code:"c291cmNlX2NvbmNlcHQlMjAlM0QlMjAlMjJib3dsJTIyJTBBdGFyZ2V0X2NvbmNlcHQlMjAlM0QlMjAlMjJiYXNrZXQlMjIlMEElMEFzb3VyY2VfdGV4dCUyMCUzRCUyMGYlMjJQcm92aWRlJTIwYSUyMGNhcHRpb24lMjBmb3IlMjBpbWFnZXMlMjBjb250YWluaW5nJTIwYSUyMCU3QnNvdXJjZV9jb25jZXB0JTdELiUyMCUyMiUwQSUyMlRoZSUyMGNhcHRpb25zJTIwc2hvdWxkJTIwYmUlMjBpbiUyMEVuZ2xpc2glMjBhbmQlMjBzaG91bGQlMjBiZSUyMG5vJTIwbG9uZ2VyJTIwdGhhbiUyMDE1MCUyMGNoYXJhY3RlcnMuJTIyJTBBJTBBdGFyZ2V0X3RleHQlMjAlM0QlMjBmJTIyUHJvdmlkZSUyMGElMjBjYXB0aW9uJTIwZm9yJTIwaW1hZ2VzJTIwY29udGFpbmluZyUyMGElMjAlN0J0YXJnZXRfY29uY2VwdCU3RC4lMjAlMjIlMEElMjJUaGUlMjBjYXB0aW9ucyUyMHNob3VsZCUyMGJlJTIwaW4lMjBFbmdsaXNoJTIwYW5kJTIwc2hvdWxkJTIwYmUlMjBubyUyMGxvbmdlciUyMHRoYW4lMjAxNTAlMjBjaGFyYWN0ZXJzLiUyMg==",highlighted:`source_concept = <span class="hljs-string">&quot;bowl&quot;</span>
target_concept = <span class="hljs-string">&quot;basket&quot;</span>

source_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{source_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>

target_text = <span class="hljs-string">f&quot;Provide a caption for images containing a <span class="hljs-subst">{target_concept}</span>. &quot;</span>
<span class="hljs-string">&quot;The captions should be in English and should be no longer than 150 characters.&quot;</span>`}}),se=new w({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfcHJvbXB0cyhpbnB1dF9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3Byb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcy50byglMjJjdWRhJTIyKSUwQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuOCUyQyUyMG51bV9yZXR1cm5fc2VxdWVuY2VzJTNEMTYlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjglMkMlMjB0b3BfayUzRDEwJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXNvdXJjZV9wcm9tcHRzJTIwJTNEJTIwZ2VuZXJhdGVfcHJvbXB0cyhzb3VyY2VfdGV4dCklMEF0YXJnZXRfcHJvbXB0cyUyMCUzRCUyMGdlbmVyYXRlX3Byb21wdHModGFyZ2V0X3RleHQpJTBBcHJpbnQoc291cmNlX3Byb21wdHMpJTBBcHJpbnQodGFyZ2V0X3Byb21wdHMp",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_prompts</span>(<span class="hljs-params">input_prompt</span>):
    input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids.to(<span class="hljs-string">&quot;cuda&quot;</span>)

    outputs = model.generate(
        input_ids, temperature=<span class="hljs-number">0.8</span>, num_return_sequences=<span class="hljs-number">16</span>, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">128</span>, top_k=<span class="hljs-number">10</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)

source_prompts = generate_prompts(source_text)
target_prompts = generate_prompts(target_text)
<span class="hljs-built_in">print</span>(source_prompts)
<span class="hljs-built_in">print</span>(target_prompts)`}}),I=new il({props:{$$slots:{default:[ol]},$$scope:{ctx:je}}}),ne=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionDiffEditPipeline

pipeline = StableDiffusionDiffEditPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipeline.enable_model_cpu_offload()
pipeline.enable_vae_slicing()

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompts</span>(<span class="hljs-params">sentences, tokenizer, text_encoder, device=<span class="hljs-string">&quot;cuda&quot;</span></span>):
    embeddings = []
    <span class="hljs-keyword">for</span> sent <span class="hljs-keyword">in</span> sentences:
        text_inputs = tokenizer(
            sent,
            padding=<span class="hljs-string">&quot;max_length&quot;</span>,
            max_length=tokenizer.model_max_length,
            truncation=<span class="hljs-literal">True</span>,
            return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
        )
        text_input_ids = text_inputs.input_ids
        prompt_embeds = text_encoder(text_input_ids.to(device), attention_mask=<span class="hljs-literal">None</span>)[<span class="hljs-number">0</span>]
        embeddings.append(prompt_embeds)
    <span class="hljs-keyword">return</span> torch.concatenate(embeddings, dim=<span class="hljs-number">0</span>).mean(dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)

source_embeds = embed_prompts(source_prompts, pipeline.tokenizer, pipeline.text_encoder)
target_embeds = embed_prompts(target_prompts, pipeline.tokenizer, pipeline.text_encoder)`}}),pe=new w({props:{code:"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",highlighted:`  from diffusers import DDIMInverseScheduler, DDIMScheduler
  from diffusers.utils import load_image, make_image_grid
  from PIL import Image

  pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
  pipeline.inverse_scheduler = DDIMInverseScheduler.from_config(pipeline.scheduler.config)

  img_url = &quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;
  raw_image = load_image(img_url).resize((768, 768))

  mask_image = pipeline.generate_mask(
      image=raw_image,
<span class="hljs-deletion">-     source_prompt=source_prompt,</span>
<span class="hljs-deletion">-     target_prompt=target_prompt,</span>
<span class="hljs-addition">+     source_prompt_embeds=source_embeds,</span>
<span class="hljs-addition">+     target_prompt_embeds=target_embeds,</span>
  )

  inv_latents = pipeline.invert(
<span class="hljs-deletion">-     prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=source_embeds,</span>
      image=raw_image,
  ).latents

  output_image = pipeline(
      mask_image=mask_image,
      image_latents=inv_latents,
<span class="hljs-deletion">-     prompt=target_prompt,</span>
<span class="hljs-deletion">-     negative_prompt=source_prompt,</span>
<span class="hljs-addition">+     prompt_embeds=target_embeds,</span>
<span class="hljs-addition">+     negative_prompt_embeds=source_embeds,</span>
  ).images[0]
  mask_image = Image.fromarray((mask_image.squeeze()*255).astype(&quot;uint8&quot;), &quot;L&quot;)
  make_image_grid([raw_image, mask_image, output_image], rows=1, cols=3)`}}),oe=new ht({}),ce=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJsaXBQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBCbGlwRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWJhc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipForConditionalGeneration, BlipProcessor

processor = BlipProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>)
model = BlipForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-base&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)`}}),ue=new w({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwZ2VuZXJhdGVfY2FwdGlvbihpbWFnZXMlMkMlMjBjYXB0aW9uX2dlbmVyYXRvciUyQyUyMGNhcHRpb25fcHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMHRleHQlMjAlM0QlMjAlMjJhJTIwcGhvdG9ncmFwaCUyMG9mJTIyJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwY2FwdGlvbl9wcm9jZXNzb3IoaW1hZ2VzJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBkdHlwZSUzRGNhcHRpb25fZ2VuZXJhdG9yLmR0eXBlKSUwQSUyMCUyMCUyMCUyMGNhcHRpb25fZ2VuZXJhdG9yLnRvKCUyMmN1ZGElMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGNhcHRpb25fZ2VuZXJhdG9yLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwb2ZmbG9hZCUyMGNhcHRpb24lMjBnZW5lcmF0b3IlMEElMjAlMjAlMjAlMjBjYXB0aW9uX2dlbmVyYXRvci50byglMjJjcHUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMGNhcHRpb25fcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNhcHRpb24=",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_caption</span>(<span class="hljs-params">images, caption_generator, caption_processor</span>):
    text = <span class="hljs-string">&quot;a photograph of&quot;</span>

    inputs = caption_processor(images, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=caption_generator.dtype)
    caption_generator.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    outputs = caption_generator.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)

    <span class="hljs-comment"># offload caption generator</span>
    caption_generator.to(<span class="hljs-string">&quot;cpu&quot;</span>)

    caption = caption_processor.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> caption`}}),Je=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGWGlhbmctY2QlMkZEaWZmRWRpdC1zdGFibGUtZGlmZnVzaW9uJTJGcmF3JTJGbWFpbiUyRmFzc2V0cyUyRm9yaWdpbi5wbmclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNzY4JTJDJTIwNzY4KSklMEFjYXB0aW9uJTIwJTNEJTIwZ2VuZXJhdGVfY2FwdGlvbihyYXdfaW1hZ2UlMkMlMjBtb2RlbCUyQyUyMHByb2Nlc3Nvcik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://github.com/Xiang-cd/DiffEdit-stable-diffusion/raw/main/assets/origin.png&quot;</span>
raw_image = load_image(img_url).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))
caption = generate_caption(raw_image, model, processor)`}}),{c(){J=i("meta"),v=a(),f=i("h1"),h=i("a"),Te=i("span"),r(G.$$.fragment),ft=a(),we=i("span"),we.textContent=Tt,Ze=a(),r(X.$$.fragment),Ie=a(),B=i("p"),B.textContent=gt,_e=a(),C=i("ol"),C.innerHTML=Ut,We=a(),V=i("p"),V.textContent=jt,ve=a(),R=i("p"),R.textContent=Zt,Ge=a(),r(k.$$.fragment),Xe=a(),E=i("p"),E.innerHTML=It,Be=a(),r(Y.$$.fragment),Ce=a(),H=i("p"),H.innerHTML=_t,Ve=a(),x=i("p"),x.textContent=Wt,Re=a(),r(N.$$.fragment),ke=a(),$=i("p"),$.textContent=vt,Ee=a(),r(F.$$.fragment),Ye=a(),S=i("p"),S.innerHTML=Gt,He=a(),r(Q.$$.fragment),xe=a(),z=i("p"),z.textContent=Xt,Ne=a(),r(A.$$.fragment),$e=a(),D=i("p"),D.innerHTML=Bt,Fe=a(),r(q.$$.fragment),Se=a(),j=i("div"),j.innerHTML=Ct,Qe=a(),T=i("h2"),Z=i("a"),ge=i("span"),r(L.$$.fragment),wt=a(),be=i("span"),be.textContent=Vt,ze=a(),P=i("p"),P.innerHTML=Rt,Ae=a(),K=i("p"),K.textContent=kt,De=a(),r(O.$$.fragment),qe=a(),ee=i("p"),ee.textContent=Et,Le=a(),r(te.$$.fragment),Pe=a(),le=i("p"),le.textContent=Yt,Ke=a(),r(se.$$.fragment),Oe=a(),r(I.$$.fragment),et=a(),ae=i("p"),ae.innerHTML=Ht,tt=a(),r(ne.$$.fragment),lt=a(),ie=i("p"),ie.innerHTML=xt,st=a(),r(pe.$$.fragment),at=a(),g=i("h2"),_=i("a"),Ue=i("span"),r(oe.$$.fragment),bt=a(),he=i("span"),he.textContent=Nt,nt=a(),re=i("p"),re.innerHTML=$t,it=a(),me=i("p"),me.textContent=Ft,pt=a(),r(ce.$$.fragment),ot=a(),de=i("p"),de.textContent=St,rt=a(),r(ue.$$.fragment),mt=a(),Me=i("p"),Me.innerHTML=Qt,ct=a(),r(Je.$$.fragment),dt=a(),W=i("div"),W.innerHTML=zt,ut=a(),ye=i("p"),ye.innerHTML=At,this.h()},l(e){const t=nl("svelte-1phssyn",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),v=n(e),f=p(e,"H1",{class:!0});var fe=U(f);h=p(fe,"A",{id:!0,class:!0,href:!0});var Dt=U(h);Te=p(Dt,"SPAN",{});var qt=U(Te);m(G.$$.fragment,qt),qt.forEach(l),Dt.forEach(l),ft=n(fe),we=p(fe,"SPAN",{"data-svelte-h":!0}),o(we)!=="svelte-yxqh4c"&&(we.textContent=Tt),fe.forEach(l),Ze=n(e),m(X.$$.fragment,e),Ie=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9fgb3t"&&(B.textContent=gt),_e=n(e),C=p(e,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-13ofpju"&&(C.innerHTML=Ut),We=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-9vh5wh"&&(V.textContent=jt),ve=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-cwruts"&&(R.textContent=Zt),Ge=n(e),m(k.$$.fragment,e),Xe=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1kliy5b"&&(E.innerHTML=It),Be=n(e),m(Y.$$.fragment,e),Ce=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1dn2ved"&&(H.innerHTML=_t),Ve=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19i848b"&&(x.textContent=Wt),Re=n(e),m(N.$$.fragment,e),ke=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1umymvd"&&($.textContent=vt),Ee=n(e),m(F.$$.fragment,e),Ye=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1a2j4cb"&&(S.innerHTML=Gt),He=n(e),m(Q.$$.fragment,e),xe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-58wksg"&&(z.textContent=Xt),Ne=n(e),m(A.$$.fragment,e),$e=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-949sql"&&(D.innerHTML=Bt),Fe=n(e),m(q.$$.fragment,e),Se=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-6s9t77"&&(j.innerHTML=Ct),Qe=n(e),T=p(e,"H2",{class:!0});var Jt=U(T);Z=p(Jt,"A",{id:!0,class:!0,href:!0});var Lt=U(Z);ge=p(Lt,"SPAN",{});var Pt=U(ge);m(L.$$.fragment,Pt),Pt.forEach(l),Lt.forEach(l),wt=n(Jt),be=p(Jt,"SPAN",{"data-svelte-h":!0}),o(be)!=="svelte-atfmiv"&&(be.textContent=Vt),Jt.forEach(l),ze=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-whlnrh"&&(P.innerHTML=Rt),Ae=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1lu7pxc"&&(K.textContent=kt),De=n(e),m(O.$$.fragment,e),qe=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1t1js6"&&(ee.textContent=Et),Le=n(e),m(te.$$.fragment,e),Pe=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1p4c9jk"&&(le.textContent=Yt),Ke=n(e),m(se.$$.fragment,e),Oe=n(e),m(I.$$.fragment,e),et=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-38yj6y"&&(ae.innerHTML=Ht),tt=n(e),m(ne.$$.fragment,e),lt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-h2rj6m"&&(ie.innerHTML=xt),st=n(e),m(pe.$$.fragment,e),at=n(e),g=p(e,"H2",{class:!0});var yt=U(g);_=p(yt,"A",{id:!0,class:!0,href:!0});var Kt=U(_);Ue=p(Kt,"SPAN",{});var Ot=U(Ue);m(oe.$$.fragment,Ot),Ot.forEach(l),Kt.forEach(l),bt=n(yt),he=p(yt,"SPAN",{"data-svelte-h":!0}),o(he)!=="svelte-1lba6w9"&&(he.textContent=Nt),yt.forEach(l),nt=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1y9t3by"&&(re.innerHTML=$t),it=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-13qc2l3"&&(me.textContent=Ft),pt=n(e),m(ce.$$.fragment,e),ot=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-16pyjsw"&&(de.textContent=St),rt=n(e),m(ue.$$.fragment,e),mt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-3lbf1j"&&(Me.innerHTML=Qt),ct=n(e),m(Je.$$.fragment,e),dt=n(e),W=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(W)!=="svelte-1jq3ee2"&&(W.innerHTML=zt),ut=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-hgmv54"&&(ye.innerHTML=At),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",JSON.stringify(ml)),y(h,"id","diffedit"),y(h,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(h,"href","#diffedit"),y(f,"class","relative group"),y(j,"class","flex gap-4"),y(Z,"id","generate-source-and-target-embeddings"),y(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(Z,"href","#generate-source-and-target-embeddings"),y(T,"class","relative group"),y(_,"id","generate-a-caption-for-inversion"),y(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(_,"href","#generate-a-caption-for-inversion"),y(g,"class","relative group"),y(W,"class","flex justify-center")},m(e,t){b(document.head,J),s(e,v,t),s(e,f,t),b(f,h),b(h,Te),c(G,Te,null),b(f,ft),b(f,we),s(e,Ze,t),c(X,e,t),s(e,Ie,t),s(e,B,t),s(e,_e,t),s(e,C,t),s(e,We,t),s(e,V,t),s(e,ve,t),s(e,R,t),s(e,Ge,t),c(k,e,t),s(e,Xe,t),s(e,E,t),s(e,Be,t),c(Y,e,t),s(e,Ce,t),s(e,H,t),s(e,Ve,t),s(e,x,t),s(e,Re,t),c(N,e,t),s(e,ke,t),s(e,$,t),s(e,Ee,t),c(F,e,t),s(e,Ye,t),s(e,S,t),s(e,He,t),c(Q,e,t),s(e,xe,t),s(e,z,t),s(e,Ne,t),c(A,e,t),s(e,$e,t),s(e,D,t),s(e,Fe,t),c(q,e,t),s(e,Se,t),s(e,j,t),s(e,Qe,t),s(e,T,t),b(T,Z),b(Z,ge),c(L,ge,null),b(T,wt),b(T,be),s(e,ze,t),s(e,P,t),s(e,Ae,t),s(e,K,t),s(e,De,t),c(O,e,t),s(e,qe,t),s(e,ee,t),s(e,Le,t),c(te,e,t),s(e,Pe,t),s(e,le,t),s(e,Ke,t),c(se,e,t),s(e,Oe,t),c(I,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),c(ne,e,t),s(e,lt,t),s(e,ie,t),s(e,st,t),c(pe,e,t),s(e,at,t),s(e,g,t),b(g,_),b(_,Ue),c(oe,Ue,null),b(g,bt),b(g,he),s(e,nt,t),s(e,re,t),s(e,it,t),s(e,me,t),s(e,pt,t),c(ce,e,t),s(e,ot,t),s(e,de,t),s(e,rt,t),c(ue,e,t),s(e,mt,t),s(e,Me,t),s(e,ct,t),c(Je,e,t),s(e,dt,t),s(e,W,t),s(e,ut,t),s(e,ye,t),Mt=!0},p(e,[t]){const fe={};t&2&&(fe.$$scope={dirty:t,ctx:e}),I.$set(fe)},i(e){Mt||(d(G.$$.fragment,e),d(X.$$.fragment,e),d(k.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(I.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),Mt=!0)},o(e){u(G.$$.fragment,e),u(X.$$.fragment,e),u(k.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(L.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(I.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),Mt=!1},d(e){e&&(l(v),l(f),l(Ze),l(Ie),l(B),l(_e),l(C),l(We),l(V),l(ve),l(R),l(Ge),l(Xe),l(E),l(Be),l(Ce),l(H),l(Ve),l(x),l(Re),l(ke),l($),l(Ee),l(Ye),l(S),l(He),l(xe),l(z),l(Ne),l($e),l(D),l(Fe),l(Se),l(j),l(Qe),l(T),l(ze),l(P),l(Ae),l(K),l(De),l(qe),l(ee),l(Le),l(Pe),l(le),l(Ke),l(Oe),l(et),l(ae),l(tt),l(lt),l(ie),l(st),l(at),l(g),l(nt),l(re),l(it),l(me),l(pt),l(ot),l(de),l(rt),l(mt),l(Me),l(ct),l(dt),l(W),l(ut),l(ye)),l(J),M(G),M(X,e),M(k,e),M(Y,e),M(N,e),M(F,e),M(Q,e),M(A,e),M(q,e),M(L),M(O,e),M(te,e),M(se,e),M(I,e),M(ne,e),M(pe,e),M(oe),M(ce,e),M(ue,e),M(Je,e)}}}const ml={local:"diffedit",sections:[{local:"generate-source-and-target-embeddings",title:"Generate source and target embeddings"},{local:"generate-a-caption-for-inversion",title:"Generate a caption for inversion"}],title:"DiffEdit"};function cl(je){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends sl{constructor(J){super(),al(this,J,cl,rl,el,{})}}export{wl as component};
