import{s as Ye,o as Qe,n as Nl}from"../chunks/scheduler.bdbef820.js";import{S as He,i as We,g as i,s as a,r as T,A as Le,h as o,f as e,c as M,j as Se,u as p,x as J,k as El,y as De,a as s,v as d,d as w,t as r,w as j}from"../chunks/index.c0aea24a.js";import{T as vl}from"../chunks/Tip.31005f7d.js";import{C as u}from"../chunks/CodeBlock.6ccca92e.js";import{H as h}from"../chunks/Heading.2eb892cb.js";function Pe(c){let n,U=`The dataset loading script is likely not needed if your dataset is in one of the following formats: CSV, JSON, JSON lines, text, images, audio or Parquet.
With those formats, you should be able to load your dataset automatically with <a href="/docs/datasets/v2.19.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>,
as long as your dataset repository has a <a href="./repository_structure">required structure</a>.`;return{c(){n=i("p"),n.innerHTML=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1js2236"&&(n.innerHTML=U)},m(y,I){s(y,n,I)},p:Nl,d(y){y&&e(n)}}}function Oe(c){let n,U="In the next major release, the new safety features of 🤗 Datasets will disable running dataset loading scripts by default, and you will have to pass <code>trust_remote_code=True</code> to load datasets that require running a dataset script.";return{c(){n=i("p"),n.innerHTML=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-mdy5pl"&&(n.innerHTML=U)},m(y,I){s(y,n,I)},p:Nl,d(y){y&&e(n)}}}function Ke(c){let n,U='To help you get started, try beginning with the dataset loading script <a href="https://github.com/huggingface/datasets/blob/main/templates/new_dataset_script.py" rel="nofollow">template</a>!';return{c(){n=i("p"),n.innerHTML=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1ews9ox"&&(n.innerHTML=U)},m(y,I){s(y,n,I)},p:Nl,d(y){y&&e(n)}}}function ls(c){let n,U="Only use a default configuration when it makes sense. Don’t set one because it may be more convenient for the user to not specify a configuration when they load your dataset. For example, multi-lingual datasets often have a separate configuration for each language. An appropriate default may be an aggregated configuration that loads all the languages of the dataset if the user doesn’t request a particular one.";return{c(){n=i("p"),n.textContent=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1h3crem"&&(n.textContent=U)},m(y,I){s(y,n,I)},p:Nl,d(y){y&&e(n)}}}function ts(c){let n,U="If the data files live in the same folder or repository of the dataset script, you can just pass the relative paths to the files instead of URLs.";return{c(){n=i("p"),n.textContent=U},l(y){n=o(y,"P",{"data-svelte-h":!0}),J(n)!=="svelte-1xoorbu"&&(n.textContent=U)},m(y,I){s(y,n,I)},p:Nl,d(y){y&&e(n)}}}function es(c){let n,U,y,I,$,zl,m,xl,f,Fl,R,se=`Write a dataset script to load and share datasets that consist of data files in unsupported formats or require more complex data preparation.
This is a more advanced way to define a dataset than using <a href="./repository_structure#define-your-splits-in-yaml">YAML metadata in the dataset card</a>.
A dataset script is a Python file that defines the different configurations and splits of your dataset, as well as how to download and process the data.`,Sl,V,ae="The script can download data files from any website, or from the same dataset repository.",Yl,k,Me="A dataset loading script should have the same name as a dataset repository or directory. For example, a repository named <code>my_dataset</code> should contain <code>my_dataset.py</code> script. This way it can be loaded with:",Ql,X,Hl,_,Wl,E,ne="The following guide includes instructions for dataset scripts for how to:",Ll,q,ie="<li>Add dataset metadata.</li> <li>Download data files.</li> <li>Generate samples.</li> <li>Generate dataset metadata.</li> <li>Upload a dataset to the Hub.</li>",Dl,v,oe='Open the <a href="https://huggingface.co/datasets/squad/blob/main/squad.py" rel="nofollow">SQuAD dataset loading script</a> template to follow along on how to share a dataset.',Pl,C,Ol,N,Kl,z,Je="The first step is to add some information, or attributes, about your dataset in <code>DatasetBuilder._info()</code>. The most important attributes you should specify are:",lt,x,ye='<li><p><code>DatasetInfo.description</code> provides a concise description of your dataset. The description informs the user what’s in the dataset, how it was collected, and how it can be used for a NLP task.</p></li> <li><p><code>DatasetInfo.features</code> defines the name and type of each column in your dataset. This will also provide the structure for each example, so it is possible to create nested subfields in a column if you want. Take a look at <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Features">Features</a> for a full list of feature types you can use.</p></li>',tt,F,et,A,Te="<li><p><code>DatasetInfo.homepage</code> contains the URL to the dataset homepage so users can find more details about the dataset.</p></li> <li><p><code>DatasetInfo.citation</code> contains a BibTeX citation for the dataset.</p></li>",st,S,pe="After you’ve filled out all these fields in the template, it should look like the following example from the SQuAD loading script:",at,Y,Mt,Q,nt,H,de='In some cases, your dataset may have multiple configurations. For example, the <a href="https://huggingface.co/datasets/super_glue" rel="nofollow">SuperGLUE</a> dataset is a collection of 5 datasets designed to evaluate language understanding tasks. 🤗 Datasets provides <a href="/docs/datasets/v2.19.0/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> which allows you to create different configurations for the user to select from.',it,W,we='Let’s study the <a href="https://huggingface.co/datasets/super_glue/blob/main/super_glue.py" rel="nofollow">SuperGLUE loading script</a> to see how you can define several configurations.',ot,L,re='<li>Create a <a href="/docs/datasets/v2.19.0/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass with attributes about your dataset. These attributes can be the features of your dataset, label classes, and a URL to the data files.</li>',Jt,D,yt,g,je="<li>Create instances of your config to specify the values of the attributes of each configuration. This gives you the flexibility to specify all the name and description of each configuration. These sub-class instances should be listed under <code>DatasetBuilder.BUILDER_CONFIGS</code>:</li>",Tt,P,pt,b,Ue="<li>Now, users can load a specific configuration of the dataset with the configuration <code>name</code>:</li>",dt,O,wt,K,ue='Additionally, users can instantiate a custom builder configuration by passing the builder configuration arguments to <a href="/docs/datasets/v2.19.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',rt,ll,jt,tl,Ut,el,Ie="Users must specify a configuration name when they load a dataset with multiple configurations. Otherwise, 🤗 Datasets will raise a <code>ValueError</code>, and prompt the user to select a configuration name. You can avoid this by setting a default dataset configuration with the <code>DEFAULT_CONFIG_NAME</code> attribute:",ut,sl,It,G,ct,al,ht,Ml,ce="After you’ve defined the attributes of your dataset, the next step is to download the data files and organize them according to their splits.",mt,nl,he="<li>Create a dictionary of URLs in the loading script that point to the original SQuAD data files:</li>",ft,il,Ct,Z,At,B,me='<li><p><a href="/docs/datasets/v2.19.0/en/package_reference/builder_classes#datasets.DownloadManager.download_and_extract">DownloadManager.download_and_extract()</a> takes this dictionary and downloads the data files. Once the files are downloaded, use <a href="/docs/datasets/v2.19.0/en/package_reference/builder_classes#datasets.SplitGenerator">SplitGenerator</a> to organize each split in the dataset. This is a simple class that contains:</p> <ul><li><p>The <code>name</code> of each split. You should use the standard split names: <code>Split.TRAIN</code>, <code>Split.TEST</code>, and <code>Split.VALIDATION</code>.</p></li> <li><p><code>gen_kwargs</code> provides the file paths to the data files to load for each split.</p></li></ul></li>',gt,ol,fe="Your <code>DatasetBuilder._split_generator()</code> should look like this now:",bt,Jl,Gt,yl,Zt,Tl,Ce="At this point, you have:",Bt,pl,Ae="<li>Added the dataset attributes.</li> <li>Provided instructions for how to download the data files.</li> <li>Organized the splits.</li>",$t,dl,ge="The next step is to actually generate the samples in each split.",Rt,wl,be="<li><p><code>DatasetBuilder._generate_examples</code> takes the file path provided by <code>gen_kwargs</code> to read and parse the data files. You need to write a function that loads the data files and extracts the columns.</p></li> <li><p>Your function should yield a tuple of an <code>id_</code>, and an example from the dataset.</p></li>",Vt,rl,kt,jl,Xt,Ul,Ge="Adding dataset metadata is a great way to include information about your dataset. The metadata is stored in the dataset card <code>README.md</code> in YAML. It includes information like the number of examples required to confirm the dataset was correctly generated, and information about the dataset like its <code>features</code>.",_t,ul,Ze="Run the following command to generate your dataset metadata in <code>README.md</code> and make sure your new dataset loading script works correctly:",Et,Il,qt,cl,Be="If your dataset loading script passed the test, you should now have a <code>README.md</code> file in your dataset folder containing a <code>dataset_info</code> field with some metadata.",vt,hl,Nt,ml,$e='Once your script is ready, <a href="dataset_card">create a dataset card</a> and <a href="share">upload it to the Hub</a>.',zt,fl,Re="Congratulations, you can now load your dataset from the Hub! 🥳",xt,Cl,Ft,Al,St,gl,Yt,bl,Ve=`If your dataset is made of many big files, 🤗 Datasets automatically runs your script in parallel to make it super fast!
It can help if you have hundreds or thousands of TAR archives, or JSONL files like <a href="https://huggingface.co/datasets/oscar/blob/main/oscar.py" rel="nofollow">oscar</a> for example.`,Qt,Gl,ke=`To make it work, we consider lists of files in <code>gen_kwargs</code> to be shards.
Therefore 🤗 Datasets can automatically spawn several workers to run <code>_generate_examples</code> in parallel, and each worker is given a subset of shards to process.`,Ht,Zl,Wt,Bl,Xe="Users can also specify <code>num_proc=</code> in <code>load_dataset()</code> to specify the number of processes to use as workers.",Lt,$l,Dt,Rl,_e=`For some datasets it can be much faster to yield batches of data rather than examples one by one.
You can speed up the dataset generation by yielding Arrow tables directly, instead of examples.
This is especially useful if your data comes from Pandas DataFrames for example, since the conversion from Pandas to Arrow is as simple as:`,Pt,Vl,Ot,kl,Ee='To yield Arrow tables instead of single examples, make your dataset builder inherit from <a href="/docs/datasets/v2.19.0/en/package_reference/builder_classes#datasets.ArrowBasedBuilder">ArrowBasedBuilder</a> instead of <a href="/docs/datasets/v2.19.0/en/package_reference/builder_classes#datasets.GeneratorBasedBuilder">GeneratorBasedBuilder</a>, and use <code>_generate_tables</code> instead of <code>_generate_examples</code>:',Kt,Xl,le,_l,qe="Don’t forget to keep your script memory efficient, in case users run them on machines with a low amount of RAM.",te,ql,ee;return $=new h({props:{title:"Create a dataset loading script",local:"create-a-dataset-loading-script",headingTag:"h1"}}),m=new vl({props:{$$slots:{default:[Pe]},$$scope:{ctx:c}}}),f=new vl({props:{warning:"true",$$slots:{default:[Oe]},$$scope:{ctx:c}}}),X=new u({props:{code:"bXlfZGF0YXNldCUyRiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG15X2RhdGFzZXQucHk=",highlighted:`my<span class="hljs-emphasis">_dataset/
├── README.md
└── my_</span>dataset.py`,wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBbG9hZF9kYXRhc2V0KCUyMnBhdGglMkZ0byUyRm15X2RhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dataset(<span class="hljs-string">&quot;path/to/my_dataset&quot;</span>)`,wrap:!1}}),C=new vl({props:{$$slots:{default:[Ke]},$$scope:{ctx:c}}}),N=new h({props:{title:"Add dataset attributes",local:"add-dataset-attributes",headingTag:"h2"}}),F=new u({props:{code:"ZGF0YXNldHMuRmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwZGF0YXNldHMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJfc3RhcnQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJpbnQzMiUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`datasets.Features(
    {
        <span class="hljs-string">&quot;id&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;title&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;context&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;question&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;answers&quot;</span>: datasets.<span class="hljs-type">Sequence</span>(
            {
                <span class="hljs-string">&quot;text&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;answer_start&quot;</span>: datasets.Value(<span class="hljs-string">&quot;int32&quot;</span>),
            }
        ),
    }
)`,wrap:!1}}),Y=new u({props:{code:"ZGVmJTIwX2luZm8oc2VsZiklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhc2V0cy5EYXRhc2V0SW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRF9ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEZGF0YXNldHMuRmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwZGF0YXNldHMuZmVhdHVyZXMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMjAlMjJhbnN3ZXJfc3RhcnQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJpbnQzMiUyMiklMkMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vJTIwZGVmYXVsdCUyMHN1cGVydmlzZWRfa2V5cyUyMChhcyUyMHdlJTIwaGF2ZSUyMHRvJTIwcGFzcyUyMGJvdGglMjBxdWVzdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGFuZCUyMGNvbnRleHQlMjBhcyUyMGlucHV0KS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcnZpc2VkX2tleXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaG9tZXBhZ2UlM0QlMjJodHRwcyUzQSUyRiUyRnJhanB1cmthci5naXRodWIuaW8lMkZTUXVBRC1leHBsb3JlciUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNpdGF0aW9uJTNEX0NJVEFUSU9OJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_info</span>(<span class="hljs-params">self</span>):
    <span class="hljs-keyword">return</span> datasets.DatasetInfo(
        description=_DESCRIPTION,
        features=datasets.Features(
            {
                <span class="hljs-string">&quot;id&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;title&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;context&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;question&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;answers&quot;</span>: datasets.features.<span class="hljs-type">Sequence</span>(
                    {<span class="hljs-string">&quot;text&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>), <span class="hljs-string">&quot;answer_start&quot;</span>: datasets.Value(<span class="hljs-string">&quot;int32&quot;</span>),}
                ),
            }
        ),
        <span class="hljs-comment"># No default supervised_keys (as we have to pass both question</span>
        <span class="hljs-comment"># and context as input).</span>
        supervised_keys=<span class="hljs-literal">None</span>,
        homepage=<span class="hljs-string">&quot;https://rajpurkar.github.io/SQuAD-explorer/&quot;</span>,
        citation=_CITATION,
    )`,wrap:!1}}),Q=new h({props:{title:"Multiple configurations",local:"multiple-configurations",headingTag:"h3"}}),D=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperGlueConfig</span>(datasets.BuilderConfig):
    <span class="hljs-string">&quot;&quot;&quot;BuilderConfig for SuperGLUE.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, features, data_url, citation, url, label_classes=(<span class="hljs-params"><span class="hljs-string">&quot;False&quot;</span>, <span class="hljs-string">&quot;True&quot;</span></span>), **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;BuilderConfig for SuperGLUE.

        Args:
        features: *list[string]*, list of the features that will appear in the
            feature dict. Should not include &quot;label&quot;.
        data_url: *string*, url to download the zip file from.
        citation: *string*, citation for the data set.
        url: *string*, url for information about the data set.
        label_classes: *list[string]*, the list of classes for the label if the
            label is present as a string. Non-string labels will be cast to either
            &#x27;False&#x27; or &#x27;True&#x27;.
        **kwargs: keyword arguments forwarded to super.
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># Version history:</span>
        <span class="hljs-comment"># 1.0.2: Fixed non-nondeterminism in ReCoRD.</span>
        <span class="hljs-comment"># 1.0.1: Change from the pre-release trial version of SuperGLUE (v1.9) to</span>
        <span class="hljs-comment">#        the full release (v2.0).</span>
        <span class="hljs-comment"># 1.0.0: S3 (new shuffling, sharding and slicing mechanism).</span>
        <span class="hljs-comment"># 0.0.2: Initial version.</span>
        <span class="hljs-built_in">super</span>().__init__(version=datasets.Version(<span class="hljs-string">&quot;1.0.2&quot;</span>), **kwargs)
        self.features = features
        self.label_classes = label_classes
        self.data_url = data_url
        self.citation = citation
        self.url = url`,wrap:!1}}),P=new u({props:{code:"Y2xhc3MlMjBTdXBlckdsdWUoZGF0YXNldHMuR2VuZXJhdG9yQmFzZWRCdWlsZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoZSUyMFN1cGVyR0xVRSUyMGJlbmNobWFyay4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBCVUlMREVSX0NPTkZJR19DTEFTUyUyMCUzRCUyMFN1cGVyR2x1ZUNvbmZpZyUwQSUwQSUyMCUyMCUyMCUyMEJVSUxERVJfQ09ORklHUyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFN1cGVyR2x1ZUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyYm9vbHElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRF9CT09MUV9ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEJTVCJTIycXVlc3Rpb24lMjIlMkMlMjAlMjJwYXNzYWdlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmRsLmZiYWlwdWJsaWNmaWxlcy5jb20lMkZnbHVlJTJGc3VwZXJnbHVlJTJGZGF0YSUyRnYyJTJGQm9vbFEuemlwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2l0YXRpb24lM0RfQk9PTFFfQ0lUQVRJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZnb29nbGUtcmVzZWFyY2gtZGF0YXNldHMlMkZib29sZWFuLXF1ZXN0aW9ucyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTdXBlckdsdWVDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmF4ZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEX0FYR19ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEJTVCJTIycHJlbWlzZSUyMiUyQyUyMCUyMmh5cG90aGVzaXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbF9jbGFzc2VzJTNEJTVCJTIyZW50YWlsbWVudCUyMiUyQyUyMCUyMm5vdF9lbnRhaWxtZW50JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmRsLmZiYWlwdWJsaWNmaWxlcy5jb20lMkZnbHVlJTJGc3VwZXJnbHVlJTJGZGF0YSUyRnYyJTJGQVgtZy56aXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaXRhdGlvbiUzRF9BWEdfQ0lUQVRJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZydWRpbmdlciUyRndpbm9nZW5kZXItc2NoZW1hcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperGlue</span>(datasets.GeneratorBasedBuilder):
    <span class="hljs-string">&quot;&quot;&quot;The SuperGLUE benchmark.&quot;&quot;&quot;</span>

    BUILDER_CONFIG_CLASS = SuperGlueConfig

    BUILDER_CONFIGS = [
        SuperGlueConfig(
            name=<span class="hljs-string">&quot;boolq&quot;</span>,
            description=_BOOLQ_DESCRIPTION,
            features=[<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;passage&quot;</span>],
            data_url=<span class="hljs-string">&quot;https://dl.fbaipublicfiles.com/glue/superglue/data/v2/BoolQ.zip&quot;</span>,
            citation=_BOOLQ_CITATION,
            url=<span class="hljs-string">&quot;https://github.com/google-research-datasets/boolean-questions&quot;</span>,
        ),
        ...
        ...
        SuperGlueConfig(
            name=<span class="hljs-string">&quot;axg&quot;</span>,
            description=_AXG_DESCRIPTION,
            features=[<span class="hljs-string">&quot;premise&quot;</span>, <span class="hljs-string">&quot;hypothesis&quot;</span>],
            label_classes=[<span class="hljs-string">&quot;entailment&quot;</span>, <span class="hljs-string">&quot;not_entailment&quot;</span>],
            data_url=<span class="hljs-string">&quot;https://dl.fbaipublicfiles.com/glue/superglue/data/v2/AX-g.zip&quot;</span>,
            citation=_AXG_CITATION,
            url=<span class="hljs-string">&quot;https://github.com/rudinger/winogender-schemas&quot;</span>,
        ),`,wrap:!1}}),O=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnc3VwZXJfZ2x1ZSclMkMlMjAnYm9vbHEnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;super_glue&#x27;</span>, <span class="hljs-string">&#x27;boolq&#x27;</span>)`,wrap:!1}}),ll=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnc3VwZXJfZ2x1ZSclMkMlMjBkYXRhX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGY3VzdG9tX3VybCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;super_glue&#x27;</span>, data_url=<span class="hljs-string">&quot;https://custom_url&quot;</span>)`,wrap:!1}}),tl=new h({props:{title:"Default configurations",local:"default-configurations",headingTag:"h3"}}),sl=new u({props:{code:"Y2xhc3MlMjBOZXdEYXRhc2V0KGRhdGFzZXRzLkdlbmVyYXRvckJhc2VkQnVpbGRlciklM0ElMEElMEFWRVJTSU9OJTIwJTNEJTIwZGF0YXNldHMuVmVyc2lvbiglMjIxLjEuMCUyMiklMEElMEFCVUlMREVSX0NPTkZJR1MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBkYXRhc2V0cy5CdWlsZGVyQ29uZmlnKG5hbWUlM0QlMjJmaXJzdF9kb21haW4lMjIlMkMlMjB2ZXJzaW9uJTNEVkVSU0lPTiUyQyUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMHBhcnQlMjBvZiUyMG15JTIwZGF0YXNldCUyMGNvdmVycyUyMGElMjBmaXJzdCUyMGRvbWFpbiUyMiklMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0cy5CdWlsZGVyQ29uZmlnKG5hbWUlM0QlMjJzZWNvbmRfZG9tYWluJTIyJTJDJTIwdmVyc2lvbiUzRFZFUlNJT04lMkMlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBwYXJ0JTIwb2YlMjBteSUyMGRhdGFzZXQlMjBjb3ZlcnMlMjBhJTIwc2Vjb25kJTIwZG9tYWluJTIyKSUyQyUwQSU1RCUwQSUwQURFRkFVTFRfQ09ORklHX05BTUUlMjAlM0QlMjAlMjJmaXJzdF9kb21haW4lMjI=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewDataset</span>(datasets.GeneratorBasedBuilder):

VERSION = datasets.Version(<span class="hljs-string">&quot;1.1.0&quot;</span>)

BUILDER_CONFIGS = [
    datasets.BuilderConfig(name=<span class="hljs-string">&quot;first_domain&quot;</span>, version=VERSION, description=<span class="hljs-string">&quot;This part of my dataset covers a first domain&quot;</span>),
    datasets.BuilderConfig(name=<span class="hljs-string">&quot;second_domain&quot;</span>, version=VERSION, description=<span class="hljs-string">&quot;This part of my dataset covers a second domain&quot;</span>),
]

DEFAULT_CONFIG_NAME = <span class="hljs-string">&quot;first_domain&quot;</span>`,wrap:!1}}),G=new vl({props:{warning:!0,$$slots:{default:[ls]},$$scope:{ctx:c}}}),al=new h({props:{title:"Download data files and organize splits",local:"download-data-files-and-organize-splits",headingTag:"h2"}}),il=new u({props:{code:"X1VSTCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmFqcHVya2FyLmdpdGh1Yi5pbyUyRlNRdUFELWV4cGxvcmVyJTJGZGF0YXNldCUyRiUyMiUwQV9VUkxTJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjBfVVJMJTIwJTJCJTIwJTIydHJhaW4tdjEuMS5qc29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGV2JTIyJTNBJTIwX1VSTCUyMCUyQiUyMCUyMmRldi12MS4xLmpzb24lMjIlMkMlMEElN0Q=",highlighted:`_URL = <span class="hljs-string">&quot;https://rajpurkar.github.io/SQuAD-explorer/dataset/&quot;</span>
_URLS = {
    <span class="hljs-string">&quot;train&quot;</span>: _URL + <span class="hljs-string">&quot;train-v1.1.json&quot;</span>,
    <span class="hljs-string">&quot;dev&quot;</span>: _URL + <span class="hljs-string">&quot;dev-v1.1.json&quot;</span>,
}`,wrap:!1}}),Z=new vl({props:{$$slots:{default:[ts]},$$scope:{ctx:c}}}),Jl=new u({props:{code:"ZGVmJTIwX3NwbGl0X2dlbmVyYXRvcnMoc2VsZiUyQyUyMGRsX21hbmFnZXIlM0ElMjBkYXRhc2V0cy5Eb3dubG9hZE1hbmFnZXIpJTIwLSUzRSUyMExpc3QlNUJkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciU1RCUzQSUwQSUyMCUyMCUyMCUyMHVybHNfdG9fZG93bmxvYWQlMjAlM0QlMjBzZWxmLl9VUkxTJTBBJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWRfYW5kX2V4dHJhY3QodXJsc190b19kb3dubG9hZCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0cy5TcGxpdEdlbmVyYXRvcihuYW1lJTNEZGF0YXNldHMuU3BsaXQuVFJBSU4lMkMlMjBnZW5fa3dhcmdzJTNEJTdCJTIyZmlsZXBhdGglMjIlM0ElMjBkb3dubG9hZGVkX2ZpbGVzJTVCJTIydHJhaW4lMjIlNUQlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IobmFtZSUzRGRhdGFzZXRzLlNwbGl0LlZBTElEQVRJT04lMkMlMjBnZW5fa3dhcmdzJTNEJTdCJTIyZmlsZXBhdGglMjIlM0ElMjBkb3dubG9hZGVkX2ZpbGVzJTVCJTIyZGV2JTIyJTVEJTdEKSUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_split_generators</span>(<span class="hljs-params">self, dl_manager: datasets.DownloadManager</span>) -&gt; <span class="hljs-type">List</span>[datasets.SplitGenerator]:
    urls_to_download = self._URLS
    downloaded_files = dl_manager.download_and_extract(urls_to_download)

    <span class="hljs-keyword">return</span> [
        datasets.SplitGenerator(name=datasets.Split.TRAIN, gen_kwargs={<span class="hljs-string">&quot;filepath&quot;</span>: downloaded_files[<span class="hljs-string">&quot;train&quot;</span>]}),
        datasets.SplitGenerator(name=datasets.Split.VALIDATION, gen_kwargs={<span class="hljs-string">&quot;filepath&quot;</span>: downloaded_files[<span class="hljs-string">&quot;dev&quot;</span>]}),
    ]`,wrap:!1}}),yl=new h({props:{title:"Generate samples",local:"generate-samples",headingTag:"h2"}}),rl=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_examples</span>(<span class="hljs-params">self, filepath</span>):
    <span class="hljs-string">&quot;&quot;&quot;This function returns the examples in the raw (text) form.&quot;&quot;&quot;</span>
    logger.info(<span class="hljs-string">&quot;generating examples from = %s&quot;</span>, filepath)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(filepath) <span class="hljs-keyword">as</span> f:
        squad = json.load(f)
        <span class="hljs-keyword">for</span> article <span class="hljs-keyword">in</span> squad[<span class="hljs-string">&quot;data&quot;</span>]:
            title = article.get(<span class="hljs-string">&quot;title&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
            <span class="hljs-keyword">for</span> paragraph <span class="hljs-keyword">in</span> article[<span class="hljs-string">&quot;paragraphs&quot;</span>]:
                context = paragraph[<span class="hljs-string">&quot;context&quot;</span>].strip()
                <span class="hljs-keyword">for</span> qa <span class="hljs-keyword">in</span> paragraph[<span class="hljs-string">&quot;qas&quot;</span>]:
                    question = qa[<span class="hljs-string">&quot;question&quot;</span>].strip()
                    id_ = qa[<span class="hljs-string">&quot;id&quot;</span>]

                    answer_starts = [answer[<span class="hljs-string">&quot;answer_start&quot;</span>] <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> qa[<span class="hljs-string">&quot;answers&quot;</span>]]
                    answers = [answer[<span class="hljs-string">&quot;text&quot;</span>].strip() <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> qa[<span class="hljs-string">&quot;answers&quot;</span>]]

                    <span class="hljs-comment"># Features currently used are &quot;context&quot;, &quot;question&quot;, and &quot;answers&quot;.</span>
                    <span class="hljs-comment"># Others are extracted here for the ease of future expansions.</span>
                    <span class="hljs-keyword">yield</span> id_, {
                        <span class="hljs-string">&quot;title&quot;</span>: title,
                        <span class="hljs-string">&quot;context&quot;</span>: context,
                        <span class="hljs-string">&quot;question&quot;</span>: question,
                        <span class="hljs-string">&quot;id&quot;</span>: id_,
                        <span class="hljs-string">&quot;answers&quot;</span>: {<span class="hljs-string">&quot;answer_start&quot;</span>: answer_starts, <span class="hljs-string">&quot;text&quot;</span>: answers,},
                    }`,wrap:!1}}),jl=new h({props:{title:"(Optional) Generate dataset metadata",local:"optional-generate-dataset-metadata",headingTag:"h2"}}),Il=new u({props:{code:"ZGF0YXNldHMtY2xpJTIwdGVzdCUyMHBhdGglMkZ0byUyRiUzQ3lvdXItZGF0YXNldC1sb2FkaW5nLXNjcmlwdCUzRSUyMC0tc2F2ZV9pbmZvJTIwLS1hbGxfY29uZmlncw==",highlighted:'datasets-cli test path/<span class="hljs-keyword">to</span>/&lt;your-dataset-loading-<span class="hljs-keyword">script</span>&gt; <span class="hljs-comment">--save_info --all_configs</span>',wrap:!1}}),hl=new h({props:{title:"Upload to the Hub",local:"upload-to-the-hub",headingTag:"h2"}}),Cl=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBbG9hZF9kYXRhc2V0KCUyMiUzQ3VzZXJuYW1lJTNFJTJGbXlfZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dataset(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>)`,wrap:!1}}),Al=new h({props:{title:"Advanced features",local:"advanced-features",headingTag:"h2"}}),gl=new h({props:{title:"Sharding",local:"sharding",headingTag:"h3"}}),Zl=new u({props:{code:"JTBBY2xhc3MlMjBNeVNoYXJkZWREYXRhc2V0KGRhdGFzZXRzLkdlbmVyYXRvckJhc2VkQnVpbGRlciklM0ElMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc3BsaXRfZ2VuZXJhdG9ycyhzZWxmJTJDJTIwZGxfbWFuYWdlciUzQSUyMGRhdGFzZXRzLkRvd25sb2FkTWFuYWdlciklMjAtJTNFJTIwTGlzdCU1QmRhdGFzZXRzLlNwbGl0R2VuZXJhdG9yJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJTVCZiUyMmRhdGElMkZzaGFyZF8lN0JpJTdELmpzb25sJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAyNCklNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IobmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTIwZ2VuX2t3YXJncyUzRCU3QiUyMmZpbGVwYXRocyUyMiUzQSUyMGRvd25sb2FkZWRfZmlsZXMlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2dlbmVyYXRlX2V4YW1wbGVzKHNlbGYlMkMlMjBmaWxlcGF0aHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRWFjaCUyMHdvcmtlciUyMGNhbiUyMGJlJTIwZ2l2ZW4lMjBhJTIwc2xpY2UlMjBvZiUyMHRoZSUyMG9yaWdpbmFsJTIwJTYwZmlsZXBhdGhzJTYwJTIwbGlzdCUyMGRlZmluZWQlMjBpbiUyMHRoZSUyMCU2MGdlbl9rd2FyZ3MlNjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzbyUyMHRoYXQlMjB0aGlzJTIwY29kZSUyMGNhbiUyMHJ1biUyMGluJTIwcGFyYWxsZWwlMjBvbiUyMHNldmVyYWwlMjBzaGFyZHMlMjBhdCUyMHRoZSUyMHNhbWUlMjB0aW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwZmlsZXBhdGglMjBpbiUyMGZpbGVwYXRocyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyShardedDataset</span>(datasets.GeneratorBasedBuilder):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_split_generators</span>(<span class="hljs-params">self, dl_manager: datasets.DownloadManager</span>) -&gt; <span class="hljs-type">List</span>[datasets.SplitGenerator]:
        downloaded_files = dl_manager.download([<span class="hljs-string">f&quot;data/shard_<span class="hljs-subst">{i}</span>.jsonl&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)])
        <span class="hljs-keyword">return</span> [
            datasets.SplitGenerator(name=datasets.Split.TRAIN, gen_kwargs={<span class="hljs-string">&quot;filepaths&quot;</span>: downloaded_files}),
        ]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_examples</span>(<span class="hljs-params">self, filepaths</span>):
        <span class="hljs-comment"># Each worker can be given a slice of the original \`filepaths\` list defined in the \`gen_kwargs\`</span>
        <span class="hljs-comment"># so that this code can run in parallel on several shards at the same time</span>
        <span class="hljs-keyword">for</span> filepath <span class="hljs-keyword">in</span> filepaths:
            ...`,wrap:!1}}),$l=new h({props:{title:"ArrowBasedBuilder",local:"arrowbasedbuilder",headingTag:"h3"}}),Vl=new u({props:{code:"aW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcGElMEFwYV90YWJsZSUyMCUzRCUyMHBhLlRhYmxlLmZyb21fcGFuZGFzKGRmKQ==",highlighted:`<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
pa_table = pa.Table.from_pandas(df)`,wrap:!1}}),Xl=new u({props:{code:"Y2xhc3MlMjBNeVN1cGVyRmFzdERhdGFzZXQoZGF0YXNldHMuQXJyb3dCYXNlZEJ1aWxkZXIpJTNBJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2dlbmVyYXRlX3RhYmxlcyhzZWxmJTJDJTIwZmlsZXBhdGhzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkeCUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBmaWxlcGF0aCUyMGluJTIwZmlsZXBhdGhzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBpZHglMkMlMjBwYV90YWJsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkeCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MySuperFastDataset</span>(datasets.ArrowBasedBuilder):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_tables</span>(<span class="hljs-params">self, filepaths</span>):
        idx = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> filepath <span class="hljs-keyword">in</span> filepaths:
            ...
            <span class="hljs-keyword">yield</span> idx, pa_table
            idx += <span class="hljs-number">1</span>`,wrap:!1}}),{c(){n=i("meta"),U=a(),y=i("p"),I=a(),T($.$$.fragment),zl=a(),T(m.$$.fragment),xl=a(),T(f.$$.fragment),Fl=a(),R=i("p"),R.innerHTML=se,Sl=a(),V=i("p"),V.textContent=ae,Yl=a(),k=i("p"),k.innerHTML=Me,Ql=a(),T(X.$$.fragment),Hl=a(),T(_.$$.fragment),Wl=a(),E=i("p"),E.textContent=ne,Ll=a(),q=i("ul"),q.innerHTML=ie,Dl=a(),v=i("p"),v.innerHTML=oe,Pl=a(),T(C.$$.fragment),Ol=a(),T(N.$$.fragment),Kl=a(),z=i("p"),z.innerHTML=Je,lt=a(),x=i("ol"),x.innerHTML=ye,tt=a(),T(F.$$.fragment),et=a(),A=i("ol"),A.innerHTML=Te,st=a(),S=i("p"),S.textContent=pe,at=a(),T(Y.$$.fragment),Mt=a(),T(Q.$$.fragment),nt=a(),H=i("p"),H.innerHTML=de,it=a(),W=i("p"),W.innerHTML=we,ot=a(),L=i("ol"),L.innerHTML=re,Jt=a(),T(D.$$.fragment),yt=a(),g=i("ol"),g.innerHTML=je,Tt=a(),T(P.$$.fragment),pt=a(),b=i("ol"),b.innerHTML=Ue,dt=a(),T(O.$$.fragment),wt=a(),K=i("p"),K.innerHTML=ue,rt=a(),T(ll.$$.fragment),jt=a(),T(tl.$$.fragment),Ut=a(),el=i("p"),el.innerHTML=Ie,ut=a(),T(sl.$$.fragment),It=a(),T(G.$$.fragment),ct=a(),T(al.$$.fragment),ht=a(),Ml=i("p"),Ml.textContent=ce,mt=a(),nl=i("ol"),nl.innerHTML=he,ft=a(),T(il.$$.fragment),Ct=a(),T(Z.$$.fragment),At=a(),B=i("ol"),B.innerHTML=me,gt=a(),ol=i("p"),ol.innerHTML=fe,bt=a(),T(Jl.$$.fragment),Gt=a(),T(yl.$$.fragment),Zt=a(),Tl=i("p"),Tl.textContent=Ce,Bt=a(),pl=i("ul"),pl.innerHTML=Ae,$t=a(),dl=i("p"),dl.textContent=ge,Rt=a(),wl=i("ol"),wl.innerHTML=be,Vt=a(),T(rl.$$.fragment),kt=a(),T(jl.$$.fragment),Xt=a(),Ul=i("p"),Ul.innerHTML=Ge,_t=a(),ul=i("p"),ul.innerHTML=Ze,Et=a(),T(Il.$$.fragment),qt=a(),cl=i("p"),cl.innerHTML=Be,vt=a(),T(hl.$$.fragment),Nt=a(),ml=i("p"),ml.innerHTML=$e,zt=a(),fl=i("p"),fl.textContent=Re,xt=a(),T(Cl.$$.fragment),Ft=a(),T(Al.$$.fragment),St=a(),T(gl.$$.fragment),Yt=a(),bl=i("p"),bl.innerHTML=Ve,Qt=a(),Gl=i("p"),Gl.innerHTML=ke,Ht=a(),T(Zl.$$.fragment),Wt=a(),Bl=i("p"),Bl.innerHTML=Xe,Lt=a(),T($l.$$.fragment),Dt=a(),Rl=i("p"),Rl.textContent=_e,Pt=a(),T(Vl.$$.fragment),Ot=a(),kl=i("p"),kl.innerHTML=Ee,Kt=a(),T(Xl.$$.fragment),le=a(),_l=i("p"),_l.textContent=qe,te=a(),ql=i("p"),this.h()},l(l){const t=Le("svelte-u9bgzb",document.head);n=o(t,"META",{name:!0,content:!0}),t.forEach(e),U=M(l),y=o(l,"P",{}),Se(y).forEach(e),I=M(l),p($.$$.fragment,l),zl=M(l),p(m.$$.fragment,l),xl=M(l),p(f.$$.fragment,l),Fl=M(l),R=o(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1k7fcoj"&&(R.innerHTML=se),Sl=M(l),V=o(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-gltuje"&&(V.textContent=ae),Yl=M(l),k=o(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1qit7w"&&(k.innerHTML=Me),Ql=M(l),p(X.$$.fragment,l),Hl=M(l),p(_.$$.fragment,l),Wl=M(l),E=o(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-mekosh"&&(E.textContent=ne),Ll=M(l),q=o(l,"UL",{"data-svelte-h":!0}),J(q)!=="svelte-v28gob"&&(q.innerHTML=ie),Dl=M(l),v=o(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-3izox6"&&(v.innerHTML=oe),Pl=M(l),p(C.$$.fragment,l),Ol=M(l),p(N.$$.fragment,l),Kl=M(l),z=o(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1yjv3de"&&(z.innerHTML=Je),lt=M(l),x=o(l,"OL",{"data-svelte-h":!0}),J(x)!=="svelte-t7we9a"&&(x.innerHTML=ye),tt=M(l),p(F.$$.fragment,l),et=M(l),A=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(A)!=="svelte-1gzz03n"&&(A.innerHTML=Te),st=M(l),S=o(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-j8hcd0"&&(S.textContent=pe),at=M(l),p(Y.$$.fragment,l),Mt=M(l),p(Q.$$.fragment,l),nt=M(l),H=o(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1uu5ctj"&&(H.innerHTML=de),it=M(l),W=o(l,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1wah8i0"&&(W.innerHTML=we),ot=M(l),L=o(l,"OL",{"data-svelte-h":!0}),J(L)!=="svelte-1n4uzti"&&(L.innerHTML=re),Jt=M(l),p(D.$$.fragment,l),yt=M(l),g=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(g)!=="svelte-1hlknx7"&&(g.innerHTML=je),Tt=M(l),p(P.$$.fragment,l),pt=M(l),b=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(b)!=="svelte-odp277"&&(b.innerHTML=Ue),dt=M(l),p(O.$$.fragment,l),wt=M(l),K=o(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-14ljekm"&&(K.innerHTML=ue),rt=M(l),p(ll.$$.fragment,l),jt=M(l),p(tl.$$.fragment,l),Ut=M(l),el=o(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-19zng3q"&&(el.innerHTML=Ie),ut=M(l),p(sl.$$.fragment,l),It=M(l),p(G.$$.fragment,l),ct=M(l),p(al.$$.fragment,l),ht=M(l),Ml=o(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-jmz9cn"&&(Ml.textContent=ce),mt=M(l),nl=o(l,"OL",{"data-svelte-h":!0}),J(nl)!=="svelte-1o1li8d"&&(nl.innerHTML=he),ft=M(l),p(il.$$.fragment,l),Ct=M(l),p(Z.$$.fragment,l),At=M(l),B=o(l,"OL",{start:!0,"data-svelte-h":!0}),J(B)!=="svelte-1elhsal"&&(B.innerHTML=me),gt=M(l),ol=o(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-leta0s"&&(ol.innerHTML=fe),bt=M(l),p(Jl.$$.fragment,l),Gt=M(l),p(yl.$$.fragment,l),Zt=M(l),Tl=o(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1edtbpg"&&(Tl.textContent=Ce),Bt=M(l),pl=o(l,"UL",{"data-svelte-h":!0}),J(pl)!=="svelte-1dze5ec"&&(pl.innerHTML=Ae),$t=M(l),dl=o(l,"P",{"data-svelte-h":!0}),J(dl)!=="svelte-atwoq9"&&(dl.textContent=ge),Rt=M(l),wl=o(l,"OL",{"data-svelte-h":!0}),J(wl)!=="svelte-1euwcht"&&(wl.innerHTML=be),Vt=M(l),p(rl.$$.fragment,l),kt=M(l),p(jl.$$.fragment,l),Xt=M(l),Ul=o(l,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-pxkn08"&&(Ul.innerHTML=Ge),_t=M(l),ul=o(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-10rffde"&&(ul.innerHTML=Ze),Et=M(l),p(Il.$$.fragment,l),qt=M(l),cl=o(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-1p203tz"&&(cl.innerHTML=Be),vt=M(l),p(hl.$$.fragment,l),Nt=M(l),ml=o(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-1oe26y1"&&(ml.innerHTML=$e),zt=M(l),fl=o(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-1539djf"&&(fl.textContent=Re),xt=M(l),p(Cl.$$.fragment,l),Ft=M(l),p(Al.$$.fragment,l),St=M(l),p(gl.$$.fragment,l),Yt=M(l),bl=o(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-1sxj7ge"&&(bl.innerHTML=Ve),Qt=M(l),Gl=o(l,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-1abrkus"&&(Gl.innerHTML=ke),Ht=M(l),p(Zl.$$.fragment,l),Wt=M(l),Bl=o(l,"P",{"data-svelte-h":!0}),J(Bl)!=="svelte-r6j4wy"&&(Bl.innerHTML=Xe),Lt=M(l),p($l.$$.fragment,l),Dt=M(l),Rl=o(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-1s4bc00"&&(Rl.textContent=_e),Pt=M(l),p(Vl.$$.fragment,l),Ot=M(l),kl=o(l,"P",{"data-svelte-h":!0}),J(kl)!=="svelte-1g8vcpj"&&(kl.innerHTML=Ee),Kt=M(l),p(Xl.$$.fragment,l),le=M(l),_l=o(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-15xk2c2"&&(_l.textContent=qe),te=M(l),ql=o(l,"P",{}),Se(ql).forEach(e),this.h()},h(){El(n,"name","hf:doc:metadata"),El(n,"content",ss),El(A,"start","3"),El(g,"start","2"),El(b,"start","3"),El(B,"start","2")},m(l,t){De(document.head,n),s(l,U,t),s(l,y,t),s(l,I,t),d($,l,t),s(l,zl,t),d(m,l,t),s(l,xl,t),d(f,l,t),s(l,Fl,t),s(l,R,t),s(l,Sl,t),s(l,V,t),s(l,Yl,t),s(l,k,t),s(l,Ql,t),d(X,l,t),s(l,Hl,t),d(_,l,t),s(l,Wl,t),s(l,E,t),s(l,Ll,t),s(l,q,t),s(l,Dl,t),s(l,v,t),s(l,Pl,t),d(C,l,t),s(l,Ol,t),d(N,l,t),s(l,Kl,t),s(l,z,t),s(l,lt,t),s(l,x,t),s(l,tt,t),d(F,l,t),s(l,et,t),s(l,A,t),s(l,st,t),s(l,S,t),s(l,at,t),d(Y,l,t),s(l,Mt,t),d(Q,l,t),s(l,nt,t),s(l,H,t),s(l,it,t),s(l,W,t),s(l,ot,t),s(l,L,t),s(l,Jt,t),d(D,l,t),s(l,yt,t),s(l,g,t),s(l,Tt,t),d(P,l,t),s(l,pt,t),s(l,b,t),s(l,dt,t),d(O,l,t),s(l,wt,t),s(l,K,t),s(l,rt,t),d(ll,l,t),s(l,jt,t),d(tl,l,t),s(l,Ut,t),s(l,el,t),s(l,ut,t),d(sl,l,t),s(l,It,t),d(G,l,t),s(l,ct,t),d(al,l,t),s(l,ht,t),s(l,Ml,t),s(l,mt,t),s(l,nl,t),s(l,ft,t),d(il,l,t),s(l,Ct,t),d(Z,l,t),s(l,At,t),s(l,B,t),s(l,gt,t),s(l,ol,t),s(l,bt,t),d(Jl,l,t),s(l,Gt,t),d(yl,l,t),s(l,Zt,t),s(l,Tl,t),s(l,Bt,t),s(l,pl,t),s(l,$t,t),s(l,dl,t),s(l,Rt,t),s(l,wl,t),s(l,Vt,t),d(rl,l,t),s(l,kt,t),d(jl,l,t),s(l,Xt,t),s(l,Ul,t),s(l,_t,t),s(l,ul,t),s(l,Et,t),d(Il,l,t),s(l,qt,t),s(l,cl,t),s(l,vt,t),d(hl,l,t),s(l,Nt,t),s(l,ml,t),s(l,zt,t),s(l,fl,t),s(l,xt,t),d(Cl,l,t),s(l,Ft,t),d(Al,l,t),s(l,St,t),d(gl,l,t),s(l,Yt,t),s(l,bl,t),s(l,Qt,t),s(l,Gl,t),s(l,Ht,t),d(Zl,l,t),s(l,Wt,t),s(l,Bl,t),s(l,Lt,t),d($l,l,t),s(l,Dt,t),s(l,Rl,t),s(l,Pt,t),d(Vl,l,t),s(l,Ot,t),s(l,kl,t),s(l,Kt,t),d(Xl,l,t),s(l,le,t),s(l,_l,t),s(l,te,t),s(l,ql,t),ee=!0},p(l,[t]){const ve={};t&2&&(ve.$$scope={dirty:t,ctx:l}),m.$set(ve);const Ne={};t&2&&(Ne.$$scope={dirty:t,ctx:l}),f.$set(Ne);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:l}),C.$set(ze);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:l}),G.$set(xe);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:l}),Z.$set(Fe)},i(l){ee||(w($.$$.fragment,l),w(m.$$.fragment,l),w(f.$$.fragment,l),w(X.$$.fragment,l),w(_.$$.fragment,l),w(C.$$.fragment,l),w(N.$$.fragment,l),w(F.$$.fragment,l),w(Y.$$.fragment,l),w(Q.$$.fragment,l),w(D.$$.fragment,l),w(P.$$.fragment,l),w(O.$$.fragment,l),w(ll.$$.fragment,l),w(tl.$$.fragment,l),w(sl.$$.fragment,l),w(G.$$.fragment,l),w(al.$$.fragment,l),w(il.$$.fragment,l),w(Z.$$.fragment,l),w(Jl.$$.fragment,l),w(yl.$$.fragment,l),w(rl.$$.fragment,l),w(jl.$$.fragment,l),w(Il.$$.fragment,l),w(hl.$$.fragment,l),w(Cl.$$.fragment,l),w(Al.$$.fragment,l),w(gl.$$.fragment,l),w(Zl.$$.fragment,l),w($l.$$.fragment,l),w(Vl.$$.fragment,l),w(Xl.$$.fragment,l),ee=!0)},o(l){r($.$$.fragment,l),r(m.$$.fragment,l),r(f.$$.fragment,l),r(X.$$.fragment,l),r(_.$$.fragment,l),r(C.$$.fragment,l),r(N.$$.fragment,l),r(F.$$.fragment,l),r(Y.$$.fragment,l),r(Q.$$.fragment,l),r(D.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(tl.$$.fragment,l),r(sl.$$.fragment,l),r(G.$$.fragment,l),r(al.$$.fragment,l),r(il.$$.fragment,l),r(Z.$$.fragment,l),r(Jl.$$.fragment,l),r(yl.$$.fragment,l),r(rl.$$.fragment,l),r(jl.$$.fragment,l),r(Il.$$.fragment,l),r(hl.$$.fragment,l),r(Cl.$$.fragment,l),r(Al.$$.fragment,l),r(gl.$$.fragment,l),r(Zl.$$.fragment,l),r($l.$$.fragment,l),r(Vl.$$.fragment,l),r(Xl.$$.fragment,l),ee=!1},d(l){l&&(e(U),e(y),e(I),e(zl),e(xl),e(Fl),e(R),e(Sl),e(V),e(Yl),e(k),e(Ql),e(Hl),e(Wl),e(E),e(Ll),e(q),e(Dl),e(v),e(Pl),e(Ol),e(Kl),e(z),e(lt),e(x),e(tt),e(et),e(A),e(st),e(S),e(at),e(Mt),e(nt),e(H),e(it),e(W),e(ot),e(L),e(Jt),e(yt),e(g),e(Tt),e(pt),e(b),e(dt),e(wt),e(K),e(rt),e(jt),e(Ut),e(el),e(ut),e(It),e(ct),e(ht),e(Ml),e(mt),e(nl),e(ft),e(Ct),e(At),e(B),e(gt),e(ol),e(bt),e(Gt),e(Zt),e(Tl),e(Bt),e(pl),e($t),e(dl),e(Rt),e(wl),e(Vt),e(kt),e(Xt),e(Ul),e(_t),e(ul),e(Et),e(qt),e(cl),e(vt),e(Nt),e(ml),e(zt),e(fl),e(xt),e(Ft),e(St),e(Yt),e(bl),e(Qt),e(Gl),e(Ht),e(Wt),e(Bl),e(Lt),e(Dt),e(Rl),e(Pt),e(Ot),e(kl),e(Kt),e(le),e(_l),e(te),e(ql)),e(n),j($,l),j(m,l),j(f,l),j(X,l),j(_,l),j(C,l),j(N,l),j(F,l),j(Y,l),j(Q,l),j(D,l),j(P,l),j(O,l),j(ll,l),j(tl,l),j(sl,l),j(G,l),j(al,l),j(il,l),j(Z,l),j(Jl,l),j(yl,l),j(rl,l),j(jl,l),j(Il,l),j(hl,l),j(Cl,l),j(Al,l),j(gl,l),j(Zl,l),j($l,l),j(Vl,l),j(Xl,l)}}}const ss='{"title":"Create a dataset loading script","local":"create-a-dataset-loading-script","sections":[{"title":"Add dataset attributes","local":"add-dataset-attributes","sections":[{"title":"Multiple configurations","local":"multiple-configurations","sections":[],"depth":3},{"title":"Default configurations","local":"default-configurations","sections":[],"depth":3}],"depth":2},{"title":"Download data files and organize splits","local":"download-data-files-and-organize-splits","sections":[],"depth":2},{"title":"Generate samples","local":"generate-samples","sections":[],"depth":2},{"title":"(Optional) Generate dataset metadata","local":"optional-generate-dataset-metadata","sections":[],"depth":2},{"title":"Upload to the Hub","local":"upload-to-the-hub","sections":[],"depth":2},{"title":"Advanced features","local":"advanced-features","sections":[{"title":"Sharding","local":"sharding","sections":[],"depth":3},{"title":"ArrowBasedBuilder","local":"arrowbasedbuilder","sections":[],"depth":3}],"depth":2}],"depth":1}';function as(c){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends He{constructor(n){super(),We(this,n,as,es,Ye,{})}}export{ys as component};
