import{s as $s,n as Js,o as _s}from"../chunks/scheduler.bdbef820.js";import{S as xs,i as ks,g as p,s as l,r as c,A as Cs,h as r,f as n,c as t,j as ws,u,x as m,k as Ts,y as vs,a as e,v as i,d as b,t as j,w as o}from"../chunks/index.c0aea24a.js";import{C as H}from"../chunks/CodeBlock.6ccca92e.js";import{H as ms}from"../chunks/Heading.2eb892cb.js";function Us(hs){let h,L,V,Y,d,N,f,cs="This guide shows specific methods for processing text datasets. Learn how to:",F,g,us='<li>Tokenize a dataset with <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a>.</li> <li>Align dataset labels with label ids for NLI datasets.</li>',P,y,is='For a guide on how to process any type of dataset, take a look at the <a class="underline decoration-sky-400 decoration-2 font-semibold" href="./process">general process guide</a>.',R,M,A,w,bs='The <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function supports processing batches of examples at once which speeds up tokenization.',B,T,js='Load a tokenizer from 🤗 <a href="https://huggingface.co/transformers/" rel="nofollow">Transformers</a>:',Q,$,X,J,os='Set the <code>batched</code> parameter to <code>True</code> in the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function to apply the tokenizer to batches of examples:',E,_,S,x,ds='The <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function converts the returned values to a PyArrow-supported format. But explicitly returning the tensors as NumPy arrays is faster because it is a natively supported PyArrow format. Set <code>return_tensors=&quot;np&quot;</code> when you tokenize your text:',D,k,K,C,O,v,fs='The <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.align_labels_with_mapping">align_labels_with_mapping()</a> function aligns a dataset label id with the label name. Not all 🤗 Transformers models follow the prescribed label mapping of the original dataset, especially for NLI datasets. For example, the <a href="https://huggingface.co/datasets/glue" rel="nofollow">MNLI</a> dataset uses the following label mapping:',ss,U,as,W,gs="To align the dataset label mapping with the mapping used by a model, create a dictionary of the label name and id to align on:",ns,G,es,I,ys='Pass the dictionary of the label mappings to the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.align_labels_with_mapping">align_labels_with_mapping()</a> function, and the column to align on:',ls,q,ts,z,Ms="You can also use this function to assign a custom mapping of labels to ids.",ps,Z,rs;return d=new ms({props:{title:"Process text data",local:"process-text-data",headingTag:"h1"}}),M=new ms({props:{title:"Map",local:"map",headingTag:"h2"}}),$=new H({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),_=new H({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMGV4YW1wbGVzJTNBJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydGV4dCUyMiU1RCklMkMlMjBiYXRjaGVkJTNEVHJ1ZSklMEFkYXRhc2V0JTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> examples: tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>, 
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">1996</span>, <span class="hljs-number">2600</span>, <span class="hljs-number">2003</span>, <span class="hljs-number">16036</span>, <span class="hljs-number">2000</span>, <span class="hljs-number">2022</span>, <span class="hljs-number">1996</span>, <span class="hljs-number">7398</span>, <span class="hljs-number">2301</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">1055</span>, <span class="hljs-number">2047</span>, <span class="hljs-number">1000</span>, <span class="hljs-number">16608</span>, <span class="hljs-number">1000</span>, <span class="hljs-number">1998</span>, <span class="hljs-number">2008</span>, <span class="hljs-number">2002</span>, <span class="hljs-number">1005</span>, <span class="hljs-number">1055</span>, <span class="hljs-number">2183</span>, <span class="hljs-number">2000</span>, <span class="hljs-number">2191</span>, <span class="hljs-number">1037</span>, <span class="hljs-number">17624</span>, <span class="hljs-number">2130</span>, <span class="hljs-number">3618</span>, <span class="hljs-number">2084</span>, <span class="hljs-number">7779</span>, <span class="hljs-number">29058</span>, <span class="hljs-number">8625</span>, <span class="hljs-number">13327</span>, <span class="hljs-number">1010</span>, <span class="hljs-number">3744</span>, <span class="hljs-number">1011</span>, <span class="hljs-number">18856</span>, <span class="hljs-number">19513</span>, <span class="hljs-number">3158</span>, <span class="hljs-number">5477</span>, <span class="hljs-number">4168</span>, <span class="hljs-number">2030</span>, <span class="hljs-number">7112</span>, <span class="hljs-number">16562</span>, <span class="hljs-number">2140</span>, <span class="hljs-number">1012</span>, <span class="hljs-number">102</span>], 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),k=new H({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMGV4YW1wbGVzJTNBJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTJDJTIwYmF0Y2hlZCUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> examples: tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;np&quot;</span>), batched=<span class="hljs-literal">True</span>)',wrap:!1}}),C=new ms({props:{title:"Align",local:"align",headingTag:"h2"}}),U=new H({props:{code:"bGFiZWwyaWQlMjAlM0QlMjAlN0IlMjJlbnRhaWxtZW50JTIyJTNBJTIwMCUyQyUyMCUyMm5ldXRyYWwlMjIlM0ElMjAxJTJDJTIwJTIyY29udHJhZGljdGlvbiUyMiUzQSUyMDIlN0Q=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {<span class="hljs-string">&quot;entailment&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;neutral&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;contradiction&quot;</span>: <span class="hljs-number">2</span>}',wrap:!1}}),G=new H({props:{code:"bGFiZWwyaWQlMjAlM0QlMjAlN0IlMjJjb250cmFkaWN0aW9uJTIyJTNBJTIwMCUyQyUyMCUyMm5ldXRyYWwlMjIlM0ElMjAxJTJDJTIwJTIyZW50YWlsbWVudCUyMiUzQSUyMDIlN0Q=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {<span class="hljs-string">&quot;contradiction&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;neutral&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;entailment&quot;</span>: <span class="hljs-number">2</span>}',wrap:!1}}),q=new H({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbW5saSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybW5saSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbW5saV9hbGlnbmVkJTIwJTNEJTIwbW5saS5hbGlnbl9sYWJlbHNfd2l0aF9tYXBwaW5nKGxhYmVsMmlkJTJDJTIwJTIybGFiZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>mnli = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mnli_aligned = mnli.align_labels_with_mapping(label2id, <span class="hljs-string">&quot;label&quot;</span>)`,wrap:!1}}),{c(){h=p("meta"),L=l(),V=p("p"),Y=l(),c(d.$$.fragment),N=l(),f=p("p"),f.textContent=cs,F=l(),g=p("ul"),g.innerHTML=us,P=l(),y=p("p"),y.innerHTML=is,R=l(),c(M.$$.fragment),A=l(),w=p("p"),w.innerHTML=bs,B=l(),T=p("p"),T.innerHTML=js,Q=l(),c($.$$.fragment),X=l(),J=p("p"),J.innerHTML=os,E=l(),c(_.$$.fragment),S=l(),x=p("p"),x.innerHTML=ds,D=l(),c(k.$$.fragment),K=l(),c(C.$$.fragment),O=l(),v=p("p"),v.innerHTML=fs,ss=l(),c(U.$$.fragment),as=l(),W=p("p"),W.textContent=gs,ns=l(),c(G.$$.fragment),es=l(),I=p("p"),I.innerHTML=ys,ls=l(),c(q.$$.fragment),ts=l(),z=p("p"),z.textContent=Ms,ps=l(),Z=p("p"),this.h()},l(s){const a=Cs("svelte-u9bgzb",document.head);h=r(a,"META",{name:!0,content:!0}),a.forEach(n),L=t(s),V=r(s,"P",{}),ws(V).forEach(n),Y=t(s),u(d.$$.fragment,s),N=t(s),f=r(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-zxifil"&&(f.textContent=cs),F=t(s),g=r(s,"UL",{"data-svelte-h":!0}),m(g)!=="svelte-1dhu20q"&&(g.innerHTML=us),P=t(s),y=r(s,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3s2bzp"&&(y.innerHTML=is),R=t(s),u(M.$$.fragment,s),A=t(s),w=r(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1q7h0ns"&&(w.innerHTML=bs),B=t(s),T=r(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-b5bjp1"&&(T.innerHTML=js),Q=t(s),u($.$$.fragment,s),X=t(s),J=r(s,"P",{"data-svelte-h":!0}),m(J)!=="svelte-7zhug3"&&(J.innerHTML=os),E=t(s),u(_.$$.fragment,s),S=t(s),x=r(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-te9x31"&&(x.innerHTML=ds),D=t(s),u(k.$$.fragment,s),K=t(s),u(C.$$.fragment,s),O=t(s),v=r(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1xhjhzj"&&(v.innerHTML=fs),ss=t(s),u(U.$$.fragment,s),as=t(s),W=r(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-tn6t6n"&&(W.textContent=gs),ns=t(s),u(G.$$.fragment,s),es=t(s),I=r(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-xe38lp"&&(I.innerHTML=ys),ls=t(s),u(q.$$.fragment,s),ts=t(s),z=r(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-18y4a1w"&&(z.textContent=Ms),ps=t(s),Z=r(s,"P",{}),ws(Z).forEach(n),this.h()},h(){Ts(h,"name","hf:doc:metadata"),Ts(h,"content",Ws)},m(s,a){vs(document.head,h),e(s,L,a),e(s,V,a),e(s,Y,a),i(d,s,a),e(s,N,a),e(s,f,a),e(s,F,a),e(s,g,a),e(s,P,a),e(s,y,a),e(s,R,a),i(M,s,a),e(s,A,a),e(s,w,a),e(s,B,a),e(s,T,a),e(s,Q,a),i($,s,a),e(s,X,a),e(s,J,a),e(s,E,a),i(_,s,a),e(s,S,a),e(s,x,a),e(s,D,a),i(k,s,a),e(s,K,a),i(C,s,a),e(s,O,a),e(s,v,a),e(s,ss,a),i(U,s,a),e(s,as,a),e(s,W,a),e(s,ns,a),i(G,s,a),e(s,es,a),e(s,I,a),e(s,ls,a),i(q,s,a),e(s,ts,a),e(s,z,a),e(s,ps,a),e(s,Z,a),rs=!0},p:Js,i(s){rs||(b(d.$$.fragment,s),b(M.$$.fragment,s),b($.$$.fragment,s),b(_.$$.fragment,s),b(k.$$.fragment,s),b(C.$$.fragment,s),b(U.$$.fragment,s),b(G.$$.fragment,s),b(q.$$.fragment,s),rs=!0)},o(s){j(d.$$.fragment,s),j(M.$$.fragment,s),j($.$$.fragment,s),j(_.$$.fragment,s),j(k.$$.fragment,s),j(C.$$.fragment,s),j(U.$$.fragment,s),j(G.$$.fragment,s),j(q.$$.fragment,s),rs=!1},d(s){s&&(n(L),n(V),n(Y),n(N),n(f),n(F),n(g),n(P),n(y),n(R),n(A),n(w),n(B),n(T),n(Q),n(X),n(J),n(E),n(S),n(x),n(D),n(K),n(O),n(v),n(ss),n(as),n(W),n(ns),n(es),n(I),n(ls),n(ts),n(z),n(ps),n(Z)),n(h),o(d,s),o(M,s),o($,s),o(_,s),o(k,s),o(C,s),o(U,s),o(G,s),o(q,s)}}}const Ws='{"title":"Process text data","local":"process-text-data","sections":[{"title":"Map","local":"map","sections":[],"depth":2},{"title":"Align","local":"align","sections":[],"depth":2}],"depth":1}';function Gs(hs){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends xs{constructor(h){super(),ks(this,h,Gs,Us,$s,{})}}export{Vs as component};
