import{s as Ys,o as As,n as Xs}from"../chunks/scheduler.bdbef820.js";import{S as Es,i as Qs,g as p,s as n,r as h,A as Ns,h as c,f as e,c as t,j as Vs,u as r,x as o,k as S,y as Rs,a as l,v as j,d as J,t as M,w as b}from"../chunks/index.c0aea24a.js";import{T as zs}from"../chunks/Tip.31005f7d.js";import{C as w}from"../chunks/CodeBlock.6ccca92e.js";import{H as Hs}from"../chunks/Heading.2eb892cb.js";function Ss(F){let i,x=`Now that you know how to process a dataset for object detection, learn
<a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/YOLOS/Fine_tuning_YOLOS_for_object_detection_on_custom_dataset_(balloon).ipynb" rel="nofollow">how to train an object detection model</a>
and use it for inference.`;return{c(){i=p("p"),i.innerHTML=x},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-cn2hue"&&(i.innerHTML=x)},m(m,z){l(m,i,z)},p:Xs,d(m){m&&e(i)}}}function Fs(F){let i,x,m,z,u,L,U,Ts='Object detection models identify something in an image, and object detection datasets are used for applications such as autonomous driving and detecting natural hazards like wildfire. This guide will show you how to apply transformations to an object detection dataset following the <a href="https://albumentations.ai/docs/examples/example_bboxes/" rel="nofollow">tutorial</a> from <a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a>.',D,f,ws="To run these examples, make sure you have up-to-date versions of <code>albumentations</code> and <code>cv2</code> installed:",K,I,P,C,xs='In this example, you’ll use the <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow"><code>cppe-5</code></a> dataset for identifying medical personal protective equipment (PPE) in the context of the COVID-19 pandemic.',q,v,us="Load the dataset and take a look at an example:",O,B,ss,_,Us="The dataset has the following fields:",as,Z,fs='<li><code>image</code>: PIL.Image.Image object containing the image.</li> <li><code>image_id</code>: The image ID.</li> <li><code>height</code>: The image height.</li> <li><code>width</code>: The image width.</li> <li><code>objects</code>: A dictionary containing bounding box metadata for the objects in the image:<ul><li><code>id</code>: The annotation id.</li> <li><code>area</code>: The area of the bounding box.</li> <li><code>bbox</code>: The object’s bounding box (in the <a href="https://albumentations.ai/docs/getting_started/bounding_boxes_augmentation/#coco" rel="nofollow">coco</a> format).</li> <li><code>category</code>: The object’s category, with possible values including <code>Coverall (0)</code>, <code>Face_Shield (1)</code>, <code>Gloves (2)</code>, <code>Goggles (3)</code> and <code>Mask (4)</code>.</li></ul></li>',es,k,Is='You can visualize the <code>bboxes</code> on the image using some internal torch utilities. To do that, you will need to reference the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> feature associated with the category IDs so you can look up the string labels:',ls,G,ns,g,Cs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/visualize_detection_example.png"/>',ts,W,vs="With <code>albumentations</code>, you can apply transforms that will affect the image while also updating the <code>bboxes</code> accordingly. In this case, the image is resized to (480, 480), flipped horizontally, and brightened.",ps,$,cs,V,Bs="Now when you visualize the result, the image should be flipped, but the <code>bboxes</code> should still be in the right places.",is,Y,os,d,_s='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/visualize_detection_example_transformed.png"/>',ms,A,Zs="Create a function to apply the transform to a batch of examples:",hs,X,rs,E,ks='Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transform on-the-fly which consumes less disk space. The randomness of data augmentation may return a different image if you access the same example twice. It is especially useful when training a model for several epochs.',js,Q,Js,N,Gs="You can verify the transform works by visualizing the 10th example:",Ms,R,bs,y,Ws='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/visualize_detection_example_transformed_2.png"/>',gs,T,ds,H,ys;return u=new Hs({props:{title:"Object detection",local:"object-detection",headingTag:"h1"}}),I=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWxidW1lbnRhdGlvbnMlMjBvcGVuY3YtcHl0aG9u",highlighted:'pip <span class="hljs-keyword">install</span> -U albumentations opencv-python',wrap:!1}}),B=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3BwZS01JTIyKSUwQWV4YW1wbGUlMjAlM0QlMjBkcyU1Qid0cmFpbiclNUQlNUIwJTVEJTBBZXhhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;cppe-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example = ds[<span class="hljs-string">&#x27;train&#x27;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>example
{<span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">663</span>,
 <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=943x663 at <span class="hljs-number">0x7FC3DC756250</span>&gt;,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;area&#x27;</span>: [<span class="hljs-number">3796</span>, <span class="hljs-number">1596</span>, <span class="hljs-number">152768</span>, <span class="hljs-number">81002</span>],
  <span class="hljs-string">&#x27;bbox&#x27;</span>: [[<span class="hljs-number">302.0</span>, <span class="hljs-number">109.0</span>, <span class="hljs-number">73.0</span>, <span class="hljs-number">52.0</span>],
   [<span class="hljs-number">810.0</span>, <span class="hljs-number">100.0</span>, <span class="hljs-number">57.0</span>, <span class="hljs-number">28.0</span>],
   [<span class="hljs-number">160.0</span>, <span class="hljs-number">31.0</span>, <span class="hljs-number">248.0</span>, <span class="hljs-number">616.0</span>],
   [<span class="hljs-number">741.0</span>, <span class="hljs-number">68.0</span>, <span class="hljs-number">202.0</span>, <span class="hljs-number">401.0</span>]],
  <span class="hljs-string">&#x27;category&#x27;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
  <span class="hljs-string">&#x27;id&#x27;</span>: [<span class="hljs-number">114</span>, <span class="hljs-number">115</span>, <span class="hljs-number">116</span>, <span class="hljs-number">117</span>]},
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">943</span>}`,wrap:!1}}),G=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24ub3BzJTIwaW1wb3J0JTIwYm94X2NvbnZlcnQlMEFmcm9tJTIwdG9yY2h2aXNpb24udXRpbHMlMjBpbXBvcnQlMjBkcmF3X2JvdW5kaW5nX2JveGVzJTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMuZnVuY3Rpb25hbCUyMGltcG9ydCUyMHBpbF90b190ZW5zb3IlMkMlMjB0b19waWxfaW1hZ2UlMEElMEFjYXRlZ29yaWVzJTIwJTNEJTIwZHMlNUIndHJhaW4nJTVELmZlYXR1cmVzJTVCJ29iamVjdHMnJTVELmZlYXR1cmUlNUInY2F0ZWdvcnknJTVEJTBBJTBBYm94ZXNfeHl3aCUyMCUzRCUyMHRvcmNoLnRlbnNvcihleGFtcGxlJTVCJ29iamVjdHMnJTVEJTVCJ2Jib3gnJTVEKSUwQWJveGVzX3h5eHklMjAlM0QlMjBib3hfY29udmVydChib3hlc194eXdoJTJDJTIwJ3h5d2gnJTJDJTIwJ3h5eHknKSUwQWxhYmVscyUyMCUzRCUyMCU1QmNhdGVnb3JpZXMuaW50MnN0cih4KSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGUlNUInb2JqZWN0cyclNUQlNUInY2F0ZWdvcnknJTVEJTVEJTBBdG9fcGlsX2ltYWdlKCUwQSUyMCUyMCUyMCUyMGRyYXdfYm91bmRpbmdfYm94ZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlsX3RvX3RlbnNvcihleGFtcGxlJTVCJ2ltYWdlJyU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3hlc194eXh5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sb3JzJTNEJTIycmVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.ops <span class="hljs-keyword">import</span> box_convert
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.utils <span class="hljs-keyword">import</span> draw_bounding_boxes
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms.functional <span class="hljs-keyword">import</span> pil_to_tensor, to_pil_image

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = ds[<span class="hljs-string">&#x27;train&#x27;</span>].features[<span class="hljs-string">&#x27;objects&#x27;</span>].feature[<span class="hljs-string">&#x27;category&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xywh = torch.tensor(example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;bbox&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xyxy = box_convert(boxes_xywh, <span class="hljs-string">&#x27;xywh&#x27;</span>, <span class="hljs-string">&#x27;xyxy&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [categories.int2str(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;category&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>to_pil_image(
<span class="hljs-meta">... </span>    draw_bounding_boxes(
<span class="hljs-meta">... </span>        pil_to_tensor(example[<span class="hljs-string">&#x27;image&#x27;</span>]),
<span class="hljs-meta">... </span>        boxes_xyxy,
<span class="hljs-meta">... </span>        colors=<span class="hljs-string">&quot;red&quot;</span>,
<span class="hljs-meta">... </span>        labels=labels,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),$=new w({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEF0cmFuc2Zvcm0lMjAlM0QlMjBhbGJ1bWVudGF0aW9ucy5Db21wb3NlKCU1QiUwQSUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJlc2l6ZSg0ODAlMkMlMjA0ODApJTJDJTBBJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuSG9yaXpvbnRhbEZsaXAocCUzRDEuMCklMkMlMEElMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5SYW5kb21CcmlnaHRuZXNzQ29udHJhc3QocCUzRDEuMCklMkMlMEElNUQlMkMlMjBiYm94X3BhcmFtcyUzRGFsYnVtZW50YXRpb25zLkJib3hQYXJhbXMoZm9ybWF0JTNEJ2NvY28nJTJDJTIwJTIwbGFiZWxfZmllbGRzJTNEJTVCJ2NhdGVnb3J5JyU1RCkpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShleGFtcGxlJTVCJ2ltYWdlJyU1RCklMEFvdXQlMjAlM0QlMjB0cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGJib3hlcyUzRGV4YW1wbGUlNUInb2JqZWN0cyclNUQlNUInYmJveCclNUQlMkMlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUzRGV4YW1wbGUlNUInb2JqZWN0cyclNUQlNUInY2F0ZWdvcnknJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose([
<span class="hljs-meta">... </span>    albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
<span class="hljs-meta">... </span>    albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>    albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>], bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&#x27;coco&#x27;</span>,  label_fields=[<span class="hljs-string">&#x27;category&#x27;</span>]))

<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(example[<span class="hljs-string">&#x27;image&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>out = transform(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    bboxes=example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;bbox&#x27;</span>],
<span class="hljs-meta">... </span>    category=example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;category&#x27;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),Y=new w({props:{code:"aW1hZ2UlMjAlM0QlMjB0b3JjaC50ZW5zb3Iob3V0JTVCJ2ltYWdlJyU1RCkucGVybXV0ZSgyJTJDJTIwMCUyQyUyMDEpJTBBYm94ZXNfeHl3aCUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QnRvcmNoLnRlbnNvcih4KSUyMGZvciUyMHglMjBpbiUyMG91dCU1QidiYm94ZXMnJTVEJTVEKSUwQWJveGVzX3h5eHklMjAlM0QlMjBib3hfY29udmVydChib3hlc194eXdoJTJDJTIwJ3h5d2gnJTJDJTIwJ3h5eHknKSUwQWxhYmVscyUyMCUzRCUyMCU1QmNhdGVnb3JpZXMuaW50MnN0cih4KSUyMGZvciUyMHglMjBpbiUyMG91dCU1QidjYXRlZ29yeSclNUQlNUQlMEF0b19waWxfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwZHJhd19ib3VuZGluZ19ib3hlcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJveGVzX3h5eHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2xvcnMlM0QncmVkJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVscyUzRGxhYmVscyUwQSUyMCUyMCUyMCUyMCklMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = torch.tensor(out[<span class="hljs-string">&#x27;image&#x27;</span>]).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xywh = torch.stack([torch.tensor(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> out[<span class="hljs-string">&#x27;bboxes&#x27;</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xyxy = box_convert(boxes_xywh, <span class="hljs-string">&#x27;xywh&#x27;</span>, <span class="hljs-string">&#x27;xyxy&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [categories.int2str(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> out[<span class="hljs-string">&#x27;category&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>to_pil_image(
<span class="hljs-meta">... </span>    draw_bounding_boxes(
<span class="hljs-meta">... </span>        image,
<span class="hljs-meta">... </span>        boxes_xyxy,
<span class="hljs-meta">... </span>        colors=<span class="hljs-string">&#x27;red&#x27;</span>,
<span class="hljs-meta">... </span>        labels=labels
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),X=new w({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMkMlMjBiYm94ZXMlMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUInaW1hZ2UnJTVEJTJDJTIwZXhhbXBsZXMlNUInb2JqZWN0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwdHJhbnNmb3JtKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYm94ZXMlM0RvYmplY3RzJTVCJ2Jib3gnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2F0ZWdvcnklM0RvYmplY3RzJTVCJ2NhdGVnb3J5JyU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKHRvcmNoLnRlbnNvcihvdXQlNUInaW1hZ2UnJTVEKS5wZXJtdXRlKDIlMkMlMjAwJTJDJTIwMSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmJveGVzLmFwcGVuZCh0b3JjaC50ZW5zb3Iob3V0JTVCJ2Jib3hlcyclNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3JpZXMuYXBwZW5kKG91dCU1QidjYXRlZ29yeSclNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJ2ltYWdlJyUzQSUyMGltYWdlcyUyQyUyMCdiYm94JyUzQSUyMGJib3hlcyUyQyUyMCdjYXRlZ29yeSclM0ElMjBjYXRlZ29yaWVzJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images, bboxes, categories = [], [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;image&#x27;</span>], examples[<span class="hljs-string">&#x27;objects&#x27;</span>]):
<span class="hljs-meta">... </span>        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))
<span class="hljs-meta">... </span>        out = transform(
<span class="hljs-meta">... </span>            image=image,
<span class="hljs-meta">... </span>            bboxes=objects[<span class="hljs-string">&#x27;bbox&#x27;</span>],
<span class="hljs-meta">... </span>            category=objects[<span class="hljs-string">&#x27;category&#x27;</span>]
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        images.append(torch.tensor(out[<span class="hljs-string">&#x27;image&#x27;</span>]).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>        bboxes.append(torch.tensor(out[<span class="hljs-string">&#x27;bboxes&#x27;</span>]))
<span class="hljs-meta">... </span>        categories.append(out[<span class="hljs-string">&#x27;category&#x27;</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&#x27;image&#x27;</span>: images, <span class="hljs-string">&#x27;bbox&#x27;</span>: bboxes, <span class="hljs-string">&#x27;category&#x27;</span>: categories}`,wrap:!1}}),Q=new w({props:{code:"ZHMlNUIndHJhaW4nJTVELnNldF90cmFuc2Zvcm0odHJhbnNmb3Jtcyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-string">&#x27;train&#x27;</span>].set_transform(transforms)',wrap:!1}}),R=new w({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRzJTVCJ3RyYWluJyU1RCU1QjEwJTVEJTBBdG9fcGlsX2ltYWdlKCUwQSUyMCUyMCUyMCUyMGRyYXdfYm91bmRpbmdfYm94ZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZSU1QidpbWFnZSclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3hfY29udmVydChleGFtcGxlJTVCJ2Jib3gnJTVEJTJDJTIwJ3h5d2gnJTJDJTIwJ3h5eHknKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbG9ycyUzRCdyZWQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCY2F0ZWdvcmllcy5pbnQyc3RyKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZSU1QidjYXRlZ29yeSclNUQlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = ds[<span class="hljs-string">&#x27;train&#x27;</span>][<span class="hljs-number">10</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>to_pil_image(
<span class="hljs-meta">... </span>    draw_bounding_boxes(
<span class="hljs-meta">... </span>        example[<span class="hljs-string">&#x27;image&#x27;</span>],
<span class="hljs-meta">... </span>        box_convert(example[<span class="hljs-string">&#x27;bbox&#x27;</span>], <span class="hljs-string">&#x27;xywh&#x27;</span>, <span class="hljs-string">&#x27;xyxy&#x27;</span>),
<span class="hljs-meta">... </span>        colors=<span class="hljs-string">&#x27;red&#x27;</span>,
<span class="hljs-meta">... </span>        labels=[categories.int2str(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example[<span class="hljs-string">&#x27;category&#x27;</span>]]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),T=new zs({props:{$$slots:{default:[Ss]},$$scope:{ctx:F}}}),{c(){i=p("meta"),x=n(),m=p("p"),z=n(),h(u.$$.fragment),L=n(),U=p("p"),U.innerHTML=Ts,D=n(),f=p("p"),f.innerHTML=ws,K=n(),h(I.$$.fragment),P=n(),C=p("p"),C.innerHTML=xs,q=n(),v=p("p"),v.textContent=us,O=n(),h(B.$$.fragment),ss=n(),_=p("p"),_.textContent=Us,as=n(),Z=p("ul"),Z.innerHTML=fs,es=n(),k=p("p"),k.innerHTML=Is,ls=n(),h(G.$$.fragment),ns=n(),g=p("div"),g.innerHTML=Cs,ts=n(),W=p("p"),W.innerHTML=vs,ps=n(),h($.$$.fragment),cs=n(),V=p("p"),V.innerHTML=Bs,is=n(),h(Y.$$.fragment),os=n(),d=p("div"),d.innerHTML=_s,ms=n(),A=p("p"),A.textContent=Zs,hs=n(),h(X.$$.fragment),rs=n(),E=p("p"),E.innerHTML=ks,js=n(),h(Q.$$.fragment),Js=n(),N=p("p"),N.textContent=Gs,Ms=n(),h(R.$$.fragment),bs=n(),y=p("div"),y.innerHTML=Ws,gs=n(),h(T.$$.fragment),ds=n(),H=p("p"),this.h()},l(s){const a=Ns("svelte-u9bgzb",document.head);i=c(a,"META",{name:!0,content:!0}),a.forEach(e),x=t(s),m=c(s,"P",{}),Vs(m).forEach(e),z=t(s),r(u.$$.fragment,s),L=t(s),U=c(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-jruc7r"&&(U.innerHTML=Ts),D=t(s),f=c(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-129tu0o"&&(f.innerHTML=ws),K=t(s),r(I.$$.fragment,s),P=t(s),C=c(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1weiyre"&&(C.innerHTML=xs),q=t(s),v=c(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1yzvpv3"&&(v.textContent=us),O=t(s),r(B.$$.fragment,s),ss=t(s),_=c(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-ybiosu"&&(_.textContent=Us),as=t(s),Z=c(s,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-1fspv27"&&(Z.innerHTML=fs),es=t(s),k=c(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1i63vec"&&(k.innerHTML=Is),ls=t(s),r(G.$$.fragment,s),ns=t(s),g=c(s,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-12m4ojo"&&(g.innerHTML=Cs),ts=t(s),W=c(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1mco384"&&(W.innerHTML=vs),ps=t(s),r($.$$.fragment,s),cs=t(s),V=c(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-kmv35f"&&(V.innerHTML=Bs),is=t(s),r(Y.$$.fragment,s),os=t(s),d=c(s,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-1hy8dte"&&(d.innerHTML=_s),ms=t(s),A=c(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-di1rb7"&&(A.textContent=Zs),hs=t(s),r(X.$$.fragment,s),rs=t(s),E=c(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-4e5700"&&(E.innerHTML=ks),js=t(s),r(Q.$$.fragment,s),Js=t(s),N=c(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-u7hwut"&&(N.textContent=Gs),Ms=t(s),r(R.$$.fragment,s),bs=t(s),y=c(s,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-70kk7f"&&(y.innerHTML=Ws),gs=t(s),r(T.$$.fragment,s),ds=t(s),H=c(s,"P",{}),Vs(H).forEach(e),this.h()},h(){S(i,"name","hf:doc:metadata"),S(i,"content",Ls),S(g,"class","flex justify-center"),S(d,"class","flex justify-center"),S(y,"class","flex justify-center")},m(s,a){Rs(document.head,i),l(s,x,a),l(s,m,a),l(s,z,a),j(u,s,a),l(s,L,a),l(s,U,a),l(s,D,a),l(s,f,a),l(s,K,a),j(I,s,a),l(s,P,a),l(s,C,a),l(s,q,a),l(s,v,a),l(s,O,a),j(B,s,a),l(s,ss,a),l(s,_,a),l(s,as,a),l(s,Z,a),l(s,es,a),l(s,k,a),l(s,ls,a),j(G,s,a),l(s,ns,a),l(s,g,a),l(s,ts,a),l(s,W,a),l(s,ps,a),j($,s,a),l(s,cs,a),l(s,V,a),l(s,is,a),j(Y,s,a),l(s,os,a),l(s,d,a),l(s,ms,a),l(s,A,a),l(s,hs,a),j(X,s,a),l(s,rs,a),l(s,E,a),l(s,js,a),j(Q,s,a),l(s,Js,a),l(s,N,a),l(s,Ms,a),j(R,s,a),l(s,bs,a),l(s,y,a),l(s,gs,a),j(T,s,a),l(s,ds,a),l(s,H,a),ys=!0},p(s,[a]){const $s={};a&2&&($s.$$scope={dirty:a,ctx:s}),T.$set($s)},i(s){ys||(J(u.$$.fragment,s),J(I.$$.fragment,s),J(B.$$.fragment,s),J(G.$$.fragment,s),J($.$$.fragment,s),J(Y.$$.fragment,s),J(X.$$.fragment,s),J(Q.$$.fragment,s),J(R.$$.fragment,s),J(T.$$.fragment,s),ys=!0)},o(s){M(u.$$.fragment,s),M(I.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M($.$$.fragment,s),M(Y.$$.fragment,s),M(X.$$.fragment,s),M(Q.$$.fragment,s),M(R.$$.fragment,s),M(T.$$.fragment,s),ys=!1},d(s){s&&(e(x),e(m),e(z),e(L),e(U),e(D),e(f),e(K),e(P),e(C),e(q),e(v),e(O),e(ss),e(_),e(as),e(Z),e(es),e(k),e(ls),e(ns),e(g),e(ts),e(W),e(ps),e(cs),e(V),e(is),e(os),e(d),e(ms),e(A),e(hs),e(rs),e(E),e(js),e(Js),e(N),e(Ms),e(bs),e(y),e(gs),e(ds),e(H)),e(i),b(u,s),b(I,s),b(B,s),b(G,s),b($,s),b(Y,s),b(X,s),b(Q,s),b(R,s),b(T,s)}}}const Ls='{"title":"Object detection","local":"object-detection","sections":[],"depth":1}';function Ds(F){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Es{constructor(i){super(),Qs(this,i,Ds,Fs,Ys,{})}}export{aa as component};
