import{s as ot,o as ft,n as qs}from"../chunks/scheduler.bdbef820.js";import{S as ut,i as gt,g as r,s as l,r as d,A as jt,h as c,f as e,c as n,j as Je,u as h,x as g,k as xe,y as Mt,a as t,v as m,d as o,t as f,w as u}from"../chunks/index.c0aea24a.js";import{T as Ps}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{F as bt,M as yt}from"../chunks/Markdown.1f17db59.js";import{H as x}from"../chunks/Heading.2eb892cb.js";function wt(w){let p,j=`An <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is useful for iterative jobs like training a model.
You shouldn’t use a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> for jobs that require random access to examples because you have to iterate all over it using a for loop. Getting the last example in an iterable dataset would require you to iterate over all the previous examples.
You can find more details in the <a href="./about_mapstyle_vs_iterable">Dataset vs. IterableDataset guide</a>.`;return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-phgqok"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:qs,d(i){i&&e(p)}}}function Tt(w){let p,j='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will also shuffle the order of the shards if the dataset is sharded into multiple files.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-5gnogz"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:qs,d(i){i&&e(p)}}}function xt(w){let p,j="<code>take</code> and <code>skip</code> prevent future calls to <code>shuffle</code> because they lock in the order of the shards. You should <code>shuffle</code> your dataset before splitting it.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-kg825l"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:qs,d(i){i&&e(p)}}}function Jt(w){let p,j="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&#39;int32&#39;)</code> to <code>Value(&#39;bool&#39;)</code> if the original column only contains ones and zeros.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-19jja92"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:qs,d(i){i&&e(p)}}}function $t(w){let p,j='See other examples of batch processing in the <a href="./process#batch-processing">batched map processing</a> documentation. They work the same for iterable datasets.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-csithm"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:qs,d(i){i&&e(p)}}}function _t(w){let p,j,i,b="Lastly, create a simple training loop and start training:",T,J,$;return p=new y({props:{code:"c2VlZCUyQyUyMGJ1ZmZlcl9zaXplJTIwJTNEJTIwNDIlMkMlMjAxMF8wMDAlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zaHVmZmxlKHNlZWQlMkMlMjBidWZmZXJfc2l6ZSUzRGJ1ZmZlcl9zaXplKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>seed, buffer_size = <span class="hljs-number">42</span>, <span class="hljs-number">10_000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.shuffle(seed, buffer_size=buffer_size)`,wrap:!1}}),J=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yTWFza2VkTE0lMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZGF0YXNldCUyQyUyMGNvbGxhdGVfZm4lM0REYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nKHRva2VuaXplcikpJTBBZGV2aWNlJTIwJTNEJTIwJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnJTIwJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwudHJhaW4oKS50byhkZXZpY2UpJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcocGFyYW1zJTNEbW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QxZS01KSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRxZG0oZGF0YWxvYWRlciUyQyUyMHRvdGFsJTNENSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwNSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cyU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTI1JTIwMTAlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMmxvc3MlM0ElMjAlN0Jsb3NzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMaskedLM, DataCollatorForLanguageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(dataset, collate_fn=DataCollatorForLanguageModeling(tokenizer))
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span> 
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.train().to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(params=model.parameters(), lr=<span class="hljs-number">1e-5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(dataloader, total=<span class="hljs-number">5</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i == <span class="hljs-number">5</span>:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;loss: <span class="hljs-subst">{loss}</span>&quot;</span>)`,wrap:!1}}),{c(){d(p.$$.fragment),j=l(),i=r("p"),i.textContent=b,T=l(),d(J.$$.fragment)},l(M){h(p.$$.fragment,M),j=n(M),i=c(M,"P",{"data-svelte-h":!0}),g(i)!=="svelte-uyzjf"&&(i.textContent=b),T=n(M),h(J.$$.fragment,M)},m(M,_){m(p,M,_),t(M,j,_),t(M,i,_),t(M,T,_),m(J,M,_),$=!0},p:qs,i(M){$||(o(p.$$.fragment,M),o(J.$$.fragment,M),$=!0)},o(M){f(p.$$.fragment,M),f(J.$$.fragment,M),$=!1},d(M){M&&(e(j),e(i),e(T)),u(p,M),u(J,M)}}}function kt(w){let p,j;return p=new yt({props:{$$slots:{default:[_t]},$$scope:{ctx:w}}}),{c(){d(p.$$.fragment)},l(i){h(p.$$.fragment,i)},m(i,b){m(p,i,b),j=!0},p(i,b){const T={};b&2&&(T.$$scope={dirty:b,ctx:i}),p.$set(T)},i(i){j||(o(p.$$.fragment,i),j=!0)},o(i){f(p.$$.fragment,i),j=!1},d(i){u(p,i)}}}function Zt(w){let p,j,i,b,T,J,$,M=`Dataset streaming lets you work with a dataset without downloading it.
The data is streamed as you iterate over the dataset.
This is especially helpful when:`,_,X,$e="<li>You don’t want to wait for an extremely large dataset to download.</li> <li>The dataset size exceeds the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",Os,k,_e='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming-dark.gif"/>',sa,C,ke='For example, the English split of the <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> dataset is 1.2 terabytes, but you can use it instantly with streaming. Stream a dataset by setting <code>streaming=True</code> in <a href="/docs/datasets/v2.19.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> as shown below:',aa,F,ea,W,Ze=`Dataset streaming also lets you work with a dataset made of local files without doing any conversion.
In this case, the data is streamed from the local files as you iterate over the dataset.
This is especially helpful when:`,ta,V,ve="<li>You don’t want to wait for an extremely large local dataset to be converted to Arrow.</li> <li>The converted files size would exceed the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",la,Y,Ue='For example, you can stream a local dataset of hundreds of compressed JSONL files like <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> to use it instantly:',na,z,pa,B,Ge=`Loading a dataset in streaming mode creates a new dataset type instance (instead of the classic <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object), known as an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
This special type of dataset has its own set of processing methods shown below.`,ia,Z,ra,N,ca,Q,Ie='If you have an existing <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can convert it to an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function. This is actually faster than setting the <code>streaming=True</code> argument in <a href="/docs/datasets/v2.19.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> because the data is streamed from local files.',da,H,ha,D,Re='The <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function supports sharding when the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is instantiated. This is useful when working with big datasets, and you’d like to shuffle the dataset or to enable fast parallel loading with a PyTorch DataLoader.',ma,L,oa,S,fa,A,Xe='Like a regular <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can also shuffle a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.',ua,E,Ce='The <code>buffer_size</code> argument controls the size of the buffer to randomly sample examples from. Let’s say your dataset has one million examples, and you set the <code>buffer_size</code> to ten thousand. <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will randomly select examples from the first ten thousand examples in the buffer. Selected examples in the buffer are replaced with new examples. By default, the buffer size is 1,000.',ga,q,ja,v,Ma,K,ba,P,Fe="Sometimes you may want to reshuffle the dataset after each epoch. This will require you to set a different seed for each epoch. Use <code>IterableDataset.set_epoch()</code> in between epochs to tell the dataset what epoch you’re on.",ya,O,We="Your seed effectively becomes: <code>initial seed + current epoch</code>.",wa,ss,Ta,as,xa,es,Ve="You can split your dataset one of two ways:",Ja,ts,Ye='<li><a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> returns the first <code>n</code> examples in a dataset:</li>',$a,ls,_a,ns,ze='<li><a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.skip">IterableDataset.skip()</a> omits the first <code>n</code> examples in a dataset and returns the remaining examples:</li>',ka,ps,Za,U,va,Es,Ua,is,Ga,rs,Be='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> can combine an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with other datasets. The combined dataset returns alternating examples from each of the original datasets.',Ia,cs,Ra,ds,Ne="Define sampling probabilities from each of the original datasets for more control over how each of them are sampled and combined. Set the <code>probabilities</code> argument with your desired sampling probabilities:",Xa,hs,Ca,ms,Qe="Around 80% of the final dataset is made of the <code>en_dataset</code>, and 20% of the <code>fr_dataset</code>.",Fa,os,He=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,Wa,fs,Va,us,De="The following methods allow you to modify the columns of a dataset. These methods are useful for renaming or removing columns and changing columns to a new set of features.",Ya,gs,za,js,Le='Use <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',Ba,Ms,Se='Provide <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> with the name of the original column, and the new column name:',Na,bs,Qa,ys,Ha,ws,Ae='When you need to remove one or more columns, give <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.remove_columns">IterableDataset.remove_columns()</a> the name of the column to remove. Remove more than one column by providing a list of column names:',Da,Ts,La,xs,Sa,Js,Ee='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.cast">IterableDataset.cast()</a> changes the feature type of one or more columns. This method takes your new <code>Features</code> as its argument. The following sample code shows how to change the feature types of <code>ClassLabel</code> and <code>Value</code>:',Aa,$s,Ea,G,qa,_s,qe='Use <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.cast_column">IterableDataset.cast_column()</a> to change the feature type of just one column. Pass the column name and its new feature type as arguments:',Ka,ks,Pa,Zs,Oa,vs,Ke=`Similar to the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a> function for a regular <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, 🤗  Datasets features <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> for processing an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> applies processing on-the-fly when examples are streamed.`,se,Us,Pe="It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.",ae,Gs,Oe='The following example demonstrates how to tokenize a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. The function needs to accept and output a <code>dict</code>:',ee,Is,te,Rs,st='Next, apply this function to the dataset with <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',le,Xs,ne,Cs,at='Let’s take a look at another example, except this time, you will remove a column with <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',pe,Fs,et='Specify the column to remove with the <code>remove_columns</code> argument in <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',ie,Ws,re,Vs,ce,Ys,tt='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> also supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> argument. This opens the door to many interesting applications such as tokenization, splitting long sentences into shorter chunks, and data augmentation.',de,zs,he,Bs,me,I,oe,Ns,fe,Qs,lt='You can filter rows in the dataset based on a predicate function using <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a>. It returns rows that match a specified condition:',ue,Hs,ge,Ds,nt='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',je,Ls,Me,Ss,be,As,pt='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> can be integrated into a training loop. First, shuffle the dataset:',ye,R,we,Ks,Te;return T=new x({props:{title:"Stream",local:"stream",headingTag:"h1"}}),F=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXItY29ycHVzJTJGT1NDQVItMjIwMSclMkMlMjAnZW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar-corpus/OSCAR-2201&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3Qid0cmFpbiclM0ElMjAncGF0aCUyRnRvJTJGT1NDQVItMjIwMSUyRmNvbXByZXNzZWQlMkZlbl9tZXRhJTJGKi5qc29ubC5neiclN0QlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdqc29uJyUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;path/to/OSCAR-2201/compressed/en_meta/*.jsonl.gz&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;json&#x27;</span>, data_files=data_files, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),Z=new Ps({props:{$$slots:{default:[wt]},$$scope:{ctx:w}}}),N=new x({props:{title:"Convert from a Dataset",local:"convert-from-a-dataset",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKSUwQSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># faster 🐇</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()

<span class="hljs-comment"># slower 🐢</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, streaming=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZvb2QxMDElMjIpJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNENjQpJTIwJTIzJTIwc2hhcmQlMjB0aGUlMjBkYXRhc2V0JTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGl0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShidWZmZXJfc2l6ZSUzRDEwXzAwMCklMjAlMjAlMjMlMjBzaHVmZmxlcyUyMHRoZSUyMHNoYXJkcyUyMG9yZGVyJTIwYW5kJTIwdXNlJTIwYSUyMHNodWZmbGUlMjBidWZmZXIlMjB3aGVuJTIweW91JTIwc3RhcnQlMjBpdGVyYXRpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">64</span>) <span class="hljs-comment"># shard the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = iterable_dataset.shuffle(buffer_size=<span class="hljs-number">10_000</span>)  <span class="hljs-comment"># shuffles the shards order and use a shuffle buffer when you start iterating</span>
dataloader = torch.utils.data.DataLoader(iterable_dataset, num_workers=<span class="hljs-number">4</span>)  <span class="hljs-comment"># assigns 64 / 4 = 16 shards from the shuffled list of shards to each worker when you start iterating</span>`,wrap:!1}}),S=new x({props:{title:"Shuffle",local:"shuffle",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQXNodWZmbGVkX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMF8wMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">10_000</span>)`,wrap:!1}}),v=new Ps({props:{$$slots:{default:[Tt]},$$scope:{ctx:w}}}),K=new x({props:{title:"Reshuffle",local:"reshuffle",headingTag:"h2"}}),ss=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGVwb2NocyklM0ElMEElMjAlMjAlMjAlMjBzaHVmZmxlZF9kYXRhc2V0LnNldF9lcG9jaChlcG9jaCklMEElMjAlMjAlMjAlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBzaHVmZmxlZF9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
<span class="hljs-meta">... </span>    shuffled_dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> shuffled_dataset:
<span class="hljs-meta">... </span>        ...`,wrap:!1}}),as=new x({props:{title:"Split dataset",local:"split-dataset",headingTag:"h2"}}),ls=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXRfaGVhZCUyMCUzRCUyMGRhdGFzZXQudGFrZSgyKSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_head = dataset.take(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(dataset_head)
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was...&#x27;</span>}, {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),ps=new y({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHNodWZmbGVkX2RhdGFzZXQuc2tpcCgxMDAwKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)',wrap:!1}}),U=new Ps({props:{warning:!0,$$slots:{default:[xt]},$$scope:{ctx:w}}}),is=new x({props:{title:"Interleave",local:"interleave",headingTag:"h2"}}),cs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyUwQWVuX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ29zY2FyJyUyQyUyMCUyMnVuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJTIyJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFmcl9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdvc2NhciclMkMlMjAlMjJ1bnNodWZmbGVkX2RlZHVwbGljYXRlZF9mciUyMiUyQyUyMHNwbGl0JTNEJ3RyYWluJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBbXVsdGlsaW5ndWFsX2RhdGFzZXQlMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEKSUwQWxpc3QobXVsdGlsaW5ndWFsX2RhdGFzZXQudGFrZSgyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>en_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fr_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_fr&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset = interleave_datasets([en_dataset, fr_dataset])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Média de débat d&#x27;idées, de culture et de littérature...&quot;</span>}]`,wrap:!1}}),hs=new y({props:{code:"bXVsdGlsaW5ndWFsX2RhdGFzZXRfd2l0aF9vdmVyc2FtcGxpbmclMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEJTJDJTIwcHJvYmFiaWxpdGllcyUzRCU1QjAuOCUyQyUyMDAuMiU1RCUyQyUyMHNlZWQlM0Q0MiklMEFsaXN0KG11bHRpbGluZ3VhbF9kYXRhc2V0X3dpdGhfb3ZlcnNhbXBsaW5nLnRha2UoMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset_with_oversampling = interleave_datasets([en_dataset, fr_dataset], probabilities=[<span class="hljs-number">0.8</span>, <span class="hljs-number">0.2</span>], seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset_with_oversampling.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),fs=new x({props:{title:"Rename, remove, and cast",local:"rename-remove-and-cast",headingTag:"h2"}}),gs=new x({props:{title:"Rename",local:"rename",headingTag:"h3"}}),bs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIydGV4dCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>)`,wrap:!1}}),ys=new x({props:{title:"Remove",local:"remove",headingTag:"h3"}}),Ts=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCd0aW1lc3RhbXAnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&#x27;timestamp&#x27;</span>)`,wrap:!1}}),xs=new x({props:{title:"Cast",local:"cast",headingTag:"h3"}}),$s=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYyclMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXQuZmVhdHVyZXMlMEElMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBDbGFzc0xhYmVsJTJDJTIwVmFsdWUlMEFuZXdfZmVhdHVyZXMlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzLmNvcHkoKSUwQW5ld19mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwQ2xhc3NMYWJlbChuYW1lcyUzRCU1QiduZWdhdGl2ZSclMkMlMjAncG9zaXRpdmUnJTVEKSUwQW5ld19mZWF0dXJlcyU1QiUyMmlkeCUyMiU1RCUyMCUzRCUyMFZhbHVlKCdpbnQ2NCcpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdChuZXdfZmVhdHVyZXMpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&#x27;int64&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),G=new Ps({props:{$$slots:{default:[Jt]},$$scope:{ctx:w}}}),ks=new y({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Zs=new x({props:{title:"Map",local:"map",headingTag:"h2"}}),Is=new y({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIndGV4dCclNUQlMjAlM0QlMjAnTXklMjB0ZXh0JTNBJTIwJyUyMCUyQiUyMGV4YW1wbGUlNUIndGV4dCclNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&#x27;text&#x27;</span>] = <span class="hljs-string">&#x27;My text: &#x27;</span> + example[<span class="hljs-string">&#x27;text&#x27;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Xs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEFsaXN0KHVwZGF0ZWRfZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Ws=new y({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyaWQlMjIlNUQpJTBBbGlzdCh1cGRhdGVkX2RhdGFzZXQudGFrZSgzKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix, remove_columns=[<span class="hljs-string">&quot;id&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Vs=new x({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),zs=new x({props:{title:"Tokenization",local:"tokenization",headingTag:"h4"}}),Bs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm1jNCUyMiUyQyUyMCUyMmVuJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyklMEFkZWYlMjBlbmNvZGUoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJ3RleHQnJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChlbmNvZGUlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUyQyUyMCUyMnVybCUyMiU1RCklMEFuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mc4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&#x27;text&#x27;</span>], truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&#x27;max_length&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(encode, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;timestamp&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">8466</span>, <span class="hljs-number">1018</span>, <span class="hljs-number">1010</span>, <span class="hljs-number">4029</span>, <span class="hljs-number">2475</span>, <span class="hljs-number">2062</span>, <span class="hljs-number">18558</span>, <span class="hljs-number">3100</span>, <span class="hljs-number">2061</span>, ...,<span class="hljs-number">1106</span>, <span class="hljs-number">3739</span>, <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),I=new Ps({props:{$$slots:{default:[$t]},$$scope:{ctx:w}}}),Ns=new x({props:{title:"Filter",local:"filter",headingTag:"h3"}}),Hs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBc3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJ3RleHQnJTVELnN0YXJ0c3dpdGgoJ0FyJykpJTBBbmV4dChpdGVyKHN0YXJ0X3dpdGhfYXIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&#x27;text&#x27;</span>].startswith(<span class="hljs-string">&#x27;Ar&#x27;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(start_with_ar))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)?...&#x27;</span>}`,wrap:!1}}),Ls=new y({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsaXN0KGV2ZW5fZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(even_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision of Chief Napoleon Dzombe, ...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;&quot;I\\&#x27;d love to help kickstart continued development! And 0 EUR/month...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)? Normally, ...&#x27;</span>}]`,wrap:!1}}),Ss=new x({props:{title:"Stream in a training loop",local:"stream-in-a-training-loop",headingTag:"h2"}}),R=new bt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[kt]},$$scope:{ctx:w}}}),{c(){p=r("meta"),j=l(),i=r("p"),b=l(),d(T.$$.fragment),J=l(),$=r("p"),$.textContent=M,_=l(),X=r("ul"),X.innerHTML=$e,Os=l(),k=r("div"),k.innerHTML=_e,sa=l(),C=r("p"),C.innerHTML=ke,aa=l(),d(F.$$.fragment),ea=l(),W=r("p"),W.textContent=Ze,ta=l(),V=r("ul"),V.innerHTML=ve,la=l(),Y=r("p"),Y.innerHTML=Ue,na=l(),d(z.$$.fragment),pa=l(),B=r("p"),B.innerHTML=Ge,ia=l(),d(Z.$$.fragment),ra=l(),d(N.$$.fragment),ca=l(),Q=r("p"),Q.innerHTML=Ie,da=l(),d(H.$$.fragment),ha=l(),D=r("p"),D.innerHTML=Re,ma=l(),d(L.$$.fragment),oa=l(),d(S.$$.fragment),fa=l(),A=r("p"),A.innerHTML=Xe,ua=l(),E=r("p"),E.innerHTML=Ce,ga=l(),d(q.$$.fragment),ja=l(),d(v.$$.fragment),Ma=l(),d(K.$$.fragment),ba=l(),P=r("p"),P.innerHTML=Fe,ya=l(),O=r("p"),O.innerHTML=We,wa=l(),d(ss.$$.fragment),Ta=l(),d(as.$$.fragment),xa=l(),es=r("p"),es.textContent=Ve,Ja=l(),ts=r("ul"),ts.innerHTML=Ye,$a=l(),d(ls.$$.fragment),_a=l(),ns=r("ul"),ns.innerHTML=ze,ka=l(),d(ps.$$.fragment),Za=l(),d(U.$$.fragment),va=l(),Es=r("a"),Ua=l(),d(is.$$.fragment),Ga=l(),rs=r("p"),rs.innerHTML=Be,Ia=l(),d(cs.$$.fragment),Ra=l(),ds=r("p"),ds.innerHTML=Ne,Xa=l(),d(hs.$$.fragment),Ca=l(),ms=r("p"),ms.innerHTML=Qe,Fa=l(),os=r("p"),os.innerHTML=He,Wa=l(),d(fs.$$.fragment),Va=l(),us=r("p"),us.textContent=De,Ya=l(),d(gs.$$.fragment),za=l(),js=r("p"),js.innerHTML=Le,Ba=l(),Ms=r("p"),Ms.innerHTML=Se,Na=l(),d(bs.$$.fragment),Qa=l(),d(ys.$$.fragment),Ha=l(),ws=r("p"),ws.innerHTML=Ae,Da=l(),d(Ts.$$.fragment),La=l(),d(xs.$$.fragment),Sa=l(),Js=r("p"),Js.innerHTML=Ee,Aa=l(),d($s.$$.fragment),Ea=l(),d(G.$$.fragment),qa=l(),_s=r("p"),_s.innerHTML=qe,Ka=l(),d(ks.$$.fragment),Pa=l(),d(Zs.$$.fragment),Oa=l(),vs=r("p"),vs.innerHTML=Ke,se=l(),Us=r("p"),Us.textContent=Pe,ae=l(),Gs=r("p"),Gs.innerHTML=Oe,ee=l(),d(Is.$$.fragment),te=l(),Rs=r("p"),Rs.innerHTML=st,le=l(),d(Xs.$$.fragment),ne=l(),Cs=r("p"),Cs.innerHTML=at,pe=l(),Fs=r("p"),Fs.innerHTML=et,ie=l(),d(Ws.$$.fragment),re=l(),d(Vs.$$.fragment),ce=l(),Ys=r("p"),Ys.innerHTML=tt,de=l(),d(zs.$$.fragment),he=l(),d(Bs.$$.fragment),me=l(),d(I.$$.fragment),oe=l(),d(Ns.$$.fragment),fe=l(),Qs=r("p"),Qs.innerHTML=lt,ue=l(),d(Hs.$$.fragment),ge=l(),Ds=r("p"),Ds.innerHTML=nt,je=l(),d(Ls.$$.fragment),Me=l(),d(Ss.$$.fragment),be=l(),As=r("p"),As.innerHTML=pt,ye=l(),d(R.$$.fragment),we=l(),Ks=r("p"),this.h()},l(s){const a=jt("svelte-u9bgzb",document.head);p=c(a,"META",{name:!0,content:!0}),a.forEach(e),j=n(s),i=c(s,"P",{}),Je(i).forEach(e),b=n(s),h(T.$$.fragment,s),J=n(s),$=c(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-1sf84jt"&&($.textContent=M),_=n(s),X=c(s,"UL",{"data-svelte-h":!0}),g(X)!=="svelte-1y6qvic"&&(X.innerHTML=$e),Os=n(s),k=c(s,"DIV",{class:!0,"data-svelte-h":!0}),g(k)!=="svelte-p91s8d"&&(k.innerHTML=_e),sa=n(s),C=c(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-a9a51q"&&(C.innerHTML=ke),aa=n(s),h(F.$$.fragment,s),ea=n(s),W=c(s,"P",{"data-svelte-h":!0}),g(W)!=="svelte-xdwdpa"&&(W.textContent=Ze),ta=n(s),V=c(s,"UL",{"data-svelte-h":!0}),g(V)!=="svelte-lffs3"&&(V.innerHTML=ve),la=n(s),Y=c(s,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1newt0m"&&(Y.innerHTML=Ue),na=n(s),h(z.$$.fragment,s),pa=n(s),B=c(s,"P",{"data-svelte-h":!0}),g(B)!=="svelte-twu6bo"&&(B.innerHTML=Ge),ia=n(s),h(Z.$$.fragment,s),ra=n(s),h(N.$$.fragment,s),ca=n(s),Q=c(s,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1iofyue"&&(Q.innerHTML=Ie),da=n(s),h(H.$$.fragment,s),ha=n(s),D=c(s,"P",{"data-svelte-h":!0}),g(D)!=="svelte-nafsbb"&&(D.innerHTML=Re),ma=n(s),h(L.$$.fragment,s),oa=n(s),h(S.$$.fragment,s),fa=n(s),A=c(s,"P",{"data-svelte-h":!0}),g(A)!=="svelte-28lby8"&&(A.innerHTML=Xe),ua=n(s),E=c(s,"P",{"data-svelte-h":!0}),g(E)!=="svelte-e2n9es"&&(E.innerHTML=Ce),ga=n(s),h(q.$$.fragment,s),ja=n(s),h(v.$$.fragment,s),Ma=n(s),h(K.$$.fragment,s),ba=n(s),P=c(s,"P",{"data-svelte-h":!0}),g(P)!=="svelte-l7znh1"&&(P.innerHTML=Fe),ya=n(s),O=c(s,"P",{"data-svelte-h":!0}),g(O)!=="svelte-flznjz"&&(O.innerHTML=We),wa=n(s),h(ss.$$.fragment,s),Ta=n(s),h(as.$$.fragment,s),xa=n(s),es=c(s,"P",{"data-svelte-h":!0}),g(es)!=="svelte-1y9p9l9"&&(es.textContent=Ve),Ja=n(s),ts=c(s,"UL",{"data-svelte-h":!0}),g(ts)!=="svelte-cye2ky"&&(ts.innerHTML=Ye),$a=n(s),h(ls.$$.fragment,s),_a=n(s),ns=c(s,"UL",{"data-svelte-h":!0}),g(ns)!=="svelte-1svly2b"&&(ns.innerHTML=ze),ka=n(s),h(ps.$$.fragment,s),Za=n(s),h(U.$$.fragment,s),va=n(s),Es=c(s,"A",{id:!0}),Je(Es).forEach(e),Ua=n(s),h(is.$$.fragment,s),Ga=n(s),rs=c(s,"P",{"data-svelte-h":!0}),g(rs)!=="svelte-1on6n9e"&&(rs.innerHTML=Be),Ia=n(s),h(cs.$$.fragment,s),Ra=n(s),ds=c(s,"P",{"data-svelte-h":!0}),g(ds)!=="svelte-1t5oa18"&&(ds.innerHTML=Ne),Xa=n(s),h(hs.$$.fragment,s),Ca=n(s),ms=c(s,"P",{"data-svelte-h":!0}),g(ms)!=="svelte-1oi4bk"&&(ms.innerHTML=Qe),Fa=n(s),os=c(s,"P",{"data-svelte-h":!0}),g(os)!=="svelte-13euv56"&&(os.innerHTML=He),Wa=n(s),h(fs.$$.fragment,s),Va=n(s),us=c(s,"P",{"data-svelte-h":!0}),g(us)!=="svelte-mlzv10"&&(us.textContent=De),Ya=n(s),h(gs.$$.fragment,s),za=n(s),js=c(s,"P",{"data-svelte-h":!0}),g(js)!=="svelte-1mhpi75"&&(js.innerHTML=Le),Ba=n(s),Ms=c(s,"P",{"data-svelte-h":!0}),g(Ms)!=="svelte-1tlk8pk"&&(Ms.innerHTML=Se),Na=n(s),h(bs.$$.fragment,s),Qa=n(s),h(ys.$$.fragment,s),Ha=n(s),ws=c(s,"P",{"data-svelte-h":!0}),g(ws)!=="svelte-1cmgwfh"&&(ws.innerHTML=Ae),Da=n(s),h(Ts.$$.fragment,s),La=n(s),h(xs.$$.fragment,s),Sa=n(s),Js=c(s,"P",{"data-svelte-h":!0}),g(Js)!=="svelte-18drud7"&&(Js.innerHTML=Ee),Aa=n(s),h($s.$$.fragment,s),Ea=n(s),h(G.$$.fragment,s),qa=n(s),_s=c(s,"P",{"data-svelte-h":!0}),g(_s)!=="svelte-1vhpqxh"&&(_s.innerHTML=qe),Ka=n(s),h(ks.$$.fragment,s),Pa=n(s),h(Zs.$$.fragment,s),Oa=n(s),vs=c(s,"P",{"data-svelte-h":!0}),g(vs)!=="svelte-1bgmov4"&&(vs.innerHTML=Ke),se=n(s),Us=c(s,"P",{"data-svelte-h":!0}),g(Us)!=="svelte-1rfoeeh"&&(Us.textContent=Pe),ae=n(s),Gs=c(s,"P",{"data-svelte-h":!0}),g(Gs)!=="svelte-4ghvwz"&&(Gs.innerHTML=Oe),ee=n(s),h(Is.$$.fragment,s),te=n(s),Rs=c(s,"P",{"data-svelte-h":!0}),g(Rs)!=="svelte-109v40w"&&(Rs.innerHTML=st),le=n(s),h(Xs.$$.fragment,s),ne=n(s),Cs=c(s,"P",{"data-svelte-h":!0}),g(Cs)!=="svelte-1ro4pkd"&&(Cs.innerHTML=at),pe=n(s),Fs=c(s,"P",{"data-svelte-h":!0}),g(Fs)!=="svelte-1ofzgpe"&&(Fs.innerHTML=et),ie=n(s),h(Ws.$$.fragment,s),re=n(s),h(Vs.$$.fragment,s),ce=n(s),Ys=c(s,"P",{"data-svelte-h":!0}),g(Ys)!=="svelte-155c2k2"&&(Ys.innerHTML=tt),de=n(s),h(zs.$$.fragment,s),he=n(s),h(Bs.$$.fragment,s),me=n(s),h(I.$$.fragment,s),oe=n(s),h(Ns.$$.fragment,s),fe=n(s),Qs=c(s,"P",{"data-svelte-h":!0}),g(Qs)!=="svelte-gr5wco"&&(Qs.innerHTML=lt),ue=n(s),h(Hs.$$.fragment,s),ge=n(s),Ds=c(s,"P",{"data-svelte-h":!0}),g(Ds)!=="svelte-1ftvu6i"&&(Ds.innerHTML=nt),je=n(s),h(Ls.$$.fragment,s),Me=n(s),h(Ss.$$.fragment,s),be=n(s),As=c(s,"P",{"data-svelte-h":!0}),g(As)!=="svelte-a9v79j"&&(As.innerHTML=pt),ye=n(s),h(R.$$.fragment,s),we=n(s),Ks=c(s,"P",{}),Je(Ks).forEach(e),this.h()},h(){xe(p,"name","hf:doc:metadata"),xe(p,"content",vt),xe(k,"class","flex justify-center"),xe(Es,"id","interleave_datasets")},m(s,a){Mt(document.head,p),t(s,j,a),t(s,i,a),t(s,b,a),m(T,s,a),t(s,J,a),t(s,$,a),t(s,_,a),t(s,X,a),t(s,Os,a),t(s,k,a),t(s,sa,a),t(s,C,a),t(s,aa,a),m(F,s,a),t(s,ea,a),t(s,W,a),t(s,ta,a),t(s,V,a),t(s,la,a),t(s,Y,a),t(s,na,a),m(z,s,a),t(s,pa,a),t(s,B,a),t(s,ia,a),m(Z,s,a),t(s,ra,a),m(N,s,a),t(s,ca,a),t(s,Q,a),t(s,da,a),m(H,s,a),t(s,ha,a),t(s,D,a),t(s,ma,a),m(L,s,a),t(s,oa,a),m(S,s,a),t(s,fa,a),t(s,A,a),t(s,ua,a),t(s,E,a),t(s,ga,a),m(q,s,a),t(s,ja,a),m(v,s,a),t(s,Ma,a),m(K,s,a),t(s,ba,a),t(s,P,a),t(s,ya,a),t(s,O,a),t(s,wa,a),m(ss,s,a),t(s,Ta,a),m(as,s,a),t(s,xa,a),t(s,es,a),t(s,Ja,a),t(s,ts,a),t(s,$a,a),m(ls,s,a),t(s,_a,a),t(s,ns,a),t(s,ka,a),m(ps,s,a),t(s,Za,a),m(U,s,a),t(s,va,a),t(s,Es,a),t(s,Ua,a),m(is,s,a),t(s,Ga,a),t(s,rs,a),t(s,Ia,a),m(cs,s,a),t(s,Ra,a),t(s,ds,a),t(s,Xa,a),m(hs,s,a),t(s,Ca,a),t(s,ms,a),t(s,Fa,a),t(s,os,a),t(s,Wa,a),m(fs,s,a),t(s,Va,a),t(s,us,a),t(s,Ya,a),m(gs,s,a),t(s,za,a),t(s,js,a),t(s,Ba,a),t(s,Ms,a),t(s,Na,a),m(bs,s,a),t(s,Qa,a),m(ys,s,a),t(s,Ha,a),t(s,ws,a),t(s,Da,a),m(Ts,s,a),t(s,La,a),m(xs,s,a),t(s,Sa,a),t(s,Js,a),t(s,Aa,a),m($s,s,a),t(s,Ea,a),m(G,s,a),t(s,qa,a),t(s,_s,a),t(s,Ka,a),m(ks,s,a),t(s,Pa,a),m(Zs,s,a),t(s,Oa,a),t(s,vs,a),t(s,se,a),t(s,Us,a),t(s,ae,a),t(s,Gs,a),t(s,ee,a),m(Is,s,a),t(s,te,a),t(s,Rs,a),t(s,le,a),m(Xs,s,a),t(s,ne,a),t(s,Cs,a),t(s,pe,a),t(s,Fs,a),t(s,ie,a),m(Ws,s,a),t(s,re,a),m(Vs,s,a),t(s,ce,a),t(s,Ys,a),t(s,de,a),m(zs,s,a),t(s,he,a),m(Bs,s,a),t(s,me,a),m(I,s,a),t(s,oe,a),m(Ns,s,a),t(s,fe,a),t(s,Qs,a),t(s,ue,a),m(Hs,s,a),t(s,ge,a),t(s,Ds,a),t(s,je,a),m(Ls,s,a),t(s,Me,a),m(Ss,s,a),t(s,be,a),t(s,As,a),t(s,ye,a),m(R,s,a),t(s,we,a),t(s,Ks,a),Te=!0},p(s,[a]){const it={};a&2&&(it.$$scope={dirty:a,ctx:s}),Z.$set(it);const rt={};a&2&&(rt.$$scope={dirty:a,ctx:s}),v.$set(rt);const ct={};a&2&&(ct.$$scope={dirty:a,ctx:s}),U.$set(ct);const dt={};a&2&&(dt.$$scope={dirty:a,ctx:s}),G.$set(dt);const ht={};a&2&&(ht.$$scope={dirty:a,ctx:s}),I.$set(ht);const mt={};a&2&&(mt.$$scope={dirty:a,ctx:s}),R.$set(mt)},i(s){Te||(o(T.$$.fragment,s),o(F.$$.fragment,s),o(z.$$.fragment,s),o(Z.$$.fragment,s),o(N.$$.fragment,s),o(H.$$.fragment,s),o(L.$$.fragment,s),o(S.$$.fragment,s),o(q.$$.fragment,s),o(v.$$.fragment,s),o(K.$$.fragment,s),o(ss.$$.fragment,s),o(as.$$.fragment,s),o(ls.$$.fragment,s),o(ps.$$.fragment,s),o(U.$$.fragment,s),o(is.$$.fragment,s),o(cs.$$.fragment,s),o(hs.$$.fragment,s),o(fs.$$.fragment,s),o(gs.$$.fragment,s),o(bs.$$.fragment,s),o(ys.$$.fragment,s),o(Ts.$$.fragment,s),o(xs.$$.fragment,s),o($s.$$.fragment,s),o(G.$$.fragment,s),o(ks.$$.fragment,s),o(Zs.$$.fragment,s),o(Is.$$.fragment,s),o(Xs.$$.fragment,s),o(Ws.$$.fragment,s),o(Vs.$$.fragment,s),o(zs.$$.fragment,s),o(Bs.$$.fragment,s),o(I.$$.fragment,s),o(Ns.$$.fragment,s),o(Hs.$$.fragment,s),o(Ls.$$.fragment,s),o(Ss.$$.fragment,s),o(R.$$.fragment,s),Te=!0)},o(s){f(T.$$.fragment,s),f(F.$$.fragment,s),f(z.$$.fragment,s),f(Z.$$.fragment,s),f(N.$$.fragment,s),f(H.$$.fragment,s),f(L.$$.fragment,s),f(S.$$.fragment,s),f(q.$$.fragment,s),f(v.$$.fragment,s),f(K.$$.fragment,s),f(ss.$$.fragment,s),f(as.$$.fragment,s),f(ls.$$.fragment,s),f(ps.$$.fragment,s),f(U.$$.fragment,s),f(is.$$.fragment,s),f(cs.$$.fragment,s),f(hs.$$.fragment,s),f(fs.$$.fragment,s),f(gs.$$.fragment,s),f(bs.$$.fragment,s),f(ys.$$.fragment,s),f(Ts.$$.fragment,s),f(xs.$$.fragment,s),f($s.$$.fragment,s),f(G.$$.fragment,s),f(ks.$$.fragment,s),f(Zs.$$.fragment,s),f(Is.$$.fragment,s),f(Xs.$$.fragment,s),f(Ws.$$.fragment,s),f(Vs.$$.fragment,s),f(zs.$$.fragment,s),f(Bs.$$.fragment,s),f(I.$$.fragment,s),f(Ns.$$.fragment,s),f(Hs.$$.fragment,s),f(Ls.$$.fragment,s),f(Ss.$$.fragment,s),f(R.$$.fragment,s),Te=!1},d(s){s&&(e(j),e(i),e(b),e(J),e($),e(_),e(X),e(Os),e(k),e(sa),e(C),e(aa),e(ea),e(W),e(ta),e(V),e(la),e(Y),e(na),e(pa),e(B),e(ia),e(ra),e(ca),e(Q),e(da),e(ha),e(D),e(ma),e(oa),e(fa),e(A),e(ua),e(E),e(ga),e(ja),e(Ma),e(ba),e(P),e(ya),e(O),e(wa),e(Ta),e(xa),e(es),e(Ja),e(ts),e($a),e(_a),e(ns),e(ka),e(Za),e(va),e(Es),e(Ua),e(Ga),e(rs),e(Ia),e(Ra),e(ds),e(Xa),e(Ca),e(ms),e(Fa),e(os),e(Wa),e(Va),e(us),e(Ya),e(za),e(js),e(Ba),e(Ms),e(Na),e(Qa),e(Ha),e(ws),e(Da),e(La),e(Sa),e(Js),e(Aa),e(Ea),e(qa),e(_s),e(Ka),e(Pa),e(Oa),e(vs),e(se),e(Us),e(ae),e(Gs),e(ee),e(te),e(Rs),e(le),e(ne),e(Cs),e(pe),e(Fs),e(ie),e(re),e(ce),e(Ys),e(de),e(he),e(me),e(oe),e(fe),e(Qs),e(ue),e(ge),e(Ds),e(je),e(Me),e(be),e(As),e(ye),e(we),e(Ks)),e(p),u(T,s),u(F,s),u(z,s),u(Z,s),u(N,s),u(H,s),u(L,s),u(S,s),u(q,s),u(v,s),u(K,s),u(ss,s),u(as,s),u(ls,s),u(ps,s),u(U,s),u(is,s),u(cs,s),u(hs,s),u(fs,s),u(gs,s),u(bs,s),u(ys,s),u(Ts,s),u(xs,s),u($s,s),u(G,s),u(ks,s),u(Zs,s),u(Is,s),u(Xs,s),u(Ws,s),u(Vs,s),u(zs,s),u(Bs,s),u(I,s),u(Ns,s),u(Hs,s),u(Ls,s),u(Ss,s),u(R,s)}}}const vt='{"title":"Stream","local":"stream","sections":[{"title":"Convert from a Dataset","local":"convert-from-a-dataset","sections":[],"depth":2},{"title":"Shuffle","local":"shuffle","sections":[],"depth":2},{"title":"Reshuffle","local":"reshuffle","sections":[],"depth":2},{"title":"Split dataset","local":"split-dataset","sections":[],"depth":2},{"title":"Interleave","local":"interleave","sections":[],"depth":2},{"title":"Rename, remove, and cast","local":"rename-remove-and-cast","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Tokenization","local":"tokenization","sections":[],"depth":4}],"depth":3},{"title":"Filter","local":"filter","sections":[],"depth":3}],"depth":2},{"title":"Stream in a training loop","local":"stream-in-a-training-loop","sections":[],"depth":2}],"depth":1}';function Ut(w){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends ut{constructor(p){super(),gt(this,p,Ut,Zt,ot,{})}}export{Wt as component};
