import{s as $t,n as yt,o as wt}from"../chunks/scheduler.bdbef820.js";import{S as bt,i as vt,g as l,s as i,r as u,A as Tt,h as o,f as s,c as n,j as ft,u as c,x as r,k as gt,y as Mt,a,v as p,d as h,t as d,w as m}from"../chunks/index.c0aea24a.js";import{C as Ae}from"../chunks/CodeBlock.6ccca92e.js";import{H as f}from"../chunks/Heading.2eb892cb.js";function _t(Qe){let g,ie,se,ne,$,le,y,We=`This guide aims to provide you the tools and knowledge required to navigate some common issues. If the suggestions listed
in this guide do not cover your such situation, please refer to the <a href="#asking-for-help">Asking for Help</a> section to learn where to
find help with your specific issue.`,oe,w,re,b,ue,v,ze=`If you are experiencing authentication issues when sharing a dataset on 🤗 Hub using <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.push_to_hub">Dataset.push_to_hub()</a> and a Hugging Face
access token:`,ce,T,Ne="<li>Make sure that the Hugging Face token you’re using to authenticate yourself is a token with <strong>write</strong> permission.</li> <li>On OSX, it may help to clean up all the huggingface.co passwords on your keychain access, as well as reconfigure <code>git config --global credential.helper osxkeychain</code>, before using <code>huggingface-cli login</code>.</li>",pe,M,Ve='Alternatively, you can use SSH keys to authenticate yourself - read more in the <a href="https://huggingface.co/docs/hub/security-git-ssh" rel="nofollow">🤗 Hub documentation</a>.',he,_,de,k,Oe=`When uploading large datasets to Hub, if the number of dataset shards is large, it can create too many commits for the Hub in a
short period. This will result in a connection error.
The connection error can also be caused by a HTTP 500 error returned by AWS S3 bucket that Hub uses internally.
In either situation, you can re-run <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.push_to_hub">Dataset.push_to_hub()</a> to proceed with the dataset upload. Hub will check the SHAs
of already uploaded shards to avoid reuploading them.
We are working on making upload process more robust to transient errors, so updating to the latest library version is
always a good idea.`,me,H,fe,x,Ke="Uploading large datasets via <code>push_to_hub()</code> can result in an error:",ge,C,$e,U,et="If you encounter this issue, you need to upgrade the <code>datasets</code> library to the latest version (or at least <code>2.15.0</code>).",ye,L,we,I,be,j,tt=`When creating a dataset from a folder, one of the most common issues is that the file structure does not follow the
expected format, or there’s an issue with the metadata file.`,ve,P,st="Learn more about required folder structure in corresponding documentation pages:",Te,J,at='<li><a href="https://huggingface.co/docs/datasets/audio_dataset#audiofolder" rel="nofollow">AudioFolder</a></li> <li><a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow">ImageFolder</a></li>',Me,D,_e,G,ke,S,it=`When creating a dataset, <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.from_generator">IterableDataset.from_generator()</a> and <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.from_generator">Dataset.from_generator()</a> expect a “picklable” generator function.
This is required to hash the function using <a href="https://docs.python.org/3/library/pickle.html" rel="nofollow"><code>pickle</code></a> to be able to cache the dataset on disk.`,He,Z,nt=`While generator functions are generally “picklable”, note that generator objects are not. So if you’re using a generator object,
you will encounter a <code>TypeError</code> like this:`,xe,B,Ce,E,lt=`This error can also occur when using a generator function that uses a global object that is not “picklable”, such as a
DB connection, for example. If that’s the case, you can initialize such object directly inside the generator function to
avoid this error.`,Ue,F,Le,q,ot=`Pickling errors can also happen in the multiprocess <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a> - objects are pickled to be passed to child processes.
If the objects used in the transformation are not picklable, it’s not possible to cache the result of <code>map</code>, which leads to an error being raised.`,Ie,R,rt="Here are some ways to address this issue:",je,X,ut='<li>A universal solution to pickle issues is to make sure the objects (or generator classes) are pickable manually by implementing <code>__getstate__</code> / <code>__setstate__</code> / <code>__reduce__</code>.</li> <li>You can also provide your own unique hash in <code>map</code> with the <code>new_fingerprint</code> argument.</li> <li>You can also disable caching by calling <code>datasets.disable_caching()</code>, however, this is undesirable - <a href="cache">read more about importance of cache</a></li>',Pe,Y,Je,A,ct="If the above troubleshooting advice did not help you resolve your issue, reach out for help to the community and the team.",De,Q,Ge,W,pt=`Ask for help on the Hugging Face forums - post your question in the <a href="https://discuss.huggingface.co/c/datasets/10" rel="nofollow">🤗Datasets category</a>
Make sure to write a descriptive post with relevant context about your setup and reproducible code to maximize the likelihood that your problem is solved!`,Se,z,Ze,N,ht='Post a question on <a href="http://hf.co/join/discord" rel="nofollow">Discord</a>, and let the team and the community help you.',Be,V,Ee,O,dt=`If you are facing issues creating a custom dataset with a script on Hub, you can ask the Hugging Face team for help by opening
a discussion in the Community tab of your dataset with this message:`,Fe,K,qe,ee,Re,te,mt=`Finally, if you suspect to have found a bug related to the library itself, create an Issue on the 🤗 Datasets
<a href="https://github.com/huggingface/datasets/issues" rel="nofollow">GitHub repository</a>. Include context regarding the bug: code snippet to reproduce,
details about your environment and data, etc. to help us figure out what’s wrong and how we can fix it.`,Xe,ae,Ye;return $=new f({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),w=new f({props:{title:"Issues when uploading datasets with push_to_hub",local:"issues-when-uploading-datasets-with-pushtohub",headingTag:"h2"}}),b=new f({props:{title:"Authentication issues",local:"authentication-issues",headingTag:"h3"}}),_=new f({props:{title:"Lost connection on large dataset upload",local:"lost-connection-on-large-dataset-upload",headingTag:"h3"}}),H=new f({props:{title:"Too Many Requests",local:"too-many-requests",headingTag:"h3"}}),C=new Ae({props:{code:"SGZIdWJIVFRQRXJyb3IlM0ElMjA0MjklMjBDbGllbnQlMjBFcnJvciUzQSUyMFRvbyUyME1hbnklMjBSZXF1ZXN0cyUyMGZvciUyMHVybCUzQSUyMC4uLiUwQVlvdSUyMGhhdmUlMjBleGNlZWRlZCUyMG91ciUyMGhvdXJseSUyMHF1b3RhcyUyMGZvciUyMGFjdGlvbiUzQSUyMGNvbW1pdC4lMjBXZSUyMGludml0ZSUyMHlvdSUyMHRvJTIwcmV0cnklMjBsYXRlci4=",highlighted:`HfHubHTTPError: 429 Client Error: Too Many Requests <span class="hljs-keyword">for</span> url: ...
You have exceeded our hourly quotas <span class="hljs-keyword">for</span> action: commit. We invite you to retry later.`,wrap:!1}}),L=new f({props:{title:"Issues when creating datasets from custom data",local:"issues-when-creating-datasets-from-custom-data",headingTag:"h2"}}),I=new f({props:{title:"Loading images and audio from a folder",local:"loading-images-and-audio-from-a-folder",headingTag:"h3"}}),D=new f({props:{title:"Pickling issues",local:"pickling-issues",headingTag:"h3"}}),G=new f({props:{title:"Pickling issues when using Dataset.from_generator",local:"pickling-issues-when-using-datasetfromgenerator",headingTag:"h4"}}),B=new Ae({props:{code:"VHlwZUVycm9yJTNBJTIwY2Fubm90JTIwcGlja2xlJTIwJ2dlbmVyYXRvciclMjBvYmplY3Q=",highlighted:'TypeError: cannot pickle <span class="hljs-string">&#x27;generator&#x27;</span> object',wrap:!1}}),F=new f({props:{title:"Pickling issues with Dataset.map",local:"pickling-issues-with-datasetmap",headingTag:"h4"}}),Y=new f({props:{title:"Asking for help",local:"asking-for-help",headingTag:"h2"}}),Q=new f({props:{title:"Forums",local:"forums",headingTag:"h3"}}),z=new f({props:{title:"Discord",local:"discord",headingTag:"h3"}}),V=new f({props:{title:"Community Discussions on 🤗 Hub",local:"community-discussions-on--hub",headingTag:"h3"}}),K=new Ae({props:{code:"JTIzJTIwRGF0YXNldCUyMHJld2lldyUyMHJlcXVlc3QlMjBmb3IlMjAlM0NEYXRhc2V0JTIwbmFtZSUzRSUwQSUwQSUyMyUyMyUyMERlc2NyaXB0aW9uJTBBJTBBJTNDYnJpZWYlMjBkZXNjcmlwdGlvbiUyMG9mJTIwdGhlJTIwZGF0YXNldCUzRSUwQSUwQSUyMyUyMyUyMEZpbGVzJTIwdG8lMjByZXZpZXclMEElMEEtJTIwZmlsZTElMEEtJTIwZmlsZTIlMEEtJTIwLi4uJTBBJTBBY2MlMjAlNDBsaG9lc3RxJTIwJTQwcG9saW5hZXRlcm5hJTIwJTQwbWFyaW9zYXNrbyUyMCU0MGFsYmVydHZpbGxhbm92YQ==",highlighted:`# Dataset rewiew request for &lt;Dataset name&gt;

## Description

&lt;brief description of the dataset&gt;

## Files to review

- file1
- file2
- ...

cc @lhoestq @polinaeterna @mariosasko @albertvillanova`,wrap:!1}}),ee=new f({props:{title:"GitHub Issues",local:"github-issues",headingTag:"h3"}}),{c(){g=l("meta"),ie=i(),se=l("p"),ne=i(),u($.$$.fragment),le=i(),y=l("p"),y.innerHTML=We,oe=i(),u(w.$$.fragment),re=i(),u(b.$$.fragment),ue=i(),v=l("p"),v.innerHTML=ze,ce=i(),T=l("ul"),T.innerHTML=Ne,pe=i(),M=l("p"),M.innerHTML=Ve,he=i(),u(_.$$.fragment),de=i(),k=l("p"),k.innerHTML=Oe,me=i(),u(H.$$.fragment),fe=i(),x=l("p"),x.innerHTML=Ke,ge=i(),u(C.$$.fragment),$e=i(),U=l("p"),U.innerHTML=et,ye=i(),u(L.$$.fragment),we=i(),u(I.$$.fragment),be=i(),j=l("p"),j.textContent=tt,ve=i(),P=l("p"),P.textContent=st,Te=i(),J=l("ul"),J.innerHTML=at,Me=i(),u(D.$$.fragment),_e=i(),u(G.$$.fragment),ke=i(),S=l("p"),S.innerHTML=it,He=i(),Z=l("p"),Z.innerHTML=nt,xe=i(),u(B.$$.fragment),Ce=i(),E=l("p"),E.textContent=lt,Ue=i(),u(F.$$.fragment),Le=i(),q=l("p"),q.innerHTML=ot,Ie=i(),R=l("p"),R.textContent=rt,je=i(),X=l("ul"),X.innerHTML=ut,Pe=i(),u(Y.$$.fragment),Je=i(),A=l("p"),A.textContent=ct,De=i(),u(Q.$$.fragment),Ge=i(),W=l("p"),W.innerHTML=pt,Se=i(),u(z.$$.fragment),Ze=i(),N=l("p"),N.innerHTML=ht,Be=i(),u(V.$$.fragment),Ee=i(),O=l("p"),O.textContent=dt,Fe=i(),u(K.$$.fragment),qe=i(),u(ee.$$.fragment),Re=i(),te=l("p"),te.innerHTML=mt,Xe=i(),ae=l("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),ie=n(e),se=o(e,"P",{}),ft(se).forEach(s),ne=n(e),c($.$$.fragment,e),le=n(e),y=o(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-wtzssa"&&(y.innerHTML=We),oe=n(e),c(w.$$.fragment,e),re=n(e),c(b.$$.fragment,e),ue=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-fncw3x"&&(v.innerHTML=ze),ce=n(e),T=o(e,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-1rjun7q"&&(T.innerHTML=Ne),pe=n(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-lnijwm"&&(M.innerHTML=Ve),he=n(e),c(_.$$.fragment,e),de=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1d9hqbk"&&(k.innerHTML=Oe),me=n(e),c(H.$$.fragment,e),fe=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18w8g2a"&&(x.innerHTML=Ke),ge=n(e),c(C.$$.fragment,e),$e=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-okquay"&&(U.innerHTML=et),ye=n(e),c(L.$$.fragment,e),we=n(e),c(I.$$.fragment,e),be=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1nemcci"&&(j.textContent=tt),ve=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1bjwb5o"&&(P.textContent=st),Te=n(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-1upvcmt"&&(J.innerHTML=at),Me=n(e),c(D.$$.fragment,e),_e=n(e),c(G.$$.fragment,e),ke=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-6s6mxv"&&(S.innerHTML=it),He=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1drlc3v"&&(Z.innerHTML=nt),xe=n(e),c(B.$$.fragment,e),Ce=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-18tjciu"&&(E.textContent=lt),Ue=n(e),c(F.$$.fragment,e),Le=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-140ninq"&&(q.innerHTML=ot),Ie=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-18m3iu6"&&(R.textContent=rt),je=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1d6loxh"&&(X.innerHTML=ut),Pe=n(e),c(Y.$$.fragment,e),Je=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-kruaya"&&(A.textContent=ct),De=n(e),c(Q.$$.fragment,e),Ge=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vitubn"&&(W.innerHTML=pt),Se=n(e),c(z.$$.fragment,e),Ze=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-qmbfjm"&&(N.innerHTML=ht),Be=n(e),c(V.$$.fragment,e),Ee=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1d58zg"&&(O.textContent=dt),Fe=n(e),c(K.$$.fragment,e),qe=n(e),c(ee.$$.fragment,e),Re=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-2r68yz"&&(te.innerHTML=mt),Xe=n(e),ae=o(e,"P",{}),ft(ae).forEach(s),this.h()},h(){gt(g,"name","hf:doc:metadata"),gt(g,"content",kt)},m(e,t){Mt(document.head,g),a(e,ie,t),a(e,se,t),a(e,ne,t),p($,e,t),a(e,le,t),a(e,y,t),a(e,oe,t),p(w,e,t),a(e,re,t),p(b,e,t),a(e,ue,t),a(e,v,t),a(e,ce,t),a(e,T,t),a(e,pe,t),a(e,M,t),a(e,he,t),p(_,e,t),a(e,de,t),a(e,k,t),a(e,me,t),p(H,e,t),a(e,fe,t),a(e,x,t),a(e,ge,t),p(C,e,t),a(e,$e,t),a(e,U,t),a(e,ye,t),p(L,e,t),a(e,we,t),p(I,e,t),a(e,be,t),a(e,j,t),a(e,ve,t),a(e,P,t),a(e,Te,t),a(e,J,t),a(e,Me,t),p(D,e,t),a(e,_e,t),p(G,e,t),a(e,ke,t),a(e,S,t),a(e,He,t),a(e,Z,t),a(e,xe,t),p(B,e,t),a(e,Ce,t),a(e,E,t),a(e,Ue,t),p(F,e,t),a(e,Le,t),a(e,q,t),a(e,Ie,t),a(e,R,t),a(e,je,t),a(e,X,t),a(e,Pe,t),p(Y,e,t),a(e,Je,t),a(e,A,t),a(e,De,t),p(Q,e,t),a(e,Ge,t),a(e,W,t),a(e,Se,t),p(z,e,t),a(e,Ze,t),a(e,N,t),a(e,Be,t),p(V,e,t),a(e,Ee,t),a(e,O,t),a(e,Fe,t),p(K,e,t),a(e,qe,t),p(ee,e,t),a(e,Re,t),a(e,te,t),a(e,Xe,t),a(e,ae,t),Ye=!0},p:yt,i(e){Ye||(h($.$$.fragment,e),h(w.$$.fragment,e),h(b.$$.fragment,e),h(_.$$.fragment,e),h(H.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(I.$$.fragment,e),h(D.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),Ye=!0)},o(e){d($.$$.fragment,e),d(w.$$.fragment,e),d(b.$$.fragment,e),d(_.$$.fragment,e),d(H.$$.fragment,e),d(C.$$.fragment,e),d(L.$$.fragment,e),d(I.$$.fragment,e),d(D.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(V.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),Ye=!1},d(e){e&&(s(ie),s(se),s(ne),s(le),s(y),s(oe),s(re),s(ue),s(v),s(ce),s(T),s(pe),s(M),s(he),s(de),s(k),s(me),s(fe),s(x),s(ge),s($e),s(U),s(ye),s(we),s(be),s(j),s(ve),s(P),s(Te),s(J),s(Me),s(_e),s(ke),s(S),s(He),s(Z),s(xe),s(Ce),s(E),s(Ue),s(Le),s(q),s(Ie),s(R),s(je),s(X),s(Pe),s(Je),s(A),s(De),s(Ge),s(W),s(Se),s(Ze),s(N),s(Be),s(Ee),s(O),s(Fe),s(qe),s(Re),s(te),s(Xe),s(ae)),s(g),m($,e),m(w,e),m(b,e),m(_,e),m(H,e),m(C,e),m(L,e),m(I,e),m(D,e),m(G,e),m(B,e),m(F,e),m(Y,e),m(Q,e),m(z,e),m(V,e),m(K,e),m(ee,e)}}}const kt='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Issues when uploading datasets with push_to_hub","local":"issues-when-uploading-datasets-with-pushtohub","sections":[{"title":"Authentication issues","local":"authentication-issues","sections":[],"depth":3},{"title":"Lost connection on large dataset upload","local":"lost-connection-on-large-dataset-upload","sections":[],"depth":3},{"title":"Too Many Requests","local":"too-many-requests","sections":[],"depth":3}],"depth":2},{"title":"Issues when creating datasets from custom data","local":"issues-when-creating-datasets-from-custom-data","sections":[{"title":"Loading images and audio from a folder","local":"loading-images-and-audio-from-a-folder","sections":[],"depth":3},{"title":"Pickling issues","local":"pickling-issues","sections":[{"title":"Pickling issues when using Dataset.from_generator","local":"pickling-issues-when-using-datasetfromgenerator","sections":[],"depth":4},{"title":"Pickling issues with Dataset.map","local":"pickling-issues-with-datasetmap","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Asking for help","local":"asking-for-help","sections":[{"title":"Forums","local":"forums","sections":[],"depth":3},{"title":"Discord","local":"discord","sections":[],"depth":3},{"title":"Community Discussions on 🤗 Hub","local":"community-discussions-on--hub","sections":[],"depth":3},{"title":"GitHub Issues","local":"github-issues","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ht(Qe){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends bt{constructor(g){super(),vt(this,g,Ht,_t,$t,{})}}export{It as component};
