import{s as ss,n as us,o as ms}from"../chunks/scheduler.b108d059.js";import{S as ns,i as fs,g as o,s as d,r as n,A as ps,h as i,f as e,c as a,j as m,u as f,x as s,k as u,y as hs,a as r,v as p,d as h,t as c,w as T}from"../chunks/index.008de539.js";import{H as y}from"../chunks/Heading.88bfeb84.js";function cs(xo){let v,cl,pl,Tl,F,yl,_,vl,x,bo="Helper module for mathematical processing.",Fl,b,$o=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,_l,$,Po='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.transpose_data"><code>.transpose_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',xl,bl,$l,P,Pl,A,Al,C,Ao='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Cl,H,Co="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Hl,Ll,Ml,L,wl,M,gl,w,Ho="Helper method to transpose a <code>AnyTypedArray</code> directly",El,g,Lo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The transposed array and the new shape.',Rl,E,Mo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",zl,kl,Kl,R,Ol,z,Bl,k,wo="Compute the softmax of an array of numbers.",Dl,K,go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Il,O,Eo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",jl,Ul,ql,B,Sl,D,Nl,I,Ro="Calculates the logarithm of the softmax function for the input array.",Gl,j,zo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',Jl,U,ko="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Ql,Vl,Wl,q,Xl,S,Yl,N,Ko="Calculates the dot product of two arrays.",Zl,G,Oo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',tr,J,Bo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",er,lr,rr,Q,dr,V,ar,W,Do="Get the top k items from an iterable, sorted by descending order",or,X,Io='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The top k items, sorted by descending order',ir,Y,jo="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array&lt;any&gt;</code> | <code>TypedArray</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",sr,ur,mr,Z,nr,tt,fr,et,Uo="Computes the cosine similarity between two arrays.",pr,lt,qo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',hr,rt,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",cr,Tr,yr,dt,vr,at,Fr,ot,No="Calculates the magnitude of a given array.",_r,it,Go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',xr,st,Jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",br,$r,Pr,ut,Ar,mt,Cr,nt,Qo="Returns the value and index of the minimum element in an array.",Hr,ft,Vo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',Lr,pt,Wo="<li><code>Error</code> If array is empty.</li>",Mr,ht,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",wr,gr,Er,ct,Rr,Tt,zr,yt,Yo="Returns the value and index of the maximum element in an array.",kr,vt,Zo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',Kr,Ft,ti="<li><code>Error</code> If array is empty.</li>",Or,_t,ei="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Br,Dr,Ir,xt,jr,bt,Ur,$t,li="Performs median filter on the provided data. Padding is done by mirroring the data.",qr,Pt,ri='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Sr,At,di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Nr,Gr,Jr,Ct,Qr,Ht,Vr,Lt,ai="Helper function to round a number to a given number of decimals",Wr,Mt,oi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Xr,wt,ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",Yr,Zr,td,gt,ed,Et,ld,Rt,si="Implementation of Radix-4 FFT.",rd,zt,ui=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,dd,kt,mi='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',ad,Kt,ni='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',od,id,sd,Ot,ud,Bt,md,Dt,fi="<strong>Throws</strong>:",nd,It,pi="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",fd,jt,hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",pd,hd,cd,Ut,Td,qt,yd,St,ci="Create a complex number array with size <code>2 * size</code>",vd,Nt,Ti='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',Fd,_d,xd,Gt,bd,Jt,$d,Qt,yi="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Pd,Vt,vi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Ad,Wt,Fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",Cd,Hd,Ld,Xt,Md,Yt,wd,Zt,_i="Convert a real-valued input array to a complex-valued output array.",gd,te,xi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Ed,ee,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Rd,zd,kd,le,Kd,re,Od,de,$i="Completes the spectrum by adding its mirrored negative frequency components.",Bd,ae,Pi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Dd,oe,Ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>spectrum</td><td><code>Float64Array</code></td><td><p>The input spectrum.</p></td></tr></tbody>",Id,jd,Ud,ie,qd,se,Sd,ue,Ci="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",Nd,me,Hi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Gd,ne,Li="<li><code>Error</code> Input and output buffers must be different.</li>",Jd,fe,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Qd,Vd,Wd,pe,Xd,he,Yd,ce,wi=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,Zd,Te,gi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ta,ye,Ei="<li><code>Error</code> If the input and output buffers are the same.</li>",ea,ve,Ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",la,ra,da,Fe,aa,_e,oa,xe,zi=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,ia,be,ki='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',sa,$e,Ki="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",ua,Pe,Oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",ma,na,fa,Ae,pa,Ce,ha,He,Bi="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",ca,Le,Di='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ta,Me,Ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",ya,va,Fa,we,_a,ge,xa,Ee,ji="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",ba,Re,Ui='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',$a,ze,qi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Pa,Aa,Ca,ke,Ha,Ke,La,Oe,Si="Performs radix-4 transformation on input data of length 8",Ma,Be,Ni='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',wa,De,Gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",ga,Ea,Ra,Ie,za,je,ka,Ue,Ji="Real input radix-4 implementation",Ka,qe,Qi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Oa,Se,Vi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Ba,Da,Ia,Ne,ja,Ge,Ua,Je,Wi="Performs a single real input radix-2 transformation on the provided data",qa,Qe,Xi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Sa,Ve,Yi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",Na,Ga,Ja,We,Qa,Xe,Va,Ye,Zi=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,Wa,Ze,ts='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Xa,tl,es="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",Ya,Za,to,el,eo,ll,lo,rl,ls=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,ro,dl,rs='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',ao,al,ds='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',oo,io,so,ol,uo,il,mo,sl,as="Constructs a new NP2FFT object.",no,ul,os="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",fo,po,ho,ml,co,nl,To,fl,is='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',yo,vo,Fo,hl,_o;return _=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),A=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathstransposedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),D=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),S=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> Array </code>",local:"utilsmathsgettopitemsitems-topk--code-array-code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),at=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),mt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Tt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),bt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),Bt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Jt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),re=new y({props:{title:"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>",local:"p2fftcompletespectrumspectrum--code-void-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),he=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),_e=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),je=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),ll=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),il=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),nl=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),{c(){v=o("meta"),cl=d(),pl=o("p"),Tl=d(),F=o("a"),yl=d(),n(_.$$.fragment),vl=d(),x=o("p"),x.textContent=bo,Fl=d(),b=o("p"),b.textContent=$o,_l=d(),$=o("ul"),$.innerHTML=Po,xl=d(),bl=o("hr"),$l=d(),P=o("a"),Pl=d(),n(A.$$.fragment),Al=d(),C=o("p"),C.innerHTML=Ao,Cl=d(),H=o("table"),H.innerHTML=Co,Hl=d(),Ll=o("hr"),Ml=d(),L=o("a"),wl=d(),n(M.$$.fragment),gl=d(),w=o("p"),w.innerHTML=Ho,El=d(),g=o("p"),g.innerHTML=Lo,Rl=d(),E=o("table"),E.innerHTML=Mo,zl=d(),kl=o("hr"),Kl=d(),R=o("a"),Ol=d(),n(z.$$.fragment),Bl=d(),k=o("p"),k.textContent=wo,Dl=d(),K=o("p"),K.innerHTML=go,Il=d(),O=o("table"),O.innerHTML=Eo,jl=d(),Ul=o("hr"),ql=d(),B=o("a"),Sl=d(),n(D.$$.fragment),Nl=d(),I=o("p"),I.textContent=Ro,Gl=d(),j=o("p"),j.innerHTML=zo,Jl=d(),U=o("table"),U.innerHTML=ko,Ql=d(),Vl=o("hr"),Wl=d(),q=o("a"),Xl=d(),n(S.$$.fragment),Yl=d(),N=o("p"),N.textContent=Ko,Zl=d(),G=o("p"),G.innerHTML=Oo,tr=d(),J=o("table"),J.innerHTML=Bo,er=d(),lr=o("hr"),rr=d(),Q=o("a"),dr=d(),n(V.$$.fragment),ar=d(),W=o("p"),W.textContent=Do,or=d(),X=o("p"),X.innerHTML=Io,ir=d(),Y=o("table"),Y.innerHTML=jo,sr=d(),ur=o("hr"),mr=d(),Z=o("a"),nr=d(),n(tt.$$.fragment),fr=d(),et=o("p"),et.textContent=Uo,pr=d(),lt=o("p"),lt.innerHTML=qo,hr=d(),rt=o("table"),rt.innerHTML=So,cr=d(),Tr=o("hr"),yr=d(),dt=o("a"),vr=d(),n(at.$$.fragment),Fr=d(),ot=o("p"),ot.textContent=No,_r=d(),it=o("p"),it.innerHTML=Go,xr=d(),st=o("table"),st.innerHTML=Jo,br=d(),$r=o("hr"),Pr=d(),ut=o("a"),Ar=d(),n(mt.$$.fragment),Cr=d(),nt=o("p"),nt.textContent=Qo,Hr=d(),ft=o("p"),ft.innerHTML=Vo,Lr=d(),pt=o("ul"),pt.innerHTML=Wo,Mr=d(),ht=o("table"),ht.innerHTML=Xo,wr=d(),gr=o("hr"),Er=d(),ct=o("a"),Rr=d(),n(Tt.$$.fragment),zr=d(),yt=o("p"),yt.textContent=Yo,kr=d(),vt=o("p"),vt.innerHTML=Zo,Kr=d(),Ft=o("ul"),Ft.innerHTML=ti,Or=d(),_t=o("table"),_t.innerHTML=ei,Br=d(),Dr=o("hr"),Ir=d(),xt=o("a"),jr=d(),n(bt.$$.fragment),Ur=d(),$t=o("p"),$t.textContent=li,qr=d(),Pt=o("p"),Pt.innerHTML=ri,Sr=d(),At=o("table"),At.innerHTML=di,Nr=d(),Gr=o("hr"),Jr=d(),Ct=o("a"),Qr=d(),n(Ht.$$.fragment),Vr=d(),Lt=o("p"),Lt.textContent=ai,Wr=d(),Mt=o("p"),Mt.innerHTML=oi,Xr=d(),wt=o("table"),wt.innerHTML=ii,Yr=d(),Zr=o("hr"),td=d(),gt=o("a"),ed=d(),n(Et.$$.fragment),ld=d(),Rt=o("p"),Rt.textContent=si,rd=d(),zt=o("p"),zt.innerHTML=ui,dd=d(),kt=o("p"),kt.innerHTML=mi,ad=d(),Kt=o("ul"),Kt.innerHTML=ni,od=d(),id=o("hr"),sd=d(),Ot=o("a"),ud=d(),n(Bt.$$.fragment),md=d(),Dt=o("p"),Dt.innerHTML=fi,nd=d(),It=o("ul"),It.innerHTML=pi,fd=d(),jt=o("table"),jt.innerHTML=hi,pd=d(),hd=o("hr"),cd=d(),Ut=o("a"),Td=d(),n(qt.$$.fragment),yd=d(),St=o("p"),St.innerHTML=ci,vd=d(),Nt=o("p"),Nt.innerHTML=Ti,Fd=d(),_d=o("hr"),xd=d(),Gt=o("a"),bd=d(),n(Jt.$$.fragment),$d=d(),Qt=o("p"),Qt.textContent=yi,Pd=d(),Vt=o("p"),Vt.innerHTML=vi,Ad=d(),Wt=o("table"),Wt.innerHTML=Fi,Cd=d(),Hd=o("hr"),Ld=d(),Xt=o("a"),Md=d(),n(Yt.$$.fragment),wd=d(),Zt=o("p"),Zt.textContent=_i,gd=d(),te=o("p"),te.innerHTML=xi,Ed=d(),ee=o("table"),ee.innerHTML=bi,Rd=d(),zd=o("hr"),kd=d(),le=o("a"),Kd=d(),n(re.$$.fragment),Od=d(),de=o("p"),de.textContent=$i,Bd=d(),ae=o("p"),ae.innerHTML=Pi,Dd=d(),oe=o("table"),oe.innerHTML=Ai,Id=d(),jd=o("hr"),Ud=d(),ie=o("a"),qd=d(),n(se.$$.fragment),Sd=d(),ue=o("p"),ue.textContent=Ci,Nd=d(),me=o("p"),me.innerHTML=Hi,Gd=d(),ne=o("ul"),ne.innerHTML=Li,Jd=d(),fe=o("table"),fe.innerHTML=Mi,Qd=d(),Vd=o("hr"),Wd=d(),pe=o("a"),Xd=d(),n(he.$$.fragment),Yd=d(),ce=o("p"),ce.textContent=wi,Zd=d(),Te=o("p"),Te.innerHTML=gi,ta=d(),ye=o("ul"),ye.innerHTML=Ei,ea=d(),ve=o("table"),ve.innerHTML=Ri,la=d(),ra=o("hr"),da=d(),Fe=o("a"),aa=d(),n(_e.$$.fragment),oa=d(),xe=o("p"),xe.innerHTML=zi,ia=d(),be=o("p"),be.innerHTML=ki,sa=d(),$e=o("ul"),$e.innerHTML=Ki,ua=d(),Pe=o("table"),Pe.innerHTML=Oi,ma=d(),na=o("hr"),fa=d(),Ae=o("a"),pa=d(),n(Ce.$$.fragment),ha=d(),He=o("p"),He.textContent=Bi,ca=d(),Le=o("p"),Le.innerHTML=Di,Ta=d(),Me=o("table"),Me.innerHTML=Ii,ya=d(),va=o("hr"),Fa=d(),we=o("a"),_a=d(),n(ge.$$.fragment),xa=d(),Ee=o("p"),Ee.textContent=ji,ba=d(),Re=o("p"),Re.innerHTML=Ui,$a=d(),ze=o("table"),ze.innerHTML=qi,Pa=d(),Aa=o("hr"),Ca=d(),ke=o("a"),Ha=d(),n(Ke.$$.fragment),La=d(),Oe=o("p"),Oe.textContent=Si,Ma=d(),Be=o("p"),Be.innerHTML=Ni,wa=d(),De=o("table"),De.innerHTML=Gi,ga=d(),Ea=o("hr"),Ra=d(),Ie=o("a"),za=d(),n(je.$$.fragment),ka=d(),Ue=o("p"),Ue.textContent=Ji,Ka=d(),qe=o("p"),qe.innerHTML=Qi,Oa=d(),Se=o("table"),Se.innerHTML=Vi,Ba=d(),Da=o("hr"),Ia=d(),Ne=o("a"),ja=d(),n(Ge.$$.fragment),Ua=d(),Je=o("p"),Je.textContent=Wi,qa=d(),Qe=o("p"),Qe.innerHTML=Xi,Sa=d(),Ve=o("table"),Ve.innerHTML=Yi,Na=d(),Ga=o("hr"),Ja=d(),We=o("a"),Qa=d(),n(Xe.$$.fragment),Va=d(),Ye=o("p"),Ye.textContent=Zi,Wa=d(),Ze=o("p"),Ze.innerHTML=ts,Xa=d(),tl=o("table"),tl.innerHTML=es,Ya=d(),Za=o("hr"),to=d(),el=o("a"),eo=d(),n(ll.$$.fragment),lo=d(),rl=o("p"),rl.textContent=ls,ro=d(),dl=o("p"),dl.innerHTML=rs,ao=d(),al=o("p"),al.innerHTML=ds,oo=d(),io=o("hr"),so=d(),ol=o("a"),uo=d(),n(il.$$.fragment),mo=d(),sl=o("p"),sl.textContent=as,no=d(),ul=o("table"),ul.innerHTML=os,fo=d(),po=o("hr"),ho=d(),ml=o("a"),co=d(),n(nl.$$.fragment),To=d(),fl=o("p"),fl.innerHTML=is,yo=d(),vo=o("hr"),Fo=d(),hl=o("p"),this.h()},l(t){const l=ps("svelte-u9bgzb",document.head);v=i(l,"META",{name:!0,content:!0}),l.forEach(e),cl=a(t),pl=i(t,"P",{}),m(pl).forEach(e),Tl=a(t),F=i(t,"A",{id:!0,class:!0}),m(F).forEach(e),yl=a(t),f(_.$$.fragment,t),vl=a(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-1d3zgi"&&(x.textContent=bo),Fl=a(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-il3kl8"&&(b.textContent=$o),_l=a(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-1qdrl2n"&&($.innerHTML=Po),xl=a(t),bl=i(t,"HR",{}),$l=a(t),P=i(t,"A",{id:!0,class:!0}),m(P).forEach(e),Pl=a(t),f(A.$$.fragment,t),Al=a(t),C=i(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-z8esp"&&(C.innerHTML=Ao),Cl=a(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=Co),Hl=a(t),Ll=i(t,"HR",{}),Ml=a(t),L=i(t,"A",{id:!0,class:!0}),m(L).forEach(e),wl=a(t),f(M.$$.fragment,t),gl=a(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-69x642"&&(w.innerHTML=Ho),El=a(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-1t49mrp"&&(g.innerHTML=Lo),Rl=a(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=Mo),zl=a(t),kl=i(t,"HR",{}),Kl=a(t),R=i(t,"A",{id:!0,class:!0}),m(R).forEach(e),Ol=a(t),f(z.$$.fragment,t),Bl=a(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=wo),Dl=a(t),K=i(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-xvvopf"&&(K.innerHTML=go),Il=a(t),O=i(t,"TABLE",{"data-svelte-h":!0}),s(O)!=="svelte-adoxzf"&&(O.innerHTML=Eo),jl=a(t),Ul=i(t,"HR",{}),ql=a(t),B=i(t,"A",{id:!0,class:!0}),m(B).forEach(e),Sl=a(t),f(D.$$.fragment,t),Nl=a(t),I=i(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-5479oq"&&(I.textContent=Ro),Gl=a(t),j=i(t,"P",{"data-svelte-h":!0}),s(j)!=="svelte-m9boyl"&&(j.innerHTML=zo),Jl=a(t),U=i(t,"TABLE",{"data-svelte-h":!0}),s(U)!=="svelte-5wetzk"&&(U.innerHTML=ko),Ql=a(t),Vl=i(t,"HR",{}),Wl=a(t),q=i(t,"A",{id:!0,class:!0}),m(q).forEach(e),Xl=a(t),f(S.$$.fragment,t),Yl=a(t),N=i(t,"P",{"data-svelte-h":!0}),s(N)!=="svelte-1kaf4lx"&&(N.textContent=Ko),Zl=a(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Oo),tr=a(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Bo),er=a(t),lr=i(t,"HR",{}),rr=a(t),Q=i(t,"A",{id:!0,class:!0}),m(Q).forEach(e),dr=a(t),f(V.$$.fragment,t),ar=a(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-s7mgi8"&&(W.textContent=Do),or=a(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-u4yvnz"&&(X.innerHTML=Io),ir=a(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-cbocil"&&(Y.innerHTML=jo),sr=a(t),ur=i(t,"HR",{}),mr=a(t),Z=i(t,"A",{id:!0,class:!0}),m(Z).forEach(e),nr=a(t),f(tt.$$.fragment,t),fr=a(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-6quqqj"&&(et.textContent=Uo),pr=a(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1y45k06"&&(lt.innerHTML=qo),hr=a(t),rt=i(t,"TABLE",{"data-svelte-h":!0}),s(rt)!=="svelte-nyqk4k"&&(rt.innerHTML=So),cr=a(t),Tr=i(t,"HR",{}),yr=a(t),dt=i(t,"A",{id:!0,class:!0}),m(dt).forEach(e),vr=a(t),f(at.$$.fragment,t),Fr=a(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-132v21g"&&(ot.textContent=No),_r=a(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-odriss"&&(it.innerHTML=Go),xr=a(t),st=i(t,"TABLE",{"data-svelte-h":!0}),s(st)!=="svelte-nbo00i"&&(st.innerHTML=Jo),br=a(t),$r=i(t,"HR",{}),Pr=a(t),ut=i(t,"A",{id:!0,class:!0}),m(ut).forEach(e),Ar=a(t),f(mt.$$.fragment,t),Cr=a(t),nt=i(t,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-67h0u1"&&(nt.textContent=Qo),Hr=a(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-cs0f6n"&&(ft.innerHTML=Vo),Lr=a(t),pt=i(t,"UL",{"data-svelte-h":!0}),s(pt)!=="svelte-jusv8t"&&(pt.innerHTML=Wo),Mr=a(t),ht=i(t,"TABLE",{"data-svelte-h":!0}),s(ht)!=="svelte-mtkj0x"&&(ht.innerHTML=Xo),wr=a(t),gr=i(t,"HR",{}),Er=a(t),ct=i(t,"A",{id:!0,class:!0}),m(ct).forEach(e),Rr=a(t),f(Tt.$$.fragment,t),zr=a(t),yt=i(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9vv4b"&&(yt.textContent=Yo),kr=a(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-1ixuuwb"&&(vt.innerHTML=Zo),Kr=a(t),Ft=i(t,"UL",{"data-svelte-h":!0}),s(Ft)!=="svelte-jusv8t"&&(Ft.innerHTML=ti),Or=a(t),_t=i(t,"TABLE",{"data-svelte-h":!0}),s(_t)!=="svelte-oriydz"&&(_t.innerHTML=ei),Br=a(t),Dr=i(t,"HR",{}),Ir=a(t),xt=i(t,"A",{id:!0,class:!0}),m(xt).forEach(e),jr=a(t),f(bt.$$.fragment,t),Ur=a(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-xb1vdd"&&($t.textContent=li),qr=a(t),Pt=i(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-z8esp"&&(Pt.innerHTML=ri),Sr=a(t),At=i(t,"TABLE",{"data-svelte-h":!0}),s(At)!=="svelte-pk7ooi"&&(At.innerHTML=di),Nr=a(t),Gr=i(t,"HR",{}),Jr=a(t),Ct=i(t,"A",{id:!0,class:!0}),m(Ct).forEach(e),Qr=a(t),f(Ht.$$.fragment,t),Vr=a(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-11aka64"&&(Lt.textContent=ai),Wr=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=oi),Xr=a(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-c6gnt1"&&(wt.innerHTML=ii),Yr=a(t),Zr=i(t,"HR",{}),td=a(t),gt=i(t,"A",{id:!0,class:!0}),m(gt).forEach(e),ed=a(t),f(Et.$$.fragment,t),ld=a(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-16m1u76"&&(Rt.textContent=si),rd=a(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-698ey0"&&(zt.innerHTML=ui),dd=a(t),kt=i(t,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-tjke50"&&(kt.innerHTML=mi),ad=a(t),Kt=i(t,"UL",{"data-svelte-h":!0}),s(Kt)!=="svelte-1iua3xn"&&(Kt.innerHTML=ni),od=a(t),id=i(t,"HR",{}),sd=a(t),Ot=i(t,"A",{id:!0,class:!0}),m(Ot).forEach(e),ud=a(t),f(Bt.$$.fragment,t),md=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1fz4yns"&&(Dt.innerHTML=fi),nd=a(t),It=i(t,"UL",{"data-svelte-h":!0}),s(It)!=="svelte-ph0ovr"&&(It.innerHTML=pi),fd=a(t),jt=i(t,"TABLE",{"data-svelte-h":!0}),s(jt)!=="svelte-a5vdxc"&&(jt.innerHTML=hi),pd=a(t),hd=i(t,"HR",{}),cd=a(t),Ut=i(t,"A",{id:!0,class:!0}),m(Ut).forEach(e),Td=a(t),f(qt.$$.fragment,t),yd=a(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1rrw4ya"&&(St.innerHTML=ci),vd=a(t),Nt=i(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1gdnoew"&&(Nt.innerHTML=Ti),Fd=a(t),_d=i(t,"HR",{}),xd=a(t),Gt=i(t,"A",{id:!0,class:!0}),m(Gt).forEach(e),bd=a(t),f(Jt.$$.fragment,t),$d=a(t),Qt=i(t,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-1693r4v"&&(Qt.textContent=yi),Pd=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-33y4ax"&&(Vt.innerHTML=vi),Ad=a(t),Wt=i(t,"TABLE",{"data-svelte-h":!0}),s(Wt)!=="svelte-1td0xj2"&&(Wt.innerHTML=Fi),Cd=a(t),Hd=i(t,"HR",{}),Ld=a(t),Xt=i(t,"A",{id:!0,class:!0}),m(Xt).forEach(e),Md=a(t),f(Yt.$$.fragment,t),wd=a(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-rsnsrd"&&(Zt.textContent=_i),gd=a(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1xayhm7"&&(te.innerHTML=xi),Ed=a(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1up5toh"&&(ee.innerHTML=bi),Rd=a(t),zd=i(t,"HR",{}),kd=a(t),le=i(t,"A",{id:!0,class:!0}),m(le).forEach(e),Kd=a(t),f(re.$$.fragment,t),Od=a(t),de=i(t,"P",{"data-svelte-h":!0}),s(de)!=="svelte-id49q5"&&(de.textContent=$i),Bd=a(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1dkdszr"&&(ae.innerHTML=Pi),Dd=a(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-15tum1z"&&(oe.innerHTML=Ai),Id=a(t),jd=i(t,"HR",{}),Ud=a(t),ie=i(t,"A",{id:!0,class:!0}),m(ie).forEach(e),qd=a(t),f(se.$$.fragment,t),Sd=a(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-846pp1"&&(ue.textContent=Ci),Nd=a(t),me=i(t,"P",{"data-svelte-h":!0}),s(me)!=="svelte-1t2xajz"&&(me.innerHTML=Hi),Gd=a(t),ne=i(t,"UL",{"data-svelte-h":!0}),s(ne)!=="svelte-173tqd8"&&(ne.innerHTML=Li),Jd=a(t),fe=i(t,"TABLE",{"data-svelte-h":!0}),s(fe)!=="svelte-1buvx7j"&&(fe.innerHTML=Mi),Qd=a(t),Vd=i(t,"HR",{}),Wd=a(t),pe=i(t,"A",{id:!0,class:!0}),m(pe).forEach(e),Xd=a(t),f(he.$$.fragment,t),Yd=a(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-ozshoc"&&(ce.textContent=wi),Zd=a(t),Te=i(t,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1t2xajz"&&(Te.innerHTML=gi),ta=a(t),ye=i(t,"UL",{"data-svelte-h":!0}),s(ye)!=="svelte-1ap3720"&&(ye.innerHTML=Ei),ea=a(t),ve=i(t,"TABLE",{"data-svelte-h":!0}),s(ve)!=="svelte-lghmn6"&&(ve.innerHTML=Ri),la=a(t),ra=i(t,"HR",{}),da=a(t),Fe=i(t,"A",{id:!0,class:!0}),m(Fe).forEach(e),aa=a(t),f(_e.$$.fragment,t),oa=a(t),xe=i(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-ijignt"&&(xe.innerHTML=zi),ia=a(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-1t2xajz"&&(be.innerHTML=ki),sa=a(t),$e=i(t,"UL",{"data-svelte-h":!0}),s($e)!=="svelte-1bp21xg"&&($e.innerHTML=Ki),ua=a(t),Pe=i(t,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-edt5vq"&&(Pe.innerHTML=Oi),ma=a(t),na=i(t,"HR",{}),fa=a(t),Ae=i(t,"A",{id:!0,class:!0}),m(Ae).forEach(e),pa=a(t),f(Ce.$$.fragment,t),ha=a(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-3r4wxn"&&(He.textContent=Bi),ca=a(t),Le=i(t,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1dkdszr"&&(Le.innerHTML=Di),Ta=a(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-15z8087"&&(Me.innerHTML=Ii),ya=a(t),va=i(t,"HR",{}),Fa=a(t),we=i(t,"A",{id:!0,class:!0}),m(we).forEach(e),_a=a(t),f(ge.$$.fragment,t),xa=a(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1jz5wqp"&&(Ee.textContent=ji),ba=a(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=Ui),$a=a(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-fx5ob"&&(ze.innerHTML=qi),Pa=a(t),Aa=i(t,"HR",{}),Ca=a(t),ke=i(t,"A",{id:!0,class:!0}),m(ke).forEach(e),Ha=a(t),f(Ke.$$.fragment,t),La=a(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1baynqa"&&(Oe.textContent=Si),Ma=a(t),Be=i(t,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1dkdszr"&&(Be.innerHTML=Ni),wa=a(t),De=i(t,"TABLE",{"data-svelte-h":!0}),s(De)!=="svelte-szv30n"&&(De.innerHTML=Gi),ga=a(t),Ea=i(t,"HR",{}),Ra=a(t),Ie=i(t,"A",{id:!0,class:!0}),m(Ie).forEach(e),za=a(t),f(je.$$.fragment,t),ka=a(t),Ue=i(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1gll44b"&&(Ue.textContent=Ji),Ka=a(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=Qi),Oa=a(t),Se=i(t,"TABLE",{"data-svelte-h":!0}),s(Se)!=="svelte-159qhrx"&&(Se.innerHTML=Vi),Ba=a(t),Da=i(t,"HR",{}),Ia=a(t),Ne=i(t,"A",{id:!0,class:!0}),m(Ne).forEach(e),ja=a(t),f(Ge.$$.fragment,t),Ua=a(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1upf1p8"&&(Je.textContent=Wi),qa=a(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=Xi),Sa=a(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-18nciet"&&(Ve.innerHTML=Yi),Na=a(t),Ga=i(t,"HR",{}),Ja=a(t),We=i(t,"A",{id:!0,class:!0}),m(We).forEach(e),Qa=a(t),f(Xe.$$.fragment,t),Va=a(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-8fqhv2"&&(Ye.textContent=Zi),Wa=a(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=ts),Xa=a(t),tl=i(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-pf887e"&&(tl.innerHTML=es),Ya=a(t),Za=i(t,"HR",{}),to=a(t),el=i(t,"A",{id:!0,class:!0}),m(el).forEach(e),eo=a(t),f(ll.$$.fragment,t),lo=a(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-yw51a0"&&(rl.textContent=ls),ro=a(t),dl=i(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-1gw6hta"&&(dl.innerHTML=rs),ao=a(t),al=i(t,"P",{"data-svelte-h":!0}),s(al)!=="svelte-tjke50"&&(al.innerHTML=ds),oo=a(t),io=i(t,"HR",{}),so=a(t),ol=i(t,"A",{id:!0,class:!0}),m(ol).forEach(e),uo=a(t),f(il.$$.fragment,t),mo=a(t),sl=i(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-lvoqsi"&&(sl.textContent=as),no=a(t),ul=i(t,"TABLE",{"data-svelte-h":!0}),s(ul)!=="svelte-1gtay08"&&(ul.innerHTML=os),fo=a(t),po=i(t,"HR",{}),ho=a(t),ml=i(t,"A",{id:!0,class:!0}),m(ml).forEach(e),co=a(t),f(nl.$$.fragment,t),To=a(t),fl=i(t,"P",{"data-svelte-h":!0}),s(fl)!=="svelte-9rr3v5"&&(fl.innerHTML=is),yo=a(t),vo=i(t,"HR",{}),Fo=a(t),hl=i(t,"P",{}),m(hl).forEach(e),this.h()},h(){u(v,"name","hf:doc:metadata"),u(v,"content",Ts),u(F,"id","module_utils/maths"),u(F,"class","group"),u(P,"id","module_utils/maths.interpolate_data"),u(P,"class","group"),u(L,"id","module_utils/maths.transpose_data"),u(L,"class","group"),u(R,"id","module_utils/maths.softmax"),u(R,"class","group"),u(B,"id","module_utils/maths.log_softmax"),u(B,"class","group"),u(q,"id","module_utils/maths.dot"),u(q,"class","group"),u(Q,"id","module_utils/maths.getTopItems"),u(Q,"class","group"),u(Z,"id","module_utils/maths.cos_sim"),u(Z,"class","group"),u(dt,"id","module_utils/maths.magnitude"),u(dt,"class","group"),u(ut,"id","module_utils/maths.min"),u(ut,"class","group"),u(ct,"id","module_utils/maths.max"),u(ct,"class","group"),u(xt,"id","module_utils/maths.medianFilter"),u(xt,"class","group"),u(Ct,"id","module_utils/maths.round"),u(Ct,"class","group"),u(gt,"id","module_utils/maths..P2FFT"),u(gt,"class","group"),u(Ot,"id","new_module_utils/maths..P2FFT_new"),u(Ot,"class","group"),u(Ut,"id","module_utils/maths..P2FFT+createComplexArray"),u(Ut,"class","group"),u(Gt,"id","module_utils/maths..P2FFT+fromComplexArray"),u(Gt,"class","group"),u(Xt,"id","module_utils/maths..P2FFT+toComplexArray"),u(Xt,"class","group"),u(le,"id","module_utils/maths..P2FFT+completeSpectrum"),u(le,"class","group"),u(ie,"id","module_utils/maths..P2FFT+transform"),u(ie,"class","group"),u(pe,"id","module_utils/maths..P2FFT+realTransform"),u(pe,"class","group"),u(Fe,"id","module_utils/maths..P2FFT+inverseTransform"),u(Fe,"class","group"),u(Ae,"id","module_utils/maths..P2FFT+_transform4"),u(Ae,"class","group"),u(we,"id","module_utils/maths..P2FFT+_singleTransform2"),u(we,"class","group"),u(ke,"id","module_utils/maths..P2FFT+_singleTransform4"),u(ke,"class","group"),u(Ie,"id","module_utils/maths..P2FFT+_realTransform4"),u(Ie,"class","group"),u(Ne,"id","module_utils/maths..P2FFT+_singleRealTransform2"),u(Ne,"class","group"),u(We,"id","module_utils/maths..P2FFT+_singleRealTransform4"),u(We,"class","group"),u(el,"id","module_utils/maths..NP2FFT"),u(el,"class","group"),u(ol,"id","new_module_utils/maths..NP2FFT_new"),u(ol,"class","group"),u(ml,"id","module_utils/maths..AnyTypedArray"),u(ml,"class","group")},m(t,l){hs(document.head,v),r(t,cl,l),r(t,pl,l),r(t,Tl,l),r(t,F,l),r(t,yl,l),p(_,t,l),r(t,vl,l),r(t,x,l),r(t,Fl,l),r(t,b,l),r(t,_l,l),r(t,$,l),r(t,xl,l),r(t,bl,l),r(t,$l,l),r(t,P,l),r(t,Pl,l),p(A,t,l),r(t,Al,l),r(t,C,l),r(t,Cl,l),r(t,H,l),r(t,Hl,l),r(t,Ll,l),r(t,Ml,l),r(t,L,l),r(t,wl,l),p(M,t,l),r(t,gl,l),r(t,w,l),r(t,El,l),r(t,g,l),r(t,Rl,l),r(t,E,l),r(t,zl,l),r(t,kl,l),r(t,Kl,l),r(t,R,l),r(t,Ol,l),p(z,t,l),r(t,Bl,l),r(t,k,l),r(t,Dl,l),r(t,K,l),r(t,Il,l),r(t,O,l),r(t,jl,l),r(t,Ul,l),r(t,ql,l),r(t,B,l),r(t,Sl,l),p(D,t,l),r(t,Nl,l),r(t,I,l),r(t,Gl,l),r(t,j,l),r(t,Jl,l),r(t,U,l),r(t,Ql,l),r(t,Vl,l),r(t,Wl,l),r(t,q,l),r(t,Xl,l),p(S,t,l),r(t,Yl,l),r(t,N,l),r(t,Zl,l),r(t,G,l),r(t,tr,l),r(t,J,l),r(t,er,l),r(t,lr,l),r(t,rr,l),r(t,Q,l),r(t,dr,l),p(V,t,l),r(t,ar,l),r(t,W,l),r(t,or,l),r(t,X,l),r(t,ir,l),r(t,Y,l),r(t,sr,l),r(t,ur,l),r(t,mr,l),r(t,Z,l),r(t,nr,l),p(tt,t,l),r(t,fr,l),r(t,et,l),r(t,pr,l),r(t,lt,l),r(t,hr,l),r(t,rt,l),r(t,cr,l),r(t,Tr,l),r(t,yr,l),r(t,dt,l),r(t,vr,l),p(at,t,l),r(t,Fr,l),r(t,ot,l),r(t,_r,l),r(t,it,l),r(t,xr,l),r(t,st,l),r(t,br,l),r(t,$r,l),r(t,Pr,l),r(t,ut,l),r(t,Ar,l),p(mt,t,l),r(t,Cr,l),r(t,nt,l),r(t,Hr,l),r(t,ft,l),r(t,Lr,l),r(t,pt,l),r(t,Mr,l),r(t,ht,l),r(t,wr,l),r(t,gr,l),r(t,Er,l),r(t,ct,l),r(t,Rr,l),p(Tt,t,l),r(t,zr,l),r(t,yt,l),r(t,kr,l),r(t,vt,l),r(t,Kr,l),r(t,Ft,l),r(t,Or,l),r(t,_t,l),r(t,Br,l),r(t,Dr,l),r(t,Ir,l),r(t,xt,l),r(t,jr,l),p(bt,t,l),r(t,Ur,l),r(t,$t,l),r(t,qr,l),r(t,Pt,l),r(t,Sr,l),r(t,At,l),r(t,Nr,l),r(t,Gr,l),r(t,Jr,l),r(t,Ct,l),r(t,Qr,l),p(Ht,t,l),r(t,Vr,l),r(t,Lt,l),r(t,Wr,l),r(t,Mt,l),r(t,Xr,l),r(t,wt,l),r(t,Yr,l),r(t,Zr,l),r(t,td,l),r(t,gt,l),r(t,ed,l),p(Et,t,l),r(t,ld,l),r(t,Rt,l),r(t,rd,l),r(t,zt,l),r(t,dd,l),r(t,kt,l),r(t,ad,l),r(t,Kt,l),r(t,od,l),r(t,id,l),r(t,sd,l),r(t,Ot,l),r(t,ud,l),p(Bt,t,l),r(t,md,l),r(t,Dt,l),r(t,nd,l),r(t,It,l),r(t,fd,l),r(t,jt,l),r(t,pd,l),r(t,hd,l),r(t,cd,l),r(t,Ut,l),r(t,Td,l),p(qt,t,l),r(t,yd,l),r(t,St,l),r(t,vd,l),r(t,Nt,l),r(t,Fd,l),r(t,_d,l),r(t,xd,l),r(t,Gt,l),r(t,bd,l),p(Jt,t,l),r(t,$d,l),r(t,Qt,l),r(t,Pd,l),r(t,Vt,l),r(t,Ad,l),r(t,Wt,l),r(t,Cd,l),r(t,Hd,l),r(t,Ld,l),r(t,Xt,l),r(t,Md,l),p(Yt,t,l),r(t,wd,l),r(t,Zt,l),r(t,gd,l),r(t,te,l),r(t,Ed,l),r(t,ee,l),r(t,Rd,l),r(t,zd,l),r(t,kd,l),r(t,le,l),r(t,Kd,l),p(re,t,l),r(t,Od,l),r(t,de,l),r(t,Bd,l),r(t,ae,l),r(t,Dd,l),r(t,oe,l),r(t,Id,l),r(t,jd,l),r(t,Ud,l),r(t,ie,l),r(t,qd,l),p(se,t,l),r(t,Sd,l),r(t,ue,l),r(t,Nd,l),r(t,me,l),r(t,Gd,l),r(t,ne,l),r(t,Jd,l),r(t,fe,l),r(t,Qd,l),r(t,Vd,l),r(t,Wd,l),r(t,pe,l),r(t,Xd,l),p(he,t,l),r(t,Yd,l),r(t,ce,l),r(t,Zd,l),r(t,Te,l),r(t,ta,l),r(t,ye,l),r(t,ea,l),r(t,ve,l),r(t,la,l),r(t,ra,l),r(t,da,l),r(t,Fe,l),r(t,aa,l),p(_e,t,l),r(t,oa,l),r(t,xe,l),r(t,ia,l),r(t,be,l),r(t,sa,l),r(t,$e,l),r(t,ua,l),r(t,Pe,l),r(t,ma,l),r(t,na,l),r(t,fa,l),r(t,Ae,l),r(t,pa,l),p(Ce,t,l),r(t,ha,l),r(t,He,l),r(t,ca,l),r(t,Le,l),r(t,Ta,l),r(t,Me,l),r(t,ya,l),r(t,va,l),r(t,Fa,l),r(t,we,l),r(t,_a,l),p(ge,t,l),r(t,xa,l),r(t,Ee,l),r(t,ba,l),r(t,Re,l),r(t,$a,l),r(t,ze,l),r(t,Pa,l),r(t,Aa,l),r(t,Ca,l),r(t,ke,l),r(t,Ha,l),p(Ke,t,l),r(t,La,l),r(t,Oe,l),r(t,Ma,l),r(t,Be,l),r(t,wa,l),r(t,De,l),r(t,ga,l),r(t,Ea,l),r(t,Ra,l),r(t,Ie,l),r(t,za,l),p(je,t,l),r(t,ka,l),r(t,Ue,l),r(t,Ka,l),r(t,qe,l),r(t,Oa,l),r(t,Se,l),r(t,Ba,l),r(t,Da,l),r(t,Ia,l),r(t,Ne,l),r(t,ja,l),p(Ge,t,l),r(t,Ua,l),r(t,Je,l),r(t,qa,l),r(t,Qe,l),r(t,Sa,l),r(t,Ve,l),r(t,Na,l),r(t,Ga,l),r(t,Ja,l),r(t,We,l),r(t,Qa,l),p(Xe,t,l),r(t,Va,l),r(t,Ye,l),r(t,Wa,l),r(t,Ze,l),r(t,Xa,l),r(t,tl,l),r(t,Ya,l),r(t,Za,l),r(t,to,l),r(t,el,l),r(t,eo,l),p(ll,t,l),r(t,lo,l),r(t,rl,l),r(t,ro,l),r(t,dl,l),r(t,ao,l),r(t,al,l),r(t,oo,l),r(t,io,l),r(t,so,l),r(t,ol,l),r(t,uo,l),p(il,t,l),r(t,mo,l),r(t,sl,l),r(t,no,l),r(t,ul,l),r(t,fo,l),r(t,po,l),r(t,ho,l),r(t,ml,l),r(t,co,l),p(nl,t,l),r(t,To,l),r(t,fl,l),r(t,yo,l),r(t,vo,l),r(t,Fo,l),r(t,hl,l),_o=!0},p:us,i(t){_o||(h(_.$$.fragment,t),h(A.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(S.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(at.$$.fragment,t),h(mt.$$.fragment,t),h(Tt.$$.fragment,t),h(bt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Bt.$$.fragment,t),h(qt.$$.fragment,t),h(Jt.$$.fragment,t),h(Yt.$$.fragment,t),h(re.$$.fragment,t),h(se.$$.fragment,t),h(he.$$.fragment,t),h(_e.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(je.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(il.$$.fragment,t),h(nl.$$.fragment,t),_o=!0)},o(t){c(_.$$.fragment,t),c(A.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(D.$$.fragment,t),c(S.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(at.$$.fragment,t),c(mt.$$.fragment,t),c(Tt.$$.fragment,t),c(bt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Bt.$$.fragment,t),c(qt.$$.fragment,t),c(Jt.$$.fragment,t),c(Yt.$$.fragment,t),c(re.$$.fragment,t),c(se.$$.fragment,t),c(he.$$.fragment,t),c(_e.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(je.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(il.$$.fragment,t),c(nl.$$.fragment,t),_o=!1},d(t){t&&(e(cl),e(pl),e(Tl),e(F),e(yl),e(vl),e(x),e(Fl),e(b),e(_l),e($),e(xl),e(bl),e($l),e(P),e(Pl),e(Al),e(C),e(Cl),e(H),e(Hl),e(Ll),e(Ml),e(L),e(wl),e(gl),e(w),e(El),e(g),e(Rl),e(E),e(zl),e(kl),e(Kl),e(R),e(Ol),e(Bl),e(k),e(Dl),e(K),e(Il),e(O),e(jl),e(Ul),e(ql),e(B),e(Sl),e(Nl),e(I),e(Gl),e(j),e(Jl),e(U),e(Ql),e(Vl),e(Wl),e(q),e(Xl),e(Yl),e(N),e(Zl),e(G),e(tr),e(J),e(er),e(lr),e(rr),e(Q),e(dr),e(ar),e(W),e(or),e(X),e(ir),e(Y),e(sr),e(ur),e(mr),e(Z),e(nr),e(fr),e(et),e(pr),e(lt),e(hr),e(rt),e(cr),e(Tr),e(yr),e(dt),e(vr),e(Fr),e(ot),e(_r),e(it),e(xr),e(st),e(br),e($r),e(Pr),e(ut),e(Ar),e(Cr),e(nt),e(Hr),e(ft),e(Lr),e(pt),e(Mr),e(ht),e(wr),e(gr),e(Er),e(ct),e(Rr),e(zr),e(yt),e(kr),e(vt),e(Kr),e(Ft),e(Or),e(_t),e(Br),e(Dr),e(Ir),e(xt),e(jr),e(Ur),e($t),e(qr),e(Pt),e(Sr),e(At),e(Nr),e(Gr),e(Jr),e(Ct),e(Qr),e(Vr),e(Lt),e(Wr),e(Mt),e(Xr),e(wt),e(Yr),e(Zr),e(td),e(gt),e(ed),e(ld),e(Rt),e(rd),e(zt),e(dd),e(kt),e(ad),e(Kt),e(od),e(id),e(sd),e(Ot),e(ud),e(md),e(Dt),e(nd),e(It),e(fd),e(jt),e(pd),e(hd),e(cd),e(Ut),e(Td),e(yd),e(St),e(vd),e(Nt),e(Fd),e(_d),e(xd),e(Gt),e(bd),e($d),e(Qt),e(Pd),e(Vt),e(Ad),e(Wt),e(Cd),e(Hd),e(Ld),e(Xt),e(Md),e(wd),e(Zt),e(gd),e(te),e(Ed),e(ee),e(Rd),e(zd),e(kd),e(le),e(Kd),e(Od),e(de),e(Bd),e(ae),e(Dd),e(oe),e(Id),e(jd),e(Ud),e(ie),e(qd),e(Sd),e(ue),e(Nd),e(me),e(Gd),e(ne),e(Jd),e(fe),e(Qd),e(Vd),e(Wd),e(pe),e(Xd),e(Yd),e(ce),e(Zd),e(Te),e(ta),e(ye),e(ea),e(ve),e(la),e(ra),e(da),e(Fe),e(aa),e(oa),e(xe),e(ia),e(be),e(sa),e($e),e(ua),e(Pe),e(ma),e(na),e(fa),e(Ae),e(pa),e(ha),e(He),e(ca),e(Le),e(Ta),e(Me),e(ya),e(va),e(Fa),e(we),e(_a),e(xa),e(Ee),e(ba),e(Re),e($a),e(ze),e(Pa),e(Aa),e(Ca),e(ke),e(Ha),e(La),e(Oe),e(Ma),e(Be),e(wa),e(De),e(ga),e(Ea),e(Ra),e(Ie),e(za),e(ka),e(Ue),e(Ka),e(qe),e(Oa),e(Se),e(Ba),e(Da),e(Ia),e(Ne),e(ja),e(Ua),e(Je),e(qa),e(Qe),e(Sa),e(Ve),e(Na),e(Ga),e(Ja),e(We),e(Qa),e(Va),e(Ye),e(Wa),e(Ze),e(Xa),e(tl),e(Ya),e(Za),e(to),e(el),e(eo),e(lo),e(rl),e(ro),e(dl),e(ao),e(al),e(oo),e(io),e(so),e(ol),e(uo),e(mo),e(sl),e(no),e(ul),e(fo),e(po),e(ho),e(ml),e(co),e(To),e(fl),e(yo),e(vo),e(Fo),e(hl)),e(v),T(_,t),T(A,t),T(M,t),T(z,t),T(D,t),T(S,t),T(V,t),T(tt,t),T(at,t),T(mt,t),T(Tt,t),T(bt,t),T(Ht,t),T(Et,t),T(Bt,t),T(qt,t),T(Jt,t),T(Yt,t),T(re,t),T(se,t),T(he,t),T(_e,t),T(Ce,t),T(ge,t),T(Ke,t),T(je,t),T(Ge,t),T(Xe,t),T(ll,t),T(il,t),T(nl,t)}}}const Ts='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathstransposedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> Array </code>","local":"utilsmathsgettopitemsitems-topk--code-array-code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>","local":"p2fftcompletespectrumspectrum--code-void-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function ys(xo){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends ns{constructor(v){super(),fs(this,v,ys,cs,ss,{})}}export{xs as component};
