import{s as Zl,n as vl,o as Bl}from"../chunks/scheduler.65852ee5.js";import{S as Gl,i as Al,g as o,s as n,r,A as Wl,h as i,f as l,c as a,j as gl,u as p,x as M,k as Cl,y as kl,a as s,v as y,d as c,t as u,w}from"../chunks/index.aa74147d.js";import{D as Nl,C as J}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as j,E as Rl}from"../chunks/EditOnGithub.4eda6a96.js";function _l(St){let m,ve,Ce,Be,d,Ge,T,Ae,U,$t='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',We,h,Qt='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',ke,b,Xt="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",Ne,I,qt='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',Re,f,xt='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">documentation</a>.',_e,g,Ht="Let’s see how to use it, and which use cases it can solve.",Ve,C,Ft="Run the line below to install required dependencies:",Ee,Z,Se,v,Yt="Let’s login in order to call the HF Inference API:",$e,B,Qe,G,Xe,A,zt="For this use case, we want to show an agent that browses the web and is able to generate images.",qe,W,Lt="To build it, we simply need to have two tools ready: image generation and web search.",xe,k,Pt="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we use a built-in tool.</li>",He,N,Fe,R,Kt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',Ye,_,ze,V,Dt="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",Le,E,Ot="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",Pe,S,el="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",Ke,$,tl="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",De,Q,ll="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Oe,X,et,q,sl="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",tt,x,lt,H,nl="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",st,F,al="We want our system to select only from the most relevant sources of information, depending on the query.",nt,Y,ol="Our documentation pages come from the following sources:",at,z,ot,L,il=`['datasets-server', 'datasets', 'optimum', 'gradio', 'blog', 'course', 'hub-docs', 'pytorch-image-models', 'peft', 'evaluate', 'diffusers', 'hf-endpoints-documentation', 'deep-rl-class', 'transformers']
`,it,P,Ml="👉 Now let’s build a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",Mt,K,rl='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',rt,D,pt,O,yt,ee,pl="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",ct,te,yl="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",ut,le,wt,se,Jt,ne,mt,ae,cl="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",jt,oe,ul=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,dt,ie,wl="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",Tt,Me,Ut,re,Jl="Since the ReactCodeAgent has a built-in Python code interpreter, we can use it to debug our faulty Python script!",ht,pe,bt,ye,ml="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",It,ce,jl="And the final code is the corrected code:",ft,ue,gt,we,dl=`my_list = [0, 1, 2]

for i in range(4):
    if i < len(my_list):
        print(my_list[i])
    else:
        print("Index out of range")
`,Ct,Je,Zt,me,Tl=`It’s really easy to set up your own LLM engine:
it only needs a <code>__call__</code> method with these criteria:`,vt,je,Ul='<li>Takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML format</a> and outputs the answer.</li> <li>Accepts a <code>stop_sequences</code> arguments to pass sequences on which generation stops.</li> <li>Depending on which kind of message roles your LLM accepts, you may also need to convert some message roles.</li>',Bt,de,Gt,Te,At,Ue,hl=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,Wt,he,kt,be,bl="The use cases above should give you a glimpse into the possibilities of our Agents framework!",Nt,Ie,Il='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',Rt,fe,fl="All feedback is welcome, it will help us improve the framework! 🚀",_t,ge,Vt,Ze,Et;return d=new Nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),T=new j({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),Z=new J({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjIlMjBkYXRhc2V0cyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwb3BlbmFpJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMC0tdXBncmFkZSUyMC1x",highlighted:'!pip install <span class="hljs-string">&quot;transformers[agents]&quot;</span> datasets langchain sentence-transformers faiss-cpu duckduckgo-search openai langchain-community --upgrade -q',wrap:!1}}),B=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),G=new j({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),N=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUyQyUyMFJlYWN0Q29kZUFnZW50JTJDJTIwSGZBcGlFbmdpbmUlMEElMEElMjMlMjBJbXBvcnQlMjB0b29sJTIwZnJvbSUyMEh1YiUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMjBjYWNoZSUzREZhbHNlKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMuc2VhcmNoJTIwaW1wb3J0JTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEElMEFsbG1fZW5naW5lJTIwJTNEJTIwSGZBcGlFbmdpbmUoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBib3RoJTIwdG9vbHMlMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTJDJTIwc2VhcmNoX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyR2VuZXJhdGUlMjBtZSUyMGElMjBwaG90byUyMG9mJTIwdGhlJTIwY2FyJTIwdGhhdCUyMEphbWVzJTIwYm9uZCUyMGRyb3ZlJTIwaW4lMjB0aGUlMjBsYXRlc3QlMjBtb3ZpZS4lMjIlMkMlMEEpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool, ReactCodeAgent, HfApiEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, cache=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> transformers.agents.search <span class="hljs-keyword">import</span> DuckDuckGoSearchTool

search_tool = DuckDuckGoSearchTool()

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),_=new j({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),X=new J({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),x=new J({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),z=new J({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),D=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][<span class="hljs-string">&quot;description&quot;</span>] = (
            <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>.replace(
                <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;\`&quot;</span>
            )
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),O=new j({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),le=new J({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwVHJ1ZSUwQSUwQWlmJTIwc2hhcmVfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHJldHJpZXZlciUyMGltcG9ydCUyMFJldHJpZXZlclRvb2wlMEElMEElMjAlMjAlMjAlMjBsb2dpbiglMjJ5b3VyX3Rva2VuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBJTIwJTIwJTIwJTIwdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBMb2FkaW5nJTIwdGhlJTIwdG9vbCUwQSUyMCUyMCUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzJTIwaW1wb3J0JTIwbG9hZF90b29sJTBBJTBBJTIwJTIwJTIwJTIwcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiUyQyUyMHZlY3RvcmRiJTNEdmVjdG9yZGIlMkMlMjBhbGxfc291cmNlcyUzRGFsbF9zb3VyY2VzKQ==",highlighted:`share_to_hub = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)

    <span class="hljs-comment"># Loading the tool</span>
    <span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> load_tool

    retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)`,wrap:!1}}),se=new j({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),ne=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIlM0R2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzJTNEYWxsX3NvdXJjZXMpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjB2ZXJib3NlJTNEMCklMEElMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwc2hvdyUyMG1lJTIwYSUyMExPUkElMjBmaW5ldHVuaW5nJTIwc2NyaXB0JTIyKSUwQSUwQXByaW50KCUyMkZpbmFsJTIwb3V0cHV0JTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactJsonAgent

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb=vectordb, all_sources=all_sources)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),Me=new j({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),pe=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpKSUwQSUwQWNvZGUlMjAlM0QlMjAlMjIlMjIlMjIlMEFsaXN0JTNEJTVCMCUyQyUyMDElMkMlMjAyJTVEJTBBJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklM0ElMEElMjAlMjAlMjAlMjBwcmludChsaXN0KGkpKSUwQSUyMiUyMiUyMiUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJJTIwaGF2ZSUyMHNvbWUlMjBjb2RlJTIwdGhhdCUyMGNyZWF0ZXMlMjBhJTIwYnVnJTNBJTIwcGxlYXNlJTIwZGVidWclMjBpdCUyQyUyMHRoZW4lMjBydW4lMjBpdCUyMHRvJTIwbWFrZSUyMHN1cmUlMjBpdCUyMHdvcmtzJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwZmluYWwlMjBjb2RlJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29kZSUzRGNvZGUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[], llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>))

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it, then run it to make sure it works and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ue=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),Je=new j({props:{title:"4. Create your own LLM engine (OpenAI)",local:"4-create-your-own-llm-engine-openai",headingTag:"h2"}}),de=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Te=new J({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),he=new j({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),ge=new Rl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){m=o("meta"),ve=n(),Ce=o("p"),Be=n(),r(d.$$.fragment),Ge=n(),r(T.$$.fragment),Ae=n(),U=o("p"),U.innerHTML=$t,We=n(),h=o("p"),h.innerHTML=Qt,ke=n(),b=o("p"),b.innerHTML=Xt,Ne=n(),I=o("p"),I.innerHTML=qt,Re=n(),f=o("p"),f.innerHTML=xt,_e=n(),g=o("p"),g.textContent=Ht,Ve=n(),C=o("p"),C.textContent=Ft,Ee=n(),r(Z.$$.fragment),Se=n(),v=o("p"),v.textContent=Yt,$e=n(),r(B.$$.fragment),Qe=n(),r(G.$$.fragment),Xe=n(),A=o("p"),A.textContent=zt,qe=n(),W=o("p"),W.textContent=Lt,xe=n(),k=o("ul"),k.innerHTML=Pt,He=n(),r(N.$$.fragment),Fe=n(),R=o("p"),R.innerHTML=Kt,Ye=n(),r(_.$$.fragment),ze=n(),V=o("p"),V.innerHTML=Dt,Le=n(),E=o("p"),E.textContent=Ot,Pe=n(),S=o("ul"),S.innerHTML=el,Ke=n(),$=o("p"),$.innerHTML=tl,De=n(),Q=o("p"),Q.innerHTML=ll,Oe=n(),r(X.$$.fragment),et=n(),q=o("p"),q.textContent=sl,tt=n(),r(x.$$.fragment),lt=n(),H=o("p"),H.textContent=nl,st=n(),F=o("p"),F.textContent=al,nt=n(),Y=o("p"),Y.textContent=ol,at=n(),r(z.$$.fragment),ot=n(),L=o("pre"),L.textContent=il,it=n(),P=o("p"),P.innerHTML=Ml,Mt=n(),K=o("p"),K.innerHTML=rl,rt=n(),r(D.$$.fragment),pt=n(),r(O.$$.fragment),yt=n(),ee=o("p"),ee.innerHTML=pl,ct=n(),te=o("p"),te.innerHTML=yl,ut=n(),r(le.$$.fragment),wt=n(),r(se.$$.fragment),Jt=n(),r(ne.$$.fragment),mt=n(),ae=o("p"),ae.innerHTML=cl,jt=n(),oe=o("p"),oe.textContent=ul,dt=n(),ie=o("p"),ie.innerHTML=wl,Tt=n(),r(Me.$$.fragment),Ut=n(),re=o("p"),re.textContent=Jl,ht=n(),r(pe.$$.fragment),bt=n(),ye=o("p"),ye.textContent=ml,It=n(),ce=o("p"),ce.textContent=jl,ft=n(),r(ue.$$.fragment),gt=n(),we=o("pre"),we.textContent=dl,Ct=n(),r(Je.$$.fragment),Zt=n(),me=o("p"),me.innerHTML=Tl,vt=n(),je=o("ol"),je.innerHTML=Ul,Bt=n(),r(de.$$.fragment),Gt=n(),r(Te.$$.fragment),At=n(),Ue=o("pre"),Ue.textContent=hl,Wt=n(),r(he.$$.fragment),kt=n(),be=o("p"),be.textContent=bl,Nt=n(),Ie=o("p"),Ie.innerHTML=Il,Rt=n(),fe=o("p"),fe.textContent=fl,_t=n(),r(ge.$$.fragment),Vt=n(),Ze=o("p"),this.h()},l(e){const t=Wl("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),ve=a(e),Ce=i(e,"P",{}),gl(Ce).forEach(l),Be=a(e),p(d.$$.fragment,e),Ge=a(e),p(T.$$.fragment,e),Ae=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1xlqnsv"&&(U.innerHTML=$t),We=a(e),h=i(e,"P",{"data-svelte-h":!0}),M(h)!=="svelte-qt5igr"&&(h.innerHTML=Qt),ke=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1mh34dv"&&(b.innerHTML=Xt),Ne=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-mmy9qo"&&(I.innerHTML=qt),Re=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-176yg59"&&(f.innerHTML=xt),_e=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-fc6q9b"&&(g.textContent=Ht),Ve=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-16cuoal"&&(C.textContent=Ft),Ee=a(e),p(Z.$$.fragment,e),Se=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-64fox6"&&(v.textContent=Yt),$e=a(e),p(B.$$.fragment,e),Qe=a(e),p(G.$$.fragment,e),Xe=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1bnny6u"&&(A.textContent=zt),qe=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1yb5yrl"&&(W.textContent=Lt),xe=a(e),k=i(e,"UL",{"data-svelte-h":!0}),M(k)!=="svelte-3qoj8n"&&(k.innerHTML=Pt),He=a(e),p(N.$$.fragment,e),Fe=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1hg95q8"&&(R.innerHTML=Kt),Ye=a(e),p(_.$$.fragment,e),ze=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1wknlb6"&&(V.innerHTML=Dt),Le=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-19h5931"&&(E.textContent=Ot),Pe=a(e),S=i(e,"UL",{"data-svelte-h":!0}),M(S)!=="svelte-5uub6"&&(S.innerHTML=el),Ke=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1kfx2et"&&($.innerHTML=tl),De=a(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1qw64fs"&&(Q.innerHTML=ll),Oe=a(e),p(X.$$.fragment,e),et=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-jy4i2f"&&(q.textContent=sl),tt=a(e),p(x.$$.fragment,e),lt=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-5pp8py"&&(H.textContent=nl),st=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1cx88lu"&&(F.textContent=al),nt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1vgfwws"&&(Y.textContent=ol),at=a(e),p(z.$$.fragment,e),ot=a(e),L=i(e,"PRE",{"data-svelte-h":!0}),M(L)!=="svelte-crsp42"&&(L.textContent=il),it=a(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1dsjmqj"&&(P.innerHTML=Ml),Mt=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-yb70ev"&&(K.innerHTML=rl),rt=a(e),p(D.$$.fragment,e),pt=a(e),p(O.$$.fragment,e),yt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-19hckuz"&&(ee.innerHTML=pl),ct=a(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1wpkyax"&&(te.innerHTML=yl),ut=a(e),p(le.$$.fragment,e),wt=a(e),p(se.$$.fragment,e),Jt=a(e),p(ne.$$.fragment,e),mt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-6d9ubm"&&(ae.innerHTML=cl),jt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-ud3g55"&&(oe.textContent=ul),dt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-3qqlok"&&(ie.innerHTML=wl),Tt=a(e),p(Me.$$.fragment,e),Ut=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-5kn15r"&&(re.textContent=Jl),ht=a(e),p(pe.$$.fragment,e),bt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-168ebuv"&&(ye.textContent=ml),It=a(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-vscncs"&&(ce.textContent=jl),ft=a(e),p(ue.$$.fragment,e),gt=a(e),we=i(e,"PRE",{"data-svelte-h":!0}),M(we)!=="svelte-eeovy7"&&(we.textContent=dl),Ct=a(e),p(Je.$$.fragment,e),Zt=a(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-6gn5q5"&&(me.innerHTML=Tl),vt=a(e),je=i(e,"OL",{"data-svelte-h":!0}),M(je)!=="svelte-1o7lqh"&&(je.innerHTML=Ul),Bt=a(e),p(de.$$.fragment,e),Gt=a(e),p(Te.$$.fragment,e),At=a(e),Ue=i(e,"PRE",{"data-svelte-h":!0}),M(Ue)!=="svelte-tgqz6q"&&(Ue.textContent=hl),Wt=a(e),p(he.$$.fragment,e),kt=a(e),be=i(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-hpfue3"&&(be.textContent=bl),Nt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-1nxb7v"&&(Ie.innerHTML=Il),Rt=a(e),fe=i(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1ctcozl"&&(fe.textContent=fl),_t=a(e),p(ge.$$.fragment,e),Vt=a(e),Ze=i(e,"P",{}),gl(Ze).forEach(l),this.h()},h(){Cl(m,"name","hf:doc:metadata"),Cl(m,"content",Vl)},m(e,t){kl(document.head,m),s(e,ve,t),s(e,Ce,t),s(e,Be,t),y(d,e,t),s(e,Ge,t),y(T,e,t),s(e,Ae,t),s(e,U,t),s(e,We,t),s(e,h,t),s(e,ke,t),s(e,b,t),s(e,Ne,t),s(e,I,t),s(e,Re,t),s(e,f,t),s(e,_e,t),s(e,g,t),s(e,Ve,t),s(e,C,t),s(e,Ee,t),y(Z,e,t),s(e,Se,t),s(e,v,t),s(e,$e,t),y(B,e,t),s(e,Qe,t),y(G,e,t),s(e,Xe,t),s(e,A,t),s(e,qe,t),s(e,W,t),s(e,xe,t),s(e,k,t),s(e,He,t),y(N,e,t),s(e,Fe,t),s(e,R,t),s(e,Ye,t),y(_,e,t),s(e,ze,t),s(e,V,t),s(e,Le,t),s(e,E,t),s(e,Pe,t),s(e,S,t),s(e,Ke,t),s(e,$,t),s(e,De,t),s(e,Q,t),s(e,Oe,t),y(X,e,t),s(e,et,t),s(e,q,t),s(e,tt,t),y(x,e,t),s(e,lt,t),s(e,H,t),s(e,st,t),s(e,F,t),s(e,nt,t),s(e,Y,t),s(e,at,t),y(z,e,t),s(e,ot,t),s(e,L,t),s(e,it,t),s(e,P,t),s(e,Mt,t),s(e,K,t),s(e,rt,t),y(D,e,t),s(e,pt,t),y(O,e,t),s(e,yt,t),s(e,ee,t),s(e,ct,t),s(e,te,t),s(e,ut,t),y(le,e,t),s(e,wt,t),y(se,e,t),s(e,Jt,t),y(ne,e,t),s(e,mt,t),s(e,ae,t),s(e,jt,t),s(e,oe,t),s(e,dt,t),s(e,ie,t),s(e,Tt,t),y(Me,e,t),s(e,Ut,t),s(e,re,t),s(e,ht,t),y(pe,e,t),s(e,bt,t),s(e,ye,t),s(e,It,t),s(e,ce,t),s(e,ft,t),y(ue,e,t),s(e,gt,t),s(e,we,t),s(e,Ct,t),y(Je,e,t),s(e,Zt,t),s(e,me,t),s(e,vt,t),s(e,je,t),s(e,Bt,t),y(de,e,t),s(e,Gt,t),y(Te,e,t),s(e,At,t),s(e,Ue,t),s(e,Wt,t),y(he,e,t),s(e,kt,t),s(e,be,t),s(e,Nt,t),s(e,Ie,t),s(e,Rt,t),s(e,fe,t),s(e,_t,t),y(ge,e,t),s(e,Vt,t),s(e,Ze,t),Et=!0},p:vl,i(e){Et||(c(d.$$.fragment,e),c(T.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(N.$$.fragment,e),c(_.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),c(ue.$$.fragment,e),c(Je.$$.fragment,e),c(de.$$.fragment,e),c(Te.$$.fragment,e),c(he.$$.fragment,e),c(ge.$$.fragment,e),Et=!0)},o(e){u(d.$$.fragment,e),u(T.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(N.$$.fragment,e),u(_.$$.fragment,e),u(X.$$.fragment,e),u(x.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(Me.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(de.$$.fragment,e),u(Te.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),Et=!1},d(e){e&&(l(ve),l(Ce),l(Be),l(Ge),l(Ae),l(U),l(We),l(h),l(ke),l(b),l(Ne),l(I),l(Re),l(f),l(_e),l(g),l(Ve),l(C),l(Ee),l(Se),l(v),l($e),l(Qe),l(Xe),l(A),l(qe),l(W),l(xe),l(k),l(He),l(Fe),l(R),l(Ye),l(ze),l(V),l(Le),l(E),l(Pe),l(S),l(Ke),l($),l(De),l(Q),l(Oe),l(et),l(q),l(tt),l(lt),l(H),l(st),l(F),l(nt),l(Y),l(at),l(ot),l(L),l(it),l(P),l(Mt),l(K),l(rt),l(pt),l(yt),l(ee),l(ct),l(te),l(ut),l(wt),l(Jt),l(mt),l(ae),l(jt),l(oe),l(dt),l(ie),l(Tt),l(Ut),l(re),l(ht),l(bt),l(ye),l(It),l(ce),l(ft),l(gt),l(we),l(Ct),l(Zt),l(me),l(vt),l(je),l(Bt),l(Gt),l(At),l(Ue),l(Wt),l(kt),l(be),l(Nt),l(Ie),l(Rt),l(fe),l(_t),l(Vt),l(Ze)),l(m),w(d,e),w(T,e),w(Z,e),w(B,e),w(G,e),w(N,e),w(_,e),w(X,e),w(x,e),w(z,e),w(D,e),w(O,e),w(le,e),w(se,e),w(ne,e),w(Me,e),w(pe,e),w(ue,e),w(Je,e),w(de,e),w(Te,e),w(he,e),w(ge,e)}}}const Vl='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"4. Create your own LLM engine (OpenAI)","local":"4-create-your-own-llm-engine-openai","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function El(St){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Gl{constructor(m){super(),Al(this,m,El,_l,Zl,{})}}export{ql as component};
