import{s as xl,n as Ql,o as Bl}from"../chunks/scheduler.71ff668b.js";import{S as kl,i as Zl,g as i,s,r as M,A as Fl,h as p,f as l,c as a,j as Rl,u as o,x as m,k as Gl,y as _l,a as n,v as r,d as u,t as b,w as y}from"../chunks/index.e0973da1.js";import{D as Il,C as U}from"../chunks/DocNotebookDropdown.94ef8762.js";import{H as $t,E as El}from"../chunks/EditOnGithub.73cfc385.js";function Nl(Xe){let f,Rt,Vt,Gt,c,xt,J,Qt,T,He='본문: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a>의 <a href="https://huggingface.co/learn/cookbook/rag_zephyr_langchain" rel="nofollow">Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain</a>을 번역하고, 한국어 모델로 변경했습니다.',Bt,h,We='번역: <a href="https://github.com/jun048098" rel="nofollow">신혁준</a>',kt,d,Se='이 노트북은 <a href="https://huggingface.co/yanolja/EEVE-Korean-Instruct-10.8B-v1.0" rel="nofollow"><code>yanolja/EEVE-Korean-Instruct-10.8B-v1.0</code></a> 모델과 LangChain을 사용하여 프로젝트의 GitHub 이슈에 대한 RAG(검색 기반 생성)를 빠르게 구축하는 방법을 보여줍니다.',Zt,C,Le="<strong>RAG란 무엇인가?</strong>",Ft,w,Ae="RAG는 강력한 대규모 언어 모델(LLM)이 특정 콘텐츠를 인식하지 못하거나 해당 콘텐츠를 훈련 데이터에 포함되지 않아서, 혹은 그 콘텐츠를 본 적이 있어도 잘못된 정보를 생성할 때 이러한 문제를 해결하기 위한 인기 있는 접근 방식입니다. 이러한 특정 콘텐츠는 독점적이거나 민감할 수 있으며, 이 예시와 같이 최근의 자주 업데이트되는 데이터일 수 있습니다.",_t,j,ze="만약 데이터가 정적이고 정기적으로 변경되지 않는 경우, 대규모 모델을 미세 조정(fine-tuning)하는 것을 고려할 수 있습니다. 그러나 많은 경우, 미세 조정은 비용이 많이 들며 데이터 드리프트 문제를 해결하기 위해 반복적으로 수행할 경우 “모델 이동(model shift)“이 발생할 수 있습니다. 이는 모델의 동작이 바람직하지 않은 방식으로 변하는 현상입니다.",It,g,Ye="<strong>RAG (검색 증강 생성)</strong>은 모델의 미세 조정이 필요하지 않습니다. 대신, RAG는 LLM에 추가적인 컨텍스트를 제공하기 위해 관련 데이터를 검색하여 더 잘 정보를 제공하는 응답을 생성할 수 있도록 합니다.",Et,$,qe="다음은 간단한 설명입니다:",Nt,V,Pe='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG 다이어그램"/>',Xt,v,Oe="<li><p>외부 데이터는 별도의 임베딩 모델을 사용해 임베딩 벡터로 변환되며, 벡터는 데이터베이스에 저장됩니다. 임베딩 모델은 일반적으로 작아서 임베딩 벡터를 정기적으로 업데이트하는 것이 모델을 미세 조정하는 것보다 빠르고 저렴하며 간편합니다.</p></li> <li><p>동시에, 미세 조정이 필요하지 않다는 점은 더 강력한 LLM이 출시되면 이를 자유롭게 교체하거나 더 빠른 추론이 필요한 경우 더 작은 증류된 모델로 전환할 수 있는 유연성을 제공합니다.</p></li>",Ht,R,De="이제 오픈 소스 LLM, 임베딩 모델, LangChain을 사용하여 RAG를 구축하는 방법을 살펴보겠습니다.",Wt,G,Ke="먼저, 필요한 의존성을 설치합니다:",St,x,Lt,Q,At,B,zt,k,Yt,Z,tl='이 예시에서는 <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT 라이브러리의 저장소</a>에서 모든 이슈(Open 이슈와 Close 이슈 모두)를 로드할 것입니다.',qt,F,el='먼저, GitHub API에 접근하기 위해 <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub 개인 접근 토큰</a>을 발급받아야 합니다.',Pt,_,Ot,I,ll='다음으로, <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> 저장소의 모든 이슈를 로드하겠습니다:',Dt,E,nl="<li>기본적으로 풀 리퀘스트도 이슈로 간주되지만, <code>include_prs=False</code>로 설정하여 데이터를 가져올 때 이를 제외하도록 설정합니다.</li> <li><code>state = &quot;all&quot;</code>로 설정하면 열린 이슈와 닫힌 이슈 모두를 로드하게 됩니다.</li>",Kt,N,te,X,sl="개별 GitHub 이슈의 내용은 임베딩 모델이 입력으로 받을 수 있는 길이보다 길 수 있습니다. 모든 내용을 임베딩하려면 문서를 적절한 크기의 조각으로 나누어야 합니다.",ee,H,al="가장 일반적이고 간단한 문서 나누기(청킹) 방법은 고정된 크기의 청크를 정의하고, 이 청크별 GitHub 이슈의 내용은 임베딩 모델이 입력으로 받을 수 있는 길이보다 길 수 있습니다. 모든 내용을 임베딩하려면 문서를 적절한 크기의 조각으로 나누어야 합니다.",le,W,il='가장 일반적이고 간단한 문서 나누기(청킹) 방법은 고정된 크기의 청크를 정의하고, 이 청크들 간에 겹침이 있을지 여부를 결정하는 것입니다. 청크들 사이에 일부 내용의 중복을 유지하면 청크들 간의 의미적 문맥을 보존할 수 있습니다. 일반적인 텍스트에 대한 추천 분할기는 <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/recursive_text_splitter" rel="nofollow">RecursiveCharacterTextSplitter</a>이며, 여기에서도 이를 사용할 것입니다.',ne,S,se,L,ae,A,pl="이제 문서가 모두 적절한 크기로 나누어졌으니, 해당 문서들의 임베딩을 사용하여 데이터베이스를 생성할 수 있습니다.",ie,z,ml='문서 조각의 임베딩을 생성하기 위해 <code>HuggingFaceEmbeddings</code>와 <a href="https://huggingface.co/BAAI/bge-m3" rel="nofollow"><code>BAAI/bge-m3</code></a> 임베딩 모델을 사용할 것입니다. Hugging Face Hub에는 이 외에도 다양한 임베딩 모델이 있으며, <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) 리더보드</a>를 통해 성능이 좋은 모델들을 확인할 수 있습니다.',pe,Y,Ml="벡터 데이터베이스를 생성하기 위해서는 Facebook AI가 개발한 <code>FAISS</code> 라이브러리를 사용할 것입니다. 이 라이브러리는 밀집 벡터의 유사성 검색과 클러스터링을 효율적으로 처리하며, 이는 우리가 여기서 필요한 기능입니다. FAISS는 현재 대규모 데이터셋에서 최근접 이웃(NN) 검색을 위해 가장 널리 사용되는 라이브러리 중 하나입니다.",me,q,ol="우리는 LangChain API를 통해 임베딩 모델과 FAISS에 접근할 것입니다.",Me,P,oe,O,rl="비정형 쿼리를 입력받아 해당 문서를 반환(검색)할 방법이 필요합니다. 이를 위해 <code>db</code>를 백엔드로 사용하여 <code>as_retriever</code> 메서드를 사용할 것입니다:",re,D,ul="<li><code>search_type=&quot;similarity&quot;</code>는 쿼리와 문서 사이의 유사성 검색을 수행하고자 한다는 것을 의미합니다.</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code>는 검색기가 상위 4개의 결과를 반환하도록 지시하는 설정입니다.</li>",ue,K,be,tt,bl="벡터 데이터베이스와 검색기가 설정되었으니, 이제 체인의 다음 부분인 모델을 설정해야 합니다.",ye,et,Ue,lt,yl='이번 예시에서는 한국어 모델로 <a href="https://huggingface.co/yanolja/EEVE-Korean-Instruct-10.8B-v1.0" rel="nofollow"><code>yanolja/EEVE-Korean-Instruct-10.8B-v1.0</code></a>를 선택했습니다.',fe,nt,Ul='매주 여러 모델이 새롭게 출시되므로, 최신 모델로 교체하고 싶을 수 있습니다. 오픈소스 LLM의 최신 동향을 파악하는 가장 좋은 방법은 [한국어 오픈소스 LLM 리더보드](<a href="https://huggingface.co/spaces/upstage/open-ko-llm-leaderboard" rel="nofollow">https://huggingface.co/spaces/upstage/open-ko-llm-leaderboard</a>, <a href="https://lk.instruct.kr/)%EB%A5%BC" rel="nofollow">https://lk.instruct.kr/)를</a> 확인하는 것입니다.',ce,st,fl="추론 속도를 빠르게 하고, Colab 실행을 위해서 양자화된 버전의 모델을 로드할 것입니다:",Je,at,Te,it,he,pt,cl="마침내, LLM 체인을 설정하는 데 필요한 모든 구성 요소가 준비되었습니다.",de,mt,Jl="먼저, 로드한 모델과 해당 토크나이저를 사용하여 <code>text_generation</code> 파이프라인을 생성합니다.",Ce,Mt,Tl="다음으로, 프롬프트 템플릿을 만듭니다. 이 템플릿은 모델의 형식을 따라야 하므로, 모델 체크포인트를 교체할 경우 적절한 형식을 사용하도록 해야 합니다.",we,ot,je,rt,hl="참고: <em>메시지 리스트(딕셔너리 형태: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>)를 적절한 채팅 형식의 문자열로 변환하려면 <code>tokenizer.apply_chat_template</code>를 사용할 수 있습니다.</em>",ge,ut,dl="마지막으로, <code>llm_chain</code>과 검색기를 결합하여 RAG 체인을 생성해야 합니다. 원본 질문과 검색된 문서들을 최종 생성 단계로 전달합니다:",$e,bt,Ve,yt,ve,Ut,Cl="RAG가 라이브러리 관련 질문에 대한 답변을 생성하는 데 어떤 차이를 만드는지 살펴보겠습니다.",Re,ft,wl="수집한 PEFT 라이브러리의 이슈가 영어로 작성되어서 영어로 질문하여 문서를 검색합니다.",Ge,ct,jl="프롬프트로 답변은 한글로 나오도록 합니다.",xe,Jt,Qe,Tt,gl="먼저, 컨텍스트를 추가하지 않고 모델 자체만으로 어떤 답변을 얻을 수 있는지 살펴보겠습니다:",Be,ht,ke,dt,$l=`모델은 질문을 전기를 공급하는 어댑터에 관한 것으로 해석했지만, PEFT의 맥락에서 “adapters”는 LoRA 어댑터를 의미합니다.<br/>
GitHub 이슈를 검색해 컨텍스트를 추가하면 모델이 더 관련성 높은 답변을 제공할 수 있는지 확인해 보겠습니다:`,Ze,Ct,Fe,wt,Vl="보시다시피, 컨텍스트를 추가하면 동일한 모델이 라이브러리 관련 질문에 대해 훨씬 더 관련성 있고 정보에 기반한 답변을 제공하는 데 큰 도움이 됩니다.",_e,jt,vl="특히, 여러 어댑터를 결합하여 추론하는 기능이 라이브러리에 추가되었으며, 이 정보는 검색된 문서에서 찾을 수 있습니다. 따라서 RAG로 문서 임베딩을 포함하는 것이 유용할 수 있습니다.",Ie,gt,Ee,vt,Ne;return c=new Il({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/ko/rag_zephyr_langchain.ipynb"}]}}),J=new $t({props:{title:"GitHub 이슈를 위한 EEVE와 LangChain을 사용한 간단한 RAG",local:"github-이슈를-위한-eeve와-langchain을-사용한-간단한-rag",headingTag:"h1"}}),x=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),Q=new U({props:{code:"JTIzJTIwR29vZ2xlJTIwQ29sYWIlRUMlOTclOTAlRUMlODQlOUMlMjAlRUMlOEIlQTQlRUQlOTYlODklRUQlOTUlOTglRUIlOEElOTQlMjAlRUElQjIlQkQlRUMlOUElQjAlMjBMYW5nQ2hhaW4lRUMlOUQlODQlMjAlRUMlODQlQTQlRUMlQjklOTglRUQlOTUlOTglRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlQjQlMjBVVEYtOCUyMCVFQiVBMSU5QyVFQyVCQyU4MCVFQyU5RCVCQyVFQyU5RCU4NCUyMCVFQyU4MiVBQyVFQyU5QSVBOSVFRCU5NSU5OCVFQSVCMyVBMCUyMCVFQyU5RSU4OCVFQiU4QSU5NCVFQyVBNyU4MCUyMCVFRCU5OSU5NSVFQyU5RCVCOCVFRCU5NSU5OCVFQSVCOCVCMCUyMCVFQyU5QyU4NCVFRCU5NSVCNCUyMCVFQyU5RCVCNCUyMCVFQyU4NSU4MCVFQyU5RCU4NCUyMCVFQyU4QiVBNCVFRCU5NiU4OSVFRCU5NSVCNCVFQyU5NSVCQyUyMCVFRCU5NSVBMCUyMCVFQyU4OCU5OCVFQiU4RiU4NCUyMCVFQyU5RSU4OCVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># Google Colab에서 실행하는 경우 LangChain을 설치하기 위해 UTF-8 로케일을 사용하고 있는지 확인하기 위해 이 셀을 실행해야 할 수도 있습니다.</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),B=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbiUyMGxhbmdjaGFpbi1jb21tdW5pdHk=",highlighted:"!pip install -q langchain langchain-community",wrap:!1}}),k=new $t({props:{title:"데이터 준비",local:"데이터-준비",headingTag:"h2"}}),_=new U({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),N=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),S=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

splitter = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),L=new $t({props:{title:"임베딩 및 검색기 생성",local:"임베딩-및-검색기-생성",headingTag:"h2"}}),P=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),K=new U({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),et=new $t({props:{title:"양자화된 모델 로드",local:"양자화된-모델-로드",headingTag:"h2"}}),at=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnlhbm9samElMkZFRVZFLUtvcmVhbi1JbnN0cnVjdC0xMC44Qi12MS4wJTIyJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;yanolja/EEVE-Korean-Instruct-10.8B-v1.0&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),it=new $t({props:{title:"LLM 체인 설정",local:"llm-체인-설정",headingTag:"h2"}}),ot=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjB1c2VyJTIwYW5kJTIwYW4lMjBhcnRpZmljaWFsJTIwaW50ZWxsaWdlbmNlJTIwYXNzaXN0YW50LiUyMFRoZSUyMGFzc2lzdGFudCUyMGdpdmVzJTIwaGVscGZ1bCUyQyUyMGRldGFpbGVkJTJDJTIwYW5kJTIwcG9saXRlJTIwYW5zd2VycyUyMHRvJTIwdGhlJTIwdXNlcidzJTIwcXVlc3Rpb25zLiUwQUh1bWFuJTNBJTIwQ29udGV4dCVFQiVBNSVCQyUyMCVFQyU5RCVCRCVFQSVCMyVBMCUyMFF1ZXN0aW9uJUVDJTk3JTkwJTIwJUVEJTk1JTlDJUVBJUI1JUFEJUVDJTk2JUI0JUVCJUExJTlDJTIwJUVCJThCJUI1JUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0LiUwQUNvbnRleHQlM0ElMjAlN0Jjb250ZXh0JTdEJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUwQUFzc2lzdGFudCUzQSU1Q24lMEElMjIlMjIlMjIlMEElMEFwcm9tcHQlMjAlM0QlMjBQcm9tcHRUZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF92YXJpYWJsZXMlM0QlNUIlMjJjb250ZXh0JTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZW1wbGF0ZSUzRHByb21wdF90ZW1wbGF0ZSUyQyUwQSklMEElMEFsbG1fY2hhaW4lMjAlM0QlMjBwcm9tcHQlMjAlN0MlMjBsbG0lMjAlN0MlMjBTdHJPdXRwdXRQYXJzZXIoKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
A chat between a curious user and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the user&#x27;s questions.
Human: Context를 읽고 Question에 한국어로 답하세요.
Context: {context}
Question: {question}
Assistant:\\n
&quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),bt=new U({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCU3QiUyMmNvbnRleHQlMjIlM0ElMjByZXRyaWV2ZXIlMkMlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMFJ1bm5hYmxlUGFzc3Rocm91Z2goKSU3RCUyMCU3QyUyMGxsbV9jaGFpbg==",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),yt=new $t({props:{title:"결과 비교",local:"결과-비교",headingTag:"h2"}}),Jt=new U({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),ht=new U({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),Ct=new U({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),gt=new El({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/ko/rag_zephyr_langchain.md"}}),{c(){f=i("meta"),Rt=s(),Vt=i("p"),Gt=s(),M(c.$$.fragment),xt=s(),M(J.$$.fragment),Qt=s(),T=i("p"),T.innerHTML=He,Bt=s(),h=i("p"),h.innerHTML=We,kt=s(),d=i("p"),d.innerHTML=Se,Zt=s(),C=i("p"),C.innerHTML=Le,Ft=s(),w=i("p"),w.textContent=Ae,_t=s(),j=i("p"),j.textContent=ze,It=s(),g=i("p"),g.innerHTML=Ye,Et=s(),$=i("p"),$.textContent=qe,Nt=s(),V=i("p"),V.innerHTML=Pe,Xt=s(),v=i("ul"),v.innerHTML=Oe,Ht=s(),R=i("p"),R.textContent=De,Wt=s(),G=i("p"),G.textContent=Ke,St=s(),M(x.$$.fragment),Lt=s(),M(Q.$$.fragment),At=s(),M(B.$$.fragment),zt=s(),M(k.$$.fragment),Yt=s(),Z=i("p"),Z.innerHTML=tl,qt=s(),F=i("p"),F.innerHTML=el,Pt=s(),M(_.$$.fragment),Ot=s(),I=i("p"),I.innerHTML=ll,Dt=s(),E=i("ul"),E.innerHTML=nl,Kt=s(),M(N.$$.fragment),te=s(),X=i("p"),X.textContent=sl,ee=s(),H=i("p"),H.textContent=al,le=s(),W=i("p"),W.innerHTML=il,ne=s(),M(S.$$.fragment),se=s(),M(L.$$.fragment),ae=s(),A=i("p"),A.textContent=pl,ie=s(),z=i("p"),z.innerHTML=ml,pe=s(),Y=i("p"),Y.innerHTML=Ml,me=s(),q=i("p"),q.textContent=ol,Me=s(),M(P.$$.fragment),oe=s(),O=i("p"),O.innerHTML=rl,re=s(),D=i("ul"),D.innerHTML=ul,ue=s(),M(K.$$.fragment),be=s(),tt=i("p"),tt.textContent=bl,ye=s(),M(et.$$.fragment),Ue=s(),lt=i("p"),lt.innerHTML=yl,fe=s(),nt=i("p"),nt.innerHTML=Ul,ce=s(),st=i("p"),st.textContent=fl,Je=s(),M(at.$$.fragment),Te=s(),M(it.$$.fragment),he=s(),pt=i("p"),pt.textContent=cl,de=s(),mt=i("p"),mt.innerHTML=Jl,Ce=s(),Mt=i("p"),Mt.textContent=Tl,we=s(),M(ot.$$.fragment),je=s(),rt=i("p"),rt.innerHTML=hl,ge=s(),ut=i("p"),ut.innerHTML=dl,$e=s(),M(bt.$$.fragment),Ve=s(),M(yt.$$.fragment),ve=s(),Ut=i("p"),Ut.textContent=Cl,Re=s(),ft=i("p"),ft.textContent=wl,Ge=s(),ct=i("p"),ct.textContent=jl,xe=s(),M(Jt.$$.fragment),Qe=s(),Tt=i("p"),Tt.textContent=gl,Be=s(),M(ht.$$.fragment),ke=s(),dt=i("p"),dt.innerHTML=$l,Ze=s(),M(Ct.$$.fragment),Fe=s(),wt=i("p"),wt.textContent=Vl,_e=s(),jt=i("p"),jt.textContent=vl,Ie=s(),M(gt.$$.fragment),Ee=s(),vt=i("p"),this.h()},l(t){const e=Fl("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(l),Rt=a(t),Vt=p(t,"P",{}),Rl(Vt).forEach(l),Gt=a(t),o(c.$$.fragment,t),xt=a(t),o(J.$$.fragment,t),Qt=a(t),T=p(t,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1nfrzmd"&&(T.innerHTML=He),Bt=a(t),h=p(t,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1sa2xxj"&&(h.innerHTML=We),kt=a(t),d=p(t,"P",{"data-svelte-h":!0}),m(d)!=="svelte-ka828j"&&(d.innerHTML=Se),Zt=a(t),C=p(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1n1t81"&&(C.innerHTML=Le),Ft=a(t),w=p(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-10ga0ii"&&(w.textContent=Ae),_t=a(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-6qz5es"&&(j.textContent=ze),It=a(t),g=p(t,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1671lfy"&&(g.innerHTML=Ye),Et=a(t),$=p(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1iie3uw"&&($.textContent=qe),Nt=a(t),V=p(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1mgszfw"&&(V.innerHTML=Pe),Xt=a(t),v=p(t,"UL",{"data-svelte-h":!0}),m(v)!=="svelte-kgp79v"&&(v.innerHTML=Oe),Ht=a(t),R=p(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1sb91xu"&&(R.textContent=De),Wt=a(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-mf3g6w"&&(G.textContent=Ke),St=a(t),o(x.$$.fragment,t),Lt=a(t),o(Q.$$.fragment,t),At=a(t),o(B.$$.fragment,t),zt=a(t),o(k.$$.fragment,t),Yt=a(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-xd3fji"&&(Z.innerHTML=tl),qt=a(t),F=p(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1hoyze8"&&(F.innerHTML=el),Pt=a(t),o(_.$$.fragment,t),Ot=a(t),I=p(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1ft022z"&&(I.innerHTML=ll),Dt=a(t),E=p(t,"UL",{"data-svelte-h":!0}),m(E)!=="svelte-14a2405"&&(E.innerHTML=nl),Kt=a(t),o(N.$$.fragment,t),te=a(t),X=p(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-si1zim"&&(X.textContent=sl),ee=a(t),H=p(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1ugvyb3"&&(H.textContent=al),le=a(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1bk5vub"&&(W.innerHTML=il),ne=a(t),o(S.$$.fragment,t),se=a(t),o(L.$$.fragment,t),ae=a(t),A=p(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-8e0o97"&&(A.textContent=pl),ie=a(t),z=p(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-t79ewh"&&(z.innerHTML=ml),pe=a(t),Y=p(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-jkyafg"&&(Y.innerHTML=Ml),me=a(t),q=p(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-19bgymi"&&(q.textContent=ol),Me=a(t),o(P.$$.fragment,t),oe=a(t),O=p(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1hrik01"&&(O.innerHTML=rl),re=a(t),D=p(t,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-11idja7"&&(D.innerHTML=ul),ue=a(t),o(K.$$.fragment,t),be=a(t),tt=p(t,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1wn2xq7"&&(tt.textContent=bl),ye=a(t),o(et.$$.fragment,t),Ue=a(t),lt=p(t,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-nncb7n"&&(lt.innerHTML=yl),fe=a(t),nt=p(t,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-8ybpgc"&&(nt.innerHTML=Ul),ce=a(t),st=p(t,"P",{"data-svelte-h":!0}),m(st)!=="svelte-15uzghm"&&(st.textContent=fl),Je=a(t),o(at.$$.fragment,t),Te=a(t),o(it.$$.fragment,t),he=a(t),pt=p(t,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-y6rc2w"&&(pt.textContent=cl),de=a(t),mt=p(t,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1p4m1m4"&&(mt.innerHTML=Jl),Ce=a(t),Mt=p(t,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-4je54k"&&(Mt.textContent=Tl),we=a(t),o(ot.$$.fragment,t),je=a(t),rt=p(t,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-j3fp7m"&&(rt.innerHTML=hl),ge=a(t),ut=p(t,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-19xo7cv"&&(ut.innerHTML=dl),$e=a(t),o(bt.$$.fragment,t),Ve=a(t),o(yt.$$.fragment,t),ve=a(t),Ut=p(t,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-qirnt8"&&(Ut.textContent=Cl),Re=a(t),ft=p(t,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1owfvqc"&&(ft.textContent=wl),Ge=a(t),ct=p(t,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-9vywbl"&&(ct.textContent=jl),xe=a(t),o(Jt.$$.fragment,t),Qe=a(t),Tt=p(t,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1sgap1m"&&(Tt.textContent=gl),Be=a(t),o(ht.$$.fragment,t),ke=a(t),dt=p(t,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-1mpcpjd"&&(dt.innerHTML=$l),Ze=a(t),o(Ct.$$.fragment,t),Fe=a(t),wt=p(t,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-121m37b"&&(wt.textContent=Vl),_e=a(t),jt=p(t,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-3b4clz"&&(jt.textContent=vl),Ie=a(t),o(gt.$$.fragment,t),Ee=a(t),vt=p(t,"P",{}),Rl(vt).forEach(l),this.h()},h(){Gl(f,"name","hf:doc:metadata"),Gl(f,"content",Xl)},m(t,e){_l(document.head,f),n(t,Rt,e),n(t,Vt,e),n(t,Gt,e),r(c,t,e),n(t,xt,e),r(J,t,e),n(t,Qt,e),n(t,T,e),n(t,Bt,e),n(t,h,e),n(t,kt,e),n(t,d,e),n(t,Zt,e),n(t,C,e),n(t,Ft,e),n(t,w,e),n(t,_t,e),n(t,j,e),n(t,It,e),n(t,g,e),n(t,Et,e),n(t,$,e),n(t,Nt,e),n(t,V,e),n(t,Xt,e),n(t,v,e),n(t,Ht,e),n(t,R,e),n(t,Wt,e),n(t,G,e),n(t,St,e),r(x,t,e),n(t,Lt,e),r(Q,t,e),n(t,At,e),r(B,t,e),n(t,zt,e),r(k,t,e),n(t,Yt,e),n(t,Z,e),n(t,qt,e),n(t,F,e),n(t,Pt,e),r(_,t,e),n(t,Ot,e),n(t,I,e),n(t,Dt,e),n(t,E,e),n(t,Kt,e),r(N,t,e),n(t,te,e),n(t,X,e),n(t,ee,e),n(t,H,e),n(t,le,e),n(t,W,e),n(t,ne,e),r(S,t,e),n(t,se,e),r(L,t,e),n(t,ae,e),n(t,A,e),n(t,ie,e),n(t,z,e),n(t,pe,e),n(t,Y,e),n(t,me,e),n(t,q,e),n(t,Me,e),r(P,t,e),n(t,oe,e),n(t,O,e),n(t,re,e),n(t,D,e),n(t,ue,e),r(K,t,e),n(t,be,e),n(t,tt,e),n(t,ye,e),r(et,t,e),n(t,Ue,e),n(t,lt,e),n(t,fe,e),n(t,nt,e),n(t,ce,e),n(t,st,e),n(t,Je,e),r(at,t,e),n(t,Te,e),r(it,t,e),n(t,he,e),n(t,pt,e),n(t,de,e),n(t,mt,e),n(t,Ce,e),n(t,Mt,e),n(t,we,e),r(ot,t,e),n(t,je,e),n(t,rt,e),n(t,ge,e),n(t,ut,e),n(t,$e,e),r(bt,t,e),n(t,Ve,e),r(yt,t,e),n(t,ve,e),n(t,Ut,e),n(t,Re,e),n(t,ft,e),n(t,Ge,e),n(t,ct,e),n(t,xe,e),r(Jt,t,e),n(t,Qe,e),n(t,Tt,e),n(t,Be,e),r(ht,t,e),n(t,ke,e),n(t,dt,e),n(t,Ze,e),r(Ct,t,e),n(t,Fe,e),n(t,wt,e),n(t,_e,e),n(t,jt,e),n(t,Ie,e),r(gt,t,e),n(t,Ee,e),n(t,vt,e),Ne=!0},p:Ql,i(t){Ne||(u(c.$$.fragment,t),u(J.$$.fragment,t),u(x.$$.fragment,t),u(Q.$$.fragment,t),u(B.$$.fragment,t),u(k.$$.fragment,t),u(_.$$.fragment,t),u(N.$$.fragment,t),u(S.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(at.$$.fragment,t),u(it.$$.fragment,t),u(ot.$$.fragment,t),u(bt.$$.fragment,t),u(yt.$$.fragment,t),u(Jt.$$.fragment,t),u(ht.$$.fragment,t),u(Ct.$$.fragment,t),u(gt.$$.fragment,t),Ne=!0)},o(t){b(c.$$.fragment,t),b(J.$$.fragment,t),b(x.$$.fragment,t),b(Q.$$.fragment,t),b(B.$$.fragment,t),b(k.$$.fragment,t),b(_.$$.fragment,t),b(N.$$.fragment,t),b(S.$$.fragment,t),b(L.$$.fragment,t),b(P.$$.fragment,t),b(K.$$.fragment,t),b(et.$$.fragment,t),b(at.$$.fragment,t),b(it.$$.fragment,t),b(ot.$$.fragment,t),b(bt.$$.fragment,t),b(yt.$$.fragment,t),b(Jt.$$.fragment,t),b(ht.$$.fragment,t),b(Ct.$$.fragment,t),b(gt.$$.fragment,t),Ne=!1},d(t){t&&(l(Rt),l(Vt),l(Gt),l(xt),l(Qt),l(T),l(Bt),l(h),l(kt),l(d),l(Zt),l(C),l(Ft),l(w),l(_t),l(j),l(It),l(g),l(Et),l($),l(Nt),l(V),l(Xt),l(v),l(Ht),l(R),l(Wt),l(G),l(St),l(Lt),l(At),l(zt),l(Yt),l(Z),l(qt),l(F),l(Pt),l(Ot),l(I),l(Dt),l(E),l(Kt),l(te),l(X),l(ee),l(H),l(le),l(W),l(ne),l(se),l(ae),l(A),l(ie),l(z),l(pe),l(Y),l(me),l(q),l(Me),l(oe),l(O),l(re),l(D),l(ue),l(be),l(tt),l(ye),l(Ue),l(lt),l(fe),l(nt),l(ce),l(st),l(Je),l(Te),l(he),l(pt),l(de),l(mt),l(Ce),l(Mt),l(we),l(je),l(rt),l(ge),l(ut),l($e),l(Ve),l(ve),l(Ut),l(Re),l(ft),l(Ge),l(ct),l(xe),l(Qe),l(Tt),l(Be),l(ke),l(dt),l(Ze),l(Fe),l(wt),l(_e),l(jt),l(Ie),l(Ee),l(vt)),l(f),y(c,t),y(J,t),y(x,t),y(Q,t),y(B,t),y(k,t),y(_,t),y(N,t),y(S,t),y(L,t),y(P,t),y(K,t),y(et,t),y(at,t),y(it,t),y(ot,t),y(bt,t),y(yt,t),y(Jt,t),y(ht,t),y(Ct,t),y(gt,t)}}}const Xl='{"title":"GitHub 이슈를 위한 EEVE와 LangChain을 사용한 간단한 RAG","local":"github-이슈를-위한-eeve와-langchain을-사용한-간단한-rag","sections":[{"title":"데이터 준비","local":"데이터-준비","sections":[],"depth":2},{"title":"임베딩 및 검색기 생성","local":"임베딩-및-검색기-생성","sections":[],"depth":2},{"title":"양자화된 모델 로드","local":"양자화된-모델-로드","sections":[],"depth":2},{"title":"LLM 체인 설정","local":"llm-체인-설정","sections":[],"depth":2},{"title":"결과 비교","local":"결과-비교","sections":[],"depth":2}],"depth":1}';function Hl(Xe){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends kl{constructor(f){super(),Zl(this,f,Hl,Nl,xl,{})}}export{zl as component};
