import{s as Kl,n as Ol,o as ls}from"../chunks/scheduler.39a43cde.js";import{S as ss,i as es,g as a,s as t,r as j,A as Ms,h as y,f as e,c as n,j as Pl,u as U,x as p,k as Dl,y as ts,a as M,v as J,d as c,t as T,w}from"../chunks/index.23ec2204.js";import{D as ns,C as P}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as F,E as as}from"../chunks/EditOnGithub.f2d09226.js";function ys(Bl){let o,D,L,K,i,O,m,ll,I,El='<em>作者: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',sl,C,Vl='<p>本教程建立在智能体知识的基础上：要了解更多关于智能体的信息，你可以从<a href="agents">这里介绍</a>开始。</p>',el,r,Wl='<a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">Transformers Agents</a> 是一个用于构建智能体的库，它使用 LLM 在 <code>llm_engine</code> 参数中提供动力。这个参数的设计是为了给用户最大的自由度去选择任意 LLM。',Ml,A,kl="让我们看看如何从一些主要提供商的 API 中构建这个 <code>llm_engine</code>。",tl,b,nl,u,Gl="Transformers Agents 提供了一个内置的 <code>HfEngine</code> 类，允许你通过无服务器 API 或你自己的专用端点使用 Hub 上的任何模型。这是使用 HF 智能体的首选方式。",al,d,yl,h,zl=`['unicodedata', 're', 'math', 'collections', 'queue', 'itertools', 'random', 'time', 'stat', 'statistics']
`,pl,f,Xl="智能体的 <code>llm_engine</code> 初始化参数可以是一个简单的可调用对象，如下所示：",jl,Z,Ul,_,Ql="这个可调用对象是 llm 引擎的核心。它应该满足以下要求：",Jl,g,Sl='<li>以 <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">聊天模板</a> 格式的消息列表作为输入，并输出一个 <code>str</code>。</li> <li>接受一个 <code>stop_sequences</code> 参数，智能体系统将传递给它应该停止生成的序列。</li>',cl,N,Rl="让我们更仔细地看看我们使用的 <code>HfEngine</code> 的代码：",Tl,B,wl,E,vl="在这里，引擎不是一个函数，而是一个带有 <code>__call__</code> 方法的类，这使得存储诸如客户端之类的属性成为可能。",ol,V,$l=`我们还使用了 <code>get_clean_message_list()</code> 实用工具来将连续的消息连接到同一个角色。
这个方法接受一个 <code>role_conversions</code> 参数，用于将 Transformers 智能体支持的角色的范围转换为你的 LLM 所接受的那些角色。`,il,W,Yl="这个配方可以适用于任何 LLM！让我们看看其他例子。",ml,k,Il,G,Hl=`使用上述配方，你可以使用任何 LLM 推理源作为你的 <code>llm_engine</code>。
只需记住两个主要约束：`,Cl,z,xl='<li><code>llm_engine</code> 是一个可调用对象，它以 <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">聊天模板</a> 格式的消息列表作为输入，并输出一个 <code>str</code>。</li> <li>它接受一个 <code>stop_sequences</code> 参数。</li>',rl,X,Al,Q,bl,S,ul,R,dl,v,hl,$,Fl="现在去为你自己选择的那个语言模型推理服务，用 <code>transformers.agents</code> 做一个 <code>llm_engine</code> 吧！",fl,Y,Ll="做好之后，你可以用这个新的 <code>llm_engine</code> 来玩玩这些应用场景：",Zl,H,ql='<li><a href="agent_rag">智能体 RAG：通过查询重构和自查询来增强你的 RAG</a></li> <li><a href="agent_text_to_sql">用于文本到 SQL 的智能体，带自动错误校正</a></li>',_l,x,gl,q,Nl;return i=new ns({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_change_llm.ipynb"}]}}),m=new F({props:{title:"从任意的 LLM 推理提供商中创建一个 Transformers 智能体",local:"从任意的-llm-推理提供商中创建一个-transformers-智能体",headingTag:"h1"}}),b=new F({props:{title:"HuggingFace 无服务器 API 和专用端点",local:"huggingface-无服务器-api-和专用端点",headingTag:"h2"}}),d=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0Q29kZUFnZW50JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMEFlbmRwb2ludF91cmwlMjAlM0QlMjAlMjJ5b3VyX2VuZHBvaW50X3VybCUyMiUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZShtb2RlbCUzRHJlcG9faWQpJTIwJTIwJTIzJTIweW91JTIwY291bGQlMjB1c2UlMjBtb2RlbCUzRGVuZHBvaW50X3VybCUyMGhlcmUlMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMDEwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_url = <span class="hljs-string">&quot;your_endpoint_url&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(model=repo_id)  <span class="hljs-comment"># you could use model=endpoint_url here</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[], llm_engine=llm_engine)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;What&#x27;s the 10th Fibonacci number?&quot;</span>)`,wrap:!1}}),Z=new P({props:{code:"ZGVmJTIwbGxtX2VuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZShtZXNzYWdlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">llm_engine</span>(<span class="hljs-params">messages, stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> response(messages)`,wrap:!1}}),B=new P({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

llama_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HfEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span></span>):
        self.model = model
        self.client = InferenceClient(model=self.model, timeout=<span class="hljs-number">120</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]], stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=llama_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1500</span>)
        response = response.choices[<span class="hljs-number">0</span>].message.content

        <span class="hljs-comment"># Remove stop sequences from LLM output</span>
        <span class="hljs-keyword">for</span> stop_seq <span class="hljs-keyword">in</span> stop_sequences:
            <span class="hljs-keyword">if</span> response[-<span class="hljs-built_in">len</span>(stop_seq) :] == stop_seq:
                response = response[: -<span class="hljs-built_in">len</span>(stop_seq)]
        <span class="hljs-keyword">return</span> response`,wrap:!1}}),k=new F({props:{title:"为任何 LLM 适配配方",local:"为任何-llm-适配配方",headingTag:"h2"}}),X=new F({props:{title:"OpenAI",local:"openai",headingTag:"h3"}}),Q=new P({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX3JvbGVfY29udmVyc2lvbnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBNZXNzYWdlUm9sZS5UT09MX1JFU1BPTlNFJTNBJTIwTWVzc2FnZVJvbGUuVVNFUiUyQyUwQSU3RCUwQSUwQSUwQWNsYXNzJTIwT3BlbkFJRW5naW5lJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1vZGVsX25hbWUlM0QlMjJncHQtNG8lMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwbW9kZWxfbmFtZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwZ2V0X2NsZWFuX21lc3NhZ2VfbGlzdChtZXNzYWdlcyUyQyUyMHJvbGVfY29udmVyc2lvbnMlM0RvcGVuYWlfcm9sZV9jb252ZXJzaW9ucyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHNlbGYuY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEc2VsZi5tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0RtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0b3AlM0RzdG9wX3NlcXVlbmNlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmNob2ljZXMlNUIwJTVELm1lc3NhZ2UuY29udGVudA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content`,wrap:!1}}),S=new F({props:{title:"Anthropic",local:"anthropic",headingTag:"h3"}}),R=new P({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> anthropic <span class="hljs-keyword">import</span> Anthropic, AnthropicBedrock


<span class="hljs-comment"># Cf this page for using Anthropic from Bedrock: https://docs.anthropic.com/en/api/claude-on-amazon-bedrock</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AnthropicEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;claude-3-5-sonnet-20240620&quot;</span>, use_bedrock=<span class="hljs-literal">False</span></span>):
        self.model_name = model_name
        <span class="hljs-keyword">if</span> use_bedrock:
            self.model_name = <span class="hljs-string">&quot;anthropic.claude-3-5-sonnet-20240620-v1:0&quot;</span>
            self.client = AnthropicBedrock(
                aws_access_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_ID&quot;</span>),
                aws_secret_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_KEY&quot;</span>),
                aws_region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
            )
        <span class="hljs-keyword">else</span>:
            self.client = Anthropic(
                api_key=os.getenv(<span class="hljs-string">&quot;ANTHROPIC_API_KEY&quot;</span>),
            )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)
        index_system_message, system_prompt = <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>
        <span class="hljs-keyword">for</span> index, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
            <span class="hljs-keyword">if</span> message[<span class="hljs-string">&quot;role&quot;</span>] == MessageRole.SYSTEM:
                index_system_message = index
                system_prompt = message[<span class="hljs-string">&quot;content&quot;</span>]
        <span class="hljs-keyword">if</span> system_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">&quot;No system prompt found!&quot;</span>)

        filtered_messages = [message <span class="hljs-keyword">for</span> i, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages) <span class="hljs-keyword">if</span> i != index_system_message]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(filtered_messages) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Error, no user message:&quot;</span>, messages)
            <span class="hljs-keyword">assert</span> <span class="hljs-literal">False</span>

        response = self.client.messages.create(
            model=self.model_name,
            system=system_prompt,
            messages=filtered_messages,
            stop_sequences=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
            max_tokens=<span class="hljs-number">2000</span>,
        )
        full_response_text = <span class="hljs-string">&quot;&quot;</span>
        <span class="hljs-keyword">for</span> content_block <span class="hljs-keyword">in</span> response.content:
            <span class="hljs-keyword">if</span> content_block.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;text&quot;</span>:
                full_response_text += content_block.text
        <span class="hljs-keyword">return</span> full_response_text`,wrap:!1}}),v=new F({props:{title:"下一步",local:"下一步",headingTag:"h3"}}),x=new as({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_change_llm.md"}}),{c(){o=a("meta"),D=t(),L=a("p"),K=t(),j(i.$$.fragment),O=t(),j(m.$$.fragment),ll=t(),I=a("p"),I.innerHTML=El,sl=t(),C=a("blockquote"),C.innerHTML=Vl,el=t(),r=a("p"),r.innerHTML=Wl,Ml=t(),A=a("p"),A.innerHTML=kl,tl=t(),j(b.$$.fragment),nl=t(),u=a("p"),u.innerHTML=Gl,al=t(),j(d.$$.fragment),yl=t(),h=a("pre"),h.textContent=zl,pl=t(),f=a("p"),f.innerHTML=Xl,jl=t(),j(Z.$$.fragment),Ul=t(),_=a("p"),_.textContent=Ql,Jl=t(),g=a("ul"),g.innerHTML=Sl,cl=t(),N=a("p"),N.innerHTML=Rl,Tl=t(),j(B.$$.fragment),wl=t(),E=a("p"),E.innerHTML=vl,ol=t(),V=a("p"),V.innerHTML=$l,il=t(),W=a("p"),W.textContent=Yl,ml=t(),j(k.$$.fragment),Il=t(),G=a("p"),G.innerHTML=Hl,Cl=t(),z=a("ul"),z.innerHTML=xl,rl=t(),j(X.$$.fragment),Al=t(),j(Q.$$.fragment),bl=t(),j(S.$$.fragment),ul=t(),j(R.$$.fragment),dl=t(),j(v.$$.fragment),hl=t(),$=a("p"),$.innerHTML=Fl,fl=t(),Y=a("p"),Y.innerHTML=Ll,Zl=t(),H=a("ul"),H.innerHTML=ql,_l=t(),j(x.$$.fragment),gl=t(),q=a("p"),this.h()},l(l){const s=Ms("svelte-u9bgzb",document.head);o=y(s,"META",{name:!0,content:!0}),s.forEach(e),D=n(l),L=y(l,"P",{}),Pl(L).forEach(e),K=n(l),U(i.$$.fragment,l),O=n(l),U(m.$$.fragment,l),ll=n(l),I=y(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ouqjzx"&&(I.innerHTML=El),sl=n(l),C=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(C)!=="svelte-e3usgd"&&(C.innerHTML=Vl),el=n(l),r=y(l,"P",{"data-svelte-h":!0}),p(r)!=="svelte-e79xia"&&(r.innerHTML=Wl),Ml=n(l),A=y(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-soqksk"&&(A.innerHTML=kl),tl=n(l),U(b.$$.fragment,l),nl=n(l),u=y(l,"P",{"data-svelte-h":!0}),p(u)!=="svelte-159gjzi"&&(u.innerHTML=Gl),al=n(l),U(d.$$.fragment,l),yl=n(l),h=y(l,"PRE",{"data-svelte-h":!0}),p(h)!=="svelte-e1jlhm"&&(h.textContent=zl),pl=n(l),f=y(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1ky0wva"&&(f.innerHTML=Xl),jl=n(l),U(Z.$$.fragment,l),Ul=n(l),_=y(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1avi9xc"&&(_.textContent=Ql),Jl=n(l),g=y(l,"UL",{"data-svelte-h":!0}),p(g)!=="svelte-mcnf66"&&(g.innerHTML=Sl),cl=n(l),N=y(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-8pke3x"&&(N.innerHTML=Rl),Tl=n(l),U(B.$$.fragment,l),wl=n(l),E=y(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-4lcfn1"&&(E.innerHTML=vl),ol=n(l),V=y(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-jm7put"&&(V.innerHTML=$l),il=n(l),W=y(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1u0ia18"&&(W.textContent=Yl),ml=n(l),U(k.$$.fragment,l),Il=n(l),G=y(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1t4bews"&&(G.innerHTML=Hl),Cl=n(l),z=y(l,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-10bbvm4"&&(z.innerHTML=xl),rl=n(l),U(X.$$.fragment,l),Al=n(l),U(Q.$$.fragment,l),bl=n(l),U(S.$$.fragment,l),ul=n(l),U(R.$$.fragment,l),dl=n(l),U(v.$$.fragment,l),hl=n(l),$=y(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1hksv30"&&($.innerHTML=Fl),fl=n(l),Y=y(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-xnkujc"&&(Y.innerHTML=Ll),Zl=n(l),H=y(l,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-gexv5y"&&(H.innerHTML=ql),_l=n(l),U(x.$$.fragment,l),gl=n(l),q=y(l,"P",{}),Pl(q).forEach(e),this.h()},h(){Dl(o,"name","hf:doc:metadata"),Dl(o,"content",ps)},m(l,s){ts(document.head,o),M(l,D,s),M(l,L,s),M(l,K,s),J(i,l,s),M(l,O,s),J(m,l,s),M(l,ll,s),M(l,I,s),M(l,sl,s),M(l,C,s),M(l,el,s),M(l,r,s),M(l,Ml,s),M(l,A,s),M(l,tl,s),J(b,l,s),M(l,nl,s),M(l,u,s),M(l,al,s),J(d,l,s),M(l,yl,s),M(l,h,s),M(l,pl,s),M(l,f,s),M(l,jl,s),J(Z,l,s),M(l,Ul,s),M(l,_,s),M(l,Jl,s),M(l,g,s),M(l,cl,s),M(l,N,s),M(l,Tl,s),J(B,l,s),M(l,wl,s),M(l,E,s),M(l,ol,s),M(l,V,s),M(l,il,s),M(l,W,s),M(l,ml,s),J(k,l,s),M(l,Il,s),M(l,G,s),M(l,Cl,s),M(l,z,s),M(l,rl,s),J(X,l,s),M(l,Al,s),J(Q,l,s),M(l,bl,s),J(S,l,s),M(l,ul,s),J(R,l,s),M(l,dl,s),J(v,l,s),M(l,hl,s),M(l,$,s),M(l,fl,s),M(l,Y,s),M(l,Zl,s),M(l,H,s),M(l,_l,s),J(x,l,s),M(l,gl,s),M(l,q,s),Nl=!0},p:Ol,i(l){Nl||(c(i.$$.fragment,l),c(m.$$.fragment,l),c(b.$$.fragment,l),c(d.$$.fragment,l),c(Z.$$.fragment,l),c(B.$$.fragment,l),c(k.$$.fragment,l),c(X.$$.fragment,l),c(Q.$$.fragment,l),c(S.$$.fragment,l),c(R.$$.fragment,l),c(v.$$.fragment,l),c(x.$$.fragment,l),Nl=!0)},o(l){T(i.$$.fragment,l),T(m.$$.fragment,l),T(b.$$.fragment,l),T(d.$$.fragment,l),T(Z.$$.fragment,l),T(B.$$.fragment,l),T(k.$$.fragment,l),T(X.$$.fragment,l),T(Q.$$.fragment,l),T(S.$$.fragment,l),T(R.$$.fragment,l),T(v.$$.fragment,l),T(x.$$.fragment,l),Nl=!1},d(l){l&&(e(D),e(L),e(K),e(O),e(ll),e(I),e(sl),e(C),e(el),e(r),e(Ml),e(A),e(tl),e(nl),e(u),e(al),e(yl),e(h),e(pl),e(f),e(jl),e(Ul),e(_),e(Jl),e(g),e(cl),e(N),e(Tl),e(wl),e(E),e(ol),e(V),e(il),e(W),e(ml),e(Il),e(G),e(Cl),e(z),e(rl),e(Al),e(bl),e(ul),e(dl),e(hl),e($),e(fl),e(Y),e(Zl),e(H),e(_l),e(gl),e(q)),e(o),w(i,l),w(m,l),w(b,l),w(d,l),w(Z,l),w(B,l),w(k,l),w(X,l),w(Q,l),w(S,l),w(R,l),w(v,l),w(x,l)}}}const ps='{"title":"从任意的 LLM 推理提供商中创建一个 Transformers 智能体","local":"从任意的-llm-推理提供商中创建一个-transformers-智能体","sections":[{"title":"HuggingFace 无服务器 API 和专用端点","local":"huggingface-无服务器-api-和专用端点","sections":[],"depth":2},{"title":"为任何 LLM 适配配方","local":"为任何-llm-适配配方","sections":[{"title":"OpenAI","local":"openai","sections":[],"depth":3},{"title":"Anthropic","local":"anthropic","sections":[],"depth":3},{"title":"下一步","local":"下一步","sections":[],"depth":3}],"depth":2}],"depth":1}';function js(Bl){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends ss{constructor(o){super(),es(this,o,js,ys,Kl,{})}}export{ws as component};
