import{s as yl,n as Ml,o as El}from"../chunks/scheduler.b108d059.js";import{S as Al,i as zl,g as d,s as i,r as g,A as Ul,h as o,f as a,c as m,j as n,u,x as s,k as r,y as jl,a as l,v as c,d as p,t as f,w}from"../chunks/index.008de539.js";import{C as Bl}from"../chunks/CodeBlock.3968c746.js";import{H as h}from"../chunks/Heading.88bfeb84.js";function kl(qa){let R,Je,Ke,qe,I,Ne,$,Se,_,Na="Helper module for image processing.",Ze,T,Sa=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Ge,v,Za='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',We,De,Oe,b,Ve,C,Fe,x,Ga='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',Qe,H,Wa='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <code>RawImage</code></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',Xe,et,tt,L,at,P,lt,y,Da="Create a new <code>RawImage</code> object.",it,M,Oa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",mt,dt,ot,E,st,A,rt,z,Va="Returns the size of the image (width, height).",nt,U,Fa='<strong>Kind</strong>: instance property of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The size of the image (width, height).',gt,ut,ct,j,pt,B,ft,k,Qa="Convert the image to grayscale format.",wt,K,Xa='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',ht,Rt,It,Y,$t,J,_t,q,el="Convert the image to RGB format.",Tt,N,tl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',vt,bt,Ct,S,xt,Z,Ht,G,al="Convert the image to RGBA format.",Lt,W,ll='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Pt,yt,Mt,D,Et,O,At,V,il="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",zt,F,ml='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - <code>this</code> to support chaining.',Ut,Q,dl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",jt,Bt,kt,X,Kt,ee,Yt,te,ol="Clone the image",Jt,ae,sl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - The cloned image',qt,Nt,St,le,Zt,ie,Gt,me,rl="Helper method for converting image to have a certain number of channels",Wt,de,nl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>RawImage</code> - <code>this</code> to support chaining.',Dt,oe,gl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",Ot,Vt,Ft,se,Qt,re,Xt,ne,ul="Save the image to the given path.",ea,ge,cl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',ta,ue,pl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",aa,la,ia,ce,ma,pe,da,fe,fl="Helper method for reading an image from a variety of input types.",oa,we,wl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',sa,he,hl="<strong>Example:</strong> Read image from a URL.",ra,Re,na,Ie,Rl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>RawImage</code> | <code>string</code> | <code>URL</code></td></tr></tbody>",ga,ua,ca,$e,pa,_e,fa,Te,Il="Read an image from a URL or file path.",wa,ve,$l='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',ha,be,_l="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",Ra,Ia,$a,Ce,_a,xe,Ta,He,Tl="Helper method to create a new Image from a blob.",va,Le,vl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The image object.',ba,Pe,bl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",Ca,xa,Ha,ye,La,Me,Pa,Ee,Cl="Helper method to create a new Image from a tensor",ya,Ae,xl='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',Ma,ze,Hl="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code>*</code></td></tr></tbody>",Ea,Aa,za,Ue,Ua,je,ja,Be,Ll="Mapping from file extensions to MIME types.",Ba,ke,Pl='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',ka,Ka,Ya,Ye,Ja;return $=new h({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new h({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),P=new h({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),A=new h({props:{title:"rawImage.size ⇒ <code> * </code>",local:"rawimagesize--code--code",headingTag:"h3"}}),B=new h({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),J=new h({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),Z=new h({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),O=new h({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),ee=new h({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),ie=new h({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),re=new h({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),pe=new h({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),Re=new Bl({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),_e=new h({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),xe=new h({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),Me=new h({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),je=new h({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),{c(){R=d("meta"),Je=i(),Ke=d("p"),qe=i(),I=d("a"),Ne=i(),g($.$$.fragment),Se=i(),_=d("p"),_.textContent=Na,Ze=i(),T=d("p"),T.textContent=Sa,Ge=i(),v=d("ul"),v.innerHTML=Za,We=i(),De=d("hr"),Oe=i(),b=d("a"),Ve=i(),g(C.$$.fragment),Fe=i(),x=d("p"),x.innerHTML=Ga,Qe=i(),H=d("ul"),H.innerHTML=Wa,Xe=i(),et=d("hr"),tt=i(),L=d("a"),at=i(),g(P.$$.fragment),lt=i(),y=d("p"),y.innerHTML=Da,it=i(),M=d("table"),M.innerHTML=Oa,mt=i(),dt=d("hr"),ot=i(),E=d("a"),st=i(),g(A.$$.fragment),rt=i(),z=d("p"),z.textContent=Va,nt=i(),U=d("p"),U.innerHTML=Fa,gt=i(),ut=d("hr"),ct=i(),j=d("a"),pt=i(),g(B.$$.fragment),ft=i(),k=d("p"),k.textContent=Qa,wt=i(),K=d("p"),K.innerHTML=Xa,ht=i(),Rt=d("hr"),It=i(),Y=d("a"),$t=i(),g(J.$$.fragment),_t=i(),q=d("p"),q.textContent=el,Tt=i(),N=d("p"),N.innerHTML=tl,vt=i(),bt=d("hr"),Ct=i(),S=d("a"),xt=i(),g(Z.$$.fragment),Ht=i(),G=d("p"),G.textContent=al,Lt=i(),W=d("p"),W.innerHTML=ll,Pt=i(),yt=d("hr"),Mt=i(),D=d("a"),Et=i(),g(O.$$.fragment),At=i(),V=d("p"),V.textContent=il,zt=i(),F=d("p"),F.innerHTML=ml,Ut=i(),Q=d("table"),Q.innerHTML=dl,jt=i(),Bt=d("hr"),kt=i(),X=d("a"),Kt=i(),g(ee.$$.fragment),Yt=i(),te=d("p"),te.textContent=ol,Jt=i(),ae=d("p"),ae.innerHTML=sl,qt=i(),Nt=d("hr"),St=i(),le=d("a"),Zt=i(),g(ie.$$.fragment),Gt=i(),me=d("p"),me.textContent=rl,Wt=i(),de=d("p"),de.innerHTML=nl,Dt=i(),oe=d("table"),oe.innerHTML=gl,Ot=i(),Vt=d("hr"),Ft=i(),se=d("a"),Qt=i(),g(re.$$.fragment),Xt=i(),ne=d("p"),ne.textContent=ul,ea=i(),ge=d("p"),ge.innerHTML=cl,ta=i(),ue=d("table"),ue.innerHTML=pl,aa=i(),la=d("hr"),ia=i(),ce=d("a"),ma=i(),g(pe.$$.fragment),da=i(),fe=d("p"),fe.textContent=fl,oa=i(),we=d("p"),we.innerHTML=wl,sa=i(),he=d("p"),he.innerHTML=hl,ra=i(),g(Re.$$.fragment),na=i(),Ie=d("table"),Ie.innerHTML=Rl,ga=i(),ua=d("hr"),ca=i(),$e=d("a"),pa=i(),g(_e.$$.fragment),fa=i(),Te=d("p"),Te.textContent=Il,wa=i(),ve=d("p"),ve.innerHTML=$l,ha=i(),be=d("table"),be.innerHTML=_l,Ra=i(),Ia=d("hr"),$a=i(),Ce=d("a"),_a=i(),g(xe.$$.fragment),Ta=i(),He=d("p"),He.textContent=Tl,va=i(),Le=d("p"),Le.innerHTML=vl,ba=i(),Pe=d("table"),Pe.innerHTML=bl,Ca=i(),xa=d("hr"),Ha=i(),ye=d("a"),La=i(),g(Me.$$.fragment),Pa=i(),Ee=d("p"),Ee.textContent=Cl,ya=i(),Ae=d("p"),Ae.innerHTML=xl,Ma=i(),ze=d("table"),ze.innerHTML=Hl,Ea=i(),Aa=d("hr"),za=i(),Ue=d("a"),Ua=i(),g(je.$$.fragment),ja=i(),Be=d("p"),Be.textContent=Ll,Ba=i(),ke=d("p"),ke.innerHTML=Pl,ka=i(),Ka=d("hr"),Ya=i(),Ye=d("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),Je=m(e),Ke=o(e,"P",{}),n(Ke).forEach(a),qe=m(e),I=o(e,"A",{id:!0,class:!0}),n(I).forEach(a),Ne=m(e),u($.$$.fragment,e),Se=m(e),_=o(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-18hbqrt"&&(_.textContent=Na),Ze=m(e),T=o(e,"P",{"data-svelte-h":!0}),s(T)!=="svelte-il3kl8"&&(T.textContent=Sa),Ge=m(e),v=o(e,"UL",{"data-svelte-h":!0}),s(v)!=="svelte-138ylq7"&&(v.innerHTML=Za),We=m(e),De=o(e,"HR",{}),Oe=m(e),b=o(e,"A",{id:!0,class:!0}),n(b).forEach(a),Ve=m(e),u(C.$$.fragment,e),Fe=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=Ga),Qe=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-1fvb8wc"&&(H.innerHTML=Wa),Xe=m(e),et=o(e,"HR",{}),tt=m(e),L=o(e,"A",{id:!0,class:!0}),n(L).forEach(a),at=m(e),u(P.$$.fragment,e),lt=m(e),y=o(e,"P",{"data-svelte-h":!0}),s(y)!=="svelte-36fe9a"&&(y.innerHTML=Da),it=m(e),M=o(e,"TABLE",{"data-svelte-h":!0}),s(M)!=="svelte-vkeoul"&&(M.innerHTML=Oa),mt=m(e),dt=o(e,"HR",{}),ot=m(e),E=o(e,"A",{id:!0,class:!0}),n(E).forEach(a),st=m(e),u(A.$$.fragment,e),rt=m(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-2j0n9s"&&(z.textContent=Va),nt=m(e),U=o(e,"P",{"data-svelte-h":!0}),s(U)!=="svelte-gwg1mu"&&(U.innerHTML=Fa),gt=m(e),ut=o(e,"HR",{}),ct=m(e),j=o(e,"A",{id:!0,class:!0}),n(j).forEach(a),pt=m(e),u(B.$$.fragment,e),ft=m(e),k=o(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1owjjfe"&&(k.textContent=Qa),wt=m(e),K=o(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-11e9r18"&&(K.innerHTML=Xa),ht=m(e),Rt=o(e,"HR",{}),It=m(e),Y=o(e,"A",{id:!0,class:!0}),n(Y).forEach(a),$t=m(e),u(J.$$.fragment,e),_t=m(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-qyo04e"&&(q.textContent=el),Tt=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-11e9r18"&&(N.innerHTML=tl),vt=m(e),bt=o(e,"HR",{}),Ct=m(e),S=o(e,"A",{id:!0,class:!0}),n(S).forEach(a),xt=m(e),u(Z.$$.fragment,e),Ht=m(e),G=o(e,"P",{"data-svelte-h":!0}),s(G)!=="svelte-19kp14j"&&(G.textContent=al),Lt=m(e),W=o(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-11e9r18"&&(W.innerHTML=ll),Pt=m(e),yt=o(e,"HR",{}),Mt=m(e),D=o(e,"A",{id:!0,class:!0}),n(D).forEach(a),Et=m(e),u(O.$$.fragment,e),At=m(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-s4dm9o"&&(V.textContent=il),zt=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1jh8cjr"&&(F.innerHTML=ml),Ut=m(e),Q=o(e,"TABLE",{"data-svelte-h":!0}),s(Q)!=="svelte-ya0vko"&&(Q.innerHTML=dl),jt=m(e),Bt=o(e,"HR",{}),kt=m(e),X=o(e,"A",{id:!0,class:!0}),n(X).forEach(a),Kt=m(e),u(ee.$$.fragment,e),Yt=m(e),te=o(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1eu6jk3"&&(te.textContent=ol),Jt=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1w4hta5"&&(ae.innerHTML=sl),qt=m(e),Nt=o(e,"HR",{}),St=m(e),le=o(e,"A",{id:!0,class:!0}),n(le).forEach(a),Zt=m(e),u(ie.$$.fragment,e),Gt=m(e),me=o(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-5ze294"&&(me.textContent=rl),Wt=m(e),de=o(e,"P",{"data-svelte-h":!0}),s(de)!=="svelte-11e9r18"&&(de.innerHTML=nl),Dt=m(e),oe=o(e,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-1hxqxaq"&&(oe.innerHTML=gl),Ot=m(e),Vt=o(e,"HR",{}),Ft=m(e),se=o(e,"A",{id:!0,class:!0}),n(se).forEach(a),Qt=m(e),u(re.$$.fragment,e),Xt=m(e),ne=o(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-119su55"&&(ne.textContent=ul),ea=m(e),ge=o(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-1epyezb"&&(ge.innerHTML=cl),ta=m(e),ue=o(e,"TABLE",{"data-svelte-h":!0}),s(ue)!=="svelte-1h4z9xq"&&(ue.innerHTML=pl),aa=m(e),la=o(e,"HR",{}),ia=m(e),ce=o(e,"A",{id:!0,class:!0}),n(ce).forEach(a),ma=m(e),u(pe.$$.fragment,e),da=m(e),fe=o(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-5659h9"&&(fe.textContent=fl),oa=m(e),we=o(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-1800vfp"&&(we.innerHTML=wl),sa=m(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-14z54gq"&&(he.innerHTML=hl),ra=m(e),u(Re.$$.fragment,e),na=m(e),Ie=o(e,"TABLE",{"data-svelte-h":!0}),s(Ie)!=="svelte-eqolu5"&&(Ie.innerHTML=Rl),ga=m(e),ua=o(e,"HR",{}),ca=m(e),$e=o(e,"A",{id:!0,class:!0}),n($e).forEach(a),pa=m(e),u(_e.$$.fragment,e),fa=m(e),Te=o(e,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1355z3u"&&(Te.textContent=Il),wa=m(e),ve=o(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-10btw3j"&&(ve.innerHTML=$l),ha=m(e),be=o(e,"TABLE",{"data-svelte-h":!0}),s(be)!=="svelte-ncveta"&&(be.innerHTML=_l),Ra=m(e),Ia=o(e,"HR",{}),$a=m(e),Ce=o(e,"A",{id:!0,class:!0}),n(Ce).forEach(a),_a=m(e),u(xe.$$.fragment,e),Ta=m(e),He=o(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1s704mu"&&(He.textContent=Tl),va=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-10btw3j"&&(Le.innerHTML=vl),ba=m(e),Pe=o(e,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-34rbhe"&&(Pe.innerHTML=bl),Ca=m(e),xa=o(e,"HR",{}),Ha=m(e),ye=o(e,"A",{id:!0,class:!0}),n(ye).forEach(a),La=m(e),u(Me.$$.fragment,e),Pa=m(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-nwy2y"&&(Ee.textContent=Cl),ya=m(e),Ae=o(e,"P",{"data-svelte-h":!0}),s(Ae)!=="svelte-sl3vqa"&&(Ae.innerHTML=xl),Ma=m(e),ze=o(e,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-t797x5"&&(ze.innerHTML=Hl),Ea=m(e),Aa=o(e,"HR",{}),za=m(e),Ue=o(e,"A",{id:!0,class:!0}),n(Ue).forEach(a),Ua=m(e),u(je.$$.fragment,e),ja=m(e),Be=o(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-15u13r6"&&(Be.textContent=Ll),Ba=m(e),ke=o(e,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-1cwm6ga"&&(ke.innerHTML=Pl),ka=m(e),Ka=o(e,"HR",{}),Ya=m(e),Ye=o(e,"P",{}),n(Ye).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",Kl),r(I,"id","module_utils/image"),r(I,"class","group"),r(b,"id","module_utils/image.RawImage"),r(b,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(E,"id","module_utils/image.RawImage+size"),r(E,"class","group"),r(j,"id","module_utils/image.RawImage+grayscale"),r(j,"class","group"),r(Y,"id","module_utils/image.RawImage+rgb"),r(Y,"class","group"),r(S,"id","module_utils/image.RawImage+rgba"),r(S,"class","group"),r(D,"id","module_utils/image.RawImage+resize"),r(D,"class","group"),r(X,"id","module_utils/image.RawImage+clone"),r(X,"class","group"),r(le,"id","module_utils/image.RawImage+convert"),r(le,"class","group"),r(se,"id","module_utils/image.RawImage+save"),r(se,"class","group"),r(ce,"id","module_utils/image.RawImage.read"),r(ce,"class","group"),r($e,"id","module_utils/image.RawImage.fromURL"),r($e,"class","group"),r(Ce,"id","module_utils/image.RawImage.fromBlob"),r(Ce,"class","group"),r(ye,"id","module_utils/image.RawImage.fromTensor"),r(ye,"class","group"),r(Ue,"id","module_utils/image..CONTENT_TYPE_MAP"),r(Ue,"class","group")},m(e,t){jl(document.head,R),l(e,Je,t),l(e,Ke,t),l(e,qe,t),l(e,I,t),l(e,Ne,t),c($,e,t),l(e,Se,t),l(e,_,t),l(e,Ze,t),l(e,T,t),l(e,Ge,t),l(e,v,t),l(e,We,t),l(e,De,t),l(e,Oe,t),l(e,b,t),l(e,Ve,t),c(C,e,t),l(e,Fe,t),l(e,x,t),l(e,Qe,t),l(e,H,t),l(e,Xe,t),l(e,et,t),l(e,tt,t),l(e,L,t),l(e,at,t),c(P,e,t),l(e,lt,t),l(e,y,t),l(e,it,t),l(e,M,t),l(e,mt,t),l(e,dt,t),l(e,ot,t),l(e,E,t),l(e,st,t),c(A,e,t),l(e,rt,t),l(e,z,t),l(e,nt,t),l(e,U,t),l(e,gt,t),l(e,ut,t),l(e,ct,t),l(e,j,t),l(e,pt,t),c(B,e,t),l(e,ft,t),l(e,k,t),l(e,wt,t),l(e,K,t),l(e,ht,t),l(e,Rt,t),l(e,It,t),l(e,Y,t),l(e,$t,t),c(J,e,t),l(e,_t,t),l(e,q,t),l(e,Tt,t),l(e,N,t),l(e,vt,t),l(e,bt,t),l(e,Ct,t),l(e,S,t),l(e,xt,t),c(Z,e,t),l(e,Ht,t),l(e,G,t),l(e,Lt,t),l(e,W,t),l(e,Pt,t),l(e,yt,t),l(e,Mt,t),l(e,D,t),l(e,Et,t),c(O,e,t),l(e,At,t),l(e,V,t),l(e,zt,t),l(e,F,t),l(e,Ut,t),l(e,Q,t),l(e,jt,t),l(e,Bt,t),l(e,kt,t),l(e,X,t),l(e,Kt,t),c(ee,e,t),l(e,Yt,t),l(e,te,t),l(e,Jt,t),l(e,ae,t),l(e,qt,t),l(e,Nt,t),l(e,St,t),l(e,le,t),l(e,Zt,t),c(ie,e,t),l(e,Gt,t),l(e,me,t),l(e,Wt,t),l(e,de,t),l(e,Dt,t),l(e,oe,t),l(e,Ot,t),l(e,Vt,t),l(e,Ft,t),l(e,se,t),l(e,Qt,t),c(re,e,t),l(e,Xt,t),l(e,ne,t),l(e,ea,t),l(e,ge,t),l(e,ta,t),l(e,ue,t),l(e,aa,t),l(e,la,t),l(e,ia,t),l(e,ce,t),l(e,ma,t),c(pe,e,t),l(e,da,t),l(e,fe,t),l(e,oa,t),l(e,we,t),l(e,sa,t),l(e,he,t),l(e,ra,t),c(Re,e,t),l(e,na,t),l(e,Ie,t),l(e,ga,t),l(e,ua,t),l(e,ca,t),l(e,$e,t),l(e,pa,t),c(_e,e,t),l(e,fa,t),l(e,Te,t),l(e,wa,t),l(e,ve,t),l(e,ha,t),l(e,be,t),l(e,Ra,t),l(e,Ia,t),l(e,$a,t),l(e,Ce,t),l(e,_a,t),c(xe,e,t),l(e,Ta,t),l(e,He,t),l(e,va,t),l(e,Le,t),l(e,ba,t),l(e,Pe,t),l(e,Ca,t),l(e,xa,t),l(e,Ha,t),l(e,ye,t),l(e,La,t),c(Me,e,t),l(e,Pa,t),l(e,Ee,t),l(e,ya,t),l(e,Ae,t),l(e,Ma,t),l(e,ze,t),l(e,Ea,t),l(e,Aa,t),l(e,za,t),l(e,Ue,t),l(e,Ua,t),c(je,e,t),l(e,ja,t),l(e,Be,t),l(e,Ba,t),l(e,ke,t),l(e,ka,t),l(e,Ka,t),l(e,Ya,t),l(e,Ye,t),Ja=!0},p:Ml,i(e){Ja||(p($.$$.fragment,e),p(C.$$.fragment,e),p(P.$$.fragment,e),p(A.$$.fragment,e),p(B.$$.fragment,e),p(J.$$.fragment,e),p(Z.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(ie.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(Re.$$.fragment,e),p(_e.$$.fragment,e),p(xe.$$.fragment,e),p(Me.$$.fragment,e),p(je.$$.fragment,e),Ja=!0)},o(e){f($.$$.fragment,e),f(C.$$.fragment,e),f(P.$$.fragment,e),f(A.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f(Z.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(Re.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f(Me.$$.fragment,e),f(je.$$.fragment,e),Ja=!1},d(e){e&&(a(Je),a(Ke),a(qe),a(I),a(Ne),a(Se),a(_),a(Ze),a(T),a(Ge),a(v),a(We),a(De),a(Oe),a(b),a(Ve),a(Fe),a(x),a(Qe),a(H),a(Xe),a(et),a(tt),a(L),a(at),a(lt),a(y),a(it),a(M),a(mt),a(dt),a(ot),a(E),a(st),a(rt),a(z),a(nt),a(U),a(gt),a(ut),a(ct),a(j),a(pt),a(ft),a(k),a(wt),a(K),a(ht),a(Rt),a(It),a(Y),a($t),a(_t),a(q),a(Tt),a(N),a(vt),a(bt),a(Ct),a(S),a(xt),a(Ht),a(G),a(Lt),a(W),a(Pt),a(yt),a(Mt),a(D),a(Et),a(At),a(V),a(zt),a(F),a(Ut),a(Q),a(jt),a(Bt),a(kt),a(X),a(Kt),a(Yt),a(te),a(Jt),a(ae),a(qt),a(Nt),a(St),a(le),a(Zt),a(Gt),a(me),a(Wt),a(de),a(Dt),a(oe),a(Ot),a(Vt),a(Ft),a(se),a(Qt),a(Xt),a(ne),a(ea),a(ge),a(ta),a(ue),a(aa),a(la),a(ia),a(ce),a(ma),a(da),a(fe),a(oa),a(we),a(sa),a(he),a(ra),a(na),a(Ie),a(ga),a(ua),a(ca),a($e),a(pa),a(fa),a(Te),a(wa),a(ve),a(ha),a(be),a(Ra),a(Ia),a($a),a(Ce),a(_a),a(Ta),a(He),a(va),a(Le),a(ba),a(Pe),a(Ca),a(xa),a(Ha),a(ye),a(La),a(Pa),a(Ee),a(ya),a(Ae),a(Ma),a(ze),a(Ea),a(Aa),a(za),a(Ue),a(Ua),a(ja),a(Be),a(Ba),a(ke),a(ka),a(Ka),a(Ya),a(Ye)),a(R),w($,e),w(C,e),w(P,e),w(A,e),w(B,e),w(J,e),w(Z,e),w(O,e),w(ee,e),w(ie,e),w(re,e),w(pe,e),w(Re,e),w(_e,e),w(xe,e),w(Me,e),w(je,e)}}}const Kl='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.size ⇒ <code> * </code>","local":"rawimagesize--code--code","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function Yl(qa){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends Al{constructor(R){super(),zl(this,R,Yl,kl,yl,{})}}export{Zl as component};
