import{s as Qs,n as vs,o as Rs}from"../chunks/scheduler.7bc62968.js";import{S as Ys,i as Hs,g as p,s as t,r as o,A as _s,h as i,f as a,c as n,j as Vs,u as c,x as u,k as Es,y as Fs,a as e,v as h,d as J,t as M,w as T}from"../chunks/index.66556066.js";import{C as q}from"../chunks/CodeBlock.a759539a.js";import{H as w,E as Xs}from"../chunks/EditOnGithub.46ca76a5.js";function Ls(gs){let r,S,X,z,j,x,d,fs="Official utilities to use the Hugging Face Hub API.",A,y,P,m,D,g,K,f,O,b,ss,U,bs='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',ls,I,Us='Learn how to find free models using the hub package in this <a href="https://scrimba.com/scrim/c7BbVPcd?pl=pkVnrP7uP" rel="nofollow">interactive tutorial</a>.',as,B,es,Z,ts,C,Is='It’s possible to login using OAuth (<a href="https://huggingface.co/docs/hub/oauth" rel="nofollow">“Sign in with HF”</a>).',ns,k,Bs="This will allow you get an access token to use some of the API, depending on the scopes set inside the Space or the OAuth App.",ps,G,is,$,Zs='Checkout the demo: <a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">https://huggingface.co/spaces/huggingfacejs/client-side-oauth</a>',os,W,cs,N,Cs='The <code>@huggingface/hub</code> package provide basic capabilities to scan the cache directory. Learn more about <a href="https://huggingface.co/docs/huggingface_hub/en/guides/manage-cache" rel="nofollow">Manage huggingface_hub cache-system</a>.',hs,V,Js,E,ks="Note that the cache directory is created and used only by the Python and Rust libraries. Downloading files using the <code>@huggingface/hub</code> package won’t use the cache directory.",Ms,Q,Ts,v,Gs="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",us,R,$s="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",rs,Y,Ws="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",ws,H,js,_,Ns="<li><code>@huggingface/tasks</code> : Typings only</li>",ds,F,ys,L,ms;return j=new w({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),y=new w({props:{title:"Install",local:"install",headingTag:"h2"}}),m=new q({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),g=new w({props:{title:"Deno",local:"deno",headingTag:"h3"}}),f=new q({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwdXBsb2FkRmlsZXMlMkMlMjBsaXN0TW9kZWxzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMHVwbG9hZEZpbGVzJTJDJTIwbGlzdE1vZGVscyUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmh1YiUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { uploadFiles, listModels } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),b=new w({props:{title:"Usage",local:"usage",headingTag:"h2"}}),B=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> * <span class="hljs-keyword">as</span> hub <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">whoAmI</span>({<span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">const</span> specificModel = <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">modelInfo</span>({<span class="hljs-attr">name</span>: <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>});
<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">checkRepoAccess</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>});

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">createRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFiles</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-comment">// or</span>

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> progressEvent <span class="hljs-keyword">of</span> <span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">uploadFilesWithProgress</span>({
  repo,
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">files</span>: [
    ...
  ],
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(progressEvent);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteFile</span>({repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> hub.<span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> hub.<span class="hljs-title function_">deleteRepo</span>({ repo, <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> });`,wrap:!1}}),Z=new w({props:{title:"OAuth Login",local:"oauth-login",headingTag:"h2"}}),G=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC5hY2Nlc3NUb2tlbkV4cGlyZXNBdCUyMGFuZCUyMG9hdXRoUmVzdWx0LnVzZXJJbmZvJTBBY29uc29sZS5sb2cob2F1dGhSZXN1bHQpJTNC",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.accessTokenExpiresAt and oauthResult.userInfo</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),W=new w({props:{title:"Hugging face cache",local:"hugging-face-cache",headingTag:"h2"}}),V=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwc2NhbkNhY2hlRGlyJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaHViJTIyJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHNjYW5DYWNoZURpcigpJTNCJTBBJTBBY29uc29sZS5sb2cocmVzdWx0KSUzQg==",highlighted:`<span class="hljs-keyword">import</span> { scanCacheDir } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">scanCacheDir</span>();

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(result);`,wrap:!1}}),Q=new w({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),H=new w({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),F=new Xs({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/hub/README.md"}}),{c(){r=p("meta"),S=t(),X=p("p"),z=t(),o(j.$$.fragment),x=t(),d=p("p"),d.textContent=fs,A=t(),o(y.$$.fragment),P=t(),o(m.$$.fragment),D=t(),o(g.$$.fragment),K=t(),o(f.$$.fragment),O=t(),o(b.$$.fragment),ss=t(),U=p("p"),U.innerHTML=bs,ls=t(),I=p("p"),I.innerHTML=Us,as=t(),o(B.$$.fragment),es=t(),o(Z.$$.fragment),ts=t(),C=p("p"),C.innerHTML=Is,ns=t(),k=p("p"),k.textContent=Bs,ps=t(),o(G.$$.fragment),is=t(),$=p("p"),$.innerHTML=Zs,os=t(),o(W.$$.fragment),cs=t(),N=p("p"),N.innerHTML=Cs,hs=t(),o(V.$$.fragment),Js=t(),E=p("p"),E.innerHTML=ks,Ms=t(),o(Q.$$.fragment),Ts=t(),v=p("p"),v.innerHTML=Gs,us=t(),R=p("p"),R.innerHTML=$s,rs=t(),Y=p("p"),Y.innerHTML=Ws,ws=t(),o(H.$$.fragment),js=t(),_=p("ul"),_.innerHTML=Ns,ds=t(),o(F.$$.fragment),ys=t(),L=p("p"),this.h()},l(s){const l=_s("svelte-u9bgzb",document.head);r=i(l,"META",{name:!0,content:!0}),l.forEach(a),S=n(s),X=i(s,"P",{}),Vs(X).forEach(a),z=n(s),c(j.$$.fragment,s),x=n(s),d=i(s,"P",{"data-svelte-h":!0}),u(d)!=="svelte-a2asrt"&&(d.textContent=fs),A=n(s),c(y.$$.fragment,s),P=n(s),c(m.$$.fragment,s),D=n(s),c(g.$$.fragment,s),K=n(s),c(f.$$.fragment,s),O=n(s),c(b.$$.fragment,s),ss=n(s),U=i(s,"P",{"data-svelte-h":!0}),u(U)!=="svelte-1nqczoz"&&(U.innerHTML=bs),ls=n(s),I=i(s,"P",{"data-svelte-h":!0}),u(I)!=="svelte-6ptpin"&&(I.innerHTML=Us),as=n(s),c(B.$$.fragment,s),es=n(s),c(Z.$$.fragment,s),ts=n(s),C=i(s,"P",{"data-svelte-h":!0}),u(C)!=="svelte-bfok93"&&(C.innerHTML=Is),ns=n(s),k=i(s,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1az135e"&&(k.textContent=Bs),ps=n(s),c(G.$$.fragment,s),is=n(s),$=i(s,"P",{"data-svelte-h":!0}),u($)!=="svelte-1qsa6tj"&&($.innerHTML=Zs),os=n(s),c(W.$$.fragment,s),cs=n(s),N=i(s,"P",{"data-svelte-h":!0}),u(N)!=="svelte-8xjlck"&&(N.innerHTML=Cs),hs=n(s),c(V.$$.fragment,s),Js=n(s),E=i(s,"P",{"data-svelte-h":!0}),u(E)!=="svelte-tt42mo"&&(E.innerHTML=ks),Ms=n(s),c(Q.$$.fragment,s),Ts=n(s),v=i(s,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1gspubq"&&(v.innerHTML=Gs),us=n(s),R=i(s,"P",{"data-svelte-h":!0}),u(R)!=="svelte-em0etc"&&(R.innerHTML=$s),rs=n(s),Y=i(s,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-lja874"&&(Y.innerHTML=Ws),ws=n(s),c(H.$$.fragment,s),js=n(s),_=i(s,"UL",{"data-svelte-h":!0}),u(_)!=="svelte-mopwlb"&&(_.innerHTML=Ns),ds=n(s),c(F.$$.fragment,s),ys=n(s),L=i(s,"P",{}),Vs(L).forEach(a),this.h()},h(){Es(r,"name","hf:doc:metadata"),Es(r,"content",qs)},m(s,l){Fs(document.head,r),e(s,S,l),e(s,X,l),e(s,z,l),h(j,s,l),e(s,x,l),e(s,d,l),e(s,A,l),h(y,s,l),e(s,P,l),h(m,s,l),e(s,D,l),h(g,s,l),e(s,K,l),h(f,s,l),e(s,O,l),h(b,s,l),e(s,ss,l),e(s,U,l),e(s,ls,l),e(s,I,l),e(s,as,l),h(B,s,l),e(s,es,l),h(Z,s,l),e(s,ts,l),e(s,C,l),e(s,ns,l),e(s,k,l),e(s,ps,l),h(G,s,l),e(s,is,l),e(s,$,l),e(s,os,l),h(W,s,l),e(s,cs,l),e(s,N,l),e(s,hs,l),h(V,s,l),e(s,Js,l),e(s,E,l),e(s,Ms,l),h(Q,s,l),e(s,Ts,l),e(s,v,l),e(s,us,l),e(s,R,l),e(s,rs,l),e(s,Y,l),e(s,ws,l),h(H,s,l),e(s,js,l),e(s,_,l),e(s,ds,l),h(F,s,l),e(s,ys,l),e(s,L,l),ms=!0},p:vs,i(s){ms||(J(j.$$.fragment,s),J(y.$$.fragment,s),J(m.$$.fragment,s),J(g.$$.fragment,s),J(f.$$.fragment,s),J(b.$$.fragment,s),J(B.$$.fragment,s),J(Z.$$.fragment,s),J(G.$$.fragment,s),J(W.$$.fragment,s),J(V.$$.fragment,s),J(Q.$$.fragment,s),J(H.$$.fragment,s),J(F.$$.fragment,s),ms=!0)},o(s){M(j.$$.fragment,s),M(y.$$.fragment,s),M(m.$$.fragment,s),M(g.$$.fragment,s),M(f.$$.fragment,s),M(b.$$.fragment,s),M(B.$$.fragment,s),M(Z.$$.fragment,s),M(G.$$.fragment,s),M(W.$$.fragment,s),M(V.$$.fragment,s),M(Q.$$.fragment,s),M(H.$$.fragment,s),M(F.$$.fragment,s),ms=!1},d(s){s&&(a(S),a(X),a(z),a(x),a(d),a(A),a(P),a(D),a(K),a(O),a(ss),a(U),a(ls),a(I),a(as),a(es),a(ts),a(C),a(ns),a(k),a(ps),a(is),a($),a(os),a(cs),a(N),a(hs),a(Js),a(E),a(Ms),a(Ts),a(v),a(us),a(R),a(rs),a(Y),a(ws),a(js),a(_),a(ds),a(ys),a(L)),a(r),T(j,s),T(y,s),T(m,s),T(g,s),T(f,s),T(b,s),T(B,s),T(Z,s),T(G,s),T(W,s),T(V,s),T(Q,s),T(H,s),T(F,s)}}}const qs='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"OAuth Login","local":"oauth-login","sections":[],"depth":2},{"title":"Hugging face cache","local":"hugging-face-cache","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Ss(gs){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ds extends Ys{constructor(r){super(),Hs(this,r,Ss,Ls,Qs,{})}}export{Ds as component};
