import{s as St,n as _t,o as qt}from"../chunks/scheduler.39a43cde.js";import{S as Nt,i as Et,g as i,s as n,r,A as Xt,h as o,f as s,c as a,j as Vt,u as p,x as c,k as Qt,y as xt,a as l,v as M,d as m,t as d,w as y}from"../chunks/index.23ec2204.js";import{D as Ft,C as h}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as w}from"../chunks/Heading.c42e7061.js";function Yt(Mt){let u,ye,me,he,g,ue,j,we,J,mt='Authored By: <a href="https://huggingface.co/RichmondMongo" rel="nofollow">Richmond Alake</a>',ge,T,je,b,dt="The shell command sequence below installs libraries for leveraging open-source large language models (LLMs), embedding models, and database interaction functionalities. These libraries simplify the development of a RAG system, reducing the complexity to a small amount of code:",Je,U,yt="<li>PyMongo: A Python library for interacting with MongoDB that enables functionalities to connect to a cluster and query data stored in collections and documents.</li> <li>Pandas: Provides a data structure for efficient data processing and analysis using Python</li> <li>Hugging Face datasets: Holds audio, vision, and text datasets</li> <li>Hugging Face Accelerate: Abstracts the complexity of writing code that leverages hardware accelerators such as GPUs. Accelerate is leveraged in the implementation to utilise the Gemma model on GPU resources.</li> <li>Hugging Face Transformers: Access to a vast collection of pre-trained models</li> <li>Hugging Face Sentence Transformers: Provides access to sentence, text, and image embeddings.</li>",Te,f,be,I,Ue,C,ht=`The data utilised in this tutorial is sourced from Hugging Face datasets, specifically the
<a href="https://huggingface.co/datasets/AIatMongoDB/embedded_movies" rel="nofollow">AIatMongoDB/embedded_movies dataset</a>.`,fe,Z,Ie,B,ut="The operations within the following code snippet below focus on enforcing data integrity and quality.",Ce,G,wt="<li>The first process ensures that each data point’s <code>fullplot</code> attribute is not empty, as this is the primary data we utilise in the embedding process.</li> <li>This step also ensures we remove the <code>plot_embedding</code> attribute from all data points as this will be replaced by new embeddings created with a different embedding model, the <code>gte-large</code>.</li>",Ze,v,Be,A,gt=`Number of missing values in each column after removal:
num_mflix_comments      0
genres                  0
countries               0
directors              12
fullplot                0
writers                13
awards                  0
runtime                14
type                    0
rated                 279
metacritic            893
poster                 78
languages               1
imdb                    0
plot                    0
cast                    1
plot_embedding          1
title                   0
dtype: int64
`,Ge,W,ve,k,jt="<strong>The steps in the code snippets are as follows:</strong>",Ae,R,Jt="<li>Import the <code>SentenceTransformer</code> class to access the embedding models.</li> <li>Load the embedding model using the <code>SentenceTransformer</code> constructor to instantiate the <code>gte-large</code> embedding model.</li> <li>Define the <code>get_embedding</code> function, which takes a text string as input and returns a list of floats representing the embedding. The function first checks if the input text is not empty (after stripping whitespace). If the text is empty, it returns an empty list. Otherwise, it generates an embedding using the loaded model.</li> <li>Generate embeddings by applying the <code>get_embedding</code> function to the “fullplot” column of the <code>dataset_df</code> DataFrame, generating embeddings for each movie’s plot. The resulting list of embeddings is assigned to a new column named embedding.</li>",We,$,Tt="<em>Note: It’s not necessary to chunk the text in the full plot, as we can ensure that the text length remains within a manageable range.</em>",ke,V,Re,Q,$e,S,bt="MongoDB acts as both an operational and a vector database. It offers a database solution that efficiently stores, queries and retrieves vector embeddings—the advantages of this lie in the simplicity of database maintenance, management and cost.",Ve,_,Ut="<strong>To create a new MongoDB database, set up a database cluster:</strong>",Qe,q,ft='<li><p>Head over to MongoDB official site and register for a <a href="https://www.mongodb.com/cloud/atlas/register?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alake" rel="nofollow">free MongoDB Atlas account</a>, or for existing users, <a href="https://account.mongodb.com/account/login?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alakee" rel="nofollow">sign into MongoDB Atlas</a>.</p></li> <li><p>Select the ‘Database’ option on the left-hand pane, which will navigate to the Database Deployment page, where there is a deployment specification of any existing cluster. Create a new database cluster by clicking on the “+Create” button.</p></li> <li><p>Select all the applicable configurations for the database cluster. Once all the configuration options are selected, click the “Create Cluster” button to deploy the newly created cluster. MongoDB also enables the creation of free clusters on the “Shared Tab”.</p> <p><em>Note: Don’t forget to whitelist the IP for the Python host or 0.0.0.0/0 for any IP when creating proof of concepts.</em></p></li> <li><p>After successfully creating and deploying the cluster, the cluster becomes accessible on the ‘Database Deployment’ page.</p></li> <li><p>Click on the “Connect” button of the cluster to view the option to set up a connection to the cluster via various language drivers.</p></li> <li><p>This tutorial only requires the cluster’s URI(unique resource identifier). Grab the URI and copy it into the Google Colabs Secrets environment in a variable named <code>MONGO_URI</code> or place it in a .env file or equivalent.</p></li>',Se,N,_e,E,It=`At this point make sure that your vector index is created via MongoDB Atlas.
Follow instructions here:`,qe,X,Ct='This next step is mandatory for conducting efficient and accurate vector-based searches based on the vector embeddings stored within the documents in the <code>movie_collection_2</code> collection. Creating a Vector Search Index enables the ability to traverse the documents efficiently to retrieve documents with embeddings that match the query embedding based on vector similarity. Go here to read more about <a href="https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/" rel="nofollow">MongoDB Vector Search Index</a>.',Ne,x,Ee,F,Zt="The <code>1024</code> value of the numDimension field corresponds to the dimension of the vector generated by the gte-large embedding model. If you use the <code>gte-base</code> or <code>gte-small</code> embedding models, the numDimension value in the vector search index must be set to 768 and 384, respectively.",Xe,Y,xe,H,Bt="The code snippet below also utilises PyMongo to create a MongoDB client object, representing the connection to the cluster and enabling access to its databases and collections.",Fe,z,Ye,D,Gt=`Connection to MongoDB successful
`,He,P,ze,L,vt="Ingesting data into a MongoDB collection from a pandas DataFrame is a straightforward process that can be efficiently accomplished by converting the DataFrame into dictionaries and then utilising the <code>insert_many</code> method on the collection to pass the converted dataset records.",De,K,Pe,O,At=`Data ingestion into MongoDB completed
`,Le,ee,Ke,te,Wt="The following step implements a function that returns a vector search result by generating a query embedding and defining a MongoDB aggregation pipeline.",Oe,se,kt="The pipeline, consisting of the <code>$vectorSearch</code> and <code>$project</code> stages, executes queries using the generated vector and formats the results to include only the required information, such as plot, title, and genres while incorporating a search score for each result.",et,le,tt,ne,st,ae,lt,ie,nt,oe,Rt=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as "Pearl Harbor."
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo & Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.
`,at,re,it,pe,ot,ce,$t=`<bos>Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara&#39;s uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as &quot;Pearl Harbor.&quot;
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship&#39;s maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne&#39;er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo &amp; Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.

Based on the search results, the best romantic movie to watch is **Shut Up and Kiss Me!** because it is a romantic comedy that explores the complexities of love and relationships. The movie is funny, heartwarming, and thought-provoking.<eos>
</eos></bos>`,rt,Me,pt,de,ct;return g=new Ft({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_with_hugging_face_gemma_mongodb.ipynb"}]}}),j=new w({props:{title:"Building A RAG System with Gemma, MongoDB and Open Source Models",local:"building-a-rag-system-with-gemma-mongodb-and-open-source-models",headingTag:"h1"}}),T=new w({props:{title:"Step 1: Installing Libraries",local:"step-1-installing-libraries",headingTag:"h2"}}),f=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHB5bW9uZ28lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMEEhcGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwSW5zdGFsbCUyMGJlbG93JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:`!pip install datasets pandas pymongo sentence_transformers
!pip install -U transformers
<span class="hljs-comment"># Install below if using GPU</span>
!pip install accelerate`,wrap:!1}}),I=new w({props:{title:"Step 2: Data sourcing and preparation",local:"step-2-data-sourcing-and-preparation",headingTag:"h2"}}),Z=new h({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGQUlhdE1vbmdvREIlMkZlbWJlZGRlZF9tb3ZpZXMlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMkFJYXRNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjB0aGUlMjBkYXRhc2V0JTIwdG8lMjBhJTIwcGFuZGFzJTIwZGF0YWZyYW1lJTBBZGF0YXNldF9kZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBZGF0YXNldF9kZi5oZWFkKDUp",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># https://huggingface.co/datasets/AIatMongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;AIatMongoDB/embedded_movies&quot;</span>)

<span class="hljs-comment"># Convert the dataset to a pandas dataframe</span>
dataset_df = pd.DataFrame(dataset[<span class="hljs-string">&quot;train&quot;</span>])

dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),v=new h({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3BuYShzdWJzZXQlM0QlNUIlMjJmdWxscGxvdCUyMiU1RCklMEFwcmludCglMjIlNUNuTnVtYmVyJTIwb2YlMjBtaXNzaW5nJTIwdmFsdWVzJTIwaW4lMjBlYWNoJTIwY29sdW1uJTIwYWZ0ZXIlMjByZW1vdmFsJTNBJTIyKSUwQXByaW50KGRhdGFzZXRfZGYuaXNudWxsKCkuc3VtKCkpJTBBJTBBJTIzJTIwUmVtb3ZlJTIwdGhlJTIwcGxvdF9lbWJlZGRpbmclMjBmcm9tJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMGluJTIwdGhlJTIwZGF0YXNldCUyMGFzJTIwd2UlMjBhcmUlMjBnb2luZyUyMHRvJTIwY3JlYXRlJTIwbmV3JTIwZW1iZWRkaW5ncyUyMHdpdGglMjBhbiUyMG9wZW4lMjBzb3VyY2UlMjBlbWJlZGRpbmclMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3AoY29sdW1ucyUzRCU1QiUyMnBsb3RfZW1iZWRkaW5nJTIyJTVEKSUwQWRhdGFzZXRfZGYuaGVhZCg1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Data Preparation</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.dropna(subset=[<span class="hljs-string">&quot;fullplot&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nNumber of missing values in each column after removal:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset_df.isnull().<span class="hljs-built_in">sum</span>())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.drop(columns=[<span class="hljs-string">&quot;plot_embedding&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),W=new w({props:{title:"Step 3: Generating embeddings",local:"step-3-generating-embeddings",headingTag:"h2"}}),V=new h({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGhlbmxwZXIlMkZndGUtbGFyZ2UlMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMnRoZW5scGVyJTJGZ3RlLWxhcmdlJTIyKSUwQSUwQSUwQWRlZiUyMGdldF9lbWJlZGRpbmcodGV4dCUzQSUyMHN0ciklMjAtJTNFJTIwbGlzdCU1QmZsb2F0JTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjB0ZXh0LnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJBdHRlbXB0ZWQlMjB0byUyMGdldCUyMGVtYmVkZGluZyUyMGZvciUyMGVtcHR5JTIwdGV4dC4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTVEJTBBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTIwJTNEJTIwZW1iZWRkaW5nX21vZGVsLmVuY29kZSh0ZXh0KSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZy50b2xpc3QoKSUwQSUwQSUwQWRhdGFzZXRfZGYlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjBkYXRhc2V0X2RmJTVCJTIyZnVsbHBsb3QlMjIlNUQuYXBwbHkoZ2V0X2VtYmVkZGluZyklMEElMEFkYXRhc2V0X2RmLmhlYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># https://huggingface.co/thenlper/gte-large</span>
embedding_model = SentenceTransformer(<span class="hljs-string">&quot;thenlper/gte-large&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
        <span class="hljs-keyword">return</span> []

    embedding = embedding_model.encode(text)

    <span class="hljs-keyword">return</span> embedding.tolist()


dataset_df[<span class="hljs-string">&quot;embedding&quot;</span>] = dataset_df[<span class="hljs-string">&quot;fullplot&quot;</span>].apply(get_embedding)

dataset_df.head()`,wrap:!1}}),Q=new w({props:{title:"Step 4: Database setup and connection",local:"step-4-database-setup-and-connection",headingTag:"h2"}}),N=new w({props:{title:"Step 5: Create a Vector Search Index",local:"step-5-create-a-vector-search-index",headingTag:"h2"}}),x=new h({props:{code:"JTdCJTBBJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIybnVtRGltZW5zaW9ucyUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJwYXRoJTIyJTNBJTIwJTIyZW1iZWRkaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyc2ltaWxhcml0eSUyMiUzQSUyMCUyMmNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ2ZWN0b3IlMjIlMEElMjAlMjAlMjAlN0QlNUQlMEElN0QlMEE=",highlighted:`{
 <span class="hljs-string">&quot;fields&quot;</span>: [{
     <span class="hljs-string">&quot;numDimensions&quot;</span>: <span class="hljs-number">1024</span>,
     <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
     <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
     <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;vector&quot;</span>
   }]
}
`,wrap:!1}}),Y=new w({props:{title:"Step 6: Establish Data Connection",local:"step-6-establish-data-connection",headingTag:"h2"}}),z=new h({props:{code:"aW1wb3J0JTIwcHltb25nbyUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQSUwQSUwQWRlZiUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkVzdGFibGlzaCUyMGNvbm5lY3Rpb24lMjB0byUyMHRoZSUyME1vbmdvREIuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2xpZW50JTIwJTNEJTIwcHltb25nby5Nb25nb0NsaWVudChtb25nb191cmkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQ29ubmVjdGlvbiUyMHRvJTIwTW9uZ29EQiUyMHN1Y2Nlc3NmdWwlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2xpZW50JTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwcHltb25nby5lcnJvcnMuQ29ubmVjdGlvbkZhaWx1cmUlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyQ29ubmVjdGlvbiUyMGZhaWxlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUwQSUwQSUwQW1vbmdvX3VyaSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJNT05HT19VUkklMjIpJTBBaWYlMjBub3QlMjBtb25nb191cmklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJNT05HT19VUkklMjBub3QlMjBzZXQlMjBpbiUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIyKSUwQSUwQW1vbmdvX2NsaWVudCUyMCUzRCUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUwQSUwQSUyMyUyMEluZ2VzdCUyMGRhdGElMjBpbnRvJTIwTW9uZ29EQiUwQWRiJTIwJTNEJTIwbW9uZ29fY2xpZW50JTVCJTIybW92aWVzJTIyJTVEJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRiJTVCJTIybW92aWVfY29sbGVjdGlvbl8yJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pymongo
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_mongo_client</span>(<span class="hljs-params">mongo_uri</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Establish connection to the MongoDB.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        client = pymongo.MongoClient(mongo_uri)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Connection to MongoDB successful&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> pymongo.errors.ConnectionFailure <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Connection failed: <span class="hljs-subst">{e}</span>&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


<span class="hljs-meta">... </span>mongo_uri = userdata.get(<span class="hljs-string">&quot;MONGO_URI&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> mongo_uri:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;MONGO_URI not set in environment variables&quot;</span>)

<span class="hljs-meta">... </span>mongo_client = get_mongo_client(mongo_uri)

<span class="hljs-meta">... </span><span class="hljs-comment"># Ingest data into MongoDB</span>
<span class="hljs-meta">... </span>db = mongo_client[<span class="hljs-string">&quot;movies&quot;</span>]
<span class="hljs-meta">... </span>collection = db[<span class="hljs-string">&quot;movie_collection_2&quot;</span>]`,wrap:!1}}),P=new h({props:{code:"JTIzJTIwRGVsZXRlJTIwYW55JTIwZXhpc3RpbmclMjByZWNvcmRzJTIwaW4lMjB0aGUlMjBjb2xsZWN0aW9uJTBBY29sbGVjdGlvbi5kZWxldGVfbWFueSglN0IlN0Qp",highlighted:`<span class="hljs-comment"># Delete any existing records in the collection</span>
collection.delete_many({})`,wrap:!1}}),K=new h({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldF9kZi50b19kaWN0KCUyMnJlY29yZHMlMjIpJTBBY29sbGVjdGlvbi5pbnNlcnRfbWFueShkb2N1bWVudHMpJTBBJTBBcHJpbnQoJTIyRGF0YSUyMGluZ2VzdGlvbiUyMGludG8lMjBNb25nb0RCJTIwY29tcGxldGVkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>documents = dataset_df.to_dict(<span class="hljs-string">&quot;records&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.insert_many(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into MongoDB completed&quot;</span>)`,wrap:!1}}),ee=new w({props:{title:"Step 7: Perform Vector Search on User Queries",local:"step-7-perform-vector-search-on-user-queries",headingTag:"h2"}}),le=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">user_query, collection</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Perform a vector search in the MongoDB collection based on the user query.

    Args:
    user_query (str): The user&#x27;s query string.
    collection (MongoCollection): The MongoDB collection to search.

    Returns:
    list: A list of matching documents.
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># Generate embedding for the user query</span>
    query_embedding = get_embedding(user_query)

    <span class="hljs-keyword">if</span> query_embedding <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Invalid query or embedding generation failed.&quot;</span>

    <span class="hljs-comment"># Define the vector search pipeline</span>
    pipeline = [
        {
            <span class="hljs-string">&quot;$vectorSearch&quot;</span>: {
                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;vector_index&quot;</span>,
                <span class="hljs-string">&quot;queryVector&quot;</span>: query_embedding,
                <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
                <span class="hljs-string">&quot;numCandidates&quot;</span>: <span class="hljs-number">150</span>,  <span class="hljs-comment"># Number of candidate matches to consider</span>
                <span class="hljs-string">&quot;limit&quot;</span>: <span class="hljs-number">4</span>,  <span class="hljs-comment"># Return top 4 matches</span>
            }
        },
        {
            <span class="hljs-string">&quot;$project&quot;</span>: {
                <span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-number">0</span>,  <span class="hljs-comment"># Exclude the _id field</span>
                <span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the plot field</span>
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the title field</span>
                <span class="hljs-string">&quot;genres&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the genres field</span>
                <span class="hljs-string">&quot;score&quot;</span>: {<span class="hljs-string">&quot;$meta&quot;</span>: <span class="hljs-string">&quot;vectorSearchScore&quot;</span>},  <span class="hljs-comment"># Include the search score</span>
            }
        },
    ]

    <span class="hljs-comment"># Execute the search</span>
    results = collection.aggregate(pipeline)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(results)`,wrap:!1}}),ne=new w({props:{title:"Step 8: Handling user queries and loading Gemma",local:"step-8-handling-user-queries-and-loading-gemma",headingTag:"h2"}}),ae=new h({props:{code:"ZGVmJTIwZ2V0X3NlYXJjaF9yZXN1bHQocXVlcnklMkMlMjBjb2xsZWN0aW9uKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGdldF9rbm93bGVkZ2UlMjAlM0QlMjB2ZWN0b3Jfc2VhcmNoKHF1ZXJ5JTJDJTIwY29sbGVjdGlvbiklMEElMEElMjAlMjAlMjAlMjBzZWFyY2hfcmVzdWx0JTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVzdWx0JTIwaW4lMjBnZXRfa25vd2xlZGdlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VhcmNoX3Jlc3VsdCUyMCUyQiUzRCUyMGYlMjJUaXRsZSUzQSUyMCU3QnJlc3VsdC5nZXQoJ3RpdGxlJyUyQyUyMCdOJTJGQScpJTdEJTJDJTIwUGxvdCUzQSUyMCU3QnJlc3VsdC5nZXQoJ2Z1bGxwbG90JyUyQyUyMCdOJTJGQScpJTdEJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlYXJjaF9yZXN1bHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_search_result</span>(<span class="hljs-params">query, collection</span>):

    get_knowledge = vector_search(query, collection)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),ie=new h({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFzb3VyY2VfaW5mb3JtYXRpb24lMjAlM0QlMjBnZXRfc2VhcmNoX3Jlc3VsdChxdWVyeSUyQyUyMGNvbGxlY3Rpb24pJTBBY29tYmluZWRfaW5mb3JtYXRpb24lMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwZiUyMlF1ZXJ5JTNBJTIwJTdCcXVlcnklN0QlNUNuQ29udGludWUlMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXJ5JTIwYnklMjB1c2luZyUyMHRoZSUyMFNlYXJjaCUyMFJlc3VsdHMlM0ElNUNuJTdCc291cmNlX2luZm9ybWF0aW9uJTdELiUyMiUwQSklMEElMEFwcmludChjb21iaW5lZF9pbmZvcm1hdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source_information = get_search_result(query, collection)
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_information = (
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using the Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_information)`,wrap:!1}}),re=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;)</span>
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),pe=new h({props:{code:"JTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFyZXNwb25zZSUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MDApJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShyZXNwb25zZSU1QjAlNUQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">500</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(response[<span class="hljs-number">0</span>]))`,wrap:!1}}),Me=new h({props:{code:"",highlighted:"",wrap:!1}}),{c(){u=i("meta"),ye=n(),me=i("p"),he=n(),r(g.$$.fragment),ue=n(),r(j.$$.fragment),we=n(),J=i("p"),J.innerHTML=mt,ge=n(),r(T.$$.fragment),je=n(),b=i("p"),b.textContent=dt,Je=n(),U=i("ul"),U.innerHTML=yt,Te=n(),r(f.$$.fragment),be=n(),r(I.$$.fragment),Ue=n(),C=i("p"),C.innerHTML=ht,fe=n(),r(Z.$$.fragment),Ie=n(),B=i("p"),B.textContent=ut,Ce=n(),G=i("ol"),G.innerHTML=wt,Ze=n(),r(v.$$.fragment),Be=n(),A=i("pre"),A.textContent=gt,Ge=n(),r(W.$$.fragment),ve=n(),k=i("p"),k.innerHTML=jt,Ae=n(),R=i("ol"),R.innerHTML=Jt,We=n(),$=i("p"),$.innerHTML=Tt,ke=n(),r(V.$$.fragment),Re=n(),r(Q.$$.fragment),$e=n(),S=i("p"),S.textContent=bt,Ve=n(),_=i("p"),_.innerHTML=Ut,Qe=n(),q=i("ol"),q.innerHTML=ft,Se=n(),r(N.$$.fragment),_e=n(),E=i("p"),E.textContent=It,qe=n(),X=i("p"),X.innerHTML=Ct,Ne=n(),r(x.$$.fragment),Ee=n(),F=i("p"),F.innerHTML=Zt,Xe=n(),r(Y.$$.fragment),xe=n(),H=i("p"),H.textContent=Bt,Fe=n(),r(z.$$.fragment),Ye=n(),D=i("pre"),D.textContent=Gt,He=n(),r(P.$$.fragment),ze=n(),L=i("p"),L.innerHTML=vt,De=n(),r(K.$$.fragment),Pe=n(),O=i("pre"),O.textContent=At,Le=n(),r(ee.$$.fragment),Ke=n(),te=i("p"),te.textContent=Wt,Oe=n(),se=i("p"),se.innerHTML=kt,et=n(),r(le.$$.fragment),tt=n(),r(ne.$$.fragment),st=n(),r(ae.$$.fragment),lt=n(),r(ie.$$.fragment),nt=n(),oe=i("pre"),oe.textContent=Rt,at=n(),r(re.$$.fragment),it=n(),r(pe.$$.fragment),ot=n(),ce=i("pre"),ce.innerHTML=$t,rt=n(),r(Me.$$.fragment),pt=n(),de=i("p"),this.h()},l(e){const t=Xt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(s),ye=a(e),me=o(e,"P",{}),Vt(me).forEach(s),he=a(e),p(g.$$.fragment,e),ue=a(e),p(j.$$.fragment,e),we=a(e),J=o(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-v2pm3i"&&(J.innerHTML=mt),ge=a(e),p(T.$$.fragment,e),je=a(e),b=o(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1l8u5ax"&&(b.textContent=dt),Je=a(e),U=o(e,"UL",{"data-svelte-h":!0}),c(U)!=="svelte-oizoqw"&&(U.innerHTML=yt),Te=a(e),p(f.$$.fragment,e),be=a(e),p(I.$$.fragment,e),Ue=a(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-mi16g3"&&(C.innerHTML=ht),fe=a(e),p(Z.$$.fragment,e),Ie=a(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-s56722"&&(B.textContent=ut),Ce=a(e),G=o(e,"OL",{"data-svelte-h":!0}),c(G)!=="svelte-18k6dgd"&&(G.innerHTML=wt),Ze=a(e),p(v.$$.fragment,e),Be=a(e),A=o(e,"PRE",{"data-svelte-h":!0}),c(A)!=="svelte-kp0u3c"&&(A.textContent=gt),Ge=a(e),p(W.$$.fragment,e),ve=a(e),k=o(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-16a70y4"&&(k.innerHTML=jt),Ae=a(e),R=o(e,"OL",{"data-svelte-h":!0}),c(R)!=="svelte-2t4hjb"&&(R.innerHTML=Jt),We=a(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-18ffxry"&&($.innerHTML=Tt),ke=a(e),p(V.$$.fragment,e),Re=a(e),p(Q.$$.fragment,e),$e=a(e),S=o(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1bv8nrt"&&(S.textContent=bt),Ve=a(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1lfzr8d"&&(_.innerHTML=Ut),Qe=a(e),q=o(e,"OL",{"data-svelte-h":!0}),c(q)!=="svelte-1mt6yhl"&&(q.innerHTML=ft),Se=a(e),p(N.$$.fragment,e),_e=a(e),E=o(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-rsvp8c"&&(E.textContent=It),qe=a(e),X=o(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-r7oqi4"&&(X.innerHTML=Ct),Ne=a(e),p(x.$$.fragment,e),Ee=a(e),F=o(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1lac1sw"&&(F.innerHTML=Zt),Xe=a(e),p(Y.$$.fragment,e),xe=a(e),H=o(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-c17qkj"&&(H.textContent=Bt),Fe=a(e),p(z.$$.fragment,e),Ye=a(e),D=o(e,"PRE",{"data-svelte-h":!0}),c(D)!=="svelte-1im4pel"&&(D.textContent=Gt),He=a(e),p(P.$$.fragment,e),ze=a(e),L=o(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1f9pwum"&&(L.innerHTML=vt),De=a(e),p(K.$$.fragment,e),Pe=a(e),O=o(e,"PRE",{"data-svelte-h":!0}),c(O)!=="svelte-48vgel"&&(O.textContent=At),Le=a(e),p(ee.$$.fragment,e),Ke=a(e),te=o(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1r00an3"&&(te.textContent=Wt),Oe=a(e),se=o(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1hz15p5"&&(se.innerHTML=kt),et=a(e),p(le.$$.fragment,e),tt=a(e),p(ne.$$.fragment,e),st=a(e),p(ae.$$.fragment,e),lt=a(e),p(ie.$$.fragment,e),nt=a(e),oe=o(e,"PRE",{"data-svelte-h":!0}),c(oe)!=="svelte-kam1j9"&&(oe.textContent=Rt),at=a(e),p(re.$$.fragment,e),it=a(e),p(pe.$$.fragment,e),ot=a(e),ce=o(e,"PRE",{"data-svelte-h":!0}),c(ce)!=="svelte-146jypo"&&(ce.innerHTML=$t),rt=a(e),p(Me.$$.fragment,e),pt=a(e),de=o(e,"P",{}),Vt(de).forEach(s),this.h()},h(){Qt(u,"name","hf:doc:metadata"),Qt(u,"content",Ht)},m(e,t){xt(document.head,u),l(e,ye,t),l(e,me,t),l(e,he,t),M(g,e,t),l(e,ue,t),M(j,e,t),l(e,we,t),l(e,J,t),l(e,ge,t),M(T,e,t),l(e,je,t),l(e,b,t),l(e,Je,t),l(e,U,t),l(e,Te,t),M(f,e,t),l(e,be,t),M(I,e,t),l(e,Ue,t),l(e,C,t),l(e,fe,t),M(Z,e,t),l(e,Ie,t),l(e,B,t),l(e,Ce,t),l(e,G,t),l(e,Ze,t),M(v,e,t),l(e,Be,t),l(e,A,t),l(e,Ge,t),M(W,e,t),l(e,ve,t),l(e,k,t),l(e,Ae,t),l(e,R,t),l(e,We,t),l(e,$,t),l(e,ke,t),M(V,e,t),l(e,Re,t),M(Q,e,t),l(e,$e,t),l(e,S,t),l(e,Ve,t),l(e,_,t),l(e,Qe,t),l(e,q,t),l(e,Se,t),M(N,e,t),l(e,_e,t),l(e,E,t),l(e,qe,t),l(e,X,t),l(e,Ne,t),M(x,e,t),l(e,Ee,t),l(e,F,t),l(e,Xe,t),M(Y,e,t),l(e,xe,t),l(e,H,t),l(e,Fe,t),M(z,e,t),l(e,Ye,t),l(e,D,t),l(e,He,t),M(P,e,t),l(e,ze,t),l(e,L,t),l(e,De,t),M(K,e,t),l(e,Pe,t),l(e,O,t),l(e,Le,t),M(ee,e,t),l(e,Ke,t),l(e,te,t),l(e,Oe,t),l(e,se,t),l(e,et,t),M(le,e,t),l(e,tt,t),M(ne,e,t),l(e,st,t),M(ae,e,t),l(e,lt,t),M(ie,e,t),l(e,nt,t),l(e,oe,t),l(e,at,t),M(re,e,t),l(e,it,t),M(pe,e,t),l(e,ot,t),l(e,ce,t),l(e,rt,t),M(Me,e,t),l(e,pt,t),l(e,de,t),ct=!0},p:_t,i(e){ct||(m(g.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(x.$$.fragment,e),m(Y.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(Me.$$.fragment,e),ct=!0)},o(e){d(g.$$.fragment,e),d(j.$$.fragment,e),d(T.$$.fragment,e),d(f.$$.fragment,e),d(I.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(W.$$.fragment,e),d(V.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(x.$$.fragment,e),d(Y.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),ct=!1},d(e){e&&(s(ye),s(me),s(he),s(ue),s(we),s(J),s(ge),s(je),s(b),s(Je),s(U),s(Te),s(be),s(Ue),s(C),s(fe),s(Ie),s(B),s(Ce),s(G),s(Ze),s(Be),s(A),s(Ge),s(ve),s(k),s(Ae),s(R),s(We),s($),s(ke),s(Re),s($e),s(S),s(Ve),s(_),s(Qe),s(q),s(Se),s(_e),s(E),s(qe),s(X),s(Ne),s(Ee),s(F),s(Xe),s(xe),s(H),s(Fe),s(Ye),s(D),s(He),s(ze),s(L),s(De),s(Pe),s(O),s(Le),s(Ke),s(te),s(Oe),s(se),s(et),s(tt),s(st),s(lt),s(nt),s(oe),s(at),s(it),s(ot),s(ce),s(rt),s(pt),s(de)),s(u),y(g,e),y(j,e),y(T,e),y(f,e),y(I,e),y(Z,e),y(v,e),y(W,e),y(V,e),y(Q,e),y(N,e),y(x,e),y(Y,e),y(z,e),y(P,e),y(K,e),y(ee,e),y(le,e),y(ne,e),y(ae,e),y(ie,e),y(re,e),y(pe,e),y(Me,e)}}}const Ht='{"title":"Building A RAG System with Gemma, MongoDB and Open Source Models","local":"building-a-rag-system-with-gemma-mongodb-and-open-source-models","sections":[{"title":"Step 1: Installing Libraries","local":"step-1-installing-libraries","sections":[],"depth":2},{"title":"Step 2: Data sourcing and preparation","local":"step-2-data-sourcing-and-preparation","sections":[],"depth":2},{"title":"Step 3: Generating embeddings","local":"step-3-generating-embeddings","sections":[],"depth":2},{"title":"Step 4: Database setup and connection","local":"step-4-database-setup-and-connection","sections":[],"depth":2},{"title":"Step 5: Create a Vector Search Index","local":"step-5-create-a-vector-search-index","sections":[],"depth":2},{"title":"Step 6: Establish Data Connection","local":"step-6-establish-data-connection","sections":[],"depth":2},{"title":"Step 7: Perform Vector Search on User Queries","local":"step-7-perform-vector-search-on-user-queries","sections":[],"depth":2},{"title":"Step 8: Handling user queries and loading Gemma","local":"step-8-handling-user-queries-and-loading-gemma","sections":[],"depth":2}],"depth":1}';function zt(Mt){return qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Nt{constructor(u){super(),Et(this,u,zt,Yt,St,{})}}export{Ot as component};
