import{s as Ot,n as el,o as tl}from"../chunks/scheduler.25b97de1.js";import{S as ll,i as nl,g as i,s as a,r as g,A as al,h as o,f as l,c as s,j as Dt,u as p,x as m,k as Kt,y as sl,a as n,v as r,d as u,t as d,w as c}from"../chunks/index.d9030fc9.js";import{C as h}from"../chunks/CodeBlock.e6cd0d95.js";import{D as il}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as M,E as ol}from"../chunks/EditOnGithub.91d95064.js";function ml(Tt){let f,be,fe,Te,b,Je,T,ye,J,Jt='There are several multilingual models in 🤗 Transformers, and their inference usage differs from monolingual models. Not <em>all</em> multilingual model usage is different though. Some models, like <a href="https://huggingface.co/google-bert/bert-base-multilingual-uncased" rel="nofollow">google-bert/bert-base-multilingual-uncased</a>, can be used just like a monolingual model. This guide will show you how to use multilingual models whose usage differs for inference.',Ue,y,ke,U,yt="XLM has ten different checkpoints, only one of which is monolingual. The nine remaining model checkpoints can be split into two categories: the checkpoints that use language embeddings and those that don’t.",we,k,$e,w,Ut="The following XLM models use language embeddings to specify the language used at inference:",je,$,kt="<li><code>FacebookAI/xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>FacebookAI/xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>FacebookAI/xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>FacebookAI/xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>FacebookAI/xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>FacebookAI/xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>FacebookAI/xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",ve,j,wt="Language embeddings are represented as a tensor of the same shape as the <code>input_ids</code> passed to the model. The values in these tensors depend on the language used and are identified by the tokenizer’s <code>lang2id</code> and <code>id2lang</code> attributes.",xe,v,$t="In this example, load the <code>FacebookAI/xlm-clm-enfr-1024</code> checkpoint (Causal language modeling, English-French):",Ze,x,Ce,Z,jt="The <code>lang2id</code> attribute of the tokenizer displays this model’s languages and their ids:",_e,C,Ie,_,vt="Next, create an example input:",Xe,I,Ge,X,xt="Set the language id as <code>&quot;en&quot;</code> and use it to define the language embedding. The language embedding is a tensor filled with <code>0</code> since that is the language id for English. This tensor should be the same size as <code>input_ids</code>.",We,G,Ve,W,Zt="Now you can pass the <code>input_ids</code> and language embedding to the model:",Re,V,Le,R,Ct='The <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> script can generate text with language embeddings using the <code>xlm-clm</code> checkpoints.',Be,L,Fe,B,_t="The following XLM models do not require language embeddings during inference:",ze,F,It="<li><code>FacebookAI/xlm-mlm-17-1280</code> (Masked language modeling, 17 languages)</li> <li><code>FacebookAI/xlm-mlm-100-1280</code> (Masked language modeling, 100 languages)</li>",Ee,z,Xt="These models are used for generic sentence representations, unlike the previous XLM checkpoints.",He,E,qe,H,Gt="The following BERT models can be used for multilingual tasks:",Qe,q,Wt="<li><code>google-bert/bert-base-multilingual-uncased</code> (Masked language modeling + Next sentence prediction, 102 languages)</li> <li><code>google-bert/bert-base-multilingual-cased</code> (Masked language modeling + Next sentence prediction, 104 languages)</li>",Ne,Q,Vt=`These models do not require language embeddings during inference. They should identify the language from the
context and infer accordingly.`,Ye,N,Ae,Y,Rt="The following XLM-RoBERTa models can be used for multilingual tasks:",Pe,A,Lt="<li><code>FacebookAI/xlm-roberta-base</code> (Masked language modeling, 100 languages)</li> <li><code>FacebookAI/xlm-roberta-large</code> (Masked language modeling, 100 languages)</li>",Se,P,Bt="XLM-RoBERTa was trained on 2.5TB of newly created and cleaned CommonCrawl data in 100 languages. It provides strong gains over previously released multilingual models like mBERT or XLM on downstream tasks like classification, sequence labeling, and question answering.",De,S,Ke,D,Ft="The following M2M100 models can be used for multilingual translation:",Oe,K,zt="<li><code>facebook/m2m100_418M</code> (Translation)</li> <li><code>facebook/m2m100_1.2B</code> (Translation)</li>",et,O,Et="In this example, load the <code>facebook/m2m100_418M</code> checkpoint to translate from Chinese to English. You can set the source language in the tokenizer:",tt,ee,lt,te,Ht="Tokenize the text:",nt,le,at,ne,qt="M2M100 forces the target language id as the first generated token to translate to the target language. Set the <code>forced_bos_token_id</code> to <code>en</code> in the <code>generate</code> method to translate to English:",st,ae,it,se,ot,ie,Qt="The following MBart models can be used for multilingual translation:",mt,oe,Nt="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (One-to-many multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Many-to-many multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Many-to-one multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50</code> (Multilingual translation, 50 languages)</li> <li><code>facebook/mbart-large-cc25</code></li>",gt,me,Yt="In this example, load the <code>facebook/mbart-large-50-many-to-many-mmt</code> checkpoint to translate Finnish to English. You can set the source language in the tokenizer:",pt,ge,rt,pe,At="Tokenize the text:",ut,re,dt,ue,Pt="MBart forces the target language id as the first generated token to translate to the target language. Set the <code>forced_bos_token_id</code> to <code>en</code> in the <code>generate</code> method to translate to English:",ct,de,ht,ce,St="If you are using the <code>facebook/mbart-large-50-many-to-one-mmt</code> checkpoint, you don’t need to force the target language id as the first generated token otherwise the usage is the same.",ft,he,Mt,Me,bt;return b=new M({props:{title:"Multilingual models for inference",local:"multilingual-models-for-inference",headingTag:"h1"}}),T=new il({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multilingual.ipynb"}]}}),y=new M({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),k=new M({props:{title:"XLM with language embeddings",local:"xlm-with-language-embeddings",headingTag:"h3"}}),x=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJGYWNlYm9va0FJJTJGeGxtLWNsbS1lbmZyLTEwMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBYTE1XaXRoTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkZhY2Vib29rQUklMkZ4bG0tY2xtLWVuZnItMTAyNCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),C=new h({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),I=new h({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),G=new h({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),V=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new M({props:{title:"XLM without language embeddings",local:"xlm-without-language-embeddings",headingTag:"h3"}}),E=new M({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new M({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),S=new M({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new h({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new h({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),se=new M({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),ge=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),re=new h({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),de=new h({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkJTVCJTIyZW5fWFglMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id[<span class="hljs-string">&quot;en_XX&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),he=new ol({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/multilingual.md"}}),{c(){f=i("meta"),be=a(),fe=i("p"),Te=a(),g(b.$$.fragment),Je=a(),g(T.$$.fragment),ye=a(),J=i("p"),J.innerHTML=Jt,Ue=a(),g(y.$$.fragment),ke=a(),U=i("p"),U.textContent=yt,we=a(),g(k.$$.fragment),$e=a(),w=i("p"),w.textContent=Ut,je=a(),$=i("ul"),$.innerHTML=kt,ve=a(),j=i("p"),j.innerHTML=wt,xe=a(),v=i("p"),v.innerHTML=$t,Ze=a(),g(x.$$.fragment),Ce=a(),Z=i("p"),Z.innerHTML=jt,_e=a(),g(C.$$.fragment),Ie=a(),_=i("p"),_.textContent=vt,Xe=a(),g(I.$$.fragment),Ge=a(),X=i("p"),X.innerHTML=xt,We=a(),g(G.$$.fragment),Ve=a(),W=i("p"),W.innerHTML=Zt,Re=a(),g(V.$$.fragment),Le=a(),R=i("p"),R.innerHTML=Ct,Be=a(),g(L.$$.fragment),Fe=a(),B=i("p"),B.textContent=_t,ze=a(),F=i("ul"),F.innerHTML=It,Ee=a(),z=i("p"),z.textContent=Xt,He=a(),g(E.$$.fragment),qe=a(),H=i("p"),H.textContent=Gt,Qe=a(),q=i("ul"),q.innerHTML=Wt,Ne=a(),Q=i("p"),Q.textContent=Vt,Ye=a(),g(N.$$.fragment),Ae=a(),Y=i("p"),Y.textContent=Rt,Pe=a(),A=i("ul"),A.innerHTML=Lt,Se=a(),P=i("p"),P.textContent=Bt,De=a(),g(S.$$.fragment),Ke=a(),D=i("p"),D.textContent=Ft,Oe=a(),K=i("ul"),K.innerHTML=zt,et=a(),O=i("p"),O.innerHTML=Et,tt=a(),g(ee.$$.fragment),lt=a(),te=i("p"),te.textContent=Ht,nt=a(),g(le.$$.fragment),at=a(),ne=i("p"),ne.innerHTML=qt,st=a(),g(ae.$$.fragment),it=a(),g(se.$$.fragment),ot=a(),ie=i("p"),ie.textContent=Qt,mt=a(),oe=i("ul"),oe.innerHTML=Nt,gt=a(),me=i("p"),me.innerHTML=Yt,pt=a(),g(ge.$$.fragment),rt=a(),pe=i("p"),pe.textContent=At,ut=a(),g(re.$$.fragment),dt=a(),ue=i("p"),ue.innerHTML=Pt,ct=a(),g(de.$$.fragment),ht=a(),ce=i("p"),ce.innerHTML=St,ft=a(),g(he.$$.fragment),Mt=a(),Me=i("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),be=s(e),fe=o(e,"P",{}),Dt(fe).forEach(l),Te=s(e),p(b.$$.fragment,e),Je=s(e),p(T.$$.fragment,e),ye=s(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-n4t2ib"&&(J.innerHTML=Jt),Ue=s(e),p(y.$$.fragment,e),ke=s(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-gat0c0"&&(U.textContent=yt),we=s(e),p(k.$$.fragment,e),$e=s(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1rdjt2u"&&(w.textContent=Ut),je=s(e),$=o(e,"UL",{"data-svelte-h":!0}),m($)!=="svelte-bq7gp5"&&($.innerHTML=kt),ve=s(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-etk90v"&&(j.innerHTML=wt),xe=s(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-vzqfkk"&&(v.innerHTML=$t),Ze=s(e),p(x.$$.fragment,e),Ce=s(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-ncydbw"&&(Z.innerHTML=jt),_e=s(e),p(C.$$.fragment,e),Ie=s(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1a9p0ho"&&(_.textContent=vt),Xe=s(e),p(I.$$.fragment,e),Ge=s(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-vuczip"&&(X.innerHTML=xt),We=s(e),p(G.$$.fragment,e),Ve=s(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-v1jc9q"&&(W.innerHTML=Zt),Re=s(e),p(V.$$.fragment,e),Le=s(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-c53qag"&&(R.innerHTML=Ct),Be=s(e),p(L.$$.fragment,e),Fe=s(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1m6ccze"&&(B.textContent=_t),ze=s(e),F=o(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-1b587ai"&&(F.innerHTML=It),Ee=s(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1fn4lmn"&&(z.textContent=Xt),He=s(e),p(E.$$.fragment,e),qe=s(e),H=o(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-ze8b37"&&(H.textContent=Gt),Qe=s(e),q=o(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-1av8rgt"&&(q.innerHTML=Wt),Ne=s(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1uvjv96"&&(Q.textContent=Vt),Ye=s(e),p(N.$$.fragment,e),Ae=s(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-cq4taf"&&(Y.textContent=Rt),Pe=s(e),A=o(e,"UL",{"data-svelte-h":!0}),m(A)!=="svelte-c4slig"&&(A.innerHTML=Lt),Se=s(e),P=o(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1ahupcy"&&(P.textContent=Bt),De=s(e),p(S.$$.fragment,e),Ke=s(e),D=o(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1n18e2"&&(D.textContent=Ft),Oe=s(e),K=o(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-xli8b1"&&(K.innerHTML=zt),et=s(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1hz3ybz"&&(O.innerHTML=Et),tt=s(e),p(ee.$$.fragment,e),lt=s(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1v7p0in"&&(te.textContent=Ht),nt=s(e),p(le.$$.fragment,e),at=s(e),ne=o(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1t7zua3"&&(ne.innerHTML=qt),st=s(e),p(ae.$$.fragment,e),it=s(e),p(se.$$.fragment,e),ot=s(e),ie=o(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1kinu1v"&&(ie.textContent=Qt),mt=s(e),oe=o(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-xa5lcq"&&(oe.innerHTML=Nt),gt=s(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-aaduni"&&(me.innerHTML=Yt),pt=s(e),p(ge.$$.fragment,e),rt=s(e),pe=o(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1v7p0in"&&(pe.textContent=At),ut=s(e),p(re.$$.fragment,e),dt=s(e),ue=o(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1hdrcsc"&&(ue.innerHTML=Pt),ct=s(e),p(de.$$.fragment,e),ht=s(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1la8qcj"&&(ce.innerHTML=St),ft=s(e),p(he.$$.fragment,e),Mt=s(e),Me=o(e,"P",{}),Dt(Me).forEach(l),this.h()},h(){Kt(f,"name","hf:doc:metadata"),Kt(f,"content",gl)},m(e,t){sl(document.head,f),n(e,be,t),n(e,fe,t),n(e,Te,t),r(b,e,t),n(e,Je,t),r(T,e,t),n(e,ye,t),n(e,J,t),n(e,Ue,t),r(y,e,t),n(e,ke,t),n(e,U,t),n(e,we,t),r(k,e,t),n(e,$e,t),n(e,w,t),n(e,je,t),n(e,$,t),n(e,ve,t),n(e,j,t),n(e,xe,t),n(e,v,t),n(e,Ze,t),r(x,e,t),n(e,Ce,t),n(e,Z,t),n(e,_e,t),r(C,e,t),n(e,Ie,t),n(e,_,t),n(e,Xe,t),r(I,e,t),n(e,Ge,t),n(e,X,t),n(e,We,t),r(G,e,t),n(e,Ve,t),n(e,W,t),n(e,Re,t),r(V,e,t),n(e,Le,t),n(e,R,t),n(e,Be,t),r(L,e,t),n(e,Fe,t),n(e,B,t),n(e,ze,t),n(e,F,t),n(e,Ee,t),n(e,z,t),n(e,He,t),r(E,e,t),n(e,qe,t),n(e,H,t),n(e,Qe,t),n(e,q,t),n(e,Ne,t),n(e,Q,t),n(e,Ye,t),r(N,e,t),n(e,Ae,t),n(e,Y,t),n(e,Pe,t),n(e,A,t),n(e,Se,t),n(e,P,t),n(e,De,t),r(S,e,t),n(e,Ke,t),n(e,D,t),n(e,Oe,t),n(e,K,t),n(e,et,t),n(e,O,t),n(e,tt,t),r(ee,e,t),n(e,lt,t),n(e,te,t),n(e,nt,t),r(le,e,t),n(e,at,t),n(e,ne,t),n(e,st,t),r(ae,e,t),n(e,it,t),r(se,e,t),n(e,ot,t),n(e,ie,t),n(e,mt,t),n(e,oe,t),n(e,gt,t),n(e,me,t),n(e,pt,t),r(ge,e,t),n(e,rt,t),n(e,pe,t),n(e,ut,t),r(re,e,t),n(e,dt,t),n(e,ue,t),n(e,ct,t),r(de,e,t),n(e,ht,t),n(e,ce,t),n(e,ft,t),r(he,e,t),n(e,Mt,t),n(e,Me,t),bt=!0},p:el,i(e){bt||(u(b.$$.fragment,e),u(T.$$.fragment,e),u(y.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(L.$$.fragment,e),u(E.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(ge.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),bt=!0)},o(e){d(b.$$.fragment,e),d(T.$$.fragment,e),d(y.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(C.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(V.$$.fragment,e),d(L.$$.fragment,e),d(E.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ge.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),bt=!1},d(e){e&&(l(be),l(fe),l(Te),l(Je),l(ye),l(J),l(Ue),l(ke),l(U),l(we),l($e),l(w),l(je),l($),l(ve),l(j),l(xe),l(v),l(Ze),l(Ce),l(Z),l(_e),l(Ie),l(_),l(Xe),l(Ge),l(X),l(We),l(Ve),l(W),l(Re),l(Le),l(R),l(Be),l(Fe),l(B),l(ze),l(F),l(Ee),l(z),l(He),l(qe),l(H),l(Qe),l(q),l(Ne),l(Q),l(Ye),l(Ae),l(Y),l(Pe),l(A),l(Se),l(P),l(De),l(Ke),l(D),l(Oe),l(K),l(et),l(O),l(tt),l(lt),l(te),l(nt),l(at),l(ne),l(st),l(it),l(ot),l(ie),l(mt),l(oe),l(gt),l(me),l(pt),l(rt),l(pe),l(ut),l(dt),l(ue),l(ct),l(ht),l(ce),l(ft),l(Mt),l(Me)),l(f),c(b,e),c(T,e),c(y,e),c(k,e),c(x,e),c(C,e),c(I,e),c(G,e),c(V,e),c(L,e),c(E,e),c(N,e),c(S,e),c(ee,e),c(le,e),c(ae,e),c(se,e),c(ge,e),c(re,e),c(de,e),c(he,e)}}}const gl='{"title":"Multilingual models for inference","local":"multilingual-models-for-inference","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM with language embeddings","local":"xlm-with-language-embeddings","sections":[],"depth":3},{"title":"XLM without language embeddings","local":"xlm-without-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function pl(Tt){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fl extends ll{constructor(f){super(),nl(this,f,pl,ml,Ot,{})}}export{fl as component};
