import{s as Tt,o as kt,n as wt}from"../chunks/scheduler.6062bdaf.js";import{S as Ct,i as Ht,g as i,s as t,r as u,A as Lt,h as o,f as r,c as a,j as I,u as l,x as g,k as v,y as n,a as s,v as h,d as m,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as Mt}from"../chunks/Tip.b9ac1f03.js";import{D as y}from"../chunks/Docstring.ed07512f.js";import{C as Pt}from"../chunks/CodeBlock.fa01571c.js";import{E as At}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as Oe}from"../chunks/Heading.723dceba.js";function jt(_e){let f,M='Check out the <a href="../guides/inference_endpoints">related guide</a> to learn how to use <code>huggingface_hub</code> to manage your Inference Endpoints programmatically.';return{c(){f=i("p"),f.innerHTML=M},l($){f=o($,"P",{"data-svelte-h":!0}),g(f)!=="svelte-tmb85g"&&(f.innerHTML=M)},m($,x){s($,f,x)},p:wt,d($){$&&r(f)}}}function qt(_e){let f,M="Example:",$,x,w;return x=new Pt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEElMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBZW5kcG9pbnQucmVzdW1lKCklMEFlbmRwb2ludC53YWl0KCklMEFlbmRwb2ludC5jbGllbnQudGV4dF90b19pbWFnZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)

<span class="hljs-comment"># Pause endpoint to save $$$</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># Resume and wait for deployment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){f=i("p"),f.textContent=M,$=t(),u(x.$$.fragment)},l(E){f=o(E,"P",{"data-svelte-h":!0}),g(f)!=="svelte-11lpom8"&&(f.textContent=M),$=a(E),l(x.$$.fragment,E)},m(E,L){s(E,f,L),s(E,$,L),h(x,E,L),w=!0},p:wt,i(E){w||(m(x.$$.fragment,E),w=!0)},o(E){_(x.$$.fragment,E),w=!1},d(E){E&&(r(f),r($)),b(x,E)}}}function Dt(_e){let f,M,$,x,w,E,L,Yn='Inference Endpoints provides a secure production solution to easily deploy models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>. This page is a reference for <code>huggingface_hub</code>’s integration with Inference Endpoints. For more information about the Inference Endpoints product, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.',Ze,V,Ge,G,Xn='Inference Endpoints can be fully managed via API. The endpoints are documented with <a href="https://api.endpoints.huggingface.cloud/" rel="nofollow">Swagger</a>. The <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> class is a simple wrapper built on top on this API.',Be,B,Qe,Q,Jn='A subset of the Inference Endpoint features are implemented in <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>:',Ye,Y,Kn='<li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to get information about your Inference Endpoints</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a> to deploy and manage Inference Endpoints</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a> to pause and resume an Inference Endpoint</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a> to manually scale an Endpoint to 0 replicas</li>',Xe,X,Je,J,et='The main dataclass is <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>. It contains information about a deployed <code>InferenceEndpoint</code>, including its configuration and current state. Once deployed, you can run inference on the Endpoint using the  <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.client">InferenceEndpoint.client</a> and <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.async_client">InferenceEndpoint.async_client</a> properties that respectively return an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> object.',Ke,p,K,hn,be,nt="Contains information about a deployed Inference Endpoint.",mn,z,_n,N,ee,bn,Ee,tt="Initialize object from raw dictionary.",En,S,ne,$n,$e,at="Returns a client to make predictions on this Inference Endpoint.",In,R,te,vn,Ie,rt="Returns a client to make predictions on this Inference Endpoint.",xn,T,ae,yn,ve,it="Delete the Inference Endpoint.",wn,xe,ot=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a> or scale it to zero with <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.`,Tn,ye,ct='This is an alias for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">HfApi.delete_inference_endpoint()</a>.',kn,U,re,Cn,we,st="Fetch latest information about the Inference Endpoint.",Hn,k,ie,Ln,Te,pt="Pause the Inference Endpoint.",Mn,ke,gt=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>, which
would be automatically restarted when a request is made to it.`,Pn,Ce,dt=`This is an alias for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">HfApi.pause_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,An,P,oe,jn,He,ft="Resume the Inference Endpoint.",qn,Le,ut=`This is an alias for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">HfApi.resume_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Dn,C,ce,Vn,Me,lt="Scale Inference Endpoint to zero.",zn,Pe,ht=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.`,Nn,Ae,mt=`This is an alias for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">HfApi.scale_to_zero_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Sn,H,se,Rn,je,_t="Update the Inference Endpoint.",Un,qe,bt=`This method allows the update of either the compute configuration, the deployed model, or both. All arguments are
optional but at least one must be provided.`,Wn,De,Et=`This is an alias for <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">HfApi.update_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,On,A,pe,Fn,Ve,$t="Wait for the Inference Endpoint to be deployed.",Zn,ze,It=`Information from the server will be fetched every 1s. If the Inference Endpoint is not deployed after <code>timeout</code>
seconds, a <code>InferenceEndpointTimeoutError</code> will be raised. The <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> will be mutated in place with the latest
data.`,en,ge,nn,j,de,Gn,Ne,vt="An enumeration.",tn,fe,an,q,ue,Bn,Se,xt="An enumeration.",rn,le,on,D,he,Qn,Re,yt="Generic exception when dealing with Inference Endpoints.",cn,Fe,sn;return w=new Oe({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),V=new Mt({props:{$$slots:{default:[jt]},$$scope:{ctx:_e}}}),B=new Oe({props:{title:"Methods",local:"methods",headingTag:"h2"}}),X=new Oe({props:{title:"InferenceEndpoint",local:"huggingface_hub.InferenceEndpoint",headingTag:"h2"}}),K=new y({props:{name:"class huggingface_hub.InferenceEndpoint",anchor:"huggingface_hub.InferenceEndpoint",parameters:[{name:"namespace",val:": str"},{name:"raw",val:": typing.Dict"},{name:"_token",val:": typing.Optional[str]"},{name:"_api",val:": HfApi"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name of the Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.InferenceEndpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>) &#x2014;
The namespace where the Inference Endpoint is located.`,name:"namespace"},{anchor:"huggingface_hub.InferenceEndpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository deployed on this Inference Endpoint.`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.status",description:`<strong>status</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>) &#x2014;
The current status of the Inference Endpoint.`,name:"status"},{anchor:"huggingface_hub.InferenceEndpoint.url",description:`<strong>url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The URL of the Inference Endpoint, if available. Only a deployed Inference Endpoint will have a URL.`,name:"url"},{anchor:"huggingface_hub.InferenceEndpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model.`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The specific model revision deployed on the Inference Endpoint.`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task associated with the deployed model.`,name:"task"},{anchor:"huggingface_hub.InferenceEndpoint.created_at",description:`<strong>created_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp when the Inference Endpoint was created.`,name:"created_at"},{anchor:"huggingface_hub.InferenceEndpoint.updated_at",description:`<strong>updated_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp of the last update of the Inference Endpoint.`,name:"updated_at"},{anchor:"huggingface_hub.InferenceEndpoint.type",description:`<strong>type</strong> (<a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointType">InferenceEndpointType</a>) &#x2014;
The type of the Inference Endpoint (public, protected, private).`,name:"type"},{anchor:"huggingface_hub.InferenceEndpoint.raw",description:`<strong>raw</strong> (<code>Dict</code>) &#x2014;
The raw dictionary data returned from the API.`,name:"raw"},{anchor:"huggingface_hub.InferenceEndpoint.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Authentication token for the Inference Endpoint, if set when requesting the API.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L45"}}),z=new At({props:{anchor:"huggingface_hub.InferenceEndpoint.example",$$slots:{default:[qt]},$$scope:{ctx:_e}}}),ee=new y({props:{name:"from_raw",anchor:"huggingface_hub.InferenceEndpoint.from_raw",parameters:[{name:"raw",val:": typing.Dict"},{name:"namespace",val:": str"},{name:"token",val:": typing.Optional[str] = None"},{name:"api",val:": typing.Optional[ForwardRef('HfApi')] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L126"}}),ne=new y({props:{name:"client",anchor:"huggingface_hub.InferenceEndpoint.client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L145",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an inference client pointing to the deployed endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient"
>InferenceClient</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),te=new y({props:{name:"async_client",anchor:"huggingface_hub.InferenceEndpoint.async_client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L162",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an asyncio-compatible inference client pointing to the deployed endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient"
>AsyncInferenceClient</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),ae=new y({props:{name:"delete",anchor:"huggingface_hub.InferenceEndpoint.delete",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L346"}}),re=new y({props:{name:"fetch",anchor:"huggingface_hub.InferenceEndpoint.fetch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L217",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ie=new y({props:{name:"pause",anchor:"huggingface_hub.InferenceEndpoint.pause",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L296",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),oe=new y({props:{name:"resume",anchor:"huggingface_hub.InferenceEndpoint.resume",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ce=new y({props:{name:"scale_to_zero",anchor:"huggingface_hub.InferenceEndpoint.scale_to_zero",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L328",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),se=new y({props:{name:"update",anchor:"huggingface_hub.InferenceEndpoint.update",parameters:[{name:"accelerator",val:": typing.Optional[str] = None"},{name:"instance_size",val:": typing.Optional[str] = None"},{name:"instance_type",val:": typing.Optional[str] = None"},{name:"min_replica",val:": typing.Optional[int] = None"},{name:"max_replica",val:": typing.Optional[int] = None"},{name:"repository",val:": typing.Optional[str] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"task",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.update.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;large&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;c6i&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.InferenceEndpoint.update.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.update.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.update.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.update.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),pe=new y({props:{name:"wait",anchor:"huggingface_hub.InferenceEndpoint.wait",parameters:[{name:"timeout",val:": typing.Optional[int] = None"},{name:"refresh_every",val:": int = 5"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.wait.timeout",description:`<strong>timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum time to wait for the Inference Endpoint to be deployed, in seconds. If <code>None</code>, will wait
indefinitely.`,name:"timeout"},{anchor:"huggingface_hub.InferenceEndpoint.wait.refresh_every",description:`<strong>refresh_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The time to wait between each fetch of the Inference Endpoint status, in seconds. Defaults to 5s.`,name:"refresh_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L179",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ge=new Oe({props:{title:"InferenceEndpointStatus",local:"huggingface_hub.InferenceEndpointStatus",headingTag:"h2"}}),de=new y({props:{name:"class huggingface_hub.InferenceEndpointStatus",anchor:"huggingface_hub.InferenceEndpointStatus",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L27"}}),fe=new Oe({props:{title:"InferenceEndpointType",local:"huggingface_hub.InferenceEndpointType",headingTag:"h2"}}),ue=new y({props:{name:"class huggingface_hub.InferenceEndpointType",anchor:"huggingface_hub.InferenceEndpointType",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L38"}}),le=new Oe({props:{title:"InferenceEndpointError",local:"huggingface_hub.InferenceEndpointError",headingTag:"h2"}}),he=new y({props:{name:"class huggingface_hub.InferenceEndpointError",anchor:"huggingface_hub.InferenceEndpointError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/_inference_endpoints.py#L19"}}),{c(){f=i("meta"),M=t(),$=i("p"),x=t(),u(w.$$.fragment),E=t(),L=i("p"),L.innerHTML=Yn,Ze=t(),u(V.$$.fragment),Ge=t(),G=i("p"),G.innerHTML=Xn,Be=t(),u(B.$$.fragment),Qe=t(),Q=i("p"),Q.innerHTML=Jn,Ye=t(),Y=i("ul"),Y.innerHTML=Kn,Xe=t(),u(X.$$.fragment),Je=t(),J=i("p"),J.innerHTML=et,Ke=t(),p=i("div"),u(K.$$.fragment),hn=t(),be=i("p"),be.textContent=nt,mn=t(),u(z.$$.fragment),_n=t(),N=i("div"),u(ee.$$.fragment),bn=t(),Ee=i("p"),Ee.textContent=tt,En=t(),S=i("div"),u(ne.$$.fragment),$n=t(),$e=i("p"),$e.textContent=at,In=t(),R=i("div"),u(te.$$.fragment),vn=t(),Ie=i("p"),Ie.textContent=rt,xn=t(),T=i("div"),u(ae.$$.fragment),yn=t(),ve=i("p"),ve.textContent=it,wn=t(),xe=i("p"),xe.innerHTML=ot,Tn=t(),ye=i("p"),ye.innerHTML=ct,kn=t(),U=i("div"),u(re.$$.fragment),Cn=t(),we=i("p"),we.textContent=st,Hn=t(),k=i("div"),u(ie.$$.fragment),Ln=t(),Te=i("p"),Te.textContent=pt,Mn=t(),ke=i("p"),ke.innerHTML=gt,Pn=t(),Ce=i("p"),Ce.innerHTML=dt,An=t(),P=i("div"),u(oe.$$.fragment),jn=t(),He=i("p"),He.textContent=ft,qn=t(),Le=i("p"),Le.innerHTML=ut,Dn=t(),C=i("div"),u(ce.$$.fragment),Vn=t(),Me=i("p"),Me.textContent=lt,zn=t(),Pe=i("p"),Pe.innerHTML=ht,Nn=t(),Ae=i("p"),Ae.innerHTML=mt,Sn=t(),H=i("div"),u(se.$$.fragment),Rn=t(),je=i("p"),je.textContent=_t,Un=t(),qe=i("p"),qe.textContent=bt,Wn=t(),De=i("p"),De.innerHTML=Et,On=t(),A=i("div"),u(pe.$$.fragment),Fn=t(),Ve=i("p"),Ve.textContent=$t,Zn=t(),ze=i("p"),ze.innerHTML=It,en=t(),u(ge.$$.fragment),nn=t(),j=i("div"),u(de.$$.fragment),Gn=t(),Ne=i("p"),Ne.textContent=vt,tn=t(),u(fe.$$.fragment),an=t(),q=i("div"),u(ue.$$.fragment),Bn=t(),Se=i("p"),Se.textContent=xt,rn=t(),u(le.$$.fragment),on=t(),D=i("div"),u(he.$$.fragment),Qn=t(),Re=i("p"),Re.textContent=yt,cn=t(),Fe=i("p"),this.h()},l(e){const c=Lt("svelte-u9bgzb",document.head);f=o(c,"META",{name:!0,content:!0}),c.forEach(r),M=a(e),$=o(e,"P",{}),I($).forEach(r),x=a(e),l(w.$$.fragment,e),E=a(e),L=o(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1bwc3b2"&&(L.innerHTML=Yn),Ze=a(e),l(V.$$.fragment,e),Ge=a(e),G=o(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1ook8pb"&&(G.innerHTML=Xn),Be=a(e),l(B.$$.fragment,e),Qe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-gr0aub"&&(Q.innerHTML=Jn),Ye=a(e),Y=o(e,"UL",{"data-svelte-h":!0}),g(Y)!=="svelte-1n53imw"&&(Y.innerHTML=Kn),Xe=a(e),l(X.$$.fragment,e),Je=a(e),J=o(e,"P",{"data-svelte-h":!0}),g(J)!=="svelte-1yhwkew"&&(J.innerHTML=et),Ke=a(e),p=o(e,"DIV",{class:!0});var d=I(p);l(K.$$.fragment,d),hn=a(d),be=o(d,"P",{"data-svelte-h":!0}),g(be)!=="svelte-1bmjqnv"&&(be.textContent=nt),mn=a(d),l(z.$$.fragment,d),_n=a(d),N=o(d,"DIV",{class:!0});var me=I(N);l(ee.$$.fragment,me),bn=a(me),Ee=o(me,"P",{"data-svelte-h":!0}),g(Ee)!=="svelte-gljdbx"&&(Ee.textContent=tt),me.forEach(r),En=a(d),S=o(d,"DIV",{class:!0});var pn=I(S);l(ne.$$.fragment,pn),$n=a(pn),$e=o(pn,"P",{"data-svelte-h":!0}),g($e)!=="svelte-jw5rtn"&&($e.textContent=at),pn.forEach(r),In=a(d),R=o(d,"DIV",{class:!0});var gn=I(R);l(te.$$.fragment,gn),vn=a(gn),Ie=o(gn,"P",{"data-svelte-h":!0}),g(Ie)!=="svelte-jw5rtn"&&(Ie.textContent=rt),gn.forEach(r),xn=a(d),T=o(d,"DIV",{class:!0});var W=I(T);l(ae.$$.fragment,W),yn=a(W),ve=o(W,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-1awp4uu"&&(ve.textContent=it),wn=a(W),xe=o(W,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-4lmb5p"&&(xe.innerHTML=ot),Tn=a(W),ye=o(W,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-1kr19ul"&&(ye.innerHTML=ct),W.forEach(r),kn=a(d),U=o(d,"DIV",{class:!0});var dn=I(U);l(re.$$.fragment,dn),Cn=a(dn),we=o(dn,"P",{"data-svelte-h":!0}),g(we)!=="svelte-1dh96nb"&&(we.textContent=st),dn.forEach(r),Hn=a(d),k=o(d,"DIV",{class:!0});var O=I(k);l(ie.$$.fragment,O),Ln=a(O),Te=o(O,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-1bfttgz"&&(Te.textContent=pt),Mn=a(O),ke=o(O,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-1c175wq"&&(ke.innerHTML=gt),Pn=a(O),Ce=o(O,"P",{"data-svelte-h":!0}),g(Ce)!=="svelte-18i7q4g"&&(Ce.innerHTML=dt),O.forEach(r),An=a(d),P=o(d,"DIV",{class:!0});var Ue=I(P);l(oe.$$.fragment,Ue),jn=a(Ue),He=o(Ue,"P",{"data-svelte-h":!0}),g(He)!=="svelte-akp3j2"&&(He.textContent=ft),qn=a(Ue),Le=o(Ue,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-1m76tq0"&&(Le.innerHTML=ut),Ue.forEach(r),Dn=a(d),C=o(d,"DIV",{class:!0});var F=I(C);l(ce.$$.fragment,F),Vn=a(F),Me=o(F,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-6vx93v"&&(Me.textContent=lt),zn=a(F),Pe=o(F,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-1rhv9ms"&&(Pe.innerHTML=ht),Nn=a(F),Ae=o(F,"P",{"data-svelte-h":!0}),g(Ae)!=="svelte-3v5am2"&&(Ae.innerHTML=mt),F.forEach(r),Sn=a(d),H=o(d,"DIV",{class:!0});var Z=I(H);l(se.$$.fragment,Z),Rn=a(Z),je=o(Z,"P",{"data-svelte-h":!0}),g(je)!=="svelte-16hllis"&&(je.textContent=_t),Un=a(Z),qe=o(Z,"P",{"data-svelte-h":!0}),g(qe)!=="svelte-llxqqu"&&(qe.textContent=bt),Wn=a(Z),De=o(Z,"P",{"data-svelte-h":!0}),g(De)!=="svelte-i2krcs"&&(De.innerHTML=Et),Z.forEach(r),On=a(d),A=o(d,"DIV",{class:!0});var We=I(A);l(pe.$$.fragment,We),Fn=a(We),Ve=o(We,"P",{"data-svelte-h":!0}),g(Ve)!=="svelte-15saqtl"&&(Ve.textContent=$t),Zn=a(We),ze=o(We,"P",{"data-svelte-h":!0}),g(ze)!=="svelte-zp8tqi"&&(ze.innerHTML=It),We.forEach(r),d.forEach(r),en=a(e),l(ge.$$.fragment,e),nn=a(e),j=o(e,"DIV",{class:!0});var fn=I(j);l(de.$$.fragment,fn),Gn=a(fn),Ne=o(fn,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-ofujqi"&&(Ne.textContent=vt),fn.forEach(r),tn=a(e),l(fe.$$.fragment,e),an=a(e),q=o(e,"DIV",{class:!0});var un=I(q);l(ue.$$.fragment,un),Bn=a(un),Se=o(un,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-ofujqi"&&(Se.textContent=xt),un.forEach(r),rn=a(e),l(le.$$.fragment,e),on=a(e),D=o(e,"DIV",{class:!0});var ln=I(D);l(he.$$.fragment,ln),Qn=a(ln),Re=o(ln,"P",{"data-svelte-h":!0}),g(Re)!=="svelte-dy4pdd"&&(Re.textContent=yt),ln.forEach(r),cn=a(e),Fe=o(e,"P",{}),I(Fe).forEach(r),this.h()},h(){v(f,"name","hf:doc:metadata"),v(f,"content",Vt),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,f),s(e,M,c),s(e,$,c),s(e,x,c),h(w,e,c),s(e,E,c),s(e,L,c),s(e,Ze,c),h(V,e,c),s(e,Ge,c),s(e,G,c),s(e,Be,c),h(B,e,c),s(e,Qe,c),s(e,Q,c),s(e,Ye,c),s(e,Y,c),s(e,Xe,c),h(X,e,c),s(e,Je,c),s(e,J,c),s(e,Ke,c),s(e,p,c),h(K,p,null),n(p,hn),n(p,be),n(p,mn),h(z,p,null),n(p,_n),n(p,N),h(ee,N,null),n(N,bn),n(N,Ee),n(p,En),n(p,S),h(ne,S,null),n(S,$n),n(S,$e),n(p,In),n(p,R),h(te,R,null),n(R,vn),n(R,Ie),n(p,xn),n(p,T),h(ae,T,null),n(T,yn),n(T,ve),n(T,wn),n(T,xe),n(T,Tn),n(T,ye),n(p,kn),n(p,U),h(re,U,null),n(U,Cn),n(U,we),n(p,Hn),n(p,k),h(ie,k,null),n(k,Ln),n(k,Te),n(k,Mn),n(k,ke),n(k,Pn),n(k,Ce),n(p,An),n(p,P),h(oe,P,null),n(P,jn),n(P,He),n(P,qn),n(P,Le),n(p,Dn),n(p,C),h(ce,C,null),n(C,Vn),n(C,Me),n(C,zn),n(C,Pe),n(C,Nn),n(C,Ae),n(p,Sn),n(p,H),h(se,H,null),n(H,Rn),n(H,je),n(H,Un),n(H,qe),n(H,Wn),n(H,De),n(p,On),n(p,A),h(pe,A,null),n(A,Fn),n(A,Ve),n(A,Zn),n(A,ze),s(e,en,c),h(ge,e,c),s(e,nn,c),s(e,j,c),h(de,j,null),n(j,Gn),n(j,Ne),s(e,tn,c),h(fe,e,c),s(e,an,c),s(e,q,c),h(ue,q,null),n(q,Bn),n(q,Se),s(e,rn,c),h(le,e,c),s(e,on,c),s(e,D,c),h(he,D,null),n(D,Qn),n(D,Re),s(e,cn,c),s(e,Fe,c),sn=!0},p(e,[c]){const d={};c&2&&(d.$$scope={dirty:c,ctx:e}),V.$set(d);const me={};c&2&&(me.$$scope={dirty:c,ctx:e}),z.$set(me)},i(e){sn||(m(w.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(K.$$.fragment,e),m(z.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(se.$$.fragment,e),m(pe.$$.fragment,e),m(ge.$$.fragment,e),m(de.$$.fragment,e),m(fe.$$.fragment,e),m(ue.$$.fragment,e),m(le.$$.fragment,e),m(he.$$.fragment,e),sn=!0)},o(e){_(w.$$.fragment,e),_(V.$$.fragment,e),_(B.$$.fragment,e),_(X.$$.fragment,e),_(K.$$.fragment,e),_(z.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(ce.$$.fragment,e),_(se.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(de.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(le.$$.fragment,e),_(he.$$.fragment,e),sn=!1},d(e){e&&(r(M),r($),r(x),r(E),r(L),r(Ze),r(Ge),r(G),r(Be),r(Qe),r(Q),r(Ye),r(Y),r(Xe),r(Je),r(J),r(Ke),r(p),r(en),r(nn),r(j),r(tn),r(an),r(q),r(rn),r(on),r(D),r(cn),r(Fe)),r(f),b(w,e),b(V,e),b(B,e),b(X,e),b(K),b(z),b(ee),b(ne),b(te),b(ae),b(re),b(ie),b(oe),b(ce),b(se),b(pe),b(ge,e),b(de),b(fe,e),b(ue),b(le,e),b(he)}}}const Vt='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Methods","local":"methods","sections":[],"depth":2},{"title":"InferenceEndpoint","local":"huggingface_hub.InferenceEndpoint","sections":[],"depth":2},{"title":"InferenceEndpointStatus","local":"huggingface_hub.InferenceEndpointStatus","sections":[],"depth":2},{"title":"InferenceEndpointType","local":"huggingface_hub.InferenceEndpointType","sections":[],"depth":2},{"title":"InferenceEndpointError","local":"huggingface_hub.InferenceEndpointError","sections":[],"depth":2}],"depth":1}';function zt(_e){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends Ct{constructor(f){super(),Ht(this,f,zt,Dt,Tt,{})}}export{Zt as component};
