import{s as Ce,n as _e,o as qe}from"../chunks/scheduler.b108d059.js";import{S as xe,i as Le,g as i,s as l,r as c,A as Qe,h as p,f as t,c as n,j as Q,u as o,x as r,k as Be,y as m,a,v as d,d as h,t as u,w as y}from"../chunks/index.008de539.js";import{C as N}from"../chunks/CodeBlock.7b00c886.js";import{H as Je,E as Ne}from"../chunks/index.9dd2deb3.js";function Ae(ke){let g,P,A,K,j,O,J,Re='Zusätzlich zur <code>HfApi</code> bietet die <code>huggingface_hub</code> Bibliothek <code>HfFileSystem</code>, eine pythonische, <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-kompatible</a> Dateischnittstelle zum Hugging Face Hub. Das <code>HfFileSystem</code> basiert auf der <code>HfApi</code> und bietet typische Dateisystemoperationen wie <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, und <code>put_file</code>.',ee,b,se,w,te,U,Ie="Das optionale Argument <code>revision</code> kann übergeben werden, um eine Operation von einem spezifischen Commit auszuführen, wie z.B. einem Branch, Tag-Namen oder einem Commit-Hash.",ae,T,ve="Anders als bei Pythons eingebautem <code>open</code>, ist der Standardmodus von <code>fsspec</code>’s <code>open</code> binär, <code>&quot;rb&quot;</code>. Das bedeutet, dass Sie den Modus explizit auf <code>&quot;r&quot;</code> zum Lesen und <code>&quot;w&quot;</code> zum Schreiben im Textmodus setzen müssen. Das Anhängen an eine Datei (Modi <code>&quot;a&quot;</code> und <code>&quot;ab&quot;</code>) wird noch nicht unterstützt.",le,Z,ne,G,ze="Das <code>HfFileSystem</code> kann mit jeder Bibliothek verwendet werden, die <code>fsspec</code> integriert, vorausgesetzt die URL folgt dem Schema:",ie,k,pe,R,Se="Der <code>repo_type_prefix</code> ist <code>datasets/</code> für Datensätze, <code>spaces/</code> für Spaces, und Modelle benötigen kein Präfix in der URL.",me,I,We="Einige interessante Integrationen, bei denen <code>HfFileSystem</code> die Interaktion mit dem Hub vereinfacht, sind unten aufgeführt:",re,M,f,B,$e='Lesen/Schreiben eines <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame aus/in ein Hub-Repository:',be,v,we,C,Xe='Der gleiche Arbeitsablauf kann auch für  <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> und <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> verwendet werden.',Ue,z,_,Ee='Abfrage von (entfernten) Hub-Dateien mit  <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',Te,S,Ze,W,q,Fe='Verwendung des Hub als Array-Speicher mit <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Ge,$,ce,X,oe,E,Ve='In vielen Fällen müssen Sie mit einem Hugging Face-Konto angemeldet sein, um mit dem Hub zu interagieren. Lesen Sie den <a href="../quick-start#login">Login</a>-Abschnitt der Dokumentation, um mehr über Authentifizierungsmethoden auf dem Hub zu erfahren.',de,F,He="Es ist auch möglich, sich programmatisch anzumelden, indem Sie Ihr <code>token</code> als Argument an <code>HfFileSystem</code> übergeben:",he,V,ue,H,Ye="Wenn Sie sich auf diese Weise anmelden, seien Sie vorsichtig, das Token nicht versehentlich zu veröffentlichen, wenn Sie Ihren Quellcode teilen!",ye,Y,Me,D,ge;return j=new Je({props:{title:"Interagieren mit dem Hub über die Filesystem API",local:"interagieren-mit-dem-hub-über-die-filesystem-api",headingTag:"h1"}}),b=new Je({props:{title:"Verwendung",local:"verwendung",headingTag:"h2"}}),w=new N({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBBbGxlJTIwRGF0ZWllbiUyMGluJTIwZWluZW0lMjBWZXJ6ZWljaG5pcyUyMGF1Zmxpc3RlbiUwQWZzLmxzKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTIyJTJDJTIwZGV0YWlsJTNERmFsc2UpJTBBJTBBJTIzJTIwQWxsZSUyMCUyMi5jc3YlMjItRGF0ZWllbiUyMGluJTIwZWluZW0lMjBSZXBvJTIwYXVmbGlzdGVuJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMEVpbmUlMjBlbnRmZXJudGUlMjBEYXRlaSUyMGxlc2VuJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGElMjAlM0QlMjBmLnJlYWRsaW5lcygpJTBBJTBBJTIzJTIwRGVuJTIwSW5oYWx0JTIwZWluZXIlMjBlbnRmZXJudGVuJTIwRGF0ZWklMjBhbHMlMjBaZWljaGVua2V0dGUlMjAlMkYlMjBTdHJpbmclMjBsZXNlbiUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBFaW5lJTIwZW50ZmVybnRlJTIwRGF0ZWklMjBzY2hyZWliZW4lMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnZhbGlkYXRpb24uY3N2JTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnRleHQlMkNsYWJlbCUyMiklMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMkZhbnRhc3RpYyUyMG1vdmllISUyQ2dvb2QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Alle Dateien in einem Verzeichnis auflisten</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Alle &quot;.csv&quot;-Dateien in einem Repo auflisten</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Den Inhalt einer entfernten Datei als Zeichenkette / String lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),Z=new Je({props:{title:"Integrationen",local:"integrationen",headingTag:"h2"}}),k=new N({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGZhZCUyRmltJTJGcmVwbyUzRQ==",highlighted:'hf://[<span class="hljs-attribute">&lt;repo_type_prefix&gt;</span>]<span class="hljs-attribute">&lt;repo_id&gt;</span>[@<span class="hljs-attribute">&lt;revision&gt;</span>]/<span class="hljs-attribute">&lt;pfad/im/repo&gt;</span>',wrap:!1}}),v=new N({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMEVpbmUlMjBlbnRmZXJudGUlMjBDU1YtRGF0ZWklMjBpbiUyMGVpbmVuJTIwRGF0YUZyYW1lJTIwbGVzZW4lMEFkZiUyMCUzRCUyMHBkLnJlYWRfY3N2KCUyMmhmJTNBJTJGJTJGZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRnRyYWluLmNzdiUyMiklMEElMEElMjMlMjBFaW5lbiUyMERhdGFGcmFtZSUyMGluJTIwZWluZSUyMGVudGZlcm50ZSUyMENTVi1EYXRlaSUyMHNjaHJlaWJlbiUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte CSV-Datei in einen DataFrame lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Einen DataFrame in eine entfernte CSV-Datei schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),S=new N({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBFaW5lJTIwZW50ZmVybnRlJTIwRGF0ZWklMjBhYmZyYWdlbiUyMHVuZCUyMGRhcyUyMEVyZ2VibmlzJTIwYWxzJTIwRGF0YUZyYW1lJTIwenVyJUMzJUJDY2tiZWtvbW1lbiUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Eine entfernte Datei abfragen und das Ergebnis als DataFrame zurückbekommen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),$=new N({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBFaW4lMjBBcnJheSUyMGluJTIwZWluJTIwUmVwbyUyMHNjaHJlaWJlbiUwQXdpdGglMjB6YXJyLm9wZW5fZ3JvdXAoJTIyaGYlM0ElMkYlMkZteS11c2VybmFtZSUyRm15LW1vZGVsLXJlcG8lMkZhcnJheS1zdG9yZSUyMiUyQyUyMG1vZGUlM0QlMjJ3JTIyKSUyMGFzJTIwcm9vdCUzQSUwQSUyMCUyMCUyMGZvbyUyMCUzRCUyMHJvb3QuY3JlYXRlX2dyb3VwKCUyMmVtYmVkZGluZ3MlMjIpJTBBJTIwJTIwJTIwZm9vYmFyJTIwJTNEJTIwZm9vLnplcm9zKCdleHBlcmltZW50XzAnJTJDJTIwc2hhcGUlM0QoNTAwMDAlMkMlMjAxMDAwKSUyQyUyMGNodW5rcyUzRCgxMDAwMCUyQyUyMDEwMDApJTJDJTIwZHR5cGUlM0QnZjQnKSUwQSUyMCUyMCUyMGZvb2JhciU1QiUzQSU1RCUyMCUzRCUyMGVtYmVkZGluZ3MlMEElMEElMjMlMjBFaW4lMjBBcnJheSUyMGF1cyUyMGVpbmVtJTIwUmVwbyUyMGxlc2VuJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Ein Array in ein Repo schreiben</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Ein Array aus einem Repo lesen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),X=new Je({props:{title:"Authentifizierung",local:"authentifizierung",headingTag:"h2"}}),V=new N({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),Y=new Ne({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/hf_file_system.md"}}),{c(){g=i("meta"),P=l(),A=i("p"),K=l(),c(j.$$.fragment),O=l(),J=i("p"),J.innerHTML=Re,ee=l(),c(b.$$.fragment),se=l(),c(w.$$.fragment),te=l(),U=i("p"),U.innerHTML=Ie,ae=l(),T=i("p"),T.innerHTML=ve,le=l(),c(Z.$$.fragment),ne=l(),G=i("p"),G.innerHTML=ze,ie=l(),c(k.$$.fragment),pe=l(),R=i("p"),R.innerHTML=Se,me=l(),I=i("p"),I.innerHTML=We,re=l(),M=i("ul"),f=i("li"),B=i("p"),B.innerHTML=$e,be=l(),c(v.$$.fragment),we=l(),C=i("p"),C.innerHTML=Xe,Ue=l(),z=i("li"),_=i("p"),_.innerHTML=Ee,Te=l(),c(S.$$.fragment),Ze=l(),W=i("li"),q=i("p"),q.innerHTML=Fe,Ge=l(),c($.$$.fragment),ce=l(),c(X.$$.fragment),oe=l(),E=i("p"),E.innerHTML=Ve,de=l(),F=i("p"),F.innerHTML=He,he=l(),c(V.$$.fragment),ue=l(),H=i("p"),H.textContent=Ye,ye=l(),c(Y.$$.fragment),Me=l(),D=i("p"),this.h()},l(e){const s=Qe("svelte-u9bgzb",document.head);g=p(s,"META",{name:!0,content:!0}),s.forEach(t),P=n(e),A=p(e,"P",{}),Q(A).forEach(t),K=n(e),o(j.$$.fragment,e),O=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18w92na"&&(J.innerHTML=Re),ee=n(e),o(b.$$.fragment,e),se=n(e),o(w.$$.fragment,e),te=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-3z26mg"&&(U.innerHTML=Ie),ae=n(e),T=p(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-tbpook"&&(T.innerHTML=ve),le=n(e),o(Z.$$.fragment,e),ne=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-eeqd0a"&&(G.innerHTML=ze),ie=n(e),o(k.$$.fragment,e),pe=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-967d81"&&(R.innerHTML=Se),me=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-wufznp"&&(I.innerHTML=We),re=n(e),M=p(e,"UL",{});var x=Q(M);f=p(x,"LI",{});var L=Q(f);B=p(L,"P",{"data-svelte-h":!0}),r(B)!=="svelte-5rmyjs"&&(B.innerHTML=$e),be=n(L),o(v.$$.fragment,L),we=n(L),C=p(L,"P",{"data-svelte-h":!0}),r(C)!=="svelte-11g4kom"&&(C.innerHTML=Xe),L.forEach(t),Ue=n(x),z=p(x,"LI",{});var fe=Q(z);_=p(fe,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1j784ud"&&(_.innerHTML=Ee),Te=n(fe),o(S.$$.fragment,fe),fe.forEach(t),Ze=n(x),W=p(x,"LI",{});var je=Q(W);q=p(je,"P",{"data-svelte-h":!0}),r(q)!=="svelte-guwc20"&&(q.innerHTML=Fe),Ge=n(je),o($.$$.fragment,je),je.forEach(t),x.forEach(t),ce=n(e),o(X.$$.fragment,e),oe=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-aphqiq"&&(E.innerHTML=Ve),de=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1enyw3z"&&(F.innerHTML=He),he=n(e),o(V.$$.fragment,e),ue=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16usaea"&&(H.textContent=Ye),ye=n(e),o(Y.$$.fragment,e),Me=n(e),D=p(e,"P",{}),Q(D).forEach(t),this.h()},h(){Be(g,"name","hf:doc:metadata"),Be(g,"content",De)},m(e,s){m(document.head,g),a(e,P,s),a(e,A,s),a(e,K,s),d(j,e,s),a(e,O,s),a(e,J,s),a(e,ee,s),d(b,e,s),a(e,se,s),d(w,e,s),a(e,te,s),a(e,U,s),a(e,ae,s),a(e,T,s),a(e,le,s),d(Z,e,s),a(e,ne,s),a(e,G,s),a(e,ie,s),d(k,e,s),a(e,pe,s),a(e,R,s),a(e,me,s),a(e,I,s),a(e,re,s),a(e,M,s),m(M,f),m(f,B),m(f,be),d(v,f,null),m(f,we),m(f,C),m(M,Ue),m(M,z),m(z,_),m(z,Te),d(S,z,null),m(M,Ze),m(M,W),m(W,q),m(W,Ge),d($,W,null),a(e,ce,s),d(X,e,s),a(e,oe,s),a(e,E,s),a(e,de,s),a(e,F,s),a(e,he,s),d(V,e,s),a(e,ue,s),a(e,H,s),a(e,ye,s),d(Y,e,s),a(e,Me,s),a(e,D,s),ge=!0},p:_e,i(e){ge||(h(j.$$.fragment,e),h(b.$$.fragment,e),h(w.$$.fragment,e),h(Z.$$.fragment,e),h(k.$$.fragment,e),h(v.$$.fragment,e),h(S.$$.fragment,e),h($.$$.fragment,e),h(X.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),ge=!0)},o(e){u(j.$$.fragment,e),u(b.$$.fragment,e),u(w.$$.fragment,e),u(Z.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(S.$$.fragment,e),u($.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),ge=!1},d(e){e&&(t(P),t(A),t(K),t(O),t(J),t(ee),t(se),t(te),t(U),t(ae),t(T),t(le),t(ne),t(G),t(ie),t(pe),t(R),t(me),t(I),t(re),t(M),t(ce),t(oe),t(E),t(de),t(F),t(he),t(ue),t(H),t(ye),t(Me),t(D)),t(g),y(j,e),y(b,e),y(w,e),y(Z,e),y(k,e),y(v),y(S),y($),y(X,e),y(V,e),y(Y,e)}}}const De='{"title":"Interagieren mit dem Hub über die Filesystem API","local":"interagieren-mit-dem-hub-über-die-filesystem-api","sections":[{"title":"Verwendung","local":"verwendung","sections":[],"depth":2},{"title":"Integrationen","local":"integrationen","sections":[],"depth":2},{"title":"Authentifizierung","local":"authentifizierung","sections":[],"depth":2}],"depth":1}';function Pe(ke){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends xe{constructor(g){super(),Le(this,g,Pe,Ae,Ce,{})}}export{ts as component};
