import{s as Fo,o as Eo,n as Ct}from"../chunks/scheduler.01eeda35.js";import{S as Po,i as No,g as l,s as n,r as f,A as Wo,h as i,f as o,c as s,j,u,x as c,k as z,y as a,a as r,v as h,d as g,t as _,w as k}from"../chunks/index.6dd51b66.js";import{T as Io}from"../chunks/Tip.de9bae2b.js";import{D as I}from"../chunks/Docstring.cb556860.js";import{C as Xe}from"../chunks/CodeBlock.19ec9b8c.js";import{E as Ao}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as Be,E as Zo}from"../chunks/index.58fe8f9d.js";function Ho(A){let d,L="The <code>Llama2</code> family models, on which Code Llama is based, were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code>. Let’s look at the different precisions:",m,b,M="<li><code>float32</code>: PyTorch convention on model initialization is to load models in <code>float32</code>, no matter with which <code>dtype</code> the model weights were stored. <code>transformers</code> also follows this convention for consistency with PyTorch. This will be picked by default. If you want the <code>AutoModel</code> API to load the checkpoints with the storage weights type, you must specify <code>torch_dtype=&quot;auto&quot;</code>, e.g. <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>.</li> <li><code>bfloat16</code>: Code Llama was trained with this precision, so we recommend using it for further training or fine-tuning.</li> <li><code>float16</code>: We recommend running inference using this precision, as it’s usually faster than <code>bfloat16</code>, and evaluation metrics show no discernible degradation with respect to <code>bfloat16</code>. You can also run inference using <code>bfloat16</code>, and we recommend you check inference results with both <code>float16</code> and <code>bfloat16</code> after fine-tuning.</li>",v,T,De="As mentioned above, the <code>dtype</code> of the storage weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using. The reason is that the model will first be downloaded (using the <code>dtype</code> of the checkpoints online) and then will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). If there is a specified <code>torch_dtype</code>, it will be used instead.";return{c(){d=l("p"),d.innerHTML=L,m=n(),b=l("ul"),b.innerHTML=M,v=n(),T=l("p"),T.innerHTML=De},l(C){d=i(C,"P",{"data-svelte-h":!0}),c(d)!=="svelte-8yf686"&&(d.innerHTML=L),m=s(C),b=i(C,"UL",{"data-svelte-h":!0}),c(b)!=="svelte-1f9e2ui"&&(b.innerHTML=M),v=s(C),T=i(C,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1bzil5i"&&(T.innerHTML=De)},m(C,q){r(C,d,q),r(C,m,q),r(C,b,q),r(C,v,q),r(C,T,q)},p:Ct,d(C){C&&(o(d),o(m),o(b),o(v),o(T))}}}function Go(A){let d,L=`Code Llama has the same architecture as the <code>Llama2</code> models, refer to <a href="llama2">Llama2’s documentation page</a> for the API reference.
Find Code Llama tokenizer reference below.`;return{c(){d=l("p"),d.innerHTML=L},l(m){d=i(m,"P",{"data-svelte-h":!0}),c(d)!=="svelte-1buct0x"&&(d.innerHTML=L)},m(m,b){r(m,d,b)},p:Ct,d(m){m&&o(d)}}}function Ro(A){let d,L="sequence pair mask has the following format:",m,b,M;return b=new Xe({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=l("p"),d.textContent=L,m=n(),f(b.$$.fragment)},l(v){d=i(v,"P",{"data-svelte-h":!0}),c(d)!=="svelte-16klr56"&&(d.textContent=L),m=s(v),u(b.$$.fragment,v)},m(v,T){r(v,d,T),r(v,m,T),h(b,v,T),M=!0},p:Ct,i(v){M||(g(b.$$.fragment,v),M=!0)},o(v){_(b.$$.fragment,v),M=!1},d(v){v&&(o(d),o(m)),k(b,v)}}}function Do(A){let d,L;return d=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVMbGFtYVRva2VuaXplckZhc3QlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGxhbWEtdG9rZW5pemVyJTIyKSUwQXRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGlzJTIwaXMlMjBhJTIwdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeLlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){f(d.$$.fragment)},l(m){u(d.$$.fragment,m)},m(m,b){h(d,m,b),L=!0},p:Ct,i(m){L||(g(d.$$.fragment,m),L=!0)},o(m){_(d.$$.fragment,m),L=!1},d(m){k(d,m)}}}function So(A){let d,L,m,b,M,v,T,De=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,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
"/>`,C,q,Qe,S,to='The Code Llama model was proposed in <a href="https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/" rel="nofollow">Code Llama: Open Foundation Models for Code</a> by Baptiste Rozière, Jonas Gehring, Fabian Gloeckle, Sten Sootla, Itai Gat, Xiaoqing Ellen Tan, Yossi Adi, Jingyu Liu, Tal Remez, Jérémy Rapin, Artyom Kozhevnikov, Ivan Evtimov, Joanna Bitton, Manish Bhatt, Cristian Canton Ferrer, Aaron Grattafiori, Wenhan Xiong, Alexandre Défossez, Jade Copet, Faisal Azhar, Hugo Touvron, Louis Martin, Nicolas Usunier, Thomas Scialom, Gabriel Synnaeve.',Oe,V,oo="The abstract from the paper is the following:",Ye,B,no="<em>We release Code Llama, a family of large language models for code based on Llama 2 providing state-of-the-art performance among open models, infilling capabilities, support for large input contexts, and zero-shot instruction following ability for programming tasks. We provide multiple flavors to cover a wide range of applications: foundation models (Code Llama), Python specializations (Code Llama - Python), and instruction-following models (Code Llama - Instruct) with 7B, 13B and 34B parameters each. All models are trained on sequences of 16k tokens and show improvements on inputs with up to 100k tokens. 7B and 13B Code Llama and Code Llama - Instruct variants support infilling based on surrounding content. Code Llama reaches state-of-the-art performance among open models on several code benchmarks, with scores of up to 53% and 55% on HumanEval and MBPP, respectively. Notably, Code Llama - Python 7B outperforms Llama 2 70B on HumanEval and MBPP, and all our models outperform every other publicly available model on MultiPL-E. We release Code Llama under a permissive license that allows for both research and commercial use.</em>",Ke,X,so='Check out all Code Llama model checkpoints <a href="https://huggingface.co/models?search=code_llama" rel="nofollow">here</a> and the officially released ones in the <a href="https://huggingface.co/meta-llama" rel="nofollow">Meta Llama org</a>.',et,Q,ao='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZucker</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.',tt,O,ot,P,nt,Y,ro="Tips:",st,K,lo="<li>The infilling task is supported out of the box. You should be using the <code>tokenizer.fill_token</code> where you want your input to be filled.</li> <li>The model conversion script is the same as for the <code>Llama2</code> family:</li>",at,ee,io="Here is a sample usage:",rt,te,lt,oe,co=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM).`,it,ne,mo="After conversion, the model and tokenizer can be loaded via:",dt,se,ct,ae,po="If you only want the infilled part:",mt,re,pt,le,fo='Under the hood, the tokenizer <a href="https://huggingface.co/docs/transformers/main/model_doc/code_llama#transformers.CodeLlamaTokenizer.fill_token" rel="nofollow">automatically splits by <code>&lt;FILL_ME&gt;</code></a> to create a formatted input string that follows <a href="https://github.com/facebookresearch/codellama/blob/cb51c14ec761370ba2e2bc351374a79265d0465e/llama/generation.py#L402" rel="nofollow">the original training pattern</a>. This is more robust than preparing the pattern yourself: it avoids pitfalls, such as token glueing, that are very hard to debug.  To see how much CPU and GPU memory you need for this model or others, try <a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">this calculator</a> which can help determine that value.',ft,ie,uo='The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.',ut,N,ht,de,gt,x,ce,wt,Le,ho=`Construct a CodeLlama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as
there is no padding token in the original model.`,Mt,Ce,go=`The default configuration match that of
<a href="https://huggingface.co/meta-llama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,$t,we,me,zt,W,pe,qt,Me,_o=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,jt,J,fe,Jt,$e,ko="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",Ut,Z,It,ze,bo="if token_ids_1 is None, only returns the first portion of the mask (0s).",At,H,ue,Ft,qe,vo="Save the vocabulary and special tokens file to a directory.",_t,he,kt,p,ge,Et,je,yo="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Pt,Je,To="This uses notably ByteFallback and no normalization.",Nt,G,Wt,Ue,xo=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Zt,Ie,Lo=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods. The default configuration match that of
<a href="https://huggingface.co/meta-llama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">meta-llama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,Ht,$,_e,Gt,Ae,Co=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,Rt,Fe,wo="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",Dt,Ee,Mo="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",St,Pe,$o=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Vt,R,ke,Bt,Ne,zo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Xt,F,be,Qt,We,qo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Ot,Ze,jo="Should be overridden in a subclass if the model has a special way of building those.",Yt,D,ve,Kt,He,Jo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",eo,Ge,ye,bt,Te,vt,Se,yt;return M=new Be({props:{title:"CodeLlama",local:"codellama",headingTag:"h1"}}),q=new Be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),O=new Be({props:{title:"Usage tips and examples",local:"usage-tips-and-examples",headingTag:"h2"}}),P=new Io({props:{warning:!0,$$slots:{default:[Ho]},$$scope:{ctx:A}}}),te=new Xe({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),se=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBDb2RlTGxhbWFUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZDb2RlTGxhbWEtN2ItaGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGQ29kZUxsYW1hLTdiLWhmJTIyKSUwQVBST01QVCUyMCUzRCUyMCcnJ2RlZiUyMHJlbW92ZV9ub25fYXNjaWkocyUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTIwJTNDRklMTF9NRSUzRSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdCUwQScnJyUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihQUk9NUFQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklMEElMEFmaWxsaW5nJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTVCJTNBJTJDJTIwaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlMjAlM0QlMjBUcnVlKSU1QjAlNUQlMEFwcmludChQUk9NUFQucmVwbGFjZSglMjIlM0NGSUxMX01FJTNFJTIyJTJDJTIwZmlsbGluZykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, CodeLlamaTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>PROMPT = <span class="hljs-string">&#x27;&#x27;&#x27;def remove_non_ascii(s: str) -&gt; str:
<span class="hljs-meta">... </span>    &quot;&quot;&quot; &lt;FILL_ME&gt;
<span class="hljs-meta">... </span>    return result
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_ids, max_new_tokens=<span class="hljs-number">128</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filling = tokenizer.batch_decode(generated_ids[:, input_ids.shape[<span class="hljs-number">1</span>]:], skip_special_tokens = <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(PROMPT.replace(<span class="hljs-string">&quot;&lt;FILL_ME&gt;&quot;</span>, filling))
<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_non_ascii</span>(<span class="hljs-params">s: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot; Remove non-ASCII characters from a string.
&lt;BLANKLINE&gt;
    Args:
        s: The string to remove non-ASCII characters from.
&lt;BLANKLINE&gt;
    Returns:
        The string with non-ASCII characters removed.
    &quot;&quot;&quot;</span>
    result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> s:
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">ord</span>(c) &lt; <span class="hljs-number">128</span>:
            result += c
    <span class="hljs-keyword">return</span> result
&lt;BLANKLINE&gt;`,wrap:!1}}),re=new Xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkNtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZDb2RlTGxhbWEtN2ItaGYlMjIlMkN0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEFnZW5lcmF0b3IoJ2RlZiUyMHJlbW92ZV9ub25fYXNjaWkocyUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTVDbiUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyMCUzQ0ZJTExfTUUlM0UlNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0JyUyQyUyMG1heF9uZXdfdG9rZW5zJTIwJTNEJTIwMTI4KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>,model=<span class="hljs-string">&quot;meta-llama/CodeLlama-7b-hf&quot;</span>,torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return result&#x27;</span>, max_new_tokens = <span class="hljs-number">128</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return resultRemove non-ASCII characters from a string. &quot;&quot;&quot;\\n    result = &quot;&quot;\\n    for c in s:\\n        if ord(c) &lt; 128:\\n            result += c&#x27;</span>}]`,wrap:!1}}),N=new Io({props:{$$slots:{default:[Go]},$$scope:{ctx:A}}}),de=new Be({props:{title:"CodeLlamaTokenizer",local:"transformers.CodeLlamaTokenizer",headingTag:"h2"}}),ce=new I({props:{name:"class transformers.CodeLlamaTokenizer",anchor:"transformers.CodeLlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"suffix_first",val:" = False"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"additional_special_tokens",val:" = None"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizer.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizer.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizer.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizer.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_first",description:`<strong>suffix_first</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the input prompt and suffix should be formatted with the suffix first.`,name:"suffix_first"},{anchor:"transformers.CodeLlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.CodeLlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the tokenization spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama.py#L49"}}),me=new I({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama.py#L357"}}),pe=new I({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama.py#L369",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),fe=new I({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama.py#L407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Z=new Ao({props:{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Ro]},$$scope:{ctx:A}}}),ue=new I({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama.py#L329",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),he=new Be({props:{title:"CodeLlamaTokenizerFast",local:"transformers.CodeLlamaTokenizerFast",headingTag:"h2"}}),ge=new I({props:{name:"class transformers.CodeLlamaTokenizerFast",anchor:"transformers.CodeLlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"additional_special_tokens",val:" = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CodeLlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to cleanup spaces after decoding, cleanup consists in removing potential artifacts like extra
spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizerFast.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizerFast.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a beginning of sequence token at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an end of sequence token at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L52"}}),G=new Ao({props:{anchor:"transformers.CodeLlamaTokenizerFast.example",$$slots:{default:[Do]},$$scope:{ctx:A}}}),_e=new I({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new I({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),be=new I({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3409",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new I({props:{name:"update_post_processor",anchor:"transformers.CodeLlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L179"}}),ye=new I({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L333"}}),Te=new Zo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/code_llama.md"}}),{c(){d=l("meta"),L=n(),m=l("p"),b=n(),f(M.$$.fragment),v=n(),T=l("div"),T.innerHTML=De,C=n(),f(q.$$.fragment),Qe=n(),S=l("p"),S.innerHTML=to,Oe=n(),V=l("p"),V.textContent=oo,Ye=n(),B=l("p"),B.innerHTML=no,Ke=n(),X=l("p"),X.innerHTML=so,et=n(),Q=l("p"),Q.innerHTML=ao,tt=n(),f(O.$$.fragment),ot=n(),f(P.$$.fragment),nt=n(),Y=l("p"),Y.textContent=ro,st=n(),K=l("ul"),K.innerHTML=lo,at=n(),ee=l("p"),ee.textContent=io,rt=n(),f(te.$$.fragment),lt=n(),oe=l("p"),oe.textContent=co,it=n(),ne=l("p"),ne.textContent=mo,dt=n(),f(se.$$.fragment),ct=n(),ae=l("p"),ae.textContent=po,mt=n(),f(re.$$.fragment),pt=n(),le=l("p"),le.innerHTML=fo,ft=n(),ie=l("p"),ie.innerHTML=uo,ut=n(),f(N.$$.fragment),ht=n(),f(de.$$.fragment),gt=n(),x=l("div"),f(ce.$$.fragment),wt=n(),Le=l("p"),Le.textContent=ho,Mt=n(),Ce=l("p"),Ce.innerHTML=go,$t=n(),we=l("div"),f(me.$$.fragment),zt=n(),W=l("div"),f(pe.$$.fragment),qt=n(),Me=l("p"),Me.innerHTML=_o,jt=n(),J=l("div"),f(fe.$$.fragment),Jt=n(),$e=l("p"),$e.textContent=ko,Ut=n(),f(Z.$$.fragment),It=n(),ze=l("p"),ze.textContent=bo,At=n(),H=l("div"),f(ue.$$.fragment),Ft=n(),qe=l("p"),qe.textContent=vo,_t=n(),f(he.$$.fragment),kt=n(),p=l("div"),f(ge.$$.fragment),Et=n(),je=l("p"),je.textContent=yo,Pt=n(),Je=l("p"),Je.textContent=To,Nt=n(),f(G.$$.fragment),Wt=n(),Ue=l("p"),Ue.innerHTML=xo,Zt=n(),Ie=l("p"),Ie.innerHTML=Lo,Ht=n(),$=l("div"),f(_e.$$.fragment),Gt=n(),Ae=l("p"),Ae.textContent=Co,Rt=n(),Fe=l("p"),Fe.innerHTML=wo,Dt=n(),Ee=l("ul"),Ee.innerHTML=Mo,St=n(),Pe=l("p"),Pe.textContent=$o,Vt=n(),R=l("div"),f(ke.$$.fragment),Bt=n(),Ne=l("p"),Ne.innerHTML=zo,Xt=n(),F=l("div"),f(be.$$.fragment),Qt=n(),We=l("p"),We.innerHTML=qo,Ot=n(),Ze=l("p"),Ze.textContent=jo,Yt=n(),D=l("div"),f(ve.$$.fragment),Kt=n(),He=l("p"),He.innerHTML=Jo,eo=n(),Ge=l("div"),f(ye.$$.fragment),bt=n(),f(Te.$$.fragment),vt=n(),Se=l("p"),this.h()},l(e){const t=Wo("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(o),L=s(e),m=i(e,"P",{}),j(m).forEach(o),b=s(e),u(M.$$.fragment,e),v=s(e),T=i(e,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-1l5icot"&&(T.innerHTML=De),C=s(e),u(q.$$.fragment,e),Qe=s(e),S=i(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1s05gbs"&&(S.innerHTML=to),Oe=s(e),V=i(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-vfdo9a"&&(V.textContent=oo),Ye=s(e),B=i(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-mbr49z"&&(B.innerHTML=no),Ke=s(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-6hejhf"&&(X.innerHTML=so),et=s(e),Q=i(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-z5ta87"&&(Q.innerHTML=ao),tt=s(e),u(O.$$.fragment,e),ot=s(e),u(P.$$.fragment,e),nt=s(e),Y=i(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-axv494"&&(Y.textContent=ro),st=s(e),K=i(e,"UL",{"data-svelte-h":!0}),c(K)!=="svelte-qxctvz"&&(K.innerHTML=lo),at=s(e),ee=i(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1fo4g0o"&&(ee.textContent=io),rt=s(e),u(te.$$.fragment,e),lt=s(e),oe=i(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1ovdf29"&&(oe.textContent=co),it=s(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-b5pwv6"&&(ne.textContent=mo),dt=s(e),u(se.$$.fragment,e),ct=s(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-cm0lfz"&&(ae.textContent=po),mt=s(e),u(re.$$.fragment,e),pt=s(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-xefpq6"&&(le.innerHTML=fo),ft=s(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-qunt86"&&(ie.innerHTML=uo),ut=s(e),u(N.$$.fragment,e),ht=s(e),u(de.$$.fragment,e),gt=s(e),x=i(e,"DIV",{class:!0});var w=j(x);u(ce.$$.fragment,w),wt=s(w),Le=i(w,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1vmwvh5"&&(Le.textContent=ho),Mt=s(w),Ce=i(w,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1a4a72p"&&(Ce.innerHTML=go),$t=s(w),we=i(w,"DIV",{class:!0});var Ve=j(we);u(me.$$.fragment,Ve),Ve.forEach(o),zt=s(w),W=i(w,"DIV",{class:!0});var xe=j(W);u(pe.$$.fragment,xe),qt=s(xe),Me=i(xe,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1f4f5kp"&&(Me.innerHTML=_o),xe.forEach(o),jt=s(w),J=i(w,"DIV",{class:!0});var U=j(J);u(fe.$$.fragment,U),Jt=s(U),$e=i(U,"P",{"data-svelte-h":!0}),c($e)!=="svelte-13bfd60"&&($e.textContent=ko),Ut=s(U),u(Z.$$.fragment,U),It=s(U),ze=i(U,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-wtrslu"&&(ze.textContent=bo),U.forEach(o),At=s(w),H=i(w,"DIV",{class:!0});var Tt=j(H);u(ue.$$.fragment,Tt),Ft=s(Tt),qe=i(Tt,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-1slb66l"&&(qe.textContent=vo),Tt.forEach(o),w.forEach(o),_t=s(e),u(he.$$.fragment,e),kt=s(e),p=i(e,"DIV",{class:!0});var y=j(p);u(ge.$$.fragment,y),Et=s(y),je=i(y,"P",{"data-svelte-h":!0}),c(je)!=="svelte-15tdcz8"&&(je.textContent=yo),Pt=s(y),Je=i(y,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-llhmpa"&&(Je.textContent=To),Nt=s(y),u(G.$$.fragment,y),Wt=s(y),Ue=i(y,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-cnb6q1"&&(Ue.innerHTML=xo),Zt=s(y),Ie=i(y,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-a387ws"&&(Ie.innerHTML=Lo),Ht=s(y),$=i(y,"DIV",{class:!0});var E=j($);u(_e.$$.fragment,E),Gt=s(E),Ae=i(E,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-1vll0v2"&&(Ae.textContent=Co),Rt=s(E),Fe=i(E,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-90np8u"&&(Fe.innerHTML=wo),Dt=s(E),Ee=i(E,"UL",{"data-svelte-h":!0}),c(Ee)!=="svelte-mlrsks"&&(Ee.innerHTML=Mo),St=s(E),Pe=i(E,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-46aam0"&&(Pe.textContent=$o),E.forEach(o),Vt=s(y),R=i(y,"DIV",{class:!0});var xt=j(R);u(ke.$$.fragment,xt),Bt=s(xt),Ne=i(xt,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-1wmjg8a"&&(Ne.innerHTML=zo),xt.forEach(o),Xt=s(y),F=i(y,"DIV",{class:!0});var Re=j(F);u(be.$$.fragment,Re),Qt=s(Re),We=i(Re,"P",{"data-svelte-h":!0}),c(We)!=="svelte-zj1vf1"&&(We.innerHTML=qo),Ot=s(Re),Ze=i(Re,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-9vptpw"&&(Ze.textContent=jo),Re.forEach(o),Yt=s(y),D=i(y,"DIV",{class:!0});var Lt=j(D);u(ve.$$.fragment,Lt),Kt=s(Lt),He=i(Lt,"P",{"data-svelte-h":!0}),c(He)!=="svelte-nfci2w"&&(He.innerHTML=Jo),Lt.forEach(o),eo=s(y),Ge=i(y,"DIV",{class:!0});var Uo=j(Ge);u(ye.$$.fragment,Uo),Uo.forEach(o),y.forEach(o),bt=s(e),u(Te.$$.fragment,e),vt=s(e),Se=i(e,"P",{}),j(Se).forEach(o),this.h()},h(){z(d,"name","hf:doc:metadata"),z(d,"content",Vo),z(T,"class","flex flex-wrap space-x-1"),z(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,d),r(e,L,t),r(e,m,t),r(e,b,t),h(M,e,t),r(e,v,t),r(e,T,t),r(e,C,t),h(q,e,t),r(e,Qe,t),r(e,S,t),r(e,Oe,t),r(e,V,t),r(e,Ye,t),r(e,B,t),r(e,Ke,t),r(e,X,t),r(e,et,t),r(e,Q,t),r(e,tt,t),h(O,e,t),r(e,ot,t),h(P,e,t),r(e,nt,t),r(e,Y,t),r(e,st,t),r(e,K,t),r(e,at,t),r(e,ee,t),r(e,rt,t),h(te,e,t),r(e,lt,t),r(e,oe,t),r(e,it,t),r(e,ne,t),r(e,dt,t),h(se,e,t),r(e,ct,t),r(e,ae,t),r(e,mt,t),h(re,e,t),r(e,pt,t),r(e,le,t),r(e,ft,t),r(e,ie,t),r(e,ut,t),h(N,e,t),r(e,ht,t),h(de,e,t),r(e,gt,t),r(e,x,t),h(ce,x,null),a(x,wt),a(x,Le),a(x,Mt),a(x,Ce),a(x,$t),a(x,we),h(me,we,null),a(x,zt),a(x,W),h(pe,W,null),a(W,qt),a(W,Me),a(x,jt),a(x,J),h(fe,J,null),a(J,Jt),a(J,$e),a(J,Ut),h(Z,J,null),a(J,It),a(J,ze),a(x,At),a(x,H),h(ue,H,null),a(H,Ft),a(H,qe),r(e,_t,t),h(he,e,t),r(e,kt,t),r(e,p,t),h(ge,p,null),a(p,Et),a(p,je),a(p,Pt),a(p,Je),a(p,Nt),h(G,p,null),a(p,Wt),a(p,Ue),a(p,Zt),a(p,Ie),a(p,Ht),a(p,$),h(_e,$,null),a($,Gt),a($,Ae),a($,Rt),a($,Fe),a($,Dt),a($,Ee),a($,St),a($,Pe),a(p,Vt),a(p,R),h(ke,R,null),a(R,Bt),a(R,Ne),a(p,Xt),a(p,F),h(be,F,null),a(F,Qt),a(F,We),a(F,Ot),a(F,Ze),a(p,Yt),a(p,D),h(ve,D,null),a(D,Kt),a(D,He),a(p,eo),a(p,Ge),h(ye,Ge,null),r(e,bt,t),h(Te,e,t),r(e,vt,t),r(e,Se,t),yt=!0},p(e,[t]){const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),P.$set(w);const Ve={};t&2&&(Ve.$$scope={dirty:t,ctx:e}),N.$set(Ve);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),Z.$set(xe);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),G.$set(U)},i(e){yt||(g(M.$$.fragment,e),g(q.$$.fragment,e),g(O.$$.fragment,e),g(P.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(N.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(fe.$$.fragment,e),g(Z.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(G.$$.fragment,e),g(_e.$$.fragment,e),g(ke.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),yt=!0)},o(e){_(M.$$.fragment,e),_(q.$$.fragment,e),_(O.$$.fragment,e),_(P.$$.fragment,e),_(te.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(N.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(fe.$$.fragment,e),_(Z.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(G.$$.fragment,e),_(_e.$$.fragment,e),_(ke.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),yt=!1},d(e){e&&(o(L),o(m),o(b),o(v),o(T),o(C),o(Qe),o(S),o(Oe),o(V),o(Ye),o(B),o(Ke),o(X),o(et),o(Q),o(tt),o(ot),o(nt),o(Y),o(st),o(K),o(at),o(ee),o(rt),o(lt),o(oe),o(it),o(ne),o(dt),o(ct),o(ae),o(mt),o(pt),o(le),o(ft),o(ie),o(ut),o(ht),o(gt),o(x),o(_t),o(kt),o(p),o(bt),o(vt),o(Se)),o(d),k(M,e),k(q,e),k(O,e),k(P,e),k(te,e),k(se,e),k(re,e),k(N,e),k(de,e),k(ce),k(me),k(pe),k(fe),k(Z),k(ue),k(he,e),k(ge),k(G),k(_e),k(ke),k(be),k(ve),k(ye),k(Te,e)}}}const Vo='{"title":"CodeLlama","local":"codellama","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips and examples","local":"usage-tips-and-examples","sections":[],"depth":2},{"title":"CodeLlamaTokenizer","local":"transformers.CodeLlamaTokenizer","sections":[],"depth":2},{"title":"CodeLlamaTokenizerFast","local":"transformers.CodeLlamaTokenizerFast","sections":[],"depth":2}],"depth":1}';function Bo(A){return Eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends Po{constructor(d){super(),No(this,d,Bo,So,Fo,{})}}export{on as component};
