import{s as Jt,A as $t,o as Ct,n as ye}from"../chunks/scheduler.01eeda35.js";import{S as kt,i as Ut,g as d,s as r,r as u,A as Ft,h as m,f as o,c as l,j as re,u as g,x as p,k as Z,y as f,a as s,v as b,d as _,t as T,w as y}from"../chunks/index.6dd51b66.js";import{T as jt}from"../chunks/Tip.de9bae2b.js";import{D as Te}from"../chunks/Docstring.cb556860.js";import{C as st}from"../chunks/CodeBlock.19ec9b8c.js";import{E as at}from"../chunks/ExampleCodeBlock.69db56ad.js";import{P as It}from"../chunks/PipelineTag.5efc345e.js";import{H as be,E as Wt}from"../chunks/index.58fe8f9d.js";function Zt(C){let n,v="Examples:",i,c,h;return c=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRhYmxlVHJhbnNmb3JtZXJNb2RlbCUyQyUyMFRhYmxlVHJhbnNmb3JtZXJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVGFibGUlMjBUcmFuc2Zvcm1lciUyMG1pY3Jvc29mdCUyRnRhYmxlLXRyYW5zZm9ybWVyLWRldGVjdGlvbiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBUYWJsZVRyYW5zZm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbWljcm9zb2Z0JTJGdGFibGUtdHJhbnNmb3JtZXItZGV0ZWN0aW9uJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUYWJsZVRyYW5zZm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TableTransformerModel, TableTransformerConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Table Transformer microsoft/table-transformer-detection style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TableTransformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/table-transformer-detection style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,i=r(),u(c.$$.fragment)},l(a){n=m(a,"P",{"data-svelte-h":!0}),p(n)!=="svelte-kvfsh7"&&(n.textContent=v),i=l(a),g(c.$$.fragment,a)},m(a,w){s(a,n,w),s(a,i,w),b(c,a,w),h=!0},p:ye,i(a){h||(_(c.$$.fragment,a),h=!0)},o(a){T(c.$$.fragment,a),h=!1},d(a){a&&(o(n),o(i)),y(c,a)}}}function zt(C){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(i){n=m(i,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(i,c){s(i,n,c)},p:ye,d(i){i&&o(n)}}}function Gt(C){let n,v="Examples:",i,c,h;return c=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRhYmxlVHJhbnNmb3JtZXJNb2RlbCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBoZl9odWJfZG93bmxvYWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmaWxlX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb19pZCUzRCUyMm5pZWxzciUyRmV4YW1wbGUtcGRmJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyZXhhbXBsZV9wZGYucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlX3BhdGgpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGdGFibGUtdHJhbnNmb3JtZXItZGV0ZWN0aW9uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVGFibGVUcmFuc2Zvcm1lck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZ0YWJsZS10cmFuc2Zvcm1lci1kZXRlY3Rpb24lMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBhcmUlMjB0aGUlMjBmaW5hbCUyMHF1ZXJ5JTIwZW1iZWRkaW5ncyUyMG9mJTIwdGhlJTIwVHJhbnNmb3JtZXIlMjBkZWNvZGVyJTBBJTIzJTIwdGhlc2UlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TableTransformerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;nielsr/example-pdf&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, filename=<span class="hljs-string">&quot;example_pdf.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(file_path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerModel.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">15</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,i=r(),u(c.$$.fragment)},l(a){n=m(a,"P",{"data-svelte-h":!0}),p(n)!=="svelte-kvfsh7"&&(n.textContent=v),i=l(a),g(c.$$.fragment,a)},m(a,w){s(a,n,w),s(a,i,w),b(c,a,w),h=!0},p:ye,i(a){h||(_(c.$$.fragment,a),h=!0)},o(a){T(c.$$.fragment,a),h=!1},d(a){a&&(o(n),o(i)),y(c,a)}}}function Nt(C){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(i){n=m(i,"P",{"data-svelte-h":!0}),p(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(i,c){s(i,n,c)},p:ye,d(i){i&&o(n)}}}function qt(C){let n,v="Examples:",i,c,h;return c=new st({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TableTransformerForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;nielsr/example-pdf&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, filename=<span class="hljs-string">&quot;example_pdf.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(file_path).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TableTransformerForObjectDetection.from_pretrained(<span class="hljs-string">&quot;microsoft/table-transformer-detection&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected table <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">202.1</span>, <span class="hljs-number">210.59</span>, <span class="hljs-number">1119.22</span>, <span class="hljs-number">385.09</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,i=r(),u(c.$$.fragment)},l(a){n=m(a,"P",{"data-svelte-h":!0}),p(n)!=="svelte-kvfsh7"&&(n.textContent=v),i=l(a),g(c.$$.fragment,a)},m(a,w){s(a,n,w),s(a,i,w),b(c,a,w),h=!0},p:ye,i(a){h||(_(c.$$.fragment,a),h=!0)},o(a){T(c.$$.fragment,a),h=!1},d(a){a&&(o(n),o(i)),y(c,a)}}}function Bt(C){let n,v,i,c,h,a,w,rt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',we,V,ve,X,lt=`The Table Transformer model was proposed in <a href="https://arxiv.org/abs/2110.00061" rel="nofollow">PubTables-1M: Towards comprehensive table extraction from unstructured documents</a> by
Brandon Smock, Rohith Pesala, Robin Abraham. The authors introduce a new dataset, PubTables-1M, to benchmark progress in table extraction from unstructured documents,
as well as table structure recognition and functional analysis. The authors train 2 <a href="detr">DETR</a> models, one for table detection and one for table structure recognition, dubbed Table Transformers.`,Me,H,it="The abstract from the paper is the following:",xe,P,ct=`<em>Recently, significant progress has been made applying machine learning to the problem of table structure inference and extraction from unstructured documents.
However, one of the greatest challenges remains the creation of datasets with complete, unambiguous ground truth at scale. To address this, we develop a new, more
comprehensive dataset for table extraction, called PubTables-1M. PubTables-1M contains nearly one million tables from scientific articles, supports multiple input
modalities, and contains detailed header and location information for table structures, making it useful for a wide variety of modeling approaches. It also addresses a significant
source of ground truth inconsistency observed in prior datasets called oversegmentation, using a novel canonicalization procedure. We demonstrate that these improvements lead to a
significant increase in training performance and a more reliable estimate of model performance at evaluation for table structure recognition. Further, we show that transformer-based
object detection models trained on PubTables-1M produce excellent results for all three tasks of detection, structure recognition, and functional analysis without the need for any
special customization for these tasks.</em>`,je,z,dt,Je,E,mt='Table detection and table structure recognition clarified. Taken from the <a href="https://arxiv.org/abs/2110.00061">original paper</a>.',$e,D,ft=`The authors released 2 models, one for <a href="https://huggingface.co/microsoft/table-transformer-detection" rel="nofollow">table detection</a> in
documents, one for <a href="https://huggingface.co/microsoft/table-transformer-structure-recognition" rel="nofollow">table structure recognition</a>
(the task of recognizing the individual rows, columns etc. in a table).`,Ce,Q,pt=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be
found <a href="https://github.com/microsoft/table-transformer" rel="nofollow">here</a>.`,ke,L,Ue,O,Fe,Y,ht='<li>A demo notebook for the Table Transformer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Table%20Transformer" rel="nofollow">here</a>.</li> <li>It turns out padding of images is quite important for detection. An interesting Github thread with replies from the authors can be found <a href="https://github.com/microsoft/table-transformer/issues/68" rel="nofollow">here</a>.</li>',Ie,S,We,j,A,Ve,le,ut=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a>. It is used to
instantiate a Table Transformer model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the Table Transformer
<a href="https://huggingface.co/microsoft/table-transformer-detection" rel="nofollow">microsoft/table-transformer-detection</a> architecture.`,Xe,ie,gt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,He,G,Ze,K,ze,M,ee,Pe,ce,bt=`The bare Table Transformer Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,Ee,de,_t=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,De,me,Tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qe,k,te,Le,fe,yt='The <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> forward method, overrides the <code>__call__</code> special method.',Oe,N,Ye,q,Ge,oe,Ne,x,ne,Se,pe,wt=`Table Transformer Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,Ae,he,vt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ke,ue,Mt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,et,U,ae,tt,ge,xt='The <a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerForObjectDetection">TableTransformerForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',ot,B,nt,R,qe,se,Be,_e,Re;return h=new be({props:{title:"Table Transformer",local:"table-transformer",headingTag:"h1"}}),V=new be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),L=new be({props:{title:"Resources",local:"resources",headingTag:"h2"}}),O=new It({props:{pipeline:"object-detection"}}),S=new be({props:{title:"TableTransformerConfig",local:"transformers.TableTransformerConfig",headingTag:"h2"}}),A=new Te({props:{name:"class transformers.TableTransformerConfig",anchor:"transformers.TableTransformerConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 100"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TableTransformerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.TableTransformerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.TableTransformerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.TableTransformerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerModel">TableTransformerModel</a> can detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.TableTransformerConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.TableTransformerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.TableTransformerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.TableTransformerConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.TableTransformerConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.TableTransformerConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.TableTransformerConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.TableTransformerConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.TableTransformerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.TableTransformerConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.TableTransformerConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.TableTransformerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.TableTransformerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.TableTransformerConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.TableTransformerConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.TableTransformerConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.TableTransformerConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.TableTransformerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.TableTransformerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.TableTransformerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.TableTransformerConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.TableTransformerConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.TableTransformerConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.TableTransformerConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.TableTransformerConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.TableTransformerConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/configuration_table_transformer.py#L32"}}),G=new at({props:{anchor:"transformers.TableTransformerConfig.example",$$slots:{default:[Zt]},$$scope:{ctx:C}}}),K=new be({props:{title:"TableTransformerModel",local:"transformers.TableTransformerModel",headingTag:"h2"}}),ee=new Te({props:{name:"class transformers.TableTransformerModel",anchor:"transformers.TableTransformerModel",parameters:[{name:"config",val:": TableTransformerConfig"}],parametersDescription:[{anchor:"transformers.TableTransformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1108"}}),te=new Te({props:{name:"forward",anchor:"transformers.TableTransformerModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TableTransformerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TableTransformerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.TableTransformerModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.TableTransformerModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TableTransformerModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.TableTransformerModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TableTransformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TableTransformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TableTransformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1150",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig"
>TableTransformerConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new jt({props:{$$slots:{default:[zt]},$$scope:{ctx:C}}}),q=new at({props:{anchor:"transformers.TableTransformerModel.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:C}}}),oe=new be({props:{title:"TableTransformerForObjectDetection",local:"transformers.TableTransformerForObjectDetection",headingTag:"h2"}}),ne=new Te({props:{name:"class transformers.TableTransformerForObjectDetection",anchor:"transformers.TableTransformerForObjectDetection",parameters:[{name:"config",val:": TableTransformerConfig"}],parametersDescription:[{anchor:"transformers.TableTransformerForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig">TableTransformerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1277"}}),ae=new Te({props:{name:"forward",anchor:"transformers.TableTransformerForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TableTransformerForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/poolformer#transformers.PoolFormerFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TableTransformerForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.TableTransformerForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.TableTransformerForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.TableTransformerForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.TableTransformerForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.TableTransformerForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TableTransformerForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TableTransformerForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TableTransformerForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/table_transformer/modeling_table_transformer.py#L1303",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/table-transformer#transformers.TableTransformerConfig"
>TableTransformerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~TableTransformerImageProcessor.post_process_object_detection</code> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.table_transformer.modeling_table_transformer.TableTransformerObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new jt({props:{$$slots:{default:[Nt]},$$scope:{ctx:C}}}),R=new at({props:{anchor:"transformers.TableTransformerForObjectDetection.forward.example",$$slots:{default:[qt]},$$scope:{ctx:C}}}),se=new Wt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/table-transformer.md"}}),{c(){n=d("meta"),v=r(),i=d("p"),c=r(),u(h.$$.fragment),a=r(),w=d("div"),w.innerHTML=rt,we=r(),u(V.$$.fragment),ve=r(),X=d("p"),X.innerHTML=lt,Me=r(),H=d("p"),H.textContent=it,xe=r(),P=d("p"),P.innerHTML=ct,je=r(),z=d("img"),Je=r(),E=d("small"),E.innerHTML=mt,$e=r(),D=d("p"),D.innerHTML=ft,Ce=r(),Q=d("p"),Q.innerHTML=pt,ke=r(),u(L.$$.fragment),Ue=r(),u(O.$$.fragment),Fe=r(),Y=d("ul"),Y.innerHTML=ht,Ie=r(),u(S.$$.fragment),We=r(),j=d("div"),u(A.$$.fragment),Ve=r(),le=d("p"),le.innerHTML=ut,Xe=r(),ie=d("p"),ie.innerHTML=gt,He=r(),u(G.$$.fragment),Ze=r(),u(K.$$.fragment),ze=r(),M=d("div"),u(ee.$$.fragment),Pe=r(),ce=d("p"),ce.textContent=bt,Ee=r(),de=d("p"),de.innerHTML=_t,De=r(),me=d("p"),me.innerHTML=Tt,Qe=r(),k=d("div"),u(te.$$.fragment),Le=r(),fe=d("p"),fe.innerHTML=yt,Oe=r(),u(N.$$.fragment),Ye=r(),u(q.$$.fragment),Ge=r(),u(oe.$$.fragment),Ne=r(),x=d("div"),u(ne.$$.fragment),Se=r(),pe=d("p"),pe.textContent=wt,Ae=r(),he=d("p"),he.innerHTML=vt,Ke=r(),ue=d("p"),ue.innerHTML=Mt,et=r(),U=d("div"),u(ae.$$.fragment),tt=r(),ge=d("p"),ge.innerHTML=xt,ot=r(),u(B.$$.fragment),nt=r(),u(R.$$.fragment),qe=r(),u(se.$$.fragment),Be=r(),_e=d("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);n=m(t,"META",{name:!0,content:!0}),t.forEach(o),v=l(e),i=m(e,"P",{}),re(i).forEach(o),c=l(e),g(h.$$.fragment,e),a=l(e),w=m(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-13t8s2t"&&(w.innerHTML=rt),we=l(e),g(V.$$.fragment,e),ve=l(e),X=m(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1eh4n85"&&(X.innerHTML=lt),Me=l(e),H=m(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-vfdo9a"&&(H.textContent=it),xe=l(e),P=m(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-15fvuyo"&&(P.innerHTML=ct),je=l(e),z=m(e,"IMG",{src:!0,alt:!0,width:!0}),Je=l(e),E=m(e,"SMALL",{"data-svelte-h":!0}),p(E)!=="svelte-xusvwd"&&(E.innerHTML=mt),$e=l(e),D=m(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1rds34j"&&(D.innerHTML=ft),Ce=l(e),Q=m(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-ynmngv"&&(Q.innerHTML=pt),ke=l(e),g(L.$$.fragment,e),Ue=l(e),g(O.$$.fragment,e),Fe=l(e),Y=m(e,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-4dtp4u"&&(Y.innerHTML=ht),Ie=l(e),g(S.$$.fragment,e),We=l(e),j=m(e,"DIV",{class:!0});var F=re(j);g(A.$$.fragment,F),Ve=l(F),le=m(F,"P",{"data-svelte-h":!0}),p(le)!=="svelte-u4joxt"&&(le.innerHTML=ut),Xe=l(F),ie=m(F,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-o55m63"&&(ie.innerHTML=gt),He=l(F),g(G.$$.fragment,F),F.forEach(o),Ze=l(e),g(K.$$.fragment,e),ze=l(e),M=m(e,"DIV",{class:!0});var J=re(M);g(ee.$$.fragment,J),Pe=l(J),ce=m(J,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-q3yild"&&(ce.textContent=bt),Ee=l(J),de=m(J,"P",{"data-svelte-h":!0}),p(de)!=="svelte-6pahdo"&&(de.innerHTML=_t),De=l(J),me=m(J,"P",{"data-svelte-h":!0}),p(me)!=="svelte-hswkmf"&&(me.innerHTML=Tt),Qe=l(J),k=m(J,"DIV",{class:!0});var I=re(k);g(te.$$.fragment,I),Le=l(I),fe=m(I,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-4zig1t"&&(fe.innerHTML=yt),Oe=l(I),g(N.$$.fragment,I),Ye=l(I),g(q.$$.fragment,I),I.forEach(o),J.forEach(o),Ge=l(e),g(oe.$$.fragment,e),Ne=l(e),x=m(e,"DIV",{class:!0});var $=re(x);g(ne.$$.fragment,$),Se=l($),pe=m($,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-14j6uvi"&&(pe.textContent=wt),Ae=l($),he=m($,"P",{"data-svelte-h":!0}),p(he)!=="svelte-6pahdo"&&(he.innerHTML=vt),Ke=l($),ue=m($,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-hswkmf"&&(ue.innerHTML=Mt),et=l($),U=m($,"DIV",{class:!0});var W=re(U);g(ae.$$.fragment,W),tt=l(W),ge=m(W,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-a1ddut"&&(ge.innerHTML=xt),ot=l(W),g(B.$$.fragment,W),nt=l(W),g(R.$$.fragment,W),W.forEach(o),$.forEach(o),qe=l(e),g(se.$$.fragment,e),Be=l(e),_e=m(e,"P",{}),re(_e).forEach(o),this.h()},h(){Z(n,"name","hf:doc:metadata"),Z(n,"content",Rt),Z(w,"class","flex flex-wrap space-x-1"),$t(z.src,dt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/table_transformer_architecture.jpeg")||Z(z,"src",dt),Z(z,"alt","drawing"),Z(z,"width","600"),Z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){f(document.head,n),s(e,v,t),s(e,i,t),s(e,c,t),b(h,e,t),s(e,a,t),s(e,w,t),s(e,we,t),b(V,e,t),s(e,ve,t),s(e,X,t),s(e,Me,t),s(e,H,t),s(e,xe,t),s(e,P,t),s(e,je,t),s(e,z,t),s(e,Je,t),s(e,E,t),s(e,$e,t),s(e,D,t),s(e,Ce,t),s(e,Q,t),s(e,ke,t),b(L,e,t),s(e,Ue,t),b(O,e,t),s(e,Fe,t),s(e,Y,t),s(e,Ie,t),b(S,e,t),s(e,We,t),s(e,j,t),b(A,j,null),f(j,Ve),f(j,le),f(j,Xe),f(j,ie),f(j,He),b(G,j,null),s(e,Ze,t),b(K,e,t),s(e,ze,t),s(e,M,t),b(ee,M,null),f(M,Pe),f(M,ce),f(M,Ee),f(M,de),f(M,De),f(M,me),f(M,Qe),f(M,k),b(te,k,null),f(k,Le),f(k,fe),f(k,Oe),b(N,k,null),f(k,Ye),b(q,k,null),s(e,Ge,t),b(oe,e,t),s(e,Ne,t),s(e,x,t),b(ne,x,null),f(x,Se),f(x,pe),f(x,Ae),f(x,he),f(x,Ke),f(x,ue),f(x,et),f(x,U),b(ae,U,null),f(U,tt),f(U,ge),f(U,ot),b(B,U,null),f(U,nt),b(R,U,null),s(e,qe,t),b(se,e,t),s(e,Be,t),s(e,_e,t),Re=!0},p(e,[t]){const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),G.$set(F);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),N.$set(J);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),q.$set(I);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),B.$set($);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),R.$set(W)},i(e){Re||(_(h.$$.fragment,e),_(V.$$.fragment,e),_(L.$$.fragment,e),_(O.$$.fragment,e),_(S.$$.fragment,e),_(A.$$.fragment,e),_(G.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(N.$$.fragment,e),_(q.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(B.$$.fragment,e),_(R.$$.fragment,e),_(se.$$.fragment,e),Re=!0)},o(e){T(h.$$.fragment,e),T(V.$$.fragment,e),T(L.$$.fragment,e),T(O.$$.fragment,e),T(S.$$.fragment,e),T(A.$$.fragment,e),T(G.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(N.$$.fragment,e),T(q.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(B.$$.fragment,e),T(R.$$.fragment,e),T(se.$$.fragment,e),Re=!1},d(e){e&&(o(v),o(i),o(c),o(a),o(w),o(we),o(ve),o(X),o(Me),o(H),o(xe),o(P),o(je),o(z),o(Je),o(E),o($e),o(D),o(Ce),o(Q),o(ke),o(Ue),o(Fe),o(Y),o(Ie),o(We),o(j),o(Ze),o(ze),o(M),o(Ge),o(Ne),o(x),o(qe),o(Be),o(_e)),o(n),y(h,e),y(V,e),y(L,e),y(O,e),y(S,e),y(A),y(G),y(K,e),y(ee),y(te),y(N),y(q),y(oe,e),y(ne),y(ae),y(B),y(R),y(se,e)}}}const Rt='{"title":"Table Transformer","local":"table-transformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"TableTransformerConfig","local":"transformers.TableTransformerConfig","sections":[],"depth":2},{"title":"TableTransformerModel","local":"transformers.TableTransformerModel","sections":[],"depth":2},{"title":"TableTransformerForObjectDetection","local":"transformers.TableTransformerForObjectDetection","sections":[],"depth":2}],"depth":1}';function Vt(C){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends kt{constructor(n){super(),Ut(this,n,Vt,Bt,Jt,{})}}export{Yt as component};
