import{s as tl,A as ll,o as sl,n as W}from"../chunks/scheduler.01eeda35.js";import{S as al,i as nl,g as u,s as p,r as T,A as ol,h,f as a,c,j as bt,u as J,x as f,k as ve,y as il,a as n,v as U,d as w,t as b,w as j}from"../chunks/index.6dd51b66.js";import{T as D}from"../chunks/Tip.de9bae2b.js";import{C as $}from"../chunks/CodeBlock.19ec9b8c.js";import{H as Y,E as rl}from"../chunks/index.58fe8f9d.js";import{H as jt,a as Be}from"../chunks/HfOption.f7f04550.js";function pl(g){let t,m='Try out <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>, a Hugging Face library dedicated to deploying and serving highly optimized LLMs for inference.';return{c(){t=u("p"),t.innerHTML=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-c1q0e5"&&(t.innerHTML=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function cl(g){let t,m='Follow this <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">issue</a> to track which models (Llama, Gemma, Mistral, etc.) support a static kv-cache and torch.compile.';return{c(){t=u("p"),t.innerHTML=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-58h2fm"&&(t.innerHTML=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function ml(g){let t,m='Regardless of how you use the static kv-cache and torch.compile, left-pad your inputs with <a href="https://hf.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow">pad_to_multiple_of</a> to a limited set of values to avoid shape-related recompilations.';return{c(){t=u("p"),t.innerHTML=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-uz572w"&&(t.innerHTML=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function Ml(g){let t,m='<li>Set the <a href="https://hf.co/docs/transformers/main_classes/text_generation#transformers.GenerationConfig.cache_implementation" rel="nofollow">cache_implementation</a> to <code>&quot;static&quot;</code> in a models <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.</li> <li>Call <a href="./perf_torch_compile">torch.compile</a> to compile the forward pass with the static kv-cache.</li>',s,r,o,i,M='Under the hood, <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> attempts to reuse the same cache object to avoid recompilation at each call, which is critical to get the most out of <a href="./perf_torch_compile">torch.compile</a>. Be aware of the following to avoid triggering recompilation or if generation is slower than expected.',Z,k,v="<li>If the batch size changes or the maximum output length increases between calls, the cache is reinitialized and recompiled.</li> <li>The first several calls of the compiled function are slower because it is being compiled.</li>",_;return r=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZS50eXBlKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAxLiUyMFRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQlMjBpbiUyMGFsbCUyMGluZXJ0aWFsJTIwcmVmZXJlbmNlJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device.<span class="hljs-built_in">type</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=u("ol"),t.innerHTML=m,s=p(),T(r.$$.fragment),o=p(),i=u("p"),i.innerHTML=M,Z=p(),k=u("ol"),k.innerHTML=v},l(d){t=h(d,"OL",{"data-svelte-h":!0}),f(t)!=="svelte-k7c087"&&(t.innerHTML=m),s=c(d),J(r.$$.fragment,d),o=c(d),i=h(d,"P",{"data-svelte-h":!0}),f(i)!=="svelte-1nxft6v"&&(i.innerHTML=M),Z=c(d),k=h(d,"OL",{"data-svelte-h":!0}),f(k)!=="svelte-13b9uyo"&&(k.innerHTML=v)},m(d,G){n(d,t,G),n(d,s,G),U(r,d,G),n(d,o,G),n(d,i,G),n(d,Z,G),n(d,k,G),_=!0},p:W,i(d){_||(w(r.$$.fragment,d),_=!0)},o(d){b(r.$$.fragment,d),_=!1},d(d){d&&(a(t),a(s),a(o),a(i),a(Z),a(k)),j(r,d)}}}function dl(g){let t,m='To reuse <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> on a new prompt, use <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache.reset">reset()</a> to reset the cache contents between calls.';return{c(){t=u("p"),t.innerHTML=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1j560i1"&&(t.innerHTML=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function yl(g){let t,m='Directly initialize a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object and pass it to the <code>past_key_values</code> parameter in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. The <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> keeps the cache contents, so you can pass it to a new <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> call to continue generation, similar to a dynamic cache.',s,r,o,i,M,Z,k='Another option for using <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> is to pass it to a models forward pass using the same <code>past_key_values</code> argument. This allows you to write your own custom decoding function to decode the next token given the current token, position, and cache position of previously generated tokens.',v,_,d,G,Ce='To enable static kv-cache and <a href="./perf_torch_compile">torch.compile</a> with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a>, follow the steps below.',z,C,P='<li>Initialize <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> before using the model for inference to configure parameters like the maximum batch size and sequence length.</li> <li>Call <a href="./perf_torch_compile">torch.compile</a> on the model to compile the forward pass with the static kv-cache.</li> <li>se SDPBackend.MATH in the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html" rel="nofollow">torch.nn.attention.sdpa_kernel</a> context manager to enable the native PyTorch C++ implementation of scaled dot product attention to speed up inference even more.</li>',I,X,R;return r=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device.<span class="hljs-built_in">type</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># If you plan to reuse the cache, make sure the cache length is large enough for all cases</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># pass in the generated text and the same cache object to continue generation from where it left off. Optionally, in a</span>
<span class="hljs-comment"># multi-turn conversation, append the new user input to the generated text.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),i=new D({props:{warning:!1,$$slots:{default:[dl]},$$scope:{ctx:g}}}),_=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),X=new $({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel

batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.MATH):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=m,s=p(),T(r.$$.fragment),o=p(),T(i.$$.fragment),M=p(),Z=u("p"),Z.innerHTML=k,v=p(),T(_.$$.fragment),d=p(),G=u("p"),G.innerHTML=Ce,z=p(),C=u("ol"),C.innerHTML=P,I=p(),T(X.$$.fragment)},l(y){t=h(y,"P",{"data-svelte-h":!0}),f(t)!=="svelte-3zw9rq"&&(t.innerHTML=m),s=c(y),J(r.$$.fragment,y),o=c(y),J(i.$$.fragment,y),M=c(y),Z=h(y,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-1gz44wn"&&(Z.innerHTML=k),v=c(y),J(_.$$.fragment,y),d=c(y),G=h(y,"P",{"data-svelte-h":!0}),f(G)!=="svelte-1g8sj7q"&&(G.innerHTML=Ce),z=c(y),C=h(y,"OL",{"data-svelte-h":!0}),f(C)!=="svelte-iqu6q8"&&(C.innerHTML=P),I=c(y),J(X.$$.fragment,y)},m(y,B){n(y,t,B),n(y,s,B),U(r,y,B),n(y,o,B),U(i,y,B),n(y,M,B),n(y,Z,B),n(y,v,B),U(_,y,B),n(y,d,B),n(y,G,B),n(y,z,B),n(y,C,B),n(y,I,B),U(X,y,B),R=!0},p(y,B){const V={};B&2&&(V.$$scope={dirty:B,ctx:y}),i.$set(V)},i(y){R||(w(r.$$.fragment,y),w(i.$$.fragment,y),w(_.$$.fragment,y),w(X.$$.fragment,y),R=!0)},o(y){b(r.$$.fragment,y),b(i.$$.fragment,y),b(_.$$.fragment,y),b(X.$$.fragment,y),R=!1},d(y){y&&(a(t),a(s),a(o),a(M),a(Z),a(v),a(d),a(G),a(z),a(C),a(I)),j(r,y),j(i,y),j(_,y),j(X,y)}}}function ul(g){let t,m='Compiling the entire <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> function also compiles the input preparation logit processor operations, and more, in addition to the forward pass. With this approach, you don’t need to initialize <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> or set the <a href="https://hf.co/docs/transformers/main_classes/text_generation#transformers.GenerationConfig.cache_implementation" rel="nofollow">cache_implementation</a> parameter.',s,r,o,i,M="This usage pattern is more appropriate for unique hardware or use cases, but there are several drawbacks to consider.",Z,k,v='<li>Compilation is much slower.</li> <li>Parameters must be configured through <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.</li> <li>Many warnings and exceptions are suppressed. We recommend testing the uncompiled model first.</li> <li>Many features are unavailable at the moment. For example, generation does not stop if an <code>EOS</code> token is selected.</li>',_;return r=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZS50eXBlKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAxLiUyMFRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQlMjBpbiUyMGFsbCUyMGluZXJ0aWFsJTIwcmVmZXJlbmNlJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device.<span class="hljs-built_in">type</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=m,s=p(),T(r.$$.fragment),o=p(),i=u("p"),i.textContent=M,Z=p(),k=u("ol"),k.innerHTML=v},l(d){t=h(d,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1tio1av"&&(t.innerHTML=m),s=c(d),J(r.$$.fragment,d),o=c(d),i=h(d,"P",{"data-svelte-h":!0}),f(i)!=="svelte-3z6n1l"&&(i.textContent=M),Z=c(d),k=h(d,"OL",{"data-svelte-h":!0}),f(k)!=="svelte-djx6ec"&&(k.innerHTML=v)},m(d,G){n(d,t,G),n(d,s,G),U(r,d,G),n(d,o,G),n(d,i,G),n(d,Z,G),n(d,k,G),_=!0},p:W,i(d){_||(w(r.$$.fragment,d),_=!0)},o(d){b(r.$$.fragment,d),_=!1},d(d){d&&(a(t),a(s),a(o),a(i),a(Z),a(k)),j(r,d)}}}function hl(g){let t,m,s,r,o,i;return t=new Be({props:{id:"static-kv",option:"1. cache_implementation",$$slots:{default:[Ml]},$$scope:{ctx:g}}}),s=new Be({props:{id:"static-kv",option:"2. StaticCache",$$slots:{default:[yl]},$$scope:{ctx:g}}}),o=new Be({props:{id:"static-kv",option:"3. compile entire generate function",$$slots:{default:[ul]},$$scope:{ctx:g}}}),{c(){T(t.$$.fragment),m=p(),T(s.$$.fragment),r=p(),T(o.$$.fragment)},l(M){J(t.$$.fragment,M),m=c(M),J(s.$$.fragment,M),r=c(M),J(o.$$.fragment,M)},m(M,Z){U(t,M,Z),n(M,m,Z),U(s,M,Z),n(M,r,Z),U(o,M,Z),i=!0},p(M,Z){const k={};Z&2&&(k.$$scope={dirty:Z,ctx:M}),t.$set(k);const v={};Z&2&&(v.$$scope={dirty:Z,ctx:M}),s.$set(v);const _={};Z&2&&(_.$$scope={dirty:Z,ctx:M}),o.$set(_)},i(M){i||(w(t.$$.fragment,M),w(s.$$.fragment,M),w(o.$$.fragment,M),i=!0)},o(M){b(t.$$.fragment,M),b(s.$$.fragment,M),b(o.$$.fragment,M),i=!1},d(M){M&&(a(m),a(r)),j(t,M),j(s,M),j(o,M)}}}function fl(g){let t,m='For a more in-depth explanation, take a look at the <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> blog post!';return{c(){t=u("p"),t.innerHTML=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-112w74b"&&(t.innerHTML=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function Tl(g){let t,m="Speculative decoding is only supported for the greedy search and sampling decoding strategies, and it doesn’t support batched inputs.";return{c(){t=u("p"),t.textContent=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1wfld0h"&&(t.textContent=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function Jl(g){let t,m;return t=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkVpbnN0ZWluJ3MlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKS50byhkZXZpY2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSU1QiUyMkVpbnN0ZWluJ3MlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwdGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudC4lMjAlMjAlMjAlMjAlMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){T(t.$$.fragment)},l(s){J(t.$$.fragment,s)},m(s,r){U(t,s,r),m=!0},p:W,i(s){m||(w(t.$$.fragment,s),m=!0)},o(s){b(t.$$.fragment,s),m=!1},d(s){j(t,s)}}}function Ul(g){let t,m='For speculative sampling decoding, add the <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.do_sample" rel="nofollow">do_sample</a> and <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.temperature" rel="nofollow">temperature</a> parameters to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',s,r,o;return r=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkVpbnN0ZWluJ3MlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKS50byhkZXZpY2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMG1vdGlvbiUyMGluJTIwdGhlJTIwdW5pdmVyc2UlMjBpcyUyMG5vdCUyMGElMjBzdHJhaWdodCUyMGxpbmUuJTVDbiUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=m,s=p(),T(r.$$.fragment)},l(i){t=h(i,"P",{"data-svelte-h":!0}),f(t)!=="svelte-nx7l91"&&(t.innerHTML=m),s=c(i),J(r.$$.fragment,i)},m(i,M){n(i,t,M),n(i,s,M),U(r,i,M),o=!0},p:W,i(i){o||(w(r.$$.fragment,i),o=!0)},o(i){b(r.$$.fragment,i),o=!1},d(i){i&&(a(t),a(s)),j(r,i)}}}function wl(g){let t,m,s,r;return t=new Be({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[Jl]},$$scope:{ctx:g}}}),s=new Be({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[Ul]},$$scope:{ctx:g}}}),{c(){T(t.$$.fragment),m=p(),T(s.$$.fragment)},l(o){J(t.$$.fragment,o),m=c(o),J(s.$$.fragment,o)},m(o,i){U(t,o,i),n(o,m,i),U(s,o,i),r=!0},p(o,i){const M={};i&2&&(M.$$scope={dirty:i,ctx:o}),t.$set(M);const Z={};i&2&&(Z.$$scope={dirty:i,ctx:o}),s.$set(Z)},i(o){r||(w(t.$$.fragment,o),w(s.$$.fragment,o),r=!0)},o(o){b(t.$$.fragment,o),b(s.$$.fragment,o),r=!1},d(o){o&&a(m),j(t,o),j(s,o)}}}function bl(g){let t,m;return t=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyKS50byhkZXZpY2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcHJvbXB0X2xvb2t1cF9udW1fdG9rZW5zJTNEMyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjB0aGF0JTIwZW50cm9weSUyMGluY3JlYXNlcyUyMHdpdGglMjB0ZW1wZXJhdHVyZS4lMjAlMjAlMjAlMjAlMjAlMjAnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){T(t.$$.fragment)},l(s){J(t.$$.fragment,s)},m(s,r){U(t,s,r),m=!0},p:W,i(s){m||(w(t.$$.fragment,s),m=!0)},o(s){b(t.$$.fragment,s),m=!1},d(s){j(t,s)}}}function jl(g){let t,m='For prompt lookup decoding with sampling, add the <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.do_sample" rel="nofollow">do_sample</a> and <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.temperature" rel="nofollow">temperature</a> parameters to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',s,r,o;return r=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGFjY2VsZXJhdGUudGVzdF91dGlscy50ZXN0aW5nJTIwaW1wb3J0JTIwZ2V0X2JhY2tlbmQlMEElMEFkZXZpY2UlMkMlMjBfJTJDJTIwXyUyMCUzRCUyMGdldF9iYWNrZW5kKCklMjAlMjMlMjBhdXRvbWF0aWNhbGx5JTIwZGV0ZWN0cyUyMHRoZSUyMHVuZGVybHlpbmclMjBkZXZpY2UlMjB0eXBlJTIwKENVREElMkMlMjBDUFUlMkMlMjBYUFUlMkMlMjBNUFMlMkMlMjBldGMuKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMS4zYiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QiUyMlRoZSUyMHNlY29uZCUyMGxhdyUyMG9mJTIwdGhlcm1vZHluYW1pY3MlMjBzdGF0ZXMlMjB0aGF0JTIwZW5lcmd5JTIwY2Fubm90JTIwYmUlMjBjcmVhdGVkJTIwbm9yJTIwZGVzdHJveWVkLiUyMEl0J3MlMjBub3QlMjBhJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=m,s=p(),T(r.$$.fragment)},l(i){t=h(i,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1uj7i8u"&&(t.innerHTML=m),s=c(i),J(r.$$.fragment,i)},m(i,M){n(i,t,M),n(i,s,M),U(r,i,M),o=!0},p:W,i(i){o||(w(r.$$.fragment,i),o=!0)},o(i){b(r.$$.fragment,i),o=!1},d(i){i&&(a(t),a(s)),j(r,i)}}}function Zl(g){let t,m,s,r;return t=new Be({props:{id:"pld",option:"greedy decoding",$$slots:{default:[bl]},$$scope:{ctx:g}}}),s=new Be({props:{id:"pld",option:"sampling",$$slots:{default:[jl]},$$scope:{ctx:g}}}),{c(){T(t.$$.fragment),m=p(),T(s.$$.fragment)},l(o){J(t.$$.fragment,o),m=c(o),J(s.$$.fragment,o)},m(o,i){U(t,o,i),n(o,m,i),U(s,o,i),r=!0},p(o,i){const M={};i&2&&(M.$$scope={dirty:i,ctx:o}),t.$set(M);const Z={};i&2&&(Z.$$scope={dirty:i,ctx:o}),s.$set(Z)},i(o){r||(w(t.$$.fragment,o),w(s.$$.fragment,o),r=!0)},o(o){b(t.$$.fragment,o),b(s.$$.fragment,o),r=!1},d(o){o&&a(m),j(t,o),j(s,o)}}}function gl(g){let t,m="SDPA automaticallysupports FlashAttention-2 as long as you have the latest PyTorch version installed.";return{c(){t=u("p"),t.textContent=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-19scp3k"&&(t.textContent=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function Gl(g){let t,m='There are many quantization libraries (see the <a href="./quantization">Quantization</a> guide for more details) available, such as Quanto, AQLM, VPTQ, AWQ, and AutoGPTQ. Feel free to try them out and see which one works best for your use case. We also recommend reading the <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post which compares AutoGPTQ and bitsandbytes.';return{c(){t=u("p"),t.innerHTML=m},l(s){t=h(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-p1oqjt"&&(t.innerHTML=m)},m(s,r){n(s,t,r)},p:W,d(s){s&&a(t)}}}function kl(g){let t,m,s,r,o,i,M,Z='Inference with large language models (LLMs) can be challenging because they have to store and handle billions of parameters. To load a 70B parameter <a href="https://hf.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama 2</a> model, it requires 256GB of memory for full precision weights and 128GB of memory for half-precision weights. The most powerful GPUs today - the A100 and H100 - only have 80GB of memory.',k,v,_="On top of the memory requirements, inference is slow because LLMs are called repeatedly to generate the next token. The input sequence increases as generation progresses, which takes longer and longer to process.",d,G,Ce="This guide will show you how to optimize LLM inference to accelerate generation and reduce memory usage.",z,C,P,I,X,R,y="LLMs compute key-value (kv) values for each input token, and it performs the same kv computation each time because the generated output becomes part of the input. However, performing the same kv computation every time is not very efficient.",B,V,Zt='A <em>kv-cache</em> stores the past keys and values instead of recomputing them each time. As a result, the kv-cache is dynamic and it grows with each generation step which prevents you from taking advantage of <a href="./perf_torch_compile">torch.compile</a>, a powerful optimization method that fuses PyTorch code into optimized kernels.',$e,K,gt='The <em>static kv-cache</em> solves this issue by pre-allocating the kv-cache size to a maximum value, so you can combine it with <a href="./perf_torch_compile">torch.compile</a> for up to a 4x speed up. Your speed up may vary depending on the model size (larger models have a smaller speed up) and hardware.',Ie,N,Xe,O,Gt="Depending on your task, there are several ways you can use the static kv-cache.",Re,ee,kt='<li>For basic use cases, set <a href="https://hf.co/docs/transformers/main_classes/text_generation#transformers.GenerationConfig.cache_implementation" rel="nofollow">cache_implementation</a> to <code>&quot;static&quot;</code> (recommended).</li> <li>For multi-turn generation or a custom generation loop, initialize and handle <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> directly.</li> <li>For more unique hardware or use cases, it may be better to compile the entire <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> function into a single graph.</li>',Ve,H,Fe,S,ze,te,Ye,le,_t="Decoding can also be optimized to accelerate generation. You can use a lightweight assistant model to generate candidate tokens faster than the LLM itself or you can use a variant of this decoding strategy that works especially well for input-grounded tasks.",Ne,se,He,x,Se,ae,Bt="For each input token, the model weights are loaded each time during the forward pass, which is slow and cumbersome when a model has billions of parameters. Speculative decoding alleviates this slowdown by using a second smaller and faster assistant model to generate candidate tokens that are verified by the larger model in a single forward pass. If the verified tokens are correct, the LLM essentially gets them for “free” without having to generate them itself. There is no degradation in accuracy because the verification forward pass ensures the same outputs are generated as if the LLM had generated them on its own.",xe,ne,vt="To get the largest speed up, the assistant model should be a lot smaller than the LLM so that it can generate tokens quickly. The assistant and LLM model must also share the same tokenizer to avoid re-encoding and decoding tokens.",Ee,E,Qe,oe,Ct='Enable speculative decoding by loading an assistant model and passing it to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',Ae,Q,qe,ie,Le,re,Wt="Prompt lookup decoding is a variant of speculative decoding that is also compatible with greedy search and sampling. Prompt lookup works especially well for input-grounded tasks - such as summarization - where there is often overlapping words between the prompt and output. These overlapping n-grams are used as the LLM candidate tokens.",De,pe,$t='To enable prompt lookup decoding, specify the number of tokens that should be overlapping in the <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.prompt_lookup_num_tokens" rel="nofollow">prompt_lookup_num_tokens</a> parameter. Then pass this parameter to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',Pe,A,Ke,ce,Oe,me,It="A known issue with transformer models is that the self-attention mechanism grows quadratically in compute and memory with the number of input tokens. This limitation is only magnified in LLMs which handles much longer sequences. To address this, try FlashAttention2 or PyTorch’s scaled dot product attention (SDPA), which are more memory efficient attention implementations.",et,Me,tt,de,Xt='FlashAttention and <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> break up the attention computation into smaller chunks and reduces the number of intermediate read/write operations to the GPU memory to speed up inference. FlashAttention-2 improves on the original FlashAttention algorithm by also parallelizing over sequence length dimension and better partitioning work on the hardware to reduce synchronization and communication overhead.',lt,ye,Rt='To use FlashAttention-2, set <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.PreTrainedModel.from_pretrained.attn_implementation" rel="nofollow">attn_implementation</a> to <code>&quot;flash_attention_2&quot;</code> in <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.',st,ue,at,he,nt,fe,Vt="Scaled dot product attention (SDPA) is automatically enabled in PyTorch 2.0 and it supports FlashAttention, xFormers, and PyTorch’s C++ implementation. SDPA chooses the most performant attention algorithm if you’re using a CUDA backend. For other backends, SDPA defaults to the PyTorch C++ implementation.",ot,q,it,Te,Ft='Use the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html" rel="nofollow">torch.nn.attention.sdpa_kernel</a> context manager to explicitly enable or disable any of the four attention algorithms. For example, use <code>SDPBackend.FLASH_ATTENTION</code> to enable FlashAttention.',rt,Je,pt,Ue,ct,we,zt="Quantization reduces the size of model weights by storing them in a lower precision. This translates to lower memory usage and makes loading LLMs for inference more accessible if you’re constrained by GPU memory.",mt,be,Yt="If you aren’t limited by your GPU, you don’t necessarily need to quantize your model because it can increase latency slightly (except for AWQ and fused AWQ modules) due to the extra step required to quantize and dequantize the weights.",Mt,L,dt,je,Nt='Use the Model Memory Calculator below to estimate and compare how much memory is required to load a model. For example, try estimating the memory required to load <a href="https://hf.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>.',yt,F,Ht,ut,Ze,St='To load a model in half-precision, set the <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.PreTrainedModel.from_pretrained.torch_dtype" rel="nofollow">torch_dtype</a> parameter in <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> to <code>torch.bfloat16</code>. This requires 13.74GB of memory.',ht,ge,ft,Ge,xt='To load a quantized model (8-bit or 4-bit), try <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a> and set the <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.BitsAndBytesConfig.load_in_4bit" rel="nofollow">load_in_4bit</a> or <a href="https://hf.co/docs/transformers/main/en/main_classes/text_generation#transformers.BitsAndBytesConfig.load_in_8bit" rel="nofollow">load_in_8bit</a> parameters to <code>True</code>. Loading the model in 8-bits only requires 6.87 GB of memory.',Tt,ke,Jt,_e,Ut,We,wt;return o=new Y({props:{title:"Optimizing inference",local:"optimizing-inference",headingTag:"h1"}}),C=new D({props:{warning:!1,$$slots:{default:[pl]},$$scope:{ctx:g}}}),I=new Y({props:{title:"Static kv-cache and torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),N=new D({props:{warning:!0,$$slots:{default:[cl]},$$scope:{ctx:g}}}),H=new D({props:{warning:!1,$$slots:{default:[ml]},$$scope:{ctx:g}}}),S=new jt({props:{id:"static-kv",options:["1. cache_implementation","2. StaticCache","3. compile entire generate function"],$$slots:{default:[hl]},$$scope:{ctx:g}}}),te=new Y({props:{title:"Decoding strategies",local:"decoding-strategies",headingTag:"h2"}}),se=new Y({props:{title:"Speculative decoding",local:"speculative-decoding",headingTag:"h3"}}),x=new D({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:g}}}),E=new D({props:{warning:!0,$$slots:{default:[Tl]},$$scope:{ctx:g}}}),Q=new jt({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[wl]},$$scope:{ctx:g}}}),ie=new Y({props:{title:"Prompt lookup decoding",local:"prompt-lookup-decoding",headingTag:"h3"}}),A=new jt({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[Zl]},$$scope:{ctx:g}}}),ce=new Y({props:{title:"Attention",local:"attention",headingTag:"h2"}}),Me=new Y({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),ue=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),he=new Y({props:{title:"PyTorch scaled dot product attention",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),q=new D({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:g}}}),Je=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gubm4uYXR0ZW50aW9uJTIwaW1wb3J0JTIwU0RQQmFja2VuZCUyQyUyMHNkcGFfa2VybmVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQSUwQXdpdGglMjBzZHBhX2tlcm5lbChTRFBCYWNrZW5kLkZMQVNIX0FUVEVOVElPTiklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.FLASH_ATTENTION):
    outputs = model.generate(**inputs)`,wrap:!1}}),Ue=new Y({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),L=new D({props:{warning:!1,$$slots:{default:[Gl]},$$scope:{ctx:g}}}),ge=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),ke=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),_e=new rl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_optims.md"}}),{c(){t=u("meta"),m=p(),s=u("p"),r=p(),T(o.$$.fragment),i=p(),M=u("p"),M.innerHTML=Z,k=p(),v=u("p"),v.textContent=_,d=p(),G=u("p"),G.textContent=Ce,z=p(),T(C.$$.fragment),P=p(),T(I.$$.fragment),X=p(),R=u("p"),R.textContent=y,B=p(),V=u("p"),V.innerHTML=Zt,$e=p(),K=u("p"),K.innerHTML=gt,Ie=p(),T(N.$$.fragment),Xe=p(),O=u("p"),O.textContent=Gt,Re=p(),ee=u("ol"),ee.innerHTML=kt,Ve=p(),T(H.$$.fragment),Fe=p(),T(S.$$.fragment),ze=p(),T(te.$$.fragment),Ye=p(),le=u("p"),le.textContent=_t,Ne=p(),T(se.$$.fragment),He=p(),T(x.$$.fragment),Se=p(),ae=u("p"),ae.textContent=Bt,xe=p(),ne=u("p"),ne.textContent=vt,Ee=p(),T(E.$$.fragment),Qe=p(),oe=u("p"),oe.innerHTML=Ct,Ae=p(),T(Q.$$.fragment),qe=p(),T(ie.$$.fragment),Le=p(),re=u("p"),re.textContent=Wt,De=p(),pe=u("p"),pe.innerHTML=$t,Pe=p(),T(A.$$.fragment),Ke=p(),T(ce.$$.fragment),Oe=p(),me=u("p"),me.textContent=It,et=p(),T(Me.$$.fragment),tt=p(),de=u("p"),de.innerHTML=Xt,lt=p(),ye=u("p"),ye.innerHTML=Rt,st=p(),T(ue.$$.fragment),at=p(),T(he.$$.fragment),nt=p(),fe=u("p"),fe.textContent=Vt,ot=p(),T(q.$$.fragment),it=p(),Te=u("p"),Te.innerHTML=Ft,rt=p(),T(Je.$$.fragment),pt=p(),T(Ue.$$.fragment),ct=p(),we=u("p"),we.textContent=zt,mt=p(),be=u("p"),be.textContent=Yt,Mt=p(),T(L.$$.fragment),dt=p(),je=u("p"),je.innerHTML=Nt,yt=p(),F=u("iframe"),ut=p(),Ze=u("p"),Ze.innerHTML=St,ht=p(),T(ge.$$.fragment),ft=p(),Ge=u("p"),Ge.innerHTML=xt,Tt=p(),T(ke.$$.fragment),Jt=p(),T(_e.$$.fragment),Ut=p(),We=u("p"),this.h()},l(e){const l=ol("svelte-u9bgzb",document.head);t=h(l,"META",{name:!0,content:!0}),l.forEach(a),m=c(e),s=h(e,"P",{}),bt(s).forEach(a),r=c(e),J(o.$$.fragment,e),i=c(e),M=h(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1f9oh7n"&&(M.innerHTML=Z),k=c(e),v=h(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1olgvni"&&(v.textContent=_),d=c(e),G=h(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-16ypsvh"&&(G.textContent=Ce),z=c(e),J(C.$$.fragment,e),P=c(e),J(I.$$.fragment,e),X=c(e),R=h(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1a9ib4g"&&(R.textContent=y),B=c(e),V=h(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-7nmn0g"&&(V.innerHTML=Zt),$e=c(e),K=h(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1abkxhz"&&(K.innerHTML=gt),Ie=c(e),J(N.$$.fragment,e),Xe=c(e),O=h(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-13l87jg"&&(O.textContent=Gt),Re=c(e),ee=h(e,"OL",{"data-svelte-h":!0}),f(ee)!=="svelte-lc6gnj"&&(ee.innerHTML=kt),Ve=c(e),J(H.$$.fragment,e),Fe=c(e),J(S.$$.fragment,e),ze=c(e),J(te.$$.fragment,e),Ye=c(e),le=h(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-a4gxio"&&(le.textContent=_t),Ne=c(e),J(se.$$.fragment,e),He=c(e),J(x.$$.fragment,e),Se=c(e),ae=h(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-nv0ghv"&&(ae.textContent=Bt),xe=c(e),ne=h(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1nm1j4o"&&(ne.textContent=vt),Ee=c(e),J(E.$$.fragment,e),Qe=c(e),oe=h(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-1yxjr5n"&&(oe.innerHTML=Ct),Ae=c(e),J(Q.$$.fragment,e),qe=c(e),J(ie.$$.fragment,e),Le=c(e),re=h(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-123yl06"&&(re.textContent=Wt),De=c(e),pe=h(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-53xl5d"&&(pe.innerHTML=$t),Pe=c(e),J(A.$$.fragment,e),Ke=c(e),J(ce.$$.fragment,e),Oe=c(e),me=h(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-119vxvi"&&(me.textContent=It),et=c(e),J(Me.$$.fragment,e),tt=c(e),de=h(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1noxdna"&&(de.innerHTML=Xt),lt=c(e),ye=h(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1d73c2c"&&(ye.innerHTML=Rt),st=c(e),J(ue.$$.fragment,e),at=c(e),J(he.$$.fragment,e),nt=c(e),fe=h(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-16n93px"&&(fe.textContent=Vt),ot=c(e),J(q.$$.fragment,e),it=c(e),Te=h(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-xcpcjc"&&(Te.innerHTML=Ft),rt=c(e),J(Je.$$.fragment,e),pt=c(e),J(Ue.$$.fragment,e),ct=c(e),we=h(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1h1vcbj"&&(we.textContent=zt),mt=c(e),be=h(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-bsjn3b"&&(be.textContent=Yt),Mt=c(e),J(L.$$.fragment,e),dt=c(e),je=h(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-14tgx8l"&&(je.innerHTML=Nt),yt=c(e),F=h(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),bt(F).forEach(a),ut=c(e),Ze=h(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-whgkfb"&&(Ze.innerHTML=St),ht=c(e),J(ge.$$.fragment,e),ft=c(e),Ge=h(e,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-1f44nt3"&&(Ge.innerHTML=xt),Tt=c(e),J(ke.$$.fragment,e),Jt=c(e),J(_e.$$.fragment,e),Ut=c(e),We=h(e,"P",{}),bt(We).forEach(a),this.h()},h(){ve(t,"name","hf:doc:metadata"),ve(t,"content",_l),ll(F.src,Ht="https://hf-accelerate-model-memory-usage.hf.space")||ve(F,"src",Ht),ve(F,"frameborder","0"),ve(F,"width","850"),ve(F,"height","450")},m(e,l){il(document.head,t),n(e,m,l),n(e,s,l),n(e,r,l),U(o,e,l),n(e,i,l),n(e,M,l),n(e,k,l),n(e,v,l),n(e,d,l),n(e,G,l),n(e,z,l),U(C,e,l),n(e,P,l),U(I,e,l),n(e,X,l),n(e,R,l),n(e,B,l),n(e,V,l),n(e,$e,l),n(e,K,l),n(e,Ie,l),U(N,e,l),n(e,Xe,l),n(e,O,l),n(e,Re,l),n(e,ee,l),n(e,Ve,l),U(H,e,l),n(e,Fe,l),U(S,e,l),n(e,ze,l),U(te,e,l),n(e,Ye,l),n(e,le,l),n(e,Ne,l),U(se,e,l),n(e,He,l),U(x,e,l),n(e,Se,l),n(e,ae,l),n(e,xe,l),n(e,ne,l),n(e,Ee,l),U(E,e,l),n(e,Qe,l),n(e,oe,l),n(e,Ae,l),U(Q,e,l),n(e,qe,l),U(ie,e,l),n(e,Le,l),n(e,re,l),n(e,De,l),n(e,pe,l),n(e,Pe,l),U(A,e,l),n(e,Ke,l),U(ce,e,l),n(e,Oe,l),n(e,me,l),n(e,et,l),U(Me,e,l),n(e,tt,l),n(e,de,l),n(e,lt,l),n(e,ye,l),n(e,st,l),U(ue,e,l),n(e,at,l),U(he,e,l),n(e,nt,l),n(e,fe,l),n(e,ot,l),U(q,e,l),n(e,it,l),n(e,Te,l),n(e,rt,l),U(Je,e,l),n(e,pt,l),U(Ue,e,l),n(e,ct,l),n(e,we,l),n(e,mt,l),n(e,be,l),n(e,Mt,l),U(L,e,l),n(e,dt,l),n(e,je,l),n(e,yt,l),n(e,F,l),n(e,ut,l),n(e,Ze,l),n(e,ht,l),U(ge,e,l),n(e,ft,l),n(e,Ge,l),n(e,Tt,l),U(ke,e,l),n(e,Jt,l),U(_e,e,l),n(e,Ut,l),n(e,We,l),wt=!0},p(e,[l]){const Et={};l&2&&(Et.$$scope={dirty:l,ctx:e}),C.$set(Et);const Qt={};l&2&&(Qt.$$scope={dirty:l,ctx:e}),N.$set(Qt);const At={};l&2&&(At.$$scope={dirty:l,ctx:e}),H.$set(At);const qt={};l&2&&(qt.$$scope={dirty:l,ctx:e}),S.$set(qt);const Lt={};l&2&&(Lt.$$scope={dirty:l,ctx:e}),x.$set(Lt);const Dt={};l&2&&(Dt.$$scope={dirty:l,ctx:e}),E.$set(Dt);const Pt={};l&2&&(Pt.$$scope={dirty:l,ctx:e}),Q.$set(Pt);const Kt={};l&2&&(Kt.$$scope={dirty:l,ctx:e}),A.$set(Kt);const Ot={};l&2&&(Ot.$$scope={dirty:l,ctx:e}),q.$set(Ot);const el={};l&2&&(el.$$scope={dirty:l,ctx:e}),L.$set(el)},i(e){wt||(w(o.$$.fragment,e),w(C.$$.fragment,e),w(I.$$.fragment,e),w(N.$$.fragment,e),w(H.$$.fragment,e),w(S.$$.fragment,e),w(te.$$.fragment,e),w(se.$$.fragment,e),w(x.$$.fragment,e),w(E.$$.fragment,e),w(Q.$$.fragment,e),w(ie.$$.fragment,e),w(A.$$.fragment,e),w(ce.$$.fragment,e),w(Me.$$.fragment,e),w(ue.$$.fragment,e),w(he.$$.fragment,e),w(q.$$.fragment,e),w(Je.$$.fragment,e),w(Ue.$$.fragment,e),w(L.$$.fragment,e),w(ge.$$.fragment,e),w(ke.$$.fragment,e),w(_e.$$.fragment,e),wt=!0)},o(e){b(o.$$.fragment,e),b(C.$$.fragment,e),b(I.$$.fragment,e),b(N.$$.fragment,e),b(H.$$.fragment,e),b(S.$$.fragment,e),b(te.$$.fragment,e),b(se.$$.fragment,e),b(x.$$.fragment,e),b(E.$$.fragment,e),b(Q.$$.fragment,e),b(ie.$$.fragment,e),b(A.$$.fragment,e),b(ce.$$.fragment,e),b(Me.$$.fragment,e),b(ue.$$.fragment,e),b(he.$$.fragment,e),b(q.$$.fragment,e),b(Je.$$.fragment,e),b(Ue.$$.fragment,e),b(L.$$.fragment,e),b(ge.$$.fragment,e),b(ke.$$.fragment,e),b(_e.$$.fragment,e),wt=!1},d(e){e&&(a(m),a(s),a(r),a(i),a(M),a(k),a(v),a(d),a(G),a(z),a(P),a(X),a(R),a(B),a(V),a($e),a(K),a(Ie),a(Xe),a(O),a(Re),a(ee),a(Ve),a(Fe),a(ze),a(Ye),a(le),a(Ne),a(He),a(Se),a(ae),a(xe),a(ne),a(Ee),a(Qe),a(oe),a(Ae),a(qe),a(Le),a(re),a(De),a(pe),a(Pe),a(Ke),a(Oe),a(me),a(et),a(tt),a(de),a(lt),a(ye),a(st),a(at),a(nt),a(fe),a(ot),a(it),a(Te),a(rt),a(pt),a(ct),a(we),a(mt),a(be),a(Mt),a(dt),a(je),a(yt),a(F),a(ut),a(Ze),a(ht),a(ft),a(Ge),a(Tt),a(Jt),a(Ut),a(We)),a(t),j(o,e),j(C,e),j(I,e),j(N,e),j(H,e),j(S,e),j(te,e),j(se,e),j(x,e),j(E,e),j(Q,e),j(ie,e),j(A,e),j(ce,e),j(Me,e),j(ue,e),j(he,e),j(q,e),j(Je,e),j(Ue,e),j(L,e),j(ge,e),j(ke,e),j(_e,e)}}}const _l='{"title":"Optimizing inference","local":"optimizing-inference","sections":[{"title":"Static kv-cache and torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"Decoding strategies","local":"decoding-strategies","sections":[{"title":"Speculative decoding","local":"speculative-decoding","sections":[],"depth":3},{"title":"Prompt lookup decoding","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"Attention","local":"attention","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"PyTorch scaled dot product attention","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function Bl(g){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends al{constructor(t){super(),nl(this,t,Bl,kl,tl,{})}}export{Rl as component};
