import{s as te,n as ee,o as le}from"../chunks/scheduler.8c3d61f6.js";import{S as oe,i as ae,g as s,s as a,r as d,A as ne,h as i,f as l,c as n,j as Kt,u as m,x as r,k as Ot,y as se,a as o,v as p,d as c,t as u,w as h}from"../chunks/index.da70eac4.js";import{C as S}from"../chunks/CodeBlock.a9c4becf.js";import{H as Gt,E as ie}from"../chunks/index.5d4ab994.js";function re(Rt){let f,D,A,P,y,K,M,xt='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch. It provides high-performance dtypes, optimization techniques, and kernels for inference and training, featuring composability with native PyTorch features like <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a>, FullyShardedDataParallel (FSDP), and more.',O,w,qt="Before you begin, make sure you have Pytorch 2.5+ and TorchAO installed.",tt,b,et,J,Ct='Quantize a model by passing <a href="/docs/diffusers/main/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',lt,T,Ft="The example below only quantizes the weights to int8.",ot,g,at,j,Bt='TorchAO is fully compatible with <a href="./optimization/torch2.0#torchcompile">torch.compile</a>, setting it apart from other quantization methods. This makes it easy to speed up inference with just one line of code.',nt,Z,st,U,Wt='For speed and memory benchmarks on Flux and CogVideoX, please refer to the table <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">here</a>. You can also find some torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> numbers for various hardware.',it,_,Xt='torchao also supports an automatic quantization API through <a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md#autoquantization" rel="nofollow">autoquant</a>. Autoquantization determines the best quantization strategy applicable to a model by comparing the performance of each technique on chosen input types and shapes. Currently, this can be used directly on the underlying modeling components. Diffusers will also expose an autoquant configuration option in the future.',rt,v,$t="The <code>TorchAoConfig</code> class accepts three parameters:",dt,I,Ht='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>’s first block, one would specify: <code>modules_to_not_convert=[&quot;single_transformer_blocks.0&quot;]</code>.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',mt,z,pt,G,kt="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",ct,R,Qt="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",ut,x,Vt="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",ht,q,Et="The quantization methods supported are as follows:",ft,C,Yt="<thead><tr><th><strong>Category</strong></th> <th><strong>Full Function Names</strong></th> <th><strong>Shorthands</strong></th></tr></thead> <tbody><tr><td><strong>Integer quantization</strong></td> <td><code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></td> <td><code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></td></tr> <tr><td><strong>Floating point 8-bit quantization</strong></td> <td><code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></td> <td><code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8_e4m3_tensor</code>, <code>float8_e4m3_row</code></td></tr> <tr><td><strong>Floating point X-bit quantization</strong></td> <td><code>fpx_weight_only</code></td> <td><code>fpX_eAwB</code> where <code>X</code> is the number of bits (1-7), <code>A</code> is exponent bits, and <code>B</code> is mantissa bits. Constraint: <code>X == A + B + 1</code></td></tr> <tr><td><strong>Unsigned Integer quantization</strong></td> <td><code>uintx_weight_only</code></td> <td><code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></td></tr></tbody>",yt,F,Nt="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",Mt,B,St="Refer to the official torchao documentation for a better understanding of the available quantization methods and the exhaustive list of configuration options available.",wt,W,bt,X,At='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',Jt,$,Tt,H,Lt='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',gt,k,jt,Q,Dt="If you are using <code>torch&lt;=2.6.0</code>, some quantization methods, such as <code>uint4wo</code>, cannot be loaded directly and may result in an <code>UnpicklingError</code> when trying to load the models, but work as expected when saving them. In order to work around this, one can load the state dict manually into the model. Note, however, that this requires using <code>weights_only=False</code> in <code>torch.load</code>, so it should be run only if the weights were obtained from a trustable source.",Zt,V,Ut,E,_t,Y,Pt='<li><a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',vt,N,It,L,zt;return y=new Gt({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),b=new S({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdG9yY2glMjB0b3JjaGFv",highlighted:"pip install -U torch torchao",wrap:!1}}),g=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFRvcmNoQW9Db25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyglMjJpbnQ4d28lMjIpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRGR0eXBlJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEZHR5cGUlMkMlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMFdpdGhvdXQlMjBxdWFudGl6YXRpb24lM0ElMjB+MzEuNDQ3JTIwR0IlMEElMjMlMjBXaXRoJTIwcXVhbnRpemF0aW9uJTNBJTIwfjIwLjQwJTIwR0IlMEFwcmludChmJTIyUGlwZWxpbmUlMjBtZW1vcnklMjB1c2FnZSUzQSUyMCU3QnRvcmNoLmN1ZGEubWF4X21lbW9yeV9yZXNlcnZlZCgpJTIwJTJGJTIwMTAyNCoqMyUzQS4zZiU3RCUyMEdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjUlMkMlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNENTEyJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel, TorchAoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = FluxPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Without quantization: ~31.447 GB</span>
<span class="hljs-comment"># With quantization: ~20.40 GB</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Pipeline memory usage: <span class="hljs-subst">{torch.cuda.max_memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.3</span>f}</span> GB&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),Z=new S({props:{code:"JTIzJTIwSW4lMjB0aGUlMjBhYm92ZSUyMGNvZGUlMkMlMjBhZGQlMjB0aGUlMjBmb2xsb3dpbmclMjBhZnRlciUyMGluaXRpYWxpemluZyUyMHRoZSUyMHRyYW5zZm9ybWVyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># In the above code, add the following after initializing the transformer</span>
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),z=new Gt({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),W=new Gt({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),$=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMFRvcmNoQW9Db25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyglMjJpbnQ4d28lMjIpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZsdXguMS1EZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEF0cmFuc2Zvcm1lci5zYXZlX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGZmx1eF9pbnQ4d28lMjIlMkMlMjBzYWZlX3NlcmlhbGl6YXRpb24lM0RGYWxzZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, TorchAoConfig

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),k=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGZmx1eF9pbnQ4d28lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNERmFsc2UpJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel

transformer = FluxTransformer2DModel.from_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, torch_dtype=torch.bfloat16, use_safetensors=<span class="hljs-literal">False</span>)
pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, guidance_scale=<span class="hljs-number">7.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),V=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMGluaXRfZW1wdHlfd2VpZ2h0cyUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4UGlwZWxpbmUlMkMlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQSUyMyUyMFNlcmlhbGl6ZSUyMHRoZSUyMG1vZGVsJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZsdXguMS1EZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RUb3JjaEFvQ29uZmlnKCUyMnVpbnQ0d28lMjIpJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEF0cmFuc2Zvcm1lci5zYXZlX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGZmx1eF91aW50NHdvJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2UlMkMlMjBtYXhfc2hhcmRfc2l6ZSUzRCUyMjUwR0IlMjIpJTBBJTIzJTIwLi4uJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMG1vZGVsJTBBc3RhdGVfZGljdCUyMCUzRCUyMHRvcmNoLmxvYWQoJTIyJTJGcGF0aCUyRnRvJTJGZmx1eF91aW50NHdvJTJGZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwd2VpZ2h0c19vbmx5JTNERmFsc2UlMkMlMjBtYXBfbG9jYXRpb24lM0QlMjJjcHUlMjIpJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fY29uZmlnKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmNvbmZpZy5qc29uJTIyKSUwQXRyYW5zZm9ybWVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEVHJ1ZSUyQyUyMGFzc2lnbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel, TorchAoConfig

<span class="hljs-comment"># Serialize the model</span>
transformer = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=TorchAoConfig(<span class="hljs-string">&quot;uint4wo&quot;</span>),
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_uint4wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>, max_shard_size=<span class="hljs-string">&quot;50GB&quot;</span>)
<span class="hljs-comment"># ...</span>

<span class="hljs-comment"># Load the model</span>
state_dict = torch.load(<span class="hljs-string">&quot;/path/to/flux_uint4wo/diffusion_pytorch_model.bin&quot;</span>, weights_only=<span class="hljs-literal">False</span>, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    transformer = FluxTransformer2DModel.from_config(<span class="hljs-string">&quot;/path/to/flux_uint4wo/config.json&quot;</span>)
transformer.load_state_dict(state_dict, strict=<span class="hljs-literal">True</span>, assign=<span class="hljs-literal">True</span>)`,wrap:!1}}),E=new Gt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),N=new ie({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){f=s("meta"),D=a(),A=s("p"),P=a(),d(y.$$.fragment),K=a(),M=s("p"),M.innerHTML=xt,O=a(),w=s("p"),w.textContent=qt,tt=a(),d(b.$$.fragment),et=a(),J=s("p"),J.innerHTML=Ct,lt=a(),T=s("p"),T.textContent=Ft,ot=a(),d(g.$$.fragment),at=a(),j=s("p"),j.innerHTML=Bt,nt=a(),d(Z.$$.fragment),st=a(),U=s("p"),U.innerHTML=Wt,it=a(),_=s("p"),_.innerHTML=Xt,rt=a(),v=s("p"),v.innerHTML=$t,dt=a(),I=s("ul"),I.innerHTML=Ht,mt=a(),d(z.$$.fragment),pt=a(),G=s("p"),G.textContent=kt,ct=a(),R=s("p"),R.innerHTML=Qt,ut=a(),x=s("p"),x.textContent=Vt,ht=a(),q=s("p"),q.textContent=Et,ft=a(),C=s("table"),C.innerHTML=Yt,yt=a(),F=s("p"),F.innerHTML=Nt,Mt=a(),B=s("p"),B.textContent=St,wt=a(),d(W.$$.fragment),bt=a(),X=s("p"),X.innerHTML=At,Jt=a(),d($.$$.fragment),Tt=a(),H=s("p"),H.innerHTML=Lt,gt=a(),d(k.$$.fragment),jt=a(),Q=s("p"),Q.innerHTML=Dt,Zt=a(),d(V.$$.fragment),Ut=a(),d(E.$$.fragment),_t=a(),Y=s("ul"),Y.innerHTML=Pt,vt=a(),d(N.$$.fragment),It=a(),L=s("p"),this.h()},l(t){const e=ne("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(l),D=n(t),A=i(t,"P",{}),Kt(A).forEach(l),P=n(t),m(y.$$.fragment,t),K=n(t),M=i(t,"P",{"data-svelte-h":!0}),r(M)!=="svelte-3zt1h"&&(M.innerHTML=xt),O=n(t),w=i(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-xmmcvn"&&(w.textContent=qt),tt=n(t),m(b.$$.fragment,t),et=n(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-17lo0nz"&&(J.innerHTML=Ct),lt=n(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1d14wga"&&(T.textContent=Ft),ot=n(t),m(g.$$.fragment,t),at=n(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1mb3hq5"&&(j.innerHTML=Bt),nt=n(t),m(Z.$$.fragment,t),st=n(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-exfnd4"&&(U.innerHTML=Wt),it=n(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1fx3nq1"&&(_.innerHTML=Xt),rt=n(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1eoai4f"&&(v.innerHTML=$t),dt=n(t),I=i(t,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1m2mgoz"&&(I.innerHTML=Ht),mt=n(t),m(z.$$.fragment,t),pt=n(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1dy3rwb"&&(G.textContent=kt),ct=n(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-17x1tdo"&&(R.innerHTML=Qt),ut=n(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1nbmql6"&&(x.textContent=Vt),ht=n(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-4xexxq"&&(q.textContent=Et),ft=n(t),C=i(t,"TABLE",{"data-svelte-h":!0}),r(C)!=="svelte-18shdov"&&(C.innerHTML=Yt),yt=n(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1r64eqr"&&(F.innerHTML=Nt),Mt=n(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9cn9y3"&&(B.textContent=St),wt=n(t),m(W.$$.fragment,t),bt=n(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-x34suv"&&(X.innerHTML=At),Jt=n(t),m($.$$.fragment,t),Tt=n(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1km1qu3"&&(H.innerHTML=Lt),gt=n(t),m(k.$$.fragment,t),jt=n(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1m61wn7"&&(Q.innerHTML=Dt),Zt=n(t),m(V.$$.fragment,t),Ut=n(t),m(E.$$.fragment,t),_t=n(t),Y=i(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-96lbpr"&&(Y.innerHTML=Pt),vt=n(t),m(N.$$.fragment,t),It=n(t),L=i(t,"P",{}),Kt(L).forEach(l),this.h()},h(){Ot(f,"name","hf:doc:metadata"),Ot(f,"content",de)},m(t,e){se(document.head,f),o(t,D,e),o(t,A,e),o(t,P,e),p(y,t,e),o(t,K,e),o(t,M,e),o(t,O,e),o(t,w,e),o(t,tt,e),p(b,t,e),o(t,et,e),o(t,J,e),o(t,lt,e),o(t,T,e),o(t,ot,e),p(g,t,e),o(t,at,e),o(t,j,e),o(t,nt,e),p(Z,t,e),o(t,st,e),o(t,U,e),o(t,it,e),o(t,_,e),o(t,rt,e),o(t,v,e),o(t,dt,e),o(t,I,e),o(t,mt,e),p(z,t,e),o(t,pt,e),o(t,G,e),o(t,ct,e),o(t,R,e),o(t,ut,e),o(t,x,e),o(t,ht,e),o(t,q,e),o(t,ft,e),o(t,C,e),o(t,yt,e),o(t,F,e),o(t,Mt,e),o(t,B,e),o(t,wt,e),p(W,t,e),o(t,bt,e),o(t,X,e),o(t,Jt,e),p($,t,e),o(t,Tt,e),o(t,H,e),o(t,gt,e),p(k,t,e),o(t,jt,e),o(t,Q,e),o(t,Zt,e),p(V,t,e),o(t,Ut,e),p(E,t,e),o(t,_t,e),o(t,Y,e),o(t,vt,e),p(N,t,e),o(t,It,e),o(t,L,e),zt=!0},p:ee,i(t){zt||(c(y.$$.fragment,t),c(b.$$.fragment,t),c(g.$$.fragment,t),c(Z.$$.fragment,t),c(z.$$.fragment,t),c(W.$$.fragment,t),c($.$$.fragment,t),c(k.$$.fragment,t),c(V.$$.fragment,t),c(E.$$.fragment,t),c(N.$$.fragment,t),zt=!0)},o(t){u(y.$$.fragment,t),u(b.$$.fragment,t),u(g.$$.fragment,t),u(Z.$$.fragment,t),u(z.$$.fragment,t),u(W.$$.fragment,t),u($.$$.fragment,t),u(k.$$.fragment,t),u(V.$$.fragment,t),u(E.$$.fragment,t),u(N.$$.fragment,t),zt=!1},d(t){t&&(l(D),l(A),l(P),l(K),l(M),l(O),l(w),l(tt),l(et),l(J),l(lt),l(T),l(ot),l(at),l(j),l(nt),l(st),l(U),l(it),l(_),l(rt),l(v),l(dt),l(I),l(mt),l(pt),l(G),l(ct),l(R),l(ut),l(x),l(ht),l(q),l(ft),l(C),l(yt),l(F),l(Mt),l(B),l(wt),l(bt),l(X),l(Jt),l(Tt),l(H),l(gt),l(jt),l(Q),l(Zt),l(Ut),l(_t),l(Y),l(vt),l(It),l(L)),l(f),h(y,t),h(b,t),h(g,t),h(Z,t),h(z,t),h(W,t),h($,t),h(k,t),h(V,t),h(E,t),h(N,t)}}}const de='{"title":"torchao","local":"torchao","sections":[{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function me(Rt){return le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fe extends oe{constructor(f){super(),ae(this,f,me,re,te,{})}}export{fe as component};
