import{s as $l,o as Hl,n as Ll}from"../chunks/scheduler.c59d9fbb.js";import{S as Kl,i as ql,g as w,s as a,r as T,A as Pl,h as j,f as s,c as n,j as kl,u as y,x as I,k as vl,y as lM,a as U,v as e,d as C,t as J,w as t}from"../chunks/index.a47918e3.js";import{T as MM}from"../chunks/Tip.3fcf4aa4.js";import{C as r}from"../chunks/CodeBlock.936db8cd.js";import{H as L}from"../chunks/Heading.604bc707.js";function sM(P){let i,A="Note that this trainer uses pairs between sentences as the training samples, so the number of training steps grows exponentially to the number of unlabeled examples. To avoid overfitting, consider setting <code>max_steps</code> relatively low.";return{c(){i=w("p"),i.innerHTML=A},l(p){i=j(p,"P",{"data-svelte-h":!0}),I(i)!=="svelte-1v3685y"&&(i.innerHTML=A)},m(p,K){U(p,i,K)},p:Ll,d(p){p&&s(i)}}}function UM(P){let i,A,p,K,m,ll,h,Yl="If you have access to unlabeled data, then you can use knowledge distillation to improve the performance of your small SetFit model. The approach involves training a larger model and using unlabeled data to distil its performance into your smaller SetFit model. As a result, your SetFit model will become stronger.",Ml,d,Zl="Additionally, you can also use knowledge distillation to replace your trained SetFit model with a more efficient model at less of a performance decrease.",sl,b,xl="This guide will show you how to proceed with knowledge distillation.",Ul,N,al,o,Wl='Let’s consider a scenario with a little bit of labeled training data (e.g. 64 sentences). We will simulate this scenario using the <a href="https://huggingface.co/datasets/ag_news" rel="nofollow">ag_news</a> dataset for this guide.',nl,O,Tl,u,yl,g,Dl="We can use standard SetFit training approach to prepare a model.",el,V,Cl,F,Jl,R,Gl="This model reaches 78.18% on our dataset. Certainly respectable given the tiny amount of training data, but we can use knowledge distillation to squeeze more performance out of our model.",tl,Y,il,Z,Ql="Alongside our labeled training data, we may als have a lot of unlabeled training data (e.g. 500 sentences). Let’s prepare it:",wl,x,jl,W,Il,D,Bl='Then, we will prepare a larger trained SetFit model that will act as the teacher to our smaller student model. The strong <a href="https://huggingface.co/sentence-transformers/paraphrase-mpnet-base-v2" rel="nofollow"><code>sentence-transformers/paraphrase-mpnet-base-v2</code></a> Sentence Transformer model will be used to initialize the SetFit model.',pl,G,rl,Q,fl="We need to train this model on the labeled dataset first:",cl,B,Al,f,ml,X,Xl="This large teacher model reaches 83.79%, which is quite strong for this little data, and noticeably, stronger than the 78.18% from our smaller (but more efficient) model.",hl,z,dl,E,zl='The performance from the stronger teacher_model can be distilled into the smaller model using the <a href="/docs/setfit/v1.0.1/en/reference/trainer#setfit.DistillationTrainer">DistillationTrainer</a>. It accepts a teacher and a student model, as well as an unlabeled dataset.',bl,c,Nl,_,ol,S,Ol,k,El="Using knowledge distillation, we were able to improve our model from 78.18% to 80.84% in a few minutes of training.",ul,v,gl,$,_l="This snippet shows the entire knowledge distillation strategy in an end-to-end example:",Vl,H,Fl,q,Rl;return m=new L({props:{title:"Knowledge Distillation",local:"knowledge-distillation",headingTag:"h1"}}),N=new L({props:{title:"Data preparation",local:"data-preparation",headingTag:"h2"}}),O=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBJTIzJTIwTG9hZCUyMGElMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhZ19uZXdzJTIyKSUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBzYW1wbGUlMjBmZXctc2hvdCUyMGRhdGFzZXQlMjB0byUyMHRyYWluJTIwd2l0aCUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBzYW1wbGVfZGF0YXNldChkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMjBsYWJlbF9jb2x1bW4lM0QlMjJsYWJlbCUyMiUyQyUyMG51bV9zYW1wbGVzJTNEMTYpJTBBJTIzJTIwRGF0YXNldCglN0IlMEElMjMlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid0ZXh0JyUyQyUyMCdsYWJlbCclNUQlMkMlMEElMjMlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDY0JTBBJTIzJTIwJTdEKSUwQSUwQSUyMyUyMERhdGFzZXQlMjBmb3IlMjBldmFsdWF0aW9uJTBBZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEElMjMlMjBEYXRhc2V0KCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNzYwMCUwQSUyMyUyMCU3RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;ag_news&quot;</span>)

<span class="hljs-comment"># Create a sample few-shot dataset to train with</span>
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">16</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 64</span>
<span class="hljs-comment"># })</span>

<span class="hljs-comment"># Dataset for evaluation</span>
eval_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 7600</span>
<span class="hljs-comment"># })</span>`,wrap:!1}}),u=new L({props:{title:"Baseline model",local:"baseline-model",headingTag:"h2"}}),V=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS1NaW5pTE0tTDMtdjIlMjIpJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMG51bV9lcG9jaHMlM0Q1JTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKSUwQSUwQW1ldHJpY3MlMjAlM0QlMjB0cmFpbmVyLmV2YWx1YXRlKCklMEFwcmludChtZXRyaWNzKQ==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, TrainingArguments, Trainer

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-MiniLM-L3-v2&quot;</span>)

args = TrainingArguments(
    batch_size=<span class="hljs-number">64</span>,
    num_epochs=<span class="hljs-number">5</span>,
)

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)
trainer.train()

metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),F=new r({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">48</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">5</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">240</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">64</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.4173</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">8.333333333333333e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1756</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.7592592592592595e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.04</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.119</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.2962962962962964e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.08</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0872</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">8.333333333333334e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">3.12</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0542</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.7037037037037037e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">4.17</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">26.0837</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">588.873</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">9.201</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">5.0</span>}                                                     
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">240</span>/<span class="hljs-number">240</span> [<span class="hljs-number">00</span>:<span class="hljs-number">20</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">11.</span>97it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.7818421052631579</span>}`,wrap:!1}}),Y=new L({props:{title:"Unlabeled Data Preparation",local:"unlabeled-data-preparation",headingTag:"h2"}}),x=new r({props:{code:"JTIzJTIwQ3JlYXRlJTIwYSUyMGRhdGFzZXQlMjBvZiUyMHVubGFiZWxlZCUyMGV4YW1wbGVzJTIwdG8lMjBwZXJmb3JtJTIwa25vd2xlZGdlJTIwZGlzdGlsbGF0aW9uJTBBdW5sYWJlbGVkX3RyYWluX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuc2h1ZmZsZShzZWVkJTNEMCkuc2VsZWN0KHJhbmdlKDUwMCkpJTBBdW5sYWJlbGVkX3RyYWluX2RhdGFzZXQlMjAlM0QlMjB1bmxhYmVsZWRfdHJhaW5fZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJsYWJlbCUyMiklMEElMjMlMjBEYXRhc2V0KCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTVEJTJDJTBBJTIzJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA1MDAlMEElMjMlMjAlN0Qp",highlighted:`<span class="hljs-comment"># Create a dataset of unlabeled examples to perform knowledge distillation</span>
unlabeled_train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">0</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">500</span>))
unlabeled_train_dataset = unlabeled_train_dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;],</span>
<span class="hljs-comment">#     num_rows: 500</span>
<span class="hljs-comment"># })</span>`,wrap:!1}}),W=new L({props:{title:"Teacher model",local:"teacher-model",headingTag:"h2"}}),G=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBdGVhY2hlcl9tb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMkZwYXJhcGhyYXNlLW1wbmV0LWJhc2UtdjIlMjIp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

teacher_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>)`,wrap:!1}}),B=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRlYWNoZXJfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMG51bV9lcG9jaHMlM0QyJTJDJTBBKSUwQSUwQXRlYWNoZXJfdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0R0ZWFjaGVyX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRlYWNoZXJfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQSUyMyUyMFRyYWluJTIwdGVhY2hlciUyMG1vZGVsJTBBdGVhY2hlcl90cmFpbmVyLnRyYWluKCklMEF0ZWFjaGVyX21ldHJpY3MlMjAlM0QlMjB0ZWFjaGVyX3RyYWluZXIuZXZhbHVhdGUoKSUwQXByaW50KHRlYWNoZXJfbWV0cmljcyk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments, Trainer

teacher_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    num_epochs=<span class="hljs-number">2</span>,
)

teacher_trainer = Trainer(
    model=teacher_model,
    args=teacher_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

<span class="hljs-comment"># Train teacher model</span>
teacher_trainer.train()
teacher_metrics = teacher_trainer.evaluate()
<span class="hljs-built_in">print</span>(teacher_metrics)`,wrap:!1}}),f=new r({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">192</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">2</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">384</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.4093</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">5.128205128205128e-07</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1087</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.9362318840579713e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.26</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.001</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.6463768115942028e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.52</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0006</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.3565217391304348e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.78</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0003</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.0666666666666667e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.04</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0004</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">7.768115942028987e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.3</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0002</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.869565217391305e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.56</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0003</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.9710144927536233e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.82</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">84.3703</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">72.822</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">4.551</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">2.0</span>}                                                      
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">384</span>/<span class="hljs-number">384</span> [<span class="hljs-number">01</span>:<span class="hljs-number">24</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">4.</span>55it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8378947368421052</span>}`,wrap:!1}}),z=new L({props:{title:"Knowledge Distillation",local:"knowledge-distillation",headingTag:"h2"}}),c=new MM({props:{warning:!0,$$slots:{default:[sM]},$$scope:{ctx:P}}}),_=new r({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMERpc3RpbGxhdGlvblRyYWluZXIlMEElMEFkaXN0aWxsYXRpb25fYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDUwMCUyQyUwQSklMEElMEFkaXN0aWxsYXRpb25fdHJhaW5lciUyMCUzRCUyMERpc3RpbGxhdGlvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdGVhY2hlcl9tb2RlbCUzRHRlYWNoZXJfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBzdHVkZW50X21vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEZGlzdGlsbGF0aW9uX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdW5sYWJlbGVkX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEEpJTBBJTIzJTIwVHJhaW4lMjBzdHVkZW50JTIwd2l0aCUyMGtub3dsZWRnZSUyMGRpc3RpbGxhdGlvbiUwQWRpc3RpbGxhdGlvbl90cmFpbmVyLnRyYWluKCklMEFkaXN0aWxsYXRpb25fbWV0cmljcyUyMCUzRCUyMGRpc3RpbGxhdGlvbl90cmFpbmVyLmV2YWx1YXRlKCklMEFwcmludChkaXN0aWxsYXRpb25fbWV0cmljcyk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> DistillationTrainer

distillation_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    max_steps=<span class="hljs-number">500</span>,
)

distillation_trainer = DistillationTrainer(
    teacher_model=teacher_model,
    student_model=model,
    args=distillation_args,
    train_dataset=unlabeled_train_dataset,
    eval_dataset=eval_dataset,
)
<span class="hljs-comment"># Train student with knowledge distillation</span>
distillation_trainer.train()
distillation_metrics = distillation_trainer.evaluate()
<span class="hljs-built_in">print</span>(distillation_metrics)`,wrap:!1}}),S=new r({props:{code:"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",highlighted:`***** Running training *****
  Num examples = <span class="hljs-number">7829</span>
  Num epochs = <span class="hljs-number">1</span>
  Total optimization steps = <span class="hljs-number">7829</span>
  Total train batch size = <span class="hljs-number">16</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.5048</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.554278416347382e-08</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.0</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.4514</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.277139208173691e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.33</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">2.554278416347382e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.01</span>}                                                                                    
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.1218</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.831417624521073e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0213</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">5.108556832694764e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.03</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.016</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">6.385696040868455e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.03</span>}                                                                                   
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0054</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">7.662835249042147e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.04</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0049</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">8.939974457215838e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.04</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.002</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.0217113665389528e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.05</span>}                                                                                  
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0019</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.1494252873563218e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.06</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0012</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">1.277139208173691e-05</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.06</span>}                                                                                  
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">22.2725</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">359.188</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">22.449</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.06</span>}                                                   
<span class="hljs-number">100</span>%|███████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">500</span>/<span class="hljs-number">500</span> [<span class="hljs-number">00</span>:<span class="hljs-number">22</span>&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>, <span class="hljs-number">22.45</span>it/s] 
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8084210526315789</span>}`,wrap:!1}}),v=new L({props:{title:"End-to-end",local:"end-to-end",headingTag:"h2"}}),H=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

<span class="hljs-comment"># Load a dataset from the Hugging Face Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;ag_news&quot;</span>)

<span class="hljs-comment"># Create a sample few-shot dataset to train with</span>
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">16</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 64</span>
<span class="hljs-comment"># })</span>

<span class="hljs-comment"># Dataset for evaluation</span>
eval_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 7600</span>
<span class="hljs-comment"># })</span>

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, TrainingArguments, Trainer

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-MiniLM-L3-v2&quot;</span>)

args = TrainingArguments(
    batch_size=<span class="hljs-number">64</span>,
    num_epochs=<span class="hljs-number">5</span>,
)

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)
trainer.train()

metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)

<span class="hljs-comment"># Create a dataset of unlabeled examples to perform knowledge distillation</span>
unlabeled_train_dataset = dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">0</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">500</span>))
unlabeled_train_dataset = unlabeled_train_dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-comment"># Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;],</span>
<span class="hljs-comment">#     num_rows: 500</span>
<span class="hljs-comment"># })</span>

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

teacher_model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;sentence-transformers/paraphrase-mpnet-base-v2&quot;</span>)

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments, Trainer

teacher_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    num_epochs=<span class="hljs-number">2</span>,
)

teacher_trainer = Trainer(
    model=teacher_model,
    args=teacher_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

<span class="hljs-comment"># Train teacher model</span>
teacher_trainer.train()
teacher_metrics = teacher_trainer.evaluate()
<span class="hljs-built_in">print</span>(teacher_metrics)

<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> DistillationTrainer

distillation_args = TrainingArguments(
    batch_size=<span class="hljs-number">16</span>,
    max_steps=<span class="hljs-number">500</span>,
)

distillation_trainer = DistillationTrainer(
    teacher_model=teacher_model,
    student_model=model,
    args=distillation_args,
    train_dataset=unlabeled_train_dataset,
    eval_dataset=eval_dataset,
)
<span class="hljs-comment"># Train student with knowledge distillation</span>
distillation_trainer.train()
distillation_metrics = distillation_trainer.evaluate()
<span class="hljs-built_in">print</span>(distillation_metrics)`,wrap:!1}}),{c(){i=w("meta"),A=a(),p=w("p"),K=a(),T(m.$$.fragment),ll=a(),h=w("p"),h.textContent=Yl,Ml=a(),d=w("p"),d.textContent=Zl,sl=a(),b=w("p"),b.textContent=xl,Ul=a(),T(N.$$.fragment),al=a(),o=w("p"),o.innerHTML=Wl,nl=a(),T(O.$$.fragment),Tl=a(),T(u.$$.fragment),yl=a(),g=w("p"),g.textContent=Dl,el=a(),T(V.$$.fragment),Cl=a(),T(F.$$.fragment),Jl=a(),R=w("p"),R.textContent=Gl,tl=a(),T(Y.$$.fragment),il=a(),Z=w("p"),Z.textContent=Ql,wl=a(),T(x.$$.fragment),jl=a(),T(W.$$.fragment),Il=a(),D=w("p"),D.innerHTML=Bl,pl=a(),T(G.$$.fragment),rl=a(),Q=w("p"),Q.textContent=fl,cl=a(),T(B.$$.fragment),Al=a(),T(f.$$.fragment),ml=a(),X=w("p"),X.textContent=Xl,hl=a(),T(z.$$.fragment),dl=a(),E=w("p"),E.innerHTML=zl,bl=a(),T(c.$$.fragment),Nl=a(),T(_.$$.fragment),ol=a(),T(S.$$.fragment),Ol=a(),k=w("p"),k.textContent=El,ul=a(),T(v.$$.fragment),gl=a(),$=w("p"),$.textContent=_l,Vl=a(),T(H.$$.fragment),Fl=a(),q=w("p"),this.h()},l(l){const M=Pl("svelte-u9bgzb",document.head);i=j(M,"META",{name:!0,content:!0}),M.forEach(s),A=n(l),p=j(l,"P",{}),kl(p).forEach(s),K=n(l),y(m.$$.fragment,l),ll=n(l),h=j(l,"P",{"data-svelte-h":!0}),I(h)!=="svelte-1iaeqif"&&(h.textContent=Yl),Ml=n(l),d=j(l,"P",{"data-svelte-h":!0}),I(d)!=="svelte-19socj4"&&(d.textContent=Zl),sl=n(l),b=j(l,"P",{"data-svelte-h":!0}),I(b)!=="svelte-1dkdhtd"&&(b.textContent=xl),Ul=n(l),y(N.$$.fragment,l),al=n(l),o=j(l,"P",{"data-svelte-h":!0}),I(o)!=="svelte-1ggqf13"&&(o.innerHTML=Wl),nl=n(l),y(O.$$.fragment,l),Tl=n(l),y(u.$$.fragment,l),yl=n(l),g=j(l,"P",{"data-svelte-h":!0}),I(g)!=="svelte-1avn12v"&&(g.textContent=Dl),el=n(l),y(V.$$.fragment,l),Cl=n(l),y(F.$$.fragment,l),Jl=n(l),R=j(l,"P",{"data-svelte-h":!0}),I(R)!=="svelte-ewavsy"&&(R.textContent=Gl),tl=n(l),y(Y.$$.fragment,l),il=n(l),Z=j(l,"P",{"data-svelte-h":!0}),I(Z)!=="svelte-lgbx2q"&&(Z.textContent=Ql),wl=n(l),y(x.$$.fragment,l),jl=n(l),y(W.$$.fragment,l),Il=n(l),D=j(l,"P",{"data-svelte-h":!0}),I(D)!=="svelte-1yw0yn"&&(D.innerHTML=Bl),pl=n(l),y(G.$$.fragment,l),rl=n(l),Q=j(l,"P",{"data-svelte-h":!0}),I(Q)!=="svelte-1t1w4v"&&(Q.textContent=fl),cl=n(l),y(B.$$.fragment,l),Al=n(l),y(f.$$.fragment,l),ml=n(l),X=j(l,"P",{"data-svelte-h":!0}),I(X)!=="svelte-1tfc559"&&(X.textContent=Xl),hl=n(l),y(z.$$.fragment,l),dl=n(l),E=j(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-1fbwdcc"&&(E.innerHTML=zl),bl=n(l),y(c.$$.fragment,l),Nl=n(l),y(_.$$.fragment,l),ol=n(l),y(S.$$.fragment,l),Ol=n(l),k=j(l,"P",{"data-svelte-h":!0}),I(k)!=="svelte-1mlr23c"&&(k.textContent=El),ul=n(l),y(v.$$.fragment,l),gl=n(l),$=j(l,"P",{"data-svelte-h":!0}),I($)!=="svelte-jbt54l"&&($.textContent=_l),Vl=n(l),y(H.$$.fragment,l),Fl=n(l),q=j(l,"P",{}),kl(q).forEach(s),this.h()},h(){vl(i,"name","hf:doc:metadata"),vl(i,"content",aM)},m(l,M){lM(document.head,i),U(l,A,M),U(l,p,M),U(l,K,M),e(m,l,M),U(l,ll,M),U(l,h,M),U(l,Ml,M),U(l,d,M),U(l,sl,M),U(l,b,M),U(l,Ul,M),e(N,l,M),U(l,al,M),U(l,o,M),U(l,nl,M),e(O,l,M),U(l,Tl,M),e(u,l,M),U(l,yl,M),U(l,g,M),U(l,el,M),e(V,l,M),U(l,Cl,M),e(F,l,M),U(l,Jl,M),U(l,R,M),U(l,tl,M),e(Y,l,M),U(l,il,M),U(l,Z,M),U(l,wl,M),e(x,l,M),U(l,jl,M),e(W,l,M),U(l,Il,M),U(l,D,M),U(l,pl,M),e(G,l,M),U(l,rl,M),U(l,Q,M),U(l,cl,M),e(B,l,M),U(l,Al,M),e(f,l,M),U(l,ml,M),U(l,X,M),U(l,hl,M),e(z,l,M),U(l,dl,M),U(l,E,M),U(l,bl,M),e(c,l,M),U(l,Nl,M),e(_,l,M),U(l,ol,M),e(S,l,M),U(l,Ol,M),U(l,k,M),U(l,ul,M),e(v,l,M),U(l,gl,M),U(l,$,M),U(l,Vl,M),e(H,l,M),U(l,Fl,M),U(l,q,M),Rl=!0},p(l,[M]){const Sl={};M&2&&(Sl.$$scope={dirty:M,ctx:l}),c.$set(Sl)},i(l){Rl||(C(m.$$.fragment,l),C(N.$$.fragment,l),C(O.$$.fragment,l),C(u.$$.fragment,l),C(V.$$.fragment,l),C(F.$$.fragment,l),C(Y.$$.fragment,l),C(x.$$.fragment,l),C(W.$$.fragment,l),C(G.$$.fragment,l),C(B.$$.fragment,l),C(f.$$.fragment,l),C(z.$$.fragment,l),C(c.$$.fragment,l),C(_.$$.fragment,l),C(S.$$.fragment,l),C(v.$$.fragment,l),C(H.$$.fragment,l),Rl=!0)},o(l){J(m.$$.fragment,l),J(N.$$.fragment,l),J(O.$$.fragment,l),J(u.$$.fragment,l),J(V.$$.fragment,l),J(F.$$.fragment,l),J(Y.$$.fragment,l),J(x.$$.fragment,l),J(W.$$.fragment,l),J(G.$$.fragment,l),J(B.$$.fragment,l),J(f.$$.fragment,l),J(z.$$.fragment,l),J(c.$$.fragment,l),J(_.$$.fragment,l),J(S.$$.fragment,l),J(v.$$.fragment,l),J(H.$$.fragment,l),Rl=!1},d(l){l&&(s(A),s(p),s(K),s(ll),s(h),s(Ml),s(d),s(sl),s(b),s(Ul),s(al),s(o),s(nl),s(Tl),s(yl),s(g),s(el),s(Cl),s(Jl),s(R),s(tl),s(il),s(Z),s(wl),s(jl),s(Il),s(D),s(pl),s(rl),s(Q),s(cl),s(Al),s(ml),s(X),s(hl),s(dl),s(E),s(bl),s(Nl),s(ol),s(Ol),s(k),s(ul),s(gl),s($),s(Vl),s(Fl),s(q)),s(i),t(m,l),t(N,l),t(O,l),t(u,l),t(V,l),t(F,l),t(Y,l),t(x,l),t(W,l),t(G,l),t(B,l),t(f,l),t(z,l),t(c,l),t(_,l),t(S,l),t(v,l),t(H,l)}}}const aM='{"title":"Knowledge Distillation","local":"knowledge-distillation","sections":[{"title":"Data preparation","local":"data-preparation","sections":[],"depth":2},{"title":"Baseline model","local":"baseline-model","sections":[],"depth":2},{"title":"Unlabeled Data Preparation","local":"unlabeled-data-preparation","sections":[],"depth":2},{"title":"Teacher model","local":"teacher-model","sections":[],"depth":2},{"title":"Knowledge Distillation","local":"knowledge-distillation","sections":[],"depth":2},{"title":"End-to-end","local":"end-to-end","sections":[],"depth":2}],"depth":1}';function nM(P){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tM extends Kl{constructor(i){super(),ql(this,i,nM,UM,$l,{})}}export{tM as component};
