import{s as Gt,o as Wt,n as k}from"../chunks/scheduler.8c3d61f6.js";import{S as Vt,i as kt,g as p,s as a,r as f,A as Xt,h as r,f as t,c as i,j as vt,u as M,x as m,k as Ct,y as Rt,a as s,v as u,d as y,t as h,w}from"../chunks/index.da70eac4.js";import{T as V}from"../chunks/Tip.1d9b8c37.js";import{C as j}from"../chunks/CodeBlock.a9c4becf.js";import{H as Z,E as Yt}from"../chunks/index.5d4ab994.js";function $t(U){let n,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=p("p"),n.innerHTML=J},l(o){n=r(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-15lbm2y"&&(n.innerHTML=J)},m(o,c){s(o,n,c)},p:k,d(o){o&&t(n)}}}function St(U){let n,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=p("p"),n.innerHTML=J},l(o){n=r(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1yyrc0t"&&(n.innerHTML=J)},m(o,c){s(o,n,c)},p:k,d(o){o&&t(n)}}}function Nt(U){let n,J='When using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',o,c,T='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=p("p"),n.innerHTML=J,o=a(),c=p("p"),c.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-pysjic"&&(n.innerHTML=J),o=i(d),c=r(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1zrt6x"&&(c.innerHTML=T)},m(d,b){s(d,n,b),s(d,o,b),s(d,c,b)},p:k,d(d){d&&(t(n),t(o),t(c))}}}function xt(U){let n,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=p("p"),n.textContent=J},l(o){n=r(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-1guxtqy"&&(n.textContent=J)},m(o,c){s(o,n,c)},p:k,d(o){o&&t(n)}}}function Et(U){let n,J='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',o,c,T='<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=p("p"),n.innerHTML=J,o=a(),c=p("p"),c.innerHTML=T},l(d){n=r(d,"P",{"data-svelte-h":!0}),m(n)!=="svelte-bljvwk"&&(n.innerHTML=J),o=i(d),c=r(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-1rrcfel"&&(c.innerHTML=T)},m(d,b){s(d,n,b),s(d,o,b),s(d,c,b)},p:k,d(d){d&&(t(n),t(o),t(c))}}}function Ht(U){let n,J='<li>Group offloading may not work with all models out-of-the-box. If the forward implementations of the model contain weight-dependent device-casting of inputs, it may clash with the offloading mechanism’s handling of device-casting.</li> <li>The <code>offload_type</code> parameter can be set to either <code>block_level</code> or <code>leaf_level</code>. <code>block_level</code> offloads groups of <code>torch::nn::ModuleList</code> or <code>torch::nn:Sequential</code> modules based on a configurable attribute <code>num_blocks_per_group</code>. For example, if you set <code>num_blocks_per_group=2</code> on a standard transformer model containing 40 layers, it will onload/offload 2 layers at a time for a total of 20 onload/offloads. This drastically reduces the VRAM requirements. <code>leaf_level</code> offloads individual layers at the lowest level, which is equivalent to sequential offloading. However, unlike sequential offloading, group offloading can be made much faster when using streams, with minimal compromise to end-to-end generation time.</li> <li>The <code>use_stream</code> parameter can be used with CUDA devices to enable prefetching layers for onload. It defaults to <code>False</code>. Layer prefetching allows overlapping computation and data transfer of model weights, which drastically reduces the overall execution time compared to other offloading methods. However, it can increase the CPU RAM usage significantly. Ensure that available CPU RAM that is at least twice the size of the model when setting <code>use_stream=True</code>. You can find more information about CUDA streams <a href="https://pytorch.org/docs/stable/generated/torch.cuda.Stream.html" rel="nofollow">here</a></li> <li>If specifying <code>use_stream=True</code> on VAEs with tiling enabled, make sure to do a dummy forward pass (possibly with dummy inputs) before the actual inference to avoid device-mismatch errors. This may not work on all implementations. Please open an issue if you encounter any problems.</li> <li>The parameter <code>low_cpu_mem_usage</code> can be set to <code>True</code> to reduce CPU memory usage when using streams for group offloading. This is useful when the CPU memory is the bottleneck, but it may counteract the benefits of using streams and increase the overall execution time. The CPU memory savings come from creating pinned-tensors on-the-fly instead of pre-pinning them. This parameter is better suited for using <code>leaf_level</code> offloading.</li> <li>When using <code>use_stream=True</code>, users can additionally specify <code>record_stream=True</code> to get better speedups at the expense of slightly increased memory usage. Refer to the <a href="https://pytorch.org/docs/stable/generated/torch.Tensor.record_stream.html" rel="nofollow">official PyTorch docs</a> to know more about this.</li>',o,c,T='For more information about available parameters and an explanation of how group offloading works, refer to <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a>.';return{c(){n=p("ul"),n.innerHTML=J,o=a(),c=p("p"),c.innerHTML=T},l(d){n=r(d,"UL",{"data-svelte-h":!0}),m(n)!=="svelte-15p4zc8"&&(n.innerHTML=J),o=i(d),c=r(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-2l3fe1"&&(c.innerHTML=T)},m(d,b){s(d,n,b),s(d,o,b),s(d,c,b)},p:k,d(d){d&&(t(n),t(o),t(c))}}}function Qt(U){let n,J='<li>Layerwise casting may not work with all models out-of-the-box. Sometimes, the forward implementations of the model might contain internal typecasting of weight values. Such implementations are not supported due to the currently simplistic implementation of layerwise casting, which assumes that the forward pass is independent of the weight precision and that the input dtypes are always in <code>compute_dtype</code>. An example of an incompatible implementation can be found <a href="https://github.com/huggingface/transformers/blob/7f5077e53682ca855afc826162b204ebf809f1f9/src/transformers/models/t5/modeling_t5.py#L294-L299" rel="nofollow">here</a>.</li> <li>Layerwise casting may fail on custom modeling implementations that make use of <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> layers. Some minimal checks to handle this case is implemented but is not extensively tested or guaranteed to work in all cases.</li> <li>It can be also be applied partially to specific layers of a model. Partially applying layerwise casting can either be done manually by calling the <code>apply_layerwise_casting</code> function on specific internal modules, or by specifying the <code>skip_modules_pattern</code> and <code>skip_modules_classes</code> parameters for a root module. These parameters are particularly useful for layers such as normalization and modulation.</li>';return{c(){n=p("ul"),n.innerHTML=J},l(o){n=r(o,"UL",{"data-svelte-h":!0}),m(n)!=="svelte-1gstadw"&&(n.innerHTML=J)},m(o,c){s(o,n,c)},p:k,d(o){o&&t(n)}}}function Ft(U){let n,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=p("p"),n.innerHTML=J},l(o){n=r(o,"P",{"data-svelte-h":!0}),m(n)!=="svelte-17vr965"&&(n.innerHTML=J)},m(o,c){s(o,n,c)},p:k,d(o){o&&t(n)}}}function zt(U){let n,J,o,c,T,d,b,El="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",ke,g,Xe,X,Hl="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",Re,R,Ql="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Ye,Y,$e,$,Fl='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Se,S,zl='To use sliced VAE, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',Ne,N,xe,x,Al="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",Ee,E,He,H,ql='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',Qe,Q,Ll='To use tiled VAE processing, call <a href="/docs/diffusers/main/en/api/pipelines/latent_consistency_models#diffusers.LatentConsistencyModelPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Fe,F,ze,z,Pl="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Ae,A,qe,q,Dl="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Le,L,Kl='To perform CPU offloading, call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',Pe,P,De,D,Ol="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Ke,B,Oe,I,el,K,ll,_,tl,O,et='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',sl,ee,lt="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",nl,le,tt=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,al,te,st='Enable model offloading by calling <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',il,se,ol,v,pl,ne,rl,ae,nt="Group offloading is the middle ground between sequential and model offloading. It works by offloading groups of internal layers (either <code>torch.nn.ModuleList</code> or <code>torch.nn.Sequential</code>), which uses less memory than model-level offloading. It is also faster than sequential-level offloading because the number of device synchronizations is reduced.",ml,ie,at='To enable group offloading, call the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_group_offload">enable_group_offload()</a> method on the model if it is a Diffusers model implementation. For any other model implementation, use <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a>:',cl,oe,dl,pe,it="Group offloading (for CUDA devices with support for asynchronous data transfer streams) overlaps data transfer and computation to reduce the overall execution time compared to sequential offloading. This is enabled using layer prefetching with CUDA streams. The next layer to be executed is loaded onto the accelerator device while the current layer is being executed - this increases the memory requirements slightly. Group offloading also supports leaf-level offloading (equivalent to sequential CPU offloading) but can be made much faster when using streams.",fl,C,Ml,re,ul,me,ot="PyTorch supports <code>torch.float8_e4m3fn</code> and <code>torch.float8_e5m2</code> as weight storage dtypes, but they can’t be used for computation in many different tensor operations due to unimplemented kernel support. However, you can use these dtypes to store model weights in fp8 precision and upcast them on-the-fly when the layers are used in the forward pass. This is known as layerwise weight-casting.",yl,ce,pt="Typically, inference on most models is done with <code>torch.float16</code> or <code>torch.bfloat16</code> weight/computation precision. Layerwise weight-casting cuts down the memory footprint of the model weights by approximately half.",hl,de,wl,fe,rt="In the above example, layerwise casting is enabled on the transformer component of the pipeline. By default, certain layers are skipped from the FP8 weight casting because it can lead to significant degradation of generation quality. The normalization and modulation related weight parameters are also skipped by default.",Jl,Me,mt='However, you gain more control and flexibility by directly utilizing the <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_layerwise_casting">apply_layerwise_casting()</a> function instead of <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_layerwise_casting">enable_layerwise_casting()</a>.',bl,G,Ul,ue,Tl,ye,ct="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",jl,he,dt="For example, to set the pipeline’s UNet to use the channels-last format:",Zl,we,gl,Je,Bl,be,ft="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",Il,Ue,Mt="To trace a UNet:",_l,Te,vl,je,ut="Replace the <code>unet</code> attribute of the pipeline with the traced model:",Cl,Ze,Gl,ge,Wl,Be,yt='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',Vl,W,kl,Ie,ht="To use Flash Attention, install the following:",Xl,_e,wt='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',Rl,ve,Jt='Then call <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',Yl,Ce,$l,Ge,bt='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',Sl,We,Nl,Ve,xl;return T=new Z({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),g=new V({props:{$$slots:{default:[$t]},$$scope:{ctx:U}}}),Y=new Z({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),N=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUyM3BpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKCklMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAzMikuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),E=new Z({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),F=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBiZWF1dGlmdWwlMjBsYW5kc2NhcGUlMjBwaG90b2dyYXBoJTIyJTBBcGlwZS5lbmFibGVfdmFlX3RpbGluZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglNUJwcm9tcHQlNUQlMkMlMjB3aWR0aCUzRDM4NDAlMkMlMjBoZWlnaHQlM0QyMjI0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new Z({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),P=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),B=new V({props:{$$slots:{default:[St]},$$scope:{ctx:U}}}),I=new V({props:{warning:!0,$$slots:{default:[Nt]},$$scope:{ctx:U}}}),K=new Z({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),_=new V({props:{$$slots:{default:[xt]},$$scope:{ctx:U}}}),se=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),v=new V({props:{warning:!0,$$slots:{default:[Et]},$$scope:{ctx:U}}}),ne=new Z({props:{title:"Group offloading",local:"group-offloading",headingTag:"h2"}}),oe=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-comment"># Load the pipeline</span>
onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
pipe = CogVideoXPipeline.from_pretrained(<span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># We can utilize the enable_group_offload method for Diffusers model implementations</span>
pipe.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>, use_stream=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Uncomment the following to also allow recording the current streams.</span>
<span class="hljs-comment"># pipe.transformer.enable_group_offload(onload_device=onload_device, offload_device=offload_device, offload_type=&quot;leaf_level&quot;, use_stream=True, record_stream=True)</span>

<span class="hljs-comment"># For any other model implementations, the apply_group_offloading function can be used</span>
apply_group_offloading(pipe.text_encoder, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;block_level&quot;</span>, num_blocks_per_group=<span class="hljs-number">2</span>)
apply_group_offloading(pipe.vae, onload_device=onload_device, offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-comment"># This utilized about 14.79 GB. It can be further reduced by using tiling and using leaf_level offloading throughout the pipeline.</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory reserved: <span class="hljs-subst">{torch.cuda.max_memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),C=new V({props:{$$slots:{default:[Ht]},$$scope:{ctx:U}}}),re=new Z({props:{title:"FP8 layerwise weight-casting",local:"fp8-layerwise-weight-casting",headingTag:"h2"}}),de=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXPipeline, CogVideoXTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

model_id = <span class="hljs-string">&quot;THUDM/CogVideoX-5b&quot;</span>

<span class="hljs-comment"># Load the model in bfloat16 and enable layerwise casting</span>
transformer = CogVideoXTransformer3DModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16)
transformer.enable_layerwise_casting(storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)

<span class="hljs-comment"># Load the pipeline</span>
pipe = CogVideoXPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = (
    <span class="hljs-string">&quot;A panda, dressed in a small, red jacket and a tiny hat, sits on a wooden stool in a serene bamboo forest. &quot;</span>
    <span class="hljs-string">&quot;The panda&#x27;s fluffy paws strum a miniature acoustic guitar, producing soft, melodic tunes. Nearby, a few other &quot;</span>
    <span class="hljs-string">&quot;pandas gather, watching curiously and some clapping in rhythm. Sunlight filters through the tall bamboo, &quot;</span>
    <span class="hljs-string">&quot;casting a gentle glow on the scene. The panda&#x27;s face is expressive, showing concentration and joy as it plays. &quot;</span>
    <span class="hljs-string">&quot;The background includes a small, flowing stream and vibrant green foliage, enhancing the peaceful and magical &quot;</span>
    <span class="hljs-string">&quot;atmosphere of this unique musical performance.&quot;</span>
)
video = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">6</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),G=new V({props:{$$slots:{default:[Qt]},$$scope:{ctx:U}}}),ue=new Z({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),we=new j({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),Je=new Z({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),Te=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),Ze=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLlRlbnNvciUwQSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjB1c2UlMjBqaXR0ZWQlMjB1bmV0JTBBdW5ldF90cmFjZWQlMjAlM0QlMjB0b3JjaC5qaXQubG9hZCglMjJ1bmV0X3RyYWNlZC5wdCUyMiklMEElMEElMEElMjMlMjBkZWwlMjBwaXBlLnVuZXQlMEFjbGFzcyUyMFRyYWNlZFVOZXQodG9yY2gubm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbl9jaGFubmVscyUyMCUzRCUyMHBpcGUudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRldmljZSUyMCUzRCUyMHBpcGUudW5ldC5kZXZpY2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHVuZXRfdHJhY2VkKGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFVOZXQyRENvbmRpdGlvbk91dHB1dChzYW1wbGUlM0RzYW1wbGUpJTBBJTBBJTBBcGlwZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.Tensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ge=new Z({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),W=new V({props:{$$slots:{default:[Ft]},$$scope:{ctx:U}}}),Ce=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwc2FtcGxlJTIwJTNEJTIwcGlwZSglMjJhJTIwc21hbGwlMjBjYXQlMjIpJTBBJTBBJTIzJTIwb3B0aW9uYWwlM0ElMjBZb3UlMjBjYW4lMjBkaXNhYmxlJTIwaXQlMjB2aWElMEElMjMlMjBwaXBlLmRpc2FibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),We=new Yt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/memory.md"}}),{c(){n=p("meta"),J=a(),o=p("p"),c=a(),f(T.$$.fragment),d=a(),b=p("p"),b.textContent=El,ke=a(),f(g.$$.fragment),Xe=a(),X=p("p"),X.textContent=Hl,Re=a(),R=p("table"),R.innerHTML=Ql,Ye=a(),f(Y.$$.fragment),$e=a(),$=p("p"),$.innerHTML=Fl,Se=a(),S=p("p"),S.innerHTML=zl,Ne=a(),f(N.$$.fragment),xe=a(),x=p("p"),x.textContent=Al,Ee=a(),f(E.$$.fragment),He=a(),H=p("p"),H.innerHTML=ql,Qe=a(),Q=p("p"),Q.innerHTML=Ll,Fe=a(),f(F.$$.fragment),ze=a(),z=p("p"),z.textContent=Pl,Ae=a(),f(A.$$.fragment),qe=a(),q=p("p"),q.textContent=Dl,Le=a(),L=p("p"),L.innerHTML=Kl,Pe=a(),f(P.$$.fragment),De=a(),D=p("p"),D.innerHTML=Ol,Ke=a(),f(B.$$.fragment),Oe=a(),f(I.$$.fragment),el=a(),f(K.$$.fragment),ll=a(),f(_.$$.fragment),tl=a(),O=p("p"),O.innerHTML=et,sl=a(),ee=p("p"),ee.innerHTML=lt,nl=a(),le=p("p"),le.textContent=tt,al=a(),te=p("p"),te.innerHTML=st,il=a(),f(se.$$.fragment),ol=a(),f(v.$$.fragment),pl=a(),f(ne.$$.fragment),rl=a(),ae=p("p"),ae.innerHTML=nt,ml=a(),ie=p("p"),ie.innerHTML=at,cl=a(),f(oe.$$.fragment),dl=a(),pe=p("p"),pe.textContent=it,fl=a(),f(C.$$.fragment),Ml=a(),f(re.$$.fragment),ul=a(),me=p("p"),me.innerHTML=ot,yl=a(),ce=p("p"),ce.innerHTML=pt,hl=a(),f(de.$$.fragment),wl=a(),fe=p("p"),fe.textContent=rt,Jl=a(),Me=p("p"),Me.innerHTML=mt,bl=a(),f(G.$$.fragment),Ul=a(),f(ue.$$.fragment),Tl=a(),ye=p("p"),ye.textContent=ct,jl=a(),he=p("p"),he.textContent=dt,Zl=a(),f(we.$$.fragment),gl=a(),f(Je.$$.fragment),Bl=a(),be=p("p"),be.innerHTML=ft,Il=a(),Ue=p("p"),Ue.textContent=Mt,_l=a(),f(Te.$$.fragment),vl=a(),je=p("p"),je.innerHTML=ut,Cl=a(),f(Ze.$$.fragment),Gl=a(),f(ge.$$.fragment),Wl=a(),Be=p("p"),Be.innerHTML=yt,Vl=a(),f(W.$$.fragment),kl=a(),Ie=p("p"),Ie.textContent=ht,Xl=a(),_e=p("ul"),_e.innerHTML=wt,Rl=a(),ve=p("p"),ve.innerHTML=Jt,Yl=a(),f(Ce.$$.fragment),$l=a(),Ge=p("p"),Ge.innerHTML=bt,Sl=a(),f(We.$$.fragment),Nl=a(),Ve=p("p"),this.h()},l(e){const l=Xt("svelte-u9bgzb",document.head);n=r(l,"META",{name:!0,content:!0}),l.forEach(t),J=i(e),o=r(e,"P",{}),vt(o).forEach(t),c=i(e),M(T.$$.fragment,e),d=i(e),b=r(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-18ag1qn"&&(b.textContent=El),ke=i(e),M(g.$$.fragment,e),Xe=i(e),X=r(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1nfsyhf"&&(X.textContent=Hl),Re=i(e),R=r(e,"TABLE",{"data-svelte-h":!0}),m(R)!=="svelte-qiiy0g"&&(R.innerHTML=Ql),Ye=i(e),M(Y.$$.fragment,e),$e=i(e),$=r(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-g37v30"&&($.innerHTML=Fl),Se=i(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1nl6cpr"&&(S.innerHTML=zl),Ne=i(e),M(N.$$.fragment,e),xe=i(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-fte8mn"&&(x.textContent=Al),Ee=i(e),M(E.$$.fragment,e),He=i(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1g0rx31"&&(H.innerHTML=ql),Qe=i(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1yciusa"&&(Q.innerHTML=Ll),Fe=i(e),M(F.$$.fragment,e),ze=i(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-nyzaca"&&(z.textContent=Pl),Ae=i(e),M(A.$$.fragment,e),qe=i(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-435lli"&&(q.textContent=Dl),Le=i(e),L=r(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-z49dor"&&(L.innerHTML=Kl),Pe=i(e),M(P.$$.fragment,e),De=i(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-153k8wf"&&(D.innerHTML=Ol),Ke=i(e),M(B.$$.fragment,e),Oe=i(e),M(I.$$.fragment,e),el=i(e),M(K.$$.fragment,e),ll=i(e),M(_.$$.fragment,e),tl=i(e),O=r(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1w0xgx8"&&(O.innerHTML=et),sl=i(e),ee=r(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-nislc4"&&(ee.innerHTML=lt),nl=i(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-11gjm3"&&(le.textContent=tt),al=i(e),te=r(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-op610o"&&(te.innerHTML=st),il=i(e),M(se.$$.fragment,e),ol=i(e),M(v.$$.fragment,e),pl=i(e),M(ne.$$.fragment,e),rl=i(e),ae=r(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-n1o14o"&&(ae.innerHTML=nt),ml=i(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1pf7o6v"&&(ie.innerHTML=at),cl=i(e),M(oe.$$.fragment,e),dl=i(e),pe=r(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-fe960w"&&(pe.textContent=it),fl=i(e),M(C.$$.fragment,e),Ml=i(e),M(re.$$.fragment,e),ul=i(e),me=r(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-lwtukj"&&(me.innerHTML=ot),yl=i(e),ce=r(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-r2gdi7"&&(ce.innerHTML=pt),hl=i(e),M(de.$$.fragment,e),wl=i(e),fe=r(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-lgt48u"&&(fe.textContent=rt),Jl=i(e),Me=r(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1fq2kcg"&&(Me.innerHTML=mt),bl=i(e),M(G.$$.fragment,e),Ul=i(e),M(ue.$$.fragment,e),Tl=i(e),ye=r(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-sky5la"&&(ye.textContent=ct),jl=i(e),he=r(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-mhdc10"&&(he.textContent=dt),Zl=i(e),M(we.$$.fragment,e),gl=i(e),M(Je.$$.fragment,e),Bl=i(e),be=r(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1hj6sqj"&&(be.innerHTML=ft),Il=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1ca1ko1"&&(Ue.textContent=Mt),_l=i(e),M(Te.$$.fragment,e),vl=i(e),je=r(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-mpebhd"&&(je.innerHTML=ut),Cl=i(e),M(Ze.$$.fragment,e),Gl=i(e),M(ge.$$.fragment,e),Wl=i(e),Be=r(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1tu2ji2"&&(Be.innerHTML=yt),Vl=i(e),M(W.$$.fragment,e),kl=i(e),Ie=r(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-rpfoyf"&&(Ie.textContent=ht),Xl=i(e),_e=r(e,"UL",{"data-svelte-h":!0}),m(_e)!=="svelte-1q6gndt"&&(_e.innerHTML=wt),Rl=i(e),ve=r(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-141yc6t"&&(ve.innerHTML=Jt),Yl=i(e),M(Ce.$$.fragment,e),$l=i(e),Ge=r(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1nf2kxh"&&(Ge.innerHTML=bt),Sl=i(e),M(We.$$.fragment,e),Nl=i(e),Ve=r(e,"P",{}),vt(Ve).forEach(t),this.h()},h(){Ct(n,"name","hf:doc:metadata"),Ct(n,"content",At)},m(e,l){Rt(document.head,n),s(e,J,l),s(e,o,l),s(e,c,l),u(T,e,l),s(e,d,l),s(e,b,l),s(e,ke,l),u(g,e,l),s(e,Xe,l),s(e,X,l),s(e,Re,l),s(e,R,l),s(e,Ye,l),u(Y,e,l),s(e,$e,l),s(e,$,l),s(e,Se,l),s(e,S,l),s(e,Ne,l),u(N,e,l),s(e,xe,l),s(e,x,l),s(e,Ee,l),u(E,e,l),s(e,He,l),s(e,H,l),s(e,Qe,l),s(e,Q,l),s(e,Fe,l),u(F,e,l),s(e,ze,l),s(e,z,l),s(e,Ae,l),u(A,e,l),s(e,qe,l),s(e,q,l),s(e,Le,l),s(e,L,l),s(e,Pe,l),u(P,e,l),s(e,De,l),s(e,D,l),s(e,Ke,l),u(B,e,l),s(e,Oe,l),u(I,e,l),s(e,el,l),u(K,e,l),s(e,ll,l),u(_,e,l),s(e,tl,l),s(e,O,l),s(e,sl,l),s(e,ee,l),s(e,nl,l),s(e,le,l),s(e,al,l),s(e,te,l),s(e,il,l),u(se,e,l),s(e,ol,l),u(v,e,l),s(e,pl,l),u(ne,e,l),s(e,rl,l),s(e,ae,l),s(e,ml,l),s(e,ie,l),s(e,cl,l),u(oe,e,l),s(e,dl,l),s(e,pe,l),s(e,fl,l),u(C,e,l),s(e,Ml,l),u(re,e,l),s(e,ul,l),s(e,me,l),s(e,yl,l),s(e,ce,l),s(e,hl,l),u(de,e,l),s(e,wl,l),s(e,fe,l),s(e,Jl,l),s(e,Me,l),s(e,bl,l),u(G,e,l),s(e,Ul,l),u(ue,e,l),s(e,Tl,l),s(e,ye,l),s(e,jl,l),s(e,he,l),s(e,Zl,l),u(we,e,l),s(e,gl,l),u(Je,e,l),s(e,Bl,l),s(e,be,l),s(e,Il,l),s(e,Ue,l),s(e,_l,l),u(Te,e,l),s(e,vl,l),s(e,je,l),s(e,Cl,l),u(Ze,e,l),s(e,Gl,l),u(ge,e,l),s(e,Wl,l),s(e,Be,l),s(e,Vl,l),u(W,e,l),s(e,kl,l),s(e,Ie,l),s(e,Xl,l),s(e,_e,l),s(e,Rl,l),s(e,ve,l),s(e,Yl,l),u(Ce,e,l),s(e,$l,l),s(e,Ge,l),s(e,Sl,l),u(We,e,l),s(e,Nl,l),s(e,Ve,l),xl=!0},p(e,[l]){const Ut={};l&2&&(Ut.$$scope={dirty:l,ctx:e}),g.$set(Ut);const Tt={};l&2&&(Tt.$$scope={dirty:l,ctx:e}),B.$set(Tt);const jt={};l&2&&(jt.$$scope={dirty:l,ctx:e}),I.$set(jt);const Zt={};l&2&&(Zt.$$scope={dirty:l,ctx:e}),_.$set(Zt);const gt={};l&2&&(gt.$$scope={dirty:l,ctx:e}),v.$set(gt);const Bt={};l&2&&(Bt.$$scope={dirty:l,ctx:e}),C.$set(Bt);const It={};l&2&&(It.$$scope={dirty:l,ctx:e}),G.$set(It);const _t={};l&2&&(_t.$$scope={dirty:l,ctx:e}),W.$set(_t)},i(e){xl||(y(T.$$.fragment,e),y(g.$$.fragment,e),y(Y.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(A.$$.fragment,e),y(P.$$.fragment,e),y(B.$$.fragment,e),y(I.$$.fragment,e),y(K.$$.fragment,e),y(_.$$.fragment,e),y(se.$$.fragment,e),y(v.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(C.$$.fragment,e),y(re.$$.fragment,e),y(de.$$.fragment,e),y(G.$$.fragment,e),y(ue.$$.fragment,e),y(we.$$.fragment,e),y(Je.$$.fragment,e),y(Te.$$.fragment,e),y(Ze.$$.fragment,e),y(ge.$$.fragment,e),y(W.$$.fragment,e),y(Ce.$$.fragment,e),y(We.$$.fragment,e),xl=!0)},o(e){h(T.$$.fragment,e),h(g.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(K.$$.fragment,e),h(_.$$.fragment,e),h(se.$$.fragment,e),h(v.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(C.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(G.$$.fragment,e),h(ue.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(Te.$$.fragment,e),h(Ze.$$.fragment,e),h(ge.$$.fragment,e),h(W.$$.fragment,e),h(Ce.$$.fragment,e),h(We.$$.fragment,e),xl=!1},d(e){e&&(t(J),t(o),t(c),t(d),t(b),t(ke),t(Xe),t(X),t(Re),t(R),t(Ye),t($e),t($),t(Se),t(S),t(Ne),t(xe),t(x),t(Ee),t(He),t(H),t(Qe),t(Q),t(Fe),t(ze),t(z),t(Ae),t(qe),t(q),t(Le),t(L),t(Pe),t(De),t(D),t(Ke),t(Oe),t(el),t(ll),t(tl),t(O),t(sl),t(ee),t(nl),t(le),t(al),t(te),t(il),t(ol),t(pl),t(rl),t(ae),t(ml),t(ie),t(cl),t(dl),t(pe),t(fl),t(Ml),t(ul),t(me),t(yl),t(ce),t(hl),t(wl),t(fe),t(Jl),t(Me),t(bl),t(Ul),t(Tl),t(ye),t(jl),t(he),t(Zl),t(gl),t(Bl),t(be),t(Il),t(Ue),t(_l),t(vl),t(je),t(Cl),t(Gl),t(Wl),t(Be),t(Vl),t(kl),t(Ie),t(Xl),t(_e),t(Rl),t(ve),t(Yl),t($l),t(Ge),t(Sl),t(Nl),t(Ve)),t(n),w(T,e),w(g,e),w(Y,e),w(N,e),w(E,e),w(F,e),w(A,e),w(P,e),w(B,e),w(I,e),w(K,e),w(_,e),w(se,e),w(v,e),w(ne,e),w(oe,e),w(C,e),w(re,e),w(de,e),w(G,e),w(ue,e),w(we,e),w(Je,e),w(Te,e),w(Ze,e),w(ge,e),w(W,e),w(Ce,e),w(We,e)}}}const At='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Group offloading","local":"group-offloading","sections":[],"depth":2},{"title":"FP8 layerwise weight-casting","local":"fp8-layerwise-weight-casting","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function qt(U){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Vt{constructor(n){super(),kt(this,n,qt,zt,Gt,{})}}export{es as component};
