import{s as ni,o as ii,n as at}from"../chunks/scheduler.8c3d61f6.js";import{S as ai,i as si,g as f,s as a,r as l,A as oi,h as u,f as n,c as s,j as Le,u as r,x as h,k as Y,y as w,a as i,v as p,d,t as c,w as m}from"../chunks/index.da70eac4.js";import{T as yn}from"../chunks/Tip.1d9b8c37.js";import{D as it}from"../chunks/Docstring.6b390b9a.js";import{C as T}from"../chunks/CodeBlock.00a903b3.js";import{E as li}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as _,E as ri}from"../chunks/EditOnGithub.1e64e623.js";function pi(Z){let o,M="The SD3 pipeline uses three text encoders to generate an image. Model offloading is necessary in order for it to run on most commodity hardware. Please use the <code>torch.float16</code> data type for additional memory savings.";return{c(){o=f("p"),o.innerHTML=M},l(g){o=u(g,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1abcova"&&(o.innerHTML=M)},m(g,y){i(g,o,y)},p:at,d(g){g&&n(o)}}}function di(Z){let o,M='Check out <a href="../../../using-diffusers/ip_adapter">IP-Adapter</a> to learn more about how IP-Adapters work.';return{c(){o=f("p"),o.innerHTML=M},l(g){o=u(g,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1xq17cf"&&(o.innerHTML=M)},m(g,y){i(g,o,y)},p:at,d(g){g&&n(o)}}}function ci(Z){let o,M="The prompt with the CLIP Text Encoders is still truncated to the 77 token limit.";return{c(){o=f("p"),o.textContent=M},l(g){o=u(g,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1pfxyog"&&(o.textContent=M)},m(g,y){i(g,o,y)},p:at,d(g){g&&n(o)}}}function mi(Z){let o,M="The following example loads a checkpoint stored in a 8-bit floating point format which requires PyTorch 2.3 or later.";return{c(){o=f("p"),o.textContent=M},l(g){o=u(g,"P",{"data-svelte-h":!0}),h(o)!=="svelte-msx2hu"&&(o.textContent=M)},m(g,y){i(g,o,y)},p:at,d(g){g&&n(o)}}}function fi(Z){let o,M="Examples:",g,y,j;return y=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){o=f("p"),o.textContent=M,g=a(),l(y.$$.fragment)},l(b){o=u(b,"P",{"data-svelte-h":!0}),h(o)!=="svelte-kvfsh7"&&(o.textContent=M),g=s(b),r(y.$$.fragment,b)},m(b,I){i(b,o,I),i(b,g,I),p(y,b,I),j=!0},p:at,i(b){j||(d(y.$$.fragment,b),j=!0)},o(b){c(y.$$.fragment,b),j=!1},d(b){b&&(n(o),n(g)),m(y,b)}}}function ui(Z){let o,M,g,y,j,b,I,In='Stable Diffusion 3 (SD3) was proposed in <a href="https://arxiv.org/pdf/2403.03206.pdf" rel="nofollow">Scaling Rectified Flow Transformers for High-Resolution Image Synthesis</a> by Patrick Esser, Sumith Kulal, Andreas Blattmann, Rahim Entezari, Jonas Muller, Harry Saini, Yam Levi, Dominik Lorenz, Axel Sauer, Frederic Boesel, Dustin Podell, Tim Dockhorn, Zion English, Kyle Lacey, Alex Goodwin, Yannik Marek, and Robin Rombach.',st,V,vn="The abstract from the paper is:",ot,z,Bn="<em>Diffusion models create data from noise by inverting the forward paths of data towards noise and have emerged as a powerful generative modeling technique for high-dimensional, perceptual data such as images and videos. Rectified flow is a recent generative model formulation that connects data and noise in a straight line. Despite its better theoretical properties and conceptual simplicity, it is not yet decisively established as standard practice. In this work, we improve existing noise sampling techniques for training rectified flow models by biasing them towards perceptually relevant scales. Through a large-scale study, we demonstrate the superior performance of this approach compared to established diffusion formulations for high-resolution text-to-image synthesis. Additionally, we present a novel transformer-based architecture for text-to-image generation that uses separate weights for the two modalities and enables a bidirectional flow of information between image and text tokens, improving text comprehension typography, and human preference ratings. We demonstrate that this architecture follows predictable scaling trends and correlates lower validation loss to improved text-to-image synthesis as measured by various metrics and human evaluations.</em>",lt,N,rt,E,Gn='<em>As the model is gated, before using it with diffusers you first need to go to the <a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow">Stable Diffusion 3 Medium Hugging Face page</a>, fill in the form and accept the gate. Once you are in, you need to login so that your system knows you’ve accepted the gate.</em>',pt,D,Wn="Use the command below to log in:",dt,Q,ct,k,mt,H,ft,F,kn="<strong>Note:</strong> Stable Diffusion 3.5 can also be run using the SD3 pipeline, and all mentioned optimizations and techniques apply to it as well. In total there are three official models in the SD3 family:",ut,P,xn='<li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-medium-diffusers" rel="nofollow"><code>stabilityai/stable-diffusion-3-medium-diffusers</code></a></li> <li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-5-large" rel="nofollow"><code>stabilityai/stable-diffusion-3.5-large</code></a></li> <li><a href="https://huggingface.co/stabilityai/stable-diffusion-3-5-large-turbo" rel="nofollow"><code>stabilityai/stable-diffusion-3.5-large-turbo</code></a></li>',gt,L,ht,A,$n="An IP-Adapter lets you prompt SD3 with images, in addition to the text prompt. This is especially useful when describing complex concepts that are difficult to articulate through text alone and you have reference images. To load and use an IP-Adapter, you need:",yt,q,Sn="<li><code>image_encoder</code>: Pre-trained vision model used to obtain image features, usually a CLIP image encoder.</li> <li><code>feature_extractor</code>: Image processor that prepares the input image for the chosen <code>image_encoder</code>.</li> <li><code>ip_adapter_id</code>: Checkpoint containing parameters of image cross attention layers and image projection.</li>",Mt,K,Cn="IP-Adapters are trained for a specific model architecture, so they also work in finetuned variations of the base model. You can use the <code>~SD3IPAdapterMixin.set_ip_adapter_scale</code> function to adjust how strongly the output aligns with the image prompt. The higher the value, the more closely the model follows the image prompt. A default value of 0.5 is typically a good balance, ensuring the model considers both the text and image prompts equally.",bt,O,_t,x,Rn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd3_ip_adapter_example.png"/> <figcaption class="mt-2 text-sm text-center text-gray-500">IP-Adapter examples with prompt &quot;a cat&quot;</figcaption>',wt,$,Tt,ee,Jt,te,Xn="SD3 uses three text encoders, one of which is the very large T5-XXL model. This makes it challenging to run the model on GPUs with less than 24GB of VRAM, even when using <code>fp16</code> precision. The following section outlines a few memory optimizations in Diffusers that make it easier to run SD3 on low resource hardware.",Ut,ne,Zt,ie,Yn="The most basic memory optimization available in Diffusers allows you to offload the components of the model to CPU during inference in order to save memory, while seeing a slight increase in inference latency. Model offloading will only move a model component onto the GPU when it needs to be executed, while keeping the remaining components on the CPU.",jt,ae,It,se,vt,oe,Vn="Removing the memory-intensive 4.7B parameter T5-XXL text encoder during inference can significantly decrease the memory requirements for SD3 with only a slight loss in performance.",Bt,le,Gt,re,Wt,pe,zn="We can leverage the <code>bitsandbytes</code> library to load and quantize the T5-XXL text encoder to 8-bit precision. This allows you to keep using all three text encoders while only slightly impacting performance.",kt,de,Nn="First install the <code>bitsandbytes</code> library.",xt,ce,$t,me,En="Then load the T5-XXL model using the <code>BitsAndBytesConfig</code>.",St,fe,Ct,ue,Dn='You can find the end-to-end script <a href="https://gist.github.com/sayakpaul/82acb5976509851f2db1a83456e504f1" rel="nofollow">here</a>.',Rt,ge,Xt,he,Yt,ye,Qn="Using compiled components in the SD3 pipeline can speed up inference by as much as 4X. The following code snippet demonstrates how to compile the Transformer and VAE components of the SD3 pipeline.",Vt,Me,zt,be,Hn='Check out the full script <a href="https://gist.github.com/sayakpaul/508d89d7aad4f454900813da5d42ca97" rel="nofollow">here</a>.',Nt,_e,Et,we,Fn="By default, the T5 Text Encoder prompt uses a maximum sequence length of <code>256</code>. This can be adjusted by setting the <code>max_sequence_length</code> to accept fewer or more tokens. Keep in mind that longer sequences require additional resources and result in longer generation times, such as during batch inference.",Dt,Te,Qt,Je,Ht,Ue,Pn="You can send a different prompt to the CLIP Text Encoders and the T5 Text Encoder to prevent the prompt from being truncated by the CLIP Text Encoders and to improve generation.",Ft,S,Pt,Ze,Lt,je,At,Ie,Ln='Tiny AutoEncoder for Stable Diffusion (TAESD3) is a tiny distilled version of Stable Diffusion 3’s VAE by <a href="https://github.com/madebyollin/taesd" rel="nofollow">Ollin Boer Bohan</a> that can decode <a href="/docs/diffusers/v0.32.1/en/api/pipelines/stable_diffusion/stable_diffusion_3#diffusers.StableDiffusion3Pipeline">StableDiffusion3Pipeline</a> latents almost instantly.',qt,ve,An="To use with Stable Diffusion 3:",Kt,Be,Ot,Ge,en,We,qn="The <code>SD3Transformer2DModel</code> and <code>StableDiffusion3Pipeline</code> classes support loading the original checkpoints via the <code>from_single_file</code> method. This method allows you to load the original checkpoint files that were used to train the models.",tn,ke,nn,xe,an,$e,sn,Se,on,Ce,ln,Re,rn,C,pn,Xe,dn,Ye,cn,Ve,mn,ze,fn,J,Ne,Mn,v,Ee,bn,Ae,Kn="Function invoked when calling the pipeline for generation.",_n,R,wn,X,De,Tn,qe,On="Encodes the given image into a feature representation using a pre-trained image encoder.",Jn,Ke,Qe,Un,B,He,Zn,Oe,ei="Prepares image embeddings for use in the IP-Adapter.",jn,et,ti="Either <code>ip_adapter_image</code> or <code>ip_adapter_image_embeds</code> must be passed.",un,Fe,gn,tt,hn;return j=new _({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h1"}}),N=new _({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),Q=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),k=new yn({props:{$$slots:{default:[pi]},$$scope:{ctx:Z}}}),H=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),L=new _({props:{title:"Image Prompting with IP-Adapters",local:"image-prompting-with-ip-adapters",headingTag:"h2"}}),O=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNpZ2xpcFZpc2lvbk1vZGVsJTJDJTIwU2lnbGlwSW1hZ2VQcm9jZXNzb3IlMEElMEFpbWFnZV9lbmNvZGVyX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGc2lnbGlwLXNvNDAwbS1wYXRjaDE0LTM4NCUyMiUwQWlwX2FkYXB0ZXJfaWQlMjAlM0QlMjAlMjJJbnN0YW50WCUyRlNEMy41LUxhcmdlLUlQLUFkYXB0ZXIlMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMFNpZ2xpcEltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyX2lkJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBTaWdsaXBWaXNpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2Rlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIwJTIyY3VkYSUyMiklMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy41LWxhcmdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlM0RpbWFnZV9lbmNvZGVyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGUubG9hZF9pcF9hZGFwdGVyKGlwX2FkYXB0ZXJfaWQpJTBBcGlwZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBJTBBcmVmX2ltZyUyMCUzRCUyMEltYWdlLm9wZW4oJTIyaW1hZ2UuanBnJTIyKS5jb252ZXJ0KCdSR0InKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMGNhdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGxvdyUyMHF1YWxpdHklMkMlMjB3b3JzdCUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDUuMCUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RyZWZfaW1nJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJyZXN1bHQuanBnJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SiglipVisionModel, SiglipImageProcessor

image_encoder_id = <span class="hljs-string">&quot;google/siglip-so400m-patch14-384&quot;</span>
ip_adapter_id = <span class="hljs-string">&quot;InstantX/SD3.5-Large-IP-Adapter&quot;</span>

feature_extractor = SiglipImageProcessor.from_pretrained(
    image_encoder_id,
    torch_dtype=torch.float16
)
image_encoder = SiglipVisionModel.from_pretrained(
    image_encoder_id,
    torch_dtype=torch.float16
).to( <span class="hljs-string">&quot;cuda&quot;</span>)

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    torch_dtype=torch.float16,
    feature_extractor=feature_extractor,
    image_encoder=image_encoder,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_ip_adapter(ip_adapter_id)
pipe.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

ref_img = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;image.jpg&quot;</span>).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)

image = pipe(
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    prompt=<span class="hljs-string">&quot;a cat&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;lowres, low quality, worst quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">24</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
    ip_adapter_image=ref_img
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;result.jpg&quot;</span>)`,wrap:!1}}),$=new yn({props:{$$slots:{default:[di]},$$scope:{ctx:Z}}}),ee=new _({props:{title:"Memory Optimisations for SD3",local:"memory-optimisations-for-sd3",headingTag:"h2"}}),ne=new _({props:{title:"Running Inference with Model Offloading",local:"running-inference-with-model-offloading",headingTag:"h3"}}),ae=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16)
pipe.enable_model_cpu_offload()

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),se=new _({props:{title:"Dropping the T5 Text Encoder during Inference",local:"dropping-the-t5-text-encoder-during-inference",headingTag:"h3"}}),le=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplcl8zJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMGhvbGRpbmclMjBhJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwaGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyOCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLW5vLVQ1LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    text_encoder_3=<span class="hljs-literal">None</span>,
    tokenizer_3=<span class="hljs-literal">None</span>,
    torch_dtype=torch.float16
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-no-T5.png&quot;</span>)`,wrap:!1}}),re=new _({props:{title:"Using a Quantized Version of the T5 Text Encoder",local:"using-a-quantized-version-of-the-t5-text-encoder",headingTag:"h3"}}),ce=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),fe=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1RW5jb2Rlck1vZGVsJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUwQXRleHRfZW5jb2RlciUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8zJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMyUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjJzZDNfaGVsbG9fd29ybGQtOGJpdC1UNS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;text_encoder_3&quot;</span>,
    quantization_config=quantization_config,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    model_id,
    text_encoder_3=text_encoder,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    torch_dtype=torch.float16
)

image = pipe(
    prompt=<span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    guidance_scale=<span class="hljs-number">7.0</span>,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;sd3_hello_world-8bit-T5.png&quot;</span>)`,wrap:!1}}),ge=new _({props:{title:"Performance Optimizations for SD3",local:"performance-optimizations-for-sd3",headingTag:"h2"}}),he=new _({props:{title:"Using Torch Compile to Speed Up Inference",local:"using-torch-compile-to-speed-up-inference",headingTag:"h3"}}),Me=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdG9yY2guc2V0X2Zsb2F0MzJfbWF0bXVsX3ByZWNpc2lvbiglMjJoaWdoJTIyKSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0tZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2V0X3Byb2dyZXNzX2Jhcl9jb25maWcoZGlzYWJsZSUzRFRydWUpJTBBJTBBcGlwZS50cmFuc2Zvcm1lci50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlLnZhZS50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEElMEFwaXBlLnRyYW5zZm9ybWVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBcGlwZS52YWUuZGVjb2RlJTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnZhZS5kZWNvZGUlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEElMjMlMjBXYXJtJTIwVXAlMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMF8lMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDEpKSUwQSUwQSUyMyUyMFJ1biUyMEluZmVyZW5jZSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgxKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzX2hlbGxvX3dvcmxkLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

torch.set_float32_matmul_precision(<span class="hljs-string">&quot;high&quot;</span>)

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.set_progress_bar_config(disable=<span class="hljs-literal">True</span>)

pipe.transformer.to(memory_format=torch.channels_last)
pipe.vae.to(memory_format=torch.channels_last)

pipe.transformer = torch.<span class="hljs-built_in">compile</span>(pipe.transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipe.vae.decode = torch.<span class="hljs-built_in">compile</span>(pipe.vae.decode, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Warm Up</span>
prompt = <span class="hljs-string">&quot;a photo of a cat holding a sign that says hello world&quot;</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    _ = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>))

<span class="hljs-comment"># Run Inference</span>
image = pipe(prompt=prompt, generator=torch.manual_seed(<span class="hljs-number">1</span>)).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd3_hello_world.png&quot;</span>)`,wrap:!1}}),_e=new _({props:{title:"Using Long Prompts with the T5 Text Encoder",local:"using-long-prompts-with-the-t5-text-encoder",headingTag:"h2"}}),Te=new T({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdoaW1zaWNhbCUyMGFuZCUyMGNyZWF0aXZlJTIwaW1hZ2UlMjBkZXBpY3RpbmclMjBhJTIwaHlicmlkJTIwY3JlYXR1cmUlMjB0aGF0JTIwaXMlMjBhJTIwbWl4JTIwb2YlMjBhJTIwd2FmZmxlJTIwYW5kJTIwYSUyMGhpcHBvcG90YW11cyUyQyUyMGJhc2tpbmclMjBpbiUyMGElMjByaXZlciUyMG9mJTIwbWVsdGVkJTIwYnV0dGVyJTIwYW1pZHN0JTIwYSUyMGJyZWFrZmFzdC10aGVtZWQlMjBsYW5kc2NhcGUuJTIwSXQlMjBmZWF0dXJlcyUyMHRoZSUyMGRpc3RpbmN0aXZlJTJDJTIwYnVsa3klMjBib2R5JTIwc2hhcGUlMjBvZiUyMGElMjBoaXBwby4lMjBIb3dldmVyJTJDJTIwaW5zdGVhZCUyMG9mJTIwdGhlJTIwdXN1YWwlMjBncmV5JTIwc2tpbiUyQyUyMHRoZSUyMGNyZWF0dXJlJUUyJTgwJTk5cyUyMGJvZHklMjByZXNlbWJsZXMlMjBhJTIwZ29sZGVuLWJyb3duJTJDJTIwY3Jpc3B5JTIwd2FmZmxlJTIwZnJlc2glMjBvZmYlMjB0aGUlMjBncmlkZGxlLiUyMFRoZSUyMHNraW4lMjBpcyUyMHRleHR1cmVkJTIwd2l0aCUyMHRoZSUyMGZhbWlsaWFyJTIwZ3JpZCUyMHBhdHRlcm4lMjBvZiUyMGElMjB3YWZmbGUlMkMlMjBlYWNoJTIwc3F1YXJlJTIwZmlsbGVkJTIwd2l0aCUyMGElMjBnbGlzdGVuaW5nJTIwc2hlZW4lMjBvZiUyMHN5cnVwLiUyMFRoZSUyMGVudmlyb25tZW50JTIwY29tYmluZXMlMjB0aGUlMjBuYXR1cmFsJTIwaGFiaXRhdCUyMG9mJTIwYSUyMGhpcHBvJTIwd2l0aCUyMGVsZW1lbnRzJTIwb2YlMjBhJTIwYnJlYWtmYXN0JTIwdGFibGUlMjBzZXR0aW5nJTJDJTIwYSUyMHJpdmVyJTIwb2YlMjB3YXJtJTJDJTIwbWVsdGVkJTIwYnV0dGVyJTJDJTIwd2l0aCUyMG92ZXJzaXplZCUyMHV0ZW5zaWxzJTIwb3IlMjBwbGF0ZXMlMjBwZWVraW5nJTIwb3V0JTIwZnJvbSUyMHRoZSUyMGx1c2glMkMlMjBwYW5jYWtlLWxpa2UlMjBmb2xpYWdlJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kJTJDJTIwYSUyMHRvd2VyaW5nJTIwcGVwcGVyJTIwbWlsbCUyMHN0YW5kaW5nJTIwaW4lMjBmb3IlMjBhJTIwdHJlZS4lMjAlMjBBcyUyMHRoZSUyMHN1biUyMHJpc2VzJTIwaW4lMjB0aGlzJTIwZmFudGFzdGljYWwlMjB3b3JsZCUyQyUyMGl0JTIwY2FzdHMlMjBhJTIwd2FybSUyQyUyMGJ1dHRlcnklMjBnbG93JTIwb3ZlciUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMGNyZWF0dXJlJTJDJTIwY29udGVudCUyMGluJTIwaXRzJTIwYnV0dGVyJTIwcml2ZXIlMkMlMjBsZXRzJTIwb3V0JTIwYSUyMHlhd24uJTIwTmVhcmJ5JTJDJTIwYSUyMGZsb2NrJTIwb2YlMjBiaXJkcyUyMHRha2UlMjBmbGlnaHQlMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI4JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjUlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNENTEyJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Je=new _({props:{title:"Sending a different prompt to the T5 Text Encoder",local:"sending-a-different-prompt-to-the-t5-text-encoder",headingTag:"h3"}}),S=new yn({props:{$$slots:{default:[ci]},$$scope:{ctx:Z}}}),Ze=new T({props:{code:"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",highlighted:`prompt = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. A river of warm, melted butter, pancake-like foliage in the background, a towering pepper mill standing in for a tree.&quot;</span>

prompt_3 = <span class="hljs-string">&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus, basking in a river of melted butter amidst a breakfast-themed landscape. It features the distinctive, bulky body shape of a hippo. However, instead of the usual grey skin, the creature’s body resembles a golden-brown, crispy waffle fresh off the griddle. The skin is textured with the familiar grid pattern of a waffle, each square filled with a glistening sheen of syrup. The environment combines the natural habitat of a hippo with elements of a breakfast table setting, a river of warm, melted butter, with oversized utensils or plates peeking out from the lush, pancake-like foliage in the background, a towering pepper mill standing in for a tree.  As the sun rises in this fantastical world, it casts a warm, buttery glow over the scene. The creature, content in its butter river, lets out a yawn. Nearby, a flock of birds take flight&quot;</span>

image = pipe(
    prompt=prompt,
    prompt_3=prompt_3,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">28</span>,
    guidance_scale=<span class="hljs-number">4.5</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),je=new _({props:{title:"Tiny AutoEncoder for Stable Diffusion 3",local:"tiny-autoencoder-for-stable-diffusion-3",headingTag:"h2"}}),Be=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTJDJTIwQXV0b2VuY29kZXJUaW55JTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMtbWVkaXVtLWRpZmZ1c2VycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZDMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzbGljZSUyMG9mJTIwZGVsaWNpb3VzJTIwTmV3JTIwWW9yay1zdHlsZSUyMGJlcnJ5JTIwY2hlZXNlY2FrZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoZWVzZWNha2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline, AutoencoderTiny

pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd3&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake.png&quot;</span>)`,wrap:!1}}),Ge=new _({props:{title:"Loading the original checkpoints via from_single_file",local:"loading-the-original-checkpoints-via-fromsinglefile",headingTag:"h2"}}),ke=new _({props:{title:"Loading the original checkpoints for the SD3Transformer2DModel",local:"loading-the-original-checkpoints-for-the-sd3transformer2dmodel",headingTag:"h2"}}),xe=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fc2luZ2xlX2ZpbGUoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bSUyRmJsb2IlMkZtYWluJTJGc2QzX21lZGl1bS5zYWZldGVuc29ycyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel

model = SD3Transformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium.safetensors&quot;</span>)`,wrap:!1}}),$e=new _({props:{title:"Loading the single checkpoint for the StableDiffusion3Pipeline",local:"loading-the-single-checkpoint-for-the-stablediffusion3pipeline",headingTag:"h2"}}),Se=new _({props:{title:"Loading the single file checkpoint without T5",local:"loading-the-single-file-checkpoint-without-t5",headingTag:"h3"}}),Ce=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwcy5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8zJTNETm9uZSUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLnBuZycp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips.safetensors&quot;</span>,
    torch_dtype=torch.float16,
    text_encoder_3=<span class="hljs-literal">None</span>
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file.png&#x27;</span>)`,wrap:!1}}),Re=new _({props:{title:"Loading the single file checkpoint with T5",local:"loading-the-single-file-checkpoint-with-t5",headingTag:"h3"}}),C=new yn({props:{warning:!1,$$slots:{default:[mi]},$$scope:{ctx:Z}}}),Xe=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNQaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMy1tZWRpdW0lMkZibG9iJTJGbWFpbiUyRnNkM19tZWRpdW1faW5jbF9jbGlwc190NXh4bGZwOC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBwaWN0dXJlJTIwb2YlMjBhJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSgnc2QzLXNpbmdsZS1maWxlLXQ1LWZwOC5wbmcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3-medium/blob/main/sd3_medium_incl_clips_t5xxlfp8.safetensors&quot;</span>,
    torch_dtype=torch.float16,
)
pipe.enable_model_cpu_offload()

image = pipe(<span class="hljs-string">&quot;a picture of a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;sd3-single-file-t5-fp8.png&#x27;</span>)`,wrap:!1}}),Ye=new _({props:{title:"Loading the single file checkpoint for the Stable Diffusion 3.5 Transformer Model",local:"loading-the-single-file-checkpoint-for-the-stable-diffusion-35-transformer-model",headingTag:"h3"}}),Ve=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU0QzVHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwU3RhYmxlRGlmZnVzaW9uM1BpcGVsaW5lJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTMuNS1sYXJnZS10dXJibyUyRmJsb2IlMkZtYWluJTJGc2QzLjVfbGFyZ2Uuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb24zUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLjUtbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUyMmElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnNkMzUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, StableDiffusion3Pipeline

transformer = SD3Transformer2DModel.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/stable-diffusion-3.5-large-turbo/blob/main/sd3.5_large.safetensors&quot;</span>,
    torch_dtype=torch.bfloat16,
)
pipe = StableDiffusion3Pipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3.5-large&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.enable_model_cpu_offload()
image = pipe(<span class="hljs-string">&quot;a cat holding a sign that says hello world&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sd35.png&quot;</span>)`,wrap:!1}}),ze=new _({props:{title:"StableDiffusion3Pipeline",local:"diffusers.StableDiffusion3Pipeline",headingTag:"h2"}}),Ne=new it({props:{name:"class diffusers.StableDiffusion3Pipeline",anchor:"diffusers.StableDiffusion3Pipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"},{name:"image_encoder",val:": PreTrainedModel = None"},{name:"feature_extractor",val:": BaseImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/v0.32.1/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.32.1/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.32.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3Pipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3Pipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"},{anchor:"diffusers.StableDiffusion3Pipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
Pre-trained Vision Model for IP Adapter.`,name:"image_encoder"},{anchor:"diffusers.StableDiffusion3Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>BaseImageProcessor</code>, <em>optional</em>) &#x2014;
Image processor for IP Adapter.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.32.1/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L147"}}),Ee=new it({props:{name:"__call__",anchor:"diffusers.StableDiffusion3Pipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"},{name:"skip_guidance_layers",val:": typing.List[int] = None"},{name:"skip_layer_guidance_scale",val:": float = 2.8"},{name:"skip_layer_guidance_stop",val:": float = 0.2"},{name:"skip_layer_guidance_start",val:": float = 0.01"},{name:"mu",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014; Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_guidance_layers",description:`<strong>skip_guidance_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of integers that specify layers to skip during guidance. If not provided, all layers will be
used for guidance. If provided, the guidance will only be applied to the layers specified in the list.
Recommended value by StabiltyAI for Stable Diffusion 3.5 Medium is [7, 8, 9].`,name:"skip_guidance_layers"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_scale",description:`<strong>skip_layer_guidance_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014; The scale of the guidance for the layers specified in
<code>skip_guidance_layers</code>. The guidance will be applied to the layers specified in <code>skip_guidance_layers</code>
with a scale of <code>skip_layer_guidance_scale</code>. The guidance will be applied to the rest of the layers
with a scale of <code>1</code>.`,name:"skip_layer_guidance_scale"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_stop",description:`<strong>skip_layer_guidance_stop</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will stop. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> until the fraction specified in <code>skip_layer_guidance_stop</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.2.`,name:"skip_layer_guidance_stop"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.skip_layer_guidance_start",description:`<strong>skip_layer_guidance_start</strong> (<code>int</code>, <em>optional</em>) &#x2014; The step at which the guidance for the layers specified in
<code>skip_guidance_layers</code> will start. The guidance will be applied to the layers specified in
<code>skip_guidance_layers</code> from the fraction specified in <code>skip_layer_guidance_start</code>. Recommended value by
StabiltyAI for Stable Diffusion 3.5 Medium is 0.01.`,name:"skip_layer_guidance_start"},{anchor:"diffusers.StableDiffusion3Pipeline.__call__.mu",description:"<strong>mu</strong> (<code>float</code>, <em>optional</em>) &#x2014; <code>mu</code> value used for <code>dynamic_shifting</code>.",name:"mu"}],source:"https://github.com/huggingface/diffusers/blob/v0.32.1/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L773",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_3.StableDiffusion3PipelineOutput</code> or <code>tuple</code></p>
`}}),R=new li({props:{anchor:"diffusers.StableDiffusion3Pipeline.__call__.example",$$slots:{default:[fi]},$$scope:{ctx:Z}}}),De=new it({props:{name:"encode_image",anchor:"diffusers.StableDiffusion3Pipeline.encode_image",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"device",val:": device"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_image.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input image to be encoded.`,name:"image"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_image.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
Torch device.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.32.1/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L697",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The encoded image feature representation.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Qe=new it({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_3",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3Pipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.32.1/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L345"}}),He=new it({props:{name:"prepare_ip_adapter_image_embeds",anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds",parameters:[{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
The input image to extract features from for IP-Adapter.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Precomputed image embeddings.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
Torch device.`,name:"device"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
Number of images that should be generated per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3Pipeline.prepare_ip_adapter_image_embeds.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, defaults to True) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"}],source:"https://github.com/huggingface/diffusers/blob/v0.32.1/src/diffusers/pipelines/stable_diffusion_3/pipeline_stable_diffusion_3.py#L717"}}),Fe=new ri({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/stable_diffusion_3.md"}}),{c(){o=f("meta"),M=a(),g=f("p"),y=a(),l(j.$$.fragment),b=a(),I=f("p"),I.innerHTML=In,st=a(),V=f("p"),V.textContent=vn,ot=a(),z=f("p"),z.innerHTML=Bn,lt=a(),l(N.$$.fragment),rt=a(),E=f("p"),E.innerHTML=Gn,pt=a(),D=f("p"),D.textContent=Wn,dt=a(),l(Q.$$.fragment),ct=a(),l(k.$$.fragment),mt=a(),l(H.$$.fragment),ft=a(),F=f("p"),F.innerHTML=kn,ut=a(),P=f("ul"),P.innerHTML=xn,gt=a(),l(L.$$.fragment),ht=a(),A=f("p"),A.textContent=$n,yt=a(),q=f("ul"),q.innerHTML=Sn,Mt=a(),K=f("p"),K.innerHTML=Cn,bt=a(),l(O.$$.fragment),_t=a(),x=f("div"),x.innerHTML=Rn,wt=a(),l($.$$.fragment),Tt=a(),l(ee.$$.fragment),Jt=a(),te=f("p"),te.innerHTML=Xn,Ut=a(),l(ne.$$.fragment),Zt=a(),ie=f("p"),ie.textContent=Yn,jt=a(),l(ae.$$.fragment),It=a(),l(se.$$.fragment),vt=a(),oe=f("p"),oe.textContent=Vn,Bt=a(),l(le.$$.fragment),Gt=a(),l(re.$$.fragment),Wt=a(),pe=f("p"),pe.innerHTML=zn,kt=a(),de=f("p"),de.innerHTML=Nn,xt=a(),l(ce.$$.fragment),$t=a(),me=f("p"),me.innerHTML=En,St=a(),l(fe.$$.fragment),Ct=a(),ue=f("p"),ue.innerHTML=Dn,Rt=a(),l(ge.$$.fragment),Xt=a(),l(he.$$.fragment),Yt=a(),ye=f("p"),ye.textContent=Qn,Vt=a(),l(Me.$$.fragment),zt=a(),be=f("p"),be.innerHTML=Hn,Nt=a(),l(_e.$$.fragment),Et=a(),we=f("p"),we.innerHTML=Fn,Dt=a(),l(Te.$$.fragment),Qt=a(),l(Je.$$.fragment),Ht=a(),Ue=f("p"),Ue.textContent=Pn,Ft=a(),l(S.$$.fragment),Pt=a(),l(Ze.$$.fragment),Lt=a(),l(je.$$.fragment),At=a(),Ie=f("p"),Ie.innerHTML=Ln,qt=a(),ve=f("p"),ve.textContent=An,Kt=a(),l(Be.$$.fragment),Ot=a(),l(Ge.$$.fragment),en=a(),We=f("p"),We.innerHTML=qn,tn=a(),l(ke.$$.fragment),nn=a(),l(xe.$$.fragment),an=a(),l($e.$$.fragment),sn=a(),l(Se.$$.fragment),on=a(),l(Ce.$$.fragment),ln=a(),l(Re.$$.fragment),rn=a(),l(C.$$.fragment),pn=a(),l(Xe.$$.fragment),dn=a(),l(Ye.$$.fragment),cn=a(),l(Ve.$$.fragment),mn=a(),l(ze.$$.fragment),fn=a(),J=f("div"),l(Ne.$$.fragment),Mn=a(),v=f("div"),l(Ee.$$.fragment),bn=a(),Ae=f("p"),Ae.textContent=Kn,_n=a(),l(R.$$.fragment),wn=a(),X=f("div"),l(De.$$.fragment),Tn=a(),qe=f("p"),qe.textContent=On,Jn=a(),Ke=f("div"),l(Qe.$$.fragment),Un=a(),B=f("div"),l(He.$$.fragment),Zn=a(),Oe=f("p"),Oe.textContent=ei,jn=a(),et=f("p"),et.innerHTML=ti,un=a(),l(Fe.$$.fragment),gn=a(),tt=f("p"),this.h()},l(e){const t=oi("svelte-u9bgzb",document.head);o=u(t,"META",{name:!0,content:!0}),t.forEach(n),M=s(e),g=u(e,"P",{}),Le(g).forEach(n),y=s(e),r(j.$$.fragment,e),b=s(e),I=u(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-3c386r"&&(I.innerHTML=In),st=s(e),V=u(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1cwsb16"&&(V.textContent=vn),ot=s(e),z=u(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-vkvbjo"&&(z.innerHTML=Bn),lt=s(e),r(N.$$.fragment,e),rt=s(e),E=u(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-mtsbjp"&&(E.innerHTML=Gn),pt=s(e),D=u(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-12sg8l0"&&(D.textContent=Wn),dt=s(e),r(Q.$$.fragment,e),ct=s(e),r(k.$$.fragment,e),mt=s(e),r(H.$$.fragment,e),ft=s(e),F=u(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-16uzmu4"&&(F.innerHTML=kn),ut=s(e),P=u(e,"UL",{"data-svelte-h":!0}),h(P)!=="svelte-1wxish5"&&(P.innerHTML=xn),gt=s(e),r(L.$$.fragment,e),ht=s(e),A=u(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-n8z787"&&(A.textContent=$n),yt=s(e),q=u(e,"UL",{"data-svelte-h":!0}),h(q)!=="svelte-79yrba"&&(q.innerHTML=Sn),Mt=s(e),K=u(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-19sl6jj"&&(K.innerHTML=Cn),bt=s(e),r(O.$$.fragment,e),_t=s(e),x=u(e,"DIV",{class:!0,"data-svelte-h":!0}),h(x)!=="svelte-lfioke"&&(x.innerHTML=Rn),wt=s(e),r($.$$.fragment,e),Tt=s(e),r(ee.$$.fragment,e),Jt=s(e),te=u(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-19ncv5l"&&(te.innerHTML=Xn),Ut=s(e),r(ne.$$.fragment,e),Zt=s(e),ie=u(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-uyrglw"&&(ie.textContent=Yn),jt=s(e),r(ae.$$.fragment,e),It=s(e),r(se.$$.fragment,e),vt=s(e),oe=u(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-k4awn"&&(oe.textContent=Vn),Bt=s(e),r(le.$$.fragment,e),Gt=s(e),r(re.$$.fragment,e),Wt=s(e),pe=u(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-vcvc4f"&&(pe.innerHTML=zn),kt=s(e),de=u(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-1t2mxsa"&&(de.innerHTML=Nn),xt=s(e),r(ce.$$.fragment,e),$t=s(e),me=u(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1pykif5"&&(me.innerHTML=En),St=s(e),r(fe.$$.fragment,e),Ct=s(e),ue=u(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-bsz29z"&&(ue.innerHTML=Dn),Rt=s(e),r(ge.$$.fragment,e),Xt=s(e),r(he.$$.fragment,e),Yt=s(e),ye=u(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-x56fi6"&&(ye.textContent=Qn),Vt=s(e),r(Me.$$.fragment,e),zt=s(e),be=u(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-d39h5a"&&(be.innerHTML=Hn),Nt=s(e),r(_e.$$.fragment,e),Et=s(e),we=u(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-ejr28n"&&(we.innerHTML=Fn),Dt=s(e),r(Te.$$.fragment,e),Qt=s(e),r(Je.$$.fragment,e),Ht=s(e),Ue=u(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1ey7u3k"&&(Ue.textContent=Pn),Ft=s(e),r(S.$$.fragment,e),Pt=s(e),r(Ze.$$.fragment,e),Lt=s(e),r(je.$$.fragment,e),At=s(e),Ie=u(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-wy5f4n"&&(Ie.innerHTML=Ln),qt=s(e),ve=u(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-cj7nlj"&&(ve.textContent=An),Kt=s(e),r(Be.$$.fragment,e),Ot=s(e),r(Ge.$$.fragment,e),en=s(e),We=u(e,"P",{"data-svelte-h":!0}),h(We)!=="svelte-1pvw0yz"&&(We.innerHTML=qn),tn=s(e),r(ke.$$.fragment,e),nn=s(e),r(xe.$$.fragment,e),an=s(e),r($e.$$.fragment,e),sn=s(e),r(Se.$$.fragment,e),on=s(e),r(Ce.$$.fragment,e),ln=s(e),r(Re.$$.fragment,e),rn=s(e),r(C.$$.fragment,e),pn=s(e),r(Xe.$$.fragment,e),dn=s(e),r(Ye.$$.fragment,e),cn=s(e),r(Ve.$$.fragment,e),mn=s(e),r(ze.$$.fragment,e),fn=s(e),J=u(e,"DIV",{class:!0});var U=Le(J);r(Ne.$$.fragment,U),Mn=s(U),v=u(U,"DIV",{class:!0});var G=Le(v);r(Ee.$$.fragment,G),bn=s(G),Ae=u(G,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-v78lg8"&&(Ae.textContent=Kn),_n=s(G),r(R.$$.fragment,G),G.forEach(n),wn=s(U),X=u(U,"DIV",{class:!0});var Pe=Le(X);r(De.$$.fragment,Pe),Tn=s(Pe),qe=u(Pe,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-vi6ux7"&&(qe.textContent=On),Pe.forEach(n),Jn=s(U),Ke=u(U,"DIV",{class:!0});var nt=Le(Ke);r(Qe.$$.fragment,nt),nt.forEach(n),Un=s(U),B=u(U,"DIV",{class:!0});var W=Le(B);r(He.$$.fragment,W),Zn=s(W),Oe=u(W,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-fimzys"&&(Oe.textContent=ei),jn=s(W),et=u(W,"P",{"data-svelte-h":!0}),h(et)!=="svelte-gkgg1h"&&(et.innerHTML=ti),W.forEach(n),U.forEach(n),un=s(e),r(Fe.$$.fragment,e),gn=s(e),tt=u(e,"P",{}),Le(tt).forEach(n),this.h()},h(){Y(o,"name","hf:doc:metadata"),Y(o,"content",gi),Y(x,"class","justify-center"),Y(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){w(document.head,o),i(e,M,t),i(e,g,t),i(e,y,t),p(j,e,t),i(e,b,t),i(e,I,t),i(e,st,t),i(e,V,t),i(e,ot,t),i(e,z,t),i(e,lt,t),p(N,e,t),i(e,rt,t),i(e,E,t),i(e,pt,t),i(e,D,t),i(e,dt,t),p(Q,e,t),i(e,ct,t),p(k,e,t),i(e,mt,t),p(H,e,t),i(e,ft,t),i(e,F,t),i(e,ut,t),i(e,P,t),i(e,gt,t),p(L,e,t),i(e,ht,t),i(e,A,t),i(e,yt,t),i(e,q,t),i(e,Mt,t),i(e,K,t),i(e,bt,t),p(O,e,t),i(e,_t,t),i(e,x,t),i(e,wt,t),p($,e,t),i(e,Tt,t),p(ee,e,t),i(e,Jt,t),i(e,te,t),i(e,Ut,t),p(ne,e,t),i(e,Zt,t),i(e,ie,t),i(e,jt,t),p(ae,e,t),i(e,It,t),p(se,e,t),i(e,vt,t),i(e,oe,t),i(e,Bt,t),p(le,e,t),i(e,Gt,t),p(re,e,t),i(e,Wt,t),i(e,pe,t),i(e,kt,t),i(e,de,t),i(e,xt,t),p(ce,e,t),i(e,$t,t),i(e,me,t),i(e,St,t),p(fe,e,t),i(e,Ct,t),i(e,ue,t),i(e,Rt,t),p(ge,e,t),i(e,Xt,t),p(he,e,t),i(e,Yt,t),i(e,ye,t),i(e,Vt,t),p(Me,e,t),i(e,zt,t),i(e,be,t),i(e,Nt,t),p(_e,e,t),i(e,Et,t),i(e,we,t),i(e,Dt,t),p(Te,e,t),i(e,Qt,t),p(Je,e,t),i(e,Ht,t),i(e,Ue,t),i(e,Ft,t),p(S,e,t),i(e,Pt,t),p(Ze,e,t),i(e,Lt,t),p(je,e,t),i(e,At,t),i(e,Ie,t),i(e,qt,t),i(e,ve,t),i(e,Kt,t),p(Be,e,t),i(e,Ot,t),p(Ge,e,t),i(e,en,t),i(e,We,t),i(e,tn,t),p(ke,e,t),i(e,nn,t),p(xe,e,t),i(e,an,t),p($e,e,t),i(e,sn,t),p(Se,e,t),i(e,on,t),p(Ce,e,t),i(e,ln,t),p(Re,e,t),i(e,rn,t),p(C,e,t),i(e,pn,t),p(Xe,e,t),i(e,dn,t),p(Ye,e,t),i(e,cn,t),p(Ve,e,t),i(e,mn,t),p(ze,e,t),i(e,fn,t),i(e,J,t),p(Ne,J,null),w(J,Mn),w(J,v),p(Ee,v,null),w(v,bn),w(v,Ae),w(v,_n),p(R,v,null),w(J,wn),w(J,X),p(De,X,null),w(X,Tn),w(X,qe),w(J,Jn),w(J,Ke),p(Qe,Ke,null),w(J,Un),w(J,B),p(He,B,null),w(B,Zn),w(B,Oe),w(B,jn),w(B,et),i(e,un,t),p(Fe,e,t),i(e,gn,t),i(e,tt,t),hn=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),k.$set(U);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),$.$set(G);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),S.$set(Pe);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),C.$set(nt);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),R.$set(W)},i(e){hn||(d(j.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(k.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d($.$$.fragment,e),d(ee.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(_e.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(S.$$.fragment,e),d(Ze.$$.fragment,e),d(je.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(xe.$$.fragment,e),d($e.$$.fragment,e),d(Se.$$.fragment,e),d(Ce.$$.fragment,e),d(Re.$$.fragment,e),d(C.$$.fragment,e),d(Xe.$$.fragment,e),d(Ye.$$.fragment,e),d(Ve.$$.fragment,e),d(ze.$$.fragment,e),d(Ne.$$.fragment,e),d(Ee.$$.fragment,e),d(R.$$.fragment,e),d(De.$$.fragment,e),d(Qe.$$.fragment,e),d(He.$$.fragment,e),d(Fe.$$.fragment,e),hn=!0)},o(e){c(j.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(k.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(O.$$.fragment,e),c($.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),c(_e.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(S.$$.fragment,e),c(Ze.$$.fragment,e),c(je.$$.fragment,e),c(Be.$$.fragment,e),c(Ge.$$.fragment,e),c(ke.$$.fragment,e),c(xe.$$.fragment,e),c($e.$$.fragment,e),c(Se.$$.fragment,e),c(Ce.$$.fragment,e),c(Re.$$.fragment,e),c(C.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c(Ve.$$.fragment,e),c(ze.$$.fragment,e),c(Ne.$$.fragment,e),c(Ee.$$.fragment,e),c(R.$$.fragment,e),c(De.$$.fragment,e),c(Qe.$$.fragment,e),c(He.$$.fragment,e),c(Fe.$$.fragment,e),hn=!1},d(e){e&&(n(M),n(g),n(y),n(b),n(I),n(st),n(V),n(ot),n(z),n(lt),n(rt),n(E),n(pt),n(D),n(dt),n(ct),n(mt),n(ft),n(F),n(ut),n(P),n(gt),n(ht),n(A),n(yt),n(q),n(Mt),n(K),n(bt),n(_t),n(x),n(wt),n(Tt),n(Jt),n(te),n(Ut),n(Zt),n(ie),n(jt),n(It),n(vt),n(oe),n(Bt),n(Gt),n(Wt),n(pe),n(kt),n(de),n(xt),n($t),n(me),n(St),n(Ct),n(ue),n(Rt),n(Xt),n(Yt),n(ye),n(Vt),n(zt),n(be),n(Nt),n(Et),n(we),n(Dt),n(Qt),n(Ht),n(Ue),n(Ft),n(Pt),n(Lt),n(At),n(Ie),n(qt),n(ve),n(Kt),n(Ot),n(en),n(We),n(tn),n(nn),n(an),n(sn),n(on),n(ln),n(rn),n(pn),n(dn),n(cn),n(mn),n(fn),n(J),n(un),n(gn),n(tt)),n(o),m(j,e),m(N,e),m(Q,e),m(k,e),m(H,e),m(L,e),m(O,e),m($,e),m(ee,e),m(ne,e),m(ae,e),m(se,e),m(le,e),m(re,e),m(ce,e),m(fe,e),m(ge,e),m(he,e),m(Me,e),m(_e,e),m(Te,e),m(Je,e),m(S,e),m(Ze,e),m(je,e),m(Be,e),m(Ge,e),m(ke,e),m(xe,e),m($e,e),m(Se,e),m(Ce,e),m(Re,e),m(C,e),m(Xe,e),m(Ye,e),m(Ve,e),m(ze,e),m(Ne),m(Ee),m(R),m(De),m(Qe),m(He),m(Fe,e)}}}const gi='{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":2},{"title":"Image Prompting with IP-Adapters","local":"image-prompting-with-ip-adapters","sections":[],"depth":2},{"title":"Memory Optimisations for SD3","local":"memory-optimisations-for-sd3","sections":[{"title":"Running Inference with Model Offloading","local":"running-inference-with-model-offloading","sections":[],"depth":3},{"title":"Dropping the T5 Text Encoder during Inference","local":"dropping-the-t5-text-encoder-during-inference","sections":[],"depth":3},{"title":"Using a Quantized Version of the T5 Text Encoder","local":"using-a-quantized-version-of-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Performance Optimizations for SD3","local":"performance-optimizations-for-sd3","sections":[{"title":"Using Torch Compile to Speed Up Inference","local":"using-torch-compile-to-speed-up-inference","sections":[],"depth":3}],"depth":2},{"title":"Using Long Prompts with the T5 Text Encoder","local":"using-long-prompts-with-the-t5-text-encoder","sections":[{"title":"Sending a different prompt to the T5 Text Encoder","local":"sending-a-different-prompt-to-the-t5-text-encoder","sections":[],"depth":3}],"depth":2},{"title":"Tiny AutoEncoder for Stable Diffusion 3","local":"tiny-autoencoder-for-stable-diffusion-3","sections":[],"depth":2},{"title":"Loading the original checkpoints via from_single_file","local":"loading-the-original-checkpoints-via-fromsinglefile","sections":[],"depth":2},{"title":"Loading the original checkpoints for the SD3Transformer2DModel","local":"loading-the-original-checkpoints-for-the-sd3transformer2dmodel","sections":[],"depth":2},{"title":"Loading the single checkpoint for the StableDiffusion3Pipeline","local":"loading-the-single-checkpoint-for-the-stablediffusion3pipeline","sections":[{"title":"Loading the single file checkpoint without T5","local":"loading-the-single-file-checkpoint-without-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint with T5","local":"loading-the-single-file-checkpoint-with-t5","sections":[],"depth":3},{"title":"Loading the single file checkpoint for the Stable Diffusion 3.5 Transformer Model","local":"loading-the-single-file-checkpoint-for-the-stable-diffusion-35-transformer-model","sections":[],"depth":3}],"depth":2},{"title":"StableDiffusion3Pipeline","local":"diffusers.StableDiffusion3Pipeline","sections":[],"depth":2}],"depth":1}';function hi(Z){return ii(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ui extends ai{constructor(o){super(),si(this,o,hi,ui,ni,{})}}export{Ui as component};
