import{s as Ft,n as Yt,o as _t}from"../chunks/scheduler.362310b7.js";import{S as Dt,i as Zt,g as i,s as U,r as n,A as Wt,h as M,f as e,c as J,j as Vt,u as y,x as a,k as Tt,y as xt,a as T,v as s,d,t as w,w as u}from"../chunks/index.57dfc70d.js";import{C as I}from"../chunks/CodeBlock.5d40996c.js";import{H as Ml,E as Bt}from"../chunks/index.289153e6.js";function Et(Ut){let g,yl,al,sl,m,dl,p,Jt='This tutorial will show you how to train a Medusa model on a dataset of your choice. Please check out the <a href="../conceptual/speculation">speculation documentation</a> for more information on how Medusa works and speculation in general.',wl,j,ul,C,it="Training Medusa heads can greatly improve the speed of generation. Medusa adds extra “heads” to LLMs to predict multiple future tokens simultaneously. When augmenting a model with Medusa, the original model stays untouched, and only the new heads are fine-tuned during training.",gl,k,Mt="One of the most important things is to have a good dataset (with similar data to what will be used in production) because Medusa has a much higher hit-rate when the generation is in-domain.",Il,h,at="If you train Medusa on a dataset that is very different from the one you will use in production then the model will not be able to predict the future tokens accurately and consequently the speedup will be minimal or non-existent.",rl,O,ol,f,nt="There are many methods for preparing data for training, but one of the easiest and most effective ways is to “self-distill” the data. This means that you can use the same model to generate the data that you will use to train the model.",ml,c,yt="Essentially, you prompt the model with a similar input to what you will use in production and the model will generate the output.",pl,A,st="We’ll use this output to help train the medusa heads to predict the <code>n+1</code>, <code>n+2</code>, <code>n+3</code>, etc tokens in the sequence.",jl,b,Cl,N,dt='The original implementation of Medusa is available at <a href="https://github.com/FasterDecoding/Medusa" rel="nofollow">https://github.com/FasterDecoding/Medusa</a> and we’ll follow a very similar process to train the model as described on the original repository.',kl,R,hl,V,wt="There are two methods for training the model:",Ol,F,ut="<li><code>torchrun</code> that is a wrapper around <code>torch.distributed.launch</code></li> <li>a forked version of <code>axlotl</code> that supports Medusa</li>",fl,Y,gt="In this tutorial we’ll use <code>torchrun</code> to train the model as it is the most straightforward way to train the model but similar steps can be followed to train the model using <code>axlotl</code> if you prefer.",cl,_,Al,D,bl,Z,It="Now lets clone the original <code>Medusa</code> repository and install the library.",Nl,W,Rl,x,rt="Next we’ll need some data to train on, we can use the <code>ShareGPT_Vicuna_unfiltered</code> dataset that is available on the Hugging Face Hub.",Vl,B,Fl,E,ot="Currently our directory structure looks like this:",Yl,$,_l,v,Dl,G,mt="Now the lets generate the data and start training the model. This process will take a while since we are generating data from the model.",Zl,S,pt="First make sure you have an instance of TGI running with the model you want to use for self-distillation.",Wl,Q,xl,X,jt="Now we can generate the data using the <code>create_data.py</code> script.",Bl,H,El,z,Ct="At this point our terminal should look like this:",$l,r,kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/medusa-train-large.gif" width="550"/>',vl,L,ht="<p>Note: In the screen shot above we are only using a the first 500 examples from the dataset to speed up the process, you should have a much larger dataset for training.</p>",Gl,P,Ot="Now we can finally get to the fun part and start training the model!",Sl,q,ft="Using <code>torchrun</code> we can easily launch the <code>medusa</code> training script with the <code>zephyr_self_distill.json</code> configuration file.",Ql,K,ct="<p>NOTE: If you just self-distilled you may still have the model running, make sure to stop it before starting the training in order to allow all of the resources to be used for training.</p>",Xl,ll,Hl,o,At='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/medusa-train-heads-large.gif" width="550"/>',zl,tl,bt="If successful, you should see the similar output to the one below:",Ll,el,Pl,Tl,Nt="Last but most importantly, don’t forget to push this model to the Hugging Face Hub so you can use it in your projects.",ql,Ul,Kl,Jl,Rt="Woo, we’ve successfully trained a Medusa model and pushed it to the Hugging Face Hub! 🎉",lt,il,tt,nl,et;return m=new Ml({props:{title:"Train Medusa",local:"train-medusa",headingTag:"h1"}}),j=new Ml({props:{title:"What are the benefits of training a Medusa model?",local:"what-are-the-benefits-of-training-a-medusa-model",headingTag:"h2"}}),O=new Ml({props:{title:"Self-distillation (Generating data for training)",local:"self-distillation-generating-data-for-training",headingTag:"h2"}}),b=new Ml({props:{title:"Training",local:"training",headingTag:"h2"}}),R=new Ml({props:{title:"Getting Started",local:"getting-started",headingTag:"h3"}}),_=new Ml({props:{title:"Training with torchrun",local:"training-with-torchrun",headingTag:"h3"}}),D=new I({props:{code:"bWtkaXIlMjBtZWR1c2EtdHJhaW5pbmclMEFjZCUyMG1lZHVzYS10cmFpbmluZyUwQSUwQXB5ZW52JTIwaW5zdGFsbCUyMDMuMTAlMEFweWVudiUyMGxvY2FsJTIwMy4xMCUwQSUwQXV2JTIwdmVudiUyMC1wJTIwMy4xMCUwQXNvdXJjZSUyMC52ZW52JTJGYmluJTJGYWN0aXZhdGU=",highlighted:`<span class="hljs-built_in">mkdir</span> medusa-training
<span class="hljs-built_in">cd</span> medusa-training

pyenv install 3.10
pyenv <span class="hljs-built_in">local</span> 3.10

uv venv -p 3.10
<span class="hljs-built_in">source</span> .venv/bin/activate`,wrap:!1}}),W=new I({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZGYXN0ZXJEZWNvZGluZyUyRk1lZHVzYS5naXQlMEFjZCUyME1lZHVzYSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/FasterDecoding/Medusa.git
<span class="hljs-built_in">cd</span> Medusa
pip install -e .`,wrap:!1}}),B=new I({props:{code:"YXB0JTIwaW5zdGFsbCUyMGdpdC1sZnMlMEFnaXQlMjBsZnMlMjBpbnN0YWxsJTBBZ2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZBZWFsYSUyRlNoYXJlR1BUX1ZpY3VuYV91bmZpbHRlcmVk",highlighted:`apt install git-lfs
git lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/datasets/Aeala/ShareGPT_Vicuna_unfiltered`,wrap:!1}}),$=new I({props:{code:"LiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGFzc2V0cyUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMENJVEFUSU9OLmNmZiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNyZWF0ZV9kYXRhLnB5JTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YV9nZW5lcmF0aW9uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGVlcHNwZWVkLmpzb24lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBsYXN0X3J1bl9wcmVwYXJlZCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMExJQ0VOU0UlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBsbG1fanVkZ2UlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtZWR1c2ElMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtZWR1c2FfbGxtLmVnZy1pbmZvJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbWlzdHJhbC5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbm90ZWJvb2tzJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwcHlwcm9qZWN0LnRvbWwlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBSRUFETUUubWQlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBST0FETUFQLm1kJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwc2NyaXB0cyUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFNoYXJlR1BUX1ZpY3VuYV91bmZpbHRlcmVkJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwUkVBRE1FLm1kJTBBJUUyJTk0JTgyJUMyJUEwJUMyJUEwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwU2hhcmVHUFRfMjAyMy4wNS4wNHYwX1dhc3RlbGFuZF9FZGl0aW9uLmpzb24lMEElRTIlOTQlODIlQzIlQTAlQzIlQTAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBTaGFyZUdQVF9WNC4zX3VuZmlsdGVyZWRfY2xlYW5lZF9zcGxpdC5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwc2ltcGxlX2dyYWRpb19pbnRlcmZhY2UucHklMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0aW55LWxsYW1hLmpzb24lMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB2aWN1bmFfN2JfcWxvcmFfc3RhZ2Ux",highlighted:`.
├── assets
├── CITATION.cff
├── create_data.py
├── data_generation
├── deepspeed.json
├── last_run_prepared
├── LICENSE
├── llm_judge
├── medusa
├── medusa_llm.egg-info
├── mistral.json
├── notebooks
├── pyproject.toml
├── README.md
├── ROADMAP.md
├── scripts
├── ShareGPT_Vicuna_unfiltered
│   ├── README.md
│   ├── ShareGPT_2023.05.04v0_Wasteland_Edition.json
│   └── ShareGPT_V4.3_unfiltered_cleaned_split.json
├── simple_gradio_interface.py
├── tiny-llama.json
└── vicuna_7b_qlora_stage1`,wrap:!1}}),v=new Ml({props:{title:"Start Training",local:"start-training",headingTag:"h2"}}),Q=new I({props:{code:"bW9kZWwlM0RIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMEF2b2x1bWUlM0QlMkZob21lJTJGdWJ1bnR1JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkYlMEElMEFkb2NrZXIlMjBydW4lMjAtLWdwdXMlMjBhbGwlMjAtLXNobS1zaXplJTIwMWclMjAtcCUyMDgwODAlM0E4MCUyMC12JTIwJTI0dm9sdW1lJTNBJTJGZGF0YSUyMGdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0FsYXRlc3QlMjAtLW1vZGVsLWlkJTIwJTI0bW9kZWw=",highlighted:`model=HuggingFaceH4/zephyr-7b-beta
volume=/home/ubuntu/.cache/huggingface/hub/

docker run --gpus all --shm-size 1g -p 8080:80 -v <span class="hljs-variable">$volume</span>:/data ghcr.io/huggingface/text-generation-inference:latest --model-id <span class="hljs-variable">$model</span>`,wrap:!1}}),H=new I({props:{code:"cHl0aG9uJTIwY3JlYXRlX2RhdGEucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0LWZpbGVuYW1lJTIwU2hhcmVHUFRfVmljdW5hX3VuZmlsdGVyZWQlMkZTaGFyZUdQVF9WNC4zX3VuZmlsdGVyZWRfY2xlYW5lZF9zcGxpdC5qc29uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXQtZmlsZW5hbWUlMjB6ZXBoeXJfc2VsZl9kaXN0aWxsLmpzb24=",highlighted:`python create_data.py \\
    --input-filename ShareGPT_Vicuna_unfiltered/ShareGPT_V4.3_unfiltered_cleaned_split.json \\
    --output-filename zephyr_self_distill.json`,wrap:!1}}),ll=new I({props:{code:"V0FOREJfTU9ERSUzRG9mZmxpbmUlMjB0b3JjaHJ1biUyMC0tbnByb2NfcGVyX25vZGUlM0Q0JTIwbWVkdXNhJTJGdHJhaW4lMkZ0cmFpbl9sZWdhY3kucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMEh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YV9wYXRoJTIwemVwaHlyX3NlbGZfZGlzdGlsbC5qc29uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHplcGh5cl9vdXQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW51bV90cmFpbl9lcG9jaHMlMjA1JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjA0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWV2YWx1YXRpb25fc3RyYXRlZ3klMjAlMjJubyUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2F2ZV9zdHJhdGVneSUyMCUyMm5vJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwMWUtMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0td2VpZ2h0X2RlY2F5JTIwMC4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS13YXJtdXBfcmF0aW8lMjAwLjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxyX3NjaGVkdWxlcl90eXBlJTIwJTIyY29zaW5lJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGYzMiUyMFRydWUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX21heF9sZW5ndGglMjAyMDQ4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sYXp5X3ByZXByb2Nlc3MlMjBUcnVlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZWR1c2FfbnVtX2hlYWRzJTIwMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVkdXNhX251bV9sYXllcnMlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kZWVwc3BlZWQlMjBkZWVwc3BlZWQuanNvbg==",highlighted:`WANDB_MODE=offline torchrun --nproc_per_node=4 medusa/train/train_legacy.py \\
    --model_name_or_path HuggingFaceH4/zephyr-7b-beta \\
    --data_path zephyr_self_distill.json \\
    --bf16 True \\
    --output_dir zephyr_out \\
    --num_train_epochs 5 \\
    --per_device_train_batch_size 4 \\
    --per_device_eval_batch_size 4 \\
    --gradient_accumulation_steps 4 \\
    --evaluation_strategy <span class="hljs-string">&quot;no&quot;</span> \\
    --save_strategy <span class="hljs-string">&quot;no&quot;</span> \\
    --learning_rate 1e-3 \\
    --weight_decay 0.0 \\
    --warmup_ratio 0.1 \\
    --lr_scheduler_type <span class="hljs-string">&quot;cosine&quot;</span> \\
    --logging_steps 1 \\
    --tf32 True \\
    --model_max_length 2048 \\
    --lazy_preprocess True \\
    --medusa_num_heads 3 \\
    --medusa_num_layers 1 \\
    --deepspeed deepspeed.json`,wrap:!1}}),el=new I({props:{code:"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",highlighted:`wandb: Run <span class="hljs-built_in">history</span>:
wandb:                    train/epoch ▁▁▁▁▁▂▂▂▂▂▃▃▃▃▃▄▄▄▄▄▅▅▅▅▅▅▅▆▆▆▆▆▇▇▇▇▇███
wandb:              train/global_step ▁▁▁▁▁▂▂▂▂▂▃▃▃▃▃▄▄▄▄▄▅▅▅▅▅▅▅▆▆▆▆▆▇▇▇▇▇███
wandb:            train/learning_rate ▅███▇▇▆▅▅▄▃▂▂▁▁▁
wandb:                     train/loss ██▆▄▄▃▃▂▂▃▁▁▂▁▁▁
wandb:             train/medusa0_loss ▆▆▇▆▆▅▄▅▃▃▃▃▂▂▂▂▂▃▂▂▂▁▁▁▂▁▁▁▁▁█▁▁▁▂▁▁▁▁▁
wandb:             train/medusa0_top1 ▁▁▁▁▁▁▁▁▃▂▃▃▄▄▄▃▄▃▄▄▅▅▆▅▆▆▇▅▇▇▄▇█▇▅▇█▆▇▇
wandb:             train/medusa1_loss ▇▇█▇▇▆▅▅▃▄▃▃▃▃▃▃▃▃▃▃▂▁▂▂▂▁▁▂▁▁▇▁▁▁▂▁▁▁▁▁
wandb:             train/medusa1_top1 ▁▁▁▁▁▁▁▁▃▂▃▃▃▄▄▃▃▂▃▃▅▅▆▄█▆▇▅▇▇▅█▇▇▅▇█▆▆▇
wandb:             train/medusa2_loss ▃▃▄▄▄▃▃▃▂▂▂▂▂▂▂▂▂▂▂▂▁▁▁▁▁▁▁▁▁▁█▁▁▁▂▁▁▁▁▁
wandb:             train/medusa2_top1 ▁▁▁▂▁▁▁▁▂▂▃▃▃▄▄▃▃▂▃▃▅▆▅▄█▆▆▅▆▆▄█▇▇▄▇█▆▆▇
wandb:               train/total_flos ▁
wandb:               train/train_loss ▁
wandb:            train/train_runtime ▁
wandb: train/train_samples_per_second ▁
wandb:   train/train_steps_per_second ▁
wandb:
wandb: Run summary:
wandb:                    train/epoch 2.0
wandb:              train/global_step 16
wandb:            train/learning_rate 0.0
wandb:                     train/loss 14.8906
wandb:             train/medusa0_loss 4.25
wandb:             train/medusa0_top1 0.28809
wandb:             train/medusa1_loss 4.8125
wandb:             train/medusa1_top1 0.22727
wandb:             train/medusa2_loss 5.5
wandb:             train/medusa2_top1 0.17293
wandb:               train/total_flos 0.0
wandb:               train/train_loss 23.98242
wandb:            train/train_runtime 396.9266
wandb: train/train_samples_per_second 2.519
wandb:   train/train_steps_per_second 0.04`,wrap:!1}}),Ul=new I({props:{code:"cHl0aG9uJTIwLW0lMjBtZWR1c2EuaGZfdXRpbHMlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWZvbGRlciUyMHplcGh5cl9vdXRfbWVkdXNhX21scF96ZXBoeXItN2ItYmV0YV9tZWR1c2FfM19scl8wLjAwMV9sYXllcnNfMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwbyUyMGRyYmglMkZ6ZXBoeXJfbWVkdXNhX2RlbW8=",highlighted:`python -m medusa.hf_utils \\
    --folder zephyr_out_medusa_mlp_zephyr-7b-beta_medusa_3_lr_0.001_layers_1 \\
    --repo drbh/zephyr_medusa_demo`,wrap:!1}}),il=new Bt({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/train_medusa.md"}}),{c(){g=i("meta"),yl=U(),al=i("p"),sl=U(),n(m.$$.fragment),dl=U(),p=i("p"),p.innerHTML=Jt,wl=U(),n(j.$$.fragment),ul=U(),C=i("p"),C.textContent=it,gl=U(),k=i("p"),k.textContent=Mt,Il=U(),h=i("p"),h.textContent=at,rl=U(),n(O.$$.fragment),ol=U(),f=i("p"),f.textContent=nt,ml=U(),c=i("p"),c.textContent=yt,pl=U(),A=i("p"),A.innerHTML=st,jl=U(),n(b.$$.fragment),Cl=U(),N=i("p"),N.innerHTML=dt,kl=U(),n(R.$$.fragment),hl=U(),V=i("p"),V.textContent=wt,Ol=U(),F=i("ul"),F.innerHTML=ut,fl=U(),Y=i("p"),Y.innerHTML=gt,cl=U(),n(_.$$.fragment),Al=U(),n(D.$$.fragment),bl=U(),Z=i("p"),Z.innerHTML=It,Nl=U(),n(W.$$.fragment),Rl=U(),x=i("p"),x.innerHTML=rt,Vl=U(),n(B.$$.fragment),Fl=U(),E=i("p"),E.textContent=ot,Yl=U(),n($.$$.fragment),_l=U(),n(v.$$.fragment),Dl=U(),G=i("p"),G.textContent=mt,Zl=U(),S=i("p"),S.textContent=pt,Wl=U(),n(Q.$$.fragment),xl=U(),X=i("p"),X.innerHTML=jt,Bl=U(),n(H.$$.fragment),El=U(),z=i("p"),z.textContent=Ct,$l=U(),r=i("div"),r.innerHTML=kt,vl=U(),L=i("blockquote"),L.innerHTML=ht,Gl=U(),P=i("p"),P.textContent=Ot,Sl=U(),q=i("p"),q.innerHTML=ft,Ql=U(),K=i("blockquote"),K.innerHTML=ct,Xl=U(),n(ll.$$.fragment),Hl=U(),o=i("div"),o.innerHTML=At,zl=U(),tl=i("p"),tl.textContent=bt,Ll=U(),n(el.$$.fragment),Pl=U(),Tl=i("p"),Tl.textContent=Nt,ql=U(),n(Ul.$$.fragment),Kl=U(),Jl=i("p"),Jl.textContent=Rt,lt=U(),n(il.$$.fragment),tt=U(),nl=i("p"),this.h()},l(l){const t=Wt("svelte-u9bgzb",document.head);g=M(t,"META",{name:!0,content:!0}),t.forEach(e),yl=J(l),al=M(l,"P",{}),Vt(al).forEach(e),sl=J(l),y(m.$$.fragment,l),dl=J(l),p=M(l,"P",{"data-svelte-h":!0}),a(p)!=="svelte-1mup0b2"&&(p.innerHTML=Jt),wl=J(l),y(j.$$.fragment,l),ul=J(l),C=M(l,"P",{"data-svelte-h":!0}),a(C)!=="svelte-1oj5145"&&(C.textContent=it),gl=J(l),k=M(l,"P",{"data-svelte-h":!0}),a(k)!=="svelte-wbzmmv"&&(k.textContent=Mt),Il=J(l),h=M(l,"P",{"data-svelte-h":!0}),a(h)!=="svelte-1wbvya5"&&(h.textContent=at),rl=J(l),y(O.$$.fragment,l),ol=J(l),f=M(l,"P",{"data-svelte-h":!0}),a(f)!=="svelte-7x6lpm"&&(f.textContent=nt),ml=J(l),c=M(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-1x3om5l"&&(c.textContent=yt),pl=J(l),A=M(l,"P",{"data-svelte-h":!0}),a(A)!=="svelte-eh68bw"&&(A.innerHTML=st),jl=J(l),y(b.$$.fragment,l),Cl=J(l),N=M(l,"P",{"data-svelte-h":!0}),a(N)!=="svelte-ls2u4e"&&(N.innerHTML=dt),kl=J(l),y(R.$$.fragment,l),hl=J(l),V=M(l,"P",{"data-svelte-h":!0}),a(V)!=="svelte-12kh7jt"&&(V.textContent=wt),Ol=J(l),F=M(l,"UL",{"data-svelte-h":!0}),a(F)!=="svelte-1uwcqxx"&&(F.innerHTML=ut),fl=J(l),Y=M(l,"P",{"data-svelte-h":!0}),a(Y)!=="svelte-1a5pkme"&&(Y.innerHTML=gt),cl=J(l),y(_.$$.fragment,l),Al=J(l),y(D.$$.fragment,l),bl=J(l),Z=M(l,"P",{"data-svelte-h":!0}),a(Z)!=="svelte-1wc72ql"&&(Z.innerHTML=It),Nl=J(l),y(W.$$.fragment,l),Rl=J(l),x=M(l,"P",{"data-svelte-h":!0}),a(x)!=="svelte-1mbhhqg"&&(x.innerHTML=rt),Vl=J(l),y(B.$$.fragment,l),Fl=J(l),E=M(l,"P",{"data-svelte-h":!0}),a(E)!=="svelte-14hgaex"&&(E.textContent=ot),Yl=J(l),y($.$$.fragment,l),_l=J(l),y(v.$$.fragment,l),Dl=J(l),G=M(l,"P",{"data-svelte-h":!0}),a(G)!=="svelte-1tf8v8k"&&(G.textContent=mt),Zl=J(l),S=M(l,"P",{"data-svelte-h":!0}),a(S)!=="svelte-161p41b"&&(S.textContent=pt),Wl=J(l),y(Q.$$.fragment,l),xl=J(l),X=M(l,"P",{"data-svelte-h":!0}),a(X)!=="svelte-11rigfv"&&(X.innerHTML=jt),Bl=J(l),y(H.$$.fragment,l),El=J(l),z=M(l,"P",{"data-svelte-h":!0}),a(z)!=="svelte-6nwsg"&&(z.textContent=Ct),$l=J(l),r=M(l,"DIV",{class:!0,"data-svelte-h":!0}),a(r)!=="svelte-a3u0yw"&&(r.innerHTML=kt),vl=J(l),L=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),a(L)!=="svelte-e4kaxa"&&(L.innerHTML=ht),Gl=J(l),P=M(l,"P",{"data-svelte-h":!0}),a(P)!=="svelte-bvvm31"&&(P.textContent=Ot),Sl=J(l),q=M(l,"P",{"data-svelte-h":!0}),a(q)!=="svelte-hsem53"&&(q.innerHTML=ft),Ql=J(l),K=M(l,"BLOCKQUOTE",{"data-svelte-h":!0}),a(K)!=="svelte-1mfdihz"&&(K.innerHTML=ct),Xl=J(l),y(ll.$$.fragment,l),Hl=J(l),o=M(l,"DIV",{class:!0,"data-svelte-h":!0}),a(o)!=="svelte-1hrpucq"&&(o.innerHTML=At),zl=J(l),tl=M(l,"P",{"data-svelte-h":!0}),a(tl)!=="svelte-1try6t2"&&(tl.textContent=bt),Ll=J(l),y(el.$$.fragment,l),Pl=J(l),Tl=M(l,"P",{"data-svelte-h":!0}),a(Tl)!=="svelte-n5i31o"&&(Tl.textContent=Nt),ql=J(l),y(Ul.$$.fragment,l),Kl=J(l),Jl=M(l,"P",{"data-svelte-h":!0}),a(Jl)!=="svelte-1qx06qo"&&(Jl.textContent=Rt),lt=J(l),y(il.$$.fragment,l),tt=J(l),nl=M(l,"P",{}),Vt(nl).forEach(e),this.h()},h(){Tt(g,"name","hf:doc:metadata"),Tt(g,"content",$t),Tt(r,"class","flex justify-center"),Tt(o,"class","flex justify-center")},m(l,t){xt(document.head,g),T(l,yl,t),T(l,al,t),T(l,sl,t),s(m,l,t),T(l,dl,t),T(l,p,t),T(l,wl,t),s(j,l,t),T(l,ul,t),T(l,C,t),T(l,gl,t),T(l,k,t),T(l,Il,t),T(l,h,t),T(l,rl,t),s(O,l,t),T(l,ol,t),T(l,f,t),T(l,ml,t),T(l,c,t),T(l,pl,t),T(l,A,t),T(l,jl,t),s(b,l,t),T(l,Cl,t),T(l,N,t),T(l,kl,t),s(R,l,t),T(l,hl,t),T(l,V,t),T(l,Ol,t),T(l,F,t),T(l,fl,t),T(l,Y,t),T(l,cl,t),s(_,l,t),T(l,Al,t),s(D,l,t),T(l,bl,t),T(l,Z,t),T(l,Nl,t),s(W,l,t),T(l,Rl,t),T(l,x,t),T(l,Vl,t),s(B,l,t),T(l,Fl,t),T(l,E,t),T(l,Yl,t),s($,l,t),T(l,_l,t),s(v,l,t),T(l,Dl,t),T(l,G,t),T(l,Zl,t),T(l,S,t),T(l,Wl,t),s(Q,l,t),T(l,xl,t),T(l,X,t),T(l,Bl,t),s(H,l,t),T(l,El,t),T(l,z,t),T(l,$l,t),T(l,r,t),T(l,vl,t),T(l,L,t),T(l,Gl,t),T(l,P,t),T(l,Sl,t),T(l,q,t),T(l,Ql,t),T(l,K,t),T(l,Xl,t),s(ll,l,t),T(l,Hl,t),T(l,o,t),T(l,zl,t),T(l,tl,t),T(l,Ll,t),s(el,l,t),T(l,Pl,t),T(l,Tl,t),T(l,ql,t),s(Ul,l,t),T(l,Kl,t),T(l,Jl,t),T(l,lt,t),s(il,l,t),T(l,tt,t),T(l,nl,t),et=!0},p:Yt,i(l){et||(d(m.$$.fragment,l),d(j.$$.fragment,l),d(O.$$.fragment,l),d(b.$$.fragment,l),d(R.$$.fragment,l),d(_.$$.fragment,l),d(D.$$.fragment,l),d(W.$$.fragment,l),d(B.$$.fragment,l),d($.$$.fragment,l),d(v.$$.fragment,l),d(Q.$$.fragment,l),d(H.$$.fragment,l),d(ll.$$.fragment,l),d(el.$$.fragment,l),d(Ul.$$.fragment,l),d(il.$$.fragment,l),et=!0)},o(l){w(m.$$.fragment,l),w(j.$$.fragment,l),w(O.$$.fragment,l),w(b.$$.fragment,l),w(R.$$.fragment,l),w(_.$$.fragment,l),w(D.$$.fragment,l),w(W.$$.fragment,l),w(B.$$.fragment,l),w($.$$.fragment,l),w(v.$$.fragment,l),w(Q.$$.fragment,l),w(H.$$.fragment,l),w(ll.$$.fragment,l),w(el.$$.fragment,l),w(Ul.$$.fragment,l),w(il.$$.fragment,l),et=!1},d(l){l&&(e(yl),e(al),e(sl),e(dl),e(p),e(wl),e(ul),e(C),e(gl),e(k),e(Il),e(h),e(rl),e(ol),e(f),e(ml),e(c),e(pl),e(A),e(jl),e(Cl),e(N),e(kl),e(hl),e(V),e(Ol),e(F),e(fl),e(Y),e(cl),e(Al),e(bl),e(Z),e(Nl),e(Rl),e(x),e(Vl),e(Fl),e(E),e(Yl),e(_l),e(Dl),e(G),e(Zl),e(S),e(Wl),e(xl),e(X),e(Bl),e(El),e(z),e($l),e(r),e(vl),e(L),e(Gl),e(P),e(Sl),e(q),e(Ql),e(K),e(Xl),e(Hl),e(o),e(zl),e(tl),e(Ll),e(Pl),e(Tl),e(ql),e(Kl),e(Jl),e(lt),e(tt),e(nl)),e(g),u(m,l),u(j,l),u(O,l),u(b,l),u(R,l),u(_,l),u(D,l),u(W,l),u(B,l),u($,l),u(v,l),u(Q,l),u(H,l),u(ll,l),u(el,l),u(Ul,l),u(il,l)}}}const $t='{"title":"Train Medusa","local":"train-medusa","sections":[{"title":"What are the benefits of training a Medusa model?","local":"what-are-the-benefits-of-training-a-medusa-model","sections":[],"depth":2},{"title":"Self-distillation (Generating data for training)","local":"self-distillation-generating-data-for-training","sections":[],"depth":2},{"title":"Training","local":"training","sections":[{"title":"Getting Started","local":"getting-started","sections":[],"depth":3},{"title":"Training with torchrun","local":"training-with-torchrun","sections":[],"depth":3}],"depth":2},{"title":"Start Training","local":"start-training","sections":[],"depth":2}],"depth":1}';function vt(Ut){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Dt{constructor(g){super(),Zt(this,g,vt,Et,Ft,{})}}export{Ht as component};
