import{s as MM,n as tM,o as eM}from"../chunks/scheduler.362310b7.js";import{S as sM,i as aM,g as n,s,r as i,A as nM,h as y,f as t,c as a,j as lM,u as J,x as U,k as ql,y as yM,a as e,v as o,d as T,t as j,w as p}from"../chunks/index.57dfc70d.js";import{C as w}from"../chunks/CodeBlock.5d40996c.js";import{H as D,E as UM}from"../chunks/index.289153e6.js";function iM(El){let u,K,P,ll,c,Ml,I,kl="Visual Language Model (VLM) are models that consume both image and text inputs to generate text.",tl,r,vl="VLM’s are trained on a combination of image and text data and can handle a wide range of tasks, such as image captioning, visual question answering, and visual dialog.",el,h,Rl="<p>What distinguishes VLMs from other text and image models is their ability to handle long context and generate text that is coherent and relevant to the image even after multiple turns or in some cases, multiple images.</p>",sl,m,Xl="Below are couple of common use cases for vision language models:",al,d,Vl="<li><strong>Image Captioning</strong>: Given an image, generate a caption that describes the image.</li> <li><strong>Visual Question Answering (VQA)</strong>: Given an image and a question about the image, generate an answer to the question.</li> <li><strong>Mulimodal Dialog</strong>: Generate response to multiple turns of images and conversations.</li> <li><strong>Image Information Retrieval</strong>: Given an image, retrieve information from the image.</li>",nl,b,yl,A,Ul,g,Sl='To infer with vision language models through Python, you can use the <a href="https://pypi.org/project/huggingface-hub/" rel="nofollow"><code>huggingface_hub</code></a> library. The <code>InferenceClient</code> class provides a simple way to interact with the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>. Images can be passed as URLs or base64-encoded strings. The <code>InferenceClient</code> will automatically detect the image format.',il,G,Jl,f,ol,Z,Hl="or via the <code>chat_completion</code> endpoint:",Tl,W,jl,B,xl='or with OpenAI’s <a href="https://github.com/openai/openai-python" rel="nofollow">client library</a>:',pl,N,ul,Q,wl,Y,zl="To use the <code>generate_stream</code> endpoint with curl, you can add the <code>-N</code> flag. This flag disables curl default buffering and shows data as it arrives from the server.",Cl,q,cl,E,Il,k,$l="First, we need to install the <code>@huggingface/inference</code> library.",rl,v,hl,R,Fl='If you’re using the free Inference API, you can use <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">Huggingface.js</a>’s <code>HfInference</code>. If you’re using inference endpoints, you can use <code>HfInferenceEndpoint</code> class to easily interact with the Inference API.',ml,X,_l='We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face access token</a>.',dl,V,bl,S,Al,H,Ll='VLMs in TGI have several advantages, for example these models can be used in tandem with other features for more complex tasks. For example, you can use VLMs with <a href="/docs/conceptual/guided-generation">Guided Generation</a> to generate specific JSON data from an image.',gl,C,Dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png" width="400"/>',Gl,x,Pl="For example we can extract information from the rabbit image and generate a JSON object with the location, activity, number of animals seen, and the animals seen. That would look like this:",fl,z,Zl,$,Ol="All we need to do is provide a JSON schema to the VLM model and it will generate the JSON object for us.",Wl,F,Bl,_,Kl='Want to learn more about how Vision Language Models work? Check out the <a href="https://huggingface.co/blog/vlms" rel="nofollow">awesome blog post on the topic</a>.',Nl,L,Ql,O,Yl;return c=new D({props:{title:"Vision Language Model Inference in TGI",local:"vision-language-model-inference-in-tgi",headingTag:"h1"}}),b=new D({props:{title:"How to Use a Vision Language Model?",local:"how-to-use-a-vision-language-model",headingTag:"h2"}}),A=new D({props:{title:"Hugging Face Hub Python Library",local:"hugging-face-hub-python-library",headingTag:"h3"}}),G=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBMzAwMCUyMiklMEFpbWFnZSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJhYmJpdC5wbmclMjIlMEFwcm9tcHQlMjAlM0QlMjBmJTIyISU1QiU1RCglN0JpbWFnZSU3RClXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxNiUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4pJTBBJTBBJTIzJTIwVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0Lg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)
image = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
prompt = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image}</span>)What is this a picture of?\\n\\n&quot;</span>
<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(prompt, max_new_tokens=<span class="hljs-number">16</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),f=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWltcG9ydCUyMGJhc2U2NCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwaW8lMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTMwMDAlMjIpJTBBJTBBJTIzJTIwcmVhZCUyMGltYWdlJTIwZnJvbSUyMGxvY2FsJTIwZmlsZSUwQWltYWdlX3BhdGglMjAlM0QlMjAlMjJyYWJiaXQucG5nJTIyJTBBd2l0aCUyMG9wZW4oaW1hZ2VfcGF0aCUyQyUyMCUyMnJiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZShmLnJlYWQoKSkuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZiUyMmRhdGElM0FpbWFnZSUyRnBuZyUzQmJhc2U2NCUyQyU3QmltYWdlJTdEJTIyJTBBcHJvbXB0JTIwJTNEJTIwZiUyMiElNUIlNUQoJTdCaW1hZ2UlN0QpV2hhdCUyMGlzJTIwdGhpcyUyMGElMjBwaWN0dXJlJTIwb2YlM0YlNUNuJTVDbiUyMiUwQSUwQWZvciUyMHRva2VuJTIwaW4lMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKHByb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKSUwQSUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjBwaWN0dXJlJTIwb2YlMjBhbiUyMGFudGhyb3BvbW9ycGhpYyUyMHJhYmJpdCUyMGluJTIwYSUyMHNwYWNlJTIwc3VpdC4=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> io

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)

<span class="hljs-comment"># read image from local file</span>
image_path = <span class="hljs-string">&quot;rabbit.png&quot;</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
    image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

image = <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image}</span>&quot;</span>
prompt = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image}</span>)What is this a picture of?\\n\\n&quot;</span>

<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(prompt, max_new_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),W=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)

chat = client.chat_completion(
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Whats in this image?&quot;</span>},
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {
                        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
                    },
                },
            ],
        },
    ],
    seed=<span class="hljs-number">42</span>,
    max_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(chat)
<span class="hljs-comment"># ChatCompletionOutput(choices=[ChatCompletionOutputComplete(finish_reason=&#x27;length&#x27;, index=0, message=ChatCompletionOutputMessage(role=&#x27;assistant&#x27;, content=&quot; The image you&#x27;ve provided features an anthropomorphic rabbit in spacesuit attire. This rabbit is depicted with human-like posture and movement, standing on a rocky terrain with a vast, reddish-brown landscape in the background. The spacesuit is detailed with mission patches, circuitry, and a helmet that covers the rabbit&#x27;s face and ear, with an illuminated red light on the chest area.\\n\\nThe artwork style is that of a&quot;, name=None, tool_calls=None), logprobs=None)], created=1714589614, id=&#x27;&#x27;, model=&#x27;llava-hf/llava-v1.6-mistral-7b-hf&#x27;, object=&#x27;text_completion&#x27;, system_fingerprint=&#x27;2.0.2-native&#x27;, usage=ChatCompletionOutputUsage(completion_tokens=100, prompt_tokens=2943, total_tokens=3043))</span>
`,wrap:!1}}),N=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>, api_key=<span class="hljs-string">&quot;-&quot;</span>)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Whats in this image?&quot;</span>},
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {
                        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
                    },
                },
            ],
        },
    ],
    stream=<span class="hljs-literal">False</span>,
)

<span class="hljs-built_in">print</span>(chat_completion)
<span class="hljs-comment"># ChatCompletion(id=&#x27;&#x27;, choices=[Choice(finish_reason=&#x27;eos_token&#x27;, index=0, logprobs=None, message=ChatCompletionMessage(content=&#x27; The image depicts an anthropomorphic rabbit dressed in a space suit with gear that resembles NASA attire. The setting appears to be a solar eclipse with dramatic mountain peaks and a partial celestial body in the sky. The artwork is detailed and vivid, with a warm color palette and a sense of an adventurous bunny exploring or preparing for a journey beyond Earth. &#x27;, role=&#x27;assistant&#x27;, function_call=None, tool_calls=None))], created=1714589732, model=&#x27;llava-hf/llava-v1.6-mistral-7b-hf&#x27;, object=&#x27;text_completion&#x27;, system_fingerprint=&#x27;2.0.2-native&#x27;, usage=CompletionUsage(completion_tokens=84, prompt_tokens=2943, total_tokens=3027))</span>`,wrap:!1}}),Q=new D({props:{title:"Inference Through Sending cURL Requests",local:"inference-through-sending-curl-requests",headingTag:"h3"}}),q=new w({props:{code:"Y3VybCUyMC1OJTIwMTI3LjAuMC4xJTNBMzAwMCUyRmdlbmVyYXRlX3N0cmVhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMiElNUIlNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmFiYml0LnBuZylXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTJDJTIycGFyYW1ldGVycyUyMiUzQSU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBMTYlMkMlMjAlMjJzZWVkJTIyJTNBJTIwNDIlN0QlN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUwQSUwQSUyMyUyMC4uLiUwQSUyMyUyMGRhdGElM0ElN0IlMjJpbmRleCUyMiUzQTE2JTJDJTIydG9rZW4lMjIlM0ElN0IlMjJpZCUyMiUzQTI4NzIzJTJDJTIydGV4dCUyMiUzQSUyMi4lMjIlMkMlMjJsb2dwcm9iJTIyJTNBLTAuNjE5NjI4OSUyQyUyMnNwZWNpYWwlMjIlM0FmYWxzZSU3RCUyQyUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIyVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0LiUyMiUyQyUyMmRldGFpbHMlMjIlM0FudWxsJTdE",highlighted:`curl -N 127.0.0.1:3000/generate_stream \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{&quot;inputs&quot;:&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;,&quot;parameters&quot;:{&quot;max_new_tokens&quot;:16, &quot;seed&quot;: 42}}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># data:{&quot;index&quot;:16,&quot;token&quot;:{&quot;id&quot;:28723,&quot;text&quot;:&quot;.&quot;,&quot;logprob&quot;:-0.6196289,&quot;special&quot;:false},&quot;generated_text&quot;:&quot;This is a picture of an anthropomorphic rabbit in a space suit.&quot;,&quot;details&quot;:null}</span>`,wrap:!1}}),E=new D({props:{title:"Inference Through JavaScript",local:"inference-through-javascript",headingTag:"h3"}}),v=new w({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:"npm install @huggingface/inference",wrap:!1}}),V=new w({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2VFbmRwb2ludCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUzQiUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZUVuZHBvaW50KCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0EzMDAwJTIyJTJDJTIwJTIySEZfVE9LRU4lMjIpJTNCJTBBJTBBY29uc3QlMjBwcm9tcHQlMjAlM0QlMEElMjAlMjAlMjIhJTVCJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJhYmJpdC5wbmcpV2hhdCUyMGlzJTIwdGhpcyUyMGElMjBwaWN0dXJlJTIwb2YlM0YlNUNuJTVDbiUyMiUzQiUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwaGYudGV4dEdlbmVyYXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwcHJvbXB0JTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUyMG1heF9uZXdfdG9rZW5zJTNBJTIwMTYlMkMlMjBzZWVkJTNBJTIwNDIlMjAlN0QlMkMlMEElN0QpJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjByJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIweWllbGQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKHIudG9rZW4udGV4dCklM0IlMEElN0QlMEElMEElMkYlMkYlMjBUaGlzJTIwaXMlMjBhJTIwcGljdHVyZSUyMG9mJTIwYW4lMjBhbnRocm9wb21vcnBoaWMlMjByYWJiaXQlMjBpbiUyMGElMjBzcGFjZSUyMHN1aXQu",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInferenceEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInferenceEndpoint</span>(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>, <span class="hljs-string">&quot;HF_TOKEN&quot;</span>);

<span class="hljs-keyword">const</span> prompt =
  <span class="hljs-string">&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;</span>;

<span class="hljs-keyword">const</span> stream = hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">inputs</span>: prompt,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">16</span>, <span class="hljs-attr">seed</span>: <span class="hljs-number">42</span> },
});
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>);
}

<span class="hljs-comment">// This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),S=new D({props:{title:"Combining Vision Language Models with Other Features",local:"combining-vision-language-models-with-other-features",headingTag:"h2"}}),z=new w({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aXZpdHklMjIlM0ElMjAlMjJTdGFuZGluZyUyMiUyQyUwQSUyMCUyMCUyMmFuaW1hbHMlMjIlM0ElMjAlNUIlMjJSYWJiaXQlMjIlNUQlMkMlMEElMjAlMjAlMjJhbmltYWxzX3NlZW4lMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIybG9jYXRpb24lMjIlM0ElMjAlMjJSb2NreSUyMHN1cmZhY2UlMjB3aXRoJTIwbW91bnRhaW5zJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kJTIwYW5kJTIwYSUyMHJlZCUyMGxpZ2h0JTIwb24lMjB0aGUlMjByYWJiaXQncyUyMGNoZXN0JTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Standing&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Rabbit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Rocky surface with mountains in the background and a red light on the rabbit&#x27;s chest&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),F=new w({props:{code:"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",highlighted:`curl localhost:3000/generate \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
    &quot;inputs&quot;:&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;,
    &quot;parameters&quot;: {
        &quot;max_new_tokens&quot;: 100,
        &quot;seed&quot;: 42,
        &quot;grammar&quot;: {
            &quot;type&quot;: &quot;json&quot;,
            &quot;value&quot;: {
                &quot;properties&quot;: {
                    &quot;location&quot;: {
                        &quot;type&quot;: &quot;string&quot;
                    },
                    &quot;activity&quot;: {
                        &quot;type&quot;: &quot;string&quot;
                    },
                    &quot;animals_seen&quot;: {
                        &quot;type&quot;: &quot;integer&quot;,
                        &quot;minimum&quot;: 1,
                        &quot;maximum&quot;: 5
                    },
                    &quot;animals&quot;: {
                        &quot;type&quot;: &quot;array&quot;,
                        &quot;items&quot;: {
                            &quot;type&quot;: &quot;string&quot;
                        }
                    }
                },
                &quot;required&quot;: [&quot;location&quot;, &quot;activity&quot;, &quot;animals_seen&quot;, &quot;animals&quot;]
            }
        }
    }
}&#x27;</span>

<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &quot;generated_text&quot;: &quot;{ \\&quot;activity\\&quot;: \\&quot;Standing\\&quot;, \\&quot;animals\\&quot;: [ \\&quot;Rabbit\\&quot; ], \\&quot;animals_seen\\&quot;: 1, \\&quot;location\\&quot;: \\&quot;Rocky surface with mountains in the background and a red light on the rabbit&#x27;s chest\\&quot; }&quot;</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),L=new UM({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/visual_language_models.md"}}),{c(){u=n("meta"),K=s(),P=n("p"),ll=s(),i(c.$$.fragment),Ml=s(),I=n("p"),I.textContent=kl,tl=s(),r=n("p"),r.textContent=vl,el=s(),h=n("blockquote"),h.innerHTML=Rl,sl=s(),m=n("p"),m.textContent=Xl,al=s(),d=n("ul"),d.innerHTML=Vl,nl=s(),i(b.$$.fragment),yl=s(),i(A.$$.fragment),Ul=s(),g=n("p"),g.innerHTML=Sl,il=s(),i(G.$$.fragment),Jl=s(),i(f.$$.fragment),ol=s(),Z=n("p"),Z.innerHTML=Hl,Tl=s(),i(W.$$.fragment),jl=s(),B=n("p"),B.innerHTML=xl,pl=s(),i(N.$$.fragment),ul=s(),i(Q.$$.fragment),wl=s(),Y=n("p"),Y.innerHTML=zl,Cl=s(),i(q.$$.fragment),cl=s(),i(E.$$.fragment),Il=s(),k=n("p"),k.innerHTML=$l,rl=s(),i(v.$$.fragment),hl=s(),R=n("p"),R.innerHTML=Fl,ml=s(),X=n("p"),X.innerHTML=_l,dl=s(),i(V.$$.fragment),bl=s(),i(S.$$.fragment),Al=s(),H=n("p"),H.innerHTML=Ll,gl=s(),C=n("div"),C.innerHTML=Dl,Gl=s(),x=n("p"),x.textContent=Pl,fl=s(),i(z.$$.fragment),Zl=s(),$=n("p"),$.textContent=Ol,Wl=s(),i(F.$$.fragment),Bl=s(),_=n("p"),_.innerHTML=Kl,Nl=s(),i(L.$$.fragment),Ql=s(),O=n("p"),this.h()},l(l){const M=nM("svelte-u9bgzb",document.head);u=y(M,"META",{name:!0,content:!0}),M.forEach(t),K=a(l),P=y(l,"P",{}),lM(P).forEach(t),ll=a(l),J(c.$$.fragment,l),Ml=a(l),I=y(l,"P",{"data-svelte-h":!0}),U(I)!=="svelte-c5mqsg"&&(I.textContent=kl),tl=a(l),r=y(l,"P",{"data-svelte-h":!0}),U(r)!=="svelte-bme3bd"&&(r.textContent=vl),el=a(l),h=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),U(h)!=="svelte-oo54gt"&&(h.innerHTML=Rl),sl=a(l),m=y(l,"P",{"data-svelte-h":!0}),U(m)!=="svelte-1u3863s"&&(m.textContent=Xl),al=a(l),d=y(l,"UL",{"data-svelte-h":!0}),U(d)!=="svelte-9wqdub"&&(d.innerHTML=Vl),nl=a(l),J(b.$$.fragment,l),yl=a(l),J(A.$$.fragment,l),Ul=a(l),g=y(l,"P",{"data-svelte-h":!0}),U(g)!=="svelte-fwtu6p"&&(g.innerHTML=Sl),il=a(l),J(G.$$.fragment,l),Jl=a(l),J(f.$$.fragment,l),ol=a(l),Z=y(l,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-1bhwrgr"&&(Z.innerHTML=Hl),Tl=a(l),J(W.$$.fragment,l),jl=a(l),B=y(l,"P",{"data-svelte-h":!0}),U(B)!=="svelte-6ske6k"&&(B.innerHTML=xl),pl=a(l),J(N.$$.fragment,l),ul=a(l),J(Q.$$.fragment,l),wl=a(l),Y=y(l,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-omocvk"&&(Y.innerHTML=zl),Cl=a(l),J(q.$$.fragment,l),cl=a(l),J(E.$$.fragment,l),Il=a(l),k=y(l,"P",{"data-svelte-h":!0}),U(k)!=="svelte-1qcvblx"&&(k.innerHTML=$l),rl=a(l),J(v.$$.fragment,l),hl=a(l),R=y(l,"P",{"data-svelte-h":!0}),U(R)!=="svelte-yp1xs4"&&(R.innerHTML=Fl),ml=a(l),X=y(l,"P",{"data-svelte-h":!0}),U(X)!=="svelte-nw2yki"&&(X.innerHTML=_l),dl=a(l),J(V.$$.fragment,l),bl=a(l),J(S.$$.fragment,l),Al=a(l),H=y(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-kstfyt"&&(H.innerHTML=Ll),gl=a(l),C=y(l,"DIV",{class:!0,"data-svelte-h":!0}),U(C)!=="svelte-vm0v0f"&&(C.innerHTML=Dl),Gl=a(l),x=y(l,"P",{"data-svelte-h":!0}),U(x)!=="svelte-1fqoo0l"&&(x.textContent=Pl),fl=a(l),J(z.$$.fragment,l),Zl=a(l),$=y(l,"P",{"data-svelte-h":!0}),U($)!=="svelte-4bcx48"&&($.textContent=Ol),Wl=a(l),J(F.$$.fragment,l),Bl=a(l),_=y(l,"P",{"data-svelte-h":!0}),U(_)!=="svelte-am908w"&&(_.innerHTML=Kl),Nl=a(l),J(L.$$.fragment,l),Ql=a(l),O=y(l,"P",{}),lM(O).forEach(t),this.h()},h(){ql(u,"name","hf:doc:metadata"),ql(u,"content",JM),ql(C,"class","flex justify-center")},m(l,M){yM(document.head,u),e(l,K,M),e(l,P,M),e(l,ll,M),o(c,l,M),e(l,Ml,M),e(l,I,M),e(l,tl,M),e(l,r,M),e(l,el,M),e(l,h,M),e(l,sl,M),e(l,m,M),e(l,al,M),e(l,d,M),e(l,nl,M),o(b,l,M),e(l,yl,M),o(A,l,M),e(l,Ul,M),e(l,g,M),e(l,il,M),o(G,l,M),e(l,Jl,M),o(f,l,M),e(l,ol,M),e(l,Z,M),e(l,Tl,M),o(W,l,M),e(l,jl,M),e(l,B,M),e(l,pl,M),o(N,l,M),e(l,ul,M),o(Q,l,M),e(l,wl,M),e(l,Y,M),e(l,Cl,M),o(q,l,M),e(l,cl,M),o(E,l,M),e(l,Il,M),e(l,k,M),e(l,rl,M),o(v,l,M),e(l,hl,M),e(l,R,M),e(l,ml,M),e(l,X,M),e(l,dl,M),o(V,l,M),e(l,bl,M),o(S,l,M),e(l,Al,M),e(l,H,M),e(l,gl,M),e(l,C,M),e(l,Gl,M),e(l,x,M),e(l,fl,M),o(z,l,M),e(l,Zl,M),e(l,$,M),e(l,Wl,M),o(F,l,M),e(l,Bl,M),e(l,_,M),e(l,Nl,M),o(L,l,M),e(l,Ql,M),e(l,O,M),Yl=!0},p:tM,i(l){Yl||(T(c.$$.fragment,l),T(b.$$.fragment,l),T(A.$$.fragment,l),T(G.$$.fragment,l),T(f.$$.fragment,l),T(W.$$.fragment,l),T(N.$$.fragment,l),T(Q.$$.fragment,l),T(q.$$.fragment,l),T(E.$$.fragment,l),T(v.$$.fragment,l),T(V.$$.fragment,l),T(S.$$.fragment,l),T(z.$$.fragment,l),T(F.$$.fragment,l),T(L.$$.fragment,l),Yl=!0)},o(l){j(c.$$.fragment,l),j(b.$$.fragment,l),j(A.$$.fragment,l),j(G.$$.fragment,l),j(f.$$.fragment,l),j(W.$$.fragment,l),j(N.$$.fragment,l),j(Q.$$.fragment,l),j(q.$$.fragment,l),j(E.$$.fragment,l),j(v.$$.fragment,l),j(V.$$.fragment,l),j(S.$$.fragment,l),j(z.$$.fragment,l),j(F.$$.fragment,l),j(L.$$.fragment,l),Yl=!1},d(l){l&&(t(K),t(P),t(ll),t(Ml),t(I),t(tl),t(r),t(el),t(h),t(sl),t(m),t(al),t(d),t(nl),t(yl),t(Ul),t(g),t(il),t(Jl),t(ol),t(Z),t(Tl),t(jl),t(B),t(pl),t(ul),t(wl),t(Y),t(Cl),t(cl),t(Il),t(k),t(rl),t(hl),t(R),t(ml),t(X),t(dl),t(bl),t(Al),t(H),t(gl),t(C),t(Gl),t(x),t(fl),t(Zl),t($),t(Wl),t(Bl),t(_),t(Nl),t(Ql),t(O)),t(u),p(c,l),p(b,l),p(A,l),p(G,l),p(f,l),p(W,l),p(N,l),p(Q,l),p(q,l),p(E,l),p(v,l),p(V,l),p(S,l),p(z,l),p(F,l),p(L,l)}}}const JM='{"title":"Vision Language Model Inference in TGI","local":"vision-language-model-inference-in-tgi","sections":[{"title":"How to Use a Vision Language Model?","local":"how-to-use-a-vision-language-model","sections":[{"title":"Hugging Face Hub Python Library","local":"hugging-face-hub-python-library","sections":[],"depth":3},{"title":"Inference Through Sending cURL Requests","local":"inference-through-sending-curl-requests","sections":[],"depth":3},{"title":"Inference Through JavaScript","local":"inference-through-javascript","sections":[],"depth":3}],"depth":2},{"title":"Combining Vision Language Models with Other Features","local":"combining-vision-language-models-with-other-features","sections":[],"depth":2}],"depth":1}';function oM(El){return eM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wM extends sM{constructor(u){super(),aM(this,u,oM,iM,MM,{})}}export{wM as component};
