import{s as TM,n as JM,o as sM}from"../chunks/scheduler.362310b7.js";import{S as aM,i as CM,g as J,s as t,r as C,A as jM,h as s,f as U,c as T,j as eM,u as j,x as a,k as tM,y as nM,a as e,v as n,d as A,t as y,w}from"../chunks/index.57dfc70d.js";import{C as Sl}from"../chunks/CodeBlock.5d40996c.js";import{H as $,E as AM}from"../chunks/index.289153e6.js";function yM(fl){let i,K,H,q,I,ll,r,Bl="This document aims at describing the architecture of Text Generation Inference (TGI), by describing the call flow between the separate components.",Ml,o,vl="A high-level architecture diagram can be seen here:",Ul,p,Zl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/TGI.png" alt="TGI architecture"/>',el,c,kl="This diagram shows well there are these separate components:",tl,V,Xl="<li><strong>The router</strong>, also named <code>webserver</code>, that receives the client requests, buffers them, creates some batches, and prepares gRPC calls to a model server.</li> <li><strong>The launcher</strong> is a helper that will be able to launch one or several model servers (if model is sharded), and it launches the router with the compatible arguments.</li> <li><strong>The model server</strong>, responsible for receiving the gRPC requests and to process the inference on the model. If the model is sharded across multiple accelerators (e.g.: multiple GPUs), the model server shards might be synchronized via NCCL or equivalent.</li>",Tl,N,Dl="Note that for other backends (eg. TRTLLM) the model server and launcher are specific to the backend.",Jl,h,Wl="The router and the model server can be two different machines, they do not need to be deployed together.",sl,d,al,m,Gl=`This component is a rust web server binary that accepts HTTP requests using the custom <a href="https://huggingface.github.io/text-generation-inference/" rel="nofollow">HTTP API</a>, as well as OpenAI’s <a href="https://huggingface.co/docs/text-generation-inference/messages_api" rel="nofollow">Messages API</a>.
The router receives the API calls and handles the “baches” logic (and introduction to batching can be found <a href="https://github.com/huggingface/text-generation-inference/blob/main/router/README.md" rel="nofollow">here</a>).
It uses different strategies to reduce latency between requests and responses, especially oriented to decoding latency. It will use queues, schedulers, and block allocators to achieve that and produce batched requests that it will then be sent to the model server.`,Cl,R,jl,F,_l="The router command line will be the way to pass parameters to it (it does not rely on configuration file):",nl,g,Al,u,yl,Q,zl=`The model server is a python server, capable of starting a server waiting for gRPC requests, loads a given model, perform sharding to provide <a href="https://huggingface.co/docs/text-generation-inference/conceptual/tensor_parallelism" rel="nofollow">tensor parallelism</a>, and stays alive while waiting for new requests.
The model server supports models instantiated using Pytorch and optimized for inference mainly on CUDA/ROCM.`,wl,O,il,b,xl="Several variants of the model server exist that are actively supported by Hugging Face:",Il,E,Ll='<li>By default, the model server will attempt building <a href="https://huggingface.co/docs/text-generation-inference/installation_nvidia" rel="nofollow">a server optimized for Nvidia GPUs with CUDA</a>. The code for this version is hosted in the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">main TGI repository</a>.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_amd" rel="nofollow">version optimized for AMD with ROCm</a> is hosted in the main TGI repository. Some model features differ.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_intel" rel="nofollow">version optimized for Intel GPUs</a> is hosted in the main TGI repository. Some model features differ.</li> <li>The <a href="https://huggingface.co/docs/text-generation-inference/installation_gaudi" rel="nofollow">version for Intel Gaudi</a> is maintained on a forked repository, often resynchronized with the main <a href="https://github.com/huggingface/tgi-gaudi" rel="nofollow">TGI repository</a>.</li> <li>A <a href="https://huggingface.co/docs/text-generation-inference/installation_inferentia" rel="nofollow">version for Neuron (AWS Inferentia2)</a> is maintained in the main TGI repository. Some model features differ.</li> <li>A version for Google TPUs is maintained as part of <a href="https://github.com/huggingface/optimum-tpu/tree/main/text-generation-inference" rel="nofollow">Optimum TPU</a>.</li>',rl,S,Yl="Not all variants provide the same features, as hardware and middleware capabilities do not provide the same optimizations.",ol,f,pl,B,$l="The official command line interface (CLI) for the server supports three subcommands, <code>download-weights</code>, <code>quantize</code> and <code>serve</code>:",cl,v,Hl="<li><code>download-weights</code> will download weights from the hub and, in some variants it will convert weights to a format that is adapted to the given implementation;</li> <li><code>quantize</code> will allow to quantize a model using the <code>qptq</code> package. This feature is not available nor supported on all variants;</li> <li><code>serve</code> will start the server that load a model (or a model shard), receives gRPC calls from the router, performs an inference and provides a formatted response to the given request.</li>",Vl,Z,Pl="Serve’s command line parameters on the TGI repository are these:",Nl,k,hl,X,Kl="Note that some variants might support different parameters, and they could possibly accept more options that can be passed on using environment variables.",dl,D,ml,W,ql='Once both components are initialized, weights downloaded and model server is up and running, router and model server exchange data and info through the gRPC call. There are currently two supported schemas, <a href="https://github.com/huggingface/text-generation-inference/blob/main/proto/generate.proto" rel="nofollow">v2</a> and <a href="https://github.com/huggingface/text-generation-inference/blob/main/proto/v3/generate.proto" rel="nofollow">v3</a>. These two versions are almost identical, except for:',Rl,G,lM="<li>input chunks support, for text and image data,</li> <li>paged attention support</li>",Fl,_,MM="Here’s a diagram that displays the exchanges that follow the router and model server startup.",gl,z,ul,x,UM="After these are done, the router is ready to receive generate calls from multiple clients. Here’s an example.",Ql,L,Ol,Y,bl,P,El;return I=new $({props:{title:"Text Generation Inference Architecture",local:"text-generation-inference-architecture",headingTag:"h1"}}),d=new $({props:{title:"The Router",local:"the-router",headingTag:"h2"}}),R=new $({props:{title:"Router’s command line",local:"routers-command-line",headingTag:"h3"}}),g=new Sl({props:{code:"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",highlighted:`Text Generation Webserver

Usage: text-generation-router <span class="hljs-selector-attr">[OPTIONS]</span>

Options:
      <span class="hljs-attr">--max-concurrent-requests</span> &lt;MAX_CONCURRENT_REQUESTS&gt;
          <span class="hljs-selector-attr">[env: MAX_CONCURRENT_REQUESTS=]</span> <span class="hljs-selector-attr">[default: 128]</span>
      <span class="hljs-attr">--max-best-of</span> &lt;MAX_BEST_OF&gt;
          <span class="hljs-selector-attr">[env: MAX_BEST_OF=]</span> <span class="hljs-selector-attr">[default: 2]</span>
      <span class="hljs-attr">--max-stop-sequences</span> &lt;MAX_STOP_SEQUENCES&gt;
          <span class="hljs-selector-attr">[env: MAX_STOP_SEQUENCES=]</span> <span class="hljs-selector-attr">[default: 4]</span>
      <span class="hljs-attr">--max-top-n-tokens</span> &lt;MAX_TOP_N_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_TOP_N_TOKENS=]</span> <span class="hljs-selector-attr">[default: 5]</span>
      <span class="hljs-attr">--max-input-tokens</span> &lt;MAX_INPUT_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_INPUT_TOKENS=]</span> <span class="hljs-selector-attr">[default: 1024]</span>
      <span class="hljs-attr">--max-total-tokens</span> &lt;MAX_TOTAL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_TOTAL_TOKENS=]</span> <span class="hljs-selector-attr">[default: 2048]</span>
      <span class="hljs-attr">--waiting-served-ratio</span> &lt;WAITING_SERVED_RATIO&gt;
          <span class="hljs-selector-attr">[env: WAITING_SERVED_RATIO=]</span> <span class="hljs-selector-attr">[default: 1.2]</span>
      <span class="hljs-attr">--max-batch-prefill-tokens</span> &lt;MAX_BATCH_PREFILL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_PREFILL_TOKENS=]</span> <span class="hljs-selector-attr">[default: 4096]</span>
      <span class="hljs-attr">--max-batch-total-tokens</span> &lt;MAX_BATCH_TOTAL_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_TOTAL_TOKENS=]</span>
      <span class="hljs-attr">--max-waiting-tokens</span> &lt;MAX_WAITING_TOKENS&gt;
          <span class="hljs-selector-attr">[env: MAX_WAITING_TOKENS=]</span> <span class="hljs-selector-attr">[default: 20]</span>
      <span class="hljs-attr">--max-batch-size</span> &lt;MAX_BATCH_SIZE&gt;
          <span class="hljs-selector-attr">[env: MAX_BATCH_SIZE=]</span>
      <span class="hljs-attr">--hostname</span> &lt;HOSTNAME&gt;
          <span class="hljs-selector-attr">[env: HOSTNAME=]</span> <span class="hljs-selector-attr">[default: 0.0.0.0]</span>
  -<span class="hljs-selector-tag">p</span>, <span class="hljs-attr">--port</span> &lt;PORT&gt;
          <span class="hljs-selector-attr">[env: PORT=]</span> <span class="hljs-selector-attr">[default: 3000]</span>
      <span class="hljs-attr">--master-shard-uds-path</span> &lt;MASTER_SHARD_UDS_PATH&gt;
          <span class="hljs-selector-attr">[env: MASTER_SHARD_UDS_PATH=]</span> <span class="hljs-selector-attr">[default: /tmp/text-generation-server-0]</span>
      <span class="hljs-attr">--tokenizer-name</span> &lt;TOKENIZER_NAME&gt;
          <span class="hljs-selector-attr">[env: TOKENIZER_NAME=]</span> <span class="hljs-selector-attr">[default: bigscience/bloom]</span>
      <span class="hljs-attr">--tokenizer-config-path</span> &lt;TOKENIZER_CONFIG_PATH&gt;
          <span class="hljs-selector-attr">[env: TOKENIZER_CONFIG_PATH=]</span>
      <span class="hljs-attr">--revision</span> &lt;REVISION&gt;
          <span class="hljs-selector-attr">[env: REVISION=]</span>
      <span class="hljs-attr">--validation-workers</span> &lt;VALIDATION_WORKERS&gt;
          <span class="hljs-selector-attr">[env: VALIDATION_WORKERS=]</span> <span class="hljs-selector-attr">[default: 2]</span>
      <span class="hljs-attr">--json-output</span>
          <span class="hljs-selector-attr">[env: JSON_OUTPUT=]</span>
      <span class="hljs-attr">--otlp-endpoint</span> &lt;OTLP_ENDPOINT&gt;
          <span class="hljs-selector-attr">[env: OTLP_ENDPOINT=]</span>
      <span class="hljs-attr">--otlp-service-name</span> &lt;OTLP_SERVICE_NAME&gt;
          <span class="hljs-selector-attr">[env: OTLP_SERVICE_NAME=]</span>
      <span class="hljs-attr">--cors-allow-origin</span> &lt;CORS_ALLOW_ORIGIN&gt;
          <span class="hljs-selector-attr">[env: CORS_ALLOW_ORIGIN=]</span>
      <span class="hljs-attr">--ngrok</span>
          <span class="hljs-selector-attr">[env: NGROK=]</span>
      <span class="hljs-attr">--ngrok-authtoken</span> &lt;NGROK_AUTHTOKEN&gt;
          <span class="hljs-selector-attr">[env: NGROK_AUTHTOKEN=]</span>
      <span class="hljs-attr">--ngrok-edge</span> &lt;NGROK_EDGE&gt;
          <span class="hljs-selector-attr">[env: NGROK_EDGE=]</span>
      <span class="hljs-attr">--messages-api-enabled</span>
          <span class="hljs-selector-attr">[env: MESSAGES_API_ENABLED=]</span>
      <span class="hljs-attr">--disable-grammar-support</span>
          <span class="hljs-selector-attr">[env: DISABLE_GRAMMAR_SUPPORT=]</span>
      <span class="hljs-attr">--max-client-batch-size</span> &lt;MAX_CLIENT_BATCH_SIZE&gt;
          <span class="hljs-selector-attr">[env: MAX_CLIENT_BATCH_SIZE=]</span> <span class="hljs-selector-attr">[default: 4]</span>
  -h, <span class="hljs-attr">--help</span>
          Print help
  -V, <span class="hljs-attr">--version</span>
          Print version`,wrap:!1}}),u=new $({props:{title:"The Model Server",local:"the-model-server",headingTag:"h2"}}),O=new $({props:{title:"Model Server Variants",local:"model-server-variants",headingTag:"h3"}}),f=new $({props:{title:"Command Line Interface",local:"command-line-interface",headingTag:"h3"}}),k=new Sl({props:{code:"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",highlighted:` Usage: cli.py serve [OPTIONS] MODEL_ID

╭─ Arguments ──────────────────────────────────────────────────────────────────────────────────────────────╮
│ *    model_id      TEXT  [default: None] [required]                                                      │
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────╯
╭─ Options ────────────────────────────────────────────────────────────────────────────────────────────────╮
│ <span class="hljs-params">--revision</span>                                       TEXT                        [default: None]             │
│ <span class="hljs-params">--sharded</span>              <span class="hljs-params">--no-sharded</span>                                          [default: no-sharded]       │
│ <span class="hljs-params">--quantize</span>                                       [bitsandbytes|bitsandbytes  [default: None]             │
│                                                  -nf4|bitsandbytes-fp4|gptq                              │
│                                                  |awq|eetq|exl2|fp8]                                     │
│ <span class="hljs-params">--speculate</span>                                      INTEGER                     [default: None]             │
│ <span class="hljs-params">--dtype</span>                                          [float16|bfloat16]          [default: None]             │
│ <span class="hljs-params">--trust-remote-code</span>    <span class="hljs-params">--no-trust-remote-code</span>                                [default:                   │
│                                                                              no-trust-remote-code]       │
│ <span class="hljs-params">--uds-path</span>                                       PATH                        [default:                   │
│                                                                              <span class="hljs-string">/tmp/text-generation-serve</span>… │
│ <span class="hljs-params">--logger-level</span>                                   TEXT                        [default: INFO]             │
│ <span class="hljs-params">--json-output</span>          <span class="hljs-params">--no-json-output</span>                                      [default: no-json-output]   │
│ <span class="hljs-params">--otlp-endpoint</span>                                  TEXT                        [default: None]             │
│ <span class="hljs-params">--otlp-service-name</span>                              TEXT                        [default:                   │
│                                                                              text-generation-inference.<span class="hljs-string">..</span>│
│ <span class="hljs-params">--help</span>                                                                       Show this message and exit. │
╰──────────────────────────────────────────────────────────────────────────────────────────────────────────╯`,wrap:!1}}),D=new $({props:{title:"Call Flow",local:"call-flow",headingTag:"h2"}}),z=new Sl({props:{code:"c2VxdWVuY2VEaWFncmFtJTBBJTBBJTIwJTIwJTIwJTIwUm91dGVyLSUzRSUzRU1vZGVsJTIwU2VydmVyJTNBJTIwc2VydmljZSUyMGRpc2NvdmVyeSUwQSUyMCUyMCUyMCUyME1vZGVsJTIwU2VydmVyLS0lM0UlM0VSb3V0ZXIlM0ElMjB1cmxzJTIwZm9yJTIwb3RoZXIlMjBzaGFyZHMlMEElMEElMjAlMjAlMjAlMjBSb3V0ZXItJTNFJTNFTW9kZWwlMjBTZXJ2ZXIlM0ElMjBnZXQlMjBtb2RlbCUyMGluZm8lMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwc2hhcmQlMjBpbmZvJTBBJTBBJTIwJTIwJTIwJTIwUm91dGVyLSUzRSUzRU1vZGVsJTIwU2VydmVyJTNBJTIwaGVhbHRoJTIwY2hlY2slMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwaGVhbHRoJTIwT0slMEElMEElMjAlMjAlMjAlMjBSb3V0ZXItJTNFJTNFTW9kZWwlMjBTZXJ2ZXIlM0ElMjB3YXJtdXAobWF4X2lucHV0X3Rva2VucyUyQyUyMG1heF9iYXRjaF9wcmVmaWxsX3Rva2VucyUyQyUyMG1heF90b3RhbF90b2tlbnMlMkMlMjBtYXhfYmF0Y2hfc2l6ZSklMEElMjAlMjAlMjAlMjBNb2RlbCUyMFNlcnZlci0tJTNFJTNFUm91dGVyJTNBJTIwd2FybXVwJTIwcmVzdWx0",highlighted:`sequenceDiagram

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: service discovery
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: urls <span class="hljs-keyword">for</span> other shards

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: get model info
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: shard info

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: health check
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: health OK

    R<span class="hljs-function"><span class="hljs-title">outer</span>-&gt;</span>&gt;Model Server: warmup(max_input_tokens, max_batch_prefill_tokens, max_total_tokens, max_batch_size)
    M<span class="hljs-function"><span class="hljs-title">odel</span> Server--&gt;</span>&gt;Router: warmup result`,wrap:!1}}),L=new Sl({props:{code:"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",highlighted:`sequenceDiagram
    participant Client <span class="hljs-number">1</span>
    participant Client <span class="hljs-number">2</span>
    participant Client <span class="hljs-number">3</span>
    participant Router
    participant Model Server

    Client <span class="hljs-number">1</span>-&gt;&gt;Router: generate_stream
    Router-&gt;&gt;Model Server: prefill(batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">1</span>

    Router-&gt;&gt;Model Server: decode(cached_batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">2</span>

    Router-&gt;&gt;Model Server: decode(cached_batch1)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">3</span>

    Client <span class="hljs-number">2</span>-&gt;&gt;Router: generate_stream
    Router-&gt;&gt;Model Server: prefill(batch2)
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted
    Model Server--&gt;&gt;Router: generations, cached_batch2, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">1</span>&#x27;

    Router-&gt;&gt;Model Server: decode(cached_batch1, cached_batch2)
    Model Server--&gt;&gt;Router: generations, cached_batch1, timings
    Router--&gt;&gt;Client <span class="hljs-number">1</span>: token <span class="hljs-number">4</span>
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">2</span>&#x27;

    Note <span class="hljs-built_in">left</span> of Client <span class="hljs-number">1</span>: Client <span class="hljs-number">1</span> leaves
    Router-&gt;&gt;Model Server: filter_batch(cached_batch1, request_ids_to_keep=batch2)
    Model Server--&gt;&gt;Router: filtered batch

    Router-&gt;&gt;Model Server: decode(cached_batch2)
    Model Server--&gt;&gt;Router: generations, cached_batch2, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">3</span>&#x27;

    Client <span class="hljs-number">3</span>-&gt;&gt;Router: generate_stream
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted
    Router-&gt;&gt;Model Server: prefill(batch3)
    Note <span class="hljs-built_in">left</span> of Client <span class="hljs-number">1</span>: Client <span class="hljs-number">3</span> leaves without receiving any batch
    Router-&gt;&gt;Model Server: clear_cache(batch3)
    Note <span class="hljs-built_in">right</span> of Model Server: This stops previous batch, that is restarted

    Router-&gt;&gt;Model Server: decode(cached_batch3)
    Note <span class="hljs-built_in">right</span> of Model Server: Last token (stopping criteria)
    Model Server--&gt;&gt;Router: generations, cached_batch3, timings
    Router--&gt;&gt;Client <span class="hljs-number">2</span>: token <span class="hljs-number">4</span>&#x27;

`,wrap:!1}}),Y=new AM({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/architecture.md"}}),{c(){i=J("meta"),K=t(),H=J("p"),q=t(),C(I.$$.fragment),ll=t(),r=J("p"),r.textContent=Bl,Ml=t(),o=J("p"),o.textContent=vl,Ul=t(),p=J("p"),p.innerHTML=Zl,el=t(),c=J("p"),c.textContent=kl,tl=t(),V=J("ul"),V.innerHTML=Xl,Tl=t(),N=J("p"),N.textContent=Dl,Jl=t(),h=J("p"),h.textContent=Wl,sl=t(),C(d.$$.fragment),al=t(),m=J("p"),m.innerHTML=Gl,Cl=t(),C(R.$$.fragment),jl=t(),F=J("p"),F.textContent=_l,nl=t(),C(g.$$.fragment),Al=t(),C(u.$$.fragment),yl=t(),Q=J("p"),Q.innerHTML=zl,wl=t(),C(O.$$.fragment),il=t(),b=J("p"),b.textContent=xl,Il=t(),E=J("ul"),E.innerHTML=Ll,rl=t(),S=J("p"),S.textContent=Yl,ol=t(),C(f.$$.fragment),pl=t(),B=J("p"),B.innerHTML=$l,cl=t(),v=J("ul"),v.innerHTML=Hl,Vl=t(),Z=J("p"),Z.textContent=Pl,Nl=t(),C(k.$$.fragment),hl=t(),X=J("p"),X.textContent=Kl,dl=t(),C(D.$$.fragment),ml=t(),W=J("p"),W.innerHTML=ql,Rl=t(),G=J("ul"),G.innerHTML=lM,Fl=t(),_=J("p"),_.textContent=MM,gl=t(),C(z.$$.fragment),ul=t(),x=J("p"),x.textContent=UM,Ql=t(),C(L.$$.fragment),Ol=t(),C(Y.$$.fragment),bl=t(),P=J("p"),this.h()},l(l){const M=jM("svelte-u9bgzb",document.head);i=s(M,"META",{name:!0,content:!0}),M.forEach(U),K=T(l),H=s(l,"P",{}),eM(H).forEach(U),q=T(l),j(I.$$.fragment,l),ll=T(l),r=s(l,"P",{"data-svelte-h":!0}),a(r)!=="svelte-vphelk"&&(r.textContent=Bl),Ml=T(l),o=s(l,"P",{"data-svelte-h":!0}),a(o)!=="svelte-772u2a"&&(o.textContent=vl),Ul=T(l),p=s(l,"P",{"data-svelte-h":!0}),a(p)!=="svelte-1l2f8t4"&&(p.innerHTML=Zl),el=T(l),c=s(l,"P",{"data-svelte-h":!0}),a(c)!=="svelte-1lzr5l3"&&(c.textContent=kl),tl=T(l),V=s(l,"UL",{"data-svelte-h":!0}),a(V)!=="svelte-1493yaa"&&(V.innerHTML=Xl),Tl=T(l),N=s(l,"P",{"data-svelte-h":!0}),a(N)!=="svelte-1wobxln"&&(N.textContent=Dl),Jl=T(l),h=s(l,"P",{"data-svelte-h":!0}),a(h)!=="svelte-9in8o2"&&(h.textContent=Wl),sl=T(l),j(d.$$.fragment,l),al=T(l),m=s(l,"P",{"data-svelte-h":!0}),a(m)!=="svelte-12wcxfx"&&(m.innerHTML=Gl),Cl=T(l),j(R.$$.fragment,l),jl=T(l),F=s(l,"P",{"data-svelte-h":!0}),a(F)!=="svelte-vrz9ad"&&(F.textContent=_l),nl=T(l),j(g.$$.fragment,l),Al=T(l),j(u.$$.fragment,l),yl=T(l),Q=s(l,"P",{"data-svelte-h":!0}),a(Q)!=="svelte-1fiirti"&&(Q.innerHTML=zl),wl=T(l),j(O.$$.fragment,l),il=T(l),b=s(l,"P",{"data-svelte-h":!0}),a(b)!=="svelte-hdemao"&&(b.textContent=xl),Il=T(l),E=s(l,"UL",{"data-svelte-h":!0}),a(E)!=="svelte-zzzshx"&&(E.innerHTML=Ll),rl=T(l),S=s(l,"P",{"data-svelte-h":!0}),a(S)!=="svelte-12gjbvy"&&(S.textContent=Yl),ol=T(l),j(f.$$.fragment,l),pl=T(l),B=s(l,"P",{"data-svelte-h":!0}),a(B)!=="svelte-8olu0s"&&(B.innerHTML=$l),cl=T(l),v=s(l,"UL",{"data-svelte-h":!0}),a(v)!=="svelte-1gvj873"&&(v.innerHTML=Hl),Vl=T(l),Z=s(l,"P",{"data-svelte-h":!0}),a(Z)!=="svelte-1v1wq4t"&&(Z.textContent=Pl),Nl=T(l),j(k.$$.fragment,l),hl=T(l),X=s(l,"P",{"data-svelte-h":!0}),a(X)!=="svelte-182mwi5"&&(X.textContent=Kl),dl=T(l),j(D.$$.fragment,l),ml=T(l),W=s(l,"P",{"data-svelte-h":!0}),a(W)!=="svelte-10nkdn7"&&(W.innerHTML=ql),Rl=T(l),G=s(l,"UL",{"data-svelte-h":!0}),a(G)!=="svelte-1e4xpg3"&&(G.innerHTML=lM),Fl=T(l),_=s(l,"P",{"data-svelte-h":!0}),a(_)!=="svelte-16m2ryh"&&(_.textContent=MM),gl=T(l),j(z.$$.fragment,l),ul=T(l),x=s(l,"P",{"data-svelte-h":!0}),a(x)!=="svelte-1qai9e7"&&(x.textContent=UM),Ql=T(l),j(L.$$.fragment,l),Ol=T(l),j(Y.$$.fragment,l),bl=T(l),P=s(l,"P",{}),eM(P).forEach(U),this.h()},h(){tM(i,"name","hf:doc:metadata"),tM(i,"content",wM)},m(l,M){nM(document.head,i),e(l,K,M),e(l,H,M),e(l,q,M),n(I,l,M),e(l,ll,M),e(l,r,M),e(l,Ml,M),e(l,o,M),e(l,Ul,M),e(l,p,M),e(l,el,M),e(l,c,M),e(l,tl,M),e(l,V,M),e(l,Tl,M),e(l,N,M),e(l,Jl,M),e(l,h,M),e(l,sl,M),n(d,l,M),e(l,al,M),e(l,m,M),e(l,Cl,M),n(R,l,M),e(l,jl,M),e(l,F,M),e(l,nl,M),n(g,l,M),e(l,Al,M),n(u,l,M),e(l,yl,M),e(l,Q,M),e(l,wl,M),n(O,l,M),e(l,il,M),e(l,b,M),e(l,Il,M),e(l,E,M),e(l,rl,M),e(l,S,M),e(l,ol,M),n(f,l,M),e(l,pl,M),e(l,B,M),e(l,cl,M),e(l,v,M),e(l,Vl,M),e(l,Z,M),e(l,Nl,M),n(k,l,M),e(l,hl,M),e(l,X,M),e(l,dl,M),n(D,l,M),e(l,ml,M),e(l,W,M),e(l,Rl,M),e(l,G,M),e(l,Fl,M),e(l,_,M),e(l,gl,M),n(z,l,M),e(l,ul,M),e(l,x,M),e(l,Ql,M),n(L,l,M),e(l,Ol,M),n(Y,l,M),e(l,bl,M),e(l,P,M),El=!0},p:JM,i(l){El||(A(I.$$.fragment,l),A(d.$$.fragment,l),A(R.$$.fragment,l),A(g.$$.fragment,l),A(u.$$.fragment,l),A(O.$$.fragment,l),A(f.$$.fragment,l),A(k.$$.fragment,l),A(D.$$.fragment,l),A(z.$$.fragment,l),A(L.$$.fragment,l),A(Y.$$.fragment,l),El=!0)},o(l){y(I.$$.fragment,l),y(d.$$.fragment,l),y(R.$$.fragment,l),y(g.$$.fragment,l),y(u.$$.fragment,l),y(O.$$.fragment,l),y(f.$$.fragment,l),y(k.$$.fragment,l),y(D.$$.fragment,l),y(z.$$.fragment,l),y(L.$$.fragment,l),y(Y.$$.fragment,l),El=!1},d(l){l&&(U(K),U(H),U(q),U(ll),U(r),U(Ml),U(o),U(Ul),U(p),U(el),U(c),U(tl),U(V),U(Tl),U(N),U(Jl),U(h),U(sl),U(al),U(m),U(Cl),U(jl),U(F),U(nl),U(Al),U(yl),U(Q),U(wl),U(il),U(b),U(Il),U(E),U(rl),U(S),U(ol),U(pl),U(B),U(cl),U(v),U(Vl),U(Z),U(Nl),U(hl),U(X),U(dl),U(ml),U(W),U(Rl),U(G),U(Fl),U(_),U(gl),U(ul),U(x),U(Ql),U(Ol),U(bl),U(P)),U(i),w(I,l),w(d,l),w(R,l),w(g,l),w(u,l),w(O,l),w(f,l),w(k,l),w(D,l),w(z,l),w(L,l),w(Y,l)}}}const wM='{"title":"Text Generation Inference Architecture","local":"text-generation-inference-architecture","sections":[{"title":"The Router","local":"the-router","sections":[{"title":"Router’s command line","local":"routers-command-line","sections":[],"depth":3}],"depth":2},{"title":"The Model Server","local":"the-model-server","sections":[{"title":"Model Server Variants","local":"model-server-variants","sections":[],"depth":3},{"title":"Command Line Interface","local":"command-line-interface","sections":[],"depth":3}],"depth":2},{"title":"Call Flow","local":"call-flow","sections":[],"depth":2}],"depth":1}';function iM(fl){return sM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cM extends aM{constructor(i){super(),CM(this,i,iM,yM,TM,{})}}export{cM as component};
