import{s as ze,n as Xe,o as Pe}from"../chunks/scheduler.362310b7.js";import{S as De,i as Fe,g as i,s as l,r as p,A as Ke,h as r,f as t,c as a,j as Le,u as c,x as o,k as X,y as Oe,a as n,v as h,d as y,t as M,w as m}from"../chunks/index.57dfc70d.js";import{C as ve}from"../chunks/CodeBlock.5d40996c.js";import{H as A,E as es}from"../chunks/index.289153e6.js";function ss(Se){let u,P,L,D,T,F,J,K,g,$e="Token streaming is the mode in which the server returns the tokens one by one as the model generates them. This enables showing progressive generations to the user rather than waiting for the whole generation. Streaming is an essential aspect of the end-user experience as it reduces latency, one of the most critical aspects of a smooth experience.",O,w,ke='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual_360.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/streaming-generation-visual-dark_360.gif"/>',ee,j,Be="With token streaming, the server can start returning the tokens one by one before having to generate the whole response. Users can have a sense of the generation’s quality before the end of the generation. This has different positive effects:",se,f,Qe="<li>Users can get results orders of magnitude earlier for extremely long queries.</li> <li>Seeing something in progress allows users to stop the generation if it’s not going in the direction they expect.</li> <li>Perceived latency is lower when results are shown in the early stages.</li> <li>When used in conversational UIs, the experience feels more natural.</li>",te,C,qe="For example, a system can generate 100 tokens per second. If the system generates 1000 tokens, with the non-streaming setup, users need to wait 10 seconds to get results. On the other hand, with the streaming setup, users get initial results immediately, and although end-to-end latency will be the same, they can see half of the generation after five seconds. Below you can see an interactive demo that shows non-streaming vs streaming side-by-side. Click <strong>generate</strong> below.",ne,U,Ee='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=light" width="850" height="350"></iframe>',le,d,Ze='<iframe src="https://osanseviero-streaming-vs-non-streaming.hf.space?__theme=dark" width="850" height="350"></iframe>',ae,I,ie,b,re,v,xe="To stream tokens with <code>InferenceClient</code>, simply pass <code>stream=True</code> and iterate over the response.",oe,S,pe,$,We="The <code>huggingface_hub</code> library also comes with an <code>AsyncInferenceClient</code> in case you need to handle the requests concurrently.",ce,k,he,B,ye,Q,Ge="To use the OpenAI Chat Completions compatible Messages API <code>v1/chat/completions</code> endpoint with curl, you can add the <code>-N</code> flag, which disables curl default buffering and shows data as it arrives from the server",Me,q,me,E,ue,Z,He=`First, we need to install the <code>@huggingface/inference</code> library.
<code>npm install @huggingface/inference</code>`,we,x,Ne="If you’re using the free Inference API, you can use <code>HfInference</code>. If you’re using inference endpoints, you can use <code>HfInferenceEndpoint</code>.",Ue,W,_e="We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and credential.",de,G,Te,H,Je,N,Ve="Under the hood, TGI uses Server-Sent Events (SSE). In an SSE Setup, a client sends a request with the data, opening an HTTP connection and subscribing to updates. Afterward, the server sends data to the client. There is no need for further requests; the server will keep sending the data. SSEs are unidirectional, meaning the client does not send other requests to the server. SSE sends data over HTTP, making it easy to use.",ge,_,Ye="SSEs are different than:",je,V,Re="<li>Polling: where the client keeps calling the server to get data. This means that the server might return empty responses and cause overhead.</li> <li>Webhooks: where there is a bi-directional connection. The server can send information to the client, but the client can also send data to the server after the first request. Webhooks are more complex to operate as they don’t only use HTTP.</li>",fe,Y,Ae="If there are too many requests at the same time, TGI returns an HTTP Error with an <code>overloaded</code> error type (<code>huggingface_hub</code> returns <code>OverloadedError</code>). This allows the client to manage the overloaded server (e.g., it could display a busy error to the user or retry with a new request). To configure the maximum number of concurrent requests, you can specify <code>--max_concurrent_requests</code>, allowing clients to handle backpressure.",Ce,R,Ie,z,be;return T=new A({props:{title:"Streaming",local:"streaming",headingTag:"h1"}}),J=new A({props:{title:"What is Streaming?",local:"what-is-streaming",headingTag:"h2"}}),I=new A({props:{title:"How to use Streaming?",local:"how-to-use-streaming",headingTag:"h2"}}),b=new A({props:{title:"Streaming with Python",local:"streaming-with-python",headingTag:"h3"}}),S=new ve({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDgwJTIyKSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KSUwQSUwQSUyMyUyMDElMEElMjMlMjAyJTBBJTIzJTIwMyUwQSUyMyUyMDQlMEElMjMlMjA1JTBBJTIzJTIwNiUwQSUyMyUyMDclMEElMjMlMjA4JTBBJTIzJTIwOSUwQSUyMyUyMDEw",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)

<span class="hljs-comment"># 1</span>
<span class="hljs-comment"># 2</span>
<span class="hljs-comment"># 3</span>
<span class="hljs-comment"># 4</span>
<span class="hljs-comment"># 5</span>
<span class="hljs-comment"># 6</span>
<span class="hljs-comment"># 7</span>
<span class="hljs-comment"># 8</span>
<span class="hljs-comment"># 9</span>
<span class="hljs-comment"># 10</span>`,wrap:!1}}),k=new ve({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBJTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkpJTBBJTBBJTIzJTIwVGhpcyUwQSUyMyUyMGlzJTBBJTIzJTIwYSUwQSUyMyUyMHRlc3QlMEElMjMu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

client = AsyncInferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    stream = <span class="hljs-keyword">await</span> client.chat.completions.create(
        messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Say this is a test&quot;</span>}],
        stream=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> stream:
        <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;&quot;</span>, end=<span class="hljs-string">&quot;&quot;</span>)

asyncio.run(main())

<span class="hljs-comment"># This</span>
<span class="hljs-comment"># is</span>
<span class="hljs-comment"># a</span>
<span class="hljs-comment"># test</span>
<span class="hljs-comment">#.</span>`,wrap:!1}}),B=new A({props:{title:"Streaming with cURL",local:"streaming-with-curl",headingTag:"h3"}}),q=new ve({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTgwODAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:<span class="hljs-number">8080</span>/v1/chat/completions \\
    -X POST \\
    -d &#x27;{
  <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;tgi&quot;</span>,
  <span class="hljs-string">&quot;messages&quot;</span>: [
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>
    },
    {
      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
      <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>
    }
  ],
  <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">20</span>
}&#x27; \\
    -H <span class="hljs-symbol">&#x27;Content</span>-<span class="hljs-keyword">Type</span>: application/json&#x27;`,wrap:!1}}),E=new A({props:{title:"Streaming with JavaScript",local:"streaming-with-javascript",headingTag:"h3"}}),G=new ve({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2VFbmRwb2ludCUyMCU3RCUyMGZyb20lMjAnJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UnJTBBJTBBY29uc3QlMjBoZiUyMCUzRCUyMG5ldyUyMEhmSW5mZXJlbmNlRW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGWU9VUl9FTkRQT0lOVC5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQnJTJDJTIwJ2hmX1lPVVJfVE9LRU4nKSUwQSUwQSUyRiUyRiUyMHByb21wdCUwQWNvbnN0JTIwcHJvbXB0JTIwJTNEJTIwJ1doYXQlMjBjYW4lMjB5b3UlMjBkbyUyMGluJTIwTnVyZW1iZXJnJTJDJTIwR2VybWFueSUzRiUyMEdpdmUlMjBtZSUyMDMlMjBUaXBzJyUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwaGYudGV4dEdlbmVyYXRpb25TdHJlYW0oJTdCJTIwaW5wdXRzJTNBJTIwcHJvbXB0JTIwJTdEKSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwciUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyRiUyRiUyMHlpZWxkJTIwdGhlJTIwZ2VuZXJhdGVkJTIwdG9rZW4lMEElMjAlMjBwcm9jZXNzLnN0ZG91dC53cml0ZShyLnRva2VuLnRleHQpJTBBJTdE",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInferenceEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInferenceEndpoint</span>(<span class="hljs-string">&#x27;https://YOUR_ENDPOINT.endpoints.huggingface.cloud&#x27;</span>, <span class="hljs-string">&#x27;hf_YOUR_TOKEN&#x27;</span>)

<span class="hljs-comment">// prompt</span>
<span class="hljs-keyword">const</span> prompt = <span class="hljs-string">&#x27;What can you do in Nuremberg, Germany? Give me 3 Tips&#x27;</span>

<span class="hljs-keyword">const</span> stream = hf.<span class="hljs-title function_">textGenerationStream</span>({ <span class="hljs-attr">inputs</span>: prompt })
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>)
}`,wrap:!1}}),H=new A({props:{title:"How does Streaming work under the hood?",local:"how-does-streaming-work-under-the-hood",headingTag:"h2"}}),R=new es({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/conceptual/streaming.md"}}),{c(){u=i("meta"),P=l(),L=i("p"),D=l(),p(T.$$.fragment),F=l(),p(J.$$.fragment),K=l(),g=i("p"),g.textContent=$e,O=l(),w=i("div"),w.innerHTML=ke,ee=l(),j=i("p"),j.textContent=Be,se=l(),f=i("ul"),f.innerHTML=Qe,te=l(),C=i("p"),C.innerHTML=qe,ne=l(),U=i("div"),U.innerHTML=Ee,le=l(),d=i("div"),d.innerHTML=Ze,ae=l(),p(I.$$.fragment),ie=l(),p(b.$$.fragment),re=l(),v=i("p"),v.innerHTML=xe,oe=l(),p(S.$$.fragment),pe=l(),$=i("p"),$.innerHTML=We,ce=l(),p(k.$$.fragment),he=l(),p(B.$$.fragment),ye=l(),Q=i("p"),Q.innerHTML=Ge,Me=l(),p(q.$$.fragment),me=l(),p(E.$$.fragment),ue=l(),Z=i("p"),Z.innerHTML=He,we=l(),x=i("p"),x.innerHTML=Ne,Ue=l(),W=i("p"),W.innerHTML=_e,de=l(),p(G.$$.fragment),Te=l(),p(H.$$.fragment),Je=l(),N=i("p"),N.textContent=Ve,ge=l(),_=i("p"),_.textContent=Ye,je=l(),V=i("ul"),V.innerHTML=Re,fe=l(),Y=i("p"),Y.innerHTML=Ae,Ce=l(),p(R.$$.fragment),Ie=l(),z=i("p"),this.h()},l(e){const s=Ke("svelte-u9bgzb",document.head);u=r(s,"META",{name:!0,content:!0}),s.forEach(t),P=a(e),L=r(e,"P",{}),Le(L).forEach(t),D=a(e),c(T.$$.fragment,e),F=a(e),c(J.$$.fragment,e),K=a(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-18otp1w"&&(g.textContent=$e),O=a(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1mls61x"&&(w.innerHTML=ke),ee=a(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1i4w8o9"&&(j.textContent=Be),se=a(e),f=r(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-1sljm14"&&(f.innerHTML=Qe),te=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-doyuuq"&&(C.innerHTML=qe),ne=a(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-7ia471"&&(U.innerHTML=Ee),le=a(e),d=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-1wj2bw6"&&(d.innerHTML=Ze),ae=a(e),c(I.$$.fragment,e),ie=a(e),c(b.$$.fragment,e),re=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-16qpzge"&&(v.innerHTML=xe),oe=a(e),c(S.$$.fragment,e),pe=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1nblluv"&&($.innerHTML=We),ce=a(e),c(k.$$.fragment,e),he=a(e),c(B.$$.fragment,e),ye=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-foca00"&&(Q.innerHTML=Ge),Me=a(e),c(q.$$.fragment,e),me=a(e),c(E.$$.fragment,e),ue=a(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16sqqc4"&&(Z.innerHTML=He),we=a(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1qwkxte"&&(x.innerHTML=Ne),Ue=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-5nogh0"&&(W.innerHTML=_e),de=a(e),c(G.$$.fragment,e),Te=a(e),c(H.$$.fragment,e),Je=a(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1wghvdx"&&(N.textContent=Ve),ge=a(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-m95rqi"&&(_.textContent=Ye),je=a(e),V=r(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1vpfo5b"&&(V.innerHTML=Re),fe=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-jbqwxg"&&(Y.innerHTML=Ae),Ce=a(e),c(R.$$.fragment,e),Ie=a(e),z=r(e,"P",{}),Le(z).forEach(t),this.h()},h(){X(u,"name","hf:doc:metadata"),X(u,"content",ts),X(w,"class","flex justify-center"),X(U,"class","block dark:hidden"),X(d,"class","hidden dark:block")},m(e,s){Oe(document.head,u),n(e,P,s),n(e,L,s),n(e,D,s),h(T,e,s),n(e,F,s),h(J,e,s),n(e,K,s),n(e,g,s),n(e,O,s),n(e,w,s),n(e,ee,s),n(e,j,s),n(e,se,s),n(e,f,s),n(e,te,s),n(e,C,s),n(e,ne,s),n(e,U,s),n(e,le,s),n(e,d,s),n(e,ae,s),h(I,e,s),n(e,ie,s),h(b,e,s),n(e,re,s),n(e,v,s),n(e,oe,s),h(S,e,s),n(e,pe,s),n(e,$,s),n(e,ce,s),h(k,e,s),n(e,he,s),h(B,e,s),n(e,ye,s),n(e,Q,s),n(e,Me,s),h(q,e,s),n(e,me,s),h(E,e,s),n(e,ue,s),n(e,Z,s),n(e,we,s),n(e,x,s),n(e,Ue,s),n(e,W,s),n(e,de,s),h(G,e,s),n(e,Te,s),h(H,e,s),n(e,Je,s),n(e,N,s),n(e,ge,s),n(e,_,s),n(e,je,s),n(e,V,s),n(e,fe,s),n(e,Y,s),n(e,Ce,s),h(R,e,s),n(e,Ie,s),n(e,z,s),be=!0},p:Xe,i(e){be||(y(T.$$.fragment,e),y(J.$$.fragment,e),y(I.$$.fragment,e),y(b.$$.fragment,e),y(S.$$.fragment,e),y(k.$$.fragment,e),y(B.$$.fragment,e),y(q.$$.fragment,e),y(E.$$.fragment,e),y(G.$$.fragment,e),y(H.$$.fragment,e),y(R.$$.fragment,e),be=!0)},o(e){M(T.$$.fragment,e),M(J.$$.fragment,e),M(I.$$.fragment,e),M(b.$$.fragment,e),M(S.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(q.$$.fragment,e),M(E.$$.fragment,e),M(G.$$.fragment,e),M(H.$$.fragment,e),M(R.$$.fragment,e),be=!1},d(e){e&&(t(P),t(L),t(D),t(F),t(K),t(g),t(O),t(w),t(ee),t(j),t(se),t(f),t(te),t(C),t(ne),t(U),t(le),t(d),t(ae),t(ie),t(re),t(v),t(oe),t(pe),t($),t(ce),t(he),t(ye),t(Q),t(Me),t(me),t(ue),t(Z),t(we),t(x),t(Ue),t(W),t(de),t(Te),t(Je),t(N),t(ge),t(_),t(je),t(V),t(fe),t(Y),t(Ce),t(Ie),t(z)),t(u),m(T,e),m(J,e),m(I,e),m(b,e),m(S,e),m(k,e),m(B,e),m(q,e),m(E,e),m(G,e),m(H,e),m(R,e)}}}const ts='{"title":"Streaming","local":"streaming","sections":[{"title":"What is Streaming?","local":"what-is-streaming","sections":[],"depth":2},{"title":"How to use Streaming?","local":"how-to-use-streaming","sections":[{"title":"Streaming with Python","local":"streaming-with-python","sections":[],"depth":3},{"title":"Streaming with cURL","local":"streaming-with-curl","sections":[],"depth":3},{"title":"Streaming with JavaScript","local":"streaming-with-javascript","sections":[],"depth":3}],"depth":2},{"title":"How does Streaming work under the hood?","local":"how-does-streaming-work-under-the-hood","sections":[],"depth":2}],"depth":1}';function ns(Se){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends De{constructor(u){super(),Fe(this,u,ns,ss,ze,{})}}export{os as component};
