import{s as Qo,A as Ao,o as Do,n as Ze}from"../chunks/scheduler.01eeda35.js";import{S as Ko,i as es,g as m,s as n,r as g,A as ts,h as d,f as o,c as a,j as $,u as h,x as M,k as T,y as i,a as l,v as f,d as u,t as _,w as b}from"../chunks/index.6dd51b66.js";import{T as Oo}from"../chunks/Tip.de9bae2b.js";import{D as z}from"../chunks/Docstring.cb556860.js";import{C as rt}from"../chunks/CodeBlock.19ec9b8c.js";import{E as at}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as G,E as os}from"../chunks/index.58fe8f9d.js";function ss(U){let r,w="Examples:",p,c,y;return c=new rt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2syRm9ybWVyQ29uZmlnJTJDJTIwTWFzazJGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXNrMkZvcm1lciUyMGZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrMkZvcm1lckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mask2FormerConfig, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mask2Former facebook/mask2former-swin-small-coco-instance configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mask2FormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/mask2former-swin-small-coco-instance style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),g(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(t),h(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),f(c,t,k),y=!0},p:Ze,i(t){y||(u(c.$$.fragment,t),y=!0)},o(t){_(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ns(U){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=m("p"),r.innerHTML=w},l(p){r=d(p,"P",{"data-svelte-h":!0}),M(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,c){l(p,r,c)},p:Ze,d(p){p&&o(r)}}}function as(U){let r,w="Examples:",p,c,y;return c=new rt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBNYXNrMkZvcm1lck1vZGVsJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBpbWFnZSUyMHByZXByb2Nlc3NvciUyMGFuZCUyME1hc2syRm9ybWVyTW9kZWwlMjB0cmFpbmVkJTIwb24lMjBDT0NPJTIwaW5zdGFuY2UlMjBzZWdtZW50YXRpb24lMjBkYXRhc2V0JTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMG1vZGVsJTIwb3V0cHV0cyUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQXByaW50KG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image preprocessor and Mask2FormerModel trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model outputs last hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.transformer_decoder_last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),g(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(t),h(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),f(c,t,k),y=!0},p:Ze,i(t){y||(u(c.$$.fragment,t),y=!0)},o(t){_(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function rs(U){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=m("p"),r.innerHTML=w},l(p){r=d(p,"P",{"data-svelte-h":!0}),M(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,c){l(p,r,c)},p:Ze,d(p){p&&o(r)}}}function is(U){let r,w="Instance segmentation example:",p,c,y;return c=new rt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMENPQ08lMjBpbnN0YW5jZSUyMHNlZ21lbnRhdGlvbiUyMGRhdGFzZXQlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMGluc3RhbmNlJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9pbnN0YW5jZV9tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX2luc3RhbmNlX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUwQSklNUIwJTVEJTBBcHJpbnQocHJlZF9pbnN0YW5jZV9tYXAuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get instance segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_instance_map = image_processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_instance_map.shape)
torch.Size([<span class="hljs-number">480</span>, <span class="hljs-number">640</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),g(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-1xhxiwz"&&(r.textContent=w),p=a(t),h(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),f(c,t,k),y=!0},p:Ze,i(t){y||(u(c.$$.fragment,t),y=!0)},o(t){_(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ls(U){let r,w="Semantic segmentation example:",p,c,y;return c=new rt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMEFERTIwayUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwZGF0YXNldCUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLXNtYWxsLWFkZS1zZW1hbnRpYyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtYWRlLXNlbWFudGljJTIyKSUwQSUwQXVybCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfYWRlMjBrJTJGcmVzb2x2ZSUyRm1haW4lMkZBREVfdmFsXzAwMDAwMDAxLmpwZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9zZW1hbnRpY19tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUwQSklNUIwJTVEJTBBcHJpbnQocHJlZF9zZW1hbnRpY19tYXAuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on ADE20k semantic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get semantic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_semantic_map.shape)
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">683</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),g(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-ec2k7m"&&(r.textContent=w),p=a(t),h(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),f(c,t,k),y=!0},p:Ze,i(t){y||(u(c.$$.fragment,t),y=!0)},o(t){_(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ms(U){let r,w="Panoptic segmentation example:",p,c,y;return c=new rt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on CityScapes panoptic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://cdn-media.huggingface.co/Inference-API/Sample-results-on-the-Cityscapes-dataset-The-above-images-show-how-our-method-can-handle.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get panoptic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_panoptic_map = image_processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_panoptic_map.shape)
torch.Size([<span class="hljs-number">338</span>, <span class="hljs-number">676</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),g(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),M(r)!=="svelte-1hqqxa2"&&(r.textContent=w),p=a(t),h(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),f(c,t,k),y=!0},p:Ze,i(t){y||(u(c.$$.fragment,t),y=!0)},o(t){_(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),b(c,t)}}}function ds(U){let r,w,p,c,y,t,k,bo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',it,oe,lt,se,Mo='The Mask2Former model was proposed in <a href="https://arxiv.org/abs/2112.01527" rel="nofollow">Masked-attention Mask Transformer for Universal Image Segmentation</a> by Bowen Cheng, Ishan Misra, Alexander G. Schwing, Alexander Kirillov, Rohit Girdhar. Mask2Former is a unified framework for panoptic, instance and semantic segmentation and features significant performance and efficiency improvements over <a href="maskformer">MaskFormer</a>.',mt,ne,yo="The abstract from the paper is the following:",dt,ae,ko=`<em>Image segmentation groups pixels with different semantics, e.g., category or instance membership. Each choice
of semantics defines a task. While only the semantics of each task differ, current research focuses on designing specialized architectures for each task. We present Masked-attention Mask Transformer (Mask2Former), a new architecture capable of addressing any image segmentation task (panoptic, instance or semantic). Its key components include masked attention, which extracts localized features by constraining cross-attention within predicted mask regions. In addition to reducing the research effort by at least three times, it outperforms the best specialized architectures by a significant margin on four popular datasets. Most notably, Mask2Former sets a new state-of-the-art for panoptic segmentation (57.8 PQ on COCO), instance segmentation (50.1 AP on COCO) and semantic segmentation (57.7 mIoU on ADE20K).</em>`,ct,P,wo,pt,re,Fo='Mask2Former architecture. Taken from the <a href="https://arxiv.org/abs/2112.01527">original paper.</a>',gt,ie,To='This model was contributed by <a href="https://huggingface.co/shivi" rel="nofollow">Shivalika Singh</a> and <a href="https://huggingface.co/adirik" rel="nofollow">Alara Dirik</a>. The original code can be found <a href="https://github.com/facebookresearch/Mask2Former" rel="nofollow">here</a>.',ht,le,ft,me,vo='<li>Mask2Former uses the same preprocessing and postprocessing steps as <a href="maskformer">MaskFormer</a>. Use <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> or <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>',ut,de,_t,ce,xo="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Mask2Former.",bt,pe,Uo='<li>Demo notebooks regarding inference + fine-tuning Mask2Former on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Mask2Former" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <code>Mask2Former</code> with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/instance-segmentation" rel="nofollow">here</a>.</li>',Mt,ge,jo=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,yt,he,kt,x,fe,Xt,Xe,$o=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. It is used to instantiate a
Mask2Former model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Mask2Former
<a href="https://huggingface.co/facebook/mask2former-swin-small-coco-instance" rel="nofollow">facebook/mask2former-swin-small-coco-instance</a>
architecture.`,Vt,Ve,Jo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Bt,Be,Io='Currently, Mask2Former only supports the <a href="swin">Swin Transformer</a> as backbone.',Rt,H,St,Y,ue,Lt,Re,zo='Instantiate a <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (or a derived class) from a pre-trained backbone model configuration.',wt,_e,Ft,B,be,Gt,Se,Wo='Class for outputs of <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. This class returns all the needed hidden states to compute the logits.',Tt,C,Me,Pt,Le,Co="Class for outputs of <code>Mask2FormerForUniversalSegmentationOutput</code>.",Ht,Ge,No=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to compute final segmentation maps. Please, see
[\`~Mask2FormerImageProcessor] for details regarding usage.`,vt,ye,xt,N,ke,Yt,Pe,Zo=`The bare Mask2Former Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,qt,W,we,Et,He,Xo='The <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ot,q,Qt,E,Ut,Fe,jt,Z,Te,At,Ye,Vo=`The Mask2Former Model with heads on top for instance/semantic/panoptic segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Dt,v,ve,Kt,qe,Bo='The <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',eo,O,to,Ee,Ro="Examples:",oo,Q,so,A,no,D,$t,xe,Jt,F,Ue,ao,Oe,So=`Constructs a Mask2Former image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,ro,Qe,Lo=`This image processor inherits from <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,io,Ae,je,lo,V,$e,mo,De,Go="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",co,Ke,Po=`Mask2Former addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,po,K,Je,go,et,Ho=`Converts the output of <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,ho,ee,Ie,fo,tt,Yo=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into instance segmentation predictions.
Only supports PyTorch. If instances could overlap, set either return_coco_annotation or return_binary_maps
to <code>True</code> to get the correct segmentation result.`,uo,te,ze,_o,ot,qo=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,It,We,zt,nt,Wt;return y=new G({props:{title:"Mask2Former",local:"mask2former",headingTag:"h1"}}),oe=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),de=new G({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new G({props:{title:"Mask2FormerConfig",local:"transformers.Mask2FormerConfig",headingTag:"h2"}}),fe=new z({props:{name:"class transformers.Mask2FormerConfig",anchor:"transformers.Mask2FormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"activation_function",val:": str = 'relu'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.0"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_projection",val:": bool = False"},{name:"common_stride",val:": int = 4"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 100"},{name:"no_object_weight",val:": float = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"feature_strides",val:": typing.List[int] = [4, 8, 16, 32]"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"backbone",val:": typing.Optional[str] = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>SwinConfig()</code>) &#x2014;
The configuration of the backbone model. If unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.Mask2FormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.Mask2FormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.Mask2FormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.Mask2FormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.Mask2FormerConfig.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The features (channels) of the resulting feature maps.`,name:"feature_size"},{anchor:"transformers.Mask2FormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.Mask2FormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of feedforward network for deformable detr encoder used as part of pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in the deformable detr encoder used as part of pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.Mask2FormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.Mask2FormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer.`,name:"num_attention_heads"},{anchor:"transformers.Mask2FormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder.`,name:"dropout"},{anchor:"transformers.Mask2FormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Feature dimension in feedforward network for transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.Mask2FormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pre-LayerNorm or not for transformer decoder.`,name:"pre_norm"},{anchor:"transformers.Mask2FormerConfig.enforce_input_projection",description:`<strong>enforce_input_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an input projection 1x1 convolution even if the input channels and hidden dim are identical
in the Transformer decoder.`,name:"enforce_input_projection"},{anchor:"transformers.Mask2FormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Parameter used for determining number of FPN levels used as part of pixel decoder.`,name:"common_stride"},{anchor:"transformers.Mask2FormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Category id to be ignored during training.`,name:"ignore_value"},{anchor:"transformers.Mask2FormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of queries for the decoder.`,name:"num_queries"},{anchor:"transformers.Mask2FormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.Mask2FormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The weight for the cross entropy loss.`,name:"class_weight"},{anchor:"transformers.Mask2FormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.Mask2FormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.Mask2FormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points used for sampling during loss calculation.`,name:"train_num_points"},{anchor:"transformers.Mask2FormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Oversampling parameter used for calculating no. of sampled points`,name:"oversample_ratio"},{anchor:"transformers.Mask2FormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.Mask2FormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.Mask2FormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.Mask2FormerConfig.use_auxiliary_loss",description:"<strong>use_auxiliary_loss</strong> (<code>boolean``, *optional*, defaults to </code>True<code>) -- If </code>True<code> </code>Mask2FormerForUniversalSegmentationOutput` will contain the auxiliary losses computed using\nthe logits from each decoder&#x2019;s stage.",name:"use_auxiliary_loss"},{anchor:"transformers.Mask2FormerConfig.feature_strides",description:`<strong>feature_strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
Feature strides corresponding to features generated from backbone network.`,name:"feature_strides"},{anchor:"transformers.Mask2FormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/configuration_mask2former.py#L28"}}),H=new at({props:{anchor:"transformers.Mask2FormerConfig.example",$$slots:{default:[ss]},$$scope:{ctx:U}}}),ue=new z({props:{name:"from_backbone_config",anchor:"transformers.Mask2FormerConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/configuration_mask2former.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a></p>
`}}),_e=new G({props:{title:"MaskFormer specific outputs",local:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",headingTag:"h2"}}),be=new z({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_intermediate_states",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_intermediate_states",description:`<strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"transformer_decoder_intermediate_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from each layer in the transformer decoder.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L144"}}),Me=new z({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"auxiliary_logits",val:": typing.Optional[typing.List[typing.Dict[str, torch.FloatTensor]]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.auxiliary_logits",description:`<strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L190"}}),ye=new G({props:{title:"Mask2FormerModel",local:"transformers.Mask2FormerModel",headingTag:"h2"}}),ke=new z({props:{name:"class transformers.Mask2FormerModel",anchor:"transformers.Mask2FormerModel",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2208"}}),we=new z({props:{name:"forward",anchor:"transformers.Mask2FormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2222",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from each layer in the transformer decoder.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new Oo({props:{$$slots:{default:[ns]},$$scope:{ctx:U}}}),E=new at({props:{anchor:"transformers.Mask2FormerModel.forward.example",$$slots:{default:[as]},$$scope:{ctx:U}}}),Fe=new G({props:{title:"Mask2FormerForUniversalSegmentation",local:"transformers.Mask2FormerForUniversalSegmentation",headingTag:"h2"}}),Te=new z({props:{name:"class transformers.Mask2FormerForUniversalSegmentation",anchor:"transformers.Mask2FormerForUniversalSegmentation",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2312"}}),ve=new z({props:{name:"forward",anchor:"transformers.Mask2FormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/modeling_mask2former.py#L2369",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Oo({props:{$$slots:{default:[rs]},$$scope:{ctx:U}}}),Q=new at({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example",$$slots:{default:[is]},$$scope:{ctx:U}}}),A=new at({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-2",$$slots:{default:[ls]},$$scope:{ctx:U}}}),D=new at({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-3",$$slots:{default:[ms]},$$scope:{ctx:U}}}),xe=new G({props:{title:"Mask2FormerImageProcessor",local:"transformers.Mask2FormerImageProcessor",headingTag:"h2"}}),Ue=new z({props:{name:"class transformers.Mask2FormerImageProcessor",anchor:"transformers.Mask2FormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"num_labels",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.Mask2FormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.Mask2FormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.Mask2FormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.Mask2FormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.Mask2FormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Mask2FormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.Mask2FormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.Mask2FormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.Mask2FormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.Mask2FormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.Mask2FormerImageProcessor.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of labels in the segmentation map.`,name:"num_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L352"}}),je=new z({props:{name:"preprocess",anchor:"transformers.Mask2FormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Optional[typing.Dict[int, int]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L678"}}),$e=new z({props:{name:"encode_inputs",anchor:"transformers.Mask2FormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Je=new z({props:{name:"post_process_semantic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Ie=new z({props:{name:"post_process_instance_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L1025",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>, or a tensor of shape <code>(num_instances, height, width)</code> if return_binary_maps is set to <code>True</code>.
Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ze=new z({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>Mask2FormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mask2former/image_processing_mask2former.py#L1146",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),We=new os({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mask2former.md"}}),{c(){r=m("meta"),w=n(),p=m("p"),c=n(),g(y.$$.fragment),t=n(),k=m("div"),k.innerHTML=bo,it=n(),g(oe.$$.fragment),lt=n(),se=m("p"),se.innerHTML=Mo,mt=n(),ne=m("p"),ne.textContent=yo,dt=n(),ae=m("p"),ae.innerHTML=ko,ct=n(),P=m("img"),pt=n(),re=m("small"),re.innerHTML=Fo,gt=n(),ie=m("p"),ie.innerHTML=To,ht=n(),g(le.$$.fragment),ft=n(),me=m("ul"),me.innerHTML=vo,ut=n(),g(de.$$.fragment),_t=n(),ce=m("p"),ce.textContent=xo,bt=n(),pe=m("ul"),pe.innerHTML=Uo,Mt=n(),ge=m("p"),ge.textContent=jo,yt=n(),g(he.$$.fragment),kt=n(),x=m("div"),g(fe.$$.fragment),Xt=n(),Xe=m("p"),Xe.innerHTML=$o,Vt=n(),Ve=m("p"),Ve.innerHTML=Jo,Bt=n(),Be=m("p"),Be.innerHTML=Io,Rt=n(),g(H.$$.fragment),St=n(),Y=m("div"),g(ue.$$.fragment),Lt=n(),Re=m("p"),Re.innerHTML=zo,wt=n(),g(_e.$$.fragment),Ft=n(),B=m("div"),g(be.$$.fragment),Gt=n(),Se=m("p"),Se.innerHTML=Wo,Tt=n(),C=m("div"),g(Me.$$.fragment),Pt=n(),Le=m("p"),Le.innerHTML=Co,Ht=n(),Ge=m("p"),Ge.innerHTML=No,vt=n(),g(ye.$$.fragment),xt=n(),N=m("div"),g(ke.$$.fragment),Yt=n(),Pe=m("p"),Pe.innerHTML=Zo,qt=n(),W=m("div"),g(we.$$.fragment),Et=n(),He=m("p"),He.innerHTML=Xo,Ot=n(),g(q.$$.fragment),Qt=n(),g(E.$$.fragment),Ut=n(),g(Fe.$$.fragment),jt=n(),Z=m("div"),g(Te.$$.fragment),At=n(),Ye=m("p"),Ye.innerHTML=Vo,Dt=n(),v=m("div"),g(ve.$$.fragment),Kt=n(),qe=m("p"),qe.innerHTML=Bo,eo=n(),g(O.$$.fragment),to=n(),Ee=m("p"),Ee.textContent=Ro,oo=n(),g(Q.$$.fragment),so=n(),g(A.$$.fragment),no=n(),g(D.$$.fragment),$t=n(),g(xe.$$.fragment),Jt=n(),F=m("div"),g(Ue.$$.fragment),ao=n(),Oe=m("p"),Oe.textContent=So,ro=n(),Qe=m("p"),Qe.innerHTML=Lo,io=n(),Ae=m("div"),g(je.$$.fragment),lo=n(),V=m("div"),g($e.$$.fragment),mo=n(),De=m("p"),De.innerHTML=Go,co=n(),Ke=m("p"),Ke.innerHTML=Po,po=n(),K=m("div"),g(Je.$$.fragment),go=n(),et=m("p"),et.innerHTML=Ho,ho=n(),ee=m("div"),g(Ie.$$.fragment),fo=n(),tt=m("p"),tt.innerHTML=Yo,uo=n(),te=m("div"),g(ze.$$.fragment),_o=n(),ot=m("p"),ot.innerHTML=qo,It=n(),g(We.$$.fragment),zt=n(),nt=m("p"),this.h()},l(e){const s=ts("svelte-u9bgzb",document.head);r=d(s,"META",{name:!0,content:!0}),s.forEach(o),w=a(e),p=d(e,"P",{}),$(p).forEach(o),c=a(e),h(y.$$.fragment,e),t=a(e),k=d(e,"DIV",{class:!0,"data-svelte-h":!0}),M(k)!=="svelte-13t8s2t"&&(k.innerHTML=bo),it=a(e),h(oe.$$.fragment,e),lt=a(e),se=d(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-vv3e67"&&(se.innerHTML=Mo),mt=a(e),ne=d(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-vfdo9a"&&(ne.textContent=yo),dt=a(e),ae=d(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-12dpxkq"&&(ae.innerHTML=ko),ct=a(e),P=d(e,"IMG",{src:!0,alt:!0,width:!0}),pt=a(e),re=d(e,"SMALL",{"data-svelte-h":!0}),M(re)!=="svelte-1qlm9ke"&&(re.innerHTML=Fo),gt=a(e),ie=d(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-12ct8xd"&&(ie.innerHTML=To),ht=a(e),h(le.$$.fragment,e),ft=a(e),me=d(e,"UL",{"data-svelte-h":!0}),M(me)!=="svelte-192jmvq"&&(me.innerHTML=vo),ut=a(e),h(de.$$.fragment,e),_t=a(e),ce=d(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-m0sdby"&&(ce.textContent=xo),bt=a(e),pe=d(e,"UL",{"data-svelte-h":!0}),M(pe)!=="svelte-jric7z"&&(pe.innerHTML=Uo),Mt=a(e),ge=d(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1rggs50"&&(ge.textContent=jo),yt=a(e),h(he.$$.fragment,e),kt=a(e),x=d(e,"DIV",{class:!0});var J=$(x);h(fe.$$.fragment,J),Xt=a(J),Xe=d(J,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-ib30qi"&&(Xe.innerHTML=$o),Vt=a(J),Ve=d(J,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-o55m63"&&(Ve.innerHTML=Jo),Bt=a(J),Be=d(J,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-938vl7"&&(Be.innerHTML=Io),Rt=a(J),h(H.$$.fragment,J),St=a(J),Y=d(J,"DIV",{class:!0});var Ce=$(Y);h(ue.$$.fragment,Ce),Lt=a(Ce),Re=d(Ce,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-iwqgdj"&&(Re.innerHTML=zo),Ce.forEach(o),J.forEach(o),wt=a(e),h(_e.$$.fragment,e),Ft=a(e),B=d(e,"DIV",{class:!0});var Ne=$(B);h(be.$$.fragment,Ne),Gt=a(Ne),Se=d(Ne,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-11ltned"&&(Se.innerHTML=Wo),Ne.forEach(o),Tt=a(e),C=d(e,"DIV",{class:!0});var R=$(C);h(Me.$$.fragment,R),Pt=a(R),Le=d(R,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-1cgna0v"&&(Le.innerHTML=Co),Ht=a(R),Ge=d(R,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-1ufbz4t"&&(Ge.innerHTML=No),R.forEach(o),vt=a(e),h(ye.$$.fragment,e),xt=a(e),N=d(e,"DIV",{class:!0});var S=$(N);h(ke.$$.fragment,S),Yt=a(S),Pe=d(S,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-14icbh2"&&(Pe.innerHTML=Zo),qt=a(S),W=d(S,"DIV",{class:!0});var X=$(W);h(we.$$.fragment,X),Et=a(X),He=d(X,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1bj7biw"&&(He.innerHTML=Xo),Ot=a(X),h(q.$$.fragment,X),Qt=a(X),h(E.$$.fragment,X),X.forEach(o),S.forEach(o),Ut=a(e),h(Fe.$$.fragment,e),jt=a(e),Z=d(e,"DIV",{class:!0});var L=$(Z);h(Te.$$.fragment,L),At=a(L),Ye=d(L,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-dh9ww1"&&(Ye.innerHTML=Vo),Dt=a(L),v=d(L,"DIV",{class:!0});var I=$(v);h(ve.$$.fragment,I),Kt=a(I),qe=d(I,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1y2q3l0"&&(qe.innerHTML=Bo),eo=a(I),h(O.$$.fragment,I),to=a(I),Ee=d(I,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-kvfsh7"&&(Ee.textContent=Ro),oo=a(I),h(Q.$$.fragment,I),so=a(I),h(A.$$.fragment,I),no=a(I),h(D.$$.fragment,I),I.forEach(o),L.forEach(o),$t=a(e),h(xe.$$.fragment,e),Jt=a(e),F=d(e,"DIV",{class:!0});var j=$(F);h(Ue.$$.fragment,j),ao=a(j),Oe=d(j,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1te0494"&&(Oe.textContent=So),ro=a(j),Qe=d(j,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-1o6r6pd"&&(Qe.innerHTML=Lo),io=a(j),Ae=d(j,"DIV",{class:!0});var Eo=$(Ae);h(je.$$.fragment,Eo),Eo.forEach(o),lo=a(j),V=d(j,"DIV",{class:!0});var st=$(V);h($e.$$.fragment,st),mo=a(st),De=d(st,"P",{"data-svelte-h":!0}),M(De)!=="svelte-1tetyua"&&(De.innerHTML=Go),co=a(st),Ke=d(st,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-1gqhxe4"&&(Ke.innerHTML=Po),st.forEach(o),po=a(j),K=d(j,"DIV",{class:!0});var Ct=$(K);h(Je.$$.fragment,Ct),go=a(Ct),et=d(Ct,"P",{"data-svelte-h":!0}),M(et)!=="svelte-h41nf"&&(et.innerHTML=Ho),Ct.forEach(o),ho=a(j),ee=d(j,"DIV",{class:!0});var Nt=$(ee);h(Ie.$$.fragment,Nt),fo=a(Nt),tt=d(Nt,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-h98l3d"&&(tt.innerHTML=Yo),Nt.forEach(o),uo=a(j),te=d(j,"DIV",{class:!0});var Zt=$(te);h(ze.$$.fragment,Zt),_o=a(Zt),ot=d(Zt,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-ay0y3u"&&(ot.innerHTML=qo),Zt.forEach(o),j.forEach(o),It=a(e),h(We.$$.fragment,e),zt=a(e),nt=d(e,"P",{}),$(nt).forEach(o),this.h()},h(){T(r,"name","hf:doc:metadata"),T(r,"content",cs),T(k,"class","flex flex-wrap space-x-1"),Ao(P.src,wo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/mask2former_architecture.jpg")||T(P,"src",wo),T(P,"alt","drawing"),T(P,"width","600"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){i(document.head,r),l(e,w,s),l(e,p,s),l(e,c,s),f(y,e,s),l(e,t,s),l(e,k,s),l(e,it,s),f(oe,e,s),l(e,lt,s),l(e,se,s),l(e,mt,s),l(e,ne,s),l(e,dt,s),l(e,ae,s),l(e,ct,s),l(e,P,s),l(e,pt,s),l(e,re,s),l(e,gt,s),l(e,ie,s),l(e,ht,s),f(le,e,s),l(e,ft,s),l(e,me,s),l(e,ut,s),f(de,e,s),l(e,_t,s),l(e,ce,s),l(e,bt,s),l(e,pe,s),l(e,Mt,s),l(e,ge,s),l(e,yt,s),f(he,e,s),l(e,kt,s),l(e,x,s),f(fe,x,null),i(x,Xt),i(x,Xe),i(x,Vt),i(x,Ve),i(x,Bt),i(x,Be),i(x,Rt),f(H,x,null),i(x,St),i(x,Y),f(ue,Y,null),i(Y,Lt),i(Y,Re),l(e,wt,s),f(_e,e,s),l(e,Ft,s),l(e,B,s),f(be,B,null),i(B,Gt),i(B,Se),l(e,Tt,s),l(e,C,s),f(Me,C,null),i(C,Pt),i(C,Le),i(C,Ht),i(C,Ge),l(e,vt,s),f(ye,e,s),l(e,xt,s),l(e,N,s),f(ke,N,null),i(N,Yt),i(N,Pe),i(N,qt),i(N,W),f(we,W,null),i(W,Et),i(W,He),i(W,Ot),f(q,W,null),i(W,Qt),f(E,W,null),l(e,Ut,s),f(Fe,e,s),l(e,jt,s),l(e,Z,s),f(Te,Z,null),i(Z,At),i(Z,Ye),i(Z,Dt),i(Z,v),f(ve,v,null),i(v,Kt),i(v,qe),i(v,eo),f(O,v,null),i(v,to),i(v,Ee),i(v,oo),f(Q,v,null),i(v,so),f(A,v,null),i(v,no),f(D,v,null),l(e,$t,s),f(xe,e,s),l(e,Jt,s),l(e,F,s),f(Ue,F,null),i(F,ao),i(F,Oe),i(F,ro),i(F,Qe),i(F,io),i(F,Ae),f(je,Ae,null),i(F,lo),i(F,V),f($e,V,null),i(V,mo),i(V,De),i(V,co),i(V,Ke),i(F,po),i(F,K),f(Je,K,null),i(K,go),i(K,et),i(F,ho),i(F,ee),f(Ie,ee,null),i(ee,fo),i(ee,tt),i(F,uo),i(F,te),f(ze,te,null),i(te,_o),i(te,ot),l(e,It,s),f(We,e,s),l(e,zt,s),l(e,nt,s),Wt=!0},p(e,[s]){const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),H.$set(J);const Ce={};s&2&&(Ce.$$scope={dirty:s,ctx:e}),q.$set(Ce);const Ne={};s&2&&(Ne.$$scope={dirty:s,ctx:e}),E.$set(Ne);const R={};s&2&&(R.$$scope={dirty:s,ctx:e}),O.$set(R);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),Q.$set(S);const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),A.$set(X);const L={};s&2&&(L.$$scope={dirty:s,ctx:e}),D.$set(L)},i(e){Wt||(u(y.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(H.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(ke.$$.fragment,e),u(we.$$.fragment,e),u(q.$$.fragment,e),u(E.$$.fragment,e),u(Fe.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(O.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u($e.$$.fragment,e),u(Je.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(We.$$.fragment,e),Wt=!0)},o(e){_(y.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(H.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(ye.$$.fragment,e),_(ke.$$.fragment,e),_(we.$$.fragment,e),_(q.$$.fragment,e),_(E.$$.fragment,e),_(Fe.$$.fragment,e),_(Te.$$.fragment,e),_(ve.$$.fragment,e),_(O.$$.fragment,e),_(Q.$$.fragment,e),_(A.$$.fragment,e),_(D.$$.fragment,e),_(xe.$$.fragment,e),_(Ue.$$.fragment,e),_(je.$$.fragment,e),_($e.$$.fragment,e),_(Je.$$.fragment,e),_(Ie.$$.fragment,e),_(ze.$$.fragment,e),_(We.$$.fragment,e),Wt=!1},d(e){e&&(o(w),o(p),o(c),o(t),o(k),o(it),o(lt),o(se),o(mt),o(ne),o(dt),o(ae),o(ct),o(P),o(pt),o(re),o(gt),o(ie),o(ht),o(ft),o(me),o(ut),o(_t),o(ce),o(bt),o(pe),o(Mt),o(ge),o(yt),o(kt),o(x),o(wt),o(Ft),o(B),o(Tt),o(C),o(vt),o(xt),o(N),o(Ut),o(jt),o(Z),o($t),o(Jt),o(F),o(It),o(zt),o(nt)),o(r),b(y,e),b(oe,e),b(le,e),b(de,e),b(he,e),b(fe),b(H),b(ue),b(_e,e),b(be),b(Me),b(ye,e),b(ke),b(we),b(q),b(E),b(Fe,e),b(Te),b(ve),b(O),b(Q),b(A),b(D),b(xe,e),b(Ue),b(je),b($e),b(Je),b(Ie),b(ze),b(We,e)}}}const cs='{"title":"Mask2Former","local":"mask2former","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Mask2FormerConfig","local":"transformers.Mask2FormerConfig","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput","sections":[],"depth":2},{"title":"Mask2FormerModel","local":"transformers.Mask2FormerModel","sections":[],"depth":2},{"title":"Mask2FormerForUniversalSegmentation","local":"transformers.Mask2FormerForUniversalSegmentation","sections":[],"depth":2},{"title":"Mask2FormerImageProcessor","local":"transformers.Mask2FormerImageProcessor","sections":[],"depth":2}],"depth":1}';function ps(U){return Do(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends Ko{constructor(r){super(),es(this,r,ps,ds,Qo,{})}}export{ys as component};
